/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.hub;

import com.paterva.maltego.transforms.tabular.ui.hub.ObservableTabularTransformSourceHoverAwarePanel;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceItemDescriptor;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TabularTransformSourceMainPanel
extends ObservableTabularTransformSourceHoverAwarePanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final TabularTransformSourceItemDescriptor item;
    private JPanel bottomPanel;
    private JLabel descriptionLabel;
    private JLabel enabledLabel;
    private JPanel innerPanel;
    private JLabel nameLabel;
    private JLabel statusLabel;
    private JPanel topPanel;

    public TabularTransformSourceMainPanel(TabularTransformSourceItemDescriptor item) {
        Args.notNull((Object)((Object)item), (String)"item");
        this.item = item;
        this.initComponents();
        if (item != null) {
            this.update();
        }
    }

    @Override
    public TabularTransformSourceItemDescriptor getItem() {
        return this.item;
    }

    private void update() {
        this.updateName();
        this.updateStatus();
        this.updateShortDescription();
        this.updateEnabled();
    }

    private Font getFontScaled(String key) {
        return LAF.getFont(key);
    }

    private void updateName() {
        this.nameLabel.setText(this.item.getTransformSource().getDisplayName());
        Color color = LAF.getColor("hub-item-name-fg");
        this.nameLabel.setForeground(color);
        this.nameLabel.setFont(this.getFontScaled("hub-item-name-font"));
    }

    private void updateStatus() {
        String text = "Tabular Transforms";
        String colorString = "hub-item-type-fg-datasource";
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(LAF.getColor(colorString));
        this.statusLabel.setFont(this.getFontScaled("hub-item-type-font"));
    }

    private void updateShortDescription() {
        String description = "";
        this.descriptionLabel.setText("");
        this.descriptionLabel.setForeground(LAF.getColor("hub-item-description-fg"));
        this.descriptionLabel.setFont(this.getFontScaled("hub-item-description-font"));
    }

    private void updateEnabled() {
        boolean enabled = true;
        this.enabledLabel.setText(enabled ? "ENABLED" : "");
        this.enabledLabel.setFont(this.getFontScaled("hub-item-installed-font"));
        String fgStr = enabled ? "hub-item-installed-fg" : "hub-item-not-installed-fg";
        this.enabledLabel.setForeground(LAF.getColor(fgStr));
    }

    protected void onHoveredChanged() {
    }

    protected void onPanelClicked() {
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.topPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.enabledLabel = new JLabel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.innerPanel.setOpaque(false);
        this.innerPanel.setLayout(new GridBagLayout());
        this.topPanel.setOpaque(false);
        this.topPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(TabularTransformSourceMainPanel.class, (String)"TabularTransformSourceMainPanel.nameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.nameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(TabularTransformSourceMainPanel.class, (String)"TabularTransformSourceMainPanel.statusLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.topPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.innerPanel.add((Component)this.topPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(TabularTransformSourceMainPanel.class, (String)"TabularTransformSourceMainPanel.descriptionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.innerPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        this.bottomPanel.setOpaque(false);
        this.bottomPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.enabledLabel, (String)NbBundle.getMessage(TabularTransformSourceMainPanel.class, (String)"TabularTransformSourceMainPanel.enabledLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.bottomPanel.add((Component)this.enabledLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.innerPanel.add((Component)this.bottomPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.innerPanel, gridBagConstraints);
    }
}

