/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.officelaf.ribbon.OfficeRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.BasicRibbonApplicationMenuButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;

public class OfficeRibbonApplicationMenuButtonUI
extends BasicRibbonApplicationMenuButtonUI {
    private static final ImageIcon normal = new ImageIcon(OfficeRibbonApplicationMenuButtonUI.class.getResource("images/exie_officebutton.png"));
    private static final ImageIcon over = new ImageIcon(OfficeRibbonApplicationMenuButtonUI.class.getResource("images/exie_officebutton_over.png"));
    private static final ImageIcon down = new ImageIcon(OfficeRibbonApplicationMenuButtonUI.class.getResource("images/exie_officebutton_down.png"));

    public static ComponentUI createUI(JComponent c) {
        return new OfficeRibbonApplicationMenuButtonUI();
    }

    protected void installComponents() {
        super.installComponents();
        final JRibbonApplicationMenuButton appMenuButton = (JRibbonApplicationMenuButton)this.commandButton;
        appMenuButton.setPopupCallback(new PopupPanelCallback(){

            public JPopupPanel getPopupPanel(final JCommandButton commandButton) {
                if (appMenuButton.getParent() instanceof JRibbon) {
                    final JRibbon ribbon = (JRibbon)appMenuButton.getParent();
                    RibbonApplicationMenu ribbonMenu = ribbon.getApplicationMenu();
                    final OfficeRibbonApplicationMenuPopupPanel menuPopupPanel = new OfficeRibbonApplicationMenuPopupPanel(appMenuButton, ribbonMenu);
                    menuPopupPanel.setCustomizer(new JPopupPanel.PopupPanelCustomizer(){

                        public Rectangle getScreenBounds() {
                            int ph;
                            int x = ribbon.getLocationOnScreen().x;
                            int y = commandButton.getLocationOnScreen().y + commandButton.getSize().height / 2 + 2;
                            Rectangle scrBounds = commandButton.getGraphicsConfiguration().getBounds();
                            int pw = menuPopupPanel.getPreferredSize().width;
                            if (x + pw > scrBounds.x + scrBounds.width) {
                                x = scrBounds.x + scrBounds.width - pw;
                            }
                            if (y + (ph = menuPopupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                                y = scrBounds.y + scrBounds.height - ph;
                            }
                            return new Rectangle(x, y, menuPopupPanel.getPreferredSize().width, menuPopupPanel.getPreferredSize().height);
                        }
                    });
                    return menuPopupPanel;
                }
                return null;
            }
        });
    }

    protected void uninstallComponents() {
        JRibbonApplicationMenuButton appMenuButton = (JRibbonApplicationMenuButton)this.commandButton;
        appMenuButton.setPopupCallback(null);
        super.uninstallComponents();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        Insets ins = c.getInsets();
        Rectangle backgroundRect = new Rectangle(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - ins.top - ins.bottom);
        this.paintButtonBackground(g2d, backgroundRect);
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty((Object)"icon.bounds", (Object)layoutInfo.iconRect);
        this.paintButtonIcon(g2d, backgroundRect);
        g2d.dispose();
    }

    protected void configureRenderer() {
        this.buttonRendererPane = new CellRendererPane();
        this.rendererButton = new JButton("");
    }

    protected void unconfigureRenderer() {
        this.buttonRendererPane = null;
        this.rendererButton = null;
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
    }

    protected Icon getIconToPaint() {
        PopupButtonModel model = this.applicationMenuButton.getPopupModel();
        ImageIcon icon = model.isPressed() || model.isPopupShowing() ? down : (model.isRollover() ? over : normal);
        return icon;
    }
}

