/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.util.SimilarStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GraphTransactionBatch {
    private SimilarStrings _description;
    private List<GraphTransaction> _transactions = new ArrayList<GraphTransaction>();
    private boolean _isSignificant;
    private Integer _sequenceNumber = null;

    public GraphTransactionBatch(SimilarStrings description, boolean isSignificant, GraphTransaction ... transactions) {
        this._description = description;
        this._isSignificant = isSignificant;
        for (GraphTransaction transaction : transactions) {
            this.add(transaction);
        }
    }

    public GraphTransactionBatch(GraphTransactionBatch batch) {
        this(batch._description, batch.isSignificant(), new GraphTransaction[0]);
        this.addAll(batch.getTransactions());
        this._sequenceNumber = batch.getSequenceNumber();
    }

    public SimilarStrings getDescription() {
        return this._description;
    }

    public boolean isSignificant() {
        return this._isSignificant;
    }

    public final void add(GraphTransaction transaction) {
        this._transactions.add(transaction);
    }

    public final void addAll(Collection<GraphTransaction> transactions) {
        this._transactions.addAll(transactions);
    }

    public List<GraphTransaction> getTransactions() {
        return Collections.unmodifiableList(this._transactions);
    }

    public void reverse() {
        Collections.reverse(this._transactions);
    }

    public boolean isEmpty() {
        return this._transactions.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Batch: ");
        sb.append(this.getDescription().getStringOne()).append(" (inverse=");
        sb.append(this.getDescription().getStringTwo());
        sb.append(") ");
        sb.append(this._sequenceNumber);
        sb.append("\n");
        for (GraphTransaction transaction : this._transactions) {
            sb.append(transaction);
        }
        return sb.toString();
    }

    public Integer getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this._sequenceNumber = sequenceNumber;
    }
}

