/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphMods;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.J.SA;

public class Graph2DRealizerUpdater {
    private SA _graph2D;
    private GraphID _graphID;
    private GraphWrapper _graphWrapper;
    private GraphStore _graphStore;
    private GraphStoreListener _graphStoreListener;

    public void setGraph(SA graph2D) {
        this._graph2D = graph2D;
        try {
            this._graphWrapper = MaltegoGraphManager.getWrapper((D)this._graph2D);
            this._graphID = GraphIDProvider.forGraph((SA)this._graph2D);
            this._graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            this._graphStoreListener = new GraphStoreListener();
            this._graphStore.addPropertyChangeListener((PropertyChangeListener)this._graphStoreListener);
            GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().equals(Graph2DRealizerUpdater.this._graphID)) {
                if ("graphClosing".equals(evt.getPropertyName())) {
                    Graph2DRealizerUpdater.this._graphStore.removePropertyChangeListener((PropertyChangeListener)Graph2DRealizerUpdater.this._graphStoreListener);
                    Graph2DRealizerUpdater.this._graphStoreListener = null;
                } else if ("graphClosed".equals(evt.getPropertyName())) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    Graph2DRealizerUpdater.this._graph2D = null;
                    Graph2DRealizerUpdater.this._graphStore = null;
                    Graph2DRealizerUpdater.this._graphID = null;
                    Graph2DRealizerUpdater.this._graphWrapper = null;
                }
            }
        }
    }

    private class GraphStoreListener
    implements PropertyChangeListener {
        private GraphStoreListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                GraphMods graphMods;
                if ("graphModified".equals(evt.getPropertyName()) && (graphMods = (GraphMods)evt.getNewValue()) != null) {
                    Set<EntityID> modelEntities = this.getModelEntitiesUpdated(graphMods);
                    Set<EntityID> viewEntities = this.getViewEntities(modelEntities);
                    this.updateEntityRealizers(viewEntities);
                    this.updateLinkRealizers(graphMods);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private Set<EntityID> getModelEntitiesUpdated(GraphMods graphMods) {
            GraphDataMods dataMods = graphMods.getDataMods();
            GraphStructureMods structureMods = graphMods.getStructureMods();
            HashSet<EntityID> modelEntities = new HashSet<EntityID>();
            if (dataMods != null) {
                modelEntities.addAll(dataMods.getEntitiesUpdated().keySet());
            }
            if (structureMods != null) {
                modelEntities.addAll(structureMods.getEntitiesPinned());
                modelEntities.addAll(structureMods.getEntitiesUnpinned());
            }
            return modelEntities;
        }

        private Set<EntityID> getViewEntities(Set<EntityID> modelEntities) throws GraphStoreException {
            Set<EntityID> viewEntities = Collections.emptySet();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(Graph2DRealizerUpdater.this._graphID);
            if (view != null) {
                GraphModelViewMappings mappings = view.getModelViewMappings();
                viewEntities = new HashSet<EntityID>(modelEntities.size());
                for (EntityID entityID : modelEntities) {
                    EntityID viewEntity = mappings.getViewEntity(entityID);
                    viewEntities.add(viewEntity);
                }
            }
            return viewEntities;
        }

        private void updateEntityRealizers(Set<EntityID> viewEntities) {
            for (EntityID viewEntity : viewEntities) {
                LightweightEntityRealizer realizer;
                Y node = Graph2DRealizerUpdater.this._graphWrapper.node(viewEntity);
                if (node == null || (realizer = (LightweightEntityRealizer)Graph2DRealizerUpdater.this._graph2D.f(node)) == null || !realizer.isInflated()) continue;
                realizer.reinflate();
            }
        }

        private void updateLinkRealizers(GraphMods graphMods) {
            GraphDataMods dataMods = graphMods.getDataMods();
            if (dataMods != null) {
                for (Map.Entry entry : dataMods.getLinksUpdated().entrySet()) {
                    LinkEdgeRealizer realizer;
                    LinkID linkID = (LinkID)entry.getKey();
                    MaltegoLink link = (MaltegoLink)entry.getValue();
                    H edge = Graph2DRealizerUpdater.this._graphWrapper.edge(linkID);
                    if (edge == null || (realizer = (LinkEdgeRealizer)Graph2DRealizerUpdater.this._graph2D.X(edge)) == null) continue;
                    realizer.update(link);
                }
            }
        }
    }
}

