/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.controls;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.Lookup;

public abstract class GraphAddOnControls {
    public static final String PROP_ADDED = "graphAddOnAdded";
    public static final String PROP_REMOVED = "graphAddOnRemoved";
    private static GraphAddOnControls _default;

    public static GraphAddOnControls getDefault() {
        if (_default == null && (_default = (GraphAddOnControls)Lookup.getDefault().lookup(GraphAddOnControls.class)) == null) {
            _default = new Default();
        }
        return _default;
    }

    public abstract void add(GraphDataObject var1, Component var2);

    public abstract void remove(GraphDataObject var1, Component var2);

    public abstract Collection<Component> get(GraphDataObject var1);

    public abstract void addPropertyChangeListener(GraphDataObject var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(GraphDataObject var1, PropertyChangeListener var2);

    private static class Default
    extends GraphAddOnControls {
        private Map<GraphDataObject, List<Component>> _addOns = new WeakHashMap<GraphDataObject, List<Component>>();
        private Map<GraphDataObject, List<PropertyChangeListener>> _listeners = new WeakHashMap<GraphDataObject, List<PropertyChangeListener>>();

        private Default() {
        }

        @Override
        public void add(GraphDataObject gdo, Component component) {
            List<Component> addOns = this._addOns.get(gdo);
            if (addOns == null) {
                addOns = new ArrayList<Component>();
                this._addOns.put(gdo, addOns);
            }
            addOns.add(component);
            this.fireAdded(gdo, component);
        }

        @Override
        public void remove(GraphDataObject gdo, Component component) {
            List<Component> addOns = this._addOns.get(gdo);
            if (addOns != null) {
                addOns.remove(component);
                this.fireRemoved(gdo, component);
            }
        }

        @Override
        public Collection<Component> get(GraphDataObject gdo) {
            List<Component> addOns = this._addOns.get(gdo);
            return addOns != null ? Collections.unmodifiableList(addOns) : Collections.EMPTY_LIST;
        }

        @Override
        public void addPropertyChangeListener(GraphDataObject gdo, PropertyChangeListener listener) {
            List<PropertyChangeListener> listeners = this._listeners.get(gdo);
            if (listeners == null) {
                listeners = new ArrayList<PropertyChangeListener>();
                this._listeners.put(gdo, listeners);
            }
            listeners.add(listener);
        }

        @Override
        public void removePropertyChangeListener(GraphDataObject gdo, PropertyChangeListener listener) {
            List<PropertyChangeListener> listeners = this._listeners.get(gdo);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }

        private void fireAdded(GraphDataObject gdo, Component component) {
            List<PropertyChangeListener> listeners = this._listeners.get(gdo);
            if (listeners != null) {
                for (PropertyChangeListener listener : listeners) {
                    listener.propertyChange(new PropertyChangeEvent(this, GraphAddOnControls.PROP_ADDED, null, component));
                }
            }
        }

        private void fireRemoved(GraphDataObject gdo, Component component) {
            List<PropertyChangeListener> listeners = this._listeners.get(gdo);
            if (listeners != null) {
                for (PropertyChangeListener listener : listeners) {
                    listener.propertyChange(new PropertyChangeEvent(this, GraphAddOnControls.PROP_REMOVED, component, null));
                }
            }
        }
    }
}

