/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.lucene.serialize.NumericTypeConverter;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;

class FloatConverter
extends NumericTypeConverter<Float> {
    private static final Float MIN_SORT_VALUE = Float.valueOf(Float.MIN_VALUE);
    private static final Float MAX_SORT_VALUE = Float.valueOf(Float.MAX_VALUE);

    public FloatConverter() {
        super("float", Float.class, Float.TYPE, SortField.Type.FLOAT);
    }

    @Override
    IndexableField createNumberField(Float value, String fieldName) {
        return new FloatField(fieldName, value.floatValue(), Field.Store.YES);
    }

    @Override
    long toSortableLong(Float value) {
        return NumericUtils.floatToSortableInt((float)value.floatValue());
    }

    @Override
    protected Float getMinSortField() {
        return MIN_SORT_VALUE;
    }

    @Override
    protected Float getMaxSortField() {
        return MAX_SORT_VALUE;
    }

    @Override
    Float toType(Number number) {
        return Float.valueOf(number.floatValue());
    }
}

