/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.FromPropertyDescriptorNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateUncached
public abstract class FromPropertyDescriptorNode
extends JavaScriptBaseNode {
    protected static final int SHAPE_LIMIT = 6;

    protected FromPropertyDescriptorNode() {
    }

    public static FromPropertyDescriptorNode create() {
        return FromPropertyDescriptorNodeGen.create();
    }

    public static FromPropertyDescriptorNode getUncached() {
        return FromPropertyDescriptorNodeGen.getUncached();
    }

    public abstract DynamicObject execute(PropertyDescriptor var1, JSContext var2);

    @Specialization
    final DynamicObject toJSObject(PropertyDescriptor desc, JSContext context, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putValueNode, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putWritableNode, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putGetNode, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putSetNode, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putEnumerableNode, @CachedLibrary(limit="SHAPE_LIMIT") DynamicObjectLibrary putConfigurableNode) {
        if (desc == null) {
            return Undefined.instance;
        }
        DynamicObject obj = JSOrdinary.create(context, this.getRealm());
        if (desc.hasValue()) {
            putValueNode.put(obj, (Object)"value", desc.getValue());
        }
        if (desc.hasWritable()) {
            putWritableNode.put(obj, (Object)"writable", (Object)desc.getWritable());
        }
        if (desc.hasGet()) {
            putGetNode.put(obj, (Object)"get", desc.getGet());
        }
        if (desc.hasSet()) {
            putSetNode.put(obj, (Object)"set", desc.getSet());
        }
        if (desc.hasEnumerable()) {
            putEnumerableNode.put(obj, (Object)"enumerable", (Object)desc.getEnumerable());
        }
        if (desc.hasConfigurable()) {
            putConfigurableNode.put(obj, (Object)"configurable", (Object)desc.getConfigurable());
        }
        return obj;
    }
}

