/* 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2014 Sun Microsystems, Inc.
 */

/* 
 * Wrappers for PAC script helper methods. These methods are defined
 * in a document by Netscape.
 * (see http://en.wikipedia.org/wiki/Proxy_auto-config)
 */

function isPlainHostName(host) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.isPlainHostName(host);
}

function dnsDomainIs(host, domain) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.dnsDomainIs(host, domain);
}

function localHostOrDomainIs(host, hostdom) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.localHostOrDomainIs(host, hostdom);
}

function isResolvable(host) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.isResolvable(host);
}

function isInNet(host, pattern, mask) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.isInNet(host, pattern, mask);
}

function dnsResolve(host) {
    return String(org.netbeans.core2.network.proxy.PacHelperMethods.dnsResolve(host));
}

function myIpAddress() {
    return String(org.netbeans.core2.network.proxy.PacHelperMethods.myIpAddress());
}

function dnsDomainLevels(host) {
    return Number(org.netbeans.core2.network.proxy.PacHelperMethods.dnsDomainLevels(host));
}

function shExpMatch(str, shexp) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.shExpMatch(str, shexp);
}

function weekdayRange(wd1, wd2, gmt) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.weekdayRange(wd1, wd2, gmt);
}

function dateRange(day1, month1, year1, day2, month2, year2, gmt) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.dateRange(day1, month1, year1, day2, month2, year2, gmt);
}

function timeRange(hour1, min1, sec1, hour2, min2, sec2, gmt) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.timeRange(hour1, min1, sec1, hour2, min2, sec2, gmt);
}


// -- OTHER ---

// Logs something to Java's logging system. This allows the JavaScript code to
// do logging. Note that this is NOT a function defined in Netscape's specification
// for the PAC file. Hence it is non-standard and should only be used for debugging
// purpose and never in a PAC file used in production.
function logMe(functionName, txt) {
    return org.netbeans.core2.network.proxy.PacHelperMethods.logMe(functionName, txt);
}
