/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jhotdraw.contrib.CTXCommandMenu;
import org.jhotdraw.contrib.CommandMenuItem;
import org.jhotdraw.contrib.MDIDesktopPane;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.standard.AbstractCommand;

public class CTXWindowMenu
extends CTXCommandMenu {
    MDIDesktopPane desktop;
    private CommandMenuItem cascadeCommand;
    private CommandMenuItem tileHCommand;
    private CommandMenuItem tileVCommand;
    private CommandMenuItem arrangeHCommand;
    private CommandMenuItem arrangeVCommand;
    private int staticItems;

    public CTXWindowMenu(String string, MDIDesktopPane mDIDesktopPane, DrawingEditor drawingEditor) {
        super(string);
        this.desktop = mDIDesktopPane;
        this.cascadeCommand = new CommandMenuItem(new AbstractCommand("Cascade", drawingEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.cascadeFrames();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.tileHCommand = new CommandMenuItem(new AbstractCommand("Tile Horizontally", drawingEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.tileFramesHorizontally();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.tileVCommand = new CommandMenuItem(new AbstractCommand("Tile Vertically", drawingEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.tileFramesVertically();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.arrangeHCommand = new CommandMenuItem(new AbstractCommand("Arrange Horizontally", drawingEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.arrangeFramesHorizontally();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.arrangeVCommand = new CommandMenuItem(new AbstractCommand("Arrange Vertically", drawingEditor){

            public void execute() {
                CTXWindowMenu.this.desktop.arrangeFramesVertically();
            }

            public boolean isExecutable() {
                return super.isExecutable() && CTXWindowMenu.this.desktop.getAllFrames().length > 0;
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
                CTXWindowMenu.this.removeWindowsList();
            }

            public void menuSelected(MenuEvent menuEvent) {
                CTXWindowMenu.this.buildChildMenus();
            }
        });
        this.add(this.cascadeCommand);
        this.add(this.tileHCommand);
        this.add(this.tileVCommand);
        this.add(this.arrangeHCommand);
        this.add(this.arrangeVCommand);
        this.staticItems = 5;
    }

    protected void removeWindowsList() {
        while (this.getItemCount() > this.staticItems) {
            this.remove(this.staticItems);
        }
    }

    void buildChildMenus() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        this.cascadeCommand.setEnabled(jInternalFrameArray.length > 0);
        this.tileHCommand.setEnabled(jInternalFrameArray.length > 0);
        this.tileVCommand.setEnabled(jInternalFrameArray.length > 0);
        this.arrangeHCommand.setEnabled(jInternalFrameArray.length > 0);
        this.arrangeVCommand.setEnabled(jInternalFrameArray.length > 0);
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.addSeparator();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            ChildMenuItem childMenuItem = new ChildMenuItem(jInternalFrameArray[i]);
            childMenuItem.setState(i == 0);
            childMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JInternalFrame jInternalFrame = ((ChildMenuItem)actionEvent.getSource()).getFrame();
                    jInternalFrame.moveToFront();
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            });
            childMenuItem.setIcon(jInternalFrameArray[i].getFrameIcon());
            this.add(childMenuItem);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame jInternalFrame) {
            super(jInternalFrame.getTitle());
            this.frame = jInternalFrame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

