/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.event;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.SelectionTool;

public class SelectionComponentDisplayer
implements PropertyChangeListener,
FigureSelectionListener {
    protected DrawingView view;
    protected DrawingEditor editor;
    protected WeakReference<JComponent> weakRef;
    protected int minSelectionCount = 1;
    protected boolean isVisibleIfCreationTool = true;

    public SelectionComponentDisplayer(DrawingEditor drawingEditor, JComponent jComponent) {
        this.editor = drawingEditor;
        this.weakRef = new WeakReference<JComponent>(jComponent);
        if (drawingEditor.getActiveView() != null) {
            this.view = drawingEditor.getActiveView();
            this.view.addPropertyChangeListener(this);
            this.view.addFigureSelectionListener(this);
        }
        drawingEditor.addPropertyChangeListener(this);
        this.updateVisibility();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "activeView") {
            if (this.view != null) {
                this.view.removePropertyChangeListener(this);
                this.view.removeFigureSelectionListener(this);
            }
            this.view = (DrawingView)propertyChangeEvent.getNewValue();
            if (this.view != null) {
                this.view.addPropertyChangeListener(this);
                this.view.addFigureSelectionListener(this);
            }
            this.updateVisibility();
        } else if (string == "tool") {
            this.updateVisibility();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.updateVisibility();
    }

    public void updateVisibility() {
        boolean bl = this.editor != null && this.editor.getActiveView() != null && (this.isVisibleIfCreationTool && this.editor.getTool() != null && !(this.editor.getTool() instanceof SelectionTool) || this.editor.getActiveView().getSelectionCount() >= this.minSelectionCount);
        JComponent jComponent = (JComponent)this.weakRef.get();
        if (jComponent == null) {
            this.dispose();
            return;
        }
        if (bl != jComponent.isVisible()) {
            jComponent.setVisible(bl);
            if (bl) {
                jComponent.setPreferredSize(null);
            } else {
                jComponent.setPreferredSize(new Dimension(0, 0));
            }
            jComponent.revalidate();
        }
    }

    protected JComponent getComponent() {
        return (JComponent)this.weakRef.get();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        if (this.view != null) {
            this.view.removePropertyChangeListener(this);
            this.view.removeFigureSelectionListener(this);
            this.view = null;
        }
    }

    public void setMinSelectionCount(int n) {
        this.minSelectionCount = n;
        this.updateVisibility();
    }

    public void setVisibleIfCreationTool(boolean bl) {
        this.isVisibleIfCreationTool = bl;
    }
}

