
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/nszlib/ns_zlib.n,v 1.1 2006/04/19 18:04:59 jgdavidson Exp $
'\"
'\" 
.so man.macros
.TH ns_zlib n 4.5 AOLserver "AOLserver Zlib Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_zlib \- Zlib compression support
.SH SYNOPSIS
.nf
\fBns_zlib compress\fR \fIstring\fR
\fBns_zlib gunzip\fR \fIfile\fR
\fBns_zlib gzip\fR \fIstring\fR
\fBns_zlib gzipfile\fR \fIfile\fR
\fBns_zlib uncompress\fR \fIstring\fR
.fi
.BE

.SH DESCRIPTION
The \fBns_zlib\fR command enables compressing and uncompressing of
strings or files.  The command is available if the \fInszlib.so\fR
module is loaded into AOLserver or the \fIlibnszlib.so\fR,
\fInszlib.dll\fR, or \fIlibnszlib.dylib\fR dynamic library is loaded
using the \fBload\fR command in a suitable \fItclsh\fR such as
\fInstclsh\fR.

.TP
\fBns_zlib compress\fR \fIstring\fR
This command compresses the given string and returns a
Tcl byte array object with the compressed data.

.TP
\fBns_zlib gunzip\fR \fIfile\fR
This command uncompresses the contents of the given gzipped
file and returns a string as the result.

.TP
\fBns_zlib gzipfile\fR \fIfile\fR
This command is similar to the \fBgzip\fR shell routines, compressing
the given file into a new file with the \fI.gz\fR extension.  If
successful, the original uncompressed file is deleted.

.TP
\fBns_zlib uncompress\fR \fIbytearray\fR
This command takes a byte array object which includes compressed
data and returns an uncompressed string object.

.SH EXAMPLES
.PP
The following examples demonstrate compressing and uncompressing
a string;

.CS
.nf
# Compress Tcl string
set test "This is test string"
set data [ns_zlib compress $test]
set test [ns_zlib uncompress $data]
\fI--> returns "This is test string"\fR

# Compress the string into gzip format
set gzip [ns_zlib gzip $test]

# Save as gzip file
set fd [open /tmp/test.gz w]
fconfigure $fd -translation binary -encoding binary
puts -nonewline $fd $gzip
close $fd

# Uncompress gzipped file
set test [ns_zlib gunzip /tmp/test.gz]
\fI--> returns "This is test string"\fR
.fi
.CE

.SH "SEE ALSO"
ns_adp_ctl(n), load(n)

.SH KEYWORDS
GZIP, compress, uncompress
