/* Asterisk -- An open source telephony toolkit.
 *
 * Copyright (C) 2016, Frank Haase, Dennis Guse
 *
 * Frank Haase <fra.haase@gmail.com>
 * Dennis Guse <dennis.guse@alumni.tu-berlin.de>
 *
 * See http://www.asterisk.org for more information about
 * the Asterisk project. Please do not directly contact
 * any of the maintainers of this project for assistance;
 * the project provides a web site, mailing lists and IRC
 * channels for your use.
 *
 * Copyright (c) 2001 The Regents of the University of California. All Rights Reserved.
 *
 * The HRIRs used here are obtained from The CIPIC HRTF Database
 * (http://interface.cipic.ucdavis.edu/CIL_html/CIL_HRTF_database.htm)
 * Note that the above mentioned material is Copyright (c) 2001 The
 * Regents of the University of California. All Rights Reserved.
 *
 * Download the file
 * http://interface.cipic.ucdavis.edu/data/special_kemar_hrir.tar and
 * uncompress it in the folder where this Matlab script resides. Finally,
 * run the script.
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License Version 2. See the LICENSE file
 * at the top of the source tree.
 */

/*! \file
 *
 * \brief Multi-party software binaural channel HRIRS
 *
 * \author Frank Haase <fra.haase@googlemail.com>
 * \author Dennis Guse <dennis.guse@alumni.tu-berlin.de>
 *
 * \ingroup bridges
 */

/*
 * This file was created with command:
 * $ conf_bridge_binaural_hrir_importer sounds/hrirs_48k.wav 0 180
 */
#define HRIRS_IMPULSE_LEN 557
#define HRIRS_IMPULSE_SIZE 181
#define HRIRS_SAMPLE_RATE 48000

float hrirs_left[HRIRS_IMPULSE_SIZE][HRIRS_IMPULSE_LEN] = {
{-0.0000610351562500, 0.0002441406250000, -0.0001220703125000, 0.0000915527343750,
-0.0003051757812500, 0.0003967285156250, -0.0000305175781250, 0.0001220703125000,
0.0002136230468750, -0.0003356933593750, 0.0000000000000000, -0.0001220703125000,
0.0002746582031250, -0.0001220703125000, 0.0004272460937500, -0.0003662109375000,
0.0001525878906250, -0.0001220703125000, 0.0000305175781250, 0.0002441406250000,
0.0002441406250000, 0.0000305175781250, -0.0003662109375000, 0.0001831054687500,
-0.0004577636718750, 0.0003356933593750, -0.0002136230468750, 0.0000915527343750,
-0.0004272460937500, -0.0001220703125000, -0.0005493164062500, 0.0000305175781250,
0.0002441406250000, -0.0001220703125000, 0.0001525878906250, -0.0002441406250000,
0.0001220703125000, -0.0000610351562500, 0.0007629394531250, 0.0000610351562500,
0.0006408691406250, -0.0000610351562500, 0.0000610351562500, 0.0000915527343750,
0.0003967285156250, 0.0002136230468750, 0.0000610351562500, 0.0000610351562500,
-0.0007324218750000, -0.0000305175781250, -0.0003051757812500, 0.0000305175781250,
-0.0004272460937500, -0.0000610351562500, -0.0008544921875000, -0.0001220703125000,
-0.0003051757812500, -0.0000610351562500, 0.0001831054687500, 0.0000305175781250,
-0.0002441406250000, -0.0000305175781250, 0.0006103515625000, 0.0000610351562500,
0.0007934570312500, 0.0001220703125000, 0.0004272460937500, 0.0000610351562500,
0.0005798339843750, 0.0000000000000000, 0.0007934570312500, 0.0000305175781250,
-0.0002441406250000, -0.0000305175781250, -0.0000610351562500, -0.0000915527343750,
-0.0001831054687500, -0.0000305175781250, -0.0008850097656250, 0.0000000000000000,
-0.0006713867187500, -0.0000305175781250, -0.0004577636718750, 0.0000305175781250,
-0.0008239746093750, 0.0000305175781250, -0.0003356933593750, 0.0000305175781250,
0.0002441406250000, 0.0000000000000000, -0.0002136230468750, 0.0000305175781250,
0.0007324218750000, 0.0000000000000000, 0.0007629394531250, -0.0000305175781250,
0.0005798339843750, 0.0000000000000000, 0.0009155273437500, 0.0000305175781250,
0.0009765625000000, 0.0000000000000000, 0.0002746582031250, 0.0000000000000000,
0.0005798339843750, 0.0000305175781250, 0.0002136230468750, 0.0000000000000000,
-0.0005187988281250, 0.0000000000000000, -0.0000915527343750, 0.0000000000000000,
-0.0008544921875000, 0.0000000000000000, -0.0009155273437500, -0.0000305175781250,
-0.0008239746093750, 0.0000000000000000, -0.0012207031250000, 0.0000305175781250,
-0.0011291503906250, 0.0000000000000000, -0.0007019042968750, 0.0000305175781250,
-0.0009765625000000, 0.0000000000000000, -0.0005493164062500, 0.0000305175781250,
0.0000305175781250, 0.0000000000000000, -0.0004577636718750, 0.0000000000000000,
0.0006713867187500, -0.0000305175781250, 0.0005187988281250, -0.0000305175781250,
0.0007019042968750, -0.0000305175781250, 0.0014648437500000, 0.0000000000000000,
0.0010681152343750, 0.0000000000000000, 0.0014953613281250, 0.0000000000000000,
0.0016784667968750, 0.0000000000000000, 0.0014038085937500, 0.0000305175781250,
0.0014648437500000, 0.0000000000000000, 0.0016174316406250, 0.0000000000000000,
0.0009155273437500, 0.0000000000000000, 0.0011901855468750, 0.0000000000000000,
0.0008544921875000, -0.0000305175781250, 0.0002441406250000, 0.0000000000000000,
0.0007324218750000, 0.0000305175781250, -0.0003662109375000, 0.0000000000000000,
-0.0000915527343750, -0.0000305175781250, -0.0003356933593750, 0.0000000000000000,
-0.0011291503906250, 0.0000000000000000, -0.0006103515625000, 0.0000000000000000,
-0.0014038085937500, 0.0000000000000000, -0.0012817382812500, 0.0000000000000000,
-0.0013122558593750, 0.0000305175781250, -0.0017395019531250, 0.0000000000000000,
-0.0014648437500000, 0.0000000000000000, -0.0017700195312500, 0.0000000000000000,
-0.0017395019531250, 0.0000000000000000, -0.0017089843750000, 0.0000000000000000,
-0.0018615722656250, -0.0000305175781250, -0.0017089843750000, 0.0000000000000000,
-0.0018005371093750, -0.0000305175781250, -0.0017395019531250, 0.0000000000000000,
-0.0016784667968750, 0.0000305175781250, -0.0017395019531250, -0.0000305175781250,
-0.0016479492187500, 0.0000305175781250, -0.0015258789062500, 0.0000000000000000,
-0.0014953613281250, 0.0000000000000000, -0.0013732910156250, 0.0000000000000000,
-0.0011901855468750, 0.0000000000000000, -0.0011291503906250, 0.0000000000000000,
-0.0008544921875000, 0.0000000000000000, -0.0008850097656250, 0.0000000000000000,
-0.0006408691406250, 0.0000000000000000, -0.0003051757812500, 0.0000000000000000,
-0.0003967285156250, -0.0000305175781250, 0.0001831054687500, 0.0000000000000000,
0.0001220703125000, -0.0000305175781250, 0.0003662109375000, 0.0000000000000000,
0.0008544921875000, -0.0000305175781250, 0.0006713867187500, 0.0000000000000000,
0.0011291503906250, 0.0000305175781250, 0.0011901855468750, 0.0000000000000000,
0.0010986328125000, 0.0000000000000000, 0.0012512207031250, 0.0000000000000000,
0.0012817382812500, 0.0000000000000000, 0.0009765625000000, -0.0000305175781250,
0.0010986328125000, 0.0000000000000000, 0.0007934570312500, 0.0000000000000000,
0.0003967285156250, 0.0000000000000000, 0.0005798339843750, -0.0000305175781250,
-0.0002136230468750, 0.0000000000000000, -0.0001831054687500, 0.0000305175781250,
-0.0003051757812500, 0.0000000000000000, -0.0008544921875000, 0.0000000000000000,
-0.0006408691406250, 0.0000305175781250, -0.0008239746093750, 0.0000000000000000,
-0.0009765625000000, 0.0000305175781250, -0.0007019042968750, 0.0000000000000000,
-0.0005187988281250, 0.0000000000000000, -0.0006713867187500, -0.0000305175781250,
0.0000610351562500, 0.0000000000000000, 0.0000000000000000, 0.0000000000000000,
0.0001525878906250, 0.0000000000000000, 0.0006408691406250, 0.0000305175781250,
0.0004882812500000, 0.0000305175781250, 0.0005187988281250, 0.0000000000000000,
0.0007019042968750, 0.0000000000000000, 0.0004272460937500, 0.0000000000000000,
0.0001220703125000, -0.0000305175781250, 0.0003051757812500, -0.0000305175781250,
-0.0002746582031250, 0.0000000000000000, -0.0003662109375000, 0.0000000000000000,
-0.0002441406250000, 0.0000000000000000, -0.0004882812500000, 0.0000000000000000,
-0.0004882812500000, 0.0000000000000000, -0.0000610351562500, -0.0000305175781250,
-0.0001525878906250, 0.0000000000000000, -0.0000305175781250, 0.0000000000000000,
0.0003662109375000, -0.0000305175781250, 0.0002136230468750, -0.0000610351562500,
0.0001831054687500, 0.0000000000000000, 0.0003356933593750, -0.0000305175781250,
0.0001220703125000, 0.0000000000000000, -0.0001525878906250, 0.0000610351562500,
0.0000305175781250, 0.0000305175781250, -0.0001831054687500, 0.0000000000000000,
-0.0003356933593750, 0.0000610351562500, -0.0001220703125000, 0.0000000000000000,
0.0000000000000000, -0.0000610351562500, -0.0001220703125000, -0.0000305175781250,
0.0001525878906250, 0.0000000000000000, 0.0002441406250000, -0.0000610351562500,
0.0001220703125000, 0.0000000000000000, 0.0000915527343750, 0.0000610351562500,
0.0001831054687500, 0.0000000000000000, -0.0001220703125000, 0.0000000000000000,
-0.0001220703125000, 0.0000610351562500, -0.0000610351562500, 0.0000000000000000,
-0.0001525878906250, -0.0000610351562500, -0.0001831054687500, -0.0000305175781250,
0.0000305175781250, 0.0000000000000000, 0.0000610351562500, -0.0000305175781250,
0.0000305175781250, 0.0000000000000000, 0.0001220703125000, 0.0000610351562500,
0.0000915527343750, 0.0000610351562500, -0.0000915527343750, -0.0000305175781250,
-0.0000610351562500, 0.0000305175781250, 0.0000000000000000, 0.0000000000000000,
-0.0000610351562500, -0.0000915527343750, -0.0000915527343750, -0.0000610351562500,
0.0000610351562500, 0.0000000000000000, 0.0000610351562500, -0.0000305175781250,
0.0000305175781250, -0.0000305175781250, 0.0000610351562500, 0.0000915527343750,
0.0000915527343750, 0.0000610351562500, -0.0000610351562500, -0.0000305175781250,
-0.0000610351562500, 0.0000305175781250, 0.0000000000000000, 0.0000000000000000,
-0.0000610351562500, -0.0001525878906250, -0.0000610351562500, -0.0000915527343750,
0.0000610351562500, 0.0000305175781250, 0.0000915527343750, -0.0000610351562500,
0.0000000000000000, 0.0000000000000000, 0.0000610351562500, 0.0002136230468750,
0.0000915527343750, 0.0001220703125000, -0.0000610351562500, 0.0000305175781250,
-0.0000305175781250, 0.0001220703125000, -0.0000305175781250, 0.0000305175781250,
-0.0000305175781250, -0.0002441406250000, -0.0000610351562500, -0.0000915527343750,
0.0000305175781250, -0.0001525878906250, 0.0000305175781250, -0.0002746582031250,
0.0000305175781250, -0.0000610351562500, 0.0000610351562500, 0.0001831054687500,
0.0000610351562500, 0.0000000000000000, -0.0000305175781250, 0.0002136230468750,
-0.0000305175781250, 0.0003662109375000, -0.0000305175781250, 0.0001525878906250,
-0.0000305175781250, 0.0000610351562500, -0.0000305175781250, 0.0002136230468750,
0.0000000000000000, -0.0002441406250000, 0.0000000000000000, -0.0003051757812500,
0.0000000000000000, -0.0001525878906250, 0.0000305175781250, -0.0003356933593750,
0.0000305175781250, -0.0003662109375000, 0.0000000000000000, 0.0000915527343750,
0.0000305175781250, -0.0000305175781250, 0.0000000000000000, 0.0000915527343750,
-0.0000610351562500, 0.0004882812500000, 0.0000000000000000, 0.0003662109375000,
0.0000000000000000, 0.0003051757812500, 0.0000000000000000, 0.0004882812500000,
0.0000000000000000, 0.0001831054687500, 0.0000000000000000, -0.0001220703125000,
0.0000000000000000, 0.0000610351562500, 0.0000000000000000, -0.0004882812500000,
0.0000000000000000, -0.0005798339843750, 0.0000000000000000, -0.0004882812500000,
0.0000000000000000, -0.0006408691406250, 0.0000000000000000, -0.0006408691406250,
0.0000000000000000, -0.0001525878906250, 0.0000000000000000, -0.0002746582031250,
0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0005187988281250,
0.0000305175781250, 0.0003051757812500, 0.0000000000000000, 0.0007629394531250,
0.0000000000000000, 0.0008850097656250, 0.0000000000000000, 0.0007324218750000,
-0.0000305175781250, 0.0008850097656250, -0.0000305175781250, 0.0009460449218750,
0.0000000000000000, 0.0005493164062500, 0.0000000000000000, 0.0006408691406250,
-0.0000305175781250, 0.0003967285156250, 0.0000000000000000, -0.0000610351562500,
0.0000305175781250, 0.0001220703125000, -0.0000305175781250, -0.0004882812500000,
0.0000000000000000, -0.0004882812500000, 0.0000000000000000, -0.0006713867187500,
0.0000000000000000, -0.0011291503906250, 0.0000000000000000, -0.0009765625000000,
0.0000000000000000, -0.0013122558593750, -0.0000305175781250, -0.0013732910156250,
0.0000000000000000, -0.0013732910156250, 0.0000000000000000, -0.0015258789062500,
0.0000000000000000, -0.0015258789062500, 0.0000000000000000, -0.0015258789062500,
0.0000000000000000, -0.0014953613281250, 0.0000000000000000, -0.0014648437500000,
0.0000000000000000, -0.0014648437500000, 0.0000000000000000, -0.0014343261718750,
0.0000000000000000, -0.0014343261718750, 0.0000000000000000, -0.0013427734375000,
0.0000305175781250, -0.0013427734375000, -0.0000305175781250, -0.0013732910156250,
0.0000000000000000, -0.0012817382812500, 0.0000000000000000, -0.0014343261718750,
0.0000000000000000, -0.0013732910156250, 0.0000305175781250, -0.0013732910156250,
0.0000000000000000, -0.0014953613281250, 0.0000305175781250, -0.0014343261718750,
0.0000000000000000, -0.0016174316406250, 0.0000000000000000, -0.0015563964843750,
0.0000000000000000},
{-0.0000915527343750, 0.0001525878906250, 0.0000000000000000, 0.0000000000000000,
-0.0000305175781250, -0.0001831054687500, -0.0000915527343750, -0.0000915527343750,
0.0000610351562500, -0.0000915527343750, 0.0000915527343750, -0.0002441406250000,
0.0000305175781250, -0.0000305175781250, 0.0000305175781250, 0.0002136230468750,
0.0000610351562500, 0.0000000000000000, -0.0000305175781250, 0.0001831054687500,
-0.0000610351562500, 0.0003356933593750, 0.0000000000000000, 0.0001220703125000,
-0.0000305175781250, -0.0000305175781250, -0.0000610351562500, 0.0001220703125000,
0.0000000000000000, -0.0002746582031250, 0.0000305175781250, -0.0003662109375000,
0.0000000000000000, -0.0001831054687500, 0.0000305175781250, -0.0002746582031250,
0.0000610351562500, -0.0003356933593750, -0.0000305175781250, 0.0001525878906250,
-0.0000305175781250, 0.0000915527343750, 0.0000000000000000, 0.0001220703125000,
-0.0000305175781250, 0.0004882812500000, -0.0000305175781250, 0.0003967285156250,
0.0000000000000000, 0.0001220703125000, 0.0000000000000000, 0.0002746582031250,
0.0000000000000000, 0.0000305175781250, 0.0000305175781250, -0.0004577636718750,
0.0000610351562500, -0.0001831054687500, 0.0000000000000000, -0.0004577636718750,
-0.0000305175781250, -0.0006408691406250, 0.0000000000000000, -0.0003051757812500,
0.0000000000000000, -0.0001525878906250, 0.0000000000000000, -0.0003356933593750,
0.0000000000000000, 0.0003662109375000, 0.0000000000000000, 0.0003967285156250,
0.0000000000000000, 0.0004272460937500, 0.0000305175781250, 0.0008239746093750,
0.0000305175781250, 0.0007019042968750, 0.0000000000000000, 0.0004882812500000,
0.0000000000000000, 0.0007019042968750, 0.0000000000000000, 0.0003051757812500,
-0.0000305175781250, -0.0001831054687500, 0.0000000000000000, 0.0001220703125000,
0.0000305175781250, -0.0006408691406250, -0.0000305175781250, -0.0007019042968750,
0.0000000000000000, -0.0007324218750000, 0.0000000000000000, -0.0011291503906250,
0.0000000000000000, -0.0010375976562500, -0.0000305175781250, -0.0009765625000000,
0.0000000000000000, -0.0010986328125000, 0.0000000000000000, -0.0008544921875000,
0.0000000000000000, -0.0005493164062500, -0.0000305175781250, -0.0007019042968750,
0.0000000000000000, -0.0000915527343750, 0.0000000000000000, -0.0001220703125000,
0.0000305175781250, 0.0001525878906250, 0.0000000000000000, 0.0007019042968750,
0.0000000000000000, 0.0005187988281250, 0.0000000000000000, 0.0010681152343750,
0.0000000000000000, 0.0011291503906250, 0.0000000000000000, 0.0012512207031250,
-0.0000305175781250, 0.0015563964843750, -0.0000305175781250, 0.0015258789062500,
0.0000000000000000, 0.0016784667968750, 0.0000000000000000, 0.0017089843750000,
0.0000000000000000, 0.0017395019531250, 0.0000000000000000, 0.0018310546875000,
0.0000000000000000, 0.0017700195312500, -0.0000305175781250, 0.0018005371093750,
0.0000000000000000, 0.0018310546875000, -0.0000305175781250, 0.0018005371093750,
0.0000000000000000, 0.0018310546875000, -0.0000305175781250, 0.0018005371093750,
-0.0000305175781250, 0.0019226074218750, 0.0000000000000000, 0.0018615722656250,
0.0000000000000000, 0.0018615722656250, -0.0000305175781250, 0.0019531250000000,
0.0000000000000000, 0.0019226074218750, 0.0000000000000000, 0.0020141601562500,
0.0000305175781250, 0.0019836425781250, 0.0000000000000000, 0.0019836425781250,
0.0000305175781250, 0.0020446777343750, 0.0000000000000000, 0.0020141601562500,
-0.0000305175781250, 0.0019226074218750, 0.0000000000000000, 0.0020141601562500,
0.0000000000000000, 0.0018615722656250, 0.0000000000000000, 0.0017089843750000,
-0.0000305175781250, 0.0018310546875000, 0.0000000000000000, 0.0011596679687500,
0.0000000000000000, 0.0014953613281250, 0.0000000000000000, 0.0010681152343750,
0.0000305175781250, 0.0003662109375000, 0.0000000000000000, 0.0008850097656250,
0.0000000000000000, -0.0004577636718750, 0.0000000000000000, -0.0002441406250000,
0.0000000000000000, -0.0004272460937500, 0.0000000000000000, -0.0014648437500000,
-0.0000305175781250, -0.0009765625000000, 0.0000000000000000, -0.0015563964843750,
0.0000000000000000, -0.0018005371093750, 0.0000000000000000, -0.0014038085937500,
0.0000000000000000, -0.0014343261718750, 0.0000305175781250, -0.0016479492187500,
-0.0000305175781250, -0.0004882812500000, -0.0000305175781250, -0.0008239746093750,
0.0000000000000000, -0.0002746582031250, 0.0000000000000000, 0.0007934570312500,
0.0000000000000000, 0.0001831054687500, 0.0000305175781250, 0.0011901855468750,
0.0000305175781250, 0.0013427734375000, 0.0000000000000000, 0.0010375976562500,
0.0000000000000000, 0.0013427734375000, 0.0000305175781250, 0.0014038085937500,
-0.0000305175781250, 0.0005493164062500, -0.0000305175781250, 0.0008239746093750,
0.0000000000000000, 0.0003967285156250, 0.0000000000000000, -0.0005493164062500,
-0.0000305175781250, -0.0001220703125000, 0.0000305175781250, -0.0008544921875000,
0.0000305175781250, -0.0010681152343750, -0.0000305175781250, -0.0007629394531250,
0.0000000000000000, -0.0008850097656250, 0.0000000000000000, -0.0010070800781250,
0.0000000000000000, -0.0000915527343750, -0.0000305175781250, -0.0002746582031250,
0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 0.0007629394531250,
-0.0000305175781250, 0.0004577636718750, 0.0000305175781250, 0.0005798339843750,
0.0000305175781250, 0.0008544921875000, 0.0000000000000000, 0.0004882812500000,
0.0000000000000000, 0.0001220703125000, 0.0000305175781250, 0.0004272460937500,
-0.0000305175781250, -0.0003662109375000, -0.0000610351562500, -0.0003967285156250,
-0.0000305175781250, -0.0003051757812500, -0.0000305175781250, -0.0006713867187500,
-0.0000610351562500, -0.0006103515625000, 0.0000610351562500, -0.0001525878906250,
0.0000610351562500, -0.0003662109375000, 0.0000305175781250, -0.0000915527343750,
0.0000915527343750, 0.0005187988281250, 0.0000915527343750, 0.0002136230468750,
-0.0000610351562500, 0.0004272460937500, -0.0000305175781250, 0.0006713867187500,
-0.0000305175781250, 0.0002746582031250, -0.0001220703125000, -0.0000305175781250,
-0.0000915527343750, 0.0002746582031250, 0.0000000000000000, -0.0004272460937500,
-0.0000305175781250, -0.0006408691406250, 0.0000305175781250, -0.0002746582031250,
0.0001831054687500, -0.0003356933593750, 0.0000915527343750, -0.0005493164062500,
0.0000305175781250, 0.0003356933593750, 0.0000915527343750, 0.0003356933593750,
0.0000000000000000, 0.0001525878906250, -0.0002136230468750, 0.0005493164062500,
-0.0000915527343750, 0.0006103515625000, -0.0001220703125000, -0.0001220703125000,
-0.0002746582031250, 0.0000000000000000, -0.0000610351562500, 0.0000305175781250,
0.0002136230468750, -0.0006408691406250, 0.0001220703125000, 0.0005187988281250,
-0.0003051757812500, -0.0002136230468750, -0.0003051757812500, 0.0001220703125000,
-0.0000915527343750, 0.0000000000000000, -0.0000915527343750, -0.0004577636718750,
-0.0002746582031250, -0.0004272460937500, 0.0003051757812500, 0.0000610351562500,
0.0003356933593750, -0.0000915527343750, 0.0001831054687500, -0.0000305175781250,
0.0005187988281250, 0.0004272460937500, 0.0005187988281250, 0.0003662109375000,
-0.0001525878906250, 0.0000000000000000, 0.0000000000000000, 0.0001831054687500,
-0.0001220703125000, 0.0000610351562500, -0.0007934570312500, -0.0003051757812500,
-0.0005493164062500, -0.0001831054687500, -0.0001220703125000, -0.0000305175781250,
-0.0005187988281250, -0.0001831054687500, -0.0000915527343750, -0.0000610351562500,
0.0007019042968750, 0.0002441406250000, 0.0002441406250000, 0.0001220703125000,
0.0005187988281250, 0.0000610351562500, 0.0009460449218750, 0.0001831054687500,
0.0003051757812500, 0.0000610351562500, -0.0002441406250000, -0.0001525878906250,
0.0003051757812500, -0.0000915527343750, -0.0006713867187500, -0.0000305175781250,
-0.0008850097656250, -0.0001525878906250, -0.0004272460937500, -0.0000305175781250,
-0.0005798339843750, 0.0001220703125000, -0.0008239746093750, 0.0000610351562500,
0.0003662109375000, 0.0000610351562500, 0.0002136230468750, 0.0000915527343750,
0.0002441406250000, 0.0000305175781250, 0.0010375976562500, -0.0000915527343750,
0.0008544921875000, -0.0000305175781250, 0.0003051757812500, -0.0000610351562500,
0.0007324218750000, -0.0000915527343750, 0.0002746582031250, -0.0000610351562500,
-0.0006103515625000, 0.0000610351562500, -0.0000915527343750, 0.0000000000000000,
-0.0007629394531250, 0.0000610351562500, -0.0010375976562500, 0.0000915527343750,
-0.0005798339843750, 0.0000305175781250, -0.0006408691406250, -0.0000610351562500,
-0.0008850097656250, -0.0000305175781250, 0.0002746582031250, 0.0000000000000000,
0.0000610351562500, -0.0000610351562500, 0.0002441406250000, -0.0000305175781250,
0.0011291503906250, 0.0000305175781250, 0.0007324218750000, 0.0000000000000000,
0.0008850097656250, 0.0000000000000000, 0.0012512207031250, 0.0000305175781250,
0.0007629394531250, 0.0000000000000000, 0.0004272460937500, -0.0000305175781250,
0.0007934570312500, -0.0000305175781250, -0.0003356933593750, 0.0000000000000000,
-0.0001525878906250, -0.0000305175781250, -0.0003967285156250, 0.0000000000000000,
-0.0012512207031250, 0.0000305175781250, -0.0007934570312500, 0.0000305175781250,
-0.0013427734375000, 0.0000000000000000, -0.0015258789062500, 0.0000000000000000,
-0.0011596679687500, 0.0000000000000000, -0.0011596679687500, -0.0000305175781250,
-0.0013427734375000, -0.0000305175781250, -0.0003662109375000, 0.0000000000000000,
-0.0007629394531250, 0.0000000000000000, -0.0003051757812500, -0.0000305175781250,
0.0006713867187500, 0.0000000000000000, 0.0000000000000000, 0.0000305175781250,
0.0013122558593750, 0.0000000000000000, 0.0011901855468750, 0.0000000000000000,
0.0012817382812500, 0.0000000000000000, 0.0020751953125000, 0.0000000000000000,
0.0016784667968750, 0.0000000000000000, 0.0020141601562500, 0.0000000000000000,
0.0021667480468750, 0.0000305175781250, 0.0019531250000000, 0.0000000000000000,
0.0018920898437500, 0.0000000000000000, 0.0020751953125000, 0.0000000000000000,
0.0013732910156250, 0.0000000000000000, 0.0017089843750000, 0.0000000000000000,
0.0014038085937500, 0.0000000000000000, 0.0007324218750000, -0.0000305175781250,
0.0012512207031250, 0.0000000000000000, 0.0003662109375000, -0.0000305175781250,
0.0005493164062500, 0.0000000000000000, 0.0003967285156250, 0.0000000000000000,
-0.0001831054687500, 0.0000000000000000, 0.0003356933593750, 0.0000000000000000,
-0.0002746582031250, -0.0000305175781250, -0.0001220703125000, 0.0000000000000000,
-0.0001525878906250, 0.0000000000000000, -0.0004577636718750, -0.0000305175781250,
-0.0001220703125000, -0.0000305175781250, -0.0004577636718750, 0.0000000000000000,
-0.0003662109375000, 0.0000000000000000, -0.0002746582031250, 0.0000000000000000,
-0.0003967285156250, -0.0000305175781250, -0.0002136230468750, 0.0000000000000000,
-0.0001525878906250, 0.0000000000000000, -0.0000305175781250, 0.0000000000000000,
0.0001220703125000, 0.0000305175781250, 0.0002441406250000, 0.0000000000000000,
0.0003662109375000, 0.0000000000000000, 0.0006408691406250, 0.0000000000000000,
0.0006713867187500, 0.0000000000000000, 0.0008544921875000, 0.0000000000000000,
0.0011291503906250, 0.0000000000000000, 0.0010681152343750, 0.0000000000000000,
0.0014648437500000, 0.0000000000000000, 0.0014648437500000, 0.0000305175781250,
0.0014648437500000, 0.0000000000000000, 0.0016784667968750, -0.0000305175781250,
0.0016174316406250},
{-0.0010986328125000, 0.0001525878906250, -0.0006408691406250, 0.0000610351562500,
-0.0005798339843750, 0.0000000000000000, -0.0010375976562500, 0.0000610351562500,
-0.0004272460937500, 0.0000610351562500, 0.0002441406250000, -0.0000610351562500,
-0.0003051757812500, -0.0000610351562500, 0.0007324218750000, -0.0000305175781250,
0.0009155273437500, -0.0000610351562500, 0.0005798339843750, -0.0000305175781250,
0.0009765625000000, 0.0000915527343750, 0.0010375976562500, 0.0000305175781250,
0.0000610351562500, 0.0000305175781250, 0.0003967285156250, 0.0000305175781250,
0.0000000000000000, 0.0000305175781250, -0.0010070800781250, -0.0000610351562500,
-0.0004577636718750, -0.0000305175781250, -0.0010681152343750, 0.0000000000000000,
-0.0013732910156250, -0.0000305175781250, -0.0009460449218750, 0.0000000000000000,
-0.0009460449218750, 0.0000305175781250, -0.0011596679687500, 0.0000305175781250,
-0.0001220703125000, 0.0000000000000000, -0.0003967285156250, 0.0000000000000000,
-0.0000305175781250, 0.0000000000000000, 0.0008850097656250, 0.0000000000000000,
0.0003662109375000, -0.0000305175781250, 0.0012817382812500, 0.0000305175781250,
0.0014038085937500, 0.0000000000000000, 0.0012207031250000, 0.0000000000000000,
0.0015563964843750, 0.0000000000000000, 0.0015258789062500, 0.0000305175781250,
0.0008850097656250, 0.0000000000000000, 0.0012817382812500, 0.0000000000000000,
0.0007324218750000, 0.0000305175781250, -0.0000610351562500, 0.0000000000000000,
0.0006103515625000, -0.0000305175781250, -0.0008239746093750, 0.0000305175781250,
-0.0006408691406250, 0.0000000000000000, -0.0009460449218750, -0.0000305175781250,
-0.0019531250000000, 0.0000000000000000, -0.0013732910156250, 0.0000000000000000,
-0.0021972656250000, -0.0000305175781250, -0.0022888183593750, 0.0000000000000000,
-0.0021362304687500, 0.0000000000000000, -0.0024719238281250, 0.0000305175781250,
-0.0024414062500000, 0.0000000000000000, -0.0021667480468750, 0.0000000000000000,
-0.0024108886718750, 0.0000000000000000, -0.0021362304687500, 0.0000000000000000,
-0.0017700195312500, 0.0000000000000000, -0.0021362304687500, 0.0000000000000000,
-0.0013427734375000, 0.0000000000000000, -0.0015869140625000, -0.0000305175781250,
-0.0013732910156250, 0.0000000000000000, -0.0008544921875000, 0.0000305175781250,
-0.0013732910156250, 0.0000000000000000, -0.0007629394531250, 0.0000000000000000,
-0.0009155273437500, 0.0000000000000000, -0.0008850097656250, 0.0000000000000000,
-0.0005187988281250, 0.0000000000000000, -0.0008544921875000, 0.0000000000000000,
-0.0005187988281250, 0.0000000000000000, -0.0006408691406250, 0.0000000000000000,
-0.0007019042968750, 0.0000000000000000, -0.0004882812500000, 0.0000000000000000,
-0.0007324218750000, 0.0000000000000000, -0.0007324218750000, 0.0000000000000000,
-0.0008544921875000, 0.0000000000000000, -0.0010070800781250, 0.0000305175781250,
-0.0010986328125000, 0.0000000000000000, -0.0012207031250000, 0.0000000000000000,
-0.0014648437500000, 0.0000305175781250, -0.0014648437500000, 0.0000305175781250,
-0.0016174316406250, 0.0000305175781250, -0.0017700195312500, 0.0000000000000000,
-0.0017395019531250, 0.0000000000000000, -0.0018615722656250, 0.0000000000000000,
-0.0019226074218750, 0.0000000000000000, -0.0018310546875000, 0.0000305175781250,
-0.0018310546875000, 0.0000000000000000, -0.0018615722656250, 0.0000305175781250,
-0.0013732910156250, 0.0000305175781250, -0.0014953613281250, 0.0000305175781250,
-0.0011291503906250, 0.0000000000000000, -0.0005187988281250, 0.0000000000000000,
-0.0008544921875000, 0.0000000000000000, 0.0001525878906250, -0.0000305175781250,
0.0001220703125000, 0.0000000000000000, 0.0003051757812500, -0.0000305175781250,
0.0010070800781250, 0.0000000000000000, 0.0007629394531250, -0.0000610351562500,
0.0011596679687500, 0.0000000000000000, 0.0013122558593750, 0.0000305175781250,
0.0010375976562500, 0.0000000000000000, 0.0009765625000000, -0.0000305175781250,
0.0010986328125000, 0.0000000000000000, 0.0003356933593750, 0.0000000000000000,
0.0004577636718750, 0.0000000000000000, 0.0000915527343750, 0.0000305175781250,
-0.0005493164062500, 0.0000000000000000, -0.0002746582031250, 0.0000610351562500,
-0.0007934570312500, 0.0000000000000000, -0.0009765625000000, 0.0000305175781250,
-0.0007324218750000, 0.0000305175781250, -0.0007019042968750, -0.0000610351562500,
-0.0008239746093750, 0.0000000000000000, -0.0000610351562500, 0.0000000000000000,
-0.0001525878906250, 0.0000000000000000, 0.0000000000000000, 0.0000305175781250,
0.0006103515625000, 0.0000000000000000, 0.0004272460937500, 0.0000305175781250,
0.0004577636718750, 0.0000000000000000, 0.0006713867187500, 0.0000000000000000,
0.0003356933593750, 0.0000610351562500, 0.0000000000000000, -0.0000305175781250,
0.0002136230468750, 0.0000000000000000, -0.0003356933593750, 0.0000000000000000,
-0.0004272460937500, -0.0000610351562500, -0.0002441406250000, 0.0000000000000000,
-0.0003967285156250, 0.0000000000000000, -0.0004882812500000, 0.0000000000000000,
0.0000915527343750, 0.0000305175781250, 0.0000610351562500, 0.0000915527343750,
0.0000305175781250, 0.0000305175781250, 0.0003967285156250, 0.0000000000000000,
0.0003051757812500, 0.0000305175781250, 0.0000000000000000, -0.0000610351562500,
0.0001525878906250, -0.0000915527343750, 0.0000305175781250, -0.0000305175781250,
-0.0003051757812500, -0.0000305175781250, -0.0001831054687500, -0.0000305175781250,
-0.0001525878906250, 0.0000305175781250, -0.0002441406250000, 0.0000915527343750,
-0.0000610351562500, 0.0000000000000000, 0.0002136230468750, 0.0000000000000000,
0.0000610351562500, 0.0000305175781250, 0.0001525878906250, -0.0000305175781250,
0.0003356933593750, -0.0000915527343750, 0.0000915527343750, 0.0000000000000000,
-0.0001220703125000, 0.0000305175781250, 0.0000305175781250, -0.0000305175781250,
-0.0001220703125000, 0.0000305175781250, -0.0002136230468750, 0.0000610351562500,
-0.0000915527343750, 0.0000000000000000, 0.0000610351562500, -0.0000305175781250,
0.0000610351562500, 0.0000000000000000, 0.0000305175781250, -0.0000610351562500,
0.0001220703125000, -0.0000915527343750, 0.0000305175781250, -0.0000305175781250,
-0.0000915527343750, 0.0000000000000000, 0.0000610351562500, 0.0000305175781250,
-0.0000610351562500, 0.0000915527343750, -0.0001525878906250, 0.0001220703125000,
0.0000000000000000, 0.0000610351562500, 0.0000915527343750, 0.0000000000000000,
0.0000000000000000, 0.0000305175781250, 0.0000305175781250, -0.0000610351562500,
0.0001220703125000, -0.0001220703125000, 0.0000000000000000, -0.0000305175781250,
-0.0000915527343750, 0.0000610351562500, 0.0000305175781250, 0.0000000000000000,
-0.0000610351562500, 0.0001220703125000, -0.0001220703125000, 0.0001831054687500,
-0.0000305175781250, 0.0000000000000000, 0.0000915527343750, -0.0000610351562500,
-0.0000305175781250, 0.0000305175781250, 0.0000610351562500, -0.0002136230468750,
0.0001220703125000, -0.0002746582031250, 0.0000610351562500, -0.0000915527343750,
-0.0000305175781250, -0.0000305175781250, 0.0000305175781250, -0.0002136230468750,
-0.0000305175781250, 0.0002441406250000, -0.0000915527343750, 0.0002746582031250,
-0.0000305175781250, 0.0001525878906250, 0.0000305175781250, 0.0002746582031250,
-0.0000305175781250, 0.0003356933593750, 0.0000305175781250, -0.0001831054687500,
0.0000610351562500, -0.0001220703125000, 0.0000305175781250, -0.0001220703125000,
-0.0000305175781250, -0.0004882812500000, 0.0000305175781250, -0.0003662109375000,
-0.0000305175781250, -0.0000610351562500, -0.0000610351562500, -0.0002441406250000,
-0.0000305175781250, -0.0000305175781250, 0.0000000000000000, 0.0004577636718750,
-0.0000610351562500, 0.0002136230468750, 0.0000305175781250, 0.0003356933593750,
0.0000610351562500, 0.0005493164062500, 0.0000610351562500, 0.0001831054687500,
0.0000000000000000, -0.0000915527343750, 0.0000305175781250, 0.0001831054687500,
-0.0000305175781250, -0.0004882812500000, -0.0000305175781250, -0.0005798339843750,
-0.0000305175781250, -0.0003967285156250, 0.0000000000000000, -0.0006103515625000,
-0.0000305175781250, -0.0006713867187500, 0.0000000000000000, -0.0000610351562500,
0.0000305175781250, -0.0002136230468750, 0.0000000000000000, 0.0001220703125000,
0.0000000000000000, 0.0007019042968750, 0.0000305175781250, 0.0004882812500000,
0.0000000000000000, 0.0007629394531250, 0.0000000000000000, 0.0009460449218750,
-0.0000305175781250, 0.0006713867187500, 0.0000000000000000, 0.0005493164062500,
-0.0000305175781250, 0.0007019042968750, 0.0000000000000000, -0.0000915527343750,
0.0000000000000000, 0.0000305175781250, 0.0000000000000000, -0.0002746582031250,
0.0000610351562500, -0.0009155273437500, 0.0000000000000000, -0.0006713867187500,
0.0000000000000000, -0.0011596679687500, 0.0000000000000000, -0.0012512207031250,
0.0000000000000000, -0.0011901855468750, 0.0000000000000000, -0.0013732910156250,
0.0000000000000000, -0.0013122558593750, 0.0000000000000000, -0.0010375976562500,
-0.0000305175781250, -0.0011291503906250, -0.0000305175781250, -0.0008239746093750,
0.0000000000000000, -0.0004577636718750, 0.0000305175781250, -0.0005798339843750,
0.0000000000000000, 0.0000305175781250, 0.0000000000000000, 0.0001525878906250,
0.0000000000000000, 0.0003051757812500, 0.0000000000000000, 0.0007324218750000,
0.0000305175781250, 0.0006713867187500, 0.0000000000000000, 0.0010070800781250,
0.0000000000000000, 0.0010986328125000, 0.0000000000000000, 0.0011901855468750,
-0.0000305175781250, 0.0013732910156250, 0.0000000000000000, 0.0013427734375000,
0.0000000000000000, 0.0014953613281250, 0.0000000000000000, 0.0015869140625000,
0.0000000000000000, 0.0015563964843750, 0.0000000000000000, 0.0016174316406250,
0.0000000000000000, 0.0016784667968750, 0.0000000000000000, 0.0016479492187500,
0.0000000000000000, 0.0017089843750000, 0.0000000000000000, 0.0016784667968750,
0.0000000000000000, 0.0016479492187500, 0.0000000000000000, 0.0016784667968750,
0.0000000000000000, 0.0015258789062500, 0.0000000000000000, 0.0016479492187500,
0.0000000000000000, 0.0015563964843750, 0.0000305175781250, 0.0014038085937500,
0.0000000000000000, 0.0015563964843750, 0.0000000000000000, 0.0010375976562500,
0.0000305175781250, 0.0012207031250000, 0.0000305175781250, 0.0009765625000000,
-0.0000305175781250, 0.0005187988281250, 0.0000000000000000, 0.0008850097656250,
-0.0000305175781250, -0.0001831054687500, 0.0000000000000000, 0.0000915527343750,
0.0000000000000000, -0.0002441406250000, 0.0000000000000000, -0.0010986328125000,
0.0000000000000000, -0.0005493164062500, -0.0000305175781250, -0.0016479492187500,
0.0000305175781250, -0.0016174316406250, -0.0000305175781250, -0.0014648437500000,
-0.0000305175781250, -0.0020141601562500, -0.0000305175781250, -0.0019226074218750,
0.0000305175781250, -0.0014343261718750, 0.0000000000000000, -0.0018310546875000,
0.0000305175781250, -0.0012207031250000, 0.0000000000000000, -0.0004272460937500,
0.0000000000000000, -0.0010070800781250, 0.0000000000000000, 0.0005493164062500,
0.0000000000000000, 0.0003967285156250, 0.0000000000000000, 0.0005798339843750,
-0.0000305175781250, 0.0016784667968750, 0.0000000000000000, 0.0012207031250000,
0.0000000000000000, 0.0013122558593750, 0.0000000000000000, 0.0016784667968750,
0.0000305175781250, 0.0010986328125000, 0.0000000000000000, 0.0006408691406250,
0.0000305175781250, 0.0010681152343750, 0.0000000000000000, -0.0003356933593750,
-0.0000305175781250},
{-0.0000305175781250, 0.0002746582031250, -0.0000610351562500, 0.0004577636718750,
0.0000000000000000, 0.0000610351562500, 0.0000000000000000, -0.0005187988281250,
-0.0000305175781250, -0.0002136230468750, 0.0000000000000000, -0.0008239746093750,
0.0000000000000000, -0.0010070800781250, -0.0000305175781250, -0.0008239746093750,
0.0000305175781250, -0.0008850097656250, 0.0000000000000000, -0.0009765625000000,
0.0000000000000000, -0.0003356933593750, 0.0000000000000000, -0.0004577636718750,
0.0000000000000000, -0.0001220703125000, 0.0000000000000000, 0.0005493164062500,
0.0000000000000000, 0.0002746582031250, -0.0000305175781250, 0.0009765625000000,
0.0000305175781250, 0.0010681152343750, -0.0000305175781250, 0.0010986328125000,
-0.0000305175781250, 0.0014343261718750, 0.0000305175781250, 0.0013427734375000,
-0.0000305175781250, 0.0013427734375000, 0.0000000000000000, 0.0014343261718750,
0.0000000000000000, 0.0011901855468750, 0.0000000000000000, 0.0009765625000000,
0.0000000000000000, 0.0010375976562500, -0.0000305175781250, 0.0005187988281250,
0.0000000000000000, 0.0004577636718750, 0.0000000000000000, 0.0002746582031250,
0.0000305175781250, -0.0001220703125000, 0.0000305175781250, -0.0000610351562500,
0.0000000000000000, -0.0004577636718750, 0.0000000000000000, -0.0006103515625000,
0.0000000000000000, -0.0007019042968750, 0.0000305175781250, -0.0009460449218750,
0.0000000000000000, -0.0008850097656250, 0.0000000000000000, -0.0010986328125000,
0.0000000000000000, -0.0012512207031250, 0.0000305175781250, -0.0012207031250000,
0.0000000000000000, -0.0012817382812500, 0.0000305175781250, -0.0013427734375000,
0.0000000000000000, -0.0012817382812500, 0.0000000000000000, -0.0013427734375000,
0.0000000000000000, -0.0012817382812500, 0.0000000000000000, -0.0012207031250000,
0.0000000000000000, -0.0012817382812500, 0.0000000000000000, -0.0010986328125000,
-0.0000305175781250, -0.0012207031250000, 0.0000000000000000, -0.0010375976562500,
-0.0000305175781250, -0.0008239746093750, 0.0000000000000000, -0.0010375976562500,
0.0000000000000000, -0.0003967285156250, 0.0000000000000000, -0.0005798339843750,
0.0000000000000000, -0.0002746582031250, 0.0000000000000000, 0.0003051757812500,
0.0000305175781250, -0.0001525878906250, 0.0000000000000000, 0.0008544921875000,
0.0000000000000000, 0.0006408691406250, 0.0000000000000000, 0.0009155273437500,
-0.0000305175781250, 0.0017089843750000, 0.0000000000000000, 0.0012207031250000,
0.0000000000000000, 0.0018615722656250, 0.0000000000000000, 0.0020141601562500,
0.0000000000000000, 0.0016479492187500, 0.0000305175781250, 0.0018615722656250,
0.0000000000000000, 0.0020141601562500, -0.0000305175781250, 0.0009765625000000,
0.0000000000000000, 0.0013732910156250, -0.0000305175781250, 0.0007324218750000,
-0.0000305175781250, -0.0003662109375000, -0.0000305175781250, 0.0003051757812500,
0.0000000000000000, -0.0011596679687500, -0.0000305175781250, -0.0011596679687500,
0.0000610351562500, -0.0010070800781250, 0.0000305175781250, -0.0018920898437500,
0.0000305175781250, -0.0016784667968750, 0.0000000000000000, -0.0011901855468750,
0.0000000000000000, -0.0016174316406250, -0.0000305175781250, -0.0009460449218750,
0.0000000000000000, -0.0000915527343750, 0.0000000000000000, -0.0007019042968750,
0.0000000000000000, 0.0007019042968750, 0.0000000000000000, 0.0007629394531250,
0.0000000000000000, 0.0006713867187500, 0.0000305175781250, 0.0014038085937500,
0.0000305175781250, 0.0012512207031250, 0.0000000000000000, 0.0007934570312500,
0.0000000000000000, 0.0010986328125000, 0.0000000000000000, 0.0005798339843750,
-0.0000305175781250, -0.0002136230468750, -0.0000305175781250, 0.0002136230468750,
0.0000305175781250, -0.0007629394531250, 0.0000000000000000, -0.0009460449218750,
0.0000000000000000, -0.0006408691406250, 0.0000610351562500, -0.0009460449218750,
0.0000305175781250, -0.0010375976562500, -0.0000305175781250, -0.0000915527343750,
0.0000000000000000, -0.0003051757812500, 0.0000000000000000, -0.0000915527343750,
-0.0000610351562500, 0.0006713867187500, -0.0000610351562500, 0.0003967285156250,
0.0000305175781250, 0.0005493164062500, -0.0000305175781250, 0.0008239746093750,
-0.0000305175781250, 0.0004272460937500, 0.0000915527343750, 0.0001525878906250,
0.0000305175781250, 0.0003967285156250, 0.0000000000000000, -0.0003662109375000,
0.0000305175781250, -0.0004577636718750, 0.0000305175781250, -0.0003356933593750,
-0.0000915527343750, -0.0006408691406250, -0.0000305175781250, -0.0006408691406250,
-0.0000305175781250, 0.0000000000000000, -0.0000915527343750, -0.0002136230468750,
-0.0000305175781250, 0.0000000000000000, 0.0001220703125000, 0.0007629394531250,
0.0000610351562500, 0.0004272460937500, 0.0000915527343750, 0.0003967285156250,
0.0001525878906250, 0.0007629394531250, 0.0000610351562500, 0.0002441406250000,
-0.0000610351562500, -0.0004272460937500, 0.0000305175781250, 0.0000000000000000,
-0.0001525878906250, -0.0004577636718750, -0.0002136230468750, -0.0008239746093750,
-0.0000610351562500, -0.0002441406250000, 0.0000000000000000, 0.0001220703125000,
-0.0001220703125000, -0.0003051757812500, 0.0002136230468750, 0.0004577636718750,
0.0002441406250000, 0.0006713867187500, 0.0001525878906250, 0.0003051757812500,
0.0001831054687500, 0.0001831054687500, -0.0003051757812500, -0.0003356933593750,
0.0002136230468750, 0.0004577636718750, -0.0000915527343750, 0.0005798339843750,
0.0000915527343750, 0.0002136230468750, 0.0005187988281250, 0.0000610351562500,
0.0003967285156250, 0.0003967285156250, 0.0000000000000000, -0.0003051757812500,
0.0003356933593750, -0.0005187988281250, -0.0000305175781250, -0.0001525878906250,
-0.0006408691406250, -0.0001525878906250, -0.0003051757812500, -0.0003356933593750,
-0.0003967285156250, 0.0002441406250000, -0.0007934570312500, 0.0003051757812500,
-0.0002136230468750, 0.0000915527343750, 0.0003967285156250, 0.0002441406250000,
-0.0001220703125000, 0.0003662109375000, 0.0007019042968750, -0.0000915527343750,
0.0010070800781250, -0.0001525878906250, 0.0003662109375000, -0.0000305175781250,
0.0002746582031250, -0.0002136230468750, 0.0007019042968750, -0.0002441406250000,
-0.0006103515625000, 0.0001525878906250, -0.0007019042968750, 0.0001525878906250,
-0.0003356933593750, 0.0000000000000000, -0.0008850097656250, 0.0001831054687500,
-0.0009765625000000, 0.0002136230468750, 0.0001831054687500, -0.0000610351562500,
-0.0001220703125000, -0.0000305175781250, 0.0001220703125000, 0.0000305175781250,
0.0012207031250000, -0.0001525878906250, 0.0007934570312500, -0.0001831054687500,
0.0004882812500000, 0.0000305175781250, 0.0010375976562500, 0.0000305175781250,
0.0003662109375000, 0.0000305175781250, -0.0005493164062500, 0.0001525878906250,
0.0000610351562500, 0.0000915527343750, -0.0009460449218750, -0.0000305175781250,
-0.0012512207031250, -0.0000305175781250, -0.0006713867187500, 0.0000000000000000,
-0.0007324218750000, -0.0000915527343750, -0.0010375976562500, -0.0000915527343750,
0.0003356933593750, 0.0000000000000000, 0.0001220703125000, 0.0000000000000000,
0.0002746582031250, 0.0000000000000000, 0.0013122558593750, 0.0000610351562500,
0.0008850097656250, 0.0000610351562500, 0.0007019042968750, -0.0000305175781250,
0.0012512207031250, 0.0000000000000000, 0.0005187988281250, 0.0000000000000000,
-0.0002136230468750, -0.0000305175781250, 0.0004272460937500, -0.0000610351562500,
-0.0009155273437500, 0.0000305175781250, -0.0008850097656250, 0.0000000000000000,
-0.0007934570312500, 0.0000305175781250, -0.0015563964843750, 0.0000305175781250,
-0.0014038085937500, 0.0000000000000000, -0.0010375976562500, -0.0000305175781250,
-0.0013732910156250, -0.0000305175781250, -0.0008544921875000, 0.0000305175781250,
-0.0001831054687500, 0.0000305175781250, -0.0007019042968750, 0.0000000000000000,
0.0007324218750000, 0.0000000000000000, 0.0005493164062500, 0.0000000000000000,
0.0007629394531250, 0.0000000000000000, 0.0017395019531250, 0.0000000000000000,
0.0012207031250000, 0.0000000000000000, 0.0016479492187500, 0.0000000000000000,
0.0018920898437500, 0.0000305175781250, 0.0014953613281250, 0.0000305175781250,
0.0013427734375000, 0.0000000000000000, 0.0016479492187500, 0.0000305175781250,
0.0004882812500000, 0.0000000000000000, 0.0008850097656250, 0.0000305175781250,
0.0003356933593750, 0.0000000000000000, -0.0007629394531250, 0.0000000000000000,
0.0000305175781250, -0.0000305175781250, -0.0015563964843750, 0.0000000000000000,
-0.0014038085937500, 0.0000305175781250, -0.0015258789062500, 0.0000305175781250,
-0.0025329589843750, -0.0000305175781250, -0.0020141601562500, 0.0000000000000000,
-0.0027465820312500, 0.0000000000000000, -0.0028076171875000, 0.0000000000000000,
-0.0027160644531250, 0.0000000000000000, -0.0030517578125000, 0.0000000000000000,
-0.0029907226562500, 0.0000000000000000, -0.0028381347656250, 0.0000305175781250,
-0.0029907226562500, 0.0000000000000000, -0.0028381347656250, 0.0000000000000000,
-0.0026550292968750, 0.0000000000000000, -0.0028686523437500, 0.0000000000000000,
-0.0025634765625000, 0.0000000000000000, -0.0026855468750000, 0.0000000000000000,
-0.0026245117187500, 0.0000000000000000, -0.0023498535156250, 0.0000305175781250,
-0.0025939941406250, -0.0000305175781250, -0.0022888183593750, 0.0000000000000000,
-0.0024108886718750, 0.0000305175781250, -0.0023803710937500, 0.0000305175781250,
-0.0022277832031250, 0.0000000000000000, -0.0024108886718750, 0.0000305175781250,
-0.0023193359375000, 0.0000000000000000, -0.0024108886718750, -0.0000305175781250,
-0.0024719238281250, 0.0000000000000000, -0.0024414062500000, 0.0000305175781250,
-0.0025024414062500, -0.0000305175781250, -0.0024414062500000, 0.0000000000000000,
-0.0024719238281250, 0.0000000000000000, -0.0024108886718750, 0.0000000000000000,
-0.0023193359375000, -0.0000305175781250, -0.0023803710937500, -0.0000305175781250,
-0.0019226074218750, -0.0000610351562500, -0.0020751953125000, -0.0000305175781250,
-0.0017700195312500, 0.0000000000000000, -0.0012512207031250, 0.0000000000000000,
-0.0014953613281250, 0.0000000000000000, -0.0005187988281250, 0.0000305175781250,
-0.0006103515625000, 0.0000305175781250, -0.0002441406250000, 0.0000305175781250,
0.0005798339843750, 0.0000000000000000, 0.0002746582031250, 0.0000000000000000,
0.0010375976562500, -0.0000610351562500, 0.0011901855468750, -0.0000610351562500,
0.0010986328125000, 0.0000000000000000, 0.0014953613281250, -0.0000305175781250,
0.0014038085937500, 0.0000000000000000, 0.0010375976562500, 0.0000305175781250,
0.0012817382812500, 0.0000305175781250, 0.0008544921875000, 0.0000305175781250,
0.0002441406250000, 0.0000000000000000, 0.0005493164062500, 0.0000000000000000,
-0.0004272460937500, 0.0000000000000000, -0.0004577636718750, 0.0000000000000000,
-0.0005798339843750, -0.0000305175781250, -0.0012207031250000, 0.0000305175781250,
-0.0010070800781250, 0.0000000000000000, -0.0008239746093750, -0.0000305175781250,
-0.0010986328125000, 0.0000305175781250, -0.0006408691406250, 0.0000000000000000,
-0.0001220703125000, 0.0000000000000000, -0.0004882812500000, 0.0000000000000000,
0.0004272460937500, 0.0000305175781250, 0.0005493164062500, 0.0000000000000000,
0.0003967285156250, 0.0000000000000000, 0.0007934570312500, 0.0000000000000000,
0.0007324218750000, -0.0000610351562500, 0.0002441406250000, 0.0000305175781250,
0.0003967285156250, 0.0000610351562500, 0.0001220703125000, 0.0000000000000000,
-0.0004577636718750},
{-0.0017089843750000, 0.0000305175781250, -0.0020446777343750, 0.0000305175781250,
-0.0021362304687500, 0.0000000000000000, -0.0012817382812500, 0.0000000000000000,
-0.0017395019531250, 0.0000000000000000, -0.0011291503906250, 0.0000000000000000,
-0.0002441406250000, 0.0000305175781250, -0.0009765625000000, 0.0000305175781250,
0.0007629394531250, 0.0000000000000000, 0.0004577636718750, 0.0000305175781250,
0.0007934570312500, 0.0000305175781250, 0.0019531250000000, -0.0000305175781250,
0.0011901855468750, 0.0000000000000000, 0.0024108886718750, 0.0000000000000000,
0.0023498535156250, 0.0000305175781250, 0.0023498535156250, 0.0000000000000000,
0.0030212402343750, 0.0000305175781250, 0.0027160644531250, 0.0000305175781250,
0.0030212402343750, 0.0000000000000000, 0.0031127929687500, 0.0000000000000000,
0.0029907226562500, -0.0000305175781250, 0.0030822753906250, -0.0000305175781250,
0.0030822753906250, 0.0000305175781250, 0.0029602050781250, 0.0000305175781250,
0.0030212402343750, 0.0000000000000000, 0.0029296875000000, 0.0000305175781250,
0.0028381347656250, 0.0000000000000000, 0.0029907226562500, 0.0000000000000000,
0.0027770996093750, 0.0000000000000000, 0.0028076171875000, 0.0000305175781250,
0.0027770996093750, 0.0000305175781250, 0.0026855468750000, 0.0000000000000000,
0.0028076171875000, 0.0000000000000000, 0.0026855468750000, 0.0000000000000000,
0.0027465820312500, 0.0000000000000000, 0.0026550292968750, 0.0000000000000000,
0.0025939941406250, 0.0000000000000000, 0.0026245117187500, 0.0000000000000000,
0.0024719238281250, -0.0000305175781250, 0.0025024414062500, 0.0000000000000000,
0.0023193359375000, 0.0000000000000000, 0.0020751953125000, -0.0000305175781250,
0.0021362304687500, -0.0000305175781250, 0.0014953613281250, -0.0000305175781250,
0.0016479492187500, 0.0000000000000000, 0.0012817382812500, 0.0000000000000000,
0.0005798339843750, 0.0000000000000000, 0.0008239746093750, 0.0000305175781250,
-0.0002136230468750, -0.0000305175781250, -0.0001831054687500, 0.0000000000000000,
-0.0004577636718750, 0.0000305175781250, -0.0012207031250000, 0.0000000000000000,
-0.0010070800781250, -0.0000305175781250, -0.0014953613281250, 0.0000000000000000,
-0.0016479492187500, -0.0000305175781250, -0.0014648437500000, 0.0000000000000000,
-0.0014953613281250, 0.0000000000000000, -0.0015869140625000, 0.0000305175781250,
-0.0008544921875000, 0.0000305175781250, -0.0010070800781250, 0.0000305175781250,
-0.0006103515625000, 0.0000000000000000, 0.0001220703125000, -0.0000305175781250,
-0.0002136230468750, 0.0000305175781250, 0.0007019042968750, 0.0000305175781250,
0.0008544921875000, 0.0000610351562500, 0.0007629394531250, 0.0000000000000000,
0.0011596679687500, 0.0000000000000000, 0.0010986328125000, 0.0000000000000000,
0.0005798339843750, -0.0000305175781250, 0.0008239746093750, 0.0000000000000000,
0.0003967285156250, 0.0000000000000000, -0.0003051757812500, -0.0000305175781250,
0.0000305175781250, -0.0000305175781250, -0.0007019042968750, 0.0000305175781250,
-0.0008850097656250, 0.0000305175781250, -0.0006103515625000, 0.0000000000000000,
-0.0007934570312500, 0.0000000000000000, -0.0008544921875000, 0.0000000000000000,
-0.0000610351562500, -0.0000305175781250, -0.0001525878906250, 0.0000000000000000,
0.0000305175781250, 0.0000000000000000, 0.0006713867187500, -0.0000610351562500,
0.0004272460937500, -0.0000305175781250, 0.0003662109375000, 0.0000915527343750,
0.0006408691406250, 0.0000000000000000, 0.0002441406250000, 0.0000000000000000,
-0.0001831054687500, 0.0000305175781250, 0.0000915527343750, 0.0000305175781250,
-0.0003051757812500, -0.0000305175781250, -0.0005187988281250, 0.0000000000000000,
-0.0002746582031250, 0.0000305175781250, -0.0000915527343750, -0.0000305175781250,
-0.0002746582031250, -0.0000305175781250, 0.0002136230468750, 0.0000305175781250,
0.0003356933593750, 0.0000305175781250, 0.0001220703125000, 0.0000000000000000,
0.0002746582031250, 0.0000610351562500, 0.0003356933593750, 0.0000915527343750,
-0.0001220703125000, 0.0000000000000000, -0.0001220703125000, 0.0000000000000000,
-0.0000915527343750, 0.0000000000000000, -0.0003356933593750, -0.0000610351562500,
-0.0003356933593750, -0.0000915527343750, 0.0000915527343750, 0.0000610351562500,
-0.0000915527343750, 0.0000000000000000, -0.0000610351562500, -0.0000305175781250,
0.0002746582031250, 0.0000610351562500, 0.0002136230468750, 0.0000610351562500,
-0.0000305175781250, -0.0000610351562500, 0.0000915527343750, -0.0000305175781250,
0.0000610351562500, 0.0000000000000000, -0.0002136230468750, -0.0000915527343750,
-0.0001831054687500, -0.0000915527343750, 0.0000610351562500, 0.0000610351562500,
-0.0000610351562500, 0.0000305175781250, -0.0000610351562500, 0.0000000000000000,
0.0001831054687500, 0.0000915527343750, 0.0001220703125000, 0.0001220703125000,
0.0000000000000000, 0.0000000000000000, 0.0000610351562500, -0.0000305175781250,
0.0000610351562500, 0.0000000000000000, -0.0001525878906250, -0.0000915527343750,
-0.0001220703125000, -0.0001220703125000, 0.0000915527343750, 0.0000610351562500,
0.0000000000000000, 0.0000610351562500, 0.0000000000000000, 0.0000000000000000,
0.0001831054687500, 0.0000915527343750, 0.0000915527343750, 0.0001220703125000,
0.0000000000000000, -0.0001525878906250, 0.0000915527343750, -0.0000915527343750,
0.0000305175781250, -0.0000610351562500, -0.0001525878906250, -0.0002441406250000,
-0.0000915527343750, -0.0002441406250000, 0.0000000000000000, 0.0001220703125000,
-0.0000305175781250, 0.0000305175781250, 0.0000000000000000, 0.0000610351562500,
0.0001220703125000, 0.0003662109375000, 0.0000915527343750, 0.0002746582031250,
0.0000000000000000, -0.0001220703125000, 0.0000305175781250, 0.0001525878906250,
0.0000000000000000, 0.0000000000000000, -0.0000610351562500, -0.0004882812500000,
-0.0000610351562500, -0.0002746582031250, 0.0000000000000000, -0.0001831054687500,
0.0000000000000000, -0.0004272460937500, -0.0000305175781250, -0.0001220703125000,
0.0000610351562500, 0.0003051757812500, 0.0000305175781250, 0.0000305175781250,
0.0000305175781250, 0.0003356933593750, 0.0000610351562500, 0.0005798339843750,
0.0000000000000000, 0.0002441406250000, -0.0000305175781250, 0.0000610351562500,
-0.0000305175781250, 0.0002746582031250, -0.0000305175781250, -0.0004272460937500,
-0.0000610351562500, -0.0004882812500000, 0.0000000000000000, -0.0003662109375000,
0.0000610351562500, -0.0006408691406250, 0.0000305175781250, -0.0006713867187500,
0.0000000000000000, -0.0000610351562500, 0.0000305175781250, -0.0002136230468750,
0.0000000000000000, 0.0000610351562500, -0.0000305175781250, 0.0007324218750000,
-0.0000305175781250, 0.0004577636718750, 0.0000000000000000, 0.0005798339843750,
-0.0000305175781250, 0.0008850097656250, 0.0000000000000000, 0.0004882812500000,
0.0000305175781250, 0.0001220703125000, 0.0000000000000000, 0.0003662109375000,
0.0000305175781250, -0.0005493164062500, 0.0000000000000000, -0.0005493164062500,
0.0000000000000000, -0.0006713867187500, 0.0000000000000000, -0.0012512207031250,
0.0000000000000000, -0.0010681152343750, -0.0000305175781250, -0.0009460449218750,
0.0000000000000000, -0.0012207031250000, -0.0000305175781250, -0.0008544921875000,
0.0000305175781250, -0.0004577636718750, 0.0000000000000000, -0.0006713867187500,
0.0000000000000000, 0.0003051757812500, 0.0000305175781250, 0.0002441406250000,
0.0000000000000000, 0.0005187988281250, -0.0000305175781250, 0.0012207031250000,
0.0000000000000000, 0.0009765625000000, 0.0000000000000000, 0.0015258789062500,
0.0000000000000000, 0.0015869140625000, 0.0000000000000000, 0.0015258789062500,
0.0000000000000000, 0.0017395019531250, 0.0000000000000000, 0.0017089843750000,
0.0000305175781250, 0.0016174316406250, 0.0000000000000000, 0.0015869140625000,
0.0000000000000000, 0.0014343261718750, 0.0000000000000000, 0.0011901855468750,
0.0000305175781250, 0.0012817382812500, 0.0000000000000000, 0.0009460449218750,
0.0000000000000000, 0.0008239746093750, 0.0000305175781250, 0.0007019042968750,
0.0000000000000000, 0.0004882812500000, 0.0000000000000000, 0.0005187988281250,
0.0000000000000000, 0.0003356933593750, 0.0000000000000000, 0.0001220703125000,
0.0000000000000000, 0.0001525878906250, -0.0000305175781250, 0.0001220703125000,
0.0000000000000000, -0.0000305175781250, 0.0000305175781250, 0.0001831054687500,
0.0000000000000000, 0.0000610351562500, 0.0000000000000000, 0.0001220703125000,
0.0000000000000000, 0.0002746582031250, 0.0000000000000000, 0.0001525878906250,
0.0000000000000000, 0.0005187988281250, 0.0000000000000000, 0.0003662109375000,
0.0000000000000000, 0.0005493164062500, 0.0000000000000000, 0.0008850097656250,
0.0000000000000000, 0.0005798339843750, 0.0000000000000000, 0.0012817382812500,
0.0000000000000000, 0.0011291503906250, 0.0000000000000000, 0.0013122558593750,
-0.0000305175781250, 0.0018310546875000, 0.0000000000000000, 0.0014953613281250,
0.0000000000000000, 0.0021667480468750, 0.0000000000000000, 0.0021362304687500,
-0.0000305175781250, 0.0019836425781250, 0.0000000000000000, 0.0023803710937500,
0.0000000000000000, 0.0023193359375000, -0.0000305175781250, 0.0018005371093750,
0.0000000000000000, 0.0021972656250000, -0.0000305175781250, 0.0015563964843750,
0.0000000000000000, 0.0008544921875000, -0.0000305175781250, 0.0014953613281250,
0.0000000000000000, -0.0002746582031250, 0.0000000000000000, -0.0000610351562500,
-0.0000305175781250, -0.0003967285156250, -0.0000610351562500, -0.0016784667968750,
0.0000305175781250, -0.0011291503906250, 0.0000000000000000, -0.0018005371093750,
-0.0000305175781250, -0.0020751953125000, 0.0000000000000000, -0.0015258789062500,
0.0000000000000000, -0.0014953613281250, 0.0000000000000000, -0.0018310546875000,
0.0000000000000000, -0.0003356933593750, 0.0000305175781250, -0.0006713867187500,
0.0000000000000000, -0.0001525878906250, -0.0000305175781250, 0.0011596679687500,
0.0000000000000000, 0.0004882812500000, 0.0000000000000000, 0.0013427734375000,
-0.0000305175781250, 0.0016784667968750, 0.0000000000000000, 0.0011596679687500,
0.0000305175781250, 0.0010986328125000, 0.0000305175781250, 0.0013732910156250,
-0.0000305175781250, 0.0000610351562500, 0.0000000000000000, 0.0002441406250000,
-0.0000305175781250, -0.0000915527343750, -0.0000610351562500, -0.0010986328125000,
-0.0000305175781250, -0.0007019042968750, 0.0000000000000000, -0.0010070800781250,
0.0000000000000000, -0.0014038085937500, 0.0000000000000000, -0.0007934570312500,
0.0000610351562500, -0.0003967285156250, 0.0000305175781250, -0.0007629394531250,
0.0000610351562500, 0.0003662109375000, 0.0000305175781250, 0.0004577636718750,
0.0000305175781250, 0.0003051757812500, -0.0000305175781250, 0.0008544921875000,
-0.0000610351562500, 0.0007934570312500, 0.0000000000000000, 0.0003051757812500,
-0.0000915527343750, 0.0005493164062500, 0.0000000000000000, 0.0001525878906250,
0.0000915527343750, -0.0005493164062500, 0.0000000000000000, -0.0001220703125000,
0.0000915527343750, -0.0006408691406250, 0.0001220703125000, -0.0008850097656250,
0.0000610351562500, -0.0004882812500000, -0.0000305175781250, -0.0003356933593750,
0.0000000000000000, -0.0005798339843750, -0.0000915527343750, 0.0003967285156250,
-0.0001525878906250, 0.0003967285156250, -0.0000305175781250, 0.0002746582031250,
-0.0000305175781250, 0.0008544921875000, -0.0000915527343750, 0.0007629394531250,
0.0001525878906250},
{-0.0000305175781250, -0.0013122558593750, -0.0000305175781250, -0.0011291503906250,
0.0000000000000000, -0.0009765625000000, 0.0000000000000000, -0.0009765625000000,
0.0000305175781250, -0.0009765625000000, 0.0000305175781250, -0.0008239746093750,
0.0000000000000000, -0.0010681152343750, -0.0000305175781250, -0.0009460449218750,
0.0000000000000000, -0.0009765625000000, 0.0000000000000000, -0.0011901855468750,
0.0000305175781250, -0.0010986328125000, 0.0000000000000000, -0.0013732910156250,
0.0000000000000000, -0.0012512207031250, 0.0000000000000000, -0.0014343261718750,
0.0000000000000000, -0.0017089843750000, 0.0000000000000000, -0.0014343261718750,
0.0000000000000000, -0.0021057128906250, -0.0000305175781250, -0.0019836425781250,
0.0000000000000000, -0.0020446777343750, 0.0000305175781250, -0.0024414062500000,
0.0000000000000000, -0.0022277832031250, 0.0000000000000000, -0.0024719238281250,
0.0000000000000000, -0.0026245117187500, 0.0000305175781250, -0.0023803710937500,
0.0000000000000000, -0.0023803710937500, 0.0000305175781250, -0.0025329589843750,
-0.0000305175781250, -0.0014648437500000, 0.0000000000000000, -0.0018920898437500,
-0.0000305175781250, -0.0013427734375000, 0.0000000000000000, -0.0002441406250000,
0.0000000000000000, -0.0010681152343750, 0.0000000000000000, 0.0007324218750000,
0.0000000000000000, 0.0007324218750000, -0.0000305175781250, 0.0008239746093750,
0.0000000000000000, 0.0019836425781250, 0.0000000000000000, 0.0015258789062500,
0.0000000000000000, 0.0016479492187500, 0.0000000000000000, 0.0020751953125000,
0.0000000000000000, 0.0013122558593750, 0.0000000000000000, 0.0008239746093750,
-0.0000305175781250, 0.0013427734375000, 0.0000000000000000, -0.0004272460937500,
0.0000000000000000, -0.0001831054687500, 0.0000000000000000, -0.0004577636718750,
0.0000000000000000, -0.0017700195312500, 0.0000000000000000, -0.0012207031250000,
0.0000000000000000, -0.0015258789062500, 0.0000000000000000, -0.0019226074218750,
0.0000000000000000, -0.0012817382812500, -0.0000305175781250, -0.0008239746093750,
0.0000000000000000, -0.0012207031250000, -0.0000305175781250, 0.0002136230468750,
-0.0000305175781250, 0.0001831054687500, -0.0000305175781250, 0.0003356933593750,
0.0000305175781250, 0.0013122558593750, 0.0000305175781250, 0.0010375976562500,
0.0000305175781250, 0.0007934570312500, 0.0000610351562500, 0.0012207031250000,
0.0000000000000000, 0.0006408691406250, -0.0000610351562500, -0.0001525878906250,
-0.0000305175781250, 0.0002746582031250, -0.0000305175781250, -0.0007019042968750,
-0.0000915527343750, -0.0008850097656250, 0.0000305175781250, -0.0006408691406250,
0.0000915527343750, -0.0009155273437500, 0.0000000000000000, -0.0009460449218750,
0.0000610351562500, -0.0001220703125000, 0.0000915527343750, -0.0003662109375000,
0.0000000000000000, -0.0000610351562500, -0.0000305175781250, 0.0006713867187500,
0.0000305175781250, 0.0003662109375000, -0.0000915527343750, 0.0005493164062500,
-0.0001220703125000, 0.0008544921875000, 0.0000000000000000, 0.0003356933593750,
0.0000000000000000, -0.0000610351562500, -0.0000915527343750, 0.0003662109375000,
0.0001220703125000, -0.0005798339843750, 0.0001525878906250, -0.0007324218750000,
0.0000610351562500, -0.0004272460937500, 0.0000305175781250, -0.0007324218750000,
0.0001831054687500, -0.0008544921875000, -0.0000915527343750, 0.0002746582031250,
-0.0001220703125000, 0.0001220703125000, -0.0000610351562500, 0.0001220703125000,
-0.0002136230468750, 0.0009460449218750, -0.0001831054687500, 0.0007629394531250,
0.0000610351562500, -0.0000305175781250, 0.0000305175781250, 0.0003356933593750,
0.0000610351562500, 0.0000610351562500, 0.0003356933593750, -0.0009155273437500,
0.0002746582031250, -0.0005493164062500, 0.0000000000000000, -0.0003051757812500,
0.0001220703125000, -0.0007019042968750, -0.0000305175781250, -0.0003356933593750,
-0.0004882812500000, 0.0007629394531250, 0.0001220703125000, -0.0003967285156250,
0.0002441406250000, -0.0001525878906250, 0.0005493164062500, -0.0007019042968750,
0.0000915527343750, -0.0001831054687500, -0.0003356933593750, 0.0006103515625000,
0.0000610351562500, 0.0002746582031250, -0.0004577636718750, 0.0001831054687500,
-0.0007629394531250, 0.0006103515625000, -0.0002746582031250, 0.0001525878906250,
-0.0000915527343750, -0.0004272460937500, -0.0004272460937500, -0.0001220703125000,
0.0006408691406250, -0.0002441406250000, 0.0007324218750000, -0.0005798339843750,
0.0003356933593750, -0.0001831054687500, 0.0007324218750000, 0.0002746582031250,
0.0009155273437500, 0.0000000000000000, -0.0003967285156250, 0.0001831054687500,
-0.0001525878906250, 0.0004272460937500, -0.0002441406250000, 0.0001525878906250,
-0.0012817382812500, -0.0001525878906250, -0.0010070800781250, 0.0000915527343750,
-0.0001525878906250, -0.0001220703125000, -0.0007019042968750, -0.0003051757812500,
-0.0001525878906250, -0.0000610351562500, 0.0010986328125000, 0.0000915527343750,
0.0005493164062500, -0.0000915527343750, 0.0007019042968750, 0.0001220703125000,
0.0012817382812500, 0.0002746582031250, 0.0004577636718750, 0.0000610351562500,
-0.0003967285156250, -0.0000305175781250, 0.0003356933593750, 0.0000915527343750,
-0.0010375976562500, -0.0001220703125000, -0.0013427734375000, -0.0001831054687500,
-0.0007019042968750, -0.0000305175781250, -0.0009460449218750, 0.0000610351562500,
-0.0012512207031250, -0.0000610351562500, 0.0003967285156250, 0.0001220703125000,
0.0001831054687500, 0.0001220703125000, 0.0002441406250000, 0.0000610351562500,
0.0013732910156250, 0.0000610351562500, 0.0009765625000000, 0.0000610351562500,
0.0006408691406250, -0.0000610351562500, 0.0011901855468750, -0.0001220703125000,
0.0004272460937500, -0.0000305175781250, -0.0004882812500000, 0.0000000000000000,
0.0002136230468750, -0.0000610351562500, -0.0011291503906250, 0.0000610351562500,
-0.0013122558593750, 0.0000915527343750, -0.0009460449218750, 0.0000610351562500,
-0.0014343261718750, 0.0000000000000000, -0.0015258789062500, 0.0000305175781250,
-0.0003662109375000, -0.0000305175781250, -0.0007934570312500, 0.0000000000000000,
-0.0003051757812500, -0.0000305175781250, 0.0008239746093750, 0.0000305175781250,
0.0002136230468750, 0.0000000000000000, 0.0013122558593750, 0.0000305175781250,
0.0014343261718750, 0.0000305175781250, 0.0012207031250000, 0.0000305175781250,
0.0016479492187500, 0.0000000000000000, 0.0016479492187500, 0.0000000000000000,
0.0008239746093750, 0.0000000000000000, 0.0012207031250000, -0.0000305175781250,
0.0006103515625000, 0.0000000000000000, -0.0003356933593750, 0.0000000000000000,
0.0003662109375000, 0.0000000000000000, -0.0012512207031250, 0.0000305175781250,
-0.0010986328125000, 0.0000305175781250, -0.0012512207031250, 0.0000305175781250,
-0.0023193359375000, 0.0000000000000000, -0.0018005371093750, 0.0000000000000000,
-0.0021362304687500, -0.0000305175781250, -0.0024719238281250, 0.0000000000000000,
-0.0019836425781250, 0.0000305175781250, -0.0018310546875000, 0.0000305175781250,
-0.0022583007812500, 0.0000610351562500, -0.0009460449218750, 0.0000000000000000,
-0.0013732910156250, 0.0000000000000000, -0.0008544921875000, 0.0000000000000000,
0.0001831054687500, 0.0000000000000000, -0.0006408691406250, -0.0000305175781250,
0.0010070800781250, 0.0000000000000000, 0.0007019042968750, 0.0000610351562500,
0.0009460449218750, 0.0000000000000000, 0.0020751953125000, 0.0000000000000000,
0.0014038085937500, 0.0000305175781250, 0.0023498535156250, -0.0000305175781250,
0.0022583007812500, 0.0000000000000000, 0.0022583007812500, 0.0000000000000000,
0.0027770996093750, 0.0000000000000000, 0.0024414062500000, 0.0000000000000000,
0.0028076171875000, 0.0000305175781250, 0.0027160644531250, 0.0000305175781250,
0.0026855468750000, 0.0000000000000000, 0.0028381347656250, 0.0000305175781250,
0.0026855468750000, -0.0000305175781250, 0.0027465820312500, -0.0000305175781250,
0.0027160644531250, 0.0000000000000000, 0.0026550292968750, 0.0000305175781250,
0.0027160644531250, 0.0000000000000000, 0.0026245117187500, 0.0000000000000000,
0.0025024414062500, 0.0000000000000000, 0.0024719238281250, 0.0000000000000000,
0.0023193359375000, -0.0000305175781250, 0.0021667480468750, -0.0000305175781250,
0.0021057128906250, 0.0000000000000000, 0.0016784667968750, 0.0000305175781250,
0.0017089843750000, -0.0000305175781250, 0.0014038085937500, -0.0000305175781250,
0.0009460449218750, 0.0000000000000000, 0.0010986328125000, -0.0000305175781250,
0.0002136230468750, 0.0000000000000000, 0.0003051757812500, 0.0000000000000000,
-0.0000610351562500, 0.0000305175781250, -0.0007934570312500, 0.0000000000000000,
-0.0005493164062500, 0.0000000000000000, -0.0013427734375000, 0.0000305175781250,
-0.0014343261718750, 0.0000000000000000, -0.0014343261718750, 0.0000000000000000,
-0.0018920898437500, -0.0000305175781250, -0.0018005371093750, 0.0000000000000000,
-0.0015869140625000, -0.0000305175781250, -0.0018005371093750, 0.0000000000000000,
-0.0013732910156250, 0.0000305175781250, -0.0008544921875000, 0.0000305175781250,
-0.0011596679687500, 0.0000000000000000, 0.0000000000000000, 0.0000305175781250,
-0.0000610351562500, 0.0000000000000000, 0.0002136230468750, -0.0000305175781250,
0.0010070800781250, 0.0000000000000000, 0.0007019042968750, 0.0000000000000000,
0.0011291503906250, 0.0000305175781250, 0.0013732910156250, 0.0000000000000000,
0.0009765625000000, -0.0000305175781250, 0.0008544921875000, 0.0000305175781250,
0.0010375976562500, 0.0000305175781250, -0.0000305175781250, -0.0000305175781250,
0.0000915527343750, 0.0000305175781250, -0.0001831054687500, 0.0000000000000000,
-0.0010070800781250, -0.0000305175781250, -0.0006713867187500, -0.0000305175781250,
-0.0008239746093750, 0.0000000000000000, -0.0011596679687500, -0.0000305175781250,
-0.0007019042968750, 0.0000305175781250, -0.0002746582031250, 0.0000305175781250,
-0.0005798339843750, 0.0000305175781250, 0.0003356933593750, 0.0000000000000000,
0.0004272460937500, 0.0000000000000000, 0.0003051757812500, 0.0000305175781250,
0.0007019042968750, -0.0000610351562500, 0.0006713867187500, -0.0000610351562500,
0.0000915527343750, 0.0000000000000000, 0.0002746582031250, 0.0000305175781250,
0.0000915527343750, 0.0000000000000000, -0.0006103515625000, 0.0000610351562500,
-0.0003051757812500, 0.0000610351562500, -0.0002746582031250, -0.0000305175781250,
-0.0005798339843750, 0.0000305175781250, -0.0002136230468750, 0.0000000000000000,
0.0002136230468750, -0.0000610351562500, -0.0000915527343750, 0.0000000000000000,
0.0003051757812500, 0.0000000000000000, 0.0005187988281250, -0.0000610351562500,
0.0001525878906250, 0.0000000000000000, -0.0000305175781250, 0.0001220703125000,
0.0001831054687500, 0.0000610351562500, -0.0002746582031250, 0.0000610351562500,
-0.0003967285156250, 0.0000915527343750, -0.0001831054687500, 0.0000305175781250,
-0.0002136230468750, -0.0000915527343750, -0.0003051757812500, -0.0000305175781250,
0.0001831054687500, -0.0000305175781250, 0.0002136230468750, -0.0000915527343750,
0.0000915527343750, -0.0000305175781250, 0.0002441406250000, 0.0001220703125000,
0.0003051757812500, 0.0000305175781250, -0.0001220703125000, 0.0000000000000000,
-0.0000915527343750, 0.0000610351562500, 0.0000000000000000, 0.0000305175781250,
-0.0001525878906250, -0.0001220703125000, -0.0001525878906250, -0.0001220703125000,
0.0001220703125000, 0.0000000000000000, 0.0000915527343750, -0.0000610351562500,
0.0000305175781250},
{-0.0020446777343750, 0.0000305175781250, -0.0018615722656250, 0.0000000000000000,
-0.0016479492187500, -0.0000305175781250, -0.0015563964843750, 0.0000305175781250,
-0.0011596679687500, 0.0000000000000000, -0.0011901855468750, 0.0000000000000000,
-0.0008239746093750, 0.0000000000000000, -0.0003967285156250, 0.0000000000000000,
-0.0005187988281250, 0.0000000000000000, 0.0003662109375000, -0.0000305175781250,
0.0003051757812500, 0.0000000000000000, 0.0005798339843750, 0.0000000000000000,
0.0012207031250000, 0.0000305175781250, 0.0010070800781250, 0.0000000000000000,
0.0015869140625000, 0.0000305175781250, 0.0016784667968750, 0.0000000000000000,
0.0015258789062500, 0.0000305175781250, 0.0017089843750000, 0.0000000000000000,
0.0018005371093750, -0.0000305175781250, 0.0012207031250000, -0.0000305175781250,
0.0014038085937500, 0.0000305175781250, 0.0009460449218750, 0.0000305175781250,
0.0002746582031250, 0.0000000000000000, 0.0006103515625000, 0.0000000000000000,
-0.0005493164062500, -0.0000305175781250, -0.0005187988281250, 0.0000000000000000,
-0.0006713867187500, -0.0000610351562500, -0.0014038085937500, 0.0000000000000000,
-0.0011901855468750, 0.0000305175781250, -0.0011901855468750, 0.0000305175781250,
-0.0014953613281250, 0.0000000000000000, -0.0010375976562500, 0.0000000000000000,
-0.0006103515625000, -0.0000305175781250, -0.0009155273437500, 0.0000000000000000,
0.0002441406250000, 0.0000000000000000, 0.0002746582031250, -0.0000305175781250,
0.0003051757812500, 0.0000000000000000, 0.0010986328125000, 0.0000305175781250,
0.0008544921875000, 0.0000305175781250, 0.0006713867187500, 0.0000305175781250,
0.0009460449218750, 0.0000000000000000, 0.0004882812500000, -0.0000305175781250,
-0.0001220703125000, 0.0000000000000000, 0.0001831054687500, 0.0000000000000000,
-0.0006103515625000, 0.0000000000000000, -0.0007934570312500, -0.0000610351562500,
-0.0005187988281250, 0.0000305175781250, -0.0006713867187500, 0.0000610351562500,
-0.0007629394531250, 0.0000000000000000, 0.0000305175781250, 0.0000610351562500,
-0.0000915527343750, 0.0000610351562500, 0.0000000000000000, 0.0000000000000000,
0.0006408691406250, -0.0000610351562500, 0.0004577636718750, -0.0000305175781250,
0.0001831054687500, 0.0000000000000000, 0.0004577636718750, -0.0000610351562500,
0.0001525878906250, 0.0000000000000000, -0.0004272460937500, 0.0000610351562500,
-0.0001220703125000, 0.0000305175781250, -0.0003051757812500, 0.0000610351562500,
-0.0005493164062500, 0.0000610351562500, -0.0001831054687500, 0.0000305175781250,
0.0001525878906250, -0.0000915527343750, -0.0001220703125000, -0.0000305175781250,
0.0002746582031250, -0.0000305175781250, 0.0004882812500000, -0.0001220703125000,
0.0001220703125000, 0.0000000000000000, 0.0000000000000000, 0.0001220703125000,
0.0002441406250000, -0.0000305175781250, -0.0002136230468750, 0.0000305175781250,
-0.0003662109375000, 0.0001220703125000, -0.0001220703125000, 0.0000000000000000,
-0.0001220703125000, -0.0000915527343750, -0.0002441406250000, -0.0000305175781250,
0.0001525878906250, -0.0000610351562500, 0.0001831054687500, -0.0000915527343750,
0.0000610351562500, -0.0000305175781250, 0.0000915527343750, 0.0000915527343750,
0.0000610351562500, 0.0000610351562500, -0.0001525878906250, 0.0000305175781250,
-0.0001525878906250, 0.0000610351562500, 0.0000000000000000, 0.0000000000000000,
-0.0000305175781250, -0.0001220703125000, -0.0001831054687500, -0.0000305175781250,
0.0001220703125000, 0.0000000000000000, 0.0001525878906250, -0.0001220703125000,
0.0000000000000000, -0.0000305175781250, 0.0000610351562500, 0.0001220703125000,
0.0001220703125000, 0.0000610351562500, -0.0000915527343750, 0.0000305175781250,
-0.0001525878906250, 0.0001220703125000, -0.0000305175781250, 0.0000000000000000,
-0.0000305175781250, -0.0002136230468750, -0.0001220703125000, -0.0001220703125000,
0.0001220703125000, -0.0000915527343750, 0.0001525878906250, -0.0001831054687500,
0.0000610351562500, 0.0000000000000000, 0.0000305175781250, 0.0002746582031250,
0.0001220703125000, 0.0000610351562500, -0.0000915527343750, 0.0001220703125000,
-0.0001220703125000, 0.0003356933593750, -0.0000305175781250, 0.0000305175781250,
-0.0000610351562500, -0.0003662109375000, -0.0000915527343750, -0.0000915527343750,
0.0000915527343750, -0.0002746582031250, 0.0001220703125000, -0.0005493164062500,
0.0000000000000000, -0.0001831054687500, 0.0000915527343750, 0.0000915527343750,
0.0001220703125000, -0.0001525878906250, -0.0000610351562500, 0.0003356933593750,
-0.0000610351562500, 0.0005187988281250, 0.0000000000000000, 0.0002136230468750,
-0.0000610351562500, 0.0002746582031250, -0.0000915527343750, 0.0004272460937500,
0.0000915527343750, -0.0003662109375000, 0.0000305175781250, -0.0003356933593750,
0.0000000000000000, -0.0002136230468750, 0.0000610351562500, -0.0007019042968750,
0.0000915527343750, -0.0006713867187500, 0.0000000000000000, -0.0001220703125000,
-0.0000305175781250, -0.0003356933593750, 0.0000000000000000, 0.0000000000000000,
-0.0000305175781250, 0.0006408691406250, -0.0000305175781250, 0.0003051757812500,
0.0000000000000000, 0.0005493164062500, 0.0000000000000000, 0.0007934570312500,
0.0000000000000000, 0.0003356933593750, 0.0000305175781250, -0.0000305175781250,
0.0000305175781250, 0.0002441406250000, -0.0000305175781250, -0.0006408691406250,
0.0000000000000000, -0.0007629394531250, -0.0000305175781250, -0.0007019042968750,
-0.0000305175781250, -0.0010986328125000, 0.0000000000000000, -0.0010070800781250,
-0.0000305175781250, -0.0004882812500000, 0.0000000000000000, -0.0007324218750000,
0.0000000000000000, -0.0002746582031250, 0.0000305175781250, 0.0003662109375000,
0.0000305175781250, 0.0000610351562500, 0.0000305175781250, 0.0008544921875000,
0.0000305175781250, 0.0010070800781250, 0.0000000000000000, 0.0009155273437500,
-0.0000305175781250, 0.0012512207031250, 0.0000000000000000, 0.0012207031250000,
0.0000305175781250, 0.0008544921875000, 0.0000305175781250, 0.0010375976562500,
0.0000305175781250, 0.0006713867187500, 0.0000000000000000, 0.0001525878906250,
0.0000000000000000, 0.0003967285156250, 0.0000000000000000, -0.0004577636718750,
0.0000000000000000, -0.0004577636718750, 0.0000000000000000, -0.0007324218750000,
-0.0000305175781250, -0.0013122558593750, 0.0000305175781250, -0.0011596679687500,
0.0000000000000000, -0.0017089843750000, 0.0000305175781250, -0.0017700195312500,
0.0000610351562500, -0.0018310546875000, 0.0000305175781250, -0.0021057128906250,
0.0000305175781250, -0.0019836425781250, -0.0000305175781250, -0.0020751953125000,
0.0000305175781250, -0.0020446777343750, 0.0000305175781250, -0.0020141601562500,
0.0000000000000000, -0.0020751953125000, -0.0000305175781250, -0.0020141601562500,
0.0000000000000000, -0.0019836425781250, -0.0000305175781250, -0.0018615722656250,
0.0000000000000000, -0.0018615722656250, 0.0000000000000000, -0.0018615722656250,
0.0000305175781250, -0.0017700195312500, 0.0000000000000000, -0.0019531250000000,
0.0000305175781250, -0.0018920898437500, 0.0000000000000000, -0.0018920898437500,
-0.0000305175781250, -0.0020751953125000, 0.0000000000000000, -0.0019836425781250,
0.0000000000000000, -0.0021972656250000, 0.0000305175781250, -0.0021057128906250,
0.0000000000000000, -0.0021972656250000, -0.0000610351562500, -0.0024108886718750,
0.0000305175781250, -0.0022277832031250, 0.0000305175781250, -0.0024108886718750,
0.0000000000000000, -0.0025024414062500, 0.0000000000000000, -0.0024414062500000,
0.0000305175781250, -0.0024719238281250, 0.0000000000000000, -0.0025024414062500,
0.0000000000000000, -0.0020141601562500, 0.0000000000000000, -0.0023498535156250,
-0.0000305175781250, -0.0018310546875000, 0.0000000000000000, -0.0012817382812500,
0.0000000000000000, -0.0018005371093750, -0.0000305175781250, -0.0002136230468750,
0.0000000000000000, -0.0005798339843750, 0.0000305175781250, -0.0001220703125000,
0.0000000000000000, 0.0011596679687500, 0.0000000000000000, 0.0004272460937500,
-0.0000305175781250, 0.0016174316406250, -0.0000305175781250, 0.0018615722656250,
0.0000000000000000, 0.0014648437500000, -0.0000305175781250, 0.0018920898437500,
0.0000000000000000, 0.0019531250000000, 0.0000000000000000, 0.0008544921875000,
0.0000305175781250, 0.0013427734375000, 0.0000000000000000, 0.0006408691406250,
0.0000000000000000, -0.0006408691406250, 0.0000305175781250, 0.0001220703125000,
-0.0000305175781250, -0.0014038085937500, -0.0000305175781250, -0.0014648437500000,
0.0000000000000000, -0.0012512207031250, 0.0000305175781250, -0.0019226074218750,
0.0000000000000000, -0.0018310546875000, 0.0000305175781250, -0.0010070800781250,
0.0000305175781250, -0.0014038085937500, 0.0000000000000000, -0.0007934570312500,
0.0000000000000000, 0.0003051757812500, 0.0000305175781250, -0.0002441406250000,
-0.0000305175781250, 0.0009765625000000, -0.0000305175781250, 0.0012207031250000,
0.0000000000000000, 0.0009155273437500, 0.0000305175781250, 0.0012512207031250,
-0.0000305175781250, 0.0013122558593750, 0.0000305175781250, 0.0002136230468750,
0.0000610351562500, 0.0005493164062500, 0.0000305175781250, 0.0001220703125000,
0.0000000000000000, -0.0010070800781250, 0.0000610351562500, -0.0005493164062500,
-0.0000610351562500, -0.0009155273437500, -0.0000915527343750, -0.0012817382812500,
-0.0000305175781250, -0.0007629394531250, 0.0000000000000000, -0.0003662109375000,
-0.0000915527343750, -0.0007629394531250, 0.0000915527343750, 0.0003356933593750,
0.0000915527343750, 0.0003356933593750, 0.0000305175781250, 0.0002746582031250,
0.0000610351562500, 0.0008850097656250, 0.0000915527343750, 0.0007629394531250,
-0.0000915527343750, 0.0002746582031250, -0.0000915527343750, 0.0006103515625000,
-0.0000305175781250, 0.0001220703125000, -0.0001220703125000, -0.0006713867187500,
-0.0001525878906250, -0.0002746582031250, 0.0000915527343750, -0.0006713867187500,
0.0000305175781250, -0.0010375976562500, 0.0000305175781250, -0.0004882812500000,
0.0001831054687500, -0.0001220703125000, 0.0001831054687500, -0.0005187988281250,
-0.0000305175781250, 0.0006408691406250, 0.0000305175781250, 0.0008239746093750,
-0.0000305175781250, 0.0003356933593750, -0.0002441406250000, 0.0006103515625000,
-0.0001831054687500, 0.0008544921875000, -0.0000610351562500, -0.0004882812500000,
-0.0001525878906250, -0.0004272460937500, 0.0000000000000000, -0.0002441406250000,
0.0003356933593750, -0.0009155273437500, 0.0001220703125000, -0.0009460449218750,
0.0001831054687500, 0.0001220703125000, 0.0003662109375000, -0.0000915527343750,
0.0001525878906250, -0.0000915527343750, -0.0003051757812500, 0.0010070800781250,
-0.0002441406250000, -0.0008850097656250, 0.0004882812500000, 0.0003051757812500,
0.0004882812500000, -0.0001831054687500, 0.0001525878906250, -0.0000305175781250,
0.0001220703125000, 0.0007934570312500, 0.0003967285156250, 0.0006713867187500,
-0.0005493164062500, -0.0001220703125000, -0.0005493164062500, 0.0001525878906250,
-0.0003051757812500, 0.0000610351562500, -0.0007629394531250, -0.0007324218750000,
-0.0007934570312500, -0.0005187988281250, 0.0002746582031250, -0.0000610351562500,
0.0000305175781250, -0.0002746582031250, 0.0001831054687500, -0.0000915527343750,
0.0011291503906250, 0.0005798339843750, 0.0008239746093750, 0.0003356933593750,
0.0001831054687500, 0.0000915527343750, 0.0007324218750000, 0.0003662109375000,
0.0000915527343750, 0.0001525878906250, -0.0012207031250000, -0.0003662109375000,
-0.0004882812500000},
{0.0000000000000000, -0.0015869140625000, 0.0000000000000000, -0.0018615722656250,
-0.0000305175781250, -0.0004577636718750, 0.0000000000000000, -0.0008239746093750,
0.0000305175781250, -0.0002136230468750, 0.0000305175781250, 0.0010986328125000,
0.0000000000000000, 0.0004272460937500, 0.0000305175781250, 0.0014953613281250,
0.0000305175781250, 0.0017700195312500, 0.0000000000000000, 0.0012817382812500,
0.0000000000000000, 0.0015563964843750, 0.0000305175781250, 0.0017089843750000,
-0.0000305175781250, 0.0003662109375000, -0.0000305175781250, 0.0007629394531250,
0.0000000000000000, 0.0002441406250000, 0.0000000000000000, -0.0009765625000000,
0.0000000000000000, -0.0004577636718750, 0.0000305175781250, -0.0012817382812500,
0.0000305175781250, -0.0016174316406250, 0.0000305175781250, -0.0011596679687500,
0.0000000000000000, -0.0010986328125000, 0.0000610351562500, -0.0013427734375000,
-0.0000305175781250, 0.0000305175781250, -0.0000610351562500, -0.0001525878906250,
-0.0000305175781250, 0.0000610351562500, -0.0000305175781250, 0.0011291503906250,
-0.0000610351562500, 0.0007934570312500, 0.0000915527343750, 0.0006713867187500,
0.0000610351562500, 0.0010986328125000, 0.0000305175781250, 0.0004882812500000,
0.0000305175781250, -0.0001525878906250, 0.0000610351562500, 0.0003356933593750,
-0.0000610351562500, -0.0006408691406250, -0.0000610351562500, -0.0007629394531250,
-0.0000305175781250, -0.0005798339843750, -0.0000915527343750, -0.0009765625000000,
-0.0000915527343750, -0.0009155273437500, 0.0000610351562500, -0.0001525878906250,
0.0000000000000000, -0.0004272460937500, 0.0000305175781250, -0.0000610351562500,
0.0001831054687500, 0.0008239746093750, 0.0001220703125000, 0.0004272460937500,
-0.0000610351562500, 0.0005187988281250, 0.0000000000000000, 0.0009765625000000,
-0.0000305175781250, 0.0003051757812500, -0.0002441406250000, -0.0003967285156250,
-0.0001831054687500, 0.0001831054687500, -0.0000305175781250, -0.0007629394531250,
-0.0001525878906250, -0.0011901855468750, 0.0000000000000000, -0.0004882812500000,
0.0002746582031250, -0.0003051757812500, 0.0000915527343750, -0.0007629394531250,
0.0001525878906250, 0.0006103515625000, 0.0002746582031250, 0.0007629394531250,
0.0000305175781250, 0.0003051757812500, -0.0002441406250000, 0.0007324218750000,
-0.0000610351562500, 0.0008850097656250, -0.0002746582031250, -0.0003967285156250,
-0.0004882812500000, -0.0003051757812500, -0.0002136230468750, -0.0001525878906250,
0.0001525878906250, -0.0009460449218750, 0.0003662109375000, 0.0008850097656250,
-0.0005493164062500, -0.0005187988281250, -0.0003662109375000, -0.0001525878906250,
-0.0001525878906250, -0.0000915527343750, -0.0004272460937500, -0.0007019042968750,
-0.0006103515625000, -0.0007324218750000, 0.0003662109375000, 0.0002136230468750,
0.0002746582031250, 0.0001220703125000, 0.0002441406250000, 0.0000610351562500,
0.0009765625000000, 0.0006103515625000, 0.0007934570312500, 0.0006408691406250,
-0.0000915527343750, -0.0001220703125000, 0.0003662109375000, 0.0000610351562500,
-0.0000610351562500, 0.0000610351562500, -0.0012817382812500, -0.0005798339843750,
-0.0007019042968750, -0.0004882812500000, -0.0005187988281250, 0.0000000000000000,
-0.0011901855468750, -0.0001525878906250, -0.0003662109375000, -0.0000610351562500,
0.0007934570312500, 0.0004272460937500, 0.0000000000000000, 0.0003051757812500,
0.0008850097656250, 0.0000000000000000, 0.0014953613281250, 0.0001831054687500,
0.0005187988281250, 0.0000610351562500, 0.0000305175781250, -0.0003356933593750,
0.0007324218750000, -0.0001831054687500, -0.0009765625000000, -0.0000305175781250,
-0.0011596679687500, -0.0001525878906250, -0.0006713867187500, -0.0000610351562500,
-0.0013122558593750, 0.0002441406250000, -0.0014038085937500, 0.0001525878906250,
0.0002441406250000, 0.0000305175781250, -0.0001831054687500, 0.0001220703125000,
0.0000915527343750, 0.0000305175781250, 0.0014953613281250, -0.0001525878906250,
0.0009765625000000, -0.0001220703125000, 0.0006103515625000, -0.0000305175781250,
0.0012512207031250, -0.0001220703125000, 0.0004577636718750, -0.0000610351562500,
-0.0006103515625000, 0.0001220703125000, 0.0001525878906250, 0.0000610351562500,
-0.0011291503906250, 0.0000000000000000, -0.0014038085937500, 0.0000915527343750,
-0.0009155273437500, 0.0000305175781250, -0.0011901855468750, -0.0001220703125000,
-0.0014343261718750, 0.0000000000000000, 0.0000610351562500, 0.0000000000000000,
-0.0003356933593750, -0.0000610351562500, 0.0000305175781250, 0.0000000000000000,
0.0014038085937500, 0.0000915527343750, 0.0007629394531250, 0.0000610351562500,
0.0011291503906250, -0.0000305175781250, 0.0016174316406250, 0.0000305175781250,
0.0010375976562500, 0.0000305175781250, 0.0007324218750000, -0.0000610351562500,
0.0011596679687500, -0.0000610351562500, -0.0003051757812500, 0.0000000000000000,
-0.0000610351562500, -0.0000305175781250, -0.0003967285156250, 0.0000000000000000,
-0.0014648437500000, 0.0000915527343750, -0.0009460449218750, 0.0000610351562500,
-0.0016479492187500, 0.0000000000000000, -0.0019226074218750, 0.0000000000000000,
-0.0014648437500000, -0.0000305175781250, -0.0014953613281250, -0.0000305175781250,
-0.0017700195312500, -0.0000305175781250, -0.0005187988281250, 0.0000305175781250,
-0.0009765625000000, 0.0000000000000000, -0.0003967285156250, 0.0000305175781250,
0.0007324218750000, 0.0000305175781250, -0.0000915527343750, 0.0000305175781250,
0.0014648437500000, -0.0000305175781250, 0.0013732910156250, 0.0000000000000000,
0.0014038085937500, 0.0000000000000000, 0.0022583007812500, 0.0000000000000000,
0.0019531250000000, 0.0000305175781250, 0.0020751953125000, 0.0000305175781250,
0.0023498535156250, 0.0000305175781250, 0.0019836425781250, 0.0000305175781250,
0.0018005371093750, 0.0000000000000000, 0.0021362304687500, 0.0000000000000000,
0.0011596679687500, -0.0000305175781250, 0.0014953613281250, 0.0000305175781250,
0.0011901855468750, 0.0000305175781250, 0.0003356933593750, 0.0000000000000000,
0.0009155273437500, 0.0000305175781250, -0.0001525878906250, 0.0000305175781250,
0.0000610351562500, 0.0000305175781250, -0.0000915527343750, 0.0000305175781250,
-0.0007629394531250, 0.0000000000000000, -0.0001831054687500, 0.0000000000000000,
-0.0008850097656250, -0.0000305175781250, -0.0007629394531250, -0.0000305175781250,
-0.0007324218750000, 0.0000305175781250, -0.0011596679687500, 0.0000305175781250,
-0.0007324218750000, 0.0000305175781250, -0.0011596679687500, 0.0000000000000000,
-0.0010375976562500, 0.0000000000000000, -0.0009765625000000, 0.0000305175781250,
-0.0011596679687500, 0.0000305175781250, -0.0009155273437500, 0.0000000000000000,
-0.0008544921875000, 0.0000000000000000, -0.0008544921875000, 0.0000000000000000,
-0.0006103515625000, 0.0000000000000000, -0.0004272460937500, 0.0000000000000000,
-0.0002441406250000, -0.0000305175781250, 0.0000915527343750, 0.0000000000000000,
0.0000610351562500, 0.0000000000000000, 0.0004272460937500, 0.0000305175781250,
0.0007324218750000, 0.0000000000000000, 0.0007324218750000, 0.0000000000000000,
0.0012817382812500, 0.0000305175781250, 0.0013122558593750, 0.0000305175781250,
0.0013427734375000, 0.0000000000000000, 0.0017395019531250, 0.0000000000000000,
0.0016784667968750, 0.0000000000000000, 0.0016784667968750, -0.0000305175781250,
0.0018310546875000, 0.0000000000000000, 0.0014953613281250, 0.0000305175781250,
0.0012512207031250, -0.0000610351562500, 0.0014648437500000, -0.0000610351562500,
0.0004577636718750, 0.0000000000000000, 0.0005798339843750, 0.0000000000000000,
0.0002441406250000, 0.0000000000000000, -0.0005798339843750, 0.0000305175781250,
-0.0002746582031250, 0.0000305175781250, -0.0010986328125000, 0.0000305175781250,
-0.0012207031250000, 0.0000000000000000, -0.0011291503906250, 0.0000000000000000,
-0.0014343261718750, 0.0000610351562500, -0.0014038085937500, 0.0000000000000000,
-0.0007934570312500, 0.0000305175781250, -0.0010070800781250, 0.0000305175781250,
-0.0005493164062500, 0.0000000000000000, 0.0002441406250000, 0.0000000000000000,
-0.0001831054687500, 0.0000000000000000, 0.0007629394531250, -0.0000305175781250,
0.0009460449218750, 0.0000000000000000, 0.0007019042968750, 0.0000305175781250,
0.0009765625000000, 0.0000305175781250, 0.0010070800781250, 0.0000000000000000,
0.0001831054687500, 0.0000305175781250, 0.0003967285156250, 0.0000305175781250,
0.0000305175781250, -0.0000305175781250, -0.0007324218750000, -0.0000305175781250,
-0.0004577636718750, 0.0000000000000000, -0.0007019042968750, -0.0000305175781250,
-0.0010070800781250, -0.0000610351562500, -0.0005798339843750, 0.0000000000000000,
-0.0002441406250000, 0.0000305175781250, -0.0005798339843750, -0.0000305175781250,
0.0003967285156250, 0.0000915527343750, 0.0005187988281250, 0.0000915527343750,
0.0002441406250000, 0.0000000000000000, 0.0005798339843750, -0.0000305175781250,
0.0006103515625000, 0.0000305175781250, -0.0000915527343750, -0.0000915527343750,
0.0000000000000000, -0.0000915527343750, -0.0000610351562500, 0.0000000000000000,
-0.0006408691406250, 0.0000305175781250, -0.0004577636718750, -0.0000305175781250,
-0.0001220703125000, 0.0000305175781250, -0.0003662109375000, 0.0000915527343750,
-0.0000915527343750, 0.0000305175781250, 0.0004272460937500, 0.0000000000000000,
0.0001831054687500, 0.0000610351562500, 0.0001525878906250, -0.0000915527343750,
0.0004272460937500, -0.0001220703125000, 0.0001220703125000, -0.0000305175781250,
-0.0003051757812500, 0.0000000000000000, -0.0000305175781250, -0.0000915527343750,
-0.0002441406250000, 0.0000610351562500, -0.0004882812500000, 0.0001525878906250,
-0.0002136230468750, 0.0000305175781250, 0.0000915527343750, 0.0000000000000000,
-0.0000915527343750, 0.0000610351562500, 0.0001525878906250, -0.0000915527343750,
0.0003051757812500, -0.0001220703125000, 0.0001220703125000, 0.0000000000000000,
-0.0000915527343750, 0.0000305175781250, -0.0000915527343750, 0.0000000000000000,
-0.0000915527343750, 0.0000610351562500, -0.0002441406250000, 0.0001220703125000,
-0.0000915527343750, 0.0000000000000000, 0.0000915527343750, -0.0000305175781250,
-0.0000610351562500, -0.0000305175781250, 0.0000915527343750, -0.0000915527343750,
0.0002136230468750, -0.0001525878906250, 0.0000305175781250, 0.0000000000000000,
-0.0001220703125000, 0.0000610351562500, 0.0000610351562500, -0.0000305175781250,
-0.0000915527343750, 0.0000915527343750, -0.0002441406250000, 0.0001831054687500,
-0.0000610351562500, 0.0000000000000000, 0.0001220703125000, -0.0001220703125000,
-0.0000305175781250, -0.0000305175781250, 0.0000915527343750, -0.0002136230468750,
0.0002136230468750, -0.0003051757812500, 0.0000610351562500, -0.0000610351562500,
-0.0000915527343750, 0.0001220703125000, 0.0000305175781250, -0.0000915527343750,
-0.0000915527343750, 0.0002441406250000, -0.0001831054687500, 0.0004272460937500,
-0.0000610351562500, 0.0000915527343750, 0.0000610351562500, -0.0000610351562500,
-0.0000610351562500, 0.0001831054687500, 0.0000610351562500, -0.0003662109375000,
0.0001831054687500, -0.0004882812500000, 0.0000610351562500, -0.0002746582031250,
-0.0000305175781250, -0.0003356933593750, 0.0000305175781250, -0.0004577636718750,
-0.0000610351562500, 0.0002746582031250, -0.0001220703125000, 0.0002136230468750,
-0.0000305175781250, 0.0001525878906250, 0.0000305175781250, 0.0005798339843750,
-0.0000610351562500, 0.0005187988281250, 0.0000610351562500, -0.0000305175781250,
0.0000915527343750},
{-0.0009765625000000, 0.0000305175781250, -0.0012512207031250, 0.0000305175781250,
-0.0008544921875000, 0.0000000000000000, -0.0009155273437500, 0.0000000000000000,
-0.0010986328125000, 0.0000305175781250, -0.0000915527343750, -0.0000305175781250,
-0.0001831054687500, -0.0000305175781250, 0.0000305175781250, 0.0000000000000000,
0.0008239746093750, 0.0000000000000000, 0.0005493164062500, -0.0000610351562500,
0.0005798339843750, 0.0000610351562500, 0.0008544921875000, 0.0000610351562500,
0.0003662109375000, 0.0000000000000000, -0.0001525878906250, 0.0000305175781250,
0.0002136230468750, 0.0000000000000000, -0.0005187988281250, 0.0000000000000000,
-0.0007324218750000, -0.0000305175781250, -0.0004577636718750, 0.0000000000000000,
-0.0005493164062500, -0.0000305175781250, -0.0007019042968750, -0.0000610351562500,
0.0001525878906250, 0.0000305175781250, 0.0001525878906250, 0.0000915527343750,
0.0000000000000000, 0.0000305175781250, 0.0004882812500000, 0.0000305175781250,
0.0004577636718750, 0.0000915527343750, -0.0000610351562500, -0.0000915527343750,
0.0000915527343750, -0.0000915527343750, -0.0000305175781250, -0.0000305175781250,
-0.0006103515625000, -0.0000305175781250, -0.0004272460937500, -0.0000915527343750,
-0.0001525878906250, 0.0000915527343750, -0.0003356933593750, 0.0001220703125000,
-0.0001525878906250, 0.0000305175781250, 0.0003662109375000, 0.0000610351562500,
0.0001220703125000, 0.0001525878906250, 0.0001525878906250, -0.0000610351562500,
0.0003662109375000, -0.0001220703125000, 0.0000915527343750, 0.0000000000000000,
-0.0002746582031250, -0.0000305175781250, -0.0000305175781250, -0.0001220703125000,
-0.0001831054687500, 0.0000610351562500, -0.0003967285156250, 0.0000915527343750,
-0.0001525878906250, 0.0000305175781250, 0.0001831054687500, -0.0000305175781250,
0.0001220703125000, -0.0000305175781250, 0.0000000000000000, -0.0000915527343750,
0.0001831054687500, -0.0001525878906250, 0.0000610351562500, -0.0000610351562500,
-0.0002136230468750, -0.0000305175781250, 0.0000000000000000, -0.0000610351562500,
-0.0000610351562500, 0.0000915527343750, -0.0002441406250000, 0.0001525878906250,
-0.0000610351562500, 0.0000000000000000, 0.0001831054687500, -0.0000305175781250,
0.0000305175781250, 0.0000610351562500, 0.0000610351562500, -0.0001220703125000,
0.0001831054687500, -0.0002136230468750, 0.0000305175781250, -0.0000610351562500,
-0.0001831054687500, 0.0000000000000000, -0.0000305175781250, -0.0001220703125000,
-0.0000610351562500, 0.0001525878906250, -0.0001831054687500, 0.0002746582031250,
-0.0000305175781250, 0.0000610351562500, 0.0002136230468750, 0.0000000000000000,
0.0000000000000000, 0.0001220703125000, 0.0000305175781250, -0.0003356933593750,
0.0001831054687500, -0.0003967285156250, 0.0000610351562500, -0.0002136230468750,
-0.0001525878906250, -0.0002441406250000, -0.0000305175781250, -0.0003967285156250,
-0.0000610351562500, 0.0003051757812500, -0.0001525878906250, 0.0002441406250000,
-0.0000305175781250, 0.0001220703125000, 0.0000915527343750, 0.0004882812500000,
0.0000000000000000, 0.0004882812500000, 0.0000610351562500, -0.0002136230468750,
0.0001525878906250, -0.0000915527343750, 0.0000305175781250, -0.0001220703125000,
-0.0000610351562500, -0.0007019042968750, 0.0000000000000000, -0.0005187988281250,
-0.0000610351562500, -0.0002441406250000, -0.0000915527343750, -0.0005493164062500,
-0.0000305175781250, -0.0001831054687500, 0.0000305175781250, 0.0004272460937500,
0.0000000000000000, 0.0000610351562500, 0.0000305175781250, 0.0004272460937500,
0.0000915527343750, 0.0007019042968750, 0.0000000000000000, 0.0002746582031250,
0.0000000000000000, -0.0000610351562500, 0.0000610351562500, 0.0003051757812500,
-0.0000305175781250, -0.0005187988281250, -0.0000610351562500, -0.0006408691406250,
0.0000000000000000, -0.0005187988281250, 0.0000305175781250, -0.0008239746093750,
-0.0000305175781250, -0.0008239746093750, 0.0000305175781250, -0.0001831054687500,
0.0000610351562500, -0.0003051757812500, 0.0000305175781250, 0.0000000000000000,
0.0000305175781250, 0.0006713867187500, 0.0000305175781250, 0.0003662109375000,
-0.0000305175781250, 0.0007324218750000, -0.0000305175781250, 0.0009765625000000,
0.0000000000000000, 0.0006408691406250, 0.0000000000000000, 0.0004882812500000,
-0.0000305175781250, 0.0006408691406250, 0.0000000000000000, -0.0001220703125000,
0.0000000000000000, -0.0000610351562500, -0.0000305175781250, -0.0002441406250000,
0.0000000000000000, -0.0007629394531250, 0.0000305175781250, -0.0006103515625000,
-0.0000305175781250, -0.0009155273437500, -0.0000305175781250, -0.0010681152343750,
0.0000000000000000, -0.0009460449218750, -0.0000305175781250, -0.0009460449218750,
0.0000000000000000, -0.0009460449218750, 0.0000610351562500, -0.0006103515625000,
0.0000000000000000, -0.0007019042968750, 0.0000000000000000, -0.0004577636718750,
0.0000000000000000, -0.0000305175781250, 0.0000305175781250, -0.0001831054687500,
0.0000000000000000, 0.0003967285156250, -0.0000305175781250, 0.0004577636718750,
0.0000000000000000, 0.0005187988281250, 0.0000000000000000, 0.0008850097656250,
0.0000000000000000, 0.0007934570312500, 0.0000000000000000, 0.0010070800781250,
0.0000000000000000, 0.0010375976562500, 0.0000305175781250, 0.0010375976562500,
0.0000305175781250, 0.0010681152343750, 0.0000000000000000, 0.0010681152343750,
0.0000000000000000, 0.0010375976562500, 0.0000000000000000, 0.0010681152343750,
0.0000305175781250, 0.0010681152343750, 0.0000000000000000, 0.0009765625000000,
0.0000000000000000, 0.0010070800781250, 0.0000305175781250, 0.0010070800781250,
-0.0000305175781250, 0.0010070800781250, 0.0000000000000000, 0.0010375976562500,
-0.0000305175781250, 0.0010681152343750, 0.0000305175781250, 0.0010070800781250,
-0.0000305175781250, 0.0011291503906250, 0.0000000000000000, 0.0010986328125000,
-0.0000305175781250, 0.0011596679687500, 0.0000000000000000, 0.0012207031250000,
0.0000000000000000, 0.0011901855468750, 0.0000000000000000, 0.0011596679687500,
0.0000305175781250, 0.0012817382812500, 0.0000000000000000, 0.0010986328125000,
-0.0000610351562500, 0.0009765625000000, 0.0000000000000000, 0.0011596679687500,
0.0000000000000000, 0.0004882812500000, 0.0000000000000000, 0.0007629394531250,
0.0000305175781250, 0.0004272460937500, 0.0000000000000000, -0.0002746582031250,
-0.0000305175781250, 0.0002746582031250, 0.0000000000000000, -0.0008850097656250,
0.0000000000000000, -0.0007629394531250, 0.0000000000000000, -0.0007934570312500,
-0.0000610351562500, -0.0014953613281250, 0.0000000000000000, -0.0012817382812500,
0.0000000000000000, -0.0011596679687500, -0.0000305175781250, -0.0014953613281250,
0.0000305175781250, -0.0010070800781250, 0.0000000000000000, -0.0004882812500000,
-0.0000305175781250, -0.0009155273437500, 0.0000000000000000, 0.0004577636718750,
0.0000000000000000, 0.0002746582031250, 0.0000000000000000, 0.0004882812500000,
-0.0000305175781250, 0.0015563964843750, 0.0000305175781250, 0.0011291503906250,
0.0000000000000000, 0.0012512207031250, 0.0000305175781250, 0.0016479492187500,
0.0000000000000000, 0.0009765625000000, 0.0000610351562500, 0.0004882812500000,
0.0000610351562500, 0.0009765625000000, -0.0000610351562500, -0.0005493164062500,
-0.0000305175781250, -0.0004577636718750, 0.0000000000000000, -0.0005493164062500,
-0.0000305175781250, -0.0015563964843750, -0.0000610351562500, -0.0012817382812500,
0.0000000000000000, -0.0011291503906250, 0.0000000000000000, -0.0015258789062500,
0.0000000000000000, -0.0008544921875000, 0.0000610351562500, -0.0001831054687500,
0.0000305175781250, -0.0006408691406250, -0.0000610351562500, 0.0007019042968750,
0.0000000000000000, 0.0008239746093750, 0.0000000000000000, 0.0005493164062500,
-0.0001220703125000, 0.0011291503906250, -0.0000915527343750, 0.0010986328125000,
0.0000610351562500, 0.0002441406250000, 0.0000000000000000, 0.0004882812500000,
0.0000000000000000, 0.0001220703125000, 0.0000915527343750, -0.0007934570312500,
0.0001220703125000, -0.0003662109375000, 0.0000305175781250, -0.0007629394531250,
0.0000305175781250, -0.0010986328125000, 0.0000000000000000, -0.0006408691406250,
-0.0001525878906250, -0.0003967285156250, -0.0000915527343750, -0.0007019042968750,
-0.0000610351562500, 0.0003356933593750, -0.0000915527343750, 0.0003356933593750,
0.0000000000000000, 0.0002746582031250, 0.0001831054687500, 0.0009155273437500,
0.0000915527343750, 0.0007934570312500, 0.0000610351562500, 0.0000610351562500,
0.0001831054687500, 0.0004577636718750, 0.0000000000000000, -0.0000305175781250,
-0.0001525878906250, -0.0010681152343750, -0.0000305175781250, -0.0005187988281250,
-0.0001525878906250, -0.0006713867187500, -0.0003051757812500, -0.0012512207031250,
-0.0000915527343750, -0.0004272460937500, 0.0000915527343750, 0.0004882812500000,
-0.0000610351562500, -0.0001831054687500, 0.0002136230468750, 0.0006713867187500,
0.0003356933593750, 0.0011596679687500, 0.0001220703125000, 0.0003356933593750,
0.0000915527343750, -0.0001220703125000, 0.0002136230468750, 0.0005187988281250,
-0.0003356933593750, -0.0007324218750000, -0.0003967285156250, -0.0010070800781250,
-0.0001831054687500, -0.0004882812500000, -0.0003051757812500, -0.0003967285156250,
0.0004577636718750, 0.0005798339843750, -0.0003662109375000, -0.0007629394531250,
0.0000915527343750, -0.0008544921875000, -0.0001525878906250, -0.0003051757812500,
-0.0008239746093750, -0.0002441406250000, -0.0006408691406250, -0.0006408691406250,
0.0000000000000000, 0.0004577636718750, -0.0004577636718750, 0.0007019042968750,
-0.0000305175781250, 0.0001831054687500, 0.0009155273437500, 0.0003356933593750,
0.0004882812500000, 0.0006103515625000, 0.0005187988281250, -0.0003662109375000,
0.0010681152343750, -0.0005187988281250, 0.0002441406250000, -0.0001525878906250,
-0.0006713867187500, -0.0004272460937500, 0.0000610351562500, -0.0005187988281250,
-0.0010070800781250, 0.0002136230468750, -0.0015258789062500, 0.0003051757812500,
-0.0006103515625000, 0.0000610351562500, -0.0002136230468750, 0.0003356933593750,
-0.0009460449218750, 0.0003967285156250, 0.0009155273437500, -0.0001220703125000,
0.0010681152343750, -0.0001525878906250, 0.0004577636718750, -0.0000305175781250,
0.0010375976562500, -0.0003356933593750, 0.0013122558593750, -0.0003356933593750,
-0.0004882812500000, 0.0001220703125000, -0.0001525878906250, 0.0001220703125000,
-0.0003051757812500, 0.0000305175781250, -0.0017089843750000, 0.0002441406250000,
-0.0012817382812500, 0.0002441406250000, -0.0005798339843750, -0.0000915527343750,
-0.0012512207031250, -0.0000305175781250, -0.0004577636718750, 0.0000000000000000,
0.0009155273437500, -0.0001831054687500, 0.0000915527343750, -0.0002136230468750,
0.0009765625000000, 0.0000610351562500, 0.0015258789062500, 0.0000000000000000,
0.0007324218750000, 0.0000305175781250, 0.0003662109375000, 0.0001831054687500,
0.0009155273437500, 0.0001525878906250, -0.0006713867187500, -0.0000305175781250,
-0.0006408691406250, 0.0000305175781250, -0.0005798339843750, 0.0000000000000000,
-0.0015258789062500, -0.0000915527343750, -0.0012817382812500, -0.0000915527343750,
-0.0006408691406250, 0.0000610351562500, -0.0011901855468750, 0.0000305175781250,
-0.0005187988281250, 0.0000000000000000, 0.0005187988281250, 0.0000915527343750,
-0.0001831054687500, 0.0000915527343750, 0.0009765625000000, -0.0000305175781250,
0.0012207031250000, -0.0000305175781250, 0.0008850097656250, -0.0000305175781250,
0.0012512207031250},
{0.0000000000000000, 0.0004577636718750, 0.0001525878906250, -0.0000305175781250,
0.0000610351562500, 0.0003356933593750, 0.0000610351562500, -0.0006713867187500,
0.0001525878906250, -0.0007629394531250, 0.0000305175781250, -0.0005187988281250,
-0.0001525878906250, -0.0008850097656250, -0.0000305175781250, -0.0009460449218750,
-0.0001220703125000, 0.0001525878906250, -0.0002441406250000, -0.0001831054687500,
-0.0000915527343750, 0.0000915527343750, 0.0001220703125000, 0.0011291503906250,
-0.0000610351562500, 0.0007629394531250, 0.0001831054687500, 0.0003662109375000,
0.0003051757812500, 0.0009460449218750, 0.0000610351562500, 0.0002136230468750,
0.0000305175781250, -0.0009765625000000, 0.0001220703125000, -0.0003662109375000,
-0.0003051757812500, -0.0006103515625000, -0.0003356933593750, -0.0013122558593750,
-0.0001220703125000, -0.0004272460937500, -0.0002441406250000, 0.0004882812500000,
-0.0003356933593750, -0.0002441406250000, 0.0002136230468750, 0.0007019042968750,
0.0002136230468750, 0.0011901855468750, 0.0001525878906250, 0.0004882812500000,
0.0005187988281250, -0.0001525878906250, -0.0004577636718750, -0.0003662109375000,
0.0000915527343750, 0.0006713867187500, -0.0003967285156250, 0.0010375976562500,
0.0000000000000000, 0.0003051757812500, 0.0007934570312500, -0.0002136230468750,
0.0004272460937500, 0.0003051757812500, 0.0002136230468750, -0.0005798339843750,
0.0007019042968750, -0.0009765625000000, 0.0000610351562500, -0.0003356933593750,
-0.0008239746093750, -0.0000305175781250, -0.0002441406250000, -0.0004577636718750,
-0.0008239746093750, 0.0004272460937500, -0.0013427734375000, 0.0007019042968750,
-0.0004882812500000, 0.0002136230468750, 0.0000915527343750, 0.0001831054687500,
-0.0005798339843750, 0.0004882812500000, 0.0009155273437500, -0.0003051757812500,
0.0012512207031250, -0.0004272460937500, 0.0004577636718750, -0.0001525878906250,
0.0007324218750000, -0.0002136230468750, 0.0011901855468750, -0.0004272460937500,
-0.0007629394531250, 0.0002136230468750, -0.0006713867187500, 0.0003356933593750,
-0.0004577636718750, 0.0000610351562500, -0.0015258789062500, 0.0002136230468750,
-0.0014343261718750, 0.0003356933593750, 0.0000305175781250, -0.0001831054687500,
-0.0005493164062500, -0.0002136230468750, -0.0000915527343750, -0.0000610351562500,
0.0014343261718750, -0.0002136230468750, 0.0007934570312500, -0.0003051757812500,
0.0007324218750000, 0.0001525878906250, 0.0014343261718750, 0.0001525878906250,
0.0005493164062500, 0.0000610351562500, -0.0005798339843750, 0.0001525878906250,
0.0002441406250000, 0.0002441406250000, -0.0010986328125000, -0.0000915527343750,
-0.0014648437500000, -0.0000915527343750, -0.0007934570312500, -0.0000305175781250,
-0.0008239746093750, -0.0001220703125000, -0.0012207031250000, -0.0001831054687500,
0.0002441406250000, 0.0000610351562500, 0.0000305175781250, 0.0000915527343750,
0.0001525878906250, 0.0000000000000000, 0.0012512207031250, 0.0000915527343750,
0.0008544921875000, 0.0001220703125000, 0.0006408691406250, -0.0000305175781250,
0.0011901855468750, -0.0000610351562500, 0.0005187988281250, 0.0000000000000000,
-0.0002746582031250, -0.0000610351562500, 0.0003662109375000, -0.0000915527343750,
-0.0007934570312500, 0.0000305175781250, -0.0009155273437500, 0.0000915527343750,
-0.0006713867187500, 0.0000000000000000, -0.0011291503906250, 0.0000305175781250,
-0.0011291503906250, 0.0000305175781250, -0.0005187988281250, -0.0000305175781250,
-0.0007629394531250, -0.0000305175781250, -0.0004272460937500, -0.0000305175781250,
0.0002746582031250, 0.0000000000000000, -0.0001525878906250, -0.0000305175781250,
0.0006408691406250, 0.0000000000000000, 0.0007324218750000, 0.0000610351562500,
0.0005798339843750, 0.0000000000000000, 0.0009155273437500, -0.0000305175781250,
0.0008850097656250, 0.0000305175781250, 0.0003051757812500, -0.0000305175781250,
0.0006713867187500, -0.0000610351562500, 0.0002136230468750, 0.0000000000000000,
-0.0005187988281250, 0.0000305175781250, 0.0000000000000000, 0.0000000000000000,
-0.0010986328125000, 0.0000000000000000, -0.0010681152343750, 0.0000305175781250,
-0.0010375976562500, 0.0000000000000000, -0.0016784667968750, 0.0000000000000000,
-0.0014343261718750, 0.0000000000000000, -0.0012817382812500, 0.0000000000000000,
-0.0016784667968750, 0.0000305175781250, -0.0011901855468750, 0.0000305175781250,
-0.0007019042968750, 0.0000000000000000, -0.0012512207031250, 0.0000610351562500,
0.0002136230468750, -0.0000305175781250, -0.0003051757812500, 0.0000000000000000,
0.0001525878906250, 0.0000305175781250, 0.0014343261718750, -0.0000305175781250,
0.0004882812500000, 0.0000000000000000, 0.0019836425781250, 0.0000000000000000,
0.0018005371093750, 0.0000305175781250, 0.0019531250000000, -0.0000305175781250,
0.0027770996093750, 0.0000000000000000, 0.0021362304687500, -0.0000305175781250,
0.0029602050781250, 0.0000000000000000, 0.0028076171875000, 0.0000000000000000,
0.0028381347656250, 0.0000305175781250, 0.0032958984375000, 0.0000000000000000,
0.0028686523437500, 0.0000000000000000, 0.0032653808593750, 0.0000000000000000,
0.0031127929687500, 0.0000305175781250, 0.0029907226562500, 0.0000305175781250,
0.0031127929687500, 0.0000000000000000, 0.0028686523437500, 0.0000000000000000,
0.0026245117187500, 0.0000305175781250, 0.0025329589843750, 0.0000000000000000,
0.0021972656250000, 0.0000000000000000, 0.0018005371093750, 0.0000000000000000,
0.0016174316406250, 0.0000000000000000, 0.0009460449218750, 0.0000000000000000,
0.0009765625000000, -0.0000305175781250, 0.0004272460937500, 0.0000000000000000,
-0.0002441406250000, 0.0000000000000000, -0.0000915527343750, 0.0000000000000000,
-0.0010681152343750, 0.0000305175781250, -0.0010681152343750, 0.0000305175781250,
-0.0012512207031250, 0.0000305175781250, -0.0019226074218750, 0.0000000000000000,
-0.0017700195312500, -0.0000305175781250, -0.0018920898437500, 0.0000305175781250,
-0.0021057128906250, 0.0000000000000000, -0.0017700195312500, 0.0000000000000000,
-0.0015869140625000, 0.0000000000000000, -0.0017700195312500, -0.0000305175781250,
-0.0007934570312500, -0.0000305175781250, -0.0009155273437500, -0.0000305175781250,
-0.0005187988281250, 0.0000000000000000, 0.0003356933593750, 0.0000000000000000,
0.0000305175781250, 0.0000000000000000, 0.0008239746093750, 0.0000305175781250,
0.0009155273437500, 0.0000305175781250, 0.0007324218750000, -0.0000305175781250,
0.0009460449218750, 0.0000305175781250, 0.0009765625000000, 0.0000305175781250,
0.0002746582031250, -0.0000305175781250, 0.0004272460937500, -0.0000305175781250,
0.0000305175781250, 0.0000000000000000, -0.0007019042968750, 0.0000000000000000,
-0.0003662109375000, -0.0000305175781250, -0.0008544921875000, 0.0000305175781250,
-0.0011291503906250, 0.0000305175781250, -0.0006408691406250, 0.0000305175781250,
-0.0004272460937500, 0.0000305175781250, -0.0007324218750000, 0.0000305175781250,
0.0002441406250000, -0.0000305175781250, 0.0003051757812500, -0.0000305175781250,
0.0003051757812500, 0.0000000000000000, 0.0008850097656250, -0.0000305175781250,
0.0007934570312500, -0.0000915527343750, 0.0002441406250000, 0.0000305175781250,
0.0005493164062500, 0.0000000000000000, 0.0001220703125000, 0.0000000000000000,
-0.0006408691406250, 0.0000305175781250, -0.0002441406250000, 0.0000305175781250,
-0.0006103515625000, -0.0000305175781250, -0.0009460449218750, -0.0000305175781250,
-0.0004882812500000, -0.0000305175781250, -0.0001525878906250, -0.0000915527343750,
-0.0004882812500000, -0.0000610351562500, 0.0003662109375000, 0.0000915527343750,
0.0005493164062500, 0.0000305175781250, 0.0001831054687500, 0.0000305175781250,
0.0003051757812500, 0.0001220703125000, 0.0004577636718750, 0.0000915527343750,
-0.0003051757812500, -0.0000610351562500, -0.0003356933593750, -0.0000305175781250,
-0.0001525878906250, -0.0000305175781250, -0.0005187988281250, -0.0001220703125000,
-0.0005187988281250, -0.0000915527343750, 0.0000610351562500, 0.0000610351562500,
-0.0000305175781250, 0.0000305175781250, -0.0000305175781250, 0.0000000000000000,
0.0004272460937500, 0.0001525878906250, 0.0003662109375000, 0.0000915527343750,
-0.0000305175781250, -0.0000915527343750, 0.0001220703125000, -0.0000305175781250,
0.0000000000000000, 0.0000000000000000, -0.0004577636718750, -0.0001525878906250,
-0.0002746582031250, -0.0001220703125000, -0.0000610351562500, 0.0000610351562500,
-0.0002136230468750, 0.0000305175781250, -0.0001220703125000, 0.0000305175781250,
0.0003051757812500, 0.0000915527343750, 0.0002136230468750, 0.0000610351562500,
-0.0001220703125000, -0.0001525878906250, 0.0000610351562500, -0.0000610351562500,
0.0000000000000000, -0.0000305175781250, -0.0002746582031250, -0.0001831054687500,
-0.0001831054687500, -0.0001220703125000, 0.0000305175781250, 0.0000610351562500,
-0.0001220703125000, 0.0000915527343750, -0.0000610351562500, 0.0000000000000000,
0.0002441406250000, 0.0001220703125000, 0.0001525878906250, 0.0001220703125000,
-0.0000610351562500, -0.0001525878906250, 0.0000305175781250, -0.0001525878906250,
-0.0000305175781250, -0.0000610351562500, -0.0002746582031250, -0.0001831054687500,
-0.0001831054687500, -0.0002441406250000, 0.0000305175781250, 0.0001525878906250,
-0.0001220703125000, 0.0001831054687500, -0.0000610351562500, 0.0000305175781250,
0.0001831054687500, 0.0002441406250000, 0.0001525878906250, 0.0002441406250000,
0.0000000000000000, -0.0002746582031250, 0.0000915527343750, -0.0002136230468750,
0.0000305175781250, -0.0001525878906250, -0.0002441406250000, -0.0005187988281250,
-0.0001220703125000, -0.0004882812500000, 0.0000000000000000, 0.0000610351562500,
-0.0001220703125000, -0.0000915527343750, -0.0000305175781250, 0.0000000000000000,
0.0002136230468750, 0.0005798339843750, 0.0000915527343750, 0.0003967285156250,
0.0000000000000000, 0.0000610351562500, 0.0000610351562500, 0.0003662109375000,
0.0000000000000000, 0.0000610351562500, -0.0001220703125000, -0.0005798339843750,
-0.0000610351562500, -0.0002441406250000, 0.0000000000000000, -0.0004272460937500,
-0.0000915527343750, -0.0007019042968750, -0.0000610351562500, -0.0003356933593750,
0.0001220703125000, 0.0000000000000000, 0.0000000000000000, -0.0002746582031250,
0.0000000000000000, 0.0003356933593750, 0.0000610351562500, 0.0005187988281250,
0.0000305175781250, 0.0002441406250000, -0.0000610351562500, 0.0003356933593750,
0.0000000000000000, 0.0004882812500000, 0.0000000000000000, -0.0002136230468750,
-0.0000305175781250, -0.0001525878906250, -0.0000305175781250, -0.0001831054687500,
0.0000305175781250, -0.0006713867187500, 0.0000000000000000, -0.0005493164062500,
0.0000305175781250, -0.0003051757812500, 0.0000305175781250, -0.0004577636718750,
0.0000305175781250, -0.0002441406250000, -0.0000305175781250, 0.0002136230468750,
-0.0000305175781250, 0.0000305175781250, -0.0000305175781250, 0.0003051757812500,
-0.0000305175781250, 0.0004272460937500, 0.0000000000000000, 0.0002136230468750,
0.0000000000000000, 0.0001220703125000, -0.0000305175781250, 0.0002746582031250,
0.0000000000000000, -0.0001831054687500, 0.0000000000000000, -0.0001831054687500,
0.0000000000000000, -0.0001831054687500, 0.0000305175781250, -0.0003662109375000,
0.0000305175781250, -0.0003356933593750, 0.0000000000000000, -0.0001525878906250,
-0.0000610351562500, -0.0002746582031250, 0.0000000000000000, -0.0000305175781250,
0.0000000000000000, 0.0003051757812500, -0.0000305175781250, 0.0001525878906250,
0.0000305175781250},
{-0.0005187988281250, -0.0001220703125000, 0.0000610351562500, 0.0000000000000000,
-0.0000610351562500, -0.0000610351562500, -0.0000305175781250, 0.0000000000000000,
0.0003967285156250, 0.0001525878906250, 0.0003356933593750, 0.0000915527343750,
-0.0000610351562500, -0.0000610351562500, 0.0000610351562500, 0.0000000000000000,
0.0000305175781250, 0.0000000000000000, -0.0003967285156250, -0.0001220703125000,
-0.0003051757812500, -0.0001220703125000, 0.0001220703125000, 0.0000610351562500,
-0.0000305175781250, -0.0000305175781250, -0.0000915527343750, -0.0000610351562500,
0.0002136230468750, 0.0001220703125000, 0.0001831054687500, 0.0001220703125000,
-0.0001220703125000, -0.0001220703125000, -0.0000915527343750, -0.0000610351562500,
0.0000000000000000, -0.0000610351562500, -0.0002136230468750, -0.0002136230468750,
-0.0002441406250000, -0.0001831054687500, 0.0000610351562500, 0.0000610351562500,
-0.0000305175781250, 0.0000305175781250, -0.0000305175781250, -0.0000305175781250,
0.0002136230468750, 0.0001220703125000, 0.0002136230468750, 0.0001525878906250,
-0.0000610351562500, -0.0002136230468750, -0.0000305175781250, -0.0001220703125000,
0.0000000000000000, -0.0001220703125000, -0.0002441406250000, -0.0003967285156250,
-0.0002136230468750, -0.0003967285156250, 0.0000610351562500, 0.0000915527343750,
0.0000305175781250, -0.0000305175781250, -0.0000305175781250, 0.0000000000000000,
0.0002136230468750, 0.0004882812500000, 0.0001525878906250, 0.0003356933593750,
-0.0000305175781250, -0.0000610351562500, 0.0000000000000000, 0.0001831054687500,
0.0000610351562500, -0.0000305175781250, -0.0001525878906250, -0.0006408691406250,
-0.0001220703125000, -0.0003967285156250, 0.0000305175781250, -0.0003051757812500,
-0.0000610351562500, -0.0005798339843750, 0.0000000000000000, -0.0002441406250000,
0.0001525878906250, 0.0002746582031250, 0.0001220703125000, -0.0000610351562500,
0.0000000000000000, 0.0003662109375000, 0.0000305175781250, 0.0006103515625000,
0.0000305175781250, 0.0002441406250000, -0.0000915527343750, 0.0000915527343750,
-0.0000915527343750, 0.0002746582031250, 0.0000000000000000, -0.0003051757812500,
-0.0000305175781250, -0.0003967285156250, 0.0000000000000000, -0.0002136230468750,
0.0000915527343750, -0.0003967285156250, 0.0000305175781250, -0.0004882812500000,
0.0000000000000000, -0.0000305175781250, 0.0000915527343750, -0.0000610351562500,
0.0000305175781250, 0.0000000000000000, -0.0000305175781250, 0.0003356933593750,
-0.0000305175781250, 0.0002746582031250, 0.0000000000000000, 0.0000305175781250,
-0.0000305175781250, 0.0001220703125000, 0.0000000000000000, 0.0000000000000000,
0.0000610351562500, -0.0003051757812500, 0.0000000000000000, -0.0002441406250000,
0.0000305175781250, -0.0000305175781250, 0.0000305175781250, -0.0002136230468750,
0.0000000000000000, 0.0001220703125000, -0.0000305175781250, 0.0005798339843750,
0.0000000000000000, 0.0003051757812500, -0.0000305175781250, 0.0008850097656250,
-0.0000610351562500, 0.0010681152343750, -0.0000305175781250, 0.0007629394531250,
0.0000610351562500, 0.0008544921875000, 0.0000000000000000, 0.0008850097656250,
0.0000000000000000, -0.0001525878906250, 0.0000305175781250, 0.0000610351562500,
0.0000000000000000, -0.0005493164062500, 0.0000000000000000, -0.0016784667968750,
-0.0000305175781250, -0.0012817382812500, 0.0000305175781250, -0.0026245117187500,
-0.0000305175781250, -0.0027160644531250, 0.0000305175781250, -0.0030822753906250,
0.0000000000000000, -0.0039978027343750, 0.0000000000000000, -0.0036621093750000,
0.0000000000000000, -0.0042114257812500, 0.0000000000000000, -0.0043029785156250,
0.0000000000000000, -0.0042114257812500, 0.0000000000000000, -0.0043029785156250,
0.0000305175781250, -0.0040893554687500, 0.0000000000000000, -0.0038146972656250,
-0.0000305175781250, -0.0034484863281250, 0.0000000000000000, -0.0032043457031250,
0.0000000000000000, -0.0031127929687500, 0.0000000000000000, -0.0029296875000000,
0.0000305175781250, -0.0022888183593750, 0.0000000000000000, -0.0017089843750000,
0.0000000000000000, -0.0017395019531250, 0.0000000000000000, -0.0015563964843750,
-0.0000305175781250, -0.0010681152343750, -0.0000305175781250, -0.0017395019531250,
0.0000000000000000, -0.0014343261718750, -0.0000305175781250, -0.0016479492187500,
0.0000000000000000, -0.0022583007812500, 0.0000000000000000, -0.0018920898437500,
0.0000000000000000, -0.0029907226562500, 0.0000000000000000, -0.0025024414062500,
0.0000000000000000, -0.0033264160156250, 0.0000000000000000, -0.0046386718750000,
0.0000000000000000, -0.0035705566406250, 0.0000000000000000, -0.0054626464843750,
0.0000305175781250, -0.0054321289062500, 0.0000305175781250, -0.0054626464843750,
0.0000305175781250, -0.0066223144531250, -0.0000305175781250, -0.0061340332031250,
0.0000000000000000, -0.0061340332031250, 0.0000000000000000, -0.0067749023437500,
0.0000000000000000, -0.0057983398437500, 0.0000000000000000, -0.0051574707031250,
0.0000000000000000, -0.0058898925781250, 0.0000305175781250, -0.0030212402343750,
0.0000000000000000, -0.0038452148437500, 0.0000000000000000, -0.0028991699218750,
0.0000305175781250, -0.0003967285156250, -0.0000305175781250, -0.0018005371093750,
0.0000000000000000, 0.0010375976562500, 0.0000610351562500, 0.0011901855468750,
0.0000000000000000, 0.0009765625000000, -0.0000610351562500, 0.0023193359375000,
0.0000305175781250, 0.0019836425781250, 0.0000000000000000, 0.0014038085937500,
0.0000000000000000, 0.0019226074218750, 0.0000610351562500, 0.0013122558593750,
0.0000305175781250, 0.0002746582031250, 0.0000000000000000, 0.0008544921875000,
0.0000000000000000, -0.0001220703125000, 0.0000305175781250, -0.0003967285156250,
0.0000305175781250, -0.0000610351562500, 0.0000305175781250, -0.0002136230468750,
0.0000000000000000, -0.0003356933593750, -0.0000305175781250, 0.0001525878906250,
-0.0000305175781250, 0.0001220703125000, -0.0000305175781250, 0.0001220703125000,
0.0000305175781250, 0.0004882812500000, 0.0000000000000000, 0.0004272460937500,
0.0000305175781250, 0.0000610351562500, 0.0000915527343750, 0.0003051757812500,
0.0000000000000000, -0.0000305175781250, -0.0000610351562500, -0.0005798339843750,
0.0000000000000000, -0.0002441406250000, -0.0000305175781250, -0.0005798339843750,
-0.0000610351562500, -0.0008850097656250, 0.0000305175781250, -0.0004577636718750,
0.0000915527343750, -0.0002746582031250, 0.0000000000000000, -0.0005187988281250,
0.0000610351562500, 0.0003356933593750, 0.0001220703125000, 0.0003967285156250,
0.0000000000000000, 0.0003051757812500, -0.0000915527343750, 0.0007324218750000,
0.0000000000000000, 0.0006408691406250, -0.0000610351562500, 0.0002136230468750,
-0.0002136230468750, 0.0005187988281250, -0.0000610351562500, 0.0001220703125000,
0.0000610351562500, -0.0004882812500000, -0.0000305175781250, -0.0001525878906250,
0.0001525878906250, -0.0007324218750000, 0.0002136230468750, -0.0010070800781250,
0.0000305175781250, -0.0004882812500000, 0.0000000000000000, -0.0003662109375000,
0.0000915527343750, -0.0007019042968750, -0.0001831054687500, 0.0005493164062500,
-0.0002746582031250, 0.0005493164062500, -0.0001220703125000, 0.0003356933593750,
-0.0000915527343750, 0.0010070800781250, -0.0001831054687500, 0.0010070800781250,
0.0001831054687500, -0.0002136230468750, 0.0001525878906250, 0.0001220703125000,
0.0000305175781250, -0.0001220703125000, 0.0003051757812500, -0.0013732910156250,
0.0002441406250000, -0.0010070800781250, -0.0001831054687500, -0.0001831054687500,
-0.0000915527343750, -0.0007934570312500, -0.0001525878906250, -0.0002136230468750,
-0.0004882812500000, 0.0012512207031250, -0.0003967285156250, 0.0005798339843750,
0.0000305175781250, 0.0004272460937500, -0.0002136230468750, 0.0010986328125000,
-0.0000610351562500, 0.0004882812500000, 0.0006408691406250, -0.0010681152343750,
-0.0002136230468750, 0.0004272460937500, -0.0003662109375000, 0.0003051757812500,
-0.0007934570312500, 0.0010375976562500, -0.0001220703125000, 0.0002441406250000,
0.0004882812500000, -0.0008850097656250, -0.0000305175781250, -0.0003051757812500,
0.0005798339843750, -0.0003967285156250, 0.0010375976562500, -0.0009460449218750,
0.0003356933593750, -0.0003051757812500, 0.0000000000000000, 0.0005798339843750,
0.0004882812500000, 0.0000610351562500, -0.0009460449218750, 0.0003662109375000,
-0.0011596679687500, 0.0007934570312500, -0.0005187988281250, 0.0003051757812500,
-0.0008850097656250, -0.0003356933593750, -0.0011901855468750, 0.0001220703125000,
0.0006103515625000, -0.0003051757812500, 0.0004272460937500, -0.0007019042968750,
0.0002746582031250, -0.0002441406250000, 0.0014343261718750, 0.0001831054687500,
0.0013122558593750, -0.0001831054687500, -0.0000915527343750, 0.0002746582031250,
0.0004882812500000, 0.0005187988281250, 0.0000610351562500, 0.0001220703125000,
-0.0015258789062500, -0.0000915527343750, -0.0008850097656250, 0.0001525878906250,
-0.0006103515625000, -0.0002136230468750, -0.0013427734375000, -0.0004272460937500,
-0.0004577636718750, -0.0001525878906250, 0.0007324218750000, 0.0000305175781250,
-0.0000610351562500, -0.0001831054687500, 0.0008544921875000, 0.0001525878906250,
0.0013732910156250, 0.0003356933593750, 0.0005493164062500, 0.0000915527343750,
0.0002441406250000, 0.0000000000000000, 0.0007629394531250, 0.0001220703125000,
-0.0006408691406250, -0.0001220703125000, -0.0007934570312500, -0.0002441406250000,
-0.0003662109375000, -0.0000610351562500, -0.0007934570312500, 0.0000305175781250,
-0.0009155273437500, -0.0000610351562500, -0.0000305175781250, 0.0000915527343750,
-0.0002136230468750, 0.0001831054687500, -0.0000915527343750, 0.0000610351562500,
0.0005493164062500, -0.0000305175781250, 0.0003051757812500, 0.0001220703125000,
0.0001525878906250, -0.0000610351562500, 0.0005187988281250, -0.0001220703125000,
0.0001525878906250, -0.0000610351562500, -0.0003967285156250, 0.0000305175781250,
0.0000000000000000, -0.0000610351562500, -0.0003967285156250, 0.0000915527343750,
-0.0007324218750000, 0.0000915527343750, -0.0001831054687500, 0.0000305175781250,
0.0000915527343750, 0.0000000000000000, -0.0003356933593750, 0.0000305175781250,
0.0009765625000000, -0.0000305175781250, 0.0008544921875000, -0.0000915527343750,
0.0008850097656250, 0.0000000000000000, 0.0017700195312500, 0.0000610351562500,
0.0014953613281250, 0.0000000000000000, 0.0010681152343750, 0.0000000000000000,
0.0017395019531250, 0.0000305175781250, 0.0006713867187500, 0.0000610351562500,
-0.0002746582031250, -0.0000610351562500, 0.0007324218750000, -0.0000305175781250,
-0.0025634765625000, 0.0000000000000000, -0.0016784667968750, -0.0000610351562500,
-0.0026550292968750, 0.0000000000000000, -0.0054321289062500, 0.0000305175781250,
-0.0036926269531250, 0.0000305175781250, -0.0059814453125000, 0.0000000000000000,
-0.0065612792968750, 0.0000305175781250, -0.0054321289062500, 0.0000000000000000,
-0.0061035156250000, -0.0000305175781250, -0.0067749023437500, 0.0000000000000000,
-0.0031433105468750, 0.0000000000000000, -0.0050354003906250, 0.0000000000000000,
-0.0028991699218750, 0.0000000000000000, 0.0005187988281250, 0.0000305175781250,
-0.0026245117187500, 0.0000000000000000, 0.0049133300781250, 0.0000000000000000,
0.0027770996093750, 0.0000000000000000, 0.0046691894531250, -0.0000305175781250,
0.0104675292968750, -0.0000305175781250, 0.0065307617187500, 0.0000000000000000,
0.0132446289062500, 0.0000305175781250, 0.0121765136718750, 0.0000610351562500,
0.0129089355468750},
{-0.0010070800781250, 0.0006713867187500, -0.0003967285156250, 0.0001831054687500,
-0.0004577636718750, -0.0008850097656250, -0.0008239746093750, -0.0003967285156250,
0.0006713867187500, -0.0003051757812500, 0.0006713867187500, -0.0007934570312500,
0.0003662109375000, -0.0003051757812500, 0.0011291503906250, 0.0005493164062500,
0.0012207031250000, 0.0001220703125000, -0.0003662109375000, 0.0002136230468750,
0.0000000000000000, 0.0006408691406250, -0.0001831054687500, 0.0001525878906250,
-0.0015869140625000, -0.0003967285156250, -0.0011596679687500, -0.0000305175781250,
-0.0002746582031250, -0.0002441406250000, -0.0010070800781250, -0.0005187988281250,
-0.0003356933593750, -0.0001525878906250, 0.0011596679687500, 0.0002441406250000,
0.0004577636718750, -0.0000610351562500, 0.0006103515625000, 0.0002136230468750,
0.0012817382812500, 0.0004272460937500, 0.0004882812500000, 0.0001220703125000,
-0.0003662109375000, -0.0002136230468750, 0.0003051757812500, 0.0000305175781250,
-0.0007629394531250, -0.0002136230468750, -0.0011596679687500, -0.0003662109375000,
-0.0004882812500000, -0.0000915527343750, -0.0003051757812500, 0.0001525878906250,
-0.0007629394531250, -0.0000610351562500, 0.0003051757812500, 0.0000610351562500,
0.0005187988281250, 0.0002441406250000, 0.0000915527343750, 0.0000610351562500,
0.0002441406250000, -0.0001220703125000, 0.0004882812500000, 0.0000305175781250,
-0.0003051757812500, -0.0000915527343750, -0.0003967285156250, -0.0002136230468750,
-0.0000915527343750, -0.0000610351562500, -0.0003662109375000, 0.0000610351562500,
-0.0004882812500000, 0.0000000000000000, 0.0005798339843750, 0.0000305175781250,
0.0002136230468750, 0.0001525878906250, 0.0006103515625000, 0.0000000000000000,
0.0017395019531250, -0.0000610351562500, 0.0011291503906250, 0.0000000000000000,
0.0008544921875000, 0.0000305175781250, 0.0017395019531250, -0.0001220703125000,
0.0004577636718750, -0.0000305175781250, -0.0008239746093750, 0.0000610351562500,
0.0003051757812500, 0.0000305175781250, -0.0030212402343750, 0.0000610351562500,
-0.0028686523437500, 0.0000610351562500, -0.0028991699218750, 0.0000305175781250,
-0.0049743652343750, -0.0000610351562500, -0.0042114257812500, -0.0000305175781250,
-0.0028686523437500, 0.0000000000000000, -0.0046386718750000, -0.0000305175781250,
-0.0017395019531250, -0.0000305175781250, 0.0011901855468750, 0.0000610351562500,
-0.0016174316406250, 0.0000305175781250, 0.0069274902343750, -0.0000305175781250,
0.0049743652343750, 0.0000610351562500, 0.0070190429687500, 0.0000305175781250,
0.0138854980468750, -0.0000610351562500, 0.0098876953125000, -0.0000305175781250,
0.0144348144531250, 0.0000305175781250, 0.0164794921875000, 0.0000000000000000,
0.0124206542968750, 0.0000000000000000, 0.0130004882812500, 0.0000305175781250,
0.0159301757812500, 0.0000610351562500, 0.0016479492187500, 0.0000000000000000,
0.0086059570312500, 0.0000305175781250, -0.0003662109375000, 0.0000305175781250,
-0.0138854980468750, 0.0000000000000000, -0.0011596679687500, 0.0000305175781250,
-0.0329895019531250, 0.0000305175781250, -0.0226135253906250, 0.0000305175781250,
-0.0323791503906250, 0.0000610351562500, -0.0581665039062500, 0.0000610351562500,
-0.0392761230468750, 0.0000610351562500, -0.0732727050781250, 0.0000610351562500,
-0.0659484863281250, 0.0000610351562500, -0.0714721679687500, 0.0000305175781250,
-0.0931091308593750, 0.0000610351562500, -0.0736083984375000, 0.0000305175781250,
-0.0965881347656250, 0.0000915527343750, -0.0910034179687500, 0.0000305175781250,
-0.0900573730468750, 0.0000305175781250, -0.1019897460937500, 0.0000610351562500,
-0.0890197753906250, 0.0000305175781250, -0.0983581542968750, 0.0000610351562500,
-0.0944213867187500, 0.0000610351562500, -0.0891418457031250, 0.0000610351562500,
-0.0917968750000000, 0.0000915527343750, -0.0848999023437500, 0.0000610351562500,
-0.0762634277343750, 0.0000915527343750, -0.0733032226562500, 0.0000610351562500,
-0.0650939941406250, 0.0000610351562500, -0.0552368164062500, 0.0000610351562500,
-0.0518798828125000, 0.0000305175781250, -0.0380554199218750, 0.0000000000000000,
-0.0373229980468750, 0.0000305175781250, -0.0285949707031250, 0.0000305175781250,
-0.0160217285156250, 0.0000305175781250, -0.0191650390625000, 0.0000305175781250,
-0.0023803710937500, 0.0000915527343750, -0.0025939941406250, 0.0000305175781250,
0.0005187988281250, 0.0000305175781250, 0.0119018554687500, 0.0000000000000000,
0.0089416503906250, 0.0000305175781250, 0.0142822265625000, 0.0000000000000000,
0.0163879394531250, 0.0000000000000000, 0.0142211914062500, 0.0000000000000000,
0.0147399902343750, 0.0000305175781250, 0.0156250000000000, -0.0000305175781250,
0.0092773437500000, 0.0000000000000000, 0.0104675292968750, -0.0000305175781250,
0.0072937011718750, 0.0000000000000000, 0.0010986328125000, 0.0000305175781250,
0.0036010742187500, 0.0000305175781250, -0.0028076171875000, 0.0000305175781250,
-0.0035400390625000, 0.0000305175781250, -0.0029907226562500, 0.0000305175781250,
-0.0057678222656250, 0.0000000000000000, -0.0053405761718750, -0.0000610351562500,
-0.0034179687500000, 0.0000305175781250, -0.0043334960937500, -0.0000305175781250,
-0.0026550292968750, 0.0000000000000000, 0.0000305175781250, 0.0000610351562500,
-0.0013122558593750, 0.0000000000000000, 0.0012817382812500, 0.0000000000000000,
0.0019531250000000, -0.0000305175781250, 0.0011596679687500, -0.0000305175781250,
0.0016174316406250, -0.0000305175781250, 0.0018615722656250, 0.0000000000000000,
0.0002136230468750, 0.0000610351562500, 0.0003356933593750, -0.0000610351562500,
0.0000915527343750, 0.0000305175781250, -0.0010681152343750, 0.0000915527343750,
-0.0007629394531250, 0.0000305175781250, -0.0003967285156250, 0.0000000000000000,
-0.0007629394531250, 0.0000610351562500, -0.0002441406250000, 0.0000305175781250,
0.0006408691406250, -0.0000915527343750, 0.0002136230468750, -0.0000305175781250,
0.0003967285156250, 0.0000000000000000, 0.0007934570312500, -0.0000610351562500,
0.0002746582031250, 0.0000000000000000, -0.0003356933593750, 0.0000610351562500,
0.0000610351562500, 0.0000305175781250, -0.0004577636718750, 0.0000305175781250,
-0.0007934570312500, 0.0000915527343750, -0.0003356933593750, 0.0000305175781250,
0.0000000000000000, -0.0001220703125000, -0.0003051757812500, 0.0000000000000000,
0.0002746582031250, -0.0000915527343750, 0.0004882812500000, -0.0001525878906250,
0.0001525878906250, -0.0000305175781250, 0.0000305175781250, 0.0000915527343750,
0.0002746582031250, 0.0000000000000000, -0.0003662109375000, 0.0000305175781250,
-0.0004882812500000, 0.0001831054687500, -0.0002136230468750, 0.0000305175781250,
-0.0003356933593750, -0.0001525878906250, -0.0005187988281250, 0.0000000000000000,
0.0002136230468750, -0.0001220703125000, 0.0002746582031250, -0.0002136230468750,
0.0000610351562500, -0.0000915527343750, 0.0002441406250000, 0.0001220703125000,
0.0003662109375000, 0.0000305175781250, -0.0002441406250000, -0.0000305175781250,
-0.0002441406250000, 0.0000915527343750, -0.0001220703125000, 0.0000305175781250,
-0.0002746582031250, -0.0002136230468750, -0.0002136230468750, -0.0001525878906250,
0.0001525878906250, 0.0000000000000000, 0.0001220703125000, -0.0000915527343750,
-0.0000305175781250, -0.0000305175781250, 0.0001220703125000, 0.0001220703125000,
0.0002136230468750, 0.0000610351562500, -0.0001831054687500, -0.0000305175781250,
-0.0002136230468750, 0.0000915527343750, -0.0000610351562500, 0.0000000000000000,
-0.0001525878906250, -0.0002441406250000, -0.0002441406250000, -0.0001525878906250,
0.0001525878906250, 0.0000000000000000, 0.0001525878906250, -0.0001525878906250,
0.0000000000000000, -0.0000610351562500, 0.0000915527343750, 0.0001831054687500,
0.0001525878906250, 0.0001525878906250, -0.0001525878906250, -0.0000610351562500,
-0.0002746582031250, 0.0000305175781250, -0.0001220703125000, -0.0000915527343750,
-0.0001220703125000, -0.0004577636718750, -0.0002441406250000, -0.0003051757812500,
0.0000915527343750, -0.0000915527343750, 0.0001525878906250, -0.0003356933593750,
0.0000305175781250, -0.0000915527343750, 0.0000915527343750, 0.0003662109375000,
0.0001525878906250, 0.0001525878906250, -0.0000915527343750, 0.0001525878906250,
-0.0001525878906250, 0.0003967285156250, -0.0000610351562500, 0.0000610351562500,
-0.0000915527343750, -0.0003356933593750, -0.0001525878906250, -0.0000915527343750,
0.0000915527343750, -0.0003051757812500, 0.0001220703125000, -0.0005187988281250,
0.0000305175781250, -0.0002441406250000, 0.0000915527343750, -0.0000305175781250,
0.0001220703125000, -0.0002136230468750, -0.0000305175781250, 0.0000610351562500,
-0.0000610351562500, 0.0002136230468750, 0.0000305175781250, 0.0000305175781250,
-0.0000610351562500, 0.0000000000000000, -0.0000915527343750, 0.0000610351562500,
0.0000305175781250, 0.0000610351562500, 0.0000305175781250, -0.0001525878906250,
0.0000305175781250, 0.0001220703125000, 0.0000610351562500, 0.0003967285156250,
0.0000610351562500, 0.0002441406250000, -0.0000305175781250, 0.0004577636718750,
0.0000000000000000, 0.0007019042968750, 0.0000000000000000, 0.0000915527343750,
-0.0000610351562500, -0.0002746582031250, -0.0000610351562500, 0.0000915527343750,
0.0000305175781250, -0.0014953613281250, -0.0000305175781250, -0.0016479492187500,
0.0000000000000000, -0.0013427734375000, 0.0000305175781250, -0.0022583007812500,
0.0000305175781250, -0.0021667480468750, -0.0000305175781250, 0.0005798339843750,
0.0000305175781250, -0.0004272460937500, 0.0000000000000000, 0.0015563964843750,
0.0000000000000000, 0.0051879882812500, 0.0000000000000000, 0.0034179687500000,
0.0000000000000000, 0.0059509277343750, 0.0000000000000000, 0.0077819824218750,
0.0000000000000000, 0.0041198730468750, 0.0000610351562500, 0.0031127929687500,
0.0000305175781250, 0.0046997070312500, 0.0000000000000000, -0.0105590820312500,
0.0000000000000000, -0.0063781738281250, 0.0000000000000000, -0.0167846679687500,
-0.0000305175781250, -0.0333862304687500, 0.0000000000000000, -0.0262756347656250,
0.0000000000000000, -0.0551147460937500, -0.0000305175781250, -0.0534973144531250,
-0.0000305175781250, -0.0661315917968750, 0.0000305175781250, -0.0904235839843750,
0.0000305175781250, -0.0820312500000000, 0.0000000000000000, -0.1137084960937500,
0.0000305175781250, -0.1163330078125000, 0.0000000000000000, -0.1253051757812500,
-0.0000305175781250, -0.1463012695312500, 0.0000305175781250, -0.1408081054687500,
0.0000305175781250, -0.1610412597656250, -0.0000305175781250, -0.1639709472656250,
0.0000000000000000, -0.1705322265625000, 0.0000000000000000, -0.1831970214843750,
0.0000000000000000, -0.1787719726562500, 0.0000305175781250, -0.1934814453125000,
0.0000000000000000, -0.1973876953125000, 0.0000305175781250, -0.1996154785156250,
0.0000305175781250, -0.2065124511718750, 0.0000000000000000, -0.2060852050781250,
0.0000000000000000, -0.2098999023437500, 0.0000000000000000, -0.2114868164062500,
-0.0000305175781250, -0.2106933593750000, -0.0000305175781250, -0.2119140625000000,
0.0000000000000000, -0.2128906250000000, 0.0000000000000000, -0.2082824707031250,
-0.0000305175781250, -0.2135314941406250, 0.0000000000000000, -0.2075500488281250,
-0.0000305175781250, -0.2004699707031250, -0.0000305175781250, -0.2072753906250000,
-0.0000305175781250, -0.1828918457031250, 0.0000000000000000, -0.1912536621093750,
-0.0000305175781250, -0.1777038574218750, 0.0000305175781250, -0.1558227539062500,
0.0000000000000000},
{-0.0000610351562500, -0.0003662109375000, -0.0001831054687500, -0.0001525878906250,
0.0001220703125000, -0.0002746582031250, 0.0001831054687500, -0.0004577636718750,
0.0000305175781250, -0.0001831054687500, 0.0000610351562500, 0.0001831054687500,
0.0001220703125000, -0.0000610351562500, -0.0001220703125000, 0.0000915527343750,
-0.0002136230468750, 0.0002746582031250, -0.0000305175781250, 0.0000915527343750,
-0.0000610351562500, -0.0000610351562500, -0.0001220703125000, 0.0000305175781250,
0.0000915527343750, 0.0001525878906250, 0.0000915527343750, -0.0000305175781250,
0.0000305175781250, 0.0001525878906250, 0.0000610351562500, 0.0004577636718750,
0.0000915527343750, 0.0002746582031250, -0.0000610351562500, -0.0000915527343750,
-0.0000610351562500, 0.0003356933593750, -0.0000305175781250, -0.0003662109375000,
-0.0000610351562500, -0.0014038085937500, -0.0000915527343750, -0.0007324218750000,
0.0000305175781250, -0.0013122558593750, 0.0000610351562500, -0.0021667480468750,
0.0000305175781250, -0.0004577636718750, 0.0000305175781250, 0.0007019042968750,
0.0000610351562500, -0.0004882812500000, -0.0000305175781250, 0.0037841796875000,
-0.0000610351562500, 0.0045776367187500, 0.0000000000000000, 0.0024108886718750,
-0.0000305175781250, 0.0044250488281250, -0.0000305175781250, 0.0047302246093750,
0.0000000000000000, -0.0105590820312500, 0.0000000000000000, -0.0035095214843750,
0.0000000000000000, -0.0202026367187500, 0.0000305175781250, -0.0411376953125000,
0.0000000000000000, -0.0286254882812500, 0.0000000000000000, -0.0752868652343750,
0.0000000000000000, -0.0705261230468750, 0.0000000000000000, -0.0866088867187500,
-0.0000305175781250, -0.1245422363281250, -0.0000305175781250, -0.1097106933593750,
0.0000000000000000, -0.1471252441406250, 0.0000305175781250, -0.1509399414062500,
0.0000305175781250, -0.1511535644531250, 0.0000305175781250, -0.1688842773437500,
0.0000305175781250, -0.1636962890625000, 0.0000000000000000, -0.1610412597656250,
0.0000305175781250, -0.1652526855468750, 0.0000305175781250, -0.1506042480468750,
0.0000000000000000, -0.1370239257812500, 0.0000305175781250, -0.1420288085937500,
0.0000000000000000, -0.1075439453125000, 0.0000305175781250, -0.1041259765625000,
0.0000305175781250, -0.0880737304687500, 0.0000610351562500, -0.0588989257812500,
0.0000610351562500, -0.0616149902343750, 0.0000610351562500, -0.0301513671875000,
0.0000305175781250, -0.0196228027343750, 0.0000610351562500, -0.0055847167968750,
0.0000000000000000, 0.0146179199218750, 0.0000000000000000, 0.0137329101562500,
0.0000305175781250, 0.0403747558593750, 0.0000610351562500, 0.0588073730468750,
0.0000915527343750, 0.0590820312500000, 0.0000305175781250, 0.0661621093750000,
0.0000000000000000, 0.0796508789062500, 0.0000305175781250, 0.0625000000000000,
0.0000000000000000, 0.0734863281250000, 0.0000305175781250, 0.0671081542968750,
0.0000000000000000, 0.0506591796875000, 0.0000000000000000, 0.0628662109375000,
0.0000305175781250, 0.0254821777343750, 0.0000610351562500, 0.0442810058593750,
0.0000305175781250, 0.0216979980468750, 0.0000000000000000, -0.0166015625000000,
0.0000000000000000, 0.0140991210937500, 0.0000000000000000, -0.0665588378906250,
0.0000000000000000, -0.0498657226562500, 0.0000305175781250, -0.0735778808593750,
0.0000305175781250, -0.1333007812500000, 0.0000305175781250, -0.0943603515625000,
0.0000305175781250, -0.1772460937500000, 0.0000305175781250, -0.1656494140625000,
0.0000305175781250, -0.1785583496093750, 0.0000000000000000, -0.2352600097656250,
0.0000305175781250, -0.2043457031250000, 0.0000000000000000, -0.2447814941406250,
-0.0000305175781250, -0.2521362304687500, 0.0000000000000000, -0.2363586425781250,
0.0000000000000000, -0.2489929199218750, 0.0000305175781250, -0.2535705566406250,
0.0000000000000000, -0.2068786621093750, 0.0000000000000000, -0.2268066406250000,
0.0000305175781250, -0.1941833496093750, -0.0000305175781250, -0.1424560546875000,
-0.0000305175781250, -0.1766662597656250, 0.0000305175781250, -0.0900573730468750,
0.0000000000000000, -0.1002197265625000, 0.0000000000000000, -0.0833740234375000,
0.0000305175781250, -0.0214233398437500, 0.0000305175781250, -0.0494079589843750,
-0.0000305175781250, -0.0059204101562500, -0.0000305175781250, -0.0004882812500000,
-0.0000305175781250, -0.0041198730468750, 0.0000000000000000, 0.0137023925781250,
-0.0000305175781250, 0.0091552734375000, 0.0000305175781250, 0.0067138671875000,
0.0000305175781250, 0.0104370117187500, 0.0000000000000000, 0.0064086914062500,
0.0000305175781250, 0.0003356933593750, 0.0000610351562500, 0.0033264160156250,
-0.0000610351562500, -0.0024108886718750, -0.0000915527343750, -0.0038146972656250,
-0.0000305175781250, -0.0023193359375000, -0.0000610351562500, -0.0035705566406250,
-0.0000915527343750, -0.0038452148437500, 0.0000915527343750, -0.0009765625000000,
0.0001220703125000, -0.0013732910156250, 0.0000305175781250, -0.0007934570312500,
0.0000305175781250, 0.0014038085937500, 0.0000915527343750, 0.0006103515625000,
-0.0000610351562500, 0.0009155273437500, -0.0000915527343750, 0.0015258789062500,
-0.0000305175781250, 0.0007629394531250, -0.0000915527343750, 0.0000915527343750,
-0.0001220703125000, 0.0006103515625000, 0.0000915527343750, -0.0003051757812500,
0.0001220703125000, -0.0005798339843750, 0.0000305175781250, -0.0001525878906250,
0.0000915527343750, -0.0001525878906250, 0.0001525878906250, -0.0003662109375000,
-0.0001220703125000, 0.0002746582031250, -0.0000610351562500, 0.0005187988281250,
-0.0000305175781250, 0.0000915527343750, -0.0002441406250000, 0.0000000000000000,
-0.0002136230468750, 0.0003051757812500, 0.0000305175781250, -0.0005798339843750,
-0.0000915527343750, -0.0007629394531250, 0.0000000000000000, -0.0002746582031250,
0.0003051757812500, -0.0003967285156250, 0.0001831054687500, -0.0006713867187500,
0.0000000000000000, 0.0006408691406250, 0.0001525878906250, 0.0007934570312500,
-0.0000305175781250, 0.0003051757812500, -0.0004272460937500, 0.0007629394531250,
-0.0002136230468750, 0.0010375976562500, -0.0001831054687500, -0.0006713867187500,
-0.0004882812500000, -0.0006103515625000, -0.0000915527343750, -0.0003051757812500,
0.0003051757812500, -0.0011901855468750, 0.0000000000000000, -0.0012207031250000,
0.0002746582031250, 0.0002441406250000, 0.0005493164062500, -0.0000305175781250,
0.0002136230468750, -0.0000305175781250, -0.0002746582031250, 0.0013732910156250,
-0.0004577636718750, -0.0011901855468750, 0.0005493164062500, 0.0004577636718750,
0.0004577636718750, -0.0001831054687500, 0.0001525878906250, -0.0000305175781250,
0.0003662109375000, 0.0009765625000000, 0.0006103515625000, 0.0008850097656250,
-0.0005187988281250, -0.0002746582031250, -0.0004882812500000, 0.0000000000000000,
-0.0003356933593750, -0.0000305175781250, -0.0010681152343750, -0.0010070800781250,
-0.0009460449218750, -0.0008544921875000, 0.0001525878906250, 0.0000610351562500,
-0.0002746582031250, -0.0002746582031250, 0.0000305175781250, -0.0001525878906250,
0.0011901855468750, 0.0007934570312500, 0.0007629394531250, 0.0005493164062500,
0.0002441406250000, 0.0000000000000000, 0.0008544921875000, 0.0003356933593750,
0.0002441406250000, 0.0001220703125000, -0.0010070800781250, -0.0006408691406250,
-0.0003051757812500, -0.0004272460937500, -0.0004882812500000, -0.0000610351562500,
-0.0011291503906250, -0.0003356933593750, -0.0004577636718750, -0.0001831054687500,
0.0004272460937500, 0.0004272460937500, -0.0001525878906250, 0.0002746582031250,
0.0001831054687500, 0.0000305175781250, 0.0006408691406250, 0.0003051757812500,
0.0002136230468750, 0.0000915527343750, -0.0003356933593750, -0.0003967285156250,
0.0000915527343750, -0.0002441406250000, 0.0000610351562500, -0.0000915527343750,
-0.0004882812500000, -0.0002441406250000, 0.0002746582031250, -0.0000610351562500,
0.0012817382812500, 0.0003051757812500, 0.0004882812500000, 0.0001525878906250,
0.0007934570312500, 0.0000305175781250, 0.0019531250000000, 0.0001831054687500,
-0.0000305175781250, 0.0000610351562500, -0.0017089843750000, -0.0002136230468750,
0.0001220703125000, -0.0000915527343750, -0.0033874511718750, -0.0000610351562500,
-0.0043945312500000, -0.0001831054687500, -0.0019531250000000, -0.0000610351562500,
-0.0025024414062500, 0.0001831054687500, -0.0039062500000000, 0.0000915527343750,
0.0045776367187500, -0.0000305175781250, 0.0023193359375000, 0.0000915527343750,
0.0037536621093750, 0.0000305175781250, 0.0117492675781250, -0.0001525878906250,
0.0082702636718750, -0.0001220703125000, 0.0037841796875000, 0.0000000000000000,
0.0124816894531250, -0.0000610351562500, -0.0030822753906250, 0.0000000000000000,
-0.0153198242187500, 0.0001220703125000, -0.0018615722656250, 0.0000915527343750,
-0.0572814941406250, 0.0000305175781250, -0.0406799316406250, 0.0000305175781250,
-0.0684204101562500, 0.0000305175781250, -0.1190490722656250, 0.0000000000000000,
-0.0856933593750000, 0.0000305175781250, -0.1685485839843750, 0.0000610351562500,
-0.1604614257812500, 0.0000305175781250, -0.1736755371093750, 0.0000305175781250,
-0.2297058105468750, 0.0000305175781250, -0.2012939453125000, 0.0001220703125000,
-0.2296447753906250, -0.0000305175781250, -0.2447814941406250, 0.0000000000000000,
-0.2177124023437500, 0.0000000000000000, -0.2159423828125000, -0.0000610351562500,
-0.2339172363281250, 0.0000000000000000, -0.1503295898437500, -0.0000305175781250,
-0.1871032714843750, -0.0000305175781250, -0.1301879882812500, -0.0000915527343750,
-0.0468139648437500, -0.0000915527343750, -0.1203308105468750, -0.0000305175781250,
0.0575866699218750, -0.0000915527343750, 0.0165100097656250, -0.0001525878906250,
0.0634155273437500, -0.0001220703125000, 0.1908264160156250, -0.0000915527343750,
0.0997924804687500, -0.0000915527343750, 0.2805786132812500, -0.0000915527343750,
0.2435607910156250, -0.0000915527343750, 0.2745361328125000, -0.0001220703125000,
0.4007873535156250, -0.0001831054687500, 0.3213806152343750, -0.0001525878906250,
0.4457092285156250, -0.0001525878906250, 0.4286804199218750, -0.0001220703125000,
0.4397583007812500, -0.0001525878906250, 0.5110778808593750, -0.0001220703125000,
0.4535217285156250, -0.0001525878906250, 0.5212707519531250, -0.0000915527343750,
0.5078430175781250, -0.0001220703125000, 0.5019531250000000, -0.0001220703125000,
0.5344543457031250, -0.0001220703125000, 0.5009460449218750, -0.0001220703125000,
0.5220336914062500, -0.0001220703125000, 0.5114746093750000, -0.0001525878906250,
0.4958496093750000, -0.0000915527343750, 0.5010375976562500, -0.0001220703125000,
0.4836120605468750, -0.0001525878906250, 0.4528503417968750, -0.0000915527343750,
0.4474487304687500, -0.0001525878906250, 0.4190063476562500, -0.0001525878906250,
0.3813476562500000, -0.0001525878906250, 0.3710327148437500, -0.0001220703125000,
0.3111267089843750, -0.0001220703125000, 0.3122863769531250, -0.0001220703125000,
0.2676391601562500, -0.0001220703125000, 0.2079772949218750, -0.0001220703125000,
0.2244262695312500, -0.0001525878906250, 0.1175231933593750, -0.0001220703125000,
0.1272888183593750, -0.0000915527343750, 0.0883789062500000, -0.0000915527343750,
0.0020141601562500, -0.0000610351562500, 0.0303344726562500, -0.0000915527343750,
-0.0708618164062500, -0.0000915527343750, -0.0721435546875000, -0.0000305175781250,
-0.0913696289062500, -0.0000305175781250, -0.1585083007812500, -0.0000305175781250,
-0.1396789550781250, -0.0000305175781250, -0.1784973144531250, 0.0000000000000000,
-0.1894836425781250},
{0.0083007812500000, -0.0000305175781250, 0.0116271972656250, 0.0000915527343750,
0.0025634765625000, 0.0000305175781250, 0.0041503906250000, -0.0001831054687500,
0.0093078613281250, -0.0001525878906250, -0.0322570800781250, 0.0000305175781250,
-0.0124206542968750, -0.0000305175781250, -0.0438537597656250, 0.0000000000000000,
-0.0908203125000000, 0.0001831054687500, -0.0549011230468750, 0.0001220703125000,
-0.1434326171875000, 0.0000000000000000, -0.1344909667968750, 0.0000305175781250,
-0.1454772949218750, 0.0000305175781250, -0.2061157226562500, -0.0000610351562500,
-0.1795043945312500, -0.0000915527343750, -0.1961364746093750, 0.0000305175781250,
-0.2187194824218750, 0.0000305175781250, -0.1791687011718750, 0.0000000000000000,
-0.1627502441406250, 0.0000610351562500, -0.1898498535156250, 0.0000915527343750,
-0.0513305664062500, -0.0000915527343750, -0.0980834960937500, -0.0001220703125000,
-0.0146179199218750, -0.0000915527343750, 0.1170959472656250, -0.0001525878906250,
0.0196228027343750, -0.0001525878906250, 0.2698974609375000, -0.0000610351562500,
0.2206420898437500, -0.0000915527343750, 0.2865600585937500, -0.0000915527343750,
0.4734191894531250, -0.0000610351562500, 0.3590087890625000, -0.0000915527343750,
0.5651550292968750, -0.0001220703125000, 0.5540771484375000, -0.0001525878906250,
0.5686340332031250, -0.0001525878906250, 0.6908264160156250, -0.0000305175781250,
0.6331481933593750, -0.0000915527343750, 0.6972656250000000, 0.0000000000000000,
0.7143249511718750, -0.0000305175781250, 0.6896362304687500, 0.0000305175781250,
0.7058410644531250, 0.0000915527343750, 0.7147827148437500, 0.0000610351562500,
0.6542968750000000, 0.0000610351562500, 0.6873168945312500, 0.0000610351562500,
0.6541442871093750, 0.0000610351562500, 0.5924072265625000, 0.0001220703125000,
0.6428527832031250, 0.0001220703125000, 0.5401306152343750, 0.0000915527343750,
0.5627136230468750, 0.0001220703125000, 0.5421752929687500, 0.0001220703125000,
0.4743957519531250, 0.0001220703125000, 0.5333557128906250, 0.0001220703125000,
0.4571838378906250, 0.0001831054687500, 0.4742126464843750, 0.0001220703125000,
0.4725341796875000, 0.0001220703125000, 0.4301147460937500, 0.0001525878906250,
0.4719848632812500, 0.0001525878906250, 0.4333496093750000, 0.0001220703125000,
0.4460754394531250, 0.0001525878906250, 0.4577636718750000, 0.0001831054687500,
0.4414367675781250, 0.0001831054687500, 0.4655761718750000, 0.0001220703125000,
0.4785156250000000, 0.0001525878906250, 0.4913330078125000, 0.0001220703125000,
0.5095520019531250, 0.0000915527343750, 0.5263061523437500, 0.0000915527343750,
0.5427246093750000, 0.0001220703125000, 0.5643310546875000, 0.0000915527343750,
0.5682678222656250, 0.0000915527343750, 0.5830383300781250, 0.0000305175781250,
0.6027526855468750, 0.0000610351562500, 0.5990905761718750, 0.0000610351562500,
0.6097717285156250, -0.0000305175781250, 0.6153259277343750, 0.0000610351562500,
0.6008300781250000, 0.0000305175781250, 0.5996093750000000, -0.0000305175781250,
0.6055603027343750, 0.0000000000000000, 0.5392150878906250, -0.0000610351562500,
0.5599975585937500, -0.0000610351562500, 0.5082397460937500, -0.0000305175781250,
0.4350280761718750, -0.0000610351562500, 0.4738769531250000, -0.0000610351562500,
0.3220214843750000, -0.0000915527343750, 0.3400878906250000, -0.0000610351562500,
0.2742614746093750, -0.0000610351562500, 0.1441345214843750, -0.0000915527343750,
0.1986694335937500, -0.0001220703125000, 0.0292358398437500, -0.0001220703125000,
0.0314941406250000, -0.0001220703125000, 0.0014038085937500, -0.0000610351562500,
-0.1085510253906250, -0.0000305175781250, -0.0688171386718750, -0.0001220703125000,
-0.1364746093750000, 0.0000305175781250, -0.1553344726562500, 0.0000305175781250,
-0.1380920410156250, -0.0000305175781250, -0.1545104980468750, 0.0000000000000000,
-0.1577758789062500, 0.0000305175781250, -0.1083679199218750, -0.0000305175781250,
-0.1213684082031250, -0.0000610351562500, -0.0967407226562500, -0.0000305175781250,
-0.0484619140625000, 0.0000610351562500, -0.0718383789062500, -0.0000305175781250,
-0.0201416015625000, 0.0000610351562500, -0.0151062011718750, 0.0000915527343750,
-0.0152893066406250, 0.0000305175781250, 0.0088806152343750, 0.0000000000000000,
0.0026245117187500, -0.0000305175781250, 0.0029296875000000, -0.0000610351562500,
0.0068969726562500, -0.0000915527343750, 0.0031127929687500, 0.0000000000000000,
-0.0019226074218750, -0.0000305175781250, 0.0005187988281250, -0.0000610351562500,
-0.0016784667968750, 0.0000915527343750, -0.0033569335937500, 0.0000915527343750,
-0.0014648437500000, 0.0000000000000000, -0.0000305175781250, -0.0000305175781250,
-0.0011901855468750, 0.0000915527343750, 0.0007934570312500, -0.0001220703125000,
0.0014953613281250, -0.0001220703125000, 0.0005187988281250, -0.0000305175781250,
0.0003051757812500, 0.0000000000000000, 0.0008239746093750, -0.0001220703125000,
-0.0003356933593750, 0.0000610351562500, -0.0007324218750000, 0.0001525878906250,
-0.0001831054687500, 0.0000000000000000, -0.0001831054687500, 0.0000000000000000,
-0.0004577636718750, 0.0001220703125000, 0.0002441406250000, -0.0001220703125000,
0.0004577636718750, -0.0001525878906250, 0.0000915527343750, -0.0000305175781250,
0.0000305175781250, -0.0000610351562500, 0.0002441406250000, -0.0001831054687500,
-0.0003051757812500, 0.0000610351562500, -0.0005187988281250, 0.0001220703125000,
-0.0001831054687500, 0.0000000000000000, -0.0000610351562500, 0.0000000000000000,
-0.0003051757812500, 0.0000915527343750, 0.0002136230468750, -0.0001220703125000,
0.0003356933593750, -0.0001831054687500, 0.0000610351562500, -0.0000305175781250,
-0.0000915527343750, 0.0000000000000000, -0.0000915527343750, -0.0000305175781250,
-0.0001525878906250, 0.0000000000000000, -0.0003356933593750, 0.0000915527343750,
-0.0001220703125000, -0.0000305175781250, 0.0000915527343750, -0.0001220703125000,
-0.0001220703125000, 0.0000305175781250, 0.0000915527343750, -0.0001220703125000,
0.0002746582031250, -0.0002441406250000, 0.0000305175781250, -0.0000915527343750,
-0.0001831054687500, 0.0000610351562500, 0.0000000000000000, -0.0000610351562500,
-0.0001220703125000, 0.0000000000000000, -0.0003662109375000, 0.0001220703125000,
-0.0000915527343750, -0.0000610351562500, 0.0001525878906250, -0.0002441406250000,
-0.0000610351562500, -0.0001525878906250, 0.0000915527343750, -0.0000915527343750,
0.0003051757812500, -0.0002136230468750, 0.0000305175781250, -0.0000915527343750,
-0.0002136230468750, 0.0002136230468750, -0.0000305175781250, 0.0000915527343750,
-0.0001220703125000, 0.0000305175781250, -0.0003051757812500, 0.0002136230468750,
-0.0000915527343750, 0.0000000000000000, 0.0001220703125000, -0.0003051757812500,
-0.0000610351562500, -0.0001220703125000, 0.0000915527343750, 0.0000915527343750,
0.0002441406250000, -0.0001220703125000, 0.0000305175781250, -0.0000305175781250,
-0.0001525878906250, 0.0004272460937500, 0.0000000000000000, 0.0002746582031250,
-0.0000610351562500, -0.0006103515625000, -0.0002441406250000, -0.0002746582031250,
-0.0000915527343750, -0.0002746582031250, 0.0000610351562500, -0.0013732910156250,
-0.0000305175781250, -0.0011291503906250, 0.0000915527343750, 0.0010375976562500,
0.0001831054687500, 0.0002136230468750, 0.0000610351562500, 0.0005493164062500,
-0.0000305175781250, 0.0038452148437500, 0.0000610351562500, 0.0026855468750000,
-0.0000610351562500, -0.0050964355468750, -0.0001525878906250, 0.0025024414062500,
-0.0000610351562500, -0.0142211914062500, 0.0000000000000000, -0.0303955078125000,
-0.0000305175781250, -0.0166015625000000, 0.0000305175781250, -0.0654907226562500,
0.0001220703125000, -0.0609436035156250, 0.0000610351562500, -0.0723876953125000,
0.0000305175781250, -0.1112365722656250, 0.0000610351562500, -0.0959167480468750,
-0.0000305175781250, -0.1021118164062500, -0.0000915527343750, -0.1207885742187500,
-0.0000610351562500, -0.0810241699218750, -0.0000305175781250, -0.0541992187500000,
-0.0000610351562500, -0.0758056640625000, 0.0000305175781250, 0.0495300292968750,
0.0000305175781250, 0.0273437500000000, 0.0000000000000000, 0.0885925292968750,
0.0000305175781250, 0.2033386230468750, 0.0000610351562500, 0.1488342285156250,
-0.0000610351562500, 0.2929077148437500, -0.0000610351562500, 0.2959899902343750,
0.0000000000000000, 0.3153991699218750, 0.0000000000000000, 0.4041442871093750,
-0.0000305175781250, 0.3754577636718750, 0.0000610351562500, 0.4122314453125000,
0.0000305175781250, 0.4290466308593750, 0.0000305175781250, 0.4094238281250000,
0.0000305175781250, 0.4059753417968750, 0.0000000000000000, 0.4099121093750000,
-0.0000305175781250, 0.3624267578125000, -0.0000610351562500, 0.3666381835937500,
0.0000000000000000, 0.3320922851562500, -0.0000305175781250, 0.2805175781250000,
-0.0000305175781250, 0.2956848144531250, 0.0000000000000000, 0.2190856933593750,
0.0000000000000000, 0.2077331542968750, 0.0000000000000000, 0.1836242675781250,
0.0000000000000000, 0.1311645507812500, 0.0000305175781250, 0.1366882324218750,
0.0000000000000000, 0.0901489257812500, -0.0000305175781250, 0.0741882324218750,
0.0000000000000000, 0.0563659667968750, 0.0000000000000000, 0.0293884277343750,
-0.0000305175781250, 0.0315856933593750, 0.0000000000000000, -0.0009155273437500,
0.0000000000000000, -0.0235290527343750, 0.0000000000000000, -0.0231628417968750,
0.0000305175781250, -0.0302124023437500, 0.0000305175781250, -0.0454406738281250,
-0.0000610351562500, -0.0256347656250000, -0.0000305175781250, -0.0380554199218750,
0.0000000000000000, -0.0289611816406250, 0.0000000000000000, -0.0097961425781250,
-0.0000610351562500, -0.0252380371093750, -0.0000305175781250, 0.0234680175781250,
0.0000000000000000, -0.0022583007812500, 0.0000000000000000, 0.0271911621093750,
0.0000000000000000, 0.0764770507812500, -0.0000305175781250, 0.0380554199218750,
0.0000000000000000, 0.1557006835937500, -0.0000610351562500, 0.1248779296875000,
-0.0000305175781250, 0.1725463867187500, 0.0000000000000000, 0.2669677734375000,
-0.0000305175781250, 0.2007751464843750, 0.0000000000000000, 0.3692321777343750,
0.0000000000000000, 0.3299560546875000, -0.0000305175781250, 0.3825683593750000,
0.0000305175781250, 0.5145263671875000, 0.0000000000000000, 0.4292602539062500,
0.0000000000000000, 0.6030883789062500, -0.0000305175781250, 0.5871887207031250,
0.0000000000000000, 0.5936889648437500, 0.0000000000000000, 0.7033996582031250,
0.0000000000000000, 0.6585083007812500, 0.0000000000000000, 0.6726074218750000,
0.0000305175781250, 0.7183532714843750, 0.0000305175781250, 0.6428833007812500,
0.0000000000000000, 0.5941772460937500, -0.0000305175781250, 0.6524047851562500,
0.0000610351562500, 0.4279785156250000, 0.0000305175781250, 0.4888610839843750,
0.0000610351562500, 0.3830566406250000, 0.0000915527343750, 0.1737365722656250,
0.0000915527343750, 0.2944335937500000, 0.0000305175781250, 0.0174255371093750,
0.0000610351562500, 0.0299987792968750, 0.0000305175781250, -0.0063476562500000,
-0.0000610351562500, -0.1809692382812500, 0.0000000000000000, -0.1044616699218750,
0.0000610351562500, -0.1994018554687500, 0.0000000000000000, -0.2271423339843750,
0.0000000000000000, -0.1939697265625000, 0.0000305175781250, -0.2118225097656250,
0.0000305175781250, -0.2202758789062500, -0.0000610351562500, -0.1451721191406250,
-0.0000305175781250, -0.1622009277343750, -0.0000305175781250, -0.1290283203125000,
-0.0000915527343750},
{-0.0000305175781250, 0.3160400390625000, 0.0000000000000000, 0.3126220703125000,
-0.0000610351562500, 0.3286132812500000, 0.0000000000000000, 0.2206115722656250,
0.0000305175781250, 0.2425537109375000, 0.0000000000000000, 0.1859436035156250,
-0.0000305175781250, 0.0814514160156250, 0.0000000000000000, 0.1233520507812500,
-0.0000305175781250, -0.0210571289062500, -0.0000610351562500, -0.0212097167968750,
-0.0000305175781250, -0.0508728027343750, 0.0000000000000000, -0.1446228027343750,
0.0000000000000000, -0.1138305664062500, 0.0000305175781250, -0.1896362304687500,
0.0000305175781250, -0.1954650878906250, 0.0000000000000000, -0.2021789550781250,
0.0000000000000000, -0.2429199218750000, 0.0000305175781250, -0.2324523925781250,
0.0000000000000000, -0.2580261230468750, 0.0000000000000000, -0.2601013183593750,
0.0000610351562500, -0.2605590820312500, 0.0000000000000000, -0.2698669433593750,
0.0000000000000000, -0.2619018554687500, 0.0000305175781250, -0.2692871093750000,
0.0000305175781250, -0.2641296386718750, 0.0000305175781250, -0.2657775878906250,
0.0000305175781250, -0.2727050781250000, 0.0000000000000000, -0.2640380859375000,
0.0000305175781250, -0.2704162597656250, 0.0000305175781250, -0.2625427246093750,
0.0000305175781250, -0.2679748535156250, 0.0000305175781250, -0.2770385742187500,
0.0000305175781250, -0.2648315429687500, 0.0000000000000000, -0.2878417968750000,
0.0000305175781250, -0.2834472656250000, 0.0000305175781250, -0.2873229980468750,
0.0000305175781250, -0.3028564453125000, 0.0000305175781250, -0.2961425781250000,
0.0000000000000000, -0.3211669921875000, 0.0000000000000000, -0.3146362304687500,
0.0000305175781250, -0.3257141113281250, 0.0000000000000000, -0.3464355468750000,
0.0000000000000000, -0.3313293457031250, 0.0000305175781250, -0.3673095703125000,
0.0000305175781250, -0.3642578125000000, 0.0000000000000000, -0.3645019531250000,
0.0000305175781250, -0.3868103027343750, 0.0000305175781250, -0.3794250488281250,
0.0000000000000000, -0.3788452148437500, -0.0000610351562500, -0.3941650390625000,
-0.0000305175781250, -0.3692016601562500, 0.0000000000000000, -0.3576660156250000,
0.0000305175781250, -0.3786315917968750, 0.0000305175781250, -0.2630920410156250,
0.0000000000000000, -0.3168029785156250, -0.0000305175781250, -0.2381591796875000,
-0.0000610351562500, -0.1211242675781250, -0.0000610351562500, -0.2143859863281250,
-0.0000305175781250, 0.0605773925781250, -0.0000610351562500, 0.0011291503906250,
-0.0000305175781250, 0.1068420410156250, 0.0000000000000000, 0.3385925292968750,
-0.0000305175781250, 0.2033996582031250, 0.0000000000000000, 0.4976806640625000,
0.0000000000000000, 0.4801940917968750, -0.0000305175781250, 0.4971923828125000,
-0.0000610351562500, 0.6837768554687500, -0.0000305175781250, 0.6147460937500000,
0.0000000000000000, 0.6313171386718750, 0.0000000000000000, 0.6900024414062500,
-0.0000305175781250, 0.5909729003906250, 0.0000610351562500, 0.5202026367187500,
0.0000305175781250, 0.5898437500000000, 0.0000000000000000, 0.3266601562500000,
0.0000610351562500, 0.3740234375000000, 0.0000000000000000, 0.2809143066406250,
-0.0000915527343750, 0.0599365234375000, -0.0000305175781250, 0.1621093750000000,
0.0000305175781250, -0.0723266601562500, -0.0000305175781250, -0.0885620117187500,
0.0000000000000000, -0.0924987792968750, 0.0001220703125000, -0.2107849121093750,
0.0000915527343750, -0.1747741699218750, 0.0000000000000000, -0.1756591796875000,
0.0000305175781250, -0.2087402343750000, 0.0000000000000000, -0.1649169921875000,
-0.0001831054687500, -0.1201477050781250, -0.0001525878906250, -0.1507873535156250,
-0.0000305175781250, -0.0588989257812500, -0.0000915527343750, -0.0612792968750000,
-0.0000305175781250, -0.0518493652343750, 0.0001220703125000, 0.0028991699218750,
0.0000915527343750, -0.0177001953125000, 0.0000000000000000, 0.0032348632812500,
0.0000915527343750, 0.0121765136718750, -0.0000305175781250, 0.0037231445312500,
-0.0002136230468750, 0.0038452148437500, -0.0001220703125000, 0.0070800781250000,
-0.0001220703125000, -0.0018005371093750, -0.0002136230468750, -0.0032348632812500,
-0.0000610351562500, -0.0008544921875000, 0.0001831054687500, -0.0028686523437500,
0.0000000000000000, -0.0036926269531250, 0.0001220703125000, 0.0004882812500000,
0.0002441406250000, 0.0004577636718750, 0.0000000000000000, -0.0002441406250000,
-0.0001831054687500, 0.0015563964843750, 0.0000000000000000, 0.0016174316406250,
-0.0003051757812500, -0.0003356933593750, -0.0004272460937500, -0.0003051757812500,
-0.0001831054687500, 0.0001525878906250, -0.0000305175781250, -0.0006713867187500,
-0.0002441406250000, -0.0008544921875000, 0.0002441406250000, 0.0004882812500000,
0.0003662109375000, 0.0005493164062500, 0.0001831054687500, 0.0000000000000000,
0.0002441406250000, 0.0003662109375000, 0.0003662109375000, 0.0007019042968750,
-0.0003356933593750, -0.0007019042968750, -0.0003356933593750, -0.0007629394531250,
-0.0002136230468750, -0.0003051757812500, -0.0006103515625000, -0.0005798339843750,
0.0004272460937500, 0.0007324218750000, -0.0000610351562500, -0.0007324218750000,
0.0003662109375000, -0.0006103515625000, 0.0000000000000000, -0.0001525878906250,
-0.0006408691406250, -0.0003051757812500, -0.0003356933593750, -0.0006408691406250,
-0.0002441406250000, 0.0005187988281250, -0.0005493164062500, 0.0007324218750000,
-0.0001525878906250, 0.0001525878906250, 0.0003356933593750, 0.0003051757812500,
-0.0000305175781250, 0.0006713867187500, 0.0003662109375000, -0.0005187988281250,
0.0004882812500000, -0.0007324218750000, 0.0003662109375000, -0.0002136230468750,
0.0003662109375000, -0.0004577636718750, 0.0003662109375000, -0.0007019042968750,
0.0003662109375000, 0.0003356933593750, 0.0004882812500000, 0.0003967285156250,
-0.0000610351562500, 0.0000610351562500, -0.0002746582031250, 0.0003662109375000,
0.0001831054687500, 0.0005493164062500, -0.0018615722656250, -0.0003051757812500,
-0.0019836425781250, -0.0003356933593750, -0.0008239746093750, -0.0001220703125000,
-0.0018615722656250, -0.0004272460937500, -0.0025634765625000, -0.0005187988281250,
0.0037841796875000, 0.0002136230468750, 0.0023803710937500, 0.0002441406250000,
0.0017089843750000, 0.0000610351562500, 0.0090637207031250, 0.0003051757812500,
0.0071716308593750, 0.0003356933593750, -0.0144653320312500, -0.0002441406250000,
0.0032043457031250, -0.0002136230468750, -0.0295715332031250, -0.0000610351562500,
-0.0657653808593750, -0.0002441406250000, -0.0347595214843750, -0.0003356933593750,
-0.1291503906250000, 0.0001220703125000, -0.1205139160156250, 0.0001525878906250,
-0.1248168945312500, 0.0000305175781250, -0.1901245117187500, 0.0001831054687500,
-0.1668395996093750, 0.0002441406250000, -0.1335144042968750, -0.0001831054687500,
-0.1834716796875000, -0.0001831054687500, -0.1004333496093750, -0.0000915527343750,
-0.0203247070312500, -0.0002441406250000, -0.0961608886718750, -0.0002441406250000,
0.1483764648437500, -0.0000305175781250, 0.0954589843750000, 0.0000000000000000,
0.1718750000000000, -0.0000610351562500, 0.3688659667968750, 0.0000000000000000,
0.2542724609375000, 0.0000305175781250, 0.4536437988281250, -0.0001220703125000,
0.4649353027343750, -0.0001525878906250, 0.4519653320312500, -0.0000610351562500,
0.5510559082031250, -0.0000305175781250, 0.5249328613281250, -0.0001220703125000,
0.4800720214843750, 0.0001220703125000, 0.5305175781250000, 0.0001525878906250,
0.4505310058593750, 0.0000915527343750, 0.3665161132812500, 0.0001220703125000,
0.4372253417968750, 0.0001831054687500, 0.1932678222656250, 0.0000915527343750,
0.2441711425781250, 0.0000610351562500, 0.1556396484375000, 0.0000915527343750,
-0.0392150878906250, 0.0001525878906250, 0.0824584960937500, 0.0001525878906250,
-0.1699523925781250, 0.0001220703125000, -0.1471557617187500, 0.0001831054687500,
-0.1752624511718750, 0.0001220703125000, -0.3342285156250000, 0.0000305175781250,
-0.2558288574218750, 0.0000915527343750, -0.3575134277343750, 0.0000305175781250,
-0.3742675781250000, 0.0000305175781250, -0.3543090820312500, -0.0000305175781250,
-0.3918457031250000, 0.0000000000000000, -0.3932189941406250, 0.0000610351562500,
-0.3603820800781250, -0.0000610351562500, -0.3801574707031250, 0.0000000000000000,
-0.3604431152343750, -0.0000305175781250, -0.3271789550781250, -0.0000915527343750,
-0.3571777343750000, -0.0000610351562500, -0.2940368652343750, -0.0000305175781250,
-0.3093261718750000, -0.0000610351562500, -0.2996215820312500, -0.0000305175781250,
-0.2549133300781250, 0.0000000000000000, -0.2824401855468750, -0.0000305175781250,
-0.2401428222656250, -0.0000305175781250, -0.2429199218750000, -0.0000305175781250,
-0.2402648925781250, -0.0000305175781250, -0.2182006835937500, 0.0000000000000000,
-0.2340393066406250, -0.0000305175781250, -0.2107849121093750, 0.0000000000000000,
-0.2144165039062500, -0.0000305175781250, -0.2143554687500000, 0.0000000000000000,
-0.2019348144531250, 0.0000000000000000, -0.2109985351562500, -0.0000305175781250,
-0.1992492675781250, 0.0000000000000000, -0.2037963867187500, -0.0000305175781250,
-0.2044677734375000, 0.0000000000000000, -0.1965026855468750, -0.0000305175781250,
-0.2038574218750000, -0.0000305175781250, -0.2048645019531250, 0.0000000000000000,
-0.2093811035156250, -0.0000610351562500, -0.2155456542968750, -0.0000610351562500,
-0.2205200195312500, 0.0000000000000000, -0.2306213378906250, -0.0000305175781250,
-0.2446594238281250, -0.0000305175781250, -0.2445678710937500, -0.0000610351562500,
-0.2603759765625000, -0.0000305175781250, -0.2777099609375000, -0.0000610351562500,
-0.2731018066406250, -0.0000610351562500, -0.3054199218750000, 0.0000000000000000,
-0.3032226562500000, -0.0000305175781250, -0.3119812011718750, -0.0000305175781250,
-0.3390197753906250, -0.0000305175781250, -0.3319091796875000, -0.0000305175781250,
-0.3377685546875000, -0.0000305175781250, -0.3494262695312500, -0.0000305175781250,
-0.3274230957031250, 0.0000000000000000, -0.3177795410156250, 0.0000305175781250,
-0.3349304199218750, -0.0000305175781250, -0.2527770996093750, 0.0000915527343750,
-0.2767333984375000, 0.0000915527343750, -0.2135925292968750, 0.0000915527343750,
-0.1224365234375000, 0.0000915527343750, -0.1685791015625000, 0.0000915527343750,
0.0170593261718750, 0.0000610351562500, -0.0044555664062500, 0.0000610351562500,
0.0632934570312500, 0.0000915527343750, 0.2150573730468750, 0.0000915527343750,
0.1500854492187500, 0.0000610351562500, 0.3133850097656250, 0.0000915527343750,
0.3303527832031250, 0.0001525878906250, 0.3320312500000000, 0.0000610351562500,
0.4168090820312500, 0.0000610351562500, 0.3965454101562500, 0.0000610351562500,
0.3557739257812500, -0.0000915527343750, 0.3990478515625000, -0.0000915527343750,
0.3243713378906250, -0.0000610351562500, 0.2373657226562500, -0.0001220703125000,
0.2948303222656250, -0.0000915527343750, 0.1031188964843750, 0.0000000000000000,
0.1145935058593750, -0.0000610351562500, 0.0716247558593750, -0.0000915527343750,
-0.0651245117187500, 0.0000000000000000, -0.0120849609375000, -0.0000305175781250,
-0.0935363769531250, -0.0000610351562500, -0.1192626953125000, -0.0000610351562500,
-0.0914611816406250, 0.0000000000000000, -0.1026306152343750, -0.0000610351562500,
-0.1116943359375000, -0.0000915527343750, -0.0538330078125000, 0.0000610351562500,
-0.0621948242187500, 0.0000610351562500, -0.0488891601562500, 0.0000000000000000,
-0.0049133300781250, 0.0000610351562500, -0.0220642089843750, 0.0000915527343750,
-0.0011291503906250},
{-0.2001037597656250, 0.0000305175781250, -0.2456665039062500, 0.0000305175781250,
-0.2269592285156250, 0.0000000000000000, -0.2497253417968750, 0.0000305175781250,
-0.2909240722656250, 0.0000610351562500, -0.2571411132812500, 0.0000610351562500,
-0.3307495117187500, 0.0000305175781250, -0.3139343261718750, 0.0000915527343750,
-0.3263854980468750, 0.0000610351562500, -0.3778686523437500, 0.0000610351562500,
-0.3444824218750000, 0.0000305175781250, -0.3950805664062500, 0.0000610351562500,
-0.3894653320312500, 0.0000915527343750, -0.3923339843750000, 0.0000610351562500,
-0.4198608398437500, 0.0000610351562500, -0.3983459472656250, 0.0000610351562500,
-0.4223632812500000, 0.0000305175781250, -0.4167175292968750, 0.0000000000000000,
-0.4132690429687500, 0.0000305175781250, -0.4241027832031250, 0.0000610351562500,
-0.4111633300781250, 0.0000305175781250, -0.4167175292968750, 0.0000915527343750,
-0.4142761230468750, 0.0000915527343750, -0.4050598144531250, 0.0000305175781250,
-0.4025268554687500, 0.0000610351562500, -0.3982543945312500, 0.0000915527343750,
-0.3796081542968750, 0.0000610351562500, -0.3769836425781250, 0.0000305175781250,
-0.3611145019531250, 0.0000610351562500, -0.3398742675781250, 0.0000610351562500,
-0.3381042480468750, 0.0000610351562500, -0.3048400878906250, 0.0000915527343750,
-0.3048400878906250, 0.0000610351562500, -0.2859802246093750, 0.0000915527343750,
-0.2561340332031250, 0.0000915527343750, -0.2636413574218750, 0.0000915527343750,
-0.2211914062500000, 0.0000610351562500, -0.2213745117187500, 0.0000305175781250,
-0.2101745605468750, 0.0000610351562500, -0.1787109375000000, 0.0000305175781250,
-0.1869506835937500, 0.0000305175781250, -0.1699523925781250, 0.0000305175781250,
-0.1628417968750000, 0.0000610351562500, -0.1697998046875000, -0.0000305175781250,
-0.1674804687500000, -0.0000305175781250, -0.1642150878906250, 0.0000000000000000,
-0.1912536621093750, -0.0000305175781250, -0.1862792968750000, -0.0000305175781250,
-0.2048034667968750, -0.0000305175781250, -0.2355651855468750, -0.0000610351562500,
-0.2236633300781250, -0.0000610351562500, -0.2579040527343750, 0.0000305175781250,
-0.2665405273437500, -0.0000305175781250, -0.2499389648437500, 0.0000305175781250,
-0.2595825195312500, 0.0000610351562500, -0.2648315429687500, 0.0000000000000000,
-0.1848449707031250, 0.0000305175781250, -0.2168579101562500, 0.0000000000000000,
-0.1430358886718750, 0.0000305175781250, -0.0445251464843750, 0.0000305175781250,
-0.1026000976562500, 0.0000305175781250, 0.1078491210937500, 0.0000610351562500,
0.0925903320312500, 0.0001220703125000, 0.1409606933593750, 0.0000915527343750,
0.2926940917968750, 0.0000915527343750, 0.2304077148437500, 0.0001220703125000,
0.3198547363281250, -0.0000305175781250, 0.3576965332031250, -0.0000305175781250,
0.3060607910156250, -0.0000305175781250, 0.3072509765625000, -0.0001220703125000,
0.3303833007812500, -0.0001220703125000, 0.1734008789062500, -0.0000610351562500,
0.2041931152343750, -0.0000915527343750, 0.1385803222656250, -0.0000305175781250,
-0.0032653808593750, 0.0000610351562500, 0.0639038085937500, -0.0000305175781250,
-0.0621948242187500, -0.0000610351562500, -0.0830383300781250, -0.0000305175781250,
-0.0627441406250000, -0.0000610351562500, -0.1054382324218750, -0.0001525878906250,
-0.1021728515625000, -0.0001525878906250, -0.0579833984375000, 0.0000305175781250,
-0.0721435546875000, 0.0000000000000000, -0.0534973144531250, 0.0000000000000000,
-0.0098571777343750, 0.0001525878906250, -0.0296936035156250, 0.0001220703125000,
-0.0032653808593750, -0.0000915527343750, 0.0046997070312500, 0.0000305175781250,
-0.0018310546875000, 0.0000000000000000, 0.0020751953125000, -0.0001831054687500,
0.0031738281250000, -0.0001525878906250, -0.0011901855468750, 0.0000305175781250,
-0.0020751953125000, -0.0000610351562500, -0.0005798339843750, -0.0000610351562500,
-0.0009155273437500, 0.0001220703125000, -0.0016479492187500, 0.0001220703125000,
0.0003967285156250, -0.0000915527343750, 0.0009155273437500, 0.0000000000000000,
0.0000915527343750, -0.0000305175781250, 0.0002441406250000, -0.0001525878906250,
0.0006103515625000, -0.0001525878906250, -0.0003051757812500, -0.0000305175781250,
-0.0005187988281250, 0.0000000000000000, -0.0001525878906250, -0.0000305175781250,
0.0000610351562500, 0.0000000000000000, 0.0000915527343750, 0.0000000000000000,
0.0000305175781250, -0.0000915527343750, 0.0002441406250000, -0.0000915527343750,
0.0000305175781250, -0.0000305175781250, -0.0002441406250000, -0.0000305175781250,
-0.0000305175781250, -0.0000610351562500, -0.0000305175781250, -0.0000305175781250,
-0.0002136230468750, 0.0000610351562500, -0.0000915527343750, -0.0000610351562500,
0.0002136230468750, -0.0002136230468750, 0.0000915527343750, -0.0000915527343750,
-0.0000610351562500, 0.0000305175781250, 0.0001220703125000, -0.0001220703125000,
0.0000000000000000, -0.0000305175781250, -0.0003662109375000, 0.0004882812500000,
-0.0002441406250000, 0.0003356933593750, 0.0000305175781250, -0.0003967285156250,
-0.0001525878906250, -0.0000915527343750, -0.0000915527343750, -0.0002441406250000,
0.0002746582031250, -0.0012817382812500, 0.0001525878906250, -0.0010375976562500,
-0.0000610351562500, 0.0008239746093750, 0.0000305175781250, 0.0006713867187500,
0.0000000000000000, -0.0012512207031250, -0.0003356933593750, 0.0013732910156250,
-0.0002441406250000, 0.0017089843750000, 0.0000000000000000, -0.0172729492187500,
-0.0001220703125000, -0.0062866210937500, -0.0000610351562500, -0.0245971679687500,
0.0002441406250000, -0.0531311035156250, 0.0001831054687500, -0.0346069335937500,
-0.0000610351562500, -0.0681152343750000, 0.0000305175781250, -0.0812072753906250,
0.0000000000000000, -0.0521545410156250, -0.0002136230468750, -0.0534667968750000,
-0.0001220703125000, -0.0691528320312500, 0.0000000000000000, 0.0423583984375000,
-0.0000915527343750, 0.0096130371093750, -0.0000305175781250, 0.0644226074218750,
0.0001525878906250, 0.1773071289062500, 0.0000610351562500, 0.1179504394531250,
-0.0000305175781250, 0.2245483398437500, 0.0000610351562500, 0.2477722167968750,
0.0000305175781250, 0.2131958007812500, -0.0001525878906250, 0.2416687011718750,
-0.0000915527343750, 0.2512207031250000, 0.0000000000000000, 0.1430969238281250,
-0.0000915527343750, 0.1734313964843750, -0.0000305175781250, 0.1118774414062500,
0.0000915527343750, -0.0021362304687500, 0.0000000000000000, 0.0509948730468750,
0.0000000000000000, -0.0784606933593750, 0.0000305175781250, -0.0925292968750000,
0.0000305175781250, -0.0905456542968750, -0.0000610351562500, -0.1496887207031250,
0.0000000000000000, -0.1355285644531250, -0.0000305175781250, -0.1242065429687500,
-0.0000610351562500, -0.1368408203125000, 0.0000000000000000, -0.1196899414062500,
0.0000610351562500, -0.0927124023437500, -0.0000305175781250, -0.1052856445312500,
0.0000000000000000, -0.0922851562500000, 0.0000610351562500, -0.0808105468750000,
0.0000000000000000, -0.1021728515625000, 0.0000000000000000, -0.1127014160156250,
0.0000000000000000, -0.1018371582031250, -0.0000610351562500, -0.1681213378906250,
-0.0000305175781250, -0.1567077636718750, 0.0000000000000000, -0.1877136230468750,
0.0000305175781250, -0.2489318847656250, -0.0000610351562500, -0.2255249023437500,
0.0000000000000000, -0.3018798828125000, 0.0000610351562500, -0.3034973144531250,
0.0000000000000000, -0.3244018554687500, -0.0000305175781250, -0.3774719238281250,
0.0000305175781250, -0.3603515625000000, 0.0000000000000000, -0.4088134765625000,
0.0000000000000000, -0.4148559570312500, -0.0000305175781250, -0.4212951660156250,
0.0000305175781250, -0.4463806152343750, 0.0000305175781250, -0.4386291503906250,
0.0000305175781250, -0.4553527832031250, 0.0000305175781250, -0.4555358886718750,
0.0000305175781250, -0.4572143554687500, 0.0000000000000000, -0.4656372070312500,
0.0000305175781250, -0.4591979980468750, 0.0000305175781250, -0.4642639160156250,
0.0000000000000000, -0.4611511230468750, 0.0000305175781250, -0.4618530273437500,
0.0000610351562500, -0.4657287597656250, 0.0000000000000000, -0.4599304199218750,
0.0000305175781250, -0.4658508300781250, 0.0000000000000000, -0.4637756347656250,
0.0000000000000000, -0.4625549316406250, 0.0000305175781250, -0.4663085937500000,
0.0000305175781250, -0.4649963378906250, 0.0000610351562500, -0.4661865234375000,
0.0000000000000000, -0.4649963378906250, 0.0000000000000000, -0.4659729003906250,
-0.0000610351562500, -0.4685974121093750, -0.0000305175781250, -0.4644165039062500,
0.0000000000000000, -0.4575195312500000, 0.0000305175781250, -0.4629211425781250,
0.0000000000000000, -0.4503784179687500, 0.0000000000000000, -0.4405822753906250,
0.0000000000000000, -0.4501953125000000, -0.0000305175781250, -0.4033203125000000,
0.0000000000000000, -0.4237670898437500, 0.0000000000000000, -0.3912353515625000,
0.0000000000000000, -0.3445739746093750, -0.0000305175781250, -0.3835144042968750,
0.0000305175781250, -0.2720031738281250, 0.0000000000000000, -0.2980957031250000,
0.0000000000000000, -0.2668762207031250, 0.0000000000000000, -0.1777343750000000,
0.0000000000000000, -0.2302551269531250, 0.0000000000000000, -0.1427917480468750,
-0.0000610351562500, -0.1268615722656250, 0.0000000000000000, -0.1479797363281250,
0.0000305175781250, -0.1158752441406250, -0.0000305175781250, -0.1124572753906250,
0.0000305175781250, -0.1892089843750000, 0.0000610351562500, -0.1513366699218750,
0.0000305175781250, -0.2055664062500000, -0.0000305175781250, -0.3009948730468750,
0.0000305175781250, -0.2425537109375000, -0.0000305175781250, -0.3538513183593750,
-0.0000305175781250, -0.3682556152343750, 0.0000000000000000, -0.3323059082031250,
0.0000305175781250, -0.3754272460937500, 0.0000305175781250, -0.3802185058593750,
0.0000305175781250, -0.2324218750000000, 0.0000305175781250, -0.3004150390625000,
-0.0000305175781250, -0.1752319335937500, -0.0001220703125000, 0.0083312988281250,
-0.0000305175781250, -0.0997314453125000, -0.0000610351562500, 0.2403564453125000,
-0.0001220703125000, 0.2265319824218750, -0.0000610351562500, 0.2843322753906250,
0.0000305175781250, 0.5127868652343750, -0.0000305175781250, 0.4230957031250000,
0.0000305175781250, 0.5095825195312500, 0.0000915527343750, 0.5771179199218750,
0.0000000000000000, 0.4806518554687500, -0.0000915527343750, 0.4392089843750000,
-0.0000610351562500, 0.4960632324218750, -0.0000610351562500, 0.2311401367187500,
-0.0001525878906250, 0.2761840820312500, -0.0000610351562500, 0.1903686523437500,
0.0000915527343750, -0.0231018066406250, 0.0000305175781250, 0.0830688476562500,
0.0000610351562500, -0.1060791015625000, 0.0002136230468750, -0.1308288574218750,
0.0000000000000000, -0.1053161621093750, -0.0000915527343750, -0.1790771484375000,
0.0000305175781250, -0.1687316894531250, -0.0001831054687500, -0.1098632812500000,
-0.0003051757812500, -0.1367492675781250, -0.0001220703125000, -0.1009216308593750,
-0.0000305175781250, -0.0315551757812500, -0.0001525878906250, -0.0671997070312500,
0.0001831054687500, -0.0086669921875000, 0.0002746582031250, 0.0016784667968750,
0.0000610351562500, -0.0078735351562500, 0.0000915527343750, 0.0098876953125000,
0.0002136230468750, 0.0086059570312500, -0.0002136230468750, -0.0005187988281250,
-0.0002441406250000, 0.0003967285156250, -0.0000915527343750, 0.0010070800781250,
-0.0003356933593750, -0.0036621093750000, -0.0003356933593750, -0.0032653808593750,
0.0001220703125000, 0.0001525878906250, 0.0000305175781250, -0.0003662109375000,
0.0000610351562500},
{0.0000000000000000, 0.0528259277343750, 0.0000305175781250, 0.0470886230468750,
0.0000305175781250, 0.0380249023437500, 0.0000305175781250, 0.0481262207031250,
0.0000305175781250, 0.0220031738281250, 0.0000610351562500, 0.0362548828125000,
0.0000305175781250, 0.0167846679687500, 0.0000305175781250, -0.0118103027343750,
0.0000000000000000, 0.0115966796875000, 0.0000000000000000, -0.0602416992187500,
0.0000305175781250, -0.0401306152343750, 0.0000305175781250, -0.0737915039062500,
0.0000000000000000, -0.1332092285156250, 0.0000000000000000, -0.0887145996093750,
0.0000305175781250, -0.2080078125000000, 0.0000305175781250, -0.1773071289062500,
0.0000305175781250, -0.2211914062500000, 0.0000305175781250, -0.3193359375000000,
0.0000610351562500, -0.2548217773437500, 0.0000305175781250, -0.3966369628906250,
0.0000000000000000, -0.3810729980468750, 0.0000000000000000, -0.3933410644531250,
0.0000305175781250, -0.4866943359375000, -0.0000305175781250, -0.4445495605468750,
0.0000000000000000, -0.4738159179687500, 0.0000610351562500, -0.5079956054687500,
0.0000305175781250, -0.4566040039062500, -0.0000305175781250, -0.4304809570312500,
0.0000305175781250, -0.4668273925781250, -0.0000610351562500, -0.3184204101562500,
-0.0000610351562500, -0.3529968261718750, -0.0000305175781250, -0.3026123046875000,
0.0000000000000000, -0.1724853515625000, -0.0000305175781250, -0.2399291992187500,
0.0000000000000000, -0.1406555175781250, 0.0000610351562500, -0.1161193847656250,
0.0000000000000000, -0.1522827148437500, -0.0000305175781250, -0.1300048828125000,
0.0000305175781250, -0.1176452636718750, -0.0000610351562500, -0.2128295898437500,
-0.0001220703125000, -0.1897888183593750, 0.0000000000000000, -0.2167968750000000,
0.0000610351562500, -0.3056335449218750, 0.0000305175781250, -0.2711486816406250,
0.0000305175781250, -0.2866516113281250, 0.0000915527343750, -0.3374023437500000,
0.0000000000000000, -0.2471618652343750, -0.0001220703125000, -0.1833190917968750,
0.0000000000000000, -0.2445068359375000, -0.0000610351562500, 0.0302124023437500,
-0.0001525878906250, -0.0245971679687500, 0.0000000000000000, 0.0776367187500000,
0.0000610351562500, 0.3213500976562500, -0.0000915527343750, 0.2100524902343750,
0.0000915527343750, 0.4246520996093750, 0.0001831054687500, 0.4639282226562500,
0.0000000000000000, 0.4107055664062500, -0.0000915527343750, 0.4804687500000000,
0.0000305175781250, 0.4879455566406250, -0.0000915527343750, 0.3202209472656250,
-0.0002136230468750, 0.3880004882812500, -0.0000915527343750, 0.2796630859375000,
0.0000000000000000, 0.0898132324218750, -0.0001220703125000, 0.1987915039062500,
0.0001525878906250, -0.0452575683593750, 0.0002136230468750, -0.0586547851562500,
0.0000915527343750, -0.0528259277343750, 0.0000610351562500, -0.1733093261718750,
0.0001831054687500, -0.1405029296875000, -0.0001525878906250, -0.1148986816406250,
-0.0002136230468750, -0.1494750976562500, -0.0000915527343750, -0.1076965332031250,
-0.0002441406250000, -0.0477600097656250, -0.0003051757812500, -0.0832824707031250,
0.0000915527343750, -0.0145263671875000, 0.0000000000000000, -0.0041809082031250,
0.0000305175781250, -0.0126342773437500, 0.0003356933593750, 0.0104064941406250,
0.0002746582031250, 0.0073852539062500, 0.0000000000000000, -0.0004577636718750,
0.0001220703125000, 0.0014648437500000, 0.0000000000000000, 0.0015563964843750,
-0.0003967285156250, -0.0032043457031250, -0.0002136230468750, -0.0026855468750000,
-0.0002746582031250, -0.0000610351562500, -0.0004577636718750, -0.0006103515625000,
-0.0002441406250000, -0.0007934570312500, 0.0001525878906250, 0.0013427734375000,
0.0005798339843750, -0.0021362304687500, -0.0007934570312500, 0.0002136230468750,
-0.0000305175781250, -0.0009460449218750, -0.0005187988281250, -0.0007019042968750,
-0.0018005371093750, 0.0008239746093750, -0.0013732910156250, 0.0007324218750000,
0.0001220703125000, -0.0001831054687500, -0.0012207031250000, -0.0001525878906250,
0.0004882812500000, 0.0001831054687500, 0.0041503906250000, -0.0000610351562500,
0.0018005371093750, -0.0002441406250000, -0.0009460449218750, 0.0003051757812500,
0.0071411132812500, 0.0005493164062500, -0.0115356445312500, 0.0001525878906250,
-0.0235900878906250, -0.0001831054687500, -0.0089721679687500, 0.0001831054687500,
-0.0773315429687500, -0.0003051757812500, -0.0614013671875000, -0.0005798339843750,
-0.0820922851562500, -0.0001525878906250, -0.1470031738281250, 0.0001525878906250,
-0.1143493652343750, -0.0002136230468750, -0.1154174804687500, 0.0002441406250000,
-0.1648559570312500, 0.0005187988281250, -0.0726318359375000, 0.0000915527343750,
-0.0046997070312500, -0.0002441406250000, -0.0813293457031250, 0.0001220703125000,
0.1817626953125000, -0.0003356933593750, 0.1334533691406250, -0.0006103515625000,
0.1945800781250000, -0.0001831054687500, 0.4058227539062500, 0.0000610351562500,
0.3057556152343750, -0.0002136230468750, 0.3971862792968750, 0.0002136230468750,
0.4656982421875000, 0.0004272460937500, 0.3595275878906250, 0.0001525878906250,
0.3187866210937500, 0.0000000000000000, 0.3898620605468750, 0.0001525878906250,
0.1112365722656250, -0.0000915527343750, 0.1606140136718750, -0.0002441406250000,
0.1003723144531250, -0.0000305175781250, -0.1098937988281250, 0.0000915527343750,
-0.0086669921875000, 0.0000000000000000, -0.1309509277343750, 0.0001525878906250,
-0.1651611328125000, 0.0003051757812500, -0.1265869140625000, 0.0000915527343750,
-0.1473999023437500, -0.0001220703125000, -0.1604003906250000, 0.0000610351562500,
-0.1155395507812500, -0.0001220703125000, -0.1138000488281250, -0.0002136230468750,
-0.1340637207031250, -0.0000915527343750, -0.1160583496093750, 0.0000610351562500,
-0.1098937988281250, -0.0000915527343750, -0.1979064941406250, 0.0000610351562500,
-0.1583251953125000, 0.0001831054687500, -0.2145385742187500, 0.0000915527343750,
-0.3107299804687500, -0.0000305175781250, -0.2479553222656250, 0.0000000000000000,
-0.3994750976562500, 0.0000305175781250, -0.3879394531250000, -0.0000610351562500,
-0.4044494628906250, 0.0000000000000000, -0.5013732910156250, 0.0001525878906250,
-0.4574890136718750, 0.0000610351562500, -0.4937133789062500, -0.0000305175781250,
-0.5205993652343750, 0.0000610351562500, -0.4716491699218750, 0.0000000000000000,
-0.4578247070312500, -0.0001220703125000, -0.4895935058593750, -0.0000610351562500,
-0.3429260253906250, -0.0000915527343750, -0.3951416015625000, -0.0000915527343750,
-0.3190002441406250, -0.0000915527343750, -0.1810302734375000, -0.0000305175781250,
-0.2805786132812500, -0.0000610351562500, -0.0618591308593750, -0.0001220703125000,
-0.0928955078125000, -0.0001220703125000, -0.0481262207031250, -0.0001220703125000,
0.1025390625000000, -0.0001525878906250, 0.0127563476562500, -0.0001220703125000,
0.1568908691406250, -0.0000610351562500, 0.1549377441406250, -0.0000915527343750,
0.1506347656250000, -0.0000610351562500, 0.2230834960937500, -0.0000305175781250,
0.1913146972656250, 0.0000000000000000, 0.2135620117187500, 0.0000000000000000,
0.2278442382812500, -0.0000610351562500, 0.2105712890625000, 0.0000000000000000,
0.2072753906250000, 0.0000305175781250, 0.2190246582031250, -0.0000305175781250,
0.1828918457031250, 0.0001220703125000, 0.1951599121093750, 0.0000915527343750,
0.1875000000000000, 0.0000610351562500, 0.1611938476562500, 0.0000915527343750,
0.1855773925781250, 0.0000610351562500, 0.1651306152343750, 0.0000610351562500,
0.1701049804687500, 0.0000305175781250, 0.1755676269531250, 0.0000610351562500,
0.1682434082031250, 0.0000915527343750, 0.1816406250000000, 0.0000610351562500,
0.1833190917968750, 0.0000610351562500, 0.1856079101562500, 0.0000915527343750,
0.1967773437500000, 0.0001220703125000, 0.2041625976562500, 0.0000610351562500,
0.2052612304687500, 0.0000610351562500, 0.2240600585937500, 0.0000305175781250,
0.2306213378906250, 0.0000000000000000, 0.2355346679687500, 0.0000305175781250,
0.2451477050781250, 0.0000305175781250, 0.2449340820312500, 0.0000000000000000,
0.2442321777343750, 0.0000305175781250, 0.2476806640625000, 0.0000000000000000,
0.2374877929687500, 0.0000000000000000, 0.2293395996093750, -0.0000305175781250,
0.2312927246093750, 0.0000305175781250, 0.1931152343750000, -0.0000915527343750,
0.2011108398437500, -0.0000610351562500, 0.1736450195312500, -0.0000610351562500,
0.1340942382812500, -0.0000610351562500, 0.1482238769531250, -0.0000610351562500,
0.0606384277343750, -0.0000915527343750, 0.0712890625000000, -0.0000915527343750,
0.0292053222656250, -0.0000915527343750, -0.0485229492187500, -0.0000915527343750,
-0.0185852050781250, -0.0000610351562500, -0.1276550292968750, -0.0000915527343750,
-0.1251831054687500, -0.0000915527343750, -0.1550598144531250, -0.0000610351562500,
-0.2356262207031250, -0.0000915527343750, -0.2099609375000000, -0.0001220703125000,
-0.2709655761718750, -0.0000610351562500, -0.2831726074218750, -0.0000610351562500,
-0.2724914550781250, -0.0000305175781250, -0.2929992675781250, 0.0000610351562500,
-0.2933654785156250, -0.0000305175781250, -0.2572937011718750, 0.0000000000000000,
-0.2698364257812500, 0.0000305175781250, -0.2458496093750000, 0.0000000000000000,
-0.2037658691406250, -0.0000305175781250, -0.2255859375000000, -0.0000305175781250,
-0.1834716796875000, 0.0000000000000000, -0.1760559082031250, -0.0000305175781250,
-0.1854553222656250, 0.0000000000000000, -0.1739501953125000, 0.0000305175781250,
-0.1731262207031250, 0.0000305175781250, -0.1912231445312500, 0.0000000000000000,
-0.1958618164062500, 0.0000000000000000, -0.1826782226562500, 0.0000000000000000,
-0.1916809082031250, -0.0000915527343750, -0.1978759765625000, -0.0000610351562500,
-0.1051025390625000, -0.0000305175781250, -0.1430053710937500, -0.0000305175781250,
-0.0636596679687500, 0.0000000000000000, 0.0529479980468750, 0.0001220703125000,
-0.0168762207031250, 0.0000915527343750, 0.1709594726562500, 0.0000000000000000,
0.1765747070312500, 0.0000915527343750, 0.1740112304687500, 0.0000000000000000,
0.2771606445312500, -0.0001525878906250, 0.2509155273437500, -0.0000610351562500,
0.1946105957031250, -0.0000610351562500, 0.2444152832031250, -0.0001831054687500,
0.1677551269531250, -0.0000915527343750, 0.0620117187500000, 0.0001220703125000,
0.1288757324218750, -0.0000305175781250, -0.0208740234375000, 0.0000000000000000,
-0.0341186523437500, 0.0000305175781250, -0.0244445800781250, -0.0000610351562500,
-0.0908203125000000, -0.0002136230468750, -0.0773315429687500, -0.0001525878906250,
-0.0500488281250000, -0.0000610351562500, -0.0672302246093750, -0.0001220703125000,
-0.0480346679687500, -0.0000610351562500, -0.0106201171875000, 0.0000915527343750,
-0.0283813476562500, 0.0000000000000000, -0.0036926269531250, 0.0000000000000000,
0.0034179687500000, 0.0000305175781250, -0.0025024414062500, 0.0000000000000000,
0.0012512207031250, -0.0000915527343750, 0.0021972656250000, -0.0000610351562500,
-0.0010375976562500, 0.0000000000000000, -0.0018615722656250, -0.0000305175781250,
-0.0006408691406250, -0.0000610351562500, -0.0001220703125000, -0.0000915527343750,
-0.0000915527343750, -0.0001220703125000, 0.0001831054687500, -0.0000610351562500,
0.0005798339843750, -0.0001525878906250, 0.0002136230468750, -0.0000610351562500,
-0.0002441406250000, 0.0002136230468750, 0.0001525878906250, 0.0000000000000000,
-0.0000305175781250, -0.0000915527343750, -0.0003967285156250, 0.0002441406250000,
-0.0001220703125000, -0.0002746582031250, 0.0002136230468750, -0.0011291503906250,
0.0000305175781250},
{-0.0187377929687500, 0.0000305175781250, -0.0278625488281250, 0.0000305175781250,
0.0157470703125000, 0.0000610351562500, 0.0114746093750000, 0.0000305175781250,
0.0299072265625000, 0.0000915527343750, 0.0667724609375000, 0.0000915527343750,
0.0557250976562500, 0.0000610351562500, 0.1102905273437500, 0.0000305175781250,
0.1088867187500000, 0.0000610351562500, 0.1247558593750000, 0.0000610351562500,
0.1678161621093750, 0.0000000000000000, 0.1584472656250000, 0.0000610351562500,
0.1877441406250000, 0.0000305175781250, 0.1969909667968750, 0.0000000000000000,
0.1871643066406250, -0.0000305175781250, 0.1961975097656250, 0.0000305175781250,
0.2004699707031250, 0.0000000000000000, 0.1478271484375000, -0.0000610351562500,
0.1674194335937500, 0.0000000000000000, 0.1211242675781250, -0.0000305175781250,
0.0554199218750000, -0.0001525878906250, 0.0885925292968750, -0.0001220703125000,
-0.0364685058593750, -0.0000915527343750, -0.0316162109375000, -0.0001220703125000,
-0.0658874511718750, -0.0001220703125000, -0.1574401855468750, 0.0000000000000000,
-0.1218566894531250, -0.0000610351562500, -0.1852111816406250, -0.0000305175781250,
-0.2024230957031250, 0.0000000000000000, -0.1836242675781250, -0.0000305175781250,
-0.1949462890625000, -0.0000610351562500, -0.2005004882812500, -0.0000610351562500,
-0.1634521484375000, 0.0000000000000000, -0.1676635742187500, -0.0000610351562500,
-0.1638488769531250, -0.0000610351562500, -0.1377563476562500, 0.0000305175781250,
-0.1460876464843750, 0.0000305175781250, -0.1544189453125000, 0.0000000000000000,
-0.1492004394531250, 0.0000305175781250, -0.1526489257812500, 0.0000000000000000,
-0.1718139648437500, -0.0000915527343750, -0.1679687500000000, -0.0000610351562500,
-0.1212158203125000, -0.0000610351562500, -0.1570129394531250, -0.0001220703125000,
-0.0887145996093750, -0.0000305175781250, -0.0065002441406250, 0.0001220703125000,
-0.0629882812500000, 0.0000000000000000, 0.1187133789062500, 0.0000610351562500,
0.1120300292968750, 0.0001525878906250, 0.1240539550781250, 0.0000305175781250,
0.2398986816406250, -0.0001220703125000, 0.2024841308593750, -0.0000305175781250,
0.1757202148437500, -0.0001220703125000, 0.2240600585937500, -0.0002136230468750,
0.1516418457031250, -0.0001220703125000, 0.0632324218750000, 0.0000305175781250,
0.1197509765625000, -0.0000915527343750, -0.0185852050781250, -0.0000305175781250,
-0.0261230468750000, 0.0000915527343750, -0.0173339843750000, 0.0000000000000000,
-0.0820617675781250, -0.0001220703125000, -0.0689392089843750, -0.0000610351562500,
-0.0430908203125000, 0.0000000000000000, -0.0588073730468750, -0.0000305175781250,
-0.0416259765625000, -0.0000915527343750, -0.0074462890625000, 0.0000305175781250,
-0.0236816406250000, 0.0000000000000000, -0.0030822753906250, -0.0000915527343750,
0.0032348632812500, -0.0001220703125000, -0.0018920898437500, 0.0000000000000000,
0.0000000000000000, 0.0001525878906250, -0.0004577636718750, 0.0001220703125000,
-0.0006713867187500, -0.0000915527343750, -0.0015258789062500, 0.0001831054687500,
-0.0008239746093750, -0.0001525878906250, 0.0003662109375000, -0.0008544921875000,
-0.0005187988281250, -0.0003967285156250, 0.0000915527343750, -0.0003967285156250,
0.0006408691406250, -0.0010375976562500, 0.0002136230468750, -0.0004577636718750,
-0.0003051757812500, 0.0017700195312500, -0.0000610351562500, 0.0005798339843750,
0.0000610351562500, -0.0067749023437500, -0.0002136230468750, 0.0007019042968750,
-0.0001220703125000, -0.0141906738281250, 0.0002746582031250, -0.0317077636718750,
0.0001831054687500, -0.0184020996093750, -0.0001525878906250, -0.0494079589843750,
-0.0000610351562500, -0.0585937500000000, 0.0000000000000000, -0.0352478027343750,
-0.0002136230468750, -0.0401611328125000, -0.0002441406250000, -0.0519104003906250,
0.0001525878906250, 0.0455627441406250, 0.0001220703125000, 0.0185546875000000,
0.0000000000000000, 0.0565185546875000, 0.0001220703125000, 0.1526794433593750,
0.0002136230468750, 0.1051330566406250, -0.0001525878906250, 0.1467285156250000,
-0.0001831054687500, 0.1838684082031250, -0.0000610351562500, 0.1257934570312500,
-0.0001525878906250, 0.0939025878906250, -0.0002136230468750, 0.1327819824218750,
0.0000915527343750, -0.0029602050781250, 0.0001220703125000, 0.0051574707031250,
0.0000000000000000, -0.0043640136718750, 0.0000610351562500, -0.0876770019531250,
0.0001525878906250, -0.0593261718750000, -0.0001220703125000, -0.0652160644531250,
-0.0001220703125000, -0.0815734863281250, -0.0000305175781250, -0.0699768066406250,
-0.0001220703125000, -0.0498962402343750, -0.0001831054687500, -0.0581970214843750,
0.0000305175781250, -0.0788574218750000, 0.0000305175781250, -0.0553588867187500,
0.0000000000000000, -0.0979003906250000, 0.0000610351562500, -0.1484375000000000,
0.0000610351562500, -0.1116943359375000, -0.0000915527343750, -0.1999511718750000,
-0.0000610351562500, -0.2080993652343750, -0.0000305175781250, -0.1964721679687500,
-0.0001220703125000, -0.2372436523437500, -0.0001525878906250, -0.2311706542968750,
0.0000305175781250, -0.1656799316406250, 0.0000000000000000, -0.1914367675781250,
0.0000000000000000, -0.1305236816406250, 0.0000610351562500, -0.0425720214843750,
0.0000915527343750, -0.0853881835937500, -0.0000305175781250, 0.0467834472656250,
0.0000000000000000, 0.0530700683593750, -0.0000305175781250, 0.0631408691406250,
-0.0000610351562500, 0.1363525390625000, -0.0000610351562500, 0.1148071289062500,
0.0000000000000000, 0.1255493164062500, -0.0000305175781250, 0.1427001953125000,
-0.0000610351562500, 0.1213989257812500, 0.0000610351562500, 0.1026916503906250,
0.0000305175781250, 0.1137084960937500, 0.0000000000000000, 0.0704956054687500,
0.0000000000000000, 0.0690307617187500, 0.0000000000000000, 0.0680236816406250,
-0.0000305175781250, 0.0440063476562500, -0.0000305175781250, 0.0495605468750000,
0.0000000000000000, 0.0594482421875000, 0.0000000000000000, 0.0502624511718750,
-0.0000610351562500, 0.0711975097656250, 0.0000000000000000, 0.0946350097656250,
0.0000305175781250, 0.0823364257812500, 0.0000000000000000, 0.1326904296875000,
0.0000305175781250, 0.1344299316406250, -0.0000305175781250, 0.1549987792968750,
0.0000305175781250, 0.1965637207031250, 0.0000305175781250, 0.1879577636718750,
0.0000610351562500, 0.2285461425781250, 0.0000305175781250, 0.2389831542968750,
0.0000000000000000, 0.2552795410156250, 0.0000610351562500, 0.2826232910156250,
0.0000000000000000, 0.2796630859375000, 0.0000305175781250, 0.3113098144531250,
0.0000305175781250, 0.3281250000000000, 0.0000610351562500, 0.3324279785156250,
0.0000305175781250, 0.3466186523437500, 0.0000610351562500, 0.3581542968750000,
0.0000305175781250, 0.3496398925781250, 0.0000305175781250, 0.3609619140625000,
0.0000000000000000, 0.3584594726562500, 0.0000305175781250, 0.3488159179687500,
0.0000305175781250, 0.3590087890625000, 0.0000305175781250, 0.3311462402343750,
0.0000305175781250, 0.3513793945312500, 0.0000915527343750, 0.3295898437500000,
0.0000000000000000, 0.2968750000000000, 0.0000000000000000, 0.3278503417968750,
0.0000305175781250, 0.2469482421875000, 0.0000610351562500, 0.2674865722656250,
0.0000305175781250, 0.2398071289062500, 0.0000000000000000, 0.1769409179687500,
0.0000000000000000, 0.2233276367187500, 0.0000305175781250, 0.1314697265625000,
0.0000000000000000, 0.1445922851562500, 0.0000000000000000, 0.1315002441406250,
0.0000000000000000, 0.0692138671875000, 0.0000305175781250, 0.1054382324218750,
-0.0000305175781250, 0.0658874511718750, -0.0000305175781250, 0.0545349121093750,
0.0000000000000000, 0.0804748535156250, -0.0000305175781250, 0.0772705078125000,
0.0000000000000000, 0.0650634765625000, 0.0000305175781250, 0.1280212402343750,
-0.0000305175781250, 0.1166992187500000, 0.0000305175781250, 0.1311950683593750,
0.0000305175781250, 0.1864013671875000, 0.0000305175781250, 0.1654968261718750,
0.0000000000000000, 0.1624145507812500, 0.0000000000000000, 0.1978454589843750,
0.0000305175781250, 0.1249389648437500, 0.0000000000000000, 0.0736083984375000,
-0.0000305175781250, 0.1309204101562500, 0.0000915527343750, -0.0929870605468750,
0.0000915527343750, -0.0434570312500000, 0.0000610351562500, -0.1288146972656250,
0.0000305175781250, -0.3221130371093750, 0.0000915527343750, -0.2140808105468750,
-0.0000610351562500, -0.4138183593750000, -0.0000305175781250, -0.4318847656250000,
0.0000000000000000, -0.4111633300781250, 0.0000000000000000, -0.5028076171875000,
-0.0000610351562500, -0.4894409179687500, 0.0000000000000000, -0.4224548339843750,
0.0000610351562500, -0.4605407714843750, -0.0000305175781250, -0.3949890136718750,
-0.0000305175781250, -0.2984619140625000, 0.0000305175781250, -0.3547668457031250,
-0.0000915527343750, -0.2211303710937500, -0.0001831054687500, -0.2138671875000000,
-0.0000915527343750, -0.2175598144531250, -0.0001220703125000, -0.1530761718750000,
-0.0001525878906250, -0.1700134277343750, 0.0000610351562500, -0.1825866699218750,
0.0000305175781250, -0.1734924316406250, 0.0000000000000000, -0.1737670898437500,
0.0000305175781250, -0.1962585449218750, 0.0001220703125000, -0.1933898925781250,
-0.0001831054687500, -0.1287536621093750, -0.0001525878906250, -0.1780395507812500,
-0.0001220703125000, -0.0871582031250000, -0.0002136230468750, 0.0207519531250000,
-0.0002441406250000, -0.0588378906250000, 0.0000000000000000, 0.1953735351562500,
-0.0000305175781250, 0.1750793457031250, 0.0000000000000000, 0.2132873535156250,
0.0001831054687500, 0.3937072753906250, 0.0001525878906250, 0.3231506347656250,
-0.0000305175781250, 0.3395385742187500, 0.0000610351562500, 0.4090881347656250,
-0.0000915527343750, 0.3016052246093750, -0.0002746582031250, 0.2118530273437500,
-0.0001525878906250, 0.2918701171875000, -0.0001831054687500, 0.0376892089843750,
-0.0003356933593750, 0.0480346679687500, -0.0000915527343750, 0.0221557617187500,
0.0000610351562500, -0.1379089355468750, -0.0000610351562500, -0.0812072753906250,
0.0003662109375000, -0.1026611328125000, 0.0004577636718750, -0.1426391601562500,
0.0002441406250000, -0.0964355468750000, 0.0003967285156250, -0.0543212890625000,
0.0004882812500000, -0.0871582031250000, -0.0006713867187500, -0.0187988281250000,
-0.0004882812500000, -0.0120239257812500, -0.0004577636718750, -0.0210266113281250,
-0.0016174316406250, 0.0140380859375000, 0.0024108886718750, -0.0847473144531250,
-0.0150756835937500, -0.0074157714843750, 0.0045471191406250, -0.0197143554687500,
-0.0243225097656250, -0.0163879394531250, -0.0504760742187500, 0.0079345703125000,
-0.0275268554687500, 0.0038757324218750, -0.0924072265625000, -0.0003662109375000,
-0.0920410156250000, 0.0015563964843750, -0.0841064453125000, 0.0012512207031250,
-0.1257019042968750, -0.0019226074218750, -0.1171569824218750, -0.0015563964843750,
-0.0330200195312500, 0.0000000000000000, -0.0915832519531250, -0.0001831054687500,
0.0117492675781250, -0.0004272460937500, 0.1453552246093750, 0.0003051757812500,
0.0478515625000000, 0.0003967285156250, 0.2974548339843750, -0.0001525878906250,
0.2997741699218750, -0.0003051757812500, 0.2778320312500000, 0.0000305175781250,
0.4158325195312500, 0.0000915527343750, 0.3887939453125000, -0.0001831054687500,
0.2364807128906250, 0.0001831054687500, 0.3381042480468750, 0.0003662109375000,
0.1950073242187500, 0.0000610351562500, -0.0309448242187500, -0.0001525878906250,
0.1176147460937500, 0.0000610351562500, -0.1513061523437500, -0.0000915527343750,
-0.1828918457031250},
{-0.0000610351562500, 0.1758422851562500, -0.0000305175781250, 0.1729125976562500,
-0.0000305175781250, 0.1650085449218750, -0.0001220703125000, 0.2125854492187500,
-0.0000610351562500, 0.2018432617187500, 0.0000000000000000, 0.1256408691406250,
0.0000305175781250, 0.1765136718750000, -0.0000305175781250, 0.0843200683593750,
0.0000000000000000, -0.0334777832031250, 0.0000305175781250, 0.0430603027343750,
-0.0001220703125000, -0.2059326171875000, -0.0001220703125000, -0.1896057128906250,
-0.0000610351562500, -0.2392578125000000, -0.0001220703125000, -0.4133300781250000,
-0.0001220703125000, -0.3414611816406250, 0.0000000000000000, -0.4272460937500000,
0.0000305175781250, -0.4696350097656250, -0.0000305175781250, -0.4138793945312500,
0.0000915527343750, -0.4044189453125000, 0.0000610351562500, -0.4314575195312500,
-0.0001525878906250, -0.2937316894531250, -0.0001220703125000, -0.3164062500000000,
-0.0000610351562500, -0.2788085937500000, -0.0001831054687500, -0.1691894531250000,
-0.0001525878906250, -0.2179260253906250, 0.0000305175781250, -0.1504211425781250,
-0.0000305175781250, -0.1341247558593750, -0.0000305175781250, -0.1491699218750000,
0.0001525878906250, -0.1388244628906250, 0.0001525878906250, -0.1364135742187500,
-0.0000305175781250, -0.1232910156250000, 0.0000610351562500, -0.1515502929687500,
-0.0000305175781250, -0.0877075195312500, -0.0002136230468750, -0.0379333496093750,
-0.0001525878906250, -0.0882568359375000, -0.0001525878906250, 0.1231079101562500,
-0.0002746582031250, 0.0842590332031250, -0.0000915527343750, 0.1418151855468750,
0.0000610351562500, 0.3206481933593750, -0.0000915527343750, 0.2403869628906250,
0.0003356933593750, 0.3129882812500000, 0.0003967285156250, 0.3784790039062500,
0.0001831054687500, 0.2777709960937500, 0.0003051757812500, 0.2221069335937500,
0.0003967285156250, 0.2878417968750000, -0.0006408691406250, 0.0474548339843750,
-0.0004882812500000, 0.0697631835937500, -0.0003662109375000, 0.0397338867187500,
-0.0012207031250000, -0.1218261718750000, -0.0010681152343750, -0.0603942871093750,
0.0010986328125000, -0.0947265625000000, 0.0003356933593750, -0.1301574707031250,
0.0004272460937500, -0.0946960449218750, 0.0031127929687500, -0.0442504882812500,
-0.0288696289062500, -0.0435791015625000, -0.0953063964843750, -0.0894165039062500,
-0.0848999023437500, -0.1177062988281250, -0.0709533691406250, -0.0782775878906250,
-0.0991210937500000, -0.0449218750000000, -0.1044006347656250, -0.0707702636718750,
0.0138549804687500, -0.0144653320312500, -0.0425720214843750, -0.0082702636718750,
0.0484313964843750, -0.0140075683593750, 0.1950378417968750, 0.0065917968750000,
0.1004333496093750, 0.0032348632812500, 0.3073120117187500, -0.0006408691406250,
0.3326416015625000, 0.0008544921875000, 0.2768859863281250, 0.0008544921875000,
0.3580627441406250, -0.0015563964843750, 0.3654785156250000, -0.0014038085937500,
0.1401367187500000, 0.0002441406250000, 0.2308349609375000, 0.0001220703125000,
0.1054382324218750, -0.0001831054687500, -0.1473693847656250, 0.0003967285156250,
0.0004272460937500, 0.0004882812500000, -0.2015686035156250, -0.0000915527343750,
-0.2761840820312500, -0.0001831054687500, -0.1613464355468750, 0.0000305175781250,
-0.1620788574218750, 0.0000305175781250, -0.2288818359375000, -0.0000305175781250,
0.0150756835937500, 0.0000000000000000, -0.0097045898437500, 0.0001220703125000,
-0.0114440917968750, 0.0000000000000000, 0.1535949707031250, -0.0003051757812500,
0.1080627441406250, -0.0001831054687500, -0.0261230468750000, 0.0000000000000000,
0.0833435058593750, -0.0002136230468750, -0.0762023925781250, -0.0000305175781250,
-0.3026123046875000, 0.0004272460937500, -0.1456298828125000, 0.0001525878906250,
-0.4718627929687500, 0.0000000000000000, -0.5018310546875000, 0.0002441406250000,
-0.4371032714843750, 0.0000610351562500, -0.5710754394531250, -0.0003356933593750,
-0.5664672851562500, -0.0001831054687500, -0.3495178222656250, -0.0001525878906250,
-0.4533691406250000, -0.0003051757812500, -0.3105773925781250, -0.0001831054687500,
-0.0610656738281250, 0.0000610351562500, -0.2210693359375000, 0.0000000000000000,
0.1013793945312500, -0.0000915527343750, 0.1062927246093750, -0.0000305175781250,
0.0965270996093750, -0.0001220703125000, 0.2626647949218750, -0.0002441406250000,
0.2107238769531250, -0.0002441406250000, 0.1876831054687500, 0.0000305175781250,
0.2439575195312500, -0.0000610351562500, 0.1757202148437500, -0.0000305175781250,
0.0971374511718750, 0.0002136230468750, 0.1595764160156250, 0.0001525878906250,
0.0044250488281250, -0.0000305175781250, 0.0111389160156250, 0.0000305175781250,
0.0062561035156250, 0.0000305175781250, -0.0892028808593750, -0.0000915527343750,
-0.0552062988281250, -0.0000610351562500, -0.0307922363281250, 0.0000305175781250,
-0.0833740234375000, 0.0000000000000000, 0.0093383789062500, -0.0000610351562500,
0.0870666503906250, -0.0000610351562500, 0.0036010742187500, 0.0000305175781250,
0.2753601074218750, -0.0001525878906250, 0.2035217285156250, -0.0001831054687500,
0.3020019531250000, -0.0001525878906250, 0.5280456542968750, -0.0001525878906250,
0.3830566406250000, -0.0001831054687500, 0.6717834472656250, -0.0000610351562500,
0.6470336914062500, -0.0000305175781250, 0.6855773925781250, -0.0000915527343750,
0.8690795898437500, -0.0000915527343750, 0.7750854492187500, -0.0000610351562500,
0.9118041992187500, -0.0000610351562500, 0.9224243164062500, -0.0000915527343750,
0.9091796875000000, -0.0000305175781250, 0.9695434570312500, 0.0000305175781250,
0.9526977539062500, 0.0000000000000000, 0.9431152343750000, 0.0000610351562500,
0.9671325683593750, 0.0000610351562500, 0.9442138671875000, 0.0000610351562500,
0.9173889160156250, 0.0000305175781250, 0.9448242187500000, 0.0000000000000000,
0.8828735351562500, 0.0000915527343750, 0.8976440429687500, 0.0000610351562500,
0.8855285644531250, 0.0000915527343750, 0.8445434570312500, 0.0000915527343750,
0.8799743652343750, 0.0000915527343750, 0.8346252441406250, 0.0000610351562500,
0.8443298339843750, 0.0000610351562500, 0.8459777832031250, 0.0000915527343750,
0.8236389160156250, 0.0001220703125000, 0.8484497070312500, 0.0000915527343750,
0.8296813964843750, 0.0000915527343750, 0.8383483886718750, 0.0000915527343750,
0.8470458984375000, 0.0000915527343750, 0.8410644531250000, 0.0001220703125000,
0.8560180664062500, 0.0001220703125000, 0.8645324707031250, 0.0000915527343750,
0.8780517578125000, 0.0000915527343750, 0.8859863281250000, 0.0000915527343750,
0.8934326171875000, 0.0000915527343750, 0.9101562500000000, 0.0000305175781250,
0.9073791503906250, 0.0000915527343750, 0.9143066406250000, 0.0000610351562500,
0.9155883789062500, 0.0000305175781250, 0.9130859375000000, 0.0000305175781250,
0.9202270507812500, 0.0000610351562500, 0.9031982421875000, 0.0000000000000000,
0.9080810546875000, -0.0000305175781250, 0.8924560546875000, -0.0000305175781250,
0.8757019042968750, 0.0000000000000000, 0.8854980468750000, -0.0000305175781250,
0.8171081542968750, -0.0000610351562500, 0.8363647460937500, -0.0000305175781250,
0.7861328125000000, -0.0000610351562500, 0.7148132324218750, -0.0001220703125000,
0.7514648437500000, -0.0001220703125000, 0.5904846191406250, -0.0001220703125000,
0.6167907714843750, -0.0001525878906250, 0.5299072265625000, -0.0001525878906250,
0.3802185058593750, -0.0001220703125000, 0.4478759765625000, -0.0001525878906250,
0.2103576660156250, -0.0001220703125000, 0.2240905761718750, -0.0000610351562500,
0.1663208007812500, -0.0000915527343750, -0.0021362304687500, -0.0000915527343750,
0.0660705566406250, -0.0000915527343750, -0.0659484863281250, -0.0000610351562500,
-0.0900573730468750, -0.0000610351562500, -0.0708312988281250, -0.0000305175781250,
-0.1179809570312500, 0.0000610351562500, -0.1122436523437500, 0.0000000000000000,
-0.0492248535156250, 0.0000610351562500, -0.0683593750000000, 0.0001220703125000,
-0.0349426269531250, 0.0000610351562500, 0.0335083007812500, 0.0000000000000000,
0.0036621093750000, 0.0000610351562500, 0.0481567382812500, 0.0000000000000000,
0.0713195800781250, -0.0000915527343750, 0.0396423339843750, -0.0000305175781250,
0.0327148437500000, 0.0000000000000000, 0.0506591796875000, -0.0000610351562500,
-0.0364685058593750, 0.0000305175781250, -0.0280761718750000, 0.0000915527343750,
-0.0444641113281250, 0.0000305175781250, -0.1081542968750000, -0.0000305175781250,
-0.0844116210937500, 0.0000000000000000, -0.0963439941406250, -0.0000610351562500,
-0.1134643554687500, -0.0001220703125000, -0.0941162109375000, 0.0000000000000000,
-0.0748291015625000, 0.0000305175781250, -0.0880432128906250, -0.0000305175781250,
-0.0720214843750000, 0.0000610351562500, -0.0622863769531250, 0.0001525878906250,
-0.0756835937500000, 0.0000305175781250, -0.0863037109375000, -0.0000305175781250,
-0.0763854980468750, 0.0000610351562500, -0.0767517089843750, -0.0000305175781250,
-0.1005554199218750, -0.0000915527343750, -0.0520629882812500, 0.0000000000000000,
-0.0139465332031250, 0.0000915527343750, -0.0503540039062500, 0.0000305175781250,
0.0881958007812500, 0.0000305175781250, 0.0761413574218750, 0.0000915527343750,
0.0884399414062500, 0.0000305175781250, 0.1856994628906250, 0.0000000000000000,
0.1547241210937500, 0.0000000000000000, 0.1275329589843750, 0.0000610351562500,
0.1705627441406250, 0.0001831054687500, 0.1088256835937500, -0.0001831054687500,
0.0302429199218750, -0.0004272460937500, 0.0828857421875000, -0.0000915527343750,
-0.0282897949218750, -0.0007324218750000, -0.0394592285156250, -0.0011291503906250,
-0.0234985351562500, -0.0003356933593750, -0.0654602050781250, 0.0010681152343750,
-0.0569458007812500, 0.0005493164062500, -0.0162048339843750, -0.0027770996093750,
-0.0313415527343750, 0.0018310546875000, -0.0281677246093750, -0.0062866210937500,
0.0023498535156250, -0.0135192871093750, -0.0090637207031250, -0.0063171386718750,
-0.0018920898437500, -0.0368347167968750, 0.0030822753906250, -0.0369873046875000,
0.0000000000000000, -0.0309448242187500, -0.0014953613281250, -0.0506286621093750,
-0.0004882812500000, -0.0492248535156250, -0.0003662109375000, 0.0068664550781250,
-0.0013122558593750, -0.0201416015625000, -0.0007629394531250, 0.0222473144531250,
0.0005187988281250, 0.0990295410156250, 0.0001525878906250, 0.0575866699218750,
-0.0001220703125000, 0.1185607910156250, 0.0001525878906250, 0.1456909179687500,
0.0001220703125000, 0.1010742187500000, -0.0003356933593750, 0.0918884277343750,
-0.0003051757812500, 0.1170349121093750, 0.0001220703125000, 0.0115966796875000,
0.0000610351562500, 0.0187683105468750, -0.0000610351562500, 0.0149230957031250,
0.0000915527343750, -0.0492553710937500, 0.0002136230468750, -0.0314636230468750,
-0.0001525878906250, -0.0239257812500000, -0.0002136230468750, -0.0355834960937500,
-0.0000305175781250, -0.0348815917968750, -0.0000610351562500, -0.0158386230468750,
-0.0001525878906250, -0.0185241699218750, 0.0000915527343750, -0.0669555664062500,
0.0002136230468750, -0.0441589355468750, 0.0000305175781250, -0.0760192871093750,
0.0000305175781250, -0.1395568847656250, 0.0000915527343750, -0.1051635742187500,
-0.0000915527343750, -0.1394653320312500, -0.0001831054687500, -0.1674804687500000,
-0.0000305175781250, -0.1213073730468750, 0.0000000000000000, -0.0968322753906250,
-0.0001220703125000, -0.1271667480468750, 0.0000610351562500, -0.0195922851562500,
0.0001831054687500, -0.0253601074218750, 0.0000305175781250, -0.0111083984375000,
0.0000305175781250},
{-0.0924377441406250, 0.0000000000000000, -0.0733337402343750, 0.0000305175781250,
-0.0946960449218750, 0.0000610351562500, -0.0184631347656250, -0.0000610351562500,
-0.0101623535156250, -0.0000610351562500, -0.0209960937500000, 0.0000000000000000,
0.0116577148437500, -0.0000610351562500, 0.0119018554687500, -0.0000610351562500,
-0.0420227050781250, 0.0000610351562500, -0.0243530273437500, 0.0001220703125000,
-0.0462341308593750, 0.0000000000000000, -0.1026611328125000, 0.0000000000000000,
-0.0778503417968750, 0.0000305175781250, -0.0959777832031250, -0.0000610351562500,
-0.1144104003906250, -0.0001220703125000, -0.0895385742187500, 0.0000000000000000,
-0.0700073242187500, 0.0000915527343750, -0.0865783691406250, -0.0000305175781250,
-0.0538330078125000, -0.0000305175781250, -0.0457153320312500, 0.0000610351562500,
-0.0559387207031250, 0.0000305175781250, -0.0547485351562500, -0.0000305175781250,
-0.0498352050781250, -0.0000610351562500, -0.0467224121093750, 0.0000305175781250,
-0.0660705566406250, 0.0001220703125000, -0.0240478515625000, -0.0001831054687500,
0.0094604492187500, -0.0002136230468750, -0.0242919921875000, 0.0000305175781250,
0.0968322753906250, -0.0007324218750000, 0.0910339355468750, -0.0010070800781250,
0.0946044921875000, -0.0001831054687500, 0.1725158691406250, 0.0001525878906250,
0.1505432128906250, -0.0007324218750000, 0.1065979003906250, 0.0000305175781250,
0.1447753906250000, 0.0027465820312500, 0.0974121093750000, -0.0043945312500000,
-0.0034484863281250, -0.0098571777343750, 0.0032958984375000, -0.0091552734375000,
-0.0500793457031250, -0.0370483398437500, -0.0523376464843750, -0.0286865234375000,
-0.0335083007812500, -0.0271606445312500, -0.0511779785156250, -0.0520019531250000,
-0.0585632324218750, -0.0452880859375000, -0.0188598632812500, -0.0104370117187500,
-0.0238342285156250, -0.0354919433593750, -0.0213623046875000, 0.0075378417968750,
0.0035705566406250, 0.0688781738281250, -0.0043945312500000, 0.0294799804687500,
-0.0014648437500000, 0.1062622070312500, 0.0022277832031250, 0.1256103515625000,
0.0003356933593750, 0.0918579101562500, -0.0018005371093750, 0.1035461425781250,
-0.0011596679687500, 0.1189880371093750, -0.0002441406250000, 0.0297241210937500,
-0.0008544921875000, 0.0398254394531250, -0.0006408691406250, 0.0297241210937500,
0.0004577636718750, -0.0324707031250000, 0.0002746582031250, -0.0130920410156250,
-0.0001831054687500, -0.0112304687500000, -0.0000915527343750, -0.0220947265625000,
0.0000000000000000, -0.0216064453125000, -0.0002441406250000, -0.0061035156250000,
-0.0003051757812500, -0.0073242187500000, 0.0000305175781250, -0.0555725097656250,
0.0001525878906250, -0.0328979492187500, -0.0000305175781250, -0.0622253417968750,
-0.0000305175781250, -0.1257934570312500, 0.0000610351562500, -0.0935668945312500,
-0.0001525878906250, -0.1173400878906250, -0.0002136230468750, -0.1461181640625000,
-0.0000915527343750, -0.1018066406250000, -0.0000305175781250, -0.0710754394531250,
-0.0001525878906250, -0.1032104492187500, 0.0000305175781250, -0.0098266601562500,
0.0001831054687500, -0.0072937011718750, -0.0000305175781250, -0.0144348144531250,
-0.0000610351562500, 0.0308532714843750, 0.0000000000000000, 0.0234375000000000,
-0.0001220703125000, -0.0046081542968750, -0.0002136230468750, 0.0063781738281250,
-0.0000915527343750, -0.0019531250000000, 0.0000305175781250, -0.0368041992187500,
-0.0000915527343750, -0.0249938964843750, 0.0000610351562500, 0.0121154785156250,
0.0001220703125000, -0.0244140625000000, 0.0000000000000000, 0.0505371093750000,
0.0000000000000000, 0.1333618164062500, 0.0000610351562500, 0.0809936523437500,
-0.0000305175781250, 0.2818908691406250, -0.0000915527343750, 0.2692565917968750,
-0.0000610351562500, 0.3267822265625000, 0.0000305175781250, 0.4776916503906250,
-0.0000305175781250, 0.4168701171875000, 0.0000610351562500, 0.5252685546875000,
0.0000915527343750, 0.5495910644531250, 0.0000305175781250, 0.5221557617187500,
0.0000610351562500, 0.5501403808593750, 0.0000915527343750, 0.5527038574218750,
-0.0000305175781250, 0.4828796386718750, -0.0000305175781250, 0.5009460449218750,
0.0000305175781250, 0.4580688476562500, 0.0000000000000000, 0.3840942382812500,
-0.0000305175781250, 0.4128112792968750, 0.0000305175781250, 0.3078308105468750,
0.0000915527343750, 0.3061523437500000, 0.0000305175781250, 0.2855529785156250,
0.0000305175781250, 0.2178955078125000, 0.0000305175781250, 0.2356262207031250,
0.0000000000000000, 0.1813964843750000, 0.0000000000000000, 0.1755371093750000,
0.0000305175781250, 0.1612854003906250, 0.0000000000000000, 0.1248779296875000,
0.0000000000000000, 0.1304626464843750, 0.0000000000000000, 0.0942382812500000,
0.0000610351562500, 0.0851135253906250, 0.0000305175781250, 0.0755004882812500,
0.0000305175781250, 0.0533752441406250, 0.0000610351562500, 0.0531616210937500,
-0.0000305175781250, 0.0402526855468750, 0.0000000000000000, 0.0287475585937500,
0.0000000000000000, 0.0240478515625000, -0.0000305175781250, 0.0184631347656250,
0.0000000000000000, 0.0142211914062500, 0.0000610351562500, 0.0197143554687500,
0.0000610351562500, 0.0024108886718750, 0.0000000000000000, 0.0110473632812500,
0.0000000000000000, 0.0244445800781250, 0.0000305175781250, 0.0058593750000000,
0.0000000000000000, 0.0514526367187500, 0.0000000000000000, 0.0375671386718750,
0.0000000000000000, 0.0542907714843750, -0.0000305175781250, 0.0919189453125000,
0.0000000000000000, 0.0656127929687500, 0.0000000000000000, 0.1246337890625000,
0.0000000000000000, 0.1111145019531250, 0.0000000000000000, 0.1311950683593750,
0.0000305175781250, 0.1790771484375000, 0.0000000000000000, 0.1503906250000000,
-0.0000305175781250, 0.2189636230468750, 0.0000000000000000, 0.2096557617187500,
0.0000305175781250, 0.2281494140625000, 0.0000305175781250, 0.2757263183593750,
0.0000000000000000, 0.2457885742187500, -0.0000305175781250, 0.3085937500000000,
0.0000000000000000, 0.2979125976562500, -0.0000305175781250, 0.3155822753906250,
-0.0000305175781250, 0.3591003417968750, -0.0000305175781250, 0.3312072753906250,
0.0000000000000000, 0.4077758789062500, -0.0000610351562500, 0.3858337402343750,
-0.0000305175781250, 0.4205322265625000, 0.0000000000000000, 0.4835815429687500,
0.0000000000000000, 0.4373474121093750, 0.0000000000000000, 0.5700073242187500,
0.0000000000000000, 0.5420532226562500, -0.0000305175781250, 0.5945739746093750,
-0.0000915527343750, 0.7084960937500000, -0.0000610351562500, 0.6417846679687500,
-0.0000305175781250, 0.7787780761718750, -0.0000610351562500, 0.7788391113281250,
-0.0000305175781250, 0.7649230957031250, 0.0000305175781250, 0.8406982421875000,
0.0000000000000000, 0.8235168457031250, 0.0000000000000000, 0.7478027343750000,
0.0000305175781250, 0.8016662597656250, 0.0000000000000000, 0.7060241699218750,
-0.0000610351562500, 0.5867614746093750, -0.0000305175781250, 0.6701049804687500,
0.0000610351562500, 0.4246520996093750, 0.0000000000000000, 0.4506530761718750,
0.0000305175781250, 0.3981628417968750, 0.0001220703125000, 0.2196350097656250,
0.0000915527343750, 0.2942504882812500, -0.0000305175781250, 0.1739501953125000,
0.0000000000000000, 0.1506958007812500, 0.0000000000000000, 0.1691284179687500,
-0.0001220703125000, 0.1334838867187500, -0.0001220703125000, 0.1389770507812500,
-0.0000305175781250, 0.1570129394531250, -0.0000610351562500, 0.1614074707031250,
-0.0000610351562500, 0.1450805664062500, 0.0000610351562500, 0.1536865234375000,
0.0000000000000000, 0.1634521484375000, -0.0000305175781250, 0.0534057617187500,
0.0000610351562500, 0.1001892089843750, -0.0000305175781250, 0.0117492675781250,
-0.0001525878906250, -0.1180725097656250, -0.0000915527343750, -0.0320434570312500,
-0.0001220703125000, -0.2635803222656250, -0.0002136230468750, -0.2528686523437500,
-0.0001220703125000, -0.2724914550781250, -0.0000305175781250, -0.4216918945312500,
-0.0000915527343750, -0.3670959472656250, 0.0002136230468750, -0.3641662597656250,
0.0002441406250000, -0.4231262207031250, 0.0000610351562500, -0.3353576660156250,
0.0001220703125000, -0.2477111816406250, 0.0002441406250000, -0.3161315917968750,
-0.0004882812500000, -0.1352233886718750, -0.0004272460937500, -0.1350097656250000,
-0.0002746582031250, -0.1349182128906250, -0.0007324218750000, -0.0391540527343750,
-0.0007629394531250, -0.0661926269531250, 0.0008544921875000, -0.0688476562500000,
0.0008850097656250, -0.0611572265625000, -0.0006408691406250, -0.0499877929687500,
0.0015869140625000, -0.0642395019531250, 0.0016174316406250, -0.0708312988281250,
-0.0146484375000000, 0.0538330078125000, -0.0046081542968750, 0.0025024414062500,
-0.0246582031250000, 0.0769958496093750, -0.0505371093750000, 0.2253112792968750,
-0.0319824218750000, 0.1415710449218750, -0.0785217285156250, 0.2505493164062500,
-0.0848083496093750, 0.2936706542968750, -0.0669860839843750, 0.2296447753906250,
-0.0739440917968750, 0.1891174316406250, 0.1296691894531250, 0.1123352050781250,
0.2735900878906250, 0.2359619140625000, 0.2972717285156250, 0.2599487304687500,
0.2092590332031250, 0.1910400390625000, 0.1994628906250000, 0.1734619140625000,
0.2606201171875000, 0.2186889648437500, -0.0165405273437500, 0.0360412597656250,
0.0311889648437500, 0.0531921386718750, -0.0245666503906250, 0.0317687988281250,
-0.2474670410156250, -0.0921630859375000, -0.1540222167968750, -0.0492553710937500,
-0.1788024902343750, -0.0618896484375000, -0.2746276855468750, -0.0915832519531250,
-0.1338195800781250, -0.0600891113281250, -0.0028686523437500, -0.0275878906250000,
-0.1159973144531250, -0.0492858886718750, 0.1441345214843750, -0.0088195800781250,
0.1800231933593750, -0.0019836425781250, 0.0877685546875000, -0.0077514648437500,
0.1762695312500000, 0.0040588378906250, 0.2073974609375000, 0.0028076171875000,
-0.1308898925781250, -0.0004272460937500, -0.0194396972656250, -0.0001525878906250,
-0.1567077636718750, 0.0003356933593750, -0.4968872070312500, -0.0007629394531250,
-0.3207092285156250, -0.0009155273437500, -0.5058288574218750, 0.0000305175781250,
-0.6077880859375000, 0.0002746582031250, -0.4500732421875000, -0.0000610351562500,
-0.4114990234375000, -0.0000915527343750, -0.5037536621093750, 0.0000915527343750,
-0.1015319824218750, -0.0001220703125000, -0.1683654785156250, -0.0003051757812500,
-0.0827636718750000, -0.0001220703125000, 0.2221984863281250, 0.0000915527343750,
0.0833740234375000, -0.0000610351562500, 0.2283935546875000, -0.0001220703125000,
0.2940368652343750, 0.0000000000000000, 0.2145385742187500, -0.0000305175781250,
0.2067871093750000, -0.0001525878906250, 0.2510375976562500, -0.0001525878906250,
0.1177062988281250, 0.0000305175781250, 0.1247863769531250, 0.0000000000000000,
0.1294860839843750, -0.0000305175781250, 0.0515136718750000, 0.0001831054687500,
0.0729370117187500, 0.0001831054687500, 0.1216125488281250, -0.0001220703125000,
0.0713500976562500, -0.0000915527343750, 0.1474609375000000, -0.0000610351562500,
0.2345275878906250, -0.0002746582031250, 0.1615295410156250, -0.0002746582031250,
0.3753356933593750, -0.0000305175781250, 0.3368530273437500, 0.0000000000000000,
0.4011840820312500, -0.0000915527343750, 0.5679931640625000, -0.0000610351562500,
0.4786682128906250, 0.0000305175781250, 0.6627807617187500, -0.0001525878906250,
0.6630554199218750, -0.0002136230468750, 0.6695861816406250, -0.0000915527343750,
0.7725524902343750, -0.0000915527343750, 0.7329101562500000, -0.0001525878906250,
0.7465515136718750},
{-0.0005798339843750, -0.3108825683593750, 0.0007629394531250, -0.3648681640625000,
0.0009460449218750, -0.4243164062500000, -0.0008239746093750, -0.3346252441406250,
0.0008239746093750, -0.2791442871093750, 0.0012512207031250, -0.3408813476562500,
-0.0143432617187500, -0.1370544433593750, -0.0048522949218750, -0.1429748535156250,
-0.0228271484375000, -0.1310424804687500, -0.0473632812500000, -0.0095520019531250,
-0.0300292968750000, -0.0460510253906250, -0.0688171386718750, -0.0469970703125000,
-0.0787048339843750, -0.0275268554687500, -0.0531005859375000, -0.0293579101562500,
-0.0636596679687500, -0.0567932128906250, -0.0745239257812500, -0.0539855957031250,
0.0472106933593750, 0.0350341796875000, 0.0094909667968750, -0.0060729980468750,
0.0549011230468750, 0.0425415039062500, 0.2493591308593750, 0.2209472656250000,
0.2226257324218750, -0.0434570312500000, -0.0920715332031250, 0.0476989746093750,
0.0332946777343750, -0.0287475585937500, -0.0459594726562500, 0.0578918457031250,
-0.2491760253906250, 0.1772155761718750, -0.1765136718750000, 0.1119689941406250,
-0.1326599121093750, 0.1967468261718750, -0.2265625000000000, 0.2427978515625000,
-0.1006469726562500, 0.1677551269531250, 0.0587463378906250, 0.1419677734375000,
-0.0548095703125000, 0.1878967285156250, 0.1592712402343750, 0.0194702148437500,
0.2184448242187500, 0.0302124023437500, 0.0982971191406250, 0.0194091796875000,
0.1278076171875000, -0.0850219726562500, 0.1889343261718750, -0.0520019531250000,
-0.1893005371093750, -0.0525817871093750, -0.0994262695312500, -0.0771484375000000,
-0.2052307128906250, -0.0512390136718750, -0.5395812988281250, -0.0191955566406250,
-0.3821105957031250, -0.0381469726562500, -0.4755249023437500, -0.0064392089843750,
-0.6070556640625000, 0.0000915527343750, -0.4131774902343750, -0.0053710937500000,
-0.2805175781250000, 0.0026855468750000, -0.4293518066406250, 0.0023803710937500,
-0.0100708007812500, -0.0005493164062500, -0.0466613769531250, -0.0007934570312500,
-0.0089721679687500, -0.0000305175781250, 0.2623596191406250, -0.0004577636718750,
0.1594543457031250, -0.0008544921875000, 0.2152709960937500, 0.0000305175781250,
0.2806091308593750, 0.0003356933593750, 0.2106628417968750, 0.0000610351562500,
0.1579589843750000, 0.0000000000000000, 0.2079467773437500, 0.0000915527343750,
0.1057128906250000, -0.0000610351562500, 0.0912780761718750, -0.0001525878906250,
0.1239013671875000, -0.0000305175781250, 0.0921020507812500, 0.0000915527343750,
0.0836791992187500, 0.0000305175781250, 0.1821899414062500, -0.0001831054687500,
0.1429138183593750, -0.0000915527343750, 0.2030334472656250, -0.0000305175781250,
0.3031921386718750, -0.0002136230468750, 0.2377014160156250, -0.0002136230468750,
0.4121704101562500, 0.0000000000000000, 0.3858337402343750, 0.0000000000000000,
0.4335021972656250, -0.0001220703125000, 0.5626525878906250, 0.0000000000000000,
0.4908447265625000, 0.0000305175781250, 0.6326293945312500, -0.0001525878906250,
0.6347351074218750, -0.0001831054687500, 0.6338195800781250, -0.0000610351562500,
0.7112426757812500, -0.0000915527343750, 0.6859741210937500, -0.0001525878906250,
0.6744995117187500, 0.0000610351562500, 0.7051696777343750, 0.0001220703125000,
0.6531982421875000, 0.0000000000000000, 0.6072082519531250, 0.0000000000000000,
0.6472473144531250, 0.0000610351562500, 0.4976501464843750, -0.0000305175781250,
0.5300598144531250, -0.0000915527343750, 0.4682617187500000, 0.0000610351562500,
0.3478698730468750, 0.0000610351562500, 0.4258422851562500, -0.0000305175781250,
0.2342834472656250, 0.0000610351562500, 0.2681884765625000, 0.0001525878906250,
0.2074890136718750, 0.0000305175781250, 0.0644226074218750, 0.0000000000000000,
0.1543579101562500, 0.0000305175781250, -0.0498046875000000, 0.0000610351562500,
-0.0177612304687500, 0.0000000000000000, -0.0734252929687500, 0.0000305175781250,
-0.2216491699218750, 0.0000915527343750, -0.1313781738281250, 0.0000915527343750,
-0.3152770996093750, 0.0000305175781250, -0.2975463867187500, 0.0000915527343750,
-0.3227844238281250, 0.0000610351562500, -0.4385375976562500, -0.0000305175781250,
-0.3763732910156250, 0.0000000000000000, -0.4769287109375000, 0.0000000000000000,
-0.4782104492187500, 0.0000610351562500, -0.4771118164062500, 0.0000610351562500,
-0.5298156738281250, 0.0000000000000000, -0.5107727050781250, 0.0000305175781250,
-0.5236206054687500, -0.0000305175781250, -0.5336303710937500, -0.0000305175781250,
-0.5214538574218750, 0.0000305175781250, -0.5184020996093750, -0.0000305175781250,
-0.5277404785156250, 0.0000000000000000, -0.4983215332031250, 0.0000305175781250,
-0.5080566406250000, 0.0000305175781250, -0.4951477050781250, 0.0000000000000000,
-0.4705200195312500, 0.0000305175781250, -0.4904785156250000, 0.0000610351562500,
-0.4471130371093750, 0.0000305175781250, -0.4572753906250000, 0.0000305175781250,
-0.4469299316406250, -0.0000305175781250, -0.4150390625000000, 0.0000000000000000,
-0.4376525878906250, 0.0000305175781250, -0.4032592773437500, 0.0000305175781250,
-0.4099426269531250, 0.0000000000000000, -0.4055175781250000, 0.0000000000000000,
-0.3834838867187500, 0.0000000000000000, -0.4017639160156250, 0.0000000000000000,
-0.3817749023437500, -0.0000610351562500, -0.3836364746093750, -0.0000305175781250,
-0.3861083984375000, 0.0000000000000000, -0.3776855468750000, -0.0000305175781250,
-0.3828125000000000, -0.0000305175781250, -0.3716430664062500, 0.0000000000000000,
-0.3740234375000000, 0.0000610351562500, -0.3623657226562500, 0.0000305175781250,
-0.3507385253906250, 0.0000610351562500, -0.3580932617187500, 0.0000610351562500,
-0.3125915527343750, 0.0000000000000000, -0.3250732421875000, 0.0000305175781250,
-0.2967224121093750, 0.0000610351562500, -0.2507629394531250, 0.0000610351562500,
-0.2764282226562500, 0.0000305175781250, -0.1992492675781250, 0.0000610351562500,
-0.2055358886718750, 0.0000610351562500, -0.1876220703125000, 0.0000305175781250,
-0.1327819824218750, 0.0000610351562500, -0.1558532714843750, 0.0000610351562500,
-0.1101684570312500, 0.0000305175781250, -0.1090087890625000, -0.0000305175781250,
-0.0961608886718750, 0.0000305175781250, -0.0700988769531250, 0.0000000000000000,
-0.0819702148437500, -0.0000305175781250, -0.0164794921875000, 0.0000915527343750,
-0.0387268066406250, 0.0000915527343750, 0.0201721191406250, 0.0000610351562500,
0.0946350097656250, 0.0000915527343750, 0.0495605468750000, 0.0000915527343750,
0.2416076660156250, -0.0000305175781250, 0.2158813476562500, 0.0000305175781250,
0.2807922363281250, 0.0000610351562500, 0.4392395019531250, 0.0000305175781250,
0.3680419921875000, 0.0000000000000000, 0.4974975585937500, 0.0000305175781250,
0.5352478027343750, 0.0000305175781250, 0.4835815429687500, -0.0000305175781250,
0.5119323730468750, -0.0000610351562500, 0.5302734375000000, -0.0000305175781250,
0.3385925292968750, -0.0001525878906250, 0.3936157226562500, -0.0001525878906250,
0.2852478027343750, -0.0000915527343750, 0.0853271484375000, -0.0001525878906250,
0.1892395019531250, -0.0001831054687500, -0.0310668945312500, -0.0000610351562500,
-0.0538940429687500, -0.0000610351562500, -0.0349121093750000, -0.0000915527343750,
-0.1270751953125000, -0.0000915527343750, -0.1098022460937500, -0.0000305175781250,
-0.0683288574218750, -0.0000610351562500, -0.0867309570312500, -0.0000915527343750,
-0.0727539062500000, -0.0001220703125000, -0.0257873535156250, -0.0000305175781250,
-0.0416564941406250, -0.0000305175781250, -0.0598144531250000, -0.0005798339843750,
-0.0377807617187500, -0.0004882812500000, -0.0651245117187500, -0.0002136230468750,
-0.1104431152343750, -0.0007019042968750, -0.0866699218750000, -0.0008544921875000,
-0.1103515625000000, 0.0007629394531250, -0.1286621093750000, 0.0012512207031250,
-0.1022338867187500, -0.0018615722656250, -0.0860900878906250, -0.0007934570312500,
-0.1033325195312500, 0.0010070800781250, -0.0571899414062500, -0.0179748535156250,
-0.0547180175781250, -0.0105895996093750, -0.0546569824218750, -0.0200805664062500,
-0.0376892089843750, -0.0440673828125000, -0.0424499511718750, -0.0314025878906250,
-0.0124816894531250, -0.0288696289062500, -0.0305175781250000, -0.0488281250000000,
0.0045776367187500, -0.0141601562500000, 0.0694274902343750, 0.0300292968750000,
0.0678710937500000, 0.0227050781250000, 0.1416931152343750, 0.0971069335937500,
0.1363220214843750, 0.0832214355468750, 0.1088867187500000, 0.0736694335937500,
0.1439208984375000, 0.1224975585937500, 0.1524047851562500, 0.1145019531250000,
0.0537109375000000, 0.0643310546875000, 0.0845336914062500, 0.0853576660156250,
0.0518493652343750, 0.0590209960937500, -0.0408935546875000, -0.0000915527343750,
0.0040283203125000, 0.0263366699218750, -0.0414123535156250, 0.0006408691406250,
-0.0643005371093750, -0.0127258300781250, -0.0384826660156250, -0.0052490234375000,
-0.0313720703125000, 0.0021057128906250, -0.0448913574218750, -0.0015869140625000,
-0.0099792480468750, -0.0347290039062500, -0.0075988769531250, -0.0136413574218750,
-0.0104675292968750, -0.0461730957031250, 0.0036621093750000, -0.1016235351562500,
0.0011291503906250, -0.0703430175781250, -0.0009460449218750, -0.1095886230468750,
0.0001525878906250, -0.1315612792968750, 0.0001525878906250, -0.0980224609375000,
-0.0014038085937500, -0.0840454101562500, -0.0014038085937500, -0.1065368652343750,
-0.0001525878906250, -0.0480346679687500, -0.0002441406250000, -0.0419921875000000,
-0.0003967285156250, -0.0556945800781250, 0.0001525878906250, -0.0370788574218750,
0.0002136230468750, -0.0329284667968750, -0.0002136230468750, -0.0610656738281250,
-0.0002441406250000, -0.0681152343750000, -0.0000610351562500, -0.0395507812500000,
-0.0000915527343750, -0.0449523925781250, -0.0001831054687500, -0.0603332519531250,
0.0000305175781250, 0.0742187500000000, 0.0001220703125000, 0.0301818847656250,
0.0000000000000000, 0.1061096191406250, -0.0000915527343750, 0.2490234375000000,
0.0000610351562500, 0.1718444824218750, -0.0000915527343750, 0.3338928222656250,
-0.0001831054687500, 0.3500366210937500, -0.0000610351562500, 0.3376770019531250,
0.0000610351562500, 0.4102783203125000, -0.0000610351562500, 0.3961181640625000,
0.0000000000000000, 0.3518676757812500, 0.0000915527343750, 0.3813781738281250,
-0.0000305175781250, 0.3280944824218750, -0.0001220703125000, 0.2565002441406250,
-0.0000305175781250, 0.2941284179687500, -0.0000915527343750, 0.1663513183593750,
-0.0001831054687500, 0.1713867187500000, -0.0000305175781250, 0.1346740722656250,
0.0000305175781250, 0.0450439453125000, -0.0000610351562500, 0.0809631347656250,
0.0000305175781250, -0.0210876464843750, 0.0000610351562500, -0.0188903808593750,
0.0000000000000000, -0.0461120605468750, 0.0000000000000000, -0.1149597167968750,
0.0000305175781250, -0.0856018066406250, -0.0000305175781250, -0.1666870117187500,
-0.0000915527343750, -0.1665344238281250, 0.0000000000000000, -0.1855773925781250,
0.0000610351562500, -0.2409667968750000, -0.0000305175781250, -0.2201232910156250,
0.0000305175781250, -0.2632446289062500, 0.0000610351562500, -0.2703552246093750,
0.0000610351562500, -0.2690429687500000, -0.0000610351562500, -0.2863769531250000,
0.0000305175781250, -0.2810974121093750, 0.0000000000000000, -0.2762451171875000,
-0.0000305175781250, -0.2801513671875000, 0.0000305175781250, -0.2651062011718750,
0.0000915527343750, -0.2492980957031250, 0.0000000000000000, -0.2545166015625000,
0.0000610351562500, -0.2243652343750000, 0.0000915527343750, -0.2183227539062500,
0.0000305175781250},
{-0.0603637695312500, 0.0606689453125000, -0.0570678710937500, 0.0610046386718750,
-0.0403747558593750, 0.1234741210937500, -0.0387573242187500, 0.1129150390625000,
0.0286254882812500, 0.0632934570312500, -0.0102539062500000, 0.0929565429687500,
0.0227661132812500, 0.0717163085937500, 0.0971984863281250, 0.0140991210937500,
0.0457763671875000, 0.0413513183593750, 0.1307067871093750, 0.0025634765625000,
0.1504516601562500, -0.0105895996093750, 0.1108703613281250, -0.0009460449218750,
0.1275329589843750, -0.0007019042968750, 0.1464233398437500, -0.0051879882812500,
0.0373535156250000, -0.0262451171875000, 0.0596618652343750, -0.0065917968750000,
0.0369567871093750, -0.0407104492187500, -0.0514221191406250, -0.0883178710937500,
-0.0159301757812500, -0.0579223632812500, -0.0392456054687500, -0.1113891601562500,
-0.0606079101562500, -0.1285095214843750, -0.0375061035156250, -0.1009216308593750,
-0.0214233398437500, -0.1009521484375000, -0.0361938476562500, -0.1149597167968750,
-0.0067138671875000, -0.0612792968750000, -0.0031127929687500, -0.0590820312500000,
-0.0070190429687500, -0.0682678222656250, 0.0028991699218750, -0.0478820800781250,
0.0017089843750000, -0.0457763671875000, -0.0007629394531250, -0.0618896484375000,
-0.0003662109375000, -0.0708923339843750, -0.0000305175781250, -0.0377807617187500,
-0.0010375976562500, -0.0332946777343750, -0.0012207031250000, -0.0540466308593750,
-0.0000915527343750, 0.0910034179687500, -0.0000305175781250, 0.0503845214843750,
-0.0003051757812500, 0.1168518066406250, 0.0000305175781250, 0.2573242187500000,
0.0001525878906250, 0.1818847656250000, -0.0001831054687500, 0.3161926269531250,
-0.0002441406250000, 0.3392944335937500, -0.0000915527343750, 0.3106384277343750,
-0.0000610351562500, 0.3538208007812500, -0.0001525878906250, 0.3550415039062500,
-0.0000305175781250, 0.2843933105468750, 0.0000305175781250, 0.3102722167968750,
-0.0000305175781250, 0.2601318359375000, -0.0001525878906250, 0.1817016601562500,
-0.0000610351562500, 0.2274780273437500, -0.0001525878906250, 0.1068115234375000,
-0.0002441406250000, 0.1127929687500000, -0.0001525878906250, 0.0799255371093750,
0.0000305175781250, -0.0038452148437500, -0.0000915527343750, 0.0329589843750000,
-0.0000915527343750, -0.0661010742187500, 0.0000000000000000, -0.0656127929687500,
-0.0000915527343750, -0.0878906250000000, -0.0001831054687500, -0.1544799804687500,
-0.0000915527343750, -0.1278076171875000, -0.0000610351562500, -0.1786804199218750,
-0.0001831054687500, -0.1873779296875000, -0.0000915527343750, -0.1784057617187500,
0.0000305175781250, -0.1965332031250000, -0.0000610351562500, -0.1948547363281250,
-0.0000610351562500, -0.1659851074218750, 0.0000000000000000, -0.1768798828125000,
-0.0000305175781250, -0.1524353027343750, -0.0000915527343750, -0.1155395507812500,
-0.0000610351562500, -0.1303100585937500, -0.0000915527343750, -0.0678710937500000,
-0.0000915527343750, -0.0670776367187500, -0.0000305175781250, -0.0557556152343750,
-0.0000305175781250, -0.0147399902343750, -0.0000305175781250, -0.0249633789062500,
-0.0000305175781250, -0.0041198730468750, 0.0000000000000000, 0.0035400390625000,
-0.0000610351562500, -0.0034790039062500, -0.0000305175781250, 0.0004272460937500,
-0.0000305175781250, 0.0052185058593750, -0.0000305175781250, -0.0151672363281250,
-0.0000610351562500, -0.0097351074218750, -0.0000610351562500, -0.0226440429687500,
-0.0000305175781250, -0.0453491210937500, -0.0000305175781250, -0.0367736816406250,
-0.0000610351562500, -0.0687561035156250, -0.0000305175781250, -0.0691833496093750,
-0.0000305175781250, -0.0789184570312500, -0.0000610351562500, -0.1008300781250000,
-0.0000610351562500, -0.0932617187500000, -0.0000610351562500, -0.1209411621093750,
-0.0000610351562500, -0.1241149902343750, -0.0000305175781250, -0.1290588378906250,
-0.0000305175781250, -0.1446838378906250, -0.0000610351562500, -0.1427612304687500,
0.0000000000000000, -0.1587829589843750, -0.0000305175781250, -0.1578369140625000,
-0.0000305175781250, -0.1651000976562500, -0.0000305175781250, -0.1777648925781250,
-0.0000305175781250, -0.1710815429687500, 0.0000000000000000, -0.1881713867187500,
0.0000000000000000, -0.1882629394531250, 0.0000000000000000, -0.1938171386718750,
0.0000000000000000, -0.2069702148437500, 0.0000000000000000, -0.2039794921875000,
-0.0000305175781250, -0.2175903320312500, 0.0000305175781250, -0.2176818847656250,
-0.0000305175781250, -0.2265014648437500, 0.0000000000000000, -0.2385559082031250,
0.0000000000000000, -0.2338562011718750, -0.0000915527343750, -0.2576293945312500,
-0.0000915527343750, -0.2524108886718750, -0.0000305175781250, -0.2656860351562500,
-0.0000915527343750, -0.2885131835937500, -0.0000610351562500, -0.2783813476562500,
-0.0000305175781250, -0.3191223144531250, -0.0000610351562500, -0.3118591308593750,
-0.0000305175781250, -0.3230590820312500, -0.0000305175781250, -0.3559570312500000,
-0.0000305175781250, -0.3399658203125000, -0.0000915527343750, -0.3631591796875000,
-0.0001220703125000, -0.3739013671875000, -0.0000915527343750, -0.3549499511718750,
-0.0000610351562500, -0.3566284179687500, -0.0000915527343750, -0.3683166503906250,
-0.0000305175781250, -0.2950744628906250, 0.0000305175781250, -0.3241882324218750,
-0.0000305175781250, -0.2683715820312500, -0.0000610351562500, -0.1877136230468750,
-0.0000305175781250, -0.2430419921875000, -0.0000610351562500, -0.0823669433593750,
-0.0001525878906250, -0.1079406738281250, -0.0000915527343750, -0.0522460937500000,
0.0000000000000000, 0.0711059570312500, -0.0000610351562500, 0.0015869140625000,
0.0000305175781250, 0.1760864257812500, 0.0000610351562500, 0.1555480957031250,
0.0000305175781250, 0.2110595703125000, -0.0000610351562500, 0.3431396484375000,
0.0000305175781250, 0.2767333984375000, -0.0000915527343750, 0.4466857910156250,
-0.0001220703125000, 0.4412536621093750, -0.0000610351562500, 0.4703979492187500,
-0.0000610351562500, 0.5823974609375000, -0.0000915527343750, 0.5355224609375000,
0.0000915527343750, 0.5959472656250000, 0.0000915527343750, 0.6173706054687500,
0.0000610351562500, 0.5903320312500000, 0.0001831054687500, 0.5982971191406250,
0.0001831054687500, 0.6102600097656250, -0.0001831054687500, 0.5385131835937500,
-0.0000915527343750, 0.5610351562500000, -0.0000610351562500, 0.5170288085937500,
-0.0003967285156250, 0.4487609863281250, -0.0003662109375000, 0.4931640625000000,
0.0005187988281250, 0.3550109863281250, 0.0006103515625000, 0.3804016113281250,
-0.0007629394531250, 0.3309631347656250, 0.0005187988281250, 0.2160339355468750,
0.0008850097656250, 0.2766723632812500, -0.0118103027343750, 0.1479187011718750,
-0.0042724609375000, 0.1417846679687500, -0.0186767578125000, 0.1415710449218750,
-0.0385437011718750, 0.0809936523437500, -0.0241394042968750, 0.1002807617187500,
-0.0523986816406250, 0.0739135742187500, -0.0619506835937500, 0.0835571289062500,
-0.0382385253906250, 0.0457763671875000, -0.0428161621093750, 0.0177612304687500,
-0.0552673339843750, 0.0503845214843750, 0.0478820800781250, -0.1168823242187500,
0.0130920410156250, -0.0768432617187500, 0.0668029785156250, -0.1484375000000000,
0.1809692382812500, -0.3118591308593750, 0.1198120117187500, -0.2284851074218750,
0.1936645507812500, -0.3299560546875000, 0.2398376464843750, -0.3833923339843750,
0.1556396484375000, -0.2956237792968750, 0.1265258789062500, -0.2704772949218750,
0.1790466308593750, -0.3250427246093750, -0.0526428222656250, -0.1226806640625000,
-0.0312194824218750, -0.1373901367187500, -0.0366516113281250, -0.1355285644531250,
-0.2461547851562500, 0.0400390625000000, 0.0039062500000000, -0.2932739257812500,
0.1537780761718750, -0.0610961914062500, 0.2085266113281250, -0.1352539062500000,
0.0702819824218750, -0.0910644531250000, 0.0177307128906250, 0.0338439941406250,
0.1182861328125000, -0.0017395019531250, -0.2425537109375000, -0.0117797851562500,
-0.2084350585937500, 0.0092468261718750, -0.2385864257812500, 0.0050354003906250,
-0.4871215820312500, -0.0282592773437500, -0.4005737304687500, -0.0231933593750000,
-0.3400878906250000, 0.0533447265625000, -0.4581909179687500, 0.0166625976562500,
-0.2872924804687500, 0.0615844726562500, -0.0836791992187500, 0.1614074707031250,
-0.2298278808593750, 0.1115722656250000, 0.1080322265625000, 0.1468505859375000,
0.1210632324218750, 0.1906738281250000, 0.1000976562500000, 0.1253356933593750,
0.2607727050781250, 0.0773315429687500, 0.2251586914062500, 0.1234436035156250,
0.1763610839843750, -0.0053710937500000, 0.2153625488281250, -0.0080871582031250,
0.1872863769531250, -0.0042419433593750, 0.1163940429687500, -0.0697021484375000,
0.1482543945312500, -0.0548095703125000, 0.1411132812500000, -0.0360107421875000,
0.1137695312500000, -0.0505371093750000, 0.1495971679687500, -0.0350341796875000,
0.1818847656250000, -0.0059204101562500, 0.1551208496093750, -0.0194702148437500,
0.2324523925781250, -0.0026245117187500, 0.2192687988281250, 0.0028991699218750,
0.2503051757812500, -0.0013122558593750, 0.3050231933593750, 0.0005798339843750,
0.2706909179687500, 0.0012207031250000, 0.4072570800781250, -0.0003051757812500,
0.3674316406250000, -0.0008850097656250, 0.4372863769531250, -0.0002746582031250,
0.5701599121093750, 0.0000000000000000, 0.4858703613281250, -0.0002441406250000,
0.6530151367187500, 0.0000000000000000, 0.6670532226562500, 0.0002136230468750,
0.6310119628906250, 0.0000610351562500, 0.7058410644531250, -0.0000610351562500,
0.7026367187500000, -0.0000610351562500, 0.5528564453125000, 0.0000610351562500,
0.6349487304687500, 0.0000610351562500, 0.5113830566406250, 0.0000000000000000,
0.3264770507812500, 0.0000610351562500, 0.4577636718750000, 0.0001220703125000,
0.1369323730468750, -0.0000305175781250, 0.1669311523437500, -0.0000610351562500,
0.1141052246093750, 0.0000305175781250, -0.0982971191406250, 0.0000915527343750,
-0.0013122558593750, 0.0000000000000000, -0.1686096191406250, 0.0000305175781250,
-0.1759643554687500, 0.0000915527343750, -0.1829833984375000, 0.0000000000000000,
-0.2682800292968750, -0.0000915527343750, -0.2325439453125000, -0.0000305175781250,
-0.2824707031250000, -0.0000610351562500, -0.2871093750000000, -0.0000915527343750,
-0.2875061035156250, -0.0000305175781250, -0.3121032714843750, 0.0000305175781250,
-0.3025512695312500, 0.0000305175781250, -0.3114013671875000, -0.0000305175781250,
-0.3173828125000000, 0.0000000000000000, -0.3142089843750000, -0.0000610351562500,
-0.3144531250000000, -0.0000915527343750, -0.3181762695312500, -0.0000915527343750,
-0.3121948242187500, -0.0000305175781250, -0.3122558593750000, -0.0000610351562500,
-0.3116149902343750, -0.0000305175781250, -0.3067932128906250, 0.0000610351562500,
-0.3059997558593750, 0.0000610351562500, -0.3039855957031250, -0.0000305175781250,
-0.3025817871093750, -0.0000305175781250, -0.2998962402343750, 0.0000000000000000,
-0.2963562011718750, 0.0000000000000000, -0.2941589355468750, 0.0000000000000000,
-0.2900695800781250, 0.0000610351562500, -0.2878417968750000, 0.0001220703125000,
-0.2817687988281250, 0.0000610351562500, -0.2777099609375000, 0.0000305175781250,
-0.2781677246093750, 0.0000305175781250, -0.2630004882812500, 0.0000000000000000,
-0.2662963867187500, 0.0000000000000000, -0.2539978027343750, 0.0000305175781250,
-0.2375183105468750, 0.0000305175781250, -0.2452392578125000, 0.0000305175781250,
-0.2116088867187500, 0.0000305175781250, -0.2178955078125000, 0.0000305175781250,
-0.2012939453125000, 0.0000305175781250, -0.1720275878906250, 0.0000305175781250,
-0.1882019042968750},
{0.2118225097656250, -0.0136718750000000, 0.1962280273437500, -0.0140380859375000,
0.1408691406250000, 0.0647888183593750, 0.1605834960937500, 0.0368957519531250,
0.1566772460937500, 0.0690917968750000, 0.1090087890625000, 0.1566772460937500,
0.1226501464843750, 0.1175842285156250, 0.1613159179687500, 0.1268005371093750,
0.1355285644531250, 0.1672058105468750, 0.1660461425781250, 0.1080017089843750,
0.2200012207031250, 0.0505065917968750, 0.1897888183593750, 0.0946655273437500,
0.2463073730468750, -0.0148010253906250, 0.2379455566406250, -0.0236816406250000,
0.2675781250000000, -0.0135192871093750, 0.3056030273437500, -0.0597229003906250,
0.2740173339843750, -0.0526428222656250, 0.4207458496093750, -0.0270996093750000,
0.3740234375000000, -0.0372314453125000, 0.4507751464843750, -0.0272827148437500,
0.6018066406250000, -0.0013732910156250, 0.5105590820312500, -0.0117492675781250,
0.6709594726562500, -0.0015258789062500, 0.7063293457031250, 0.0028686523437500,
0.6325378417968750, -0.0001525878906250, 0.6725158691406250, 0.0001525878906250,
0.7025146484375000, 0.0006408691406250, 0.4535217285156250, -0.0000305175781250,
0.5443420410156250, -0.0005493164062500, 0.4093627929687500, -0.0001220703125000,
0.1555786132812500, 0.0003356933593750, 0.3118896484375000, 0.0001220703125000,
-0.0139160156250000, 0.0001220703125000, -0.0099182128906250, 0.0002746582031250,
-0.0221862792968750, 0.0001831054687500, -0.2009277343750000, 0.0000305175781250,
-0.1327209472656250, 0.0000305175781250, -0.1970214843750000, 0.0000305175781250,
-0.2190246582031250, 0.0000915527343750, -0.2084350585937500, 0.0000000000000000,
-0.2209472656250000, -0.0000305175781250, -0.2208251953125000, 0.0000000000000000,
-0.2389526367187500, -0.0000305175781250, -0.2253112792968750, -0.0001220703125000,
-0.2509155273437500, -0.0000305175781250, -0.2798156738281250, 0.0000915527343750,
-0.2557373046875000, 0.0000305175781250, -0.3327636718750000, 0.0000305175781250,
-0.3203735351562500, 0.0000915527343750, -0.3408203125000000, 0.0000000000000000,
-0.3985595703125000, -0.0000915527343750, -0.3667602539062500, 0.0000000000000000,
-0.4176025390625000, 0.0000610351562500, -0.4205017089843750, 0.0000000000000000,
-0.4105834960937500, 0.0000000000000000, -0.4321289062500000, 0.0000610351562500,
-0.4277954101562500, 0.0000610351562500, -0.4018859863281250, -0.0000610351562500,
-0.4188537597656250, -0.0000305175781250, -0.3907165527343750, -0.0000610351562500,
-0.3562622070312500, -0.0001220703125000, -0.3843994140625000, -0.0000915527343750,
-0.3037719726562500, -0.0000610351562500, -0.3224182128906250, -0.0000610351562500,
-0.2960815429687500, -0.0000915527343750, -0.2349548339843750, -0.0000915527343750,
-0.2761840820312500, -0.0000610351562500, -0.1838989257812500, -0.0001220703125000,
-0.2023620605468750, -0.0001220703125000, -0.1808471679687500, -0.0000915527343750,
-0.1141662597656250, -0.0000610351562500, -0.1560363769531250, -0.0000915527343750,
-0.0773925781250000, -0.0000305175781250, -0.0887451171875000, 0.0000000000000000,
-0.0746154785156250, -0.0000305175781250, -0.0236206054687500, -0.0000915527343750,
-0.0592956542968750, -0.0000305175781250, -0.0043029785156250, -0.0000610351562500,
-0.0125427246093750, -0.0000915527343750, -0.0080871582031250, -0.0000610351562500,
0.0251159667968750, -0.0000610351562500, 0.0027160644531250, -0.0000610351562500,
0.0329895019531250, -0.0000915527343750, 0.0284729003906250, -0.0000610351562500,
0.0291137695312500, -0.0000610351562500, 0.0463867187500000, -0.0001220703125000,
0.0343017578125000, -0.0000610351562500, 0.0484313964843750, -0.0000915527343750,
0.0449523925781250, -0.0000915527343750, 0.0463256835937500, -0.0001220703125000,
0.0550231933593750, -0.0001220703125000, 0.0464172363281250, -0.0001525878906250,
0.0575256347656250, -0.0001220703125000, 0.0561523437500000, -0.0000915527343750,
0.0553283691406250, -0.0000610351562500, 0.0609741210937500, -0.0000610351562500,
0.0577697753906250, -0.0000610351562500, 0.0620422363281250, -0.0000915527343750,
0.0597534179687500, -0.0000915527343750, 0.0635070800781250, -0.0000610351562500,
0.0668640136718750, -0.0000610351562500, 0.0625305175781250, -0.0000915527343750,
0.0853881835937500, -0.0000610351562500, 0.0772705078125000, -0.0000305175781250,
0.0928344726562500, -0.0000305175781250, 0.1176452636718750, -0.0000305175781250,
0.1037292480468750, -0.0000305175781250, 0.1499938964843750, 0.0000000000000000,
0.1476135253906250, 0.0000000000000000, 0.1603088378906250, -0.0000610351562500,
0.1957702636718750, -0.0000915527343750, 0.1819763183593750, -0.0000305175781250,
0.2008666992187500, -0.0000610351562500, 0.2115173339843750, -0.0000915527343750,
0.1894836425781250, -0.0000915527343750, 0.1824340820312500, -0.0000610351562500,
0.1915283203125000, -0.0000915527343750, 0.1213073730468750, -0.0000915527343750,
0.1347045898437500, -0.0001220703125000, 0.0965881347656250, -0.0000915527343750,
0.0281982421875000, -0.0001525878906250, 0.0592041015625000, -0.0001525878906250,
-0.0258789062500000, -0.0001220703125000, -0.0330810546875000, -0.0000915527343750,
-0.0324401855468750, -0.0000915527343750, -0.0733642578125000, -0.0001220703125000,
-0.0647277832031250, -0.0000610351562500, -0.0595397949218750, -0.0001220703125000,
-0.0713195800781250, -0.0001220703125000, -0.0586547851562500, -0.0000915527343750,
-0.0414428710937500, -0.0000610351562500, -0.0530700683593750, -0.0001525878906250,
-0.0297851562500000, -0.0002136230468750, -0.0315551757812500, -0.0000915527343750,
-0.0227355957031250, -0.0001831054687500, -0.0122070312500000, -0.0005187988281250,
-0.0216674804687500, -0.0003967285156250, 0.0413818359375000, 0.0000305175781250,
0.0115356445312500, -0.0003051757812500, 0.0735168457031250, -0.0001220703125000,
0.1561279296875000, 0.0013427734375000, 0.1024475097656250, 0.0006103515625000,
0.2796325683593750, -0.0042419433593750, 0.2715454101562500, 0.0007629394531250,
0.2845153808593750, -0.0086975097656250, 0.4034118652343750, -0.0194396972656250,
0.3645935058593750, -0.0101013183593750, 0.3181152343750000, -0.0311584472656250,
0.3832702636718750, -0.0363464355468750, 0.2771911621093750, -0.0204467773437500,
0.1506042480468750, -0.0252075195312500, 0.2355651855468750, -0.0337524414062500,
0.0089416503906250, 0.0332336425781250, 0.0066528320312500, 0.0133972167968750,
0.0076904296875000, 0.0353393554687500, -0.1124267578125000, 0.0996398925781250,
-0.0805969238281250, 0.0671081542968750, -0.0675659179687500, 0.0837402343750000,
-0.0889892578125000, 0.1117858886718750, -0.0744018554687500, 0.0733337402343750,
-0.0403442382812500, 0.0406188964843750, -0.0523376464843750, 0.0704040527343750,
-0.0683898925781250, 0.0064392089843750, -0.0518493652343750, -0.0002136230468750,
-0.0663146972656250, 0.0078430175781250, -0.1066589355468750, -0.0120544433593750,
-0.1015625000000000, -0.0105590820312500, -0.0849304199218750, -0.0212707519531250,
-0.1003417968750000, -0.0078430175781250, -0.0890502929687500, -0.0293884277343750,
-0.0649719238281250, -0.0541076660156250, -0.0801086425781250, -0.0334777832031250,
-0.0572814941406250, -0.0984191894531250, -0.0572204589843750, -0.1036376953125000,
-0.0457763671875000, -0.0908508300781250, -0.0363464355468750, -0.1171569824218750,
-0.0482177734375000, -0.1185302734375000, 0.0260620117187500, -0.0721130371093750,
-0.0001525878906250, -0.0812072753906250, 0.0357360839843750, -0.0747985839843750,
0.1181640625000000, -0.0384826660156250, 0.0743713378906250, -0.0475769042968750,
0.1187744140625000, -0.0502014160156250, 0.1502990722656250, -0.0504455566406250,
0.1014099121093750, -0.0319213867187500, 0.0788269042968750, -0.0334167480468750,
0.1125183105468750, -0.0449218750000000, 0.0079345703125000, 0.0632934570312500,
0.0130615234375000, 0.0274353027343750, 0.0100402832031250, 0.0859069824218750,
-0.0516967773437500, 0.2008972167968750, -0.0335693359375000, 0.1374511718750000,
-0.0300903320312500, 0.2487182617187500, -0.0446777343750000, 0.2668151855468750,
-0.0297851562500000, 0.2431335449218750, -0.0090332031250000, 0.2800292968750000,
-0.0206298828125000, 0.2806701660156250, -0.0030822753906250, 0.2212219238281250,
0.0009460449218750, 0.2435913085937500, -0.0026245117187500, 0.2076110839843750,
0.0011291503906250, 0.1471862792968750, 0.0013122558593750, 0.1826782226562500,
-0.0005493164062500, 0.0822143554687500, -0.0007324218750000, 0.0928955078125000,
-0.0002136230468750, 0.0657043457031250, -0.0003967285156250, -0.0097656250000000,
-0.0007324218750000, 0.0261230468750000, -0.0000305175781250, -0.0380859375000000,
0.0000915527343750, -0.0497436523437500, -0.0000610351562500, -0.0340270996093750,
-0.0000610351562500, -0.0550842285156250, 0.0000305175781250, -0.0568847656250000,
-0.0000610351562500, -0.0080261230468750, -0.0001220703125000, -0.0224304199218750,
-0.0000305175781250, 0.0092163085937500, 0.0001220703125000, 0.0643615722656250,
-0.0000305175781250, 0.0397033691406250, -0.0000305175781250, 0.1037292480468750,
0.0000915527343750, 0.1130065917968750, 0.0000305175781250, 0.1100158691406250,
-0.0000610351562500, 0.1377563476562500, 0.0000000000000000, 0.1337890625000000,
0.0000000000000000, 0.1172485351562500, -0.0000915527343750, 0.1274414062500000,
-0.0000610351562500, 0.1090393066406250, 0.0000305175781250, 0.0824584960937500,
0.0000305175781250, 0.0967712402343750, -0.0000305175781250, 0.0623168945312500,
0.0000305175781250, 0.0603027343750000, -0.0000305175781250, 0.0609741210937500,
-0.0000610351562500, 0.0437622070312500, -0.0000610351562500, 0.0484619140625000,
0.0000000000000000, 0.0541687011718750, -0.0000305175781250, 0.0495300292968750,
-0.0000610351562500, 0.0591735839843750, -0.0000305175781250, 0.0718383789062500,
0.0000000000000000, 0.0680236816406250, -0.0000610351562500, 0.0887451171875000,
-0.0000610351562500, 0.0903625488281250, -0.0000610351562500, 0.0955505371093750,
-0.0001525878906250, 0.1107788085937500, -0.0000915527343750, 0.1090393066406250,
-0.0000610351562500, 0.1139221191406250, -0.0000610351562500, 0.1198120117187500,
-0.0000610351562500, 0.1173095703125000, 0.0000000000000000, 0.1151428222656250,
0.0000000000000000, 0.1176757812500000, -0.0000610351562500, 0.1060180664062500,
0.0000000000000000, 0.1091918945312500, -0.0000610351562500, 0.1035766601562500,
-0.0000610351562500, 0.0923461914062500, -0.0000915527343750, 0.0976562500000000,
-0.0000610351562500, 0.0821228027343750, -0.0000610351562500, 0.0827026367187500,
-0.0000915527343750, 0.0780639648437500, -0.0000915527343750, 0.0676879882812500,
-0.0000915527343750, 0.0731811523437500, -0.0001525878906250, 0.0596618652343750,
-0.0001220703125000, 0.0615844726562500, -0.0000610351562500, 0.0566406250000000,
-0.0000915527343750, 0.0466613769531250, -0.0001220703125000, 0.0534057617187500,
-0.0000610351562500, 0.0382080078125000, -0.0000610351562500, 0.0412597656250000,
-0.0000610351562500, 0.0370788574218750, -0.0000610351562500, 0.0263061523437500,
-0.0000915527343750, 0.0321655273437500, -0.0000610351562500, 0.0108032226562500,
-0.0000915527343750, 0.0161743164062500, -0.0000610351562500, 0.0032348632812500,
0.0000610351562500, -0.0150451660156250, 0.0000000000000000, -0.0018005371093750,
-0.0000305175781250, -0.0494079589843750, -0.0000305175781250, -0.0325317382812500,
0.0000000000000000, -0.0585632324218750, 0.0000000000000000, -0.1021118164062500,
-0.0000305175781250, -0.0697326660156250, 0.0000000000000000, -0.1598205566406250,
0.0000305175781250},
{-0.0241088867187500, 0.1052856445312500, -0.0354003906250000, 0.1170043945312500,
-0.0246582031250000, 0.0935058593750000, -0.0049438476562500, 0.0232849121093750,
-0.0148620605468750, 0.0571594238281250, -0.0021057128906250, 0.0099487304687500,
0.0014343261718750, -0.0071411132812500, -0.0016784667968750, 0.0197143554687500,
0.0005493164062500, 0.0182495117187500, 0.0009765625000000, 0.0055236816406250,
-0.0004882812500000, 0.0735778808593750, -0.0007934570312500, 0.0628662109375000,
-0.0003051757812500, 0.0848999023437500, -0.0002746582031250, 0.1426696777343750,
-0.0005493164062500, 0.1171569824218750, -0.0000915527343750, 0.1470642089843750,
0.0000610351562500, 0.1622009277343750, -0.0000915527343750, 0.1417846679687500,
-0.0001220703125000, 0.1351318359375000, -0.0000610351562500, 0.1439819335937500,
-0.0000610351562500, 0.1023254394531250, -0.0000915527343750, 0.1021728515625000,
-0.0000915527343750, 0.0958862304687500, 0.0000610351562500, 0.0688171386718750,
0.0000000000000000, 0.0771179199218750, -0.0000305175781250, 0.0768127441406250,
0.0000305175781250, 0.0679016113281250, 0.0000305175781250, 0.0797424316406250,
-0.0000610351562500, 0.0924377441406250, -0.0000305175781250, 0.0837402343750000,
0.0000000000000000, 0.1064758300781250, -0.0000305175781250, 0.1086730957031250,
0.0000000000000000, 0.1072082519531250, 0.0000305175781250, 0.1184082031250000,
0.0000000000000000, 0.1157226562500000, -0.0000610351562500, 0.1006774902343750,
0.0000000000000000, 0.1076965332031250, 0.0000000000000000, 0.0928344726562500,
-0.0000915527343750, 0.0710449218750000, -0.0000610351562500, 0.0792236328125000,
0.0000000000000000, 0.0426025390625000, -0.0000610351562500, 0.0424499511718750,
-0.0000610351562500, 0.0279235839843750, 0.0000000000000000, -0.0018310546875000,
0.0000000000000000, 0.0065307617187500, -0.0000610351562500, -0.0233764648437500,
-0.0000305175781250, -0.0295715332031250, -0.0000610351562500, -0.0317993164062500,
-0.0001220703125000, -0.0461120605468750, -0.0001220703125000, -0.0462341308593750,
-0.0000610351562500, -0.0495605468750000, -0.0001220703125000, -0.0544128417968750,
-0.0001220703125000, -0.0548095703125000, -0.0001220703125000, -0.0542297363281250,
-0.0000915527343750, -0.0568847656250000, -0.0001220703125000, -0.0551757812500000,
-0.0001220703125000, -0.0570373535156250, -0.0000610351562500, -0.0592041015625000,
-0.0001220703125000, -0.0581359863281250, -0.0001220703125000, -0.0582885742187500,
-0.0000915527343750, -0.0612487792968750, -0.0000915527343750, -0.0590820312500000,
-0.0000610351562500, -0.0628356933593750, -0.0000610351562500, -0.0673217773437500,
-0.0000305175781250, -0.0640563964843750, -0.0000305175781250, -0.0756225585937500,
-0.0000305175781250, -0.0747375488281250, -0.0000305175781250, -0.0774230957031250,
-0.0000305175781250, -0.0852661132812500, -0.0000305175781250, -0.0810241699218750,
0.0000000000000000, -0.0869445800781250, 0.0000610351562500, -0.0906372070312500,
0.0000000000000000, -0.0874938964843750, -0.0000305175781250, -0.0880432128906250,
0.0000000000000000, -0.0905151367187500, 0.0000000000000000, -0.0763549804687500,
-0.0000305175781250, -0.0836181640625000, 0.0000000000000000, -0.0747070312500000,
0.0000610351562500, -0.0592346191406250, 0.0000305175781250, -0.0705261230468750,
0.0000915527343750, -0.0436706542968750, 0.0000305175781250, -0.0460205078125000,
0.0000610351562500, -0.0494995117187500, 0.0000305175781250, -0.0332336425781250,
0.0000305175781250, -0.0370788574218750, 0.0001220703125000, -0.0546875000000000,
0.0001220703125000, -0.0361328125000000, 0.0001220703125000, -0.0671997070312500,
0.0001525878906250, -0.0989379882812500, 0.0001525878906250, -0.0697631835937500,
0.0001220703125000, -0.1678771972656250, 0.0001831054687500, -0.1428833007812500,
0.0001220703125000, -0.1870727539062500, 0.0000610351562500, -0.2765502929687500,
0.0001220703125000, -0.2247314453125000, 0.0000915527343750, -0.3427124023437500,
0.0000610351562500, -0.3390502929687500, 0.0000915527343750, -0.3481140136718750,
0.0001831054687500, -0.4196166992187500, 0.0001525878906250, -0.3893737792968750,
0.0000915527343750, -0.4016723632812500, 0.0001831054687500, -0.4269714355468750,
0.0000610351562500, -0.3870544433593750, -0.0002136230468750, -0.3589172363281250,
-0.0000610351562500, -0.3862609863281250, 0.0001525878906250, -0.2825317382812500,
0.0000000000000000, -0.2941894531250000, -0.0001525878906250, -0.2705078125000000,
0.0007934570312500, -0.1939697265625000, 0.0005187988281250, -0.2289428710937500,
-0.0046081542968750, -0.1925048828125000, -0.0001525878906250, -0.1823425292968750,
-0.0088500976562500, -0.1885986328125000, -0.0189208984375000, -0.1914672851562500,
-0.0110168457031250, -0.1928405761718750, -0.0330505371093750, -0.1350708007812500,
-0.0368957519531250, -0.1833801269531250, -0.0245361328125000, -0.0851135253906250,
-0.0333862304687500, 0.0185241699218750, -0.0382385253906250, -0.0673217773437500,
0.0267944335937500, 0.2223815917968750, 0.0025634765625000, 0.1786804199218750,
0.0400085449218750, 0.2517700195312500, 0.1159667968750000, 0.4779663085937500,
0.0748901367187500, 0.3754272460937500, 0.1268005371093750, 0.5231323242187500,
0.1592407226562500, 0.5637512207031250, 0.1007385253906250, 0.5187072753906250,
0.0804443359375000, 0.5458984375000000, 0.1196899414062500, 0.5578002929687500,
-0.0356750488281250, 0.4752502441406250, -0.0218811035156250, 0.4927062988281250,
-0.0296630859375000, 0.4655151367187500, -0.1366271972656250, 0.4005126953125000,
-0.1047973632812500, 0.4323120117187500, -0.0500183105468750, 0.3558044433593750,
-0.1061096191406250, 0.3677978515625000, -0.0330810546875000, 0.3298339843750000,
0.0859680175781250, 0.2677917480468750, 0.0160217285156250, 0.3080139160156250,
0.0896606445312500, 0.1765136718750000, 0.1525573730468750, 0.1936950683593750,
0.0406799316406250, 0.1615295410156250, -0.0169067382812500, 0.0634765625000000,
0.0597229003906250, 0.1101989746093750, -0.2232360839843750, 0.0382080078125000,
-0.2106018066406250, 0.0317993164062500, -0.1996765136718750, 0.0279846191406250,
-0.4184875488281250, -0.0307617187500000, -0.1030273437500000, 0.1120605468750000,
0.1310729980468750, 0.0146179199218750, 0.1035461425781250, 0.0373229980468750,
0.0939941406250000, 0.0086364746093750, 0.1488647460937500, -0.0256042480468750,
0.1511535644531250, -0.0042724609375000, 0.1187438964843750, -0.1103515625000000,
0.1132507324218750, -0.0816040039062500, 0.1348876953125000, -0.1268005371093750,
0.1313781738281250, -0.2378234863281250, 0.1167907714843750, -0.1826477050781250,
0.1878662109375000, -0.2218933105468750, 0.1793823242187500, -0.2705688476562500,
0.1853332519531250, -0.1955566406250000, 0.2313842773437500, -0.1417541503906250,
0.2180480957031250, -0.1957702636718750, 0.2300109863281250, -0.0458984375000000,
0.2204284667968750, -0.0397949218750000, 0.2609863281250000, -0.0486145019531250,
0.2786865234375000, 0.0198364257812500, 0.2444458007812500, 0.0072326660156250,
0.4303894042968750, -0.0078125000000000, 0.3760986328125000, -0.0068664550781250,
0.4510498046875000, 0.0105285644531250, 0.6351318359375000, 0.0066223144531250,
0.5361328125000000, -0.0062866210937500, 0.6375427246093750, 0.0742187500000000,
0.7049255371093750, 0.0633239746093750, 0.5873718261718750, 0.0714721679687500,
0.5516662597656250, 0.1343688964843750, 0.6246337890625000, 0.1157226562500000,
0.2774658203125000, 0.0798645019531250, 0.3533020019531250, 0.1117553710937500,
0.2402648925781250, 0.0683898925781250, -0.0520629882812500, 0.0004272460937500,
0.0974731445312500, 0.0395507812500000, -0.1437072753906250, -0.0249023437500000,
-0.1803283691406250, -0.0402221679687500, -0.1431884765625000, -0.0237731933593750,
-0.2233276367187500, -0.0370788574218750, -0.2166748046875000, -0.0404663085937500,
-0.1895446777343750, -0.0143432617187500, -0.1892395019531250, -0.0167236328125000,
-0.2099304199218750, -0.0143127441406250, -0.1995239257812500, 0.0020446777343750,
-0.1872253417968750, -0.0025634765625000, -0.2919616699218750, -0.0003967285156250,
-0.2531433105468750, 0.0015869140625000, -0.3067016601562500, 0.0004577636718750,
-0.4155883789062500, -0.0003662109375000, -0.3504028320312500, -0.0001525878906250,
-0.4616699218750000, 0.0000610351562500, -0.4792480468750000, -0.0000610351562500,
-0.4532775878906250, -0.0000610351562500, -0.4932556152343750, 0.0001525878906250,
-0.4952087402343750, 0.0001525878906250, -0.4126892089843750, 0.0000305175781250,
-0.4499816894531250, 0.0000305175781250, -0.3914489746093750, 0.0000305175781250,
-0.2987670898437500, 0.0000305175781250, -0.3596496582031250, 0.0000305175781250,
-0.2041015625000000, -0.0000305175781250, -0.2167968750000000, 0.0000305175781250,
-0.1918029785156250, 0.0000000000000000, -0.0908203125000000, -0.0000305175781250,
-0.1401672363281250, -0.0000610351562500, -0.0711364746093750, 0.0000610351562500,
-0.0613708496093750, 0.0000915527343750, -0.0688171386718750, 0.0000610351562500,
-0.0421447753906250, 0.0001220703125000, -0.0468750000000000, 0.0000610351562500,
-0.0478515625000000, 0.0000000000000000, -0.0443420410156250, -0.0000305175781250,
-0.0451965332031250, 0.0000305175781250, -0.0476684570312500, 0.0000000000000000,
-0.0444335937500000, 0.0000000000000000, -0.0399475097656250, -0.0000305175781250,
-0.0429687500000000, 0.0000000000000000, -0.0357360839843750, -0.0000305175781250,
-0.0278930664062500, -0.0000915527343750, -0.0333251953125000, -0.0000305175781250,
-0.0168151855468750, -0.0000610351562500, -0.0190429687500000, -0.0000915527343750,
-0.0154113769531250, -0.0000610351562500, -0.0037536621093750, -0.0000610351562500,
-0.0100708007812500, -0.0000610351562500, -0.0007019042968750, -0.0000610351562500,
-0.0007324218750000, -0.0000610351562500, -0.0021972656250000, -0.0000915527343750,
0.0015563964843750, -0.0001525878906250, -0.0010070800781250, -0.0001220703125000,
-0.0039367675781250, -0.0001220703125000, -0.0035400390625000, -0.0001525878906250,
-0.0057067871093750, -0.0001220703125000, -0.0093994140625000, -0.0001220703125000,
-0.0094909667968750, -0.0001220703125000, -0.0119934082031250, -0.0000915527343750,
-0.0120849609375000, -0.0001220703125000, -0.0134277343750000, -0.0001220703125000,
-0.0152587890625000, -0.0001220703125000, -0.0148925781250000, -0.0001220703125000,
-0.0201110839843750, -0.0000915527343750, -0.0189514160156250, -0.0000915527343750,
-0.0239562988281250, -0.0001220703125000, -0.0294189453125000, -0.0000915527343750,
-0.0256652832031250, -0.0000915527343750, -0.0409240722656250, -0.0001220703125000,
-0.0380249023437500, -0.0001220703125000, -0.0432434082031250, -0.0000915527343750,
-0.0556640625000000, -0.0001220703125000, -0.0487365722656250, -0.0001220703125000,
-0.0612792968750000, -0.0001220703125000, -0.0621032714843750, -0.0000610351562500,
-0.0604858398437500, -0.0000610351562500, -0.0659179687500000, -0.0000610351562500,
-0.0627136230468750, -0.0001220703125000, -0.0533142089843750, -0.0000610351562500,
-0.0582275390625000, -0.0000610351562500, -0.0474548339843750, -0.0000610351562500,
-0.0333251953125000, 0.0000000000000000, -0.0396423339843750, -0.0000610351562500,
-0.0124816894531250, -0.0000610351562500, -0.0153808593750000, 0.0000000000000000,
-0.0063781738281250, -0.0000305175781250, 0.0157470703125000, -0.0000305175781250,
0.0072021484375000, -0.0000305175781250, 0.0266113281250000, 0.0000000000000000,
0.0281372070312500, 0.0000000000000000, 0.0305480957031250, -0.0000305175781250,
0.0403137207031250},
{-0.4284362792968750, -0.0089111328125000, -0.4179382324218750, 0.0020446777343750,
-0.4476928710937500, -0.0005187988281250, -0.3241882324218750, -0.0004272460937500,
-0.3546142578125000, 0.0006408691406250, -0.3118591308593750, 0.0002441406250000,
-0.2063293457031250, -0.0003662109375000, -0.2622375488281250, -0.0003967285156250,
-0.1539916992187500, 0.0000305175781250, -0.1499938964843750, 0.0000000000000000,
-0.1481018066406250, -0.0000610351562500, -0.0926208496093750, 0.0000915527343750,
-0.1123046875000000, 0.0001220703125000, -0.0971984863281250, 0.0000000000000000,
-0.0897216796875000, -0.0000305175781250, -0.0926208496093750, 0.0000000000000000,
-0.0932006835937500, 0.0000610351562500, -0.0921020507812500, 0.0000305175781250,
-0.0765380859375000, 0.0000000000000000, -0.0885009765625000, 0.0000000000000000,
-0.0660705566406250, 0.0000305175781250, -0.0409545898437500, 0.0000000000000000,
-0.0622558593750000, -0.0000610351562500, 0.0013732910156250, 0.0000305175781250,
-0.0100708007812500, 0.0000610351562500, 0.0056762695312500, -0.0000305175781250,
0.0528564453125000, 0.0000000000000000, 0.0253601074218750, 0.0000305175781250,
0.0670776367187500, 0.0000000000000000, 0.0708312988281250, -0.0000915527343750,
0.0647583007812500, -0.0000305175781250, 0.0810852050781250, 0.0000305175781250,
0.0761718750000000, -0.0000305175781250, 0.0657043457031250, 0.0000000000000000,
0.0739135742187500, 0.0000305175781250, 0.0604248046875000, 0.0000000000000000,
0.0441589355468750, -0.0000610351562500, 0.0567932128906250, -0.0000305175781250,
0.0226745605468750, 0.0000305175781250, 0.0304870605468750, 0.0000000000000000,
0.0206298828125000, -0.0000305175781250, -0.0049133300781250, 0.0000305175781250,
0.0127258300781250, 0.0000305175781250, -0.0188598632812500, 0.0000000000000000,
-0.0131225585937500, -0.0000305175781250, -0.0191040039062500, 0.0000000000000000,
-0.0399475097656250, 0.0000000000000000, -0.0247192382812500, 0.0000000000000000,
-0.0505981445312500, 0.0000000000000000, -0.0459289550781250, 0.0000305175781250,
-0.0485839843750000, -0.0000305175781250, -0.0654907226562500, -0.0000305175781250,
-0.0545349121093750, 0.0000000000000000, -0.0672607421875000, -0.0000610351562500,
-0.0651245117187500, -0.0000610351562500, -0.0644836425781250, -0.0000610351562500,
-0.0702209472656250, 0.0000000000000000, -0.0628662109375000, -0.0000915527343750,
-0.0672607421875000, 0.0000000000000000, -0.0654296875000000, 0.0000305175781250,
-0.0637817382812500, 0.0000000000000000, -0.0653381347656250, 0.0000000000000000,
-0.0631713867187500, 0.0000000000000000, -0.0671997070312500, 0.0000305175781250,
-0.0643005371093750, 0.0000000000000000, -0.0691223144531250, 0.0000000000000000,
-0.0747375488281250, 0.0000305175781250, -0.0695495605468750, 0.0000305175781250,
-0.0869445800781250, 0.0000305175781250, -0.0840454101562500, 0.0000610351562500,
-0.0907897949218750, 0.0000610351562500, -0.1058654785156250, 0.0000305175781250,
-0.0990905761718750, 0.0000000000000000, -0.1153869628906250, 0.0000000000000000,
-0.1176147460937500, 0.0000305175781250, -0.1156311035156250, 0.0000305175781250,
-0.1223754882812500, 0.0000305175781250, -0.1203308105468750, 0.0000000000000000,
-0.1077575683593750, 0.0000305175781250, -0.1142883300781250, 0.0000610351562500,
-0.0983276367187500, 0.0000305175781250, -0.0786132812500000, 0.0000000000000000,
-0.0885620117187500, -0.0000305175781250, -0.0468139648437500, 0.0000305175781250,
-0.0490112304687500, 0.0000305175781250, -0.0349731445312500, -0.0000305175781250,
-0.0036010742187500, -0.0000915527343750, -0.0161132812500000, -0.0000305175781250,
0.0173645019531250, -0.0001220703125000, 0.0168457031250000, -0.0003051757812500,
0.0245666503906250, 0.0000915527343750, 0.0445556640625000, 0.0004882812500000,
0.0346374511718750, 0.0000305175781250, 0.0657653808593750, -0.0002746582031250,
0.0618286132812500, 0.0015258789062500, 0.0734252929687500, -0.0030212402343750,
0.0992126464843750, -0.0057067871093750, 0.0867919921875000, -0.0018615722656250,
0.1148986816406250, -0.0175170898437500, 0.1179809570312500, -0.0151367187500000,
0.1143493652343750, -0.0147705078125000, 0.1264953613281250, -0.0277709960937500,
0.1250915527343750, -0.0242309570312500, 0.1107482910156250, -0.0043029785156250,
0.1161804199218750, -0.0205383300781250, 0.1094970703125000, 0.0054626464843750,
0.0925903320312500, 0.0407409667968750, 0.0991516113281250, 0.0143432617187500,
0.0965881347656250, 0.0664367675781250, 0.0877685546875000, 0.0748596191406250,
0.1016845703125000, 0.0569152832031250, 0.1137084960937500, 0.0722045898437500,
0.1024475097656250, 0.0784301757812500, 0.1315917968750000, 0.0248413085937500,
0.1315612792968750, 0.0374145507812500, 0.1323547363281250, 0.0269775390625000,
0.1454772949218750, -0.0170593261718750, 0.1408386230468750, -0.0008850097656250,
0.1562194824218750, -0.0112609863281250, 0.1452331542968750, -0.0161743164062500,
0.1701354980468750, -0.0207824707031250, 0.1966857910156250, -0.0205993652343750,
0.1739501953125000, -0.0149230957031250, 0.2472534179687500, -0.0563049316406250,
0.2499084472656250, -0.0459594726562500, 0.2356262207031250, -0.0545349121093750,
0.2765502929687500, -0.0935668945312500, 0.2743835449218750, -0.0793457031250000,
0.1729736328125000, -0.0654907226562500, 0.2206726074218750, -0.0832214355468750,
0.1558227539062500, -0.0644531250000000, -0.0025634765625000, -0.0231323242187500,
0.0102844238281250, -0.0303649902343750, -0.0726623535156250, -0.0321044921875000,
-0.0746154785156250, -0.0218811035156250, -0.0479431152343750, -0.0294494628906250,
-0.0764160156250000, -0.0465393066406250, -0.0862121582031250, -0.0365905761718750,
-0.0416564941406250, -0.0171508789062500, -0.0390625000000000, -0.0461730957031250,
-0.0533447265625000, 0.0100708007812500, -0.0390930175781250, 0.0686950683593750,
-0.0319213867187500, 0.0231018066406250, -0.0705566406250000, 0.1616821289062500,
-0.0685119628906250, 0.1582031250000000, -0.0616455078125000, 0.1694030761718750,
-0.0813293457031250, 0.2538452148437500, -0.0816345214843750, 0.2272949218750000,
-0.0541076660156250, 0.2390136718750000, -0.0596313476562500, 0.2600402832031250,
-0.0571289062500000, 0.2301025390625000, -0.0383605957031250, 0.2093811035156250,
-0.0430603027343750, 0.2283935546875000, -0.0374755859375000, 0.1506652832031250,
-0.0439453125000000, 0.1637878417968750, -0.0226745605468750, 0.1405944824218750,
-0.0086059570312500, 0.0762939453125000, -0.0272216796875000, 0.1072998046875000,
0.0475463867187500, 0.0698547363281250, 0.0377197265625000, 0.0520935058593750,
0.0480957031250000, 0.0787963867187500, 0.1063537597656250, 0.0848388671875000,
0.0863037109375000, 0.0695190429687500, 0.0729370117187500, 0.1255493164062500,
0.0993652343750000, 0.1257629394531250, 0.0640258789062500, 0.1188049316406250,
0.0191345214843750, 0.1476440429687500, 0.0502014160156250, 0.1437683105468750,
-0.0123291015625000, 0.1031799316406250, -0.0181274414062500, 0.1193542480468750,
-0.0088806152343750, 0.0956115722656250, -0.0330810546875000, 0.0476989746093750,
-0.0309143066406250, 0.0701293945312500, -0.0140686035156250, 0.0359497070312500,
-0.0200195312500000, 0.0240783691406250, -0.0154113769531250, 0.0365295410156250,
-0.0004272460937500, 0.0345458984375000, -0.0067749023437500, 0.0284118652343750,
-0.0007934570312500, 0.0454101562500000, 0.0016174316406250, 0.0496520996093750,
-0.0002441406250000, 0.0361022949218750, 0.0001220703125000, 0.0372314453125000,
0.0005798339843750, 0.0419616699218750, -0.0000610351562500, -0.0121154785156250,
-0.0004272460937500, -0.0014343261718750, -0.0001220703125000, -0.0333862304687500,
0.0001220703125000, -0.0892333984375000, -0.0001525878906250, -0.0657348632812500,
0.0000915527343750, -0.1308898925781250, 0.0001831054687500, -0.1382446289062500,
0.0001220703125000, -0.1371154785156250, 0.0000305175781250, -0.1678466796875000,
0.0000610351562500, -0.1620178222656250, 0.0000610351562500, -0.1500549316406250,
0.0000305175781250, -0.1612243652343750, 0.0000305175781250, -0.1440429687500000,
0.0001525878906250, -0.1209411621093750, 0.0001220703125000, -0.1335144042968750,
0.0000610351562500, -0.0931091308593750, 0.0000610351562500, -0.0937805175781250,
0.0001220703125000, -0.0881347656250000, 0.0000610351562500, -0.0631103515625000,
0.0000305175781250, -0.0721740722656250, 0.0000915527343750, -0.0600891113281250,
0.0000610351562500, -0.0560607910156250, 0.0000610351562500, -0.0603332519531250,
0.0001220703125000, -0.0596923828125000, 0.0000915527343750, -0.0598449707031250,
0.0000305175781250, -0.0684204101562500, 0.0000610351562500, -0.0700073242187500,
0.0000610351562500, -0.0750122070312500, 0.0000915527343750, -0.0831909179687500,
0.0000610351562500, -0.0821228027343750, 0.0001220703125000, -0.0849609375000000,
0.0001525878906250, -0.0895996093750000, 0.0001220703125000, -0.0876770019531250,
0.0001525878906250, -0.0865173339843750, 0.0001220703125000, -0.0901184082031250,
0.0000610351562500, -0.0795288085937500, 0.0000610351562500, -0.0855712890625000,
0.0000610351562500, -0.0792541503906250, 0.0000610351562500, -0.0677490234375000,
0.0000610351562500, -0.0767517089843750, 0.0000610351562500, -0.0553283691406250,
0.0000610351562500, -0.0595703125000000, 0.0000610351562500, -0.0532836914062500,
0.0000610351562500, -0.0366210937500000, 0.0000610351562500, -0.0456237792968750,
0.0000305175781250, -0.0241394042968750, 0.0000305175781250, -0.0275573730468750,
0.0000305175781250, -0.0194396972656250, 0.0000305175781250, -0.0030212402343750,
0.0000000000000000, -0.0139160156250000, 0.0000305175781250, 0.0130920410156250,
0.0000305175781250, 0.0105590820312500, 0.0000000000000000, 0.0168151855468750,
0.0000000000000000, 0.0362854003906250, 0.0000305175781250, 0.0267333984375000,
0.0000000000000000, 0.0415344238281250, -0.0000305175781250, 0.0457153320312500,
-0.0000305175781250, 0.0378112792968750, 0.0000305175781250, 0.0422363281250000,
0.0000000000000000, 0.0470886230468750, 0.0000305175781250, 0.0170593261718750,
0.0000305175781250, 0.0307006835937500, -0.0000305175781250, 0.0098266601562500,
-0.0000610351562500, -0.0206909179687500, -0.0000305175781250, 0.0050354003906250,
-0.0000915527343750, -0.0606384277343750, -0.0001220703125000, -0.0492248535156250,
-0.0000610351562500, -0.0693664550781250, -0.0000610351562500, -0.1198730468750000,
-0.0001220703125000, -0.0923156738281250, -0.0000305175781250, -0.1556396484375000,
0.0000305175781250, -0.1515808105468750, -0.0000305175781250, -0.1555786132812500,
-0.0000915527343750, -0.1962890625000000, -0.0000305175781250, -0.1804199218750000,
-0.0001831054687500, -0.1807556152343750, -0.0003051757812500, -0.1957397460937500,
-0.0000610351562500, -0.1750183105468750, 0.0003356933593750, -0.1539611816406250,
-0.0000915527343750, -0.1712036132812500, -0.0011291503906250, -0.1334838867187500,
0.0012207031250000, -0.1273803710937500, -0.0045166015625000, -0.1427612304687500,
-0.0086975097656250, -0.1282043457031250, -0.0037536621093750, -0.1232299804687500,
-0.0218505859375000, -0.1958618164062500, -0.0213623046875000, -0.1654663085937500,
-0.0180664062500000, -0.2230529785156250, -0.0310058593750000, -0.3142089843750000,
-0.0296936035156250, -0.2606811523437500, 0.0056152343750000, -0.3840942382812500,
-0.0145874023437500, -0.3972778320312500, 0.0166015625000000, -0.3778076171875000,
0.0679626464843750, -0.4322509765625000, 0.0368041992187500, -0.4298095703125000,
0.0930480957031250},
{0.0000305175781250, -0.1015930175781250, 0.0000305175781250, -0.1217346191406250,
0.0000305175781250, -0.1207580566406250, 0.0000305175781250, -0.1257629394531250,
0.0000610351562500, -0.1407470703125000, 0.0000000000000000, -0.1361999511718750,
0.0000305175781250, -0.1431579589843750, 0.0000000000000000, -0.1467590332031250,
0.0000000000000000, -0.1415405273437500, 0.0000000000000000, -0.1405944824218750,
0.0000000000000000, -0.1427612304687500, 0.0000915527343750, -0.1254577636718750,
0.0000610351562500, -0.1278991699218750, 0.0000915527343750, -0.1177978515625000,
0.0000915527343750, -0.1007995605468750, 0.0000915527343750, -0.1071166992187500,
0.0000915527343750, -0.0836486816406250, 0.0000915527343750, -0.0821228027343750,
0.0000915527343750, -0.0738525390625000, 0.0000610351562500, -0.0574340820312500,
0.0000305175781250, -0.0635070800781250, 0.0000610351562500, -0.0454406738281250,
0.0000915527343750, -0.0404663085937500, 0.0000610351562500, -0.0373229980468750,
0.0000915527343750, -0.0287170410156250, 0.0001220703125000, -0.0286560058593750,
0.0000305175781250, -0.0205078125000000, 0.0000610351562500, -0.0201416015625000,
0.0000610351562500, -0.0164794921875000, 0.0000305175781250, -0.0104064941406250,
0.0000610351562500, -0.0131530761718750, 0.0000610351562500, -0.0059204101562500,
0.0000305175781250, -0.0032958984375000, 0.0000305175781250, -0.0036010742187500,
0.0000915527343750, -0.0012512207031250, 0.0000915527343750, -0.0007019042968750,
0.0000000000000000, -0.0035095214843750, 0.0000000000000000, -0.0010986328125000,
0.0000000000000000, 0.0003356933593750, 0.0000610351562500, -0.0013122558593750,
0.0000000000000000, 0.0012817382812500, 0.0000610351562500, 0.0061645507812500,
0.0000915527343750, 0.0044250488281250, 0.0000305175781250, 0.0101318359375000,
0.0000610351562500, 0.0176086425781250, 0.0000610351562500, 0.0140380859375000,
-0.0000305175781250, 0.0229187011718750, 0.0000000000000000, 0.0262451171875000,
0.0000000000000000, 0.0223388671875000, -0.0000305175781250, 0.0237121582031250,
-0.0000305175781250, 0.0271301269531250, 0.0000305175781250, 0.0149230957031250,
0.0000305175781250, 0.0193481445312500, 0.0000305175781250, 0.0161743164062500,
0.0000305175781250, 0.0068969726562500, 0.0000610351562500, 0.0123596191406250,
-0.0001525878906250, -0.0040283203125000, -0.0001525878906250, 0.0036621093750000,
0.0000610351562500, -0.0160522460937500, 0.0000610351562500, -0.0349426269531250,
-0.0001525878906250, -0.0156555175781250, -0.0002441406250000, -0.0872802734375000,
0.0010986328125000, -0.0701293945312500, -0.0025939941406250, -0.1009216308593750,
-0.0043640136718750, -0.1661376953125000, -0.0015563964843750, -0.1295471191406250,
-0.0165100097656250, -0.2010498046875000, -0.0140075683593750, -0.2058410644531250,
-0.0149536132812500, -0.1995849609375000, -0.0289306640625000, -0.2328796386718750,
-0.0245056152343750, -0.2264404296875000, -0.0042724609375000, -0.2083129882812500,
-0.0221252441406250, -0.2154541015625000, 0.0086669921875000, -0.2066650390625000,
0.0492248535156250, -0.1817321777343750, 0.0205078125000000, -0.1904296875000000,
0.0787353515625000, -0.2085266113281250, 0.0906066894531250, -0.1816101074218750,
0.0643310546875000, -0.2269897460937500, 0.0782470703125000, -0.2780761718750000,
0.0888977050781250, -0.2413635253906250, 0.0001831054687500, -0.3574523925781250,
0.0184326171875000, -0.3595275878906250, 0.0000000000000000, -0.3544311523437500,
-0.0780029296875000, -0.4187622070312500, -0.0495605468750000, -0.4061889648437500,
-0.0330200195312500, -0.3527832031250000, -0.0698242187500000, -0.3901977539062500,
-0.0226440429687500, -0.3392944335937500, 0.0447692871093750, -0.2561950683593750,
0.0023193359375000, -0.3047180175781250, 0.0507812500000000, -0.2121276855468750,
0.0902099609375000, -0.2005615234375000, 0.0186157226562500, -0.2124023437500000,
-0.0171203613281250, -0.1844177246093750, 0.0335998535156250, -0.1886901855468750,
-0.1434631347656250, -0.1760864257812500, -0.1351318359375000, -0.1986694335937500,
-0.1335449218750000, -0.1411132812500000, -0.2425537109375000, -0.1025390625000000,
-0.2151794433593750, -0.1486816406250000, -0.1432800292968750, 0.0677795410156250,
-0.2011413574218750, 0.0163269042968750, -0.1225280761718750, 0.1138305664062500,
0.0023193359375000, 0.3174133300781250, -0.0702514648437500, 0.2093200683593750,
0.0594787597656250, 0.4132385253906250, 0.0825805664062500, 0.4404296875000000,
0.0595092773437500, 0.4037170410156250, 0.0953979492187500, 0.4764099121093750,
0.0968017578125000, 0.4725646972656250, 0.0812683105468750, 0.3892822265625000,
0.0748291015625000, 0.4141845703125000, 0.0931396484375000, 0.3951416015625000,
0.1153564453125000, 0.2831420898437500, 0.1792297363281250, 0.4488220214843750,
0.2096862792968750, 0.3499450683593750, 0.1744995117187500, 0.4035644531250000,
0.2399902343750000, 0.3583068847656250, 0.2838134765625000, 0.2793273925781250,
0.2338562011718750, 0.3116149902343750, 0.4234924316406250, 0.2590332031250000,
0.3952636718750000, 0.2630615234375000, 0.4280090332031250, 0.2352905273437500,
0.5784606933593750, 0.1968383789062500, 0.5160217285156250, 0.2259826660156250,
0.5041198730468750, 0.1121215820312500, 0.5878906250000000, 0.1304321289062500,
0.4498901367187500, 0.1025390625000000, 0.3240356445312500, 0.0140075683593750,
0.4326477050781250, 0.0520935058593750, 0.0811157226562500, -0.0076599121093750,
0.1235961914062500, -0.0093994140625000, 0.0539245605468750, -0.0265502929687500,
-0.1949768066406250, -0.0601196289062500, -0.0804443359375000, -0.0372009277343750,
-0.2401123046875000, -0.1206970214843750, -0.2733764648437500, -0.1113281250000000,
-0.2471313476562500, -0.1193237304687500, -0.2943420410156250, -0.1838684082031250,
-0.2917175292968750, -0.1635437011718750, -0.2751770019531250, -0.1295471191406250,
-0.2772827148437500, -0.1639404296875000, -0.2879333496093750, -0.1140136718750000,
-0.2801818847656250, -0.0408325195312500, -0.2750244140625000, -0.0848693847656250,
-0.3259887695312500, -0.0106201171875000, -0.3076477050781250, 0.0067443847656250,
-0.3344726562500000, -0.0104370117187500, -0.3896179199218750, 0.0016479492187500,
-0.3595886230468750, 0.0059509277343750, -0.4084777832031250, 0.0048828125000000,
-0.4218750000000000, -0.0083007812500000, -0.3983459472656250, 0.0167846679687500,
-0.4069824218750000, 0.0415344238281250, -0.4166259765625000, 0.0215454101562500,
-0.3434448242187500, 0.0704040527343750, -0.3672790527343750, 0.0805053710937500,
-0.3300781250000000, 0.0603332519531250, -0.2585449218750000, 0.0705261230468750,
-0.2998657226562500, 0.0794982910156250, -0.2064208984375000, 0.0194091796875000,
-0.2117309570312500, 0.0280151367187500, -0.1974182128906250, 0.0169067382812500,
-0.1401367187500000, -0.0288696289062500, -0.1680297851562500, -0.0127868652343750,
-0.1141967773437500, -0.0194091796875000, -0.1177673339843750, -0.0303955078125000,
-0.1044311523437500, -0.0192871093750000, -0.0700988769531250, -0.0079345703125000,
-0.0892028808593750, -0.0149230957031250, -0.0301208496093750, -0.0026550292968750,
-0.0413818359375000, -0.0000305175781250, -0.0174865722656250, -0.0021972656250000,
0.0337524414062500, 0.0006713867187500, 0.0045166015625000, 0.0005798339843750,
0.0610961914062500, -0.0001525878906250, 0.0683288574218750, -0.0003051757812500,
0.0568847656250000, -0.0000915527343750, 0.0789184570312500, 0.0000305175781250,
0.0794372558593750, -0.0000915527343750, 0.0436706542968750, 0.0000000000000000,
0.0604858398437500, 0.0001220703125000, 0.0411987304687500, 0.0000610351562500,
0.0021362304687500, 0.0000000000000000, 0.0265502929687500, 0.0000000000000000,
-0.0145568847656250, 0.0000000000000000, -0.0180664062500000, 0.0000305175781250,
-0.0129699707031250, 0.0000000000000000, -0.0303649902343750, -0.0000305175781250,
-0.0279846191406250, 0.0000000000000000, -0.0206604003906250, 0.0000000000000000,
-0.0268249511718750, -0.0000610351562500, -0.0217590332031250, 0.0000000000000000,
-0.0130310058593750, 0.0000610351562500, -0.0206298828125000, 0.0000305175781250,
-0.0065917968750000, 0.0000000000000000, -0.0091857910156250, 0.0000305175781250,
-0.0075683593750000, 0.0000305175781250, 0.0020446777343750, -0.0000610351562500,
-0.0034790039062500, -0.0000305175781250, 0.0031127929687500, 0.0000610351562500,
0.0038146972656250, 0.0000915527343750, 0.0017089843750000, 0.0000305175781250,
0.0041198730468750, 0.0000610351562500, 0.0046081542968750, 0.0000610351562500,
0.0011596679687500, 0.0000000000000000, 0.0033874511718750, 0.0000305175781250,
-0.0002746582031250, 0.0000610351562500, -0.0053100585937500, 0.0000305175781250,
-0.0017089843750000, 0.0000000000000000, -0.0111694335937500, 0.0000610351562500,
-0.0098266601562500, 0.0000610351562500, -0.0134582519531250, 0.0000305175781250,
-0.0202636718750000, 0.0000000000000000, -0.0159606933593750, 0.0000610351562500,
-0.0297241210937500, 0.0000305175781250, -0.0273437500000000, 0.0000305175781250,
-0.0341186523437500, 0.0000305175781250, -0.0466308593750000, 0.0000610351562500,
-0.0415344238281250, 0.0000305175781250, -0.0627746582031250, 0.0000305175781250,
-0.0595703125000000, 0.0000915527343750, -0.0690307617187500, 0.0000305175781250,
-0.0867309570312500, -0.0000305175781250, -0.0783386230468750, 0.0000305175781250,
-0.1073303222656250, 0.0000000000000000, -0.1034545898437500, 0.0000000000000000,
-0.1127929687500000, 0.0000000000000000, -0.1354064941406250, 0.0000000000000000,
-0.1256103515625000, 0.0000305175781250, -0.1538391113281250, 0.0001220703125000,
-0.1528930664062500, 0.0000610351562500, -0.1574096679687500, 0.0000915527343750,
-0.1760559082031250, 0.0000610351562500, -0.1687316894531250, 0.0000305175781250,
-0.1761474609375000, 0.0000610351562500, -0.1806030273437500, 0.0001525878906250,
-0.1725158691406250, 0.0000305175781250, -0.1693420410156250, 0.0000000000000000,
-0.1725158691406250, 0.0000915527343750, -0.1509094238281250, -0.0000305175781250,
-0.1526794433593750, -0.0000915527343750, -0.1489257812500000, 0.0000305175781250,
-0.1323547363281250, 0.0000915527343750, -0.1372375488281250, -0.0000610351562500,
-0.1396484375000000, 0.0001831054687500, -0.1308593750000000, 0.0008239746093750,
-0.1436157226562500, -0.0012512207031250, -0.1576232910156250, -0.0017089843750000,
-0.1464843750000000, -0.0001525878906250, -0.1740722656250000, -0.0098571777343750,
-0.1755371093750000, -0.0067749023437500, -0.1719665527343750, -0.0100402832031250,
-0.1847534179687500, -0.0207824707031250, -0.1827087402343750, -0.0154113769531250,
-0.1675109863281250, -0.0118408203125000, -0.1748962402343750, -0.0223083496093750,
-0.1590270996093750, -0.0033874511718750, -0.1385803222656250, 0.0140380859375000,
-0.1498413085937500, -0.0029602050781250, -0.1052246093750000, 0.0439453125000000,
-0.1113586425781250, 0.0421752929687500, -0.0913085937500000, 0.0384521484375000,
-0.0538940429687500, 0.0658264160156250, -0.0727844238281250, 0.0606384277343750,
-0.0182800292968750, 0.0354309082031250, -0.0218200683593750, 0.0505676269531250,
-0.0079040527343750, 0.0326843261718750, 0.0303039550781250, -0.0019226074218750,
0.0138244628906250, 0.0176086425781250, 0.0532531738281250, -0.0069580078125000,
0.0543518066406250, -0.0144042968750000, 0.0559997558593750, -0.0090942382812500,
0.0778808593750000, -0.0103759765625000, 0.0706481933593750, -0.0118713378906250,
0.0719909667968750, -0.0252380371093750, 0.0772094726562500, -0.0146179199218750,
0.0725708007812500},
{-0.0320129394531250, 0.0000915527343750, -0.0352783203125000, 0.0001220703125000,
-0.0534973144531250, 0.0001220703125000, -0.0441894531250000, 0.0001220703125000,
-0.0591735839843750, 0.0000915527343750, -0.0591125488281250, 0.0000610351562500,
-0.0593566894531250, 0.0000915527343750, -0.0671081542968750, 0.0001220703125000,
-0.0631408691406250, 0.0000915527343750, -0.0667114257812500, 0.0000915527343750,
-0.0669555664062500, 0.0001831054687500, -0.0649414062500000, 0.0001831054687500,
-0.0652770996093750, 0.0001220703125000, -0.0655517578125000, 0.0001831054687500,
-0.0643920898437500, 0.0001525878906250, -0.0640869140625000, 0.0001220703125000,
-0.0642700195312500, 0.0000610351562500, -0.0639038085937500, 0.0000915527343750,
-0.0636901855468750, 0.0000610351562500, -0.0649108886718750, 0.0001220703125000,
-0.0645751953125000, 0.0001220703125000, -0.0650024414062500, 0.0001220703125000,
-0.0654907226562500, 0.0001220703125000, -0.0645446777343750, 0.0000915527343750,
-0.0672302246093750, 0.0000915527343750, -0.0665588378906250, 0.0000610351562500,
-0.0673522949218750, 0.0001220703125000, -0.0693969726562500, 0.0001525878906250,
-0.0678710937500000, 0.0000915527343750, -0.0706481933593750, 0.0001220703125000,
-0.0706176757812500, 0.0001525878906250, -0.0707397460937500, 0.0001220703125000,
-0.0715332031250000, 0.0001220703125000, -0.0710449218750000, 0.0000915527343750,
-0.0759582519531250, 0.0001220703125000, -0.0729064941406250, 0.0001220703125000,
-0.0788879394531250, 0.0000305175781250, -0.0852661132812500, 0.0000305175781250,
-0.0802307128906250, 0.0000305175781250, -0.1025085449218750, -0.0001831054687500,
-0.0974731445312500, -0.0001831054687500, -0.1092834472656250, -0.0000915527343750,
-0.1314086914062500, -0.0001525878906250, -0.1213989257812500, -0.0002136230468750,
-0.1509094238281250, 0.0000915527343750, -0.1517944335937500, 0.0004577636718750,
-0.1535644531250000, -0.0009155273437500, -0.1701049804687500, -0.0009460449218750,
-0.1651000976562500, 0.0000000000000000, -0.1661071777343750, -0.0071716308593750,
-0.1690673828125000, -0.0041809082031250, -0.1685485839843750, -0.0079345703125000,
-0.1649169921875000, -0.0167236328125000, -0.1650695800781250, -0.0115051269531250,
-0.1757507324218750, -0.0129089355468750, -0.1685485839843750, -0.0205688476562500,
-0.1781005859375000, -0.0057373046875000, -0.1940612792968750, 0.0045471191406250,
-0.1836853027343750, -0.0080871582031250, -0.2025146484375000, 0.0328979492187500,
-0.2052612304687500, 0.0288085937500000, -0.2009582519531250, 0.0302429199218750,
-0.2068786621093750, 0.0583496093750000, -0.2063903808593750, 0.0496826171875000,
-0.1960754394531250, 0.0363464355468750, -0.2001953125000000, 0.0512390136718750,
-0.1898803710937500, 0.0332641601562500, -0.1784667968750000, 0.0058898925781250,
-0.1860961914062500, 0.0241088867187500, -0.1506042480468750, -0.0035705566406250,
-0.1592102050781250, -0.0093383789062500, -0.1399536132812500, -0.0034484863281250,
-0.1065979003906250, -0.0085449218750000, -0.1241149902343750, -0.0100708007812500,
-0.0672302246093750, -0.0148925781250000, -0.0740661621093750, -0.0070495605468750,
-0.0558471679687500, -0.0213623046875000, -0.0125427246093750, -0.0381164550781250,
-0.0342407226562500, -0.0242919921875000, 0.0149536132812500, -0.0494079589843750,
0.0157165527343750, -0.0558776855468750, 0.0209960937500000, -0.0440673828125000,
0.0500183105468750, -0.0452880859375000, 0.0389709472656250, -0.0523681640625000,
0.0505065917968750, -0.0357360839843750, 0.0546875000000000, -0.0294799804687500,
0.0517272949218750, -0.0440673828125000, 0.0508117675781250, -0.0484619140625000,
0.0515136718750000, -0.0360717773437500, 0.0620422363281250, -0.0592346191406250,
0.0515441894531250, -0.0724182128906250, 0.0715637207031250, -0.0374450683593750,
0.0924377441406250, -0.0295715332031250, 0.0749206542968750, -0.0535888671875000,
0.1334838867187500, 0.0655212402343750, 0.1236267089843750, 0.0408020019531250,
0.1412353515625000, 0.0756530761718750, 0.1935424804687500, 0.1927795410156250,
0.1917724609375000, 0.1756286621093750, 0.2616577148437500, 0.2245178222656250,
0.2360534667968750, 0.2233581542968750, 0.2457580566406250, 0.2126770019531250,
0.3069763183593750, 0.2373657226562500, 0.2762756347656250, 0.2344360351562500,
0.2791748046875000, 0.2033691406250000, 0.3201904296875000, 0.2171936035156250,
0.2460632324218750, 0.1901550292968750, 0.1917419433593750, 0.1505737304687500,
0.2543640136718750, 0.1741027832031250, 0.0468750000000000, 0.1136779785156250,
0.0718688964843750, 0.1099243164062500, 0.0448303222656250, 0.1134643554687500,
-0.1022033691406250, 0.0853271484375000, -0.0462036132812500, 0.0893859863281250,
-0.0721130371093750, 0.0983276367187500, -0.1073303222656250, 0.0978393554687500,
-0.0711059570312500, 0.0880126953125000, -0.0365295410156250, 0.0914001464843750,
-0.0613708496093750, 0.0968322753906250, -0.0325012207031250, 0.0467834472656250,
-0.0165405273437500, 0.0587158203125000, -0.0363769531250000, 0.0426330566406250,
-0.0466003417968750, -0.0035400390625000, -0.0340576171875000, 0.0160217285156250,
-0.0544128417968750, -0.0001525878906250, -0.0636901855468750, -0.0111389160156250,
-0.0488586425781250, -0.0030517578125000, -0.0437927246093750, 0.0054321289062500,
-0.0535583496093750, -0.0005187988281250, -0.0283813476562500, -0.0191345214843750,
-0.0267028808593750, 0.0003356933593750, -0.0285949707031250, -0.0358276367187500,
-0.0207519531250000, -0.0768127441406250, -0.0218200683593750, -0.0463562011718750,
-0.0095825195312500, -0.1367492675781250, -0.0201416015625000, -0.1331787109375000,
0.0003662109375000, -0.1414184570312500, 0.0244445800781250, -0.1973571777343750,
0.0043029785156250, -0.1772460937500000, 0.0521240234375000, -0.1869812011718750,
0.0543518066406250, -0.2007141113281250, 0.0444335937500000, -0.1811523437500000,
0.0659179687500000, -0.1658020019531250, 0.0656738281250000, -0.1787414550781250,
0.0298461914062500, -0.1466979980468750, 0.0450134277343750, -0.1437377929687500,
0.0287475585937500, -0.1463623046875000, -0.0093078613281250, -0.1330871582031250,
0.0116577148437500, -0.1353149414062500, -0.0144042968750000, -0.1416015625000000,
-0.0212097167968750, -0.1399841308593750, -0.0123291015625000, -0.1400756835937500,
-0.0168762207031250, -0.1462097167968750, -0.0198364257812500, -0.1452331542968750,
-0.0067443847656250, -0.1326599121093750, -0.0083007812500000, -0.1387329101562500,
-0.0074768066406250, -0.1253356933593750, 0.0005493164062500, -0.1066894531250000,
-0.0021972656250000, -0.1163330078125000, -0.0005798339843750, -0.0869445800781250,
0.0005493164062500, -0.0859985351562500, -0.0000610351562500, -0.0830078125000000,
-0.0003051757812500, -0.0655517578125000, -0.0000915527343750, -0.0702209472656250,
-0.0000305175781250, -0.0665893554687500, -0.0001831054687500, -0.0632324218750000,
-0.0000915527343750, -0.0663146972656250, 0.0001525878906250, -0.0686035156250000,
0.0000610351562500, -0.0673522949218750, 0.0001831054687500, -0.0730285644531250,
0.0001831054687500, -0.0729980468750000, 0.0001831054687500, -0.0755310058593750,
0.0002136230468750, -0.0803527832031250, 0.0002136230468750, -0.0788879394531250,
0.0001831054687500, -0.0840454101562500, 0.0002136230468750, -0.0849609375000000,
0.0001831054687500, -0.0841369628906250, 0.0001220703125000, -0.0857849121093750,
0.0001831054687500, -0.0859069824218750, 0.0001525878906250, -0.0834045410156250,
0.0000915527343750, -0.0841674804687500, 0.0000915527343750, -0.0816955566406250,
0.0000915527343750, -0.0783691406250000, 0.0000915527343750, -0.0797424316406250,
0.0000305175781250, -0.0736083984375000, 0.0000610351562500, -0.0728149414062500,
0.0000610351562500, -0.0715637207031250, 0.0000610351562500, -0.0678405761718750,
0.0000610351562500, -0.0682067871093750, 0.0000305175781250, -0.0666198730468750,
0.0000305175781250, -0.0659790039062500, 0.0000610351562500, -0.0654602050781250,
0.0000610351562500, -0.0646667480468750, 0.0000305175781250, -0.0646972656250000,
0.0000610351562500, -0.0635070800781250, 0.0000610351562500, -0.0644836425781250,
0.0000610351562500, -0.0628051757812500, 0.0000915527343750, -0.0612487792968750,
0.0000915527343750, -0.0607604980468750, 0.0000000000000000, -0.0485229492187500,
0.0000305175781250, -0.0541381835937500, 0.0000305175781250, -0.0420532226562500,
0.0000305175781250, -0.0266113281250000, -0.0000305175781250, -0.0377502441406250,
0.0000000000000000, -0.0057067871093750, 0.0000000000000000, -0.0106506347656250,
0.0000000000000000, -0.0023803710937500, 0.0000610351562500, 0.0211181640625000,
0.0000305175781250, 0.0097045898437500, 0.0000000000000000, 0.0368652343750000,
0.0000305175781250, 0.0305786132812500, -0.0000305175781250, 0.0463562011718750,
-0.0000915527343750, 0.0687866210937500, -0.0000915527343750, 0.0505065917968750,
0.0001220703125000, 0.1111450195312500, 0.0002441406250000, 0.1013488769531250,
-0.0005187988281250, 0.1140441894531250, -0.0000915527343750, 0.1635437011718750,
0.0001525878906250, 0.1424560546875000, -0.0066833496093750, 0.1504211425781250,
-0.0033264160156250, 0.1726074218750000, -0.0087890625000000, 0.1369934082031250,
-0.0190429687500000, 0.1095886230468750, -0.0127258300781250, 0.1372070312500000,
-0.0157470703125000, 0.0527648925781250, -0.0256958007812500, 0.0601806640625000,
-0.0050964355468750, 0.0495300292968750, 0.0091552734375000, -0.0059814453125000,
-0.0070190429687500, 0.0150146484375000, 0.0481567382812500, -0.0082092285156250,
0.0466308593750000, -0.0133972167968750, 0.0412292480468750, -0.0120849609375000,
0.0743713378906250, -0.0173645019531250, 0.0696105957031250, -0.0132141113281250,
0.0244140625000000, -0.0297851562500000, 0.0467529296875000, -0.0192565917968750,
0.0189208984375000, -0.0417480468750000, -0.0415039062500000, -0.0648803710937500,
-0.0116271972656250, -0.0450744628906250, -0.0303344726562500, -0.1250610351562500,
-0.0563354492187500, -0.1080932617187500, -0.0202331542968750, -0.1371459960937500,
0.0115051269531250, -0.2084960937500000, -0.0157470703125000, -0.1752319335937500,
0.0341491699218750, -0.2363586425781250, 0.0563354492187500, -0.2457275390625000,
0.0114440917968750, -0.2362976074218750, 0.0029907226562500, -0.2564086914062500,
0.0318603515625000, -0.2551879882812500, -0.0949096679687500, -0.2445373535156250,
-0.0840759277343750, -0.2431335449218750, -0.0899047851562500, -0.2500610351562500,
-0.1762390136718750, -0.2482299804687500, -0.1523132324218750, -0.2447509765625000,
-0.1082763671875000, -0.2745666503906250, -0.1504516601562500, -0.2700500488281250,
-0.0915222167968750, -0.2725219726562500, -0.0049438476562500, -0.2963256835937500,
-0.0588684082031250, -0.2904663085937500, 0.0387573242187500, -0.2760314941406250,
0.0536499023437500, -0.2923889160156250, 0.0399780273437500, -0.2688293457031250,
0.0700988769531250, -0.2396545410156250, 0.0682983398437500, -0.2611694335937500,
0.0685729980468750, -0.1998901367187500, 0.0611877441406250, -0.2068176269531250,
0.0837707519531250, -0.1916503906250000, 0.1009521484375000, -0.1491088867187500,
0.0831604003906250, -0.1697387695312500, 0.1427307128906250, -0.1200256347656250,
0.1407775878906250, -0.1311645507812500, 0.1442871093750000, -0.0951232910156250,
0.1755371093750000, -0.0542602539062500, 0.1655273437500000, -0.0878295898437500,
0.1899108886718750, 0.0676574707031250, 0.1776428222656250, 0.0289916992187500,
0.2082519531250000, 0.0807189941406250, 0.2831726074218750, 0.3150939941406250,
0.4269409179687500},
{-0.0000610351562500, -0.0066833496093750, -0.0000915527343750, -0.0082397460937500,
-0.0000915527343750, -0.0084228515625000, -0.0000610351562500, -0.0087280273437500,
-0.0000305175781250, -0.0069580078125000, -0.0000305175781250, -0.0075073242187500,
-0.0000610351562500, -0.0091552734375000, 0.0000000000000000, 0.0037536621093750,
0.0000915527343750, -0.0028381347656250, 0.0000305175781250, 0.0072631835937500,
0.0000305175781250, 0.0242614746093750, 0.0000305175781250, 0.0131225585937500,
0.0000610351562500, 0.0325622558593750, 0.0000305175781250, 0.0376586914062500,
-0.0000610351562500, 0.0304260253906250, 0.0003967285156250, 0.0338745117187500,
0.0002136230468750, 0.0382080078125000, -0.0032348632812500, 0.0223693847656250,
-0.0006103515625000, 0.0196228027343750, -0.0057678222656250, 0.0325622558593750,
-0.0125732421875000, 0.0282287597656250, -0.0075988769531250, 0.0217895507812500,
-0.0164489746093750, 0.0802307128906250, -0.0219726562500000, 0.0603027343750000,
-0.0087890625000000, 0.0881042480468750, -0.0054931640625000, 0.1505126953125000,
-0.0144348144531250, 0.1177673339843750, 0.0318298339843750, 0.1575927734375000,
0.0243530273437500, 0.1748352050781250, 0.0302429199218750, 0.1487426757812500,
0.0685424804687500, 0.1437072753906250, 0.0556335449218750, 0.1566467285156250,
0.0341186523437500, 0.1045837402343750, 0.0570678710937500, 0.1112976074218750,
0.0263366699218750, 0.0979919433593750, -0.0214843750000000, 0.0609741210937500,
0.0082702636718750, 0.0777893066406250, -0.0272521972656250, 0.0375366210937500,
-0.0487976074218750, 0.0393066406250000, -0.0165100097656250, 0.0314025878906250,
-0.0002136230468750, 0.0058593750000000, -0.0227050781250000, 0.0186157226562500,
0.0275878906250000, -0.0070800781250000, 0.0407104492187500, -0.0026245117187500,
0.0090942382812500, -0.0148620605468750, 0.0145568847656250, -0.0328674316406250,
0.0313415527343750, -0.0201110839843750, -0.0708618164062500, -0.0822448730468750,
-0.0558166503906250, -0.0644226074218750, -0.0687255859375000, -0.0978698730468750,
-0.1482849121093750, -0.1586914062500000, -0.1222229003906250, -0.1221008300781250,
-0.0950927734375000, -0.2061157226562500, -0.1321716308593750, -0.2056579589843750,
-0.0820312500000000, -0.2085571289062500, -0.0124511718750000, -0.2552795410156250,
-0.0551452636718750, -0.2394409179687500, 0.0296325683593750, -0.2492980957031250,
0.0408020019531250, -0.2570800781250000, 0.0315856933593750, -0.2480468750000000,
0.0601196289062500, -0.2431335449218750, 0.0563964843750000, -0.2482910156250000,
0.0599975585937500, -0.2374572753906250, 0.0527648925781250, -0.2377624511718750,
0.0724792480468750, -0.2374267578125000, 0.0895996093750000, -0.2317810058593750,
0.0733032226562500, -0.2341308593750000, 0.1263427734375000, -0.2322998046875000,
0.1228942871093750, -0.2356567382812500, 0.1276245117187500, -0.2278137207031250,
0.1573791503906250, -0.2249450683593750, 0.1475219726562500, -0.2317810058593750,
0.1755676269531250, -0.1867675781250000, 0.1591491699218750, -0.2017517089843750,
0.2025146484375000, -0.1761169433593750, 0.2437133789062500, -0.1296081542968750,
0.2056274414062500, -0.1569213867187500, 0.3550415039062500, -0.0964965820312500,
0.3406982421875000, -0.1009216308593750, 0.3468322753906250, -0.0876464843750000,
0.4879455566406250, -0.0166320800781250, 0.2804870605468750, -0.1459655761718750,
-0.0443725585937500, -0.0640563964843750, 0.0705871582031250, -0.0933227539062500,
-0.0208435058593750, -0.0542297363281250, -0.2004394531250000, -0.0153808593750000,
-0.1227722167968750, -0.0430297851562500, -0.2338256835937500, 0.0939025878906250,
-0.2531738281250000, 0.0529479980468750, -0.2400817871093750, 0.1249084472656250,
-0.2808837890625000, 0.2701110839843750, -0.2713623046875000, 0.1908569335937500,
-0.2500915527343750, 0.3189697265625000, -0.2668457031250000, 0.3504333496093750,
-0.2476196289062500, 0.3070983886718750, -0.2112426757812500, 0.3298645019531250,
-0.2314758300781250, 0.3446655273437500, -0.2162475585937500, 0.2617797851562500,
-0.1929016113281250, 0.2711181640625000, -0.2364501953125000, 0.2572937011718750,
-0.2623596191406250, 0.2043457031250000, -0.2268371582031250, 0.2240600585937500,
-0.3414916992187500, 0.1788024902343750, -0.3336181640625000, 0.1894226074218750,
-0.3349609375000000, 0.1587219238281250, -0.4097595214843750, 0.1131896972656250,
-0.3888549804687500, 0.1441955566406250, -0.3445434570312500, 0.0537414550781250,
-0.3872070312500000, 0.0574951171875000, -0.3265075683593750, 0.0462951660156250,
-0.2442932128906250, -0.0075378417968750, -0.2998046875000000, 0.0130310058593750,
-0.1638488769531250, -0.0263977050781250, -0.1662902832031250, -0.0207824707031250,
-0.1558837890625000, -0.0411071777343750, -0.0801696777343750, -0.0769653320312500,
-0.1076660156250000, -0.0529174804687500, -0.0589904785156250, -0.1027832031250000,
-0.0626220703125000, -0.1130371093750000, -0.0401000976562500, -0.0936584472656250,
-0.0038452148437500, -0.1064758300781250, -0.0299987792968750, -0.1141967773437500,
0.0498962402343750, -0.0502624511718750, 0.0380859375000000, -0.0625915527343750,
0.0546264648437500, -0.0474853515625000, 0.1125793457031250, 0.0059204101562500,
0.0844421386718750, -0.0130004882812500, 0.1262817382812500, -0.0000305175781250,
0.1325378417968750, 0.0079650878906250, 0.1235351562500000, 0.0062561035156250,
0.1403503417968750, 0.0024719238281250, 0.1392211914062500, 0.0015258789062500,
0.1076660156250000, 0.0287780761718750, 0.1262207031250000, 0.0200500488281250,
0.1004333496093750, 0.0287780761718750, 0.0569763183593750, 0.0588989257812500,
0.0845336914062500, 0.0477905273437500, 0.0350036621093750, 0.0390319824218750,
0.0284423828125000, 0.0548706054687500, 0.0374755859375000, 0.0325622558593750,
0.0209960937500000, 0.0024108886718750, 0.0214233398437500, 0.0207519531250000,
0.0351867675781250, -0.0121154785156250, 0.0333251953125000, -0.0192871093750000,
0.0321655273437500, -0.0104370117187500, 0.0401000976562500, -0.0172729492187500,
0.0390014648437500, -0.0195312500000000, 0.0308227539062500, -0.0059204101562500,
0.0346374511718750, -0.0066833496093750, 0.0308532714843750, -0.0063171386718750,
0.0207519531250000, 0.0011901855468750, 0.0249938964843750, -0.0007324218750000,
0.0241088867187500, -0.0002746582031250, 0.0204772949218750, 0.0004882812500000,
0.0252685546875000, 0.0002136230468750, 0.0315246582031250, -0.0000610351562500,
0.0285644531250000, -0.0000610351562500, 0.0314941406250000, 0.0000915527343750,
0.0375976562500000, 0.0000915527343750, 0.0299072265625000, 0.0000305175781250,
0.0268859863281250, 0.0000915527343750, 0.0365295410156250, 0.0000915527343750,
0.0083923339843750, 0.0000305175781250, 0.0192871093750000, 0.0000915527343750,
0.0095825195312500, 0.0000610351562500, -0.0150146484375000, 0.0000610351562500,
0.0027160644531250, 0.0000610351562500, -0.0282897949218750, 0.0001220703125000,
-0.0230407714843750, 0.0000305175781250, -0.0263977050781250, 0.0000610351562500,
-0.0446777343750000, 0.0000610351562500, -0.0294494628906250, 0.0000305175781250,
-0.0469055175781250, 0.0000915527343750, -0.0432739257812500, 0.0001220703125000,
-0.0425109863281250, 0.0001220703125000, -0.0514221191406250, 0.0001220703125000,
-0.0422363281250000, 0.0000915527343750, -0.0498046875000000, 0.0000915527343750,
-0.0473022460937500, 0.0001220703125000, -0.0444946289062500, 0.0000915527343750,
-0.0474548339843750, 0.0000915527343750, -0.0425109863281250, 0.0001220703125000,
-0.0384826660156250, 0.0001220703125000, -0.0364379882812500, 0.0001220703125000,
-0.0309143066406250, 0.0000610351562500, -0.0254516601562500, 0.0000305175781250,
-0.0231018066406250, 0.0000610351562500, -0.0131530761718750, 0.0000305175781250,
-0.0139465332031250, 0.0000305175781250, -0.0056152343750000, 0.0000000000000000,
0.0051879882812500, 0.0000000000000000, 0.0014038085937500, 0.0000305175781250,
0.0202026367187500, -0.0001220703125000, 0.0192565917968750, -0.0000610351562500,
0.0222473144531250, -0.0000610351562500, 0.0357666015625000, -0.0001525878906250,
0.0321655273437500, -0.0001525878906250, 0.0339355468750000, 0.0000610351562500,
0.0388183593750000, 0.0000915527343750, 0.0306701660156250, -0.0003356933593750,
0.0250549316406250, 0.0000610351562500, 0.0306396484375000, 0.0001831054687500,
0.0060424804687500, -0.0033874511718750, 0.0111694335937500, -0.0012512207031250,
-0.0007324218750000, -0.0046386718750000, -0.0239562988281250, -0.0098876953125000,
-0.0136108398437500, -0.0059204101562500, -0.0428771972656250, -0.0114135742187500,
-0.0428161621093750, -0.0147094726562500, -0.0468444824218750, -0.0071105957031250,
-0.0644226074218750, -0.0057678222656250, -0.0584411621093750, -0.0111694335937500,
-0.0719299316406250, 0.0155944824218750, -0.0725708007812500, 0.0084228515625000,
-0.0732421875000000, 0.0158996582031250, -0.0809936523437500, 0.0404052734375000,
-0.0778503417968750, 0.0285644531250000, -0.0756530761718750, 0.0347290039062500,
-0.0799255371093750, 0.0449523925781250, -0.0737609863281250, 0.0304260253906250,
-0.0644836425781250, 0.0191345214843750, -0.0699157714843750, 0.0309753417968750,
-0.0675354003906250, 0.0039367675781250, -0.0582580566406250, 0.0027770996093750,
-0.0796508789062500, 0.0052795410156250, -0.0942382812500000, -0.0059814453125000,
-0.0802917480468750, -0.0044555664062500, -0.1448974609375000, -0.0052795410156250,
-0.1387939453125000, -0.0022277832031250, -0.1529235839843750, -0.0114746093750000,
-0.2002868652343750, -0.0177307128906250, -0.1819763183593750, -0.0092163085937500,
-0.2021179199218750, -0.0360412597656250, -0.2097167968750000, -0.0343627929687500,
-0.2033081054687500, -0.0335083007812500, -0.2048645019531250, -0.0491638183593750,
-0.2058715820312500, -0.0458068847656250, -0.1986389160156250, -0.0396728515625000,
-0.2003479003906250, -0.0418701171875000, -0.1944580078125000, -0.0447082519531250,
-0.1877441406250000, -0.0402221679687500, -0.1917114257812500, -0.0380554199218750,
-0.1691894531250000, -0.0536193847656250, -0.1762084960937500, -0.0545349121093750,
-0.1592712402343750, -0.0420227050781250, -0.1352233886718750, -0.0507507324218750,
-0.1499938964843750, -0.0563049316406250, -0.1005249023437500, 0.0174865722656250,
-0.1086425781250000, -0.0131530761718750, -0.0915527343750000, 0.0324096679687500,
-0.0523681640625000, 0.1140136718750000, -0.0725402832031250, 0.0619201660156250,
-0.0226440429687500, 0.1635437011718750, -0.0252685546875000, 0.1689453125000000,
-0.0164184570312500, 0.1694335937500000, 0.0160522460937500, 0.2198486328125000,
0.0012207031250000, 0.2029418945312500, 0.0267333984375000, 0.2097473144531250,
0.0275878906250000, 0.2224731445312500, 0.0302124023437500, 0.2022399902343750,
0.0434875488281250, 0.1837158203125000, 0.0429687500000000, 0.1853332519531250,
0.0733032226562500, 0.1293945312500000, 0.0573730468750000, 0.1478576660156250,
0.0725097656250000, 0.1401062011718750, 0.1020507812500000, 0.0932312011718750,
0.0808715820312500, 0.1100769042968750, 0.1386413574218750, 0.0938720703125000,
0.1264343261718750, 0.0858764648437500, 0.1499938964843750, 0.0874633789062500,
0.1962585449218750, 0.0892944335937500, 0.1658325195312500, 0.0884704589843750,
0.2456665039062500, 0.0612182617187500, 0.2401428222656250, 0.0740356445312500,
0.2419128417968750, 0.0517883300781250, 0.2987976074218750, 0.0139160156250000,
0.2802429199218750, 0.0338134765625000, 0.2299499511718750, -0.0025634765625000,
0.2796630859375000},
{-0.0432434082031250, -0.0022888183593750, -0.0473937988281250, -0.0005798339843750,
-0.0372924804687500, -0.0035400390625000, -0.0195922851562500, -0.0074768066406250,
-0.0276184082031250, -0.0042419433593750, -0.0001831054687500, -0.0101623535156250,
-0.0009460449218750, -0.0120239257812500, 0.0059509277343750, -0.0069580078125000,
0.0264282226562500, -0.0079345703125000, 0.0195617675781250, -0.0110168457031250,
0.0300598144531250, 0.0093688964843750, 0.0356750488281250, 0.0025329589843750,
0.0284118652343750, 0.0109252929687500, 0.0267639160156250, 0.0316772460937500,
0.0299072265625000, 0.0202026367187500, 0.0073852539062500, 0.0314941406250000,
0.0125427246093750, 0.0391540527343750, -0.0004577636718750, 0.0276489257812500,
-0.0216674804687500, 0.0228576660156250, -0.0098876953125000, 0.0312500000000000,
-0.0452880859375000, 0.0073852539062500, -0.0448608398437500, 0.0085144042968750,
-0.0473937988281250, 0.0086975097656250, -0.0699157714843750, -0.0043029785156250,
-0.0626220703125000, -0.0010986328125000, -0.0559997558593750, -0.0028381347656250,
-0.0661315917968750, -0.0017395019531250, -0.0505065917968750, -0.0082092285156250,
-0.0284118652343750, -0.0118713378906250, -0.0408325195312500, -0.0058593750000000,
-0.0243835449218750, -0.0294494628906250, -0.0105590820312500, -0.0256958007812500,
-0.0390625000000000, -0.0278930664062500, -0.0544433593750000, -0.0450744628906250,
-0.0361938476562500, -0.0393676757812500, -0.1084289550781250, -0.0384826660156250,
-0.1024780273437500, -0.0420532226562500, -0.1158752441406250, -0.0412902832031250,
-0.1649780273437500, -0.0364685058593750, -0.1460876464843750, -0.0368957519531250,
-0.1759033203125000, -0.0463256835937500, -0.1808471679687500, -0.0445861816406250,
-0.1784667968750000, -0.0395812988281250, -0.1895141601562500, -0.0493469238281250,
-0.1864318847656250, -0.0499877929687500, -0.1863403320312500, -0.0024414062500000,
-0.1887207031250000, -0.0284729003906250, -0.1843872070312500, 0.0131225585937500,
-0.1821899414062500, 0.0764465332031250, -0.1844482421875000, 0.0358886718750000,
-0.1664123535156250, 0.1365661621093750, -0.1744689941406250, 0.1320495605468750,
-0.1587829589843750, 0.1416320800781250, -0.1372680664062500, 0.2015991210937500,
-0.1516418457031250, 0.1759033203125000, -0.1051940917968750, 0.2061767578125000,
-0.1121826171875000, 0.2174377441406250, -0.0961608886718750, 0.1997680664062500,
-0.0603942871093750, 0.2029113769531250, -0.0798950195312500, 0.2110900878906250,
-0.0330505371093750, 0.1577453613281250, -0.0361633300781250, 0.1712951660156250,
-0.0287475585937500, 0.1532592773437500, 0.0066833496093750, 0.0956420898437500,
0.0041198730468750, 0.1042785644531250, 0.0281066894531250, 0.0869750976562500,
0.0200195312500000, 0.0849609375000000, 0.0267639160156250, 0.0874328613281250,
0.0447998046875000, 0.0833129882812500, 0.0332946777343750, 0.0822143554687500,
0.0688781738281250, 0.0632019042968750, 0.0593566894531250, 0.0753784179687500,
0.0767517089843750, 0.0511779785156250, 0.1079406738281250, 0.0184326171875000,
0.0869445800781250, 0.0394592285156250, 0.1424255371093750, -0.0089416503906250,
0.1307678222656250, -0.0133361816406250, 0.1541442871093750, -0.0125427246093750,
0.2007751464843750, -0.0312805175781250, 0.1714172363281250, -0.0273437500000000,
0.2428894042968750, -0.0469360351562500, 0.2447204589843750, -0.0354919433593750,
0.2360229492187500, -0.0615844726562500, 0.2788391113281250, -0.0928344726562500,
0.2718811035156250, -0.0702819824218750, 0.1941223144531250, -0.1405334472656250,
0.2425537109375000, -0.1378479003906250, 0.1672668457031250, -0.1424865722656250,
0.0541381835937500, -0.1849670410156250, 0.1292114257812500, -0.1715698242187500,
-0.0305175781250000, -0.1764526367187500, -0.0422668457031250, -0.1851806640625000,
-0.0287475585937500, -0.1760864257812500, -0.1002502441406250, -0.1696166992187500,
-0.0871887207031250, -0.1752014160156250, -0.0520629882812500, -0.1516113281250000,
-0.0688476562500000, -0.1610412597656250, -0.0561218261718750, -0.1453247070312500,
-0.0175781250000000, -0.1190490722656250, -0.0322875976562500, -0.1375732421875000,
-0.0299377441406250, -0.1000061035156250, -0.0190734863281250, -0.0962829589843750,
-0.0271606445312500, -0.1020202636718750, -0.0402526855468750, -0.0874938964843750,
-0.0337219238281250, -0.0883178710937500, -0.0310668945312500, -0.0998229980468750,
-0.0390930175781250, -0.0974731445312500, -0.0297241210937500, -0.0969543457031250,
-0.0171203613281250, -0.1057739257812500, -0.0257263183593750, -0.1047363281250000,
-0.0119934082031250, -0.0928039550781250, -0.0107727050781250, -0.0987854003906250,
-0.0096740722656250, -0.0885925292968750, -0.0050964355468750, -0.0720825195312500,
-0.0077819824218750, -0.0803527832031250, 0.0095520019531250, -0.0596313476562500,
0.0017700195312500, -0.0576782226562500, 0.0117492675781250, -0.0548095703125000,
0.0319213867187500, -0.0437622070312500, 0.0188293457031250, -0.0476379394531250,
0.0365905761718750, -0.0392150878906250, 0.0432434082031250, -0.0390014648437500,
0.0312500000000000, -0.0370788574218750, 0.0311279296875000, -0.0310058593750000,
0.0384216308593750, -0.0334472656250000, 0.0086669921875000, -0.0314025878906250,
0.0135803222656250, -0.0288696289062500, 0.0089416503906250, -0.0336303710937500,
-0.0129089355468750, -0.0371093750000000, -0.0039062500000000, -0.0344848632812500,
-0.0100708007812500, -0.0454711914062500, -0.0152282714843750, -0.0451049804687500,
-0.0097351074218750, -0.0456848144531250, -0.0063476562500000, -0.0514526367187500,
-0.0098571777343750, -0.0488891601562500, -0.0024719238281250, -0.0499877929687500,
-0.0018615722656250, -0.0493774414062500, -0.0025634765625000, -0.0464172363281250,
0.0003051757812500, -0.0442810058593750, -0.0003356933593750, -0.0429687500000000,
-0.0004577636718750, -0.0399475097656250, -0.0002136230468750, -0.0365905761718750,
-0.0002441406250000, -0.0360107421875000, -0.0004272460937500, -0.0350646972656250,
-0.0004272460937500, -0.0317077636718750, -0.0003051757812500, -0.0337829589843750,
-0.0003356933593750, -0.0305480957031250, -0.0002441406250000, -0.0302429199218750,
-0.0002136230468750, -0.0324401855468750, -0.0002746582031250, -0.0293273925781250,
-0.0001220703125000, -0.0328674316406250, -0.0001525878906250, -0.0288085937500000,
-0.0001220703125000, -0.0307617187500000, -0.0000610351562500, -0.0354614257812500,
-0.0001220703125000, -0.0304870605468750, -0.0000610351562500, -0.0400085449218750,
-0.0000915527343750, -0.0380554199218750, -0.0000610351562500, -0.0396423339843750,
-0.0000305175781250, -0.0464172363281250, -0.0000305175781250, -0.0431213378906250,
-0.0000305175781250, -0.0510253906250000, 0.0000000000000000, -0.0481262207031250,
-0.0000305175781250, -0.0515441894531250, -0.0000305175781250, -0.0588684082031250,
0.0000000000000000, -0.0540771484375000, -0.0002136230468750, -0.0663452148437500,
-0.0001831054687500, -0.0637207031250000, -0.0002136230468750, -0.0681762695312500,
-0.0002441406250000, -0.0767211914062500, -0.0002441406250000, -0.0711059570312500,
-0.0006713867187500, -0.0926818847656250, 0.0000915527343750, -0.0823059082031250,
-0.0021362304687500, -0.1008300781250000, -0.0035705566406250, -0.1256713867187500,
-0.0019226074218750, -0.1053161621093750, -0.0107421875000000, -0.1638793945312500,
-0.0102539062500000, -0.1560363769531250, -0.0097351074218750, -0.1595764160156250,
-0.0173645019531250, -0.2009582519531250, -0.0157775878906250, -0.1852111816406250,
0.0028686523437500, -0.1756591796875000, -0.0078735351562500, -0.1991882324218750,
0.0089721679687500, -0.1645507812500000, 0.0380859375000000, -0.1283569335937500,
0.0214843750000000, -0.1588134765625000, 0.0412292480468750, -0.0741577148437500,
0.0559692382812500, -0.0852355957031250, 0.0313415527343750, -0.0668334960937500,
0.0182495117187500, -0.0078125000000000, 0.0359191894531250, -0.0357971191406250,
-0.0153808593750000, 0.0256042480468750, -0.0197448730468750, 0.0170593261718750,
-0.0063171386718750, 0.0416564941406250, -0.0251464843750000, 0.0920715332031250,
-0.0290832519531250, 0.0609130859375000, 0.0128784179687500, 0.1262207031250000,
0.0088500976562500, 0.1330871582031250, 0.0012817382812500, 0.1231079101562500,
0.0283813476562500, 0.1491394042968750, 0.0280151367187500, 0.1484069824218750,
-0.0284729003906250, 0.1230773925781250, -0.0069885253906250, 0.1243896484375000,
-0.0319213867187500, 0.1296081542968750, -0.0968017578125000, 0.1165771484375000,
-0.0678405761718750, 0.1151428222656250, -0.0782165527343750, 0.1435546875000000,
-0.1052551269531250, 0.1406250000000000, -0.0681762695312500, 0.1406555175781250,
-0.0337524414062500, 0.1616210937500000, -0.0609741210937500, 0.1589965820312500,
0.0083312988281250, 0.1353454589843750, 0.0122985839843750, 0.1517333984375000,
0.0094604492187500, 0.1264038085937500, 0.0394897460937500, 0.0914611816406250,
0.0334777832031250, 0.1157531738281250, 0.0404052734375000, 0.0522766113281250,
0.0360412597656250, 0.0591430664062500, 0.0509338378906250, 0.0430908203125000,
0.0650939941406250, 0.0001831054687500, 0.0520324707031250, 0.0222778320312500,
0.0950622558593750, -0.0378417968750000, 0.0923461914062500, -0.0254211425781250,
0.0987243652343750, -0.0550842285156250, 0.1245422363281250, -0.1069030761718750,
0.1156921386718750, -0.0737304687500000, 0.1444091796875000, -0.1673583984375000,
0.1310729980468750, -0.1546020507812500, 0.1659240722656250, -0.1781616210937500,
0.2026062011718750, -0.2509460449218750, 0.1707458496093750, -0.2160034179687500,
0.2867736816406250, -0.2619934082031250, 0.2736816406250000, -0.2829895019531250,
0.2872009277343750, -0.2501220703125000, 0.3753051757812500, -0.2448120117187500,
0.3430175781250000, -0.2636108398437500, 0.3091125488281250, -0.1840209960937500,
0.3626098632812500, -0.1905822753906250, 0.2693786621093750, -0.1889648437500000,
0.1705322265625000, -0.1382751464843750, 0.2453002929687500, -0.1506958007812500,
0.0149536132812500, -0.1689147949218750, 0.0257568359375000, -0.1574707031250000,
0.0114746093750000, -0.1626281738281250, -0.2003479003906250, -0.1940917968750000,
-0.2117309570312500, -0.1367187500000000, -0.1857910156250000, -0.1623229980468750,
-0.2113342285156250, -0.1455688476562500, -0.1856689453125000, -0.1512756347656250,
-0.1480712890625000, -0.1809082031250000, -0.1708374023437500, -0.1771850585937500,
-0.1562500000000000, -0.1291198730468750, -0.1322021484375000, -0.1534729003906250,
-0.1741943359375000, -0.1226806640625000, -0.2003479003906250, -0.0626525878906250,
-0.1680908203125000, -0.0922851562500000, -0.2830505371093750, -0.0327758789062500,
-0.2731628417968750, -0.0376892089843750, -0.2780151367187500, -0.0108032226562500,
-0.3563232421875000, 0.0273437500000000, -0.3321838378906250, -0.0016784667968750,
-0.2918395996093750, 0.1260375976562500, -0.3343200683593750, 0.0991210937500000,
-0.2737121582031250, 0.1425170898437500, -0.1928100585937500, 0.2576904296875000,
-0.2494506835937500, 0.2028503417968750, -0.1259460449218750, 0.2650451660156250,
-0.1245422363281250, 0.2955322265625000, -0.1142578125000000, 0.2557983398437500,
-0.0508728027343750, 0.2449340820312500, -0.0751647949218750, 0.2657165527343750,
-0.0086669921875000, 0.1965637207031250, -0.0271606445312500, 0.1993408203125000,
0.0133361816406250, 0.1895446777343750, 0.0787963867187500, 0.1515197753906250,
0.0341186523437500, 0.1669616699218750, 0.1540222167968750, 0.1183166503906250,
0.1496887207031250, 0.1306762695312500, 0.1507873535156250, 0.1032409667968750,
0.2231140136718750},
{-0.0170593261718750, 0.0215148925781250, -0.0707092285156250, 0.1256713867187500,
-0.0402832031250000, 0.0727233886718750, -0.0702209472656250, 0.1642761230468750,
-0.0934143066406250, 0.1889343261718750, -0.0598144531250000, 0.1575622558593750,
-0.0405578613281250, 0.1695556640625000, -0.0633239746093750, 0.1809692382812500,
-0.0002441406250000, 0.1284179687500000, -0.0004882812500000, 0.1285400390625000,
-0.0011291503906250, 0.1324462890625000, 0.0300292968750000, 0.1064758300781250,
0.0222167968750000, 0.1106872558593750, 0.0318908691406250, 0.1314086914062500,
0.0294799804687500, 0.1243591308593750, 0.0413208007812500, 0.1323242187500000,
0.0534362792968750, 0.1546020507812500, 0.0426940917968750, 0.1459655761718750,
0.0808105468750000, 0.1460571289062500, 0.0778808593750000, 0.1599426269531250,
0.0845642089843750, 0.1360473632812500, 0.1083068847656250, 0.1174316406250000,
0.0994873046875000, 0.1370544433593750, 0.1263732910156250, 0.0684509277343750,
0.1150512695312500, 0.0802307128906250, 0.1465454101562500, 0.0568237304687500,
0.1804504394531250, 0.0037231445312500, 0.1519470214843750, 0.0329589843750000,
0.2535095214843750, -0.0362548828125000, 0.2426147460937500, -0.0264587402343750,
0.2538146972656250, -0.0517883300781250, 0.3294982910156250, -0.1029968261718750,
0.3020324707031250, -0.0726013183593750, 0.2768859863281250, -0.1672973632812500,
0.3245849609375000, -0.1531372070312500, 0.2445068359375000, -0.1829833984375000,
0.1605224609375000, -0.2620239257812500, 0.2243347167968750, -0.2221984863281250,
0.0238952636718750, -0.2718505859375000, 0.0405883789062500, -0.2971801757812500,
0.0006103515625000, -0.2551574707031250, -0.1369628906250000, -0.2438354492187500,
-0.0778503417968750, -0.2705078125000000, -0.1749267578125000, -0.1752014160156250,
-0.1909179687500000, -0.1793212890625000, -0.1770324707031250, -0.1846313476562500,
-0.2233581542968750, -0.1135559082031250, -0.1650085449218750, -0.2692565917968750,
-0.1531677246093750, -0.1472167968750000, -0.1300659179687500, -0.1773071289062500,
-0.1738891601562500, -0.1700744628906250, -0.2019042968750000, -0.1181945800781250,
-0.1693725585937500, -0.1256103515625000, -0.2754516601562500, -0.1580505371093750,
-0.2689208984375000, -0.1515808105468750, -0.2714538574218750, -0.1469421386718750,
-0.3398132324218750, -0.1721191406250000, -0.3194580078125000, -0.1715393066406250,
-0.2844543457031250, -0.1141357421875000, -0.3194580078125000, -0.1359252929687500,
-0.2674255371093750, -0.1082458496093750, -0.1980285644531250, -0.0481262207031250,
-0.2433776855468750, -0.0767822265625000, -0.1354675292968750, -0.0201416015625000,
-0.1387023925781250, -0.0263977050781250, -0.1206970214843750, 0.0033264160156250,
-0.0603332519531250, 0.0450439453125000, -0.0888977050781250, 0.0137939453125000,
0.0026245117187500, 0.1341247558593750, -0.0213928222656250, 0.1144409179687500,
0.0299987792968750, 0.1449279785156250, 0.1206054687500000, 0.2451477050781250,
0.0627746582031250, 0.2030029296875000, 0.1876525878906250, 0.2363281250000000,
0.1914062500000000, 0.2652893066406250, 0.1813354492187500, 0.2286376953125000,
0.2456665039062500, 0.2049865722656250, 0.2312927246093750, 0.2279052734375000,
0.1817016601562500, 0.1666870117187500, 0.2142944335937500, 0.1671447753906250,
0.1744079589843750, 0.1580810546875000, 0.1017150878906250, 0.1259765625000000,
0.1451110839843750, 0.1402282714843750, 0.0937500000000000, 0.0910644531250000,
0.0684509277343750, 0.1018371582031250, 0.1047363281250000, 0.0795593261718750,
0.1181945800781250, 0.0336303710937500, 0.0932006835937500, 0.0579223632812500,
0.1373596191406250, 0.0065002441406250, 0.1562194824218750, 0.0042724609375000,
0.1199645996093750, 0.0000915527343750, 0.1130371093750000, -0.0250549316406250,
0.1378479003906250, -0.0151062011718750, 0.0481567382812500, -0.0447998046875000,
0.0618286132812500, -0.0406799316406250, 0.0469970703125000, -0.0483703613281250,
-0.0132751464843750, -0.0756835937500000, 0.0146789550781250, -0.0646057128906250,
-0.0346679687500000, -0.0602722167968750, -0.0338745117187500, -0.0764770507812500,
-0.0383605957031250, -0.0524597167968750, -0.0700683593750000, -0.0238952636718750,
-0.0579833984375000, -0.0431518554687500, -0.0651855468750000, -0.0028991699218750,
-0.0751342773437500, 0.0032348632812500, -0.0646057128906250, -0.0034484863281250,
-0.0569458007812500, 0.0072326660156250, -0.0652465820312500, 0.0075378417968750,
-0.0422668457031250, 0.0090637207031250, -0.0465393066406250, 0.0029296875000000,
-0.0400085449218750, 0.0147399902343750, -0.0224609375000000, 0.0279846191406250,
-0.0339965820312500, 0.0169677734375000, -0.0191955566406250, 0.0354309082031250,
-0.0165710449218750, 0.0435485839843750, -0.0232849121093750, 0.0286254882812500,
-0.0209655761718750, 0.0247802734375000, -0.0196838378906250, 0.0339660644531250,
-0.0321655273437500, -0.0000915527343750, -0.0283203125000000, 0.0006408691406250,
-0.0358581542968750, 0.0006408691406250, -0.0472106933593750, -0.0183715820312500,
-0.0385437011718750, -0.0140075683593750, -0.0603942871093750, -0.0090026855468750,
-0.0553894042968750, -0.0130920410156250, -0.0615539550781250, -0.0091552734375000,
-0.0778808593750000, -0.0013732910156250, -0.0669860839843750, -0.0046081542968750,
-0.0896301269531250, -0.0009460449218750, -0.0872192382812500, 0.0003967285156250,
-0.0905456542968750, -0.0004882812500000, -0.1063537597656250, -0.0001220703125000,
-0.0993347167968750, -0.0000610351562500, -0.1076965332031250, -0.0001831054687500,
-0.1111755371093750, -0.0002441406250000, -0.1068725585937500, -0.0002136230468750,
-0.1074523925781250, -0.0001220703125000, -0.1100463867187500, -0.0001220703125000,
-0.0998840332031250, -0.0002136230468750, -0.1024475097656250, -0.0001831054687500,
-0.0984497070312500, -0.0001831054687500, -0.0899963378906250, -0.0002441406250000,
-0.0953674316406250, -0.0002136230468750, -0.0840454101562500, -0.0001525878906250,
-0.0856323242187500, -0.0001831054687500, -0.0825195312500000, -0.0001831054687500,
-0.0746459960937500, -0.0001525878906250, -0.0798339843750000, -0.0001831054687500,
-0.0683898925781250, 0.0000000000000000, -0.0696716308593750, -0.0000305175781250,
-0.0674133300781250, -0.0000915527343750, -0.0593872070312500, 0.0001831054687500,
-0.0625915527343750, 0.0000610351562500, -0.0542907714843750, -0.0009155273437500,
-0.0553283691406250, 0.0001220703125000, -0.0519409179687500, -0.0017700195312500,
-0.0460205078125000, -0.0037231445312500, -0.0496520996093750, -0.0017700195312500,
-0.0353698730468750, -0.0071411132812500, -0.0391235351562500, -0.0071716308593750,
-0.0311584472656250, -0.0056152343750000, -0.0174865722656250, -0.0087585449218750,
-0.0249938964843750, -0.0088500976562500, -0.0007629394531250, 0.0011291503906250,
-0.0034484863281250, -0.0042724609375000, 0.0034790039062500, 0.0037841796875000,
0.0220336914062500, 0.0169982910156250, 0.0138244628906250, 0.0079345703125000,
0.0304565429687500, 0.0231323242187500, 0.0326232910156250, 0.0262145996093750,
0.0276184082031250, 0.0204162597656250, 0.0328979492187500, 0.0241394042968750,
0.0326232910156250, 0.0266723632812500, 0.0158081054687500, 0.0115966796875000,
0.0201110839843750, 0.0150756835937500, 0.0112609863281250, 0.0120849609375000,
-0.0060119628906250, 0.0001831054687500, 0.0008239746093750, 0.0051574707031250,
-0.0160827636718750, 0.0002746582031250, -0.0179748535156250, -0.0005187988281250,
-0.0190429687500000, -0.0027770996093750, -0.0280151367187500, -0.0044860839843750,
-0.0248413085937500, -0.0018615722656250, -0.0223083496093750, -0.0165710449218750,
-0.0267028808593750, -0.0120849609375000, -0.0179748535156250, -0.0175476074218750,
-0.0088195800781250, -0.0321044921875000, -0.0147399902343750, -0.0248413085937500,
0.0054321289062500, -0.0316162109375000, 0.0085754394531250, -0.0351562500000000,
0.0051269531250000, -0.0321044921875000, 0.0140075683593750, -0.0304260253906250,
0.0149536132812500, -0.0320434570312500, -0.0065612792968750, -0.0343017578125000,
-0.0011596679687500, -0.0314941406250000, -0.0056152343750000, -0.0330810546875000,
-0.0259399414062500, -0.0400695800781250, -0.0193176269531250, -0.0368347167968750,
-0.0107421875000000, -0.0223999023437500, -0.0167236328125000, -0.0374755859375000,
-0.0118713378906250, -0.0090942382812500, 0.0023803710937500, 0.0199584960937500,
-0.0020446777343750, -0.0052795410156250, -0.0111083984375000, 0.0762634277343750,
-0.0006408691406250, 0.0629272460937500, -0.0170593261718750, 0.0861206054687500,
-0.0358581542968750, 0.1484680175781250, -0.0222778320312500, 0.1158447265625000,
-0.0690307617187500, 0.1782836914062500, -0.0619201660156250, 0.1813964843750000,
-0.0786437988281250, 0.1765747070312500, -0.1179809570312500, 0.2094116210937500,
-0.0992431640625000, 0.2014465332031250, -0.1349792480468750, 0.1726074218750000,
-0.1378173828125000, 0.1952209472656250, -0.1373901367187500, 0.1625671386718750,
-0.1533813476562500, 0.1159057617187500, -0.1484375000000000, 0.1501464843750000,
-0.1561889648437500, 0.0851440429687500, -0.1572265625000000, 0.0787658691406250,
-0.1559143066406250, 0.0847167968750000, -0.1604309082031250, 0.0603637695312500,
-0.1597290039062500, 0.0639953613281250, -0.1489562988281250, 0.0576782226562500,
-0.1559143066406250, 0.0650024414062500, -0.1433410644531250, 0.0465393066406250,
-0.1228027343750000, 0.0223388671875000, -0.1222229003906250, 0.0255126953125000,
-0.0809936523437500, -0.0244140625000000, -0.0972595214843750, -0.0112304687500000,
-0.0871582031250000, -0.0135192871093750, -0.0533142089843750, -0.0491943359375000,
-0.0722656250000000, -0.0386352539062500, -0.0314331054687500, -0.0513305664062500,
-0.0353393554687500, -0.0494689941406250, -0.0266418457031250, -0.0630798339843750,
-0.0000915527343750, -0.0750122070312500, -0.0148315429687500, -0.0627441406250000,
0.0191955566406250, -0.1190490722656250, 0.0134277343750000, -0.1094970703125000,
0.0256652832031250, -0.1260986328125000, 0.0518188476562500, -0.1736145019531250,
0.0362548828125000, -0.1535034179687500, 0.0800476074218750, -0.1789855957031250,
0.0733642578125000, -0.1887207031250000, 0.0874938964843750, -0.1769409179687500,
0.1195068359375000, -0.1773986816406250, 0.1009521484375000, -0.1817626953125000,
0.1498718261718750, -0.1589355468750000, 0.1415405273437500, -0.1642761230468750,
0.1593933105468750, -0.1526489257812500, 0.2007751464843750, -0.1338195800781250,
0.1771850585937500, -0.1456298828125000, 0.2181701660156250, -0.1039428710937500,
0.2316284179687500, -0.1099243164062500, 0.2047729492187500, -0.1021728515625000,
0.2124633789062500, -0.0682373046875000, 0.2264404296875000, -0.0797119140625000,
0.1165466308593750, -0.0771484375000000, 0.1522521972656250, -0.0668640136718750,
0.0998535156250000, -0.0718688964843750, -0.0114135742187500, -0.0835571289062500,
0.0500793457031250, -0.0770874023437500, -0.0503845214843750, -0.0623779296875000,
-0.0679321289062500, -0.0737915039062500, -0.0433959960937500, -0.0560913085937500,
-0.0715942382812500, -0.0287475585937500, -0.0756835937500000, -0.0437622070312500,
-0.0353698730468750, -0.0175476074218750, -0.0414123535156250, -0.0105895996093750,
-0.0401611328125000, -0.0171203613281250, -0.0142517089843750, -0.0122375488281250,
-0.0212402343750000, -0.0096740722656250, -0.0259704589843750, -0.0178833007812500,
-0.0205993652343750, -0.0194396972656250, -0.0220031738281250, -0.0134582519531250,
-0.0300903320312500, -0.0144348144531250, -0.0278930664062500, -0.0163269042968750,
-0.0196533203125000},
{-0.0095214843750000, -0.0146484375000000, -0.0112304687500000, 0.0530395507812500,
-0.0105285644531250, 0.0381774902343750, -0.0069885253906250, 0.0635070800781250,
-0.0061340332031250, 0.1203613281250000, -0.0090332031250000, 0.0881652832031250,
-0.0016479492187500, 0.1566467285156250, 0.0017089843750000, 0.1563720703125000,
-0.0036926269531250, 0.1584167480468750, -0.0052490234375000, 0.1990356445312500,
-0.0013427734375000, 0.1842346191406250, -0.0124511718750000, 0.1747131347656250,
-0.0091552734375000, 0.1960144042968750, -0.0191040039062500, 0.1636352539062500,
-0.0292358398437500, 0.1278381347656250, -0.0207214355468750, 0.1557312011718750,
-0.0628051757812500, 0.0860900878906250, -0.0527648925781250, 0.0855102539062500,
-0.0686035156250000, 0.0888061523437500, -0.1067199707031250, 0.0556945800781250,
-0.0883178710937500, 0.0634460449218750, -0.1214904785156250, 0.0597229003906250,
-0.1245727539062500, 0.0627136230468750, -0.1250000000000000, 0.0464477539062500,
-0.1397705078125000, 0.0365905761718750, -0.1344909667968750, 0.0510559082031250,
-0.1444702148437500, -0.0057983398437500, -0.1448364257812500, 0.0016174316406250,
-0.1435852050781250, -0.0061340332031250, -0.1509399414062500, -0.0510559082031250,
-0.1492614746093750, -0.0450134277343750, -0.1307983398437500, -0.0532531738281250,
-0.1425781250000000, -0.0511779785156250, -0.1310729980468750, -0.0589904785156250,
-0.1109008789062500, -0.0652770996093750, -0.1255798339843750, -0.0584106445312500,
-0.0847167968750000, -0.1064147949218750, -0.0911254882812500, -0.0942077636718750,
-0.0798950195312500, -0.1152954101562500, -0.0502929687500000, -0.1620788574218750,
-0.0668029785156250, -0.1387939453125000, -0.0293579101562500, -0.1744689941406250,
-0.0330810546875000, -0.1838989257812500, -0.0238342285156250, -0.1722106933593750,
0.0015258789062500, -0.1788635253906250, -0.0118713378906250, -0.1816711425781250,
0.0231933593750000, -0.1545715332031250, 0.0170593261718750, -0.1610412597656250,
0.0312500000000000, -0.1490478515625000, 0.0592346191406250, -0.1253051757812500,
0.0415954589843750, -0.1370239257812500, 0.0858459472656250, -0.1040344238281250,
0.0799255371093750, -0.1087036132812500, 0.0924987792968750, -0.0960388183593750,
0.1243896484375000, -0.0682067871093750, 0.1075134277343750, -0.0834045410156250,
0.1515808105468750, -0.0560302734375000, 0.1452636718750000, -0.0513610839843750,
0.1585998535156250, -0.0553894042968750, 0.1955871582031250, -0.0484924316406250,
0.1771850585937500, -0.0475158691406250, 0.1998291015625000, -0.0386352539062500,
0.2163696289062500, -0.0465393066406250, 0.1821899414062500, -0.0331115722656250,
0.1724853515625000, -0.0144348144531250, 0.1954040527343750, -0.0273132324218750,
0.0812683105468750, -0.0044250488281250, 0.1106872558593750, 0.0007324218750000,
0.0696411132812500, -0.0059814453125000, -0.0349426269531250, -0.0028076171875000,
0.0184020996093750, -0.0002746582031250, -0.0522766113281250, -0.0039672851562500,
-0.0714111328125000, -0.0092773437500000, -0.0469970703125000, 0.0023193359375000,
-0.0581970214843750, 0.0093688964843750, -0.0665283203125000, 0.0000915527343750,
-0.0293884277343750, 0.0321350097656250, -0.0325622558593750, 0.0292358398437500,
-0.0339965820312500, 0.0356445312500000, -0.0135192871093750, 0.0597229003906250,
-0.0179443359375000, 0.0506591796875000, -0.0229492187500000, 0.0557250976562500,
-0.0194702148437500, 0.0645446777343750, -0.0189514160156250, 0.0491943359375000,
-0.0244750976562500, 0.0370483398437500, -0.0238952636718750, 0.0464172363281250,
-0.0146789550781250, 0.0128173828125000, -0.0190734863281250, 0.0125427246093750,
-0.0146789550781250, 0.0086975097656250, -0.0044860839843750, -0.0112609863281250,
-0.0097351074218750, -0.0050354003906250, -0.0017700195312500, -0.0105285644531250,
-0.0018005371093750, -0.0148620605468750, 0.0007934570312500, -0.0093688964843750,
0.0050659179687500, -0.0067749023437500, 0.0012817382812500, -0.0093078613281250,
0.0151977539062500, 0.0051574707031250, 0.0124511718750000, 0.0025634765625000,
0.0151062011718750, 0.0091552734375000, 0.0272521972656250, 0.0225830078125000,
0.0222167968750000, 0.0171508789062500, 0.0200805664062500, 0.0320434570312500,
0.0266723632812500, 0.0326538085937500, 0.0174865722656250, 0.0342712402343750,
0.0072326660156250, 0.0427856445312500, 0.0157470703125000, 0.0398559570312500,
-0.0023193359375000, 0.0429687500000000, -0.0027160644531250, 0.0438232421875000,
-0.0012817382812500, 0.0420837402343750, -0.0099792480468750, 0.0418090820312500,
-0.0080566406250000, 0.0416564941406250, -0.0052490234375000, 0.0386352539062500,
-0.0074768066406250, 0.0380554199218750, -0.0053710937500000, 0.0360717773437500,
-0.0012512207031250, 0.0333251953125000, -0.0033569335937500, 0.0333862304687500,
-0.0005493164062500, 0.0297546386718750, 0.0000305175781250, 0.0280761718750000,
-0.0003967285156250, 0.0265808105468750, 0.0003356933593750, 0.0249938964843750,
0.0002136230468750, 0.0251770019531250, 0.0001525878906250, 0.0225524902343750,
0.0002136230468750, 0.0233459472656250, -0.0000610351562500, 0.0201416015625000,
0.0000000000000000, 0.0173950195312500, 0.0000915527343750, 0.0204467773437500,
-0.0023193359375000, 0.0104064941406250, -0.0008850097656250, 0.0123901367187500,
-0.0038452148437500, 0.0094909667968750, -0.0077209472656250, 0.0009155273437500,
-0.0049133300781250, 0.0043640136718750, -0.0109863281250000, -0.0020446777343750,
-0.0135192871093750, -0.0034484863281250, -0.0069580078125000, -0.0030212402343750,
-0.0069274902343750, -0.0046386718750000, -0.0106811523437500, -0.0046081542968750,
0.0160827636718750, -0.0077209472656250, 0.0107421875000000, -0.0047302246093750,
0.0168151855468750, -0.0096435546875000, 0.0417480468750000, -0.0148925781250000,
0.0332336425781250, -0.0101623535156250, 0.0245666503906250, -0.0268554687500000,
0.0365905761718750, -0.0216674804687500, 0.0183410644531250, -0.0274047851562500,
-0.0084228515625000, -0.0414733886718750, 0.0072937011718750, -0.0324401855468750,
-0.0067138671875000, -0.0516662597656250, -0.0198974609375000, -0.0514526367187500,
-0.0029907226562500, -0.0520629882812500, 0.0122375488281250, -0.0643310546875000,
-0.0004882812500000, -0.0608215332031250, 0.0107421875000000, -0.0553894042968750,
0.0263366699218750, -0.0619812011718750, -0.0002746582031250, -0.0522766113281250,
-0.0205383300781250, -0.0405883789062500, 0.0004577636718750, -0.0498657226562500,
-0.0513610839843750, -0.0280456542968750, -0.0582275390625000, -0.0310363769531250,
-0.0423278808593750, -0.0248718261718750, -0.0580749511718750, -0.0075683593750000,
-0.0633239746093750, -0.0178833007812500, -0.0180053710937500, -0.0079345703125000,
-0.0267944335937500, 0.0039978027343750, -0.0180969238281250, -0.0221252441406250,
0.0163269042968750, -0.0375976562500000, 0.0034484863281250, -0.0195617675781250,
0.0184936523437500, -0.0892028808593750, 0.0201721191406250, -0.0960998535156250,
0.0264892578125000, -0.0773315429687500, 0.0348205566406250, -0.1069335937500000,
0.0274047851562500, -0.1136169433593750, 0.0567321777343750, -0.0253906250000000,
0.0523681640625000, -0.0517578125000000, 0.0585327148437500, -0.0179443359375000,
0.0792846679687500, 0.0665893554687500, 0.0712585449218750, 0.0300903320312500,
0.0924682617187500, 0.0951232910156250, 0.0856628417968750, 0.1028747558593750,
0.1073608398437500, 0.0994873046875000, 0.1299133300781250, 0.1283874511718750,
0.1104431152343750, 0.1201171875000000, 0.1891174316406250, 0.1105651855468750,
0.1777343750000000, 0.1227111816406250, 0.1921997070312500, 0.1076660156250000,
0.2556152343750000, 0.0843200683593750, 0.2303466796875000, 0.0985412597656250,
0.2253112792968750, 0.0814819335937500, 0.2597351074218750, 0.0728759765625000,
0.2004699707031250, 0.0838623046875000, 0.1472473144531250, 0.0887756347656250,
0.1937255859375000, 0.0831298828125000, 0.0442504882812500, 0.0968933105468750,
0.0614624023437500, 0.1031799316406250, 0.0268554687500000, 0.0900268554687500,
-0.0800781250000000, 0.0902404785156250, -0.0313110351562500, 0.0988464355468750,
-0.1223449707031250, 0.0451660156250000, -0.1304016113281250, 0.0628662109375000,
-0.1287841796875000, 0.0325012207031250, -0.1717834472656250, -0.0226745605468750,
-0.1587524414062500, 0.0087890625000000, -0.1589355468750000, -0.0664978027343750,
-0.1692810058593750, -0.0607910156250000, -0.1560058593750000, -0.0795898437500000,
-0.1391601562500000, -0.1272583007812500, -0.1499328613281250, -0.1007995605468750,
-0.1436157226562500, -0.1806030273437500, -0.1295166015625000, -0.1689453125000000,
-0.1529846191406250, -0.1829528808593750, -0.1945190429687500, -0.2794799804687500,
-0.2567749023437500, -0.1045227050781250, -0.2362670898437500, -0.1960449218750000,
-0.2692871093750000, -0.1592407226562500, -0.2286987304687500, -0.1919555664062500,
-0.1848449707031250, -0.2559814453125000, -0.2142028808593750, -0.2287902832031250,
-0.1399841308593750, -0.2347412109375000, -0.1477050781250000, -0.2653808593750000,
-0.1213684082031250, -0.2173461914062500, -0.0712585449218750, -0.1712036132812500,
-0.1009216308593750, -0.2088623046875000, 0.0099487304687500, -0.1230468750000000,
-0.0143737792968750, -0.1119689941406250, 0.0331726074218750, -0.1287536621093750,
0.1355285644531250, -0.1018676757812500, 0.0786132812500000, -0.0996398925781250,
0.1739501953125000, -0.1281738281250000, 0.1957092285156250, -0.1319580078125000,
0.1601257324218750, -0.1153869628906250, 0.1822814941406250, -0.1215515136718750,
0.1976928710937500, -0.1312561035156250, 0.1036376953125000, -0.0705261230468750,
0.1240844726562500, -0.0829467773437500, 0.1044311523437500, -0.0645751953125000,
0.0282287597656250, -0.0162963867187500, 0.0602722167968750, -0.0373229980468750,
0.0393676757812500, 0.0132141113281250, 0.0186462402343750, 0.0030517578125000,
0.0462646484375000, 0.0354003906250000, 0.0624694824218750, 0.0820922851562500,
0.0442504882812500, 0.0487060546875000, 0.1031799316406250, 0.1494445800781250,
0.1027221679687500, 0.1454467773437500, 0.0941467285156250, 0.1496887207031250,
0.1282958984375000, 0.2120666503906250, 0.1245117187500000, 0.1932373046875000,
0.0619812011718750, 0.1792297363281250, 0.0896911621093750, 0.1993103027343750,
0.0598144531250000, 0.1745605468750000, -0.0127868652343750, 0.1398010253906250,
0.0228271484375000, 0.1593933105468750, -0.0067749023437500, 0.1154479980468750,
-0.0252380371093750, 0.1166076660156250, -0.0121154785156250, 0.1057739257812500,
-0.0024108886718750, 0.0795898437500000, -0.0090637207031250, 0.0936889648437500,
-0.0205383300781250, 0.0462036132812500, -0.0073242187500000, 0.0529785156250000,
-0.0216064453125000, 0.0396118164062500, -0.0463562011718750, 0.0022888183593750,
-0.0317993164062500, 0.0191955566406250, -0.0508422851562500, -0.0110168457031250,
-0.0562744140625000, -0.0118103027343750, -0.0515441894531250, -0.0178527832031250,
-0.0563659667968750, -0.0352478027343750, -0.0567626953125000, -0.0256347656250000,
-0.0432128906250000, -0.0508728027343750, -0.0518798828125000, -0.0531005859375000,
-0.0395202636718750, -0.0461120605468750, -0.0191650390625000, -0.0576477050781250,
-0.0332946777343750, -0.0592346191406250, -0.0139160156250000, -0.0261230468750000,
-0.0074768066406250, -0.0356445312500000, -0.0183105468750000, -0.0246582031250000,
-0.0178527832031250, 0.0068359375000000, -0.0130004882812500, -0.0065002441406250,
-0.0375366210937500, 0.0052490234375000, -0.0327758789062500, 0.0106811523437500,
-0.0420532226562500},
{-0.1488037109375000, 0.0900268554687500, -0.1390380859375000, 0.0805358886718750,
-0.1278991699218750, 0.0834350585937500, -0.1361083984375000, 0.0891418457031250,
-0.1340637207031250, 0.0383300781250000, -0.1204833984375000, 0.0578308105468750,
-0.1478881835937500, 0.0262451171875000, -0.1683959960937500, -0.0291137695312500,
-0.1472167968750000, 0.0047607421875000, -0.2224731445312500, -0.0701293945312500,
-0.2181091308593750, -0.0682067871093750, -0.2179870605468750, -0.0743713378906250,
-0.2815246582031250, -0.1452941894531250, -0.2016296386718750, 0.0112304687500000,
-0.1210327148437500, -0.0814514160156250, -0.1589050292968750, -0.0516662597656250,
-0.1122436523437500, -0.0823059082031250, -0.0593566894531250, -0.1286315917968750,
-0.0947570800781250, -0.1052246093750000, 0.0245056152343750, -0.1766052246093750,
0.0028076171875000, -0.1683044433593750, 0.0419921875000000, -0.1797790527343750,
0.1428527832031250, -0.2362976074218750, 0.0904846191406250, -0.2143859863281250,
0.1668701171875000, -0.2037658691406250, 0.1932373046875000, -0.2324218750000000,
0.1535949707031250, -0.1901855468750000, 0.1577758789062500, -0.1394958496093750,
0.1777954101562500, -0.1752624511718750, 0.0826721191406250, -0.1066894531250000,
0.0964965820312500, -0.0934753417968750, 0.0856933593750000, -0.1106567382812500,
0.0180358886718750, -0.0957946777343750, 0.0430603027343750, -0.0907287597656250,
0.0425109863281250, -0.1102600097656250, 0.0224609375000000, -0.1179504394531250,
0.0442199707031250, -0.0980224609375000, 0.0700683593750000, -0.0940246582031250,
0.0525817871093750, -0.1073303222656250, 0.0828247070312500, -0.0468139648437500,
0.0850219726562500, -0.0552978515625000, 0.0830688476562500, -0.0404663085937500,
0.0991210937500000, 0.0018310546875000, 0.0931091308593750, -0.0167541503906250,
0.0733032226562500, 0.0326538085937500, 0.0932312011718750, 0.0210266113281250,
0.0586242675781250, 0.0518493652343750, 0.0162658691406250, 0.1007995605468750,
0.0481262207031250, 0.0679016113281250, -0.0248107910156250, 0.1490173339843750,
-0.0280761718750000, 0.1533508300781250, -0.0291137695312500, 0.1478271484375000,
-0.0613098144531250, 0.1880798339843750, -0.0507202148437500, 0.1809082031250000,
-0.0800170898437500, 0.1530456542968750, -0.0724182128906250, 0.1684265136718750,
-0.0828857421875000, 0.1484375000000000, -0.1138305664062500, 0.1122131347656250,
-0.0966186523437500, 0.1298217773437500, -0.0942687988281250, 0.0917968750000000,
-0.1158447265625000, 0.0939025878906250, -0.0841979980468750, 0.0820007324218750,
-0.0515441894531250, 0.0569152832031250, -0.0797729492187500, 0.0718994140625000,
-0.0190734863281250, 0.0269775390625000, -0.0186767578125000, 0.0310363769531250,
-0.0192260742187500, 0.0230407714843750, 0.0114746093750000, -0.0075988769531250,
-0.0003662109375000, 0.0045471191406250, 0.0002136230468750, -0.0173950195312500,
0.0119628906250000, -0.0164184570312500, -0.0101013183593750, -0.0237121582031250,
-0.0270690917968750, -0.0402526855468750, -0.0098266601562500, -0.0305175781250000,
-0.0647277832031250, -0.0488891601562500, -0.0600891113281250, -0.0548095703125000,
-0.0673217773437500, -0.0420532226562500, -0.1019287109375000, -0.0425109863281250,
-0.0861511230468750, -0.0500183105468750, -0.1040039062500000, -0.0137023925781250,
-0.1094360351562500, -0.0174865722656250, -0.1007385253906250, -0.0141601562500000,
-0.1041564941406250, 0.0099182128906250, -0.1077270507812500, 0.0029907226562500,
-0.0834350585937500, 0.0061340332031250, -0.0950622558593750, 0.0070800781250000,
-0.0769042968750000, 0.0115966796875000, -0.0512390136718750, 0.0142211914062500,
-0.0732421875000000, 0.0095825195312500, -0.0180358886718750, 0.0288696289062500,
-0.0291748046875000, 0.0296630859375000, -0.0156860351562500, 0.0252075195312500,
0.0239868164062500, 0.0345458984375000, -0.0021667480468750, 0.0353698730468750,
0.0433654785156250, 0.0121765136718750, 0.0378112792968750, 0.0178527832031250,
0.0418395996093750, 0.0101013183593750, 0.0692749023437500, -0.0115966796875000,
0.0528869628906250, -0.0031738281250000, 0.0766906738281250, -0.0106811523437500,
0.0729980468750000, -0.0158996582031250, 0.0767822265625000, -0.0104370117187500,
0.0922546386718750, -0.0071411132812500, 0.0811157226562500, -0.0098876953125000,
0.0997924804687500, -0.0031433105468750, 0.0976562500000000, -0.0020141601562500,
0.0973205566406250, -0.0031738281250000, 0.1074829101562500, -0.0010681152343750,
0.1015014648437500, -0.0009460449218750, 0.1053466796875000, -0.0036926269531250,
0.1047973632812500, -0.0028381347656250, 0.1028137207031250, -0.0034484863281250,
0.1033935546875000, -0.0061645507812500, 0.1015625000000000, -0.0049743652343750,
0.1014709472656250, -0.0032958984375000, 0.1002197265625000, -0.0061340332031250,
0.0991821289062500, -0.0012207031250000, 0.0986328125000000, 0.0034484863281250,
0.0955505371093750, -0.0012817382812500, 0.0909423828125000, 0.0115356445312500,
0.0924072265625000, 0.0105895996093750, 0.0834045410156250, 0.0106506347656250,
0.0745239257812500, 0.0185546875000000, 0.0778503417968750, 0.0160217285156250,
0.0560302734375000, 0.0134582519531250, 0.0580749511718750, 0.0167846679687500,
0.0506896972656250, 0.0128173828125000, 0.0332641601562500, 0.0070495605468750,
0.0388793945312500, 0.0109558105468750, 0.0208435058593750, 0.0045471191406250,
0.0198364257812500, 0.0039672851562500, 0.0173645019531250, 0.0035705566406250,
0.0065612792968750, 0.0011901855468750, 0.0087280273437500, 0.0022583007812500,
0.0022888183593750, -0.0040588378906250, 0.0013122558593750, -0.0010375976562500,
-0.0000610351562500, -0.0059204101562500, -0.0033264160156250, -0.0137634277343750,
-0.0024719238281250, -0.0082092285156250, -0.0089111328125000, -0.0186462402343750,
-0.0080871582031250, -0.0194702148437500, -0.0105895996093750, -0.0184631347656250,
-0.0167846679687500, -0.0225524902343750, -0.0147399902343750, -0.0217895507812500,
-0.0169372558593750, -0.0226440429687500, -0.0199279785156250, -0.0218200683593750,
-0.0170593261718750, -0.0239562988281250, -0.0162658691406250, -0.0265808105468750,
-0.0188903808593750, -0.0238647460937500, -0.0046691894531250, -0.0256958007812500,
-0.0114440917968750, -0.0303649902343750, 0.0010375976562500, -0.0190124511718750,
0.0186462402343750, -0.0139160156250000, 0.0067138671875000, -0.0223388671875000,
0.0417785644531250, 0.0191040039062500, 0.0388488769531250, 0.0055541992187500,
0.0466918945312500, 0.0290527343750000, 0.0736083984375000, 0.0695495605468750,
0.0617065429687500, 0.0433044433593750, 0.0676269531250000, 0.1090698242187500,
0.0798034667968750, 0.1021423339843750, 0.0601501464843750, 0.1132812500000000,
0.0432739257812500, 0.1597900390625000, 0.0571899414062500, 0.1380004882812500,
0.0201416015625000, 0.1585388183593750, 0.0184631347656250, 0.1728515625000000,
0.0153808593750000, 0.1491394042968750, -0.0034484863281250, 0.1404418945312500,
0.0040283203125000, 0.1565856933593750, -0.0075378417968750, 0.0973815917968750,
-0.0131835937500000, 0.1050720214843750, -0.0017700195312500, 0.0977783203125000,
0.0018920898437500, 0.0567626953125000, -0.0069885253906250, 0.0718688964843750,
0.0147094726562500, 0.0611572265625000, 0.0204162597656250, 0.0567321777343750,
0.0082092285156250, 0.0527038574218750, 0.0084838867187500, 0.0527343750000000,
0.0157775878906250, 0.0570373535156250, -0.0083007812500000, 0.0144653320312500,
-0.0085449218750000, 0.0299072265625000, -0.0065917968750000, 0.0102233886718750,
-0.0160522460937500, -0.0341186523437500, -0.0146179199218750, -0.0094604492187500,
-0.0191345214843750, -0.0428771972656250, -0.0131530761718750, -0.0502319335937500,
-0.0257568359375000, -0.0490722656250000, -0.0375061035156250, -0.0563049316406250,
-0.0263366699218750, -0.0534667968750000, -0.0642395019531250, -0.0835266113281250,
-0.0592651367187500, -0.0696411132812500, -0.0662841796875000, -0.0914611816406250,
-0.0979003906250000, -0.1390991210937500, -0.0952148437500000, -0.1315307617187500,
-0.1109619140625000, -0.1639099121093750, -0.1069946289062500, -0.1622314453125000,
-0.1089782714843750, -0.1551208496093750, -0.1198120117187500, -0.1706848144531250,
-0.1135559082031250, -0.1693420410156250, -0.1255187988281250, -0.1500549316406250,
-0.1258544921875000, -0.1559753417968750, -0.1228942871093750, -0.1430053710937500,
-0.1292419433593750, -0.1231079101562500, -0.1287231445312500, -0.1338195800781250,
-0.1136169433593750, -0.1007690429687500, -0.1219787597656250, -0.1027221679687500,
-0.1082153320312500, -0.0966186523437500, -0.0886230468750000, -0.0760803222656250,
-0.1019592285156250, -0.0835876464843750, -0.0658569335937500, -0.0571899414062500,
-0.0703430175781250, -0.0643005371093750, -0.0600585937500000, -0.0469055175781250,
-0.0344238281250000, -0.0170898437500000, -0.0485229492187500, -0.0346069335937500,
-0.0145874023437500, -0.0016479492187500, -0.0196533203125000, 0.0058593750000000,
-0.0089416503906250, -0.0022277832031250, 0.0161743164062500, 0.0046081542968750,
0.0015869140625000, 0.0076293945312500, 0.0382385253906250, -0.0012817382812500,
0.0333862304687500, -0.0021667480468750, 0.0459594726562500, -0.0002441406250000,
0.0740356445312500, -0.0039062500000000, 0.0587463378906250, -0.0033874511718750,
0.0968017578125000, 0.0079650878906250, 0.0928039550781250, -0.0002136230468750,
0.1028442382812500, 0.0161132812500000, 0.1293029785156250, 0.0357360839843750,
0.1151733398437500, 0.0208129882812500, 0.1493530273437500, 0.0592041015625000,
0.1473693847656250, 0.0612182617187500, 0.1484069824218750, 0.0561523437500000,
0.1720581054687500, 0.0736389160156250, 0.1639404296875000, 0.0711669921875000,
0.1485900878906250, 0.0509338378906250, 0.1696777343750000, 0.0585937500000000,
0.1324157714843750, 0.0461425781250000, 0.0959167480468750, 0.0223388671875000,
0.1296691894531250, 0.0334167480468750, 0.0239257812500000, 0.0150146484375000,
0.0398864746093750, 0.0106201171875000, 0.0238952636718750, 0.0122985839843750,
-0.0519714355468750, 0.0061035156250000, -0.0179748535156250, 0.0065612792968750,
-0.0462646484375000, 0.0097351074218750, -0.0621643066406250, 0.0074462890625000,
-0.0434570312500000, 0.0090332031250000, -0.0381469726562500, 0.0134887695312500,
-0.0491638183593750, 0.0113525390625000, -0.0221557617187500, 0.0115051269531250,
-0.0212402343750000, 0.0121459960937500, -0.0241394042968750, 0.0110778808593750,
-0.0126953125000000, 0.0088806152343750, -0.0140991210937500, 0.0090026855468750,
-0.0171508789062500, 0.0141601562500000, -0.0170288085937500, 0.0102233886718750,
-0.0143737792968750, 0.0178527832031250, -0.0151672363281250, 0.0269775390625000,
-0.0171203613281250, 0.0212707519531250, -0.0065612792968750, 0.0433349609375000,
-0.0087890625000000, 0.0417175292968750, -0.0062866210937500, 0.0475158691406250,
0.0018005371093750, 0.0639038085937500, -0.0019226074218750, 0.0583801269531250,
0.0044250488281250, 0.0722045898437500, 0.0036621093750000, 0.0737304687500000,
0.0064697265625000, 0.0746459960937500, 0.0112609863281250, 0.0818481445312500,
0.0072937011718750, 0.0799255371093750, 0.0165710449218750, 0.0809936523437500,
0.0166015625000000, 0.0824279785156250, 0.0149536132812500, 0.0793151855468750,
0.0200500488281250, 0.0761413574218750, 0.0195617675781250, 0.0770263671875000,
0.0110473632812500, 0.0733642578125000, 0.0152893066406250, 0.0713500976562500,
0.0095214843750000, 0.0711975097656250, -0.0010375976562500, 0.0699462890625000,
0.0050354003906250},
{-0.0961303710937500, -0.1283874511718750, -0.0844421386718750, -0.1358642578125000,
-0.1016235351562500, -0.1091918945312500, -0.1016235351562500, -0.1133117675781250,
-0.1033935546875000, -0.1016540527343750, -0.1128234863281250, -0.0785217285156250,
-0.1074523925781250, -0.0904541015625000, -0.1177062988281250, -0.0618591308593750,
-0.1186218261718750, -0.0642395019531250, -0.1149597167968750, -0.0502319335937500,
-0.1195678710937500, -0.0280456542968750, -0.1202392578125000, -0.0417480468750000,
-0.1032409667968750, 0.0052185058593750, -0.1109008789062500, 0.0056152343750000,
-0.0981445312500000, 0.0013122558593750, -0.0787353515625000, 0.0259704589843750,
-0.0916748046875000, 0.0238342285156250, -0.0575561523437500, 0.0031433105468750,
-0.0624084472656250, 0.0082397460937500, -0.0526428222656250, 0.0086364746093750,
-0.0282897949218750, -0.0071105957031250, -0.0421142578125000, -0.0047302246093750,
-0.0085144042968750, 0.0093688964843750, -0.0128479003906250, 0.0004577636718750,
-0.0010681152343750, 0.0141601562500000, 0.0242919921875000, 0.0339660644531250,
0.0097656250000000, 0.0205383300781250, 0.0476684570312500, 0.0533447265625000,
0.0429382324218750, 0.0554809570312500, 0.0535888671875000, 0.0487976074218750,
0.0808105468750000, 0.0628662109375000, 0.0659790039062500, 0.0621032714843750,
0.1005249023437500, 0.0364379882812500, 0.0969543457031250, 0.0450134277343750,
0.1052246093750000, 0.0325012207031250, 0.1296081542968750, 0.0052490234375000,
0.1170654296875000, 0.0180969238281250, 0.1434020996093750, -0.0001831054687500,
0.1442565917968750, -0.0060424804687500, 0.1393127441406250, -0.0024719238281250,
0.1541137695312500, -0.0053100585937500, 0.1522827148437500, -0.0061340332031250,
0.1224365234375000, -0.0051879882812500, 0.1439208984375000, -0.0054626464843750,
0.1084289550781250, -0.0052185058593750, 0.0632934570312500, -0.0058288574218750,
0.0993652343750000, -0.0067443847656250, 0.0075073242187500, 0.0000915527343750,
0.0174560546875000, -0.0038146972656250, 0.0092773437500000, 0.0040283203125000,
-0.0510559082031250, 0.0131835937500000, -0.0258483886718750, 0.0067138671875000,
-0.0417480468750000, 0.0325317382812500, -0.0558776855468750, 0.0274658203125000,
-0.0400390625000000, 0.0383605957031250, -0.0302429199218750, 0.0609436035156250,
-0.0409545898437500, 0.0485534667968750, -0.0192260742187500, 0.0741271972656250,
-0.0169982910156250, 0.0755615234375000, -0.0202331542968750, 0.0725097656250000,
-0.0127868652343750, 0.0841369628906250, -0.0130920410156250, 0.0805053710937500,
-0.0153808593750000, 0.0676574707031250, -0.0163269042968750, 0.0737304687500000,
-0.0127258300781250, 0.0597229003906250, -0.0117492675781250, 0.0407104492187500,
-0.0146179199218750, 0.0486755371093750, -0.0039062500000000, 0.0150146484375000,
-0.0053405761718750, 0.0160522460937500, -0.0039062500000000, 0.0038757324218750,
0.0029296875000000, -0.0224609375000000, -0.0000305175781250, -0.0137634277343750,
0.0052795410156250, -0.0419616699218750, 0.0042114257812500, -0.0458679199218750,
0.0066528320312500, -0.0509948730468750, 0.0113220214843750, -0.0671997070312500,
0.0077209472656250, -0.0637512207031250, 0.0137329101562500, -0.0737609863281250,
0.0148620605468750, -0.0763549804687500, 0.0113220214843750, -0.0792236328125000,
0.0126647949218750, -0.0851135253906250, 0.0143127441406250, -0.0835571289062500,
0.0023193359375000, -0.0878601074218750, 0.0053710937500000, -0.0916137695312500,
0.0019836425781250, -0.0884704589843750, -0.0090942382812500, -0.0879211425781250,
-0.0036010742187500, -0.0915222167968750, -0.0043334960937500, -0.0784301757812500,
-0.0104980468750000, -0.0829467773437500, 0.0001525878906250, -0.0775756835937500,
0.0093383789062500, -0.0659179687500000, 0.0011596679687500, -0.0734558105468750,
0.0253601074218750, -0.0566406250000000, 0.0268554687500000, -0.0609741210937500,
0.0218811035156250, -0.0522460937500000, 0.0329284667968750, -0.0375366210937500,
0.0329284667968750, -0.0471496582031250, 0.0092773437500000, -0.0141296386718750,
0.0156555175781250, -0.0204772949218750, 0.0095214843750000, -0.0104980468750000,
-0.0136413574218750, 0.0159301757812500, -0.0058593750000000, 0.0016479492187500,
-0.0003051757812500, 0.0259094238281250, -0.0085449218750000, 0.0262145996093750,
-0.0023498535156250, 0.0278015136718750, 0.0141906738281250, 0.0401000976562500,
0.0083007812500000, 0.0342712402343750, -0.0056457519531250, 0.0467529296875000,
0.0056762695312500, 0.0452575683593750, -0.0115966796875000, 0.0466003417968750,
-0.0402832031250000, 0.0561218261718750, -0.0248107910156250, 0.0516052246093750,
-0.0365600585937500, 0.0491943359375000, -0.0496520996093750, 0.0581970214843750,
-0.0323486328125000, 0.0426025390625000, -0.0182495117187500, 0.0290832519531250,
-0.0301208496093750, 0.0422058105468750, -0.0033264160156250, -0.0028991699218750,
-0.0007019042968750, 0.0040588378906250, -0.0007629394531250, -0.0081787109375000,
0.0090332031250000, -0.0428771972656250, 0.0060424804687500, -0.0265197753906250,
0.0195312500000000, -0.0574035644531250, 0.0145263671875000, -0.0609436035156250,
0.0234985351562500, -0.0568847656250000, 0.0396118164062500, -0.0701904296875000,
0.0305175781250000, -0.0692138671875000, 0.0486145019531250, -0.0559692382812500,
0.0475769042968750, -0.0589294433593750, 0.0556945800781250, -0.0603942871093750,
0.0660705566406250, -0.0487670898437500, 0.0576477050781250, -0.0491638183593750,
0.1008605957031250, -0.0729980468750000, 0.0879516601562500, -0.0649414062500000,
0.1102905273437500, -0.0746154785156250, 0.1571655273437500, -0.1005249023437500,
0.1320190429687500, -0.0913696289062500, 0.1640014648437500, -0.0998229980468750,
0.1801452636718750, -0.1030883789062500, 0.1527404785156250, -0.1072692871093750,
0.1478576660156250, -0.1129150390625000, 0.1626586914062500, -0.1078186035156250,
0.0805664062500000, -0.1132202148437500, 0.0980224609375000, -0.1263732910156250,
0.0659179687500000, -0.1004333496093750, -0.0054016113281250, -0.0804138183593750,
0.0300598144531250, -0.1030883789062500, -0.0456848144531250, -0.0475769042968750,
-0.0483093261718750, -0.0418395996093750, -0.0534362792968750, -0.0520019531250000,
-0.0948486328125000, -0.0366821289062500, -0.0799865722656250, -0.0353698730468750,
-0.0962219238281250, -0.0347595214843750, -0.1032409667968750, -0.0482482910156250,
-0.0980224609375000, -0.0219421386718750, -0.0977172851562500, 0.0019836425781250,
-0.1014099121093750, -0.0207214355468750, -0.1060791015625000, 0.0410766601562500,
-0.0971679687500000, 0.0383605957031250, -0.1165466308593750, 0.0448608398437500,
-0.1334533691406250, 0.0816955566406250, -0.1175537109375000, 0.0670471191406250,
-0.1720886230468750, 0.0870666503906250, -0.1674194335937500, 0.0928344726562500,
-0.1731262207031250, 0.0865173339843750, -0.2104187011718750, 0.0909423828125000,
-0.1968688964843750, 0.0928955078125000, -0.1952514648437500, 0.0778808593750000,
-0.2086486816406250, 0.0800476074218750, -0.1876220703125000, 0.0796508789062500,
-0.1679687500000000, 0.0693054199218750, -0.1828002929687500, 0.0718078613281250,
-0.1306457519531250, 0.0767822265625000, -0.1390380859375000, 0.0758972167968750,
-0.1207885742187500, 0.0725097656250000, -0.0464782714843750, 0.0726623535156250,
0.0785522460937500, 0.0678710937500000, 0.1388549804687500, 0.0690307617187500,
0.1553039550781250, 0.0703735351562500, 0.1174011230468750, 0.0621948242187500,
0.1020507812500000, 0.0644226074218750, 0.1303405761718750, 0.0700988769531250,
0.0500183105468750, 0.0205078125000000, 0.0500183105468750, 0.0390319824218750,
0.0546569824218750, 0.0103149414062500, 0.0123901367187500, -0.0437011718750000,
0.0209045410156250, -0.0142822265625000, 0.0473632812500000, -0.0801086425781250,
0.0324707031250000, -0.0773010253906250, 0.0454711914062500, -0.0908508300781250,
0.0799255371093750, -0.1316528320312500, 0.0657958984375000, -0.1100769042968750,
0.0696105957031250, -0.1612243652343750, 0.0812072753906250, -0.1625366210937500,
0.0692443847656250, -0.1577758789062500, 0.0535888671875000, -0.1865539550781250,
0.0625915527343750, -0.1809692382812500, 0.0582275390625000, -0.1443176269531250,
0.0513916015625000, -0.1641540527343750, 0.0514831542968750, -0.1371154785156250,
0.0627441406250000, -0.0862731933593750, 0.0591735839843750, -0.1124572753906250,
0.0052490234375000, -0.0761718750000000, 0.0390930175781250, -0.0641174316406250,
-0.0116271972656250, -0.0771179199218750, -0.0934448242187500, -0.0775756835937500,
-0.0419006347656250, -0.0719299316406250, -0.1327209472656250, -0.0717773437500000,
-0.1503601074218750, -0.0844421386718750, -0.1272583007812500, -0.0617370605468750,
-0.1518554687500000, -0.0404052734375000, -0.1560974121093750, -0.0584411621093750,
-0.1047058105468750, -0.0067443847656250, -0.1222534179687500, -0.0096435546875000,
-0.0987854003906250, 0.0003356933593750, -0.0476989746093750, 0.0306701660156250,
-0.0776367187500000, 0.0164489746093750, -0.0361633300781250, 0.0619201660156250,
-0.0218811035156250, 0.0519409179687500, -0.0480957031250000, 0.0730895996093750,
-0.0456237792968750, 0.1181640625000000, -0.0303344726562500, 0.0952148437500000,
-0.1009521484375000, 0.1347351074218750, -0.0874023437500000, 0.1465454101562500,
-0.0984191894531250, 0.1293334960937500, -0.1534423828125000, 0.1338195800781250,
-0.1312255859375000, 0.1416931152343750, -0.1356201171875000, 0.1004028320312500,
-0.1553649902343750, 0.1069641113281250, -0.1293029785156250, 0.0964355468750000,
-0.1095581054687500, 0.0664672851562500, -0.1296081542968750, 0.0792541503906250,
-0.0529785156250000, 0.0470886230468750, -0.0703125000000000, 0.0517272949218750,
-0.0421142578125000, 0.0391845703125000, 0.0228881835937500, 0.0121765136718750,
-0.0132446289062500, 0.0270080566406250, 0.0587158203125000, -0.0040588378906250,
0.0590209960937500, -0.0050964355468750, 0.0633850097656250, -0.0065612792968750,
0.1029663085937500, -0.0214233398437500, 0.0855712890625000, -0.0156860351562500,
0.1011352539062500, -0.0307006835937500, 0.1098632812500000, -0.0285949707031250,
0.0984497070312500, -0.0315551757812500, 0.0973205566406250, -0.0454101562500000,
0.1044921875000000, -0.0401611328125000, 0.0747070312500000, -0.0333557128906250,
0.0840148925781250, -0.0426940917968750, 0.0693969726562500, -0.0289611816406250,
0.0429382324218750, -0.0099487304687500, 0.0617675781250000, -0.0214233398437500,
0.0171508789062500, -0.0004882812500000, 0.0238342285156250, 0.0039367675781250,
0.0130615234375000, 0.0008544921875000, -0.0187377929687500, 0.0046997070312500,
-0.0009765625000000, 0.0046691894531250, -0.0373840332031250, 0.0126342773437500,
-0.0363159179687500, 0.0078735351562500, -0.0416259765625000, 0.0156860351562500,
-0.0642395019531250, 0.0299682617187500, -0.0543212890625000, 0.0227050781250000,
-0.0713195800781250, 0.0285644531250000, -0.0722351074218750, 0.0366821289062500,
-0.0742492675781250, 0.0243530273437500, -0.0838317871093750, 0.0141601562500000,
-0.0809020996093750, 0.0225219726562500, -0.0916442871093750, -0.0014953613281250,
-0.0921020507812500, -0.0041198730468750, -0.0940856933593750, -0.0010375976562500,
-0.1014709472656250, -0.0107727050781250, -0.0997924804687500, -0.0105590820312500,
-0.1014709472656250, -0.0000915527343750, -0.1041564941406250, -0.0038146972656250,
-0.1014404296875000, 0.0000610351562500, -0.0991516113281250, 0.0104370117187500,
-0.1016235351562500, 0.0056152343750000, -0.0955505371093750, 0.0103149414062500,
-0.0962829589843750},
{0.0200805664062500, -0.1491088867187500, 0.0488281250000000, -0.1536560058593750,
-0.0033264160156250, -0.1438598632812500, -0.0695190429687500, -0.1605834960937500,
-0.0188903808593750, -0.1614990234375000, -0.1239624023437500, -0.1174621582031250,
-0.1365356445312500, -0.1321716308593750, -0.1119995117187500, -0.1116027832031250,
-0.1476745605468750, -0.0642395019531250, -0.1522521972656250, -0.0866699218750000,
-0.0946655273437500, -0.0627441406250000, -0.1069641113281250, -0.0518188476562500,
-0.0971374511718750, -0.0602111816406250, -0.0526428222656250, -0.0640258789062500,
-0.0710754394531250, -0.0601806640625000, -0.0668029785156250, -0.0488891601562500,
-0.0494384765625000, -0.0616149902343750, -0.0762329101562500, -0.0413818359375000,
-0.0983886718750000, -0.0155944824218750, -0.0759277343750000, -0.0329589843750000,
-0.1331176757812500, 0.0125427246093750, -0.1331481933593750, 0.0101318359375000,
-0.1286010742187500, 0.0200805664062500, -0.1603698730468750, 0.0476684570312500,
-0.1544799804687500, 0.0343933105468750, -0.1244201660156250, 0.0782470703125000,
-0.1477661132812500, 0.0710144042968750, -0.1166992187500000, 0.0854797363281250,
-0.0710449218750000, 0.1245117187500000, -0.1039733886718750, 0.1065063476562500,
-0.0320434570312500, 0.1253356933593750, -0.0359191894531250, 0.1388549804687500,
-0.0263366699218750, 0.1197509765625000, 0.0183105468750000, 0.1099243164062500,
-0.0020751953125000, 0.1215209960937500, 0.0292968750000000, 0.0820007324218750,
0.0331420898437500, 0.0853881835937500, 0.0321655273437500, 0.0763854980468750,
0.0447082519531250, 0.0509643554687500, 0.0401611328125000, 0.0627136230468750,
0.0478820800781250, 0.0297241210937500, 0.0480651855468750, 0.0347595214843750,
0.0486145019531250, 0.0240783691406250, 0.0543518066406250, -0.0028076171875000,
0.0530395507812500, 0.0108947753906250, 0.0502319335937500, -0.0136108398437500,
0.0551757812500000, -0.0153503417968750, 0.0482482910156250, -0.0172729492187500,
0.0413818359375000, -0.0287170410156250, 0.0480041503906250, -0.0234680175781250,
0.0248107910156250, -0.0379638671875000, 0.0301208496093750, -0.0380859375000000,
0.0213623046875000, -0.0357055664062500, 0.0017700195312500, -0.0446777343750000,
0.0128784179687500, -0.0439453125000000, -0.0112915039062500, -0.0249938964843750,
-0.0096130371093750, -0.0317993164062500, -0.0140075683593750, -0.0229492187500000,
-0.0288696289062500, -0.0015258789062500, -0.0205688476562500, -0.0104064941406250,
-0.0373535156250000, -0.0027770996093750, -0.0347595214843750, 0.0015563964843750,
-0.0390014648437500, 0.0002136230468750, -0.0510559082031250, -0.0017395019531250,
-0.0432128906250000, -0.0014953613281250, -0.0571594238281250, 0.0110473632812500,
-0.0560607910156250, 0.0060729980468750, -0.0576782226562500, 0.0132751464843750,
-0.0660095214843750, 0.0291442871093750, -0.0610656738281250, 0.0222473144531250,
-0.0678405761718750, 0.0280151367187500, -0.0662841796875000, 0.0328979492187500,
-0.0686035156250000, 0.0255432128906250, -0.0734558105468750, 0.0203247070312500,
-0.0691528320312500, 0.0239257812500000, -0.0800781250000000, 0.0116882324218750,
-0.0780944824218750, 0.0115661621093750, -0.0805969238281250, 0.0104370117187500,
-0.0890197753906250, 0.0037231445312500, -0.0845947265625000, 0.0061950683593750,
-0.0904541015625000, 0.0035095214843750, -0.0910644531250000, 0.0031127929687500,
-0.0900573730468750, 0.0031433105468750, -0.0914611816406250, 0.0024719238281250,
-0.0905761718750000, 0.0031127929687500, -0.0927734375000000, 0.0000000000000000,
-0.0907592773437500, 0.0016784667968750, -0.0930786132812500, -0.0016174316406250,
-0.0965881347656250, -0.0056762695312500, -0.0936279296875000, -0.0022277832031250,
-0.1002502441406250, -0.0112915039062500, -0.1001892089843750, -0.0104980468750000,
-0.1001586914062500, -0.0114746093750000, -0.1038818359375000, -0.0172119140625000,
-0.1024780273437500, -0.0148315429687500, -0.1012268066406250, -0.0173645019531250,
-0.1030883789062500, -0.0178222656250000, -0.1007995605468750, -0.0180664062500000,
-0.0983886718750000, -0.0190734863281250, -0.1003417968750000, -0.0182189941406250,
-0.0917968750000000, -0.0202636718750000, -0.0950622558593750, -0.0209960937500000,
-0.0856933593750000, -0.0181884765625000, -0.0751037597656250, -0.0189208984375000,
-0.0817871093750000, -0.0203857421875000, -0.0508728027343750, -0.0053100585937500,
-0.0559692382812500, -0.0131530761718750, -0.0420532226562500, 0.0009155273437500,
-0.0147399902343750, 0.0189514160156250, -0.0273742675781250, 0.0049438476562500,
0.0078430175781250, 0.0491027832031250, 0.0084533691406250, 0.0392761230468750,
0.0135498046875000, 0.0555419921875000, 0.0360717773437500, 0.0927429199218750,
0.0286560058593750, 0.0705871582031250, 0.0349731445312500, 0.1129150390625000,
0.0420532226562500, 0.1159973144531250, 0.0304870605468750, 0.1098937988281250,
0.0246887207031250, 0.1295471191406250, 0.0316467285156250, 0.1271667480468750,
-0.0055847167968750, 0.1043701171875000, 0.0002136230468750, 0.1162414550781250,
-0.0109558105468750, 0.1017761230468750, -0.0431213378906250, 0.0734863281250000,
-0.0306396484375000, 0.0896606445312500, -0.0424499511718750, 0.0658264160156250,
-0.0502624511718750, 0.0615539550781250, -0.0426940917968750, 0.0640563964843750,
-0.0406188964843750, 0.0586242675781250, -0.0437316894531250, 0.0592041015625000,
-0.0218505859375000, 0.0445251464843750, -0.0287475585937500, 0.0559082031250000,
-0.0172729492187500, 0.0350952148437500, 0.0074768066406250, 0.0097656250000000,
-0.0047607421875000, 0.0304260253906250, 0.0083007812500000, -0.0209655761718750,
0.0129089355468750, -0.0201110839843750, 0.0132446289062500, -0.0219421386718750,
0.0148315429687500, -0.0494384765625000, 0.0115966796875000, -0.0407409667968750,
0.0249328613281250, -0.0539550781250000, 0.0257873535156250, -0.0502319335937500,
0.0213623046875000, -0.0650939941406250, 0.0249633789062500, -0.0798034667968750,
0.0273742675781250, -0.0657653808593750, 0.0206604003906250, -0.1184692382812500,
0.0174865722656250, -0.1108703613281250, 0.0225524902343750, -0.1173400878906250,
0.0250854492187500, -0.1555786132812500, 0.0214538574218750, -0.1407775878906250,
0.0282287597656250, -0.1443481445312500, 0.0307006835937500, -0.1564941406250000,
0.0274658203125000, -0.1433410644531250, 0.0271606445312500, -0.1300659179687500,
0.0292358398437500, -0.1398620605468750, 0.0252990722656250, -0.1158752441406250,
0.0257873535156250, -0.1192016601562500, 0.0238647460937500, -0.1071472167968750,
0.0214538574218750, -0.0841369628906250, 0.0211181640625000, -0.0867309570312500,
0.0049438476562500, -0.0408020019531250, 0.0128479003906250, -0.0568237304687500,
0.0064086914062500, -0.0481567382812500, -0.0078735351562500, -0.0086364746093750,
0.0018920898437500, -0.0231018066406250, -0.0253601074218750, 0.0055236816406250,
-0.0188598632812500, 0.0075073242187500, -0.0299377441406250, 0.0144653320312500,
-0.0529479980468750, 0.0325317382812500, -0.0379943847656250, 0.0227661132812500,
-0.0701904296875000, 0.0375061035156250, -0.0685424804687500, 0.0466308593750000,
-0.0715332031250000, 0.0306091308593750, -0.0910034179687500, 0.0214538574218750,
-0.0829162597656250, 0.0336303710937500, -0.0942077636718750, 0.0114440917968750,
-0.0951232910156250, 0.0024414062500000, -0.0962524414062500, 0.0166931152343750,
-0.1026000976562500, 0.0220947265625000, -0.0994262695312500, 0.0130004882812500,
-0.1022949218750000, 0.0284118652343750, -0.1057739257812500, 0.0343017578125000,
-0.0995178222656250, 0.0268554687500000, -0.0971984863281250, 0.0252380371093750,
-0.1024780273437500, 0.0285949707031250, -0.0811462402343750, 0.0180053710937500,
-0.0874633789062500, 0.0198974609375000, -0.0772705078125000, 0.0144348144531250,
-0.0575561523437500, 0.0049743652343750, -0.0690307617187500, 0.0111999511718750,
-0.0395202636718750, -0.0012817382812500, -0.0440979003906250, -0.0009155273437500,
-0.0341491699218750, -0.0030822753906250, -0.0124206542968750, -0.0104980468750000,
-0.0255432128906250, -0.0057067871093750, 0.0099182128906250, -0.0124816894531250,
0.0035705566406250, -0.0154724121093750, 0.0162353515625000, -0.0091857910156250,
0.0448913574218750, -0.0082702636718750, 0.0283508300781250, -0.0119628906250000,
0.0642700195312500, 0.0066833496093750, 0.0612487792968750, 0.0017700195312500,
0.0680541992187500, 0.0124511718750000, 0.0913696289062500, 0.0320739746093750,
0.0793151855468750, 0.0208740234375000, 0.1048583984375000, 0.0396118164062500,
0.1028747558593750, 0.0461120605468750, 0.1065368652343750, 0.0349731445312500,
0.1236267089843750, 0.0357055664062500, 0.1152648925781250, 0.0405273437500000,
0.1239013671875000, 0.0066223144531250, 0.1289978027343750, 0.0128784179687500,
0.1170043945312500, -0.0039978027343750, 0.1159057617187500, -0.0354614257812500,
0.1235351562500000, -0.0212097167968750, 0.0788574218750000, -0.0602722167968750,
0.0960083007812500, -0.0609436035156250, 0.0694274902343750, -0.0672912597656250,
0.0223999023437500, -0.0912475585937500, 0.0536804199218750, -0.0822448730468750,
-0.0120849609375000, -0.0970153808593750, -0.0123596191406250, -0.1001586914062500,
-0.0110778808593750, -0.0970153808593750, -0.0459289550781250, -0.1012878417968750,
-0.0353393554687500, -0.1006164550781250, -0.0320739746093750, -0.0927429199218750,
-0.0412292480468750, -0.0954284667968750, -0.0315856933593750, -0.0908203125000000,
-0.0179138183593750, -0.0830383300781250, -0.0261230468750000, -0.0873718261718750,
-0.0148010253906250, -0.0755615234375000, -0.0114440917968750, -0.0773620605468750,
-0.0144653320312500, -0.0749816894531250, -0.0130920410156250, -0.0671081542968750,
-0.0119628906250000, -0.0719909667968750, -0.0123291015625000, -0.0638122558593750,
-0.0144958496093750, -0.0652160644531250, -0.0106506347656250, -0.0641174316406250,
-0.0077819824218750, -0.0593261718750000, -0.0110168457031250, -0.0630187988281250,
-0.0001831054687500, -0.0554199218750000, -0.0025939941406250, -0.0578918457031250,
0.0025024414062500, -0.0553894042968750, 0.0118408203125000, -0.0485839843750000,
0.0064086914062500, -0.0533142089843750, 0.0224914550781250, -0.0474548339843750,
0.0213012695312500, -0.0467529296875000, 0.0233764648437500, -0.0495910644531250,
0.0351562500000000, -0.0487670898437500, 0.0302124023437500, -0.0484619140625000,
0.0263977050781250, -0.0522155761718750, 0.0342407226562500, -0.0517883300781250,
0.0216674804687500, -0.0514831542968750, 0.0071105957031250, -0.0532531738281250,
0.0178222656250000, -0.0521850585937500, -0.0058898925781250, -0.0513000488281250,
-0.0095825195312500, -0.0521240234375000, -0.0028686523437500, -0.0502319335937500,
-0.0083618164062500, -0.0493774414062500, -0.0105590820312500, -0.0510864257812500,
-0.0005187988281250, -0.0422363281250000, 0.0033264160156250, -0.0470275878906250,
-0.0073852539062500, -0.0395507812500000, -0.0100402832031250, -0.0296020507812500,
-0.0025634765625000, -0.0381469726562500, -0.0325622558593750, -0.0131530761718750,
-0.0330200195312500, -0.0211791992187500, -0.0286560058593750, -0.0084838867187500,
-0.0434265136718750, 0.0140686035156250, -0.0428466796875000, -0.0027465820312500,
-0.0220031738281250, 0.0379943847656250, -0.0270385742187500, 0.0328063964843750,
-0.0193481445312500, 0.0349121093750000, -0.0007934570312500, 0.0620727539062500,
-0.0082397460937500, 0.0504760742187500, 0.0058593750000000, 0.0494995117187500,
0.0050354003906250, 0.0596923828125000, 0.0113830566406250, 0.0444335937500000,
0.0225830078125000},
{-0.0252990722656250, 0.0202331542968750, -0.0032958984375000, 0.0437316894531250,
-0.0176391601562500, 0.0331420898437500, 0.0190429687500000, 0.0414123535156250,
0.0128784179687500, 0.0498352050781250, 0.0234375000000000, 0.0346374511718750,
0.0509338378906250, 0.0271606445312500, 0.0351562500000000, 0.0371704101562500,
0.0689086914062500, -0.0057067871093750, 0.0659790039062500, 0.0009460449218750,
0.0716247558593750, -0.0133972167968750, 0.0934143066406250, -0.0491943359375000,
0.0822143554687500, -0.0339660644531250, 0.1025390625000000, -0.0635986328125000,
0.1019287109375000, -0.0671081542968750, 0.1027832031250000, -0.0672912597656250,
0.1151123046875000, -0.0798645019531250, 0.1100158691406250, -0.0758972167968750,
0.1107482910156250, -0.0834655761718750, 0.1179504394531250, -0.0830078125000000,
0.1040039062500000, -0.0849914550781250, 0.0957031250000000, -0.0906982421875000,
0.1066284179687500, -0.0882568359375000, 0.0590515136718750, -0.0940246582031250,
0.0729370117187500, -0.0942077636718750, 0.0518798828125000, -0.0950012207031250,
0.0076293945312500, -0.0988464355468750, 0.0343627929687500, -0.0975036621093750,
-0.0170898437500000, -0.0975646972656250, -0.0203552246093750, -0.0996704101562500,
-0.0158691406250000, -0.0959472656250000, -0.0392761230468750, -0.0929565429687500,
-0.0341796875000000, -0.0952148437500000, -0.0247497558593750, -0.0836181640625000,
-0.0309753417968750, -0.0853881835937500, -0.0252990722656250, -0.0797119140625000,
-0.0131225585937500, -0.0695495605468750, -0.0191650390625000, -0.0741271972656250,
-0.0119323730468750, -0.0583801269531250, -0.0101623535156250, -0.0589294433593750,
-0.0101013183593750, -0.0527038574218750, -0.0083923339843750, -0.0402832031250000,
-0.0089416503906250, -0.0458068847656250, -0.0007019042968750, -0.0324707031250000,
-0.0037536621093750, -0.0315551757812500, 0.0012512207031250, -0.0299682617187500,
0.0111083984375000, -0.0228881835937500, 0.0056152343750000, -0.0254211425781250,
0.0124206542968750, -0.0196838378906250, 0.0152587890625000, -0.0197448730468750,
0.0099792480468750, -0.0173034667968750, 0.0082397460937500, -0.0126647949218750,
0.0108642578125000, -0.0148620605468750, 0.0022277832031250, -0.0094604492187500,
0.0003051757812500, -0.0076293945312500, 0.0046081542968750, -0.0104370117187500,
0.0034790039062500, -0.0093994140625000, 0.0007629394531250, -0.0074157714843750,
0.0124206542968750, -0.0180664062500000, 0.0143737792968750, -0.0132446289062500,
0.0068664550781250, -0.0184936523437500, 0.0101623535156250, -0.0288391113281250,
0.0143432617187500, -0.0215454101562500, -0.0179138183593750, -0.0382385253906250,
-0.0118103027343750, -0.0347290039062500, -0.0176391601562500, -0.0394592285156250,
-0.0450744628906250, -0.0519104003906250, -0.0358886718750000, -0.0438842773437500,
-0.0302429199218750, -0.0610351562500000, -0.0407409667968750, -0.0588684082031250,
-0.0277404785156250, -0.0617065429687500, -0.0090942382812500, -0.0740661621093750,
-0.0186462402343750, -0.0675659179687500, 0.0014648437500000, -0.0735168457031250,
0.0022888183593750, -0.0802001953125000, 0.0065612792968750, -0.0690917968750000,
0.0176391601562500, -0.0656433105468750, 0.0119018554687500, -0.0750427246093750,
0.0296936035156250, -0.0350952148437500, 0.0286865234375000, -0.0468750000000000,
0.0312805175781250, -0.0298156738281250, 0.0418090820312500, 0.0085144042968750,
0.0382995605468750, -0.0122070312500000, 0.0513000488281250, 0.0256042480468750,
0.0449829101562500, 0.0288696289062500, 0.0607299804687500, 0.0251159667968750,
0.0783996582031250, 0.0419921875000000, 0.0637207031250000, 0.0386962890625000,
0.1106262207031250, 0.0295410156250000, 0.1081848144531250, 0.0371704101562500,
0.1084289550781250, 0.0250244140625000, 0.1387023925781250, 0.0102539062500000,
0.1306762695312500, 0.0211181640625000, 0.1104431152343750, -0.0118408203125000,
0.1280517578125000, -0.0085754394531250, 0.1006774902343750, -0.0138854980468750,
0.0651245117187500, -0.0392150878906250, 0.0897216796875000, -0.0298461914062500,
0.0257568359375000, -0.0273742675781250, 0.0291442871093750, -0.0376892089843750,
0.0168151855468750, -0.0231323242187500, -0.0255737304687500, -0.0052185058593750,
-0.0068054199218750, -0.0161437988281250, -0.0383300781250000, 0.0062561035156250,
-0.0418090820312500, 0.0122680664062500, -0.0418090820312500, -0.0004577636718750,
-0.0550231933593750, 0.0047607421875000, -0.0511169433593750, 0.0099487304687500,
-0.0639343261718750, -0.0456848144531250, -0.0592956542968750, -0.0320434570312500,
-0.0715332031250000, -0.0498352050781250, -0.0865478515625000, -0.1002502441406250,
-0.0750122070312500, -0.0794982910156250, -0.1119384765625000, -0.1048889160156250,
-0.1090087890625000, -0.1107482910156250, -0.1134948730468750, -0.1100769042968750,
-0.1385498046875000, -0.1221008300781250, -0.1293945312500000, -0.1173095703125000,
-0.1337585449218750, -0.1045837402343750, -0.1408691406250000, -0.1218566894531250,
-0.1307067871093750, -0.0931091308593750, -0.1243896484375000, -0.0558776855468750,
-0.1304321289062500, -0.0827636718750000, -0.1010742187500000, -0.0399169921875000,
-0.1120910644531250, -0.0281677246093750, -0.0863647460937500, -0.0437927246093750,
-0.0550842285156250, -0.0423583984375000, -0.0781555175781250, -0.0356750488281250,
0.0112304687500000, -0.0429077148437500, -0.0042419433593750, -0.0555114746093750,
0.0224609375000000, -0.0333557128906250, 0.0980529785156250, -0.0167541503906250,
0.0628967285156250, -0.0339050292968750, 0.1038513183593750, 0.0202026367187500,
0.1250000000000000, 0.0164794921875000, 0.0943603515625000, 0.0207824707031250,
0.0849914550781250, 0.0535888671875000, 0.1032409667968750, 0.0420532226562500,
0.0437927246093750, 0.0540771484375000, 0.0425720214843750, 0.0555725097656250,
0.0513610839843750, 0.0577392578125000, 0.0188293457031250, 0.0704040527343750,
0.0774230957031250, 0.0460205078125000, 0.0827331542968750, 0.0557556152343750,
0.0911560058593750, 0.0527038574218750, 0.0814819335937500, 0.0599975585937500,
0.0704956054687500, 0.0660095214843750, 0.0772399902343750, 0.0603027343750000,
0.0690307617187500, 0.0783691406250000, 0.0678100585937500, 0.0801696777343750,
0.0632629394531250, 0.0739746093750000, 0.0621948242187500, 0.0799865722656250,
0.0653686523437500, 0.0827636718750000, 0.0253295898437500, 0.0636901855468750,
0.0418701171875000, 0.0658874511718750, 0.0135803222656250, 0.0646972656250000,
-0.0352172851562500, 0.0528259277343750, -0.0071411132812500, 0.0558166503906250,
-0.0635986328125000, 0.0539855957031250, -0.0693054199218750, 0.0582580566406250,
-0.0635375976562500, 0.0445556640625000, -0.0883483886718750, 0.0364685058593750,
-0.0858459472656250, 0.0475463867187500, -0.0690307617187500, -0.0036926269531250,
-0.0744018554687500, 0.0075378417968750, -0.0790405273437500, -0.0111389160156250,
-0.0633850097656250, -0.0554199218750000, -0.0630187988281250, -0.0339050292968750,
-0.1070861816406250, -0.0793457031250000, -0.0916137695312500, -0.0788269042968750,
-0.1029663085937500, -0.0865783691406250, -0.1489257812500000, -0.1155395507812500,
-0.1321411132812500, -0.1015930175781250, -0.1213684082031250, -0.1200866699218750,
-0.1433715820312500, -0.1293640136718750, -0.1143188476562500, -0.1119689941406250,
-0.0812377929687500, -0.1080932617187500, -0.1066894531250000, -0.1189270019531250,
-0.0335083007812500, -0.0715942382812500, -0.0401611328125000, -0.0769348144531250,
-0.0349426269531250, -0.0695800781250000, 0.0121154785156250, -0.0360717773437500,
-0.0051879882812500, -0.0480041503906250, 0.0010070800781250, -0.0393371582031250,
0.0081787109375000, -0.0358886718750000, 0.0051269531250000, -0.0343627929687500,
0.0007934570312500, -0.0349731445312500, 0.0015258789062500, -0.0381164550781250,
0.0086975097656250, -0.0108337402343750, 0.0032653808593750, -0.0206604003906250,
0.0107727050781250, -0.0051879882812500, 0.0216369628906250, 0.0241699218750000,
0.0130920410156250, 0.0084228515625000, 0.0299072265625000, 0.0437316894531250,
0.0310363769531250, 0.0413818359375000, 0.0271606445312500, 0.0516052246093750,
0.0346374511718750, 0.0756225585937500, 0.0339660644531250, 0.0623168945312500,
0.0173339843750000, 0.0982666015625000, 0.0271301269531250, 0.0982055664062500,
0.0105895996093750, 0.0967407226562500, -0.0118103027343750, 0.1177978515625000,
0.0049438476562500, 0.1133422851562500, -0.0372619628906250, 0.0965881347656250,
-0.0327453613281250, 0.1066589355468750, -0.0425415039062500, 0.0929565429687500,
-0.0711669921875000, 0.0701904296875000, -0.0545349121093750, 0.0828857421875000,
-0.0833129882812500, 0.0545043945312500, -0.0843200683593750, 0.0563659667968750,
-0.0803527832031250, 0.0477905273437500, -0.0944213867187500, 0.0285339355468750,
-0.0912475585937500, 0.0393371582031250, -0.0777893066406250, 0.0088806152343750,
-0.0874633789062500, 0.0111999511718750, -0.0708923339843750, 0.0055847167968750,
-0.0513000488281250, -0.0146484375000000, -0.0672302246093750, -0.0063171386718750,
-0.0208740234375000, -0.0238952636718750, -0.0285949707031250, -0.0231628417968750,
-0.0175781250000000, -0.0271606445312500, 0.0162353515625000, -0.0407409667968750,
-0.0022888183593750, -0.0346679687500000, 0.0299987792968750, -0.0365600585937500,
0.0296936035156250, -0.0449218750000000, 0.0305786132812500, -0.0311584472656250,
0.0476684570312500, -0.0186462402343750, 0.0401000976562500, -0.0291442871093750,
0.0489196777343750, -0.0007934570312500, 0.0499572753906250, 0.0012817382812500,
0.0484619140625000, -0.0009460449218750, 0.0521240234375000, 0.0110168457031250,
0.0513000488281250, 0.0093994140625000, 0.0496826171875000, 0.0063476562500000,
0.0518493652343750, 0.0061035156250000, 0.0482482910156250, 0.0091552734375000,
0.0440368652343750, 0.0098876953125000, 0.0470581054687500, 0.0080261230468750,
0.0389099121093750, 0.0157470703125000, 0.0393981933593750, 0.0171813964843750,
0.0383300781250000, 0.0139465332031250, 0.0335693359375000, 0.0163879394531250,
0.0355834960937500, 0.0182800292968750, 0.0313110351562500, 0.0046691894531250,
0.0324401855468750, 0.0083618164062500, 0.0303039550781250, 0.0030822753906250,
0.0263977050781250, -0.0098571777343750, 0.0281982421875000, -0.0038146972656250,
0.0189514160156250, -0.0125427246093750, 0.0206604003906250, -0.0145263671875000,
0.0158691406250000, -0.0129394531250000, 0.0074462890625000, -0.0149536132812500,
0.0111389160156250, -0.0147705078125000, -0.0030822753906250, -0.0144653320312500,
-0.0007324218750000, -0.0143432617187500, -0.0078125000000000, -0.0139160156250000,
-0.0199890136718750, -0.0143737792968750, -0.0142211914062500, -0.0142822265625000,
-0.0384521484375000, -0.0090332031250000, -0.0348510742187500, -0.0132141113281250,
-0.0444641113281250, -0.0048217773437500, -0.0651245117187500, 0.0033264160156250,
-0.0555419921875000, -0.0044250488281250, -0.0787658691406250, 0.0237426757812500,
-0.0795898437500000, 0.0156860351562500, -0.0817871093750000, 0.0300598144531250,
-0.0947570800781250, 0.0561218261718750, -0.0904235839843750, 0.0388183593750000,
-0.0976867675781250, 0.0793762207031250, -0.0987548828125000, 0.0771179199218750,
-0.0975646972656250, 0.0794982910156250, -0.1014099121093750, 0.1050720214843750,
-0.1004333496093750, 0.0954284667968750, -0.0910034179687500, 0.0952453613281250,
-0.0969543457031250, 0.1053771972656250, -0.0856018066406250, 0.0926208496093750,
-0.0717163085937500, 0.0791320800781250, -0.0819702148437500, 0.0904846191406250,
-0.0509948730468750},
{0.0028076171875000, 0.0270080566406250, -0.0358581542968750, 0.0575866699218750,
-0.0330505371093750, 0.0546569824218750, -0.0387573242187500, 0.0648498535156250,
-0.0629882812500000, 0.0882873535156250, -0.0520935058593750, 0.0751647949218750,
-0.0720214843750000, 0.1017456054687500, -0.0714416503906250, 0.1059570312500000,
-0.0726013183593750, 0.0973510742187500, -0.0856323242187500, 0.1056518554687500,
-0.0801696777343750, 0.1082458496093750, -0.0772094726562500, 0.0813293457031250,
-0.0843505859375000, 0.0883789062500000, -0.0737609863281250, 0.0781555175781250,
-0.0629882812500000, 0.0545043945312500, -0.0717468261718750, 0.0655822753906250,
-0.0434265136718750, 0.0403442382812500, -0.0478210449218750, 0.0425720214843750,
-0.0391235351562500, 0.0348815917968750, -0.0168151855468750, 0.0159912109375000,
-0.0274658203125000, 0.0257263183593750, -0.0046997070312500, 0.0041198730468750,
-0.0031127929687500, 0.0029602050781250, -0.0009765625000000, 0.0014343261718750,
0.0120544433593750, -0.0089721679687500, 0.0086975097656250, -0.0055541992187500,
0.0138244628906250, -0.0174255371093750, 0.0175476074218750, -0.0156860351562500,
0.0157165527343750, -0.0195312500000000, 0.0155029296875000, -0.0310974121093750,
0.0174865722656250, -0.0263671875000000, 0.0117492675781250, -0.0251464843750000,
0.0133056640625000, -0.0317077636718750, 0.0122375488281250, -0.0216674804687500,
0.0075378417968750, -0.0094299316406250, 0.0100097656250000, -0.0165710449218750,
0.0076599121093750, -0.0013732910156250, 0.0068664550781250, 0.0021972656250000,
0.0085144042968750, -0.0015869140625000, 0.0092468261718750, 0.0011596679687500,
0.0087280273437500, 0.0023803710937500, 0.0091247558593750, -0.0023803710937500,
0.0105895996093750, -0.0028076171875000, 0.0088806152343750, -0.0012512207031250,
0.0072631835937500, -0.0021362304687500, 0.0087585449218750, -0.0024108886718750,
0.0041503906250000, 0.0006408691406250, 0.0045471191406250, 0.0014648437500000,
0.0045776367187500, -0.0004577636718750, 0.0022583007812500, 0.0000610351562500,
0.0035705566406250, 0.0012512207031250, 0.0025024414062500, -0.0068359375000000,
0.0028381347656250, -0.0050964355468750, 0.0026245117187500, -0.0072937011718750,
0.0020141601562500, -0.0145874023437500, 0.0030822753906250, -0.0112915039062500,
0.0018310546875000, -0.0118713378906250, 0.0018005371093750, -0.0160827636718750,
0.0023803710937500, -0.0083923339843750, 0.0023803710937500, -0.0033874511718750,
0.0023803710937500, -0.0093078613281250, 0.0018310546875000, 0.0150756835937500,
0.0037231445312500, 0.0079040527343750, 0.0001831054687500, 0.0211791992187500,
-0.0020141601562500, 0.0439758300781250, 0.0007934570312500, 0.0284729003906250,
-0.0148620605468750, 0.0660705566406250, -0.0101928710937500, 0.0627746582031250,
-0.0205078125000000, 0.0674133300781250, -0.0376892089843750, 0.0928344726562500,
-0.0291748046875000, 0.0817871093750000, -0.0554809570312500, 0.0885925292968750,
-0.0539855957031250, 0.0967102050781250, -0.0620422363281250, 0.0858764648437500,
-0.0812072753906250, 0.0787048339843750, -0.0729980468750000, 0.0871582031250000,
-0.0955200195312500, 0.0661926269531250, -0.0972290039062500, 0.0669555664062500,
-0.0965576171875000, 0.0669250488281250, -0.1094055175781250, 0.0562438964843750,
-0.1070861816406250, 0.0592956542968750, -0.0931701660156250, 0.0533142089843750,
-0.1034240722656250, 0.0572204589843750, -0.0852050781250000, 0.0461120605468750,
-0.0618286132812500, 0.0369873046875000, -0.0775146484375000, 0.0474243164062500,
-0.0339355468750000, 0.0076904296875000, -0.0338745117187500, 0.0162048339843750,
-0.0302734375000000, 0.0044250488281250, -0.0052795410156250, -0.0289306640625000,
-0.0140380859375000, -0.0125732421875000, -0.0072326660156250, -0.0364990234375000,
-0.0029296875000000, -0.0400390625000000, -0.0093688964843750, -0.0400695800781250,
-0.0128173828125000, -0.0479431152343750, -0.0094299316406250, -0.0454406738281250,
-0.0174560546875000, -0.0643615722656250, -0.0216064453125000, -0.0543823242187500,
-0.0142211914062500, -0.0720214843750000, -0.0108642578125000, -0.0976562500000000,
-0.0163269042968750, -0.0787048339843750, -0.0033874511718750, -0.1188964843750000,
-0.0019531250000000, -0.1221008300781250, -0.0029296875000000, -0.1146545410156250,
0.0016174316406250, -0.1324157714843750, -0.0007019042968750, -0.1317749023437500,
-0.0030212402343750, -0.1033325195312500, 0.0016784667968750, -0.1167297363281250,
-0.0079650878906250, -0.0993652343750000, -0.0196533203125000, -0.0665893554687500,
-0.0117797851562500, -0.0841064453125000, -0.0217895507812500, -0.0430603027343750,
-0.0278625488281250, -0.0458984375000000, -0.0210266113281250, -0.0344543457031250,
-0.0179443359375000, -0.0078430175781250, -0.0219116210937500, -0.0241394042968750,
-0.0090026855468750, 0.0185852050781250, -0.0122070312500000, 0.0155029296875000,
-0.0054626464843750, 0.0198059082031250, 0.0061950683593750, 0.0487365722656250,
-0.0012512207031250, 0.0380554199218750, 0.0190429687500000, 0.0390319824218750,
0.0177001953125000, 0.0472717285156250, 0.0186462402343750, 0.0403137207031250,
0.0335388183593750, 0.0281372070312500, 0.0308837890625000, 0.0304565429687500,
0.0227966308593750, 0.0297851562500000, 0.0266723632812500, 0.0288391113281250,
0.0273437500000000, 0.0265502929687500, 0.0198974609375000, 0.0267333984375000,
0.0208435058593750, 0.0283203125000000, 0.0295410156250000, 0.0140686035156250,
0.0252990722656250, 0.0150146484375000, 0.0283813476562500, 0.0174560546875000,
0.0389404296875000, 0.0098266601562500, 0.0342102050781250, 0.0091247558593750,
0.0308227539062500, 0.0180358886718750, 0.0379028320312500, 0.0180358886718750,
0.0270080566406250, 0.0169067382812500, 0.0150146484375000, 0.0184326171875000,
0.0243835449218750, 0.0189208984375000, 0.0000610351562500, 0.0284729003906250,
0.0014343261718750, 0.0238647460937500, -0.0021667480468750, 0.0281982421875000,
-0.0160827636718750, 0.0427246093750000, -0.0094604492187500, 0.0376586914062500,
-0.0267028808593750, 0.0263061523437500, -0.0220336914062500, 0.0343322753906250,
-0.0308532714843750, 0.0279846191406250, -0.0472106933593750, 0.0105895996093750,
-0.0362854003906250, 0.0166015625000000, -0.0605468750000000, 0.0162658691406250,
-0.0601501464843750, 0.0108947753906250, -0.0626831054687500, 0.0168762207031250,
-0.0772094726562500, 0.0237121582031250, -0.0716247558593750, 0.0179443359375000,
-0.0788574218750000, 0.0258178710937500, -0.0801696777343750, 0.0316772460937500,
-0.0788574218750000, 0.0178222656250000, -0.0820312500000000, 0.0111083984375000,
-0.0815734863281250, 0.0205078125000000, -0.0760803222656250, -0.0132141113281250,
-0.0807800292968750, -0.0114135742187500, -0.0721130371093750, -0.0179443359375000,
-0.0625915527343750, -0.0391235351562500, -0.0709228515625000, -0.0308227539062500,
-0.0475769042968750, -0.0533447265625000, -0.0517578125000000, -0.0520935058593750,
-0.0450439453125000, -0.0583190917968750, -0.0282287597656250, -0.0751342773437500,
-0.0381164550781250, -0.0678405761718750, -0.0136108398437500, -0.0815429687500000,
-0.0190429687500000, -0.0835266113281250, -0.0090942382812500, -0.0835876464843750,
0.0108032226562500, -0.0900268554687500, -0.0026245117187500, -0.0885620117187500,
0.0307922363281250, -0.0881652832031250, 0.0249023437500000, -0.0918579101562500,
0.0336608886718750, -0.0842285156250000, 0.0582885742187500, -0.0783081054687500,
0.0437927246093750, -0.0834655761718750, 0.0715332031250000, -0.0597839355468750,
0.0699462890625000, -0.0629272460937500, 0.0731201171875000, -0.0540466308593750,
0.0899047851562500, -0.0345153808593750, 0.0816040039062500, -0.0433654785156250,
0.0940856933593750, -0.0229797363281250, 0.0959167480468750, -0.0214538574218750,
0.0928955078125000, -0.0212402343750000, 0.0981445312500000, -0.0106811523437500,
0.0978393554687500, -0.0135498046875000, 0.0852661132812500, -0.0157775878906250,
0.0938720703125000, -0.0118408203125000, 0.0785217285156250, -0.0172424316406250,
0.0604858398437500, -0.0238037109375000, 0.0752868652343750, -0.0195312500000000,
0.0292053222656250, -0.0315246582031250, 0.0367736816406250, -0.0300292968750000,
0.0258178710937500, -0.0323486328125000, -0.0087280273437500, -0.0401306152343750,
0.0095825195312500, -0.0356140136718750, -0.0156860351562500, -0.0434875488281250,
-0.0201110839843750, -0.0425415039062500, -0.0147094726562500, -0.0420227050781250,
-0.0227355957031250, -0.0460510253906250, -0.0232849121093750, -0.0428161621093750,
-0.0158081054687500, -0.0414733886718750, -0.0182800292968750, -0.0409240722656250,
-0.0169067382812500, -0.0379638671875000, -0.0110168457031250, -0.0350952148437500,
-0.0133666992187500, -0.0350341796875000, -0.0094909667968750, -0.0329284667968750,
-0.0090942382812500, -0.0302124023437500, -0.0090942382812500, -0.0301208496093750,
-0.0064086914062500, -0.0310363769531250, -0.0072631835937500, -0.0297241210937500,
-0.0114440917968750, -0.0291442871093750, -0.0078430175781250, -0.0303955078125000,
-0.0142822265625000, -0.0282592773437500, -0.0233764648437500, -0.0256347656250000,
-0.0174255371093750, -0.0278625488281250, -0.0260925292968750, -0.0261230468750000,
-0.0318603515625000, -0.0243225097656250, -0.0216979980468750, -0.0277709960937500,
-0.0173034667968750, -0.0292663574218750, -0.0239868164062500, -0.0268249511718750,
0.0018005371093750, -0.0373229980468750, -0.0001525878906250, -0.0330810546875000,
0.0037231445312500, -0.0407409667968750, 0.0203247070312500, -0.0515747070312500,
0.0146179199218750, -0.0431518554687500, 0.0257568359375000, -0.0683898925781250,
0.0261535644531250, -0.0642700195312500, 0.0283813476562500, -0.0695800781250000,
0.0360412597656250, -0.0890502929687500, 0.0335388183593750, -0.0791625976562500,
0.0384216308593750, -0.0865783691406250, 0.0380554199218750, -0.0934143066406250,
0.0440063476562500, -0.0832519531250000, 0.0471496582031250, -0.0783081054687500,
0.0430297851562500, -0.0856018066406250, 0.0738220214843750, -0.0598754882812500,
0.0650024414062500, -0.0632019042968750, 0.0791625976562500, -0.0587463378906250,
0.1116638183593750, -0.0407104492187500, 0.0958251953125000, -0.0480346679687500,
0.1135253906250000, -0.0376281738281250, 0.1254272460937500, -0.0377502441406250,
0.1069030761718750, -0.0340576171875000, 0.0999145507812500, -0.0282897949218750,
0.1113586425781250, -0.0329895019531250, 0.0628662109375000, -0.0127258300781250,
0.0717773437500000, -0.0167236328125000, 0.0552062988281250, -0.0098266601562500,
0.0154113769531250, 0.0073852539062500, 0.0354309082031250, -0.0004882812500000,
-0.0039672851562500, 0.0156860351562500, -0.0053405761718750, 0.0143737792968750,
-0.0081481933593750, 0.0201416015625000, -0.0286865234375000, 0.0340881347656250,
-0.0209350585937500, 0.0267944335937500, -0.0367126464843750, 0.0344848632812500,
-0.0342102050781250, 0.0424194335937500, -0.0435180664062500, 0.0303039550781250,
-0.0574645996093750, 0.0209655761718750, -0.0477600097656250, 0.0301208496093750,
-0.0774536132812500, 0.0122680664062500, -0.0741577148437500, 0.0102844238281250,
-0.0795593261718750, 0.0116271972656250, -0.1013793945312500, 0.0044860839843750,
-0.0925598144531250, 0.0071105957031250, -0.1011352539062500, 0.0111694335937500,
-0.1062011718750000, 0.0049743652343750, -0.1001586914062500, 0.0166015625000000,
-0.0990600585937500, 0.0320129394531250, -0.1017456054687500, 0.0211791992187500,
-0.0845031738281250, 0.0286865234375000, -0.0924377441406250, 0.0411682128906250,
-0.0732421875000000},
{0.0875854492187500, -0.0082092285156250, 0.0702819824218750, -0.0073852539062500,
0.0483093261718750, -0.0046081542968750, 0.0654296875000000, -0.0046386718750000,
0.0165405273437500, -0.0015258789062500, 0.0230102539062500, -0.0015563964843750,
0.0141906738281250, -0.0001831054687500, -0.0211486816406250, 0.0025634765625000,
-0.0046691894531250, 0.0012512207031250, -0.0217590332031250, 0.0015869140625000,
-0.0280456542968750, 0.0025939941406250, -0.0206298828125000, 0.0001525878906250,
-0.0210876464843750, -0.0018615722656250, -0.0242004394531250, -0.0005493164062500,
-0.0166320800781250, -0.0051879882812500, -0.0146789550781250, -0.0058898925781250,
-0.0202331542968750, -0.0060119628906250, -0.0207824707031250, -0.0077819824218750,
-0.0176086425781250, -0.0077209472656250, -0.0303955078125000, -0.0096435546875000,
-0.0313110351562500, -0.0086975097656250, -0.0268554687500000, -0.0113525390625000,
-0.0321044921875000, -0.0148925781250000, -0.0335693359375000, -0.0126953125000000,
-0.0131530761718750, -0.0155944824218750, -0.0191955566406250, -0.0180053710937500,
-0.0102539062500000, -0.0161743164062500, 0.0092163085937500, -0.0157165527343750,
-0.0002746582031250, -0.0183410644531250, 0.0191040039062500, -0.0142517089843750,
0.0189514160156250, -0.0156250000000000, 0.0229797363281250, -0.0150756835937500,
0.0351867675781250, -0.0122985839843750, 0.0293884277343750, -0.0148010253906250,
0.0429077148437500, -0.0114440917968750, 0.0429077148437500, -0.0091552734375000,
0.0454101562500000, -0.0151062011718750, 0.0523376464843750, -0.0151367187500000,
0.0494995117187500, -0.0109558105468750, 0.0661315917968750, -0.0380859375000000,
0.0606384277343750, -0.0266723632812500, 0.0744323730468750, -0.0402221679687500,
0.0957031250000000, -0.0681457519531250, 0.0827636718750000, -0.0490722656250000,
0.1068420410156250, -0.0795593261718750, 0.1138916015625000, -0.0833435058593750,
0.1019592285156250, -0.0762329101562500, 0.1051025390625000, -0.0867309570312500,
0.1101989746093750, -0.0867004394531250, 0.0733337402343750, -0.0704650878906250,
0.0823669433593750, -0.0757141113281250, 0.0660705566406250, -0.0675048828125000,
0.0330200195312500, -0.0536499023437500, 0.0505371093750000, -0.0615844726562500,
0.0103149414062500, -0.0320739746093750, 0.0110778808593750, -0.0415649414062500,
0.0061035156250000, -0.0220947265625000, -0.0177612304687500, 0.0100097656250000,
-0.0080871582031250, -0.0107421875000000, -0.0256958007812500, 0.0354614257812500,
-0.0244140625000000, 0.0374755859375000, -0.0318603515625000, 0.0372924804687500,
-0.0445556640625000, 0.0600891113281250, -0.0359802246093750, 0.0538024902343750,
-0.0638427734375000, 0.0567016601562500, -0.0602416992187500, 0.0600280761718750,
-0.0668640136718750, 0.0531005859375000, -0.0887145996093750, 0.0514526367187500,
-0.0793762207031250, 0.0563659667968750, -0.0899353027343750, 0.0318908691406250,
-0.0942687988281250, 0.0344543457031250, -0.0897216796875000, 0.0344848632812500,
-0.0907287597656250, 0.0198364257812500, -0.0918884277343750, 0.0234375000000000,
-0.0792541503906250, 0.0251159667968750, -0.0859069824218750, 0.0248413085937500,
-0.0699768066406250, 0.0252075195312500, -0.0540771484375000, 0.0248718261718750,
-0.0671386718750000, 0.0256958007812500, -0.0097656250000000, 0.0332946777343750,
-0.0211791992187500, 0.0327758789062500, -0.0004577636718750, 0.0278930664062500,
0.0509948730468750, 0.0332641601562500, 0.0265197753906250, 0.0372619628906250,
0.0614013671875000, 0.0092468261718750, 0.0749511718750000, 0.0135192871093750,
0.0571899414062500, 0.0104980468750000, 0.0571899414062500, -0.0070800781250000,
0.0679016113281250, -0.0018920898437500, 0.0341491699218750, -0.0177001953125000,
0.0338439941406250, -0.0101318359375000, 0.0393981933593750, -0.0275878906250000,
0.0235595703125000, -0.0513305664062500, 0.0246582031250000, -0.0344848632812500,
0.0466613769531250, -0.0718688964843750, 0.0390930175781250, -0.0765991210937500,
0.0467834472656250, -0.0741882324218750, 0.0690612792968750, -0.0899963378906250,
0.0596008300781250, -0.0862731933593750, 0.0640869140625000, -0.0754699707031250,
0.0701599121093750, -0.0871276855468750, 0.0631103515625000, -0.0686950683593750,
0.0570678710937500, -0.0442504882812500, 0.0615234375000000, -0.0623474121093750,
0.0514221191406250, -0.0320739746093750, 0.0523681640625000, -0.0258789062500000,
0.0477294921875000, -0.0346679687500000, 0.0323791503906250, -0.0289916992187500,
-0.0241394042968750, -0.0646972656250000, -0.0511779785156250, -0.0248718261718750,
-0.0505371093750000, -0.0262145996093750, -0.0488891601562500, -0.0310058593750000,
-0.0520019531250000, -0.0281066894531250, -0.0535278320312500, -0.0255126953125000,
-0.0571899414062500, -0.0235290527343750, -0.0496826171875000, -0.0329589843750000,
-0.0667419433593750, -0.0163879394531250, -0.0804138183593750, 0.0008850097656250,
-0.0652160644531250, -0.0134277343750000, -0.1163635253906250, 0.0206298828125000,
-0.1156005859375000, 0.0225219726562500, -0.1109619140625000, 0.0208740234375000,
-0.1400756835937500, 0.0348815917968750, -0.1364440917968750, 0.0314941406250000,
-0.1040954589843750, 0.0373840332031250, -0.1215515136718750, 0.0348815917968750,
-0.0963745117187500, 0.0408630371093750, -0.0583190917968750, 0.0502014160156250,
-0.0835571289062500, 0.0438232421875000, -0.0114440917968750, 0.0520019531250000,
-0.0209655761718750, 0.0575561523437500, -0.0052795410156250, 0.0481567382812500,
0.0481872558593750, 0.0435791015625000, 0.0238342285156250, 0.0499877929687500,
0.0596008300781250, 0.0302124023437500, 0.0638427734375000, 0.0304260253906250,
0.0613708496093750, 0.0295715332031250, 0.0780334472656250, 0.0204162597656250,
0.0721130371093750, 0.0233459472656250, 0.0606689453125000, 0.0119628906250000,
0.0721130371093750, 0.0180969238281250, 0.0574340820312500, 0.0045776367187500,
0.0337829589843750, -0.0120544433593750, 0.0480346679687500, 0.0005187988281250,
0.0296325683593750, -0.0361022949218750, 0.0234985351562500, -0.0335998535156250,
0.0332336425781250, -0.0403442382812500, 0.0315856933593750, -0.0642700195312500,
0.0285644531250000, -0.0539855957031250, 0.0583801269531250, -0.0742797851562500,
0.0494079589843750, -0.0752258300781250, 0.0581970214843750, -0.0747070312500000,
0.0895385742187500, -0.0870056152343750, 0.0755310058593750, -0.0838317871093750,
0.0642700195312500, -0.0720520019531250, 0.0858154296875000, -0.0819396972656250,
0.0541687011718750, -0.0656433105468750, 0.0186462402343750, -0.0434875488281250,
0.0474548339843750, -0.0579528808593750, -0.0246582031250000, -0.0252380371093750,
-0.0202636718750000, -0.0229187011718750, -0.0264892578125000, -0.0243835449218750,
-0.0696105957031250, -0.0114746093750000, -0.0520019531250000, -0.0145263671875000,
-0.0739440917968750, -0.0059204101562500, -0.0804443359375000, -0.0112304687500000,
-0.0696105957031250, 0.0005798339843750, -0.0737915039062500, 0.0146179199218750,
-0.0783081054687500, 0.0039062500000000, -0.0466308593750000, 0.0354003906250000,
-0.0547790527343750, 0.0323181152343750, -0.0429382324218750, 0.0399475097656250,
-0.0158386230468750, 0.0608215332031250, -0.0311279296875000, 0.0504150390625000,
-0.0027465820312500, 0.0786132812500000, -0.0030822753906250, 0.0752868652343750,
-0.0036621093750000, 0.0816650390625000, 0.0118103027343750, 0.1042785644531250,
0.0064392089843750, 0.0944824218750000, 0.0051574707031250, 0.0998535156250000,
0.0104370117187500, 0.1083679199218750, 0.0030822753906250, 0.0959472656250000,
-0.0038452148437500, 0.0863647460937500, 0.0027770996093750, 0.0946960449218750,
-0.0150756835937500, 0.0679931640625000, -0.0112915039062500, 0.0704040527343750,
-0.0153503417968750, 0.0628051757812500, -0.0275573730468750, 0.0446166992187500,
-0.0187683105468750, 0.0538024902343750, -0.0337524414062500, 0.0280761718750000,
-0.0309753417968750, 0.0302734375000000, -0.0310668945312500, 0.0238342285156250,
-0.0399475097656250, 0.0054931640625000, -0.0340576171875000, 0.0136718750000000,
-0.0381774902343750, -0.0044250488281250, -0.0376892089843750, -0.0028686523437500,
-0.0351562500000000, -0.0090026855468750, -0.0347595214843750, -0.0227661132812500,
-0.0323791503906250, -0.0153808593750000, -0.0313720703125000, -0.0326843261718750,
-0.0291748046875000, -0.0350036621093750, -0.0290832519531250, -0.0313415527343750,
-0.0287475585937500, -0.0375976562500000, -0.0261535644531250, -0.0379333496093750,
-0.0311584472656250, -0.0255432128906250, -0.0289306640625000, -0.0285949707031250,
-0.0296936035156250, -0.0239868164062500, -0.0339355468750000, -0.0126342773437500,
-0.0305786132812500, -0.0171508789062500, -0.0319519042968750, -0.0093994140625000,
-0.0317687988281250, -0.0086975097656250, -0.0302429199218750, -0.0068969726562500,
-0.0289611816406250, -0.0039672851562500, -0.0269775390625000, -0.0063476562500000,
-0.0269470214843750, 0.0071105957031250, -0.0257873535156250, 0.0008239746093750,
-0.0236511230468750, 0.0119628906250000, -0.0230407714843750, 0.0275268554687500,
-0.0220947265625000, 0.0156860351562500, -0.0164184570312500, 0.0480041503906250,
-0.0181274414062500, 0.0440673828125000, -0.0141296386718750, 0.0498657226562500,
-0.0071716308593750, 0.0726623535156250, -0.0093994140625000, 0.0613403320312500,
-0.0018615722656250, 0.0734863281250000, -0.0004882812500000, 0.0785217285156250,
-0.0012207031250000, 0.0714721679687500, 0.0020446777343750, 0.0711059570312500,
0.0026550292968750, 0.0750122070312500, -0.0007934570312500, 0.0616760253906250,
0.0003662109375000, 0.0631713867187500, -0.0004577636718750, 0.0621948242187500,
-0.0032958984375000, 0.0539855957031250, -0.0017395019531250, 0.0571289062500000,
-0.0034484863281250, 0.0538940429687500, -0.0030517578125000, 0.0552062988281250,
-0.0034179687500000, 0.0499572753906250, -0.0040283203125000, 0.0469055175781250,
-0.0028381347656250, 0.0517578125000000, -0.0073852539062500, 0.0262756347656250,
-0.0048217773437500, 0.0351257324218750, -0.0098571777343750, 0.0221862792968750,
-0.0145874023437500, -0.0036315917968750, -0.0096740722656250, 0.0119628906250000,
-0.0307922363281250, -0.0181579589843750, -0.0245666503906250, -0.0191955566406250,
-0.0365295410156250, -0.0198974609375000, -0.0578613281250000, -0.0344543457031250,
-0.0456542968750000, -0.0297851562500000, -0.0772094726562500, -0.0405273437500000,
-0.0791320800781250, -0.0368347167968750, -0.0773620605468750, -0.0478515625000000,
-0.0953674316406250, -0.0597229003906250, -0.0921630859375000, -0.0489501953125000,
-0.0688476562500000, -0.0860900878906250, -0.0820007324218750, -0.0797119140625000,
-0.0622253417968750, -0.0853576660156250, -0.0292663574218750, -0.1145629882812500,
-0.0473022460937500, -0.1020812988281250, -0.0106201171875000, -0.1015014648437500,
-0.0058288574218750, -0.1160888671875000, -0.0110168457031250, -0.0943603515625000,
0.0025024414062500, -0.0744018554687500, 0.0007629394531250, -0.0929870605468750,
-0.0120849609375000, -0.0426330566406250, -0.0084533691406250, -0.0458068847656250,
-0.0123596191406250, -0.0401000976562500, -0.0245666503906250, -0.0092468261718750,
-0.0200195312500000, -0.0205078125000000, -0.0207519531250000, -0.0002136230468750,
-0.0280761718750000, -0.0021972656250000, -0.0148315429687500, 0.0076293945312500,
-0.0023193359375000, 0.0240478515625000, -0.0138549804687500, 0.0121154785156250,
0.0087280273437500, 0.0411071777343750, 0.0157165527343750, 0.0430908203125000,
0.0040893554687500, 0.0350952148437500, 0.0039978027343750, 0.0468444824218750,
0.0096435546875000},
{-0.0319213867187500, -0.0075073242187500, -0.0404052734375000, -0.0013427734375000,
-0.0225830078125000, -0.0154724121093750, -0.0254516601562500, -0.0144958496093750,
-0.0214233398437500, -0.0190124511718750, -0.0090332031250000, -0.0303039550781250,
-0.0169982910156250, -0.0247802734375000, -0.0032043457031250, -0.0335388183593750,
-0.0039978027343750, -0.0372924804687500, -0.0046691894531250, -0.0305480957031250,
0.0024719238281250, -0.0304870605468750, -0.0012207031250000, -0.0340881347656250,
-0.0013122558593750, -0.0117187500000000, -0.0015563964843750, -0.0183410644531250,
-0.0039062500000000, -0.0060424804687500, -0.0062255859375000, 0.0154724121093750,
-0.0079040527343750, 0.0022888183593750, -0.0100402832031250, 0.0348205566406250,
-0.0106201171875000, 0.0313110351562500, -0.0130004882812500, 0.0377502441406250,
-0.0152893066406250, 0.0597839355468750, -0.0154724121093750, 0.0480041503906250,
-0.0209045410156250, 0.0672912597656250, -0.0205688476562500, 0.0692138671875000,
-0.0217285156250000, 0.0663146972656250, -0.0262451171875000, 0.0744628906250000,
-0.0254516601562500, 0.0734863281250000, -0.0247192382812500, 0.0668640136718750,
-0.0269775390625000, 0.0703430175781250, -0.0239257812500000, 0.0663452148437500,
-0.0204772949218750, 0.0585021972656250, -0.0232238769531250, 0.0628967285156250,
-0.0158996582031250, 0.0549926757812500, -0.0156250000000000, 0.0558776855468750,
-0.0147399902343750, 0.0515136718750000, -0.0103454589843750, 0.0463256835937500,
-0.0109863281250000, 0.0507812500000000, -0.0083618164062500, 0.0297851562500000,
-0.0083618164062500, 0.0369262695312500, -0.0060729980468750, 0.0253906250000000,
-0.0029907226562500, 0.0040893554687500, -0.0041809082031250, 0.0177612304687500,
0.0001525878906250, -0.0106201171875000, 0.0012817382812500, -0.0103149414062500,
0.0005187988281250, -0.0118408203125000, 0.0026855468750000, -0.0269775390625000,
0.0032348632812500, -0.0213012695312500, -0.0036315917968750, -0.0323791503906250,
0.0009155273437500, -0.0301818847656250, -0.0079040527343750, -0.0377502441406250,
-0.0181579589843750, -0.0470886230468750, -0.0102539062500000, -0.0393981933593750,
-0.0363464355468750, -0.0687255859375000, -0.0324401855468750, -0.0618591308593750,
-0.0430908203125000, -0.0711059570312500, -0.0653076171875000, -0.0974731445312500,
-0.0537719726562500, -0.0833740234375000, -0.0785827636718750, -0.0948791503906250,
-0.0837402343750000, -0.1062622070312500, -0.0734558105468750, -0.0876770019531250,
-0.0791931152343750, -0.0786132812500000, -0.0830078125000000, -0.0931396484375000,
-0.0500793457031250, -0.0460510253906250, -0.0559387207031250, -0.0530090332031250,
-0.0469055175781250, -0.0439147949218750, -0.0203857421875000, -0.0095520019531250,
-0.0312194824218750, -0.0242614746093750, -0.0152893066406250, -0.0035705566406250,
-0.0114135742187500, -0.0010070800781250, -0.0149230957031250, 0.0032043457031250,
-0.0109558105468750, 0.0122375488281250, -0.0106811523437500, 0.0055847167968750,
-0.0167541503906250, 0.0314941406250000, -0.0153198242187500, 0.0269775390625000,
-0.0171508789062500, 0.0286254882812500, -0.0253906250000000, 0.0496826171875000,
-0.0230712890625000, 0.0433959960937500, -0.0089721679687500, 0.0298156738281250,
-0.0174560546875000, 0.0418090820312500, -0.0104675292968750, 0.0289916992187500,
0.0086975097656250, 0.0053405761718750, 0.0008850097656250, 0.0199890136718750,
0.0053405761718750, 0.0074157714843750, 0.0096435546875000, -0.0022277832031250,
0.0024719238281250, 0.0100402832031250, 0.0001831054687500, 0.0178222656250000,
0.0040588378906250, 0.0093078613281250, -0.0214538574218750, 0.0263366699218750,
-0.0175476074218750, 0.0292968750000000, -0.0180358886718750, 0.0262756347656250,
-0.0386047363281250, 0.0298461914062500, -0.0355224609375000, 0.0289611816406250,
-0.0166625976562500, 0.0286254882812500, -0.0269165039062500, 0.0292053222656250,
-0.0193176269531250, 0.0258789062500000, -0.0011901855468750, 0.0251770019531250,
-0.0127563476562500, 0.0267639160156250, 0.0120544433593750, 0.0091857910156250,
0.0124206542968750, 0.0111694335937500, 0.0114746093750000, 0.0097045898437500,
0.0235290527343750, -0.0032348632812500, 0.0202941894531250, -0.0008850097656250,
0.0220642089843750, 0.0038146972656250, 0.0228576660156250, 0.0007324218750000,
0.0221862792968750, 0.0010375976562500, 0.0226440429687500, 0.0075683593750000,
0.0228576660156250, 0.0058593750000000, 0.0214843750000000, -0.0062866210937500,
0.0201721191406250, -0.0000610351562500, 0.0249633789062500, -0.0101623535156250,
0.0270996093750000, -0.0263977050781250, 0.0231933593750000, -0.0177001953125000,
0.0364685058593750, -0.0401306152343750, 0.0373535156250000, -0.0415649414062500,
0.0322875976562500, -0.0400085449218750, 0.0383605957031250, -0.0497436523437500,
0.0405578613281250, -0.0489196777343750, 0.0170898437500000, -0.0496826171875000,
0.0245971679687500, -0.0481872558593750, 0.0151977539062500, -0.0517578125000000,
-0.0082397460937500, -0.0541381835937500, 0.0028991699218750, -0.0511474609375000,
-0.0114440917968750, -0.0669250488281250, -0.0143127441406250, -0.0618286132812500,
-0.0136718750000000, -0.0658874511718750, -0.0167846679687500, -0.0821228027343750,
-0.0148620605468750, -0.0749511718750000, -0.0273132324218750, -0.0704650878906250,
-0.0216369628906250, -0.0780639648437500, -0.0305786132812500, -0.0685424804687500,
-0.0462036132812500, -0.0548706054687500, -0.0361938476562500, -0.0625000000000000,
-0.0526733398437500, -0.0490722656250000, -0.0542602539062500, -0.0468139648437500,
-0.0525207519531250, -0.0459899902343750, -0.0586853027343750, -0.0410766601562500,
-0.0571289062500000, -0.0424804687500000, -0.0581665039062500, -0.0318603515625000,
-0.0592346191406250, -0.0339355468750000, -0.0566101074218750, -0.0281982421875000,
-0.0563964843750000, -0.0168762207031250, -0.0579223632812500, -0.0208435058593750,
-0.0467529296875000, -0.0101013183593750, -0.0520019531250000, -0.0068969726562500,
-0.0436096191406250, -0.0086364746093750, -0.0311279296875000, -0.0045776367187500,
-0.0405578613281250, -0.0036926269531250, -0.0165100097656250, -0.0156860351562500,
-0.0202026367187500, -0.0103149414062500, -0.0136413574218750, -0.0191345214843750,
0.0037231445312500, -0.0334472656250000, -0.0059509277343750, -0.0248718261718750,
0.0162048339843750, -0.0464172363281250, 0.0131835937500000, -0.0453491210937500,
0.0191650390625000, -0.0484008789062500, 0.0350952148437500, -0.0623474121093750,
0.0258789062500000, -0.0561523437500000, 0.0455932617187500, -0.0619506835937500,
0.0438537597656250, -0.0650634765625000, 0.0476684570312500, -0.0586853027343750,
0.0605163574218750, -0.0559082031250000, 0.0536499023437500, -0.0576782226562500,
0.0673217773437500, -0.0419616699218750, 0.0667114257812500, -0.0431518554687500,
0.0677795410156250, -0.0362854003906250, 0.0765686035156250, -0.0223693847656250,
0.0723266601562500, -0.0262756347656250, 0.0718688964843750, -0.0121154785156250,
0.0768737792968750, -0.0097656250000000, 0.0668640136718750, -0.0060119628906250,
0.0598754882812500, 0.0029602050781250, 0.0671997070312500, 0.0016174316406250,
0.0355224609375000, 0.0083007812500000, 0.0432434082031250, 0.0110778808593750,
0.0303955078125000, 0.0112304687500000, 0.0020141601562500, 0.0143127441406250,
0.0178833007812500, 0.0155334472656250, -0.0112304687500000, 0.0102233886718750,
-0.0130004882812500, 0.0147705078125000, -0.0084228515625000, 0.0102539062500000,
-0.0204772949218750, 0.0032653808593750, -0.0176696777343750, 0.0098266601562500,
-0.0063781738281250, -0.0046691894531250, -0.0120544433593750, -0.0014343261718750,
-0.0034790039062500, -0.0052490234375000, 0.0104675292968750, -0.0160827636718750,
0.0024108886718750, -0.0088500976562500, 0.0209960937500000, -0.0224914550781250,
0.0211181640625000, -0.0209045410156250, 0.0227355957031250, -0.0229492187500000,
0.0328369140625000, -0.0315246582031250, 0.0292053222656250, -0.0267333984375000,
0.0369873046875000, -0.0367431640625000, 0.0345458984375000, -0.0355834960937500,
0.0431213378906250, -0.0361633300781250, 0.0516052246093750, -0.0422363281250000,
0.0440979003906250, -0.0390319824218750, 0.0760803222656250, -0.0421752929687500,
0.0715332031250000, -0.0415649414062500, 0.0775756835937500, -0.0433654785156250,
0.1030883789062500, -0.0451354980468750, 0.0933227539062500, -0.0419616699218750,
0.0935668945312500, -0.0518798828125000, 0.1030578613281250, -0.0493164062500000,
0.0856628417968750, -0.0492248535156250, 0.0702514648437500, -0.0567626953125000,
0.0820007324218750, -0.0533142089843750, 0.0429992675781250, -0.0483398437500000,
0.0461730957031250, -0.0543212890625000, 0.0370178222656250, -0.0458679199218750,
0.0101318359375000, -0.0344238281250000, 0.0217285156250000, -0.0423278808593750,
-0.0036315917968750, -0.0263977050781250, -0.0032348632812500, -0.0263366699218750,
-0.0091552734375000, -0.0234985351562500, -0.0244750976562500, -0.0149230957031250,
-0.0164489746093750, -0.0196228027343750, -0.0414123535156250, -0.0055236816406250,
-0.0370788574218750, -0.0057373046875000, -0.0452575683593750, -0.0074462890625000,
-0.0664367675781250, 0.0010986328125000, -0.0559997558593750, 0.0002441406250000,
-0.0724487304687500, -0.0133056640625000, -0.0755920410156250, -0.0094299316406250,
-0.0724487304687500, -0.0107116699218750, -0.0774536132812500, -0.0249023437500000,
-0.0772705078125000, -0.0224609375000000, -0.0723266601562500, -0.0046386718750000,
-0.0758666992187500, -0.0149536132812500, -0.0667114257812500, 0.0008544921875000,
-0.0596008300781250, 0.0261535644531250, -0.0664062500000000, 0.0132446289062500,
-0.0301513671875000, 0.0491333007812500, -0.0407714843750000, 0.0482177734375000,
-0.0234375000000000, 0.0510559082031250, 0.0131835937500000, 0.0752563476562500,
-0.0058593750000000, 0.0682067871093750, 0.0298156738281250, 0.0607910156250000,
0.0379638671875000, 0.0711669921875000, 0.0273132324218750, 0.0579833984375000,
0.0352172851562500, 0.0396423339843750, 0.0391540527343750, 0.0510253906250000,
0.0163269042968750, 0.0258178710937500, 0.0174865722656250, 0.0259704589843750,
0.0197753906250000, 0.0249023437500000, 0.0070495605468750, 0.0092468261718750,
0.0085449218750000, 0.0150146484375000, 0.0236511230468750, 0.0219421386718750,
0.0178833007812500, 0.0160522460937500, 0.0249023437500000, 0.0201721191406250,
0.0416870117187500, 0.0327148437500000, 0.0342712402343750, 0.0289611816406250,
0.0409851074218750, 0.0226440429687500, 0.0450744628906250, 0.0299377441406250,
0.0408630371093750, 0.0198669433593750, 0.0388183593750000, 0.0068969726562500,
0.0405883789062500, 0.0156860351562500, 0.0353393554687500, -0.0090332031250000,
0.0374450683593750, -0.0068054199218750, 0.0308837890625000, -0.0115661621093750,
0.0261230468750000, -0.0312805175781250, 0.0313720703125000, -0.0236816406250000,
-0.0007019042968750, -0.0206604003906250, 0.0072021484375000, -0.0251464843750000,
-0.0054931640625000, -0.0295104980468750, -0.0365295410156250, -0.0216674804687500,
-0.0220642089843750, -0.0186157226562500, -0.0400085449218750, -0.0606079101562500,
-0.0473327636718750, -0.0509643554687500, -0.0426330566406250, -0.0558166503906250,
-0.0434570312500000, -0.1054077148437500, -0.0632324218750000, -0.0149536132812500,
-0.1024475097656250, -0.0679931640625000, -0.1012573242187500, -0.0497436523437500,
-0.0938110351562500, -0.0602111816406250, -0.0998840332031250, -0.0930786132812500,
-0.1048583984375000, -0.0845642089843750, -0.0812072753906250, -0.0662231445312500,
-0.0879821777343750},
{0.0831909179687500, -0.0287170410156250, 0.0911560058593750, -0.0327148437500000,
0.0785217285156250, -0.0246582031250000, 0.0715637207031250, -0.0182495117187500,
0.0785217285156250, -0.0251770019531250, 0.0477600097656250, -0.0051574707031250,
0.0507812500000000, -0.0067749023437500, 0.0400390625000000, -0.0068664550781250,
0.0159301757812500, 0.0058288574218750, 0.0267944335937500, 0.0023803710937500,
0.0034790039062500, -0.0031127929687500, 0.0024108886718750, 0.0040893554687500,
-0.0008544921875000, -0.0043029785156250, -0.0129394531250000, -0.0161132812500000,
-0.0079956054687500, -0.0074157714843750, -0.0257873535156250, -0.0244750976562500,
-0.0217285156250000, -0.0225830078125000, -0.0307006835937500, -0.0266113281250000,
-0.0474243164062500, -0.0379943847656250, -0.0375366210937500, -0.0308227539062500,
-0.0592651367187500, -0.0458374023437500, -0.0596923828125000, -0.0472106933593750,
-0.0598144531250000, -0.0417480468750000, -0.0711364746093750, -0.0473937988281250,
-0.0676879882812500, -0.0489807128906250, -0.0692138671875000, -0.0295104980468750,
-0.0720825195312500, -0.0342407226562500, -0.0663452148437500, -0.0277709960937500,
-0.0647888183593750, -0.0107421875000000, -0.0684204101562500, -0.0172119140625000,
-0.0430603027343750, -0.0033569335937500, -0.0525207519531250, -0.0052795410156250,
-0.0343322753906250, 0.0028076171875000, -0.0040893554687500, 0.0155639648437500,
-0.0222778320312500, 0.0065307617187500, 0.0137023925781250, 0.0260314941406250,
0.0186157226562500, 0.0274658203125000, 0.0115661621093750, 0.0272216796875000,
0.0239562988281250, 0.0350646972656250, 0.0244140625000000, 0.0326538085937500,
0.0086059570312500, 0.0401916503906250, 0.0114440917968750, 0.0390625000000000,
0.0117187500000000, 0.0415649414062500, 0.0000000000000000, 0.0485229492187500,
0.0022583007812500, 0.0453796386718750, 0.0149230957031250, 0.0477905273437500,
0.0087585449218750, 0.0508728027343750, 0.0158691406250000, 0.0450439453125000,
0.0315551757812500, 0.0426025390625000, 0.0242614746093750, 0.0470581054687500,
0.0324096679687500, 0.0280456542968750, 0.0361022949218750, 0.0310363769531250,
0.0323486328125000, 0.0260925292968750, 0.0314941406250000, 0.0117187500000000,
0.0329589843750000, 0.0187683105468750, 0.0292663574218750, 0.0074768066406250,
0.0302734375000000, 0.0053710937500000, 0.0257263183593750, 0.0091247558593750,
0.0231933593750000, 0.0066223144531250, 0.0266723632812500, 0.0055541992187500,
0.0021057128906250, 0.0122680664062500, 0.0095520019531250, 0.0149536132812500,
-0.0026550292968750, 0.0069885253906250, -0.0289001464843750, 0.0070495605468750,
-0.0158386230468750, 0.0130004882812500, -0.0343322753906250, -0.0204772949218750,
-0.0404663085937500, -0.0183105468750000, -0.0352478027343750, -0.0132446289062500,
-0.0347900390625000, -0.0307617187500000, -0.0374145507812500, -0.0313415527343750,
-0.0477294921875000, -0.0149230957031250, -0.0382385253906250, -0.0136718750000000,
-0.0517272949218750, -0.0234680175781250, -0.0885620117187500, -0.0266113281250000,
-0.1034545898437500, -0.0217285156250000, -0.0621032714843750, -0.0182189941406250,
-0.0774230957031250, -0.0136413574218750, -0.0676269531250000, -0.0254516601562500,
-0.0472106933593750, -0.0305786132812500, -0.0549926757812500, -0.0228881835937500,
-0.0323181152343750, -0.0615539550781250, -0.0407104492187500, -0.0575256347656250,
-0.0227050781250000, -0.0591125488281250, 0.0030517578125000, -0.0875854492187500,
-0.0148925781250000, -0.0808105468750000, 0.0381774902343750, -0.0590209960937500,
0.0331420898437500, -0.0733642578125000, 0.0426025390625000, -0.0573120117187500,
0.0821533203125000, -0.0251464843750000, 0.0649414062500000, -0.0415954589843750,
0.0684204101562500, -0.0238037109375000, 0.0859680175781250, -0.0170898437500000,
0.0631103515625000, -0.0217285156250000, 0.0405578613281250, -0.0222778320312500,
0.0604858398437500, -0.0214538574218750, 0.0207214355468750, -0.0130004882812500,
0.0149841308593750, -0.0191955566406250, 0.0264892578125000, -0.0109252929687500,
0.0148010253906250, 0.0037536621093750, 0.0116882324218750, -0.0042724609375000,
0.0393066406250000, 0.0072021484375000, 0.0329589843750000, 0.0099792480468750,
0.0393981933593750, 0.0088195800781250, 0.0624694824218750, 0.0105590820312500,
0.0534973144531250, 0.0100402832031250, 0.0613403320312500, 0.0188903808593750,
0.0666198730468750, 0.0156860351562500, 0.0596618652343750, 0.0198669433593750,
0.0607299804687500, 0.0309448242187500, 0.0639343261718750, 0.0263061523437500,
0.0265808105468750, 0.0255737304687500, 0.0417785644531250, 0.0314941406250000,
0.0220031738281250, 0.0235900878906250, -0.0213928222656250, 0.0149536132812500,
0.0014953613281250, 0.0212707519531250, -0.0251770019531250, 0.0046081542968750,
-0.0345458984375000, 0.0063476562500000, -0.0276489257812500, 0.0010681152343750,
-0.0292968750000000, -0.0098571777343750, -0.0299072265625000, -0.0032653808593750,
-0.0295410156250000, -0.0251464843750000, -0.0254211425781250, -0.0211486816406250,
-0.0307312011718750, -0.0288085937500000, -0.0355529785156250, -0.0475463867187500,
-0.0291442871093750, -0.0386657714843750, -0.0420532226562500, -0.0559082031250000,
-0.0430908203125000, -0.0572814941406250, -0.0393676757812500, -0.0577392578125000,
-0.0448303222656250, -0.0664672851562500, -0.0448913574218750, -0.0633239746093750,
-0.0281372070312500, -0.0646362304687500, -0.0364990234375000, -0.0690612792968750,
-0.0239868164062500, -0.0598449707031250, -0.0022888183593750, -0.0539855957031250,
-0.0158691406250000, -0.0607604980468750, 0.0061340332031250, -0.0330810546875000,
0.0111999511718750, -0.0367126464843750, 0.0043334960937500, -0.0314025878906250,
0.0087280273437500, -0.0115356445312500, 0.0103454589843750, -0.0195922851562500,
-0.0030517578125000, -0.0083923339843750, 0.0011596679687500, -0.0081176757812500,
-0.0057983398437500, -0.0035400390625000, -0.0183410644531250, 0.0030517578125000,
-0.0102844238281250, -0.0021972656250000, -0.0287170410156250, 0.0194091796875000,
-0.0273742675781250, 0.0155029296875000, -0.0298767089843750, 0.0227966308593750,
-0.0413208007812500, 0.0403747558593750, -0.0355834960937500, 0.0323791503906250,
-0.0437622070312500, 0.0530395507812500, -0.0442810058593750, 0.0514526367187500,
-0.0437316894531250, 0.0572204589843750, -0.0476379394531250, 0.0731811523437500,
-0.0465698242187500, 0.0655517578125000, -0.0466613769531250, 0.0762939453125000,
-0.0484008789062500, 0.0810546875000000, -0.0469055175781250, 0.0738220214843750,
-0.0455322265625000, 0.0723876953125000, -0.0474548339843750, 0.0762634277343750,
-0.0423278808593750, 0.0595703125000000, -0.0443725585937500, 0.0612487792968750,
-0.0419921875000000, 0.0571289062500000, -0.0376281738281250, 0.0452880859375000,
-0.0416564941406250, 0.0499572753906250, -0.0333557128906250, 0.0386962890625000,
-0.0354003906250000, 0.0376892089843750, -0.0328674316406250, 0.0372924804687500,
-0.0265502929687500, 0.0303955078125000, -0.0311889648437500, 0.0310974121093750,
-0.0223388671875000, 0.0349121093750000, -0.0235900878906250, 0.0303955078125000,
-0.0223999023437500, 0.0351257324218750, -0.0168457031250000, 0.0420837402343750,
-0.0202331542968750, 0.0359802246093750, -0.0143737792968750, 0.0462341308593750,
-0.0156555175781250, 0.0462646484375000, -0.0151672363281250, 0.0448608398437500,
-0.0111694335937500, 0.0492553710937500, -0.0137939453125000, 0.0476989746093750,
-0.0112915039062500, 0.0460815429687500, -0.0106811523437500, 0.0466308593750000,
-0.0122680664062500, 0.0476074218750000, -0.0125122070312500, 0.0465698242187500,
-0.0119934082031250, 0.0461730957031250, -0.0129394531250000, 0.0516662597656250,
-0.0138244628906250, 0.0509948730468750, -0.0109558105468750, 0.0501708984375000,
-0.0096435546875000, 0.0547790527343750, -0.0111083984375000, 0.0543823242187500,
-0.0018005371093750, 0.0435485839843750, -0.0033874511718750, 0.0502014160156250,
0.0007324218750000, 0.0393371582031250, 0.0090942382812500, 0.0241699218750000,
0.0057373046875000, 0.0351867675781250, 0.0158081054687500, 0.0090942382812500,
0.0159301757812500, 0.0107727050781250, 0.0179748535156250, 0.0075683593750000,
0.0245666503906250, -0.0082092285156250, 0.0222778320312500, -0.0010986328125000,
0.0271301269531250, -0.0135192871093750, 0.0286254882812500, -0.0121765136718750,
0.0250854492187500, -0.0177917480468750, 0.0255737304687500, -0.0269470214843750,
0.0269775390625000, -0.0205383300781250, 0.0138549804687500, -0.0429992675781250,
0.0173034667968750, -0.0380554199218750, 0.0114135742187500, -0.0466308593750000,
-0.0016479492187500, -0.0659179687500000, 0.0046691894531250, -0.0545654296875000,
-0.0050964355468750, -0.0749511718750000, -0.0083007812500000, -0.0776672363281250,
-0.0027160644531250, -0.0707702636718750, -0.0030212402343750, -0.0784912109375000,
-0.0054321289062500, -0.0802001953125000, 0.0091857910156250, -0.0547180175781250,
0.0095825195312500, -0.0655212402343750, 0.0084838867187500, -0.0513916015625000,
0.0173950195312500, -0.0234985351562500, 0.0169677734375000, -0.0400085449218750,
0.0027160644531250, -0.0097351074218750, 0.0110168457031250, -0.0084838867187500,
-0.0037231445312500, -0.0072631835937500, -0.0230712890625000, 0.0075073242187500,
-0.0099487304687500, 0.0021057128906250, -0.0528259277343750, 0.0143737792968750,
-0.0512390136718750, 0.0119018554687500, -0.0509643554687500, 0.0177001953125000,
-0.0771789550781250, 0.0291748046875000, -0.0709838867187500, 0.0212707519531250,
-0.0559997558593750, 0.0330505371093750, -0.0644836425781250, 0.0379333496093750,
-0.0548706054687500, 0.0282592773437500, -0.0348510742187500, 0.0267944335937500,
-0.0436401367187500, 0.0335083007812500, -0.0324707031250000, 0.0103759765625000,
-0.0288391113281250, 0.0109558105468750, -0.0295410156250000, 0.0148010253906250,
-0.0275878906250000, 0.0030822753906250, -0.0291748046875000, 0.0038452148437500,
-0.0249633789062500, 0.0200500488281250, -0.0249023437500000, 0.0139770507812500,
-0.0229797363281250, 0.0193176269531250, -0.0217590332031250, 0.0360107421875000,
-0.0234375000000000, 0.0283508300781250, -0.0074462890625000, 0.0301513671875000,
-0.0095214843750000, 0.0377502441406250, -0.0098571777343750, 0.0275573730468750,
-0.0003356933593750, 0.0178833007812500, -0.0011901855468750, 0.0257568359375000,
0.0007934570312500, 0.0060119628906250, -0.0014953613281250, 0.0061340332031250,
0.0006103515625000, 0.0032348632812500, 0.0089111328125000, -0.0108032226562500,
0.0064392089843750, -0.0095520019531250, -0.0098876953125000, -0.0155029296875000,
-0.0013122558593750, -0.0167541503906250, -0.0059204101562500, -0.0123901367187500,
-0.0219421386718750, -0.0131835937500000, -0.0141601562500000, -0.0172119140625000,
-0.0262451171875000, -0.0078735351562500, -0.0293884277343750, -0.0052490234375000,
-0.0232238769531250, -0.0133972167968750, -0.0263061523437500, -0.0134887695312500,
-0.0299682617187500, -0.0093688964843750, -0.0088195800781250, -0.0374755859375000,
-0.0134582519531250, -0.0339050292968750, -0.0097961425781250, -0.0363464355468750,
0.0061035156250000, -0.0570678710937500, 0.0002746582031250, -0.0529785156250000,
0.0103149414062500, -0.0485534667968750, 0.0093383789062500, -0.0533752441406250,
0.0133666992187500, -0.0475463867187500, 0.0222778320312500, -0.0401306152343750,
0.0168457031250000, -0.0456237792968750, 0.0235900878906250, -0.0296936035156250,
0.0267639160156250, -0.0290222167968750, 0.0225524902343750, -0.0320739746093750,
0.0206298828125000},
{0.0028381347656250, -0.0111999511718750, 0.0036010742187500, -0.0215454101562500,
0.0023193359375000, -0.0154113769531250, 0.0088195800781250, -0.0346069335937500,
0.0075378417968750, -0.0309448242187500, 0.0105895996093750, -0.0379333496093750,
0.0169372558593750, -0.0540161132812500, 0.0141906738281250, -0.0448303222656250,
0.0195922851562500, -0.0615844726562500, 0.0223083496093750, -0.0626525878906250,
0.0186462402343750, -0.0599060058593750, 0.0183715820312500, -0.0677795410156250,
0.0209960937500000, -0.0662536621093750, 0.0090332031250000, -0.0545959472656250,
0.0114746093750000, -0.0630798339843750, 0.0071105957031250, -0.0501403808593750,
-0.0036315917968750, -0.0323791503906250, 0.0015869140625000, -0.0457763671875000,
-0.0054016113281250, -0.0158386230468750, -0.0086364746093750, -0.0171203613281250,
-0.0037536621093750, -0.0136108398437500, -0.0018920898437500, 0.0039978027343750,
-0.0046081542968750, -0.0033874511718750, 0.0024414062500000, 0.0117492675781250,
0.0045776367187500, 0.0108642578125000, 0.0020446777343750, 0.0141296386718750,
0.0037841796875000, 0.0244445800781250, 0.0045166015625000, 0.0190429687500000,
-0.0074462890625000, 0.0286865234375000, -0.0003662109375000, 0.0301208496093750,
-0.0149230957031250, 0.0267333984375000, -0.0343017578125000, 0.0303955078125000,
-0.0203857421875000, 0.0314331054687500, -0.0490417480468750, 0.0185546875000000,
-0.0548095703125000, 0.0223083496093750, -0.0460815429687500, 0.0203552246093750,
-0.0520629882812500, 0.0085449218750000, -0.0551757812500000, 0.0126647949218750,
-0.0384521484375000, 0.0174865722656250, -0.0391540527343750, 0.0118103027343750,
-0.0399475097656250, 0.0180969238281250, -0.0310363769531250, 0.0287170410156250,
-0.0320129394531250, 0.0226135253906250, -0.0351257324218750, 0.0301513671875000,
-0.0333251953125000, 0.0346374511718750, -0.0350646972656250, 0.0264892578125000,
-0.0388488769531250, 0.0244750976562500, -0.0357055664062500, 0.0305175781250000,
-0.0350952148437500, 0.0076904296875000, -0.0412292480468750, 0.0111999511718750,
-0.0305786132812500, 0.0053710937500000, -0.0185546875000000, -0.0123596191406250,
-0.0277404785156250, -0.0048522949218750, -0.0149230957031250, -0.0170288085937500,
-0.0115051269531250, -0.0192565917968750, -0.0118713378906250, -0.0181579589843750,
-0.0079956054687500, -0.0234069824218750, -0.0082397460937500, -0.0229492187500000,
-0.0035095214843750, -0.0179748535156250, -0.0027770996093750, -0.0202331542968750,
-0.0063476562500000, -0.0216979980468750, -0.0064697265625000, -0.0170593261718750,
-0.0047912597656250, -0.0180664062500000, -0.0127868652343750, -0.0309448242187500,
-0.0108642578125000, -0.0260009765625000, -0.0167846679687500, -0.0339660644531250,
-0.0254516601562500, -0.0498962402343750, -0.0190124511718750, -0.0415344238281250,
-0.0303039550781250, -0.0473327636718750, -0.0354309082031250, -0.0554504394531250,
-0.0269775390625000, -0.0460205078125000, -0.0249633789062500, -0.0369567871093750,
-0.0309753417968750, -0.0433349609375000, -0.0134277343750000, -0.0296936035156250,
-0.0146789550781250, -0.0306091308593750, -0.0110473632812500, -0.0264587402343750,
-0.0010070800781250, -0.0139465332031250, -0.0066528320312500, -0.0197448730468750,
0.0106201171875000, -0.0229492187500000, 0.0074768066406250, -0.0137634277343750,
0.0113830566406250, -0.0265197753906250, 0.0258789062500000, -0.0430297851562500,
0.0195617675781250, -0.0309753417968750, 0.0227661132812500, -0.0472717285156250,
0.0270385742187500, -0.0561828613281250, 0.0226745605468750, -0.0420227050781250,
0.0179748535156250, -0.0368957519531250, 0.0213317871093750, -0.0462341308593750,
0.0211486816406250, -0.0156860351562500, 0.0169067382812500, -0.0187377929687500,
0.0224914550781250, -0.0147094726562500, 0.0302734375000000, 0.0068359375000000,
0.0252075195312500, -0.0021972656250000, 0.0258178710937500, -0.0038452148437500,
0.0338134765625000, 0.0050659179687500, 0.0205078125000000, -0.0059204101562500,
0.0083312988281250, -0.0205383300781250, 0.0200805664062500, -0.0119628906250000,
-0.0074157714843750, -0.0246887207031250, -0.0076599121093750, -0.0303039550781250,
-0.0057983398437500, -0.0213317871093750, -0.0182800292968750, -0.0201416015625000,
-0.0154724121093750, -0.0254821777343750, -0.0173034667968750, -0.0018920898437500,
-0.0155639648437500, -0.0050659179687500, -0.0211181640625000, 0.0018005371093750,
-0.0253906250000000, 0.0203247070312500, -0.0197448730468750, 0.0129699707031250,
-0.0379943847656250, 0.0287475585937500, -0.0351867675781250, 0.0301513671875000,
-0.0373535156250000, 0.0304260253906250, -0.0500488281250000, 0.0379638671875000,
-0.0446777343750000, 0.0358581542968750, -0.0484924316406250, 0.0390930175781250,
-0.0513000488281250, 0.0387573242187500, -0.0478515625000000, 0.0403747558593750,
-0.0462646484375000, 0.0431823730468750, -0.0479431152343750, 0.0415344238281250,
-0.0412902832031250, 0.0466308593750000, -0.0431213378906250, 0.0461425781250000,
-0.0397338867187500, 0.0469360351562500, -0.0343933105468750, 0.0503234863281250,
-0.0385131835937500, 0.0491027832031250, -0.0259094238281250, 0.0518798828125000,
-0.0298767089843750, 0.0520935058593750, -0.0234069824218750, 0.0519104003906250,
-0.0121154785156250, 0.0537414550781250, -0.0199279785156250, 0.0533142089843750,
0.0024414062500000, 0.0499877929687500, -0.0014953613281250, 0.0526428222656250,
0.0065917968750000, 0.0473632812500000, 0.0242309570312500, 0.0413513183593750,
0.0142517089843750, 0.0453796386718750, 0.0402832031250000, 0.0304565429687500,
0.0368957519531250, 0.0324707031250000, 0.0442504882812500, 0.0270080566406250,
0.0633544921875000, 0.0151977539062500, 0.0530700683593750, 0.0212402343750000,
0.0751953125000000, 0.0068969726562500, 0.0744628906250000, 0.0075073242187500,
0.0773010253906250, 0.0047607421875000, 0.0912475585937500, -0.0047302246093750,
0.0856018066406250, -0.0000610351562500, 0.0932312011718750, -0.0067138671875000,
0.0946960449218750, -0.0086669921875000, 0.0934448242187500, -0.0069885253906250,
0.0957336425781250, -0.0084228515625000, 0.0953674316406250, -0.0092468261718750,
0.0950317382812500, -0.0068359375000000, 0.0953063964843750, -0.0079956054687500,
0.0956726074218750, -0.0060424804687500, 0.0961303710937500, -0.0039062500000000,
0.0961608886718750, -0.0061035156250000, 0.0948791503906250, 0.0030822753906250,
0.0987854003906250, -0.0004577636718750, 0.0910644531250000, 0.0040893554687500,
0.0857543945312500, 0.0134887695312500, 0.0923461914062500, 0.0081176757812500,
0.0627746582031250, 0.0207519531250000, 0.0693054199218750, 0.0198364257812500,
0.0572814941406250, 0.0225524902343750, 0.0307922363281250, 0.0310668945312500,
0.0436706542968750, 0.0269470214843750, 0.0146484375000000, 0.0363159179687500,
0.0133666992187500, 0.0369873046875000, 0.0100097656250000, 0.0357360839843750,
-0.0061035156250000, 0.0411071777343750, -0.0007324218750000, 0.0407409667968750,
-0.0137023925781250, 0.0307922363281250, -0.0122375488281250, 0.0376281738281250,
-0.0196533203125000, 0.0289306640625000, -0.0309143066406250, 0.0155639648437500,
-0.0238342285156250, 0.0256958007812500, -0.0458679199218750, 0.0032043457031250,
-0.0448913574218750, 0.0043640136718750, -0.0473327636718750, 0.0017700195312500,
-0.0611877441406250, -0.0117797851562500, -0.0565490722656250, -0.0062561035156250,
-0.0615844726562500, -0.0164184570312500, -0.0638122558593750, -0.0155334472656250,
-0.0615539550781250, -0.0169982910156250, -0.0625915527343750, -0.0253601074218750,
-0.0629272460937500, -0.0213623046875000, -0.0530090332031250, -0.0173034667968750,
-0.0597534179687500, -0.0240783691406250, -0.0459899902343750, -0.0138549804687500,
-0.0297546386718750, 0.0003662109375000, -0.0422058105468750, -0.0091552734375000,
-0.0071105957031250, 0.0014648437500000, -0.0077514648437500, 0.0109863281250000,
-0.0077514648437500, -0.0077819824218750, 0.0122985839843750, -0.0172729492187500,
0.0071716308593750, -0.0042114257812500, 0.0019531250000000, -0.0539245605468750,
0.0070495605468750, -0.0503540039062500, 0.0034179687500000, -0.0581970214843750,
-0.0062561035156250, -0.0917053222656250, -0.0024719238281250, -0.0786132812500000,
0.0008850097656250, -0.0893859863281250, -0.0041503906250000, -0.1022338867187500,
0.0028381347656250, -0.0776062011718750, 0.0126953125000000, -0.0657653808593750,
0.0071411132812500, -0.0824584960937500, 0.0173950195312500, -0.0051574707031250,
0.0195617675781250, -0.0138854980468750, 0.0179443359375000, -0.0050354003906250,
0.0205383300781250, 0.0491333007812500, 0.0205688476562500, 0.0317077636718750,
0.0197143554687500, 0.0352478027343750, 0.0200805664062500, 0.0469970703125000,
0.0180969238281250, 0.0358581542968750, 0.0177307128906250, 0.0234985351562500,
0.0187683105468750, 0.0314025878906250, 0.0061950683593750, 0.0155944824218750,
0.0114746093750000, 0.0120544433593750, 0.0013122558593750, 0.0191650390625000,
-0.0148315429687500, 0.0149536132812500, -0.0052795410156250, 0.0122680664062500,
-0.0260314941406250, 0.0407409667968750, -0.0279846191406250, 0.0353698730468750,
-0.0274353027343750, 0.0354309082031250, -0.0355834960937500, 0.0591430664062500,
-0.0340576171875000, 0.0547485351562500, -0.0410461425781250, 0.0274047851562500,
-0.0356750488281250, 0.0419006347656250, -0.0489501953125000, 0.0205688476562500,
-0.0626525878906250, -0.0173950195312500, -0.0508728027343750, 0.0044250488281250,
-0.0864562988281250, -0.0230712890625000, -0.0883483886718750, -0.0368652343750000,
-0.0808715820312500, -0.0182495117187500, -0.0971984863281250, -0.0101013183593750,
-0.0978698730468750, -0.0213928222656250, -0.0640258789062500, -0.0007019042968750,
-0.0724792480468750, 0.0044250488281250, -0.0687866210937500, -0.0019531250000000,
-0.0296630859375000, -0.0000305175781250, -0.0190734863281250, -0.0288696289062500,
0.0272216796875000, 0.0052185058593750, 0.0047302246093750, -0.0003356933593750,
0.0194396972656250, -0.0050659179687500, 0.0544433593750000, 0.0060424804687500,
0.0421447753906250, 0.0092773437500000, 0.0374145507812500, -0.0198059082031250,
0.0491943359375000, -0.0173950195312500, 0.0384521484375000, -0.0142517089843750,
0.0203552246093750, -0.0299072265625000, 0.0300903320312500, -0.0295104980468750,
0.0217285156250000, -0.0177612304687500, 0.0150451660156250, -0.0164794921875000,
0.0252380371093750, -0.0253906250000000, 0.0325012207031250, -0.0240478515625000,
0.0253601074218750, -0.0177612304687500, 0.0362854003906250, -0.0459899902343750,
0.0423889160156250, -0.0470581054687500, 0.0326232910156250, -0.0409851074218750,
0.0286865234375000, -0.0540771484375000, 0.0356140136718750, -0.0556030273437500,
0.0157470703125000, -0.0286560058593750, 0.0151672363281250, -0.0356750488281250,
0.0220336914062500, -0.0292358398437500, 0.0136413574218750, -0.0057067871093750,
0.0111389160156250, -0.0146179199218750, 0.0364685058593750, -0.0093078613281250,
0.0333251953125000, -0.0061645507812500, 0.0276184082031250, -0.0065612792968750,
0.0475463867187500, -0.0077514648437500, 0.0466918945312500, -0.0089721679687500,
-0.0109252929687500, 0.0019226074218750, 0.0148925781250000, -0.0006408691406250,
-0.0190124511718750, 0.0011596679687500, -0.0866088867187500, 0.0106201171875000,
-0.0493774414062500, 0.0076599121093750, -0.1096801757812500, 0.0057678222656250,
-0.1200866699218750, 0.0077514648437500, -0.1069946289062500, 0.0070800781250000,
-0.1266479492187500, 0.0034790039062500, -0.1256713867187500, 0.0040588378906250,
-0.0898132324218750},
{0.0063476562500000, -0.0281677246093750, 0.0167846679687500, -0.0606994628906250,
0.0180969238281250, -0.0568237304687500, 0.0174255371093750, -0.0658874511718750,
0.0213317871093750, -0.0929565429687500, 0.0205078125000000, -0.0801391601562500,
0.0213928222656250, -0.0871887207031250, 0.0216674804687500, -0.1051940917968750,
0.0203552246093750, -0.0736389160156250, 0.0210876464843750, -0.0482177734375000,
0.0214233398437500, -0.0734863281250000, 0.0127563476562500, -0.0063171386718750,
0.0172424316406250, -0.0047607421875000, 0.0086975097656250, -0.0042724609375000,
-0.0032653808593750, 0.0289001464843750, 0.0044860839843750, 0.0187377929687500,
-0.0162048339843750, 0.0252685546875000, -0.0160522460937500, 0.0315856933593750,
-0.0187683105468750, 0.0233154296875000, -0.0307006835937500, 0.0186462402343750,
-0.0264587402343750, 0.0246582031250000, -0.0374145507812500, 0.0097045898437500,
-0.0346069335937500, 0.0046997070312500, -0.0430297851562500, 0.0186462402343750,
-0.0540771484375000, 0.0220336914062500, -0.0457763671875000, 0.0117187500000000,
-0.0717468261718750, 0.0389099121093750, -0.0713500976562500, 0.0439147949218750,
-0.0704650878906250, 0.0363159179687500, -0.0869140625000000, 0.0451965332031250,
-0.0832824707031250, 0.0462951660156250, -0.0648803710937500, 0.0114440917968750,
-0.0757446289062500, 0.0252990722656250, -0.0609436035156250, 0.0086669921875000,
-0.0343627929687500, -0.0310058593750000, -0.0488586425781250, -0.0117492675781250,
-0.0275268554687500, -0.0295104980468750, -0.0236206054687500, -0.0393981933593750,
-0.0229492187500000, -0.0275878906250000, -0.0088195800781250, -0.0170288085937500,
0.0242309570312500, -0.0065612792968750, 0.0290222167968750, -0.0319213867187500,
0.0399780273437500, -0.0396728515625000, 0.0267333984375000, -0.0195312500000000,
0.0114440917968750, -0.0086364746093750, 0.0222778320312500, -0.0235290527343750,
0.0165100097656250, 0.0084228515625000, 0.0070190429687500, 0.0184936523437500,
0.0189208984375000, -0.0005493164062500, 0.0309448242187500, -0.0025634765625000,
0.0220031738281250, 0.0091247558593750, 0.0361938476562500, -0.0254516601562500,
0.0429992675781250, -0.0294799804687500, 0.0305480957031250, -0.0210876464843750,
0.0268859863281250, -0.0301208496093750, 0.0357360839843750, -0.0330200195312500,
0.0093383789062500, -0.0220031738281250, 0.0078735351562500, -0.0179748535156250,
0.0131835937500000, -0.0280761718750000, 0.0022888183593750, -0.0313415527343750,
0.0021972656250000, -0.0242309570312500, 0.0204772949218750, -0.0453796386718750,
0.0155334472656250, -0.0491333007812500, 0.0161743164062500, -0.0401916503906250,
0.0351257324218750, -0.0451965332031250, 0.0297546386718750, -0.0498657226562500,
-0.0042419433593750, -0.0222167968750000, 0.0216064453125000, -0.0257568359375000,
-0.0182800292968750, -0.0226440429687500, -0.0755920410156250, -0.0037536621093750,
-0.0362854003906250, -0.0098571777343750, -0.1159057617187500, -0.0073242187500000,
-0.1239929199218750, -0.0059509277343750, -0.1140441894531250, -0.0037536621093750,
-0.1460266113281250, -0.0029296875000000, -0.1408081054687500, -0.0056152343750000,
-0.1157836914062500, 0.0063171386718750, -0.1310119628906250, 0.0055236816406250,
-0.1084289550781250, 0.0052185058593750, -0.0736389160156250, 0.0126342773437500,
-0.0968627929687500, 0.0112304687500000, -0.0534362792968750, 0.0068359375000000,
-0.0479431152343750, 0.0084838867187500, -0.0548400878906250, 0.0079956054687500,
-0.0419616699218750, 0.0038146972656250, -0.0424804687500000, 0.0046997070312500,
-0.0398254394531250, 0.0079345703125000, -0.0440063476562500, 0.0073547363281250,
-0.0366516113281250, 0.0072937011718750, -0.0282897949218750, 0.0100402832031250,
-0.0350952148437500, 0.0098876953125000, -0.0167236328125000, 0.0050048828125000,
-0.0173339843750000, 0.0075378417968750, -0.0174560546875000, 0.0038146972656250,
-0.0072631835937500, -0.0015869140625000, -0.0099792480468750, 0.0016174316406250,
-0.0099182128906250, -0.0115661621093750, -0.0080871582031250, -0.0075683593750000,
-0.0097961425781250, -0.0156250000000000, -0.0118408203125000, -0.0294189453125000,
-0.0097656250000000, -0.0209350585937500, -0.0108642578125000, -0.0407714843750000,
-0.0140686035156250, -0.0406188964843750, -0.0075683593750000, -0.0420532226562500,
-0.0028686523437500, -0.0531616210937500, -0.0081787109375000, -0.0488891601562500,
0.0077209472656250, -0.0544128417968750, 0.0066223144531250, -0.0560607910156250,
0.0082397460937500, -0.0531311035156250, 0.0176696777343750, -0.0548095703125000,
0.0137939453125000, -0.0557861328125000, 0.0196838378906250, -0.0428161621093750,
0.0191040039062500, -0.0473632812500000, 0.0207824707031250, -0.0400695800781250,
0.0247802734375000, -0.0256652832031250, 0.0217285156250000, -0.0328369140625000,
0.0281372070312500, -0.0196838378906250, 0.0270996093750000, -0.0186767578125000,
0.0273437500000000, -0.0162963867187500, 0.0311584472656250, -0.0106811523437500,
0.0286254882812500, -0.0140380859375000, 0.0301513671875000, 0.0032653808593750,
0.0306091308593750, -0.0024414062500000, 0.0283813476562500, 0.0090026855468750,
0.0277404785156250, 0.0276489257812500, 0.0284423828125000, 0.0168457031250000,
0.0239868164062500, 0.0473632812500000, 0.0247497558593750, 0.0449523925781250,
0.0225830078125000, 0.0524291992187500, 0.0187988281250000, 0.0749511718750000,
0.0210266113281250, 0.0653991699218750, 0.0155639648437500, 0.0816345214843750,
0.0162048339843750, 0.0866088867187500, 0.0146484375000000, 0.0811462402343750,
0.0107421875000000, 0.0842895507812500, 0.0133056640625000, 0.0868835449218750,
0.0093688964843750, 0.0724487304687500, 0.0095214843750000, 0.0758361816406250,
0.0097351074218750, 0.0709838867187500, 0.0077819824218750, 0.0593566894531250,
0.0091857910156250, 0.0656127929687500, 0.0101013183593750, 0.0527343750000000,
0.0092773437500000, 0.0547180175781250, 0.0122070312500000, 0.0492858886718750,
0.0146484375000000, 0.0399780273437500, 0.0130310058593750, 0.0473327636718750,
0.0204772949218750, 0.0262756347656250, 0.0197143554687500, 0.0305786132812500,
0.0211791992187500, 0.0242004394531250, 0.0264892578125000, 0.0075073242187500,
0.0241699218750000, 0.0171813964843750, 0.0262145996093750, -0.0003356933593750,
0.0270996093750000, 0.0002441406250000, 0.0256042480468750, -0.0025939941406250,
0.0251159667968750, -0.0122070312500000, 0.0252380371093750, -0.0068969726562500,
0.0222473144531250, -0.0234985351562500, 0.0230102539062500, -0.0194396972656250,
0.0202941894531250, -0.0274047851562500, 0.0169372558593750, -0.0432739257812500,
0.0188598632812500, -0.0336608886718750, 0.0113525390625000, -0.0515747070312500,
0.0122375488281250, -0.0538635253906250, 0.0106811523437500, -0.0498657226562500,
0.0051574707031250, -0.0559082031250000, 0.0077514648437500, -0.0557861328125000,
0.0057983398437500, -0.0456542968750000, 0.0043334960937500, -0.0489196777343750,
0.0072326660156250, -0.0435791015625000, 0.0089416503906250, -0.0344543457031250,
0.0073852539062500, -0.0403137207031250, 0.0127868652343750, -0.0250244140625000,
0.0131225585937500, -0.0291137695312500, 0.0127563476562500, -0.0229187011718750,
0.0156860351562500, -0.0097045898437500, 0.0149841308593750, -0.0180358886718750,
0.0103149414062500, 0.0020446777343750, 0.0136108398437500, 0.0000915527343750,
0.0072326660156250, 0.0046386718750000, -0.0009765625000000, 0.0192565917968750,
0.0045471191406250, 0.0119934082031250, -0.0091552734375000, 0.0221557617187500,
-0.0104675292968750, 0.0255737304687500, -0.0090332031250000, 0.0212402343750000,
-0.0150146484375000, 0.0219726562500000, -0.0135192871093750, 0.0245666503906250,
-0.0059204101562500, 0.0182800292968750, -0.0097045898437500, 0.0181884765625000,
-0.0018005371093750, 0.0189819335937500, 0.0102539062500000, 0.0167236328125000,
0.0035095214843750, 0.0172119140625000, 0.0137329101562500, 0.0167236328125000,
0.0194702148437500, 0.0165405273437500, 0.0111694335937500, 0.0175781250000000,
0.0084228515625000, 0.0177917480468750, 0.0132446289062500, 0.0169372558593750,
-0.0071716308593750, 0.0190429687500000, -0.0018920898437500, 0.0198364257812500,
-0.0111999511718750, 0.0174255371093750, -0.0310974121093750, 0.0175170898437500,
-0.0193481445312500, 0.0188903808593750, -0.0339660644531250, 0.0092163085937500,
-0.0386962890625000, 0.0136413574218750, -0.0335083007812500, 0.0051574707031250,
-0.0340270996093750, -0.0071105957031250, -0.0347290039062500, 0.0009460449218750,
-0.0285034179687500, -0.0205383300781250, -0.0271911621093750, -0.0211181640625000,
-0.0307617187500000, -0.0206604003906250, -0.0300903320312500, -0.0315246582031250,
-0.0267028808593750, -0.0292968750000000, -0.0341186523437500, -0.0290222167968750,
-0.0340576171875000, -0.0314636230468750, -0.0348815917968750, -0.0296936035156250,
-0.0390014648437500, -0.0270080566406250, -0.0364074707031250, -0.0289001464843750,
-0.0367736816406250, -0.0264587402343750, -0.0395202636718750, -0.0262756347656250,
-0.0366821289062500, -0.0272216796875000, -0.0324707031250000, -0.0266418457031250,
-0.0334472656250000, -0.0269775390625000, -0.0295410156250000, -0.0296936035156250,
-0.0315551757812500, -0.0301208496093750, -0.0296630859375000, -0.0277099609375000,
-0.0247802734375000, -0.0276794433593750, -0.0278015136718750, -0.0292968750000000,
-0.0263061523437500, -0.0225830078125000, -0.0239562988281250, -0.0232543945312500,
-0.0252075195312500, -0.0218505859375000, -0.0288085937500000, -0.0162658691406250,
-0.0278320312500000, -0.0181274414062500, -0.0184020996093750, -0.0201721191406250,
-0.0226135253906250, -0.0183715820312500, -0.0210266113281250, -0.0185241699218750,
-0.0105285644531250, -0.0189819335937500, -0.0137939453125000, -0.0192871093750000,
-0.0201416015625000, -0.0315551757812500, -0.0160522460937500, -0.0257568359375000,
-0.0213317871093750, -0.0305786132812500, -0.0309753417968750, -0.0465698242187500,
-0.0264587402343750, -0.0406799316406250, -0.0328063964843750, -0.0370788574218750,
-0.0359191894531250, -0.0433044433593750, -0.0315551757812500, -0.0366516113281250,
-0.0317687988281250, -0.0256652832031250, -0.0348205566406250, -0.0313110351562500,
-0.0197143554687500, -0.0263061523437500, -0.0248413085937500, -0.0236206054687500,
-0.0162658691406250, -0.0244750976562500, -0.0007324218750000, -0.0238647460937500,
-0.0100097656250000, -0.0238037109375000, 0.0115661621093750, -0.0263061523437500,
0.0115356445312500, -0.0258178710937500, 0.0110473632812500, -0.0212097167968750,
0.0227355957031250, -0.0220336914062500, 0.0195922851562500, -0.0246887207031250,
0.0171508789062500, -0.0051879882812500, 0.0196838378906250, -0.0077209472656250,
0.0195617675781250, -0.0029907226562500, 0.0157470703125000, 0.0114440917968750,
0.0163574218750000, 0.0061035156250000, 0.0227050781250000, 0.0164489746093750,
0.0213317871093750, 0.0169372558593750, 0.0202636718750000, 0.0191955566406250,
0.0259399414062500, 0.0254821777343750, 0.0260925292968750, 0.0226135253906250,
0.0128784179687500, 0.0303344726562500, 0.0199279785156250, 0.0311889648437500,
0.0121765136718750, 0.0306701660156250, -0.0037841796875000, 0.0343017578125000,
0.0060729980468750, 0.0343322753906250, -0.0075683593750000, 0.0319519042968750,
-0.0088195800781250, 0.0326843261718750, -0.0079345703125000, 0.0314636230468750,
-0.0123291015625000, 0.0290832519531250, -0.0103454589843750, 0.0299682617187500,
-0.0189819335937500, 0.0267333984375000, -0.0148620605468750, 0.0262756347656250,
-0.0212402343750000},
{0.0133361816406250, 0.0090637207031250, 0.0029602050781250, 0.0033264160156250,
-0.0039672851562500, -0.0058288574218750, 0.0043640136718750, -0.0001525878906250,
-0.0263671875000000, -0.0182800292968750, -0.0248718261718750, -0.0170288085937500,
-0.0242309570312500, -0.0187377929687500, -0.0415954589843750, -0.0312805175781250,
-0.0370788574218750, -0.0281066894531250, -0.0310974121093750, -0.0285339355468750,
-0.0363159179687500, -0.0309143066406250, -0.0293273925781250, -0.0298461914062500,
-0.0170898437500000, -0.0282592773437500, -0.0231628417968750, -0.0292358398437500,
-0.0208740234375000, -0.0265808105468750, -0.0141296386718750, -0.0276794433593750,
-0.0209350585937500, -0.0267944335937500, -0.0285339355468750, -0.0243835449218750,
-0.0226135253906250, -0.0258789062500000, -0.0334777832031250, -0.0228576660156250,
-0.0351562500000000, -0.0230712890625000, -0.0310058593750000, -0.0223999023437500,
-0.0312194824218750, -0.0209655761718750, -0.0306396484375000, -0.0214233398437500,
-0.0284729003906250, -0.0145568847656250, -0.0282592773437500, -0.0168151855468750,
-0.0277404785156250, -0.0178833007812500, -0.0271301269531250, -0.0126037597656250,
-0.0276184082031250, -0.0127258300781250, -0.0240478515625000, -0.0162963867187500,
-0.0233459472656250, -0.0150451660156250, -0.0259094238281250, -0.0169677734375000,
-0.0252380371093750, -0.0208129882812500, -0.0226440429687500, -0.0182800292968750,
-0.0298461914062500, -0.0187377929687500, -0.0312194824218750, -0.0187988281250000,
-0.0263061523437500, -0.0225830078125000, -0.0268249511718750, -0.0238952636718750,
-0.0300903320312500, -0.0192260742187500, -0.0178222656250000, -0.0292053222656250,
-0.0181579589843750, -0.0313415527343750, -0.0195617675781250, -0.0285034179687500,
-0.0130615234375000, -0.0291748046875000, -0.0140991210937500, -0.0297851562500000,
-0.0218505859375000, -0.0295410156250000, -0.0181274414062500, -0.0290222167968750,
-0.0240783691406250, -0.0280151367187500, -0.0346679687500000, -0.0289611816406250,
-0.0289611816406250, -0.0289916992187500, -0.0366821289062500, -0.0186157226562500,
-0.0414733886718750, -0.0219116210937500, -0.0340881347656250, -0.0189514160156250,
-0.0319213867187500, -0.0091857910156250, -0.0368652343750000, -0.0113525390625000,
-0.0158996582031250, -0.0031738281250000, -0.0206298828125000, -0.0053100585937500,
-0.0129699707031250, -0.0007629394531250, 0.0046691894531250, 0.0085754394531250,
-0.0053405761718750, 0.0044860839843750, 0.0142211914062500, 0.0118713378906250,
0.0152587890625000, 0.0119628906250000, 0.0135192871093750, 0.0158386230468750,
0.0224914550781250, 0.0217590332031250, 0.0207519531250000, 0.0179748535156250,
0.0186767578125000, 0.0279541015625000, 0.0192565917968750, 0.0289611816406250,
0.0210571289062500, 0.0271301269531250, 0.0204772949218750, 0.0315246582031250,
0.0192871093750000, 0.0314941406250000, 0.0256042480468750, 0.0226440429687500,
0.0264587402343750, 0.0250854492187500, 0.0224914550781250, 0.0218200683593750,
0.0245056152343750, 0.0131225585937500, 0.0270690917968750, 0.0162963867187500,
0.0110778808593750, 0.0128479003906250, 0.0163879394531250, 0.0108947753906250,
0.0108642578125000, 0.0124206542968750, -0.0037841796875000, 0.0130004882812500,
0.0043945312500000, 0.0122985839843750, -0.0069580078125000, 0.0136413574218750,
-0.0079345703125000, 0.0145874023437500, -0.0079345703125000, 0.0125122070312500,
-0.0122375488281250, 0.0119323730468750, -0.0099182128906250, 0.0130920410156250,
-0.0168457031250000, 0.0047302246093750, -0.0139770507812500, 0.0067443847656250,
-0.0179138183593750, 0.0023498535156250, -0.0253295898437500, -0.0061035156250000,
-0.0200805664062500, -0.0025634765625000, -0.0300292968750000, -0.0128479003906250,
-0.0306091308593750, -0.0133666992187500, -0.0290527343750000, -0.0153198242187500,
-0.0330200195312500, -0.0220031738281250, -0.0322875976562500, -0.0204772949218750,
-0.0293579101562500, -0.0246887207031250, -0.0302734375000000, -0.0263671875000000,
-0.0294494628906250, -0.0255737304687500, -0.0273742675781250, -0.0267639160156250,
-0.0281982421875000, -0.0278625488281250, -0.0252990722656250, -0.0247497558593750,
-0.0281066894531250, -0.0258178710937500, -0.0222167968750000, -0.0244750976562500,
-0.0173034667968750, -0.0212402343750000, -0.0226440429687500, -0.0226135253906250,
0.0003051757812500, -0.0193481445312500, -0.0055847167968750, -0.0193176269531250,
0.0046997070312500, -0.0177917480468750, 0.0260009765625000, -0.0155334472656250,
0.0140991210937500, -0.0166015625000000, 0.0385131835937500, -0.0111083984375000,
0.0397644042968750, -0.0108032226562500, 0.0385742187500000, -0.0097656250000000,
0.0502624511718750, -0.0060729980468750, 0.0464477539062500, -0.0067749023437500,
0.0417480468750000, -0.0054931640625000, 0.0460510253906250, -0.0042419433593750,
0.0389404296875000, -0.0050964355468750, 0.0300292968750000, -0.0052795410156250,
0.0354614257812500, -0.0041198730468750, 0.0201110839843750, -0.0073852539062500,
0.0209350585937500, -0.0056152343750000, 0.0174560546875000, -0.0068359375000000,
0.0080566406250000, -0.0101928710937500, 0.0125122070312500, -0.0078430175781250,
-0.0017700195312500, -0.0111999511718750, 0.0016784667968750, -0.0109558105468750,
-0.0071716308593750, -0.0107116699218750, -0.0212402343750000, -0.0126647949218750,
-0.0126037597656250, -0.0118103027343750, -0.0377807617187500, -0.0110473632812500,
-0.0352783203125000, -0.0135803222656250, -0.0400085449218750, -0.0092773437500000,
-0.0570373535156250, -0.0064086914062500, -0.0490722656250000, -0.0110168457031250,
-0.0628967285156250, 0.0048217773437500, -0.0644836425781250, 0.0005493164062500,
-0.0610046386718750, 0.0046691894531250, -0.0669860839843750, 0.0176086425781250,
-0.0661315917968750, 0.0102844238281250, -0.0495605468750000, 0.0206604003906250,
-0.0570068359375000, 0.0220947265625000, -0.0443115234375000, 0.0207824707031250,
-0.0229797363281250, 0.0246887207031250, -0.0349121093750000, 0.0235290527343750,
-0.0118103027343750, 0.0215148925781250, -0.0080566406250000, 0.0238342285156250,
-0.0115051269531250, 0.0188903808593750, -0.0046691894531250, 0.0146789550781250,
-0.0048522949218750, 0.0192565917968750, -0.0062561035156250, 0.0046997070312500,
-0.0078430175781250, 0.0064697265625000, -0.0034790039062500, 0.0041198730468750,
-0.0006713867187500, -0.0052795410156250, -0.0038146972656250, -0.0014648437500000,
0.0079956054687500, -0.0114440917968750, 0.0068664550781250, -0.0088195800781250,
0.0087585449218750, -0.0148010253906250, 0.0164489746093750, -0.0252380371093750,
0.0133666992187500, -0.0184326171875000, 0.0191040039062500, -0.0318603515625000,
0.0193481445312500, -0.0355834960937500, 0.0192871093750000, -0.0278015136718750,
0.0226745605468750, -0.0265808105468750, 0.0213012695312500, -0.0316162109375000,
0.0190429687500000, -0.0241394042968750, 0.0220031738281250, -0.0170288085937500,
0.0164184570312500, -0.0295715332031250, 0.0106506347656250, -0.0391845703125000,
0.0146789550781250, -0.0299682617187500, -0.0011596679687500, -0.0504455566406250,
0.0009460449218750, -0.0523681640625000, -0.0044250488281250, -0.0529479980468750,
-0.0164794921875000, -0.0612487792968750, -0.0106201171875000, -0.0572814941406250,
-0.0261535644531250, -0.0636901855468750, -0.0249938964843750, -0.0694885253906250,
-0.0293579101562500, -0.0556945800781250, -0.0405578613281250, -0.0482788085937500,
-0.0350646972656250, -0.0593261718750000, -0.0473327636718750, -0.0289916992187500,
-0.0480957031250000, -0.0273742675781250, -0.0481872558593750, -0.0281982421875000,
-0.0549621582031250, -0.0160217285156250, -0.0534667968750000, -0.0188598632812500,
-0.0512084960937500, -0.0098266601562500, -0.0550537109375000, -0.0138244628906250,
-0.0487365722656250, -0.0072326660156250, -0.0433654785156250, 0.0048217773437500,
-0.0486450195312500, -0.0010070800781250, -0.0257873535156250, 0.0131225585937500,
-0.0314636230468750, 0.0097961425781250, -0.0219726562500000, 0.0192565917968750,
-0.0009460449218750, 0.0370178222656250, -0.0118713378906250, 0.0269775390625000,
0.0098876953125000, 0.0333862304687500, 0.0106811523437500, 0.0396728515625000,
0.0127563476562500, 0.0366516113281250, 0.0253601074218750, 0.0330810546875000,
0.0198669433593750, 0.0340576171875000, 0.0226135253906250, 0.0323181152343750,
0.0274353027343750, 0.0332336425781250, 0.0213623046875000, 0.0317077636718750,
0.0106506347656250, 0.0271606445312500, 0.0171203613281250, 0.0327453613281250,
0.0308227539062500, 0.0265197753906250, 0.0311584472656250, 0.0259094238281250,
0.0268554687500000, 0.0229187011718750, 0.0276184082031250, 0.0256652832031250,
0.0314941406250000, 0.0280151367187500, 0.0225524902343750, -0.0024414062500000,
0.0208435058593750, 0.0063476562500000, 0.0243530273437500, -0.0008850097656250,
0.0237426757812500, -0.0312194824218750, 0.0213012695312500, -0.0203552246093750,
0.0232543945312500, -0.0112304687500000, 0.0277404785156250, -0.0225830078125000,
0.0174560546875000, -0.0121154785156250, 0.0116271972656250, 0.0093994140625000,
0.0193786621093750, 0.0000610351562500, -0.0138854980468750, 0.0017089843750000,
-0.0078125000000000, 0.0109558105468750, -0.0179138183593750, -0.0002441406250000,
-0.0421752929687500, -0.0138549804687500, -0.0294189453125000, -0.0050964355468750,
-0.0658569335937500, -0.0169372558593750, -0.0606079101562500, -0.0220947265625000,
-0.0700073242187500, -0.0165710449218750, -0.0979309082031250, -0.0143737792968750,
-0.0844116210937500, -0.0176086425781250, -0.1081542968750000, -0.0170593261718750,
-0.1105041503906250, -0.0120544433593750, -0.1076660156250000, -0.0202331542968750,
-0.1210632324218750, -0.0299377441406250, -0.1176147460937500, -0.0232238769531250,
-0.0896911621093750, -0.0305786132812500, -0.1078491210937500, -0.0375366210937500,
-0.0806884765625000, -0.0265197753906250, -0.0375366210937500, -0.0190734863281250,
-0.0645446777343750, -0.0272827148437500, -0.0160522460937500, -0.0066528320312500,
-0.0083312988281250, -0.0053405761718750, -0.0176391601562500, -0.0071105957031250,
-0.0029296875000000, 0.0008239746093750, -0.0030517578125000, -0.0007324218750000,
-0.0166625976562500, 0.0000305175781250, -0.0117492675781250, -0.0019226074218750,
-0.0185852050781250, 0.0027465820312500, -0.0327453613281250, 0.0074157714843750,
-0.0236206054687500, 0.0030822753906250, -0.0313415527343750, 0.0134582519531250,
-0.0377197265625000, 0.0151367187500000, -0.0278320312500000, 0.0119628906250000,
-0.0228271484375000, 0.0147705078125000, -0.0292968750000000, 0.0161437988281250,
-0.0064086914062500, 0.0085754394531250, -0.0116577148437500, 0.0096435546875000,
-0.0035400390625000, 0.0087585449218750, 0.0154418945312500, 0.0040893554687500,
0.0047302246093750, 0.0058288574218750, 0.0270996093750000, 0.0020141601562500,
0.0275573730468750, 0.0032958984375000, 0.0267944335937500, 0.0003967285156250,
0.0393981933593750, -0.0037536621093750, 0.0360107421875000, -0.0008544921875000,
0.0278625488281250, -0.0098266601562500, 0.0344238281250000, -0.0079345703125000,
0.0267333984375000, -0.0125122070312500, 0.0143737792968750, -0.0197448730468750,
0.0225830078125000, -0.0147705078125000, 0.0072021484375000, -0.0318298339843750,
0.0079345703125000, -0.0289916992187500, 0.0065612792968750, -0.0338134765625000,
-0.0025024414062500, -0.0477905273437500, 0.0021057128906250, -0.0413513183593750,
-0.0033264160156250, -0.0506896972656250, -0.0047607421875000, -0.0533447265625000,
-0.0027160644531250, -0.0501403808593750, -0.0042419433593750, -0.0527648925781250,
-0.0052185058593750},
{0.0122375488281250, 0.0424194335937500, 0.0158081054687500, 0.0371704101562500,
0.0130004882812500, 0.0368347167968750, 0.0093078613281250, 0.0415649414062500,
0.0152587890625000, 0.0361022949218750, 0.0251770019531250, 0.0243225097656250,
0.0340270996093750, 0.0370788574218750, 0.0282287597656250, 0.0306091308593750,
0.0267944335937500, 0.0401611328125000, 0.0303955078125000, 0.0329895019531250,
0.0328979492187500, 0.0198974609375000, 0.0298156738281250, 0.0249023437500000,
0.0311889648437500, 0.0243835449218750, 0.0381164550781250, 0.0238952636718750,
0.0225830078125000, 0.0180358886718750, 0.0120849609375000, 0.0169982910156250,
0.0244140625000000, 0.0223999023437500, -0.0198974609375000, -0.0029602050781250,
-0.0158081054687500, -0.0003662109375000, -0.0208129882812500, -0.0008239746093750,
-0.0501403808593750, -0.0174865722656250, -0.0397644042968750, -0.0132141113281250,
-0.0466613769531250, -0.0053710937500000, -0.0474853515625000, -0.0101928710937500,
-0.0554809570312500, -0.0057678222656250, -0.0611267089843750, 0.0056152343750000,
-0.0529479980468750, 0.0012207031250000, -0.0838928222656250, -0.0010986328125000,
-0.0800476074218750, 0.0046997070312500, -0.0850524902343750, -0.0024108886718750,
-0.1085815429687500, -0.0129394531250000, -0.0982055664062500, -0.0068664550781250,
-0.0950622558593750, -0.0132446289062500, -0.1117248535156250, -0.0172424316406250,
-0.0809020996093750, -0.0132446289062500, -0.0530700683593750, -0.0099487304687500,
-0.0797729492187500, -0.0126647949218750, -0.0090942382812500, -0.0145568847656250,
-0.0053710937500000, -0.0107116699218750, -0.0146484375000000, -0.0154113769531250,
0.0158691406250000, -0.0239257812500000, 0.0128479003906250, -0.0197448730468750,
-0.0123901367187500, -0.0175781250000000, -0.0020141601562500, -0.0244750976562500,
-0.0117797851562500, -0.0149536132812500, -0.0379333496093750, -0.0031127929687500,
-0.0251464843750000, -0.0113220214843750, -0.0350341796875000, 0.0043029785156250,
-0.0451660156250000, 0.0069885253906250, -0.0272216796875000, 0.0036315917968750,
-0.0173950195312500, 0.0071105957031250, -0.0312194824218750, 0.0074768066406250,
0.0088195800781250, 0.0060729980468750, 0.0071105957031250, 0.0040588378906250,
0.0071716308593750, 0.0075988769531250, 0.0290527343750000, 0.0109558105468750,
0.0218505859375000, 0.0080261230468750, 0.0220336914062500, 0.0131225585937500,
0.0282897949218750, 0.0155029296875000, 0.0205688476562500, 0.0115051269531250,
0.0132751464843750, 0.0103454589843750, 0.0195922851562500, 0.0128479003906250,
0.0012512207031250, 0.0035400390625000, 0.0027465820312500, 0.0047607421875000,
0.0007324218750000, 0.0022277832031250, -0.0122375488281250, -0.0041503906250000,
-0.0072326660156250, -0.0008544921875000, -0.0047607421875000, -0.0101928710937500,
-0.0112915039062500, -0.0086669921875000, -0.0033569335937500, -0.0112915039062500,
0.0062255859375000, -0.0186462402343750, -0.0014343261718750, -0.0148010253906250,
0.0150146484375000, -0.0212097167968750, 0.0130004882812500, -0.0218200683593750,
0.0156555175781250, -0.0221557617187500, 0.0261230468750000, -0.0254211425781250,
0.0199584960937500, -0.0242919921875000, 0.0304565429687500, -0.0262145996093750,
0.0301208496093750, -0.0277099609375000, 0.0309753417968750, -0.0256347656250000,
0.0370788574218750, -0.0252685546875000, 0.0342407226562500, -0.0274047851562500,
0.0383300781250000, -0.0202026367187500, 0.0390930175781250, -0.0223083496093750,
0.0381164550781250, -0.0192871093750000, 0.0401916503906250, -0.0140380859375000,
0.0409240722656250, -0.0178833007812500, 0.0363769531250000, -0.0031738281250000,
0.0398559570312500, -0.0079040527343750, 0.0368347167968750, 0.0009155273437500,
0.0315856933593750, 0.0162658691406250, 0.0362548828125000, 0.0068359375000000,
0.0254211425781250, 0.0290527343750000, 0.0283508300781250, 0.0291442871093750,
0.0249023437500000, 0.0303344726562500, 0.0166320800781250, 0.0422058105468750,
0.0231933593750000, 0.0378417968750000, 0.0109558105468750, 0.0432434082031250,
0.0136413574218750, 0.0440063476562500, 0.0106811523437500, 0.0435485839843750,
0.0022277832031250, 0.0458068847656250, 0.0084533691406250, 0.0451354980468750,
-0.0044250488281250, 0.0457458496093750, -0.0016784667968750, 0.0462951660156250,
-0.0045776367187500, 0.0451660156250000, -0.0140075683593750, 0.0451354980468750,
-0.0079345703125000, 0.0455627441406250, -0.0173645019531250, 0.0396118164062500,
-0.0163574218750000, 0.0429382324218750, -0.0159912109375000, 0.0357055664062500,
-0.0205688476562500, 0.0275268554687500, -0.0168151855468750, 0.0334777832031250,
-0.0183715820312500, 0.0100708007812500, -0.0183410644531250, 0.0147094726562500,
-0.0163879394531250, 0.0060119628906250, -0.0156860351562500, -0.0144042968750000,
-0.0150451660156250, -0.0039672851562500, -0.0130310058593750, -0.0221862792968750,
-0.0131530761718750, -0.0258178710937500, -0.0116271972656250, -0.0211181640625000,
-0.0097961425781250, -0.0256958007812500, -0.0104370117187500, -0.0270996093750000,
-0.0056762695312500, -0.0198059082031250, -0.0065917968750000, -0.0199890136718750,
-0.0051574707031250, -0.0206604003906250, -0.0011291503906250, -0.0182189941406250,
-0.0030822753906250, -0.0186462402343750, -0.0010986328125000, -0.0159606933593750,
-0.0007629394531250, -0.0205688476562500, -0.0016784667968750, -0.0115966796875000,
-0.0018920898437500, -0.0029907226562500, -0.0023193359375000, -0.0117492675781250,
-0.0028381347656250, 0.0119323730468750, -0.0033569335937500, 0.0111694335937500,
-0.0030517578125000, 0.0114135742187500, -0.0028076171875000, 0.0252075195312500,
-0.0032958984375000, 0.0210876464843750, -0.0021667480468750, 0.0188293457031250,
-0.0021057128906250, 0.0234985351562500, -0.0017395019531250, 0.0185852050781250,
-0.0014038085937500, 0.0110778808593750, -0.0014953613281250, 0.0164184570312500,
0.0028076171875000, 0.0127563476562500, 0.0010070800781250, 0.0085449218750000,
0.0048217773437500, 0.0145263671875000, 0.0104980468750000, 0.0194396972656250,
0.0070495605468750, 0.0142211914062500, 0.0153503417968750, 0.0196533203125000,
0.0157470703125000, 0.0234680175781250, 0.0152282714843750, 0.0177307128906250,
0.0196228027343750, 0.0146179199218750, 0.0185852050781250, 0.0183410644531250,
0.0142211914062500, 0.0076599121093750, 0.0173034667968750, 0.0094604492187500,
0.0132751464843750, 0.0041198730468750, 0.0068664550781250, -0.0043334960937500,
0.0108337402343750, 0.0017700195312500, 0.0021972656250000, -0.0154113769531250,
0.0028686523437500, -0.0143432617187500, 0.0004272460937500, -0.0158081054687500,
-0.0063781738281250, -0.0266418457031250, -0.0030212402343750, -0.0230712890625000,
-0.0064392089843750, -0.0257873535156250, -0.0085449218750000, -0.0283813476562500,
-0.0067443847656250, -0.0262756347656250, -0.0066223144531250, -0.0247497558593750,
-0.0073242187500000, -0.0268554687500000, -0.0005187988281250, -0.0252685546875000,
-0.0021667480468750, -0.0238342285156250, -0.0032653808593750, -0.0251770019531250,
0.0031738281250000, -0.0279846191406250, 0.0030822753906250, -0.0271301269531250,
-0.0098571777343750, -0.0196228027343750, -0.0058593750000000, -0.0246582031250000,
-0.0122375488281250, -0.0200500488281250, -0.0252380371093750, -0.0093994140625000,
-0.0182800292968750, -0.0149536132812500, -0.0297241210937500, -0.0092773437500000,
-0.0356140136718750, -0.0074768066406250, -0.0256652832031250, -0.0086669921875000,
-0.0216369628906250, -0.0073852539062500, -0.0285339355468750, -0.0073852539062500,
-0.0103454589843750, -0.0088195800781250, -0.0079040527343750, -0.0080566406250000,
-0.0136108398437500, -0.0110168457031250, -0.0102539062500000, -0.0138244628906250,
-0.0107421875000000, -0.0125122070312500, -0.0233459472656250, -0.0214538574218750,
-0.0209960937500000, -0.0210266113281250, -0.0198059082031250, -0.0177307128906250,
-0.0264282226562500, -0.0202636718750000, -0.0241699218750000, -0.0211791992187500,
-0.0218200683593750, -0.0166320800781250, -0.0249023437500000, -0.0142211914062500,
-0.0209350585937500, -0.0189819335937500, -0.0143737792968750, -0.0202636718750000,
-0.0185241699218750, -0.0161437988281250, -0.0186462402343750, -0.0300903320312500,
-0.0138244628906250, -0.0300292968750000, -0.0190429687500000, -0.0301818847656250,
-0.0260009765625000, -0.0379638671875000, -0.0213317871093750, -0.0352172851562500,
-0.0266723632812500, -0.0315246582031250, -0.0285644531250000, -0.0392456054687500,
-0.0263977050781250, -0.0247802734375000, -0.0265808105468750, -0.0090942382812500,
-0.0269775390625000, -0.0209350585937500, -0.0232849121093750, 0.0075683593750000,
-0.0247802734375000, 0.0100097656250000, -0.0210266113281250, 0.0072631835937500,
-0.0166625976562500, 0.0188293457031250, -0.0204162597656250, 0.0178833007812500,
-0.0098571777343750, 0.0156555175781250, -0.0089416503906250, 0.0155639648437500,
-0.0127563476562500, 0.0172729492187500, -0.0088195800781250, 0.0182189941406250,
-0.0074462890625000, 0.0173034667968750, -0.0223388671875000, 0.0184631347656250,
-0.0197753906250000, 0.0177307128906250, -0.0212707519531250, 0.0202636718750000,
-0.0331115722656250, 0.0233764648437500, -0.0300598144531250, 0.0206604003906250,
-0.0249938964843750, 0.0213928222656250, -0.0310668945312500, 0.0239562988281250,
-0.0226135253906250, 0.0213317871093750, -0.0122070312500000, 0.0179138183593750,
-0.0202331542968750, 0.0200195312500000, 0.0005798339843750, 0.0178833007812500,
-0.0023803710937500, 0.0173339843750000, 0.0014953613281250, 0.0177917480468750,
0.0162658691406250, 0.0182495117187500, 0.0090026855468750, 0.0182189941406250,
0.0192565917968750, 0.0132751464843750, 0.0206604003906250, 0.0165405273437500,
0.0192565917968750, 0.0106201171875000, 0.0224304199218750, 0.0021667480468750,
0.0217590332031250, 0.0069580078125000, 0.0241394042968750, -0.0059204101562500,
0.0233459472656250, -0.0072021484375000, 0.0242614746093750, -0.0074462890625000,
0.0273437500000000, -0.0139465332031250, 0.0260620117187500, -0.0120849609375000,
0.0241699218750000, -0.0097045898437500, 0.0274353027343750, -0.0118103027343750,
0.0231323242187500, -0.0077819824218750, 0.0178833007812500, -0.0025024414062500,
0.0222167968750000, -0.0050964355468750, 0.0122375488281250, 0.0014038085937500,
0.0135498046875000, 0.0024719238281250, 0.0114135742187500, 0.0019226074218750,
0.0050659179687500, 0.0046691894531250, 0.0086975097656250, 0.0046386718750000,
-0.0009765625000000, 0.0021362304687500, 0.0005798339843750, 0.0035705566406250,
-0.0020141601562500, 0.0011291503906250, -0.0097351074218750, -0.0025329589843750,
-0.0054626464843750, -0.0008850097656250, -0.0100708007812500, -0.0075683593750000,
-0.0119934082031250, -0.0077514648437500, -0.0074768066406250, -0.0104370117187500,
-0.0059509277343750, -0.0162353515625000, -0.0068359375000000, -0.0149841308593750,
0.0047302246093750, -0.0189819335937500, 0.0037841796875000, -0.0216369628906250,
0.0079956054687500, -0.0204467773437500, 0.0174255371093750, -0.0210571289062500,
0.0137329101562500, -0.0232543945312500, 0.0198974609375000, -0.0177612304687500,
0.0216674804687500, -0.0204467773437500, 0.0194702148437500, -0.0185852050781250,
0.0202636718750000, -0.0137023925781250, 0.0213012695312500, -0.0174865722656250,
0.0181274414062500, -0.0099792480468750, 0.0176696777343750, -0.0122070312500000,
0.0184631347656250, -0.0103149414062500, 0.0178222656250000, -0.0046081542968750,
0.0177612304687500, -0.0088500976562500, 0.0189208984375000, -0.0015258789062500,
0.0190124511718750},
{-0.0155639648437500, -0.0321044921875000, -0.0168762207031250, -0.0363464355468750,
-0.0197753906250000, -0.0279541015625000, -0.0131530761718750, -0.0234069824218750,
-0.0119323730468750, -0.0292663574218750, -0.0233764648437500, 0.0016784667968750,
-0.0223693847656250, -0.0017395019531250, -0.0216979980468750, 0.0006713867187500,
-0.0282592773437500, 0.0215454101562500, -0.0272827148437500, 0.0159912109375000,
-0.0224914550781250, 0.0164184570312500, -0.0244750976562500, 0.0208129882812500,
-0.0223083496093750, 0.0169677734375000, -0.0176391601562500, 0.0121765136718750,
-0.0196533203125000, 0.0152587890625000, -0.0139465332031250, 0.0100402832031250,
-0.0156860351562500, 0.0098876953125000, -0.0117797851562500, 0.0105285644531250,
-0.0051269531250000, 0.0066528320312500, -0.0097045898437500, 0.0072021484375000,
-0.0032653808593750, 0.0158691406250000, 0.0007324218750000, 0.0127258300781250,
-0.0068359375000000, 0.0145874023437500, -0.0101623535156250, 0.0229492187500000,
-0.0048828125000000, 0.0205993652343750, -0.0212402343750000, 0.0215759277343750,
-0.0215759277343750, 0.0238952636718750, -0.0194396972656250, 0.0196533203125000,
-0.0275573730468750, 0.0174865722656250, -0.0270996093750000, 0.0205688476562500,
-0.0177612304687500, 0.0061340332031250, -0.0230102539062500, 0.0090026855468750,
-0.0156555175781250, 0.0029296875000000, -0.0043029785156250, -0.0107727050781250,
-0.0120849609375000, -0.0040283203125000, 0.0079650878906250, -0.0134582519531250,
0.0057983398437500, -0.0175781250000000, 0.0085449218750000, -0.0122985839843750,
0.0218505859375000, -0.0115051269531250, 0.0158691406250000, -0.0140991210937500,
0.0232543945312500, -0.0030517578125000, 0.0243225097656250, -0.0033264160156250,
0.0237731933593750, -0.0018310546875000, 0.0265197753906250, 0.0055847167968750,
0.0255126953125000, 0.0031433105468750, 0.0271606445312500, 0.0012817382812500,
0.0278625488281250, 0.0046691894531250, 0.0261840820312500, -0.0017700195312500,
0.0262451171875000, -0.0085754394531250, 0.0273437500000000, -0.0044250488281250,
0.0208740234375000, -0.0189819335937500, 0.0229797363281250, -0.0184936523437500,
0.0209655761718750, -0.0226135253906250, 0.0150451660156250, -0.0330505371093750,
0.0185241699218750, -0.0292358398437500, 0.0160827636718750, -0.0391235351562500,
0.0143737792968750, -0.0398864746093750, 0.0179748535156250, -0.0404357910156250,
0.0202331542968750, -0.0455932617187500, 0.0191040039062500, -0.0438842773437500,
0.0265808105468750, -0.0443420410156250, 0.0270080566406250, -0.0453796386718750,
0.0281066894531250, -0.0421752929687500, 0.0331115722656250, -0.0395812988281250,
0.0324707031250000, -0.0404968261718750, 0.0316467285156250, -0.0330810546875000,
0.0343627929687500, -0.0332031250000000, 0.0316772460937500, -0.0296020507812500,
0.0279846191406250, -0.0235900878906250, 0.0307617187500000, -0.0256652832031250,
0.0242309570312500, -0.0171203613281250, 0.0246276855468750, -0.0176391601562500,
0.0229492187500000, -0.0144348144531250, 0.0186157226562500, -0.0077209472656250,
0.0209350585937500, -0.0108032226562500, 0.0150756835937500, -0.0036926269531250,
0.0156250000000000, -0.0032653808593750, 0.0130615234375000, -0.0030212402343750,
0.0083618164062500, 0.0003051757812500, 0.0110168457031250, -0.0006713867187500,
0.0038452148437500, 0.0015563964843750, 0.0035400390625000, 0.0009155273437500,
0.0033569335937500, 0.0019226074218750, -0.0008239746093750, 0.0037231445312500,
-0.0002441406250000, 0.0018310546875000, 0.0003662109375000, 0.0048522949218750,
-0.0015869140625000, 0.0041809082031250, 0.0004272460937500, 0.0046386718750000,
0.0028381347656250, 0.0066833496093750, 0.0007934570312500, 0.0051879882812500,
0.0070190429687500, 0.0075378417968750, 0.0046386718750000, 0.0083007812500000,
0.0103454589843750, 0.0062255859375000, 0.0173950195312500, 0.0067443847656250,
0.0126037597656250, 0.0079040527343750, 0.0323486328125000, -0.0010986328125000,
0.0303649902343750, 0.0026855468750000, 0.0343017578125000, -0.0025634765625000,
0.0499877929687500, -0.0121459960937500, 0.0451965332031250, -0.0056457519531250,
0.0463867187500000, -0.0179748535156250, 0.0516357421875000, -0.0184326171875000,
0.0465698242187500, -0.0168151855468750, 0.0408630371093750, -0.0230102539062500,
0.0453796386718750, -0.0219116210937500, 0.0374145507812500, -0.0158996582031250,
0.0372924804687500, -0.0210266113281250, 0.0359802246093750, -0.0137023925781250,
0.0322265625000000, -0.0036621093750000, 0.0351562500000000, -0.0110168457031250,
0.0274658203125000, 0.0064086914062500, 0.0291442871093750, 0.0043334960937500,
0.0267944335937500, 0.0072021484375000, 0.0204772949218750, 0.0192565917968750,
0.0236511230468750, 0.0136413574218750, 0.0169677734375000, 0.0213623046875000,
0.0176696777343750, 0.0232543945312500, 0.0148925781250000, 0.0211791992187500,
0.0099487304687500, 0.0238037109375000, 0.0132446289062500, 0.0240478515625000,
0.0038146972656250, 0.0155029296875000, 0.0049438476562500, 0.0199584960937500,
0.0023193359375000, 0.0122985839843750, -0.0041503906250000, 0.0005798339843750,
-0.0006408691406250, 0.0068969726562500, -0.0100097656250000, -0.0120849609375000,
-0.0084228515625000, -0.0126953125000000, -0.0125122070312500, -0.0122985839843750,
-0.0209045410156250, -0.0230407714843750, -0.0162658691406250, -0.0207824707031250,
-0.0256652832031250, -0.0122680664062500, -0.0267944335937500, -0.0150756835937500,
-0.0256958007812500, -0.0132751464843750, -0.0292968750000000, -0.0052490234375000,
-0.0290222167968750, -0.0068359375000000, -0.0271911621093750, -0.0068969726562500,
-0.0281982421875000, -0.0052795410156250, -0.0268249511718750, -0.0083007812500000,
-0.0253906250000000, -0.0083007812500000, -0.0267333984375000, -0.0064697265625000,
-0.0189819335937500, -0.0271606445312500, -0.0227661132812500, -0.0187683105468750,
-0.0150451660156250, -0.0290527343750000, -0.0052185058593750, -0.0533447265625000,
-0.0124206542968750, -0.0421752929687500, 0.0100402832031250, -0.0555114746093750,
0.0080566406250000, -0.0618896484375000, 0.0117187500000000, -0.0513305664062500,
0.0280761718750000, -0.0491638183593750, 0.0216674804687500, -0.0555114746093750,
0.0236816406250000, -0.0317382812500000, 0.0291748046875000, -0.0346984863281250,
0.0231018066406250, -0.0290527343750000, 0.0157775878906250, -0.0105895996093750,
0.0209655761718750, -0.0190429687500000, 0.0176696777343750, -0.0150146484375000,
0.0126953125000000, -0.0103454589843750, 0.0194702148437500, -0.0099792480468750,
0.0258178710937500, -0.0122985839843750, 0.0211181640625000, -0.0140686035156250,
0.0312194824218750, -0.0064392089843750, 0.0326538085937500, -0.0067749023437500,
0.0316162109375000, -0.0041809082031250, 0.0353393554687500, 0.0011596679687500,
0.0349121093750000, -0.0025024414062500, 0.0321655273437500, 0.0003967285156250,
0.0321044921875000, 0.0022583007812500, 0.0349426269531250, 0.0050354003906250,
0.0369873046875000, 0.0085449218750000, 0.0302429199218750, 0.0109252929687500,
-0.0203857421875000, 0.0046691894531250, -0.0021972656250000, 0.0013122558593750,
-0.0128479003906250, 0.0107116699218750, -0.0408020019531250, 0.0150146484375000,
-0.0309448242187500, 0.0082702636718750, -0.0335693359375000, 0.0322875976562500,
-0.0401611328125000, 0.0326232910156250, -0.0339050292968750, 0.0288085937500000,
-0.0252075195312500, 0.0399475097656250, -0.0298767089843750, 0.0397338867187500,
-0.0325927734375000, 0.0262756347656250, -0.0235290527343750, 0.0297546386718750,
-0.0382690429687500, 0.0262451171875000, -0.0552368164062500, 0.0144653320312500,
-0.0409851074218750, 0.0191040039062500, -0.0614318847656250, 0.0166625976562500,
-0.0698547363281250, 0.0149536132812500, -0.0590209960937500, 0.0142822265625000,
-0.0573120117187500, 0.0154418945312500, -0.0622863769531250, 0.0164184570312500,
-0.0412902832031250, 0.0039672851562500, -0.0453796386718750, 0.0072021484375000,
-0.0385742187500000, 0.0047302246093750, -0.0196533203125000, -0.0071716308593750,
-0.0285034179687500, -0.0034179687500000, -0.0220031738281250, 0.0012207031250000,
-0.0150451660156250, -0.0025634765625000, -0.0203247070312500, 0.0004272460937500,
-0.0279541015625000, 0.0086364746093750, -0.0235290527343750, 0.0058898925781250,
-0.0137329101562500, 0.0019226074218750, -0.0219726562500000, 0.0051879882812500,
-0.0136413574218750, 0.0025939941406250, 0.0016479492187500, -0.0041198730468750,
-0.0063171386718750, -0.0018310546875000, 0.0121765136718750, -0.0012207031250000,
0.0114440917968750, -0.0027465820312500, 0.0121765136718750, -0.0028991699218750,
0.0239868164062500, -0.0006713867187500, 0.0202026367187500, -0.0008544921875000,
0.0165405273437500, -0.0072021484375000, 0.0217895507812500, -0.0061340332031250,
0.0168457031250000, -0.0060729980468750, 0.0068054199218750, -0.0118103027343750,
0.0114746093750000, -0.0113830566406250, 0.0118103027343750, -0.0018615722656250,
0.0064697265625000, -0.0059204101562500, 0.0108337402343750, -0.0012817382812500,
0.0162963867187500, 0.0101318359375000, 0.0117187500000000, 0.0051574707031250,
0.0232849121093750, 0.0087890625000000, 0.0214843750000000, 0.0117492675781250,
0.0224304199218750, 0.0092163085937500, 0.0314941406250000, 0.0066833496093750,
0.0280456542968750, 0.0079956054687500, 0.0237731933593750, 0.0099792480468750,
0.0303955078125000, 0.0072326660156250, 0.0191345214843750, 0.0108642578125000,
0.0070495605468750, 0.0158386230468750, 0.0172424316406250, 0.0127258300781250,
-0.0081176757812500, 0.0200195312500000, -0.0084533691406250, 0.0191650390625000,
-0.0081481933593750, 0.0217590332031250, -0.0204162597656250, 0.0268859863281250,
-0.0166015625000000, 0.0232543945312500, -0.0189514160156250, 0.0322265625000000,
-0.0203857421875000, 0.0314331054687500, -0.0186157226562500, 0.0317077636718750,
-0.0187683105468750, 0.0371704101562500, -0.0196533203125000, 0.0350646972656250,
-0.0144653320312500, 0.0351562500000000, -0.0163574218750000, 0.0362243652343750,
-0.0132446289062500, 0.0343322753906250, -0.0081176757812500, 0.0329895019531250,
-0.0116882324218750, 0.0338134765625000, -0.0026855468750000, 0.0279846191406250,
-0.0036315917968750, 0.0297851562500000, -0.0017700195312500, 0.0255737304687500,
0.0046081542968750, 0.0191650390625000, 0.0017089843750000, 0.0229492187500000,
0.0073852539062500, 0.0122680664062500, 0.0079956054687500, 0.0134582519531250,
0.0088500976562500, 0.0101013183593750, 0.0119628906250000, 0.0020446777343750,
0.0111083984375000, 0.0063476562500000, 0.0142517089843750, -0.0026855468750000,
0.0152587890625000, -0.0035705566406250, 0.0146789550781250, -0.0017395019531250,
0.0163879394531250, -0.0053710937500000, 0.0178527832031250, -0.0049133300781250,
0.0142517089843750, 0.0021667480468750, 0.0166625976562500, 0.0009155273437500,
0.0145874023437500, 0.0031127929687500, 0.0105590820312500, 0.0095214843750000,
0.0141601562500000, 0.0077209472656250, 0.0082397460937500, 0.0089721679687500,
0.0094604492187500, 0.0106811523437500, 0.0084838867187500, 0.0101318359375000,
0.0049133300781250, 0.0086975097656250, 0.0080566406250000, 0.0098266601562500,
0.0014953613281250, 0.0134887695312500, 0.0038757324218750, 0.0103454589843750,
0.0015258789062500, 0.0171508789062500, -0.0043029785156250, 0.0245971679687500,
-0.0001831054687500, 0.0192260742187500, -0.0079345703125000, 0.0366516113281250,
-0.0072631835937500, 0.0355834960937500, -0.0085144042968750, 0.0371093750000000,
-0.0130310058593750},
{-0.0055236816406250, 0.0062255859375000, 0.0169982910156250, -0.0058288574218750,
0.0054321289062500, -0.0032043457031250, 0.0108642578125000, 0.0017700195312500,
0.0184326171875000, -0.0004882812500000, 0.0136413574218750, -0.0001831054687500,
0.0069274902343750, 0.0048217773437500, 0.0097656250000000, 0.0040283203125000,
0.0104675292968750, -0.0012817382812500, 0.0071411132812500, 0.0001831054687500,
0.0122680664062500, -0.0004882812500000, 0.0166931152343750, -0.0050048828125000,
0.0123596191406250, -0.0041809082031250, 0.0274353027343750, -0.0026855468750000,
0.0243835449218750, -0.0028991699218750, 0.0273742675781250, -0.0047912597656250,
0.0403137207031250, -0.0045166015625000, 0.0343933105468750, -0.0031433105468750,
0.0326232910156250, -0.0104675292968750, 0.0379638671875000, -0.0112609863281250,
0.0331726074218750, -0.0082092285156250, 0.0262145996093750, -0.0114135742187500,
0.0298461914062500, -0.0130615234375000, 0.0202941894531250, 0.0020751953125000,
0.0226135253906250, -0.0022888183593750, 0.0170898437500000, 0.0032653808593750,
0.0079345703125000, 0.0172119140625000, 0.0140380859375000, 0.0107421875000000,
-0.0021667480468750, 0.0220947265625000, -0.0020751953125000, 0.0215759277343750,
-0.0016784667968750, 0.0249328613281250, -0.0104675292968750, 0.0319213867187500,
-0.0090637207031250, 0.0270996093750000, -0.0078430175781250, 0.0421142578125000,
-0.0079040527343750, 0.0404052734375000, -0.0105285644531250, 0.0428161621093750,
-0.0108642578125000, 0.0534057617187500, -0.0085144042968750, 0.0489196777343750,
-0.0169982910156250, 0.0533447265625000, -0.0154724121093750, 0.0546569824218750,
-0.0169677734375000, 0.0534973144531250, -0.0227661132812500, 0.0544433593750000,
-0.0195312500000000, 0.0541381835937500, -0.0239868164062500, 0.0523986816406250,
-0.0238037109375000, 0.0538940429687500, -0.0234375000000000, 0.0505676269531250,
-0.0255737304687500, 0.0475769042968750, -0.0242004394531250, 0.0502014160156250,
-0.0242614746093750, 0.0386962890625000, -0.0248107910156250, 0.0419311523437500,
-0.0229797363281250, 0.0350341796875000, -0.0218811035156250, 0.0242919921875000,
-0.0228271484375000, 0.0313415527343750, -0.0176086425781250, 0.0099487304687500,
-0.0192260742187500, 0.0129699707031250, -0.0167541503906250, 0.0071105957031250,
-0.0119934082031250, -0.0090942382812500, -0.0151672363281250, -0.0011291503906250,
-0.0087280273437500, -0.0169677734375000, -0.0097656250000000, -0.0167541503906250,
-0.0079650878906250, -0.0190734863281250, -0.0038146972656250, -0.0286254882812500,
-0.0071411132812500, -0.0239257812500000, 0.0013732910156250, -0.0313110351562500,
-0.0009460449218750, -0.0321350097656250, 0.0019836425781250, -0.0299072265625000,
0.0094604492187500, -0.0321655273437500, 0.0045166015625000, -0.0314941406250000,
0.0107421875000000, -0.0253295898437500, 0.0114135742187500, -0.0278320312500000,
0.0086364746093750, -0.0217590332031250, 0.0096130371093750, -0.0143127441406250,
0.0091857910156250, -0.0190429687500000, 0.0035400390625000, -0.0017089843750000,
0.0037231445312500, -0.0050048828125000, 0.0008850097656250, 0.0026855468750000,
-0.0040893554687500, 0.0178833007812500, -0.0031433105468750, 0.0097045898437500,
-0.0090637207031250, 0.0298767089843750, -0.0087585449218750, 0.0299072265625000,
-0.0112304687500000, 0.0325012207031250, -0.0159606933593750, 0.0439147949218750,
-0.0139770507812500, 0.0391540527343750, -0.0195922851562500, 0.0494079589843750,
-0.0195922851562500, 0.0472106933593750, -0.0202026367187500, 0.0516662597656250,
-0.0235290527343750, 0.0610961914062500, -0.0224304199218750, 0.0545654296875000,
-0.0246582031250000, 0.0637512207031250, -0.0244140625000000, 0.0673522949218750,
-0.0249633789062500, 0.0600585937500000, -0.0260620117187500, 0.0591735839843750,
-0.0247497558593750, 0.0632629394531250, -0.0280456542968750, 0.0447692871093750,
-0.0268249511718750, 0.0484008789062500, -0.0282287597656250, 0.0433349609375000,
-0.0313720703125000, 0.0286865234375000, -0.0290832519531250, 0.0361938476562500,
-0.0328674316406250, 0.0253601074218750, -0.0332336425781250, 0.0231628417968750,
-0.0326232910156250, 0.0250244140625000, -0.0345458984375000, 0.0223388671875000,
-0.0345764160156250, 0.0215759277343750, -0.0323486328125000, 0.0186157226562500,
-0.0337829589843750, 0.0220336914062500, -0.0321960449218750, 0.0150146484375000,
-0.0298156738281250, 0.0072326660156250, -0.0314331054687500, 0.0135192871093750,
-0.0240173339843750, -0.0009765625000000, -0.0262756347656250, -0.0010375976562500,
-0.0203552246093750, -0.0026245117187500, -0.0115966796875000, -0.0102539062500000,
-0.0166320800781250, -0.0066833496093750, -0.0021972656250000, -0.0145874023437500,
-0.0016174316406250, -0.0150756835937500, -0.0012512207031250, -0.0130310058593750,
0.0061340332031250, -0.0166015625000000, 0.0040893554687500, -0.0174865722656250,
0.0046386718750000, -0.0112915039062500, 0.0050048828125000, -0.0123596191406250,
0.0046386718750000, -0.0130310058593750, 0.0043640136718750, -0.0098876953125000,
0.0038757324218750, -0.0106506347656250, 0.0043029785156250, -0.0107727050781250,
0.0045471191406250, -0.0115966796875000, 0.0030517578125000, -0.0110168457031250,
0.0026855468750000, -0.0101928710937500, 0.0037231445312500, -0.0111999511718750,
-0.0007629394531250, -0.0087585449218750, 0.0005798339843750, -0.0100097656250000,
-0.0028991699218750, -0.0078430175781250, -0.0073242187500000, -0.0040588378906250,
-0.0033874511718750, -0.0066223144531250, -0.0133666992187500, -0.0043640136718750,
-0.0157775878906250, -0.0024414062500000, -0.0104675292968750, -0.0044555664062500,
-0.0109863281250000, -0.0060424804687500, -0.0137939453125000, -0.0049438476562500,
-0.0029907226562500, -0.0073242187500000, -0.0038757324218750, -0.0061645507812500,
-0.0033569335937500, -0.0105590820312500, 0.0048522949218750, -0.0149841308593750,
0.0025024414062500, -0.0101013183593750, -0.0072021484375000, -0.0166625976562500,
-0.0022583007812500, -0.0187377929687500, -0.0071105957031250, -0.0180969238281250,
-0.0185852050781250, -0.0186157226562500, -0.0136718750000000, -0.0169982910156250,
-0.0210876464843750, -0.0178222656250000, -0.0236511230468750, -0.0187072753906250,
-0.0194702148437500, -0.0191040039062500, -0.0183105468750000, -0.0182800292968750,
-0.0182189941406250, -0.0180358886718750, -0.0089721679687500, -0.0241394042968750,
-0.0111694335937500, -0.0230102539062500, -0.0122070312500000, -0.0215759277343750,
-0.0057678222656250, -0.0249328613281250, -0.0057678222656250, -0.0244140625000000,
-0.0104370117187500, -0.0187988281250000, -0.0103759765625000, -0.0213623046875000,
-0.0079650878906250, -0.0167236328125000, -0.0076293945312500, -0.0108947753906250,
-0.0094299316406250, -0.0151367187500000, -0.0120239257812500, 0.0015563964843750,
-0.0090332031250000, 0.0013732910156250, -0.0084533691406250, -0.0021057128906250,
-0.0136413574218750, 0.0055847167968750, -0.0137023925781250, 0.0069885253906250,
-0.0028076171875000, -0.0012817382812500, -0.0050659179687500, -0.0004272460937500,
-0.0049743652343750, -0.0031738281250000, 0.0034790039062500, -0.0090637207031250,
0.0021057128906250, -0.0051574707031250, -0.0042419433593750, -0.0093078613281250,
-0.0003662109375000, -0.0136718750000000, -0.0052795410156250, -0.0057678222656250,
-0.0142211914062500, -0.0008544921875000, -0.0088500976562500, -0.0070190429687500,
-0.0159301757812500, 0.0107421875000000, -0.0191040039062500, 0.0126953125000000,
-0.0141906738281250, 0.0061340332031250, -0.0130615234375000, 0.0114746093750000,
-0.0160217285156250, 0.0146789550781250, -0.0064086914062500, -0.0037536621093750,
-0.0072021484375000, -0.0010681152343750, -0.0057373046875000, -0.0051574707031250,
-0.0002136230468750, -0.0190734863281250, -0.0030822753906250, -0.0124511718750000,
0.0033874511718750, -0.0170898437500000, 0.0032653808593750, -0.0227355957031250,
0.0018615722656250, -0.0142517089843750, 0.0053710937500000, -0.0076293945312500,
0.0052490234375000, -0.0137634277343750, -0.0014343261718750, 0.0000000000000000,
0.0014038085937500, 0.0025024414062500, -0.0022277832031250, -0.0023193359375000,
-0.0099182128906250, 0.0015563964843750, -0.0060119628906250, 0.0032653808593750,
-0.0126342773437500, -0.0127258300781250, -0.0146484375000000, -0.0090332031250000,
-0.0107421875000000, -0.0157775878906250, -0.0119018554687500, -0.0309753417968750,
-0.0143737792968750, -0.0245971679687500, -0.0019226074218750, -0.0366821289062500,
-0.0067443847656250, -0.0390319824218750, -0.0007324218750000, -0.0370178222656250,
0.0112915039062500, -0.0406494140625000, 0.0032653808593750, -0.0404357910156250,
0.0201416015625000, -0.0361328125000000, 0.0185241699218750, -0.0366821289062500,
0.0227661132812500, -0.0360107421875000, 0.0341491699218750, -0.0328674316406250,
0.0281372070312500, -0.0336303710937500, 0.0444030761718750, -0.0341491699218750,
0.0429992675781250, -0.0333557128906250, 0.0461730957031250, -0.0337524414062500,
0.0580444335937500, -0.0349426269531250, 0.0534362792968750, -0.0346374511718750,
0.0592346191406250, -0.0345153808593750, 0.0617675781250000, -0.0352783203125000,
0.0596313476562500, -0.0339965820312500, 0.0596923828125000, -0.0329284667968750,
0.0605163574218750, -0.0338439941406250, 0.0576171875000000, -0.0297241210937500,
0.0590820312500000, -0.0307006835937500, 0.0553588867187500, -0.0276184082031250,
0.0520935058593750, -0.0231323242187500, 0.0547180175781250, -0.0254211425781250,
0.0386047363281250, -0.0169982910156250, 0.0431518554687500, -0.0169982910156250,
0.0338134765625000, -0.0147094726562500, 0.0173950195312500, -0.0087585449218750,
0.0261230468750000, -0.0106201171875000, 0.0025634765625000, -0.0061035156250000,
0.0040588378906250, -0.0049438476562500, -0.0019531250000000, -0.0040283203125000,
-0.0182800292968750, -0.0015869140625000, -0.0107727050781250, -0.0020446777343750,
-0.0279235839843750, -0.0003356933593750, -0.0285034179687500, 0.0009460449218750,
-0.0302429199218750, 0.0009765625000000, -0.0401611328125000, 0.0014038085937500,
-0.0366821289062500, 0.0022583007812500, -0.0410766601562500, 0.0010681152343750,
-0.0435791015625000, 0.0021667480468750, -0.0402832031250000, 0.0009460449218750,
-0.0404968261718750, -0.0005187988281250, -0.0421447753906250, 0.0009460449218750,
-0.0285034179687500, -0.0050964355468750, -0.0344848632812500, -0.0033264160156250,
-0.0240478515625000, -0.0060424804687500, -0.0079040527343750, -0.0117797851562500,
-0.0185546875000000, -0.0087585449218750, 0.0079040527343750, -0.0161743164062500,
0.0071411132812500, -0.0160522460937500, 0.0100708007812500, -0.0180664062500000,
0.0254211425781250, -0.0229187011718750, 0.0191955566406250, -0.0207824707031250,
0.0304260253906250, -0.0274047851562500, 0.0288391113281250, -0.0272827148437500,
0.0330810546875000, -0.0282897949218750, 0.0414123535156250, -0.0330200195312500,
0.0357666015625000, -0.0315856933593750, 0.0525817871093750, -0.0314636230468750,
0.0506896972656250, -0.0341796875000000, 0.0550231933593750, -0.0308227539062500,
0.0672607421875000, -0.0280151367187500, 0.0610351562500000, -0.0313110351562500,
0.0718994140625000, -0.0204162597656250, 0.0737915039062500, -0.0224609375000000,
0.0708923339843750, -0.0195007324218750, 0.0748291015625000, -0.0107421875000000,
0.0751037597656250, -0.0147094726562500, 0.0636291503906250, -0.0072326660156250,
0.0682983398437500, -0.0073547363281250, 0.0598449707031250, -0.0076599121093750,
0.0469360351562500, -0.0028381347656250, 0.0546875000000000, -0.0043029785156250,
0.0320739746093750},
{0.0039367675781250, -0.0260314941406250, -0.0057678222656250, -0.0333862304687500,
-0.0038452148437500, -0.0355834960937500, -0.0064697265625000, -0.0344848632812500,
-0.0148315429687500, -0.0361938476562500, -0.0109863281250000, -0.0361022949218750,
-0.0132751464843750, -0.0350036621093750, -0.0175170898437500, -0.0354003906250000,
-0.0093078613281250, -0.0354003906250000, -0.0048828125000000, -0.0343017578125000,
-0.0110473632812500, -0.0345764160156250, 0.0147094726562500, -0.0361633300781250,
0.0089416503906250, -0.0357666015625000, 0.0175476074218750, -0.0355834960937500,
0.0392456054687500, -0.0369567871093750, 0.0279235839843750, -0.0365295410156250,
0.0479736328125000, -0.0328369140625000, 0.0488586425781250, -0.0341186523437500,
0.0495300292968750, -0.0303344726562500, 0.0594787597656250, -0.0252380371093750,
0.0552673339843750, -0.0273132324218750, 0.0606994628906250, -0.0183410644531250,
0.0624084472656250, -0.0188903808593750, 0.0584106445312500, -0.0154724121093750,
0.0589599609375000, -0.0084838867187500, 0.0603637695312500, -0.0115051269531250,
0.0469360351562500, -0.0030822753906250, 0.0506591796875000, -0.0028076171875000,
0.0433654785156250, -0.0027465820312500, 0.0299377441406250, 0.0016784667968750,
0.0362548828125000, 0.0004577636718750, 0.0166625976562500, 0.0002136230468750,
0.0181884765625000, 0.0011901855468750, 0.0113220214843750, -0.0006408691406250,
-0.0030212402343750, -0.0026550292968750, 0.0042114257812500, -0.0019531250000000,
-0.0162658691406250, -0.0053405761718750, -0.0144958496093750, -0.0056457519531250,
-0.0195617675781250, -0.0067749023437500, -0.0342102050781250, -0.0088500976562500,
-0.0276489257812500, -0.0081176757812500, -0.0416564941406250, -0.0117492675781250,
-0.0424499511718750, -0.0120849609375000, -0.0431823730468750, -0.0129089355468750,
-0.0511169433593750, -0.0149841308593750, -0.0483398437500000, -0.0144958496093750,
-0.0477294921875000, -0.0162658691406250, -0.0516662597656250, -0.0162963867187500,
-0.0447998046875000, -0.0162353515625000, -0.0389404296875000, -0.0170898437500000,
-0.0440673828125000, -0.0166931152343750, -0.0248413085937500, -0.0166931152343750,
-0.0270080566406250, -0.0171203613281250, -0.0234375000000000, -0.0171813964843750,
-0.0102539062500000, -0.0169067382812500, -0.0159912109375000, -0.0169067382812500,
-0.0073547363281250, -0.0172119140625000, -0.0075988769531250, -0.0177612304687500,
-0.0041503906250000, -0.0172119140625000, 0.0009765625000000, -0.0173950195312500,
-0.0034790039062500, -0.0184631347656250, 0.0132446289062500, -0.0148315429687500,
0.0087585449218750, -0.0164489746093750, 0.0155944824218750, -0.0159912109375000,
0.0303344726562500, -0.0127563476562500, 0.0218200683593750, -0.0151367187500000,
0.0415649414062500, -0.0160827636718750, 0.0406188964843750, -0.0142822265625000,
0.0425720214843750, -0.0176696777343750, 0.0545654296875000, -0.0208740234375000,
0.0492248535156250, -0.0179748535156250, 0.0537414550781250, -0.0254821777343750,
0.0562744140625000, -0.0254821777343750, 0.0529479980468750, -0.0255737304687500,
0.0517272949218750, -0.0297546386718750, 0.0529174804687500, -0.0285034179687500,
0.0463867187500000, -0.0282287597656250, 0.0474853515625000, -0.0294799804687500,
0.0439147949218750, -0.0260620117187500, 0.0388488769531250, -0.0244750976562500,
0.0422058105468750, -0.0269775390625000, 0.0291137695312500, -0.0138244628906250,
0.0319213867187500, -0.0165405273437500, 0.0264892578125000, -0.0131225585937500,
0.0146789550781250, -0.0018920898437500, 0.0203247070312500, -0.0068359375000000,
0.0068359375000000, -0.0036926269531250, 0.0077514648437500, -0.0001220703125000,
0.0040588378906250, -0.0043945312500000, -0.0053710937500000, -0.0092468261718750,
-0.0006103515625000, -0.0060729980468750, -0.0117492675781250, -0.0048522949218750,
-0.0128784179687500, -0.0114440917968750, -0.0108032226562500, -0.0007324218750000,
-0.0156860351562500, 0.0104675292968750, -0.0157775878906250, 0.0021667480468750,
-0.0066833496093750, 0.0266723632812500, -0.0102844238281250, 0.0262145996093750,
-0.0065002441406250, 0.0247802734375000, 0.0029602050781250, 0.0394592285156250,
-0.0013732910156250, 0.0368652343750000, 0.0047302246093750, 0.0229187011718750,
0.0056762695312500, 0.0307006835937500, 0.0063476562500000, 0.0197448730468750,
0.0086059570312500, 0.0012512207031250, 0.0071105957031250, 0.0113830566406250,
0.0133972167968750, -0.0115356445312500, 0.0124816894531250, -0.0107116699218750,
0.0132141113281250, -0.0136413574218750, 0.0179138183593750, -0.0299377441406250,
0.0166015625000000, -0.0236206054687500, 0.0169067382812500, -0.0193786621093750,
0.0171203613281250, -0.0257263183593750, 0.0185852050781250, -0.0211181640625000,
0.0195007324218750, -0.0093383789062500, 0.0183715820312500, -0.0138854980468750,
0.0221557617187500, -0.0210266113281250, 0.0221862792968750, -0.0122070312500000,
0.0223083496093750, -0.0228271484375000, 0.0244750976562500, -0.0405273437500000,
0.0234985351562500, -0.0315551757812500, 0.0223693847656250, -0.0441894531250000,
0.0260009765625000, -0.0465698242187500, 0.0168151855468750, -0.0445861816406250,
0.0104370117187500, -0.0521850585937500, 0.0177307128906250, -0.0514526367187500,
-0.0115966796875000, -0.0293884277343750, -0.0082702636718750, -0.0385742187500000,
-0.0138854980468750, -0.0269470214843750, -0.0355529785156250, -0.0020446777343750,
-0.0261840820312500, -0.0154724121093750, -0.0307312011718750, 0.0020751953125000,
-0.0383605957031250, 0.0080261230468750, -0.0300903320312500, 0.0022888183593750,
-0.0150451660156250, 0.0024414062500000, -0.0149230957031250, -0.0150146484375000,
-0.0234375000000000, 0.0062255859375000, -0.0227355957031250, 0.0035705566406250,
-0.0256958007812500, -0.0001831054687500, -0.0252380371093750, 0.0041198730468750,
-0.0226745605468750, 0.0075683593750000, -0.0467834472656250, -0.0010681152343750,
-0.0375061035156250, -0.0048828125000000, -0.0499267578125000, 0.0012512207031250,
-0.0777893066406250, 0.0046081542968750, -0.0625915527343750, 0.0006408691406250,
-0.0755310058593750, 0.0067138671875000, -0.0874023437500000, 0.0092468261718750,
-0.0688781738281250, 0.0055541992187500, -0.0600585937500000, 0.0044860839843750,
-0.0723876953125000, 0.0070495605468750, -0.0202026367187500, 0.0021972656250000,
-0.0282287597656250, -0.0007629394531250, -0.0182800292968750, 0.0060424804687500,
0.0204162597656250, 0.0101013183593750, 0.0043334960937500, 0.0050354003906250,
0.0228881835937500, 0.0154113769531250, 0.0290527343750000, 0.0186462402343750,
0.0229492187500000, 0.0139160156250000, 0.0252075195312500, 0.0135192871093750,
0.0271606445312500, 0.0163269042968750, 0.0195922851562500, 0.0112304687500000,
0.0187683105468750, 0.0093688964843750, 0.0234069824218750, 0.0116577148437500,
0.0216064453125000, 0.0130920410156250, 0.0182495117187500, 0.0115661621093750,
0.0319824218750000, 0.0084533691406250, 0.0310974121093750, 0.0130310058593750,
0.0335388183593750, 0.0053100585937500, 0.0415649414062500, -0.0043945312500000,
0.0369262695312500, 0.0025024414062500, 0.0447692871093750, -0.0109252929687500,
0.0478820800781250, -0.0133361816406250, 0.0411071777343750, -0.0100708007812500,
0.0397644042968750, -0.0133056640625000, 0.0442199707031250, -0.0139770507812500,
0.0288391113281250, -0.0088195800781250, 0.0289001464843750, -0.0089111328125000,
0.0307617187500000, -0.0092163085937500, 0.0249023437500000, -0.0073242187500000,
0.0245971679687500, -0.0075073242187500, 0.0205688476562500, -0.0052795410156250,
0.0263061523437500, -0.0081787109375000, 0.0168151855468750, -0.0025939941406250,
0.0057373046875000, 0.0031127929687500, 0.0152282714843750, -0.0022888183593750,
-0.0061035156250000, 0.0123291015625000, -0.0051269531250000, 0.0112915039062500,
-0.0068664550781250, 0.0131225585937500, -0.0191345214843750, 0.0213928222656250,
-0.0139160156250000, 0.0177612304687500, -0.0207519531250000, 0.0278015136718750,
-0.0224304199218750, 0.0246582031250000, -0.0191040039062500, 0.0311584472656250,
-0.0213317871093750, 0.0421142578125000, -0.0226745605468750, 0.0350036621093750,
-0.0091857910156250, 0.0507812500000000, -0.0139465332031250, 0.0515136718750000,
-0.0079345703125000, 0.0504760742187500, 0.0052795410156250, 0.0576477050781250,
-0.0026245117187500, 0.0558471679687500, 0.0092773437500000, 0.0549011230468750,
0.0099792480468750, 0.0564575195312500, 0.0089721679687500, 0.0544433593750000,
0.0145263671875000, 0.0529479980468750, 0.0127868652343750, 0.0545959472656250,
0.0109252929687500, 0.0459899902343750, 0.0135803222656250, 0.0496520996093750,
0.0094604492187500, 0.0433044433593750, 0.0055541992187500, 0.0333557128906250,
0.0097656250000000, 0.0400390625000000, -0.0018615722656250, 0.0229797363281250,
0.0013122558593750, 0.0245666503906250, -0.0027465820312500, 0.0203552246093750,
-0.0121154785156250, 0.0091857910156250, -0.0055236816406250, 0.0152282714843750,
-0.0192871093750000, -0.0009155273437500, -0.0177612304687500, 0.0018005371093750,
-0.0185241699218750, -0.0041503906250000, -0.0268554687500000, -0.0168762207031250,
-0.0228271484375000, -0.0095214843750000, -0.0267944335937500, -0.0284118652343750,
-0.0267639160156250, -0.0265197753906250, -0.0264587402343750, -0.0309143066406250,
-0.0279541015625000, -0.0446777343750000, -0.0267028808593750, -0.0385437011718750,
-0.0291748046875000, -0.0493469238281250, -0.0288696289062500, -0.0512390136718750,
-0.0279846191406250, -0.0497131347656250, -0.0291748046875000, -0.0538024902343750,
-0.0289306640625000, -0.0535583496093750, -0.0260314941406250, -0.0493469238281250,
-0.0271301269531250, -0.0514831542968750, -0.0245361328125000, -0.0475463867187500,
-0.0210266113281250, -0.0422973632812500, -0.0230407714843750, -0.0456542968750000,
-0.0162963867187500, -0.0348815917968750, -0.0168457031250000, -0.0373840332031250,
-0.0149230957031250, -0.0313415527343750, -0.0097351074218750, -0.0222167968750000,
-0.0111389160156250, -0.0283508300781250, -0.0053710937500000, -0.0058593750000000,
-0.0051879882812500, -0.0107116699218750, -0.0029907226562500, -0.0021057128906250,
0.0014953613281250, 0.0177612304687500, 0.0003967285156250, 0.0075988769531250,
0.0062561035156250, 0.0269470214843750, 0.0062561035156250, 0.0283203125000000,
0.0079345703125000, 0.0289916992187500, 0.0122070312500000, 0.0380249023437500,
0.0113830566406250, 0.0351867675781250, 0.0153808593750000, 0.0430908203125000,
0.0160827636718750, 0.0430297851562500, 0.0165405273437500, 0.0451049804687500,
0.0190429687500000, 0.0507507324218750, 0.0190124511718750, 0.0485534667968750,
0.0183715820312500, 0.0527648925781250, 0.0195007324218750, 0.0535278320312500,
0.0173339843750000, 0.0506591796875000, 0.0151672363281250, 0.0523071289062500,
0.0163574218750000, 0.0530395507812500, 0.0092468261718750, 0.0382080078125000,
0.0106506347656250, 0.0444335937500000, 0.0058898925781250, 0.0350036621093750,
-0.0008850097656250, 0.0177307128906250, 0.0027770996093750, 0.0275573730468750,
-0.0118103027343750, 0.0089416503906250, -0.0102844238281250, 0.0080871582031250,
-0.0138244628906250, 0.0059509277343750, -0.0250854492187500, -0.0036315917968750,
-0.0205383300781250, 0.0009155273437500, -0.0253906250000000, -0.0092468261718750,
-0.0275268554687500, -0.0101013183593750, -0.0256347656250000, -0.0087890625000000,
-0.0252990722656250, -0.0130004882812500, -0.0258178710937500, -0.0129394531250000,
-0.0245666503906250, -0.0111389160156250, -0.0240173339843750, -0.0116882324218750,
-0.0244140625000000},
{0.0091552734375000, 0.0265808105468750, 0.0049438476562500, 0.0287780761718750,
0.0011901855468750, 0.0327453613281250, 0.0047607421875000, 0.0304870605468750,
-0.0040283203125000, 0.0318908691406250, -0.0025024414062500, 0.0345458984375000,
-0.0045166015625000, 0.0313720703125000, -0.0107421875000000, 0.0284118652343750,
-0.0070800781250000, 0.0310974121093750, -0.0137329101562500, 0.0257568359375000,
-0.0140380859375000, 0.0260925292968750, -0.0141906738281250, 0.0247802734375000,
-0.0178222656250000, 0.0223083496093750, -0.0169372558593750, 0.0243530273437500,
-0.0175170898437500, 0.0150451660156250, -0.0192565917968750, 0.0184326171875000,
-0.0173950195312500, 0.0123596191406250, -0.0167541503906250, 0.0023498535156250,
-0.0193176269531250, 0.0086669921875000, -0.0109252929687500, -0.0075073242187500,
-0.0138854980468750, -0.0063781738281250, -0.0111694335937500, -0.0091247558593750,
-0.0035400390625000, -0.0195312500000000, -0.0079345703125000, -0.0148315429687500,
-0.0009765625000000, -0.0233764648437500, -0.0013427734375000, -0.0236206054687500,
-0.0011291503906250, -0.0247192382812500, 0.0020141601562500, -0.0295104980468750,
-0.0004882812500000, -0.0276489257812500, 0.0034484863281250, -0.0329284667968750,
0.0021972656250000, -0.0326843261718750, 0.0029602050781250, -0.0336303710937500,
0.0059509277343750, -0.0371093750000000, 0.0036621093750000, -0.0357055664062500,
0.0070190429687500, -0.0383300781250000, 0.0066223144531250, -0.0383911132812500,
0.0063781738281250, -0.0385742187500000, 0.0079956054687500, -0.0407714843750000,
0.0068359375000000, -0.0403442382812500, 0.0078735351562500, -0.0382385253906250,
0.0071716308593750, -0.0417175292968750, 0.0070495605468750, -0.0359497070312500,
0.0078125000000000, -0.0300598144531250, 0.0065612792968750, -0.0354309082031250,
0.0063476562500000, -0.0191040039062500, 0.0071411132812500, -0.0208740234375000,
0.0050964355468750, -0.0175170898437500, 0.0033874511718750, -0.0063171386718750,
0.0043334960937500, -0.0107421875000000, -0.0008544921875000, 0.0004577636718750,
-0.0003051757812500, -0.0001831054687500, -0.0021362304687500, 0.0036621093750000,
-0.0064697265625000, 0.0119018554687500, -0.0048522949218750, 0.0082092285156250,
-0.0084838867187500, 0.0204467773437500, -0.0092773437500000, 0.0189514160156250,
-0.0084533691406250, 0.0224914550781250, -0.0097351074218750, 0.0320434570312500,
-0.0101928710937500, 0.0268554687500000, -0.0068969726562500, 0.0332031250000000,
-0.0079040527343750, 0.0362854003906250, -0.0058288574218750, 0.0311279296875000,
-0.0020141601562500, 0.0297851562500000, -0.0033569335937500, 0.0334777832031250,
0.0008544921875000, 0.0242004394531250, 0.0018920898437500, 0.0240478515625000,
0.0021362304687500, 0.0238952636718750, 0.0043945312500000, 0.0202636718750000,
0.0045776367187500, 0.0214538574218750, 0.0038452148437500, 0.0145568847656250,
0.0059814453125000, 0.0174865722656250, 0.0018005371093750, 0.0126647949218750,
-0.0014343261718750, 0.0039367675781250, 0.0019226074218750, 0.0089111328125000,
-0.0127563476562500, 0.0004272460937500, -0.0105590820312500, -0.0009460449218750,
-0.0153808593750000, -0.0010070800781250, -0.0278320312500000, -0.0043334960937500,
-0.0225219726562500, -0.0032958984375000, -0.0307922363281250, -0.0065002441406250,
-0.0335693359375000, -0.0070495605468750, -0.0310363769531250, -0.0071411132812500,
-0.0320739746093750, -0.0084838867187500, -0.0327453613281250, -0.0085754394531250,
-0.0278930664062500, -0.0100708007812500, -0.0289001464843750, -0.0097351074218750,
-0.0261535644531250, -0.0085144042968750, -0.0219421386718750, -0.0097656250000000,
-0.0247802734375000, -0.0103149414062500, -0.0173034667968750, -0.0030822753906250,
-0.0191345214843750, -0.0045776367187500, -0.0148620605468750, -0.0032958984375000,
-0.0083312988281250, 0.0028991699218750, -0.0131225585937500, 0.0010986328125000,
0.0012207031250000, 0.0007324218750000, -0.0010070800781250, 0.0034179687500000,
0.0032653808593750, -0.0002441406250000, 0.0153808593750000, -0.0041198730468750,
0.0090942382812500, -0.0005187988281250, 0.0139160156250000, -0.0072631835937500,
0.0187683105468750, -0.0076904296875000, 0.0130310058593750, -0.0066528320312500,
0.0090026855468750, -0.0089721679687500, 0.0122070312500000, -0.0082397460937500,
-0.0007324218750000, -0.0080261230468750, 0.0008239746093750, -0.0053405761718750,
0.0000000000000000, -0.0114440917968750, -0.0092468261718750, -0.0169372558593750,
-0.0070800781250000, -0.0103759765625000, -0.0054931640625000, -0.0187988281250000,
-0.0076904296875000, -0.0206298828125000, -0.0048522949218750, -0.0220947265625000,
-0.0003356933593750, -0.0256042480468750, -0.0031127929687500, -0.0221557617187500,
-0.0032653808593750, -0.0248107910156250, -0.0003967285156250, -0.0283203125000000,
-0.0021972656250000, -0.0232543945312500, -0.0043029785156250, -0.0174865722656250,
-0.0040588378906250, -0.0188293457031250, -0.0151367187500000, -0.0121459960937500,
-0.0094299316406250, -0.0125732421875000, -0.0119018554687500, -0.0130615234375000,
-0.0236511230468750, -0.0100097656250000, -0.0184631347656250, -0.0107727050781250,
-0.0206298828125000, -0.0091552734375000, -0.0266418457031250, -0.0092163085937500,
-0.0158691406250000, -0.0082397460937500, -0.0075073242187500, -0.0067443847656250,
-0.0171508789062500, -0.0081481933593750, 0.0040283203125000, -0.0075988769531250,
0.0059814453125000, -0.0047302246093750, 0.0026855468750000, -0.0084228515625000,
0.0113220214843750, -0.0141601562500000, 0.0102844238281250, -0.0114135742187500,
-0.0015869140625000, -0.0101318359375000, 0.0028686523437500, -0.0133056640625000,
-0.0006408691406250, -0.0104675292968750, -0.0139770507812500, -0.0067443847656250,
-0.0090637207031250, -0.0092163085937500, -0.0033264160156250, 0.0001220703125000,
-0.0100097656250000, -0.0016479492187500, -0.0043640136718750, 0.0000000000000000,
0.0080261230468750, 0.0083007812500000, 0.0025024414062500, 0.0042724609375000,
0.0038757324218750, -0.0007019042968750, 0.0079345703125000, 0.0057983398437500,
0.0047912597656250, -0.0035400390625000, 0.0007324218750000, -0.0173034667968750,
0.0027770996093750, -0.0099182128906250, -0.0016479492187500, -0.0226440429687500,
-0.0003356933593750, -0.0252380371093750, -0.0044860839843750, -0.0242309570312500,
-0.0094299316406250, -0.0287780761718750, -0.0051574707031250, -0.0281066894531250,
-0.0173645019531250, -0.0260314941406250, -0.0172119140625000, -0.0268859863281250,
-0.0163574218750000, -0.0277404785156250, -0.0232849121093750, -0.0265502929687500,
-0.0219726562500000, -0.0261840820312500, -0.0161132812500000, -0.0285644531250000,
-0.0202636718750000, -0.0290832519531250, -0.0143737792968750, -0.0270996093750000,
-0.0055847167968750, -0.0274658203125000, -0.0115051269531250, -0.0284118652343750,
0.0011596679687500, -0.0200195312500000, 0.0014648437500000, -0.0219116210937500,
0.0020446777343750, -0.0186462402343750, 0.0088195800781250, -0.0104980468750000,
0.0067749023437500, -0.0136413574218750, 0.0101318359375000, -0.0090942382812500,
0.0107727050781250, -0.0072937011718750, 0.0104370117187500, -0.0084838867187500,
0.0119018554687500, -0.0079956054687500, 0.0117797851562500, -0.0076293945312500,
0.0101623535156250, -0.0099487304687500, 0.0111389160156250, -0.0096435546875000,
0.0100097656250000, -0.0105895996093750, 0.0076293945312500, -0.0128479003906250,
0.0086975097656250, -0.0119628906250000, 0.0075683593750000, -0.0118408203125000,
0.0060729980468750, -0.0131530761718750, 0.0068359375000000, -0.0107116699218750,
0.0072021484375000, -0.0083618164062500, 0.0049133300781250, -0.0098571777343750,
0.0053710937500000, -0.0038757324218750, 0.0054016113281250, -0.0040893554687500,
0.0024108886718750, -0.0025024414062500, 0.0006103515625000, 0.0019836425781250,
0.0010986328125000, 0.0009765625000000, -0.0047302246093750, 0.0049743652343750,
-0.0045471191406250, 0.0058593750000000, -0.0075073242187500, 0.0068054199218750,
-0.0118408203125000, 0.0095520019531250, -0.0100708007812500, 0.0098266601562500,
-0.0195312500000000, 0.0108032226562500, -0.0181579589843750, 0.0121154785156250,
-0.0217285156250000, 0.0117492675781250, -0.0299377441406250, 0.0113525390625000,
-0.0258483886718750, 0.0119323730468750, -0.0312500000000000, 0.0096740722656250,
-0.0335083007812500, 0.0101318359375000, -0.0297241210937500, 0.0088806152343750,
-0.0289001464843750, 0.0066528320312500, -0.0307922363281250, 0.0075683593750000,
-0.0236816406250000, 0.0040588378906250, -0.0229797363281250, 0.0038146972656250,
-0.0231628417968750, 0.0033874511718750, -0.0195617675781250, 0.0013122558593750,
-0.0198059082031250, 0.0016174316406250, -0.0224914550781250, 0.0014038085937500,
-0.0207824707031250, 0.0008850097656250, -0.0224609375000000, 0.0013122558593750,
-0.0263061523437500, 0.0017395019531250, -0.0242004394531250, 0.0014038085937500,
-0.0255432128906250, 0.0030517578125000, -0.0273132324218750, 0.0026550292968750,
-0.0245056152343750, 0.0035095214843750, -0.0227050781250000, 0.0050659179687500,
-0.0244750976562500, 0.0040588378906250, -0.0169982910156250, 0.0057678222656250,
-0.0180053710937500, 0.0059204101562500, -0.0156555175781250, 0.0061035156250000,
-0.0097656250000000, 0.0073852539062500, -0.0126647949218750, 0.0072021484375000,
-0.0079040527343750, 0.0067443847656250, -0.0069885253906250, 0.0086669921875000,
-0.0087585449218750, 0.0056762695312500, -0.0084228515625000, 0.0036926269531250,
-0.0083312988281250, 0.0069885253906250, -0.0101013183593750, -0.0045166015625000,
-0.0118408203125000, -0.0014038085937500, -0.0098571777343750, -0.0046691894531250,
-0.0091247558593750, -0.0141906738281250, -0.0115051269531250, -0.0089111328125000,
-0.0047302246093750, -0.0176391601562500, -0.0055541992187500, -0.0186462402343750,
-0.0047302246093750, -0.0184936523437500, -0.0007019042968750, -0.0222473144531250,
-0.0028076171875000, -0.0209655761718750, 0.0007324218750000, -0.0225219726562500,
-0.0002441406250000, -0.0235290527343750, 0.0018615722656250, -0.0202636718750000,
0.0053100585937500, -0.0192871093750000, 0.0027160644531250, -0.0217895507812500,
0.0093994140625000, -0.0122070312500000, 0.0083007812500000, -0.0130004882812500,
0.0109558105468750, -0.0117797851562500, 0.0156250000000000, -0.0051879882812500,
0.0122985839843750, -0.0073242187500000, 0.0230407714843750, -0.0064392089843750,
0.0208435058593750, -0.0046081542968750, 0.0240478515625000, -0.0064697265625000,
0.0335998535156250, -0.0085144042968750, 0.0288391113281250, -0.0075683593750000,
0.0322570800781250, -0.0097351074218750, 0.0361022949218750, -0.0091552734375000,
0.0310058593750000, -0.0111999511718750, 0.0272827148437500, -0.0149230957031250,
0.0307312011718750, -0.0124511718750000, 0.0215759277343750, -0.0100708007812500,
0.0218811035156250, -0.0156860351562500, 0.0208435058593750, -0.0057373046875000,
0.0163574218750000, 0.0049743652343750, 0.0184631347656250, -0.0031433105468750,
0.0101623535156250, 0.0184326171875000, 0.0126647949218750, 0.0203552246093750,
0.0088195800781250, 0.0165710449218750, -0.0000610351562500, 0.0254516601562500,
0.0048828125000000, 0.0252685546875000, 0.0002136230468750, 0.0113525390625000,
-0.0029907226562500, 0.0156555175781250, 0.0004882812500000, 0.0119323730468750,
0.0032653808593750, -0.0011291503906250, 0.0006713867187500, 0.0028381347656250,
0.0005798339843750, -0.0013427734375000, 0.0044860839843750, -0.0013732910156250,
-0.0023193359375000, -0.0028076171875000, -0.0088500976562500, -0.0066528320312500,
-0.0035705566406250},
{-0.0247192382812500, -0.0147705078125000, -0.0262451171875000, -0.0127563476562500,
-0.0227050781250000, -0.0169677734375000, -0.0225219726562500, -0.0168762207031250,
-0.0212402343750000, -0.0177917480468750, -0.0187988281250000, -0.0202941894531250,
-0.0199890136718750, -0.0187377929687500, -0.0169067382812500, -0.0222167968750000,
-0.0162658691406250, -0.0213623046875000, -0.0167541503906250, -0.0226135253906250,
-0.0155334472656250, -0.0254821777343750, -0.0154418945312500, -0.0236206054687500,
-0.0177307128906250, -0.0278320312500000, -0.0166931152343750, -0.0274047851562500,
-0.0172119140625000, -0.0277709960937500, -0.0195922851562500, -0.0305175781250000,
-0.0184326171875000, -0.0293273925781250, -0.0177001953125000, -0.0304565429687500,
-0.0185852050781250, -0.0307922363281250, -0.0170898437500000, -0.0299987792968750,
-0.0149841308593750, -0.0299682617187500, -0.0161437988281250, -0.0300292968750000,
-0.0145263671875000, -0.0279541015625000, -0.0133056640625000, -0.0283203125000000,
-0.0155334472656250, -0.0269775390625000, -0.0167236328125000, -0.0249023437500000,
-0.0152893066406250, -0.0255737304687500, -0.0207519531250000, -0.0216369628906250,
-0.0209045410156250, -0.0228576660156250, -0.0204162597656250, -0.0195007324218750,
-0.0233154296875000, -0.0154113769531250, -0.0234069824218750, -0.0186157226562500,
-0.0204467773437500, -0.0081481933593750, -0.0213623046875000, -0.0097961425781250,
-0.0214233398437500, -0.0075683593750000, -0.0194396972656250, -0.0001525878906250,
-0.0204467773437500, -0.0040283203125000, -0.0218200683593750, 0.0021057128906250,
-0.0221862792968750, 0.0032653808593750, -0.0214233398437500, 0.0018310546875000,
-0.0222473144531250, 0.0039062500000000, -0.0236511230468750, 0.0039062500000000,
-0.0187683105468750, -0.0006408691406250, -0.0209350585937500, 0.0023498535156250,
-0.0178222656250000, -0.0036010742187500, -0.0131225585937500, -0.0108642578125000,
-0.0165100097656250, -0.0050964355468750, -0.0039978027343750, -0.0192260742187500,
-0.0075683593750000, -0.0192565917968750, -0.0010070800781250, -0.0190124511718750,
0.0115356445312500, -0.0263977050781250, 0.0040283203125000, -0.0239562988281250,
0.0187377929687500, -0.0223693847656250, 0.0197753906250000, -0.0245056152343750,
0.0190734863281250, -0.0214233398437500, 0.0255432128906250, -0.0173645019531250,
0.0240783691406250, -0.0189819335937500, 0.0259399414062500, -0.0129699707031250,
0.0256042480468750, -0.0137023925781250, 0.0270385742187500, -0.0109252929687500,
0.0297241210937500, -0.0045471191406250, 0.0279846191406250, -0.0076293945312500,
0.0284423828125000, -0.0076293945312500, 0.0314331054687500, -0.0048522949218750,
0.0263671875000000, -0.0065917968750000, 0.0221557617187500, -0.0113830566406250,
0.0265502929687500, -0.0098266601562500, 0.0141906738281250, -0.0029296875000000,
0.0146179199218750, -0.0082092285156250, 0.0137939453125000, -0.0013427734375000,
0.0075378417968750, 0.0106201171875000, 0.0097961425781250, 0.0040588378906250,
0.0022583007812500, 0.0130004882812500, 0.0056762695312500, 0.0173645019531250,
-0.0020751953125000, 0.0099487304687500, -0.0125427246093750, 0.0072937011718750,
-0.0051574707031250, 0.0124816894531250, -0.0234069824218750, 0.0010375976562500,
-0.0242309570312500, -0.0007019042968750, -0.0234680175781250, -0.0007629394531250,
-0.0319519042968750, -0.0041809082031250, -0.0299072265625000, -0.0021057128906250,
-0.0299682617187500, -0.0066223144531250, -0.0307312011718750, -0.0070800781250000,
-0.0302124023437500, -0.0081176757812500, -0.0301513671875000, -0.0109558105468750,
-0.0299987792968750, -0.0093688964843750, -0.0259094238281250, -0.0090637207031250,
-0.0278015136718750, -0.0068664550781250, -0.0239562988281250, -0.0182800292968750,
-0.0181274414062500, -0.0244750976562500, -0.0212707519531250, -0.0144653320312500,
-0.0140991210937500, -0.0444946289062500, -0.0117797851562500, -0.0450439453125000,
-0.0166931152343750, -0.0444946289062500, -0.0157775878906250, -0.0604248046875000,
-0.0125732421875000, -0.0557250976562500, -0.0295410156250000, -0.0459594726562500,
-0.0253601074218750, -0.0530700683593750, -0.0323486328125000, -0.0466003417968750,
-0.0588378906250000, -0.0236511230468750, -0.0693664550781250, -0.0574645996093750,
-0.0451354980468750, -0.0393981933593750, -0.0618896484375000, -0.0517578125000000,
-0.0458984375000000, -0.0417480468750000, -0.0238037109375000, -0.0230102539062500,
-0.0364074707031250, -0.0296630859375000, -0.0070190429687500, -0.0247802734375000,
-0.0086364746093750, -0.0234069824218750, -0.0026550292968750, -0.0220336914062500,
0.0157165527343750, -0.0190124511718750, 0.0062866210937500, -0.0208740234375000,
0.0290527343750000, -0.0177001953125000, 0.0306701660156250, -0.0187683105468750,
0.0267639160156250, -0.0144042968750000, 0.0373535156250000, -0.0090026855468750,
0.0366821289062500, -0.0133666992187500, 0.0191650390625000, -0.0086975097656250,
0.0245056152343750, -0.0058288574218750, 0.0226745605468750, -0.0080261230468750,
0.0064697265625000, -0.0096130371093750, 0.0099182128906250, -0.0086975097656250,
0.0177001953125000, -0.0092468261718750, 0.0122375488281250, -0.0092468261718750,
0.0187683105468750, -0.0104675292968750, 0.0302429199218750, -0.0109863281250000,
0.0228576660156250, -0.0097351074218750, 0.0314331054687500, -0.0144958496093750,
0.0373840332031250, -0.0141601562500000, 0.0257568359375000, -0.0142211914062500,
0.0224304199218750, -0.0176696777343750, 0.0306091308593750, -0.0165710449218750,
-0.0076293945312500, -0.0120849609375000, -0.0034179687500000, -0.0155029296875000,
-0.0041198730468750, -0.0091857910156250, -0.0282897949218750, -0.0010681152343750,
-0.0225830078125000, -0.0064697265625000, -0.0201721191406250, 0.0073547363281250,
-0.0250854492187500, 0.0075988769531250, -0.0202026367187500, 0.0081481933593750,
-0.0136718750000000, 0.0153503417968750, -0.0184631347656250, 0.0129394531250000,
-0.0099792480468750, 0.0149841308593750, -0.0084533691406250, 0.0160217285156250,
-0.0127258300781250, 0.0143432617187500, -0.0100402832031250, 0.0143432617187500,
-0.0077514648437500, 0.0151672363281250, -0.0235900878906250, 0.0098876953125000,
-0.0203552246093750, 0.0112915039062500, -0.0211181640625000, 0.0093078613281250,
-0.0328979492187500, 0.0041809082031250, -0.0295104980468750, 0.0065612792968750,
-0.0255126953125000, 0.0039062500000000, -0.0299682617187500, 0.0032653808593750,
-0.0248413085937500, 0.0028686523437500, -0.0176391601562500, 0.0025634765625000,
-0.0224914550781250, 0.0033264160156250, -0.0103454589843750, -0.0033569335937500,
-0.0111999511718750, -0.0010070800781250, -0.0095214843750000, -0.0043640136718750,
-0.0011596679687500, -0.0115661621093750, -0.0049133300781250, -0.0078430175781250,
-0.0031127929687500, -0.0136718750000000, 0.0006103515625000, -0.0143127441406250,
-0.0048828125000000, -0.0146484375000000, -0.0090026855468750, -0.0171508789062500,
-0.0041503906250000, -0.0157470703125000, -0.0163574218750000, -0.0193481445312500,
-0.0144042968750000, -0.0192260742187500, -0.0165100097656250, -0.0185241699218750,
-0.0245971679687500, -0.0204162597656250, -0.0197753906250000, -0.0202941894531250,
-0.0271911621093750, -0.0172424316406250, -0.0274658203125000, -0.0177307128906250,
-0.0265197753906250, -0.0174255371093750, -0.0300598144531250, -0.0152587890625000,
-0.0291748046875000, -0.0155944824218750, -0.0269470214843750, -0.0154724121093750,
-0.0285034179687500, -0.0160827636718750, -0.0267639160156250, -0.0140686035156250,
-0.0243530273437500, -0.0126342773437500, -0.0266418457031250, -0.0142517089843750,
-0.0216979980468750, -0.0085449218750000, -0.0240783691406250, -0.0087280273437500,
-0.0222473144531250, -0.0083618164062500, -0.0179443359375000, -0.0049133300781250,
-0.0219726562500000, -0.0057373046875000, -0.0146789550781250, -0.0057678222656250,
-0.0165100097656250, -0.0046997070312500, -0.0152282714843750, -0.0058898925781250,
-0.0105285644531250, -0.0068054199218750, -0.0147399902343750, -0.0059509277343750,
-0.0086669921875000, -0.0109252929687500, -0.0104980468750000, -0.0096435546875000,
-0.0092468261718750, -0.0120544433593750, -0.0048522949218750, -0.0171813964843750,
-0.0087585449218750, -0.0147399902343750, -0.0025939941406250, -0.0190429687500000,
-0.0036621093750000, -0.0196838378906250, -0.0035095214843750, -0.0198669433593750,
0.0000610351562500, -0.0212097167968750, -0.0023803710937500, -0.0208129882812500,
-0.0002746582031250, -0.0252075195312500, -0.0010986328125000, -0.0232238769531250,
-0.0015869140625000, -0.0265502929687500, -0.0006713867187500, -0.0323181152343750,
-0.0025939941406250, -0.0285949707031250, -0.0024108886718750, -0.0333557128906250,
-0.0024719238281250, -0.0346679687500000, -0.0038757324218750, -0.0325317382812500,
-0.0048828125000000, -0.0326538085937500, -0.0050354003906250, -0.0332336425781250,
-0.0065002441406250, -0.0310363769531250, -0.0068664550781250, -0.0309143066406250,
-0.0071716308593750, -0.0316772460937500, -0.0078735351562500, -0.0311279296875000,
-0.0081176757812500, -0.0308532714843750, -0.0088500976562500, -0.0325927734375000,
-0.0087585449218750, -0.0328674316406250, -0.0089416503906250, -0.0308532714843750,
-0.0094299316406250, -0.0314025878906250, -0.0089111328125000, -0.0324707031250000,
-0.0088500976562500, -0.0222167968750000, -0.0083923339843750, -0.0254516601562500,
-0.0080871582031250, -0.0215759277343750, -0.0077209472656250, -0.0113220214843750,
-0.0068054199218750, -0.0156555175781250, -0.0066223144531250, -0.0095520019531250,
-0.0064697265625000, -0.0086669921875000, -0.0062255859375000, -0.0065917968750000,
-0.0058898925781250, -0.0035095214843750, -0.0057983398437500, -0.0058288574218750,
-0.0073852539062500, 0.0033264160156250, -0.0067749023437500, 0.0024108886718750,
-0.0078125000000000, 0.0030212402343750, -0.0101318359375000, 0.0086669921875000,
-0.0094909667968750, 0.0064697265625000, -0.0101318359375000, 0.0082092285156250,
-0.0109558105468750, 0.0083618164062500, -0.0099792480468750, 0.0083618164062500,
-0.0095520019531250, 0.0095825195312500, -0.0099487304687500, 0.0092163085937500,
-0.0053100585937500, 0.0085754394531250, -0.0054321289062500, 0.0096435546875000,
-0.0058288574218750, 0.0085449218750000, -0.0025329589843750, 0.0070495605468750,
-0.0024414062500000, 0.0079956054687500, -0.0076599121093750, 0.0041198730468750,
-0.0054321289062500, 0.0054626464843750, -0.0087585449218750, 0.0032653808593750,
-0.0143737792968750, -0.0009460449218750, -0.0110168457031250, 0.0015869140625000,
-0.0204162597656250, -0.0028076171875000, -0.0198669433593750, -0.0023803710937500,
-0.0207824707031250, -0.0051269531250000, -0.0270690917968750, -0.0082702636718750,
-0.0242614746093750, -0.0049743652343750, -0.0223999023437500, -0.0148925781250000,
-0.0262756347656250, -0.0133972167968750, -0.0193481445312500, -0.0156555175781250,
-0.0108947753906250, -0.0229797363281250, -0.0161132812500000, -0.0184326171875000,
-0.0070190429687500, -0.0219116210937500, -0.0054016113281250, -0.0243835449218750,
-0.0045166015625000, -0.0227050781250000, -0.0007019042968750, -0.0209350585937500,
-0.0027160644531250, -0.0209350585937500, 0.0000610351562500, -0.0214233398437500,
0.0008239746093750, -0.0223388671875000, 0.0004577636718750, -0.0209960937500000,
0.0016784667968750, -0.0195617675781250, 0.0018005371093750, -0.0202331542968750,
-0.0009765625000000, -0.0174865722656250, 0.0002136230468750, -0.0198364257812500,
-0.0014038085937500, -0.0162048339843750, -0.0047302246093750, -0.0106506347656250,
-0.0031738281250000, -0.0143432617187500, -0.0063781738281250, -0.0089721679687500,
-0.0081176757812500},
{-0.0051879882812500, -0.0100708007812500, -0.0047607421875000, -0.0091552734375000,
-0.0037536621093750, -0.0118103027343750, -0.0042419433593750, -0.0138854980468750,
-0.0035095214843750, -0.0113830566406250, -0.0016479492187500, -0.0195007324218750,
-0.0015869140625000, -0.0180053710937500, 0.0003967285156250, -0.0200500488281250,
0.0024719238281250, -0.0259094238281250, 0.0021667480468750, -0.0229492187500000,
0.0073242187500000, -0.0300903320312500, 0.0062255859375000, -0.0291442871093750,
0.0088195800781250, -0.0321044921875000, 0.0137939453125000, -0.0380249023437500,
0.0111694335937500, -0.0348510742187500, 0.0160522460937500, -0.0428466796875000,
0.0166931152343750, -0.0424194335937500, 0.0155029296875000, -0.0436401367187500,
0.0172729492187500, -0.0489807128906250, 0.0170898437500000, -0.0464477539062500,
0.0130004882812500, -0.0473327636718750, 0.0150146484375000, -0.0498352050781250,
0.0108337402343750, -0.0463256835937500, 0.0054626464843750, -0.0430908203125000,
0.0087890625000000, -0.0458679199218750, -0.0035400390625000, -0.0401916503906250,
-0.0023193359375000, -0.0398559570312500, -0.0056762695312500, -0.0386352539062500,
-0.0152893066406250, -0.0363769531250000, -0.0115356445312500, -0.0375366210937500,
-0.0181884765625000, -0.0274047851562500, -0.0200500488281250, -0.0310974121093750,
-0.0184020996093750, -0.0256958007812500, -0.0204162597656250, -0.0150756835937500,
-0.0209655761718750, -0.0211791992187500, -0.0146179199218750, -0.0086059570312500,
-0.0170593261718750, -0.0093078613281250, -0.0129394531250000, -0.0063171386718750,
-0.0057373046875000, 0.0017700195312500, -0.0097656250000000, -0.0028076171875000,
0.0002136230468750, 0.0079040527343750, 0.0003051757812500, 0.0080261230468750,
0.0001831054687500, 0.0086059570312500, 0.0057678222656250, 0.0150146484375000,
0.0042114257812500, 0.0132446289062500, 0.0019836425781250, 0.0138549804687500,
0.0034179687500000, 0.0157470703125000, 0.0019531250000000, 0.0135498046875000,
-0.0006713867187500, 0.0115966796875000, 0.0004272460937500, 0.0134582519531250,
-0.0038757324218750, 0.0088806152343750, -0.0027465820312500, 0.0089721679687500,
-0.0043029785156250, 0.0078125000000000, -0.0081787109375000, 0.0057373046875000,
-0.0061340332031250, 0.0065917968750000, -0.0100097656250000, -0.0036315917968750,
-0.0090332031250000, 0.0012207031250000, -0.0107421875000000, -0.0057678222656250,
-0.0137023925781250, -0.0184936523437500, -0.0114440917968750, -0.0109863281250000,
-0.0186767578125000, -0.0255432128906250, -0.0176391601562500, -0.0260925292968750,
-0.0170288085937500, -0.0242919921875000, -0.0226745605468750, -0.0313415527343750,
-0.0216674804687500, -0.0306396484375000, -0.0132446289062500, -0.0249023437500000,
-0.0155029296875000, -0.0255432128906250, -0.0128479003906250, -0.0265197753906250,
-0.0054931640625000, -0.0249633789062500, -0.0078735351562500, -0.0248107910156250,
-0.0023803710937500, -0.0214233398437500, -0.0015869140625000, -0.0230712890625000,
-0.0025939941406250, -0.0217590332031250, -0.0005798339843750, -0.0188903808593750,
-0.0001220703125000, -0.0205383300781250, -0.0018005371093750, -0.0135803222656250,
-0.0014343261718750, -0.0151672363281250, -0.0005493164062500, -0.0129394531250000,
-0.0012512207031250, -0.0072021484375000, -0.0017089843750000, -0.0101928710937500,
0.0006408691406250, -0.0042724609375000, 0.0010375976562500, -0.0046386718750000,
0.0003662109375000, -0.0027770996093750, 0.0002746582031250, 0.0036010742187500,
-0.0007629394531250, 0.0022583007812500, -0.0034790039062500, -0.0012817382812500,
-0.0029602050781250, 0.0025329589843750, -0.0009155273437500, -0.0000610351562500,
-0.0017700195312500, -0.0067443847656250, -0.0041809082031250, -0.0036621093750000,
-0.0011291503906250, -0.0057983398437500, 0.0032653808593750, -0.0095214843750000,
-0.0064086914062500, -0.0036010742187500, -0.0131225585937500, 0.0015563964843750,
-0.0050964355468750, -0.0034484863281250, -0.0252990722656250, 0.0046081542968750,
-0.0263366699218750, 0.0065002441406250, -0.0237426757812500, 0.0048828125000000,
-0.0325927734375000, 0.0070800781250000, -0.0319519042968750, 0.0062561035156250,
-0.0247802734375000, 0.0001831054687500, -0.0272827148437500, 0.0031433105468750,
-0.0235595703125000, -0.0010681152343750, -0.0161743164062500, -0.0090026855468750,
-0.0205688476562500, -0.0053405761718750, -0.0151062011718750, -0.0136413574218750,
-0.0124511718750000, -0.0141906738281250, -0.0161743164062500, -0.0138549804687500,
-0.0172424316406250, -0.0177917480468750, -0.0148620605468750, -0.0170288085937500,
-0.0212707519531250, -0.0166625976562500, -0.0217285156250000, -0.0182189941406250,
-0.0202026367187500, -0.0151062011718750, -0.0226745605468750, -0.0119018554687500,
-0.0231018066406250, -0.0149230957031250, -0.0183715820312500, -0.0113525390625000,
-0.0205688476562500, -0.0092468261718750, -0.0158996582031250, -0.0111999511718750,
-0.0098266601562500, -0.0121154785156250, -0.0140380859375000, -0.0115661621093750,
-0.0017700195312500, -0.0153808593750000, -0.0022583007812500, -0.0144348144531250,
-0.0015258789062500, -0.0155944824218750, 0.0061950683593750, -0.0200500488281250,
0.0038146972656250, -0.0185852050781250, 0.0030822753906250, -0.0153198242187500,
0.0058593750000000, -0.0189208984375000, 0.0028686523437500, -0.0130004882812500,
-0.0004882812500000, -0.0057067871093750, 0.0024108886718750, -0.0111083984375000,
-0.0048217773437500, 0.0015563964843750, -0.0037231445312500, 0.0022277832031250,
-0.0059204101562500, 0.0015563964843750, -0.0115661621093750, 0.0072937011718750,
-0.0085754394531250, 0.0057983398437500, -0.0147705078125000, 0.0038757324218750,
-0.0153503417968750, 0.0044860839843750, -0.0160827636718750, 0.0028991699218750,
-0.0195312500000000, 0.0000915527343750, -0.0191955566406250, 0.0008544921875000,
-0.0226135253906250, 0.0009765625000000, -0.0221252441406250, -0.0009460449218750,
-0.0254516601562500, 0.0019836425781250, -0.0290222167968750, 0.0046386718750000,
-0.0268554687500000, 0.0022888183593750, -0.0368652343750000, 0.0102844238281250,
-0.0352478027343750, 0.0094909667968750, -0.0387573242187500, 0.0112304687500000,
-0.0469970703125000, 0.0171203613281250, -0.0430297851562500, 0.0146789550781250,
-0.0509338378906250, 0.0179748535156250, -0.0514831542968750, 0.0184936523437500,
-0.0516052246093750, 0.0169982910156250, -0.0555725097656250, 0.0172119140625000,
-0.0540771484375000, 0.0168151855468750, -0.0537719726562500, 0.0141296386718750,
-0.0557250976562500, 0.0144348144531250, -0.0516662597656250, 0.0118103027343750,
-0.0486755371093750, 0.0087585449218750, -0.0516052246093750, 0.0100708007812500,
-0.0392761230468750, 0.0036315917968750, -0.0420532226562500, 0.0037536621093750,
-0.0375061035156250, 0.0015258789062500, -0.0273132324218750, -0.0033264160156250,
-0.0331726074218750, -0.0014953613281250, -0.0209960937500000, -0.0063476562500000,
-0.0216979980468750, -0.0066833496093750, -0.0198669433593750, -0.0075378417968750,
-0.0120544433593750, -0.0103454589843750, -0.0155334472656250, -0.0090942382812500,
-0.0094299316406250, -0.0108642578125000, -0.0087585449218750, -0.0110473632812500,
-0.0083923339843750, -0.0106201171875000, -0.0054016113281250, -0.0110778808593750,
-0.0064086914062500, -0.0107727050781250, -0.0042114257812500, -0.0109558105468750,
-0.0038757324218750, -0.0108032226562500, -0.0040588378906250, -0.0104370117187500,
-0.0028076171875000, -0.0104370117187500, -0.0029907226562500, -0.0101623535156250,
-0.0054321289062500, -0.0089111328125000, -0.0036315917968750, -0.0093383789062500,
-0.0065307617187500, -0.0086364746093750, -0.0103149414062500, -0.0074462890625000,
-0.0076293945312500, -0.0081176757812500, -0.0157165527343750, -0.0062255859375000,
-0.0145263671875000, -0.0074157714843750, -0.0176086425781250, -0.0053405761718750,
-0.0236511230468750, -0.0035095214843750, -0.0204772949218750, -0.0059509277343750,
-0.0317382812500000, 0.0034484863281250, -0.0299682617187500, 0.0001220703125000,
-0.0341186523437500, 0.0037231445312500, -0.0440063476562500, 0.0127563476562500,
-0.0397644042968750, 0.0072326660156250, -0.0487670898437500, 0.0152893066406250,
-0.0502624511718750, 0.0164794921875000, -0.0497436523437500, 0.0143432617187500,
-0.0535278320312500, 0.0173034667968750, -0.0529174804687500, 0.0175170898437500,
-0.0503234863281250, 0.0113220214843750, -0.0529479980468750, 0.0149230957031250,
-0.0483398437500000, 0.0092773437500000, -0.0435180664062500, 0.0009460449218750,
-0.0477294921875000, 0.0064392089843750, -0.0343627929687500, -0.0083312988281250,
-0.0359191894531250, -0.0065612792968750, -0.0339050292968750, -0.0089416503906250,
-0.0250244140625000, -0.0201416015625000, -0.0289611816406250, -0.0158386230468750,
-0.0233154296875000, -0.0178833007812500, -0.0234375000000000, -0.0215454101562500,
-0.0214843750000000, -0.0174560546875000, -0.0178222656250000, -0.0142822265625000,
-0.0202636718750000, -0.0173339843750000, -0.0118408203125000, -0.0071105957031250,
-0.0130310058593750, -0.0084228515625000, -0.0110473632812500, -0.0070495605468750,
-0.0047302246093750, 0.0007019042968750, -0.0072631835937500, -0.0014953613281250,
-0.0022583007812500, -0.0000610351562500, -0.0025634765625000, 0.0031433105468750,
-0.0001525878906250, -0.0038452148437500, 0.0038452148437500, -0.0078430175781250,
0.0011901855468750, -0.0025024414062500, 0.0084228515625000, -0.0236511230468750,
0.0087890625000000, -0.0229187011718750, 0.0073852539062500, -0.0223083496093750,
0.0107727050781250, -0.0349731445312500, 0.0106811523437500, -0.0324707031250000,
0.0037231445312500, -0.0230712890625000, 0.0060119628906250, -0.0288391113281250,
0.0035095214843750, -0.0202941894531250, -0.0033264160156250, -0.0075378417968750,
-0.0004577636718750, -0.0151977539062500, -0.0034790039062500, 0.0056152343750000,
-0.0036926269531250, 0.0047912597656250, -0.0048522949218750, 0.0059814453125000,
-0.0059204101562500, 0.0191650390625000, -0.0040588378906250, 0.0147705078125000,
-0.0123901367187500, 0.0126342773437500, -0.0104064941406250, 0.0198669433593750,
-0.0128173828125000, 0.0069885253906250, -0.0201110839843750, -0.0074157714843750,
-0.0166931152343750, 0.0036010742187500, -0.0203857421875000, -0.0143432617187500,
-0.0209045410156250, -0.0189819335937500, -0.0218505859375000, -0.0129394531250000,
-0.0223693847656250, -0.0162353515625000, -0.0211181640625000, -0.0185241699218750,
-0.0330505371093750, -0.0037231445312500, -0.0283203125000000, -0.0018005371093750,
-0.0356445312500000, -0.0096130371093750, -0.0489807128906250, -0.0074462890625000,
-0.0413513183593750, -0.0032043457031250, -0.0581054687500000, -0.0222778320312500,
-0.0588073730468750, -0.0193176269531250, -0.0580444335937500, -0.0242004394531250,
-0.0668640136718750, -0.0397644042968750, -0.0643615722656250, -0.0337524414062500,
-0.0580444335937500, -0.0392761230468750, -0.0635070800781250, -0.0410156250000000,
-0.0558471679687500, -0.0424194335937500, -0.0350646972656250, -0.0475769042968750,
-0.0257263183593750, -0.0495605468750000, 0.0020446777343750, -0.0490417480468750,
-0.0069580078125000, -0.0501403808593750, -0.0042114257812500, -0.0525512695312500,
0.0092468261718750, -0.0521850585937500, 0.0074462890625000, -0.0496826171875000,
0.0058898925781250, -0.0556640625000000, 0.0059814453125000, -0.0581970214843750,
0.0065917968750000, -0.0529479980468750, 0.0061645507812500, -0.0527954101562500,
0.0054016113281250, -0.0552978515625000, 0.0094299316406250, -0.0335388183593750,
0.0080871582031250, -0.0387878417968750, 0.0090332031250000, -0.0349731445312500,
0.0133666992187500},
{-0.0500488281250000, -0.0057983398437500, -0.0503540039062500, -0.0038452148437500,
-0.0509338378906250, -0.0056762695312500, -0.0459594726562500, 0.0012207031250000,
-0.0471191406250000, -0.0001220703125000, -0.0454711914062500, 0.0023803710937500,
-0.0411682128906250, 0.0083923339843750, -0.0432128906250000, 0.0055541992187500,
-0.0401611328125000, 0.0110778808593750, -0.0403442382812500, 0.0117187500000000,
-0.0389404296875000, 0.0099792480468750, -0.0371093750000000, 0.0124511718750000,
-0.0387878417968750, 0.0129394531250000, -0.0317687988281250, 0.0053100585937500,
-0.0334167480468750, 0.0080261230468750, -0.0307312011718750, 0.0030822753906250,
-0.0243225097656250, -0.0051269531250000, -0.0271911621093750, -0.0003356933593750,
-0.0208740234375000, -0.0122680664062500, -0.0213012695312500, -0.0125732421875000,
-0.0189819335937500, -0.0120849609375000, -0.0144653320312500, -0.0187988281250000,
-0.0171508789062500, -0.0178527832031250, -0.0087280273437500, -0.0144958496093750,
-0.0090637207031250, -0.0175781250000000, -0.0086364746093750, -0.0118713378906250,
-0.0032958984375000, -0.0043640136718750, -0.0048522949218750, -0.0095214843750000,
-0.0057678222656250, -0.0008239746093750, -0.0046386718750000, 0.0035705566406250,
-0.0049133300781250, -0.0035095214843750, -0.0070190429687500, -0.0057678222656250,
-0.0068054199218750, -0.0012817382812500, -0.0031738281250000, -0.0184020996093750,
-0.0047912597656250, -0.0179748535156250, -0.0028686523437500, -0.0175781250000000,
0.0016174316406250, -0.0271301269531250, -0.0003051757812500, -0.0247192382812500,
0.0018005371093750, -0.0199279785156250, 0.0028381347656250, -0.0252685546875000,
0.0020751953125000, -0.0162658691406250, 0.0025024414062500, -0.0057067871093750,
0.0029296875000000, -0.0130920410156250, -0.0002136230468750, 0.0085144042968750,
0.0021362304687500, 0.0079040527343750, -0.0023803710937500, 0.0077209472656250,
-0.0067443847656250, 0.0224304199218750, -0.0028076171875000, 0.0192260742187500,
-0.0197143554687500, 0.0028381347656250, -0.0148620605468750, 0.0112304687500000,
-0.0235290527343750, 0.0007019042968750, -0.0405883789062500, -0.0198974609375000,
-0.0307617187500000, -0.0083007812500000, -0.0490722656250000, -0.0231323242187500,
-0.0513305664062500, -0.0317993164062500, -0.0502929687500000, -0.0198669433593750,
-0.0574340820312500, -0.0120239257812500, -0.0551757812500000, -0.0194091796875000,
-0.0561218261718750, -0.0100708007812500, -0.0585632324218750, -0.0039062500000000,
-0.0530395507812500, -0.0146789550781250, -0.0502929687500000, -0.0189819335937500,
-0.0541992187500000, -0.0110778808593750, -0.0352172851562500, -0.0386657714843750,
-0.0381469726562500, -0.0382385253906250, -0.0353393554687500, -0.0367431640625000,
-0.0138854980468750, -0.0564575195312500, -0.0080871582031250, -0.0227966308593750,
-0.0017089843750000, -0.0522766113281250, 0.0003051757812500, -0.0455017089843750,
0.0005187988281250, -0.0468444824218750, -0.0019836425781250, -0.0583190917968750,
-0.0031433105468750, -0.0572204589843750, 0.0071716308593750, -0.0531005859375000,
0.0059509277343750, -0.0540771484375000, 0.0043945312500000, -0.0533447265625000,
0.0113220214843750, -0.0502624511718750, 0.0103759765625000, -0.0510864257812500,
-0.0027160644531250, -0.0517272949218750, 0.0027465820312500, -0.0536193847656250,
-0.0047912597656250, -0.0456542968750000, -0.0201416015625000, -0.0412902832031250,
-0.0120849609375000, -0.0482177734375000, -0.0232543945312500, -0.0270690917968750,
-0.0295104980468750, -0.0265197753906250, -0.0191955566406250, -0.0274047851562500,
-0.0145263671875000, -0.0178222656250000, -0.0223083496093750, -0.0199279785156250,
-0.0072631835937500, -0.0191650390625000, -0.0057983398437500, -0.0195617675781250,
-0.0076293945312500, -0.0159606933593750, -0.0007324218750000, -0.0145874023437500,
-0.0024414062500000, -0.0175170898437500, -0.0132446289062500, -0.0004577636718750,
-0.0054626464843750, -0.0033569335937500, -0.0170288085937500, -0.0005187988281250,
-0.0357971191406250, 0.0131835937500000, -0.0234985351562500, 0.0085754394531250,
-0.0361633300781250, 0.0073547363281250, -0.0450439453125000, 0.0113525390625000,
-0.0355224609375000, 0.0076293945312500, -0.0288391113281250, 0.0018920898437500,
-0.0350036621093750, 0.0047607421875000, -0.0269470214843750, 0.0002441406250000,
-0.0247802734375000, 0.0003967285156250, -0.0256347656250000, -0.0016174316406250,
-0.0240783691406250, -0.0044860839843750, -0.0243835449218750, -0.0019836425781250,
-0.0213623046875000, -0.0106506347656250, -0.0227355957031250, -0.0098266601562500,
-0.0203552246093750, -0.0101013183593750, -0.0167541503906250, -0.0156250000000000,
-0.0187988281250000, -0.0139160156250000, -0.0115966796875000, -0.0125122070312500,
-0.0135192871093750, -0.0129699707031250, -0.0111694335937500, -0.0131530761718750,
-0.0047302246093750, -0.0113220214843750, -0.0081787109375000, -0.0108337402343750,
-0.0036926269531250, -0.0164794921875000, -0.0033569335937500, -0.0140380859375000,
-0.0028076171875000, -0.0172424316406250, -0.0004272460937500, -0.0233154296875000,
-0.0019226074218750, -0.0200500488281250, -0.0001525878906250, -0.0292663574218750,
0.0009155273437500, -0.0276184082031250, -0.0014038085937500, -0.0314636230468750,
-0.0021667480468750, -0.0392456054687500, -0.0004272460937500, -0.0345764160156250,
-0.0061645507812500, -0.0444030761718750, -0.0061035156250000, -0.0449829101562500,
-0.0051269531250000, -0.0440673828125000, -0.0080871582031250, -0.0481567382812500,
-0.0079956054687500, -0.0473022460937500, -0.0037841796875000, -0.0468750000000000,
-0.0054931640625000, -0.0468750000000000, -0.0039978027343750, -0.0476684570312500,
0.0000000000000000, -0.0481567382812500, -0.0022583007812500, -0.0474548339843750,
0.0004882812500000, -0.0486145019531250, 0.0003662109375000, -0.0497741699218750,
0.0005187988281250, -0.0477600097656250, 0.0015563964843750, -0.0468139648437500,
0.0002136230468750, -0.0483703613281250, 0.0023193359375000, -0.0422058105468750,
0.0016479492187500, -0.0437316894531250, 0.0018310546875000, -0.0407409667968750,
0.0033569335937500, -0.0355529785156250, 0.0021972656250000, -0.0388488769531250,
0.0032958984375000, -0.0288391113281250, 0.0036010742187500, -0.0304870605468750,
0.0032348632812500, -0.0271911621093750, 0.0036926269531250, -0.0193481445312500,
0.0039062500000000, -0.0236206054687500, 0.0028686523437500, -0.0137634277343750,
0.0035705566406250, -0.0145874023437500, 0.0024719238281250, -0.0121459960937500,
0.0012512207031250, -0.0051269531250000, 0.0027160644531250, -0.0084533691406250,
-0.0006713867187500, -0.0015563964843750, 0.0002746582031250, -0.0007629394531250,
-0.0012512207031250, -0.0008544921875000, -0.0042724609375000, 0.0024719238281250,
-0.0020141601562500, 0.0020141601562500, -0.0061645507812500, 0.0017700195312500,
-0.0059509277343750, 0.0032348632812500, -0.0057678222656250, 0.0009155273437500,
-0.0079956054687500, -0.0007934570312500, -0.0070495605468750, 0.0010070800781250,
-0.0068969726562500, -0.0079650878906250, -0.0070190429687500, -0.0055541992187500,
-0.0063781738281250, -0.0104675292968750, -0.0054931640625000, -0.0192565917968750,
-0.0053405761718750, -0.0141906738281250, -0.0053405761718750, -0.0269775390625000,
-0.0046691894531250, -0.0263977050781250, -0.0052185058593750, -0.0284118652343750,
-0.0057678222656250, -0.0366210937500000, -0.0049438476562500, -0.0335083007812500,
-0.0072021484375000, -0.0396423339843750, -0.0069274902343750, -0.0393371582031250,
-0.0078430175781250, -0.0415344238281250, -0.0098266601562500, -0.0456542968750000,
-0.0088806152343750, -0.0427246093750000, -0.0107116699218750, -0.0509338378906250,
-0.0117492675781250, -0.0506896972656250, -0.0104064941406250, -0.0497741699218750,
-0.0107116699218750, -0.0543212890625000, -0.0123291015625000, -0.0537719726562500,
-0.0072631835937500, -0.0495300292968750, -0.0093078613281250, -0.0517578125000000,
-0.0067138671875000, -0.0493469238281250, -0.0017700195312500, -0.0451660156250000,
-0.0050964355468750, -0.0479736328125000, 0.0032043457031250, -0.0395507812500000,
0.0023193359375000, -0.0422363281250000, 0.0039978027343750, -0.0376586914062500,
0.0100097656250000, -0.0290222167968750, 0.0072631835937500, -0.0343322753906250,
0.0111083984375000, -0.0227966308593750, 0.0126953125000000, -0.0223999023437500,
0.0102539062500000, -0.0211181640625000, 0.0105590820312500, -0.0147399902343750,
0.0116882324218750, -0.0166625976562500, 0.0031127929687500, -0.0108947753906250,
0.0057983398437500, -0.0113525390625000, 0.0004577636718750, -0.0082702636718750,
-0.0091247558593750, -0.0037231445312500, -0.0040893554687500, -0.0067749023437500,
-0.0138244628906250, 0.0025329589843750, -0.0161437988281250, 0.0025024414062500,
-0.0141906738281250, 0.0011901855468750, -0.0166931152343750, 0.0068664550781250,
-0.0165100097656250, 0.0064086914062500, -0.0104675292968750, -0.0034179687500000,
-0.0126037597656250, 0.0022888183593750, -0.0086364746093750, -0.0037231445312500,
-0.0008544921875000, -0.0163574218750000, -0.0045166015625000, -0.0090332031250000,
-0.0018615722656250, -0.0181579589843750, 0.0015563964843750, -0.0205993652343750,
-0.0032043457031250, -0.0169372558593750, -0.0068969726562500, -0.0190429687500000,
-0.0039367675781250, -0.0202636718750000, -0.0144653320312500, -0.0082092285156250,
-0.0151062011718750, -0.0095520019531250, -0.0133666992187500, -0.0132751464843750,
-0.0180053710937500, -0.0075073242187500, -0.0187072753906250, -0.0054931640625000,
-0.0138549804687500, -0.0142211914062500, -0.0150146484375000, -0.0143737792968750,
-0.0124816894531250, -0.0156860351562500, -0.0086669921875000, -0.0204467773437500,
-0.0120544433593750, -0.0175781250000000, -0.0043334960937500, -0.0178222656250000,
-0.0040283203125000, -0.0219726562500000, -0.0048522949218750, -0.0160522460937500,
-0.0024414062500000, -0.0096740722656250, -0.0034484863281250, -0.0153198242187500,
-0.0013122558593750, -0.0064392089843750, -0.0021362304687500, -0.0036926269531250,
-0.0008239746093750, -0.0068359375000000, 0.0021057128906250, -0.0070800781250000,
0.0004882812500000, -0.0058593750000000, 0.0007934570312500, -0.0057983398437500,
0.0025634765625000, -0.0071716308593750, 0.0016479492187500, -0.0053100585937500,
-0.0002441406250000, -0.0032348632812500, 0.0010681152343750, -0.0035705566406250,
0.0021362304687500, 0.0038146972656250, 0.0017395019531250, 0.0019836425781250,
0.0012512207031250, 0.0020751953125000, 0.0024108886718750, 0.0070495605468750,
0.0025024414062500, 0.0054931640625000, -0.0033874511718750, 0.0066528320312500,
-0.0018310546875000, 0.0072326660156250, -0.0021362304687500, 0.0073547363281250,
-0.0057983398437500, 0.0081176757812500, -0.0055541992187500, 0.0073547363281250,
-0.0113830566406250, 0.0050048828125000, -0.0072631835937500, 0.0076904296875000,
-0.0136413574218750, 0.0041198730468750, -0.0231018066406250, -0.0013732910156250,
-0.0166625976562500, 0.0013427734375000, -0.0306091308593750, -0.0054931640625000,
-0.0318298339843750, -0.0052185058593750, -0.0298767089843750, -0.0053100585937500,
-0.0356750488281250, -0.0096130371093750, -0.0346374511718750, -0.0087280273437500,
-0.0283203125000000, -0.0075683593750000, -0.0326843261718750, -0.0075073242187500,
-0.0260925292968750, -0.0081787109375000, -0.0155334472656250, -0.0079040527343750,
-0.0221862792968750, -0.0074157714843750, -0.0132141113281250, -0.0108642578125000,
-0.0101318359375000, -0.0104370117187500, -0.0131530761718750, -0.0086364746093750,
-0.0132141113281250, -0.0108642578125000, -0.0115356445312500, -0.0119018554687500,
-0.0108337402343750},
{0.0037231445312500, -0.0288696289062500, 0.0023193359375000, -0.0265808105468750,
0.0025024414062500, -0.0259399414062500, 0.0028076171875000, -0.0252380371093750,
0.0021362304687500, -0.0242614746093750, 0.0023498535156250, -0.0244750976562500,
0.0036010742187500, -0.0198669433593750, 0.0035705566406250, -0.0217285156250000,
0.0035400390625000, -0.0189819335937500, 0.0051574707031250, -0.0132751464843750,
0.0052490234375000, -0.0166320800781250, 0.0002136230468750, -0.0138244628906250,
0.0030517578125000, -0.0106201171875000, -0.0010986328125000, -0.0151062011718750,
-0.0078125000000000, -0.0178833007812500, -0.0039367675781250, -0.0135498046875000,
-0.0140075683593750, -0.0226135253906250, -0.0140686035156250, -0.0230407714843750,
-0.0131225585937500, -0.0198364257812500, -0.0186462402343750, -0.0230407714843750,
-0.0176086425781250, -0.0234375000000000, -0.0115051269531250, -0.0138244628906250,
-0.0136413574218750, -0.0178222656250000, -0.0111083984375000, -0.0106201171875000,
-0.0046997070312500, 0.0022277832031250, -0.0073547363281250, -0.0064086914062500,
-0.0049438476562500, -0.0016174316406250, -0.0024719238281250, 0.0058593750000000,
-0.0069580078125000, -0.0014038085937500, -0.0105590820312500, -0.0098266601562500,
-0.0073547363281250, -0.0051574707031250, -0.0126037597656250, -0.0118713378906250,
-0.0151672363281250, -0.0137023925781250, -0.0131530761718750, -0.0108337402343750,
-0.0132446289062500, -0.0127563476562500, -0.0140686035156250, -0.0144958496093750,
-0.0063476562500000, -0.0045776367187500, -0.0096740722656250, -0.0052795410156250,
-0.0065307617187500, -0.0072937011718750, 0.0021667480468750, -0.0021362304687500,
-0.0022277832031250, -0.0017700195312500, 0.0011291503906250, -0.0093994140625000,
0.0028381347656250, -0.0096130371093750, -0.0002746582031250, -0.0058593750000000,
-0.0017089843750000, -0.0077209472656250, -0.0003662109375000, -0.0101623535156250,
-0.0036621093750000, -0.0017395019531250, -0.0043945312500000, -0.0026245117187500,
-0.0044860839843750, -0.0006408691406250, -0.0055847167968750, 0.0068054199218750,
-0.0050659179687500, 0.0057067871093750, -0.0048217773437500, 0.0064697265625000,
-0.0047302246093750, 0.0067138671875000, -0.0051879882812500, 0.0067749023437500,
-0.0051269531250000, 0.0072631835937500, -0.0044860839843750, 0.0068969726562500,
-0.0065917968750000, 0.0070495605468750, -0.0060729980468750, 0.0077819824218750,
-0.0061035156250000, 0.0054626464843750, -0.0081176757812500, 0.0042114257812500,
-0.0078125000000000, 0.0061035156250000, -0.0052795410156250, -0.0003967285156250,
-0.0043029785156250, -0.0004577636718750, -0.0090332031250000, -0.0011596679687500,
-0.0103149414062500, -0.0041809082031250, -0.0063476562500000, -0.0025939941406250,
-0.0195007324218750, -0.0068054199218750, -0.0188903808593750, -0.0070190429687500,
-0.0184326171875000, -0.0071411132812500, -0.0256958007812500, -0.0087280273437500,
-0.0239868164062500, -0.0077514648437500, -0.0217590332031250, -0.0103149414062500,
-0.0237121582031250, -0.0110473632812500, -0.0201416015625000, -0.0087585449218750,
-0.0169372558593750, -0.0086059570312500, -0.0202941894531250, -0.0097961425781250,
-0.0085754394531250, -0.0024414062500000, -0.0093688964843750, -0.0042114257812500,
-0.0090942382812500, -0.0025329589843750, -0.0015563964843750, 0.0046997070312500,
-0.0034484863281250, 0.0025024414062500, -0.0061950683593750, 0.0003356933593750,
-0.0039367675781250, 0.0025939941406250, -0.0049743652343750, 0.0010681152343750,
-0.0090637207031250, -0.0021667480468750, -0.0080871582031250, -0.0002746582031250,
-0.0071716308593750, -0.0028991699218750, -0.0075378417968750, -0.0037231445312500,
-0.0090026855468750, -0.0003662109375000, -0.0087280273437500, 0.0005493164062500,
-0.0079345703125000, -0.0011291503906250, -0.0140991210937500, 0.0068664550781250,
-0.0124816894531250, 0.0072021484375000, -0.0150146484375000, 0.0073242187500000,
-0.0210876464843750, 0.0118713378906250, -0.0181884765625000, 0.0114746093750000,
-0.0220031738281250, 0.0090026855468750, -0.0235595703125000, 0.0108032226562500,
-0.0230712890625000, 0.0095825195312500, -0.0235900878906250, 0.0064697265625000,
-0.0242919921875000, 0.0081481933593750, -0.0257568359375000, 0.0061645507812500,
-0.0241394042968750, 0.0063171386718750, -0.0278320312500000, 0.0062866210937500,
-0.0309143066406250, 0.0053710937500000, -0.0273742675781250, 0.0062255859375000,
-0.0381469726562500, 0.0052490234375000, -0.0364074707031250, 0.0054321289062500,
-0.0373229980468750, 0.0047302246093750, -0.0447387695312500, 0.0038146972656250,
-0.0414733886718750, 0.0042419433593750, -0.0421752929687500, 0.0007629394531250,
-0.0440368652343750, 0.0016479492187500, -0.0412597656250000, -0.0006103515625000,
-0.0388488769531250, -0.0041809082031250, -0.0402526855468750, -0.0025329589843750,
-0.0351867675781250, -0.0088806152343750, -0.0357360839843750, -0.0088195800781250,
-0.0335083007812500, -0.0102233886718750, -0.0293884277343750, -0.0145874023437500,
-0.0314941406250000, -0.0131530761718750, -0.0256652832031250, -0.0151977539062500,
-0.0254821777343750, -0.0159912109375000, -0.0253601074218750, -0.0145874023437500,
-0.0222778320312500, -0.0143127441406250, -0.0228271484375000, -0.0149230957031250,
-0.0216064453125000, -0.0116577148437500, -0.0213317871093750, -0.0121459960937500,
-0.0203247070312500, -0.0104980468750000, -0.0192871093750000, -0.0077514648437500,
-0.0197448730468750, -0.0090637207031250, -0.0170593261718750, -0.0045471191406250,
-0.0171203613281250, -0.0048828125000000, -0.0165405273437500, -0.0032653808593750,
-0.0148315429687500, 0.0002136230468750, -0.0154113769531250, -0.0015563964843750,
-0.0139160156250000, 0.0025024414062500, -0.0144042968750000, 0.0032653808593750,
-0.0133972167968750, 0.0032653808593750, -0.0117492675781250, 0.0048217773437500,
-0.0130310058593750, 0.0046386718750000, -0.0109863281250000, 0.0046997070312500,
-0.0106811523437500, 0.0048828125000000, -0.0122985839843750, 0.0048522949218750,
-0.0120544433593750, 0.0046691894531250, -0.0116882324218750, 0.0044860839843750,
-0.0173645019531250, 0.0047302246093750, -0.0160827636718750, 0.0050659179687500,
-0.0184326171875000, 0.0045471191406250, -0.0235290527343750, 0.0043945312500000,
-0.0210571289062500, 0.0047607421875000, -0.0258178710937500, 0.0025634765625000,
-0.0258483886718750, 0.0037231445312500, -0.0265808105468750, 0.0019531250000000,
-0.0293273925781250, -0.0005187988281250, -0.0277099609375000, 0.0016174316406250,
-0.0299377441406250, -0.0036010742187500, -0.0303649902343750, -0.0032958984375000,
-0.0289611816406250, -0.0028076171875000, -0.0286254882812500, -0.0058898925781250,
-0.0288391113281250, -0.0050048828125000, -0.0271911621093750, -0.0021972656250000,
-0.0261230468750000, -0.0044555664062500, -0.0270996093750000, -0.0008239746093750,
-0.0271301269531250, 0.0036621093750000, -0.0256042480468750, -0.0000305175781250,
-0.0288696289062500, 0.0094909667968750, -0.0285644531250000, 0.0089111328125000,
-0.0286254882812500, 0.0097656250000000, -0.0302124023437500, 0.0157165527343750,
-0.0292358398437500, 0.0135803222656250, -0.0300903320312500, 0.0157165527343750,
-0.0298461914062500, 0.0171508789062500, -0.0298767089843750, 0.0143127441406250,
-0.0307617187500000, 0.0139465332031250, -0.0301513671875000, 0.0160522460937500,
-0.0290222167968750, 0.0065917968750000, -0.0297851562500000, 0.0087280273437500,
-0.0283813476562500, 0.0055236816406250, -0.0261840820312500, -0.0026855468750000,
-0.0272827148437500, 0.0016784667968750, -0.0263061523437500, -0.0042724609375000,
-0.0255737304687500, -0.0066223144531250, -0.0262145996093750, -0.0031738281250000,
-0.0268859863281250, -0.0025329589843750, -0.0263366699218750, -0.0041503906250000,
-0.0254821777343750, 0.0014038085937500, -0.0263977050781250, 0.0019531250000000,
-0.0250549316406250, 0.0017089843750000, -0.0228576660156250, 0.0048217773437500,
-0.0238037109375000, 0.0042724609375000, -0.0223388671875000, -0.0011291503906250,
-0.0219421386718750, 0.0020446777343750, -0.0214233398437500, -0.0018615722656250,
-0.0210876464843750, -0.0094604492187500, -0.0213012695312500, -0.0057373046875000,
-0.0167236328125000, -0.0128173828125000, -0.0177307128906250, -0.0139465332031250,
-0.0170593261718750, -0.0130310058593750, -0.0124206542968750, -0.0154724121093750,
-0.0137939453125000, -0.0148620605468750, -0.0188293457031250, -0.0126647949218750,
-0.0153198242187500, -0.0146789550781250, -0.0197143554687500, -0.0115051269531250,
-0.0281677246093750, -0.0071105957031250, -0.0239868164062500, -0.0096435546875000,
-0.0278930664062500, -0.0026245117187500, -0.0307922363281250, -0.0018920898437500,
-0.0277404785156250, -0.0042724609375000, -0.0261840820312500, -0.0024414062500000,
-0.0279541015625000, -0.0005187988281250, -0.0215454101562500, -0.0023498535156250,
-0.0227355957031250, -0.0051269531250000, -0.0214538574218750, -0.0024108886718750,
-0.0160827636718750, 0.0009765625000000, -0.0179748535156250, -0.0000305175781250,
-0.0170288085937500, 0.0054931640625000, -0.0169677734375000, 0.0053710937500000,
-0.0142822265625000, 0.0025939941406250, -0.0126647949218750, 0.0054321289062500,
-0.0151062011718750, 0.0079956054687500, -0.0072021484375000, -0.0017700195312500,
-0.0070800781250000, -0.0003051757812500, -0.0075988769531250, -0.0052795410156250,
-0.0048217773437500, -0.0127868652343750, -0.0053710937500000, -0.0064697265625000,
-0.0013122558593750, -0.0188598632812500, -0.0029602050781250, -0.0204467773437500,
-0.0027770996093750, -0.0184631347656250, 0.0027770996093750, -0.0238952636718750,
0.0089111328125000, -0.0018920898437500, -0.0021667480468750, -0.0256042480468750,
0.0023803710937500, -0.0236206054687500, -0.0035400390625000, -0.0213928222656250,
-0.0122375488281250, -0.0241394042968750, -0.0074157714843750, -0.0252380371093750,
-0.0112915039062500, -0.0291442871093750, -0.0159606933593750, -0.0238342285156250,
-0.0091247558593750, -0.0324707031250000, -0.0043945312500000, -0.0437622070312500,
-0.0104370117187500, -0.0358581542968750, 0.0024719238281250, -0.0510864257812500,
0.0050048828125000, -0.0557250976562500, 0.0001525878906250, -0.0466613769531250,
0.0028076171875000, -0.0469360351562500, 0.0047607421875000, -0.0521545410156250,
-0.0081481933593750, -0.0313110351562500, -0.0074462890625000, -0.0327148437500000,
-0.0042114257812500, -0.0315246582031250, -0.0095520019531250, -0.0188903808593750,
-0.0116882324218750, -0.0227050781250000, -0.0086364746093750, -0.0221557617187500,
-0.0045166015625000, -0.0216674804687500, -0.0116577148437500, -0.0193481445312500,
-0.0180053710937500, -0.0182495117187500, -0.0124206542968750, -0.0207824707031250,
-0.0238952636718750, -0.0135192871093750, -0.0249633789062500, -0.0126953125000000,
-0.0242614746093750, -0.0134887695312500, -0.0287780761718750, -0.0114135742187500,
-0.0267944335937500, -0.0114746093750000, -0.0257873535156250, -0.0089721679687500,
-0.0307922363281250, -0.0108032226562500, -0.0202636718750000, -0.0073852539062500,
-0.0102233886718750, -0.0023803710937500, -0.0192260742187500, -0.0054931640625000,
0.0003051757812500, -0.0003356933593750, 0.0019531250000000, 0.0017089843750000,
0.0003051757812500, -0.0015563964843750, 0.0090332031250000, -0.0016784667968750,
0.0070800781250000, 0.0001831054687500, 0.0002441406250000, -0.0089416503906250,
0.0049743652343750, -0.0072937011718750, -0.0004577636718750, -0.0097656250000000,
-0.0110168457031250, -0.0166015625000000, -0.0048828125000000, -0.0134887695312500,
-0.0095214843750000, -0.0210266113281250, -0.0150451660156250, -0.0197448730468750,
-0.0065307617187500},
{-0.0231933593750000, -0.0039672851562500, -0.0281066894531250, -0.0057983398437500,
-0.0330810546875000, -0.0086059570312500, -0.0289916992187500, -0.0069274902343750,
-0.0354614257812500, -0.0120544433593750, -0.0385437011718750, -0.0113830566406250,
-0.0334472656250000, -0.0117492675781250, -0.0318908691406250, -0.0160827636718750,
-0.0351867675781250, -0.0148010253906250, -0.0250549316406250, -0.0111389160156250,
-0.0260620117187500, -0.0144958496093750, -0.0231018066406250, -0.0077209472656250,
-0.0165710449218750, 0.0008850097656250, -0.0207214355468750, -0.0053710937500000,
-0.0090942382812500, 0.0031738281250000, -0.0098266601562500, 0.0057983398437500,
-0.0086975097656250, 0.0056762695312500, -0.0018310546875000, 0.0081787109375000,
-0.0041198730468750, 0.0062866210937500, 0.0024108886718750, 0.0039672851562500,
0.0017700195312500, 0.0066833496093750, 0.0021057128906250, 0.0054931640625000,
0.0063781738281250, 0.0011596679687500, 0.0051879882812500, 0.0020446777343750,
0.0060424804687500, 0.0010375976562500, 0.0049438476562500, -0.0006713867187500,
0.0078735351562500, 0.0046081542968750, 0.0111083984375000, 0.0094299316406250,
0.0076599121093750, 0.0042114257812500, 0.0111083984375000, 0.0044860839843750,
0.0143127441406250, 0.0115966796875000, 0.0101318359375000, 0.0029907226562500,
0.0036621093750000, -0.0160827636718750, 0.0005798339843750, 0.0124816894531250,
0.0035095214843750, 0.0027770996093750, -0.0005798339843750, 0.0150146484375000,
0.0036926269531250, 0.0017395019531250, 0.0094909667968750, -0.0168151855468750,
0.0057983398437500, -0.0073852539062500, 0.0083007812500000, -0.0174560546875000,
0.0112609863281250, -0.0214843750000000, 0.0066833496093750, -0.0183410644531250,
0.0041809082031250, -0.0179443359375000, 0.0076904296875000, -0.0194396972656250,
-0.0047912597656250, -0.0222778320312500, -0.0046386718750000, -0.0173950195312500,
-0.0038452148437500, -0.0250854492187500, -0.0107727050781250, -0.0359802246093750,
-0.0093383789062500, -0.0286254882812500, -0.0027465820312500, -0.0350952148437500,
-0.0044250488281250, -0.0419311523437500, -0.0086059570312500, -0.0318908691406250,
-0.0036926269531250, -0.0242919921875000, -0.0003967285156250, -0.0319213867187500,
-0.0211486816406250, -0.0158691406250000, -0.0185241699218750, -0.0126647949218750,
-0.0191650390625000, -0.0176391601562500, -0.0326843261718750, -0.0154418945312500,
-0.0286560058593750, -0.0137634277343750, -0.0246582031250000, -0.0183105468750000,
-0.0299377441406250, -0.0199584960937500, -0.0221557617187500, -0.0177307128906250,
-0.0134582519531250, -0.0172424316406250, -0.0202026367187500, -0.0182800292968750,
0.0009765625000000, -0.0146484375000000, 0.0011291503906250, -0.0147094726562500,
-0.0021057128906250, -0.0140686035156250, 0.0073852539062500, -0.0119018554687500,
0.0073852539062500, -0.0127563476562500, 0.0014038085937500, -0.0103759765625000,
0.0030212402343750, -0.0107421875000000, 0.0009765625000000, -0.0097351074218750,
-0.0043640136718750, -0.0073547363281250, -0.0011596679687500, -0.0085754394531250,
-0.0019531250000000, -0.0077209472656250, -0.0062866210937500, -0.0057983398437500,
0.0007629394531250, -0.0090942382812500, 0.0066833496093750, -0.0113830566406250,
0.0001831054687500, -0.0087890625000000, 0.0155334472656250, -0.0180358886718750,
0.0165100097656250, -0.0168151855468750, 0.0129699707031250, -0.0188293457031250,
0.0189819335937500, -0.0252380371093750, 0.0195922851562500, -0.0222778320312500,
0.0098266601562500, -0.0282592773437500, 0.0127563476562500, -0.0281677246093750,
0.0097351074218750, -0.0288085937500000, 0.0015563964843750, -0.0327758789062500,
0.0055236816406250, -0.0311889648437500, -0.0028991699218750, -0.0313415527343750,
-0.0028076171875000, -0.0328063964843750, -0.0028686523437500, -0.0306396484375000,
-0.0082397460937500, -0.0283508300781250, -0.0067138671875000, -0.0297851562500000,
-0.0032958984375000, -0.0264282226562500, -0.0065612792968750, -0.0260620117187500,
-0.0024414062500000, -0.0255737304687500, 0.0033264160156250, -0.0241088867187500,
-0.0011596679687500, -0.0248107910156250, 0.0078430175781250, -0.0215148925781250,
0.0071411132812500, -0.0222167968750000, 0.0076599121093750, -0.0215454101562500,
0.0129089355468750, -0.0186767578125000, 0.0104370117187500, -0.0198669433593750,
0.0131225585937500, -0.0202941894531250, 0.0137939453125000, -0.0199584960937500,
0.0130310058593750, -0.0202941894531250, 0.0138549804687500, -0.0216064453125000,
0.0142822265625000, -0.0217285156250000, 0.0125122070312500, -0.0191345214843750,
0.0137939453125000, -0.0200805664062500, 0.0122375488281250, -0.0191345214843750,
0.0104675292968750, -0.0161743164062500, 0.0128479003906250, -0.0173034667968750,
0.0065917968750000, -0.0167236328125000, 0.0087890625000000, -0.0157470703125000,
0.0065002441406250, -0.0166015625000000, 0.0010070800781250, -0.0174255371093750,
0.0046997070312500, -0.0167846679687500, -0.0029296875000000, -0.0180969238281250,
-0.0017089843750000, -0.0178833007812500, -0.0032958984375000, -0.0184936523437500,
-0.0084228515625000, -0.0196228027343750, -0.0050964355468750, -0.0189514160156250,
-0.0114440917968750, -0.0203857421875000, -0.0102844238281250, -0.0207824707031250,
-0.0115051269531250, -0.0204162597656250, -0.0157470703125000, -0.0209655761718750,
-0.0128479003906250, -0.0212097167968750, -0.0183410644531250, -0.0192565917968750,
-0.0173645019531250, -0.0203552246093750, -0.0181884765625000, -0.0188903808593750,
-0.0219421386718750, -0.0166015625000000, -0.0196228027343750, -0.0183715820312500,
-0.0224609375000000, -0.0141296386718750, -0.0221557617187500, -0.0143737792968750,
-0.0220031738281250, -0.0137939453125000, -0.0234375000000000, -0.0107116699218750,
-0.0219726562500000, -0.0114746093750000, -0.0216064453125000, -0.0109252929687500,
-0.0225219726562500, -0.0099792480468750, -0.0197143554687500, -0.0104980468750000,
-0.0175170898437500, -0.0111083984375000, -0.0191040039062500, -0.0108032226562500,
-0.0119018554687500, -0.0119934082031250, -0.0129394531250000, -0.0119934082031250,
-0.0109863281250000, -0.0125122070312500, -0.0054931640625000, -0.0137939453125000,
-0.0075988769531250, -0.0137634277343750, -0.0021362304687500, -0.0140380859375000,
-0.0019836425781250, -0.0148620605468750, -0.0016479492187500, -0.0146484375000000,
0.0017089843750000, -0.0137023925781250, 0.0007629394531250, -0.0141906738281250,
0.0000000000000000, -0.0158081054687500, 0.0013732910156250, -0.0140075683593750,
-0.0006103515625000, -0.0159606933593750, -0.0031738281250000, -0.0186767578125000,
-0.0016174316406250, -0.0164489746093750, -0.0050659179687500, -0.0224914550781250,
-0.0055847167968750, -0.0208740234375000, -0.0058593750000000, -0.0231628417968750,
-0.0076599121093750, -0.0288391113281250, -0.0073242187500000, -0.0257263183593750,
-0.0076904296875000, -0.0302124023437500, -0.0086364746093750, -0.0314025878906250,
-0.0070800781250000, -0.0313720703125000, -0.0061035156250000, -0.0319519042968750,
-0.0071716308593750, -0.0315551757812500, -0.0015258789062500, -0.0371398925781250,
-0.0026550292968750, -0.0346374511718750, -0.0001220703125000, -0.0374755859375000,
0.0052795410156250, -0.0440979003906250, 0.0028991699218750, -0.0403747558593750,
0.0068664550781250, -0.0434875488281250, 0.0079956054687500, -0.0463256835937500,
0.0071105957031250, -0.0403137207031250, 0.0080261230468750, -0.0377197265625000,
0.0080871582031250, -0.0419006347656250, 0.0058898925781250, -0.0249938964843750,
0.0063171386718750, -0.0279541015625000, 0.0049438476562500, -0.0236816406250000,
0.0033569335937500, -0.0104370117187500, 0.0047607421875000, -0.0172119140625000,
-0.0008850097656250, -0.0105895996093750, -0.0003051757812500, -0.0068359375000000,
-0.0001220703125000, -0.0104675292968750, -0.0033569335937500, -0.0136108398437500,
-0.0028076171875000, -0.0115356445312500, -0.0028991699218750, -0.0065612792968750,
-0.0020141601562500, -0.0105895996093750, -0.0037231445312500, -0.0078430175781250,
-0.0055541992187500, -0.0010681152343750, -0.0039062500000000, -0.0042419433593750,
-0.0065612792968750, 0.0026550292968750, -0.0064086914062500, 0.0027465820312500,
-0.0068969726562500, 0.0021362304687500, -0.0089416503906250, 0.0049133300781250,
-0.0078735351562500, 0.0043029785156250, -0.0072326660156250, 0.0061340332031250,
-0.0076293945312500, 0.0039062500000000, -0.0078430175781250, 0.0086364746093750,
-0.0073547363281250, 0.0137023925781250, -0.0067443847656250, 0.0079956054687500,
-0.0072326660156250, 0.0155334472656250, -0.0077819824218750, 0.0189819335937500,
-0.0063781738281250, 0.0151367187500000, -0.0060424804687500, 0.0141906738281250,
-0.0072021484375000, 0.0154418945312500, -0.0014038085937500, 0.0070800781250000,
-0.0016479492187500, 0.0093688964843750, -0.0035400390625000, 0.0067443847656250,
-0.0017089843750000, -0.0022583007812500, -0.0030212402343750, -0.0009460449218750,
-0.0099487304687500, -0.0045776367187500, -0.0082092285156250, -0.0044555664062500,
-0.0071105957031250, -0.0032043457031250, -0.0117492675781250, -0.0047302246093750,
-0.0111083984375000, -0.0050659179687500, -0.0045166015625000, -0.0029296875000000,
-0.0067443847656250, -0.0027465820312500, -0.0055847167968750, -0.0036315917968750,
0.0009155273437500, -0.0024719238281250, -0.0006103515625000, -0.0021667480468750,
-0.0025939941406250, -0.0082397460937500, -0.0022583007812500, -0.0074157714843750,
0.0022583007812500, -0.0070190429687500, 0.0021972656250000, -0.0107727050781250,
-0.0017395019531250, -0.0102844238281250, 0.0139465332031250, -0.0077209472656250,
0.0146179199218750, -0.0095825195312500, 0.0112915039062500, -0.0057067871093750,
0.0181884765625000, -0.0003051757812500, 0.0188293457031250, -0.0037841796875000,
0.0050659179687500, 0.0000305175781250, 0.0090332031250000, 0.0022583007812500,
0.0063476562500000, 0.0007629394531250, -0.0057373046875000, 0.0000610351562500,
-0.0016174316406250, 0.0011596679687500, -0.0032653808593750, 0.0007629394531250,
-0.0063171386718750, -0.0004882812500000, -0.0027465820312500, 0.0029602050781250,
0.0009765625000000, 0.0061950683593750, -0.0020751953125000, 0.0036926269531250,
-0.0007629394531250, 0.0074768066406250, 0.0024108886718750, 0.0090942382812500,
-0.0018310546875000, 0.0084838867187500, -0.0054016113281250, 0.0089416503906250,
-0.0023498535156250, 0.0089416503906250, -0.0131225585937500, 0.0079040527343750,
-0.0116271972656250, 0.0085449218750000, -0.0135192871093750, 0.0083618164062500,
-0.0211791992187500, 0.0068664550781250, -0.0184020996093750, 0.0072631835937500,
-0.0238037109375000, 0.0085449218750000, -0.0237121582031250, 0.0082092285156250,
-0.0242919921875000, 0.0079956054687500, -0.0278930664062500, 0.0094909667968750,
-0.0265197753906250, 0.0095825195312500, -0.0275268554687500, 0.0046386718750000,
-0.0281677246093750, 0.0066833496093750, -0.0277099609375000, 0.0030212402343750,
-0.0275573730468750, -0.0034790039062500, -0.0278015136718750, -0.0003356933593750,
-0.0267639160156250, -0.0060729980468750, -0.0270996093750000, -0.0073547363281250,
-0.0258483886718750, -0.0062866210937500, -0.0247802734375000, -0.0077819824218750,
-0.0254516601562500, -0.0075378417968750, -0.0200195312500000, -0.0050354003906250,
-0.0215454101562500, -0.0055236816406250, -0.0192871093750000, -0.0038452148437500,
-0.0134887695312500, -0.0010681152343750, -0.0161437988281250, -0.0021667480468750,
-0.0146789550781250, 0.0001525878906250, -0.0119018554687500, 0.0007324218750000,
-0.0148925781250000, 0.0004577636718750, -0.0175781250000000, 0.0012817382812500,
-0.0142211914062500},
{-0.0069580078125000, 0.0146789550781250, -0.0042419433593750, 0.0100402832031250,
-0.0108947753906250, 0.0185241699218750, -0.0116271972656250, 0.0188293457031250,
-0.0096435546875000, 0.0172119140625000, -0.0113525390625000, 0.0216369628906250,
-0.0116271972656250, 0.0216674804687500, -0.0076904296875000, 0.0153198242187500,
-0.0079650878906250, 0.0174865722656250, -0.0076293945312500, 0.0132141113281250,
-0.0049133300781250, 0.0070495605468750, -0.0050354003906250, 0.0117187500000000,
-0.0059814453125000, 0.0001220703125000, -0.0064392089843750, -0.0007019042968750,
-0.0043029785156250, 0.0003356933593750, -0.0019836425781250, -0.0046997070312500,
-0.0022583007812500, -0.0040588378906250, -0.0007324218750000, -0.0016784667968750,
-0.0003967285156250, -0.0024719238281250, -0.0008239746093750, -0.0030517578125000,
-0.0006713867187500, -0.0012512207031250, -0.0002746582031250, -0.0011291503906250,
0.0004272460937500, -0.0049133300781250, -0.0013427734375000, -0.0033264160156250,
0.0021057128906250, -0.0061035156250000, 0.0058593750000000, -0.0111999511718750,
0.0025024414062500, -0.0081481933593750, 0.0082397460937500, -0.0104064941406250,
0.0099487304687500, -0.0123596191406250, 0.0077819824218750, -0.0102539062500000,
0.0069885253906250, -0.0090942382812500, 0.0084228515625000, -0.0098876953125000,
0.0122375488281250, -0.0035400390625000, 0.0083312988281250, -0.0043945312500000,
0.0126647949218750, -0.0041503906250000, 0.0209960937500000, -0.0002136230468750,
0.0166320800781250, -0.0006713867187500, 0.0190734863281250, 0.0018005371093750,
0.0236816406250000, 0.0007019042968750, 0.0163269042968750, 0.0026245117187500,
0.0107727050781250, 0.0061340332031250, 0.0166320800781250, 0.0044860839843750,
0.0008544921875000, 0.0078430175781250, 0.0015563964843750, 0.0088195800781250,
0.0003356933593750, 0.0071716308593750, -0.0099792480468750, 0.0072937011718750,
-0.0068969726562500, 0.0085754394531250, -0.0053405761718750, 0.0069580078125000,
-0.0075073242187500, 0.0061035156250000, -0.0075988769531250, 0.0069885253906250,
-0.0048828125000000, 0.0078430175781250, -0.0050354003906250, 0.0075988769531250,
-0.0101318359375000, 0.0070800781250000, -0.0076599121093750, 0.0080261230468750,
-0.0114440917968750, 0.0064086914062500, -0.0181579589843750, 0.0050354003906250,
-0.0141296386718750, 0.0063781738281250, -0.0195922851562500, 0.0004577636718750,
-0.0208129882812500, 0.0016174316406250, -0.0205078125000000, -0.0005187988281250,
-0.0219726562500000, -0.0059509277343750, -0.0213012695312500, -0.0033569335937500,
-0.0233459472656250, -0.0053100585937500, -0.0231018066406250, -0.0075683593750000,
-0.0229492187500000, -0.0040893554687500, -0.0242309570312500, -0.0012512207031250,
-0.0237121582031250, -0.0033569335937500, -0.0225219726562500, 0.0018310546875000,
-0.0234375000000000, 0.0029296875000000, -0.0217590332031250, 0.0020446777343750,
-0.0194702148437500, 0.0036010742187500, -0.0206909179687500, 0.0036926269531250,
-0.0174255371093750, 0.0003662109375000, -0.0178833007812500, 0.0016174316406250,
-0.0154113769531250, -0.0011901855468750, -0.0126647949218750, -0.0053100585937500,
-0.0148010253906250, -0.0029907226562500, -0.0058288574218750, -0.0087585449218750,
-0.0071716308593750, -0.0087890625000000, -0.0059204101562500, -0.0093688964843750,
0.0010986328125000, -0.0126342773437500, -0.0010070800781250, -0.0113830566406250,
-0.0021057128906250, -0.0133361816406250, 0.0011596679687500, -0.0138549804687500,
-0.0020141601562500, -0.0130615234375000, -0.0066223144531250, -0.0134887695312500,
-0.0033569335937500, -0.0136413574218750, -0.0077514648437500, -0.0106506347656250,
-0.0086059570312500, -0.0113830566406250, -0.0075378417968750, -0.0095520019531250,
-0.0083923339843750, -0.0063781738281250, -0.0084228515625000, -0.0078735351562500,
-0.0085754394531250, -0.0042114257812500, -0.0079345703125000, -0.0038452148437500,
-0.0090026855468750, -0.0036621093750000, -0.0099182128906250, -0.0020751953125000,
-0.0090026855468750, -0.0024108886718750, -0.0120849609375000, -0.0012207031250000,
-0.0114440917968750, -0.0014038085937500, -0.0130004882812500, -0.0003967285156250,
-0.0156860351562500, 0.0008544921875000, -0.0140075683593750, 0.0001220703125000,
-0.0187377929687500, 0.0028381347656250, -0.0182189941406250, 0.0023498535156250,
-0.0194702148437500, 0.0035705566406250, -0.0229187011718750, 0.0056762695312500,
-0.0211791992187500, 0.0042724609375000, -0.0241088867187500, 0.0079956054687500,
-0.0248718261718750, 0.0074462890625000, -0.0236511230468750, 0.0079650878906250,
-0.0244750976562500, 0.0104675292968750, -0.0249633789062500, 0.0091247558593750,
-0.0200500488281250, 0.0105285644531250, -0.0218505859375000, 0.0105590820312500,
-0.0187988281250000, 0.0103454589843750, -0.0134887695312500, 0.0108032226562500,
-0.0166931152343750, 0.0102844238281250, -0.0094299316406250, 0.0103454589843750,
-0.0094604492187500, 0.0101928710937500, -0.0088195800781250, 0.0093994140625000,
-0.0047607421875000, 0.0090637207031250, -0.0064086914062500, 0.0088500976562500,
-0.0037841796875000, 0.0061950683593750, -0.0036010742187500, 0.0072326660156250,
-0.0036315917968750, 0.0044250488281250, -0.0022277832031250, 0.0010681152343750,
-0.0025329589843750, 0.0034484863281250, -0.0022277832031250, -0.0041503906250000,
-0.0018310546875000, -0.0028991699218750, -0.0018005371093750, -0.0046997070312500,
-0.0015258789062500, -0.0103454589843750, -0.0015563964843750, -0.0071716308593750,
-0.0024719238281250, -0.0119018554687500, -0.0011291503906250, -0.0133972167968750,
-0.0034790039062500, -0.0116882324218750, -0.0057067871093750, -0.0128784179687500,
-0.0034790039062500, -0.0138244628906250, -0.0109558105468750, -0.0081481933593750,
-0.0098266601562500, -0.0110168457031250, -0.0118408203125000, -0.0064086914062500,
-0.0172119140625000, 0.0008850097656250, -0.0144653320312500, -0.0041809082031250,
-0.0211486816406250, 0.0057983398437500, -0.0202026367187500, 0.0063171386718750,
-0.0223388671875000, 0.0055236816406250, -0.0275573730468750, 0.0103149414062500,
-0.0245971679687500, 0.0089111328125000, -0.0299072265625000, 0.0053710937500000,
-0.0304260253906250, 0.0078125000000000, -0.0296020507812500, 0.0043945312500000,
-0.0314025878906250, -0.0009765625000000, -0.0311889648437500, 0.0016174316406250,
-0.0314331054687500, -0.0059204101562500, -0.0302124023437500, -0.0058288574218750,
-0.0330810546875000, -0.0062866210937500, -0.0354919433593750, -0.0113830566406250,
-0.0329895019531250, -0.0099487304687500, -0.0403442382812500, -0.0067443847656250,
-0.0406799316406250, -0.0094909667968750, -0.0391845703125000, -0.0056762695312500,
-0.0426635742187500, 0.0002136230468750, -0.0426940917968750, -0.0034484863281250,
-0.0361328125000000, 0.0024414062500000, -0.0385437011718750, 0.0042724609375000,
-0.0351867675781250, 0.0007934570312500, -0.0285339355468750, 0.0010681152343750,
-0.0319213867187500, 0.0025024414062500, -0.0234680175781250, -0.0077819824218750,
-0.0250244140625000, -0.0062866210937500, -0.0200805664062500, -0.0069274902343750,
-0.0124206542968750, -0.0142822265625000, -0.0178527832031250, -0.0126953125000000,
-0.0034179687500000, -0.0110778808593750, -0.0021057128906250, -0.0130615234375000,
-0.0051879882812500, -0.0102539062500000, -0.0003356933593750, -0.0066223144531250,
0.0005798339843750, -0.0087585449218750, -0.0041198730468750, -0.0036926269531250,
-0.0055236816406250, -0.0049438476562500, -0.0022277832031250, -0.0022888183593750,
-0.0021057128906250, 0.0041809082031250, -0.0042114257812500, 0.0011596679687500,
0.0057067871093750, -0.0004272460937500, 0.0040893554687500, 0.0006408691406250,
0.0054626464843750, 0.0032348632812500, 0.0135498046875000, 0.0026855468750000,
0.0107727050781250, 0.0008850097656250, 0.0072021484375000, 0.0103149414062500,
0.0102233886718750, 0.0088500976562500, 0.0079345703125000, 0.0091857910156250,
0.0010681152343750, 0.0171203613281250, 0.0036621093750000, 0.0159606933593750,
0.0102844238281250, 0.0080566406250000, 0.0051879882812500, 0.0092163085937500,
0.0096130371093750, 0.0111083984375000, 0.0257263183593750, 0.0069580078125000,
0.0281982421875000, 0.0187072753906250, 0.0118408203125000, 0.0205383300781250,
0.0166931152343750, 0.0225830078125000, 0.0169067382812500, 0.0209045410156250,
0.0106811523437500, 0.0182189941406250, 0.0099487304687500, 0.0188598632812500,
0.0098876953125000, 0.0189514160156250, 0.0133972167968750, 0.0187683105468750,
0.0069274902343750, 0.0185241699218750, 0.0012207031250000, 0.0199890136718750,
0.0065002441406250, 0.0190429687500000, -0.0105895996093750, 0.0079956054687500,
-0.0092163085937500, 0.0150146484375000, -0.0104370117187500, 0.0054321289062500,
-0.0210266113281250, -0.0120849609375000, -0.0168151855468750, -0.0029907226562500,
-0.0184326171875000, -0.0157470703125000, -0.0216369628906250, -0.0183410644531250,
-0.0184326171875000, -0.0178527832031250, -0.0140991210937500, -0.0217895507812500,
-0.0162048339843750, -0.0198364257812500, -0.0173339843750000, -0.0234985351562500,
-0.0163879394531250, -0.0243835449218750, -0.0138549804687500, -0.0219726562500000,
-0.0148010253906250, -0.0221862792968750, -0.0163879394531250, -0.0236816406250000,
-0.0038452148437500, -0.0182495117187500, -0.0071411132812500, -0.0180053710937500,
-0.0031738281250000, -0.0185546875000000, 0.0074462890625000, -0.0158691406250000,
0.0025939941406250, -0.0165405273437500, 0.0139160156250000, -0.0200805664062500,
0.0144348144531250, -0.0172729492187500, 0.0103454589843750, -0.0220031738281250,
0.0151367187500000, -0.0289916992187500, 0.0170898437500000, -0.0244140625000000,
0.0042724609375000, -0.0303955078125000, 0.0060119628906250, -0.0335693359375000,
0.0043640136718750, -0.0289306640625000, -0.0037536621093750, -0.0270385742187500,
-0.0002136230468750, -0.0296936035156250, -0.0048522949218750, -0.0220336914062500,
-0.0065917968750000, -0.0218200683593750, -0.0030212402343750, -0.0215148925781250,
-0.0034790039062500, -0.0182189941406250, -0.0058288574218750, -0.0193176269531250,
0.0050354003906250, -0.0153503417968750, 0.0025329589843750, -0.0167846679687500,
0.0042724609375000, -0.0140380859375000, 0.0128479003906250, -0.0093994140625000,
0.0090332031250000, -0.0121765136718750, 0.0105590820312500, -0.0065307617187500,
0.0130615234375000, -0.0060729980468750, 0.0100402832031250, -0.0061950683593750,
0.0079040527343750, -0.0039978027343750, 0.0097045898437500, -0.0047607421875000,
0.0019226074218750, -0.0029296875000000, 0.0041809082031250, -0.0031433105468750,
0.0001831054687500, -0.0029296875000000, -0.0077209472656250, -0.0014953613281250,
-0.0028076171875000, -0.0020446777343750, -0.0108642578125000, -0.0021362304687500,
-0.0127868652343750, -0.0019531250000000, -0.0097351074218750, -0.0021057128906250,
-0.0111999511718750, -0.0027160644531250, -0.0123901367187500, -0.0028686523437500,
-0.0051269531250000, -0.0025024414062500, -0.0074157714843750, -0.0024414062500000,
-0.0045471191406250, -0.0032653808593750, 0.0020446777343750, -0.0032348632812500,
-0.0018615722656250, -0.0026245117187500, 0.0049743652343750, -0.0058898925781250,
0.0052490234375000, -0.0049743652343750, 0.0050964355468750, -0.0062255859375000,
0.0084533691406250, -0.0089721679687500, 0.0073242187500000, -0.0073242187500000,
0.0074157714843750, -0.0112915039062500, 0.0084838867187500, -0.0105590820312500,
0.0072326660156250, -0.0118408203125000, 0.0062561035156250, -0.0150756835937500,
0.0074462890625000, -0.0131530761718750, 0.0036315917968750, -0.0165100097656250,
0.0050659179687500},
{0.0160522460937500, 0.0253601074218750, 0.0165405273437500, 0.0183105468750000,
0.0111389160156250, 0.0210876464843750, 0.0103759765625000, 0.0322570800781250,
0.0153198242187500, 0.0303344726562500, -0.0032653808593750, 0.0224609375000000,
-0.0020751953125000, 0.0263977050781250, -0.0025329589843750, 0.0216979980468750,
-0.0137634277343750, 0.0108032226562500, -0.0104370117187500, 0.0156860351562500,
-0.0071716308593750, 0.0163879394531250, -0.0096740722656250, 0.0132446289062500,
-0.0088806152343750, 0.0111999511718750, -0.0039672851562500, 0.0156555175781250,
-0.0050354003906250, 0.0173645019531250, -0.0106201171875000, -0.0028076171875000,
-0.0068969726562500, 0.0025024414062500, -0.0108337402343750, -0.0048828125000000,
-0.0211486816406250, -0.0234069824218750, -0.0159912109375000, -0.0146789550781250,
-0.0078125000000000, -0.0275878906250000, -0.0168762207031250, -0.0305786132812500,
-0.0058593750000000, -0.0267639160156250, 0.0117492675781250, -0.0294189453125000,
0.0009155273437500, -0.0302734375000000, 0.0162963867187500, -0.0241394042968750,
0.0212402343750000, -0.0238952636718750, 0.0140991210937500, -0.0250244140625000,
0.0157165527343750, -0.0229187011718750, 0.0184631347656250, -0.0225219726562500,
-0.0010681152343750, -0.0242004394531250, 0.0033874511718750, -0.0246887207031250,
-0.0000610351562500, -0.0244750976562500, -0.0169982910156250, -0.0238037109375000,
-0.0111999511718750, -0.0240478515625000, -0.0093078613281250, -0.0290222167968750,
-0.0145568847656250, -0.0270996093750000, -0.0086364746093750, -0.0287475585937500,
-0.0018005371093750, -0.0350341796875000, -0.0070495605468750, -0.0329895019531250,
0.0071411132812500, -0.0289611816406250, 0.0060119628906250, -0.0331726074218750,
0.0059509277343750, -0.0275573730468750, 0.0149536132812500, -0.0190124511718750,
0.0122985839843750, -0.0238342285156250, 0.0081176757812500, -0.0141601562500000,
0.0118713378906250, -0.0136108398437500, 0.0076293945312500, -0.0126953125000000,
0.0006408691406250, -0.0083312988281250, 0.0049438476562500, -0.0104370117187500,
-0.0024719238281250, -0.0030822753906250, -0.0029907226562500, -0.0046691894531250,
-0.0031738281250000, -0.0018615722656250, -0.0065917968750000, 0.0049743652343750,
-0.0050354003906250, 0.0015869140625000, -0.0070495605468750, 0.0071411132812500,
-0.0081176757812500, 0.0081176757812500, -0.0057067871093750, 0.0072021484375000,
-0.0050659179687500, 0.0088500976562500, -0.0068054199218750, 0.0084838867187500,
-0.0011901855468750, 0.0073242187500000, -0.0011901855468750, 0.0078735351562500,
-0.0016479492187500, 0.0063171386718750, 0.0011901855468750, 0.0045166015625000,
0.0007324218750000, 0.0057678222656250, -0.0009765625000000, 0.0025024414062500,
0.0005798339843750, 0.0023803710937500, -0.0011291503906250, 0.0027160644531250,
-0.0033874511718750, 0.0016479492187500, -0.0012207031250000, 0.0018310546875000,
-0.0063171386718750, 0.0007019042968750, -0.0053405761718750, 0.0020141601562500,
-0.0064392089843750, -0.0004577636718750, -0.0101318359375000, -0.0030212402343750,
-0.0079345703125000, -0.0007019042968750, -0.0114746093750000, -0.0075378417968750,
-0.0116882324218750, -0.0069885253906250, -0.0113525390625000, -0.0083618164062500,
-0.0131835937500000, -0.0126647949218750, -0.0129394531250000, -0.0107421875000000,
-0.0115661621093750, -0.0162353515625000, -0.0130615234375000, -0.0156555175781250,
-0.0113830566406250, -0.0173645019531250, -0.0090942382812500, -0.0219421386718750,
-0.0111694335937500, -0.0200195312500000, -0.0062561035156250, -0.0228576660156250,
-0.0072937011718750, -0.0240478515625000, -0.0062255859375000, -0.0231323242187500,
-0.0029602050781250, -0.0232238769531250, -0.0055236816406250, -0.0237731933593750,
-0.0017395019531250, -0.0229797363281250, -0.0028686523437500, -0.0225219726562500,
-0.0018005371093750, -0.0232238769531250, 0.0010375976562500, -0.0234069824218750,
-0.0015563964843750, -0.0227661132812500, 0.0030822753906250, -0.0237731933593750,
0.0022888183593750, -0.0241394042968750, 0.0029296875000000, -0.0229492187500000,
0.0061645507812500, -0.0227661132812500, 0.0040893554687500, -0.0234985351562500,
0.0061950683593750, -0.0200195312500000, 0.0059509277343750, -0.0211791992187500,
0.0049438476562500, -0.0193481445312500, 0.0054626464843750, -0.0164489746093750,
0.0048522949218750, -0.0185852050781250, 0.0030517578125000, -0.0112915039062500,
0.0035095214843750, -0.0132446289062500, 0.0021362304687500, -0.0100097656250000,
0.0001831054687500, -0.0029602050781250, 0.0010070800781250, -0.0067138671875000,
-0.0024414062500000, 0.0001831054687500, -0.0018310546875000, 0.0012817382812500,
-0.0027770996093750, 0.0007324218750000, -0.0056457519531250, 0.0036315917968750,
-0.0042419433593750, 0.0033264160156250, -0.0056152343750000, 0.0018615722656250,
-0.0062866210937500, 0.0038452148437500, -0.0054321289062500, 0.0012817382812500,
-0.0051879882812500, -0.0022583007812500, -0.0054626464843750, 0.0005187988281250,
-0.0041198730468750, -0.0046997070312500, -0.0039367675781250, -0.0056457519531250,
-0.0039672851562500, -0.0053405761718750, -0.0031433105468750, -0.0065307617187500,
-0.0030822753906250, -0.0065917968750000, -0.0042724609375000, -0.0105895996093750,
-0.0032653808593750, -0.0084838867187500, -0.0047912597656250, -0.0115356445312500,
-0.0066833496093750, -0.0171508789062500, -0.0050354003906250, -0.0141906738281250,
-0.0100402832031250, -0.0191650390625000, -0.0095825195312500, -0.0191650390625000,
-0.0104980468750000, -0.0208740234375000, -0.0142211914062500, -0.0240783691406250,
-0.0130310058593750, -0.0213928222656250, -0.0141296386718750, -0.0262756347656250,
-0.0153198242187500, -0.0279235839843750, -0.0133666992187500, -0.0249328613281250,
-0.0123901367187500, -0.0246887207031250, -0.0136718750000000, -0.0267333984375000,
-0.0077819824218750, -0.0218200683593750, -0.0088195800781250, -0.0222473144531250,
-0.0064697265625000, -0.0208435058593750, -0.0016784667968750, -0.0166625976562500,
-0.0042419433593750, -0.0195007324218750, 0.0016174316406250, -0.0212707519531250,
0.0014038085937500, -0.0172119140625000, 0.0022277832031250, -0.0208435058593750,
0.0057983398437500, -0.0282287597656250, 0.0040283203125000, -0.0245666503906250,
0.0066223144531250, -0.0228271484375000, 0.0063476562500000, -0.0279235839843750,
0.0071411132812500, -0.0198364257812500, 0.0090332031250000, -0.0114135742187500,
0.0075378417968750, -0.0182189941406250, 0.0100097656250000, -0.0007629394531250,
0.0107116699218750, -0.0007019042968750, 0.0091857910156250, 0.0001220703125000,
0.0094299316406250, 0.0101013183593750, 0.0103454589843750, 0.0063476562500000,
0.0062255859375000, 0.0055236816406250, 0.0069274902343750, 0.0086975097656250,
0.0054321289062500, 0.0075988769531250, 0.0024108886718750, 0.0043029785156250,
0.0042419433593750, 0.0051574707031250, -0.0003356933593750, 0.0033569335937500,
0.0003662109375000, 0.0042724609375000, -0.0014343261718750, 0.0036315917968750,
-0.0051269531250000, 0.0020751953125000, -0.0025634765625000, 0.0032958984375000,
-0.0072631835937500, -0.0007324218750000, -0.0075073242187500, -0.0009460449218750,
-0.0078430175781250, 0.0008544921875000, -0.0105895996093750, 0.0003967285156250,
-0.0091247558593750, -0.0006408691406250, -0.0071716308593750, -0.0000305175781250,
-0.0093383789062500, 0.0013427734375000, -0.0065917968750000, 0.0002746582031250,
-0.0012817382812500, -0.0014953613281250, -0.0013427734375000, -0.0010070800781250,
0.0032653808593750, -0.0016174316406250, 0.0021667480468750, -0.0018615722656250,
0.0016784667968750, -0.0019836425781250, 0.0048217773437500, -0.0015563964843750,
0.0047302246093750, -0.0008544921875000, 0.0035705566406250, -0.0032653808593750,
0.0029602050781250, -0.0024414062500000, 0.0058898925781250, -0.0029907226562500,
0.0067749023437500, -0.0052185058593750, 0.0045166015625000, -0.0036315917968750,
0.0144958496093750, -0.0027465820312500, 0.0135803222656250, -0.0038146972656250,
0.0120544433593750, -0.0031738281250000, 0.0181579589843750, -0.0010070800781250,
0.0178527832031250, -0.0008850097656250, 0.0086669921875000, -0.0014343261718750,
0.0111694335937500, -0.0011596679687500, 0.0099792480468750, -0.0016784667968750,
0.0018005371093750, -0.0020141601562500, 0.0033874511718750, -0.0008544921875000,
0.0060119628906250, -0.0027465820312500, 0.0049133300781250, -0.0036621093750000,
0.0032348632812500, -0.0014343261718750, 0.0050048828125000, -0.0002746582031250,
0.0058898925781250, -0.0016174316406250, -0.0019226074218750, 0.0018615722656250,
0.0001831054687500, 0.0025939941406250, -0.0010070800781250, 0.0009460449218750,
-0.0071716308593750, 0.0016479492187500, -0.0052185058593750, 0.0027465820312500,
-0.0088500976562500, -0.0021972656250000, -0.0078735351562500, -0.0023803710937500,
-0.0096130371093750, -0.0011901855468750, -0.0138244628906250, -0.0032653808593750,
-0.0118408203125000, -0.0033874511718750, -0.0137939453125000, 0.0014038085937500,
-0.0149230957031250, -0.0001220703125000, -0.0131530761718750, 0.0017089843750000,
-0.0126647949218750, 0.0067443847656250, -0.0139160156250000, 0.0045166015625000,
-0.0098266601562500, 0.0046691894531250, -0.0092773437500000, 0.0069580078125000,
-0.0105590820312500, 0.0031127929687500, -0.0094909667968750, -0.0003662109375000,
-0.0086364746093750, 0.0024719238281250, -0.0109863281250000, -0.0063781738281250,
-0.0106811523437500, -0.0065917968750000, -0.0103759765625000, -0.0065307617187500,
-0.0115356445312500, -0.0112304687500000, -0.0109558105468750, -0.0103149414062500,
-0.0093383789062500, -0.0090637207031250, -0.0099792480468750, -0.0099487304687500,
-0.0087585449218750, -0.0089111328125000, -0.0065002441406250, -0.0070800781250000,
-0.0071411132812500, -0.0079650878906250, -0.0056457519531250, -0.0062561035156250,
-0.0054931640625000, -0.0058288574218750, -0.0044250488281250, -0.0070190429687500,
-0.0032348632812500, -0.0069580078125000, -0.0042114257812500, -0.0066223144531250,
-0.0014953613281250, -0.0101013183593750, -0.0013427734375000, -0.0095825195312500,
-0.0015563964843750, -0.0104675292968750, -0.0006103515625000, -0.0133056640625000,
-0.0007629394531250, -0.0123596191406250, -0.0003051757812500, -0.0136718750000000,
-0.0008850097656250, -0.0138549804687500, -0.0001525878906250, -0.0136718750000000,
0.0010986328125000, -0.0140075683593750, -0.0000915527343750, -0.0133666992187500,
-0.0004882812500000, -0.0125732421875000, 0.0013732910156250, -0.0126953125000000,
-0.0025024414062500, -0.0107116699218750, -0.0058593750000000, -0.0089416503906250,
-0.0028686523437500, -0.0094909667968750, -0.0129699707031250, -0.0052795410156250,
-0.0119934082031250, -0.0050659179687500, -0.0137329101562500, -0.0037231445312500,
-0.0205078125000000, -0.0006713867187500, -0.0178222656250000, -0.0014648437500000,
-0.0217590332031250, 0.0003967285156250, -0.0223693847656250, 0.0012512207031250,
-0.0223999023437500, 0.0011596679687500, -0.0243225097656250, 0.0018310546875000,
-0.0236206054687500, 0.0022277832031250, -0.0238647460937500, 0.0011901855468750,
-0.0247192382812500, 0.0020141601562500, -0.0231323242187500, 0.0016479492187500,
-0.0219726562500000, 0.0006408691406250, -0.0231628417968750, 0.0018615722656250,
-0.0190734863281250, 0.0004577636718750, -0.0194091796875000, 0.0008239746093750,
-0.0189208984375000, 0.0007324218750000, -0.0162963867187500, -0.0001220703125000,
-0.0171813964843750, 0.0005798339843750, -0.0160522460937500, -0.0006408691406250,
-0.0159912109375000, -0.0002136230468750, -0.0158691406250000, -0.0003967285156250,
-0.0155334472656250},
{0.0081176757812500, -0.0011596679687500, 0.0014953613281250, -0.0016479492187500,
0.0081481933593750, -0.0014343261718750, -0.0032043457031250, 0.0000915527343750,
-0.0068664550781250, 0.0005187988281250, -0.0029296875000000, -0.0009765625000000,
-0.0028381347656250, -0.0011596679687500, -0.0047607421875000, -0.0000610351562500,
-0.0031433105468750, -0.0039062500000000, -0.0004272460937500, -0.0038757324218750,
-0.0051269531250000, -0.0029296875000000, -0.0090942382812500, -0.0050048828125000,
-0.0048217773437500, -0.0051879882812500, -0.0115661621093750, -0.0003662109375000,
-0.0135498046875000, -0.0016174316406250, -0.0118408203125000, -0.0002441406250000,
-0.0124816894531250, 0.0041503906250000, -0.0127258300781250, 0.0021057128906250,
-0.0111999511718750, 0.0024414062500000, -0.0114135742187500, 0.0043945312500000,
-0.0119628906250000, 0.0008850097656250, -0.0113830566406250, -0.0026550292968750,
-0.0106811523437500, -0.0003967285156250, -0.0110778808593750, -0.0052185058593750,
-0.0123291015625000, -0.0062255859375000, -0.0097351074218750, -0.0053710937500000,
-0.0073547363281250, -0.0067749023437500, -0.0092468261718750, -0.0071716308593750,
-0.0048522949218750, -0.0051574707031250, -0.0045166015625000, -0.0052185058593750,
-0.0041809082031250, -0.0057067871093750, -0.0017089843750000, -0.0045471191406250,
-0.0021362304687500, -0.0045776367187500, -0.0019836425781250, -0.0079650878906250,
-0.0010681152343750, -0.0073242187500000, -0.0010375976562500, -0.0087585449218750,
-0.0014038085937500, -0.0118103027343750, -0.0012512207031250, -0.0105590820312500,
-0.0016479492187500, -0.0130615234375000, -0.0009460449218750, -0.0136108398437500,
-0.0023193359375000, -0.0129394531250000, -0.0038452148437500, -0.0139160156250000,
-0.0025329589843750, -0.0140380859375000, -0.0047607421875000, -0.0107116699218750,
-0.0052795410156250, -0.0116577148437500, -0.0046081542968750, -0.0097045898437500,
-0.0049743652343750, -0.0059204101562500, -0.0053405761718750, -0.0072021484375000,
-0.0047912597656250, -0.0036926269531250, -0.0046386718750000, -0.0028991699218750,
-0.0051879882812500, -0.0026245117187500, -0.0054321289062500, -0.0009765625000000,
-0.0053710937500000, -0.0009460449218750, -0.0063476562500000, -0.0006408691406250,
-0.0062866210937500, 0.0000305175781250, -0.0074768066406250, -0.0008544921875000,
-0.0083618164062500, -0.0014038085937500, -0.0080261230468750, -0.0004882812500000,
-0.0134277343750000, -0.0032958984375000, -0.0117187500000000, -0.0028686523437500,
-0.0151977539062500, -0.0034790039062500, -0.0212097167968750, -0.0056457519531250,
-0.0176391601562500, -0.0047607421875000, -0.0246276855468750, -0.0065002441406250,
-0.0254821777343750, -0.0069274902343750, -0.0239257812500000, -0.0067443847656250,
-0.0262145996093750, -0.0072937011718750, -0.0263061523437500, -0.0074157714843750,
-0.0227050781250000, -0.0071105957031250, -0.0233459472656250, -0.0078735351562500,
-0.0225219726562500, -0.0079040527343750, -0.0196228027343750, -0.0074462890625000,
-0.0207214355468750, -0.0081787109375000, -0.0199279785156250, -0.0083007812500000,
-0.0191345214843750, -0.0083618164062500, -0.0199584960937500, -0.0085754394531250,
-0.0206298828125000, -0.0089111328125000, -0.0199890136718750, -0.0089721679687500,
-0.0209045410156250, -0.0082092285156250, -0.0211791992187500, -0.0089111328125000,
-0.0208435058593750, -0.0082092285156250, -0.0211791992187500, -0.0071716308593750,
-0.0212707519531250, -0.0081787109375000, -0.0195312500000000, -0.0061645507812500,
-0.0205078125000000, -0.0065307617187500, -0.0187988281250000, -0.0059204101562500,
-0.0162658691406250, -0.0045471191406250, -0.0180358886718750, -0.0056152343750000,
-0.0142211914062500, -0.0027160644531250, -0.0140075683593750, -0.0032958984375000,
-0.0144042968750000, -0.0031738281250000, -0.0130004882812500, -0.0010681152343750,
-0.0134887695312500, -0.0020141601562500, -0.0130615234375000, -0.0020751953125000,
-0.0134887695312500, -0.0011596679687500, -0.0131225585937500, -0.0024108886718750,
-0.0126037597656250, -0.0031127929687500, -0.0132141113281250, -0.0016784667968750,
-0.0111389160156250, -0.0069885253906250, -0.0118408203125000, -0.0051879882812500,
-0.0101928710937500, -0.0077819824218750, -0.0079345703125000, -0.0130615234375000,
-0.0094299316406250, -0.0101013183593750, -0.0038757324218750, -0.0168457031250000,
-0.0039062500000000, -0.0163574218750000, -0.0036010742187500, -0.0157470703125000,
0.0000000000000000, -0.0198059082031250, -0.0007324218750000, -0.0186767578125000,
-0.0024414062500000, -0.0156250000000000, -0.0007629394531250, -0.0177001953125000,
-0.0029296875000000, -0.0149230957031250, -0.0062255859375000, -0.0106506347656250,
-0.0042419433593750, -0.0135803222656250, -0.0082702636718750, -0.0075988769531250,
-0.0084838867187500, -0.0072021484375000, -0.0090026855468750, -0.0075988769531250,
-0.0111999511718750, -0.0051879882812500, -0.0102539062500000, -0.0057373046875000,
-0.0123901367187500, -0.0048217773437500, -0.0125427246093750, -0.0048217773437500,
-0.0119628906250000, -0.0056152343750000, -0.0131225585937500, -0.0054931640625000,
-0.0131835937500000, -0.0050048828125000, -0.0099182128906250, -0.0067749023437500,
-0.0112915039062500, -0.0077819824218750, -0.0096740722656250, -0.0053710937500000,
-0.0056457519531250, -0.0047607421875000, -0.0076293945312500, -0.0064392089843750,
-0.0072326660156250, 0.0024414062500000, -0.0054321289062500, 0.0018310546875000,
-0.0076904296875000, 0.0014648437500000, -0.0099487304687500, 0.0065612792968750,
-0.0085449218750000, 0.0052795410156250, -0.0137939453125000, 0.0014343261718750,
-0.0129089355468750, 0.0036926269531250, -0.0149536132812500, 0.0009765625000000,
-0.0200195312500000, -0.0043334960937500, -0.0177917480468750, -0.0024719238281250,
-0.0201721191406250, -0.0077514648437500, -0.0218811035156250, -0.0063171386718750,
-0.0193786621093750, -0.0090942382812500, -0.0189514160156250, -0.0156555175781250,
-0.0204162597656250, -0.0127563476562500, -0.0099182128906250, -0.0139465332031250,
-0.0132446289062500, -0.0172729492187500, -0.0087280273437500, -0.0115661621093750,
0.0017089843750000, -0.0064697265625000, -0.0035095214843750, -0.0116882324218750,
0.0054931640625000, -0.0038146972656250, 0.0069274902343750, -0.0011596679687500,
0.0053100585937500, -0.0025024414062500, 0.0075683593750000, -0.0025939941406250,
0.0078125000000000, -0.0032653808593750, 0.0093383789062500, 0.0002746582031250,
0.0071411132812500, -0.0019226074218750, 0.0099792480468750, 0.0033264160156250,
0.0151062011718750, 0.0096130371093750, 0.0121765136718750, 0.0043029785156250,
0.0115051269531250, 0.0133056640625000, 0.0142517089843750, 0.0152282714843750,
0.0121154785156250, 0.0136718750000000, 0.0059204101562500, 0.0167846679687500,
-0.0104980468750000, 0.0014343261718750, -0.0126953125000000, 0.0128784179687500,
-0.0158081054687500, 0.0109558105468750, -0.0108032226562500, 0.0099182128906250,
-0.0059814453125000, 0.0124511718750000, -0.0095214843750000, 0.0132446289062500,
-0.0047912597656250, 0.0127868652343750, -0.0037231445312500, 0.0112915039062500,
-0.0035095214843750, 0.0140686035156250, -0.0021972656250000, 0.0167236328125000,
-0.0027465820312500, 0.0140991210937500, 0.0015869140625000, 0.0185546875000000,
-0.0003662109375000, 0.0221557617187500, 0.0031127929687500, 0.0148620605468750,
0.0083007812500000, 0.0099792480468750, 0.0048522949218750, 0.0157165527343750,
0.0144653320312500, 0.0045776367187500, 0.0150146484375000, 0.0030517578125000,
0.0112915039062500, 0.0027770996093750, 0.0150451660156250, -0.0008850097656250,
0.0170288085937500, 0.0008239746093750, 0.0051574707031250, -0.0057373046875000,
0.0077209472656250, -0.0026550292968750, 0.0041198730468750, -0.0101928710937500,
-0.0061035156250000, -0.0189514160156250, -0.0010986328125000, -0.0117797851562500,
-0.0053405761718750, -0.0332641601562500, -0.0090942382812500, -0.0336608886718750,
-0.0047302246093750, -0.0316162109375000, -0.0019836425781250, -0.0426025390625000,
-0.0054016113281250, -0.0413818359375000, 0.0017700195312500, -0.0312500000000000,
0.0032653808593750, -0.0342407226562500, 0.0010375976562500, -0.0321350097656250,
0.0015258789062500, -0.0235595703125000, 0.0023803710937500, -0.0262756347656250,
0.0030517578125000, -0.0242919921875000, 0.0025329589843750, -0.0242309570312500,
0.0005187988281250, -0.0228271484375000, 0.0011596679687500, -0.0210876464843750,
0.0027465820312500, -0.0228271484375000, -0.0054321289062500, -0.0180053710937500,
-0.0039367675781250, -0.0180053710937500, -0.0055236816406250, -0.0184326171875000,
-0.0109558105468750, -0.0162353515625000, -0.0082702636718750, -0.0165405273437500,
-0.0150451660156250, -0.0169982910156250, -0.0136413574218750, -0.0176391601562500,
-0.0148010253906250, -0.0156860351562500, -0.0203857421875000, -0.0150146484375000,
-0.0177001953125000, -0.0166320800781250, -0.0179138183593750, -0.0087890625000000,
-0.0203857421875000, -0.0101318359375000, -0.0165710449218750, -0.0083312988281250,
-0.0131835937500000, -0.0021362304687500, -0.0161437988281250, -0.0045471191406250,
-0.0075683593750000, -0.0011596679687500, -0.0085754394531250, -0.0007934570312500,
-0.0060424804687500, -0.0001220703125000, -0.0000305175781250, 0.0016479492187500,
-0.0035705566406250, 0.0005798339843750, 0.0044250488281250, 0.0035705566406250,
0.0047302246093750, 0.0036010742187500, 0.0039978027343750, 0.0033874511718750,
0.0080261230468750, 0.0049743652343750, 0.0073852539062500, 0.0047912597656250,
0.0046081542968750, 0.0041503906250000, 0.0067138671875000, 0.0045471191406250,
0.0037841796875000, 0.0043334960937500, 0.0000610351562500, 0.0038452148437500,
0.0032043457031250, 0.0040283203125000, -0.0051879882812500, 0.0026245117187500,
-0.0032653808593750, 0.0033874511718750, -0.0062255859375000, 0.0018005371093750,
-0.0127563476562500, -0.0003662109375000, -0.0081481933593750, 0.0010070800781250,
-0.0168151855468750, -0.0029296875000000, -0.0157775878906250, -0.0028686523437500,
-0.0165405273437500, -0.0038146972656250, -0.0215148925781250, -0.0062866210937500,
-0.0184326171875000, -0.0052185058593750, -0.0238037109375000, -0.0090637207031250,
-0.0226135253906250, -0.0085449218750000, -0.0234069824218750, -0.0101623535156250,
-0.0272827148437500, -0.0133361816406250, -0.0248107910156250, -0.0115966796875000,
-0.0274963378906250, -0.0161743164062500, -0.0275268554687500, -0.0156860351562500,
-0.0263977050781250, -0.0165710449218750, -0.0268554687500000, -0.0197448730468750,
-0.0262451171875000, -0.0183105468750000, -0.0243835449218750, -0.0204467773437500,
-0.0243225097656250, -0.0209960937500000, -0.0229492187500000, -0.0207214355468750,
-0.0210571289062500, -0.0213317871093750, -0.0215148925781250, -0.0214843750000000,
-0.0188598632812500, -0.0215759277343750, -0.0187377929687500, -0.0220947265625000,
-0.0176391601562500, -0.0214538574218750, -0.0155639648437500, -0.0213317871093750,
-0.0159606933593750, -0.0222473144531250, -0.0128173828125000, -0.0184631347656250,
-0.0128173828125000, -0.0197448730468750, -0.0111694335937500, -0.0180358886718750,
-0.0084533691406250, -0.0142822265625000, -0.0093383789062500, -0.0162353515625000,
-0.0060424804687500, -0.0126647949218750, -0.0060729980468750, -0.0119323730468750,
-0.0046386718750000, -0.0122680664062500, -0.0021057128906250, -0.0105895996093750,
-0.0028991699218750, -0.0102844238281250, 0.0014648437500000, -0.0122985839843750,
0.0014343261718750, -0.0114746093750000, 0.0028381347656250, -0.0118408203125000,
0.0061645507812500, -0.0145263671875000, 0.0054626464843750, -0.0139770507812500,
0.0086975097656250},
{0.0054016113281250, -0.0322265625000000, -0.0002136230468750, -0.0231933593750000,
0.0058288574218750, -0.0230407714843750, -0.0017089843750000, -0.0226745605468750,
-0.0133666992187500, -0.0184326171875000, -0.0060424804687500, -0.0199584960937500,
-0.0189819335937500, -0.0172729492187500, -0.0202026367187500, -0.0174865722656250,
-0.0185852050781250, -0.0170898437500000, -0.0241394042968750, -0.0152587890625000,
-0.0227050781250000, -0.0161132812500000, -0.0169067382812500, -0.0145263671875000,
-0.0210876464843750, -0.0142211914062500, -0.0153198242187500, -0.0150451660156250,
-0.0063476562500000, -0.0149230957031250, -0.0123596191406250, -0.0145874023437500,
-0.0014038085937500, -0.0161743164062500, -0.0002136230468750, -0.0169372558593750,
-0.0021057128906250, -0.0151367187500000, 0.0020751953125000, -0.0147705078125000,
0.0019531250000000, -0.0159912109375000, -0.0021667480468750, -0.0099792480468750,
0.0000610351562500, -0.0107421875000000, -0.0036315917968750, -0.0095214843750000,
-0.0080871582031250, -0.0051269531250000, -0.0042114257812500, -0.0067138671875000,
-0.0169372558593750, -0.0043945312500000, -0.0144042968750000, -0.0042419433593750,
-0.0176086425781250, -0.0037841796875000, -0.0271911621093750, -0.0022888183593750,
-0.0216064453125000, -0.0029907226562500, -0.0298461914062500, -0.0017395019531250,
-0.0294189453125000, -0.0012817382812500, -0.0296325683593750, -0.0018920898437500,
-0.0341491699218750, -0.0020141601562500, -0.0319213867187500, -0.0018005371093750,
-0.0349731445312500, -0.0029907226562500, -0.0350952148437500, -0.0029602050781250,
-0.0346069335937500, -0.0034484863281250, -0.0359497070312500, -0.0042419433593750,
-0.0355224609375000, -0.0038452148437500, -0.0351562500000000, -0.0049743652343750,
-0.0352783203125000, -0.0052795410156250, -0.0346984863281250, -0.0048828125000000,
-0.0341491699218750, -0.0052185058593750, -0.0344238281250000, -0.0054321289062500,
-0.0330810546875000, -0.0043945312500000, -0.0336608886718750, -0.0041198730468750,
-0.0326843261718750, -0.0050048828125000, -0.0312194824218750, -0.0048828125000000,
-0.0325012207031250, -0.0042114257812500, -0.0303039550781250, -0.0079345703125000,
-0.0301818847656250, -0.0070190429687500, -0.0299377441406250, -0.0086975097656250,
-0.0288696289062500, -0.0120544433593750, -0.0294799804687500, -0.0106201171875000,
-0.0284118652343750, -0.0152282714843750, -0.0284423828125000, -0.0151672363281250,
-0.0282592773437500, -0.0159301757812500, -0.0274353027343750, -0.0192565917968750,
-0.0275573730468750, -0.0181884765625000, -0.0265197753906250, -0.0182189941406250,
-0.0267028808593750, -0.0196533203125000, -0.0260925292968750, -0.0175476074218750,
-0.0251159667968750, -0.0151977539062500, -0.0254211425781250, -0.0169067382812500,
-0.0236206054687500, -0.0131225585937500, -0.0238647460937500, -0.0123291015625000,
-0.0231933593750000, -0.0132446289062500, -0.0216674804687500, -0.0118408203125000,
-0.0219116210937500, -0.0113525390625000, -0.0190124511718750, -0.0147399902343750,
-0.0190734863281250, -0.0131835937500000, -0.0181579589843750, -0.0149841308593750,
-0.0158081054687500, -0.0190124511718750, -0.0162353515625000, -0.0167236328125000,
-0.0146179199218750, -0.0193481445312500, -0.0139465332031250, -0.0214843750000000,
-0.0140380859375000, -0.0187988281250000, -0.0133056640625000, -0.0174560546875000,
-0.0124511718750000, -0.0198669433593750, -0.0126342773437500, -0.0145568847656250,
-0.0119934082031250, -0.0146179199218750, -0.0110778808593750, -0.0143737792968750,
-0.0109558105468750, -0.0116271972656250, -0.0103454589843750, -0.0127258300781250,
-0.0082397460937500, -0.0109558105468750, -0.0086364746093750, -0.0101623535156250,
-0.0060424804687500, -0.0117187500000000, -0.0030212402343750, -0.0117492675781250,
-0.0042114257812500, -0.0100097656250000, 0.0011596679687500, -0.0139465332031250,
0.0007629394531250, -0.0149841308593750, 0.0023193359375000, -0.0114746093750000,
0.0061950683593750, -0.0116577148437500, 0.0043640136718750, -0.0143127441406250,
0.0076599121093750, -0.0042114257812500, 0.0084533691406250, -0.0047607421875000,
0.0073852539062500, -0.0056762695312500, 0.0081481933593750, -0.0007324218750000,
0.0082702636718750, -0.0012817382812500, 0.0048217773437500, -0.0017395019531250,
0.0061035156250000, -0.0017395019531250, 0.0040283203125000, -0.0025024414062500,
-0.0003662109375000, -0.0019531250000000, 0.0018005371093750, -0.0011596679687500,
-0.0001220703125000, -0.0066528320312500, -0.0018615722656250, -0.0070800781250000,
-0.0003051757812500, -0.0029602050781250, 0.0009460449218750, -0.0040283203125000,
-0.0000305175781250, -0.0075988769531250, 0.0021972656250000, 0.0021972656250000,
0.0029907226562500, 0.0024108886718750, 0.0020751953125000, 0.0010375976562500,
0.0025024414062500, 0.0052490234375000, 0.0030212402343750, 0.0044860839843750,
-0.0001831054687500, 0.0003662109375000, 0.0010986328125000, 0.0028686523437500,
-0.0011596679687500, -0.0018615722656250, -0.0051269531250000, -0.0078430175781250,
-0.0025939941406250, -0.0028686523437500, -0.0062255859375000, -0.0126342773437500,
-0.0087280273437500, -0.0153503417968750, -0.0035095214843750, -0.0103759765625000,
-0.0007324218750000, -0.0098876953125000, -0.0047302246093750, -0.0127868652343750,
0.0045776367187500, -0.0088195800781250, 0.0057373046875000, -0.0068969726562500,
0.0048217773437500, -0.0095520019531250, 0.0081787109375000, -0.0102233886718750,
0.0072937011718750, -0.0082092285156250, 0.0047607421875000, -0.0135192871093750,
0.0061645507812500, -0.0151977539062500, 0.0044860839843750, -0.0115051269531250,
0.0008239746093750, -0.0114135742187500, 0.0024719238281250, -0.0135803222656250,
0.0021362304687500, -0.0033874511718750, 0.0005187988281250, -0.0052185058593750,
0.0021362304687500, -0.0039367675781250, 0.0045776367187500, 0.0039672851562500,
0.0034790039062500, 0.0016174316406250, 0.0032653808593750, 0.0016784667968750,
0.0043334960937500, 0.0036315917968750, 0.0036926269531250, 0.0009460449218750,
0.0020446777343750, -0.0030822753906250, 0.0022277832031250, -0.0023803710937500,
0.0024414062500000, -0.0038452148437500, 0.0016479492187500, -0.0044860839843750,
0.0022888183593750, -0.0036926269531250, 0.0036010742187500, -0.0039367675781250,
0.0025939941406250, -0.0043640136718750, 0.0020751953125000, -0.0007934570312500,
0.0031433105468750, -0.0021057128906250, 0.0017089843750000, -0.0001220703125000,
0.0000915527343750, 0.0039062500000000, 0.0011596679687500, 0.0017700195312500,
-0.0032043457031250, 0.0053100585937500, -0.0023803710937500, 0.0067749023437500,
-0.0043945312500000, 0.0044250488281250, -0.0083923339843750, 0.0034179687500000,
-0.0056762695312500, 0.0046691894531250, -0.0079650878906250, 0.0024414062500000,
-0.0106201171875000, 0.0017395019531250, -0.0073242187500000, 0.0021667480468750,
-0.0040893554687500, 0.0015258789062500, -0.0066528320312500, 0.0014343261718750,
-0.0042724609375000, 0.0035400390625000, -0.0019531250000000, 0.0032043457031250,
-0.0050048828125000, 0.0022277832031250, -0.0075683593750000, 0.0033569335937500,
-0.0050354003906250, 0.0036315917968750, -0.0072631835937500, -0.0009155273437500,
-0.0087890625000000, 0.0001220703125000, -0.0084533691406250, -0.0012512207031250,
-0.0082397460937500, -0.0055541992187500, -0.0083007812500000, -0.0041503906250000,
-0.0078430175781250, -0.0052490234375000, -0.0072021484375000, -0.0060119628906250,
-0.0090332031250000, -0.0057983398437500, -0.0103149414062500, -0.0059814453125000,
-0.0082702636718750, -0.0062561035156250, -0.0111083984375000, -0.0055541992187500,
-0.0117492675781250, -0.0053405761718750, -0.0101928710937500, -0.0068969726562500,
-0.0108947753906250, -0.0075073242187500, -0.0112609863281250, -0.0065612792968750,
-0.0046081542968750, -0.0100097656250000, -0.0064697265625000, -0.0106811523437500,
-0.0054016113281250, -0.0094909667968750, 0.0003356933593750, -0.0104064941406250,
-0.0013122558593750, -0.0110473632812500, -0.0009765625000000, -0.0064697265625000,
0.0000610351562500, -0.0076293945312500, -0.0008544921875000, -0.0057067871093750,
-0.0018615722656250, -0.0010681152343750, -0.0009155273437500, -0.0028991699218750,
-0.0014953613281250, -0.0003662109375000, -0.0025024414062500, 0.0006103515625000,
-0.0014343261718750, -0.0007934570312500, -0.0002136230468750, -0.0012512207031250,
-0.0014343261718750, -0.0009155273437500, -0.0014953613281250, -0.0032348632812500,
-0.0001831054687500, -0.0032958984375000, -0.0019531250000000, -0.0045471191406250,
-0.0039367675781250, -0.0063476562500000, -0.0026245117187500, -0.0054931640625000,
-0.0065917968750000, -0.0079956054687500, -0.0058898925781250, -0.0082092285156250,
-0.0078735351562500, -0.0086975097656250, -0.0114440917968750, -0.0104370117187500,
-0.0093994140625000, -0.0105285644531250, -0.0150451660156250, -0.0118408203125000,
-0.0149230957031250, -0.0121459960937500, -0.0158691406250000, -0.0133666992187500,
-0.0195312500000000, -0.0147094726562500, -0.0182495117187500, -0.0147094726562500,
-0.0202941894531250, -0.0178527832031250, -0.0212402343750000, -0.0176086425781250,
-0.0202941894531250, -0.0198974609375000, -0.0204772949218750, -0.0231323242187500,
-0.0211486816406250, -0.0220031738281250, -0.0179748535156250, -0.0269165039062500,
-0.0188293457031250, -0.0267944335937500, -0.0178222656250000, -0.0285339355468750,
-0.0149230957031250, -0.0321044921875000, -0.0163574218750000, -0.0304870605468750,
-0.0149841308593750, -0.0343933105468750, -0.0142517089843750, -0.0342712402343750,
-0.0153503417968750, -0.0351562500000000, -0.0156860351562500, -0.0374450683593750,
-0.0150146484375000, -0.0358581542968750, -0.0173034667968750, -0.0384826660156250,
-0.0167846679687500, -0.0378417968750000, -0.0173950195312500, -0.0378112792968750,
-0.0192871093750000, -0.0388488769531250, -0.0181579589843750, -0.0368652343750000,
-0.0189514160156250, -0.0382995605468750, -0.0195312500000000, -0.0369262695312500,
-0.0183410644531250, -0.0369262695312500, -0.0176391601562500, -0.0378112792968750,
-0.0182495117187500, -0.0359191894531250, -0.0161743164062500, -0.0390014648437500,
-0.0157470703125000, -0.0372924804687500, -0.0164794921875000, -0.0371398925781250,
-0.0158386230468750, -0.0390319824218750, -0.0153198242187500, -0.0365295410156250,
-0.0179443359375000, -0.0379943847656250, -0.0173645019531250, -0.0383300781250000,
-0.0178527832031250, -0.0366210937500000, -0.0200195312500000, -0.0365600585937500,
-0.0191955566406250, -0.0375366210937500, -0.0195922851562500, -0.0344543457031250,
-0.0199890136718750, -0.0347290039062500, -0.0192260742187500, -0.0341796875000000,
-0.0188903808593750, -0.0318908691406250, -0.0191650390625000, -0.0324707031250000,
-0.0169067382812500, -0.0318908691406250, -0.0176086425781250, -0.0314941406250000,
-0.0161743164062500, -0.0320739746093750, -0.0136108398437500, -0.0325622558593750,
-0.0152893066406250, -0.0324096679687500, -0.0131225585937500, -0.0332336425781250,
-0.0124206542968750, -0.0336914062500000, -0.0137023925781250, -0.0323791503906250,
-0.0141906738281250, -0.0321655273437500, -0.0139465332031250, -0.0332641601562500,
-0.0149841308593750, -0.0286254882812500, -0.0160522460937500, -0.0309143066406250,
-0.0149536132812500, -0.0269470214843750, -0.0142517089843750, -0.0217895507812500,
-0.0154418945312500, -0.0265502929687500, -0.0123596191406250, -0.0144653320312500,
-0.0128173828125000, -0.0164184570312500, -0.0120544433593750, -0.0135192871093750,
-0.0101928710937500, -0.0044860839843750, -0.0114746093750000, -0.0091552734375000,
-0.0074157714843750, -0.0009460449218750, -0.0086669921875000, 0.0001831054687500,
-0.0064392089843750},
{-0.0028686523437500, -0.0099792480468750, -0.0033569335937500, -0.0104370117187500,
-0.0047607421875000, -0.0111083984375000, -0.0043945312500000, -0.0118713378906250,
-0.0043945312500000, -0.0127563476562500, -0.0045471191406250, -0.0126037597656250,
-0.0057067871093750, -0.0139160156250000, -0.0061950683593750, -0.0151977539062500,
-0.0054626464843750, -0.0146789550781250, -0.0093383789062500, -0.0175170898437500,
-0.0086975097656250, -0.0173339843750000, -0.0101623535156250, -0.0188903808593750,
-0.0131835937500000, -0.0209655761718750, -0.0118408203125000, -0.0193176269531250,
-0.0165405273437500, -0.0235900878906250, -0.0161132812500000, -0.0225524902343750,
-0.0172424316406250, -0.0231018066406250, -0.0208435058593750, -0.0259399414062500,
-0.0193481445312500, -0.0238037109375000, -0.0212097167968750, -0.0256347656250000,
-0.0220947265625000, -0.0256347656250000, -0.0211791992187500, -0.0238342285156250,
-0.0212097167968750, -0.0232849121093750, -0.0215759277343750, -0.0225524902343750,
-0.0190734863281250, -0.0195007324218750, -0.0199890136718750, -0.0181884765625000,
-0.0182800292968750, -0.0160827636718750, -0.0156250000000000, -0.0132446289062500,
-0.0173950195312500, -0.0123901367187500, -0.0131225585937500, -0.0103149414062500,
-0.0131530761718750, -0.0077514648437500, -0.0130615234375000, -0.0060119628906250,
-0.0106201171875000, -0.0045776367187500, -0.0112609863281250, -0.0026245117187500,
-0.0111999511718750, -0.0007934570312500, -0.0105285644531250, 0.0015563964843750,
-0.0109558105468750, 0.0022888183593750, -0.0115661621093750, 0.0030517578125000,
-0.0110778808593750, 0.0054321289062500, -0.0118103027343750, 0.0034790039062500,
-0.0115661621093750, 0.0057983398437500, -0.0117797851562500, 0.0058898925781250,
-0.0122070312500000, 0.0044555664062500, -0.0116577148437500, 0.0074462890625000,
-0.0131225585937500, 0.0045166015625000, -0.0126647949218750, 0.0072631835937500,
-0.0130920410156250, 0.0064697265625000, -0.0142211914062500, 0.0039062500000000,
-0.0134277343750000, 0.0077514648437500, -0.0147094726562500, 0.0016174316406250,
-0.0144042968750000, 0.0038757324218750, -0.0147705078125000, 0.0014953613281250,
-0.0157470703125000, -0.0035095214843750, -0.0148925781250000, 0.0009460449218750,
-0.0160522460937500, -0.0084838867187500, -0.0161743164062500, -0.0065002441406250,
-0.0155029296875000, -0.0083923339843750, -0.0155029296875000, -0.0148620605468750,
-0.0158691406250000, -0.0104064941406250, -0.0151977539062500, -0.0182800292968750,
-0.0147705078125000, -0.0168762207031250, -0.0161743164062500, -0.0173339843750000,
-0.0170288085937500, -0.0223083496093750, -0.0162658691406250, -0.0197448730468750,
-0.0195617675781250, -0.0237426757812500, -0.0198059082031250, -0.0228576660156250,
-0.0196533203125000, -0.0245666503906250, -0.0212707519531250, -0.0280761718750000,
-0.0214538574218750, -0.0254821777343750, -0.0205688476562500, -0.0303344726562500,
-0.0212402343750000, -0.0292358398437500, -0.0209655761718750, -0.0304565429687500,
-0.0205078125000000, -0.0342712402343750, -0.0210876464843750, -0.0318908691406250,
-0.0180358886718750, -0.0354309082031250, -0.0198974609375000, -0.0364379882812500,
-0.0167541503906250, -0.0350036621093750, -0.0125122070312500, -0.0360107421875000,
-0.0157775878906250, -0.0363769531250000, -0.0074768066406250, -0.0304260253906250,
-0.0080261230468750, -0.0335693359375000, -0.0065917968750000, -0.0278930664062500,
-0.0010986328125000, -0.0198059082031250, -0.0035095214843750, -0.0249023437500000,
-0.0001220703125000, -0.0101623535156250, 0.0008850097656250, -0.0112609863281250,
-0.0003967285156250, -0.0088500976562500, 0.0002746582031250, 0.0016174316406250,
0.0006713867187500, -0.0024414062500000, -0.0026855468750000, 0.0003356933593750,
-0.0013732910156250, 0.0030822753906250, -0.0040588378906250, 0.0003662109375000,
-0.0081481933593750, -0.0018005371093750, -0.0054016113281250, 0.0000000000000000,
-0.0117187500000000, -0.0032348632812500, -0.0133666992187500, -0.0034790039062500,
-0.0098571777343750, -0.0037841796875000, -0.0101623535156250, -0.0053405761718750,
-0.0123291015625000, -0.0041809082031250, -0.0050659179687500, -0.0048522949218750,
-0.0041198730468750, -0.0057067871093750, -0.0056457519531250, -0.0040283203125000,
-0.0034179687500000, -0.0032348632812500, -0.0028381347656250, -0.0043334960937500,
-0.0058898925781250, 0.0014038085937500, -0.0055236816406250, 0.0013732910156250,
-0.0057067871093750, -0.0004577636718750, -0.0075378417968750, 0.0013427734375000,
-0.0068664550781250, 0.0021667480468750, -0.0076904296875000, 0.0000915527343750,
-0.0073547363281250, 0.0002441406250000, -0.0086059570312500, -0.0017395019531250,
-0.0098266601562500, -0.0039367675781250, -0.0085449218750000, -0.0018920898437500,
-0.0124206542968750, -0.0046081542968750, -0.0119934082031250, -0.0053100585937500,
-0.0133361816406250, -0.0057067871093750, -0.0160827636718750, -0.0066223144531250,
-0.0143127441406250, -0.0061340332031250, -0.0182495117187500, -0.0089111328125000,
-0.0182800292968750, -0.0072631835937500, -0.0187072753906250, -0.0100097656250000,
-0.0206604003906250, -0.0152282714843750, -0.0194091796875000, -0.0125122070312500,
-0.0218200683593750, -0.0124816894531250, -0.0227966308593750, -0.0156860351562500,
-0.0204162597656250, -0.0114440917968750, -0.0180358886718750, -0.0026550292968750,
-0.0119323730468750, -0.0128173828125000, -0.0070190429687500, -0.0141296386718750,
-0.0066833496093750, -0.0184326171875000, -0.0093078613281250, -0.0147094726562500,
-0.0097961425781250, -0.0091857910156250, -0.0074157714843750, -0.0115051269531250,
-0.0120849609375000, -0.0098571777343750, -0.0144958496093750, -0.0083618164062500,
-0.0095825195312500, -0.0102844238281250, -0.0083007812500000, -0.0128479003906250,
-0.0118713378906250, -0.0109252929687500, 0.0020751953125000, -0.0050354003906250,
0.0013122558593750, -0.0095214843750000, 0.0006713867187500, -0.0054016113281250,
0.0086364746093750, 0.0045166015625000, 0.0068969726562500, 0.0005187988281250,
0.0017395019531250, 0.0021972656250000, 0.0037536621093750, 0.0056457519531250,
0.0044250488281250, 0.0003051757812500, -0.0007629394531250, -0.0043945312500000,
-0.0011901855468750, 0.0000610351562500, 0.0085449218750000, -0.0065002441406250,
0.0068969726562500, -0.0097045898437500, 0.0064392089843750, -0.0053405761718750,
0.0125732421875000, -0.0029296875000000, 0.0114440917968750, -0.0054016113281250,
0.0076599121093750, -0.0020446777343750, 0.0108642578125000, 0.0000305175781250,
0.0058898925781250, -0.0032348632812500, -0.0003662109375000, -0.0043334960937500,
0.0045166015625000, -0.0022888183593750, -0.0086669921875000, -0.0123596191406250,
-0.0092773437500000, -0.0108032226562500, -0.0057983398437500, -0.0123901367187500,
-0.0110778808593750, -0.0198669433593750, -0.0122680664062500, -0.0171508789062500,
-0.0032653808593750, -0.0187377929687500, -0.0041198730468750, -0.0199890136718750,
-0.0049743652343750, -0.0192565917968750, 0.0006103515625000, -0.0187072753906250,
-0.0003967285156250, -0.0189208984375000, -0.0086669921875000, -0.0191345214843750,
-0.0031127929687500, -0.0193481445312500, -0.0115356445312500, -0.0183410644531250,
-0.0231323242187500, -0.0179443359375000, -0.0140380859375000, -0.0188293457031250,
-0.0346069335937500, -0.0158691406250000, -0.0344238281250000, -0.0152893066406250,
-0.0338134765625000, -0.0169677734375000, -0.0446472167968750, -0.0166625976562500,
-0.0412597656250000, -0.0156250000000000, -0.0396118164062500, -0.0196838378906250,
-0.0429077148437500, -0.0197753906250000, -0.0389099121093750, -0.0192260742187500,
-0.0341796875000000, -0.0208129882812500, -0.0376586914062500, -0.0209045410156250,
-0.0279235839843750, -0.0201416015625000, -0.0296630859375000, -0.0199890136718750,
-0.0266113281250000, -0.0205688476562500, -0.0188903808593750, -0.0209655761718750,
-0.0235290527343750, -0.0206909179687500, -0.0156555175781250, -0.0208129882812500,
-0.0159912109375000, -0.0216979980468750, -0.0153503417968750, -0.0205993652343750,
-0.0114135742187500, -0.0194091796875000, -0.0140991210937500, -0.0205383300781250,
-0.0088500976562500, -0.0184326171875000, -0.0111694335937500, -0.0184631347656250,
-0.0089721679687500, -0.0180664062500000, -0.0040588378906250, -0.0171508789062500,
-0.0078735351562500, -0.0177307128906250, 0.0009155273437500, -0.0147094726562500,
-0.0010681152343750, -0.0154724121093750, 0.0009765625000000, -0.0141601562500000,
0.0073547363281250, -0.0110778808593750, 0.0033264160156250, -0.0123596191406250,
0.0112915039062500, -0.0099182128906250, 0.0098571777343750, -0.0096435546875000,
0.0112915039062500, -0.0093383789062500, 0.0166931152343750, -0.0081787109375000,
0.0133056640625000, -0.0087585449218750, 0.0191955566406250, -0.0070190429687500,
0.0191040039062500, -0.0071716308593750, 0.0195312500000000, -0.0070495605468750,
0.0229187011718750, -0.0061340332031250, 0.0218200683593750, -0.0065917968750000,
0.0250244140625000, -0.0058288574218750, 0.0246582031250000, -0.0064697265625000,
0.0252685546875000, -0.0051574707031250, 0.0278015136718750, -0.0037841796875000,
0.0273437500000000, -0.0050964355468750, 0.0291442871093750, -0.0008850097656250,
0.0295410156250000, -0.0009155273437500, 0.0299072265625000, -0.0010070800781250,
0.0307312011718750, 0.0015563964843750, 0.0304870605468750, 0.0011901855468750,
0.0318298339843750, -0.0008850097656250, 0.0321044921875000, 0.0010070800781250,
0.0322265625000000, -0.0015869140625000, 0.0329895019531250, -0.0049133300781250,
0.0332946777343750, -0.0022277832031250, 0.0338745117187500, -0.0100402832031250,
0.0344848632812500, -0.0090332031250000, 0.0345458984375000, -0.0109252929687500,
0.0346984863281250, -0.0172729492187500, 0.0346984863281250, -0.0149230957031250,
0.0323181152343750, -0.0174560546875000, 0.0335998535156250, -0.0193176269531250,
0.0316162109375000, -0.0184020996093750, 0.0287475585937500, -0.0176696777343750,
0.0303955078125000, -0.0186462402343750, 0.0238952636718750, -0.0192565917968750,
0.0253906250000000, -0.0182189941406250, 0.0230712890625000, -0.0198059082031250,
0.0173034667968750, -0.0216064453125000, 0.0195922851562500, -0.0202636718750000,
0.0121154785156250, -0.0231628417968750, 0.0122070312500000, -0.0227661132812500,
0.0091552734375000, -0.0227966308593750, 0.0030822753906250, -0.0250549316406250,
0.0054321289062500, -0.0240783691406250, -0.0010986328125000, -0.0216369628906250,
-0.0021057128906250, -0.0244140625000000, -0.0033569335937500, -0.0204467773437500,
-0.0071716308593750, -0.0153198242187500, -0.0068664550781250, -0.0194091796875000,
-0.0108642578125000, -0.0111083984375000, -0.0108032226562500, -0.0109863281250000,
-0.0114440917968750, -0.0104370117187500, -0.0139160156250000, -0.0065612792968750,
-0.0131530761718750, -0.0081787109375000, -0.0144042968750000, -0.0017700195312500,
-0.0149536132812500, -0.0034179687500000, -0.0140991210937500, -0.0015563964843750,
-0.0141601562500000, 0.0047912597656250, -0.0146484375000000, 0.0021667480468750,
-0.0118103027343750, 0.0022583007812500, -0.0123596191406250, 0.0033264160156250,
-0.0107116699218750, 0.0051269531250000, -0.0081481933593750, 0.0046691894531250,
-0.0095825195312500, 0.0025634765625000, -0.0051269531250000, 0.0092163085937500,
-0.0050659179687500, 0.0095520019531250, -0.0040893554687500, 0.0079040527343750,
-0.0010986328125000, 0.0102844238281250, -0.0020141601562500, 0.0107116699218750,
-0.0000305175781250, 0.0068054199218750, 0.0010070800781250, 0.0084533691406250,
0.0000610351562500, 0.0058898925781250, 0.0000305175781250, 0.0019836425781250,
0.0006713867187500},
{0.0142517089843750, -0.0208740234375000, 0.0137023925781250, -0.0218811035156250,
0.0115966796875000, -0.0191040039062500, 0.0126647949218750, -0.0193786621093750,
0.0111389160156250, -0.0182495117187500, 0.0088195800781250, -0.0161743164062500,
0.0107116699218750, -0.0173950195312500, 0.0068664550781250, -0.0133056640625000,
0.0079040527343750, -0.0136718750000000, 0.0070190429687500, -0.0129394531250000,
0.0045166015625000, -0.0101928710937500, 0.0070495605468750, -0.0113830566406250,
0.0027770996093750, -0.0095825195312500, 0.0037841796875000, -0.0097045898437500,
0.0035095214843750, -0.0090942382812500, 0.0007324218750000, -0.0079956054687500,
0.0022583007812500, -0.0089416503906250, -0.0005493164062500, -0.0057983398437500,
0.0002136230468750, -0.0064086914062500, -0.0002136230468750, -0.0050659179687500,
-0.0022583007812500, -0.0021057128906250, -0.0010070800781250, -0.0034484863281250,
-0.0029296875000000, -0.0004882812500000, -0.0026855468750000, 0.0003967285156250,
-0.0021667480468750, -0.0002441406250000, -0.0025939941406250, 0.0008850097656250,
-0.0019226074218750, 0.0014038085937500, -0.0025024414062500, -0.0018005371093750,
-0.0019836425781250, -0.0002136230468750, -0.0022277832031250, -0.0023803710937500,
-0.0027160644531250, -0.0064086914062500, -0.0016784667968750, -0.0041503906250000,
-0.0024414062500000, -0.0087585449218750, -0.0020446777343750, -0.0096740722656250,
-0.0018005371093750, -0.0093078613281250, -0.0020141601562500, -0.0107727050781250,
-0.0008544921875000, -0.0110778808593750, 0.0000305175781250, -0.0123901367187500,
-0.0002746582031250, -0.0114135742187500, 0.0013427734375000, -0.0137634277343750,
0.0029602050781250, -0.0164794921875000, 0.0028381347656250, -0.0146179199218750,
0.0073852539062500, -0.0193786621093750, 0.0066223144531250, -0.0190124511718750,
0.0091552734375000, -0.0196838378906250, 0.0137023925781250, -0.0225219726562500,
0.0123596191406250, -0.0207519531250000, 0.0191040039062500, -0.0229187011718750,
0.0188293457031250, -0.0240478515625000, 0.0209960937500000, -0.0217895507812500,
0.0263061523437500, -0.0213623046875000, 0.0241088867187500, -0.0231628417968750,
0.0270690917968750, -0.0172424316406250, 0.0284118652343750, -0.0182800292968750,
0.0269165039062500, -0.0171203613281250, 0.0272216796875000, -0.0131530761718750,
0.0280151367187500, -0.0150756835937500, 0.0230712890625000, -0.0102539062500000,
0.0242919921875000, -0.0115051269531250, 0.0205993652343750, -0.0087890625000000,
0.0152893066406250, -0.0039672851562500, 0.0180664062500000, -0.0072937011718750,
0.0081176757812500, -0.0006103515625000, 0.0091247558593750, 0.0004272460937500,
0.0056457519531250, -0.0012207031250000, -0.0020141601562500, 0.0001220703125000,
0.0018005371093750, 0.0010986328125000, -0.0068969726562500, 0.0019836425781250,
-0.0068359375000000, -0.0003356933593750, -0.0082397460937500, 0.0023803710937500,
-0.0132141113281250, 0.0065917968750000, -0.0104370117187500, 0.0039672851562500,
-0.0152893066406250, 0.0059509277343750, -0.0155639648437500, 0.0074462890625000,
-0.0154418945312500, 0.0065002441406250, -0.0180664062500000, 0.0061950683593750,
-0.0170593261718750, 0.0066223144531250, -0.0149230957031250, 0.0038452148437500,
-0.0166931152343750, 0.0054931640625000, -0.0139160156250000, 0.0029602050781250,
-0.0101013183593750, -0.0012512207031250, -0.0123901367187500, 0.0019836425781250,
-0.0065917968750000, -0.0011596679687500, -0.0066528320312500, -0.0025634765625000,
-0.0062866210937500, -0.0019836425781250, -0.0027770996093750, -0.0015869140625000,
-0.0038146972656250, -0.0009765625000000, -0.0041503906250000, -0.0027770996093750,
-0.0030822753906250, -0.0021057128906250, -0.0042419433593750, -0.0046997070312500,
-0.0059814453125000, -0.0070800781250000, -0.0050964355468750, -0.0043334960937500,
-0.0065917968750000, -0.0100708007812500, -0.0071105957031250, -0.0106811523437500,
-0.0050048828125000, -0.0110473632812500, -0.0048828125000000, -0.0134582519531250,
-0.0064086914062500, -0.0119323730468750, 0.0007934570312500, -0.0129089355468750,
0.0001525878906250, -0.0135803222656250, 0.0000305175781250, -0.0133056640625000,
0.0041198730468750, -0.0130920410156250, 0.0030212402343750, -0.0129699707031250,
0.0020751953125000, -0.0131835937500000, 0.0025939941406250, -0.0126647949218750,
0.0025939941406250, -0.0130310058593750, 0.0018310546875000, -0.0144348144531250,
0.0014953613281250, -0.0138854980468750, 0.0013427734375000, -0.0108947753906250,
0.0021972656250000, -0.0120544433593750, 0.0003051757812500, -0.0107116699218750,
-0.0021972656250000, -0.0069580078125000, -0.0021667480468750, -0.0072631835937500,
-0.0060119628906250, -0.0048522949218750, -0.0050048828125000, -0.0053100585937500,
-0.0053710937500000, -0.0048828125000000, -0.0081787109375000, -0.0035095214843750,
-0.0069885253906250, -0.0042114257812500, -0.0086669921875000, -0.0008239746093750,
-0.0085144042968750, -0.0018005371093750, -0.0094299316406250, -0.0001220703125000,
-0.0106811523437500, 0.0034484863281250, -0.0096435546875000, 0.0013732910156250,
-0.0137329101562500, 0.0035095214843750, -0.0134277343750000, 0.0044555664062500,
-0.0126647949218750, 0.0031433105468750, -0.0140686035156250, 0.0029907226562500,
-0.0142211914062500, 0.0033264160156250, -0.0153808593750000, -0.0002136230468750,
-0.0139465332031250, 0.0003967285156250, -0.0162658691406250, 0.0001525878906250,
-0.0192565917968750, -0.0025939941406250, -0.0166015625000000, -0.0020751953125000,
-0.0201416015625000, -0.0018005371093750, -0.0227050781250000, -0.0022888183593750,
-0.0178527832031250, -0.0019226074218750, -0.0152282714843750, -0.0015258789062500,
-0.0188293457031250, -0.0018005371093750, -0.0089416503906250, -0.0001525878906250,
-0.0080871582031250, -0.0010070800781250, -0.0110168457031250, 0.0005493164062500,
-0.0080261230468750, 0.0033569335937500, -0.0060729980468750, 0.0015869140625000,
-0.0097045898437500, 0.0019836425781250, -0.0120544433593750, 0.0044555664062500,
-0.0081481933593750, 0.0009765625000000, -0.0055236816406250, -0.0024719238281250,
-0.0084228515625000, 0.0002136230468750, -0.0025939941406250, -0.0077514648437500,
-0.0018615722656250, -0.0069885253906250, -0.0042419433593750, -0.0087585449218750,
-0.0026855468750000, -0.0147705078125000, -0.0014648437500000, -0.0123901367187500,
-0.0069274902343750, -0.0153503417968750, -0.0066528320312500, -0.0164184570312500,
-0.0065917968750000, -0.0159301757812500, -0.0093994140625000, -0.0162658691406250,
-0.0085449218750000, -0.0162658691406250, -0.0086975097656250, -0.0165405273437500,
-0.0097351074218750, -0.0157775878906250, -0.0086364746093750, -0.0153198242187500,
-0.0072937011718750, -0.0156250000000000, -0.0085754394531250, -0.0144348144531250,
-0.0087280273437500, -0.0113220214843750, -0.0079040527343750, -0.0117187500000000,
-0.0089111328125000, -0.0069274902343750, -0.0102844238281250, -0.0019226074218750,
-0.0098876953125000, -0.0036315917968750, -0.0115051269531250, 0.0068969726562500,
-0.0112609863281250, 0.0064697265625000, -0.0118713378906250, 0.0093078613281250,
-0.0133972167968750, 0.0168151855468750, -0.0128173828125000, 0.0140686035156250,
-0.0135803222656250, 0.0194396972656250, -0.0138854980468750, 0.0206298828125000,
-0.0139465332031250, 0.0196533203125000, -0.0141906738281250, 0.0208740234375000,
-0.0139770507812500, 0.0201110839843750, -0.0138244628906250, 0.0176696777343750,
-0.0143127441406250, 0.0177612304687500, -0.0132141113281250, 0.0156250000000000,
-0.0120239257812500, 0.0126953125000000, -0.0128479003906250, 0.0129089355468750,
-0.0110168457031250, 0.0083312988281250, -0.0104980468750000, 0.0083312988281250,
-0.0109558105468750, 0.0058593750000000, -0.0105895996093750, 0.0015563964843750,
-0.0101318359375000, 0.0028686523437500, -0.0108947753906250, -0.0010986328125000,
-0.0107116699218750, -0.0019226074218750, -0.0106506347656250, -0.0025634765625000,
-0.0112609863281250, -0.0046386718750000, -0.0110778808593750, -0.0042419433593750,
-0.0105590820312500, -0.0052490234375000, -0.0111083984375000, -0.0059204101562500,
-0.0098571777343750, -0.0068969726562500, -0.0087585449218750, -0.0077514648437500,
-0.0097961425781250, -0.0077819824218750, -0.0065002441406250, -0.0096435546875000,
-0.0068664550781250, -0.0091552734375000, -0.0065002441406250, -0.0097045898437500,
-0.0042724609375000, -0.0111083984375000, -0.0051574707031250, -0.0101318359375000,
-0.0051574707031250, -0.0120849609375000, -0.0043029785156250, -0.0116271972656250,
-0.0052795410156250, -0.0117797851562500, -0.0062866210937500, -0.0132141113281250,
-0.0054016113281250, -0.0128479003906250, -0.0075988769531250, -0.0143737792968750,
-0.0073852539062500, -0.0138854980468750, -0.0075683593750000, -0.0138244628906250,
-0.0089721679687500, -0.0146789550781250, -0.0083312988281250, -0.0139770507812500,
-0.0089721679687500, -0.0147094726562500, -0.0088500976562500, -0.0149841308593750,
-0.0093078613281250, -0.0139770507812500, -0.0095214843750000, -0.0140380859375000,
-0.0090332031250000, -0.0147399902343750, -0.0122680664062500, -0.0111999511718750,
-0.0109863281250000, -0.0131225585937500, -0.0131530761718750, -0.0094909667968750,
-0.0169372558593750, -0.0050964355468750, -0.0149230957031250, -0.0087890625000000,
-0.0195617675781250, 0.0022888183593750, -0.0197753906250000, -0.0008850097656250,
-0.0200805664062500, 0.0036010742187500, -0.0225219726562500, 0.0132751464843750,
-0.0215759277343750, 0.0067138671875000, -0.0220336914062500, 0.0190734863281250,
-0.0230407714843750, 0.0192871093750000, -0.0213623046875000, 0.0209350585937500,
-0.0204162597656250, 0.0280761718750000, -0.0215148925781250, 0.0246276855468750,
-0.0163269042968750, 0.0295104980468750, -0.0172119140625000, 0.0301208496093750,
-0.0156555175781250, 0.0278015136718750, -0.0116577148437500, 0.0291748046875000,
-0.0137023925781250, 0.0298156738281250, -0.0100708007812500, 0.0236206054687500,
-0.0098266601562500, 0.0258789062500000, -0.0100097656250000, 0.0217895507812500,
-0.0081176757812500, 0.0148620605468750, -0.0086669921875000, 0.0192871093750000,
-0.0095520019531250, 0.0106506347656250, -0.0088500976562500, 0.0111083984375000,
-0.0100708007812500, 0.0090637207031250, -0.0118713378906250, 0.0043334960937500,
-0.0108642578125000, 0.0078430175781250, -0.0120239257812500, -0.0019531250000000,
-0.0128479003906250, 0.0008544921875000, -0.0121154785156250, -0.0038452148437500,
-0.0117492675781250, -0.0125122070312500, -0.0122375488281250, -0.0066528320312500,
-0.0107727050781250, -0.0218505859375000, -0.0113525390625000, -0.0209045410156250,
-0.0098266601562500, -0.0227661132812500, -0.0079040527343750, -0.0332336425781250,
-0.0093688964843750, -0.0292968750000000, -0.0054931640625000, -0.0293579101562500,
-0.0053100585937500, -0.0338439941406250, -0.0047607421875000, -0.0263061523437500,
-0.0027770996093750, -0.0201110839843750, -0.0037536621093750, -0.0257568359375000,
-0.0010070800781250, -0.0055236816406250, 0.0000305175781250, -0.0077819824218750,
-0.0028381347656250, -0.0041198730468750, -0.0032043457031250, 0.0107116699218750,
-0.0009765625000000, 0.0049743652343750, -0.0091247558593750, 0.0102233886718750,
-0.0093078613281250, 0.0148010253906250, -0.0079650878906250, 0.0097351074218750,
-0.0115356445312500, 0.0057983398437500, -0.0114440917968750, 0.0091247558593750,
-0.0073852539062500, 0.0028991699218750, -0.0083618164062500, 0.0024719238281250,
-0.0075683593750000, 0.0029602050781250, -0.0034790039062500, -0.0008239746093750,
-0.0050354003906250, -0.0007019042968750, -0.0100097656250000, 0.0038146972656250,
-0.0067749023437500},
{-0.0079345703125000, 0.0120544433593750, -0.0084228515625000, 0.0121154785156250,
-0.0075988769531250, 0.0121459960937500, -0.0065917968750000, 0.0129394531250000,
-0.0074462890625000, 0.0128784179687500, -0.0059509277343750, 0.0135803222656250,
-0.0057678222656250, 0.0138854980468750, -0.0061950683593750, 0.0138854980468750,
-0.0057678222656250, 0.0141296386718750, -0.0056457519531250, 0.0145568847656250,
-0.0067749023437500, 0.0148925781250000, -0.0065002441406250, 0.0149536132812500,
-0.0069274902343750, 0.0153808593750000, -0.0076293945312500, 0.0157775878906250,
-0.0072021484375000, 0.0157470703125000, -0.0095825195312500, 0.0173034667968750,
-0.0085754394531250, 0.0178833007812500, -0.0106201171875000, 0.0167846679687500,
-0.0136108398437500, 0.0171203613281250, -0.0116577148437500, 0.0184020996093750,
-0.0165710449218750, 0.0141601562500000, -0.0166320800781250, 0.0165100097656250,
-0.0166625976562500, 0.0134582519531250, -0.0192260742187500, 0.0088806152343750,
-0.0184326171875000, 0.0131835937500000, -0.0182800292968750, 0.0038452148437500,
-0.0189208984375000, 0.0063171386718750, -0.0174560546875000, 0.0049438476562500,
-0.0162353515625000, -0.0021667480468750, -0.0168151855468750, 0.0016784667968750,
-0.0132141113281250, -0.0031127929687500, -0.0135803222656250, -0.0039978027343750,
-0.0125122070312500, -0.0025024414062500, -0.0096740722656250, -0.0038452148437500,
-0.0107727050781250, -0.0035705566406250, -0.0085449218750000, 0.0005187988281250,
-0.0082397460937500, -0.0016784667968750, -0.0085449218750000, 0.0026245117187500,
-0.0076904296875000, 0.0084228515625000, -0.0079040527343750, 0.0044860839843750,
-0.0088500976562500, 0.0145263671875000, -0.0080871582031250, 0.0135498046875000,
-0.0094299316406250, 0.0143432617187500, -0.0111389160156250, 0.0208435058593750,
-0.0099182128906250, 0.0178222656250000, -0.0130004882812500, 0.0183410644531250,
-0.0133972167968750, 0.0198059082031250, -0.0130004882812500, 0.0187683105468750,
-0.0140686035156250, 0.0172729492187500, -0.0141906738281250, 0.0178527832031250,
-0.0138244628906250, 0.0171813964843750, -0.0136413574218750, 0.0169982910156250,
-0.0140686035156250, 0.0172729492187500, -0.0147399902343750, 0.0177917480468750,
-0.0143737792968750, 0.0175781250000000, -0.0125427246093750, 0.0151367187500000,
-0.0140991210937500, 0.0183105468750000, -0.0117187500000000, 0.0127258300781250,
-0.0083007812500000, 0.0075073242187500, -0.0102539062500000, 0.0125732421875000,
-0.0050964355468750, -0.0069580078125000, -0.0048522949218750, -0.0030822753906250,
-0.0052490234375000, -0.0088500976562500, -0.0022888183593750, -0.0249633789062500,
-0.0029296875000000, -0.0164794921875000, -0.0067138671875000, -0.0281677246093750,
-0.0050964355468750, -0.0320434570312500, -0.0062255859375000, -0.0254516601562500,
-0.0109863281250000, -0.0261535644531250, -0.0094909667968750, -0.0289306640625000,
-0.0053405761718750, -0.0108947753906250, -0.0080566406250000, -0.0145568847656250,
-0.0052490234375000, -0.0088806152343750, 0.0008544921875000, 0.0071411132812500,
-0.0018310546875000, 0.0010375976562500, 0.0011291503906250, 0.0091552734375000,
0.0029602050781250, 0.0117797851562500, -0.0008850097656250, 0.0081176757812500,
-0.0024108886718750, 0.0095520019531250, 0.0004272460937500, 0.0117492675781250,
-0.0074157714843750, 0.0021057128906250, -0.0086669921875000, 0.0014953613281250,
-0.0072326660156250, 0.0020751953125000, -0.0086669921875000, -0.0017395019531250,
-0.0091552734375000, -0.0007324218750000, -0.0114135742187500, 0.0006103515625000,
-0.0095214843750000, 0.0000000000000000, -0.0122375488281250, -0.0023498535156250,
-0.0176391601562500, -0.0015869140625000, -0.0148620605468750, 0.0003356933593750,
-0.0137634277343750, -0.0098571777343750, -0.0172119140625000, -0.0087280273437500,
-0.0135192871093750, -0.0092773437500000, -0.0042419433593750, -0.0189819335937500,
0.0008239746093750, -0.0040893554687500, -0.0058593750000000, -0.0143432617187500,
-0.0039978027343750, -0.0107116699218750, -0.0029296875000000, -0.0119323730468750,
-0.0061645507812500, -0.0177307128906250, -0.0072326660156250, -0.0166320800781250,
0.0002441406250000, -0.0128173828125000, -0.0005187988281250, -0.0144348144531250,
-0.0012512207031250, -0.0146179199218750, 0.0036010742187500, -0.0102844238281250,
0.0029602050781250, -0.0105895996093750, -0.0037536621093750, -0.0191955566406250,
-0.0013122558593750, -0.0173339843750000, -0.0036621093750000, -0.0174865722656250,
-0.0105590820312500, -0.0250244140625000, -0.0076293945312500, -0.0233459472656250,
-0.0092468261718750, -0.0128479003906250, -0.0114135742187500, -0.0192871093750000,
-0.0091552734375000, -0.0105590820312500, -0.0055236816406250, 0.0054626464843750,
-0.0076904296875000, -0.0032043457031250, -0.0144958496093750, 0.0067749023437500,
-0.0082397460937500, 0.0108337402343750, -0.0153198242187500, 0.0065307617187500,
-0.0280456542968750, 0.0061645507812500, -0.0205078125000000, 0.0078735351562500,
-0.0295410156250000, 0.0020751953125000, -0.0331726074218750, 0.0012817382812500,
-0.0276794433593750, 0.0028381347656250, -0.0283813476562500, 0.0019836425781250,
-0.0304260253906250, 0.0010375976562500, -0.0111694335937500, 0.0002441406250000,
-0.0176086425781250, 0.0020751953125000, -0.0087890625000000, 0.0001525878906250,
0.0111083984375000, -0.0032043457031250, 0.0010681152343750, -0.0018310546875000,
0.0162658691406250, -0.0035095214843750, 0.0185241699218750, -0.0032348632812500,
0.0168762207031250, -0.0052795410156250, 0.0229187011718750, -0.0067138671875000,
0.0213928222656250, -0.0048522949218750, 0.0180969238281250, -0.0129089355468750,
0.0201416015625000, -0.0116882324218750, 0.0185546875000000, -0.0132141113281250,
0.0148010253906250, -0.0196838378906250, 0.0172119140625000, -0.0173339843750000,
0.0155639648437500, -0.0184326171875000, 0.0146789550781250, -0.0196533203125000,
0.0150451660156250, -0.0192871093750000, 0.0154113769531250, -0.0182189941406250,
0.0155029296875000, -0.0182495117187500, 0.0136718750000000, -0.0215148925781250,
0.0147094726562500, -0.0206298828125000, 0.0141296386718750, -0.0209960937500000,
0.0121765136718750, -0.0240173339843750, 0.0128784179687500, -0.0234375000000000,
0.0114135742187500, -0.0217285156250000, 0.0114135742187500, -0.0224304199218750,
0.0107421875000000, -0.0223388671875000, 0.0094299316406250, -0.0205078125000000,
0.0100402832031250, -0.0206604003906250, 0.0086975097656250, -0.0229187011718750,
0.0075683593750000, -0.0221862792968750, 0.0091247558593750, -0.0223388671875000,
0.0100402832031250, -0.0242309570312500, 0.0086669921875000, -0.0237731933593750,
0.0119934082031250, -0.0227050781250000, 0.0114135742187500, -0.0232543945312500,
0.0115356445312500, -0.0229492187500000, 0.0137939453125000, -0.0218200683593750,
0.0127868652343750, -0.0221862792968750, 0.0124816894531250, -0.0218200683593750,
0.0136413574218750, -0.0222167968750000, 0.0115966796875000, -0.0213928222656250,
0.0101318359375000, -0.0206298828125000, 0.0121154785156250, -0.0216369628906250,
0.0066833496093750, -0.0189208984375000, 0.0082092285156250, -0.0192565917968750,
0.0064392089843750, -0.0184936523437500, 0.0023803710937500, -0.0167236328125000,
0.0058288574218750, -0.0175781250000000, -0.0010070800781250, -0.0141906738281250,
0.0008850097656250, -0.0146179199218750, -0.0006103515625000, -0.0133056640625000,
-0.0057067871093750, -0.0101623535156250, -0.0021667480468750, -0.0112609863281250,
-0.0075378417968750, -0.0091552734375000, -0.0063476562500000, -0.0082397460937500,
-0.0069580078125000, -0.0087280273437500, -0.0100097656250000, -0.0084533691406250,
-0.0067138671875000, -0.0079345703125000, -0.0110473632812500, -0.0089721679687500,
-0.0095520019531250, -0.0090332031250000, -0.0104675292968750, -0.0088806152343750,
-0.0135498046875000, -0.0096130371093750, -0.0104675292968750, -0.0098571777343750,
-0.0148620605468750, -0.0088195800781250, -0.0137023925781250, -0.0093688964843750,
-0.0133666992187500, -0.0093383789062500, -0.0158691406250000, -0.0083007812500000,
-0.0136413574218750, -0.0087890625000000, -0.0137939453125000, -0.0093688964843750,
-0.0133056640625000, -0.0089111328125000, -0.0116882324218750, -0.0094604492187500,
-0.0107116699218750, -0.0102844238281250, -0.0100402832031250, -0.0097045898437500,
-0.0072326660156250, -0.0108642578125000, -0.0072631835937500, -0.0103149414062500,
-0.0050354003906250, -0.0111694335937500, -0.0022888183593750, -0.0127563476562500,
-0.0031433105468750, -0.0116271972656250, 0.0021057128906250, -0.0128479003906250,
0.0016174316406250, -0.0137939453125000, 0.0032043457031250, -0.0125427246093750,
0.0072326660156250, -0.0118713378906250, 0.0057678222656250, -0.0128479003906250,
0.0087585449218750, -0.0109558105468750, 0.0094909667968750, -0.0112915039062500,
0.0086975097656250, -0.0102844238281250, 0.0094299316406250, -0.0089111328125000,
0.0098876953125000, -0.0101928710937500, 0.0080566406250000, -0.0063781738281250,
0.0081481933593750, -0.0063781738281250, 0.0072326660156250, -0.0064697265625000,
0.0056152343750000, -0.0043640136718750, 0.0059509277343750, -0.0047302246093750,
0.0030517578125000, -0.0053100585937500, 0.0032043457031250, -0.0043029785156250,
0.0032348632812500, -0.0060119628906250, 0.0013122558593750, -0.0080261230468750,
0.0015258789062500, -0.0061035156250000, 0.0028381347656250, -0.0084838867187500,
0.0016174316406250, -0.0104980468750000, 0.0036621093750000, -0.0071411132812500,
0.0061340332031250, -0.0051269531250000, 0.0044250488281250, -0.0079956054687500,
0.0101318359375000, -0.0024414062500000, 0.0098266601562500, -0.0017395019531250,
0.0109863281250000, -0.0023498535156250, 0.0148010253906250, -0.0001220703125000,
0.0130310058593750, -0.0006103515625000, 0.0145568847656250, -0.0026245117187500,
0.0156555175781250, -0.0010375976562500, 0.0140991210937500, -0.0034484863281250,
0.0139160156250000, -0.0072937011718750, 0.0148010253906250, -0.0044860839843750,
0.0083312988281250, -0.0059509277343750, 0.0106201171875000, -0.0091857910156250,
0.0054016113281250, -0.0046386718750000, -0.0022888183593750, 0.0001525878906250,
0.0025939941406250, -0.0037231445312500, -0.0088500976562500, 0.0007629394531250,
-0.0087890625000000, 0.0033264160156250, -0.0098266601562500, -0.0008239746093750,
-0.0163574218750000, -0.0022583007812500, -0.0139160156250000, 0.0006103515625000,
-0.0181579589843750, -0.0082702636718750, -0.0194396972656250, -0.0092163085937500,
-0.0168457031250000, -0.0071105957031250, -0.0173950195312500, -0.0096435546875000,
-0.0189514160156250, -0.0101318359375000, -0.0112304687500000, -0.0064697265625000,
-0.0124206542968750, -0.0075988769531250, -0.0102844238281250, -0.0068969726562500,
-0.0041198730468750, -0.0035705566406250, -0.0067749023437500, -0.0045776367187500,
-0.0040893554687500, -0.0043640136718750, -0.0030517578125000, -0.0040588378906250,
-0.0034179687500000, -0.0053710937500000, -0.0030212402343750, -0.0061645507812500,
-0.0032958984375000, -0.0051574707031250, -0.0029296875000000, -0.0066833496093750,
-0.0032348632812500, -0.0071716308593750, -0.0026245117187500, -0.0079956054687500,
-0.0016174316406250, -0.0090942382812500, -0.0023803710937500, -0.0079956054687500,
-0.0026855468750000, -0.0078430175781250, -0.0015869140625000, -0.0095214843750000,
-0.0035095214843750, -0.0077209472656250, -0.0062255859375000, -0.0047302246093750,
-0.0062255859375000, -0.0054931640625000, -0.0103759765625000, -0.0035400390625000,
-0.0097045898437500, -0.0034179687500000, -0.0085449218750000, -0.0042724609375000,
-0.0108337402343750},
{-0.0090026855468750, -0.0102539062500000, -0.0097045898437500, -0.0093994140625000,
-0.0110168457031250, -0.0093383789062500, -0.0106506347656250, -0.0097656250000000,
-0.0117797851562500, -0.0097045898437500, -0.0119323730468750, -0.0092468261718750,
-0.0115966796875000, -0.0094604492187500, -0.0130004882812500, -0.0099182128906250,
-0.0119934082031250, -0.0084228515625000, -0.0125427246093750, -0.0087585449218750,
-0.0127563476562500, -0.0081481933593750, -0.0125732421875000, -0.0072326660156250,
-0.0135498046875000, -0.0080566406250000, -0.0112915039062500, -0.0044860839843750,
-0.0122070312500000, -0.0053710937500000, -0.0103149414062500, -0.0045776367187500,
-0.0075683593750000, -0.0012817382812500, -0.0092163085937500, -0.0024414062500000,
-0.0033874511718750, -0.0027770996093750, -0.0039978027343750, -0.0013732910156250,
-0.0024719238281250, -0.0028076171875000, 0.0019226074218750, -0.0044555664062500,
0.0004882812500000, -0.0032043457031250, 0.0047607421875000, -0.0078430175781250,
0.0048217773437500, -0.0071716308593750, 0.0046386718750000, -0.0072326660156250,
0.0070800781250000, -0.0111389160156250, 0.0067138671875000, -0.0104370117187500,
0.0050964355468750, -0.0060424804687500, 0.0062255859375000, -0.0083312988281250,
0.0042114257812500, -0.0071716308593750, 0.0014038085937500, -0.0020751953125000,
0.0027465820312500, -0.0037231445312500, -0.0021667480468750, -0.0041503906250000,
-0.0021667480468750, -0.0025024414062500, -0.0016784667968750, -0.0046691894531250,
-0.0040893554687500, -0.0069580078125000, -0.0033874511718750, -0.0052185058593750,
-0.0011901855468750, -0.0101013183593750, -0.0027770996093750, -0.0103454589843750,
0.0004272460937500, -0.0086669921875000, 0.0043945312500000, -0.0110778808593750,
0.0019226074218750, -0.0119018554687500, 0.0099487304687500, -0.0037841796875000,
0.0099487304687500, -0.0053100585937500, 0.0098571777343750, -0.0057373046875000,
0.0146179199218750, -0.0001831054687500, 0.0134582519531250, -0.0010375976562500,
0.0093994140625000, -0.0047912597656250, 0.0117797851562500, -0.0027160644531250,
0.0080871582031250, -0.0052795410156250, 0.0024414062500000, -0.0108947753906250,
0.0053710937500000, -0.0081787109375000, -0.0031738281250000, -0.0075988769531250,
-0.0022583007812500, -0.0103454589843750, -0.0059509277343750, -0.0076599121093750,
-0.0133056640625000, -0.0041198730468750, -0.0093688964843750, -0.0066833496093750,
-0.0163269042968750, -0.0007934570312500, -0.0183715820312500, -0.0004272460937500,
-0.0161437988281250, -0.0010681152343750, -0.0173950195312500, 0.0011596679687500,
-0.0179443359375000, 0.0002746582031250, -0.0122985839843750, -0.0006408691406250,
-0.0138854980468750, 0.0006103515625000, -0.0111694335937500, -0.0007934570312500,
-0.0057678222656250, -0.0032958984375000, -0.0088195800781250, -0.0024108886718750,
-0.0021667480468750, -0.0047302246093750, -0.0012817382812500, -0.0049133300781250,
-0.0027465820312500, -0.0039672851562500, -0.0007934570312500, -0.0049133300781250,
-0.0007019042968750, -0.0057983398437500, -0.0028991699218750, -0.0036315917968750,
-0.0025634765625000, -0.0033264160156250, -0.0034179687500000, -0.0040588378906250,
-0.0052490234375000, -0.0039367675781250, -0.0051879882812500, -0.0043945312500000,
-0.0089416503906250, -0.0065917968750000, -0.0073547363281250, -0.0060119628906250,
-0.0086364746093750, -0.0062255859375000, -0.0125427246093750, -0.0079040527343750,
-0.0102539062500000, -0.0074462890625000, -0.0106506347656250, -0.0076599121093750,
-0.0136108398437500, -0.0081176757812500, -0.0092468261718750, -0.0080566406250000,
-0.0046386718750000, -0.0079956054687500, -0.0085144042968750, -0.0080261230468750,
-0.0027770996093750, -0.0063171386718750, -0.0007019042968750, -0.0075988769531250,
-0.0028076171875000, -0.0065002441406250, -0.0028686523437500, -0.0035705566406250,
-0.0021362304687500, -0.0048828125000000, -0.0041809082031250, -0.0055541992187500,
-0.0044860839843750, -0.0041809082031250, -0.0032653808593750, -0.0070190429687500,
-0.0031127929687500, -0.0094299316406250, -0.0039672851562500, -0.0072021484375000,
-0.0033264160156250, -0.0153503417968750, -0.0018310546875000, -0.0152282714843750,
-0.0041809082031250, -0.0148925781250000, -0.0063781738281250, -0.0196228027343750,
-0.0041503906250000, -0.0187683105468750, -0.0075073242187500, -0.0152893066406250,
-0.0097351074218750, -0.0180664062500000, -0.0057983398437500, -0.0144042968750000,
-0.0030822753906250, -0.0088195800781250, -0.0061340332031250, -0.0120544433593750,
-0.0025939941406250, -0.0028076171875000, -0.0004882812500000, -0.0034179687500000,
-0.0038146972656250, -0.0012817382812500, -0.0048217773437500, 0.0051879882812500,
-0.0024414062500000, 0.0024108886718750, -0.0111999511718750, 0.0080871582031250,
-0.0108642578125000, 0.0089416503906250, -0.0093688964843750, 0.0079956054687500,
-0.0132751464843750, 0.0101318359375000, -0.0134277343750000, 0.0100402832031250,
-0.0118103027343750, 0.0070800781250000, -0.0118103027343750, 0.0081481933593750,
-0.0123901367187500, 0.0061035156250000, -0.0118103027343750, 0.0025024414062500,
-0.0119323730468750, 0.0041809082031250, -0.0154418945312500, 0.0006408691406250,
-0.0144042968750000, -0.0002746582031250, -0.0148925781250000, 0.0011596679687500,
-0.0181274414062500, 0.0007934570312500, -0.0175170898437500, 0.0003051757812500,
-0.0170898437500000, 0.0044860839843750, -0.0178222656250000, 0.0046691894531250,
-0.0170898437500000, 0.0056457519531250, -0.0162963867187500, 0.0086669921875000,
-0.0168762207031250, 0.0082702636718750, -0.0142211914062500, 0.0084228515625000,
-0.0147399902343750, 0.0098571777343750, -0.0142517089843750, 0.0085449218750000,
-0.0123901367187500, 0.0070495605468750, -0.0131835937500000, 0.0084838867187500,
-0.0108337402343750, 0.0051574707031250, -0.0114746093750000, 0.0053710937500000,
-0.0104980468750000, 0.0049743652343750, -0.0081787109375000, 0.0029602050781250,
-0.0093078613281250, 0.0039978027343750, -0.0075073242187500, 0.0035400390625000,
-0.0073547363281250, 0.0033264160156250, -0.0067749023437500, 0.0044250488281250,
-0.0057067871093750, 0.0051879882812500, -0.0065002441406250, 0.0050048828125000,
-0.0043029785156250, 0.0066223144531250, -0.0040893554687500, 0.0069274902343750,
-0.0045776367187500, 0.0083007812500000, -0.0038146972656250, 0.0100708007812500,
-0.0036010742187500, 0.0100708007812500, -0.0045471191406250, 0.0133056640625000,
-0.0043640136718750, 0.0140686035156250, -0.0039978027343750, 0.0151977539062500,
-0.0042724609375000, 0.0175170898437500, -0.0042419433593750, 0.0177612304687500,
-0.0038757324218750, 0.0184936523437500, -0.0035400390625000, 0.0200805664062500,
-0.0043029785156250, 0.0200195312500000, -0.0045776367187500, 0.0197448730468750,
-0.0039062500000000, 0.0211181640625000, -0.0062255859375000, 0.0197448730468750,
-0.0059509277343750, 0.0210876464843750, -0.0062866210937500, 0.0209960937500000,
-0.0078430175781250, 0.0199279785156250, -0.0071716308593750, 0.0215759277343750,
-0.0083007812500000, 0.0190429687500000, -0.0083923339843750, 0.0204467773437500,
-0.0087280273437500, 0.0197448730468750, -0.0094604492187500, 0.0177917480468750,
-0.0092773437500000, 0.0199584960937500, -0.0106201171875000, 0.0156555175781250,
-0.0107421875000000, 0.0178527832031250, -0.0107727050781250, 0.0168762207031250,
-0.0115966796875000, 0.0134277343750000, -0.0115051269531250, 0.0166015625000000,
-0.0106506347656250, 0.0111694335937500, -0.0111694335937500, 0.0121459960937500,
-0.0103454589843750, 0.0108947753906250, -0.0091552734375000, 0.0072631835937500,
-0.0097351074218750, 0.0094299316406250, -0.0077209472656250, 0.0026245117187500,
-0.0078735351562500, 0.0041503906250000, -0.0071105957031250, 0.0026855468750000,
-0.0053405761718750, -0.0021972656250000, -0.0059509277343750, 0.0008239746093750,
-0.0048828125000000, -0.0048522949218750, -0.0043029785156250, -0.0048522949218750,
-0.0047302246093750, -0.0042419433593750, -0.0046691894531250, -0.0076599121093750,
-0.0042724609375000, -0.0073852539062500, -0.0053405761718750, -0.0039672851562500,
-0.0047607421875000, -0.0065307617187500, -0.0057373046875000, -0.0023193359375000,
-0.0068664550781250, 0.0026245117187500, -0.0057983398437500, -0.0014953613281250,
-0.0093688964843750, 0.0111389160156250, -0.0087890625000000, 0.0082702636718750,
-0.0094909667968750, 0.0113830566406250, -0.0121765136718750, 0.0217285156250000,
-0.0111083984375000, 0.0164489746093750, -0.0124206542968750, 0.0230407714843750,
-0.0126647949218750, 0.0244445800781250, -0.0127563476562500, 0.0223999023437500,
-0.0130615234375000, 0.0239562988281250, -0.0127563476562500, 0.0245971679687500,
-0.0145568847656250, 0.0213012695312500, -0.0141296386718750, 0.0215759277343750,
-0.0144042968750000, 0.0212097167968750, -0.0163269042968750, 0.0201110839843750,
-0.0158691406250000, 0.0206909179687500, -0.0140380859375000, 0.0153808593750000,
-0.0151977539062500, 0.0173645019531250, -0.0143432617187500, 0.0147094726562500,
-0.0116882324218750, 0.0090332031250000, -0.0126342773437500, 0.0124206542968750,
-0.0130004882812500, 0.0076599121093750, -0.0120849609375000, 0.0064697265625000,
-0.0129699707031250, 0.0074157714843750, -0.0144653320312500, 0.0061035156250000,
-0.0137023925781250, 0.0059509277343750, -0.0145568847656250, 0.0080871582031250,
-0.0155334472656250, 0.0068359375000000, -0.0135192871093750, 0.0088500976562500,
-0.0127563476562500, 0.0114440917968750, -0.0140991210937500, 0.0092468261718750,
-0.0064086914062500, 0.0153503417968750, -0.0081176757812500, 0.0148925781250000,
-0.0057067871093750, 0.0142822265625000, 0.0009765625000000, 0.0185241699218750,
-0.0018920898437500, 0.0181274414062500, 0.0031738281250000, 0.0121154785156250,
0.0036926269531250, 0.0161743164062500, 0.0021667480468750, 0.0086059570312500,
0.0048217773437500, -0.0011596679687500, 0.0050048828125000, 0.0058898925781250,
-0.0035705566406250, -0.0108947753906250, -0.0017700195312500, -0.0101928710937500,
-0.0026550292968750, -0.0135803222656250, -0.0089111328125000, -0.0252990722656250,
-0.0072631835937500, -0.0191650390625000, -0.0089721679687500, -0.0213928222656250,
-0.0101013183593750, -0.0265502929687500, -0.0074768066406250, -0.0197753906250000,
-0.0068969726562500, -0.0133361816406250, -0.0087280273437500, -0.0178222656250000,
-0.0005798339843750, -0.0052795410156250, -0.0010986328125000, -0.0037231445312500,
-0.0012207031250000, -0.0073852539062500, 0.0033569335937500, -0.0042114257812500,
0.0023498535156250, -0.0025024414062500, 0.0016479492187500, -0.0084533691406250,
0.0024414062500000, -0.0089721679687500, 0.0014953613281250, -0.0075378417968750,
-0.0007934570312500, -0.0093994140625000, 0.0051269531250000, -0.0077209472656250,
-0.0088806152343750, -0.0087585449218750, -0.0025634765625000, -0.0093688964843750,
-0.0078735351562500, -0.0069274902343750, -0.0174560546875000, -0.0057678222656250,
-0.0130615234375000, -0.0075683593750000, -0.0184326171875000, -0.0020751953125000,
-0.0192871093750000, -0.0012207031250000, -0.0191650390625000, -0.0043945312500000,
-0.0210876464843750, -0.0035705566406250, -0.0200805664062500, -0.0015563964843750,
-0.0226135253906250, -0.0094604492187500, -0.0226440429687500, -0.0099182128906250,
-0.0214538574218750, -0.0091247558593750, -0.0229187011718750, -0.0122985839843750,
-0.0229187011718750, -0.0118713378906250, -0.0159301757812500, -0.0102539062500000,
-0.0196533203125000, -0.0106811523437500, -0.0112915039062500, -0.0112609863281250,
-0.0011901855468750, -0.0111083984375000, -0.0094604492187500, -0.0104675292968750,
0.0102539062500000},
{-0.0071105957031250, 0.0089721679687500, -0.0105590820312500, -0.0025329589843750,
-0.0108032226562500, -0.0017700195312500, -0.0107421875000000, -0.0018310546875000,
-0.0121459960937500, -0.0090637207031250, -0.0115966796875000, -0.0066833496093750,
-0.0127563476562500, -0.0052795410156250, -0.0124206542968750, -0.0081481933593750,
-0.0129394531250000, -0.0037231445312500, -0.0142211914062500, 0.0008850097656250,
-0.0133666992187500, -0.0029296875000000, -0.0137329101562500, 0.0074157714843750,
-0.0144958496093750, 0.0061950683593750, -0.0133056640625000, 0.0092468261718750,
-0.0121459960937500, 0.0166625976562500, -0.0131225585937500, 0.0127258300781250,
-0.0122375488281250, 0.0228881835937500, -0.0112609863281250, 0.0229797363281250,
-0.0125427246093750, 0.0220947265625000, -0.0137023925781250, 0.0272521972656250,
-0.0127563476562500, 0.0260620117187500, -0.0140991210937500, 0.0221252441406250,
-0.0146789550781250, 0.0244140625000000, -0.0143127441406250, 0.0217285156250000,
-0.0144042968750000, 0.0165710449218750, -0.0145263671875000, 0.0188598632812500,
-0.0131225585937500, 0.0133361816406250, -0.0143127441406250, 0.0138244628906250,
-0.0113525390625000, 0.0120849609375000, -0.0085754394531250, 0.0081176757812500,
-0.0112304687500000, 0.0101623535156250, -0.0035095214843750, 0.0042114257812500,
-0.0035095214843750, 0.0039672851562500, -0.0036926269531250, 0.0051879882812500,
0.0003967285156250, 0.0024719238281250, -0.0008544921875000, 0.0020446777343750,
-0.0023193359375000, 0.0060424804687500, 0.0001831054687500, 0.0052185058593750,
-0.0044555664062500, 0.0075073242187500, -0.0103759765625000, 0.0116882324218750,
-0.0061950683593750, 0.0095520019531250, -0.0097045898437500, 0.0115356445312500,
-0.0128479003906250, 0.0132446289062500, -0.0098876953125000, 0.0106506347656250,
-0.0076293945312500, 0.0106811523437500, -0.0092468261718750, 0.0118713378906250,
-0.0040893554687500, -0.0033264160156250, -0.0049133300781250, 0.0009765625000000,
-0.0032043457031250, -0.0046997070312500, 0.0010375976562500, -0.0192260742187500,
-0.0009765625000000, -0.0123291015625000, 0.0031127929687500, -0.0212402343750000,
0.0026550292968750, -0.0256652832031250, 0.0043945312500000, -0.0191955566406250,
0.0082702636718750, -0.0166625976562500, 0.0058288574218750, -0.0204772949218750,
0.0069885253906250, -0.0115661621093750, 0.0096130371093750, -0.0110473632812500,
0.0065307617187500, -0.0119323730468750, 0.0004882812500000, -0.0065612792968750,
-0.0120544433593750, -0.0219421386718750, -0.0196228027343750, -0.0101928710937500,
-0.0203247070312500, -0.0137634277343750, -0.0183105468750000, -0.0122070312500000,
-0.0177612304687500, -0.0068664550781250, -0.0187988281250000, -0.0079650878906250,
-0.0169982910156250, -0.0068359375000000, -0.0174560546875000, -0.0077514648437500,
-0.0151367187500000, -0.0045166015625000, -0.0138854980468750, -0.0011596679687500,
-0.0156860351562500, -0.0045776367187500, -0.0033569335937500, 0.0002746582031250,
-0.0065307617187500, 0.0028686523437500, -0.0017395019531250, -0.0012817382812500,
0.0103759765625000, -0.0029296875000000, 0.0049743652343750, -0.0004882812500000,
0.0114746093750000, -0.0094604492187500, 0.0151062011718750, -0.0092163085937500,
0.0090942382812500, -0.0087890625000000, 0.0077209472656250, -0.0136413574218750,
0.0122985839843750, -0.0128784179687500, -0.0024108886718750, -0.0110778808593750,
-0.0019226074218750, -0.0124511718750000, -0.0007629394531250, -0.0098571777343750,
-0.0084533691406250, -0.0070190429687500, -0.0067138671875000, -0.0093383789062500,
-0.0018310546875000, -0.0028381347656250, -0.0053100585937500, -0.0032348632812500,
-0.0007324218750000, -0.0020141601562500, 0.0062255859375000, 0.0022277832031250,
0.0021667480468750, -0.0000305175781250, 0.0137329101562500, 0.0022277832031250,
0.0133972167968750, 0.0038757324218750, 0.0143127441406250, 0.0016479492187500,
0.0205383300781250, -0.0000610351562500, 0.0183715820312500, 0.0013732910156250,
0.0247497558593750, -0.0003051757812500, 0.0232543945312500, -0.0010681152343750,
0.0240173339843750, -0.0006103515625000, 0.0294189453125000, -0.0005798339843750,
0.0272521972656250, -0.0007629394531250, 0.0263366699218750, -0.0002136230468750,
0.0281982421875000, 0.0001220703125000, 0.0249023437500000, -0.0014038085937500,
0.0225219726562500, -0.0015869140625000, 0.0249633789062500, -0.0005798339843750,
0.0137939453125000, -0.0065612792968750, 0.0172119140625000, -0.0056762695312500,
0.0121765136718750, -0.0065917968750000, 0.0014038085937500, -0.0108642578125000,
0.0078735351562500, -0.0093383789062500, -0.0030517578125000, -0.0107727050781250,
-0.0047607421875000, -0.0111389160156250, -0.0021362304687500, -0.0110168457031250,
-0.0060119628906250, -0.0115966796875000, -0.0064697265625000, -0.0113525390625000,
0.0009460449218750, -0.0112304687500000, -0.0021972656250000, -0.0115356445312500,
0.0025024414062500, -0.0113525390625000, 0.0100097656250000, -0.0108947753906250,
0.0046997070312500, -0.0111083984375000, 0.0188293457031250, -0.0120239257812500,
0.0171203613281250, -0.0113830566406250, 0.0194702148437500, -0.0124511718750000,
0.0289611816406250, -0.0142211914062500, 0.0242309570312500, -0.0133056640625000,
0.0309143066406250, -0.0146179199218750, 0.0314331054687500, -0.0152282714843750,
0.0303955078125000, -0.0145568847656250, 0.0333557128906250, -0.0142211914062500,
0.0327758789062500, -0.0144653320312500, 0.0308532714843750, -0.0142211914062500,
0.0325012207031250, -0.0136108398437500, 0.0306091308593750, -0.0140380859375000,
0.0280456542968750, -0.0145568847656250, 0.0304870605468750, -0.0140075683593750,
0.0254211425781250, -0.0142822265625000, 0.0263671875000000, -0.0143127441406250,
0.0252380371093750, -0.0141906738281250, 0.0219116210937500, -0.0140380859375000,
0.0244750976562500, -0.0139770507812500, 0.0194091796875000, -0.0150146484375000,
0.0204162597656250, -0.0147705078125000, 0.0191345214843750, -0.0152282714843750,
0.0154418945312500, -0.0164184570312500, 0.0178833007812500, -0.0162353515625000,
0.0135803222656250, -0.0162658691406250, 0.0139770507812500, -0.0168151855468750,
0.0132446289062500, -0.0164794921875000, 0.0104370117187500, -0.0159606933593750,
0.0121154785156250, -0.0163574218750000, 0.0094604492187500, -0.0152587890625000,
0.0095825195312500, -0.0156250000000000, 0.0100097656250000, -0.0148010253906250,
0.0089721679687500, -0.0134887695312500, 0.0093688964843750, -0.0142211914062500,
0.0092468261718750, -0.0122985839843750, 0.0092773437500000, -0.0119934082031250,
0.0096435546875000, -0.0122985839843750, 0.0097961425781250, -0.0116882324218750,
0.0102233886718750, -0.0115356445312500, 0.0111083984375000, -0.0114746093750000,
0.0110473632812500, -0.0121154785156250, 0.0117187500000000, -0.0106811523437500,
0.0126342773437500, -0.0095520019531250, 0.0123596191406250, -0.0107116699218750,
0.0131835937500000, -0.0071411132812500, 0.0136413574218750, -0.0077209472656250,
0.0138549804687500, -0.0064086914062500, 0.0140380859375000, -0.0036621093750000,
0.0144348144531250, -0.0054016113281250, 0.0162353515625000, -0.0011291503906250,
0.0158691406250000, -0.0008544921875000, 0.0174560546875000, -0.0015258789062500,
0.0197143554687500, 0.0004882812500000, 0.0193176269531250, 0.0007324218750000,
0.0234069824218750, -0.0016479492187500, 0.0231018066406250, -0.0010681152343750,
0.0247802734375000, -0.0012817382812500, 0.0283508300781250, -0.0027770996093750,
0.0268554687500000, -0.0022888183593750, 0.0292053222656250, -0.0037536621093750,
0.0303344726562500, -0.0037231445312500, 0.0292968750000000, -0.0032653808593750,
0.0295410156250000, -0.0043640136718750, 0.0299682617187500, -0.0047912597656250,
0.0261840820312500, -0.0016784667968750, 0.0274353027343750, -0.0019836425781250,
0.0240173339843750, -0.0035095214843750, 0.0195007324218750, -0.0020446777343750,
0.0220642089843750, -0.0011291503906250, 0.0120849609375000, -0.0062561035156250,
0.0129394531250000, -0.0057373046875000, 0.0099182128906250, -0.0060729980468750,
0.0024719238281250, -0.0090332031250000, 0.0061035156250000, -0.0083618164062500,
0.0006103515625000, -0.0110473632812500, -0.0012817382812500, -0.0105895996093750,
0.0011291503906250, -0.0108337402343750, 0.0009155273437500, -0.0135803222656250,
-0.0001525878906250, -0.0129089355468750, 0.0042419433593750, -0.0096435546875000,
0.0042724609375000, -0.0111999511718750, 0.0048522949218750, -0.0108337402343750,
0.0076599121093750, -0.0071411132812500, 0.0069885253906250, -0.0077514648437500,
0.0071105957031250, -0.0099487304687500, 0.0075988769531250, -0.0085144042968750,
0.0061035156250000, -0.0105590820312500, 0.0049743652343750, -0.0142517089843750,
0.0058288574218750, -0.0118408203125000, 0.0032043457031250, -0.0118103027343750,
0.0026550292968750, -0.0151062011718750, 0.0036621093750000, -0.0109558105468750,
0.0031433105468750, -0.0062866210937500, 0.0025634765625000, -0.0097045898437500,
0.0055847167968750, -0.0014953613281250, 0.0051879882812500, -0.0010681152343750,
0.0059814453125000, -0.0023193359375000, 0.0084228515625000, 0.0007324218750000,
0.0074157714843750, 0.0007934570312500, 0.0079956054687500, 0.0005493164062500,
0.0096130371093750, 0.0003662109375000, 0.0068664550781250, 0.0000000000000000,
0.0046691894531250, -0.0003662109375000, 0.0064697265625000, -0.0001831054687500,
-0.0013732910156250, 0.0009460449218750, 0.0005187988281250, 0.0010070800781250,
-0.0032348632812500, -0.0004272460937500, -0.0101928710937500, -0.0008239746093750,
-0.0061645507812500, 0.0003662109375000, -0.0179748535156250, -0.0017395019531250,
-0.0175476074218750, -0.0018310546875000, -0.0172424316406250, -0.0017700195312500,
-0.0244140625000000, -0.0028686523437500, -0.0226745605468750, -0.0028076171875000,
-0.0174560546875000, -0.0026855468750000, -0.0208740234375000, -0.0026550292968750,
-0.0165710449218750, -0.0026855468750000, -0.0075378417968750, -0.0027465820312500,
-0.0087280273437500, -0.0028381347656250, -0.0013427734375000, -0.0026550292968750,
-0.0021972656250000, -0.0027465820312500, -0.0039367675781250, -0.0028686523437500,
-0.0000915527343750, -0.0022583007812500, -0.0000305175781250, -0.0022888183593750,
-0.0042724609375000, -0.0058288574218750, -0.0030517578125000, -0.0036621093750000,
-0.0040283203125000, -0.0070800781250000, -0.0075988769531250, -0.0120849609375000,
-0.0060729980468750, -0.0086975097656250, -0.0063781738281250, -0.0171508789062500,
-0.0080871582031250, -0.0179443359375000, -0.0051879882812500, -0.0163574218750000,
-0.0026550292968750, -0.0194091796875000, -0.0050659179687500, -0.0192565917968750,
0.0007324218750000, -0.0152893066406250, 0.0006713867187500, -0.0168151855468750,
0.0010375976562500, -0.0138244628906250, 0.0046997070312500, -0.0092163085937500,
0.0032958984375000, -0.0122985839843750, 0.0015258789062500, -0.0061950683593750,
0.0034484863281250, -0.0058898925781250, 0.0006713867187500, -0.0054321289062500,
-0.0032043457031250, -0.0023193359375000, -0.0005798339843750, -0.0034484863281250,
-0.0049743652343750, -0.0015563964843750, -0.0054016113281250, -0.0009765625000000,
-0.0059814453125000, -0.0013427734375000, -0.0083312988281250, -0.0008544921875000,
-0.0066528320312500, -0.0005798339843750, -0.0072326660156250, -0.0010070800781250,
-0.0094909667968750, -0.0014343261718750, -0.0070190429687500, -0.0000305175781250,
-0.0039062500000000, 0.0007019042968750, -0.0060424804687500, -0.0002441406250000,
-0.0027465820312500, 0.0039062500000000, -0.0015258789062500, 0.0030822753906250,
-0.0049133300781250},
{0.0245666503906250, -0.0124816894531250, 0.0201721191406250, -0.0104064941406250,
0.0142822265625000, -0.0105590820312500, 0.0176696777343750, -0.0120239257812500,
0.0086059570312500, -0.0093994140625000, 0.0078735351562500, -0.0081176757812500,
0.0075988769531250, -0.0100402832031250, 0.0028686523437500, -0.0106811523437500,
0.0038452148437500, -0.0095825195312500, 0.0039672851562500, -0.0136413574218750,
0.0024414062500000, -0.0136718750000000, 0.0050659179687500, -0.0121154785156250,
0.0075378417968750, -0.0142211914062500, 0.0053710937500000, -0.0151672363281250,
0.0106811523437500, -0.0080871582031250, 0.0108947753906250, -0.0095520019531250,
0.0102233886718750, -0.0081176757812500, 0.0126342773437500, -0.0024719238281250,
0.0122680664062500, -0.0047607421875000, 0.0099792480468750, -0.0036315917968750,
0.0105895996093750, -0.0024719238281250, 0.0098876953125000, -0.0021362304687500,
0.0079956054687500, -0.0023498535156250, 0.0089721679687500, -0.0033264160156250,
0.0080261230468750, -0.0027160644531250, 0.0078430175781250, -0.0021667480468750,
0.0075073242187500, -0.0018920898437500, 0.0074462890625000, -0.0017089843750000,
0.0081787109375000, -0.0022583007812500, 0.0052490234375000, -0.0042419433593750,
0.0062866210937500, -0.0031433105468750, 0.0043029785156250, -0.0026855468750000,
0.0014038085937500, -0.0046997070312500, 0.0033874511718750, -0.0046997070312500,
-0.0028991699218750, -0.0021667480468750, -0.0014648437500000, -0.0029907226562500,
-0.0054016113281250, -0.0021667480468750, -0.0115966796875000, 0.0003356933593750,
-0.0074768066406250, -0.0006713867187500, -0.0176696777343750, 0.0003662109375000,
-0.0178833007812500, 0.0007934570312500, -0.0168457031250000, 0.0000915527343750,
-0.0226135253906250, 0.0002136230468750, -0.0213623046875000, -0.0001831054687500,
-0.0123596191406250, -0.0046081542968750, -0.0178222656250000, -0.0015563964843750,
-0.0136413574218750, -0.0051574707031250, -0.0035400390625000, -0.0109252929687500,
-0.0102539062500000, -0.0066833496093750, -0.0013732910156250, -0.0171813964843750,
0.0014038085937500, -0.0178833007812500, -0.0021667480468750, -0.0167541503906250,
-0.0018005371093750, -0.0217285156250000, -0.0000915527343750, -0.0208740234375000,
-0.0035400390625000, -0.0148620605468750, -0.0044555664062500, -0.0171508789062500,
-0.0033264160156250, -0.0143127441406250, -0.0037841796875000, -0.0078430175781250,
-0.0041503906250000, -0.0102844238281250, -0.0018615722656250, -0.0046081542968750,
-0.0021972656250000, -0.0043640136718750, -0.0015563964843750, -0.0046081542968750,
-0.0001831054687500, -0.0018615722656250, -0.0011901855468750, -0.0021972656250000,
0.0014953613281250, -0.0016784667968750, 0.0017089843750000, -0.0014953613281250,
0.0006408691406250, -0.0011596679687500, 0.0018615722656250, -0.0008239746093750,
0.0020446777343750, -0.0008544921875000, -0.0036926269531250, 0.0004577636718750,
-0.0016174316406250, -0.0000915527343750, -0.0038146972656250, 0.0013732910156250,
-0.0096740722656250, 0.0030822753906250, -0.0072326660156250, 0.0020751953125000,
-0.0112304687500000, 0.0071105957031250, -0.0126342773437500, 0.0071105957031250,
-0.0097351074218750, 0.0072021484375000, -0.0096435546875000, 0.0100402832031250,
-0.0117187500000000, 0.0096130371093750, -0.0054931640625000, 0.0094299316406250,
-0.0057067871093750, 0.0097351074218750, -0.0055541992187500, 0.0092773437500000,
-0.0017395019531250, 0.0086669921875000, -0.0032348632812500, 0.0091552734375000,
-0.0056762695312500, 0.0092163085937500, -0.0031738281250000, 0.0080566406250000,
-0.0050048828125000, 0.0103149414062500, -0.0093383789062500, 0.0122680664062500,
-0.0072631835937500, 0.0105590820312500, -0.0090026855468750, 0.0169067382812500,
-0.0093688964843750, 0.0163879394531250, -0.0090942382812500, 0.0177612304687500,
-0.0097656250000000, 0.0226745605468750, -0.0093688964843750, 0.0209960937500000,
-0.0084228515625000, 0.0220031738281250, -0.0086059570312500, 0.0235290527343750,
-0.0090026855468750, 0.0207214355468750, -0.0085449218750000, 0.0184631347656250,
-0.0079650878906250, 0.0197143554687500, -0.0088806152343750, 0.0126647949218750,
-0.0089111328125000, 0.0130004882812500, -0.0088195800781250, 0.0110473632812500,
-0.0090942382812500, 0.0058593750000000, -0.0087585449218750, 0.0076293945312500,
-0.0089111328125000, 0.0043640136718750, -0.0093994140625000, 0.0032043457031250,
-0.0080871582031250, 0.0039062500000000, -0.0070190429687500, 0.0029907226562500,
-0.0081787109375000, 0.0025939941406250, -0.0059814453125000, 0.0053405761718750,
-0.0053710937500000, 0.0044555664062500, -0.0062866210937500, 0.0052795410156250,
-0.0061950683593750, 0.0076599121093750, -0.0056762695312500, 0.0063171386718750,
-0.0066528320312500, 0.0076293945312500, -0.0069885253906250, 0.0079345703125000,
-0.0064697265625000, 0.0071716308593750, -0.0064086914062500, 0.0070190429687500,
-0.0068054199218750, 0.0069885253906250, -0.0056457519531250, 0.0059509277343750,
-0.0058288574218750, 0.0055236816406250, -0.0057373046875000, 0.0044860839843750,
-0.0049133300781250, 0.0031738281250000, -0.0052795410156250, 0.0030212402343750,
-0.0052185058593750, 0.0017395019531250, -0.0049133300781250, 0.0009460449218750,
-0.0055236816406250, 0.0000610351562500, -0.0060424804687500, -0.0010070800781250,
-0.0056152343750000, -0.0014953613281250, -0.0068664550781250, -0.0032653808593750,
-0.0068359375000000, -0.0045471191406250, -0.0069885253906250, -0.0048828125000000,
-0.0077819824218750, -0.0056152343750000, -0.0073547363281250, -0.0066833496093750,
-0.0073852539062500, -0.0062255859375000, -0.0076904296875000, -0.0071411132812500,
-0.0072631835937500, -0.0071411132812500, -0.0068359375000000, -0.0067138671875000,
-0.0070800781250000, -0.0078430175781250, -0.0063781738281250, -0.0065612792968750,
-0.0063171386718750, -0.0077819824218750, -0.0063781738281250, -0.0068969726562500,
-0.0062255859375000, -0.0052795410156250, -0.0062255859375000, -0.0071716308593750,
-0.0058898925781250, -0.0035095214843750, -0.0063781738281250, -0.0045776367187500,
-0.0055847167968750, -0.0036621093750000, -0.0046997070312500, -0.0010070800781250,
-0.0055847167968750, -0.0031433105468750, -0.0038757324218750, 0.0012512207031250,
-0.0038146972656250, 0.0005187988281250, -0.0045166015625000, 0.0006713867187500,
-0.0042419433593750, 0.0035095214843750, -0.0042419433593750, 0.0022277832031250,
-0.0055847167968750, 0.0035400390625000, -0.0057067871093750, 0.0040893554687500,
-0.0055541992187500, 0.0033569335937500, -0.0061340332031250, 0.0031738281250000,
-0.0062866210937500, 0.0034179687500000, -0.0055541992187500, 0.0025939941406250,
-0.0055236816406250, 0.0019531250000000, -0.0057983398437500, 0.0030517578125000,
-0.0055236816406250, 0.0032043457031250, -0.0053100585937500, 0.0021362304687500,
-0.0065307617187500, 0.0059814453125000, -0.0060729980468750, 0.0041503906250000,
-0.0065917968750000, 0.0071105957031250, -0.0075988769531250, 0.0116577148437500,
-0.0068969726562500, 0.0081787109375000, -0.0084533691406250, 0.0164184570312500,
-0.0081481933593750, 0.0158386230468750, -0.0086364746093750, 0.0169372558593750,
-0.0098266601562500, 0.0223388671875000, -0.0089721679687500, 0.0197753906250000,
-0.0106506347656250, 0.0218200683593750, -0.0106506347656250, 0.0231323242187500,
-0.0105285644531250, 0.0211181640625000, -0.0114440917968750, 0.0208129882812500,
-0.0111999511718750, 0.0216369628906250, -0.0105285644531250, 0.0142822265625000,
-0.0109252929687500, 0.0167846679687500, -0.0104980468750000, 0.0116882324218750,
-0.0098571777343750, 0.0029907226562500, -0.0101013183593750, 0.0077819824218750,
-0.0082397460937500, -0.0016784667968750, -0.0093383789062500, -0.0034484863281250,
-0.0069885253906250, -0.0014343261718750, -0.0039978027343750, -0.0044250488281250,
-0.0063476562500000, -0.0045776367187500, -0.0009155273437500, 0.0010070800781250,
0.0002136230468750, -0.0011291503906250, -0.0025939941406250, 0.0021057128906250,
-0.0021972656250000, 0.0072937011718750, -0.0007324218750000, 0.0034484863281250,
-0.0062255859375000, 0.0133972167968750, -0.0059509277343750, 0.0121765136718750,
-0.0078430175781250, 0.0135192871093750, -0.0118103027343750, 0.0209655761718750,
-0.0094299316406250, 0.0180053710937500, -0.0130004882812500, 0.0180053710937500,
-0.0145874023437500, 0.0207214355468750, -0.0129699707031250, 0.0170593261718750,
-0.0126342773437500, 0.0135498046875000, -0.0131530761718750, 0.0162353515625000,
-0.0099182128906250, 0.0069274902343750, -0.0116271972656250, 0.0077514648437500,
-0.0082397460937500, 0.0056457519531250, -0.0033569335937500, -0.0007324218750000,
-0.0065307617187500, 0.0024414062500000, 0.0003662109375000, -0.0020446777343750,
0.0012512207031250, -0.0042724609375000, -0.0003051757812500, -0.0013427734375000,
0.0029296875000000, -0.0008544921875000, 0.0028381347656250, -0.0020141601562500,
-0.0064086914062500, 0.0072021484375000, -0.0022583007812500, 0.0048522949218750,
-0.0076599121093750, 0.0068664550781250, -0.0192260742187500, 0.0159606933593750,
-0.0136108398437500, 0.0132446289062500, -0.0199584960937500, 0.0101928710937500,
-0.0227355957031250, 0.0147399902343750, -0.0194396972656250, 0.0081787109375000,
-0.0177307128906250, -0.0074768066406250, -0.0023498535156250, 0.0111694335937500,
0.0138244628906250, 0.0096740722656250, 0.0112609863281250, 0.0182800292968750,
0.0116577148437500, 0.0087890625000000, 0.0179443359375000, -0.0026855468750000,
0.0170593261718750, 0.0040893554687500, 0.0086669921875000, -0.0076599121093750,
0.0144958496093750, -0.0098876953125000, 0.0064086914062500, -0.0076904296875000,
-0.0062561035156250, -0.0103759765625000, 0.0023193359375000, -0.0102844238281250,
-0.0142822265625000, -0.0103759765625000, -0.0174865722656250, -0.0099182128906250,
-0.0114440917968750, -0.0094604492187500, -0.0155944824218750, -0.0098876953125000,
-0.0176086425781250, -0.0099487304687500, -0.0006103515625000, -0.0078735351562500,
-0.0046386718750000, -0.0087280273437500, 0.0001220703125000, -0.0075683593750000,
0.0151062011718750, -0.0044250488281250, 0.0088195800781250, -0.0059509277343750,
0.0144653320312500, -0.0081787109375000, 0.0173645019531250, -0.0056152343750000,
0.0148315429687500, -0.0087890625000000, 0.0144348144531250, -0.0140991210937500,
0.0154418945312500, -0.0112609863281250, 0.0122985839843750, -0.0144653320312500,
0.0125427246093750, -0.0176391601562500, 0.0118103027343750, -0.0119018554687500,
0.0100708007812500, -0.0083618164062500, 0.0108337402343750, -0.0128173828125000,
0.0070800781250000, -0.0010375976562500, 0.0084228515625000, -0.0004577636718750,
0.0049438476562500, -0.0012817382812500, 0.0003967285156250, 0.0040283203125000,
0.0042114257812500, 0.0028076171875000, -0.0034790039062500, 0.0000000000000000,
-0.0047912597656250, 0.0014038085937500, -0.0024719238281250, 0.0003967285156250,
-0.0043640136718750, -0.0029296875000000, -0.0048522949218750, -0.0020141601562500,
0.0001525878906250, -0.0012512207031250, -0.0023193359375000, -0.0016479492187500,
0.0019531250000000, -0.0020446777343750, 0.0078125000000000, -0.0015869140625000,
0.0032043457031250, -0.0011901855468750, 0.0153808593750000, -0.0020446777343750,
0.0144042968750000, -0.0026245117187500, 0.0155639648437500, -0.0019226074218750,
0.0230407714843750, -0.0010986328125000, 0.0198974609375000, -0.0016784667968750,
0.0238647460937500, -0.0023498535156250, 0.0243225097656250, -0.0011596679687500,
0.0243530273437500, -0.0029296875000000, 0.0261230468750000, -0.0052490234375000,
0.0252380371093750},
{-0.0120239257812500, -0.0025329589843750, -0.0101928710937500, -0.0055236816406250,
-0.0104980468750000, 0.0045471191406250, -0.0120544433593750, 0.0039367675781250,
-0.0102844238281250, 0.0051574707031250, -0.0084533691406250, 0.0114746093750000,
-0.0098266601562500, 0.0092468261718750, -0.0063171386718750, 0.0123596191406250,
-0.0054016113281250, 0.0135192871093750, -0.0075073242187500, 0.0121765136718750,
-0.0071105957031250, 0.0121765136718750, -0.0058593750000000, 0.0122375488281250,
-0.0121154785156250, 0.0094909667968750, -0.0104370117187500, 0.0107116699218750,
-0.0129394531250000, 0.0086059570312500, -0.0186767578125000, 0.0054626464843750,
-0.0153808593750000, 0.0069274902343750, -0.0207519531250000, -0.0005798339843750,
-0.0226745605468750, 0.0002136230468750, -0.0189514160156250, 0.0011901855468750,
-0.0188903808593750, -0.0041198730468750, -0.0207824707031250, -0.0037231445312500,
-0.0099182128906250, 0.0042114257812500, -0.0127258300781250, 0.0012207031250000,
-0.0086059570312500, 0.0048522949218750, 0.0083007812500000, 0.0188598632812500,
0.0136108398437500, -0.0021362304687500, 0.0010375976562500, 0.0049133300781250,
0.0097961425781250, -0.0009765625000000, 0.0010986328125000, 0.0032043457031250,
-0.0116882324218750, 0.0120849609375000, -0.0040588378906250, 0.0092163085937500,
-0.0124206542968750, 0.0083923339843750, -0.0173950195312500, 0.0123901367187500,
-0.0099182128906250, 0.0063781738281250, -0.0076599121093750, -0.0003356933593750,
-0.0124206542968750, 0.0043334960937500, 0.0071411132812500, -0.0065917968750000,
0.0048828125000000, -0.0063171386718750, 0.0074462890625000, -0.0072021484375000,
0.0212097167968750, -0.0135498046875000, 0.0161437988281250, -0.0109863281250000,
0.0172729492187500, -0.0130920410156250, 0.0215759277343750, -0.0136108398437500,
0.0165100097656250, -0.0132751464843750, 0.0110778808593750, -0.0143432617187500,
0.0150146484375000, -0.0140075683593750, 0.0081787109375000, -0.0118408203125000,
0.0077209472656250, -0.0126037597656250, 0.0069580078125000, -0.0119934082031250,
0.0037841796875000, -0.0098571777343750, 0.0054931640625000, -0.0105895996093750,
0.0005187988281250, -0.0105285644531250, 0.0014038085937500, -0.0098266601562500,
-0.0003662109375000, -0.0106201171875000, -0.0044555664062500, -0.0124511718750000,
-0.0020446777343750, -0.0117187500000000, -0.0061950683593750, -0.0075988769531250,
-0.0074462890625000, -0.0104370117187500, -0.0043640136718750, -0.0067138671875000,
-0.0046691894531250, -0.0000610351562500, -0.0068969726562500, -0.0038452148437500,
0.0019226074218750, 0.0018310546875000, 0.0004577636718750, 0.0037536621093750,
0.0024719238281250, 0.0006713867187500, 0.0083923339843750, 0.0005187988281250,
0.0053710937500000, 0.0022277832031250, 0.0131835937500000, -0.0028381347656250,
0.0120544433593750, -0.0039062500000000, 0.0140380859375000, -0.0018920898437500,
0.0203247070312500, -0.0022888183593750, 0.0179138183593750, -0.0033569335937500,
0.0220947265625000, -0.0005798339843750, 0.0225830078125000, -0.0000305175781250,
0.0228576660156250, -0.0005493164062500, 0.0249023437500000, -0.0001525878906250,
0.0237426757812500, -0.0002136230468750, 0.0241394042968750, -0.0003967285156250,
0.0257263183593750, -0.0002746582031250, 0.0229492187500000, -0.0008850097656250,
0.0215148925781250, -0.0010986328125000, 0.0238342285156250, -0.0006103515625000,
0.0140075683593750, -0.0032348632812500, 0.0173034667968750, -0.0025634765625000,
0.0123291015625000, -0.0035400390625000, 0.0036926269531250, -0.0060119628906250,
0.0101013183593750, -0.0046997070312500, -0.0073852539062500, -0.0060119628906250,
-0.0037536621093750, -0.0065612792968750, -0.0086975097656250, -0.0056457519531250,
-0.0221557617187500, -0.0053100585937500, -0.0138549804687500, -0.0056457519531250,
-0.0278930664062500, -0.0045776367187500, -0.0275268554687500, -0.0043334960937500,
-0.0271911621093750, -0.0047302246093750, -0.0344238281250000, -0.0045471191406250,
-0.0311279296875000, -0.0045166015625000, -0.0321655273437500, -0.0061645507812500,
-0.0339965820312500, -0.0055847167968750, -0.0311889648437500, -0.0070495605468750,
-0.0301208496093750, -0.0091247558593750, -0.0329589843750000, -0.0079040527343750,
-0.0252380371093750, -0.0112915039062500, -0.0281982421875000, -0.0115661621093750,
-0.0249328613281250, -0.0113830566406250, -0.0182800292968750, -0.0127868652343750,
-0.0237426757812500, -0.0125427246093750, -0.0114746093750000, -0.0124511718750000,
-0.0149841308593750, -0.0123901367187500, -0.0121765136718750, -0.0126647949218750,
-0.0028991699218750, -0.0128173828125000, -0.0093383789062500, -0.0124511718750000,
0.0010375976562500, -0.0135192871093750, -0.0009460449218750, -0.0133666992187500,
0.0004882812500000, -0.0134887695312500, 0.0069274902343750, -0.0141296386718750,
0.0015258789062500, -0.0138854980468750, 0.0092468261718750, -0.0139160156250000,
0.0072937011718750, -0.0143432617187500, 0.0080871582031250, -0.0136718750000000,
0.0126953125000000, -0.0132141113281250, 0.0081787109375000, -0.0138244628906250,
0.0144042968750000, -0.0117797851562500, 0.0125427246093750, -0.0122985839843750,
0.0126037597656250, -0.0115051269531250, 0.0162048339843750, -0.0097045898437500,
0.0122680664062500, -0.0107421875000000, 0.0146179199218750, -0.0083923339843750,
0.0133056640625000, -0.0080871582031250, 0.0118103027343750, -0.0083007812500000,
0.0123291015625000, -0.0072021484375000, 0.0099792480468750, -0.0070495605468750,
0.0083007812500000, -0.0070800781250000, 0.0084228515625000, -0.0075073242187500,
0.0056457519531250, -0.0060424804687500, 0.0029296875000000, -0.0049438476562500,
0.0031433105468750, -0.0060729980468750, -0.0032653808593750, -0.0030212402343750,
-0.0028076171875000, -0.0028076171875000, -0.0061035156250000, -0.0034484863281250,
-0.0119018554687500, -0.0025329589843750, -0.0104064941406250, -0.0024719238281250,
-0.0184020996093750, -0.0030517578125000, -0.0182800292968750, -0.0032348632812500,
-0.0202331542968750, -0.0029907226562500, -0.0259094238281250, -0.0028686523437500,
-0.0240173339843750, -0.0030822753906250, -0.0266418457031250, -0.0032653808593750,
-0.0278625488281250, -0.0029602050781250, -0.0265197753906250, -0.0031433105468750,
-0.0267639160156250, -0.0035400390625000, -0.0273132324218750, -0.0033264160156250,
-0.0229492187500000, -0.0044250488281250, -0.0241088867187500, -0.0035400390625000,
-0.0216369628906250, -0.0055236816406250, -0.0170898437500000, -0.0078735351562500,
-0.0192260742187500, -0.0057678222656250, -0.0139465332031250, -0.0092773437500000,
-0.0137023925781250, -0.0103759765625000, -0.0133361816406250, -0.0081787109375000,
-0.0106201171875000, -0.0079650878906250, -0.0117492675781250, -0.0093078613281250,
-0.0104064941406250, -0.0059204101562500, -0.0107421875000000, -0.0051574707031250,
-0.0088195800781250, -0.0063476562500000, -0.0074462890625000, -0.0057678222656250,
-0.0090637207031250, -0.0053100585937500, -0.0005493164062500, -0.0081787109375000,
-0.0027770996093750, -0.0075988769531250, 0.0020141601562500, -0.0083312988281250,
0.0106506347656250, -0.0112609863281250, 0.0061950683593750, -0.0104370117187500,
0.0171508789062500, -0.0089416503906250, 0.0181274414062500, -0.0103149414062500,
0.0172424316406250, -0.0092163085937500, 0.0223388671875000, -0.0069885253906250,
0.0211486816406250, -0.0081787109375000, 0.0165405273437500, -0.0055847167968750,
0.0188903808593750, -0.0055541992187500, 0.0150451660156250, -0.0056152343750000,
0.0085449218750000, -0.0045166015625000, 0.0117492675781250, -0.0053710937500000,
0.0058593750000000, -0.0057067871093750, 0.0043945312500000, -0.0044860839843750,
0.0053100585937500, -0.0057678222656250, 0.0038146972656250, -0.0079956054687500,
0.0037231445312500, -0.0072021484375000, 0.0046691894531250, -0.0078125000000000,
0.0042419433593750, -0.0079650878906250, 0.0048217773437500, -0.0068969726562500,
0.0059814453125000, -0.0073547363281250, 0.0053100585937500, -0.0083312988281250,
0.0055236816406250, -0.0038452148437500, 0.0062561035156250, -0.0041809082031250,
0.0053100585937500, -0.0042419433593750, 0.0039978027343750, -0.0016174316406250,
0.0046997070312500, -0.0025634765625000, 0.0043640136718750, -0.0043029785156250,
0.0039672851562500, -0.0021667480468750, 0.0043029785156250, -0.0058288574218750,
0.0047302246093750, -0.0097351074218750, 0.0046997070312500, -0.0063781738281250,
0.0050964355468750, -0.0160217285156250, 0.0048828125000000, -0.0158996582031250,
0.0054931640625000, -0.0155029296875000, 0.0072326660156250, -0.0214843750000000,
0.0069580078125000, -0.0201110839843750, 0.0035400390625000, -0.0127258300781250,
0.0068664550781250, -0.0175476074218750, 0.0027160644531250, -0.0137023925781250,
-0.0021667480468750, -0.0048522949218750, 0.0033569335937500, -0.0096435546875000,
-0.0102844238281250, 0.0003051757812500, -0.0098876953125000, 0.0016784667968750,
-0.0086059570312500, 0.0002746582031250, -0.0153198242187500, 0.0038757324218750,
-0.0139465332031250, 0.0039367675781250, -0.0115356445312500, 0.0021057128906250,
-0.0128479003906250, 0.0022583007812500, -0.0119018554687500, 0.0024414062500000,
-0.0100708007812500, 0.0014648437500000, -0.0114440917968750, 0.0017395019531250,
-0.0073547363281250, 0.0031738281250000, -0.0084838867187500, 0.0025634765625000,
-0.0067138671875000, 0.0033569335937500, -0.0029907226562500, 0.0050354003906250,
-0.0054321289062500, 0.0043640136718750, -0.0012817382812500, 0.0058288574218750,
-0.0007934570312500, 0.0062561035156250, -0.0014953613281250, 0.0052490234375000,
0.0000305175781250, 0.0055236816406250, -0.0000610351562500, 0.0063476562500000,
-0.0015869140625000, 0.0031738281250000, -0.0014953613281250, 0.0035400390625000,
-0.0013122558593750, 0.0036315917968750, -0.0017395019531250, 0.0010375976562500,
-0.0019836425781250, 0.0018310546875000, -0.0034179687500000, 0.0069274902343750,
-0.0021057128906250, 0.0041503906250000, -0.0046386718750000, 0.0079040527343750,
-0.0077819824218750, 0.0151062011718750, -0.0051879882812500, 0.0114135742187500,
-0.0093994140625000, 0.0169982910156250, -0.0112609863281250, 0.0191650390625000,
-0.0074768066406250, 0.0159301757812500, -0.0065002441406250, 0.0158081054687500,
-0.0090026855468750, 0.0172424316406250, -0.0012512207031250, 0.0092468261718750,
-0.0019836425781250, 0.0100708007812500, -0.0010681152343750, 0.0074157714843750,
0.0045166015625000, 0.0008544921875000, 0.0024108886718750, 0.0032958984375000,
0.0008544921875000, -0.0004577636718750, 0.0036621093750000, -0.0021667480468750,
0.0020446777343750, -0.0014038085937500, -0.0017395019531250, -0.0018920898437500,
0.0000305175781250, -0.0028686523437500, -0.0015563964843750, -0.0026550292968750,
-0.0014648437500000, -0.0025634765625000, -0.0020141601562500, -0.0048522949218750,
-0.0031127929687500, -0.0062866210937500, -0.0021057128906250, -0.0058288574218750,
-0.0045776367187500, -0.0112609863281250, -0.0038757324218750, -0.0107727050781250,
-0.0051574707031250, -0.0129089355468750, -0.0076599121093750, -0.0175781250000000,
-0.0057983398437500, -0.0157775878906250, -0.0081787109375000, -0.0193786621093750,
-0.0087585449218750, -0.0203552246093750, -0.0082092285156250, -0.0193786621093750,
-0.0085144042968750, -0.0199584960937500, -0.0085144042968750, -0.0195922851562500,
-0.0095214843750000, -0.0158081054687500, -0.0092163085937500, -0.0162048339843750,
-0.0090942382812500, -0.0131225585937500, -0.0099182128906250, -0.0086059570312500,
-0.0098571777343750, -0.0094299316406250, -0.0088500976562500, -0.0034790039062500,
-0.0090026855468750},
{0.0030517578125000, -0.0162353515625000, 0.0031738281250000, -0.0160522460937500,
0.0034484863281250, -0.0157470703125000, 0.0033264160156250, -0.0208129882812500,
0.0030822753906250, -0.0197448730468750, 0.0041809082031250, -0.0141296386718750,
0.0040588378906250, -0.0173339843750000, 0.0043640136718750, -0.0130004882812500,
0.0048828125000000, -0.0034790039062500, 0.0048828125000000, -0.0041503906250000,
0.0079650878906250, 0.0038452148437500, 0.0067749023437500, 0.0028381347656250,
0.0072326660156250, 0.0017700195312500, 0.0101623535156250, 0.0062561035156250,
0.0085449218750000, 0.0056152343750000, 0.0071411132812500, 0.0033264160156250,
0.0106811523437500, 0.0043029785156250, 0.0052490234375000, 0.0036315917968750,
-0.0003051757812500, 0.0012207031250000, 0.0050964355468750, 0.0020446777343750,
-0.0074157714843750, 0.0023193359375000, -0.0062561035156250, 0.0015869140625000,
-0.0078430175781250, 0.0024108886718750, -0.0161437988281250, 0.0034790039062500,
-0.0122985839843750, 0.0027160644531250, -0.0155639648437500, 0.0037841796875000,
-0.0184020996093750, 0.0041198730468750, -0.0146789550781250, 0.0037841796875000,
-0.0127258300781250, 0.0038757324218750, -0.0155029296875000, 0.0039062500000000,
-0.0072631835937500, 0.0032043457031250, -0.0085754394531250, 0.0032043457031250,
-0.0069580078125000, 0.0039062500000000, -0.0011596679687500, 0.0032958984375000,
-0.0043640136718750, 0.0027465820312500, 0.0003662109375000, 0.0077819824218750,
0.0014953613281250, 0.0057373046875000, -0.0001220703125000, 0.0087890625000000,
0.0007629394531250, 0.0151062011718750, 0.0012817382812500, 0.0116882324218750,
-0.0010681152343750, 0.0148925781250000, -0.0007324218750000, 0.0180664062500000,
-0.0013427734375000, 0.0131225585937500, -0.0027770996093750, 0.0100097656250000,
-0.0020446777343750, 0.0133972167968750, -0.0048828125000000, 0.0018615722656250,
-0.0046081542968750, 0.0025024414062500, -0.0037841796875000, 0.0010070800781250,
-0.0056762695312500, -0.0065917968750000, -0.0058593750000000, -0.0040893554687500,
-0.0017089843750000, -0.0064392089843750, -0.0030822753906250, -0.0075683593750000,
-0.0011291503906250, -0.0070190429687500, 0.0028381347656250, -0.0068969726562500,
0.0004882812500000, -0.0070495605468750, 0.0049133300781250, -0.0089416503906250,
0.0059509277343750, -0.0080871582031250, 0.0035400390625000, -0.0103759765625000,
0.0040588378906250, -0.0134887695312500, 0.0058288574218750, -0.0118408203125000,
0.0011291503906250, -0.0157165527343750, 0.0014648437500000, -0.0164184570312500,
0.0013122558593750, -0.0148925781250000, -0.0010070800781250, -0.0155639648437500,
0.0000610351562500, -0.0151062011718750, -0.0023803710937500, -0.0093383789062500,
-0.0018310546875000, -0.0105285644531250, -0.0028686523437500, -0.0056762695312500,
-0.0048217773437500, 0.0010070800781250, -0.0034179687500000, -0.0019531250000000,
-0.0080566406250000, 0.0089721679687500, -0.0072326660156250, 0.0092163085937500,
-0.0075683593750000, 0.0127258300781250, -0.0107727050781250, 0.0210876464843750,
-0.0096130371093750, 0.0191955566406250, -0.0096740722656250, 0.0261840820312500,
-0.0100708007812500, 0.0276184082031250, -0.0102233886718750, 0.0282897949218750,
-0.0099487304687500, 0.0317077636718750, -0.0096435546875000, 0.0316467285156250,
-0.0108032226562500, 0.0327148437500000, -0.0108642578125000, 0.0333557128906250,
-0.0107421875000000, 0.0335693359375000, -0.0112304687500000, 0.0337829589843750,
-0.0113220214843750, 0.0335998535156250, -0.0111999511718750, 0.0335388183593750,
-0.0111999511718750, 0.0332336425781250, -0.0112609863281250, 0.0335693359375000,
-0.0112915039062500, 0.0339660644531250, -0.0112915039062500, 0.0336303710937500,
-0.0110473632812500, 0.0336303710937500, -0.0113525390625000, 0.0337524414062500,
-0.0107116699218750, 0.0337829589843750, -0.0101623535156250, 0.0337829589843750,
-0.0108032226562500, 0.0338745117187500, -0.0089111328125000, 0.0339355468750000,
-0.0092163085937500, 0.0339965820312500, -0.0087890625000000, 0.0340270996093750,
-0.0075073242187500, 0.0341796875000000, -0.0080871582031250, 0.0340270996093750,
-0.0067138671875000, 0.0334167480468750, -0.0067749023437500, 0.0336303710937500,
-0.0065307617187500, 0.0331420898437500, -0.0055847167968750, 0.0324707031250000,
-0.0059814453125000, 0.0329589843750000, -0.0058593750000000, 0.0318603515625000,
-0.0053710937500000, 0.0317687988281250, -0.0061950683593750, 0.0308837890625000,
-0.0068969726562500, 0.0299987792968750, -0.0062866210937500, 0.0303649902343750,
-0.0077514648437500, 0.0271606445312500, -0.0077819824218750, 0.0279846191406250,
-0.0077514648437500, 0.0270996093750000, -0.0082702636718750, 0.0245666503906250,
-0.0081176757812500, 0.0263061523437500, -0.0086059570312500, 0.0243225097656250,
-0.0083312988281250, 0.0242309570312500, -0.0087280273437500, 0.0243225097656250,
-0.0095214843750000, 0.0236816406250000, -0.0091247558593750, 0.0238342285156250,
-0.0096740722656250, 0.0223083496093750, -0.0100097656250000, 0.0229492187500000,
-0.0098571777343750, 0.0210571289062500, -0.0099182128906250, 0.0194702148437500,
-0.0100708007812500, 0.0212707519531250, -0.0095520019531250, 0.0136413574218750,
-0.0099487304687500, 0.0160827636718750, -0.0092468261718750, 0.0112915039062500,
-0.0085449218750000, 0.0038452148437500, -0.0091857910156250, 0.0089416503906250,
-0.0066223144531250, -0.0055847167968750, -0.0070495605468750, -0.0021667480468750,
-0.0060729980468750, -0.0074462890625000, -0.0041198730468750, -0.0200195312500000,
-0.0051269531250000, -0.0128173828125000, -0.0017395019531250, -0.0263366699218750,
-0.0024108886718750, -0.0268859863281250, -0.0012207031250000, -0.0253601074218750,
0.0016174316406250, -0.0318908691406250, 0.0000305175781250, -0.0303955078125000,
0.0027160644531250, -0.0253906250000000, 0.0028686523437500, -0.0291442871093750,
0.0031738281250000, -0.0233459472656250, 0.0045166015625000, -0.0154113769531250,
0.0039672851562500, -0.0205993652343750, 0.0061340332031250, -0.0067443847656250,
0.0057983398437500, -0.0065002441406250, 0.0060119628906250, -0.0070190429687500,
0.0079650878906250, 0.0000305175781250, 0.0073242187500000, -0.0015563964843750,
0.0049438476562500, -0.0041503906250000, 0.0066833496093750, -0.0025939941406250,
0.0049743652343750, -0.0029602050781250, 0.0014343261718750, -0.0064086914062500,
0.0028991699218750, -0.0055847167968750, -0.0012207031250000, -0.0003051757812500,
-0.0002441406250000, -0.0029296875000000, -0.0025329589843750, 0.0005187988281250,
-0.0071105957031250, 0.0073242187500000, -0.0046081542968750, 0.0039367675781250,
-0.0071105957031250, 0.0090942382812500, -0.0075683593750000, 0.0108642578125000,
-0.0092773437500000, 0.0090332031250000, -0.0104370117187500, 0.0097961425781250,
-0.0084533691406250, 0.0103454589843750, -0.0160522460937500, 0.0052185058593750,
-0.0152282714843750, 0.0065917968750000, -0.0160217285156250, 0.0049438476562500,
-0.0218811035156250, 0.0001525878906250, -0.0199584960937500, 0.0018615722656250,
-0.0164489746093750, -0.0012512207031250, -0.0199584960937500, -0.0018005371093750,
-0.0154113769531250, -0.0008850097656250, -0.0085144042968750, -0.0018310546875000,
-0.0128479003906250, -0.0021057128906250, -0.0050048828125000, 0.0000000000000000,
-0.0041503906250000, -0.0002746582031250, -0.0044860839843750, 0.0005798339843750,
-0.0017089843750000, 0.0019531250000000, -0.0028381347656250, 0.0012817382812500,
-0.0000305175781250, 0.0050659179687500, -0.0001220703125000, 0.0031127929687500,
0.0002136230468750, 0.0071105957031250, 0.0031738281250000, 0.0129394531250000,
0.0022583007812500, 0.0091857910156250, -0.0039978027343750, 0.0162353515625000,
-0.0007019042968750, 0.0174865722656250, -0.0030517578125000, 0.0149841308593750,
-0.0145568847656250, 0.0162658691406250, -0.0027160644531250, 0.0057983398437500,
0.0156250000000000, 0.0165405273437500, 0.0113220214843750, 0.0158996582031250,
0.0112915039062500, 0.0137329101562500, 0.0190734863281250, 0.0166931152343750,
0.0190734863281250, 0.0179138183593750, 0.0096435546875000, 0.0046386718750000,
0.0128173828125000, 0.0082397460937500, 0.0099182128906250, 0.0046997070312500,
0.0008544921875000, -0.0079956054687500, 0.0046997070312500, -0.0033264160156250,
0.0021057128906250, -0.0026855468750000, -0.0000305175781250, -0.0068359375000000,
0.0012512207031250, -0.0021667480468750, 0.0023193359375000, 0.0046081542968750,
0.0017089843750000, 0.0004577636718750, 0.0016784667968750, 0.0023193359375000,
0.0025634765625000, 0.0061950683593750, 0.0015869140625000, 0.0019226074218750,
-0.0003356933593750, -0.0025024414062500, 0.0007629394531250, 0.0004882812500000,
0.0032348632812500, -0.0060424804687500, 0.0007019042968750, -0.0056762695312500,
0.0030212402343750, -0.0071411132812500, 0.0073852539062500, -0.0112915039062500,
0.0049133300781250, -0.0093383789062500, 0.0087890625000000, -0.0153808593750000,
0.0089721679687500, -0.0144653320312500, 0.0088500976562500, -0.0155334472656250,
0.0108337402343750, -0.0208435058593750, 0.0100708007812500, -0.0187988281250000,
0.0093994140625000, -0.0163574218750000, 0.0101928710937500, -0.0192260742187500,
0.0102844238281250, -0.0149536132812500, 0.0087890625000000, -0.0094604492187500,
0.0086975097656250, -0.0129699707031250, 0.0121154785156250, -0.0043029785156250,
0.0119934082031250, -0.0043334960937500, 0.0091247558593750, -0.0036010742187500,
0.0106506347656250, 0.0008850097656250, 0.0121154785156250, -0.0009460449218750,
-0.0014038085937500, 0.0036010742187500, 0.0036315917968750, 0.0033874511718750,
-0.0036926269531250, 0.0029907226562500, -0.0175476074218750, 0.0060424804687500,
-0.0089111328125000, 0.0055847167968750, -0.0263671875000000, 0.0022277832031250,
-0.0267333984375000, 0.0033264160156250, -0.0254821777343750, 0.0022888183593750,
-0.0342407226562500, -0.0010375976562500, -0.0316162109375000, 0.0000610351562500,
-0.0272521972656250, -0.0002746582031250, -0.0315856933593750, -0.0010375976562500,
-0.0258178710937500, -0.0003356933593750, -0.0185241699218750, 0.0005187988281250,
-0.0239868164062500, 0.0000915527343750, -0.0082092285156250, 0.0003051757812500,
-0.0112609863281250, 0.0007934570312500, -0.0060729980468750, 0.0002746582031250,
0.0063781738281250, -0.0003051757812500, -0.0010986328125000, 0.0001220703125000,
0.0138244628906250, -0.0005493164062500, 0.0136108398437500, -0.0005187988281250,
0.0134887695312500, -0.0010986328125000, 0.0211486816406250, -0.0015258789062500,
0.0181884765625000, -0.0010070800781250, 0.0202941894531250, -0.0036926269531250,
0.0211486816406250, -0.0032958984375000, 0.0202636718750000, -0.0037841796875000,
0.0202636718750000, -0.0059204101562500, 0.0203247070312500, -0.0051879882812500,
0.0202026367187500, -0.0056762695312500, 0.0196228027343750, -0.0059509277343750,
0.0208129882812500, -0.0057373046875000, 0.0216369628906250, -0.0057067871093750,
0.0209350585937500, -0.0057067871093750, 0.0246887207031250, -0.0054321289062500,
0.0234375000000000, -0.0054626464843750, 0.0250244140625000, -0.0053710937500000,
0.0281372070312500, -0.0050354003906250, 0.0258178710937500, -0.0050659179687500,
0.0313415527343750, -0.0058593750000000, 0.0299072265625000, -0.0055541992187500,
0.0314331054687500, -0.0061035156250000, 0.0359191894531250, -0.0073242187500000,
0.0332031250000000, -0.0068969726562500, 0.0384521484375000, -0.0071105957031250,
0.0374145507812500, -0.0076599121093750, 0.0381469726562500, -0.0071716308593750,
0.0415344238281250},
{-0.0022888183593750, 0.0101013183593750, 0.0016479492187500, 0.0141906738281250,
-0.0008850097656250, 0.0156860351562500, 0.0019226074218750, 0.0023803710937500,
0.0031127929687500, 0.0046386718750000, 0.0024108886718750, 0.0028686523437500,
0.0019531250000000, -0.0072631835937500, 0.0021057128906250, -0.0037536621093750,
0.0049743652343750, -0.0014038085937500, 0.0025939941406250, -0.0043640136718750,
0.0065917968750000, -0.0026855468750000, 0.0121459960937500, 0.0021972656250000,
0.0078735351562500, 0.0009460449218750, 0.0136413574218750, 0.0005493164062500,
0.0156860351562500, 0.0020446777343750, 0.0133056640625000, 0.0002746582031250,
0.0134582519531250, -0.0015563964843750, 0.0146179199218750, 0.0001525878906250,
0.0114440917968750, -0.0047302246093750, 0.0118103027343750, -0.0038757324218750,
0.0111083984375000, -0.0067138671875000, 0.0090942382812500, -0.0107421875000000,
0.0102233886718750, -0.0075988769531250, 0.0079345703125000, -0.0169372558593750,
0.0083007812500000, -0.0171203613281250, 0.0058898925781250, -0.0157165527343750,
0.0048522949218750, -0.0204162597656250, 0.0067749023437500, -0.0197448730468750,
-0.0075073242187500, -0.0126342773437500, -0.0024414062500000, -0.0158386230468750,
-0.0091552734375000, -0.0111999511718750, -0.0239257812500000, -0.0025329589843750,
-0.0153198242187500, -0.0070495605468750, -0.0279235839843750, 0.0005493164062500,
-0.0308837890625000, 0.0015258789062500, -0.0256958007812500, 0.0013122558593750,
-0.0288391113281250, 0.0043029785156250, -0.0311279296875000, 0.0031433105468750,
-0.0162658691406250, 0.0047302246093750, -0.0209350585937500, 0.0055236816406250,
-0.0153503417968750, 0.0041809082031250, -0.0019226074218750, 0.0038146972656250,
-0.0095825195312500, 0.0047607421875000, 0.0037841796875000, 0.0015258789062500,
0.0039367675781250, 0.0016479492187500, 0.0041809082031250, 0.0016479492187500,
0.0108947753906250, -0.0003051757812500, 0.0082702636718750, 0.0002136230468750,
0.0128479003906250, 0.0009460449218750, 0.0127868652343750, 0.0003662109375000,
0.0130004882812500, 0.0006713867187500, 0.0155639648437500, 0.0018615722656250,
0.0145263671875000, 0.0014038085937500, 0.0163269042968750, 0.0000000000000000,
0.0156860351562500, 0.0006713867187500, 0.0180358886718750, -0.0002441406250000,
0.0200195312500000, -0.0020446777343750, 0.0174560546875000, -0.0011901855468750,
0.0261535644531250, -0.0025024414062500, 0.0236816406250000, -0.0024719238281250,
0.0270996093750000, -0.0030212402343750, 0.0344543457031250, -0.0039062500000000,
0.0291748046875000, -0.0032043457031250, 0.0384216308593750, -0.0050964355468750,
0.0378112792968750, -0.0051574707031250, 0.0386047363281250, -0.0048828125000000,
0.0442199707031250, -0.0057373046875000, 0.0415039062500000, -0.0055541992187500,
0.0449829101562500, -0.0050048828125000, 0.0457458496093750, -0.0051879882812500,
0.0446166992187500, -0.0048217773437500, 0.0456237792968750, -0.0043334960937500,
0.0455322265625000, -0.0046386718750000, 0.0423583984375000, -0.0037231445312500,
0.0445251464843750, -0.0038757324218750, 0.0423889160156250, -0.0037841796875000,
0.0386047363281250, -0.0030517578125000, 0.0416564941406250, -0.0033569335937500,
0.0357971191406250, -0.0036315917968750, 0.0370788574218750, -0.0034179687500000,
0.0359497070312500, -0.0037841796875000, 0.0320129394531250, -0.0043945312500000,
0.0352478027343750, -0.0040893554687500, 0.0306701660156250, -0.0045471191406250,
0.0319824218750000, -0.0044860839843750, 0.0316772460937500, -0.0045776367187500,
0.0290527343750000, -0.0047912597656250, 0.0317382812500000, -0.0045471191406250,
0.0281066894531250, -0.0052795410156250, 0.0292053222656250, -0.0051879882812500,
0.0292968750000000, -0.0054016113281250, 0.0272827148437500, -0.0059509277343750,
0.0295410156250000, -0.0057373046875000, 0.0280151367187500, -0.0066528320312500,
0.0289001464843750, -0.0064086914062500, 0.0293579101562500, -0.0070495605468750,
0.0287170410156250, -0.0080566406250000, 0.0303649902343750, -0.0074768066406250,
0.0297851562500000, -0.0087890625000000, 0.0301208496093750, -0.0089721679687500,
0.0306701660156250, -0.0089721679687500, 0.0306396484375000, -0.0095214843750000,
0.0311889648437500, -0.0093383789062500, 0.0315246582031250, -0.0091247558593750,
0.0316772460937500, -0.0093078613281250, 0.0319213867187500, -0.0092468261718750,
0.0323486328125000, -0.0087280273437500, 0.0326232910156250, -0.0087890625000000,
0.0320129394531250, -0.0097961425781250, 0.0323486328125000, -0.0091857910156250,
0.0319213867187500, -0.0097045898437500, 0.0313415527343750, -0.0110168457031250,
0.0318603515625000, -0.0103454589843750, 0.0298767089843750, -0.0111083984375000,
0.0301208496093750, -0.0114135742187500, 0.0301513671875000, -0.0105895996093750,
0.0291137695312500, -0.0105285644531250, 0.0300598144531250, -0.0107727050781250,
0.0306701660156250, -0.0072631835937500, 0.0303955078125000, -0.0083312988281250,
0.0320434570312500, -0.0068359375000000, 0.0334472656250000, -0.0031738281250000,
0.0325622558593750, -0.0048522949218750, 0.0362548828125000, -0.0032653808593750,
0.0364990234375000, -0.0020751953125000, 0.0368652343750000, -0.0035705566406250,
0.0394592285156250, -0.0043640136718750, 0.0388793945312500, -0.0034179687500000,
0.0357971191406250, -0.0065612792968750, 0.0382385253906250, -0.0067443847656250,
0.0331420898437500, -0.0054931640625000, 0.0273437500000000, -0.0065307617187500,
0.0309753417968750, -0.0071105957031250, 0.0169677734375000, -0.0031127929687500,
0.0187377929687500, -0.0038146972656250, 0.0136413574218750, -0.0028381347656250,
0.0024719238281250, 0.0003967285156250, 0.0078735351562500, -0.0009765625000000,
-0.0051879882812500, -0.0003967285156250, -0.0050659179687500, 0.0004882812500000,
-0.0062561035156250, 0.0001831054687500, -0.0137939453125000, -0.0001220703125000,
-0.0104370117187500, -0.0003967285156250, -0.0128479003906250, -0.0024719238281250,
-0.0140991210937500, -0.0010070800781250, -0.0120849609375000, -0.0027465820312500,
-0.0111694335937500, -0.0055236816406250, -0.0117187500000000, -0.0040283203125000,
-0.0095825195312500, -0.0104675292968750, -0.0097351074218750, -0.0090942382812500,
-0.0075988769531250, -0.0099792480468750, -0.0055541992187500, -0.0149841308593750,
-0.0069580078125000, -0.0133972167968750, -0.0000610351562500, -0.0163574218750000,
-0.0011901855468750, -0.0166015625000000, 0.0017395019531250, -0.0151672363281250,
0.0079345703125000, -0.0163879394531250, 0.0049438476562500, -0.0169372558593750,
0.0099487304687500, -0.0113525390625000, 0.0110778808593750, -0.0136718750000000,
0.0088500976562500, -0.0099792480468750, 0.0094909667968750, -0.0037841796875000,
0.0103454589843750, -0.0080871582031250, 0.0060119628906250, 0.0003967285156250,
0.0062255859375000, 0.0014038085937500, 0.0050048828125000, -0.0005493164062500,
0.0021667480468750, 0.0024108886718750, 0.0034484863281250, 0.0031433105468750,
0.0005493164062500, 0.0000000000000000, 0.0003356933593750, 0.0001525878906250,
0.0006713867187500, -0.0002136230468750, -0.0009765625000000, -0.0023193359375000,
-0.0010681152343750, -0.0020141601562500, 0.0009155273437500, -0.0018310546875000,
-0.0002441406250000, -0.0023498535156250, 0.0005798339843750, -0.0017700195312500,
0.0028076171875000, -0.0009460449218750, 0.0011901855468750, -0.0015258789062500,
0.0025024414062500, -0.0003356933593750, 0.0036926269531250, 0.0000305175781250,
0.0024108886718750, 0.0000610351562500, 0.0012207031250000, 0.0001220703125000,
0.0023193359375000, 0.0000000000000000, 0.0016174316406250, 0.0017089843750000,
0.0000610351562500, 0.0008544921875000, 0.0021972656250000, 0.0029907226562500,
0.0046386718750000, 0.0057373046875000, 0.0027160644531250, 0.0037536621093750,
0.0039367675781250, 0.0086975097656250, 0.0071716308593750, 0.0092468261718750,
0.0012207031250000, 0.0086975097656250, -0.0031433105468750, 0.0105285644531250,
0.0020751953125000, 0.0102844238281250, -0.0111694335937500, 0.0096435546875000,
-0.0107116699218750, 0.0111083984375000, -0.0101928710937500, 0.0083923339843750,
-0.0170288085937500, 0.0060119628906250, -0.0146789550781250, 0.0084838867187500,
-0.0135192871093750, 0.0007629394531250, -0.0157165527343750, 0.0015563964843750,
-0.0119934082031250, 0.0005187988281250, -0.0088500976562500, -0.0048522949218750,
-0.0123596191406250, -0.0030212402343750, -0.0019226074218750, -0.0047912597656250,
-0.0034790039062500, -0.0053405761718750, -0.0024414062500000, -0.0055847167968750,
0.0047302246093750, -0.0061340332031250, 0.0018005371093750, -0.0056457519531250,
0.0032958984375000, -0.0082092285156250, 0.0052795410156250, -0.0078125000000000,
0.0020141601562500, -0.0075378417968750, -0.0001220703125000, -0.0096435546875000,
0.0025024414062500, -0.0090332031250000, -0.0035705566406250, -0.0041198730468750,
-0.0043640136718750, -0.0069580078125000, -0.0021667480468750, -0.0010681152343750,
-0.0037536621093750, 0.0068359375000000, -0.0048217773437500, 0.0023193359375000,
0.0000000000000000, 0.0159301757812500, -0.0007629394531250, 0.0163269042968750,
-0.0003051757812500, 0.0178833007812500, 0.0027465820312500, 0.0257873535156250,
0.0014038085937500, 0.0234985351562500, 0.0027465820312500, 0.0260009765625000,
0.0033569335937500, 0.0267639160156250, 0.0018920898437500, 0.0259399414062500,
0.0014648437500000, 0.0258178710937500, 0.0025939941406250, 0.0249633789062500,
0.0000610351562500, 0.0244445800781250, -0.0000610351562500, 0.0239257812500000,
-0.0001525878906250, 0.0239868164062500, -0.0009765625000000, 0.0241088867187500,
-0.0005493164062500, 0.0237121582031250, -0.0028991699218750, 0.0246276855468750,
-0.0020141601562500, 0.0241088867187500, -0.0032958984375000, 0.0237731933593750,
-0.0055541992187500, 0.0240783691406250, -0.0040893554687500, 0.0234680175781250,
-0.0079956054687500, 0.0237426757812500, -0.0074768066406250, 0.0230712890625000,
-0.0081176757812500, 0.0227355957031250, -0.0109252929687500, 0.0227355957031250,
-0.0096130371093750, 0.0216369628906250, -0.0110778808593750, 0.0214843750000000,
-0.0114440917968750, 0.0209655761718750, -0.0110168457031250, 0.0194091796875000,
-0.0113525390625000, 0.0183105468750000, -0.0112915039062500, 0.0179748535156250,
-0.0104980468750000, 0.0163574218750000, -0.0107727050781250, 0.0155029296875000,
-0.0103454589843750, 0.0144958496093750, -0.0095214843750000, 0.0130004882812500,
-0.0099487304687500, 0.0124206542968750, -0.0093383789062500, 0.0122680664062500,
-0.0092773437500000, 0.0112304687500000, -0.0091857910156250, 0.0107421875000000,
-0.0089721679687500, 0.0105895996093750, -0.0090942382812500, 0.0098266601562500,
-0.0085144042968750, 0.0098876953125000, -0.0084838867187500, 0.0086975097656250,
-0.0085754394531250, 0.0089721679687500, -0.0082702636718750, 0.0093383789062500,
-0.0082702636718750, 0.0077819824218750, -0.0084228515625000, 0.0102844238281250,
-0.0084838867187500, 0.0089721679687500, -0.0081481933593750, 0.0098876953125000,
-0.0080871582031250, 0.0118408203125000, -0.0083312988281250, 0.0096130371093750,
-0.0075683593750000, 0.0139160156250000, -0.0075073242187500, 0.0120544433593750,
-0.0077209472656250, 0.0133666992187500, -0.0073242187500000, 0.0168151855468750,
-0.0072631835937500, 0.0138549804687500, -0.0080871582031250, 0.0196838378906250,
-0.0078735351562500, 0.0183715820312500, -0.0080261230468750, 0.0198059082031250,
-0.0086975097656250, 0.0240173339843750, -0.0083618164062500, 0.0213928222656250,
-0.0086364746093750},
{0.0004272460937500, -0.0009765625000000, -0.0076599121093750, -0.0043945312500000,
-0.0072326660156250, -0.0044860839843750, -0.0072021484375000, -0.0046997070312500,
-0.0115661621093750, -0.0065917968750000, -0.0092163085937500, -0.0059814453125000,
-0.0090026855468750, -0.0067443847656250, -0.0110778808593750, -0.0079040527343750,
-0.0077819824218750, -0.0056152343750000, -0.0046081542968750, -0.0046081542968750,
-0.0075683593750000, -0.0059814453125000, -0.0012817382812500, 0.0026855468750000,
-0.0015258789062500, 0.0003356933593750, -0.0018615722656250, 0.0053405761718750,
0.0016784667968750, 0.0144042968750000, 0.0003051757812500, 0.0095214843750000,
-0.0024719238281250, 0.0198059082031250, -0.0005187988281250, 0.0210266113281250,
-0.0024719238281250, 0.0203857421875000, -0.0068969726562500, 0.0245971679687500,
-0.0047302246093750, 0.0234375000000000, -0.0051574707031250, 0.0215454101562500,
-0.0073852539062500, 0.0218200683593750, -0.0047912597656250, 0.0202636718750000,
-0.0021362304687500, 0.0176086425781250, -0.0043945312500000, 0.0177307128906250,
-0.0001220703125000, 0.0174255371093750, -0.0001525878906250, 0.0159301757812500,
-0.0003662109375000, 0.0159606933593750, 0.0019531250000000, 0.0167236328125000,
0.0010070800781250, 0.0157775878906250, -0.0002136230468750, 0.0157165527343750,
0.0008239746093750, 0.0161437988281250, 0.0000000000000000, 0.0146789550781250,
-0.0020751953125000, 0.0136413574218750, -0.0013122558593750, 0.0140991210937500,
-0.0020141601562500, 0.0098571777343750, -0.0021362304687500, 0.0100097656250000,
-0.0025634765625000, 0.0081481933593750, -0.0028991699218750, 0.0044555664062500,
-0.0024719238281250, 0.0053100585937500, -0.0047912597656250, 0.0016479492187500,
-0.0040893554687500, 0.0010375976562500, -0.0052795410156250, 0.0002746582031250,
-0.0075683593750000, -0.0019531250000000, -0.0061950683593750, -0.0018005371093750,
-0.0086975097656250, -0.0026550292968750, -0.0087890625000000, -0.0036010742187500,
-0.0086059570312500, -0.0031433105468750, -0.0095825195312500, -0.0030517578125000,
-0.0091552734375000, -0.0039062500000000, -0.0094604492187500, -0.0018920898437500,
-0.0094909667968750, -0.0025939941406250, -0.0089721679687500, -0.0024719238281250,
-0.0089721679687500, -0.0010375976562500, -0.0092163085937500, -0.0019531250000000,
-0.0078735351562500, -0.0006408691406250, -0.0079345703125000, -0.0007324218750000,
-0.0080566406250000, -0.0005187988281250, -0.0072631835937500, 0.0000610351562500,
-0.0073547363281250, -0.0005493164062500, -0.0079345703125000, 0.0007629394531250,
-0.0077209472656250, 0.0005798339843750, -0.0077819824218750, 0.0004272460937500,
-0.0082702636718750, 0.0010681152343750, -0.0080566406250000, 0.0010070800781250,
-0.0079956054687500, 0.0016784667968750, -0.0080261230468750, 0.0012512207031250,
-0.0080261230468750, 0.0018005371093750, -0.0078735351562500, 0.0024719238281250,
-0.0078430175781250, 0.0015563964843750, -0.0084533691406250, 0.0028991699218750,
-0.0082702636718750, 0.0027160644531250, -0.0083618164062500, 0.0032043457031250,
-0.0089111328125000, 0.0041809082031250, -0.0086975097656250, 0.0036010742187500,
-0.0081481933593750, 0.0054321289062500, -0.0084533691406250, 0.0052185058593750,
-0.0079345703125000, 0.0055236816406250, -0.0070190429687500, 0.0067749023437500,
-0.0073242187500000, 0.0062561035156250, -0.0063476562500000, 0.0071411132812500,
-0.0061645507812500, 0.0068054199218750, -0.0061340332031250, 0.0076599121093750,
-0.0055847167968750, 0.0084533691406250, -0.0056457519531250, 0.0077514648437500,
-0.0059814453125000, 0.0116882324218750, -0.0057678222656250, 0.0102233886718750,
-0.0059509277343750, 0.0126342773437500, -0.0065002441406250, 0.0165710449218750,
-0.0062255859375000, 0.0137023925781250, -0.0057067871093750, 0.0202636718750000,
-0.0063171386718750, 0.0193786621093750, -0.0053405761718750, 0.0208740234375000,
-0.0041809082031250, 0.0254211425781250, -0.0049743652343750, 0.0227661132812500,
-0.0028381347656250, 0.0275268554687500, -0.0031127929687500, 0.0275878906250000,
-0.0024108886718750, 0.0267028808593750, -0.0010070800781250, 0.0290832519531250,
-0.0019836425781250, 0.0288085937500000, 0.0004272460937500, 0.0255432128906250,
0.0003051757812500, 0.0269165039062500, 0.0005493164062500, 0.0245361328125000,
0.0022277832031250, 0.0207519531250000, 0.0015563964843750, 0.0230712890625000,
0.0011596679687500, 0.0179138183593750, 0.0020141601562500, 0.0181579589843750,
0.0004577636718750, 0.0178527832031250, -0.0010986328125000, 0.0145568847656250,
0.0001831054687500, 0.0155029296875000, -0.0032653808593750, 0.0151977539062500,
-0.0030517578125000, 0.0148010253906250, -0.0042724609375000, 0.0147094726562500,
-0.0064697265625000, 0.0154113769531250, -0.0052490234375000, 0.0154418945312500,
-0.0100097656250000, 0.0109863281250000, -0.0098876953125000, 0.0136108398437500,
-0.0089721679687500, 0.0100097656250000, -0.0117187500000000, 0.0039672851562500,
-0.0116882324218750, 0.0077209472656250, -0.0068054199218750, -0.0009765625000000,
-0.0082397460937500, -0.0003662109375000, -0.0056762695312500, -0.0028991699218750,
-0.0009765625000000, -0.0083007812500000, -0.0035095214843750, -0.0045776367187500,
0.0018920898437500, -0.0146179199218750, 0.0025939941406250, -0.0139160156250000,
0.0018920898437500, -0.0142211914062500, 0.0039672851562500, -0.0210876464843750,
0.0037231445312500, -0.0190429687500000, 0.0019226074218750, -0.0155944824218750,
0.0033874511718750, -0.0193176269531250, 0.0012207031250000, -0.0131530761718750,
-0.0015258789062500, -0.0054016113281250, 0.0007324218750000, -0.0102844238281250,
-0.0055847167968750, 0.0030517578125000, -0.0058593750000000, 0.0032653808593750,
-0.0040283203125000, 0.0030822753906250, -0.0071411132812500, 0.0096435546875000,
-0.0078735351562500, 0.0078430175781250, 0.0000915527343750, 0.0085754394531250,
-0.0026855468750000, 0.0092468261718750, 0.0011291503906250, 0.0086364746093750,
0.0096740722656250, 0.0082397460937500, 0.0051269531250000, 0.0081787109375000,
0.0104370117187500, 0.0073242187500000, 0.0137023925781250, 0.0083312988281250,
0.0085449218750000, 0.0066833496093750, 0.0066833496093750, 0.0045776367187500,
0.0101623535156250, 0.0061950683593750, -0.0025329589843750, 0.0030822753906250,
-0.0025329589843750, 0.0021972656250000, -0.0015258789062500, 0.0041198730468750,
-0.0097045898437500, 0.0050964355468750, -0.0010681152343750, 0.0037536621093750,
0.0011901855468750, 0.0025939941406250, 0.0012817382812500, 0.0013122558593750,
0.0014953613281250, 0.0032653808593750, 0.0008544921875000, 0.0053100585937500,
0.0006103515625000, 0.0039367675781250, 0.0055847167968750, 0.0049133300781250,
0.0034179687500000, 0.0069885253906250, 0.0058898925781250, 0.0034790039062500,
0.0114135742187500, 0.0000610351562500, 0.0083007812500000, 0.0030822753906250,
0.0120849609375000, -0.0013427734375000, 0.0138549804687500, -0.0034179687500000,
0.0119018554687500, 0.0005798339843750, 0.0119018554687500, 0.0015563964843750,
0.0127868652343750, -0.0014038085937500, 0.0071716308593750, 0.0085449218750000,
0.0089416503906250, 0.0086975097656250, 0.0066223144531250, 0.0078125000000000,
0.0016174316406250, 0.0125122070312500, 0.0038757324218750, 0.0117187500000000,
-0.0038757324218750, 0.0085754394531250, -0.0018310546875000, 0.0105895996093750,
-0.0056152343750000, 0.0073547363281250, -0.0133666992187500, 0.0021667480468750,
-0.0089721679687500, 0.0052185058593750, -0.0165405273437500, 0.0013427734375000,
-0.0176086425781250, 0.0005187988281250, -0.0160827636718750, 0.0004882812500000,
-0.0187988281250000, -0.0006713867187500, -0.0185241699218750, 0.0002746582031250,
-0.0135498046875000, -0.0015869140625000, -0.0165710449218750, -0.0014038085937500,
-0.0106811523437500, -0.0023803710937500, -0.0030517578125000, -0.0036010742187500,
-0.0086364746093750, -0.0025939941406250, 0.0037841796875000, -0.0072937011718750,
0.0039367675781250, -0.0062255859375000, 0.0045166015625000, -0.0083312988281250,
0.0111083984375000, -0.0127258300781250, 0.0087890625000000, -0.0100402832031250,
0.0115356445312500, -0.0138244628906250, 0.0123291015625000, -0.0156555175781250,
0.0122375488281250, -0.0121765136718750, 0.0129089355468750, -0.0111083984375000,
0.0131225585937500, -0.0132141113281250, 0.0163574218750000, -0.0050659179687500,
0.0141906738281250, -0.0057373046875000, 0.0180053710937500, -0.0042419433593750,
0.0229492187500000, 0.0012512207031250, 0.0191345214843750, -0.0010070800781250,
0.0283203125000000, 0.0022583007812500, 0.0278930664062500, 0.0029907226562500,
0.0282897949218750, 0.0025024414062500, 0.0338745117187500, 0.0034790039062500,
0.0320129394531250, 0.0032958984375000, 0.0325622558593750, 0.0026550292968750,
0.0340270996093750, 0.0032653808593750, 0.0316162109375000, 0.0020751953125000,
0.0303955078125000, 0.0007324218750000, 0.0322875976562500, 0.0018005371093750,
0.0237426757812500, -0.0009765625000000, 0.0263366699218750, -0.0010681152343750,
0.0226440429687500, -0.0009155273437500, 0.0150146484375000, -0.0019836425781250,
0.0199890136718750, -0.0017395019531250, 0.0104370117187500, -0.0020141601562500,
0.0114440917968750, -0.0017089843750000, 0.0107116699218750, -0.0023498535156250,
0.0047302246093750, -0.0032348632812500, 0.0076293945312500, -0.0025939941406250,
0.0040893554687500, -0.0037536621093750, 0.0035400390625000, -0.0040893554687500,
0.0041503906250000, -0.0036315917968750, 0.0026855468750000, -0.0036621093750000,
0.0025024414062500, -0.0039062500000000, 0.0028686523437500, -0.0034179687500000,
0.0024414062500000, -0.0032653808593750, 0.0028686523437500, -0.0034790039062500,
0.0034790039062500, -0.0035400390625000, 0.0028991699218750, -0.0034484863281250,
0.0041198730468750, -0.0034179687500000, 0.0039062500000000, -0.0034790039062500,
0.0037536621093750, -0.0033874511718750, 0.0044555664062500, -0.0032043457031250,
0.0040588378906250, -0.0031738281250000, 0.0036621093750000, -0.0028991699218750,
0.0043945312500000, -0.0029296875000000, 0.0036010742187500, -0.0027160644531250,
0.0027160644531250, -0.0023803710937500, 0.0036621093750000, -0.0025634765625000,
0.0014953613281250, -0.0024108886718750, 0.0019836425781250, -0.0021972656250000,
0.0010681152343750, -0.0026550292968750, -0.0007934570312500, -0.0029296875000000,
0.0003662109375000, -0.0026550292968750, -0.0018615722656250, -0.0035095214843750,
-0.0016174316406250, -0.0036010742187500, -0.0020141601562500, -0.0034790039062500,
-0.0035095214843750, -0.0038452148437500, -0.0028991699218750, -0.0038757324218750,
-0.0046691894531250, -0.0040893554687500, -0.0044250488281250, -0.0038146972656250,
-0.0049438476562500, -0.0044860839843750, -0.0063171386718750, -0.0052185058593750,
-0.0057067871093750, -0.0046386718750000, -0.0073242187500000, -0.0062255859375000,
-0.0072937011718750, -0.0061340332031250, -0.0076293945312500, -0.0067749023437500,
-0.0084838867187500, -0.0077819824218750, -0.0081787109375000, -0.0070495605468750,
-0.0102233886718750, -0.0097351074218750, -0.0100097656250000, -0.0093688964843750,
-0.0111694335937500, -0.0094604492187500, -0.0130310058593750, -0.0112915039062500,
-0.0122375488281250, -0.0107421875000000, -0.0149230957031250, -0.0108642578125000,
-0.0146789550781250, -0.0110473632812500, -0.0150451660156250, -0.0107727050781250,
-0.0170593261718750, -0.0108032226562500, -0.0161743164062500, -0.0108032226562500,
-0.0153808593750000, -0.0092468261718750, -0.0165710449218750, -0.0098266601562500,
-0.0145568847656250},
{0.0164794921875000, -0.0076293945312500, 0.0188293457031250, -0.0081176757812500,
0.0242309570312500, -0.0097656250000000, 0.0211791992187500, -0.0089721679687500,
0.0255126953125000, -0.0085449218750000, 0.0267639160156250, -0.0098571777343750,
0.0251159667968750, -0.0079650878906250, 0.0259704589843750, -0.0057983398437500,
0.0267028808593750, -0.0073547363281250, 0.0222473144531250, -0.0032348632812500,
0.0239868164062500, -0.0031738281250000, 0.0219116210937500, -0.0030822753906250,
0.0177307128906250, -0.0008850097656250, 0.0203857421875000, -0.0013732910156250,
0.0135192871093750, -0.0009460449218750, 0.0146179199218750, -0.0008239746093750,
0.0125732421875000, -0.0004882812500000, 0.0073852539062500, -0.0000305175781250,
0.0105590820312500, -0.0003051757812500, 0.0047912597656250, -0.0000305175781250,
0.0047302246093750, 0.0004577636718750, 0.0040283203125000, -0.0002136230468750,
0.0010375976562500, -0.0008239746093750, 0.0027160644531250, -0.0002441406250000,
-0.0007629394531250, -0.0009765625000000, -0.0001525878906250, -0.0013427734375000,
-0.0011596679687500, -0.0010070800781250, -0.0037231445312500, -0.0006713867187500,
-0.0018005371093750, -0.0009460449218750, -0.0046386718750000, -0.0015563964843750,
-0.0041503906250000, -0.0009460449218750, -0.0050659179687500, -0.0018310546875000,
-0.0072631835937500, -0.0031433105468750, -0.0057678222656250, -0.0023193359375000,
-0.0089721679687500, -0.0035400390625000, -0.0084533691406250, -0.0039062500000000,
-0.0088500976562500, -0.0035400390625000, -0.0109558105468750, -0.0036926269531250,
-0.0093994140625000, -0.0037231445312500, -0.0110778808593750, -0.0031433105468750,
-0.0111694335937500, -0.0032043457031250, -0.0108642578125000, -0.0028686523437500,
-0.0115966796875000, -0.0022277832031250, -0.0113525390625000, -0.0026245117187500,
-0.0107727050781250, -0.0018920898437500, -0.0111999511718750, -0.0017395019531250,
-0.0106201171875000, -0.0021362304687500, -0.0097961425781250, -0.0020751953125000,
-0.0101928710937500, -0.0018615722656250, -0.0089416503906250, -0.0028991699218750,
-0.0093078613281250, -0.0028076171875000, -0.0091552734375000, -0.0029907226562500,
-0.0084228515625000, -0.0036926269531250, -0.0089721679687500, -0.0033874511718750,
-0.0077819824218750, -0.0038452148437500, -0.0079650878906250, -0.0037841796875000,
-0.0078430175781250, -0.0041503906250000, -0.0072631835937500, -0.0045166015625000,
-0.0079650878906250, -0.0041809082031250, -0.0072937011718750, -0.0051269531250000,
-0.0075073242187500, -0.0051269531250000, -0.0076599121093750, -0.0049743652343750,
-0.0073242187500000, -0.0051574707031250, -0.0076293945312500, -0.0051269531250000,
-0.0072937011718750, -0.0058593750000000, -0.0075073242187500, -0.0051879882812500,
-0.0075073242187500, -0.0061950683593750, -0.0071411132812500, -0.0076904296875000,
-0.0073547363281250, -0.0066223144531250, -0.0071716308593750, -0.0081176757812500,
-0.0072631835937500, -0.0084533691406250, -0.0071105957031250, -0.0083923339843750,
-0.0068664550781250, -0.0086669921875000, -0.0071411132812500, -0.0084533691406250,
-0.0070190429687500, -0.0090942382812500, -0.0068664550781250, -0.0091857910156250,
-0.0075073242187500, -0.0085144042968750, -0.0080261230468750, -0.0085754394531250,
-0.0079040527343750, -0.0090026855468750, -0.0092163085937500, -0.0072326660156250,
-0.0090942382812500, -0.0074157714843750, -0.0100097656250000, -0.0072021484375000,
-0.0115356445312500, -0.0061340332031250, -0.0115356445312500, -0.0066833496093750,
-0.0137329101562500, -0.0064086914062500, -0.0138244628906250, -0.0059204101562500,
-0.0143127441406250, -0.0072021484375000, -0.0159606933593750, -0.0082092285156250,
-0.0153503417968750, -0.0071105957031250, -0.0144042968750000, -0.0086975097656250,
-0.0158691406250000, -0.0099182128906250, -0.0137939453125000, -0.0075378417968750,
-0.0115966796875000, -0.0061950683593750, -0.0131530761718750, -0.0080566406250000,
-0.0059204101562500, -0.0033264160156250, -0.0069885253906250, -0.0028076171875000,
-0.0046997070312500, -0.0040588378906250, 0.0011291503906250, -0.0022888183593750,
-0.0012512207031250, -0.0019226074218750, 0.0040283203125000, -0.0061645507812500,
0.0047912597656250, -0.0050048828125000, 0.0048217773437500, -0.0066528320312500,
0.0068359375000000, -0.0103454589843750, 0.0064086914062500, -0.0081787109375000,
0.0083618164062500, -0.0119934082031250, 0.0078735351562500, -0.0128479003906250,
0.0086364746093750, -0.0108947753906250, 0.0101623535156250, -0.0111389160156250,
0.0091552734375000, -0.0119323730468750, 0.0120849609375000, -0.0082092285156250,
0.0110778808593750, -0.0097656250000000, 0.0126647949218750, -0.0063781738281250,
0.0160827636718750, -0.0016174316406250, 0.0142211914062500, -0.0051574707031250,
0.0162048339843750, 0.0015563964843750, 0.0179748535156250, 0.0022888183593750,
0.0154418945312500, 0.0011901855468750, 0.0138854980468750, 0.0041198730468750,
0.0152893066406250, 0.0041503906250000, 0.0089416503906250, 0.0002746582031250,
0.0101623535156250, 0.0014648437500000, 0.0071411132812500, 0.0003662109375000,
0.0010986328125000, -0.0032653808593750, 0.0039978027343750, -0.0016784667968750,
-0.0021972656250000, -0.0018615722656250, -0.0027160644531250, -0.0028991699218750,
-0.0025939941406250, -0.0023498535156250, -0.0051574707031250, -0.0014953613281250,
-0.0042114257812500, -0.0017700195312500, -0.0060119628906250, -0.0009460449218750,
-0.0065612792968750, -0.0010070800781250, -0.0047912597656250, -0.0007629394531250,
-0.0049743652343750, -0.0004577636718750, -0.0060119628906250, -0.0008850097656250,
0.0007934570312500, 0.0011291503906250, -0.0007019042968750, 0.0007629394531250,
0.0007019042968750, 0.0011901855468750, 0.0069274902343750, 0.0030517578125000,
0.0060119628906250, 0.0032043457031250, 0.0076293945312500, 0.0050354003906250,
0.0081787109375000, 0.0040283203125000, 0.0066833496093750, 0.0052490234375000,
0.0066223144531250, 0.0077819824218750, 0.0076904296875000, 0.0061035156250000,
0.0043640136718750, 0.0071411132812500, 0.0051574707031250, 0.0090332031250000,
0.0038452148437500, 0.0062561035156250, 0.0013732910156250, 0.0039367675781250,
0.0033874511718750, 0.0058898925781250, -0.0012207031250000, -0.0001831054687500,
-0.0013122558593750, -0.0002136230468750, -0.0004882812500000, -0.0001220703125000,
-0.0024719238281250, -0.0028076171875000, -0.0024414062500000, -0.0022277832031250,
-0.0015258789062500, -0.0043334960937500, -0.0018615722656250, -0.0037231445312500,
-0.0010681152343750, -0.0042114257812500, 0.0001831054687500, -0.0068054199218750,
-0.0004882812500000, -0.0060424804687500, 0.0002441406250000, -0.0047302246093750,
0.0009155273437500, -0.0070800781250000, 0.0004272460937500, -0.0027770996093750,
-0.0003051757812500, 0.0013427734375000, 0.0001220703125000, -0.0024414062500000,
0.0018615722656250, 0.0093688964843750, 0.0007629394531250, 0.0080566406250000,
0.0016784667968750, 0.0098876953125000, 0.0041809082031250, 0.0182495117187500,
0.0029296875000000, 0.0148925781250000, 0.0025024414062500, 0.0172424316406250,
0.0040893554687500, 0.0191955566406250, 0.0017395019531250, 0.0168457031250000,
-0.0005493164062500, 0.0155334472656250, 0.0018005371093750, 0.0166625976562500,
-0.0032348632812500, 0.0123291015625000, -0.0025634765625000, 0.0122375488281250,
-0.0034790039062500, 0.0119323730468750, -0.0065917968750000, 0.0095214843750000,
-0.0043029785156250, 0.0097961425781250, -0.0081787109375000, 0.0086975097656250,
-0.0080871582031250, 0.0090942382812500, -0.0080566406250000, 0.0072326660156250,
-0.0100097656250000, 0.0054931640625000, -0.0092773437500000, 0.0066833496093750,
-0.0109558105468750, 0.0009765625000000, -0.0116271972656250, 0.0017700195312500,
-0.0106811523437500, -0.0000610351562500, -0.0111389160156250, -0.0047912597656250,
-0.0122680664062500, -0.0029907226562500, -0.0086975097656250, -0.0063171386718750,
-0.0099487304687500, -0.0072937011718750, -0.0083923339843750, -0.0066223144531250,
-0.0048828125000000, -0.0071716308593750, -0.0070495605468750, -0.0071411132812500,
-0.0034484863281250, -0.0059204101562500, -0.0033264160156250, -0.0061340332031250,
-0.0032043457031250, -0.0053710937500000, -0.0013122558593750, -0.0042114257812500,
-0.0021972656250000, -0.0049743652343750, -0.0020141601562500, -0.0039672851562500,
-0.0014038085937500, -0.0036315917968750, -0.0020446777343750, -0.0039672851562500,
-0.0028686523437500, -0.0036926269531250, -0.0024414062500000, -0.0035400390625000,
-0.0024108886718750, -0.0046997070312500, -0.0030822753906250, -0.0044555664062500,
-0.0025024414062500, -0.0048828125000000, -0.0016784667968750, -0.0057983398437500,
-0.0022583007812500, -0.0054321289062500, -0.0021057128906250, -0.0066528320312500,
-0.0014038085937500, -0.0065002441406250, -0.0024719238281250, -0.0065307617187500,
-0.0034484863281250, -0.0070800781250000, -0.0024719238281250, -0.0066833496093750,
-0.0048217773437500, -0.0072021484375000, -0.0046386718750000, -0.0066833496093750,
-0.0047607421875000, -0.0061645507812500, -0.0059814453125000, -0.0058288574218750,
-0.0054626464843750, -0.0051574707031250, -0.0066833496093750, -0.0056152343750000,
-0.0064086914062500, -0.0046997070312500, -0.0066833496093750, -0.0046386718750000,
-0.0077514648437500, -0.0049743652343750, -0.0072021484375000, -0.0037231445312500,
-0.0076904296875000, -0.0045471191406250, -0.0079956054687500, -0.0036621093750000,
-0.0076904296875000, -0.0036621093750000, -0.0075073242187500, -0.0044250488281250,
-0.0077209472656250, -0.0033264160156250, -0.0072326660156250, -0.0045471191406250,
-0.0072326660156250, -0.0039672851562500, -0.0069580078125000, -0.0040893554687500,
-0.0065307617187500, -0.0048828125000000, -0.0067443847656250, -0.0039062500000000,
-0.0060119628906250, -0.0052185058593750, -0.0060424804687500, -0.0044250488281250,
-0.0058898925781250, -0.0048828125000000, -0.0054016113281250, -0.0061950683593750,
-0.0055847167968750, -0.0049133300781250, -0.0052795410156250, -0.0070800781250000,
-0.0052490234375000, -0.0067749023437500, -0.0052185058593750, -0.0071411132812500,
-0.0050659179687500, -0.0085449218750000, -0.0051574707031250, -0.0077209472656250,
-0.0042114257812500, -0.0093078613281250, -0.0047302246093750, -0.0093688964843750,
-0.0036010742187500, -0.0087585449218750, -0.0020751953125000, -0.0094909667968750,
-0.0029602050781250, -0.0094909667968750, -0.0005798339843750, -0.0073852539062500,
-0.0002441406250000, -0.0087585449218750, -0.0004577636718750, -0.0070800781250000,
0.0005187988281250, -0.0045166015625000, 0.0004577636718750, -0.0065002441406250,
-0.0004577636718750, -0.0011291503906250, 0.0001220703125000, -0.0020141601562500,
-0.0007629394531250, -0.0003356933593750, -0.0018310546875000, 0.0037841796875000,
-0.0009460449218750, 0.0014648437500000, -0.0039978027343750, 0.0062561035156250,
-0.0033569335937500, 0.0061340332031250, -0.0042724609375000, 0.0058288574218750,
-0.0068664550781250, 0.0081176757812500, -0.0056152343750000, 0.0072631835937500,
-0.0074462890625000, 0.0075073242187500, -0.0077819824218750, 0.0076904296875000,
-0.0077819824218750, 0.0074157714843750, -0.0084533691406250, 0.0071105957031250,
-0.0081787109375000, 0.0074157714843750, -0.0085754394531250, 0.0079650878906250,
-0.0088195800781250, 0.0068969726562500, -0.0084228515625000, 0.0087280273437500,
-0.0082702636718750, 0.0107727050781250, -0.0085754394531250, 0.0092773437500000,
-0.0076293945312500, 0.0137023925781250, -0.0078735351562500, 0.0138549804687500,
-0.0068969726562500, 0.0140075683593750, -0.0056152343750000, 0.0162963867187500,
-0.0064392089843750},
{-0.0022583007812500, -0.0025024414062500, -0.0040893554687500, -0.0024414062500000,
-0.0018005371093750, -0.0017395019531250, -0.0016174316406250, -0.0018310546875000,
-0.0018920898437500, -0.0007934570312500, -0.0007934570312500, 0.0004577636718750,
-0.0010070800781250, 0.0002136230468750, -0.0013732910156250, 0.0030212402343750,
-0.0011901855468750, 0.0031738281250000, -0.0010681152343750, 0.0040893554687500,
-0.0014343261718750, 0.0062255859375000, -0.0014648437500000, 0.0060424804687500,
-0.0009155273437500, 0.0078735351562500, -0.0009460449218750, 0.0085449218750000,
-0.0014038085937500, 0.0090026855468750, -0.0012512207031250, 0.0101928710937500,
-0.0010681152343750, 0.0106201171875000, -0.0033874511718750, 0.0109558105468750,
-0.0026245117187500, 0.0118408203125000, -0.0035705566406250, 0.0118103027343750,
-0.0058288574218750, 0.0115661621093750, -0.0046386718750000, 0.0121765136718750,
-0.0064392089843750, 0.0110168457031250, -0.0065917968750000, 0.0113220214843750,
-0.0066528320312500, 0.0108947753906250, -0.0075073242187500, 0.0100708007812500,
-0.0070495605468750, 0.0108032226562500, -0.0075683593750000, 0.0093383789062500,
-0.0077209472656250, 0.0091857910156250, -0.0071105957031250, 0.0094299316406250,
-0.0068969726562500, 0.0089721679687500, -0.0072021484375000, 0.0090332031250000,
-0.0061035156250000, 0.0091247558593750, -0.0061035156250000, 0.0090026855468750,
-0.0061645507812500, 0.0092163085937500, -0.0056762695312500, 0.0093994140625000,
-0.0057067871093750, 0.0093078613281250, -0.0058593750000000, 0.0102233886718750,
-0.0058593750000000, 0.0099182128906250, -0.0057373046875000, 0.0101623535156250,
-0.0058593750000000, 0.0110473632812500, -0.0059204101562500, 0.0105285644531250,
-0.0049743652343750, 0.0110473632812500, -0.0054626464843750, 0.0110168457031250,
-0.0045166015625000, 0.0106201171875000, -0.0032958984375000, 0.0108337402343750,
-0.0041503906250000, 0.0105590820312500, -0.0020141601562500, 0.0091552734375000,
-0.0019226074218750, 0.0099792480468750, -0.0020446777343750, 0.0083007812500000,
-0.0010070800781250, 0.0065307617187500, -0.0011596679687500, 0.0079956054687500,
-0.0018005371093750, 0.0021057128906250, -0.0015258789062500, 0.0038757324218750,
-0.0019836425781250, 0.0015258789062500, -0.0027160644531250, -0.0036315917968750,
-0.0022888183593750, -0.0004577636718750, -0.0036926269531250, -0.0068359375000000,
-0.0032348632812500, -0.0066833496093750, -0.0038146972656250, -0.0073547363281250,
-0.0053100585937500, -0.0112304687500000, -0.0043945312500000, -0.0093688964843750,
-0.0051879882812500, -0.0104064941406250, -0.0057678222656250, -0.0115661621093750,
-0.0049133300781250, -0.0092163085937500, -0.0044250488281250, -0.0079345703125000,
-0.0049743652343750, -0.0094299316406250, -0.0042419433593750, -0.0034790039062500,
-0.0037841796875000, -0.0048828125000000, -0.0043334960937500, -0.0024414062500000,
-0.0045776367187500, 0.0027465820312500, -0.0042724609375000, -0.0002746582031250,
-0.0053405761718750, 0.0054626464843750, -0.0050659179687500, 0.0055847167968750,
-0.0059509277343750, 0.0058898925781250, -0.0070190429687500, 0.0087280273437500,
-0.0061035156250000, 0.0073547363281250, -0.0083923339843750, 0.0092163085937500,
-0.0083923339843750, 0.0093078613281250, -0.0083618164062500, 0.0088806152343750,
-0.0094909667968750, 0.0096130371093750, -0.0092163085937500, 0.0096435546875000,
-0.0083923339843750, 0.0096435546875000, -0.0093383789062500, 0.0090942382812500,
-0.0074462890625000, 0.0104064941406250, -0.0057983398437500, 0.0113525390625000,
-0.0072021484375000, 0.0101318359375000, -0.0006713867187500, 0.0138854980468750,
-0.0022583007812500, 0.0137634277343750, 0.0007629394531250, 0.0136108398437500,
0.0071411132812500, 0.0156860351562500, 0.0038452148437500, 0.0150451660156250,
0.0096130371093750, 0.0135803222656250, 0.0108337402343750, 0.0139770507812500,
0.0092468261718750, 0.0139770507812500, 0.0110778808593750, 0.0128479003906250,
0.0115661621093750, 0.0130310058593750, 0.0063781738281250, 0.0141601562500000,
0.0074768066406250, 0.0135192871093750, 0.0062561035156250, 0.0149841308593750,
0.0022583007812500, 0.0172119140625000, 0.0042419433593750, 0.0160217285156250,
0.0019531250000000, 0.0171813964843750, 0.0007019042968750, 0.0191955566406250,
0.0027160644531250, 0.0143432617187500, 0.0037536621093750, 0.0119934082031250,
0.0024414062500000, 0.0155334472656250, 0.0047302246093750, -0.0010681152343750,
0.0047607421875000, 0.0014038085937500, 0.0046386718750000, -0.0030517578125000,
0.0056762695312500, -0.0166931152343750, 0.0052490234375000, -0.0108642578125000,
0.0049133300781250, -0.0158081054687500, 0.0051574707031250, -0.0196838378906250,
0.0045471191406250, -0.0153503417968750, 0.0034790039062500, -0.0127868652343750,
0.0041198730468750, -0.0154418945312500, 0.0054626464843750, -0.0083618164062500,
0.0040588378906250, -0.0078430175781250, 0.0052490234375000, -0.0081787109375000,
0.0093994140625000, -0.0036315917968750, 0.0068359375000000, -0.0161743164062500,
-0.0043640136718750, -0.0116882324218750, 0.0005798339843750, -0.0134582519531250,
-0.0028991699218750, -0.0107727050781250, -0.0099487304687500, -0.0081481933593750,
-0.0072021484375000, -0.0098876953125000, -0.0119323730468750, -0.0017395019531250,
-0.0122375488281250, -0.0031127929687500, -0.0122680664062500, -0.0012817382812500,
-0.0148620605468750, 0.0057373046875000, -0.0138854980468750, 0.0032043457031250,
-0.0129394531250000, 0.0030212402343750, -0.0155639648437500, 0.0051269531250000,
-0.0096740722656250, 0.0037536621093750, -0.0050354003906250, 0.0007019042968750,
-0.0094909667968750, 0.0016784667968750, 0.0078430175781250, 0.0039978027343750,
0.0052795410156250, 0.0022583007812500, 0.0082702636718750, 0.0039978027343750,
0.0219116210937500, 0.0076293945312500, 0.0168151855468750, 0.0059509277343750,
0.0178833007812500, 0.0078125000000000, 0.0216064453125000, 0.0089721679687500,
0.0181274414062500, 0.0063781738281250, 0.0140686035156250, 0.0049438476562500,
0.0168151855468750, 0.0068969726562500, 0.0126037597656250, 0.0034179687500000,
0.0113525390625000, 0.0018310546875000, 0.0127868652343750, 0.0040588378906250,
0.0120544433593750, 0.0049743652343750, 0.0114746093750000, 0.0037231445312500,
0.0149841308593750, 0.0071411132812500, 0.0139465332031250, 0.0073242187500000,
0.0149230957031250, 0.0072631835937500, 0.0180358886718750, 0.0091857910156250,
0.0166931152343750, 0.0087890625000000, 0.0190429687500000, 0.0064697265625000,
0.0188903808593750, 0.0077819824218750, 0.0187683105468750, 0.0057373046875000,
0.0202026367187500, 0.0030517578125000, 0.0194396972656250, 0.0046691894531250,
0.0178833007812500, -0.0025939941406250, 0.0193481445312500, -0.0009765625000000,
0.0170288085937500, -0.0033874511718750, 0.0142517089843750, -0.0100708007812500,
0.0158996582031250, -0.0070495605468750, 0.0087280273437500, -0.0103149414062500,
0.0108337402343750, -0.0119323730468750, 0.0064392089843750, -0.0097961425781250,
-0.0007019042968750, -0.0092163085937500, 0.0042114257812500, -0.0102233886718750,
-0.0068664550781250, -0.0063781738281250, -0.0059814453125000, -0.0065002441406250,
-0.0072326660156250, -0.0063781738281250, -0.0140991210937500, -0.0043334960937500,
-0.0110168457031250, -0.0048828125000000, -0.0150146484375000, -0.0043640136718750,
-0.0155639648437500, -0.0043334960937500, -0.0145568847656250, -0.0041503906250000,
-0.0161437988281250, -0.0036010742187500, -0.0158386230468750, -0.0039978027343750,
-0.0125427246093750, -0.0041198730468750, -0.0141906738281250, -0.0037841796875000,
-0.0115661621093750, -0.0040893554687500, -0.0074768066406250, -0.0046997070312500,
-0.0100708007812500, -0.0044555664062500, -0.0041198730468750, -0.0037841796875000,
-0.0047302246093750, -0.0041809082031250, -0.0038757324218750, -0.0036926269531250,
0.0001831054687500, -0.0027465820312500, -0.0017089843750000, -0.0030822753906250,
0.0012512207031250, -0.0024719238281250, 0.0014648437500000, -0.0025024414062500,
0.0015258789062500, -0.0019226074218750, 0.0032348632812500, -0.0013122558593750,
0.0031127929687500, -0.0018005371093750, 0.0032043457031250, -0.0000610351562500,
0.0037841796875000, 0.0001220703125000, 0.0033264160156250, -0.0002746582031250,
0.0031127929687500, 0.0004577636718750, 0.0037841796875000, 0.0005493164062500,
0.0013732910156250, -0.0009460449218750, 0.0026855468750000, -0.0006103515625000,
0.0018310546875000, -0.0011596679687500, -0.0003662109375000, -0.0024414062500000,
0.0015563964843750, -0.0019226074218750, -0.0013122558593750, -0.0029602050781250,
-0.0009155273437500, -0.0029602050781250, -0.0011596679687500, -0.0031127929687500,
-0.0026855468750000, -0.0037231445312500, -0.0013122558593750, -0.0034179687500000,
-0.0031738281250000, -0.0040893554687500, -0.0028076171875000, -0.0039367675781250,
-0.0025634765625000, -0.0042419433593750, -0.0033874511718750, -0.0047912597656250,
-0.0026550292968750, -0.0043334960937500, -0.0031433105468750, -0.0051879882812500,
-0.0030822753906250, -0.0050659179687500, -0.0028076171875000, -0.0053100585937500,
-0.0028686523437500, -0.0058898925781250, -0.0023803710937500, -0.0055541992187500,
-0.0019226074218750, -0.0066833496093750, -0.0018005371093750, -0.0066223144531250,
-0.0009765625000000, -0.0064697265625000, -0.0002746582031250, -0.0071105957031250,
-0.0001220703125000, -0.0070495605468750, 0.0017700195312500, -0.0065307617187500,
0.0014648437500000, -0.0065307617187500, 0.0028076171875000, -0.0070190429687500,
0.0046386718750000, -0.0071716308593750, 0.0038146972656250, -0.0066223144531250,
0.0076293945312500, -0.0072937011718750, 0.0073547363281250, -0.0079040527343750,
0.0087585449218750, -0.0065307617187500, 0.0116271972656250, -0.0057373046875000,
0.0101928710937500, -0.0068054199218750, 0.0135498046875000, -0.0039367675781250,
0.0135498046875000, -0.0040588378906250, 0.0134277343750000, -0.0039978027343750,
0.0154113769531250, -0.0023193359375000, 0.0149536132812500, -0.0030822753906250,
0.0133666992187500, -0.0033874511718750, 0.0144348144531250, -0.0024108886718750,
0.0126953125000000, -0.0042114257812500, 0.0104370117187500, -0.0060729980468750,
0.0120849609375000, -0.0045166015625000, 0.0075073242187500, -0.0072937011718750,
0.0080871582031250, -0.0079345703125000, 0.0067749023437500, -0.0070495605468750,
0.0031738281250000, -0.0073547363281250, 0.0047912597656250, -0.0076904296875000,
0.0015869140625000, -0.0072631835937500, 0.0014648437500000, -0.0067749023437500,
0.0014038085937500, -0.0074768066406250, -0.0000915527343750, -0.0079650878906250,
0.0006408691406250, -0.0074462890625000, -0.0005798339843750, -0.0092468261718750,
-0.0004577636718750, -0.0093994140625000, -0.0011291503906250, -0.0089416503906250,
-0.0020141601562500, -0.0095825195312500, -0.0012817382812500, -0.0097656250000000,
-0.0040588378906250, -0.0090332031250000, -0.0035705566406250, -0.0094299316406250,
-0.0045166015625000, -0.0081787109375000, -0.0069885253906250, -0.0068359375000000,
-0.0060424804687500, -0.0079650878906250, -0.0075378417968750, -0.0061950683593750,
-0.0080871582031250, -0.0058898925781250, -0.0070190429687500, -0.0050048828125000,
-0.0072021484375000, -0.0039062500000000, -0.0075683593750000, -0.0051879882812500,
-0.0026550292968750, -0.0029602050781250, -0.0038452148437500, -0.0026245117187500,
-0.0017089843750000, -0.0024719238281250, 0.0030517578125000, -0.0015563964843750,
0.0009155273437500, -0.0020751953125000, 0.0045471191406250, -0.0016479492187500,
0.0051879882812500},
{-0.0054321289062500, -0.0034484863281250, -0.0056152343750000, -0.0035400390625000,
-0.0053100585937500, -0.0030212402343750, -0.0054931640625000, -0.0024108886718750,
-0.0056457519531250, -0.0028381347656250, -0.0044860839843750, -0.0018310546875000,
-0.0051879882812500, -0.0015258789062500, -0.0044555664062500, -0.0018615722656250,
-0.0031738281250000, -0.0017089843750000, -0.0044250488281250, -0.0015258789062500,
-0.0027770996093750, -0.0023803710937500, -0.0026855468750000, -0.0021362304687500,
-0.0027465820312500, -0.0027160644531250, -0.0023498535156250, -0.0035095214843750,
-0.0031738281250000, -0.0029602050781250, -0.0023803710937500, -0.0047607421875000,
-0.0028686523437500, -0.0045471191406250, -0.0026245117187500, -0.0048217773437500,
-0.0019836425781250, -0.0061035156250000, -0.0030517578125000, -0.0055847167968750,
-0.0020446777343750, -0.0061950683593750, -0.0026550292968750, -0.0063781738281250,
-0.0027160644531250, -0.0061645507812500, -0.0020446777343750, -0.0062866210937500,
-0.0028686523437500, -0.0062866210937500, -0.0023498535156250, -0.0057983398437500,
-0.0028991699218750, -0.0058593750000000, -0.0029602050781250, -0.0059509277343750,
-0.0025939941406250, -0.0055236816406250, -0.0033874511718750, -0.0055847167968750,
-0.0028991699218750, -0.0065612792968750, -0.0029602050781250, -0.0062866210937500,
-0.0030822753906250, -0.0061340332031250, -0.0031433105468750, -0.0069274902343750,
-0.0034484863281250, -0.0069274902343750, -0.0026550292968750, -0.0053710937500000,
-0.0032348632812500, -0.0061340332031250, -0.0026550292968750, -0.0052185058593750,
-0.0016784667968750, -0.0035095214843750, -0.0023498535156250, -0.0046386718750000,
-0.0000915527343750, -0.0025024414062500, -0.0007934570312500, -0.0023193359375000,
0.0007629394531250, -0.0030822753906250, 0.0032348632812500, -0.0021057128906250,
0.0018920898437500, -0.0019531250000000, 0.0063476562500000, -0.0050048828125000,
0.0059814453125000, -0.0039672851562500, 0.0073547363281250, -0.0050964355468750,
0.0110168457031250, -0.0080871582031250, 0.0099182128906250, -0.0066223144531250,
0.0132751464843750, -0.0084838867187500, 0.0135803222656250, -0.0088500976562500,
0.0132751464843750, -0.0084838867187500, 0.0147094726562500, -0.0090942382812500,
0.0143127441406250, -0.0090332031250000, 0.0125122070312500, -0.0078430175781250,
0.0134582519531250, -0.0083618164062500, 0.0117797851562500, -0.0080566406250000,
0.0094604492187500, -0.0070495605468750, 0.0108642578125000, -0.0075683593750000,
0.0060119628906250, -0.0065612792968750, 0.0062255859375000, -0.0066833496093750,
0.0055847167968750, -0.0069580078125000, 0.0024108886718750, -0.0065307617187500,
0.0034179687500000, -0.0063781738281250, 0.0022888183593750, -0.0059509277343750,
0.0017700195312500, -0.0062866210937500, 0.0016479492187500, -0.0061645507812500,
0.0014038085937500, -0.0056152343750000, 0.0014038085937500, -0.0054931640625000,
-0.0000915527343750, -0.0046081542968750, 0.0004577636718750, -0.0054016113281250,
-0.0008239746093750, -0.0046386718750000, -0.0027160644531250, -0.0029602050781250,
-0.0013732910156250, -0.0036010742187500, -0.0041503906250000, -0.0021362304687500,
-0.0046081542968750, -0.0022277832031250, -0.0038146972656250, -0.0025329589843750,
-0.0049133300781250, -0.0016784667968750, -0.0051879882812500, -0.0016479492187500,
-0.0017395019531250, -0.0024414062500000, -0.0030212402343750, -0.0026550292968750,
-0.0011596679687500, -0.0016479492187500, 0.0024719238281250, -0.0017089843750000,
0.0004577636718750, -0.0024719238281250, 0.0048828125000000, 0.0021667480468750,
0.0051574707031250, 0.0015869140625000, 0.0050659179687500, 0.0019836425781250,
0.0072631835937500, 0.0048828125000000, 0.0068054199218750, 0.0038757324218750,
0.0063476562500000, 0.0046691894531250, 0.0061340332031250, 0.0053405761718750,
0.0076293945312500, 0.0050659179687500, 0.0081481933593750, 0.0044250488281250,
0.0068664550781250, 0.0046081542968750, 0.0113220214843750, 0.0068054199218750,
0.0113830566406250, 0.0056152343750000, 0.0108947753906250, 0.0068664550781250,
0.0132141113281250, 0.0101928710937500, 0.0128479003906250, 0.0085449218750000,
0.0096130371093750, 0.0074157714843750, 0.0114440917968750, 0.0098266601562500,
0.0090332031250000, 0.0066833496093750, 0.0041198730468750, 0.0012817382812500,
0.0047607421875000, 0.0020751953125000, -0.0010375976562500, -0.0019226074218750,
0.0004882812500000, -0.0020446777343750, 0.0003051757812500, -0.0007324218750000,
-0.0037841796875000, -0.0021362304687500, -0.0020141601562500, -0.0025329589843750,
-0.0024108886718750, 0.0007934570312500, -0.0042724609375000, -0.0003662109375000,
-0.0018615722656250, 0.0017089843750000, 0.0003051757812500, 0.0049133300781250,
-0.0018920898437500, 0.0026855468750000, 0.0031433105468750, 0.0093078613281250,
0.0028991699218750, 0.0090026855468750, 0.0034790039062500, 0.0088806152343750,
0.0062866210937500, 0.0128479003906250, 0.0047912597656250, 0.0119628906250000,
0.0068054199218750, 0.0105590820312500, 0.0068054199218750, 0.0115661621093750,
0.0076904296875000, 0.0103759765625000, 0.0093688964843750, 0.0084228515625000,
0.0079040527343750, 0.0095520019531250, 0.0086364746093750, 0.0075683593750000,
0.0106506347656250, 0.0073242187500000, 0.0070800781250000, 0.0072631835937500,
0.0043640136718750, 0.0067749023437500, 0.0074157714843750, 0.0068969726562500,
-0.0006103515625000, 0.0037536621093750, -0.0000610351562500, 0.0053710937500000,
-0.0005798339843750, 0.0027465820312500, -0.0052795410156250, -0.0018005371093750,
-0.0033569335937500, 0.0006713867187500, -0.0052795410156250, -0.0035705566406250,
-0.0058288574218750, -0.0048522949218750, -0.0053100585937500, -0.0035095214843750,
-0.0057067871093750, -0.0040283203125000, -0.0057678222656250, -0.0043640136718750,
-0.0058593750000000, -0.0018005371093750, -0.0057678222656250, -0.0024108886718750,
-0.0055236816406250, -0.0010681152343750, -0.0057067871093750, 0.0016174316406250,
-0.0058898925781250, 0.0003662109375000, -0.0043640136718750, 0.0018920898437500,
-0.0052795410156250, 0.0024719238281250, -0.0037231445312500, 0.0024414062500000,
-0.0013427734375000, 0.0024719238281250, -0.0032653808593750, 0.0025024414062500,
-0.0015258789062500, 0.0047607421875000, -0.0005798339843750, 0.0038757324218750,
-0.0016479492187500, 0.0059204101562500, -0.0015869140625000, 0.0089416503906250,
-0.0013427734375000, 0.0075378417968750, -0.0056762695312500, 0.0120239257812500,
-0.0032653808593750, 0.0125122070312500, -0.0059509277343750, 0.0126037597656250,
-0.0112915039062500, 0.0148010253906250, -0.0078125000000000, 0.0140686035156250,
-0.0126342773437500, 0.0128479003906250, -0.0134582519531250, 0.0136413574218750,
-0.0118713378906250, 0.0117492675781250, -0.0134887695312500, 0.0094909667968750,
-0.0136108398437500, 0.0104980468750000, -0.0085754394531250, 0.0060729980468750,
-0.0106811523437500, 0.0061340332031250, -0.0084533691406250, 0.0045471191406250,
-0.0033264160156250, 0.0008544921875000, -0.0063781738281250, 0.0016479492187500,
-0.0018310546875000, -0.0009155273437500, -0.0015258789062500, -0.0017089843750000,
-0.0019836425781250, -0.0018615722656250, -0.0000610351562500, -0.0028991699218750,
-0.0006408691406250, -0.0031433105468750, -0.0010375976562500, -0.0034790039062500,
-0.0005493164062500, -0.0037231445312500, -0.0010681152343750, -0.0039367675781250,
-0.0018920898437500, -0.0041503906250000, -0.0014343261718750, -0.0039978027343750,
-0.0021057128906250, -0.0038757324218750, -0.0021667480468750, -0.0039367675781250,
-0.0022277832031250, -0.0038452148437500, -0.0023803710937500, -0.0037841796875000,
-0.0022277832031250, -0.0038452148437500, -0.0029907226562500, -0.0034179687500000,
-0.0026245117187500, -0.0033874511718750, -0.0031433105468750, -0.0034484863281250,
-0.0040588378906250, -0.0034179687500000, -0.0034484863281250, -0.0036010742187500,
-0.0046997070312500, -0.0038757324218750, -0.0046386718750000, -0.0037841796875000,
-0.0048522949218750, -0.0039062500000000, -0.0056762695312500, -0.0041809082031250,
-0.0053100585937500, -0.0039978027343750, -0.0061340332031250, -0.0038757324218750,
-0.0062561035156250, -0.0038757324218750, -0.0059814453125000, -0.0036621093750000,
-0.0062561035156250, -0.0034790039062500, -0.0064392089843750, -0.0036315917968750,
-0.0055541992187500, -0.0039062500000000, -0.0058898925781250, -0.0036621093750000,
-0.0057678222656250, -0.0035095214843750, -0.0050048828125000, -0.0037536621093750,
-0.0053710937500000, -0.0036010742187500, -0.0053100585937500, -0.0030517578125000,
-0.0051269531250000, -0.0032958984375000, -0.0054016113281250, -0.0032043457031250,
-0.0057678222656250, -0.0026550292968750, -0.0056457519531250, -0.0029907226562500,
-0.0054931640625000, -0.0032043457031250, -0.0058593750000000, -0.0026855468750000,
-0.0052795410156250, -0.0032958984375000, -0.0046691894531250, -0.0040588378906250,
-0.0050354003906250, -0.0034179687500000, -0.0034790039062500, -0.0047607421875000,
-0.0038757324218750, -0.0047912597656250, -0.0026245117187500, -0.0044555664062500,
-0.0010375976562500, -0.0052185058593750, -0.0021362304687500, -0.0052795410156250,
0.0016174316406250, -0.0037841796875000, 0.0015563964843750, -0.0047607421875000,
0.0014038085937500, -0.0028991699218750, 0.0036010742187500, -0.0008544921875000,
0.0031433105468750, -0.0028381347656250, 0.0010986328125000, 0.0028381347656250,
0.0024108886718750, 0.0013122558593750, 0.0004577636718750, 0.0030822753906250,
-0.0024108886718750, 0.0080566406250000, -0.0006713867187500, 0.0052795410156250,
-0.0056457519531250, 0.0094299316406250, -0.0050048828125000, 0.0103454589843750,
-0.0063781738281250, 0.0083312988281250, -0.0103149414062500, 0.0093994140625000,
-0.0083007812500000, 0.0102539062500000, -0.0103454589843750, 0.0034484863281250,
-0.0117187500000000, 0.0058288574218750, -0.0091857910156250, 0.0021362304687500,
-0.0080261230468750, -0.0050659179687500, -0.0097045898437500, -0.0011596679687500,
-0.0041198730468750, -0.0094299316406250, -0.0045166015625000, -0.0102844238281250,
-0.0034790039062500, -0.0086669921875000, 0.0002136230468750, -0.0121765136718750,
-0.0012512207031250, -0.0120849609375000, 0.0016479492187500, -0.0058288574218750,
0.0016479492187500, -0.0083923339843750, 0.0018005371093750, -0.0048217773437500,
0.0037841796875000, 0.0021362304687500, 0.0031738281250000, -0.0015869140625000,
0.0019836425781250, 0.0055236816406250, 0.0034179687500000, 0.0057067871093750,
0.0014038085937500, 0.0056152343750000, -0.0012207031250000, 0.0089721679687500,
0.0006713867187500, 0.0075988769531250, -0.0044555664062500, 0.0087890625000000,
-0.0051269531250000, 0.0091857910156250, -0.0029907226562500, 0.0081787109375000,
-0.0044250488281250, 0.0080261230468750, -0.0056152343750000, 0.0086975097656250,
0.0005798339843750, 0.0075378417968750, -0.0002136230468750, 0.0063781738281250,
0.0011291503906250, 0.0080261230468750, 0.0058288574218750, 0.0095825195312500,
0.0037536621093750, 0.0082092285156250, 0.0039672851562500, 0.0095825195312500,
0.0052490234375000, 0.0102233886718750, 0.0051574707031250, 0.0093383789062500,
0.0036621093750000, 0.0087890625000000, 0.0035095214843750, 0.0092773437500000,
0.0068359375000000, 0.0089721679687500, 0.0055847167968750, 0.0081481933593750,
0.0072326660156250, 0.0096130371093750, 0.0113525390625000, 0.0108032226562500,
0.0093383789062500, 0.0095825195312500, 0.0090942382812500, 0.0131835937500000,
0.0116882324218750, 0.0137023925781250, 0.0076599121093750, 0.0122375488281250,
0.0036010742187500},
{-0.0059814453125000, -0.0038146972656250, -0.0064086914062500, -0.0048217773437500,
-0.0061950683593750, -0.0042419433593750, -0.0061340332031250, -0.0050964355468750,
-0.0062561035156250, -0.0048217773437500, -0.0061950683593750, -0.0051574707031250,
-0.0060424804687500, -0.0058898925781250, -0.0060729980468750, -0.0051269531250000,
-0.0057983398437500, -0.0060729980468750, -0.0061035156250000, -0.0060729980468750,
-0.0054321289062500, -0.0058898925781250, -0.0048217773437500, -0.0064086914062500,
-0.0053100585937500, -0.0061645507812500, -0.0033569335937500, -0.0047607421875000,
-0.0036926269531250, -0.0053100585937500, -0.0027465820312500, -0.0046691894531250,
-0.0011901855468750, -0.0032348632812500, -0.0020446777343750, -0.0039978027343750,
0.0007019042968750, -0.0022583007812500, 0.0005493164062500, -0.0020751953125000,
0.0007019042968750, -0.0022583007812500, 0.0026855468750000, -0.0013732910156250,
0.0019531250000000, -0.0014343261718750, 0.0008239746093750, -0.0027160644531250,
0.0020446777343750, -0.0018005371093750, -0.0000610351562500, -0.0027160644531250,
-0.0025939941406250, -0.0043640136718750, -0.0009765625000000, -0.0031738281250000,
-0.0057678222656250, -0.0062255859375000, -0.0055236816406250, -0.0058593750000000,
-0.0063781738281250, -0.0057678222656250, -0.0096130371093750, -0.0078735351562500,
-0.0080871582031250, -0.0073242187500000, -0.0100708007812500, -0.0059204101562500,
-0.0108642578125000, -0.0077514648437500, -0.0091552734375000, -0.0049438476562500,
-0.0090332031250000, -0.0019531250000000, -0.0098266601562500, -0.0046691894531250,
-0.0048217773437500, 0.0031738281250000, -0.0056457519531250, 0.0022583007812500,
-0.0044250488281250, 0.0035095214843750, -0.0003356933593750, 0.0094299316406250,
-0.0018310546875000, 0.0072326660156250, -0.0002746582031250, 0.0083923339843750,
0.0004577636718750, 0.0107421875000000, -0.0000915527343750, 0.0071411132812500,
-0.0000610351562500, 0.0045776367187500, 0.0000915527343750, 0.0072937011718750,
-0.0007629394531250, -0.0014648437500000, -0.0001220703125000, -0.0007629394531250,
-0.0011901855468750, -0.0019226074218750, -0.0025329589843750, -0.0077819824218750,
-0.0014953613281250, -0.0056152343750000, -0.0042114257812500, -0.0072631835937500,
-0.0041503906250000, -0.0086364746093750, -0.0046081542968750, -0.0066528320312500,
-0.0066833496093750, -0.0061950683593750, -0.0057678222656250, -0.0075683593750000,
-0.0041198730468750, -0.0015563964843750, -0.0058898925781250, -0.0033569335937500,
-0.0039062500000000, -0.0008239746093750, -0.0004272460937500, 0.0051574707031250,
-0.0020446777343750, 0.0018310546875000, 0.0015258789062500, 0.0060119628906250,
0.0014648437500000, 0.0076293945312500, 0.0017089843750000, 0.0067749023437500,
0.0035095214843750, 0.0068664550781250, 0.0029907226562500, 0.0068054199218750,
0.0056457519531250, 0.0078430175781250, 0.0046081542968750, 0.0076904296875000,
0.0056762695312500, 0.0077209472656250, 0.0089111328125000, 0.0081481933593750,
0.0075683593750000, 0.0079956054687500, 0.0080871582031250, 0.0079650878906250,
0.0097045898437500, 0.0083312988281250, 0.0068054199218750, 0.0074768066406250,
0.0047302246093750, 0.0068359375000000, 0.0069274902343750, 0.0075683593750000,
-0.0001525878906250, 0.0051574707031250, -0.0000305175781250, 0.0046691894531250,
-0.0001831054687500, 0.0062561035156250, -0.0040893554687500, 0.0055541992187500,
-0.0031738281250000, 0.0047302246093750, -0.0039978027343750, 0.0115966796875000,
-0.0042114257812500, 0.0105590820312500, -0.0038146972656250, 0.0099792480468750,
-0.0040283203125000, 0.0155944824218750, 0.0087890625000000, 0.0034790039062500,
0.0168457031250000, 0.0129089355468750, 0.0157165527343750, 0.0109558105468750,
0.0143737792968750, 0.0104980468750000, 0.0168457031250000, 0.0142211914062500,
0.0177612304687500, 0.0143737792968750, 0.0108642578125000, 0.0075683593750000,
0.0118103027343750, 0.0095520019531250, 0.0114135742187500, 0.0075988769531250,
0.0066223144531250, 0.0015258789062500, 0.0079040527343750, 0.0038757324218750,
0.0094604492187500, 0.0008544921875000, 0.0076904296875000, 0.0008850097656250,
0.0092468261718750, 0.0000305175781250, 0.0123901367187500, -0.0018005371093750,
0.0108337402343750, -0.0004272460937500, 0.0115966796875000, -0.0045166015625000,
0.0130310058593750, -0.0046386718750000, 0.0105895996093750, -0.0035400390625000,
0.0082702636718750, -0.0057678222656250, 0.0103454589843750, -0.0059814453125000,
0.0082702636718750, -0.0000915527343750, 0.0071105957031250, -0.0016784667968750,
0.0074157714843750, -0.0006713867187500, 0.0080261230468750, 0.0049133300781250,
0.0078430175781250, 0.0033569335937500, 0.0044555664062500, 0.0009155273437500,
0.0060424804687500, 0.0023193359375000, 0.0035400390625000, 0.0014953613281250,
-0.0003051757812500, -0.0015869140625000, 0.0019531250000000, -0.0008239746093750,
-0.0054931640625000, 0.0003051757812500, -0.0044860839843750, -0.0009765625000000,
-0.0061035156250000, 0.0007934570312500, -0.0122375488281250, 0.0035705566406250,
-0.0095520019531250, 0.0018310546875000, -0.0099487304687500, 0.0028686523437500,
-0.0123596191406250, 0.0042419433593750, -0.0087585449218750, 0.0026855468750000,
-0.0050964355468750, 0.0011291503906250, -0.0079650878906250, 0.0021362304687500,
-0.0023193359375000, 0.0003662109375000, -0.0014038085937500, 0.0002746582031250,
-0.0029602050781250, 0.0000915527343750, -0.0009155273437500, -0.0007324218750000,
-0.0001525878906250, -0.0002746582031250, -0.0053405761718750, -0.0013427734375000,
-0.0036010742187500, -0.0011901855468750, -0.0045471191406250, -0.0017700195312500,
-0.0091857910156250, -0.0027160644531250, -0.0072631835937500, -0.0020751953125000,
-0.0074462890625000, -0.0042419433593750, -0.0090942382812500, -0.0037841796875000,
-0.0069885253906250, -0.0049438476562500, -0.0050354003906250, -0.0068969726562500,
-0.0066833496093750, -0.0056762695312500, -0.0021057128906250, -0.0095520019531250,
-0.0028381347656250, -0.0095214843750000, -0.0017395019531250, -0.0092468261718750,
0.0017395019531250, -0.0115661621093750, -0.0002136230468750, -0.0113220214843750,
0.0025939941406250, -0.0090637207031250, 0.0032653808593750, -0.0101013183593750,
0.0023193359375000, -0.0087890625000000, 0.0028686523437500, -0.0062255859375000,
0.0029907226562500, -0.0075988769531250, 0.0012817382812500, -0.0046691894531250,
0.0015563964843750, -0.0047607421875000, 0.0011901855468750, -0.0042419433593750,
-0.0001525878906250, -0.0023193359375000, 0.0004577636718750, -0.0032348632812500,
0.0001220703125000, -0.0019836425781250, -0.0003051757812500, -0.0015258789062500,
0.0003967285156250, -0.0023498535156250, 0.0006408691406250, -0.0024108886718750,
-0.0000915527343750, -0.0019836425781250, 0.0019531250000000, -0.0036315917968750,
0.0014953613281250, -0.0035095214843750, 0.0019226074218750, -0.0037841796875000,
0.0033264160156250, -0.0047607421875000, 0.0023803710937500, -0.0042724609375000,
0.0041198730468750, -0.0056457519531250, 0.0037231445312500, -0.0053710937500000,
0.0038757324218750, -0.0059509277343750, 0.0049133300781250, -0.0072021484375000,
0.0040283203125000, -0.0065307617187500, 0.0054016113281250, -0.0072631835937500,
0.0051269531250000, -0.0076293945312500, 0.0051574707031250, -0.0071411132812500,
0.0059509277343750, -0.0069580078125000, 0.0052490234375000, -0.0072937011718750,
0.0059204101562500, -0.0064086914062500, 0.0057983398437500, -0.0065307617187500,
0.0056762695312500, -0.0063171386718750, 0.0059204101562500, -0.0056457519531250,
0.0054016113281250, -0.0059204101562500, 0.0055541992187500, -0.0053100585937500,
0.0057678222656250, -0.0051574707031250, 0.0053100585937500, -0.0053710937500000,
0.0050354003906250, -0.0052185058593750, 0.0050659179687500, -0.0051269531250000,
0.0039367675781250, -0.0055847167968750, 0.0040588378906250, -0.0058288574218750,
0.0032653808593750, -0.0051574707031250, 0.0019836425781250, -0.0050659179687500,
0.0021667480468750, -0.0056457519531250, 0.0004577636718750, -0.0033569335937500,
0.0003967285156250, -0.0039062500000000, -0.0003356933593750, -0.0033264160156250,
-0.0015869140625000, -0.0013732910156250, -0.0011291503906250, -0.0024108886718750,
-0.0031127929687500, -0.0018005371093750, -0.0030212402343750, -0.0007629394531250,
-0.0035705566406250, -0.0027160644531250, -0.0050354003906250, -0.0037841796875000,
-0.0043945312500000, -0.0023193359375000, -0.0056762695312500, -0.0074157714843750,
-0.0059204101562500, -0.0069274902343750, -0.0056762695312500, -0.0073242187500000,
-0.0062866210937500, -0.0107727050781250, -0.0064392089843750, -0.0094909667968750,
-0.0054626464843750, -0.0091247558593750, -0.0058898925781250, -0.0108337402343750,
-0.0054931640625000, -0.0084228515625000, -0.0047302246093750, -0.0059204101562500,
-0.0056762695312500, -0.0082702636718750, -0.0044250488281250, -0.0032043457031250,
-0.0045776367187500, -0.0029296875000000, -0.0045471191406250, -0.0039672851562500,
-0.0037231445312500, -0.0021057128906250, -0.0040283203125000, -0.0022277832031250,
-0.0036621093750000, -0.0039978027343750, -0.0039062500000000, -0.0037536621093750,
-0.0039978027343750, -0.0041809082031250, -0.0039978027343750, -0.0054016113281250,
-0.0039367675781250, -0.0047302246093750, -0.0025329589843750, -0.0052795410156250,
-0.0033874511718750, -0.0058593750000000, -0.0017395019531250, -0.0049743652343750,
0.0005187988281250, -0.0042724609375000, -0.0010070800781250, -0.0048522949218750,
0.0025939941406250, -0.0035400390625000, 0.0026550292968750, -0.0038757324218750,
0.0028686523437500, -0.0031127929687500, 0.0047912597656250, -0.0018005371093750,
0.0041503906250000, -0.0027160644531250, 0.0048828125000000, -0.0013427734375000,
0.0051879882812500, -0.0014038085937500, 0.0046997070312500, -0.0008850097656250,
0.0045166015625000, 0.0001220703125000, 0.0046081542968750, -0.0006103515625000,
0.0036926269531250, 0.0010681152343750, 0.0035095214843750, 0.0007019042968750,
0.0035095214843750, 0.0014648437500000, 0.0030517578125000, 0.0030822753906250,
0.0030822753906250, 0.0021667480468750, 0.0042419433593750, 0.0039672851562500,
0.0039367675781250, 0.0045166015625000, 0.0037841796875000, 0.0033569335937500,
0.0046997070312500, 0.0031738281250000, 0.0045471191406250, 0.0042419433593750,
0.0027465820312500, 0.0035095214843750, 0.0034790039062500, 0.0025024414062500,
0.0023803710937500, 0.0035400390625000, 0.0001220703125000, 0.0046691894531250,
0.0012207031250000, 0.0039367675781250, 0.0002136230468750, 0.0052490234375000,
-0.0005493164062500, 0.0061645507812500, 0.0008239746093750, 0.0042419433593750,
0.0018310546875000, 0.0036926269531250, 0.0010681152343750, 0.0053405761718750,
0.0028686523437500, -0.0007934570312500, 0.0026855468750000, -0.0000305175781250,
0.0034790039062500, 0.0003967285156250, 0.0048217773437500, -0.0037231445312500,
0.0039672851562500, -0.0030822753906250, 0.0069580078125000, 0.0005798339843750,
0.0062866210937500, -0.0013732910156250, 0.0072631835937500, 0.0012512207031250,
0.0102844238281250, 0.0072326660156250, 0.0100097656250000, 0.0067138671875000,
0.0128173828125000, 0.0098876953125000, 0.0124511718750000, 0.0095214843750000,
0.0113220214843750, 0.0094909667968750, 0.0128173828125000, 0.0114135742187500,
0.0131225585937500, 0.0107421875000000, 0.0092773437500000, 0.0111389160156250,
0.0106506347656250, 0.0117187500000000, 0.0087890625000000, 0.0104064941406250,
0.0054321289062500, 0.0097961425781250, 0.0077819824218750, 0.0108642578125000,
0.0014343261718750},
{0.0053710937500000, -0.0018920898437500, 0.0044555664062500, -0.0055236816406250,
0.0047607421875000, -0.0045471191406250, 0.0044250488281250, -0.0056762695312500,
0.0037231445312500, -0.0090637207031250, 0.0043945312500000, -0.0075073242187500,
0.0026855468750000, -0.0086669921875000, 0.0031433105468750, -0.0099792480468750,
0.0024414062500000, -0.0080566406250000, 0.0008239746093750, -0.0070190429687500,
0.0015869140625000, -0.0086669921875000, -0.0004272460937500, -0.0037536621093750,
-0.0004577636718750, -0.0043945312500000, -0.0007629394531250, -0.0041503906250000,
-0.0021057128906250, -0.0008544921875000, -0.0019531250000000, -0.0019836425781250,
-0.0029296875000000, -0.0028381347656250, -0.0031433105468750, -0.0018310546875000,
-0.0031738281250000, -0.0028076171875000, -0.0036926269531250, -0.0045471191406250,
-0.0035400390625000, -0.0037841796875000, -0.0029296875000000, -0.0045776367187500,
-0.0031433105468750, -0.0048217773437500, -0.0031738281250000, -0.0045166015625000,
-0.0026550292968750, -0.0047912597656250, -0.0028686523437500, -0.0047912597656250,
-0.0035400390625000, -0.0036010742187500, -0.0029602050781250, -0.0038146972656250,
-0.0038146972656250, -0.0038146972656250, -0.0050964355468750, -0.0032653808593750,
-0.0042724609375000, -0.0033569335937500, -0.0055541992187500, -0.0023803710937500,
-0.0060424804687500, -0.0029907226562500, -0.0051879882812500, -0.0021972656250000,
-0.0052795410156250, -0.0010986328125000, -0.0058288574218750, -0.0018310546875000,
-0.0033569335937500, 0.0012512207031250, -0.0041809082031250, 0.0005798339843750,
-0.0027465820312500, 0.0011901855468750, -0.0002746582031250, 0.0036010742187500,
-0.0019836425781250, 0.0025329589843750, 0.0013427734375000, 0.0035400390625000,
0.0012817382812500, 0.0039978027343750, 0.0012512207031250, 0.0034790039062500,
0.0030822753906250, 0.0034484863281250, 0.0025024414062500, 0.0036926269531250,
0.0026245117187500, 0.0031433105468750, 0.0028381347656250, 0.0031433105468750,
0.0030212402343750, 0.0038757324218750, 0.0031433105468750, 0.0039672851562500,
0.0030212402343750, 0.0032348632812500, 0.0036621093750000, 0.0035400390625000,
0.0039062500000000, 0.0046691894531250, 0.0036315917968750, 0.0030212402343750,
0.0036926269531250, 0.0016784667968750, 0.0039062500000000, 0.0030822753906250,
0.0022277832031250, -0.0012817382812500, 0.0028991699218750, -0.0006713867187500,
0.0021362304687500, -0.0006713867187500, 0.0001525878906250, -0.0036010742187500,
0.0012512207031250, -0.0024719238281250, 0.0002441406250000, -0.0002136230468750,
-0.0003967285156250, -0.0025634765625000, 0.0009765625000000, 0.0006408691406250,
0.0014038085937500, 0.0053100585937500, 0.0004272460937500, 0.0023498535156250,
0.0040588378906250, 0.0084228515625000, 0.0036315917968750, 0.0087585449218750,
0.0043945312500000, 0.0082397460937500, 0.0071411132812500, 0.0109252929687500,
0.0066528320312500, 0.0105590820312500, 0.0086364746093750, 0.0095825195312500,
0.0078735351562500, 0.0099487304687500, 0.0086364746093750, 0.0095520019531250,
0.0104675292968750, 0.0088195800781250, 0.0089416503906250, 0.0091857910156250,
0.0107421875000000, 0.0074157714843750, 0.0115966796875000, 0.0080871582031250,
0.0100097656250000, 0.0070800781250000, 0.0094909667968750, 0.0050659179687500,
0.0105895996093750, 0.0061340332031250, 0.0077514648437500, 0.0038146972656250,
0.0083312988281250, 0.0040588378906250, 0.0067749023437500, 0.0031127929687500,
0.0046691894531250, 0.0009460449218750, 0.0065002441406250, 0.0020751953125000,
-0.0000305175781250, 0.0005493164062500, 0.0014343261718750, 0.0000000000000000,
-0.0007019042968750, 0.0003356933593750, -0.0068969726562500, 0.0000305175781250,
-0.0039367675781250, -0.0001220703125000, -0.0056457519531250, 0.0005493164062500,
-0.0082397460937500, 0.0000915527343750, -0.0046081542968750, 0.0006103515625000,
-0.0018005371093750, 0.0013427734375000, -0.0048828125000000, 0.0005798339843750,
0.0017395019531250, 0.0025024414062500, 0.0018005371093750, 0.0021972656250000,
0.0013732910156250, 0.0029296875000000, 0.0042419433593750, 0.0042724609375000,
0.0031433105468750, 0.0033569335937500, 0.0034484863281250, 0.0066528320312500,
0.0039062500000000, 0.0067443847656250, 0.0030517578125000, 0.0061950683593750,
0.0024719238281250, 0.0079040527343750, 0.0030212402343750, 0.0078430175781250,
0.0018310546875000, 0.0050354003906250, 0.0021362304687500, 0.0062866210937500,
0.0013122558593750, 0.0037536621093750, 0.0002441406250000, -0.0001831054687500,
0.0011596679687500, 0.0018920898437500, -0.0010986328125000, -0.0027465820312500,
-0.0003967285156250, -0.0036621093750000, -0.0009155273437500, -0.0032348632812500,
-0.0027465820312500, -0.0049438476562500, -0.0015563964843750, -0.0048522949218750,
-0.0032653808593750, -0.0034484863281250, -0.0031738281250000, -0.0036010742187500,
-0.0025329589843750, -0.0033264160156250, -0.0035400390625000, -0.0021362304687500,
-0.0036926269531250, -0.0020446777343750, -0.0015258789062500, -0.0026245117187500,
-0.0019226074218750, -0.0021057128906250, -0.0018310546875000, -0.0018920898437500,
-0.0003967285156250, -0.0023193359375000, -0.0009155273437500, -0.0019226074218750,
-0.0003967285156250, -0.0011291503906250, 0.0004272460937500, -0.0014953613281250,
-0.0017089843750000, -0.0004272460937500, -0.0028686523437500, 0.0008544921875000,
-0.0009155273437500, 0.0001525878906250, -0.0058593750000000, 0.0025939941406250,
-0.0058898925781250, 0.0025024414062500, -0.0057678222656250, 0.0035095214843750,
-0.0081176757812500, 0.0054931640625000, -0.0074462890625000, 0.0048828125000000,
-0.0077514648437500, 0.0072326660156250, -0.0080566406250000, 0.0073852539062500,
-0.0074768066406250, 0.0076599121093750, -0.0072021484375000, 0.0090637207031250,
-0.0073852539062500, 0.0086059570312500, -0.0064086914062500, 0.0087890625000000,
-0.0065002441406250, 0.0091247558593750, -0.0059814453125000, 0.0085754394531250,
-0.0052185058593750, 0.0080871582031250, -0.0057067871093750, 0.0083312988281250,
-0.0040893554687500, 0.0074462890625000, -0.0043334960937500, 0.0072631835937500,
-0.0040588378906250, 0.0072326660156250, -0.0028991699218750, 0.0067443847656250,
-0.0034179687500000, 0.0065307617187500, -0.0025634765625000, 0.0065917968750000,
-0.0027770996093750, 0.0061950683593750, -0.0022888183593750, 0.0061035156250000,
-0.0014648437500000, 0.0061950683593750, -0.0022277832031250, 0.0058898925781250,
-0.0007324218750000, 0.0060119628906250, -0.0006713867187500, 0.0054626464843750,
-0.0011596679687500, 0.0057373046875000, -0.0005798339843750, 0.0061035156250000,
-0.0005187988281250, 0.0051574707031250, -0.0017395019531250, 0.0062255859375000,
-0.0015869140625000, 0.0060424804687500, -0.0015258789062500, 0.0061340332031250,
-0.0023193359375000, 0.0067443847656250, -0.0021972656250000, 0.0065002441406250,
-0.0016784667968750, 0.0072326660156250, -0.0016784667968750, 0.0069885253906250,
-0.0016784667968750, 0.0068664550781250, -0.0013732910156250, 0.0072021484375000,
-0.0012817382812500, 0.0069580078125000, -0.0012817382812500, 0.0071411132812500,
-0.0013427734375000, 0.0069885253906250, -0.0010681152343750, 0.0073852539062500,
-0.0007934570312500, 0.0077514648437500, -0.0010375976562500, 0.0072326660156250,
-0.0010681152343750, 0.0084838867187500, -0.0007019042968750, 0.0082092285156250,
-0.0016479492187500, 0.0085449218750000, -0.0025024414062500, 0.0096435546875000,
-0.0019836425781250, 0.0090026855468750, -0.0043945312500000, 0.0093994140625000,
-0.0043334960937500, 0.0096740722656250, -0.0047912597656250, 0.0090942382812500,
-0.0063781738281250, 0.0088195800781250, -0.0058898925781250, 0.0091552734375000,
-0.0066223144531250, 0.0077819824218750, -0.0069885253906250, 0.0082397460937500,
-0.0066528320312500, 0.0074157714843750, -0.0067138671875000, 0.0060119628906250,
-0.0068664550781250, 0.0069580078125000, -0.0055236816406250, 0.0045776367187500,
-0.0059509277343750, 0.0047302246093750, -0.0049743652343750, 0.0046691894531250,
-0.0034484863281250, 0.0030517578125000, -0.0041809082031250, 0.0033874511718750,
-0.0019226074218750, 0.0038757324218750, -0.0019226074218750, 0.0032958984375000,
-0.0016784667968750, 0.0039062500000000, -0.0002441406250000, 0.0050048828125000,
-0.0006713867187500, 0.0042724609375000, -0.0002136230468750, 0.0049438476562500,
-0.0000915527343750, 0.0055847167968750, 0.0000915527343750, 0.0039978027343750,
0.0003356933593750, 0.0035705566406250, 0.0001831054687500, 0.0047302246093750,
0.0008239746093750, -0.0009460449218750, 0.0008544921875000, 0.0002441406250000,
0.0012817382812500, -0.0014648437500000, 0.0019836425781250, -0.0064392089843750,
0.0018005371093750, -0.0040283203125000, 0.0027465820312500, -0.0066833496093750,
0.0030517578125000, -0.0082092285156250, 0.0023498535156250, -0.0065307617187500,
0.0021362304687500, -0.0065002441406250, 0.0028381347656250, -0.0073547363281250,
0.0025939941406250, -0.0016479492187500, 0.0013122558593750, -0.0031738281250000,
0.0032043457031250, -0.0006408691406250, 0.0050964355468750, 0.0050659179687500,
0.0036621093750000, 0.0020141601562500, 0.0068664550781250, 0.0054626464843750,
0.0068664550781250, 0.0080261230468750, 0.0063171386718750, 0.0037536621093750,
0.0084838867187500, 0.0018310546875000, 0.0083618164062500, 0.0047302246093750,
0.0033874511718750, -0.0063171386718750, 0.0052490234375000, -0.0061340332031250,
0.0028381347656250, -0.0063781738281250, -0.0024108886718750, -0.0126953125000000,
0.0004882812500000, -0.0111083984375000, -0.0037536621093750, -0.0103759765625000,
-0.0048828125000000, -0.0124816894531250, -0.0033874511718750, -0.0083312988281250,
-0.0039978027343750, -0.0047302246093750, -0.0043640136718750, -0.0081176757812500,
-0.0015869140625000, 0.0019836425781250, -0.0025329589843750, 0.0021057128906250,
-0.0008544921875000, 0.0018615722656250, 0.0015869140625000, 0.0068969726562500,
-0.0000305175781250, 0.0059204101562500, 0.0064392089843750, 0.0059509277343750,
0.0050354003906250, 0.0061340332031250, 0.0075683593750000, 0.0069885253906250,
0.0133361816406250, 0.0074768066406250, 0.0104370117187500, 0.0065002441406250,
0.0159912109375000, 0.0082702636718750, 0.0174560546875000, 0.0089721679687500,
0.0151062011718750, 0.0077209472656250, 0.0148620605468750, 0.0067443847656250,
0.0075988769531250, 0.0068359375000000, 0.0119323730468750, 0.0090942382812500,
0.0096740722656250, 0.0089416503906250, 0.0115661621093750, 0.0082092285156250,
0.0155639648437500, 0.0084533691406250, 0.0137023925781250, 0.0088806152343750,
0.0112304687500000, 0.0070190429687500, 0.0140991210937500, 0.0066833496093750,
0.0110473632812500, 0.0077209472656250, 0.0059509277343750, 0.0075683593750000,
0.0089721679687500, 0.0068054199218750, 0.0041503906250000, 0.0087280273437500,
0.0034790039062500, 0.0089416503906250, 0.0033874511718750, 0.0081787109375000,
0.0015869140625000, 0.0088195800781250, 0.0024108886718750, 0.0091247558593750,
-0.0000305175781250, 0.0058288574218750, 0.0005798339843750, 0.0066528320312500,
-0.0017395019531250, 0.0055541992187500, -0.0044555664062500, 0.0029602050781250,
-0.0018615722656250, 0.0043640136718750, -0.0068664550781250, 0.0010681152343750,
-0.0084228515625000, 0.0016784667968750, -0.0058898925781250, 0.0003051757812500,
-0.0058898925781250, -0.0026855468750000, -0.0073852539062500, -0.0008850097656250,
-0.0032653808593750, -0.0036010742187500, -0.0026855468750000, -0.0045471191406250,
-0.0041809082031250},
{0.0000915527343750, 0.0093078613281250, 0.0001525878906250, 0.0080261230468750,
0.0012817382812500, 0.0056762695312500, 0.0010681152343750, 0.0071105957031250,
0.0017089843750000, 0.0041503906250000, 0.0015563964843750, 0.0036010742187500,
0.0020751953125000, 0.0045471191406250, 0.0027770996093750, 0.0037536621093750,
0.0024414062500000, 0.0033569335937500, 0.0038146972656250, 0.0051574707031250,
0.0039062500000000, 0.0052795410156250, 0.0039062500000000, 0.0045471191406250,
0.0048217773437500, 0.0054016113281250, 0.0048217773437500, 0.0057067871093750,
0.0036926269531250, 0.0021667480468750, 0.0039978027343750, 0.0035705566406250,
0.0043640136718750, 0.0010986328125000, 0.0032958984375000, -0.0027770996093750,
0.0031127929687500, -0.0003356933593750, 0.0057067871093750, -0.0072021484375000,
0.0055847167968750, -0.0072326660156250, 0.0051269531250000, -0.0069580078125000,
0.0066223144531250, -0.0111389160156250, 0.0066223144531250, -0.0102844238281250,
0.0036315917968750, -0.0063476562500000, 0.0055236816406250, -0.0090026855468750,
0.0021667480468750, -0.0051879882812500, -0.0029602050781250, 0.0012207031250000,
0.0003967285156250, -0.0023498535156250, -0.0043945312500000, 0.0032043457031250,
-0.0058898925781250, 0.0056152343750000, -0.0038146972656250, 0.0018615722656250,
-0.0042419433593750, 0.0009155273437500, -0.0051269531250000, 0.0029296875000000,
-0.0006103515625000, -0.0044250488281250, -0.0012207031250000, -0.0033569335937500,
-0.0002136230468750, -0.0057678222656250, 0.0026855468750000, -0.0120849609375000,
0.0013122558593750, -0.0086364746093750, 0.0055847167968750, -0.0100708007812500,
0.0044250488281250, -0.0137634277343750, 0.0066528320312500, -0.0082092285156250,
0.0108642578125000, -0.0031433105468750, 0.0081481933593750, -0.0073547363281250,
0.0129089355468750, 0.0030212402343750, 0.0141906738281250, 0.0036315917968750,
0.0124511718750000, 0.0028076171875000, 0.0134277343750000, 0.0072021484375000,
0.0142517089843750, 0.0065917968750000, 0.0090332031250000, 0.0063781738281250,
0.0093383789062500, 0.0064086914062500, 0.0103454589843750, 0.0070190429687500,
0.0074462890625000, 0.0079345703125000, 0.0119323730468750, 0.0066833496093750,
0.0111389160156250, 0.0056762695312500, 0.0139465332031250, 0.0052185058593750,
0.0100097656250000, 0.0068969726562500, 0.0058898925781250, 0.0076599121093750,
0.0091552734375000, 0.0062255859375000, 0.0045166015625000, 0.0096130371093750,
0.0032043457031250, 0.0104370117187500, 0.0044860839843750, 0.0085449218750000,
0.0042419433593750, 0.0086059570312500, 0.0038757324218750, 0.0097045898437500,
0.0026855468750000, 0.0059204101562500, 0.0041503906250000, 0.0055847167968750,
0.0019531250000000, 0.0067749023437500, -0.0013732910156250, 0.0055236816406250,
0.0005493164062500, 0.0050048828125000, -0.0030212402343750, 0.0086364746093750,
-0.0035705566406250, 0.0085449218750000, -0.0022277832031250, 0.0079956054687500,
-0.0032653808593750, 0.0099487304687500, -0.0041198730468750, 0.0098266601562500,
-0.0010375976562500, 0.0064392089843750, -0.0003356933593750, 0.0076904296875000,
-0.0029296875000000, 0.0062561035156250, -0.0028991699218750, 0.0029602050781250,
-0.0011291503906250, 0.0045471191406250, -0.0080566406250000, 0.0010986328125000,
-0.0072631835937500, 0.0014038085937500, -0.0080261230468750, 0.0002746582031250,
-0.0130004882812500, -0.0023498535156250, -0.0112609863281250, -0.0008850097656250,
-0.0106201171875000, -0.0038146972656250, -0.0130310058593750, -0.0044250488281250,
-0.0092163085937500, -0.0027160644531250, -0.0054016113281250, -0.0032653808593750,
-0.0086364746093750, -0.0041198730468750, -0.0003967285156250, 0.0011291503906250,
-0.0005798339843750, 0.0005493164062500, -0.0006713867187500, 0.0010070800781250,
0.0037231445312500, 0.0044555664062500, 0.0021667480468750, 0.0035095214843750,
0.0017700195312500, 0.0037231445312500, 0.0029907226562500, 0.0042114257812500,
0.0016784667968750, 0.0039062500000000, -0.0003662109375000, 0.0034790039062500,
0.0009155273437500, 0.0036926269531250, 0.0007019042968750, 0.0035400390625000,
-0.0011291503906250, 0.0035705566406250, 0.0012817382812500, 0.0032958984375000,
0.0038146972656250, 0.0032348632812500, 0.0016174316406250, 0.0034179687500000,
0.0057983398437500, 0.0020141601562500, 0.0062561035156250, 0.0022277832031250,
0.0056762695312500, 0.0020751953125000, 0.0072021484375000, 0.0012817382812500,
0.0070800781250000, 0.0014648437500000, 0.0060424804687500, 0.0003356933593750,
0.0065917968750000, 0.0010986328125000, 0.0061950683593750, -0.0004272460937500,
0.0053100585937500, -0.0023498535156250, 0.0058288574218750, -0.0010070800781250,
0.0042724609375000, -0.0043029785156250, 0.0043945312500000, -0.0043945312500000,
0.0042419433593750, -0.0043945312500000, 0.0032043457031250, -0.0059204101562500,
0.0036315917968750, -0.0053710937500000, 0.0033264160156250, -0.0062255859375000,
0.0028991699218750, -0.0061340332031250, 0.0030517578125000, -0.0061645507812500,
0.0031738281250000, -0.0068054199218750, 0.0028381347656250, -0.0065612792968750,
0.0029907226562500, -0.0059509277343750, 0.0027770996093750, -0.0064086914062500,
0.0027770996093750, -0.0058288574218750, 0.0030517578125000, -0.0047607421875000,
0.0028381347656250, -0.0053100585937500, 0.0029296875000000, -0.0045166015625000,
0.0031433105468750, -0.0044250488281250, 0.0026855468750000, -0.0043029785156250,
0.0024719238281250, -0.0039367675781250, 0.0027465820312500, -0.0043334960937500,
0.0012817382812500, -0.0032653808593750, 0.0018005371093750, -0.0033569335937500,
0.0011291503906250, -0.0034790039062500, -0.0001525878906250, -0.0028686523437500,
0.0008544921875000, -0.0029602050781250, -0.0014648437500000, -0.0032348632812500,
-0.0009765625000000, -0.0031127929687500, -0.0014343261718750, -0.0032958984375000,
-0.0030212402343750, -0.0036010742187500, -0.0017089843750000, -0.0036315917968750,
-0.0034790039062500, -0.0036926269531250, -0.0031127929687500, -0.0038757324218750,
-0.0032043457031250, -0.0037841796875000, -0.0042114257812500, -0.0037536621093750,
-0.0031127929687500, -0.0039978027343750, -0.0042724609375000, -0.0034179687500000,
-0.0040893554687500, -0.0035400390625000, -0.0039978027343750, -0.0036010742187500,
-0.0043945312500000, -0.0031738281250000, -0.0037231445312500, -0.0033569335937500,
-0.0041809082031250, -0.0040283203125000, -0.0038757324218750, -0.0035095214843750,
-0.0035400390625000, -0.0045471191406250, -0.0036315917968750, -0.0057983398437500,
-0.0031127929687500, -0.0049438476562500, -0.0028991699218750, -0.0068054199218750,
-0.0027465820312500, -0.0072631835937500, -0.0022888183593750, -0.0065917968750000,
-0.0019836425781250, -0.0070190429687500, -0.0020446777343750, -0.0073852539062500,
-0.0013732910156250, -0.0056762695312500, -0.0011291503906250, -0.0062255859375000,
-0.0012207031250000, -0.0055236816406250, -0.0010070800781250, -0.0040893554687500,
-0.0009460449218750, -0.0050659179687500, -0.0012817382812500, -0.0028991699218750,
-0.0010681152343750, -0.0028991699218750, -0.0012512207031250, -0.0030517578125000,
-0.0016174316406250, -0.0018310546875000, -0.0013122558593750, -0.0020751953125000,
-0.0018920898437500, -0.0028991699218750, -0.0017395019531250, -0.0024719238281250,
-0.0018005371093750, -0.0030212402343750, -0.0020751953125000, -0.0040283203125000,
-0.0015869140625000, -0.0034179687500000, -0.0017395019531250, -0.0043640136718750,
-0.0018615722656250, -0.0043640136718750, -0.0013732910156250, -0.0041198730468750,
-0.0009765625000000, -0.0046386718750000, -0.0012512207031250, -0.0044860839843750,
-0.0007019042968750, -0.0028991699218750, -0.0003662109375000, -0.0035705566406250,
-0.0001525878906250, -0.0027770996093750, 0.0001220703125000, -0.0013122558593750,
0.0000305175781250, -0.0021362304687500, 0.0004272460937500, 0.0004882812500000,
0.0006103515625000, -0.0003051757812500, 0.0003967285156250, 0.0007019042968750,
0.0003356933593750, 0.0032653808593750, 0.0003356933593750, 0.0020141601562500,
-0.0006103515625000, 0.0041503906250000, -0.0005493164062500, 0.0044860839843750,
-0.0007324218750000, 0.0038452148437500, -0.0013122558593750, 0.0045471191406250,
-0.0010681152343750, 0.0046997070312500, -0.0013427734375000, 0.0035400390625000,
-0.0014038085937500, 0.0035400390625000, -0.0011596679687500, 0.0039062500000000,
-0.0010986328125000, 0.0034179687500000, -0.0013122558593750, 0.0030822753906250,
-0.0005187988281250, 0.0045776367187500, -0.0001220703125000, 0.0047912597656250,
-0.0012817382812500, 0.0035095214843750, -0.0017700195312500, 0.0035095214843750,
-0.0010070800781250, 0.0042419433593750, -0.0040893554687500, 0.0008544921875000,
-0.0042724609375000, 0.0012817382812500, -0.0043640136718750, 0.0011901855468750,
-0.0060729980468750, -0.0015869140625000, -0.0056457519531250, -0.0008544921875000,
-0.0051574707031250, 0.0016479492187500, -0.0058288574218750, 0.0000610351562500,
-0.0048217773437500, 0.0021667480468750, -0.0034484863281250, 0.0057067871093750,
-0.0041503906250000, 0.0036010742187500, -0.0023193359375000, 0.0075378417968750,
-0.0021057128906250, 0.0075683593750000, -0.0017089843750000, 0.0077514648437500,
-0.0008544921875000, 0.0099792480468750, -0.0012512207031250, 0.0087890625000000,
0.0005798339843750, 0.0087585449218750, 0.0003967285156250, 0.0096130371093750,
0.0007019042968750, 0.0084228515625000, 0.0022583007812500, 0.0073242187500000,
0.0017700195312500, 0.0082092285156250, 0.0004577636718750, 0.0053405761718750,
0.0013122558593750, 0.0054016113281250, 0.0011596679687500, 0.0052795410156250,
-0.0007019042968750, 0.0036315917968750, -0.0002746582031250, 0.0036315917968750,
0.0019531250000000, 0.0019226074218750, 0.0004272460937500, 0.0029602050781250,
0.0015563964843750, 0.0018920898437500, 0.0041503906250000, -0.0003051757812500,
0.0024108886718750, 0.0010375976562500, 0.0049133300781250, -0.0008544921875000,
0.0050048828125000, -0.0016479492187500, 0.0053405761718750, -0.0010681152343750,
0.0063781738281250, -0.0012512207031250, 0.0053710937500000, -0.0013732910156250,
0.0072937011718750, -0.0003356933593750, 0.0075683593750000, -0.0006408691406250,
0.0071716308593750, -0.0003356933593750, 0.0077819824218750, 0.0003662109375000,
0.0077514648437500, -0.0000305175781250, 0.0072937011718750, 0.0017395019531250,
0.0074768066406250, 0.0010986328125000, 0.0075683593750000, 0.0021972656250000,
0.0072631835937500, 0.0042419433593750, 0.0070495605468750, 0.0029907226562500,
0.0069885253906250, 0.0051574707031250, 0.0079345703125000, 0.0061950683593750,
0.0056457519531250, 0.0042114257812500, 0.0043029785156250, 0.0038146972656250,
0.0064086914062500, 0.0051879882812500, -0.0007324218750000, -0.0003662109375000,
0.0004272460937500, 0.0007629394531250, -0.0001220703125000, -0.0009765625000000,
-0.0050964355468750, -0.0058288574218750, -0.0032043457031250, -0.0036010742187500,
-0.0033264160156250, -0.0058593750000000, -0.0048522949218750, -0.0074157714843750,
-0.0028991699218750, -0.0054931640625000, -0.0010681152343750, -0.0045776367187500,
-0.0030517578125000, -0.0057067871093750, 0.0003356933593750, -0.0020751953125000,
0.0005187988281250, -0.0019836425781250, 0.0005187988281250, -0.0021362304687500,
0.0016784667968750, -0.0002136230468750, 0.0008239746093750, -0.0002441406250000,
0.0026855468750000, -0.0008239746093750, 0.0023193359375000, -0.0004882812500000,
0.0029296875000000, -0.0001220703125000, 0.0046386718750000, -0.0003662109375000,
0.0034790039062500},
{0.0010681152343750, 0.0033874511718750, 0.0010375976562500, 0.0036315917968750,
0.0001831054687500, 0.0034790039062500, 0.0006713867187500, 0.0033264160156250,
0.0000305175781250, 0.0032958984375000, -0.0012207031250000, 0.0036926269531250,
-0.0004272460937500, 0.0036621093750000, -0.0010681152343750, 0.0014648437500000,
-0.0018005371093750, 0.0023498535156250, -0.0007934570312500, 0.0019531250000000,
0.0002136230468750, -0.0003051757812500, -0.0005798339843750, 0.0004272460937500,
0.0003967285156250, 0.0012207031250000, 0.0012512207031250, -0.0002441406250000,
-0.0005187988281250, 0.0019836425781250, -0.0015869140625000, 0.0045471191406250,
-0.0004882812500000, 0.0025939941406250, -0.0045471191406250, 0.0071716308593750,
-0.0044250488281250, 0.0069885253906250, -0.0049743652343750, 0.0070190429687500,
-0.0078125000000000, 0.0094604492187500, -0.0068664550781250, 0.0086059570312500,
-0.0060119628906250, 0.0093994140625000, -0.0073547363281250, 0.0097351074218750,
-0.0057678222656250, 0.0084838867187500, -0.0034790039062500, 0.0082397460937500,
-0.0048522949218750, 0.0091247558593750, -0.0019226074218750, 0.0062866210937500,
-0.0017700195312500, 0.0066528320312500, -0.0017395019531250, 0.0055847167968750,
-0.0003967285156250, 0.0034179687500000, -0.0008544921875000, 0.0047302246093750,
0.0000915527343750, 0.0025329589843750, 0.0004272460937500, 0.0025024414062500,
-0.0000610351562500, 0.0019836425781250, -0.0004882812500000, 0.0005187988281250,
-0.0005798339843750, 0.0005798339843750, -0.0006713867187500, -0.0022888183593750,
-0.0008544921875000, -0.0017395019531250, -0.0004577636718750, -0.0010681152343750,
-0.0003662109375000, -0.0027160644531250, -0.0007629394531250, -0.0028991699218750,
0.0016174316406250, -0.0014343261718750, 0.0007629394531250, -0.0016784667968750,
0.0016784667968750, -0.0010070800781250, 0.0038757324218750, -0.0000610351562500,
0.0025939941406250, -0.0008239746093750, 0.0051269531250000, 0.0013122558593750,
0.0048217773437500, 0.0008544921875000, 0.0050048828125000, 0.0015563964843750,
0.0066223144531250, 0.0035095214843750, 0.0060119628906250, 0.0025024414062500,
0.0073547363281250, 0.0033264160156250, 0.0071716308593750, 0.0043029785156250,
0.0071716308593750, 0.0027465820312500, 0.0080871582031250, 0.0018310546875000,
0.0078735351562500, 0.0029907226562500, 0.0075378417968750, -0.0016174316406250,
0.0076293945312500, -0.0009460449218750, 0.0076904296875000, -0.0015563964843750,
0.0075378417968750, -0.0049438476562500, 0.0073852539062500, -0.0037536621093750,
0.0067443847656250, -0.0046081542968750, 0.0078125000000000, -0.0054931640625000,
0.0058593750000000, -0.0041503906250000, 0.0041503906250000, -0.0032958984375000,
0.0062866210937500, -0.0041809082031250, 0.0009460449218750, -0.0011901855468750,
0.0018005371093750, -0.0012207031250000, 0.0010681152343750, -0.0009460449218750,
-0.0027770996093750, 0.0009765625000000, -0.0008850097656250, 0.0005798339843750,
-0.0017089843750000, 0.0003662109375000, -0.0029602050781250, 0.0010375976562500,
-0.0018920898437500, 0.0010681152343750, -0.0010070800781250, 0.0004882812500000,
-0.0017089843750000, 0.0007629394531250, 0.0004882812500000, 0.0016174316406250,
-0.0003967285156250, 0.0017395019531250, 0.0003051757812500, 0.0016784667968750,
0.0022277832031250, 0.0023498535156250, 0.0008850097656250, 0.0025329589843750,
0.0038146972656250, 0.0010070800781250, 0.0035400390625000, 0.0015258789062500,
0.0032348632812500, 0.0005493164062500, 0.0049438476562500, -0.0013732910156250,
0.0046081542968750, -0.0005798339843750, 0.0037231445312500, -0.0020446777343750,
0.0043640136718750, -0.0025024414062500, 0.0030822753906250, -0.0024719238281250,
0.0016479492187500, -0.0026245117187500, 0.0030517578125000, -0.0023193359375000,
0.0006713867187500, -0.0030517578125000, 0.0004882812500000, -0.0023498535156250,
0.0006103515625000, -0.0027770996093750, -0.0002441406250000, -0.0036621093750000,
0.0003662109375000, -0.0027160644531250, -0.0006408691406250, -0.0045776367187500,
-0.0005187988281250, -0.0041503906250000, -0.0004577636718750, -0.0046997070312500,
-0.0007324218750000, -0.0060729980468750, -0.0005187988281250, -0.0050354003906250,
-0.0018920898437500, -0.0073242187500000, -0.0012207031250000, -0.0068664550781250,
-0.0019531250000000, -0.0072326660156250, -0.0035705566406250, -0.0089416503906250,
-0.0027770996093750, -0.0080566406250000, -0.0043640136718750, -0.0095825195312500,
-0.0042419433593750, -0.0095520019531250, -0.0043945312500000, -0.0094299316406250,
-0.0055236816406250, -0.0101928710937500, -0.0049438476562500, -0.0099182128906250,
-0.0047302246093750, -0.0094909667968750, -0.0054321289062500, -0.0101623535156250,
-0.0043029785156250, -0.0096740722656250, -0.0030822753906250, -0.0089111328125000,
-0.0039367675781250, -0.0096130371093750, -0.0019531250000000, -0.0082092285156250,
-0.0018615722656250, -0.0082397460937500, -0.0017395019531250, -0.0081176757812500,
-0.0006408691406250, -0.0074462890625000, -0.0010375976562500, -0.0079650878906250,
-0.0006408691406250, -0.0072937011718750, -0.0004272460937500, -0.0070495605468750,
-0.0005798339843750, -0.0072326660156250, -0.0005798339843750, -0.0071411132812500,
-0.0004577636718750, -0.0069274902343750, -0.0006103515625000, -0.0068664550781250,
-0.0007629394531250, -0.0070800781250000, -0.0003967285156250, -0.0068054199218750,
-0.0001831054687500, -0.0065307617187500, -0.0005493164062500, -0.0068969726562500,
-0.0002746582031250, -0.0062561035156250, 0.0000000000000000, -0.0064086914062500,
-0.0008544921875000, -0.0061950683593750, -0.0013122558593750, -0.0057983398437500,
-0.0007629394531250, -0.0062255859375000, -0.0029602050781250, -0.0055541992187500,
-0.0026855468750000, -0.0057373046875000, -0.0033264160156250, -0.0054626464843750,
-0.0049438476562500, -0.0049133300781250, -0.0042114257812500, -0.0052795410156250,
-0.0059204101562500, -0.0039672851562500, -0.0060119628906250, -0.0045776367187500,
-0.0056457519531250, -0.0037231445312500, -0.0063476562500000, -0.0026245117187500,
-0.0061950683593750, -0.0036315917968750, -0.0051269531250000, -0.0000610351562500,
-0.0053100585937500, -0.0009765625000000, -0.0047912597656250, 0.0001525878906250,
-0.0037841796875000, 0.0028991699218750, -0.0040893554687500, 0.0011901855468750,
-0.0029296875000000, 0.0051269531250000, -0.0031127929687500, 0.0045166015625000,
-0.0025024414062500, 0.0057067871093750, -0.0014648437500000, 0.0088195800781250,
-0.0021362304687500, 0.0069885253906250, -0.0005798339843750, 0.0102844238281250,
-0.0007324218750000, 0.0104675292968750, -0.0003051757812500, 0.0099182128906250,
0.0005798339843750, 0.0113220214843750, 0.0000305175781250, 0.0111083984375000,
0.0024108886718750, 0.0095520019531250, 0.0017089843750000, 0.0102539062500000,
0.0028076171875000, 0.0090637207031250, 0.0052795410156250, 0.0071411132812500,
0.0039367675781250, 0.0084533691406250, 0.0057678222656250, 0.0065307617187500,
0.0063781738281250, 0.0061340332031250, 0.0056457519531250, 0.0064086914062500,
0.0058593750000000, 0.0061035156250000, 0.0061340332031250, 0.0062561035156250,
0.0046691894531250, 0.0053100585937500, 0.0047912597656250, 0.0057067871093750,
0.0046997070312500, 0.0052185058593750, 0.0037231445312500, 0.0039978027343750,
0.0037536621093750, 0.0046386718750000, 0.0031127929687500, 0.0039367675781250,
0.0035705566406250, 0.0038757324218750, 0.0025634765625000, 0.0034179687500000,
0.0011596679687500, 0.0027160644531250, 0.0020141601562500, 0.0029907226562500,
0.0009765625000000, 0.0018310546875000, 0.0002746582031250, 0.0013732910156250,
0.0008544921875000, 0.0016784667968750, 0.0008850097656250, 0.0015563964843750,
0.0007324218750000, 0.0010681152343750, 0.0037841796875000, 0.0015258789062500,
0.0025939941406250, 0.0020141601562500, 0.0042114257812500, 0.0003662109375000,
0.0076599121093750, -0.0005798339843750, 0.0061645507812500, 0.0006408691406250,
0.0090942382812500, -0.0032653808593750, 0.0093383789062500, -0.0030517578125000,
0.0091247558593750, -0.0030822753906250, 0.0104675292968750, -0.0055236816406250,
0.0102844238281250, -0.0050659179687500, 0.0097351074218750, -0.0049743652343750,
0.0101928710937500, -0.0053405761718750, 0.0092773437500000, -0.0042419433593750,
0.0082092285156250, -0.0040588378906250, 0.0090942382812500, -0.0049743652343750,
0.0074462890625000, 0.0003356933593750, 0.0076904296875000, -0.0000610351562500,
0.0075683593750000, -0.0005187988281250, 0.0062561035156250, 0.0027770996093750,
0.0068359375000000, 0.0022583007812500, 0.0079650878906250, -0.0014953613281250,
0.0071105957031250, 0.0001525878906250, 0.0082092285156250, -0.0016479492187500,
0.0101928710937500, -0.0063476562500000, 0.0089111328125000, -0.0043029785156250,
0.0085144042968750, -0.0038757324218750, 0.0100708007812500, -0.0061950683593750,
0.0086364746093750, -0.0036621093750000, 0.0047912597656250, 0.0022888183593750,
0.0042419433593750, -0.0011291503906250, 0.0033874511718750, -0.0019226074218750,
0.0043029785156250, -0.0039367675781250, 0.0027160644531250, -0.0014038085937500,
0.0013732910156250, 0.0011901855468750, 0.0026855468750000, -0.0007629394531250,
-0.0009460449218750, 0.0019226074218750, -0.0014343261718750, 0.0028381347656250,
-0.0006713867187500, 0.0023498535156250, -0.0021057128906250, 0.0022277832031250,
-0.0025939941406250, 0.0021667480468750, -0.0001831054687500, 0.0047302246093750,
-0.0002441406250000, 0.0033569335937500, -0.0013122558593750, 0.0049743652343750,
-0.0006103515625000, 0.0085144042968750, -0.0002136230468750, 0.0065917968750000,
-0.0026855468750000, 0.0070800781250000, -0.0020446777343750, 0.0089721679687500,
-0.0027160644531250, 0.0063476562500000, -0.0052490234375000, 0.0033264160156250,
-0.0042419433593750, 0.0054016113281250, -0.0031738281250000, 0.0029907226562500,
-0.0040588378906250, 0.0014038085937500, -0.0036315917968750, 0.0036926269531250,
-0.0021362304687500, 0.0052185058593750, -0.0025024414062500, 0.0037536621093750,
-0.0025024414062500, 0.0061950683593750, -0.0023193359375000, 0.0072631835937500,
-0.0015258789062500, 0.0061340332031250, -0.0012512207031250, 0.0058898925781250,
-0.0018920898437500, 0.0066833496093750, -0.0001831054687500, 0.0049438476562500,
-0.0002136230468750, 0.0049743652343750, 0.0003967285156250, 0.0048828125000000,
0.0016174316406250, 0.0043640136718750, 0.0009155273437500, 0.0046691894531250,
0.0020446777343750, 0.0022888183593750, 0.0024719238281250, 0.0034179687500000,
0.0018615722656250, 0.0018615722656250, 0.0018005371093750, -0.0013122558593750,
0.0023193359375000, 0.0003967285156250, 0.0016784667968750, -0.0016174316406250,
0.0015563964843750, -0.0028991699218750, 0.0015258789062500, -0.0013122558593750,
0.0010986328125000, -0.0006408691406250, 0.0012817382812500, -0.0015258789062500,
0.0020446777343750, 0.0016174316406250, 0.0008544921875000, 0.0014648437500000,
0.0031127929687500, 0.0016784667968750, 0.0052795410156250, 0.0034179687500000,
0.0030822753906250, 0.0028076171875000, 0.0086059570312500, 0.0038452148437500,
0.0082702636718750, 0.0037231445312500, 0.0081787109375000, 0.0041503906250000,
0.0114746093750000, 0.0052795410156250, 0.0105285644531250, 0.0047607421875000,
0.0097351074218750, 0.0047607421875000, 0.0112915039062500, 0.0054931640625000,
0.0087585449218750, 0.0045166015625000, 0.0065612792968750, 0.0034179687500000,
0.0088806152343750, 0.0041809082031250, 0.0010375976562500, 0.0025024414062500,
0.0028991699218750},
{0.0071411132812500, -0.0004882812500000, 0.0065307617187500, -0.0005493164062500,
0.0075988769531250, -0.0014343261718750, 0.0083923339843750, -0.0015869140625000,
0.0074157714843750, -0.0006408691406250, 0.0086059570312500, -0.0033264160156250,
0.0091247558593750, -0.0039672851562500, 0.0084838867187500, -0.0026245117187500,
0.0085144042968750, -0.0029602050781250, 0.0086669921875000, -0.0036621093750000,
0.0063781738281250, -0.0000305175781250, 0.0070800781250000, -0.0008544921875000,
0.0061645507812500, -0.0002441406250000, 0.0039062500000000, 0.0029907226562500,
0.0050659179687500, 0.0018310546875000, 0.0041503906250000, 0.0007934570312500,
0.0033874511718750, 0.0018920898437500, 0.0038757324218750, 0.0005798339843750,
0.0045166015625000, -0.0031738281250000, 0.0014343261718750, 0.0011596679687500,
-0.0032958984375000, 0.0010070800781250, -0.0028991699218750, 0.0033569335937500,
-0.0024719238281250, 0.0007934570312500, -0.0037231445312500, -0.0027770996093750,
-0.0040588378906250, -0.0009765625000000, -0.0021362304687500, -0.0014343261718750,
-0.0025939941406250, -0.0032043457031250, -0.0026245117187500, -0.0012817382812500,
-0.0012207031250000, 0.0012207031250000, -0.0015869140625000, -0.0002136230468750,
-0.0023803710937500, 0.0018920898437500, -0.0020446777343750, 0.0022888183593750,
-0.0015869140625000, 0.0022277832031250, -0.0016784667968750, 0.0025329589843750,
-0.0018310546875000, 0.0022888183593750, -0.0018615722656250, 0.0049438476562500,
-0.0013122558593750, 0.0039062500000000, -0.0016479492187500, 0.0048217773437500,
-0.0019226074218750, 0.0078735351562500, -0.0015869140625000, 0.0065002441406250,
-0.0043640136718750, 0.0060729980468750, -0.0039367675781250, 0.0074462890625000,
-0.0032348632812500, 0.0059509277343750, -0.0052490234375000, 0.0036621093750000,
-0.0054016113281250, 0.0048217773437500, -0.0009765625000000, 0.0042114257812500,
-0.0023498535156250, 0.0033874511718750, -0.0005798339843750, 0.0042114257812500,
0.0037841796875000, 0.0051269531250000, 0.0017700195312500, 0.0046386718750000,
0.0043945312500000, 0.0053100585937500, 0.0053710937500000, 0.0057067871093750,
0.0041503906250000, 0.0052795410156250, 0.0043640136718750, 0.0051269531250000,
0.0051269531250000, 0.0054626464843750, 0.0028076171875000, 0.0047607421875000,
0.0022888183593750, 0.0047607421875000, 0.0035095214843750, 0.0044860839843750,
0.0031738281250000, 0.0043334960937500, 0.0026855468750000, 0.0046997070312500,
0.0061035156250000, 0.0025329589843750, 0.0049438476562500, 0.0031127929687500,
0.0063476562500000, 0.0021972656250000, 0.0095520019531250, -0.0002746582031250,
0.0074462890625000, 0.0007629394531250, 0.0098266601562500, -0.0002746582031250,
0.0112304687500000, -0.0010681152343750, 0.0084228515625000, 0.0000305175781250,
0.0076904296875000, 0.0006713867187500, 0.0096435546875000, -0.0000915527343750,
0.0014343261718750, 0.0018310546875000, 0.0032653808593750, 0.0019226074218750,
0.0010681152343750, 0.0020446777343750, -0.0053710937500000, 0.0028381347656250,
-0.0021362304687500, 0.0025634765625000, -0.0078735351562500, 0.0038452148437500,
-0.0083618164062500, 0.0036621093750000, -0.0081176757812500, 0.0038757324218750,
-0.0110473632812500, 0.0049743652343750, -0.0102233886718750, 0.0046997070312500,
-0.0086669921875000, 0.0039672851562500, -0.0105285644531250, 0.0045166015625000,
-0.0080566406250000, 0.0038452148437500, -0.0051269531250000, 0.0028381347656250,
-0.0079040527343750, 0.0033874511718750, -0.0021667480468750, 0.0019836425781250,
-0.0029907226562500, 0.0021972656250000, -0.0024414062500000, 0.0013732910156250,
0.0010681152343750, 0.0001525878906250, -0.0010070800781250, 0.0009765625000000,
0.0015563964843750, -0.0014343261718750, 0.0016784667968750, -0.0013732910156250,
0.0013122558593750, -0.0014648437500000, 0.0024108886718750, -0.0028381347656250,
0.0018005371093750, -0.0023498535156250, 0.0015869140625000, -0.0028686523437500,
0.0018615722656250, -0.0028381347656250, 0.0010986328125000, -0.0031738281250000,
0.0006103515625000, -0.0036315917968750, 0.0010681152343750, -0.0033569335937500,
-0.0010070800781250, -0.0039672851562500, -0.0004577636718750, -0.0041809082031250,
-0.0012817382812500, -0.0039062500000000, -0.0031127929687500, -0.0040283203125000,
-0.0018615722656250, -0.0041503906250000, -0.0038452148437500, -0.0034790039062500,
-0.0039367675781250, -0.0035705566406250, -0.0038757324218750, -0.0034179687500000,
-0.0047302246093750, -0.0030212402343750, -0.0042419433593750, -0.0032348632812500,
-0.0041198730468750, -0.0025024414062500, -0.0040893554687500, -0.0027160644531250,
-0.0035705566406250, -0.0024414062500000, -0.0031738281250000, -0.0017089843750000,
-0.0032958984375000, -0.0021667480468750, -0.0024414062500000, -0.0016784667968750,
-0.0022583007812500, -0.0015563964843750, -0.0018920898437500, -0.0018615722656250,
-0.0014343261718750, -0.0019226074218750, -0.0016479492187500, -0.0018615722656250,
-0.0005493164062500, -0.0025939941406250, -0.0005187988281250, -0.0026855468750000,
-0.0000610351562500, -0.0025329589843750, 0.0007934570312500, -0.0029602050781250,
0.0007324218750000, -0.0030822753906250, 0.0020751953125000, -0.0018310546875000,
0.0018920898437500, -0.0023803710937500, 0.0025024414062500, -0.0019531250000000,
0.0037536621093750, -0.0005798339843750, 0.0033264160156250, -0.0012207031250000,
0.0046997070312500, -0.0008850097656250, 0.0049743652343750, -0.0002441406250000,
0.0050048828125000, -0.0011596679687500, 0.0057678222656250, -0.0018310546875000,
0.0056762695312500, -0.0010986328125000, 0.0054931640625000, -0.0030822753906250,
0.0058593750000000, -0.0032043457031250, 0.0052795410156250, -0.0025329589843750,
0.0047607421875000, -0.0033264160156250, 0.0051879882812500, -0.0035705566406250,
0.0032958984375000, -0.0010681152343750, 0.0034484863281250, -0.0018615722656250,
0.0025634765625000, -0.0006103515625000, 0.0007629394531250, 0.0018615722656250,
0.0011596679687500, 0.0004272460937500, -0.0015258789062500, 0.0029602050781250,
-0.0014953613281250, 0.0033874511718750, -0.0022277832031250, 0.0027160644531250,
-0.0042724609375000, 0.0033874511718750, -0.0038146972656250, 0.0035705566406250,
-0.0050354003906250, 0.0024719238281250, -0.0055236816406250, 0.0026855468750000,
-0.0052185058593750, 0.0025939941406250, -0.0054626464843750, 0.0017395019531250,
-0.0055541992187500, 0.0019836425781250, -0.0037536621093750, 0.0021667480468750,
-0.0041503906250000, 0.0021667480468750, -0.0036926269531250, 0.0016784667968750,
-0.0020141601562500, 0.0014343261718750, -0.0024414062500000, 0.0019531250000000,
-0.0023803710937500, 0.0004272460937500, -0.0019836425781250, 0.0004882812500000,
-0.0019226074218750, 0.0007324218750000, -0.0019531250000000, -0.0000915527343750,
-0.0020141601562500, 0.0000000000000000, -0.0018920898437500, 0.0009460449218750,
-0.0016479492187500, 0.0003967285156250, -0.0019226074218750, 0.0015869140625000,
-0.0022583007812500, 0.0028991699218750, -0.0019836425781250, 0.0016784667968750,
-0.0020446777343750, 0.0045166015625000, -0.0019226074218750, 0.0044555664062500,
-0.0019836425781250, 0.0049438476562500, -0.0019531250000000, 0.0065307617187500,
-0.0016784667968750, 0.0056152343750000, -0.0026245117187500, 0.0073242187500000,
-0.0024719238281250, 0.0076599121093750, -0.0021362304687500, 0.0074157714843750,
-0.0026550292968750, 0.0082092285156250, -0.0026855468750000, 0.0080566406250000,
-0.0013732910156250, 0.0063781738281250, -0.0018005371093750, 0.0071716308593750,
-0.0011291503906250, 0.0061950683593750, 0.0001831054687500, 0.0041809082031250,
-0.0005187988281250, 0.0054321289062500, 0.0006713867187500, 0.0034484863281250,
0.0014648437500000, 0.0030212402343750, -0.0005798339843750, 0.0031738281250000,
-0.0014648437500000, 0.0028686523437500, -0.0000305175781250, 0.0032348632812500,
-0.0049743652343750, 0.0017700195312500, -0.0049743652343750, 0.0020751953125000,
-0.0047302246093750, 0.0015563964843750, -0.0073852539062500, 0.0003356933593750,
-0.0069580078125000, 0.0010681152343750, -0.0052185058593750, -0.0002136230468750,
-0.0061950683593750, -0.0004272460937500, -0.0051574707031250, 0.0004272460937500,
-0.0025939941406250, 0.0007629394531250, -0.0033264160156250, 0.0008239746093750,
-0.0029296875000000, 0.0021972656250000, -0.0025939941406250, 0.0022583007812500,
-0.0024108886718750, 0.0019836425781250, -0.0025634765625000, 0.0023803710937500,
-0.0027160644531250, 0.0024414062500000, -0.0011901855468750, 0.0022583007812500,
-0.0013427734375000, 0.0028381347656250, -0.0014953613281250, 0.0013732910156250,
-0.0007934570312500, 0.0003662109375000, -0.0007324218750000, 0.0016174316406250,
-0.0006713867187500, -0.0031433105468750, -0.0010070800781250, -0.0028381347656250,
-0.0003356933593750, -0.0027465820312500, 0.0000915527343750, -0.0057678222656250,
-0.0005187988281250, -0.0054321289062500, 0.0020141601562500, -0.0031127929687500,
0.0018005371093750, -0.0040588378906250, 0.0016479492187500, -0.0030822753906250,
0.0028991699218750, -0.0006103515625000, 0.0027465820312500, -0.0018310546875000,
0.0032958984375000, -0.0011291503906250, 0.0027160644531250, -0.0003662109375000,
0.0036010742187500, -0.0009460449218750, 0.0046081542968750, -0.0017700195312500,
0.0036926269531250, -0.0013122558593750, 0.0063476562500000, 0.0000915527343750,
0.0061340332031250, -0.0008239746093750, 0.0062561035156250, 0.0006408691406250,
0.0078735351562500, 0.0031433105468750, 0.0073242187500000, 0.0019531250000000,
0.0076599121093750, 0.0034790039062500, 0.0077514648437500, 0.0046081542968750,
0.0076904296875000, 0.0035095214843750, 0.0078735351562500, 0.0029296875000000,
0.0078735351562500, 0.0037536621093750, 0.0072937011718750, 0.0009155273437500,
0.0083923339843750, 0.0017395019531250, 0.0063781738281250, 0.0005493164062500,
0.0044860839843750, -0.0021667480468750, 0.0064086914062500, -0.0005798339843750,
0.0009765625000000, -0.0026550292968750, 0.0021972656250000, -0.0030822753906250,
0.0007324218750000, -0.0030517578125000, -0.0038757324218750, -0.0035705566406250,
-0.0013122558593750, -0.0032653808593750, -0.0030212402343750, -0.0049438476562500,
-0.0044250488281250, -0.0041198730468750, -0.0027770996093750, -0.0053100585937500,
-0.0020141601562500, -0.0074157714843750, -0.0032043457031250, -0.0060729980468750,
0.0006103515625000, -0.0089111328125000, -0.0002136230468750, -0.0089416503906250,
0.0001831054687500, -0.0085449218750000, 0.0028381347656250, -0.0094909667968750,
0.0015563964843750, -0.0088806152343750, 0.0032348632812500, -0.0079650878906250,
0.0033874511718750, -0.0078430175781250, 0.0028381347656250, -0.0069580078125000,
0.0033874511718750, -0.0057983398437500, 0.0035095214843750, -0.0058288574218750,
0.0026855468750000, -0.0047607421875000, 0.0029602050781250, -0.0044860839843750,
0.0025024414062500, -0.0040283203125000, 0.0017395019531250, -0.0033264160156250,
0.0024108886718750, -0.0033874511718750, 0.0014343261718750, -0.0028381347656250,
0.0013122558593750, -0.0030517578125000, 0.0014038085937500, -0.0028991699218750,
0.0013122558593750, -0.0025939941406250, 0.0014648437500000, -0.0032043457031250,
-0.0000305175781250, -0.0026245117187500, 0.0006713867187500, -0.0031433105468750,
0.0000915527343750, -0.0032043457031250, -0.0015869140625000, -0.0028076171875000,
-0.0007324218750000, -0.0036315917968750, -0.0016784667968750, -0.0034179687500000,
-0.0018005371093750, -0.0030517578125000, -0.0019531250000000, -0.0030822753906250,
-0.0024719238281250},
{-0.0048217773437500, 0.0021972656250000, -0.0065917968750000, 0.0044860839843750,
-0.0064697265625000, 0.0040588378906250, -0.0044250488281250, 0.0024108886718750,
-0.0053710937500000, 0.0032043457031250, -0.0051879882812500, 0.0025024414062500,
-0.0034179687500000, 0.0011596679687500, -0.0039672851562500, 0.0020141601562500,
-0.0026245117187500, -0.0018005371093750, -0.0029907226562500, -0.0011901855468750,
-0.0021057128906250, -0.0018920898437500, -0.0006103515625000, -0.0050659179687500,
-0.0015869140625000, -0.0038757324218750, -0.0001220703125000, -0.0031738281250000,
0.0004272460937500, -0.0046386718750000, -0.0001525878906250, -0.0029602050781250,
-0.0000610351562500, -0.0002441406250000, 0.0003356933593750, -0.0015258789062500,
-0.0004882812500000, -0.0001831054687500, -0.0009155273437500, 0.0007934570312500,
-0.0001220703125000, -0.0002136230468750, 0.0001525878906250, -0.0008850097656250,
-0.0004577636718750, -0.0001831054687500, 0.0013122558593750, -0.0010375976562500,
0.0011291503906250, -0.0017700195312500, 0.0011596679687500, -0.0001525878906250,
0.0021057128906250, 0.0009765625000000, 0.0018310546875000, -0.0000305175781250,
0.0029602050781250, 0.0028991699218750, 0.0021362304687500, 0.0035705566406250,
0.0035095214843750, 0.0024719238281250, 0.0052490234375000, 0.0031433105468750,
0.0036621093750000, 0.0038757324218750, 0.0066528320312500, 0.0010375976562500,
0.0065917968750000, 0.0014038085937500, 0.0064086914062500, 0.0010070800781250,
0.0079040527343750, -0.0005798339843750, 0.0073852539062500, 0.0003051757812500,
0.0074462890625000, -0.0013122558593750, 0.0075988769531250, -0.0012512207031250,
0.0073547363281250, -0.0012512207031250, 0.0074462890625000, -0.0020446777343750,
0.0075683593750000, -0.0018005371093750, 0.0059204101562500, -0.0032653808593750,
0.0068054199218750, -0.0027160644531250, 0.0050354003906250, -0.0036621093750000,
0.0032043457031250, -0.0054931640625000, 0.0052185058593750, -0.0044250488281250,
-0.0008850097656250, -0.0056762695312500, -0.0001220703125000, -0.0061035156250000,
-0.0002441406250000, -0.0049438476562500, -0.0040283203125000, -0.0045471191406250,
-0.0025634765625000, -0.0047302246093750, -0.0029907226562500, -0.0024108886718750,
-0.0040283203125000, -0.0018615722656250, -0.0023803710937500, -0.0009765625000000,
-0.0010681152343750, 0.0006408691406250, -0.0023803710937500, 0.0005493164062500,
0.0007324218750000, 0.0012512207031250, 0.0004272460937500, 0.0014648437500000,
0.0010070800781250, 0.0015258789062500, 0.0029602050781250, 0.0015258789062500,
0.0017700195312500, 0.0012512207031250, 0.0036010742187500, 0.0020446777343750,
0.0036010742187500, 0.0011901855468750, 0.0036621093750000, 0.0017395019531250,
0.0047302246093750, 0.0025329589843750, 0.0042114257812500, 0.0010681152343750,
0.0039062500000000, 0.0033264160156250, 0.0045166015625000, 0.0024414062500000,
0.0038757324218750, 0.0027160644531250, 0.0028076171875000, 0.0044250488281250,
0.0033264160156250, 0.0031127929687500, 0.0024414062500000, 0.0050048828125000,
0.0027770996093750, 0.0046081542968750, 0.0017700195312500, 0.0047912597656250,
0.0007629394531250, 0.0059814453125000, 0.0018615722656250, 0.0050354003906250,
-0.0011291503906250, 0.0060729980468750, -0.0008850097656250, 0.0063476562500000,
-0.0011901855468750, 0.0061950683593750, -0.0029907226562500, 0.0065002441406250,
-0.0022888183593750, 0.0065307617187500, -0.0032958984375000, 0.0066833496093750,
-0.0033264160156250, 0.0064086914062500, -0.0033264160156250, 0.0064392089843750,
-0.0038452148437500, 0.0065917968750000, -0.0036315917968750, 0.0062866210937500,
-0.0035400390625000, 0.0064086914062500, -0.0038146972656250, 0.0060729980468750,
-0.0034790039062500, 0.0061340332031250, -0.0030517578125000, 0.0061340332031250,
-0.0032958984375000, 0.0054931640625000, -0.0027160644531250, 0.0062866210937500,
-0.0025634765625000, 0.0057067871093750, -0.0027160644531250, 0.0057373046875000,
-0.0025634765625000, 0.0063171386718750, -0.0024719238281250, 0.0054931640625000,
-0.0027160644531250, 0.0063781738281250, -0.0027160644531250, 0.0057983398437500,
-0.0025024414062500, 0.0057983398437500, -0.0025024414062500, 0.0063476562500000,
-0.0024719238281250, 0.0054321289062500, -0.0019226074218750, 0.0060424804687500,
-0.0019531250000000, 0.0058288574218750, -0.0016784667968750, 0.0053100585937500,
-0.0012512207031250, 0.0054626464843750, -0.0014038085937500, 0.0052490234375000,
-0.0006103515625000, 0.0039062500000000, -0.0007324218750000, 0.0043029785156250,
-0.0001525878906250, 0.0035095214843750, 0.0007019042968750, 0.0022888183593750,
0.0002441406250000, 0.0030517578125000, 0.0017700195312500, 0.0010986328125000,
0.0017700195312500, 0.0012512207031250, 0.0019531250000000, 0.0007934570312500,
0.0028991699218750, -0.0005187988281250, 0.0026550292968750, 0.0001525878906250,
0.0030212402343750, -0.0010375976562500, 0.0032653808593750, -0.0013427734375000,
0.0029296875000000, -0.0008544921875000, 0.0029296875000000, -0.0009765625000000,
0.0032348632812500, -0.0010681152343750, 0.0016479492187500, 0.0003662109375000,
0.0021667480468750, 0.0002746582031250, 0.0015258789062500, 0.0007324218750000,
0.0001525878906250, 0.0020141601562500, 0.0009155273437500, 0.0016784667968750,
-0.0007324218750000, 0.0020751953125000, -0.0006713867187500, 0.0027770996093750,
-0.0009155273437500, 0.0018920898437500, -0.0021362304687500, 0.0014648437500000,
-0.0016784667968750, 0.0023193359375000, -0.0014648437500000, -0.0008850097656250,
-0.0023193359375000, -0.0003662109375000, -0.0010681152343750, -0.0009765625000000,
0.0001831054687500, -0.0033874511718750, -0.0009460449218750, -0.0027465820312500,
0.0021972656250000, -0.0042114257812500, 0.0020751953125000, -0.0043029785156250,
0.0025329589843750, -0.0040283203125000, 0.0045471191406250, -0.0048522949218750,
0.0039367675781250, -0.0043029785156250, 0.0047302246093750, -0.0015258789062500,
0.0049743652343750, -0.0034179687500000, 0.0054321289062500, -0.0001220703125000,
0.0056762695312500, 0.0045471191406250, 0.0051269531250000, 0.0017700195312500,
0.0075988769531250, 0.0083923339843750, 0.0073547363281250, 0.0089111328125000,
0.0076904296875000, 0.0089111328125000, 0.0091552734375000, 0.0119934082031250,
0.0084838867187500, 0.0111694335937500, 0.0096130371093750, 0.0118103027343750,
0.0097351074218750, 0.0123596191406250, 0.0095825195312500, 0.0111083984375000,
0.0100097656250000, 0.0106201171875000, 0.0097656250000000, 0.0112915039062500,
0.0093383789062500, 0.0074462890625000, 0.0100097656250000, 0.0082702636718750,
0.0088500976562500, 0.0061950683593750, 0.0077209472656250, 0.0024414062500000,
0.0086364746093750, 0.0044250488281250, 0.0046997070312500, 0.0007324218750000,
0.0053710937500000, 0.0004882812500000, 0.0050354003906250, 0.0004577636718750,
0.0018920898437500, -0.0013122558593750, 0.0025939941406250, -0.0004882812500000,
0.0032958984375000, -0.0004577636718750, 0.0024108886718750, -0.0012207031250000,
0.0034484863281250, -0.0005493164062500, 0.0051269531250000, 0.0000305175781250,
0.0038757324218750, -0.0005187988281250, 0.0041809082031250, 0.0024719238281250,
0.0056762695312500, 0.0021667480468750, 0.0026245117187500, 0.0015563964843750,
0.0000305175781250, 0.0034790039062500, 0.0024108886718750, 0.0036926269531250,
-0.0036926269531250, -0.0002441406250000, -0.0045471191406250, 0.0009460449218750,
-0.0029602050781250, 0.0003967285156250, -0.0046691894531250, -0.0045776367187500,
-0.0003356933593750, 0.0034484863281250, -0.0005187988281250, -0.0023193359375000,
-0.0004272460937500, -0.0003662109375000, -0.0003662109375000, -0.0005798339843750,
-0.0005493164062500, -0.0036315917968750, -0.0007934570312500, -0.0034790039062500,
-0.0003051757812500, -0.0005187988281250, 0.0003051757812500, -0.0011596679687500,
-0.0008239746093750, -0.0010375976562500, -0.0011596679687500, 0.0010681152343750,
-0.0003967285156250, 0.0005187988281250, -0.0052795410156250, -0.0003662109375000,
-0.0045471191406250, 0.0000000000000000, -0.0043029785156250, 0.0000915527343750,
-0.0079956054687500, -0.0009460449218750, -0.0076904296875000, -0.0008850097656250,
-0.0034790039062500, 0.0015258789062500, -0.0059204101562500, 0.0009155273437500,
-0.0023498535156250, 0.0013427734375000, 0.0034790039062500, 0.0033569335937500,
-0.0003051757812500, 0.0027770996093750, 0.0063171386718750, 0.0029296875000000,
0.0075073242187500, 0.0030212402343750, 0.0066223144531250, 0.0032348632812500,
0.0084533691406250, 0.0031738281250000, 0.0083007812500000, 0.0028686523437500,
0.0088500976562500, 0.0044250488281250, 0.0085449218750000, 0.0039978027343750,
0.0087585449218750, 0.0046386718750000, 0.0095825195312500, 0.0061645507812500,
0.0092468261718750, 0.0053405761718750, 0.0090637207031250, 0.0055541992187500,
0.0096130371093750, 0.0063781738281250, 0.0081176757812500, 0.0052185058593750,
0.0073242187500000, 0.0039062500000000, 0.0084228515625000, 0.0046691894531250,
0.0022583007812500, 0.0040893554687500, 0.0038452148437500, 0.0035095214843750,
0.0016174316406250, 0.0040283203125000, -0.0038757324218750, 0.0046691894531250,
-0.0010681152343750, 0.0043945312500000, -0.0057678222656250, 0.0040588378906250,
-0.0066833496093750, 0.0043945312500000, -0.0049743652343750, 0.0040283203125000,
-0.0065307617187500, 0.0032348632812500, -0.0072631835937500, 0.0036010742187500,
-0.0014038085937500, 0.0037231445312500, -0.0034790039062500, 0.0033874511718750,
-0.0015869140625000, 0.0036621093750000, 0.0039978027343750, 0.0043334960937500,
0.0011291503906250, 0.0040893554687500, 0.0039367675781250, 0.0032653808593750,
0.0051879882812500, 0.0038757324218750, 0.0035095214843750, 0.0031433105468750,
0.0034179687500000, 0.0017395019531250, 0.0043029785156250, 0.0023803710937500,
0.0003967285156250, 0.0016174316406250, 0.0012817382812500, 0.0012512207031250,
-0.0001525878906250, 0.0013427734375000, -0.0033874511718750, 0.0012512207031250,
-0.0015869140625000, 0.0013122558593750, -0.0045166015625000, 0.0012207031250000,
-0.0053100585937500, 0.0010375976562500, -0.0043334960937500, 0.0014953613281250,
-0.0050048828125000, 0.0018005371093750, -0.0054626464843750, 0.0015563964843750,
-0.0031127929687500, 0.0025329589843750, -0.0039672851562500, 0.0026855468750000,
-0.0030517578125000, 0.0025329589843750, -0.0008850097656250, 0.0028381347656250,
-0.0023498535156250, 0.0029296875000000, 0.0001220703125000, 0.0025939941406250,
0.0000610351562500, 0.0026855468750000, -0.0001220703125000, 0.0025024414062500,
0.0011596679687500, 0.0023498535156250, 0.0007324218750000, 0.0024719238281250,
0.0007019042968750, 0.0013427734375000, 0.0011901855468750, 0.0016784667968750,
0.0006103515625000, 0.0010375976562500, 0.0001220703125000, -0.0003662109375000,
0.0006713867187500, 0.0002441406250000, -0.0009765625000000, -0.0006713867187500,
-0.0004882812500000, -0.0010375976562500, -0.0006408691406250, -0.0008239746093750,
-0.0018005371093750, -0.0008850097656250, -0.0011291503906250, -0.0010375976562500,
-0.0019226074218750, -0.0010375976562500, -0.0016784667968750, -0.0009460449218750,
-0.0015258789062500, -0.0012207031250000, -0.0017700195312500, -0.0015563964843750,
-0.0013427734375000, -0.0013732910156250, -0.0016784667968750, -0.0019226074218750,
-0.0013427734375000, -0.0019531250000000, -0.0014343261718750, -0.0019836425781250,
-0.0017700195312500, -0.0022583007812500, -0.0011596679687500, -0.0021667480468750,
-0.0018615722656250},
{0.0006408691406250, -0.0003967285156250, 0.0072021484375000, -0.0003051757812500,
0.0071411132812500, -0.0001220703125000, 0.0074768066406250, 0.0002441406250000,
0.0110778808593750, 0.0003356933593750, 0.0101013183593750, 0.0000000000000000,
0.0119018554687500, 0.0015869140625000, 0.0118103027343750, 0.0013732910156250,
0.0119323730468750, 0.0016479492187500, 0.0137023925781250, 0.0027770996093750,
0.0130920410156250, 0.0022888183593750, 0.0105590820312500, 0.0024719238281250,
0.0126037597656250, 0.0025939941406250, 0.0090332031250000, 0.0025634765625000,
0.0045166015625000, 0.0022583007812500, 0.0076599121093750, 0.0022583007812500,
-0.0006103515625000, 0.0039367675781250, -0.0002441406250000, 0.0033264160156250,
-0.0007629394531250, 0.0038146972656250, -0.0060424804687500, 0.0056457519531250,
-0.0042419433593750, 0.0048828125000000, -0.0036926269531250, 0.0039978027343750,
-0.0056762695312500, 0.0046386718750000, -0.0034179687500000, 0.0041503906250000,
-0.0009460449218750, 0.0027160644531250, -0.0030212402343750, 0.0030517578125000,
0.0020141601562500, 0.0033874511718750, 0.0016174316406250, 0.0031433105468750,
0.0016174316406250, 0.0032348632812500, 0.0048522949218750, 0.0038146972656250,
0.0037841796875000, 0.0037536621093750, 0.0023803710937500, 0.0030517578125000,
0.0039672851562500, 0.0032348632812500, 0.0018310546875000, 0.0032653808593750,
-0.0011901855468750, 0.0026550292968750, 0.0008239746093750, 0.0026855468750000,
-0.0025634765625000, 0.0039672851562500, -0.0030212402343750, 0.0036315917968750,
-0.0024108886718750, 0.0035705566406250, -0.0037231445312500, 0.0046691894531250,
-0.0037231445312500, 0.0046081542968750, -0.0024108886718750, 0.0030517578125000,
-0.0030822753906250, 0.0035705566406250, -0.0018615722656250, 0.0029296875000000,
-0.0001525878906250, 0.0013427734375000, -0.0016174316406250, 0.0019531250000000,
0.0010681152343750, 0.0011291503906250, 0.0013427734375000, 0.0008850097656250,
0.0002136230468750, 0.0010375976562500, 0.0010070800781250, 0.0007629394531250,
0.0013427734375000, 0.0007934570312500, -0.0018005371093750, 0.0012512207031250,
-0.0006103515625000, 0.0010070800781250, -0.0023498535156250, 0.0013427734375000,
-0.0054016113281250, 0.0019836425781250, -0.0031433105468750, 0.0016784667968750,
-0.0077209472656250, 0.0020141601562500, -0.0073547363281250, 0.0022583007812500,
-0.0077209472656250, 0.0019531250000000, -0.0104675292968750, 0.0016479492187500,
-0.0089721679687500, 0.0018310546875000, -0.0104064941406250, 0.0016784667968750,
-0.0108337402343750, 0.0014648437500000, -0.0099487304687500, 0.0016784667968750,
-0.0100708007812500, 0.0019836425781250, -0.0103759765625000, 0.0017700195312500,
-0.0081481933593750, 0.0016784667968750, -0.0090637207031250, 0.0018920898437500,
-0.0079040527343750, 0.0014953613281250, -0.0057678222656250, 0.0009765625000000,
-0.0072631835937500, 0.0012512207031250, -0.0041809082031250, 0.0003662109375000,
-0.0045776367187500, 0.0005187988281250, -0.0039978027343750, 0.0000610351562500,
-0.0020446777343750, -0.0006713867187500, -0.0033874511718750, -0.0002441406250000,
-0.0011901855468750, -0.0015258789062500, -0.0016784667968750, -0.0016174316406250,
-0.0014648437500000, -0.0016174316406250, -0.0001220703125000, -0.0022583007812500,
-0.0012207031250000, -0.0021667480468750, -0.0000305175781250, -0.0017089843750000,
-0.0003051757812500, -0.0020141601562500, -0.0005187988281250, -0.0016174316406250,
0.0000305175781250, -0.0010375976562500, -0.0005493164062500, -0.0014038085937500,
-0.0004882812500000, -0.0008239746093750, -0.0008239746093750, -0.0007019042968750,
-0.0009460449218750, -0.0007934570312500, -0.0009460449218750, -0.0005798339843750,
-0.0014648437500000, -0.0005798339843750, -0.0013427734375000, -0.0005798339843750,
-0.0014038085937500, -0.0007324218750000, -0.0017395019531250, -0.0002136230468750,
-0.0018005371093750, -0.0000610351562500, -0.0018920898437500, -0.0004882812500000,
-0.0027160644531250, 0.0017700195312500, -0.0024719238281250, 0.0012512207031250,
-0.0028686523437500, 0.0017395019531250, -0.0036926269531250, 0.0036010742187500,
-0.0032043457031250, 0.0028076171875000, -0.0038146972656250, 0.0035705566406250,
-0.0039978027343750, 0.0039367675781250, -0.0035400390625000, 0.0034179687500000,
-0.0034179687500000, 0.0035705566406250, -0.0033569335937500, 0.0038757324218750,
-0.0021362304687500, 0.0018615722656250, -0.0022277832031250, 0.0024108886718750,
-0.0015869140625000, 0.0021972656250000, -0.0004272460937500, 0.0005493164062500,
-0.0006713867187500, 0.0010681152343750, 0.0006103515625000, 0.0011901855468750,
0.0007019042968750, 0.0007934570312500, 0.0007629394531250, 0.0011901855468750,
0.0014343261718750, 0.0016784667968750, 0.0013427734375000, 0.0013732910156250,
0.0014343261718750, 0.0021667480468750, 0.0014343261718750, 0.0020446777343750,
0.0016174316406250, 0.0022583007812500, 0.0016784667968750, 0.0028991699218750,
0.0015258789062500, 0.0026245117187500, 0.0030212402343750, 0.0031738281250000,
0.0021667480468750, 0.0030212402343750, 0.0036010742187500, 0.0036010742187500,
0.0056457519531250, 0.0042114257812500, 0.0041503906250000, 0.0036010742187500,
0.0074768066406250, 0.0046997070312500, 0.0075378417968750, 0.0048828125000000,
0.0075683593750000, 0.0044555664062500, 0.0094604492187500, 0.0047912597656250,
0.0089111328125000, 0.0048828125000000, 0.0079345703125000, 0.0027465820312500,
0.0090637207031250, 0.0033569335937500, 0.0075378417968750, 0.0027465820312500,
0.0053405761718750, 0.0007629394531250, 0.0066528320312500, 0.0016174316406250,
0.0036315917968750, 0.0008544921875000, 0.0036621093750000, 0.0001831054687500,
0.0034179687500000, 0.0010986328125000, 0.0016479492187500, 0.0016784667968750,
0.0023193359375000, 0.0010070800781250, 0.0021057128906250, 0.0020446777343750,
0.0018310546875000, 0.0022277832031250, 0.0016174316406250, 0.0015563964843750,
0.0016784667968750, 0.0016479492187500, 0.0018615722656250, 0.0019836425781250,
-0.0002441406250000, 0.0006713867187500, 0.0002441406250000, 0.0006713867187500,
-0.0007629394531250, 0.0008239746093750, -0.0031127929687500, -0.0000610351562500,
-0.0021362304687500, 0.0000305175781250, -0.0024719238281250, 0.0021362304687500,
-0.0037231445312500, 0.0014648437500000, -0.0021667480468750, 0.0014343261718750,
-0.0005798339843750, 0.0030517578125000, -0.0018005371093750, 0.0027465820312500,
0.0011291503906250, 0.0024719238281250, 0.0015869140625000, 0.0027770996093750,
0.0003356933593750, 0.0020446777343750, 0.0008544921875000, 0.0016479492187500,
0.0015258789062500, 0.0021057128906250, -0.0014953613281250, -0.0014953613281250,
-0.0013122558593750, -0.0007324218750000, -0.0013122558593750, -0.0009155273437500,
-0.0030517578125000, -0.0037841796875000, -0.0028381347656250, -0.0034484863281250,
-0.0023498535156250, -0.0028381347656250, -0.0022277832031250, -0.0035095214843750,
-0.0028991699218750, -0.0023498535156250, -0.0030212402343750, -0.0012512207031250,
-0.0023803710937500, -0.0023498535156250, -0.0042114257812500, 0.0012207031250000,
-0.0043029785156250, 0.0012207031250000, -0.0042419433593750, 0.0011291503906250,
-0.0050964355468750, 0.0032653808593750, -0.0047912597656250, 0.0029602050781250,
-0.0046386718750000, 0.0017700195312500, -0.0051574707031250, 0.0022583007812500,
-0.0044250488281250, 0.0021972656250000, -0.0038146972656250, 0.0014038085937500,
-0.0044860839843750, 0.0017395019531250, -0.0018615722656250, 0.0015869140625000,
-0.0025024414062500, 0.0016174316406250, -0.0015563964843750, 0.0017089843750000,
0.0008544921875000, 0.0016174316406250, -0.0004272460937500, 0.0017700195312500,
0.0012817382812500, 0.0021057128906250, 0.0018005371093750, 0.0019836425781250,
0.0011291503906250, 0.0021667480468750, 0.0011596679687500, 0.0027770996093750,
0.0014038085937500, 0.0026855468750000, 0.0008850097656250, 0.0015258789062500,
0.0006408691406250, 0.0022888183593750, 0.0008850097656250, 0.0014038085937500,
0.0010070800781250, -0.0000305175781250, 0.0008850097656250, 0.0009765625000000,
0.0009460449218750, -0.0014038085937500, 0.0007019042968750, -0.0017395019531250,
0.0010986328125000, -0.0009460449218750, 0.0012207031250000, -0.0016784667968750,
0.0006408691406250, -0.0019836425781250, 0.0025939941406250, 0.0004272460937500,
0.0017089843750000, -0.0002136230468750, 0.0026245117187500, 0.0010375976562500,
0.0046691894531250, 0.0036010742187500, 0.0033874511718750, 0.0024108886718750,
0.0055847167968750, 0.0043640136718750, 0.0056762695312500, 0.0053710937500000,
0.0050048828125000, 0.0044555664062500, 0.0057983398437500, 0.0043334960937500,
0.0059814453125000, 0.0051269531250000, 0.0053405761718750, 0.0032348632812500,
0.0053710937500000, 0.0027160644531250, 0.0048217773437500, 0.0033264160156250,
0.0045776367187500, 0.0025634765625000, 0.0052185058593750, 0.0017700195312500,
0.0028991699218750, 0.0041809082031250, 0.0033569335937500, 0.0028991699218750,
0.0028686523437500, 0.0034179687500000, 0.0012817382812500, 0.0055236816406250,
0.0022583007812500, 0.0038146972656250, 0.0004577636718750, 0.0051269531250000,
0.0004272460937500, 0.0050964355468750, 0.0007629394531250, 0.0040893554687500,
0.0001220703125000, 0.0041198730468750, 0.0003356933593750, 0.0038757324218750,
0.0008239746093750, 0.0021972656250000, 0.0005798339843750, 0.0022888183593750,
0.0008239746093750, 0.0013732910156250, 0.0012817382812500, -0.0002136230468750,
0.0010070800781250, 0.0003662109375000, 0.0015258789062500, -0.0012817382812500,
0.0010986328125000, -0.0014953613281250, 0.0017700195312500, -0.0014648437500000,
0.0025939941406250, -0.0022583007812500, 0.0016479492187500, -0.0020751953125000,
0.0030517578125000, -0.0017700195312500, 0.0032653808593750, -0.0019226074218750,
0.0028076171875000, -0.0014343261718750, 0.0030822753906250, -0.0006713867187500,
0.0030822753906250, -0.0007629394531250, 0.0023803710937500, 0.0000000000000000,
0.0027160644531250, 0.0002746582031250, 0.0021362304687500, 0.0004272460937500,
0.0014038085937500, 0.0008850097656250, 0.0020141601562500, 0.0009460449218750,
0.0003662109375000, 0.0009155273437500, 0.0006103515625000, 0.0013122558593750,
0.0001831054687500, 0.0014038085937500, -0.0010070800781250, 0.0012512207031250,
-0.0003356933593750, 0.0014953613281250, -0.0019836425781250, 0.0014953613281250,
-0.0018310546875000, 0.0018615722656250, -0.0018005371093750, 0.0018005371093750,
-0.0028076171875000, 0.0017089843750000, -0.0024414062500000, 0.0022888183593750,
-0.0019836425781250, 0.0018310546875000, -0.0024108886718750, 0.0020751953125000,
-0.0017089843750000, 0.0020446777343750, -0.0008850097656250, 0.0017700195312500,
-0.0013732910156250, 0.0021667480468750, -0.0001220703125000, 0.0014343261718750,
-0.0001525878906250, 0.0018005371093750, 0.0001525878906250, 0.0017700195312500,
0.0009765625000000, 0.0012817382812500, 0.0005798339843750, 0.0018005371093750,
0.0015869140625000, 0.0011596679687500, 0.0016479492187500, 0.0015869140625000,
0.0017395019531250, 0.0010070800781250, 0.0023803710937500, 0.0003662109375000,
0.0021667480468750, 0.0012207031250000, 0.0023498535156250, -0.0010375976562500,
0.0024108886718750, -0.0003662109375000, 0.0023498535156250, -0.0011901855468750,
0.0024108886718750, -0.0032348632812500, 0.0023498535156250, -0.0020751953125000,
0.0018615722656250, -0.0045776367187500, 0.0020446777343750, -0.0043029785156250,
0.0016174316406250},
{0.0007324218750000, 0.0008544921875000, 0.0006713867187500, 0.0019836425781250,
0.0001831054687500, 0.0051269531250000, 0.0002441406250000, 0.0037841796875000,
0.0004272460937500, 0.0055236816406250, 0.0001525878906250, 0.0063171386718750,
0.0006713867187500, 0.0051879882812500, 0.0009155273437500, 0.0049133300781250,
0.0002746582031250, 0.0054321289062500, 0.0020751953125000, 0.0030517578125000,
0.0013427734375000, 0.0026550292968750, 0.0023498535156250, 0.0030212402343750,
0.0043334960937500, 0.0018005371093750, 0.0028991699218750, 0.0010681152343750,
0.0046997070312500, 0.0030212402343750, 0.0050659179687500, 0.0019226074218750,
0.0050048828125000, 0.0019836425781250, 0.0056152343750000, 0.0036010742187500,
0.0052490234375000, 0.0023803710937500, 0.0047912597656250, 0.0023498535156250,
0.0055236816406250, 0.0023193359375000, 0.0048522949218750, 0.0013122558593750,
0.0036621093750000, 0.0005493164062500, 0.0042419433593750, 0.0006103515625000,
0.0030822753906250, -0.0000305175781250, 0.0032348632812500, -0.0005493164062500,
0.0028076171875000, -0.0002746582031250, 0.0019226074218750, -0.0001831054687500,
0.0025024414062500, -0.0006408691406250, 0.0012207031250000, 0.0006408691406250,
0.0014343261718750, 0.0003662109375000, 0.0013427734375000, 0.0010986328125000,
0.0005187988281250, 0.0023498535156250, 0.0010375976562500, 0.0018920898437500,
0.0005187988281250, 0.0038146972656250, 0.0005493164062500, 0.0038452148437500,
0.0007324218750000, 0.0042724609375000, 0.0003967285156250, 0.0055236816406250,
0.0004577636718750, 0.0050354003906250, 0.0014038085937500, 0.0057067871093750,
0.0007934570312500, 0.0059204101562500, 0.0014343261718750, 0.0054931640625000,
0.0025939941406250, 0.0056152343750000, 0.0017700195312500, 0.0057373046875000,
0.0028076171875000, 0.0047607421875000, 0.0029907226562500, 0.0048522949218750,
0.0025329589843750, 0.0044555664062500, 0.0029296875000000, 0.0036315917968750,
0.0029296875000000, 0.0038452148437500, 0.0016784667968750, 0.0027160644531250,
0.0020751953125000, 0.0030212402343750, 0.0015563964843750, 0.0024108886718750,
0.0002746582031250, 0.0014648437500000, 0.0008850097656250, 0.0021972656250000,
0.0000000000000000, 0.0004882812500000, -0.0000915527343750, 0.0006713867187500,
-0.0001525878906250, 0.0003051757812500, -0.0004577636718750, -0.0007934570312500,
-0.0001831054687500, -0.0001220703125000, -0.0008850097656250, -0.0013427734375000,
-0.0007324218750000, -0.0012207031250000, -0.0007019042968750, -0.0013122558593750,
-0.0012512207031250, -0.0020751953125000, -0.0010070800781250, -0.0016174316406250,
-0.0004272460937500, -0.0020141601562500, -0.0008544921875000, -0.0021057128906250,
-0.0001525878906250, -0.0018920898437500, 0.0008239746093750, -0.0019836425781250,
0.0002441406250000, -0.0020751953125000, 0.0017089843750000, -0.0015258789062500,
0.0017395019531250, -0.0018615722656250, 0.0018615722656250, -0.0010986328125000,
0.0028076171875000, -0.0003356933593750, 0.0023803710937500, -0.0010681152343750,
0.0025939941406250, 0.0010986328125000, 0.0028686523437500, 0.0006713867187500,
0.0023803710937500, 0.0010681152343750, 0.0019836425781250, 0.0025634765625000,
0.0023193359375000, 0.0015869140625000, 0.0016174316406250, 0.0027160644531250,
0.0014343261718750, 0.0028076171875000, 0.0017089843750000, 0.0022277832031250,
0.0015258789062500, 0.0025024414062500, 0.0014343261718750, 0.0025329589843750,
0.0022277832031250, 0.0009155273437500, 0.0018920898437500, 0.0016174316406250,
0.0025024414062500, 0.0001220703125000, 0.0033874511718750, -0.0018310546875000,
0.0028381347656250, -0.0003662109375000, 0.0042419433593750, -0.0042114257812500,
0.0042724609375000, -0.0036621093750000, 0.0043029785156250, -0.0038146972656250,
0.0050048828125000, -0.0064392089843750, 0.0047607421875000, -0.0053100585937500,
0.0045776367187500, -0.0050048828125000, 0.0046691894531250, -0.0059204101562500,
0.0048217773437500, -0.0043029785156250, 0.0046386718750000, -0.0025024414062500,
0.0045471191406250, -0.0035400390625000, 0.0056762695312500, -0.0004882812500000,
0.0054931640625000, -0.0000915527343750, 0.0057678222656250, -0.0001525878906250,
0.0067443847656250, 0.0014343261718750, 0.0064086914062500, 0.0015258789062500,
0.0063476562500000, 0.0006408691406250, 0.0068054199218750, 0.0015869140625000,
0.0061950683593750, 0.0006408691406250, 0.0056152343750000, -0.0011291503906250,
0.0061340332031250, -0.0000305175781250, 0.0044860839843750, -0.0013732910156250,
0.0047302246093750, -0.0028686523437500, 0.0041809082031250, -0.0007324218750000,
0.0028991699218750, 0.0006103515625000, 0.0034179687500000, -0.0012207031250000,
0.0015869140625000, 0.0042419433593750, 0.0016784667968750, 0.0045166015625000,
0.0012817382812500, 0.0037841796875000, 0.0000305175781250, 0.0063171386718750,
0.0006103515625000, 0.0062866210937500, 0.0000610351562500, 0.0036315917968750,
-0.0003967285156250, 0.0046081542968750, 0.0003356933593750, 0.0034484863281250,
0.0012207031250000, 0.0010070800781250, 0.0006408691406250, 0.0023803710937500,
-0.0003662109375000, 0.0004272460937500, 0.0007934570312500, -0.0003051757812500,
-0.0004882812500000, 0.0017089843750000, -0.0027770996093750, 0.0018310546875000,
-0.0014648437500000, 0.0007629394531250, -0.0032348632812500, 0.0074157714843750,
-0.0043334960937500, 0.0056457519531250, -0.0023498535156250, 0.0084838867187500,
-0.0013732910156250, 0.0152893066406250, -0.0029296875000000, 0.0119628906250000,
0.0001525878906250, 0.0147399902343750, 0.0006408691406250, 0.0174560546875000,
-0.0002746582031250, 0.0133666992187500, 0.0002136230468750, 0.0106506347656250,
0.0003967285156250, 0.0133972167968750, -0.0005187988281250, 0.0060424804687500,
-0.0007019042968750, 0.0054016113281250, -0.0010375976562500, 0.0060119628906250,
-0.0014953613281250, 0.0033264160156250, -0.0011596679687500, 0.0037841796875000,
-0.0011291503906250, 0.0030517578125000, -0.0016479492187500, 0.0035095214843750,
-0.0017395019531250, 0.0023498535156250, -0.0013732910156250, -0.0003051757812500,
-0.0024108886718750, 0.0037536621093750, 0.0016784667968750, 0.0042724609375000,
-0.0011901855468750, 0.0055847167968750, 0.0016784667968750, 0.0031738281250000,
0.0058593750000000, 0.0014343261718750, 0.0037231445312500, 0.0033569335937500,
0.0067443847656250, -0.0017089843750000, 0.0071411132812500, -0.0023498535156250,
0.0076293945312500, -0.0004882812500000, 0.0088806152343750, -0.0017089843750000,
0.0079956054687500, -0.0025634765625000, 0.0107421875000000, 0.0013427734375000,
0.0104064941406250, 0.0016784667968750, 0.0106506347656250, 0.0002136230468750,
0.0132751464843750, 0.0012817382812500, 0.0125122070312500, 0.0020751953125000,
0.0091552734375000, -0.0019836425781250, 0.0119323730468750, -0.0019226074218750,
0.0075683593750000, -0.0017089843750000, 0.0016479492187500, -0.0037231445312500,
0.0059509277343750, -0.0034790039062500, -0.0033874511718750, -0.0024414062500000,
-0.0044250488281250, -0.0028991699218750, -0.0022583007812500, -0.0026245117187500,
-0.0056457519531250, -0.0014953613281250, -0.0060119628906250, -0.0017700195312500,
-0.0005798339843750, -0.0020446777343750, -0.0021667480468750, -0.0021057128906250,
-0.0006713867187500, -0.0017089843750000, 0.0041198730468750, -0.0017089843750000,
0.0018310546875000, -0.0021972656250000, 0.0039062500000000, -0.0007019042968750,
0.0051879882812500, -0.0007019042968750, 0.0033264160156250, -0.0011901855468750,
0.0024414062500000, -0.0007324218750000, 0.0036621093750000, -0.0005187988281250,
0.0008544921875000, -0.0013122558593750, 0.0007324218750000, -0.0017395019531250,
0.0011291503906250, -0.0008239746093750, 0.0000000000000000, -0.0004272460937500,
0.0002746582031250, -0.0012207031250000, 0.0013427734375000, 0.0007324218750000,
0.0007629394531250, 0.0007019042968750, 0.0011901855468750, 0.0006103515625000,
0.0026855468750000, 0.0015563964843750, 0.0019836425781250, 0.0012512207031250,
0.0007629394531250, 0.0013732910156250, 0.0023193359375000, 0.0014038085937500,
0.0001220703125000, 0.0015563964843750, -0.0025939941406250, 0.0017395019531250,
-0.0003662109375000, 0.0014648437500000, -0.0049743652343750, 0.0022888183593750,
-0.0048217773437500, 0.0024108886718750, -0.0050964355468750, 0.0021667480468750,
-0.0077209472656250, 0.0022583007812500, -0.0065307617187500, 0.0024414062500000,
-0.0075988769531250, 0.0021362304687500, -0.0079650878906250, 0.0018310546875000,
-0.0071105957031250, 0.0023193359375000, -0.0071411132812500, 0.0027160644531250,
-0.0074157714843750, 0.0022888183593750, -0.0045166015625000, 0.0030212402343750,
-0.0051574707031250, 0.0032653808593750, -0.0040893554687500, 0.0028381347656250,
-0.0014038085937500, 0.0028076171875000, -0.0025634765625000, 0.0029296875000000,
-0.0007629394531250, 0.0022583007812500, -0.0001831054687500, 0.0022277832031250,
-0.0005798339843750, 0.0021057128906250, 0.0000610351562500, 0.0017089843750000,
0.0003967285156250, 0.0018310546875000, -0.0007934570312500, 0.0015869140625000,
-0.0000915527343750, 0.0015563964843750, -0.0006103515625000, 0.0016174316406250,
-0.0017700195312500, 0.0015258789062500, -0.0006713867187500, 0.0015563964843750,
-0.0023498535156250, 0.0017089843750000, -0.0020751953125000, 0.0017700195312500,
-0.0022277832031250, 0.0016784667968750, -0.0032348632812500, 0.0017395019531250,
-0.0024414062500000, 0.0019226074218750, -0.0036010742187500, 0.0011901855468750,
-0.0034179687500000, 0.0013732910156250, -0.0033264160156250, 0.0012207031250000,
-0.0039367675781250, 0.0006713867187500, -0.0035400390625000, 0.0008544921875000,
-0.0033569335937500, 0.0005187988281250, -0.0036621093750000, 0.0005493164062500,
-0.0031738281250000, 0.0003662109375000, -0.0027465820312500, 0.0000000000000000,
-0.0030517578125000, 0.0002441406250000, -0.0020751953125000, 0.0000000000000000,
-0.0021972656250000, -0.0001831054687500, -0.0018310546875000, 0.0000610351562500,
-0.0010070800781250, 0.0002136230468750, -0.0015563964843750, 0.0000610351562500,
-0.0004882812500000, 0.0002746582031250, -0.0005187988281250, 0.0004577636718750,
-0.0003662109375000, 0.0003356933593750, 0.0002746582031250, 0.0003051757812500,
0.0000000000000000, 0.0003662109375000, 0.0005798339843750, 0.0005187988281250,
0.0007019042968750, 0.0001220703125000, 0.0006408691406250, 0.0009155273437500,
0.0010070800781250, 0.0016479492187500, 0.0010070800781250, 0.0009765625000000,
0.0010070800781250, 0.0025024414062500, 0.0011596679687500, 0.0027770996093750,
0.0010986328125000, 0.0021972656250000, 0.0010070800781250, 0.0024719238281250,
0.0011596679687500, 0.0028076171875000, 0.0012207031250000, 0.0017700195312500,
0.0013427734375000, 0.0018310546875000, 0.0017700195312500, 0.0017700195312500,
0.0019836425781250, 0.0013122558593750, 0.0018920898437500, 0.0015563964843750,
0.0031433105468750, 0.0008544921875000, 0.0028991699218750, 0.0007629394531250,
0.0033264160156250, 0.0013122558593750, 0.0044555664062500, 0.0010986328125000,
0.0040588378906250, 0.0006408691406250, 0.0043640136718750, 0.0025329589843750,
0.0047912597656250, 0.0020141601562500, 0.0043334960937500, 0.0027160644531250,
0.0040588378906250, 0.0042114257812500, 0.0043029785156250, 0.0032348632812500,
0.0027465820312500, 0.0051269531250000, 0.0032653808593750, 0.0051879882812500,
0.0021362304687500, 0.0048828125000000, 0.0003356933593750, 0.0057373046875000,
0.0013427734375000},
{-0.0036010742187500, 0.0013122558593750, -0.0045776367187500, 0.0012512207031250,
-0.0019531250000000, 0.0008544921875000, -0.0020141601562500, 0.0006408691406250,
-0.0020141601562500, 0.0010681152343750, -0.0005798339843750, 0.0013427734375000,
-0.0008544921875000, 0.0010070800781250, -0.0008850097656250, 0.0018920898437500,
-0.0003356933593750, 0.0019836425781250, -0.0009155273437500, 0.0019531250000000,
-0.0012512207031250, 0.0021667480468750, -0.0006713867187500, 0.0020751953125000,
-0.0029602050781250, 0.0025024414062500, -0.0021667480468750, 0.0022888183593750,
-0.0026245117187500, 0.0024719238281250, -0.0046691894531250, 0.0030212402343750,
-0.0034484863281250, 0.0026550292968750, -0.0043029785156250, 0.0029602050781250,
-0.0046691894531250, 0.0030212402343750, -0.0037536621093750, 0.0029602050781250,
-0.0035705566406250, 0.0029296875000000, -0.0039978027343750, 0.0028991699218750,
-0.0019226074218750, 0.0028991699218750, -0.0024719238281250, 0.0029296875000000,
-0.0014648437500000, 0.0026550292968750, 0.0003662109375000, 0.0025939941406250,
-0.0009155273437500, 0.0028076171875000, 0.0019226074218750, 0.0019226074218750,
0.0015258789062500, 0.0020141601562500, 0.0020446777343750, 0.0019226074218750,
0.0039062500000000, 0.0013732910156250, 0.0027160644531250, 0.0015258789062500,
0.0045776367187500, 0.0011291503906250, 0.0044860839843750, 0.0012512207031250,
0.0043029785156250, 0.0009765625000000, 0.0051879882812500, 0.0005493164062500,
0.0048522949218750, 0.0008239746093750, 0.0047607421875000, 0.0003051757812500,
0.0048522949218750, 0.0001831054687500, 0.0045776367187500, 0.0004272460937500,
0.0043334960937500, 0.0003662109375000, 0.0045166015625000, 0.0002746582031250,
0.0041809082031250, 0.0007324218750000, 0.0041198730468750, 0.0007324218750000,
0.0042419433593750, 0.0007934570312500, 0.0041503906250000, 0.0010375976562500,
0.0040588378906250, 0.0010070800781250, 0.0043640136718750, 0.0011291503906250,
0.0045166015625000, 0.0010681152343750, 0.0044555664062500, 0.0012512207031250,
0.0045776367187500, 0.0014038085937500, 0.0046997070312500, 0.0012512207031250,
0.0046081542968750, 0.0015563964843750, 0.0047302246093750, 0.0015869140625000,
0.0046691894531250, 0.0013427734375000, 0.0045776367187500, 0.0013732910156250,
0.0047912597656250, 0.0016174316406250, 0.0044250488281250, 0.0009155273437500,
0.0045776367187500, 0.0009460449218750, 0.0042419433593750, 0.0014038085937500,
0.0038452148437500, 0.0012817382812500, 0.0042114257812500, 0.0010986328125000,
0.0030822753906250, 0.0017700195312500, 0.0032958984375000, 0.0019531250000000,
0.0029296875000000, 0.0018005371093750, 0.0019836425781250, 0.0016479492187500,
0.0024108886718750, 0.0017700195312500, 0.0013427734375000, 0.0023193359375000,
0.0013732910156250, 0.0016174316406250, 0.0014038085937500, 0.0024108886718750,
0.0007629394531250, 0.0034179687500000, 0.0007934570312500, 0.0025634765625000,
0.0009460449218750, 0.0044250488281250, 0.0006408691406250, 0.0041198730468750,
0.0010986328125000, 0.0044555664062500, 0.0015869140625000, 0.0059814453125000,
0.0012512207031250, 0.0051574707031250, 0.0026550292968750, 0.0053710937500000,
0.0025329589843750, 0.0059814453125000, 0.0029296875000000, 0.0052185058593750,
0.0040893554687500, 0.0043945312500000, 0.0037536621093750, 0.0049133300781250,
0.0043334960937500, 0.0039978027343750, 0.0048217773437500, 0.0039367675781250,
0.0043334960937500, 0.0034484863281250, 0.0043640136718750, 0.0028991699218750,
0.0047302246093750, 0.0034179687500000, 0.0022277832031250, 0.0018310546875000,
0.0031433105468750, 0.0018005371093750, 0.0016479492187500, 0.0018920898437500,
-0.0011291503906250, 0.0010986328125000, 0.0003662109375000, 0.0012817382812500,
-0.0030212402343750, 0.0017395019531250, -0.0032348632812500, 0.0012817382812500,
-0.0031127929687500, 0.0019226074218750, -0.0046997070312500, 0.0028381347656250,
-0.0042724609375000, 0.0022888183593750, -0.0037231445312500, 0.0030212402343750,
-0.0043945312500000, 0.0033569335937500, -0.0031127929687500, 0.0027770996093750,
-0.0017700195312500, 0.0025329589843750, -0.0028076171875000, 0.0028991699218750,
-0.0003356933593750, 0.0022583007812500, -0.0000915527343750, 0.0022583007812500,
-0.0007629394531250, 0.0017395019531250, -0.0002136230468750, 0.0014953613281250,
0.0000610351562500, 0.0020141601562500, -0.0000915527343750, -0.0005493164062500,
-0.0007934570312500, 0.0001525878906250, 0.0007019042968750, -0.0006103515625000,
0.0020446777343750, -0.0026245117187500, 0.0010375976562500, -0.0016784667968750,
0.0043640136718750, -0.0043945312500000, 0.0043029785156250, -0.0039672851562500,
0.0047302246093750, -0.0040283203125000, 0.0071716308593750, -0.0062255859375000,
0.0063171386718750, -0.0058593750000000, 0.0055236816406250, -0.0042114257812500,
0.0067749023437500, -0.0048522949218750, 0.0051879882812500, -0.0044555664062500,
0.0029907226562500, -0.0031127929687500, 0.0043334960937500, -0.0037231445312500,
0.0012817382812500, -0.0024108886718750, 0.0009155273437500, -0.0026550292968750,
0.0010986328125000, -0.0024108886718750, -0.0000305175781250, -0.0011291503906250,
0.0003356933593750, -0.0014038085937500, 0.0000305175781250, -0.0013732910156250,
-0.0001831054687500, -0.0015258789062500, 0.0002441406250000, -0.0008850097656250,
0.0007019042968750, -0.0001220703125000, 0.0007629394531250, -0.0001831054687500,
0.0007324218750000, 0.0009460449218750, 0.0009460449218750, 0.0008239746093750,
0.0004882812500000, 0.0004272460937500, 0.0002746582031250, 0.0009155273437500,
0.0006408691406250, 0.0012512207031250, -0.0013122558593750, 0.0004577636718750,
-0.0007934570312500, 0.0003662109375000, -0.0011901855468750, 0.0003662109375000,
-0.0028076171875000, 0.0001525878906250, -0.0019836425781250, 0.0003662109375000,
-0.0027160644531250, 0.0001220703125000, -0.0029907226562500, -0.0001220703125000,
-0.0025634765625000, 0.0002136230468750, -0.0022277832031250, 0.0004577636718750,
-0.0025329589843750, 0.0001220703125000, -0.0036010742187500, 0.0009155273437500,
-0.0028686523437500, 0.0009765625000000, -0.0039062500000000, 0.0011596679687500,
-0.0058898925781250, 0.0013732910156250, -0.0049438476562500, 0.0013427734375000,
-0.0059204101562500, 0.0031127929687500, -0.0065002441406250, 0.0026550292968750,
-0.0062561035156250, 0.0027160644531250, -0.0062866210937500, 0.0043029785156250,
-0.0063476562500000, 0.0040283203125000, -0.0059814453125000, 0.0030517578125000,
-0.0063781738281250, 0.0035705566406250, -0.0054931640625000, 0.0028686523437500,
-0.0048522949218750, 0.0014953613281250, -0.0058288574218750, 0.0019226074218750,
-0.0021972656250000, 0.0008544921875000, -0.0031127929687500, 0.0007324218750000,
-0.0021972656250000, 0.0003967285156250, 0.0008239746093750, -0.0003356933593750,
-0.0007324218750000, -0.0001525878906250, 0.0008850097656250, -0.0009460449218750,
0.0015258789062500, -0.0014648437500000, 0.0010375976562500, -0.0013122558593750,
0.0011596679687500, -0.0015258789062500, 0.0012817382812500, -0.0019226074218750,
0.0010375976562500, -0.0009155273437500, 0.0010681152343750, -0.0014648437500000,
0.0013122558593750, -0.0008544921875000, 0.0013732910156250, 0.0001831054687500,
0.0012512207031250, -0.0005493164062500, 0.0014038085937500, 0.0019531250000000,
0.0012817382812500, 0.0016784667968750, 0.0017089843750000, 0.0025634765625000,
0.0020751953125000, 0.0047912597656250, 0.0015563964843750, 0.0037841796875000,
0.0025024414062500, 0.0049133300781250, 0.0022888183593750, 0.0055541992187500,
0.0026245117187500, 0.0047607421875000, 0.0034179687500000, 0.0044250488281250,
0.0028991699218750, 0.0048828125000000, 0.0029296875000000, 0.0033264160156250,
0.0034179687500000, 0.0034790039062500, 0.0031433105468750, 0.0032958984375000,
0.0025329589843750, 0.0021667480468750, 0.0027160644531250, 0.0025634765625000,
0.0028686523437500, 0.0025939941406250, 0.0025024414062500, 0.0020446777343750,
0.0028686523437500, 0.0025329589843750, 0.0033569335937500, 0.0028991699218750,
0.0029907226562500, 0.0020446777343750, 0.0031433105468750, 0.0033874511718750,
0.0036926269531250, 0.0028381347656250, 0.0030212402343750, 0.0029296875000000,
0.0024719238281250, 0.0038757324218750, 0.0031433105468750, 0.0029907226562500,
0.0014953613281250, 0.0038757324218750, 0.0018920898437500, 0.0035705566406250,
0.0014953613281250, 0.0032348632812500, 0.0001525878906250, 0.0036010742187500,
0.0009765625000000, 0.0031127929687500, -0.0000915527343750, 0.0028686523437500,
-0.0002441406250000, 0.0031738281250000, 0.0000305175781250, 0.0024108886718750,
-0.0002441406250000, 0.0018005371093750, -0.0002136230468750, 0.0025329589843750,
0.0005493164062500, 0.0008850097656250, 0.0002746582031250, 0.0007934570312500,
0.0007019042968750, 0.0004882812500000, 0.0016784667968750, -0.0003051757812500,
0.0011596679687500, 0.0002136230468750, 0.0017395019531250, -0.0007629394531250,
0.0019531250000000, -0.0007934570312500, 0.0017700195312500, -0.0009765625000000,
0.0016784667968750, -0.0014953613281250, 0.0018615722656250, -0.0012207031250000,
0.0018310546875000, -0.0017395019531250, 0.0018310546875000, -0.0016174316406250,
0.0018920898437500, -0.0017700195312500, 0.0019836425781250, -0.0021972656250000,
0.0020446777343750, -0.0020751953125000, 0.0017395019531250, -0.0022888183593750,
0.0019531250000000, -0.0024108886718750, 0.0018005371093750, -0.0022888183593750,
0.0014038085937500, -0.0024108886718750, 0.0016174316406250, -0.0025634765625000,
0.0013122558593750, -0.0018615722656250, 0.0011901855468750, -0.0021362304687500,
0.0014953613281250, -0.0019531250000000, 0.0015563964843750, -0.0013732910156250,
0.0014038085937500, -0.0018615722656250, 0.0024414062500000, -0.0010986328125000,
0.0022277832031250, -0.0011596679687500, 0.0026550292968750, -0.0012512207031250,
0.0035400390625000, -0.0006713867187500, 0.0032043457031250, -0.0008239746093750,
0.0043640136718750, -0.0018005371093750, 0.0042724609375000, -0.0011291503906250,
0.0046386718750000, -0.0021362304687500, 0.0054931640625000, -0.0034484863281250,
0.0050964355468750, -0.0023803710937500, 0.0055541992187500, -0.0050048828125000,
0.0059204101562500, -0.0047912597656250, 0.0054016113281250, -0.0051269531250000,
0.0050659179687500, -0.0069580078125000, 0.0054321289062500, -0.0063171386718750,
0.0048522949218750, -0.0066528320312500, 0.0046691894531250, -0.0075683593750000,
0.0048522949218750, -0.0062255859375000, 0.0049438476562500, -0.0053710937500000,
0.0049133300781250, -0.0064697265625000, 0.0043945312500000, -0.0026855468750000,
0.0048217773437500, -0.0033569335937500, 0.0042114257812500, -0.0021667480468750,
0.0032348632812500, 0.0008850097656250, 0.0038146972656250, -0.0008239746093750,
0.0028991699218750, 0.0014953613281250, 0.0027465820312500, 0.0018920898437500,
0.0028076171875000, 0.0010375976562500, 0.0025329589843750, 0.0015258789062500,
0.0024719238281250, 0.0015563964843750, 0.0022277832031250, -0.0001525878906250,
0.0024108886718750, 0.0002441406250000, 0.0018005371093750, -0.0004272460937500,
0.0011901855468750, -0.0020141601562500, 0.0016479492187500, -0.0010986328125000,
-0.0000915527343750, -0.0016479492187500, 0.0001220703125000, -0.0019531250000000,
-0.0005798339843750, -0.0007019042968750, -0.0019531250000000, 0.0002441406250000,
-0.0011901855468750, -0.0002441406250000, -0.0033569335937500, 0.0010681152343750,
-0.0033569335937500},
{0.0024414062500000, 0.0014953613281250, 0.0023498535156250, 0.0012512207031250,
0.0022888183593750, 0.0007324218750000, 0.0028381347656250, 0.0000915527343750,
0.0028381347656250, 0.0000000000000000, 0.0021667480468750, -0.0007019042968750,
0.0026245117187500, -0.0009155273437500, 0.0022888183593750, -0.0012207031250000,
0.0014953613281250, -0.0017700195312500, 0.0021667480468750, -0.0018310546875000,
0.0012817382812500, -0.0019531250000000, 0.0013732910156250, -0.0022277832031250,
0.0015258789062500, -0.0024414062500000, 0.0011596679687500, -0.0024414062500000,
0.0013122558593750, -0.0023803710937500, 0.0010070800781250, -0.0024719238281250,
0.0011901855468750, -0.0022888183593750, 0.0011596679687500, -0.0021057128906250,
0.0007934570312500, -0.0021667480468750, 0.0009460449218750, -0.0020141601562500,
0.0014648437500000, -0.0018005371093750, 0.0012817382812500, -0.0019531250000000,
0.0015869140625000, -0.0019226074218750, 0.0022583007812500, -0.0017700195312500,
0.0019531250000000, -0.0020141601562500, 0.0025634765625000, -0.0021362304687500,
0.0025329589843750, -0.0021667480468750, 0.0026245117187500, -0.0024719238281250,
0.0029296875000000, -0.0027465820312500, 0.0027770996093750, -0.0028991699218750,
0.0028686523437500, -0.0031433105468750, 0.0030822753906250, -0.0034484863281250,
0.0027465820312500, -0.0036926269531250, 0.0025024414062500, -0.0038146972656250,
0.0027770996093750, -0.0039978027343750, 0.0023803710937500, -0.0040588378906250,
0.0022888183593750, -0.0041809082031250, 0.0025939941406250, -0.0043334960937500,
0.0025634765625000, -0.0044860839843750, 0.0025024414062500, -0.0044555664062500,
0.0034790039062500, -0.0041503906250000, 0.0031433105468750, -0.0046997070312500,
0.0037231445312500, -0.0042419433593750, 0.0046997070312500, -0.0037536621093750,
0.0041809082031250, -0.0045166015625000, 0.0051879882812500, -0.0021972656250000,
0.0053405761718750, -0.0031433105468750, 0.0050354003906250, -0.0024108886718750,
0.0051574707031250, -0.0004272460937500, 0.0052185058593750, -0.0020751953125000,
0.0046691894531250, 0.0002441406250000, 0.0046386718750000, 0.0000305175781250,
0.0046691894531250, -0.0004882812500000, 0.0045166015625000, 0.0005493164062500,
0.0044860839843750, 0.0000915527343750, 0.0041198730468750, -0.0009460449218750,
0.0044860839843750, -0.0004272460937500, 0.0039062500000000, -0.0016784667968750,
0.0032043457031250, -0.0032958984375000, 0.0037536621093750, -0.0025939941406250,
0.0025939941406250, -0.0052185058593750, 0.0026245117187500, -0.0053710937500000,
0.0025939941406250, -0.0054016113281250, 0.0020446777343750, -0.0068664550781250,
0.0022583007812500, -0.0064392089843750, 0.0015869140625000, -0.0054016113281250,
0.0017395019531250, -0.0065002441406250, 0.0012512207031250, -0.0050048828125000,
0.0005493164062500, -0.0030822753906250, 0.0010070800781250, -0.0046081542968750,
-0.0003662109375000, -0.0008239746093750, -0.0003051757812500, -0.0012207031250000,
-0.0005493164062500, -0.0007629394531250, -0.0013122558593750, 0.0017395019531250,
-0.0009460449218750, 0.0004272460937500, -0.0020751953125000, 0.0010375976562500,
-0.0018310546875000, 0.0019836425781250, -0.0021362304687500, 0.0008239746093750,
-0.0033264160156250, -0.0001525878906250, -0.0028076171875000, 0.0009155273437500,
-0.0024414062500000, -0.0002746582031250, -0.0030822753906250, -0.0003967285156250,
-0.0027160644531250, 0.0000915527343750, -0.0017089843750000, -0.0001220703125000,
-0.0020446777343750, -0.0000915527343750, -0.0022277832031250, 0.0007629394531250,
-0.0021057128906250, 0.0003967285156250, -0.0026550292968750, 0.0007324218750000,
-0.0030212402343750, 0.0016784667968750, -0.0026855468750000, 0.0011596679687500,
-0.0038452148437500, 0.0011596679687500, -0.0042114257812500, 0.0018615722656250,
-0.0037536621093750, 0.0000000000000000, -0.0037231445312500, -0.0017089843750000,
-0.0039672851562500, -0.0004882812500000, -0.0033264160156250, -0.0041198730468750,
-0.0035095214843750, -0.0042114257812500, -0.0031127929687500, -0.0031127929687500,
-0.0025939941406250, -0.0047912597656250, -0.0031738281250000, -0.0048217773437500,
-0.0013732910156250, -0.0005798339843750, -0.0019531250000000, -0.0018310546875000,
-0.0009155273437500, 0.0003051757812500, 0.0004272460937500, 0.0048522949218750,
-0.0007629394531250, 0.0027465820312500, 0.0046386718750000, 0.0054931640625000,
0.0036621093750000, 0.0066223144531250, 0.0045471191406250, 0.0057983398437500,
0.0086975097656250, 0.0058288574218750, 0.0071716308593750, 0.0061950683593750,
0.0085144042968750, 0.0067749023437500, 0.0093688964843750, 0.0060424804687500,
0.0084533691406250, 0.0071105957031250, 0.0075073242187500, 0.0097656250000000,
0.0029907226562500, 0.0053405761718750, 0.0008239746093750, 0.0059814453125000,
0.0017089843750000, 0.0045471191406250, 0.0004882812500000, 0.0062255859375000,
-0.0009765625000000, 0.0086669921875000, 0.0000915527343750, 0.0074462890625000,
-0.0017700195312500, 0.0074157714843750, -0.0021667480468750, 0.0087585449218750,
-0.0018005371093750, 0.0076293945312500, -0.0022277832031250, 0.0057983398437500,
-0.0021667480468750, 0.0067443847656250, -0.0018310546875000, 0.0058593750000000,
-0.0016784667968750, 0.0051879882812500, -0.0024108886718750, 0.0057678222656250,
-0.0027465820312500, 0.0064086914062500, -0.0020141601562500, 0.0058898925781250,
-0.0033569335937500, 0.0049743652343750, -0.0039672851562500, 0.0061035156250000,
-0.0028076171875000, 0.0044860839843750, -0.0026855468750000, 0.0023193359375000,
-0.0033569335937500, 0.0037841796875000, 0.0008544921875000, 0.0000610351562500,
-0.0000915527343750, -0.0000610351562500, 0.0002441406250000, 0.0002441406250000,
0.0036621093750000, -0.0014038085937500, 0.0025024414062500, -0.0011901855468750,
0.0007019042968750, -0.0010681152343750, 0.0023498535156250, -0.0010375976562500,
0.0003356933593750, -0.0014343261718750, -0.0030212402343750, -0.0017700195312500,
-0.0010986328125000, -0.0014648437500000, -0.0039978027343750, -0.0021057128906250,
-0.0049743652343750, -0.0024108886718750, -0.0033569335937500, -0.0019836425781250,
-0.0034179687500000, -0.0018615722656250, -0.0044860839843750, -0.0022583007812500,
-0.0008239746093750, -0.0016784667968750, -0.0011291503906250, -0.0016174316406250,
-0.0010681152343750, -0.0018310546875000, 0.0009765625000000, -0.0017395019531250,
0.0001525878906250, -0.0017395019531250, 0.0001525878906250, -0.0019226074218750,
0.0011291503906250, -0.0019836425781250, -0.0003051757812500, -0.0017089843750000,
-0.0015258789062500, -0.0016174316406250, -0.0001525878906250, -0.0017700195312500,
-0.0033874511718750, -0.0010375976562500, -0.0034790039062500, -0.0009765625000000,
-0.0026245117187500, -0.0012207031250000, -0.0039062500000000, -0.0012512207031250,
-0.0039367675781250, -0.0011291503906250, -0.0015869140625000, -0.0008544921875000,
-0.0023498535156250, -0.0013122558593750, -0.0012512207031250, -0.0006408691406250,
0.0009460449218750, 0.0003356933593750, -0.0003051757812500, -0.0003051757812500,
0.0019531250000000, 0.0003967285156250, 0.0020141601562500, 0.0007019042968750,
0.0021057128906250, 0.0004577636718750, 0.0034790039062500, 0.0003356933593750,
0.0028381347656250, 0.0004577636718750, 0.0023193359375000, 0.0007629394531250,
0.0033569335937500, 0.0005187988281250, 0.0018005371093750, 0.0009765625000000,
0.0003051757812500, 0.0017089843750000, 0.0019836425781250, 0.0012512207031250,
-0.0018310546875000, 0.0021667480468750, -0.0010681152343750, 0.0021667480468750,
-0.0017089843750000, 0.0022277832031250, -0.0042419433593750, 0.0027465820312500,
-0.0024719238281250, 0.0025329589843750, -0.0046997070312500, 0.0028686523437500,
-0.0046386718750000, 0.0029296875000000, -0.0043029785156250, 0.0028686523437500,
-0.0052795410156250, 0.0030517578125000, -0.0047607421875000, 0.0030517578125000,
-0.0046997070312500, 0.0026245117187500, -0.0047302246093750, 0.0027160644531250,
-0.0043640136718750, 0.0027465820312500, -0.0041198730468750, 0.0025329589843750,
-0.0041198730468750, 0.0026245117187500, -0.0029602050781250, 0.0026550292968750,
-0.0033569335937500, 0.0026550292968750, -0.0027465820312500, 0.0025024414062500,
-0.0016479492187500, 0.0024108886718750, -0.0025939941406250, 0.0025329589843750,
-0.0011291503906250, 0.0022888183593750, -0.0012207031250000, 0.0022583007812500,
-0.0012207031250000, 0.0023803710937500, -0.0004577636718750, 0.0024108886718750,
-0.0008239746093750, 0.0023498535156250, -0.0006713867187500, 0.0024108886718750,
-0.0004577636718750, 0.0025634765625000, -0.0007629394531250, 0.0022888183593750,
-0.0008850097656250, 0.0021362304687500, -0.0005493164062500, 0.0023498535156250,
-0.0013427734375000, 0.0017700195312500, -0.0010986328125000, 0.0018615722656250,
-0.0013732910156250, 0.0017089843750000, -0.0019836425781250, 0.0012207031250000,
-0.0014038085937500, 0.0014953613281250, -0.0024414062500000, 0.0013427734375000,
-0.0023193359375000, 0.0010986328125000, -0.0024719238281250, 0.0014648437500000,
-0.0032043457031250, 0.0018310546875000, -0.0028686523437500, 0.0015258789062500,
-0.0033569335937500, 0.0018310546875000, -0.0033569335937500, 0.0020446777343750,
-0.0033874511718750, 0.0018920898437500, -0.0036315917968750, 0.0017089843750000,
-0.0035400390625000, 0.0017700195312500, -0.0036621093750000, 0.0022888183593750,
-0.0038757324218750, 0.0017089843750000, -0.0039672851562500, 0.0023803710937500,
-0.0041503906250000, 0.0032043457031250, -0.0043334960937500, 0.0024414062500000,
-0.0042114257812500, 0.0044250488281250, -0.0043029785156250, 0.0041809082031250,
-0.0039672851562500, 0.0042114257812500, -0.0036621093750000, 0.0056457519531250,
-0.0037536621093750, 0.0051574707031250, -0.0027465820312500, 0.0043029785156250,
-0.0027770996093750, 0.0051269531250000, -0.0021667480468750, 0.0041809082031250,
-0.0012817382812500, 0.0026855468750000, -0.0015258789062500, 0.0035705566406250,
0.0002441406250000, 0.0020141601562500, 0.0000305175781250, 0.0017395019531250,
0.0004272460937500, 0.0019226074218750, 0.0017700195312500, 0.0013122558593750,
0.0012817382812500, 0.0014343261718750, 0.0016479492187500, 0.0017395019531250,
0.0020751953125000, 0.0014953613281250, 0.0015869140625000, 0.0017089843750000,
0.0014038085937500, 0.0021972656250000, 0.0018310546875000, 0.0019226074218750,
0.0003051757812500, 0.0020751953125000, 0.0006408691406250, 0.0020141601562500,
0.0004272460937500, 0.0025024414062500, -0.0007629394531250, 0.0029296875000000,
-0.0003051757812500, 0.0024108886718750, -0.0007324218750000, 0.0033569335937500,
-0.0008544921875000, 0.0035705566406250, -0.0006713867187500, 0.0030212402343750,
-0.0007324218750000, 0.0031738281250000, -0.0007324218750000, 0.0034179687500000,
-0.0001831054687500, 0.0014953613281250, -0.0002746582031250, 0.0022583007812500,
-0.0001525878906250, 0.0008239746093750, 0.0002441406250000, -0.0014038085937500,
0.0000610351562500, 0.0001831054687500, -0.0002136230468750, -0.0029296875000000,
-0.0000610351562500, -0.0032043457031250, -0.0001220703125000, -0.0027160644531250,
-0.0006713867187500, -0.0037841796875000, -0.0007934570312500, -0.0037231445312500,
-0.0001220703125000, -0.0032958984375000, -0.0004272460937500, -0.0033874511718750,
-0.0003967285156250, -0.0030822753906250, 0.0001220703125000, -0.0030212402343750,
-0.0001220703125000, -0.0033569335937500, 0.0003662109375000, -0.0009460449218750,
0.0004882812500000, -0.0012817382812500, 0.0002746582031250, -0.0020751953125000,
0.0003356933593750},
{-0.0036010742187500, 0.0034179687500000, -0.0039978027343750, 0.0039672851562500,
-0.0036315917968750, 0.0037231445312500, -0.0042724609375000, 0.0038146972656250,
-0.0039672851562500, 0.0040588378906250, -0.0042724609375000, 0.0036010742187500,
-0.0049438476562500, 0.0031738281250000, -0.0043640136718750, 0.0034790039062500,
-0.0053710937500000, 0.0022277832031250, -0.0050048828125000, 0.0023498535156250,
-0.0052185058593750, 0.0021972656250000, -0.0058593750000000, 0.0014648437500000,
-0.0051574707031250, 0.0017395019531250, -0.0061340332031250, 0.0016174316406250,
-0.0058288574218750, 0.0014648437500000, -0.0058593750000000, 0.0018005371093750,
-0.0063781738281250, 0.0020141601562500, -0.0057373046875000, 0.0018005371093750,
-0.0063781738281250, 0.0025024414062500, -0.0060119628906250, 0.0025634765625000,
-0.0058593750000000, 0.0024108886718750, -0.0061035156250000, 0.0026855468750000,
-0.0054931640625000, 0.0027465820312500, -0.0056152343750000, 0.0025329589843750,
-0.0054016113281250, 0.0023498535156250, -0.0049438476562500, 0.0027160644531250,
-0.0047302246093750, 0.0028076171875000, -0.0043945312500000, 0.0023803710937500,
-0.0034179687500000, 0.0034179687500000, -0.0036010742187500, 0.0032043457031250,
-0.0031433105468750, 0.0033264160156250, -0.0023193359375000, 0.0040893554687500,
-0.0028991699218750, 0.0036315917968750, -0.0019836425781250, 0.0034790039062500,
-0.0019836425781250, 0.0040588378906250, -0.0021972656250000, 0.0031738281250000,
-0.0018920898437500, 0.0022583007812500, -0.0020141601562500, 0.0031127929687500,
-0.0022888183593750, 0.0014343261718750, -0.0021667480468750, 0.0013427734375000,
-0.0024719238281250, 0.0015563964843750, -0.0027770996093750, 0.0007629394531250,
-0.0025939941406250, 0.0009460449218750, -0.0032958984375000, 0.0015869140625000,
-0.0031433105468750, 0.0012207031250000, -0.0032043457031250, 0.0014953613281250,
-0.0037231445312500, 0.0021362304687500, -0.0033874511718750, 0.0018005371093750,
-0.0035705566406250, 0.0021972656250000, -0.0036621093750000, 0.0023193359375000,
-0.0033264160156250, 0.0021972656250000, -0.0032348632812500, 0.0021667480468750,
-0.0034179687500000, 0.0021972656250000, -0.0019836425781250, 0.0029602050781250,
-0.0020446777343750, 0.0027160644531250, -0.0018310546875000, 0.0026550292968750,
-0.0007934570312500, 0.0033264160156250, -0.0009155273437500, 0.0032348632812500,
-0.0007934570312500, 0.0019836425781250, -0.0004577636718750, 0.0026550292968750,
-0.0008544921875000, 0.0014953613281250, -0.0010986328125000, -0.0001525878906250,
-0.0007934570312500, 0.0008850097656250, -0.0016174316406250, -0.0021057128906250,
-0.0016479492187500, -0.0018920898437500, -0.0013732910156250, -0.0020751953125000,
-0.0017395019531250, -0.0039978027343750, -0.0018310546875000, -0.0033569335937500,
-0.0004577636718750, -0.0027465820312500, -0.0008544921875000, -0.0034484863281250,
-0.0003662109375000, -0.0026855468750000, 0.0009155273437500, -0.0014343261718750,
0.0004272460937500, -0.0021667480468750, 0.0012512207031250, -0.0009765625000000,
0.0014343261718750, -0.0010986328125000, 0.0008544921875000, -0.0006408691406250,
0.0008850097656250, 0.0005798339843750, 0.0011291503906250, -0.0003051757812500,
-0.0002441406250000, -0.0013732910156250, -0.0003356933593750, -0.0000305175781250,
-0.0000610351562500, -0.0014648437500000, -0.0005493164062500, -0.0040588378906250,
-0.0006408691406250, -0.0028381347656250, -0.0001831054687500, -0.0037841796875000,
-0.0001525878906250, -0.0047607421875000, -0.0002136230468750, -0.0035095214843750,
-0.0001220703125000, -0.0027160644531250, -0.0000610351562500, -0.0036315917968750,
0.0000000000000000, -0.0007934570312500, -0.0002441406250000, -0.0009765625000000,
0.0004882812500000, -0.0012207031250000, 0.0011901855468750, 0.0002136230468750,
0.0006713867187500, -0.0001525878906250, 0.0015258789062500, -0.0006713867187500,
0.0018920898437500, -0.0001831054687500, 0.0013122558593750, -0.0010986328125000,
0.0010986328125000, -0.0029296875000000, 0.0013427734375000, -0.0027160644531250,
-0.0002441406250000, -0.0018005371093750, 0.0000915527343750, -0.0026550292968750,
0.0003662109375000, -0.0018615722656250, -0.0003967285156250, -0.0007934570312500,
-0.0004882812500000, -0.0018005371093750, -0.0004882812500000, 0.0015869140625000,
0.0000000000000000, 0.0012207031250000, -0.0008544921875000, 0.0015869140625000,
-0.0018615722656250, 0.0040588378906250, -0.0010375976562500, 0.0032958984375000,
-0.0025024414062500, 0.0026855468750000, -0.0028991699218750, 0.0037536621093750,
-0.0023193359375000, 0.0025939941406250, -0.0025024414062500, 0.0008239746093750,
-0.0027770996093750, 0.0017395019531250, -0.0020446777343750, 0.0002746582031250,
-0.0018310546875000, -0.0002136230468750, -0.0018615722656250, 0.0005187988281250,
-0.0017700195312500, 0.0003967285156250, -0.0016479492187500, -0.0001220703125000,
-0.0013427734375000, 0.0010986328125000, -0.0015563964843750, 0.0011291503906250,
-0.0011596679687500, 0.0002136230468750, -0.0005493164062500, 0.0000610351562500,
-0.0009155273437500, 0.0003051757812500, -0.0000915527343750, -0.0010375976562500,
0.0001525878906250, -0.0013427734375000, -0.0007629394531250, -0.0008544921875000,
-0.0008544921875000, -0.0010681152343750, -0.0001525878906250, -0.0014343261718750,
-0.0024108886718750, -0.0005798339843750, -0.0020446777343750, -0.0003051757812500,
-0.0026855468750000, -0.0005798339843750, -0.0045166015625000, -0.0004272460937500,
-0.0035400390625000, -0.0003051757812500, -0.0045776367187500, -0.0012512207031250,
-0.0050048828125000, -0.0014038085937500, -0.0044555664062500, -0.0015258789062500,
-0.0044860839843750, -0.0022888183593750, -0.0047607421875000, -0.0022583007812500,
-0.0034484863281250, -0.0013122558593750, -0.0039062500000000, -0.0017700195312500,
-0.0030822753906250, -0.0009460449218750, -0.0018615722656250, 0.0003967285156250,
-0.0028686523437500, -0.0003662109375000, -0.0002746582031250, 0.0006408691406250,
-0.0006408691406250, 0.0007629394531250, -0.0002441406250000, 0.0001220703125000,
0.0015563964843750, -0.0001220703125000, 0.0005798339843750, -0.0004882812500000,
0.0017089843750000, -0.0012817382812500, 0.0019836425781250, -0.0019836425781250,
0.0015563964843750, -0.0023803710937500, 0.0016784667968750, -0.0027770996093750,
0.0018310546875000, -0.0032043457031250, 0.0012207031250000, -0.0032043457031250,
0.0013732910156250, -0.0034484863281250, 0.0011596679687500, -0.0034179687500000,
0.0007629394531250, -0.0031433105468750, 0.0011291503906250, -0.0034179687500000,
0.0000000000000000, -0.0035400390625000, 0.0004272460937500, -0.0030212402343750,
-0.0000305175781250, -0.0036010742187500, -0.0012207031250000, -0.0039672851562500,
-0.0004577636718750, -0.0029296875000000, -0.0007629394531250, -0.0050354003906250,
-0.0012512207031250, -0.0039672851562500, -0.0004882812500000, -0.0043334960937500,
0.0000610351562500, -0.0059509277343750, -0.0003356933593750, -0.0044555664062500,
0.0010681152343750, -0.0065917968750000, 0.0008544921875000, -0.0059204101562500,
0.0012512207031250, -0.0061035156250000, 0.0023193359375000, -0.0074462890625000,
0.0017700195312500, -0.0061340332031250, 0.0030517578125000, -0.0078430175781250,
0.0030517578125000, -0.0076599121093750, 0.0031738281250000, -0.0070800781250000,
0.0039062500000000, -0.0077514648437500, 0.0038146972656250, -0.0075378417968750,
0.0038146972656250, -0.0071716308593750, 0.0040588378906250, -0.0072326660156250,
0.0040283203125000, -0.0069885253906250, 0.0039062500000000, -0.0063781738281250,
0.0039978027343750, -0.0061645507812500, 0.0037231445312500, -0.0060119628906250,
0.0039367675781250, -0.0053710937500000, 0.0035705566406250, -0.0054931640625000,
0.0031433105468750, -0.0056457519531250, 0.0034790039062500, -0.0048522949218750,
0.0028381347656250, -0.0057983398437500, 0.0028076171875000, -0.0051879882812500,
0.0029907226562500, -0.0050354003906250, 0.0027770996093750, -0.0054931640625000,
0.0028991699218750, -0.0047302246093750, 0.0032348632812500, -0.0052490234375000,
0.0031127929687500, -0.0046081542968750, 0.0034179687500000, -0.0047912597656250,
0.0038757324218750, -0.0052185058593750, 0.0036315917968750, -0.0041809082031250,
0.0042724609375000, -0.0056762695312500, 0.0043945312500000, -0.0050964355468750,
0.0041198730468750, -0.0051269531250000, 0.0043334960937500, -0.0061645507812500,
0.0044250488281250, -0.0052490234375000, 0.0033874511718750, -0.0057373046875000,
0.0036621093750000, -0.0057678222656250, 0.0031738281250000, -0.0054016113281250,
0.0022277832031250, -0.0054931640625000, 0.0026855468750000, -0.0054626464843750,
0.0021667480468750, -0.0049743652343750, 0.0020141601562500, -0.0050964355468750,
0.0020141601562500, -0.0048217773437500, 0.0019531250000000, -0.0043640136718750,
0.0020446777343750, -0.0046386718750000, 0.0014343261718750, -0.0038146972656250,
0.0016174316406250, -0.0036315917968750, 0.0014648437500000, -0.0036315917968750,
0.0008850097656250, -0.0032348632812500, 0.0011291503906250, -0.0032958984375000,
0.0008239746093750, -0.0039062500000000, 0.0007324218750000, -0.0038146972656250,
0.0004882812500000, -0.0042114257812500, 0.0001525878906250, -0.0050659179687500,
0.0003051757812500, -0.0049438476562500, -0.0004577636718750, -0.0051879882812500,
-0.0006713867187500, -0.0056762695312500, -0.0004577636718750, -0.0050354003906250,
-0.0006713867187500, -0.0047302246093750, -0.0009155273437500, -0.0054931640625000,
-0.0003967285156250, -0.0029296875000000, -0.0004577636718750, -0.0036621093750000,
-0.0004882812500000, -0.0030822753906250, -0.0002441406250000, -0.0009155273437500,
-0.0003967285156250, -0.0018615722656250, -0.0003662109375000, -0.0002441406250000,
-0.0001831054687500, -0.0000610351562500, -0.0002136230468750, -0.0004272460937500,
-0.0003356933593750, 0.0002746582031250, -0.0003356933593750, 0.0002746582031250,
0.0000000000000000, -0.0011596679687500, 0.0000000000000000, -0.0004272460937500,
-0.0003051757812500, -0.0014038085937500, -0.0002441406250000, -0.0032653808593750,
-0.0000610351562500, -0.0022888183593750, -0.0015258789062500, -0.0041503906250000,
-0.0014953613281250, -0.0043334960937500, -0.0014648437500000, -0.0038757324218750,
-0.0022583007812500, -0.0044250488281250, -0.0021972656250000, -0.0040283203125000,
-0.0016784667968750, -0.0026245117187500, -0.0022583007812500, -0.0028076171875000,
-0.0013427734375000, -0.0018310546875000, -0.0000305175781250, -0.0003051757812500,
-0.0009765625000000, -0.0010375976562500, 0.0002136230468750, -0.0000915527343750,
0.0003051757812500, 0.0003356933593750, 0.0009155273437500, -0.0002441406250000,
0.0015258789062500, -0.0004272460937500, 0.0007629394531250, -0.0001525878906250,
0.0039367675781250, -0.0007934570312500, 0.0036010742187500, -0.0009765625000000,
0.0037231445312500, -0.0007629394531250, 0.0059204101562500, -0.0007324218750000,
0.0055236816406250, -0.0008850097656250, 0.0054931640625000, -0.0013732910156250,
0.0063476562500000, -0.0003967285156250, 0.0047607421875000, -0.0017089843750000,
0.0036621093750000, -0.0031738281250000, 0.0053710937500000, -0.0018310546875000,
0.0010986328125000, -0.0057067871093750, 0.0011291503906250, -0.0059814453125000,
0.0011901855468750, -0.0045471191406250, -0.0007324218750000, -0.0059509277343750,
0.0000610351562500, -0.0063781738281250, -0.0009765625000000, -0.0012512207031250,
-0.0008544921875000, -0.0023193359375000, -0.0008239746093750, -0.0013122558593750,
-0.0018615722656250, 0.0051574707031250, -0.0022583007812500, -0.0054016113281250,
-0.0019531250000000},
{0.0028686523437500, 0.0016479492187500, 0.0021972656250000, 0.0010375976562500,
0.0020446777343750, 0.0015563964843750, 0.0020141601562500, 0.0012207031250000,
0.0017395019531250, 0.0007324218750000, 0.0016479492187500, 0.0015869140625000,
0.0016784667968750, -0.0004882812500000, 0.0015869140625000, 0.0002136230468750,
0.0015258789062500, -0.0003051757812500, 0.0016479492187500, -0.0019836425781250,
0.0015563964843750, -0.0009765625000000, 0.0011596679687500, -0.0028686523437500,
0.0012512207031250, -0.0025634765625000, 0.0009460449218750, -0.0030212402343750,
0.0004272460937500, -0.0043640136718750, 0.0005798339843750, -0.0036621093750000,
0.0003356933593750, -0.0054626464843750, 0.0003356933593750, -0.0055236816406250,
0.0002746582031250, -0.0052795410156250, 0.0001525878906250, -0.0059509277343750,
0.0003356933593750, -0.0055541992187500, -0.0002441406250000, -0.0046386718750000,
-0.0001831054687500, -0.0048217773437500, -0.0001220703125000, -0.0040588378906250,
-0.0004577636718750, -0.0029602050781250, -0.0003662109375000, -0.0034179687500000,
0.0000305175781250, -0.0027160644531250, -0.0001525878906250, -0.0022277832031250,
0.0000610351562500, -0.0028991699218750, 0.0004882812500000, -0.0029907226562500,
0.0003051757812500, -0.0022583007812500, 0.0007629394531250, -0.0041198730468750,
0.0006713867187500, -0.0036926269531250, 0.0006408691406250, -0.0036621093750000,
0.0010375976562500, -0.0048522949218750, 0.0008850097656250, -0.0044250488281250,
0.0003967285156250, -0.0047912597656250, 0.0006713867187500, -0.0051269531250000,
0.0003051757812500, -0.0042724609375000, -0.0002746582031250, -0.0040588378906250,
-0.0000610351562500, -0.0045471191406250, -0.0008239746093750, -0.0012817382812500,
-0.0007934570312500, -0.0022277832031250, -0.0007934570312500, -0.0012817382812500,
-0.0012817382812500, 0.0018005371093750, -0.0012207031250000, 0.0005187988281250,
-0.0008239746093750, 0.0010070800781250, -0.0010375976562500, 0.0021667480468750,
-0.0007934570312500, 0.0002136230468750, -0.0005493164062500, -0.0012207031250000,
-0.0006713867187500, 0.0002136230468750, 0.0007019042968750, -0.0041198730468750,
0.0002746582031250, -0.0038452148437500, 0.0007324218750000, -0.0036926269531250,
0.0019226074218750, -0.0059814453125000, 0.0014648437500000, -0.0049438476562500,
0.0026550292968750, -0.0035400390625000, 0.0025634765625000, -0.0046081542968750,
0.0025634765625000, -0.0030212402343750, 0.0036926269531250, -0.0004882812500000,
0.0034179687500000, -0.0020751953125000, 0.0018615722656250, 0.0001831054687500,
0.0029296875000000, 0.0008850097656250, 0.0019226074218750, -0.0001220703125000,
-0.0001525878906250, -0.0000915527343750, 0.0008850097656250, 0.0003662109375000,
-0.0014343261718750, -0.0013427734375000, -0.0009155273437500, -0.0013427734375000,
-0.0013732910156250, -0.0011596679687500, -0.0033569335937500, -0.0018615722656250,
-0.0023803710937500, -0.0016174316406250, -0.0030212402343750, -0.0014648437500000,
-0.0032653808593750, -0.0009765625000000, -0.0031127929687500, -0.0019836425781250,
-0.0032958984375000, -0.0026855468750000, -0.0032043457031250, -0.0017700195312500,
-0.0026855468750000, -0.0044860839843750, -0.0029296875000000, -0.0044555664062500,
-0.0027160644531250, -0.0039672851562500, -0.0018920898437500, -0.0054626464843750,
-0.0025939941406250, -0.0011901855468750, -0.0036010742187500, -0.0051269531250000,
-0.0033264160156250, -0.0037536621093750, -0.0031127929687500, -0.0039062500000000,
-0.0036315917968750, -0.0061035156250000, -0.0037841796875000, -0.0059814453125000,
-0.0021057128906250, -0.0031433105468750, -0.0023498535156250, -0.0038452148437500,
-0.0025939941406250, -0.0032348632812500, -0.0018005371093750, -0.0008239746093750,
-0.0020446777343750, -0.0015563964843750, -0.0032348632812500, -0.0013122558593750,
-0.0029602050781250, -0.0011901855468750, -0.0031433105468750, -0.0004577636718750,
-0.0046691894531250, -0.0002441406250000, -0.0044250488281250, -0.0009765625000000,
-0.0019531250000000, 0.0018005371093750, -0.0032043457031250, 0.0017395019531250,
-0.0017700195312500, 0.0015869140625000, 0.0012817382812500, 0.0029907226562500,
-0.0004882812500000, 0.0025329589843750, 0.0005493164062500, 0.0013122558593750,
0.0019531250000000, 0.0020446777343750, 0.0000915527343750, 0.0013122558593750,
-0.0016174316406250, -0.0006408691406250, -0.0000610351562500, 0.0001220703125000,
-0.0020751953125000, 0.0007629394531250, -0.0029296875000000, -0.0001831054687500,
-0.0011901855468750, 0.0007019042968750, -0.0007324218750000, 0.0024108886718750,
-0.0018920898437500, 0.0016174316406250, 0.0013122558593750, 0.0018615722656250,
0.0015258789062500, 0.0024719238281250, 0.0007934570312500, 0.0017089843750000,
0.0021667480468750, 0.0007629394531250, 0.0022888183593750, 0.0012512207031250,
-0.0004272460937500, 0.0009460449218750, 0.0004577636718750, 0.0007019042968750,
-0.0004272460937500, 0.0008544921875000, -0.0028076171875000, 0.0010681152343750,
-0.0015258789062500, 0.0009765625000000, -0.0036926269531250, 0.0004577636718750,
-0.0036926269531250, 0.0006103515625000, -0.0035705566406250, 0.0003662109375000,
-0.0049133300781250, -0.0002746582031250, -0.0045166015625000, -0.0000915527343750,
-0.0034179687500000, 0.0002746582031250, -0.0041198730468750, 0.0001525878906250,
-0.0035705566406250, -0.0000305175781250, -0.0019226074218750, 0.0003051757812500,
-0.0025634765625000, 0.0004272460937500, -0.0023193359375000, -0.0009155273437500,
-0.0015563964843750, -0.0007324218750000, -0.0023803710937500, -0.0006103515625000,
-0.0031127929687500, -0.0015258789062500, -0.0021667480468750, -0.0014343261718750,
-0.0042724609375000, -0.0004882812500000, -0.0039367675781250, -0.0007629394531250,
-0.0042724609375000, -0.0005187988281250, -0.0057678222656250, 0.0003051757812500,
-0.0048828125000000, 0.0000610351562500, -0.0053710937500000, 0.0000610351562500,
-0.0060119628906250, 0.0001525878906250, -0.0047912597656250, 0.0000915527343750,
-0.0041809082031250, -0.0000915527343750, -0.0052185058593750, -0.0000610351562500,
-0.0018005371093750, -0.0000305175781250, -0.0028076171875000, -0.0000610351562500,
-0.0016174316406250, -0.0000915527343750, 0.0011291503906250, -0.0001220703125000,
-0.0008544921875000, -0.0000915527343750, 0.0026245117187500, 0.0001525878906250,
0.0022583007812500, -0.0001525878906250, 0.0023803710937500, 0.0004577636718750,
0.0044860839843750, 0.0010681152343750, 0.0033874511718750, 0.0006408691406250,
0.0043945312500000, 0.0017700195312500, 0.0046386718750000, 0.0018615722656250,
0.0040893554687500, 0.0018310546875000, 0.0043334960937500, 0.0023193359375000,
0.0043945312500000, 0.0022277832031250, 0.0028381347656250, 0.0023803710937500,
0.0033874511718750, 0.0024108886718750, 0.0027465820312500, 0.0023803710937500,
0.0013122558593750, 0.0024719238281250, 0.0021362304687500, 0.0025329589843750,
0.0004272460937500, 0.0025024414062500, 0.0003967285156250, 0.0024108886718750,
0.0001831054687500, 0.0027160644531250, -0.0008239746093750, 0.0029296875000000,
-0.0004882812500000, 0.0027160644531250, -0.0013122558593750, 0.0035705566406250,
-0.0014343261718750, 0.0035705566406250, -0.0015869140625000, 0.0036926269531250,
-0.0021667480468750, 0.0041809082031250, -0.0021972656250000, 0.0040893554687500,
-0.0026855468750000, 0.0040893554687500, -0.0030517578125000, 0.0042724609375000,
-0.0031738281250000, 0.0040283203125000, -0.0035095214843750, 0.0037231445312500,
-0.0038757324218750, 0.0039062500000000, -0.0034179687500000, 0.0036010742187500,
-0.0038757324218750, 0.0033874511718750, -0.0037231445312500, 0.0035400390625000,
-0.0032653808593750, 0.0036315917968750, -0.0036926269531250, 0.0033569335937500,
-0.0026245117187500, 0.0036926269531250, -0.0030517578125000, 0.0038452148437500,
-0.0026245117187500, 0.0035095214843750, -0.0016174316406250, 0.0036315917968750,
-0.0024414062500000, 0.0037536621093750, -0.0014343261718750, 0.0023498535156250,
-0.0015258789062500, 0.0029296875000000, -0.0011596679687500, 0.0021667480468750,
-0.0004882812500000, 0.0006713867187500, -0.0009765625000000, 0.0016174316406250,
0.0001220703125000, 0.0000610351562500, -0.0001525878906250, -0.0000305175781250,
-0.0003051757812500, 0.0002136230468750, 0.0001525878906250, -0.0004577636718750,
-0.0003356933593750, -0.0003356933593750, -0.0005493164062500, 0.0001831054687500,
-0.0005798339843750, 0.0000000000000000, -0.0009765625000000, 0.0001220703125000,
-0.0013427734375000, 0.0006408691406250, -0.0013427734375000, 0.0005493164062500,
-0.0019836425781250, 0.0006713867187500, -0.0019836425781250, 0.0007019042968750,
-0.0020751953125000, 0.0006408691406250, -0.0023193359375000, 0.0007629394531250,
-0.0021972656250000, 0.0008239746093750, -0.0023498535156250, 0.0005798339843750,
-0.0021362304687500, 0.0008239746093750, -0.0021057128906250, 0.0002746582031250,
-0.0021057128906250, -0.0001831054687500, -0.0018310546875000, 0.0003662109375000,
-0.0023803710937500, -0.0010375976562500, -0.0020141601562500, -0.0009155273437500,
-0.0024108886718750, -0.0011901855468750, -0.0033264160156250, -0.0019531250000000,
-0.0029296875000000, -0.0014648437500000, -0.0039062500000000, -0.0027465820312500,
-0.0041503906250000, -0.0027770996093750, -0.0041198730468750, -0.0023803710937500,
-0.0044250488281250, -0.0029602050781250, -0.0043945312500000, -0.0029907226562500,
-0.0039978027343750, -0.0011291503906250, -0.0041503906250000, -0.0016479492187500,
-0.0037536621093750, -0.0013427734375000, -0.0031433105468750, 0.0003662109375000,
-0.0033264160156250, -0.0002136230468750, -0.0028076171875000, -0.0010375976562500,
-0.0025024414062500, -0.0001525878906250, -0.0027770996093750, -0.0009155273437500,
-0.0028381347656250, -0.0023803710937500, -0.0025634765625000, -0.0017089843750000,
-0.0035400390625000, -0.0029907226562500, -0.0036010742187500, -0.0029296875000000,
-0.0030517578125000, -0.0027465820312500, -0.0033874511718750, -0.0036010742187500,
-0.0035400390625000, -0.0035400390625000, -0.0010681152343750, -0.0021972656250000,
-0.0016479492187500, -0.0025329589843750, -0.0010375976562500, -0.0021972656250000,
0.0010375976562500, -0.0009765625000000, 0.0001831054687500, -0.0013122558593750,
0.0005798339843750, -0.0013427734375000, 0.0010070800781250, -0.0010070800781250,
0.0004882812500000, -0.0011291503906250, 0.0001220703125000, -0.0014038085937500,
0.0004577636718750, -0.0011901855468750, -0.0004272460937500, -0.0014038085937500,
-0.0005187988281250, -0.0014343261718750, -0.0003662109375000, -0.0016174316406250,
-0.0004882812500000, -0.0019836425781250, -0.0005187988281250, -0.0016479492187500,
-0.0008850097656250, -0.0006408691406250, -0.0005798339843750, -0.0014343261718750,
-0.0012207031250000, -0.0008850097656250, -0.0023193359375000, 0.0008850097656250,
-0.0022888183593750, 0.0007934570312500, -0.0036926269531250, 0.0012512207031250,
-0.0036926269531250, 0.0013427734375000, -0.0028991699218750, 0.0007324218750000,
-0.0032653808593750, 0.0006408691406250, -0.0036315917968750, 0.0010986328125000,
-0.0015869140625000, -0.0003356933593750, -0.0019226074218750, -0.0004882812500000,
-0.0013732910156250, -0.0004272460937500, 0.0001525878906250, -0.0010986328125000,
-0.0007019042968750, -0.0009765625000000, -0.0001220703125000, -0.0003356933593750,
0.0002746582031250, -0.0009155273437500, 0.0000915527343750, -0.0005493164062500,
0.0001525878906250, 0.0002136230468750, 0.0001220703125000, -0.0005798339843750,
-0.0003356933593750, 0.0002746582031250, 0.0000305175781250, 0.0003662109375000,
-0.0008544921875000},
{-0.0059509277343750, 0.0001831054687500, -0.0050354003906250, 0.0004882812500000,
-0.0037841796875000, 0.0005493164062500, -0.0044555664062500, 0.0003662109375000,
-0.0025329589843750, 0.0005798339843750, -0.0026855468750000, 0.0008239746093750,
-0.0023193359375000, 0.0005493164062500, -0.0010681152343750, 0.0004577636718750,
-0.0015869140625000, 0.0007019042968750, -0.0004882812500000, -0.0003051757812500,
-0.0006408691406250, 0.0002136230468750, -0.0006103515625000, -0.0004882812500000,
-0.0000610351562500, -0.0016784667968750, -0.0004882812500000, -0.0008544921875000,
0.0000305175781250, -0.0022277832031250, 0.0000305175781250, -0.0023498535156250,
-0.0003051757812500, -0.0022277832031250, -0.0001525878906250, -0.0027770996093750,
-0.0000305175781250, -0.0026245117187500, -0.0007934570312500, -0.0027160644531250,
-0.0005187988281250, -0.0026245117187500, -0.0007324218750000, -0.0027465820312500,
-0.0012512207031250, -0.0031433105468750, -0.0005798339843750, -0.0028381347656250,
-0.0012817382812500, -0.0023193359375000, -0.0013122558593750, -0.0028381347656250,
-0.0011596679687500, -0.0020446777343750, -0.0013732910156250, -0.0007629394531250,
-0.0013427734375000, -0.0015258789062500, -0.0016174316406250, -0.0008850097656250,
-0.0014648437500000, -0.0001831054687500, -0.0019226074218750, -0.0013122558593750,
-0.0023803710937500, -0.0021057128906250, -0.0019226074218750, -0.0011901855468750,
-0.0030212402343750, -0.0028381347656250, -0.0028686523437500, -0.0032348632812500,
-0.0028686523437500, -0.0027770996093750, -0.0036010742187500, -0.0028381347656250,
-0.0033264160156250, -0.0029602050781250, -0.0033264160156250, -0.0028686523437500,
-0.0034790039062500, -0.0029296875000000, -0.0035095214843750, -0.0025634765625000,
-0.0034179687500000, -0.0021362304687500, -0.0032653808593750, -0.0024414062500000,
-0.0027160644531250, -0.0019836425781250, -0.0031433105468750, -0.0018005371093750,
-0.0022888183593750, -0.0017700195312500, -0.0011596679687500, -0.0017395019531250,
-0.0017700195312500, -0.0016174316406250, -0.0006713867187500, -0.0009155273437500,
-0.0005798339843750, -0.0011291503906250, -0.0005493164062500, -0.0008544921875000,
-0.0000610351562500, -0.0000610351562500, -0.0003662109375000, -0.0003967285156250,
0.0000000000000000, -0.0005187988281250, 0.0002136230468750, -0.0002136230468750,
-0.0001831054687500, 0.0000000000000000, -0.0004577636718750, -0.0001831054687500,
-0.0002441406250000, -0.0004272460937500, -0.0005493164062500, -0.0000915527343750,
-0.0006103515625000, 0.0005493164062500, -0.0005798339843750, 0.0003051757812500,
-0.0003356933593750, -0.0002746582031250, -0.0003051757812500, -0.0001220703125000,
-0.0023193359375000, -0.0007324218750000, -0.0010375976562500, -0.0003967285156250,
-0.0018005371093750, -0.0004272460937500, -0.0041503906250000, -0.0010681152343750,
-0.0026855468750000, -0.0008850097656250, -0.0038452148437500, -0.0007934570312500,
-0.0046386718750000, -0.0009765625000000, -0.0032348632812500, -0.0008850097656250,
-0.0025329589843750, -0.0007629394531250, -0.0033569335937500, -0.0012207031250000,
-0.0007934570312500, -0.0006103515625000, -0.0007019042968750, -0.0009155273437500,
-0.0010070800781250, -0.0010986328125000, -0.0000915527343750, -0.0006713867187500,
-0.0002441406250000, -0.0010986328125000, 0.0000915527343750, -0.0018005371093750,
-0.0001525878906250, -0.0014038085937500, 0.0001525878906250, -0.0023193359375000,
0.0009460449218750, -0.0035705566406250, 0.0004882812500000, -0.0029602050781250,
-0.0002136230468750, -0.0041503906250000, 0.0008544921875000, -0.0050354003906250,
-0.0004272460937500, -0.0038757324218750, -0.0024108886718750, -0.0036621093750000,
-0.0008850097656250, -0.0051574707031250, -0.0021362304687500, -0.0015258789062500,
-0.0028991699218750, -0.0022277832031250, -0.0018005371093750, -0.0024719238281250,
-0.0010681152343750, 0.0000000000000000, -0.0015563964843750, -0.0004882812500000,
-0.0002746582031250, -0.0017700195312500, -0.0000915527343750, -0.0005187988281250,
-0.0002136230468750, -0.0009765625000000, 0.0005187988281250, -0.0024719238281250,
0.0006713867187500, -0.0011596679687500, -0.0000610351562500, -0.0023498535156250,
0.0002136230468750, -0.0025939941406250, -0.0000305175781250, -0.0019226074218750,
-0.0004882812500000, -0.0018310546875000, -0.0000305175781250, -0.0018920898437500,
-0.0010681152343750, -0.0012817382812500, -0.0007934570312500, -0.0006408691406250,
-0.0012512207031250, -0.0011291503906250, -0.0020751953125000, -0.0011596679687500,
-0.0013427734375000, -0.0000915527343750, -0.0028381347656250, -0.0024719238281250,
-0.0026245117187500, -0.0012207031250000, -0.0028076171875000, -0.0015258789062500,
-0.0037536621093750, -0.0033569335937500, -0.0031127929687500, -0.0014343261718750,
-0.0037841796875000, -0.0026855468750000, -0.0037841796875000, -0.0020446777343750,
-0.0034790039062500, -0.0015563964843750, -0.0036010742187500, -0.0019226074218750,
-0.0033874511718750, -0.0007934570312500, -0.0029296875000000, -0.0014343261718750,
-0.0031738281250000, -0.0008850097656250, -0.0025939941406250, -0.0009765625000000,
-0.0019836425781250, -0.0017089843750000, -0.0024414062500000, -0.0012207031250000,
-0.0011596679687500, -0.0024414062500000, -0.0014648437500000, -0.0023803710937500,
-0.0011596679687500, -0.0028381347656250, -0.0003051757812500, -0.0038757324218750,
-0.0008850097656250, -0.0036010742187500, 0.0006713867187500, -0.0045166015625000,
0.0002441406250000, -0.0049133300781250, 0.0005187988281250, -0.0047912597656250,
0.0019226074218750, -0.0051879882812500, 0.0011901855468750, -0.0056457519531250,
0.0012817382812500, -0.0047912597656250, 0.0017700195312500, -0.0055847167968750,
0.0011291503906250, -0.0051574707031250, 0.0003051757812500, -0.0043029785156250,
0.0009155273437500, -0.0056457519531250, 0.0000610351562500, -0.0039367675781250,
-0.0002441406250000, -0.0042114257812500, 0.0003356933593750, -0.0040893554687500,
0.0003967285156250, -0.0029907226562500, 0.0000000000000000, -0.0033569335937500,
0.0015869140625000, -0.0023193359375000, 0.0013122558593750, -0.0025634765625000,
0.0016479492187500, -0.0023193359375000, 0.0027770996093750, -0.0015869140625000,
0.0021972656250000, -0.0020751953125000, 0.0028686523437500, -0.0012817382812500,
0.0030822753906250, -0.0013427734375000, 0.0028381347656250, -0.0013732910156250,
0.0030212402343750, -0.0011901855468750, 0.0031127929687500, -0.0015869140625000,
0.0025939941406250, -0.0011596679687500, 0.0026855468750000, -0.0018005371093750,
0.0024108886718750, -0.0016784667968750, 0.0019531250000000, -0.0014343261718750,
0.0021057128906250, -0.0025939941406250, 0.0012512207031250, -0.0014038085937500,
0.0013122558593750, -0.0022583007812500, 0.0010375976562500, -0.0023803710937500,
0.0004577636718750, -0.0016784667968750, 0.0006103515625000, -0.0031127929687500,
-0.0001831054687500, -0.0020141601562500, 0.0000305175781250, -0.0026855468750000,
-0.0005187988281250, -0.0033264160156250, -0.0013427734375000, -0.0027160644531250,
-0.0007629394531250, -0.0033874511718750, -0.0020751953125000, -0.0038146972656250,
-0.0021057128906250, -0.0034179687500000, -0.0018310546875000, -0.0039978027343750,
-0.0022277832031250, -0.0044555664062500, -0.0021667480468750, -0.0035705566406250,
-0.0016174316406250, -0.0048522949218750, -0.0016479492187500, -0.0043334960937500,
-0.0014648437500000, -0.0041198730468750, -0.0011596679687500, -0.0048522949218750,
-0.0012512207031250, -0.0040283203125000, -0.0006103515625000, -0.0034484863281250,
-0.0008544921875000, -0.0038146972656250, -0.0004577636718750, -0.0023498535156250,
0.0003051757812500, -0.0010986328125000, -0.0002136230468750, -0.0020446777343750,
0.0004272460937500, 0.0006103515625000, 0.0005187988281250, 0.0003967285156250,
0.0002136230468750, 0.0003662109375000, 0.0002441406250000, 0.0020141601562500,
0.0001831054687500, 0.0015869140625000, -0.0003356933593750, 0.0007019042968750,
-0.0001831054687500, 0.0017089843750000, -0.0008239746093750, 0.0002746582031250,
-0.0015258789062500, -0.0015869140625000, -0.0010375976562500, -0.0002136230468750,
-0.0025939941406250, -0.0037231445312500, -0.0026245117187500, -0.0037536621093750,
-0.0023193359375000, -0.0042724609375000, -0.0029602050781250, -0.0065002441406250,
-0.0029296875000000, -0.0057983398437500, -0.0018310546875000, -0.0067138671875000,
-0.0020446777343750, -0.0071716308593750, -0.0017089843750000, -0.0062255859375000,
-0.0008239746093750, -0.0057067871093750, -0.0011596679687500, -0.0060119628906250,
-0.0003662109375000, -0.0042114257812500, -0.0007019042968750, -0.0033874511718750,
-0.0000915527343750, -0.0034179687500000, 0.0007934570312500, -0.0028686523437500,
0.0000305175781250, -0.0025024414062500, 0.0021972656250000, -0.0032653808593750,
0.0022888183593750, -0.0035095214843750, 0.0016479492187500, -0.0027465820312500,
0.0025939941406250, -0.0026550292968750, 0.0027770996093750, -0.0029296875000000,
0.0005798339843750, -0.0003356933593750, 0.0011596679687500, -0.0008544921875000,
0.0002441406250000, -0.0004272460937500, -0.0017700195312500, 0.0016174316406250,
-0.0008239746093750, 0.0006713867187500, -0.0023193359375000, 0.0002746582031250,
-0.0028076171875000, 0.0017089843750000, -0.0021057128906250, 0.0000610351562500,
-0.0022583007812500, -0.0017395019531250, -0.0027465820312500, -0.0000305175781250,
-0.0019226074218750, -0.0047302246093750, -0.0012817382812500, -0.0046386718750000,
-0.0027770996093750, -0.0043945312500000, -0.0039978027343750, -0.0070800781250000,
-0.0028381347656250, -0.0064086914062500, -0.0045166015625000, -0.0047607421875000,
-0.0050659179687500, -0.0059509277343750, -0.0044860839843750, -0.0039367675781250,
-0.0045776367187500, -0.0010986328125000, -0.0047302246093750, -0.0030517578125000,
-0.0033569335937500, 0.0001220703125000, -0.0033874511718750, 0.0010986328125000,
-0.0036926269531250, -0.0005798339843750, -0.0031433105468750, -0.0004577636718750,
-0.0030212402343750, 0.0004272460937500, -0.0039062500000000, -0.0030212402343750,
-0.0040588378906250, -0.0029907226562500, -0.0037536621093750, -0.0021667480468750,
-0.0038757324218750, -0.0037231445312500, -0.0046691894531250, -0.0006408691406250,
-0.0045471191406250, -0.0045471191406250, -0.0051574707031250, -0.0048828125000000,
-0.0042419433593750, -0.0032653808593750, -0.0038757324218750, -0.0029296875000000,
-0.0046691894531250, -0.0041198730468750, -0.0007629394531250, -0.0014953613281250,
-0.0013732910156250, -0.0008850097656250, -0.0010070800781250, -0.0021972656250000,
0.0019836425781250, -0.0021362304687500, 0.0012207031250000, -0.0015563964843750,
0.0004272460937500, -0.0039672851562500, 0.0019836425781250, -0.0043640136718750,
0.0002136230468750, -0.0036315917968750, -0.0022888183593750, -0.0042114257812500,
-0.0003662109375000, -0.0046081542968750, -0.0029907226562500, -0.0022888183593750,
-0.0038452148437500, -0.0027465820312500, -0.0022888183593750, -0.0021667480468750,
-0.0021972656250000, -0.0002746582031250, -0.0029907226562500, -0.0010681152343750,
0.0000000000000000, -0.0008850097656250, 0.0000610351562500, -0.0005798339843750,
-0.0003356933593750, -0.0003356933593750, 0.0010375976562500, -0.0005187988281250,
0.0010375976562500, -0.0010070800781250, -0.0008850097656250, 0.0011596679687500,
-0.0000305175781250, 0.0009765625000000, -0.0006103515625000, 0.0009155273437500,
-0.0025939941406250, 0.0021972656250000, -0.0014648437500000, 0.0020141601562500,
-0.0017089843750000, 0.0011596679687500, -0.0022277832031250, 0.0013122558593750,
-0.0015258789062500, 0.0013732910156250, -0.0004882812500000, 0.0008850097656250,
-0.0008544921875000},
{-0.0008544921875000, 0.0016174316406250, -0.0018310546875000, 0.0015258789062500,
-0.0007629394531250, -0.0007934570312500, -0.0007019042968750, -0.0002441406250000,
-0.0007324218750000, -0.0018615722656250, -0.0003662109375000, -0.0045166015625000,
-0.0006408691406250, -0.0032958984375000, 0.0004882812500000, -0.0060729980468750,
0.0003051757812500, -0.0064392089843750, 0.0003356933593750, -0.0058288574218750,
0.0012817382812500, -0.0064392089843750, 0.0010375976562500, -0.0060119628906250,
0.0001220703125000, -0.0043945312500000, 0.0004882812500000, -0.0046691894531250,
0.0000915527343750, -0.0039062500000000, -0.0011901855468750, -0.0024108886718750,
-0.0009155273437500, -0.0029602050781250, -0.0004272460937500, -0.0015869140625000,
-0.0009460449218750, -0.0010986328125000, -0.0006103515625000, -0.0007934570312500,
0.0001831054687500, -0.0002441406250000, -0.0003051757812500, -0.0003356933593750,
-0.0000915527343750, -0.0000610351562500, 0.0003051757812500, 0.0000610351562500,
-0.0004272460937500, -0.0000610351562500, -0.0008239746093750, 0.0000915527343750,
-0.0003356933593750, 0.0001831054687500, -0.0031127929687500, -0.0013122558593750,
-0.0029602050781250, -0.0004577636718750, -0.0024719238281250, -0.0015563964843750,
-0.0038757324218750, -0.0034179687500000, -0.0040588378906250, -0.0021667480468750,
-0.0027770996093750, -0.0045471191406250, -0.0028991699218750, -0.0045776367187500,
-0.0029602050781250, -0.0045166015625000, -0.0022888183593750, -0.0058593750000000,
-0.0025634765625000, -0.0053100585937500, -0.0031433105468750, -0.0041503906250000,
-0.0028381347656250, -0.0052490234375000, -0.0032653808593750, -0.0036010742187500,
-0.0042724609375000, -0.0010681152343750, -0.0039672851562500, -0.0026550292968750,
-0.0043029785156250, -0.0004882812500000, -0.0045471191406250, 0.0005493164062500,
-0.0046081542968750, -0.0011596679687500, -0.0047302246093750, -0.0028381347656250,
-0.0048217773437500, -0.0037231445312500, -0.0012512207031250, -0.0022277832031250,
-0.0027160644531250, -0.0012512207031250, -0.0014953613281250, -0.0025634765625000,
0.0011291503906250, -0.0039367675781250, 0.0000610351562500, -0.0029602050781250,
-0.0007324218750000, -0.0038452148437500, 0.0008850097656250, -0.0048522949218750,
-0.0004272460937500, -0.0034179687500000, -0.0028686523437500, -0.0022888183593750,
-0.0014648437500000, -0.0034790039062500, -0.0029602050781250, -0.0013427734375000,
-0.0036621093750000, -0.0007934570312500, -0.0022888183593750, -0.0018920898437500,
-0.0017700195312500, -0.0018615722656250, -0.0026245117187500, -0.0013427734375000,
-0.0007019042968750, -0.0030212402343750, -0.0003051757812500, -0.0032958984375000,
-0.0010375976562500, -0.0024108886718750, -0.0006408691406250, -0.0027465820312500,
-0.0000610351562500, -0.0032653808593750, -0.0011901855468750, 0.0002746582031250,
-0.0014343261718750, -0.0001831054687500, -0.0007324218750000, -0.0001525878906250,
-0.0006713867187500, 0.0019531250000000, -0.0009460449218750, 0.0014953613281250,
0.0001525878906250, 0.0013427734375000, 0.0004272460937500, 0.0012817382812500,
-0.0001831054687500, 0.0015258789062500, 0.0000915527343750, 0.0016784667968750,
0.0004882812500000, 0.0013732910156250, -0.0025024414062500, 0.0022277832031250,
-0.0016784667968750, 0.0024108886718750, -0.0029602050781250, 0.0020751953125000,
-0.0060729980468750, 0.0022277832031250, -0.0044860839843750, 0.0023193359375000,
-0.0058288574218750, 0.0014648437500000, -0.0072631835937500, 0.0016479492187500,
-0.0054931640625000, 0.0014343261718750, -0.0045166015625000, 0.0007019042968750,
-0.0059204101562500, 0.0009765625000000, -0.0015869140625000, 0.0008239746093750,
-0.0026855468750000, 0.0006408691406250, -0.0013732910156250, 0.0009460449218750,
0.0022277832031250, 0.0011901855468750, -0.0001220703125000, 0.0010681152343750,
0.0026550292968750, 0.0014343261718750, 0.0032653808593750, 0.0013122558593750,
0.0021362304687500, 0.0015258789062500, 0.0022888183593750, 0.0019226074218750,
0.0023498535156250, 0.0016479492187500, 0.0008239746093750, 0.0016784667968750,
0.0005187988281250, 0.0020141601562500, 0.0005187988281250, 0.0013427734375000,
-0.0002136230468750, 0.0007019042968750, -0.0004272460937500, 0.0011596679687500,
0.0000305175781250, -0.0003051757812500, -0.0005187988281250, -0.0003967285156250,
-0.0001525878906250, -0.0004577636718750, 0.0003662109375000, -0.0012207031250000,
-0.0002441406250000, -0.0010070800781250, 0.0013732910156250, -0.0012512207031250,
0.0010375976562500, -0.0013122558593750, 0.0012512207031250, -0.0013732910156250,
0.0025024414062500, -0.0015563964843750, 0.0018920898437500, -0.0014343261718750,
0.0019836425781250, -0.0016174316406250, 0.0023498535156250, -0.0016784667968750,
0.0017089843750000, -0.0015563964843750, 0.0012817382812500, -0.0015258789062500,
0.0017395019531250, -0.0015563964843750, -0.0000610351562500, -0.0014038085937500,
0.0005798339843750, -0.0014343261718750, -0.0002136230468750, -0.0013732910156250,
-0.0017700195312500, -0.0013122558593750, -0.0005187988281250, -0.0013427734375000,
-0.0028991699218750, -0.0010375976562500, -0.0024414062500000, -0.0010681152343750,
-0.0028076171875000, -0.0010375976562500, -0.0043334960937500, -0.0007934570312500,
-0.0030822753906250, -0.0008544921875000, -0.0048522949218750, -0.0006713867187500,
-0.0044860839843750, -0.0007019042968750, -0.0044860839843750, -0.0004577636718750,
-0.0054626464843750, -0.0001831054687500, -0.0047302246093750, -0.0002746582031250,
-0.0053100585937500, 0.0003967285156250, -0.0051269531250000, 0.0003356933593750,
-0.0050354003906250, 0.0004882812500000, -0.0052795410156250, 0.0008850097656250,
-0.0049133300781250, 0.0008239746093750, -0.0049743652343750, 0.0010986328125000,
-0.0048828125000000, 0.0010375976562500, -0.0046691894531250, 0.0012512207031250,
-0.0045776367187500, 0.0016174316406250, -0.0044555664062500, 0.0014038085937500,
-0.0044860839843750, 0.0018005371093750, -0.0043029785156250, 0.0020141601562500,
-0.0041809082031250, 0.0018920898437500, -0.0041503906250000, 0.0019836425781250,
-0.0039978027343750, 0.0021667480468750, -0.0039062500000000, 0.0017700195312500,
-0.0037231445312500, 0.0019226074218750, -0.0037536621093750, 0.0018615722656250,
-0.0038146972656250, 0.0016784667968750, -0.0035095214843750, 0.0018310546875000,
-0.0039672851562500, 0.0015869140625000, -0.0038452148437500, 0.0017089843750000,
-0.0038146972656250, 0.0014953613281250, -0.0040588378906250, 0.0011901855468750,
-0.0039367675781250, 0.0014648437500000, -0.0042419433593750, 0.0009460449218750,
-0.0040588378906250, 0.0009155273437500, -0.0041198730468750, 0.0009460449218750,
-0.0043334960937500, 0.0008239746093750, -0.0041503906250000, 0.0009155273437500,
-0.0043029785156250, 0.0000610351562500, -0.0042419433593750, 0.0004882812500000,
-0.0042419433593750, 0.0000000000000000, -0.0043029785156250, -0.0009155273437500,
-0.0042419433593750, -0.0003051757812500, -0.0043334960937500, -0.0017700195312500,
-0.0045166015625000, -0.0014648437500000, -0.0046386718750000, -0.0018615722656250,
-0.0047912597656250, -0.0031127929687500, -0.0050964355468750, -0.0024719238281250,
-0.0051574707031250, -0.0029602050781250, -0.0055236816406250, -0.0032653808593750,
-0.0056762695312500, -0.0029602050781250, -0.0057983398437500, -0.0028381347656250,
-0.0062866210937500, -0.0029296875000000, -0.0058898925781250, -0.0024719238281250,
-0.0062866210937500, -0.0024719238281250, -0.0060729980468750, -0.0025024414062500,
-0.0057983398437500, -0.0023498535156250, -0.0061645507812500, -0.0022888183593750,
-0.0041198730468750, -0.0020446777343750, -0.0048522949218750, -0.0020751953125000,
-0.0034179687500000, -0.0018920898437500, -0.0012207031250000, -0.0015869140625000,
-0.0027160644531250, -0.0017700195312500, 0.0007019042968750, -0.0017700195312500,
0.0004272460937500, -0.0014953613281250, 0.0002746582031250, -0.0019226074218750,
0.0021667480468750, -0.0022888183593750, 0.0014038085937500, -0.0019836425781250,
0.0011596679687500, -0.0027160644531250, 0.0017395019531250, -0.0027465820312500,
0.0009765625000000, -0.0026855468750000, 0.0000915527343750, -0.0028076171875000,
0.0007019042968750, -0.0027160644531250, -0.0005187988281250, -0.0034484863281250,
-0.0007629394531250, -0.0034790039062500, -0.0005493164062500, -0.0027465820312500,
-0.0007934570312500, -0.0028991699218750, -0.0006103515625000, -0.0034790039062500,
-0.0003967285156250, -0.0011901855468750, 0.0002441406250000, -0.0014038085937500,
-0.0004272460937500, -0.0010986328125000, -0.0010986328125000, 0.0003662109375000,
-0.0003051757812500, -0.0001525878906250, -0.0026550292968750, 0.0007629394531250,
-0.0027465820312500, 0.0009155273437500, -0.0029602050781250, 0.0009155273437500,
-0.0044250488281250, 0.0014343261718750, -0.0038757324218750, 0.0013122558593750,
-0.0030822753906250, 0.0007324218750000, -0.0037536621093750, 0.0012512207031250,
-0.0030212402343750, 0.0004272460937500, -0.0014343261718750, -0.0007019042968750,
-0.0020446777343750, 0.0002136230468750, -0.0021057128906250, -0.0009765625000000,
-0.0015563964843750, -0.0012207031250000, -0.0020751953125000, -0.0007629394531250,
-0.0029296875000000, -0.0011901855468750, -0.0026855468750000, -0.0015258789062500,
-0.0025634765625000, 0.0003356933593750, -0.0029907226562500, 0.0000915527343750,
-0.0022583007812500, -0.0003662109375000, -0.0012512207031250, 0.0002441406250000,
-0.0014038085937500, 0.0001220703125000, 0.0001831054687500, 0.0001525878906250,
-0.0002746582031250, 0.0000915527343750, -0.0003967285156250, -0.0000915527343750,
0.0006103515625000, -0.0003356933593750, 0.0001831054687500, -0.0006713867187500,
-0.0002136230468750, -0.0009765625000000, 0.0002441406250000, -0.0009765625000000,
-0.0004882812500000, -0.0014038085937500, -0.0014343261718750, -0.0018615722656250,
-0.0008544921875000, -0.0015563964843750, -0.0023193359375000, -0.0019836425781250,
-0.0023803710937500, -0.0022583007812500, -0.0021057128906250, -0.0021362304687500,
-0.0028686523437500, -0.0021972656250000, -0.0028076171875000, -0.0025329589843750,
-0.0018615722656250, -0.0021057128906250, -0.0019226074218750, -0.0025939941406250,
-0.0016784667968750, -0.0024719238281250, -0.0008850097656250, -0.0019226074218750,
-0.0010070800781250, -0.0024719238281250, -0.0008544921875000, -0.0021362304687500,
-0.0007629394531250, -0.0017395019531250, -0.0004577636718750, -0.0015563964843750,
-0.0002136230468750, -0.0012207031250000, -0.0004882812500000, -0.0005798339843750,
0.0001220703125000, -0.0005493164062500, 0.0003662109375000, -0.0001220703125000,
-0.0000915527343750, 0.0003967285156250, 0.0000915527343750, 0.0007324218750000,
0.0006103515625000, 0.0008544921875000, -0.0007934570312500, 0.0004882812500000,
-0.0003662109375000, 0.0010681152343750, -0.0007629394531250, 0.0007324218750000,
-0.0020751953125000, 0.0002746582031250, -0.0010986328125000, 0.0011901855468750,
-0.0012512207031250, 0.0001525878906250, -0.0017700195312500, 0.0009155273437500,
-0.0013732910156250, 0.0010070800781250, -0.0007324218750000, 0.0004882812500000,
-0.0009460449218750, 0.0015258789062500, -0.0008239746093750, 0.0004577636718750,
-0.0006103515625000, 0.0015258789062500, -0.0012207031250000, 0.0008239746093750,
-0.0017700195312500, -0.0005493164062500, -0.0014038085937500, 0.0009460449218750,
-0.0021362304687500, -0.0021667480468750, -0.0025634765625000, -0.0020446777343750,
-0.0023193359375000, -0.0025634765625000, -0.0023803710937500, -0.0049133300781250,
-0.0027465820312500, -0.0042114257812500, -0.0018920898437500, -0.0047607421875000,
-0.0023193359375000},
{-0.0005187988281250, -0.0019226074218750, -0.0001525878906250, -0.0027770996093750,
-0.0006408691406250, -0.0019226074218750, -0.0010375976562500, 0.0002136230468750,
-0.0008544921875000, -0.0006408691406250, -0.0011901855468750, 0.0004882812500000,
-0.0011596679687500, 0.0009155273437500, -0.0009765625000000, 0.0007324218750000,
-0.0006408691406250, 0.0010986328125000, -0.0002136230468750, 0.0010070800781250,
-0.0011596679687500, 0.0007629394531250, -0.0007629394531250, 0.0010375976562500,
-0.0014343261718750, 0.0004272460937500, -0.0026550292968750, -0.0001525878906250,
-0.0020446777343750, 0.0003051757812500, -0.0039672851562500, -0.0015563964843750,
-0.0040893554687500, -0.0015258789062500, -0.0036926269531250, -0.0011291503906250,
-0.0043640136718750, -0.0020141601562500, -0.0043945312500000, -0.0019836425781250,
-0.0029907226562500, -0.0007019042968750, -0.0031127929687500, -0.0013427734375000,
-0.0031127929687500, -0.0003967285156250, -0.0022888183593750, 0.0014038085937500,
-0.0025024414062500, 0.0003662109375000, -0.0028076171875000, 0.0004272460937500,
-0.0027465820312500, 0.0012207031250000, -0.0027465820312500, 0.0007629394531250,
-0.0031738281250000, 0.0000000000000000, -0.0030517578125000, 0.0003051757812500,
-0.0011291503906250, -0.0005798339843750, -0.0023193359375000, -0.0004272460937500,
-0.0014343261718750, -0.0006408691406250, 0.0007019042968750, -0.0014038085937500,
-0.0008544921875000, -0.0010375976562500, 0.0010986328125000, -0.0015563964843750,
0.0014038085937500, -0.0018615722656250, 0.0005798339843750, -0.0013427734375000,
0.0008544921875000, -0.0010375976562500, 0.0009765625000000, -0.0017395019531250,
0.0000610351562500, -0.0011901855468750, 0.0000610351562500, -0.0011596679687500,
-0.0004882812500000, -0.0019226074218750, -0.0010681152343750, -0.0023803710937500,
-0.0005798339843750, -0.0022583007812500, -0.0020751953125000, -0.0028076171875000,
-0.0018310546875000, -0.0030212402343750, -0.0021362304687500, -0.0026245117187500,
-0.0032958984375000, -0.0023803710937500, -0.0024719238281250, -0.0021667480468750,
-0.0025939941406250, -0.0007324218750000, -0.0030517578125000, -0.0003967285156250,
-0.0022583007812500, -0.0001831054687500, -0.0014953613281250, 0.0006103515625000,
-0.0019836425781250, 0.0007019042968750, -0.0006713867187500, 0.0003356933593750,
-0.0006103515625000, 0.0004272460937500, -0.0004882812500000, 0.0002441406250000,
0.0002136230468750, -0.0000610351562500, 0.0000000000000000, 0.0003662109375000,
0.0001220703125000, 0.0002136230468750, 0.0003662109375000, 0.0005187988281250,
0.0001831054687500, 0.0006408691406250, 0.0000915527343750, 0.0009155273437500,
0.0002441406250000, 0.0015258789062500, -0.0010681152343750, 0.0003051757812500,
-0.0009155273437500, 0.0011291503906250, -0.0007629394531250, 0.0002746582031250,
-0.0015563964843750, -0.0011596679687500, -0.0016479492187500, 0.0000915527343750,
-0.0014343261718750, -0.0028991699218750, -0.0016479492187500, -0.0028991699218750,
-0.0016174316406250, -0.0030822753906250, -0.0014343261718750, -0.0050964355468750,
-0.0018005371093750, -0.0049438476562500, -0.0018615722656250, -0.0046997070312500,
-0.0019531250000000, -0.0058593750000000, -0.0019226074218750, -0.0052185058593750,
-0.0020141601562500, -0.0042114257812500, -0.0023803710937500, -0.0056457519531250,
-0.0015258789062500, -0.0037536621093750, -0.0021057128906250, -0.0042724609375000,
-0.0015258789062500, -0.0044250488281250, -0.0004577636718750, -0.0035095214843750,
-0.0014953613281250, -0.0044250488281250, 0.0000305175781250, -0.0036010742187500,
-0.0000915527343750, -0.0041198730468750, -0.0003356933593750, -0.0038146972656250,
0.0002746582031250, -0.0030822753906250, -0.0001831054687500, -0.0040893554687500,
-0.0000305175781250, -0.0028686523437500, -0.0002136230468750, -0.0032958984375000,
-0.0003356933593750, -0.0030517578125000, -0.0002746582031250, -0.0021972656250000,
-0.0004882812500000, -0.0030517578125000, -0.0007629394531250, -0.0019531250000000,
-0.0007324218750000, -0.0022888183593750, -0.0009460449218750, -0.0019836425781250,
-0.0012512207031250, -0.0012817382812500, -0.0012207031250000, -0.0021362304687500,
-0.0010986328125000, -0.0011596679687500, -0.0014648437500000, -0.0012512207031250,
-0.0010986328125000, -0.0015258789062500, -0.0006713867187500, -0.0009765625000000,
-0.0011596679687500, -0.0008850097656250, -0.0003967285156250, -0.0017089843750000,
-0.0002441406250000, -0.0014648437500000, -0.0006103515625000, -0.0018005371093750,
-0.0004577636718750, -0.0025329589843750, -0.0002746582031250, -0.0021057128906250,
-0.0010070800781250, -0.0027465820312500, -0.0008850097656250, -0.0033569335937500,
-0.0010070800781250, -0.0031433105468750, -0.0015869140625000, -0.0031738281250000,
-0.0012207031250000, -0.0038452148437500, -0.0014343261718750, -0.0032348632812500,
-0.0016479492187500, -0.0037231445312500, -0.0013427734375000, -0.0038452148437500,
-0.0010986328125000, -0.0034790039062500, -0.0013122558593750, -0.0040893554687500,
-0.0008239746093750, -0.0036010742187500, -0.0008239746093750, -0.0036010742187500,
-0.0008239746093750, -0.0036010742187500, -0.0005187988281250, -0.0032348632812500,
-0.0006408691406250, -0.0033264160156250, -0.0004882812500000, -0.0031433105468750,
-0.0005187988281250, -0.0028076171875000, -0.0004577636718750, -0.0026245117187500,
-0.0003967285156250, -0.0024414062500000, -0.0004577636718750, -0.0020141601562500,
-0.0003356933593750, -0.0016174316406250, -0.0003356933593750, -0.0014648437500000,
-0.0004272460937500, -0.0007324218750000, -0.0003662109375000, -0.0002746582031250,
-0.0004577636718750, -0.0005493164062500, -0.0007629394531250, 0.0006713867187500,
-0.0007629394531250, 0.0004882812500000, -0.0010070800781250, 0.0007934570312500,
-0.0012817382812500, 0.0015563964843750, -0.0011291503906250, 0.0008239746093750,
-0.0021362304687500, 0.0014343261718750, -0.0018920898437500, 0.0011596679687500,
-0.0021667480468750, 0.0007934570312500, -0.0029296875000000, 0.0009460449218750,
-0.0024719238281250, 0.0005187988281250, -0.0032043457031250, 0.0004577636718750,
-0.0031127929687500, 0.0002441406250000, -0.0031738281250000, 0.0000915527343750,
-0.0036315917968750, 0.0001220703125000, -0.0032348632812500, -0.0001220703125000,
-0.0031127929687500, -0.0001525878906250, -0.0034179687500000, -0.0001831054687500,
-0.0025634765625000, -0.0001220703125000, -0.0018310546875000, -0.0000305175781250,
-0.0023803710937500, 0.0000610351562500, -0.0003967285156250, 0.0003051757812500,
-0.0004882812500000, 0.0004882812500000, -0.0003356933593750, 0.0006713867187500,
0.0009155273437500, 0.0009155273437500, 0.0006103515625000, 0.0009155273437500,
0.0005798339843750, 0.0005798339843750, 0.0008544921875000, 0.0010375976562500,
0.0007324218750000, 0.0001525878906250, 0.0005493164062500, -0.0007629394531250,
0.0006713867187500, 0.0000305175781250, 0.0006103515625000, -0.0019226074218750,
0.0006103515625000, -0.0018005371093750, 0.0004882812500000, -0.0017395019531250,
0.0003356933593750, -0.0028991699218750, 0.0004577636718750, -0.0025329589843750,
0.0005493164062500, -0.0021057128906250, 0.0002136230468750, -0.0027770996093750,
0.0007629394531250, -0.0020446777343750, 0.0013732910156250, -0.0010070800781250,
0.0008850097656250, -0.0020141601562500, 0.0016174316406250, -0.0017089843750000,
0.0019836425781250, -0.0008239746093750, 0.0013732910156250, -0.0021362304687500,
0.0010070800781250, -0.0031127929687500, 0.0013427734375000, -0.0017395019531250,
0.0008544921875000, -0.0043640136718750, 0.0004882812500000, -0.0043945312500000,
0.0008239746093750, -0.0041503906250000, 0.0011596679687500, -0.0054321289062500,
0.0007934570312500, -0.0049133300781250, 0.0005798339843750, -0.0041809082031250,
0.0009460449218750, -0.0048522949218750, 0.0001525878906250, -0.0036315917968750,
-0.0007324218750000, -0.0021057128906250, -0.0001525878906250, -0.0030822753906250,
-0.0018310546875000, -0.0005187988281250, -0.0014648437500000, -0.0007019042968750,
-0.0017395019531250, -0.0003051757812500, -0.0030822753906250, 0.0016784667968750,
-0.0025024414062500, 0.0010070800781250, -0.0031127929687500, 0.0003662109375000,
-0.0028686523437500, 0.0017700195312500, -0.0034179687500000, 0.0000610351562500,
-0.0041809082031250, -0.0022583007812500, -0.0034179687500000, -0.0005798339843750,
-0.0047912597656250, -0.0025939941406250, -0.0051879882812500, -0.0031738281250000,
-0.0041198730468750, -0.0025634765625000, -0.0040588378906250, -0.0027465820312500,
-0.0046691894531250, -0.0028991699218750, -0.0019836425781250, -0.0035705566406250,
-0.0022277832031250, -0.0030212402343750, -0.0023498535156250, -0.0037841796875000,
-0.0001831054687500, -0.0058898925781250, -0.0029602050781250, -0.0021057128906250,
-0.0036621093750000, -0.0032958984375000, -0.0039367675781250, -0.0019226074218750,
-0.0027160644531250, -0.0034790039062500, -0.0020141601562500, -0.0056762695312500,
-0.0027770996093750, -0.0045166015625000, -0.0010986328125000, -0.0050964355468750,
-0.0004272460937500, -0.0061340332031250, -0.0011901855468750, -0.0046997070312500,
-0.0013427734375000, -0.0032653808593750, -0.0007934570312500, -0.0043334960937500,
-0.0017700195312500, -0.0030212402343750, -0.0019836425781250, -0.0021972656250000,
-0.0008239746093750, -0.0031433105468750, -0.0005187988281250, -0.0039367675781250,
-0.0010986328125000, -0.0033264160156250, 0.0014648437500000, -0.0038452148437500,
0.0015563964843750, -0.0048522949218750, 0.0007019042968750, -0.0036010742187500,
0.0018310546875000, -0.0024414062500000, 0.0018920898437500, -0.0035705566406250,
-0.0020141601562500, -0.0013122558593750, -0.0010986328125000, -0.0008239746093750,
-0.0020751953125000, -0.0014343261718750, -0.0057067871093750, -0.0011596679687500,
-0.0046081542968750, -0.0008544921875000, -0.0043640136718750, -0.0005798339843750,
-0.0060424804687500, -0.0011291503906250, -0.0044555664062500, -0.0003662109375000,
-0.0022277832031250, 0.0007019042968750, -0.0037536621093750, 0.0001525878906250,
-0.0009460449218750, 0.0012512207031250, -0.0001525878906250, 0.0015258789062500,
-0.0013427734375000, 0.0010375976562500, -0.0009155273437500, 0.0011596679687500,
0.0000000000000000, 0.0014343261718750, -0.0024719238281250, 0.0006103515625000,
-0.0020751953125000, 0.0003967285156250, -0.0018310546875000, 0.0009765625000000,
-0.0029296875000000, 0.0009460449218750, -0.0021972656250000, 0.0005493164062500,
-0.0019226074218750, 0.0020141601562500, -0.0020446777343750, 0.0022277832031250,
-0.0009765625000000, 0.0016479492187500, 0.0000305175781250, 0.0018920898437500,
-0.0003051757812500, 0.0021667480468750, 0.0012817382812500, 0.0008544921875000,
0.0020751953125000, 0.0008239746093750, 0.0013122558593750, 0.0010375976562500,
0.0017089843750000, 0.0006713867187500, 0.0028381347656250, 0.0006713867187500,
-0.0000915527343750, 0.0009155273437500, 0.0013427734375000, 0.0010681152343750,
0.0004882812500000, 0.0007934570312500, -0.0018920898437500, 0.0005493164062500,
0.0003967285156250, 0.0007324218750000, -0.0032348632812500, 0.0005798339843750,
-0.0020751953125000, 0.0003662109375000, -0.0024414062500000, 0.0004882812500000,
-0.0048522949218750, 0.0007324218750000, -0.0025939941406250, 0.0005798339843750,
-0.0045166015625000, 0.0000610351562500, -0.0041809082031250, 0.0004272460937500,
-0.0032958984375000, -0.0000915527343750, -0.0036315917968750, -0.0010070800781250,
-0.0028381347656250, -0.0004882812500000, -0.0027465820312500, -0.0012207031250000,
-0.0021362304687500, -0.0014648437500000, -0.0019836425781250, -0.0013122558593750,
-0.0019531250000000},
{-0.0031127929687500, -0.0007019042968750, -0.0041503906250000, 0.0014343261718750,
-0.0039672851562500, 0.0008544921875000, -0.0024108886718750, -0.0003967285156250,
-0.0030212402343750, 0.0007019042968750, -0.0025939941406250, -0.0003051757812500,
-0.0009765625000000, -0.0024108886718750, -0.0015869140625000, -0.0012512207031250,
-0.0021972656250000, -0.0021667480468750, -0.0016479492187500, -0.0027770996093750,
-0.0021667480468750, -0.0022277832031250, -0.0038452148437500, -0.0015563964843750,
-0.0025024414062500, -0.0018615722656250, -0.0015869140625000, -0.0014038085937500,
-0.0014343261718750, -0.0022277832031250, -0.0017395019531250, -0.0018310546875000,
-0.0016479492187500, -0.0004882812500000, -0.0011596679687500, -0.0007934570312500,
-0.0020141601562500, -0.0028686523437500, -0.0024108886718750, -0.0017395019531250,
-0.0014953613281250, -0.0029602050781250, -0.0010681152343750, -0.0057983398437500,
-0.0015563964843750, -0.0044555664062500, 0.0004577636718750, -0.0047912597656250,
0.0005187988281250, -0.0059509277343750, 0.0000000000000000, -0.0046386718750000,
0.0007934570312500, -0.0030517578125000, 0.0007019042968750, -0.0039978027343750,
-0.0008850097656250, -0.0028381347656250, -0.0007629394531250, -0.0023498535156250,
-0.0012817382812500, -0.0030212402343750, -0.0028381347656250, -0.0034484863281250,
-0.0025634765625000, -0.0031433105468750, -0.0021057128906250, -0.0032958984375000,
-0.0028686523437500, -0.0039367675781250, -0.0024414062500000, -0.0031127929687500,
-0.0012207031250000, -0.0020141601562500, -0.0016479492187500, -0.0025634765625000,
-0.0016479492187500, -0.0016174316406250, -0.0005187988281250, -0.0012817382812500,
-0.0015258789062500, -0.0014343261718750, -0.0026550292968750, -0.0013427734375000,
-0.0011901855468750, -0.0012512207031250, -0.0035705566406250, -0.0011596679687500,
-0.0034179687500000, -0.0014038085937500, -0.0025939941406250, -0.0007934570312500,
-0.0034790039062500, -0.0002441406250000, -0.0032958984375000, -0.0007934570312500,
-0.0014038085937500, 0.0002136230468750, -0.0013732910156250, 0.0006103515625000,
-0.0011291503906250, 0.0001831054687500, 0.0000610351562500, 0.0000305175781250,
0.0000305175781250, 0.0003356933593750, -0.0000915527343750, 0.0003051757812500,
0.0007629394531250, -0.0003051757812500, -0.0002136230468750, 0.0004882812500000,
-0.0010070800781250, 0.0016174316406250, 0.0003051757812500, 0.0009155273437500,
-0.0031127929687500, 0.0014343261718750, -0.0022583007812500, 0.0021057128906250,
-0.0025634765625000, 0.0011901855468750, -0.0047302246093750, 0.0004272460937500,
-0.0031433105468750, 0.0010986328125000, -0.0044555664062500, 0.0001220703125000,
-0.0037841796875000, -0.0002136230468750, -0.0037231445312500, 0.0002746582031250,
-0.0043029785156250, 0.0003662109375000, -0.0028381347656250, 0.0001220703125000,
-0.0045776367187500, 0.0005493164062500, -0.0033874511718750, 0.0006103515625000,
-0.0031738281250000, 0.0004272460937500, -0.0041503906250000, 0.0004272460937500,
-0.0026245117187500, 0.0004882812500000, -0.0039978027343750, 0.0005187988281250,
-0.0029296875000000, 0.0003051757812500, -0.0032043457031250, 0.0004272460937500,
-0.0043334960937500, 0.0007324218750000, -0.0027160644531250, 0.0004882812500000,
-0.0046691894531250, 0.0001831054687500, -0.0040283203125000, 0.0004882812500000,
-0.0038146972656250, 0.0001220703125000, -0.0048828125000000, -0.0005187988281250,
-0.0037536621093750, -0.0001525878906250, -0.0043640136718750, -0.0006408691406250,
-0.0044860839843750, -0.0006408691406250, -0.0039062500000000, -0.0006713867187500,
-0.0039062500000000, -0.0009155273437500, -0.0041198730468750, -0.0007324218750000,
-0.0029602050781250, -0.0010681152343750, -0.0035095214843750, -0.0010681152343750,
-0.0028686523437500, -0.0009765625000000, -0.0018005371093750, -0.0011596679687500,
-0.0029296875000000, -0.0010681152343750, -0.0012817382812500, -0.0010375976562500,
-0.0016784667968750, -0.0009765625000000, -0.0016479492187500, -0.0010375976562500,
-0.0006408691406250, -0.0010681152343750, -0.0012207031250000, -0.0010375976562500,
-0.0007019042968750, -0.0010681152343750, -0.0006408691406250, -0.0010681152343750,
-0.0005493164062500, -0.0009765625000000, -0.0002441406250000, -0.0009460449218750,
-0.0005798339843750, -0.0008544921875000, 0.0000000000000000, -0.0006408691406250,
-0.0002136230468750, -0.0007019042968750, -0.0000915527343750, -0.0005187988281250,
0.0003051757812500, -0.0001525878906250, -0.0000610351562500, -0.0003051757812500,
0.0005187988281250, -0.0000610351562500, 0.0002441406250000, 0.0001525878906250,
0.0003051757812500, -0.0001525878906250, 0.0007324218750000, -0.0003051757812500,
0.0001525878906250, 0.0000000000000000, 0.0004882812500000, -0.0007629394531250,
0.0002136230468750, -0.0006713867187500, -0.0001525878906250, -0.0007629394531250,
-0.0001525878906250, -0.0012817382812500, -0.0005187988281250, -0.0010070800781250,
-0.0009460449218750, -0.0014648437500000, -0.0008850097656250, -0.0014038085937500,
-0.0013427734375000, -0.0013732910156250, -0.0018615722656250, -0.0015258789062500,
-0.0016784667968750, -0.0013732910156250, -0.0028686523437500, -0.0012207031250000,
-0.0025329589843750, -0.0012512207031250, -0.0028076171875000, -0.0013122558593750,
-0.0037231445312500, -0.0012207031250000, -0.0031433105468750, -0.0010986328125000,
-0.0039672851562500, -0.0010681152343750, -0.0039062500000000, -0.0012817382812500,
-0.0040588378906250, -0.0009460449218750, -0.0045776367187500, -0.0006103515625000,
-0.0042724609375000, -0.0008544921875000, -0.0049133300781250, -0.0003967285156250,
-0.0046081542968750, -0.0003662109375000, -0.0045471191406250, -0.0002441406250000,
-0.0047912597656250, 0.0000915527343750, -0.0041809082031250, -0.0001525878906250,
-0.0043334960937500, -0.0003967285156250, -0.0041198730468750, 0.0000000000000000,
-0.0038452148437500, -0.0003051757812500, -0.0038452148437500, -0.0008850097656250,
-0.0035400390625000, -0.0005798339843750, -0.0036315917968750, -0.0006408691406250,
-0.0032958984375000, -0.0007324218750000, -0.0035400390625000, -0.0010375976562500,
-0.0037841796875000, -0.0010070800781250, -0.0032348632812500, -0.0008239746093750,
-0.0045166015625000, -0.0024108886718750, -0.0045471191406250, -0.0020141601562500,
-0.0043945312500000, -0.0022888183593750, -0.0052490234375000, -0.0037536621093750,
-0.0054626464843750, -0.0032958984375000, -0.0045776367187500, -0.0027465820312500,
-0.0052490234375000, -0.0033264160156250, -0.0048828125000000, -0.0027465820312500,
-0.0036926269531250, -0.0017089843750000, -0.0041503906250000, -0.0022583007812500,
-0.0032958984375000, -0.0007629394531250, -0.0025329589843750, -0.0008850097656250,
-0.0022277832031250, -0.0007629394531250, -0.0018310546875000, 0.0003662109375000,
-0.0014648437500000, 0.0001220703125000, -0.0018005371093750, -0.0001831054687500,
-0.0013427734375000, 0.0001220703125000, -0.0019226074218750, -0.0003051757812500,
-0.0027160644531250, -0.0007019042968750, -0.0021362304687500, -0.0002746582031250,
-0.0032043457031250, -0.0018005371093750, -0.0033569335937500, -0.0015563964843750,
-0.0029907226562500, -0.0017089843750000, -0.0036010742187500, -0.0027770996093750,
-0.0039672851562500, -0.0023193359375000, -0.0027770996093750, -0.0024719238281250,
-0.0028076171875000, -0.0028686523437500, -0.0025939941406250, -0.0020446777343750,
-0.0017700195312500, -0.0014343261718750, -0.0020751953125000, -0.0020446777343750,
-0.0023193359375000, -0.0001831054687500, -0.0020751953125000, -0.0000915527343750,
-0.0025024414062500, -0.0000305175781250, -0.0032653808593750, 0.0010070800781250,
-0.0028686523437500, 0.0006408691406250, -0.0026550292968750, -0.0001220703125000,
-0.0032043457031250, 0.0004882812500000, -0.0025939941406250, 0.0000610351562500,
-0.0016174316406250, -0.0010070800781250, -0.0020141601562500, -0.0006713867187500,
-0.0014038085937500, -0.0018310546875000, -0.0011291503906250, -0.0016174316406250,
-0.0010986328125000, -0.0012207031250000, -0.0010070800781250, -0.0014038085937500,
-0.0009155273437500, -0.0009155273437500, -0.0001220703125000, -0.0003356933593750,
-0.0004577636718750, -0.0003356933593750, -0.0003662109375000, -0.0004882812500000,
0.0002746582031250, -0.0002441406250000, 0.0000305175781250, -0.0003356933593750,
0.0006103515625000, -0.0021972656250000, 0.0003967285156250, -0.0016174316406250,
0.0009765625000000, -0.0024414062500000, 0.0017700195312500, -0.0043945312500000,
0.0010070800781250, -0.0033874511718750, 0.0021362304687500, -0.0036010742187500,
0.0025939941406250, -0.0040893554687500, 0.0015258789062500, -0.0032348632812500,
0.0011291503906250, -0.0023498535156250, 0.0018005371093750, -0.0025329589843750,
0.0000610351562500, -0.0014953613281250, -0.0001831054687500, -0.0011596679687500,
0.0000000000000000, -0.0015869140625000, -0.0007629394531250, -0.0015563964843750,
-0.0010070800781250, -0.0011596679687500, -0.0004577636718750, -0.0017089843750000,
-0.0002746582031250, -0.0019531250000000, -0.0012817382812500, -0.0016174316406250,
-0.0017700195312500, -0.0010070800781250, -0.0010375976562500, -0.0007629394531250,
-0.0032958984375000, -0.0016784667968750, -0.0035705566406250, -0.0007934570312500,
-0.0027770996093750, -0.0015563964843750, -0.0035095214843750, -0.0029907226562500,
-0.0040283203125000, -0.0018005371093750, -0.0017700195312500, -0.0036315917968750,
-0.0022888183593750, -0.0039062500000000, -0.0020446777343750, -0.0034484863281250,
-0.0004272460937500, -0.0040283203125000, -0.0011901855468750, -0.0042114257812500,
-0.0008850097656250, -0.0037231445312500, -0.0008544921875000, -0.0042724609375000,
-0.0010375976562500, -0.0040588378906250, -0.0010375976562500, -0.0037536621093750,
-0.0010986328125000, -0.0047302246093750, -0.0008239746093750, -0.0041198730468750,
-0.0012512207031250, -0.0047607421875000, -0.0007324218750000, -0.0049438476562500,
0.0001525878906250, -0.0047607421875000, -0.0003051757812500, -0.0056457519531250,
-0.0000305175781250, -0.0044555664062500, 0.0003967285156250, -0.0049743652343750,
-0.0000305175781250, -0.0045471191406250, -0.0002746582031250, -0.0034179687500000,
0.0001831054687500, -0.0041503906250000, -0.0009155273437500, -0.0028991699218750,
-0.0007629394531250, -0.0028991699218750, -0.0006103515625000, -0.0031738281250000,
-0.0011901855468750, -0.0028991699218750, -0.0010986328125000, -0.0032043457031250,
-0.0009460449218750, -0.0035705566406250, -0.0011901855468750, -0.0037231445312500,
-0.0008850097656250, -0.0038757324218750, -0.0005798339843750, -0.0042419433593750,
-0.0010070800781250, -0.0043945312500000, 0.0002746582031250, -0.0036926269531250,
0.0000915527343750, -0.0042419433593750, 0.0003356933593750, -0.0038757324218750,
0.0013427734375000, -0.0031738281250000, 0.0009460449218750, -0.0040283203125000,
0.0011596679687500, -0.0025024414062500, 0.0014343261718750, -0.0026245117187500,
0.0011291503906250, -0.0024108886718750, 0.0009460449218750, -0.0014038085937500,
0.0011596679687500, -0.0017089843750000, 0.0002441406250000, -0.0007629394531250,
0.0004577636718750, -0.0009155273437500, 0.0000000000000000, -0.0006713867187500,
-0.0008239746093750, -0.0001220703125000, -0.0003051757812500, -0.0006713867187500,
-0.0016174316406250, 0.0000915527343750, -0.0017089843750000, 0.0000305175781250,
-0.0014953613281250, 0.0000000000000000, -0.0020751953125000, 0.0000915527343750,
-0.0020751953125000, -0.0006713867187500, -0.0015258789062500, -0.0001220703125000,
-0.0016479492187500, -0.0001831054687500, -0.0015869140625000, -0.0007629394531250,
-0.0012207031250000, -0.0008544921875000, -0.0013122558593750, -0.0009765625000000,
-0.0014038085937500},
{-0.0006103515625000, -0.0026550292968750, -0.0006103515625000, -0.0038452148437500,
-0.0007629394531250, -0.0041503906250000, -0.0002136230468750, -0.0035095214843750,
0.0002441406250000, -0.0033569335937500, 0.0000610351562500, -0.0034484863281250,
0.0011596679687500, -0.0026245117187500, 0.0010375976562500, -0.0023498535156250,
0.0011901855468750, -0.0022888183593750, 0.0021057128906250, -0.0018310546875000,
0.0019836425781250, -0.0017089843750000, 0.0014343261718750, -0.0022583007812500,
0.0018920898437500, -0.0018920898437500, 0.0014038085937500, -0.0020446777343750,
0.0003662109375000, -0.0028076171875000, 0.0008544921875000, -0.0025329589843750,
0.0002746582031250, -0.0025634765625000, -0.0003662109375000, -0.0021972656250000,
0.0000305175781250, -0.0027160644531250, 0.0004272460937500, -0.0033569335937500,
-0.0001831054687500, -0.0026855468750000, -0.0004272460937500, -0.0034484863281250,
0.0001831054687500, -0.0037536621093750, -0.0010986328125000, -0.0034484863281250,
-0.0025024414062500, -0.0034790039062500, -0.0015258789062500, -0.0036010742187500,
-0.0031738281250000, -0.0030822753906250, -0.0036926269531250, -0.0032958984375000,
-0.0029602050781250, -0.0036621093750000, -0.0030822753906250, -0.0037841796875000,
-0.0035400390625000, -0.0041198730468750, -0.0018310546875000, -0.0044555664062500,
-0.0020141601562500, -0.0049743652343750, -0.0017700195312500, -0.0050964355468750,
-0.0007019042968750, -0.0053405761718750, -0.0011596679687500, -0.0056762695312500,
-0.0008850097656250, -0.0048522949218750, -0.0006713867187500, -0.0053710937500000,
-0.0006103515625000, -0.0048522949218750, -0.0007934570312500, -0.0038146972656250,
-0.0010070800781250, -0.0044860839843750, 0.0001831054687500, -0.0032958984375000,
-0.0000915527343750, -0.0030822753906250, 0.0000305175781250, -0.0032958984375000,
0.0009460449218750, -0.0029296875000000, 0.0004882812500000, -0.0029296875000000,
0.0003662109375000, -0.0031738281250000, 0.0009155273437500, -0.0034484863281250,
0.0003662109375000, -0.0030822753906250, -0.0003662109375000, -0.0029296875000000,
0.0003051757812500, -0.0033264160156250, -0.0005187988281250, -0.0018005371093750,
-0.0006103515625000, -0.0023498535156250, -0.0003662109375000, -0.0017089843750000,
-0.0005798339843750, -0.0003967285156250, -0.0004577636718750, -0.0014953613281250,
-0.0001525878906250, 0.0002136230468750, -0.0002441406250000, -0.0001525878906250,
0.0000915527343750, -0.0000305175781250, 0.0004577636718750, 0.0011596679687500,
0.0002136230468750, 0.0002136230468750, 0.0007324218750000, 0.0003356933593750,
0.0008850097656250, 0.0005187988281250, 0.0006408691406250, 0.0003356933593750,
0.0007324218750000, -0.0001220703125000, 0.0009155273437500, -0.0004577636718750,
0.0002136230468750, -0.0002441406250000, 0.0004272460937500, -0.0011901855468750,
0.0002746582031250, -0.0012207031250000, -0.0002441406250000, -0.0010070800781250,
0.0001220703125000, -0.0021362304687500, -0.0003967285156250, -0.0011291503906250,
-0.0003051757812500, -0.0020141601562500, -0.0004272460937500, -0.0023498535156250,
-0.0007629394531250, -0.0018005371093750, -0.0004882812500000, -0.0028686523437500,
-0.0010070800781250, -0.0025024414062500, -0.0010070800781250, -0.0025024414062500,
-0.0009460449218750, -0.0031127929687500, -0.0011596679687500, -0.0031738281250000,
-0.0010986328125000, -0.0028381347656250, -0.0012207031250000, -0.0034179687500000,
-0.0011291503906250, -0.0028991699218750, -0.0012512207031250, -0.0028686523437500,
-0.0014038085937500, -0.0033264160156250, -0.0012207031250000, -0.0028076171875000,
-0.0014343261718750, -0.0033264160156250, -0.0014648437500000, -0.0034179687500000,
-0.0012207031250000, -0.0033569335937500, -0.0012207031250000, -0.0037536621093750,
-0.0013427734375000, -0.0039672851562500, -0.0005493164062500, -0.0037841796875000,
-0.0007324218750000, -0.0042724609375000, -0.0004577636718750, -0.0043334960937500,
0.0001525878906250, -0.0041809082031250, -0.0000915527343750, -0.0048217773437500,
0.0003662109375000, -0.0044250488281250, 0.0004577636718750, -0.0048828125000000,
0.0004577636718750, -0.0048828125000000, 0.0006408691406250, -0.0046081542968750,
0.0006103515625000, -0.0052795410156250, 0.0005493164062500, -0.0044860839843750,
0.0006103515625000, -0.0046691894531250, 0.0007019042968750, -0.0043029785156250,
0.0006408691406250, -0.0034179687500000, 0.0006408691406250, -0.0036621093750000,
0.0011291503906250, -0.0022583007812500, 0.0010681152343750, -0.0022583007812500,
0.0013122558593750, -0.0016479492187500, 0.0018005371093750, -0.0003967285156250,
0.0016479492187500, -0.0007019042968750, 0.0016174316406250, 0.0001525878906250,
0.0018615722656250, 0.0008544921875000, 0.0014953613281250, 0.0005187988281250,
0.0010681152343750, 0.0005493164062500, 0.0013122558593750, 0.0010375976562500,
0.0005493164062500, -0.0003967285156250, 0.0006103515625000, 0.0000915527343750,
0.0005493164062500, -0.0006408691406250, 0.0001220703125000, -0.0020446777343750,
0.0003967285156250, -0.0012512207031250, 0.0003662109375000, -0.0030517578125000,
0.0002746582031250, -0.0030822753906250, 0.0006103515625000, -0.0029907226562500,
0.0010070800781250, -0.0041198730468750, 0.0009155273437500, -0.0040283203125000,
0.0008544921875000, -0.0035400390625000, 0.0012207031250000, -0.0039062500000000,
0.0010375976562500, -0.0036621093750000, 0.0005798339843750, -0.0030212402343750,
0.0008850097656250, -0.0030517578125000, 0.0007934570312500, -0.0021362304687500,
0.0007934570312500, -0.0020141601562500, 0.0006713867187500, -0.0019226074218750,
0.0007324218750000, -0.0012207031250000, 0.0009155273437500, -0.0012817382812500,
-0.0002746582031250, -0.0020446777343750, 0.0000610351562500, -0.0014038085937500,
-0.0004272460937500, -0.0019226074218750, -0.0014343261718750, -0.0029296875000000,
-0.0007629394531250, -0.0019836425781250, -0.0023193359375000, -0.0025939941406250,
-0.0023193359375000, -0.0024108886718750, -0.0021972656250000, -0.0019531250000000,
-0.0029907226562500, -0.0019836425781250, -0.0027465820312500, -0.0019226074218750,
-0.0024108886718750, -0.0018310546875000, -0.0024108886718750, -0.0011596679687500,
-0.0020751953125000, -0.0018920898437500, -0.0015869140625000, -0.0024108886718750,
-0.0016174316406250, -0.0014038085937500, -0.0014038085937500, -0.0038146972656250,
-0.0013122558593750, -0.0030822753906250, -0.0010070800781250, -0.0028686523437500,
-0.0007934570312500, -0.0043334960937500, -0.0010070800781250, -0.0033874511718750,
-0.0007934570312500, -0.0039978027343750, -0.0008239746093750, -0.0039672851562500,
-0.0009460449218750, -0.0028686523437500, -0.0008239746093750, -0.0023498535156250,
-0.0009460449218750, -0.0024719238281250, -0.0012817382812500, -0.0006713867187500,
-0.0010681152343750, -0.0001220703125000, -0.0015258789062500, -0.0009460449218750,
-0.0021362304687500, -0.0006713867187500, -0.0016174316406250, -0.0000305175781250,
-0.0021057128906250, -0.0027160644531250, -0.0025939941406250, -0.0023193359375000,
-0.0017395019531250, -0.0022583007812500, -0.0009765625000000, -0.0039062500000000,
-0.0014953613281250, -0.0032348632812500, -0.0006103515625000, -0.0023803710937500,
-0.0000610351562500, -0.0030517578125000, -0.0003356933593750, -0.0024414062500000,
-0.0006103515625000, -0.0002441406250000, 0.0002136230468750, -0.0032043457031250,
-0.0001220703125000, -0.0014038085937500, -0.0000305175781250, -0.0022277832031250,
-0.0003662109375000, -0.0016479492187500, -0.0006103515625000, -0.0000610351562500,
-0.0003356933593750, -0.0002746582031250, -0.0015258789062500, -0.0011596679687500,
-0.0018920898437500, -0.0006713867187500, -0.0011596679687500, -0.0008239746093750,
-0.0012207031250000, -0.0018005371093750, -0.0017700195312500, -0.0014648437500000,
0.0003662109375000, -0.0010681152343750, 0.0007324218750000, -0.0009765625000000,
-0.0000915527343750, -0.0014038085937500, 0.0009765625000000, -0.0011291503906250,
0.0020751953125000, -0.0006713867187500, -0.0023498535156250, -0.0029296875000000,
-0.0005798339843750, -0.0023498535156250, -0.0014953613281250, -0.0029907226562500,
-0.0054016113281250, -0.0050964355468750, -0.0027770996093750, -0.0039367675781250,
-0.0034484863281250, -0.0038757324218750, -0.0046386718750000, -0.0046997070312500,
-0.0024414062500000, -0.0038452148437500, -0.0005187988281250, -0.0025024414062500,
-0.0017089843750000, -0.0030822753906250, 0.0007629394531250, -0.0026550292968750,
0.0014038085937500, -0.0021667480468750, 0.0003662109375000, -0.0025634765625000,
0.0008544921875000, -0.0029907226562500, 0.0013732910156250, -0.0026550292968750,
-0.0014953613281250, -0.0021972656250000, -0.0007019042968750, -0.0027465820312500,
-0.0010375976562500, -0.0019531250000000, -0.0031127929687500, -0.0007019042968750,
-0.0019226074218750, -0.0014953613281250, -0.0022888183593750, -0.0009765625000000,
-0.0021667480468750, -0.0006103515625000, -0.0021667480468750, -0.0009765625000000,
-0.0022888183593750, -0.0014953613281250, -0.0016479492187500, -0.0014648437500000,
-0.0025024414062500, -0.0008544921875000, -0.0022277832031250, -0.0013122558593750,
-0.0024108886718750, -0.0010070800781250, -0.0029296875000000, -0.0001831054687500,
-0.0024108886718750, -0.0006103515625000, -0.0039367675781250, -0.0004882812500000,
-0.0036315917968750, -0.0004882812500000, -0.0036315917968750, -0.0002441406250000,
-0.0049438476562500, -0.0001220703125000, -0.0046997070312500, -0.0003967285156250,
-0.0036315917968750, 0.0005798339843750, -0.0047912597656250, 0.0005187988281250,
-0.0037231445312500, 0.0003967285156250, -0.0022277832031250, 0.0009155273437500,
-0.0038146972656250, 0.0009155273437500, -0.0009155273437500, 0.0004272460937500,
-0.0017089843750000, 0.0004882812500000, -0.0013732910156250, 0.0007324218750000,
0.0004882812500000, 0.0005187988281250, -0.0011596679687500, 0.0003662109375000,
0.0004272460937500, 0.0012207031250000, 0.0000000000000000, 0.0011901855468750,
-0.0006103515625000, 0.0010986328125000, -0.0002136230468750, 0.0016479492187500,
-0.0010986328125000, 0.0015869140625000, -0.0011901855468750, 0.0012207031250000,
-0.0019226074218750, 0.0013122558593750, -0.0021972656250000, 0.0012817382812500,
-0.0023803710937500, 0.0010986328125000, -0.0032348632812500, 0.0010986328125000,
-0.0024414062500000, 0.0010070800781250, -0.0033874511718750, 0.0010681152343750,
-0.0032653808593750, 0.0009155273437500, -0.0025939941406250, 0.0006408691406250,
-0.0038146972656250, 0.0007629394531250, -0.0021057128906250, 0.0006103515625000,
-0.0026855468750000, 0.0005187988281250, -0.0027160644531250, 0.0005493164062500,
-0.0016784667968750, 0.0005798339843750, -0.0024108886718750, 0.0005187988281250,
-0.0009460449218750, 0.0003356933593750, -0.0013427734375000, 0.0004882812500000,
-0.0007324218750000, 0.0003356933593750, 0.0004272460937500, 0.0001220703125000,
-0.0005798339843750, 0.0001831054687500, 0.0011596679687500, 0.0000305175781250,
0.0007934570312500, 0.0000610351562500, 0.0008544921875000, -0.0000915527343750,
0.0018615722656250, -0.0002441406250000, 0.0010070800781250, -0.0000915527343750,
0.0020141601562500, -0.0007629394531250, 0.0018310546875000, -0.0005493164062500,
0.0017395019531250, -0.0008239746093750, 0.0023498535156250, -0.0013732910156250,
0.0019226074218750, -0.0009765625000000, 0.0020751953125000, -0.0017700195312500,
0.0022888183593750, -0.0017700195312500, 0.0020141601562500, -0.0017089843750000,
0.0018920898437500, -0.0020141601562500, 0.0020141601562500, -0.0019531250000000,
0.0014648437500000, -0.0019226074218750, 0.0016784667968750, -0.0019531250000000,
0.0014038085937500},
{0.0002746582031250, -0.0021667480468750, -0.0011291503906250, -0.0024108886718750,
-0.0009460449218750, -0.0044250488281250, -0.0004882812500000, -0.0038757324218750,
-0.0029602050781250, -0.0032043457031250, -0.0024414062500000, -0.0037536621093750,
-0.0024414062500000, -0.0032653808593750, -0.0039672851562500, -0.0021057128906250,
-0.0030212402343750, -0.0025634765625000, -0.0026245117187500, -0.0024414062500000,
-0.0028076171875000, -0.0021667480468750, -0.0024108886718750, -0.0020751953125000,
-0.0015563964843750, -0.0023193359375000, -0.0016479492187500, -0.0024414062500000,
-0.0029907226562500, -0.0011901855468750, -0.0025939941406250, -0.0014648437500000,
-0.0027770996093750, -0.0013122558593750, -0.0041809082031250, -0.0002136230468750,
-0.0041198730468750, -0.0005187988281250, -0.0036010742187500, -0.0010070800781250,
-0.0045166015625000, -0.0008850097656250, -0.0038146972656250, -0.0008544921875000,
-0.0029296875000000, -0.0013122558593750, -0.0041198730468750, -0.0014038085937500,
-0.0013427734375000, -0.0006103515625000, -0.0021667480468750, -0.0009765625000000,
-0.0017089843750000, -0.0007324218750000, 0.0004272460937500, 0.0000305175781250,
-0.0010070800781250, -0.0003967285156250, -0.0003051757812500, 0.0002441406250000,
0.0000610351562500, 0.0002136230468750, -0.0007324218750000, 0.0003662109375000,
-0.0011596679687500, 0.0007019042968750, -0.0009765625000000, 0.0003967285156250,
-0.0023498535156250, 0.0011596679687500, -0.0024108886718750, 0.0011291503906250,
-0.0027465820312500, 0.0010070800781250, -0.0038452148437500, 0.0014038085937500,
-0.0037536621093750, 0.0013732910156250, -0.0038757324218750, 0.0009765625000000,
-0.0047607421875000, 0.0009460449218750, -0.0039367675781250, 0.0011596679687500,
-0.0033874511718750, 0.0010681152343750, -0.0047302246093750, 0.0009155273437500,
-0.0016784667968750, 0.0014648437500000, -0.0027160644531250, 0.0014953613281250,
-0.0019836425781250, 0.0014038085937500, 0.0003662109375000, 0.0016479492187500,
-0.0013427734375000, 0.0016174316406250, 0.0013122558593750, 0.0016174316406250,
0.0010986328125000, 0.0015258789062500, 0.0012817382812500, 0.0015563964843750,
0.0029602050781250, 0.0017700195312500, 0.0021972656250000, 0.0015869140625000,
0.0028381347656250, 0.0015563964843750, 0.0033264160156250, 0.0016784667968750,
0.0030822753906250, 0.0014648437500000, 0.0031127929687500, 0.0011901855468750,
0.0037536621093750, 0.0012817382812500, 0.0036926269531250, 0.0010681152343750,
0.0038146972656250, 0.0010375976562500, 0.0037841796875000, 0.0009460449218750,
0.0036315917968750, 0.0008544921875000, 0.0037536621093750, 0.0008850097656250,
0.0031127929687500, 0.0004882812500000, 0.0032958984375000, 0.0005798339843750,
0.0029907226562500, 0.0002746582031250, 0.0025329589843750, -0.0001525878906250,
0.0031738281250000, 0.0000915527343750, 0.0022583007812500, -0.0006713867187500,
0.0026245117187500, -0.0005798339843750, 0.0024414062500000, -0.0007324218750000,
0.0018005371093750, -0.0012512207031250, 0.0025634765625000, -0.0010375976562500,
0.0013122558593750, -0.0014343261718750, 0.0018310546875000, -0.0014648437500000,
0.0018005371093750, -0.0015258789062500, 0.0010375976562500, -0.0018005371093750,
0.0018920898437500, -0.0016784667968750, 0.0011596679687500, -0.0019226074218750,
0.0016174316406250, -0.0020141601562500, 0.0016784667968750, -0.0019836425781250,
0.0013122558593750, -0.0020751953125000, 0.0021667480468750, -0.0020751953125000,
0.0017395019531250, -0.0017700195312500, 0.0020446777343750, -0.0020141601562500,
0.0023498535156250, -0.0014953613281250, 0.0022277832031250, -0.0010375976562500,
0.0027465820312500, -0.0015258789062500, 0.0030212402343750, -0.0001220703125000,
0.0030212402343750, -0.0003051757812500, 0.0028076171875000, -0.0001220703125000,
0.0028076171875000, 0.0007019042968750, 0.0030212402343750, 0.0002746582031250,
0.0022583007812500, 0.0007934570312500, 0.0027160644531250, 0.0009460449218750,
0.0024108886718750, 0.0005187988281250, 0.0017089843750000, 0.0004577636718750,
0.0024414062500000, 0.0007324218750000, 0.0012817382812500, 0.0001831054687500,
0.0014648437500000, 0.0000000000000000, 0.0013427734375000, 0.0003356933593750,
0.0004577636718750, 0.0004272460937500, 0.0007324218750000, 0.0002136230468750,
-0.0000915527343750, 0.0003967285156250, -0.0001220703125000, 0.0004882812500000,
-0.0005798339843750, 0.0003356933593750, -0.0014343261718750, 0.0002441406250000,
-0.0014648437500000, 0.0003051757812500, -0.0023498535156250, -0.0000610351562500,
-0.0023498535156250, -0.0000610351562500, -0.0024414062500000, -0.0001525878906250,
-0.0027160644531250, -0.0004272460937500, -0.0022583007812500, -0.0003967285156250,
-0.0025634765625000, -0.0004577636718750, -0.0021667480468750, -0.0006103515625000,
-0.0021972656250000, -0.0004272460937500, -0.0025939941406250, -0.0002441406250000,
-0.0024108886718750, -0.0004882812500000, -0.0030822753906250, -0.0003051757812500,
-0.0032653808593750, 0.0000915527343750, -0.0035705566406250, -0.0007324218750000,
-0.0041503906250000, -0.0014953613281250, -0.0043334960937500, -0.0007019042968750,
-0.0048522949218750, -0.0019226074218750, -0.0053405761718750, -0.0022277832031250,
-0.0050048828125000, -0.0018005371093750, -0.0050354003906250, -0.0021057128906250,
-0.0059509277343750, -0.0021667480468750, -0.0042419433593750, -0.0009460449218750,
-0.0045471191406250, -0.0011596679687500, -0.0049438476562500, -0.0012207031250000,
-0.0039978027343750, -0.0003356933593750, -0.0038146972656250, -0.0004272460937500,
-0.0039062500000000, -0.0005798339843750, -0.0038146972656250, -0.0006103515625000,
-0.0033569335937500, -0.0002746582031250, -0.0034484863281250, -0.0001525878906250,
-0.0041503906250000, -0.0004882812500000, -0.0026855468750000, -0.0000610351562500,
-0.0026855468750000, 0.0000305175781250, -0.0028381347656250, -0.0001220703125000,
-0.0020751953125000, 0.0000610351562500, -0.0022888183593750, 0.0000610351562500,
-0.0030822753906250, -0.0007019042968750, -0.0018920898437500, -0.0003967285156250,
-0.0025024414062500, -0.0007324218750000, -0.0040588378906250, -0.0014343261718750,
-0.0030212402343750, -0.0009460449218750, -0.0038146972656250, -0.0018920898437500,
-0.0042724609375000, -0.0019531250000000, -0.0036315917968750, -0.0019836425781250,
-0.0034484863281250, -0.0022583007812500, -0.0037536621093750, -0.0018920898437500,
-0.0028076171875000, -0.0025634765625000, -0.0032348632812500, -0.0028076171875000,
-0.0026550292968750, -0.0025329589843750, -0.0018005371093750, -0.0022888183593750,
-0.0027160644531250, -0.0023498535156250, -0.0009460449218750, -0.0035095214843750,
-0.0014343261718750, -0.0026855468750000, -0.0013732910156250, -0.0027465820312500,
-0.0000305175781250, -0.0035095214843750, -0.0006408691406250, -0.0025329589843750,
-0.0006408691406250, -0.0035400390625000, 0.0000610351562500, -0.0029907226562500,
-0.0008239746093750, -0.0029907226562500, -0.0017700195312500, -0.0035400390625000,
-0.0007934570312500, -0.0026550292968750, -0.0018310546875000, -0.0039672851562500,
-0.0020751953125000, -0.0037231445312500, -0.0014648437500000, -0.0036621093750000,
-0.0012817382812500, -0.0047302246093750, -0.0012817382812500, -0.0045166015625000,
-0.0005187988281250, -0.0035400390625000, -0.0003356933593750, -0.0034790039062500,
-0.0007324218750000, -0.0034790039062500, -0.0006408691406250, -0.0026855468750000,
-0.0002441406250000, -0.0021362304687500, -0.0007324218750000, -0.0029296875000000,
-0.0009155273437500, -0.0019531250000000, -0.0006103515625000, -0.0027160644531250,
-0.0004577636718750, -0.0039062500000000, -0.0005493164062500, -0.0023193359375000,
-0.0003051757812500, -0.0048828125000000, -0.0001831054687500, -0.0049743652343750,
-0.0005493164062500, -0.0046997070312500, -0.0007934570312500, -0.0059814453125000,
-0.0006103515625000, -0.0059204101562500, -0.0014648437500000, -0.0053710937500000,
-0.0014953613281250, -0.0057983398437500, -0.0014953613281250, -0.0056762695312500,
-0.0020751953125000, -0.0052490234375000, -0.0021362304687500, -0.0056457519531250,
-0.0019531250000000, -0.0047912597656250, -0.0021057128906250, -0.0051879882812500,
-0.0018920898437500, -0.0047607421875000, -0.0016479492187500, -0.0040893554687500,
-0.0020446777343750, -0.0050354003906250, -0.0014953613281250, -0.0030822753906250,
-0.0015869140625000, -0.0039367675781250, -0.0010986328125000, -0.0033874511718750,
-0.0004882812500000, -0.0017395019531250, -0.0011291503906250, -0.0029907226562500,
-0.0002136230468750, -0.0011901855468750, -0.0001220703125000, -0.0015258789062500,
-0.0000915527343750, -0.0015869140625000, 0.0001525878906250, -0.0007324218750000,
-0.0000610351562500, -0.0017395019531250, 0.0006408691406250, -0.0011596679687500,
0.0003662109375000, -0.0017700195312500, 0.0007019042968750, -0.0019226074218750,
0.0013732910156250, -0.0015869140625000, 0.0007629394531250, -0.0025329589843750,
0.0014038085937500, -0.0012512207031250, 0.0017089843750000, -0.0017700195312500,
0.0010986328125000, -0.0014038085937500, 0.0009765625000000, -0.0003051757812500,
0.0014038085937500, -0.0010681152343750, 0.0000305175781250, 0.0002136230468750,
0.0003356933593750, 0.0002441406250000, 0.0001220703125000, 0.0001220703125000,
-0.0007629394531250, 0.0007019042968750, -0.0001220703125000, 0.0006103515625000,
-0.0007629394531250, 0.0006103515625000, -0.0006103515625000, 0.0010681152343750,
-0.0003356933593750, 0.0006103515625000, -0.0005493164062500, 0.0004577636718750,
-0.0003356933593750, 0.0012817382812500, 0.0000000000000000, -0.0003051757812500,
-0.0000305175781250, 0.0007324218750000, 0.0002136230468750, 0.0003967285156250,
0.0006103515625000, -0.0008544921875000, 0.0004882812500000, 0.0005798339843750,
0.0008850097656250, -0.0014343261718750, 0.0010070800781250, -0.0003051757812500,
0.0007629394531250, -0.0002746582031250, 0.0007934570312500, -0.0018615722656250,
0.0009765625000000, -0.0004577636718750, 0.0003662109375000, -0.0015869140625000,
0.0004882812500000, -0.0010681152343750, 0.0003967285156250, -0.0003967285156250,
-0.0000305175781250, -0.0008239746093750, 0.0001831054687500, -0.0002441406250000,
-0.0000305175781250, 0.0001525878906250, -0.0001525878906250, 0.0002441406250000,
-0.0000305175781250, 0.0002441406250000, 0.0000000000000000, 0.0005493164062500,
-0.0001220703125000, 0.0008239746093750, -0.0000915527343750, 0.0001831054687500,
-0.0000915527343750, 0.0010375976562500, -0.0001220703125000, 0.0007934570312500,
-0.0001220703125000, 0.0002136230468750, -0.0001831054687500, 0.0014343261718750,
-0.0001525878906250, 0.0000305175781250, -0.0003051757812500, 0.0009155273437500,
-0.0002136230468750, 0.0007934570312500, -0.0000610351562500, -0.0001220703125000,
-0.0002746582031250, 0.0013122558593750, 0.0004882812500000, -0.0004272460937500,
0.0003051757812500, 0.0003967285156250, 0.0008239746093750, 0.0003662109375000,
0.0016784667968750, -0.0007019042968750, 0.0014038085937500, 0.0007629394531250,
0.0022888183593750, -0.0001525878906250, 0.0024414062500000, -0.0000305175781250,
0.0023803710937500, 0.0004272460937500, 0.0026245117187500, 0.0001220703125000,
0.0025634765625000, 0.0001831054687500, 0.0024414062500000, 0.0001525878906250,
0.0022888183593750, 0.0003662109375000, 0.0022888183593750, -0.0000610351562500,
0.0022583007812500, -0.0001831054687500, 0.0020751953125000, 0.0003967285156250,
0.0020751953125000, -0.0008239746093750, 0.0019531250000000, 0.0000000000000000,
0.0019531250000000, -0.0006103515625000, 0.0018615722656250, -0.0018615722656250,
0.0016479492187500},
{-0.0018615722656250, -0.0015563964843750, -0.0025024414062500, -0.0036010742187500,
-0.0008239746093750, -0.0012512207031250, -0.0011901855468750, -0.0018005371093750,
-0.0012207031250000, -0.0021972656250000, -0.0001220703125000, -0.0012817382812500,
-0.0005187988281250, -0.0025634765625000, -0.0000305175781250, -0.0015563964843750,
0.0000305175781250, -0.0027160644531250, -0.0001220703125000, -0.0024414062500000,
0.0001525878906250, -0.0014953613281250, 0.0002136230468750, -0.0032348632812500,
0.0000915527343750, -0.0007324218750000, 0.0000305175781250, -0.0014953613281250,
-0.0000305175781250, -0.0010986328125000, -0.0001525878906250, 0.0009765625000000,
-0.0001525878906250, -0.0002746582031250, -0.0000915527343750, 0.0009765625000000,
-0.0002441406250000, 0.0013122558593750, -0.0000610351562500, 0.0008544921875000,
0.0002136230468750, 0.0011291503906250, 0.0000305175781250, 0.0011291503906250,
0.0003051757812500, 0.0001220703125000, 0.0005798339843750, 0.0006713867187500,
0.0003967285156250, 0.0001220703125000, 0.0004882812500000, -0.0007934570312500,
0.0008850097656250, 0.0003967285156250, 0.0002441406250000, -0.0012817382812500,
0.0005798339843750, -0.0005493164062500, 0.0005187988281250, -0.0005187988281250,
0.0000305175781250, -0.0012817382812500, 0.0005187988281250, 0.0001220703125000,
0.0002441406250000, -0.0010986328125000, 0.0001831054687500, 0.0000000000000000,
0.0003662109375000, 0.0003051757812500, 0.0003356933593750, -0.0002136230468750,
0.0003967285156250, 0.0014953613281250, 0.0006103515625000, 0.0006408691406250,
0.0006103515625000, 0.0019836425781250, 0.0007934570312500, 0.0025634765625000,
0.0010681152343750, 0.0018005371093750, 0.0010070800781250, 0.0029907226562500,
0.0011596679687500, 0.0031127929687500, 0.0013427734375000, 0.0027465820312500,
0.0011901855468750, 0.0033264160156250, 0.00112915