#include "types.h"
#include "dballe/core/data.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace python {

void data_setpy(core::Data& data, const char* key, unsigned len, PyObject* val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            data.level.l1     = dballe_int_from_python(val);
                            break;
                        case '2':
                            data.level.l2     = dballe_int_from_python(val);
                            break;
                        default: set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            data.trange.p1    = dballe_int_from_python(val);
                            break;
                        case '2':
                            data.trange.p2    = dballe_int_from_python(val);
                            break;
                        default: set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                set_lat_from_python(val, data.station.coords);
                            } else {
                                set_values_from_python(data.values, resolve_varcode(key), val);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                set_lon_from_python(val, data.station.coords);
                            } else {
                                set_values_from_python(data.values, resolve_varcode(key), val);
                            }
                            break;
                        default: set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        data.datetime.day    = datetime_int8_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        data.datetime.minute = datetime_int8_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        data.datetime.second = datetime_int8_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        data.datetime.year   = datetime_int16_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        data.datetime.hour   = datetime_int8_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        data.station.ident = ident_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        data.datetime.month  = datetime_int8_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        data.level = level_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        data.station.report = dballe_nullable_string_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        data.station.id = dballe_int_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        data.trange = trange_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        data.station.report = dballe_nullable_string_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        data.datetime = datetime_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                data.level.ltype1 = dballe_int_from_python(val);
                                break;
                            case '2':
                                data.level.ltype2 = dballe_int_from_python(val);
                                break;
                            default: set_values_from_python(data.values, resolve_varcode(key), val);
                        }
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        data.trange.pind  = dballe_int_from_python(val);
                    } else {
                        set_values_from_python(data.values, resolve_varcode(key), val);
                    }
                    break;
                default: set_values_from_python(data.values, resolve_varcode(key), val);
            }
            break;
        default: set_values_from_python(data.values, resolve_varcode(key), val);
    }
}

void data_unsetpy(core::Data& data, const char* key, unsigned len)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            data.level.l1     = MISSING_INT;
                            break;
                        case '2':
                            data.level.l2     = MISSING_INT;
                            break;
                        default: data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            data.trange.p1    = MISSING_INT;
                            break;
                        case '2':
                            data.trange.p2    = MISSING_INT;
                            break;
                        default: data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                data.station.coords.lat = MISSING_INT;
                            } else {
                                data.values.unset(resolve_varcode(key));
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                data.station.coords.lon = MISSING_INT;
                            } else {
                                data.values.unset(resolve_varcode(key));
                            }
                            break;
                        default: data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        data.datetime.day    = 0xff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        data.datetime.minute = 0xff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        data.datetime.second = 0xff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        data.datetime.year   = 0xffff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        data.datetime.hour   = 0xff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        data.station.ident.clear();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        data.datetime.month  = 0xff;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        data.level = Level();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        data.station.report.clear();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        data.station.id = MISSING_INT;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        data.trange = Trange();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 8:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        data.station.report.clear();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        data.datetime = Datetime();
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                data.level.ltype1 = MISSING_INT;
                                break;
                            case '2':
                                data.level.ltype2 = MISSING_INT;
                                break;
                            default: data.values.unset(resolve_varcode(key));
                        }
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        data.trange.pind  = MISSING_INT;
                    } else {
                        data.values.unset(resolve_varcode(key));
                    }
                    break;
                default: data.values.unset(resolve_varcode(key));
            }
            break;
        default: data.values.unset(resolve_varcode(key));
    }
}

}
}
