#!/usr/bin/runghc

\begin{code}
import Distribution.Simple(defaultMainWithHooks ,simpleUserHooks ,preConf)
import Distribution.Simple.Setup(ConfigFlags)
import Distribution.PackageDescription.Parse(writeHookedBuildInfo)
import Distribution.PackageDescription
    (HookedBuildInfo ,BuildInfo(extraLibs ,ccOptions) ,emptyBuildInfo)
import System.Info(os)

main = defaultMainWithHooks simpleUserHooks{ preConf=configure }
  where
    configure:: [String]-> ConfigFlags-> IO HookedBuildInfo
    configure args flags = do
      let binfo | os == "mingw32" = 
                    emptyBuildInfo{ extraLibs=["odbc32"]
                                  , ccOptions=["-Dmingw32_HOST_OS"] }
                | otherwise       = emptyBuildInfo{ extraLibs=["odbc"] }
          hbi = (Just binfo ,[])
      writeHookedBuildInfo "ODBC.buildinfo" hbi
      return hbi
\end{code}
