// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// RUN: %clang_cc1 -std=c++03 -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/Inputs/include -verify -fopenmp -x c++ -triple nvptx64-nvidia-cuda -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm -fopenmp-is-target-device -o - %s | FileCheck -check-prefixes=NVPTX,NVPTX-CXX03 %s
// RUN: %clang_cc1 -std=c++11 -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/Inputs/include -verify -fopenmp -x c++ -triple nvptx64-nvidia-cuda -fopenmp-targets=nvptx64-nvidia-cuda -emit-llvm -fopenmp-is-target-device -o - %s | FileCheck -check-prefixes=NVPTX,NVPTX-NVPTX-CXX11 %s

// RUN: %clang_cc1 -std=c++03 -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/Inputs/include -verify -fopenmp -x c++ -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm -fopenmp-is-target-device -o - %s | FileCheck -check-prefixes=AMDGPU,AMDGPU-CXX03 %s
// RUN: %clang_cc1 -std=c++11 -internal-isystem %S/../../lib/Headers/openmp_wrappers -include __clang_openmp_device_functions.h -internal-isystem %S/Inputs/include -verify -fopenmp -x c++ -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm -fopenmp-is-target-device -o - %s | FileCheck -check-prefixes=AMDGPU,AMDGPU-CXX11 %s


// expected-no-diagnostics

#include <new>

#pragma omp begin declare target
extern const std::nothrow_t nothrow;

// NVPTX-LABEL: define hidden noundef ptr @_Z17new_stuff_nothrowv
// NVPTX-SAME: () #[[ATTR0:[0-9]+]] {
// NVPTX-NEXT:  entry:
// NVPTX-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnwmRKSt9nothrow_t(i64 noundef 4, ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR4:[0-9]+]]
// NVPTX-NEXT:    ret ptr [[CALL]]
//
// AMDGPU-LABEL: define hidden noundef ptr @_Z17new_stuff_nothrowv
// AMDGPU-SAME: () #[[ATTR0:[0-9]+]] {
// AMDGPU-NEXT:  entry:
// AMDGPU-NEXT:    [[RETVAL:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// AMDGPU-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnwmRKSt9nothrow_t(i64 noundef 4, ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR4:[0-9]+]]
// AMDGPU-NEXT:    ret ptr [[CALL]]
//
int* new_stuff_nothrow() {
  return new (nothrow) int;
}

//
// NVPTX-CXX11-LABEL: define hidden noundef ptr @_Z23new_array_stuff_nothrowv
// NVPTX-CXX11-SAME: () #[[ATTR0]] {
// NVPTX-CXX11-NEXT:  entry:
// NVPTX-CXX11-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnamRKSt9nothrow_t(i64 noundef 136, ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR7:[0-9]+]]
// NVPTX-CXX11-NEXT:    ret ptr [[CALL]]
// NVPTX-CXX03-LABEL: define hidden noundef ptr @_Z23new_array_stuff_nothrowv
// NVPTX-CXX03-SAME: () #[[ATTR0]] {
// NVPTX-CXX03-NEXT:  entry:
// NVPTX-CXX03-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnamRKSt9nothrow_t(i64 noundef 136, ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR4]]
// NVPTX-CXX03-NEXT:    ret ptr [[CALL]]
//
// NVPTX-NVPTX-CXX11-LABEL: define hidden noundef ptr @_Z23new_array_stuff_nothrowv
// NVPTX-NVPTX-CXX11-SAME: () #[[ATTR0]] {
// NVPTX-NVPTX-CXX11-NEXT:  entry:
// NVPTX-NVPTX-CXX11-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnamRKSt9nothrow_t(i64 noundef 136, ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR7:[0-9]+]]
// NVPTX-NVPTX-CXX11-NEXT:    ret ptr [[CALL]]
//
// AMDGPU-CXX03-LABEL: define hidden noundef ptr @_Z23new_array_stuff_nothrowv
// AMDGPU-CXX03-SAME: () #[[ATTR0]] {
// AMDGPU-CXX03-NEXT:  entry:
// AMDGPU-CXX03-NEXT:    [[RETVAL:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX03-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// AMDGPU-CXX03-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnamRKSt9nothrow_t(i64 noundef 136, ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR4]]
// AMDGPU-CXX03-NEXT:    ret ptr [[CALL]]
//
// AMDGPU-CXX11-LABEL: define hidden noundef ptr @_Z23new_array_stuff_nothrowv
// AMDGPU-CXX11-SAME: () #[[ATTR0]] {
// AMDGPU-CXX11-NEXT:  entry:
// AMDGPU-CXX11-NEXT:    [[RETVAL:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX11-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// AMDGPU-CXX11-NEXT:    [[CALL:%.*]] = call noalias noundef ptr @_ZnamRKSt9nothrow_t(i64 noundef 136, ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR7:[0-9]+]]
// AMDGPU-CXX11-NEXT:    ret ptr [[CALL]]
//
int* new_array_stuff_nothrow() {
  return new (nothrow) int[34];
}

//
// NVPTX-CXX11-LABEL: define hidden void @_Z20delete_stuff_nothrowPi
// NVPTX-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-CXX11-NEXT:  entry:
// NVPTX-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-CXX11-NEXT:    call void @_ZdlPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR8:[0-9]+]]
// NVPTX-CXX11-NEXT:    ret void
// NVPTX-CXX03-LABEL: define hidden void @_Z20delete_stuff_nothrowPi
// NVPTX-CXX03-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-CXX03-NEXT:  entry:
// NVPTX-CXX03-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-CXX03-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-CXX03-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-CXX03-NEXT:    call void @_ZdlPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR6:[0-9]+]]
// NVPTX-CXX03-NEXT:    ret void
//
// NVPTX-NVPTX-CXX11-LABEL: define hidden void @_Z20delete_stuff_nothrowPi
// NVPTX-NVPTX-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-NVPTX-CXX11-NEXT:  entry:
// NVPTX-NVPTX-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-NVPTX-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-NVPTX-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-NVPTX-CXX11-NEXT:    call void @_ZdlPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR8:[0-9]+]]
// NVPTX-NVPTX-CXX11-NEXT:    ret void
//
// AMDGPU-CXX03-LABEL: define hidden void @_Z20delete_stuff_nothrowPi
// AMDGPU-CXX03-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// AMDGPU-CXX03-NEXT:  entry:
// AMDGPU-CXX03-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX03-NEXT:    [[PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[PTR_ADDR]] to ptr
// AMDGPU-CXX03-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX03-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX03-NEXT:    call void @_ZdlPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR6:[0-9]+]]
// AMDGPU-CXX03-NEXT:    ret void
//
// AMDGPU-CXX11-LABEL: define hidden void @_Z20delete_stuff_nothrowPi
// AMDGPU-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// AMDGPU-CXX11-NEXT:  entry:
// AMDGPU-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX11-NEXT:    [[PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[PTR_ADDR]] to ptr
// AMDGPU-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX11-NEXT:    call void @_ZdlPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR8:[0-9]+]]
// AMDGPU-CXX11-NEXT:    ret void
//
void delete_stuff_nothrow(int* ptr) {
  operator delete(ptr, nothrow);
}

//
// NVPTX-CXX11-LABEL: define hidden void @_Z26delete_array_stuff_nothrowPi
// NVPTX-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-CXX11-NEXT:  entry:
// NVPTX-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-CXX11-NEXT:    call void @_ZdaPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR8]]
// NVPTX-CXX11-NEXT:    ret void
// NVPTX-CXX03-LABEL: define hidden void @_Z26delete_array_stuff_nothrowPi
// NVPTX-CXX03-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-CXX03-NEXT:  entry:
// NVPTX-CXX03-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-CXX03-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-CXX03-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-CXX03-NEXT:    call void @_ZdaPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR6]]
// NVPTX-CXX03-NEXT:    ret void
//
// NVPTX-NVPTX-CXX11-LABEL: define hidden void @_Z26delete_array_stuff_nothrowPi
// NVPTX-NVPTX-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// NVPTX-NVPTX-CXX11-NEXT:  entry:
// NVPTX-NVPTX-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-NVPTX-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR]], align 8
// NVPTX-NVPTX-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// NVPTX-NVPTX-CXX11-NEXT:    call void @_ZdaPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) @nothrow) #[[ATTR8]]
// NVPTX-NVPTX-CXX11-NEXT:    ret void
//
// AMDGPU-CXX03-LABEL: define hidden void @_Z26delete_array_stuff_nothrowPi
// AMDGPU-CXX03-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// AMDGPU-CXX03-NEXT:  entry:
// AMDGPU-CXX03-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX03-NEXT:    [[PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[PTR_ADDR]] to ptr
// AMDGPU-CXX03-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX03-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX03-NEXT:    call void @_ZdaPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR6]]
// AMDGPU-CXX03-NEXT:    ret void
//
// AMDGPU-CXX11-LABEL: define hidden void @_Z26delete_array_stuff_nothrowPi
// AMDGPU-CXX11-SAME: (ptr noundef [[PTR:%.*]]) #[[ATTR0]] {
// AMDGPU-CXX11-NEXT:  entry:
// AMDGPU-CXX11-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-CXX11-NEXT:    [[PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[PTR_ADDR]] to ptr
// AMDGPU-CXX11-NEXT:    store ptr [[PTR]], ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR_ASCAST]], align 8
// AMDGPU-CXX11-NEXT:    call void @_ZdaPvRKSt9nothrow_t(ptr noundef [[TMP0]], ptr noundef nonnull align 1 dereferenceable(1) addrspacecast (ptr addrspace(1) @nothrow to ptr)) #[[ATTR8]]
// AMDGPU-CXX11-NEXT:    ret void
//
void delete_array_stuff_nothrow(int* ptr) {
  operator delete[](ptr, nothrow);
}

#pragma omp end declare target
