// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

[assembly:System.Reflection.AssemblyVersionAttribute("4.0.0.0")]
[assembly:System.CLSCompliantAttribute(true)]
[assembly:System.Diagnostics.DebuggableAttribute(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly:System.Reflection.AssemblyCompanyAttribute("Mono development team")]
[assembly:System.Reflection.AssemblyCopyrightAttribute("(c) Various Mono authors")]
[assembly:System.Reflection.AssemblyDefaultAliasAttribute("System.Xml.dll")]
[assembly:System.Reflection.AssemblyDescriptionAttribute("System.Xml.dll")]
[assembly:System.Reflection.AssemblyFileVersionAttribute("4.8.3761.0")]
[assembly:System.Reflection.AssemblyInformationalVersionAttribute("4.8.3761.0")]
[assembly:System.Reflection.AssemblyProductAttribute("Mono Common Language Infrastructure")]
[assembly:System.Reflection.AssemblyTitleAttribute("System.Xml.dll")]
[assembly:System.Resources.NeutralResourcesLanguageAttribute("en-US")]
[assembly:System.Resources.SatelliteContractVersionAttribute("4.0.0.0")]
[assembly:System.Runtime.CompilerServices.CompilationRelaxationsAttribute(8)]
[assembly:System.Runtime.CompilerServices.ReferenceAssemblyAttribute]
[assembly:System.Runtime.CompilerServices.RuntimeCompatibilityAttribute(WrapNonExceptionThrows=true)]
[assembly:System.Runtime.InteropServices.ComVisibleAttribute(false)]
[assembly:System.Runtime.InteropServices.DefaultDllImportSearchPathsAttribute(System.Runtime.InteropServices.DllImportSearchPath.AssemblyDirectory | System.Runtime.InteropServices.DllImportSearchPath.System32)]
[assembly:System.Security.AllowPartiallyTrustedCallersAttribute]
[assembly:System.Security.SecurityRulesAttribute(System.Security.SecurityRuleSet.Level1, SkipVerificationInFullTrust=true)]
[assembly:System.Security.Permissions.SecurityPermissionAttribute(System.Security.Permissions.SecurityAction.RequestMinimum, SkipVerification=true)]
namespace System.Xml
{
    public enum ConformanceLevel
    {
        Auto = 0,
        Document = 2,
        Fragment = 1,
    }
    public enum DtdProcessing
    {
        Ignore = 1,
        Parse = 2,
        Prohibit = 0,
    }
    public enum EntityHandling
    {
        ExpandCharEntities = 2,
        ExpandEntities = 1,
    }
    public enum Formatting
    {
        Indented = 1,
        None = 0,
    }
    [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Never)]
    [System.ObsoleteAttribute("This API supports the .NET Framework infrastructure and is not intended to be used directly from your code.", true)]
    public partial interface IApplicationResourceStreamResolver
    {
        [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Never)]
        [System.ObsoleteAttribute("This API supports the .NET Framework infrastructure and is not intended to be used directly from your code.", true)]
        System.IO.Stream GetApplicationResourceStream(System.Uri relativeUri);
    }
    public partial interface IHasXmlNode
    {
        System.Xml.XmlNode GetNode();
    }
    public partial interface IXmlLineInfo
    {
        int LineNumber { get; }
        int LinePosition { get; }
        bool HasLineInfo();
    }
    public partial interface IXmlNamespaceResolver
    {
        System.Collections.Generic.IDictionary<string, string> GetNamespacesInScope(System.Xml.XmlNamespaceScope scope);
        string LookupNamespace(string prefix);
        string LookupPrefix(string namespaceName);
    }
    [System.FlagsAttribute]
    public enum NamespaceHandling
    {
        Default = 0,
        OmitDuplicates = 1,
    }
    public partial class NameTable : System.Xml.XmlNameTable
    {
        public NameTable() { }
        public override string Add(char[] key, int start, int len) { throw null; }
        public override string Add(string key) { throw null; }
        public override string Get(char[] key, int start, int len) { throw null; }
        public override string Get(string value) { throw null; }
    }
    public enum NewLineHandling
    {
        Entitize = 1,
        None = 2,
        Replace = 0,
    }
    public enum ReadState
    {
        Closed = 4,
        EndOfFile = 3,
        Error = 2,
        Initial = 0,
        Interactive = 1,
    }
    public enum ValidationType
    {
        [System.ObsoleteAttribute("Validation type should be specified as DTD or Schema.")]
        Auto = 1,
        DTD = 2,
        None = 0,
        Schema = 4,
        [System.ObsoleteAttribute("XDR Validation through XmlValidatingReader is obsoleted")]
        XDR = 3,
    }
    public enum WhitespaceHandling
    {
        All = 0,
        None = 2,
        Significant = 1,
    }
    public enum WriteState
    {
        Attribute = 3,
        Closed = 5,
        Content = 4,
        Element = 2,
        Error = 6,
        Prolog = 1,
        Start = 0,
    }
    public partial class XmlAttribute : System.Xml.XmlNode
    {
        protected internal XmlAttribute(string prefix, string localName, string namespaceURI, System.Xml.XmlDocument doc) { }
        public override string BaseURI { get { throw null; } }
        public override string InnerText { set { } }
        public override string InnerXml { set { } }
        public override string LocalName { get { throw null; } }
        public override string Name { get { throw null; } }
        public override string NamespaceURI { get { throw null; } }
        public override System.Xml.XmlNodeType NodeType { get { throw null; } }
        public override System.Xml.XmlDocument OwnerDocument { get { throw null; } }
        public virtual System.Xml.XmlElement OwnerElement { get { throw null; } }
        public override System.Xml.XmlNode ParentNode { get { throw null; } }
        public override string Prefix { get { throw null; } set { } }
        public override System.Xml.Schema.IXmlSchemaInfo SchemaInfo { get { throw null; } }
        public virtual bool Specified { get { throw null; } }
        public override string Value { get { throw null; } set { } }
        public override System.Xml.XmlNode AppendChild(System.Xml.XmlNode newChild) { throw null; }
        public override System.Xml.XmlNode CloneNode(bool deep) { throw null; }
        public override System.Xml.XmlNode InsertAfter(System.Xml.XmlNode newChild, System.Xml.XmlNode refChild) { throw null; }
        public override System.Xml.XmlNode InsertBefore(System.Xml.XmlNode newChild, System.Xml.XmlNode refChild) { throw null; }
        public override System.Xml.XmlNode PrependChild(System.Xml.XmlNode newChild) { throw null; }
        public override System.Xml.XmlNode RemoveChild(System.Xml.XmlNode oldChild) { throw null; }
        public override System.Xml.XmlNode ReplaceChild(System.Xml.XmlNode newChild, System.Xml.XmlNode oldChild) { throw null; }
        public override void WriteContentTo(System.Xml.XmlWriter w) { }
        public override void WriteTo(System.Xml.XmlWriter w) { }
    }
    public sealed partial class XmlAttributeCollection : System.Xml.XmlNamedNodeMap, System.Collections.ICollection, System.Collections.IEnumerable
    {
        internal XmlAttributeCollection() { }
        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
        public System.Xml.XmlAttribute this[int i] { get { throw null; } }
        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
        public System.Xml.XmlAttribute this[string name] { get { throw null; } }
        [System.Runtime.CompilerServices.IndexerName("ItemOf")]
        public System.Xml.XmlAttribute this[string localName, string namespaceURI] { get { throw null; } }
        int System.Collections.ICollection.Count { get { throw null; } }
        bool System.Collections.ICollection.IsSynchronized { get { throw null; } }
        object System.Collections.ICollection.SyncRoot { get { throw null; } }
        public System.Xml.XmlAttribute Append(System.Xml.XmlAttribute node) { throw null; }
        public void CopyTo(System.Xml.XmlAttribute[] array, int index) { }
        public System.Xml.XmlAttribute InsertAfter(System.Xml.XmlAttribute newNode, System.Xml.XmlAttribute refNode) { throw null; }
        public System.Xml.XmlAttribute InsertBefore(System.Xml.XmlAttribute newNode, System.Xml.XmlAttribute refNode) { throw null; }
        public System.Xml.XmlAttribute Prepend(System.Xml.XmlAttribute node) { throw null; }
        public System.Xml.XmlAttribute Remove(System.Xml.XmlAttribute node) { throw null; }
        public void RemoveAll() { }
        public System.Xml.XmlAttribute RemoveAt(int i) { throw null; }
        public override System.Xml.XmlNode SetNamedItem(System.Xml.XmlNode node) { throw null; }
        void System.Collections.ICollection.CopyTo(System.Array array, int index) { }
    }
    public partial class XmlCDataSection : System.Xml.XmlCharacterData
    {
        protected internal XmlCDataSection(string data, System.Xml.XmlDocument doc) : base (default(string), default(System.Xml.XmlDocument)) { }
        public override string LocalName { get { throw null; } }
        public override string Name { get { throw null; } }
        public override System.Xml.XmlNodeType NodeType { get { throw null; } }
        public override System.Xml.XmlNode ParentNode { get { throw null; } }
        public override System.Xml.XmlNode PreviousText { get { throw null; } }
        public override System.Xml.XmlNode CloneNode(bool deep) { throw null; }
        public override void WriteContentTo(System.Xml.XmlWriter w) { }
        public override void WriteTo(System.Xml.XmlWriter w) { }
    }
    public abstract partial class XmlCharacterData : System.Xml.XmlLinkedNode
    {
        protected internal XmlCharacterData(string data, System.Xml.XmlDocument doc) { }
        public virtual string Data { get { throw null; } set { } }
        public override string InnerText { get { throw null; } set { } }
        public virtual int Length { get { throw null; } }
        public override string Value { get { throw null; } set { } }
        public virtual void AppendData(string strData) { }
        public virtual void DeleteData(int offset, int count) { }
        public virtual void InsertData(int offset, string strData) { }
        public virtual void ReplaceData(int offset, int count, string strData) { }
        public virtual string Substring(int offset, int count) { throw null; }
    }
    public partial class XmlComment : System.Xml.XmlCharacterData
    {
        protected internal XmlComment(string comment, System.Xml.XmlDocument doc) : base (default(string), default(System.Xml.XmlDocument)) { }
        public override string LocalName { get { throw null; } }
        public override string Name { get { throw null; } }
        public override System.Xml.XmlNodeType NodeType { get { throw null; } }
        public override System.Xml.XmlNode CloneNode(bool deep) { throw null; }
        public override void WriteContentTo(System.Xml.XmlWriter w) { }
        public override void WriteTo(System.Xml.XmlWriter w) { }
    }
    public partial class XmlConvert
    {
        public XmlConvert() { }
        public static string DecodeName(string name) { throw null; }
        public static string EncodeLocalName(string name) { throw null; }
        public static string EncodeName(string name) { throw null; }
        public static string EncodeNmToken(string name) { throw null; }
        public static bool IsNCNameChar(char ch) { throw null; }
        public static bool IsPublicIdChar(char ch) { throw null; }
        public static bool IsStartNCNameChar(char ch) { throw null; }
        public static bool IsWhitespaceChar(char ch) { throw null; }
        public static bool IsXmlChar(char ch) { throw null; }
        public static bool IsXmlSurrogatePair(char lowChar, char highChar) { throw null; }
        public static bool ToBoolean(string s) { throw null; }
        public static byte ToByte(string s) { throw null; }
        public static char ToChar(string s) { throw null; }
        [System.ObsoleteAttribute("Use XmlConvert.ToDateTime() that takes in XmlDateTimeSerializationMode")]
        public static System.DateTime ToDateTime(string s) { throw null; }
        public static System.DateTime ToDateTime(string s, string format) { throw null; }
        public static System.DateTime ToDateTime(string s, string[] formats) { throw null; }
        public static System.DateTime ToDateTime(string s, System.Xml.XmlDateTimeSerializationMode dateTimeOption) { throw null; }
        public static System.DateTimeOffset ToDateTimeOffset(string s) { throw null; }
        public static System.DateTimeOffset ToDateTimeOffset(string s, string format) { throw null; }
        public static System.DateTimeOffset ToDateTimeOffset(string s, string[] formats) { throw null; }
        public static decimal ToDecimal(string s) { throw null; }
        public static double ToDouble(string s) { throw null; }
        public static System.Guid ToGuid(string s) { throw null; }
        public static short ToInt16(string s) { throw null; }
        public static int ToInt32(string s) { throw null; }
        public static long ToInt64(string s) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static sbyte ToSByte(string s) { throw null; }
        public static float ToSingle(string s) { throw null; }
        public static string ToString(bool value) { throw null; }
        public static string ToString(byte value) { throw null; }
        public static string ToString(char value) { throw null; }
        [System.ObsoleteAttribute("Use XmlConvert.ToString() that takes in XmlDateTimeSerializationMode")]
        public static string ToString(System.DateTime value) { throw null; }
        public static string ToString(System.DateTime value, string format) { throw null; }
        public static string ToString(System.DateTime value, System.Xml.XmlDateTimeSerializationMode dateTimeOption) { throw null; }
        public static string ToString(System.DateTimeOffset value) { throw null; }
        public static string ToString(System.DateTimeOffset value, string format) { throw null; }
        public static string ToString(decimal value) { throw null; }
        public static string ToString(double value) { throw null; }
        public static string ToString(System.Guid value) { throw null; }
        public static string ToString(short value) { throw null; }
        public static string ToString(int value) { throw null; }
        public static string ToString(long value) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static string ToString(sbyte value) { throw null; }
        public static string ToString(float value) { throw null; }
        public static string ToString(System.TimeSpan value) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static string ToString(ushort value) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static string ToString(uint value) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static string ToString(ulong value) { throw null; }
        public static System.TimeSpan ToTimeSpan(string s) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static ushort ToUInt16(string s) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static uint ToUInt32(string s) { throw null; }
        [System.CLSCompliantAttribute(false)]
        public static ulong ToUInt64(string s) { throw null; }
        public static string VerifyName(string name) { throw null; }
        public static string VerifyNCName(string name) { throw null; }
        public static string VerifyNMTOKEN(string name) { throw null; }
        public static string VerifyPublicId(string publicId) { throw null; }
        public static string VerifyTOKEN(string token) { throw null; }
        public static string VerifyWhitespace(string content) { throw null; }
        public static string VerifyXmlChars(string content) { throw null; }
    }
    public enum XmlDateTimeSerializationMode
    {
        Local = 0,
        RoundtripKind = 3,
        Unspecified = 2,
        Utc = 1,
 