import assert from "assert";
import "../../main.js";
import { parse } from "../../lib/parse.js";

describe("operator", function() {
    it("Should handle mixing of ++/+/--/- correctly", async function() {
        this.timeout(10000);

        function evaluate(exp) {
            return new Function("var a=1,b=2,c=" + exp + ";return{a:a,b:b,c:c}")();
        }

        [ "", "+", "-" ].forEach(function(p) {
            [ "++a", "--a", "a", "a--", "a++" ].forEach(function(a) {
                [ "+", "-" ].forEach(function(o) {
                    [ "", "+", "-" ].forEach(function(q) {
                        [ "++b", "--b", "b", "b--", "b++" ].forEach(function(b) {
                            var exp = [p, a, o, q, b].join(" ");
                            var orig = evaluate(exp);
                            var terser = evaluate(parse(exp).print_to_string());
                            assert.strictEqual(orig.a, terser.a);
                            assert.strictEqual(orig.b, terser.b);
                            assert.strictEqual(orig.c, terser.c);
                            var beautify = evaluate(parse(exp).print_to_string({
                                beautify: true
                            }));
                            assert.strictEqual(orig.a, beautify.a);
                            assert.strictEqual(orig.b, beautify.b);
                            assert.strictEqual(orig.c, beautify.c);
                        });
                    });
                });
            });
        });
    });
    it("Should remove extraneous spaces", async function() {
        [
            [ "++a + ++b", "++a+ ++b" ],
            [ "++a + --b", "++a+--b" ],
            [ "++a + b", "++a+b" ],
            [ "++a + b--", "++a+b--" ],
            [ "++a + b++", "++a+b++" ],
            [ "++a + + ++b", "++a+ + ++b" ],
            [ "++a + + --b", "++a+ +--b" ],
            [ "++a + + b", "++a+ +b" ],
            [ "++a + + b--", "++a+ +b--" ],
            [ "++a + + b++", "++a+ +b++" ],
            [ "++a + - ++b", "++a+-++b" ],
            [ "++a + - --b", "++a+- --b" ],
            [ "++a + - b", "++a+-b" ],
            [ "++a + - b--", "++a+-b--" ],
            [ "++a + - b++", "++a+-b++" ],
            [ "++a - ++b", "++a-++b" ],
            [ "++a - --b", "++a- --b" ],
            [ "++a - b", "++a-b" ],
            [ "++a - b--", "++a-b--" ],
            [ "++a - b++", "++a-b++" ],
            [ "++a - + ++b", "++a-+ ++b" ],
            [ "++a - + --b", "++a-+--b" ],
            [ "++a - + b", "++a-+b" ],
            [ "++a - + b--", "++a-+b--" ],
            [ "++a - + b++", "++a-+b++" ],
            [ "++a - - ++b", "++a- -++b" ],
            [ "++a - - --b", "++a- - --b" ],
            [ "++a - - b", "++a- -b" ],
            [ "++a - - b--", "++a- -b--" ],
            [ "++a - - b++", "++a- -b++" ],
            [ "--a + ++b", "--a+ ++b" ],
            [ "--a + --b", "--a+--b" ],
            [ "--a + b", "--a+b" ],
            [ "--a + b--", "--a+b--" ],
            [ "--a + b++", "--a+b++" ],
            [ "--a + + ++b", "--a+ + ++b" ],
            [ "--a + + --b", "--a+ +--b" ],
            [ "--a + + b", "--a+ +b" ],
            [ "--a + + b--", "--a+ +b--" ],
            [ "--a + + b++", "--a+ +b++" ],
            [ "--a + - ++b", "--a+-++b" ],
            [ "--a + - --b", "--a+- --b" ],
            [ "--a + - b", "--a+-b" ],
            [ "--a + - b--", "--a+-b--" ],
            [ "--a + - b++", "--a+-b++" ],
            [ "--a - ++b", "--a-++b" ],
            [ "--a - --b", "--a- --b" ],
            [ "--a - b", "--a-b" ],
            [ "--a - b--", "--a-b--" ],
            [ "--a - b++", "--a-b++" ],
            [ "--a - + ++b", "--a-+ ++b" ],
            [ "--a - + --b", "--a-+--b" ],
            [ "--a - + b", "--a-+b" ],
            [ "--a - + b--", "--a-+b--" ],
            [ "--a - + b++", "--a-+b++" ],
            [ "--a - - ++b", "--a- -++b" ],
            [ "--a - - --b", "--a- - --b" ],
            [ "--a - - b", "--a- -b" ],
            [ "--a - - b--", "--a- -b--" ],
            [ "--a - - b++", "--a- -b++" ],
            [ "a + ++b", "a+ ++b" ],
            [ "a + --b", "a+--b" ],
            [ "a + b", "a+b" ],
            [ "a + b--", "a+b--" ],
            [ "a + b++", "a+b++" ],
            [ "a + + ++b", "a+ + ++b" ],
            [ "a + + --b", "a+ +--b" ],
            [ "a + + b", "a+ +b" ],
            [ "a + + b--", "a+ +b--" ],
            [ "a + + b++", "a+ +b++" ],
            [ "a + - ++b", "a+-++b" ],
            [ "a + - --b", "a+- --b" ],
            [ "a + - b", "a+-b" ],
            [ "a + - b--", "a+-b--" ],
            [ "a + - b++", "a+-b++" ],
            [ "a - ++b", "a-++b" ],
            [ "a - --b", "a- --b" ],
            [ "a - b", "a-b" ],
            [ "a - b--", "a-b--" ],
            [ "a - b++", "a-b++" ],
            [ "a - + ++b", "a-+ ++b" ],
            [ "a - + --b", "a-+--b" ],
            [ "a - + b", "a-+b" ],
            [ "a - + b--", "a-+b--" ],
            [ "a - + b++", "a-+b++" ],
            [ "a - - ++b", "a- -++b" ],
            [ "a - - --b", "a- - --b" ],
            [ "a - - b", "a- -b" ],
            [ "a - - b--", "a- -b--" ],
            [ "a - - b++", "a- -b++" ],
            [ "a-- + ++b", "a--+ ++b" ],
            [ "a-- + --b", "a--+--b" ],
            [ "a-- + b", "a--+b" ],
            [ "a-- + b--", "a--+b--" ],
            [ "a-- + b++", "a--+b++" ],
            [ "a-- + + ++b", "a--+ + ++b" ],
            [ "a-- + + --b", "a--+ +--b" ],
            [ "a-- + + b", "a--+ +b" ],
            [ "a-- + + b--", "a--+ +b--" ],
            [ "a-- + + b++", "a--+ +b++" ],
            [ "a-- + - ++b", "a--+-++b" ],
            [ "a-- + - --b", "a--+- --b" ],
            [ "a-- + - b", "a--+-b" ],
            [ "a-- + - b--", "a--+-b--" ],
            [ "a-- + - b++", "a--+-b++" ],
            [ "a-- - ++b", "a---++b" ],
            [ "a-- - --b", "a--- --b" ],
            [ "a-- - b", "a---b" ],
            [ "a-- - b--", "a---b--" ],
            [ "a-- - b++", "a---b++" ],
            [ "a-- - + ++b", "a---+ ++b" ],
            [ "a-- - + --b", "a---+--b" ],
            [ "a-- - + b", "a---+b" ],
            [ "a-- - + b--", "a---+b--" ],
            [ "a-- - + b++", "a---+b++" ],
            [ "a-- - - ++b", "a--- -++b" ],
            [ "a-- - - --b", "a--- - --b" ],
            [ "a-- - - b", "a--- -b" ],
            [ "a-- - - b--", "a--- -b--" ],
            [ "a-- - - b++", "a--- -b++" ],
            [ "a++ + ++b", "a+++ ++b" ],
            [ "a++ + --b", "a+++--b" ],
            [ "a++ + b", "a+++b" ],
            [ "a++ + b--", "a+++b--" ],
            [ "a++ + b++", "a+++b++" ],
            [ "a++ + + ++b", "a+++ + ++b" ],
            [ "a++ + + --b", "a+++ +--b" ],
            [ "a++ + + b", "a+++ +b" ],
            [ "a++ + + b--", "a+++ +b--" ],
            [ "a++ + + b++", "a+++ +b++" ],
            [ "a++ + - ++b", "a+++-++b" ],
            [ "a++ + - --b", "a+++- --b" ],
            [ "a++ + - b", "a+++-b" ],
            [ "a++ + - b--", "a+++-b--" ],
            [ "a++ + - b++", "a+++-b++" ],
            [ "a++ - ++b", "a++-++b" ],
            [ "a++ - --b", "a++- --b" ],
            [ "a++ - b", "a++-b" ],
            [ "a++ - b--", "a++-b--" ],
            [ "a++ - b++", "a++-b++" ],
            [ "a++ - + ++b", "a++-+ ++b" ],
            [ "a++ - + --b", "a++-+--b" ],
            [ "a++ - + b", "a++-+b" ],
            [ "a++ - + b--", "a++-+b--" ],
            [ "a++ - + b++", "a++-+b++" ],
            [ "a++ - - ++b", "a++- -++b" ],
            [ "a++ - - --b", "a++- - --b" ],
            [ "a++ - - b", "a++- -b" ],
            [ "a++ - - b--", "a++- -b--" ],
            [ "a++ - - b++", "a++- -b++" ],
            [ "+ ++a + ++b", "+ ++a+ ++b" ],
            [ "+ ++a + --b", "+ ++a+--b" ],
            [ "+ ++a + b", "+ ++a+b" ],
            [ "+ ++a + b--", "+ ++a+b--" ],
            [ "+ ++a + b++", "+ ++a+b++" ],
            [ "+ ++a + + ++b", "+ ++a+ + ++b" ],
            [ "+ ++a + + --b", "+ ++a+ +--b" ],
            [ "+ ++a + + b", "+ ++a+ +b" ],
            [ "+ ++a + + b--", "+ ++a+ +b--" ],
            [ "+ ++a + + b++", "+ ++a+ +b++" ],
            [ "+ ++a + - ++b", "+ ++a+-++b" ],
            [ "+ ++a + - --b", "+ ++a+- --b" ],
            [ "+ ++a + - b", "+ ++a+-b" ],
            [ "+ ++a + - b--", "+ ++a+-b--" ],
            [ "+ ++a + - b++", "+ ++a+-b++" ],
            [ "+ ++a - ++b", "+ ++a-++b" ],
            [ "+ ++a - --b", "+ ++a- --b" ],
            [ "+ ++a - b", "+ ++a-b" ],
            [ "+ ++a - b--", "+ ++a-b--" ],
            [ "+ ++a - b++", "+ ++a-b++" ],
            [ "+ ++a - + ++b", "+ ++a-+ ++b" ],
            [ "+ ++a - + --b", "+ ++a-+--b" ],
            [ "+ ++a - + b", "+ ++a-+b" ],
            [ "+ ++a - + b--", "+ ++a-+b--" ],
            [ "+ ++a - + b++", "+ ++a-+b++" ],
            [ "+ ++a - - ++b", "+ ++a- -++b" ],
            [ "+ ++a - - --b", "+ ++a- - --b" ],
            [ "+ ++a - - b", "+ ++a- -b" ],
            [ "+ ++a - - b--", "+ ++a- -b--" ],
            [ "+ ++a - - b++", "+ ++a- -b++" ],
            [ "+ --a + ++b", "+--a+ ++b" ],
            [ "+ --a + --b", "+--a+--b" ],
            [ "+ --a + b", "+--a+b" ],
            [ "+ --a + b--", "+--a+b--" ],
            [ "+ --a + b++", "+--a+b++" ],
            [ "+ --a + + ++b", "+--a+ + ++b" ],
            [ "+ --a + + --b", "+--a+ +--b" ],
            [ "+ --a + + b", "+--a+ +b" ],
            [ "+ --a + + b--", "+--a+ +b--" ],
            [ "+ --a + + b++", "+--a+ +b++" ],
            [ "+ --a + - ++b", "+--a+-++b" ],
            [ "+ --a + - --b", "+--a+- --b" ],
            [ "+ --a + - b", "+--a+-b" ],
            [ "+ --a + - b--", "+--a+-b--" ],
            [ "+ --a + - b++", "+--a+-b++" ],
            [ "+ --a - ++b", "+--a-++b" ],
            [ "+ --a - --b", "+--a- --b" ],
            [ "+ --a - b", "+--a-b" ],
            [ "+ --a - b--", "+--a-b--" ],
            [ "+ --a - b++", "+--a-b++" ],
            [ "+ --a - + ++b", "+--a-+ ++b" ],
            [ "+ --a - + --b", "+--a-+--b" ],
            [ "+ --a - + b", "+--a-+b" ],
            [ "+ --a - + b--", "+--a-+b--" ],
            [ "+ --a - + b++", "+--a-+b++" ],
            [ "+ --a - - ++b", "+--a- -++b" ],
            [ "+ --a - - --b", "+--a- - --b" ],
            [ "+ --a - - b", "+--a- -b" ],
            [ "+ --a - - b--", "+--a- -b--" ],
            [ "+ --a - - b++", "+--a- -b++" ],
            [ "+ a + ++b", "+a+ ++b" ],
            [ "+ a + --b", "+a+--b" ],
            [ "+ a + b", "+a+b" ],
            [ "+ a + b--", "+a+b--" ],
            [ "+ a + b++", "+a+b++" ],
            [ "+ a + + ++b", "+a+ + ++b" ],
            [ "+ a + + --b", "+a+ +--b" ],
            [ "+ a + + b", "+a+ +b" ],
            [ "+ a + + b--", "+a+ +b--" ],
            [ "+ a + + b++", "+a+ +b++" ],
            [ "+ a + - ++b", "+a+-++b" ],
            [ "+ a + - --b", "+a+- --b" ],
            [ "+ a + - b", "+a+-b" ],
            [ "+ a + - b--", "+a+-b--" ],
            [ "+ a + - b++", "+a+-b++" ],
            [ "+ a - ++b", "+a-++b" ],
            [ "+ a - --b", "+a- --b" ],
            [ "+ a - b", "+a-b" ],
            [ "+ a - b--", "+a-b--" ],
            [ "+ a - b++", "+a-b++" ],
            [ "+ a - + ++b", "+a-+ ++b" ],
            [ "+ a - + --b", "+a-+--b" ],
            [ "+ a - + b", "+a-+b" ],
            [ "+ a - + b--", "+a-+b--" ],
            [ "+ a - + b++", "+a-+b++" ],
            [ "+ a - - ++b", "+a- -++b" ],
            [ "+ a - - --b", "+a- - --b" ],
            [ "+ a - - b", "+a- -b" ],
            [ "+ a - - b--", "+a- -b--" ],
            [ "+ a - - b++", "+a- -b++" ],
            [ "+ a-- + ++b", "+a--+ ++b" ],
            [ "+ a-- + --b", "+a--+--b" ],
            [ "+ a-- + b", "+a--+b" ],
            [ "+ a-- + b--", "+a--+b--" ],
            [ "+ a-- + b++", "+a--+b++" ],
            [ "+ a-- + + ++b", "+a--+ + ++b" ],
            [ "+ a-- + + --b", "+a--+ +--b" ],
            [ "+ a-- + + b", "+a--+ +b" ],
            [ "+ a-- + + b--", "+a--+ +b--" ],
            [ "+ a-- + + b++", "+a--+ +b++" ],
            [ "+ a-- + - ++b", "+a--+-++b" ],
            [ "+ a-- + - --b", "+a--+- --b" ],
            [ "+ a-- + - b", "+a--+-b" ],
            [ "+ a-- + - b--", "+a--+-b--" ],
            [ "+ a-- + - b++", "+a--+-b++" ],
            [ "+ a-- - ++b", "+a---++b" ],
            [ "+ a-- - --b", "+a--- --b" ],
            [ "+ a-- - b", "+a---b" ],
            [ "+ a-- - b--", "+a---b--" ],
            [ "+ a-- - b++", "+a---b++" ],
            [ "+ a-- - + ++b", "+a---+ ++b" ],
            [ "+ a-- - + --b", "+a---+--b" ],
            [ "+ a-- - + b", "+a---+b" ],
            [ "+ a-- - + b--", "+a---+b--" ],
            [ "+ a-- - + b++", "+a---+b++" ],
            [ "+ a-- - - ++b", "+a--- -++b" ],
            [ "+ a-- - - --b", "+a--- - --b" ],
            [ "+ a-- - - b", "+a--- -b" ],
            [ "+ a-- - - b--", "+a--- -b--" ],
            [ "+ a-- - - b++", "+a--- -b++" ],
            [ "+ a++ + ++b", "+a+++ ++b" ],
            [ "+ a++ + --b", "+a+++--b" ],
            [ "+ a++ + b", "+a+++b" ],
            [ "+ a++ + b--", "+a+++b--" ],
            [ "+ a++ + b++", "+a+++b++" ],
            [ "+ a++ + + ++b", "+a+++ + ++b" ],
            [ "+ a++ + + --b", "+a+++ +--b" ],
            [ "+ a++ + + b", "+a+++ +b" ],
            [ "+ a++ + + b--", "+a+++ +b--" ],
            [ "+ a++ + + b++", "+a+++ +b++" ],
            [ "+ a++ + - ++b", "+a+++-++b" ],
            [ "+ a++ + - --b", "+a+++- --b" ],
            [ "+ a++ + - b", "+a+++-b" ],
            [ "+ a++ + - b--", "+a+++-b--" ],
            [ "+ a++ + - b++", "+a+++-b++" ],
            [ "+ a++ - ++b", "+a++-++b" ],
            [ "+ a++ - --b", "+a++- --b" ],
            [ "+ a++ - b", "+a++-b" ],
            [ "+ a++ - b--", "+a++-b--" ],
            [ "+ a++ - b++", "+a++-b++" ],
            [ "+ a++ - + ++b", "+a++-+ ++b" ],
            [ "+ a++ - + --b", "+a++-+--b" ],
            [ "+ a++ - + b", "+a++-+b" ],
            [ "+ a++ - + b--", "+a++-+b--" ],
            [ "+ a++ - + b++", "+a++-+b++" ],
            [ "+ a++ - - ++b", "+a++- -++b" ],
            [ "+ a++ - - --b", "+a++- - --b" ],
            [ "+ a++ - - b", "+a++- -b" ],
            [ "+ a++ - - b--", "+a++- -b--" ],
            [ "+ a++ - - b++", "+a++- -b++" ],
            [ "- ++a + ++b", "-++a+ ++b" ],
            [ "- ++a + --b", "-++a+--b" ],
            [ "- ++a + b", "-++a+b" ],
            [ "- ++a + b--", "-++a+b--" ],
            [ "- ++a + b++", "-++a+b++" ],
            [ "- ++a + + ++b", "-++a+ + ++b" ],
            [ "- ++a + + --b", "-++a+ +--b" ],
            [ "- ++a + + b", "-++a+ +b" ],
            [ "- ++a + + b--", "-++a+ +b--" ],
            [ "- ++a + + b++", "-++a+ +b++" ],
            [ "- ++a + - ++b", "-++a+-++b" ],
            [ "- ++a + - --b", "-++a+- --b" ],
            [ "- ++a + - b", "-++a+-b" ],
            [ "- ++a + - b--", "-++a+-b--" ],
            [ "- ++a + - b++", "-++a+-b++" ],
            [ "- ++a - ++b", "-++a-++b" ],
            [ "- ++a - --b", "-++a- --b" ],
            [ "- ++a - b", "-++a-b" ],
            [ "- ++a - b--", "-++a-b--" ],
            [ "- ++a - b++", "-++a-b++" ],
            [ "- ++a - + ++b", "-++a-+ ++b" ],
            [ "- ++a - + --b", "-++a-+--b" ],
            [ "- ++a - + b", "-++a-+b" ],
            [ "- ++a - + b--", "-++a-+b--" ],
            [ "- ++a - + b++", "-++a-+b++" ],
            [ "- ++a - - ++b", "-++a- -++b" ],
            [ "- ++a - - --b", "-++a- - --b" ],
            [ "- ++a - - b", "-++a- -b" ],
            [ "- ++a - - b--", "-++a- -b--" ],
            [ "- ++a - - b++", "-++a- -b++" ],
            [ "- --a + ++b", "- --a+ ++b" ],
            [ "- --a + --b", "- --a+--b" ],
            [ "- --a + b", "- --a+b" ],
            [ "- --a + b--", "- --a+b--" ],
            [ "- --a + b++", "- --a+b++" ],
            [ "- --a + + ++b", "- --a+ + ++b" ],
            [ "- --a + + --b", "- --a+ +--b" ],
            [ "- --a + + b", "- --a+ +b" ],
            [ "- --a + + b--", "- --a+ +b--" ],
            [ "- --a + + b++", "- --a+ +b++" ],
            [ "- --a + - ++b", "- --a+-++b" ],
            [ "- --a + - --b", "- --a+- --b" ],
            [ "- --a + - b", "- --a+-b" ],
            [ "- --a + - b--", "- --a+-b--" ],
            [ "- --a + - b++", "- --a+-b++" ],
            [ "- --a - ++b", "- --a-++b" ],
            [ "- --a - --b", "- --a- --b" ],
            [ "- --a - b", "- --a-b" ],
            [ "- --a - b--", "- --a-b--" ],
            [ "- --a - b++", "- --a-b++" ],
            [ "- --a - + ++b", "- --a-+ ++b" ],
            [ "- --a - + --b", "- --a-+--b" ],
            [ "- --a - + b", "- --a-+b" ],
            [ "- --a - + b--", "- --a-+b--" ],
            [ "- --a - + b++", "- --a-+b++" ],
            [ "- --a - - ++b", "- --a- -++b" ],
            [ "- --a - - --b", "- --a- - --b" ],
            [ "- --a - - b", "- --a- -b" ],
            [ "- --a - - b--", "- --a- -b--" ],
            [ "- --a - - b++", "- --a- -b++" ],
            [ "- a + ++b", "-a+ ++b" ],
            [ "- a + --b", "-a+--b" ],
            [ "- a + b", "-a+b" ],
            [ "- a + b--", "-a+b--" ],
            [ "- a + b++", "-a+b++" ],
            [ "- a + + ++b", "-a+ + ++b" ],
            [ "- a + + --b", "-a+ +--b" ],
            [ "- a + + b", "-a+ +b" ],
            [ "- a + + b--", "-a+ +b--" ],
            [ "- a + + b++", "-a+ +b++" ],
            [ "- a + - ++b", "-a+-++b" ],
            [ "- a + - --b", "-a+- --b" ],
            [ "- a + - b", "-a+-b" ],
            [ "- a + - b--", "-a+-b--" ],
            [ "- a + - b++", "-a+-b++" ],
            [ "- a - ++b", "-a-++b" ],
            [ "- a - --b", "-a- --b" ],
            [ "- a - b", "-a-b" ],
            [ "- a - b--", "-a-b--" ],
            [ "- a - b++", "-a-b++" ],
            [ "- a - + ++b", "-a-+ ++b" ],
            [ "- a - + --b", "-a-+--b" ],
            [ "- a - + b", "-a-+b" ],
            [ "- a - + b--", "-a-+b--" ],
            [ "- a - + b++", "-a-+b++" ],
            [ "- a - - ++b", "-a- -++b" ],
            [ "- a - - --b", "-a- - --b" ],
            [ "- a - - b", "-a- -b" ],
            [ "- a - - b--", "-a- -b--" ],
            [ "- a - - b++", "-a- -b++" ],
            [ "- a-- + ++b", "-a--+ ++b" ],
            [ "- a-- + --b", "-a--+--b" ],
            [ "- a-- + b", "-a--+b" ],
            [ "- a-- + b--", "-a--+b--" ],
            [ "- a-- + b++", "-a--+b++" ],
            [ "- a-- + + ++b", "-a--+ + ++b" ],
            [ "- a-- + + --b", "-a--+ +--b" ],
            [ "- a-- + + b", "-a--+ +b" ],
            [ "- a-- + + b--", "-a--+ +b--" ],
            [ "- a-- + + b++", "-a--+ +b++" ],
            [ "- a-- + - ++b", "-a--+-++b" ],
            [ "- a-- + - --b", "-a--+- --b" ],
            [ "- a-- + - b", "-a--+-b" ],
            [ "- a-- + - b--", "-a--+-b--" ],
            [ "- a-- + - b++", "-a--+-b++" ],
            [ "- a-- - ++b", "-a---++b" ],
            [ "- a-- - --b", "-a--- --b" ],
            [ "- a-- - b", "-a---b" ],
            [ "- a-- - b--", "-a---b--" ],
            [ "- a-- - b++", "-a---b++" ],
            [ "- a-- - + ++b", "-a---+ ++b" ],
            [ "- a-- - + --b", "-a---+--b" ],
            [ "- a-- - + b", "-a---+b" ],
            [ "- a-- - + b--", "-a---+b--" ],
            [ "- a-- - + b++", "-a---+b++" ],
            [ "- a-- - - ++b", "-a--- -++b" ],
            [ "- a-- - - --b", "-a--- - --b" ],
            [ "- a-- - - b", "-a--- -b" ],
            [ "- a-- - - b--", "-a--- -b--" ],
            [ "- a-- - - b++", "-a--- -b++" ],
            [ "- a++ + ++b", "-a+++ ++b" ],
            [ "- a++ + --b", "-a+++--b" ],
            [ "- a++ + b", "-a+++b" ],
            [ "- a++ + b--", "-a+++b--" ],
            [ "- a++ + b++", "-a+++b++" ],
            [ "- a++ + + ++b", "-a+++ + ++b" ],
            [ "- a++ + + --b", "-a+++ +--b" ],
            [ "- a++ + + b", "-a+++ +b" ],
            [ "- a++ + + b--", "-a+++ +b--" ],
            [ "- a++ + + b++", "-a+++ +b++" ],
            [ "- a++ + - ++b", "-a+++-++b" ],
            [ "- a++ + - --b", "-a+++- --b" ],
            [ "- a++ + - b", "-a+++-b" ],
            [ "- a++ + - b--", "-a+++-b--" ],
            [ "- a++ + - b++", "-a+++-b++" ],
            [ "- a++ - ++b", "-a++-++b" ],
            [ "- a++ - --b", "-a++- --b" ],
            [ "- a++ - b", "-a++-b" ],
            [ "- a++ - b--", "-a++-b--" ],
            [ "- a++ - b++", "-a++-b++" ],
            [ "- a++ - + ++b", "-a++-+ ++b" ],
            [ "- a++ - + --b", "-a++-+--b" ],
            [ "- a++ - + b", "-a++-+b" ],
            [ "- a++ - + b--", "-a++-+b--" ],
            [ "- a++ - + b++", "-a++-+b++" ],
            [ "- a++ - - ++b", "-a++- -++b" ],
            [ "- a++ - - --b", "-a++- - --b" ],
            [ "- a++ - - b", "-a++- -b" ],
            [ "- a++ - - b--", "-a++- -b--" ],
            [ "- a++ - - b++", "-a++- -b++" ],
        ].forEach(function(exp) {
            assert.strictEqual(parse(exp[0]).print_to_string(), exp[1] + ";");
        });
    });
});
