# octocatalog-diff v1 API documentation: OctocatalogDiff::API::V1::Catalog

## Overview

`OctocatalogDiff::API::V1::Catalog` is an object that represents a compiled catalog.

It wraps the [`OctocatalogDiff::Catalog`](/lib/octocatalog-diff/catalog.rb) object.

This object is the return value from the [`catalog`](/doc/dev/api/v1/calls/catalog.md) API call, and the `to` and `from` catalogs computed by the [`catalog-diff`](/doc/dev/api/v1/calls/catalog-diff.md) API call.

## Methods

#### `#builder` (String)

Returns the name of the class the built the catalog.

```
catalog.builder #=> 'OctocatalogDiff::Catalog::JSON'
```

#### `#compilation_dir` (String)

Returns the temporary directory in which the catalog was compiled.

```
catalog.compilation_dir #=> '/var/folders/dw/5ftmkqk972j_kw2fdjyzdqdw0000gn/T/d20170108-95774-1r4ohjd'
```

This is only applicable for catalogs compiled by `OctocatalogDiff::Catalog::Computed`. This method will return `nil` for catalogs generated by other backends.

#### `#error_message` (String)

Returns the error message for a failed catalog. (If the catalog is valid, this returns `nil`.)

```
good_catalog.valid?         #=> true
good_catalog.error_message  #=> nil

bad_catalog.valid?          #=> false
bad_catalog.error_message   #=> 'Failed to compile catalog for node ...'
```

#### `#puppet_version` (String)

Returns the Puppet version used to compile the catalog.

```
catalog.puppet_version  #=> '3.8.7'
```

This is only applicable for catalogs compiled by `OctocatalogDiff::Catalog::Computed`. This method will return `nil` for catalogs generated by other backends.

#### `#resource(<Hash>)` (Hash)

Returns the hash representation of the object identified by the type and title supplied.

This method requires 1 argument, which is a hash containing `:type` and `:title` keys.

```
catalog.resource(type: 'File', title: '/etc/foo')
#=> {"title"=>"/etc/foo", "type"=>"File",
    "parameters"=>{"content"=>"This is the file", "owner"=>"root"},
    "file"=>"/etc/puppetlabs/code/environments/production/manifests/site.pp", "line"=>25}
```

Returns `nil` if the type+title resource was not present in the catalog.

##### Notes

1. The first call to this method will build a hash table (`O(N)` operation) from the resource array. Thereafter, each call to this method will look up the value in that hash table (`O(1)` operation). To perform lookups of known types and titles, it is faster to use this method than to use `#resources` with array operations when performing multiple lookups.

2. The structure of the returned hash is dependent on the representation of the resource in the Puppet catalog. It is therefore possible that different versions of Puppet could cause different data structures. It is the author's experience that Puppet 3.8.7 and Puppet 4.x produce similar (if not indistinguishable) resource representations.

3. This method will also locate a resource that was named using an alias.

  ```
  # Puppet code
  file { '/etc/foo':
    alias => 'foo file for the win',
    ...
  }

  # octocatalog-diff API
  catalog.resource(type: 'File', title: 'foo file for the win')
  #=> {"title"=>"/etc/foo", "type"=>"File", ...}
  ```

#### `#resources` (Array&lt;Hash&gt;)

Returns an array of catalog resources in a successful catalog. (If the catalog is not valid, this returns `nil`.)

```
bad_catalog.valid?      #=> false
bad_catalog.resources   #=> nil

good_catalog.valid?     #=> true
good_catalog.resources
#=> [
  { "title"=>"/etc/foo", "type"=>"File", ... },
  { "title"=>"/bin/true", "type"=>"Exec", ... }
]
```

The structure of the returned hash is dependent on the representation of the resource in the Puppet catalog. It is therefore possible that different versions of Puppet could cause different data structures. It is the author's experience that Puppet 3.8.7 and Puppet 4.x produce similar (if not indistinguishable) resource representations.

#### `#to_json` (String)

Returns the JSON representation of a successful catalog. (If the catalog is not valid, this returns `nil`.)

```
bad_catalog.valid?     #=> false
bad_catalog.to_json    #=> nil

good_catalog.valid?    #=> true
good_catalog.to_json   #=> '{ "document_type": "Catalog", ... }'
```

#### `#valid?` (Boolean)

Returns `true` if the catalog is valid, and `false` if the catalog is not valid.

## Other methods

These methods are available for debugging or development purposes but are not guaranteed to remain consistent between versions:

- `#to_h` (Hash): Returns hash representation of parsed JSON catalog
- `#raw` (OctocatalogDiff::Catalog): Returns underlying internal catalog object
