# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HybridRunbookWorkerGroup(Model):
    """Definition of hybrid runbook worker group.

    :param id: Gets or sets the id of the resource.
    :type id: str
    :param name: Gets or sets the name of the group.
    :type name: str
    :param hybrid_runbook_workers: Gets or sets the list of hybrid runbook
     workers.
    :type hybrid_runbook_workers:
     list[~azure.mgmt.automation.models.HybridRunbookWorker]
    :param credential: Sets the credential of a worker group.
    :type credential:
     ~azure.mgmt.automation.models.RunAsCredentialAssociationProperty
    :param group_type: Type of the HybridWorkerGroup. Possible values include:
     'User', 'System'
    :type group_type: str or ~azure.mgmt.automation.models.GroupTypeEnum
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'hybrid_runbook_workers': {'key': 'hybridRunbookWorkers', 'type': '[HybridRunbookWorker]'},
        'credential': {'key': 'credential', 'type': 'RunAsCredentialAssociationProperty'},
        'group_type': {'key': 'groupType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HybridRunbookWorkerGroup, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.hybrid_runbook_workers = kwargs.get('hybrid_runbook_workers', None)
        self.credential = kwargs.get('credential', None)
        self.group_type = kwargs.get('group_type', None)
