# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContainerState(Model):
    """The container instance state.

    :param state: The state of the container instance.
    :type state: str
    :param start_time: The date-time when the container instance state
     started.
    :type start_time: datetime
    :param exit_code: The container instance exit codes correspond to those
     from the `docker run` command.
    :type exit_code: int
    :param finish_time: The date-time when the container instance state
     finished.
    :type finish_time: datetime
    :param detail_status: The human-readable status of the container instance
     state.
    :type detail_status: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'detail_status': {'key': 'detailStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerState, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.start_time = kwargs.get('start_time', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.detail_status = kwargs.get('detail_status', None)
