# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse

from .. import models


class BaselinesOperations(object):
    """BaselinesOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: Client Api Version. Constant value: "2019-03-01".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2019-03-01"

        self.config = config

    def list(
            self, resource_uri, metricnames=None, metricnamespace=None, timespan=None, interval=None, aggregation=None, sensitivities=None, filter=None, result_type=None, custom_headers=None, raw=False, **operation_config):
        """**Lists the metric baseline values for a resource**.

        :param resource_uri: The identifier of the resource.
        :type resource_uri: str
        :param metricnames: The names of the metrics (comma separated) to
         retrieve.
        :type metricnames: str
        :param metricnamespace: Metric namespace to query metric definitions
         for.
        :type metricnamespace: str
        :param timespan: The timespan of the query. It is a string with the
         following format 'startDateTime_ISO/endDateTime_ISO'.
        :type timespan: str
        :param interval: The interval (i.e. timegrain) of the query.
        :type interval: timedelta
        :param aggregation: The list of aggregation types (comma separated) to
         retrieve.
        :type aggregation: str
        :param sensitivities: The list of sensitivities (comma separated) to
         retrieve.
        :type sensitivities: str
        :param filter: The **$filter** is used to reduce the set of metric
         data returned.<br>Example:<br>Metric contains metadata A, B and
         C.<br>- Return all time series of C where A = a1 and B = b1 or
         b2<br>**$filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq
         ‘*’**<br>- Invalid variant:<br>**$filter=A eq ‘a1’ and B eq ‘b1’ and C
         eq ‘*’ or B = ‘b2’**<br>This is invalid because the logical or
         operator cannot separate two different metadata names.<br>- Return all
         time series where A = a1, B = b1 and C = c1:<br>**$filter=A eq ‘a1’
         and B eq ‘b1’ and C eq ‘c1’**<br>- Return all time series where A =
         a1<br>**$filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**.
        :type filter: str
        :param result_type: Allows retrieving only metadata of the baseline.
         On data request all information is retrieved. Possible values include:
         'Data', 'Metadata'
        :type result_type: str or
         ~azure.mgmt.monitor.v2019_03_01.models.ResultType
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of SingleMetricBaseline
        :rtype:
         ~azure.mgmt.monitor.v2019_03_01.models.SingleMetricBaselinePaged[~azure.mgmt.monitor.v2019_03_01.models.SingleMetricBaseline]
        :raises:
         :class:`ErrorResponseException<azure.mgmt.monitor.v2019_03_01.models.ErrorResponseException>`
        """
        def prepare_request(next_link=None):
            if not next_link:
                # Construct URL
                url = self.list.metadata['url']
                path_format_arguments = {
                    'resourceUri': self._serialize.url("resource_uri", resource_uri, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                if metricnames is not None:
                    query_parameters['metricnames'] = self._serialize.query("metricnames", metricnames, 'str')
                if metricnamespace is not None:
                    query_parameters['metricnamespace'] = self._serialize.query("metricnamespace", metricnamespace, 'str')
                if timespan is not None:
                    query_parameters['timespan'] = self._serialize.query("timespan", timespan, 'str')
                if interval is not None:
                    query_parameters['interval'] = self._serialize.query("interval", interval, 'duration')
                if aggregation is not None:
                    query_parameters['aggregation'] = self._serialize.query("aggregation", aggregation, 'str')
                if sensitivities is not None:
                    query_parameters['sensitivities'] = self._serialize.query("sensitivities", sensitivities, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if result_type is not None:
                    query_parameters['resultType'] = self._serialize.query("result_type", result_type, 'ResultType')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        def internal_paging(next_link=None):
            request = prepare_request(next_link)

            response = self._client.send(request, stream=False, **operation_config)

            if response.status_code not in [200]:
                raise models.ErrorResponseException(self._deserialize, response)

            return response

        # Deserialize response
        header_dict = None
        if raw:
            header_dict = {}
        deserialized = models.SingleMetricBaselinePaged(internal_paging, self._deserialize.dependencies, header_dict)

        return deserialized
    list.metadata = {'url': '/{resourceUri}/providers/microsoft.insights/metricBaselines'}
