# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AclCreateOrUpdateParameters(Model):
    """The parameters used to create or update an access control list (ACL) entry.

    All required parameters must be populated in order to send to Azure.

    :param ace_type: Required. the access control list (ACL) entry type.
     UserObj and GroupObj denote the owning user and group, respectively.
     Possible values include: 'UserObj', 'GroupObj', 'Other', 'User', 'Group'
    :type ace_type: str or
     ~azure.mgmt.datalake.analytics.catalog.models.AclType
    :param principal_id: Required. the Azure AD object ID of the user or group
     being specified in the access control list (ACL) entry.
    :type principal_id: str
    :param permission: Required. the permission type of the access control
     list (ACL) entry. Possible values include: 'None', 'Use', 'Create',
     'Drop', 'Alter', 'Write', 'All'
    :type permission: str or
     ~azure.mgmt.datalake.analytics.catalog.models.PermissionType
    """

    _validation = {
        'ace_type': {'required': True},
        'principal_id': {'required': True},
        'permission': {'required': True},
    }

    _attribute_map = {
        'ace_type': {'key': 'aceType', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'permission': {'key': 'permission', 'type': 'str'},
    }

    def __init__(self, *, ace_type, principal_id: str, permission, **kwargs) -> None:
        super(AclCreateOrUpdateParameters, self).__init__(**kwargs)
        self.ace_type = ace_type
        self.principal_id = principal_id
        self.permission = permission
