# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class KeyVaultClientOperationsMixin(object):

    def get_certificates(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        include_pending=None,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateListResult"]
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates which are not completely
         provisioned.
        :type include_pending: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.CertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_certificates.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                if include_pending is not None:
                    query_parameters['includePending'] = self._serialize.query("include_pending", include_pending, 'bool')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('CertificateListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_certificates.metadata = {'url': '/certificates'}  # type: ignore

    def delete_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedCertificateBundle"
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated policy. Delete
        certificate cannot be used to remove individual versions of a certificate object. This
        operation requires the certificates/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.DeletedCertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeletedCertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.delete_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('DeletedCertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_certificate.metadata = {'url': '/certificates/{certificate-name}'}  # type: ignore

    def set_certificate_contacts(
        self,
        vault_base_url,  # type: str
        contacts,  # type: "_models.Contacts"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate.
        :type contacts: ~azure.keyvault.v7_1.models.Contacts
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Contacts"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.set_certificate_contacts.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(contacts, 'Contacts')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('Contacts', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    set_certificate_contacts.metadata = {'url': '/certificates/contacts'}  # type: ignore

    def get_certificate_contacts(
        self,
        vault_base_url,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate contact resources in the
        specified key vault. This operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Contacts"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_certificate_contacts.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('Contacts', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_certificate_contacts.metadata = {'url': '/certificates/contacts'}  # type: ignore

    def delete_certificate_contacts(
        self,
        vault_base_url,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Contacts"
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate. This operation requires
        the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.Contacts
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Contacts"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.delete_certificate_contacts.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('Contacts', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_certificate_contacts.metadata = {'url': '/certificates/contacts'}  # type: ignore

    def get_certificate_issuers(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateIssuerListResult"]
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateIssuerListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.CertificateIssuerListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateIssuerListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_certificate_issuers.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('CertificateIssuerListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_certificate_issuers.metadata = {'url': '/certificates/issuers'}  # type: ignore

    def set_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        parameter,  # type: "_models.CertificateIssuerSetParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter.
        :type parameter: ~azure.keyvault.v7_1.models.CertificateIssuerSetParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.IssuerBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.set_certificate_issuer.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameter, 'CertificateIssuerSetParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('IssuerBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    set_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}  # type: ignore

    def update_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        parameter,  # type: "_models.CertificateIssuerUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter.
        :type parameter: ~azure.keyvault.v7_1.models.CertificateIssuerUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.IssuerBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.update_certificate_issuer.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameter, 'CertificateIssuerUpdateParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('IssuerBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}  # type: ignore

    def get_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.IssuerBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_certificate_issuer.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('IssuerBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}  # type: ignore

    def delete_certificate_issuer(
        self,
        vault_base_url,  # type: str
        issuer_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IssuerBundle"
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
        the vault. This operation requires the certificates/manageissuers/deleteissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.IssuerBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.IssuerBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.delete_certificate_issuer.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'issuer-name': self._serialize.url("issuer_name", issuer_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('IssuerBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_certificate_issuer.metadata = {'url': '/certificates/issuers/{issuer-name}'}  # type: ignore

    def create_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate.
        :type parameters: ~azure.keyvault.v7_1.models.CertificateCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.create_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str', pattern=r'^[0-9a-zA-Z-]+$'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'CertificateCreateParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_certificate.metadata = {'url': '/certificates/{certificate-name}/create'}  # type: ignore

    def import_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateImportParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. The
        certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM
        format the PEM file must contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate.
        :type parameters: ~azure.keyvault.v7_1.models.CertificateImportParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.import_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str', pattern=r'^[0-9a-zA-Z-]+$'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'CertificateImportParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    import_certificate.metadata = {'url': '/certificates/{certificate-name}/import'}  # type: ignore

    def get_certificate_versions(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.CertificateListResult"]
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a certificate in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.CertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_certificate_versions.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('CertificateListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_certificate_versions.metadata = {'url': '/certificates/{certificate-name}/versions'}  # type: ignore

    def get_certificate_policy(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificatePolicy"
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate policy resources in the
        specified key vault. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in a given key vault.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificatePolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificatePolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_certificate_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificatePolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_certificate_policy.metadata = {'url': '/certificates/{certificate-name}/policy'}  # type: ignore

    def update_certificate_policy(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_policy,  # type: "_models.CertificatePolicy"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificatePolicy"
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate.
        :type certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificatePolicy
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificatePolicy"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.update_certificate_policy.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(certificate_policy, 'CertificatePolicy')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificatePolicy', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_certificate_policy.metadata = {'url': '/certificates/{certificate-name}/policy'}  # type: ignore

    def update_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_version,  # type: str
        parameters,  # type: "_models.CertificateUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate.
        :type certificate_version: str
        :param parameters: The parameters for certificate update.
        :type parameters: ~azure.keyvault.v7_1.models.CertificateUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.update_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
            'certificate-version': self._serialize.url("certificate_version", certificate_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'CertificateUpdateParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_certificate.metadata = {'url': '/certificates/{certificate-name}/{certificate-version}'}  # type: ignore

    def get_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires the certificates/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. This URI fragment is optional. If
         not specified, the latest version of the certificate is returned.
        :type certificate_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
            'certificate-version': self._serialize.url("certificate_version", certificate_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_certificate.metadata = {'url': '/certificates/{certificate-name}/{certificate-version}'}  # type: ignore

    def update_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        certificate_operation,  # type: "_models.CertificateOperationUpdateParameter"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response.
        :type certificate_operation: ~azure.keyvault.v7_1.models.CertificateOperationUpdateParameter
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.update_certificate_operation.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(certificate_operation, 'CertificateOperationUpdateParameter')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}  # type: ignore

    def get_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_certificate_operation.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}  # type: ignore

    def delete_certificate_operation(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateOperation"
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in the process of being
        created. The certificate is no longer created. This operation requires the certificates/update
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.delete_certificate_operation.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_certificate_operation.metadata = {'url': '/certificates/{certificate-name}/pending'}  # type: ignore

    def merge_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        parameters,  # type: "_models.CertificateMergeParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate.
        :type parameters: ~azure.keyvault.v7_1.models.CertificateMergeParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.merge_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'CertificateMergeParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    merge_certificate.metadata = {'url': '/certificates/{certificate-name}/pending/merge'}  # type: ignore

    def backup_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.BackupCertificateResult"
        """Backs up the specified certificate.

        Requests that a backup of the specified certificate be downloaded to the client. All versions
        of the certificate will be downloaded. This operation requires the certificates/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupCertificateResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.BackupCertificateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BackupCertificateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.backup_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('BackupCertificateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    backup_certificate.metadata = {'url': '/certificates/{certificate-name}/backup'}  # type: ignore

    def restore_certificate(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "_models.CertificateRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Restores a backed up certificate to a vault.

        Restores a backed up certificate, and all its versions, to a vault. This operation requires the
        certificates/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the certificate.
        :type parameters: ~azure.keyvault.v7_1.models.CertificateRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.restore_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'CertificateRestoreParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    restore_certificate.metadata = {'url': '/certificates/restore'}  # type: ignore

    def get_deleted_certificates(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        include_pending=None,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.DeletedCertificateListResult"]
        """Lists the deleted certificates in the specified vault currently available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the current vault which are
        in a deleted state and ready for recovery or purging. This operation includes deletion-specific
        information. This operation requires the certificates/get/list permission. This operation can
        only be enabled on soft-delete enabled vaults.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :param include_pending: Specifies whether to include certificates which are not completely
         provisioned.
        :type include_pending: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedCertificateListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.DeletedCertificateListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeletedCertificateListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_deleted_certificates.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                if include_pending is not None:
                    query_parameters['includePending'] = self._serialize.query("include_pending", include_pending, 'bool')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('DeletedCertificateListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_deleted_certificates.metadata = {'url': '/deletedcertificates'}  # type: ignore

    def get_deleted_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeletedCertificateBundle"
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate information plus its
        attributes, such as retention interval, scheduled permanent deletion and the current deletion
        recovery level. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.DeletedCertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeletedCertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.get_deleted_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('DeletedCertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}'}  # type: ignore

    def purge_deleted_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion of the specified
        certificate, without possibility for recovery. The operation is not available if the recovery
        level does not specify 'Purgeable'. This operation requires the certificate/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.purge_deleted_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}'}  # type: ignore

    def recover_deleted_certificate(
        self,
        vault_base_url,  # type: str
        certificate_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CertificateBundle"
        """Recovers the deleted certificate back to its current version under /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
        operation is applicable in vaults enabled for soft-delete, and must be issued during the
        retention interval (available in the deleted certificate's attributes). This operation requires
        the certificates/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param certificate_name: The name of the deleted certificate.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.CertificateBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CertificateBundle"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        accept = "application/json"

        # Construct URL
        url = self.recover_deleted_certificate.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'certificate-name': self._serialize.url("certificate_name", certificate_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CertificateBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    recover_deleted_certificate.metadata = {'url': '/deletedcertificates/{certificate-name}/recover'}  # type: ignore
