# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import HybridContainerServiceMgmtClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AgentPoolOperations,
    HybridContainerServiceOperations,
    HybridIdentityMetadataOperations,
    Operations,
    ProvisionedClustersOperations,
    StorageSpacesOperations,
    VirtualNetworksOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class HybridContainerServiceMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """The Microsoft.HybridContainerService Rest API spec.

    :ivar provisioned_clusters: ProvisionedClustersOperations operations
    :vartype provisioned_clusters:
     azure.mgmt.hybridcontainerservice.operations.ProvisionedClustersOperations
    :ivar hybrid_identity_metadata: HybridIdentityMetadataOperations operations
    :vartype hybrid_identity_metadata:
     azure.mgmt.hybridcontainerservice.operations.HybridIdentityMetadataOperations
    :ivar agent_pool: AgentPoolOperations operations
    :vartype agent_pool: azure.mgmt.hybridcontainerservice.operations.AgentPoolOperations
    :ivar hybrid_container_service: HybridContainerServiceOperations operations
    :vartype hybrid_container_service:
     azure.mgmt.hybridcontainerservice.operations.HybridContainerServiceOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hybridcontainerservice.operations.Operations
    :ivar storage_spaces: StorageSpacesOperations operations
    :vartype storage_spaces: azure.mgmt.hybridcontainerservice.operations.StorageSpacesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks:
     azure.mgmt.hybridcontainerservice.operations.VirtualNetworksOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-09-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = HybridContainerServiceMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.provisioned_clusters = ProvisionedClustersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hybrid_identity_metadata = HybridIdentityMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.agent_pool = AgentPoolOperations(self._client, self._config, self._serialize, self._deserialize)
        self.hybrid_container_service = HybridContainerServiceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.storage_spaces = StorageSpacesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "HybridContainerServiceMgmtClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
