# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.networkcloud import NetworkCloudMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-networkcloud
# USAGE
    python default_cni_networks_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkCloudMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="subscriptionId",
    )

    response = client.default_cni_networks.begin_create_or_update(
        resource_group_name="resourceGroupName",
        default_cni_network_name="defaultCniNetworkName",
        default_cni_network_parameters={
            "extendedLocation": {
                "name": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
                "type": "CustomLocation",
            },
            "location": "location",
            "properties": {
                "cniBgpConfiguration": {
                    "bgpPeers": [{"asNumber": 64497, "peerIp": "203.0.113.254"}],
                    "communityAdvertisements": [{"communities": ["64512:100"], "subnetPrefix": "192.0.2.0/27"}],
                    "serviceExternalPrefixes": ["192.0.2.0/28"],
                    "serviceLoadBalancerPrefixes": ["192.0.2.16/28"],
                },
                "ipAllocationType": "DualStack",
                "ipv4ConnectedPrefix": "203.0.113.0/24",
                "ipv6ConnectedPrefix": "2001:db8:0:3::/64",
                "l3IsolationDomainId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
                "vlan": 12,
            },
            "tags": {"key1": "myvalue1", "key2": "myvalue2"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/networkcloud/resource-manager/Microsoft.NetworkCloud/preview/2022-12-12-preview/examples/DefaultCniNetworks_Create.json
if __name__ == "__main__":
    main()
