# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar innererror: Internal error details.
    :vartype innererror: any
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "innererror": {"key": "innererror", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.innererror = None


class InnerErrorTrace(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar trace: detailed error trace.
    :vartype trace: list[str]
    """

    _validation = {
        "trace": {"readonly": True},
    }

    _attribute_map = {
        "trace": {"key": "trace", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.trace = None


class MyWorkbookResource(_serialization.Model):
    """An azure resource object.

    :ivar identity: Identity used for BYOS.
    :vartype identity: ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentity
    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Resource etag.
    :vartype etag: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "MyWorkbookManagedIdentity"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.MyWorkbookManagedIdentity"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity used for BYOS.
        :paramtype identity:
         ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentity
        :keyword id: Azure resource Id.
        :paramtype id: str
        :keyword name: Azure resource name.
        :paramtype name: str
        :keyword type: Azure resource type.
        :paramtype type: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Resource etag.
        :paramtype etag: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
        self.etag = etag


class MyWorkbook(MyWorkbookResource):  # pylint: disable=too-many-instance-attributes
    """An Application Insights private workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: Identity used for BYOS.
    :vartype identity: ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentity
    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Resource etag.
    :vartype etag: dict[str, str]
    :ivar kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2021_03_08.models.Kind
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.applicationinsights.v2021_03_08.models.SystemData
    :ivar display_name: The user-defined name of the private workbook.
    :vartype display_name: str
    :ivar serialized_data: Configuration of this particular private workbook. Configuration data is
     a string containing valid JSON.
    :vartype serialized_data: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added that can be marked private workbook.
    :vartype version: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     private workbook definition.
    :vartype time_modified: str
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar tags_properties_tags: A list of 0 or more tags that are associated with this private
     workbook definition.
    :vartype tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this private workbook.
    :vartype user_id: str
    :ivar source_id: Optional resourceId for a source resource.
    :vartype source_id: str
    :ivar storage_uri: BYOS Storage Account URI.
    :vartype storage_uri: str
    """

    _validation = {
        "system_data": {"readonly": True},
        "time_modified": {"readonly": True},
        "user_id": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "MyWorkbookManagedIdentity"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "serialized_data": {"key": "properties.serializedData", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "time_modified": {"key": "properties.timeModified", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "tags_properties_tags": {"key": "properties.tags", "type": "[str]"},
        "user_id": {"key": "properties.userId", "type": "str"},
        "source_id": {"key": "properties.sourceId", "type": "str"},
        "storage_uri": {"key": "properties.storageUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.MyWorkbookManagedIdentity"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        display_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        version: Optional[str] = None,
        category: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        source_id: Optional[str] = None,
        storage_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity used for BYOS.
        :paramtype identity:
         ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentity
        :keyword id: Azure resource Id.
        :paramtype id: str
        :keyword name: Azure resource name.
        :paramtype name: str
        :keyword type: Azure resource type.
        :paramtype type: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Resource etag.
        :paramtype etag: dict[str, str]
        :keyword kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
         "shared".
        :paramtype kind: str or ~azure.mgmt.applicationinsights.v2021_03_08.models.Kind
        :keyword display_name: The user-defined name of the private workbook.
        :paramtype display_name: str
        :keyword serialized_data: Configuration of this particular private workbook. Configuration data
         is a string containing valid JSON.
        :paramtype serialized_data: str
        :keyword version: This instance's version of the data model. This can change as new features
         are added that can be marked private workbook.
        :paramtype version: str
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword tags_properties_tags: A list of 0 or more tags that are associated with this private
         workbook definition.
        :paramtype tags_properties_tags: list[str]
        :keyword source_id: Optional resourceId for a source resource.
        :paramtype source_id: str
        :keyword storage_uri: BYOS Storage Account URI.
        :paramtype storage_uri: str
        """
        super().__init__(
            identity=identity, id=id, name=name, type=type, location=location, tags=tags, etag=etag, **kwargs
        )
        self.kind = kind
        self.system_data = None
        self.display_name = display_name
        self.serialized_data = serialized_data
        self.version = version
        self.time_modified = None
        self.category = category
        self.tags_properties_tags = tags_properties_tags
        self.user_id = None
        self.source_id = source_id
        self.storage_uri = storage_uri


class MyWorkbookError(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.applicationinsights.v2021_03_08.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.applicationinsights.v2021_03_08.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class MyWorkbookManagedIdentity(_serialization.Model):
    """Customer Managed Identity.

    :ivar user_assigned_identities: Customer Managed Identity.
    :vartype user_assigned_identities:
     ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookUserAssignedIdentities
    :ivar type: The identity type. Known values are: "UserAssigned" and "None".
    :vartype type: str or
     ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentityType
    """

    _attribute_map = {
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "MyWorkbookUserAssignedIdentities"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_assigned_identities: Optional["_models.MyWorkbookUserAssignedIdentities"] = None,
        type: Optional[Union[str, "_models.MyWorkbookManagedIdentityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_assigned_identities: Customer Managed Identity.
        :paramtype user_assigned_identities:
         ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookUserAssignedIdentities
        :keyword type: The identity type. Known values are: "UserAssigned" and "None".
        :paramtype type: str or
         ~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbookManagedIdentityType
        """
        super().__init__(**kwargs)
        self.user_assigned_identities = user_assigned_identities
        self.type = type


class MyWorkbooksListResult(_serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of private workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2021_03_08.models.MyWorkbook]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MyWorkbook]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class MyWorkbookUserAssignedIdentities(_serialization.Model):
    """Customer Managed Identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.applicationinsights.v2021_03_08.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.applicationinsights.v2021_03_08.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.applicationinsights.v2021_03_08.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.applicationinsights.v2021_03_08.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
