# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field
from .._vendor import FileType

if TYPE_CHECKING:
    from .. import models as _models


class AccessoryItem(_model_base.Model):
    """Accessory item and corresponding confidence level.


    :ivar type: Type of the accessory. Required. Known values are: "headwear", "glasses", and
     "mask".
    :vartype type: str or ~azure.ai.vision.face.models.AccessoryType
    :ivar confidence: Confidence level of the accessory type. Range between [0,1]. Required.
    :vartype confidence: float
    """

    type: Union[str, "_models.AccessoryType"] = rest_field()
    """Type of the accessory. Required. Known values are: \"headwear\", \"glasses\", and \"mask\"."""
    confidence: float = rest_field()
    """Confidence level of the accessory type. Range between [0,1]. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.AccessoryType"],
        confidence: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AddFaceResult(_model_base.Model):
    """Response body for adding face.


    :ivar persisted_face_id: Persisted Face ID of the added face, which is persisted and will not
     expire. Different from faceId which is created in "Detect" and will expire in 24 hours after
     the detection call. Required.
    :vartype persisted_face_id: str
    """

    persisted_face_id: str = rest_field(name="persistedFaceId")
    """Persisted Face ID of the added face, which is persisted and will not expire. Different from
     faceId which is created in \"Detect\" and will expire in 24 hours after the detection call.
     Required."""

    @overload
    def __init__(
        self,
        *,
        persisted_face_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AuditLivenessResponseInfo(_model_base.Model):
    """Audit entry for a response in the session.


    :ivar body: The response body. The schema of this field will depend on the request.url and
     request.method used by the client. Required.
    :vartype body: ~azure.ai.vision.face.models.LivenessResponseBody
    :ivar status_code: The HTTP status code returned to the client. Required.
    :vartype status_code: int
    :ivar latency_in_milliseconds: The server measured latency for this request in milliseconds.
     Required.
    :vartype latency_in_milliseconds: int
    """

    body: "_models.LivenessResponseBody" = rest_field()
    """The response body. The schema of this field will depend on the request.url and request.method
     used by the client. Required."""
    status_code: int = rest_field(name="statusCode")
    """The HTTP status code returned to the client. Required."""
    latency_in_milliseconds: int = rest_field(name="latencyInMilliseconds")
    """The server measured latency for this request in milliseconds. Required."""

    @overload
    def __init__(
        self,
        *,
        body: "_models.LivenessResponseBody",
        status_code: int,
        latency_in_milliseconds: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AuditRequestInfo(_model_base.Model):
    """Audit entry for a request in the session.


    :ivar url: The relative URL and query of the liveness request. Required.
    :vartype url: str
    :ivar method: The HTTP method of the request (i.e., GET, POST, DELETE). Required.
    :vartype method: str
    :ivar content_length: The length of the request body in bytes.
    :vartype content_length: int
    :ivar content_type: The content type of the request. Required.
    :vartype content_type: str
    :ivar user_agent: The user agent used to submit the request.
    :vartype user_agent: str
    """

    url: str = rest_field()
    """The relative URL and query of the liveness request. Required."""
    method: str = rest_field()
    """The HTTP method of the request (i.e., GET, POST, DELETE). Required."""
    content_length: Optional[int] = rest_field(name="contentLength")
    """The length of the request body in bytes."""
    content_type: str = rest_field(name="contentType")
    """The content type of the request. Required."""
    user_agent: Optional[str] = rest_field(name="userAgent")
    """The user agent used to submit the request."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        method: str,
        content_type: str,
        content_length: Optional[int] = None,
        user_agent: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BlurProperties(_model_base.Model):
    """Properties describing any presence of blur within the image.


    :ivar blur_level: An enum value indicating level of blurriness. Required. Known values are:
     "low", "medium", and "high".
    :vartype blur_level: str or ~azure.ai.vision.face.models.BlurLevel
    :ivar value: A number indicating level of blurriness ranging from 0 to 1. Required.
    :vartype value: float
    """

    blur_level: Union[str, "_models.BlurLevel"] = rest_field(name="blurLevel")
    """An enum value indicating level of blurriness. Required. Known values are: \"low\", \"medium\",
     and \"high\"."""
    value: float = rest_field()
    """A number indicating level of blurriness ranging from 0 to 1. Required."""

    @overload
    def __init__(
        self,
        *,
        blur_level: Union[str, "_models.BlurLevel"],
        value: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreateLivenessSessionContent(_model_base.Model):
    """Request model for creating liveness session.

    All required parameters must be populated in order to send to server.

    :ivar liveness_operation_mode: Type of liveness mode the client should follow. Required. Known
     values are: "Passive" and "PassiveActive".
    :vartype liveness_operation_mode: str or ~azure.ai.vision.face.models.LivenessOperationMode
    :ivar send_results_to_client: Whether or not to allow a '200 - Success' response body to be
     sent to the client, which may be undesirable for security reasons. Default is false, clients
     will receive a '204 - NoContent' empty body response. Regardless of selection, calling Session
     GetResult will always contain a response body enabling business logic to be implemented.
    :vartype send_results_to_client: bool
    :ivar device_correlation_id_set_in_client: Whether or not to allow client to set their own
     'deviceCorrelationId' via the Vision SDK. Default is false, and 'deviceCorrelationId' must be
     set in this request body.
    :vartype device_correlation_id_set_in_client: bool
    :ivar enable_session_image: Whether or not store the session image.
    :vartype enable_session_image: bool
    :ivar liveness_single_modal_model: The model version used for liveness classification. This is
     an optional parameter, and if this is not specified, then the latest supported model version
     will be chosen. Known values are: "2022-10-15-preview.04" and "2023-12-20-preview.06".
    :vartype liveness_single_modal_model: str or ~azure.ai.vision.face.models.LivenessModel
    :ivar device_correlation_id: Unique Guid per each end-user device. This is to provide rate
     limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this
     'deviceCorrelationId' must be null.
    :vartype device_correlation_id: str
    :ivar auth_token_time_to_live_in_seconds: Seconds the session should last for. Range is 60 to
     86400 seconds. Default value is 600.
    :vartype auth_token_time_to_live_in_seconds: int
    """

    liveness_operation_mode: Union[str, "_models.LivenessOperationMode"] = rest_field(name="livenessOperationMode")
    """Type of liveness mode the client should follow. Required. Known values are: \"Passive\" and
     \"PassiveActive\"."""
    send_results_to_client: Optional[bool] = rest_field(name="sendResultsToClient")
    """Whether or not to allow a '200 - Success' response body to be sent to the client, which may be
     undesirable for security reasons. Default is false, clients will receive a '204 - NoContent'
     empty body response. Regardless of selection, calling Session GetResult will always contain a
     response body enabling business logic to be implemented."""
    device_correlation_id_set_in_client: Optional[bool] = rest_field(name="deviceCorrelationIdSetInClient")
    """Whether or not to allow client to set their own 'deviceCorrelationId' via the Vision SDK.
     Default is false, and 'deviceCorrelationId' must be set in this request body."""
    enable_session_image: Optional[bool] = rest_field(name="enableSessionImage")
    """Whether or not store the session image."""
    liveness_single_modal_model: Optional[Union[str, "_models.LivenessModel"]] = rest_field(
        name="livenessSingleModalModel"
    )
    """The model version used for liveness classification. This is an optional parameter, and if this
     is not specified, then the latest supported model version will be chosen. Known values are:
     \"2022-10-15-preview.04\" and \"2023-12-20-preview.06\"."""
    device_correlation_id: Optional[str] = rest_field(name="deviceCorrelationId")
    """Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If
     'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be
     null."""
    auth_token_time_to_live_in_seconds: Optional[int] = rest_field(name="authTokenTimeToLiveInSeconds")
    """Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600."""

    @overload
    def __init__(
        self,
        *,
        liveness_operation_mode: Union[str, "_models.LivenessOperationMode"],
        send_results_to_client: Optional[bool] = None,
        device_correlation_id_set_in_client: Optional[bool] = None,
        enable_session_image: Optional[bool] = None,
        liveness_single_modal_model: Optional[Union[str, "_models.LivenessModel"]] = None,
        device_correlation_id: Optional[str] = None,
        auth_token_time_to_live_in_seconds: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreateLivenessSessionResult(_model_base.Model):
    """Response of liveness session creation.


    :ivar session_id: The unique session ID of the created session. It will expire 48 hours after
     it was created or may be deleted sooner using the corresponding Session DELETE operation.
     Required.
    :vartype session_id: str
    :ivar auth_token: Bearer token to provide authentication for the Vision SDK running on a client
     application. This Bearer token has limited permissions to perform only the required action and
     expires after the TTL time. It is also auditable. Required.
    :vartype auth_token: str
    """

    session_id: str = rest_field(name="sessionId")
    """The unique session ID of the created session. It will expire 48 hours after it was created or
     may be deleted sooner using the corresponding Session DELETE operation. Required."""
    auth_token: str = rest_field(name="authToken")
    """Bearer token to provide authentication for the Vision SDK running on a client application. This
     Bearer token has limited permissions to perform only the required action and expires after the
     TTL time. It is also auditable. Required."""

    @overload
    def __init__(
        self,
        *,
        session_id: str,
        auth_token: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreateLivenessWithVerifySessionContent(_model_base.Model):
    """Request for creating liveness with verify session.

    All required parameters must be populated in order to send to server.

    :ivar liveness_operation_mode: Type of liveness mode the client should follow. Required. Known
     values are: "Passive" and "PassiveActive".
    :vartype liveness_operation_mode: str or ~azure.ai.vision.face.models.LivenessOperationMode
    :ivar send_results_to_client: Whether or not to allow a '200 - Success' response body to be
     sent to the client, which may be undesirable for security reasons. Default is false, clients
     will receive a '204 - NoContent' empty body response. Regardless of selection, calling Session
     GetResult will always contain a response body enabling business logic to be implemented.
    :vartype send_results_to_client: bool
    :ivar device_correlation_id_set_in_client: Whether or not to allow client to set their own
     'deviceCorrelationId' via the Vision SDK. Default is false, and 'deviceCorrelationId' must be
     set in this request body.
    :vartype device_correlation_id_set_in_client: bool
    :ivar enable_session_image: Whether or not store the session image.
    :vartype enable_session_image: bool
    :ivar liveness_single_modal_model: The model version used for liveness classification. This is
     an optional parameter, and if this is not specified, then the latest supported model version
     will be chosen. Known values are: "2022-10-15-preview.04" and "2023-12-20-preview.06".
    :vartype liveness_single_modal_model: str or ~azure.ai.vision.face.models.LivenessModel
    :ivar device_correlation_id: Unique Guid per each end-user device. This is to provide rate
     limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this
     'deviceCorrelationId' must be null.
    :vartype device_correlation_id: str
    :ivar auth_token_time_to_live_in_seconds: Seconds the session should last for. Range is 60 to
     86400 seconds. Default value is 600.
    :vartype auth_token_time_to_live_in_seconds: int
    :ivar return_verify_image_hash: Whether or not return the verify image hash.
    :vartype return_verify_image_hash: bool
    :ivar verify_confidence_threshold: Threshold for confidence of the face verification.
    :vartype verify_confidence_threshold: float
    """

    liveness_operation_mode: Union[str, "_models.LivenessOperationMode"] = rest_field(name="livenessOperationMode")
    """Type of liveness mode the client should follow. Required. Known values are: \"Passive\" and
     \"PassiveActive\"."""
    send_results_to_client: Optional[bool] = rest_field(name="sendResultsToClient")
    """Whether or not to allow a '200 - Success' response body to be sent to the client, which may be
     undesirable for security reasons. Default is false, clients will receive a '204 - NoContent'
     empty body response. Regardless of selection, calling Session GetResult will always contain a
     response body enabling business logic to be implemented."""
    device_correlation_id_set_in_client: Optional[bool] = rest_field(name="deviceCorrelationIdSetInClient")
    """Whether or not to allow client to set their own 'deviceCorrelationId' via the Vision SDK.
     Default is false, and 'deviceCorrelationId' must be set in this request body."""
    enable_session_image: Optional[bool] = rest_field(name="enableSessionImage")
    """Whether or not store the session image."""
    liveness_single_modal_model: Optional[Union[str, "_models.LivenessModel"]] = rest_field(
        name="livenessSingleModalModel"
    )
    """The model version used for liveness classification. This is an optional parameter, and if this
     is not specified, then the latest supported model version will be chosen. Known values are:
     \"2022-10-15-preview.04\" and \"2023-12-20-preview.06\"."""
    device_correlation_id: Optional[str] = rest_field(name="deviceCorrelationId")
    """Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If
     'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be
     null."""
    auth_token_time_to_live_in_seconds: Optional[int] = rest_field(name="authTokenTimeToLiveInSeconds")
    """Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600."""
    return_verify_image_hash: Optional[bool] = rest_field(name="returnVerifyImageHash")
    """Whether or not return the verify image hash."""
    verify_confidence_threshold: Optional[float] = rest_field(name="verifyConfidenceThreshold")
    """Threshold for confidence of the face verification."""

    @overload
    def __init__(
        self,
        *,
        liveness_operation_mode: Union[str, "_models.LivenessOperationMode"],
        send_results_to_client: Optional[bool] = None,
        device_correlation_id_set_in_client: Optional[bool] = None,
        enable_session_image: Optional[bool] = None,
        liveness_single_modal_model: Optional[Union[str, "_models.LivenessModel"]] = None,
        device_correlation_id: Optional[str] = None,
        auth_token_time_to_live_in_seconds: Optional[int] = None,
        return_verify_image_hash: Optional[bool] = None,
        verify_confidence_threshold: Optional[float] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreateLivenessWithVerifySessionMultipartContent(_model_base.Model):  # pylint: disable=name-too-long
    """Request of liveness with verify session creation.

    All required parameters must be populated in order to send to server.

    :ivar parameters: The parameters for creating session. Required.
    :vartype parameters: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionContent
    :ivar verify_image: The image stream for verify. Content-Disposition header field for this part
     must have filename. Required.
    :vartype verify_image: ~azure.ai.vision.face._vendor.FileType
    """

    parameters: "_models.CreateLivenessWithVerifySessionContent" = rest_field(name="Parameters")
    """The parameters for creating session. Required."""
    verify_image: FileType = rest_field(name="VerifyImage", is_multipart_file_input=True)
    """The image stream for verify. Content-Disposition header field for this part must have filename.
     Required."""

    @overload
    def __init__(
        self,
        *,
        parameters: "_models.CreateLivenessWithVerifySessionContent",
        verify_image: FileType,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreateLivenessWithVerifySessionResult(_model_base.Model):
    """Response of liveness session with verify creation with verify image provided.


    :ivar session_id: The unique session ID of the created session. It will expire 48 hours after
     it was created or may be deleted sooner using the corresponding Session DELETE operation.
     Required.
    :vartype session_id: str
    :ivar auth_token: Bearer token to provide authentication for the Vision SDK running on a client
     application. This Bearer token has limited permissions to perform only the required action and
     expires after the TTL time. It is also auditable. Required.
    :vartype auth_token: str
    :ivar verify_image: The detail of face for verification.
    :vartype verify_image: ~azure.ai.vision.face.models.LivenessWithVerifyImage
    """

    session_id: str = rest_field(name="sessionId")
    """The unique session ID of the created session. It will expire 48 hours after it was created or
     may be deleted sooner using the corresponding Session DELETE operation. Required."""
    auth_token: str = rest_field(name="authToken")
    """Bearer token to provide authentication for the Vision SDK running on a client application. This
     Bearer token has limited permissions to perform only the required action and expires after the
     TTL time. It is also auditable. Required."""
    verify_image: Optional["_models.LivenessWithVerifyImage"] = rest_field(name="verifyImage")
    """The detail of face for verification."""

    @overload
    def __init__(
        self,
        *,
        session_id: str,
        auth_token: str,
        verify_image: Optional["_models.LivenessWithVerifyImage"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CreatePersonResult(_model_base.Model):
    """Response of create person.


    :ivar person_id: Person ID of the person. Required.
    :vartype person_id: str
    """

    person_id: str = rest_field(name="personId")
    """Person ID of the person. Required."""

    @overload
    def __init__(
        self,
        *,
        person_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExposureProperties(_model_base.Model):
    """Properties describing exposure level of the image.


    :ivar exposure_level: An enum value indicating level of exposure. Required. Known values are:
     "underExposure", "goodExposure", and "overExposure".
    :vartype exposure_level: str or ~azure.ai.vision.face.models.ExposureLevel
    :ivar value: A number indicating level of exposure level ranging from 0 to 1. [0, 0.25) is
     under exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. Required.
    :vartype value: float
    """

    exposure_level: Union[str, "_models.ExposureLevel"] = rest_field(name="exposureLevel")
    """An enum value indicating level of exposure. Required. Known values are: \"underExposure\",
     \"goodExposure\", and \"overExposure\"."""
    value: float = rest_field()
    """A number indicating level of exposure level ranging from 0 to 1. [0, 0.25) is under exposure.
     [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. Required."""

    @overload
    def __init__(
        self,
        *,
        exposure_level: Union[str, "_models.ExposureLevel"],
        value: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceAttributes(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Face attributes for the detected face.

    :ivar age: Age in years.
    :vartype age: float
    :ivar smile: Smile intensity, a number between [0,1].
    :vartype smile: float
    :ivar facial_hair: Properties describing facial hair attributes.
    :vartype facial_hair: ~azure.ai.vision.face.models.FacialHair
    :ivar glasses: Glasses type if any of the face. Known values are: "noGlasses",
     "readingGlasses", "sunglasses", and "swimmingGoggles".
    :vartype glasses: str or ~azure.ai.vision.face.models.GlassesType
    :ivar head_pose: 3-D roll/yaw/pitch angles for face direction.
    :vartype head_pose: ~azure.ai.vision.face.models.HeadPose
    :ivar hair: Properties describing hair attributes.
    :vartype hair: ~azure.ai.vision.face.models.HairProperties
    :ivar occlusion: Properties describing occlusions on a given face.
    :vartype occlusion: ~azure.ai.vision.face.models.OcclusionProperties
    :ivar accessories: Properties describing any accessories on a given face.
    :vartype accessories: list[~azure.ai.vision.face.models.AccessoryItem]
    :ivar blur: Properties describing any presence of blur within the image.
    :vartype blur: ~azure.ai.vision.face.models.BlurProperties
    :ivar exposure: Properties describing exposure level of the image.
    :vartype exposure: ~azure.ai.vision.face.models.ExposureProperties
    :ivar noise: Properties describing noise level of the image.
    :vartype noise: ~azure.ai.vision.face.models.NoiseProperties
    :ivar mask: Properties describing the presence of a mask on a given face.
    :vartype mask: ~azure.ai.vision.face.models.MaskProperties
    :ivar quality_for_recognition: Properties describing the overall image quality regarding
     whether the image being used in the detection is of sufficient quality to attempt face
     recognition on. Known values are: "low", "medium", and "high".
    :vartype quality_for_recognition: str or ~azure.ai.vision.face.models.QualityForRecognition
    """

    age: Optional[float] = rest_field()
    """Age in years."""
    smile: Optional[float] = rest_field()
    """Smile intensity, a number between [0,1]."""
    facial_hair: Optional["_models.FacialHair"] = rest_field(name="facialHair")
    """Properties describing facial hair attributes."""
    glasses: Optional[Union[str, "_models.GlassesType"]] = rest_field()
    """Glasses type if any of the face. Known values are: \"noGlasses\", \"readingGlasses\",
     \"sunglasses\", and \"swimmingGoggles\"."""
    head_pose: Optional["_models.HeadPose"] = rest_field(name="headPose")
    """3-D roll/yaw/pitch angles for face direction."""
    hair: Optional["_models.HairProperties"] = rest_field()
    """Properties describing hair attributes."""
    occlusion: Optional["_models.OcclusionProperties"] = rest_field()
    """Properties describing occlusions on a given face."""
    accessories: Optional[List["_models.AccessoryItem"]] = rest_field()
    """Properties describing any accessories on a given face."""
    blur: Optional["_models.BlurProperties"] = rest_field()
    """Properties describing any presence of blur within the image."""
    exposure: Optional["_models.ExposureProperties"] = rest_field()
    """Properties describing exposure level of the image."""
    noise: Optional["_models.NoiseProperties"] = rest_field()
    """Properties describing noise level of the image."""
    mask: Optional["_models.MaskProperties"] = rest_field()
    """Properties describing the presence of a mask on a given face."""
    quality_for_recognition: Optional[Union[str, "_models.QualityForRecognition"]] = rest_field(
        name="qualityForRecognition"
    )
    """Properties describing the overall image quality regarding whether the image being used in the
     detection is of sufficient quality to attempt face recognition on. Known values are: \"low\",
     \"medium\", and \"high\"."""

    @overload
    def __init__(
        self,
        *,
        age: Optional[float] = None,
        smile: Optional[float] = None,
        facial_hair: Optional["_models.FacialHair"] = None,
        glasses: Optional[Union[str, "_models.GlassesType"]] = None,
        head_pose: Optional["_models.HeadPose"] = None,
        hair: Optional["_models.HairProperties"] = None,
        occlusion: Optional["_models.OcclusionProperties"] = None,
        accessories: Optional[List["_models.AccessoryItem"]] = None,
        blur: Optional["_models.BlurProperties"] = None,
        exposure: Optional["_models.ExposureProperties"] = None,
        noise: Optional["_models.NoiseProperties"] = None,
        mask: Optional["_models.MaskProperties"] = None,
        quality_for_recognition: Optional[Union[str, "_models.QualityForRecognition"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceDetectionResult(_model_base.Model):
    """Response for detect API.


    :ivar face_id: Unique faceId of the detected face, created by detection API and it will expire
     24 hours after the detection call. To return this, it requires 'returnFaceId' parameter to be
     true.
    :vartype face_id: str
    :ivar recognition_model: The 'recognitionModel' associated with this faceId. This is only
     returned when 'returnRecognitionModel' is explicitly set as true. Known values are:
     "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
    :vartype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
    :ivar face_rectangle: A rectangle area for the face location on image. Required.
    :vartype face_rectangle: ~azure.ai.vision.face.models.FaceRectangle
    :ivar face_landmarks: An array of 27-point face landmarks pointing to the important positions
     of face components. To return this, it requires 'returnFaceLandmarks' parameter to be true.
    :vartype face_landmarks: ~azure.ai.vision.face.models.FaceLandmarks
    :ivar face_attributes: Face attributes for detected face.
    :vartype face_attributes: ~azure.ai.vision.face.models.FaceAttributes
    """

    face_id: Optional[str] = rest_field(name="faceId")
    """Unique faceId of the detected face, created by detection API and it will expire 24 hours after
     the detection call. To return this, it requires 'returnFaceId' parameter to be true."""
    recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = rest_field(name="recognitionModel")
    """The 'recognitionModel' associated with this faceId. This is only returned when
     'returnRecognitionModel' is explicitly set as true. Known values are: \"recognition_01\",
     \"recognition_02\", \"recognition_03\", and \"recognition_04\"."""
    face_rectangle: "_models.FaceRectangle" = rest_field(name="faceRectangle")
    """A rectangle area for the face location on image. Required."""
    face_landmarks: Optional["_models.FaceLandmarks"] = rest_field(name="faceLandmarks")
    """An array of 27-point face landmarks pointing to the important positions of face components. To
     return this, it requires 'returnFaceLandmarks' parameter to be true."""
    face_attributes: Optional["_models.FaceAttributes"] = rest_field(name="faceAttributes")
    """Face attributes for detected face."""

    @overload
    def __init__(
        self,
        *,
        face_rectangle: "_models.FaceRectangle",
        face_id: Optional[str] = None,
        recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = None,
        face_landmarks: Optional["_models.FaceLandmarks"] = None,
        face_attributes: Optional["_models.FaceAttributes"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceError(_model_base.Model):
    """The error object. For comprehensive details on error codes and messages returned by the Face
    Service, please refer to the following link: https://aka.ms/face-error-codes-and-messages.


    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required."""
    message: str = rest_field()
    """A human-readable representation of the error. Required."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceErrorResponse(_model_base.Model):
    """A response containing error details.


    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.vision.face.models.FaceError
    """

    error: "_models.FaceError" = rest_field()
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.FaceError",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceFindSimilarResult(_model_base.Model):
    """Response body for find similar face operation.


    :ivar confidence: Confidence value of the candidate. The higher confidence, the more similar.
     Range between [0,1]. Required.
    :vartype confidence: float
    :ivar face_id: faceId of candidate face when find by faceIds. faceId is created by "Detect" and
     will expire 24 hours after the detection call.
    :vartype face_id: str
    :ivar persisted_face_id: persistedFaceId of candidate face when find by faceListId or
     largeFaceListId. persistedFaceId in face list/large face list is persisted and will not expire.
    :vartype persisted_face_id: str
    """

    confidence: float = rest_field()
    """Confidence value of the candidate. The higher confidence, the more similar. Range between
     [0,1]. Required."""
    face_id: Optional[str] = rest_field(name="faceId")
    """faceId of candidate face when find by faceIds. faceId is created by \"Detect\" and will expire
     24 hours after the detection call."""
    persisted_face_id: Optional[str] = rest_field(name="persistedFaceId")
    """persistedFaceId of candidate face when find by faceListId or largeFaceListId. persistedFaceId
     in face list/large face list is persisted and will not expire."""

    @overload
    def __init__(
        self,
        *,
        confidence: float,
        face_id: Optional[str] = None,
        persisted_face_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceGroupingResult(_model_base.Model):
    """Response body for group face operation.


    :ivar groups: A partition of the original faces based on face similarity. Groups are ranked by
     number of faces. Required.
    :vartype groups: list[list[str]]
    :ivar messy_group: Face ids array of faces that cannot find any similar faces from original
     faces. Required.
    :vartype messy_group: list[str]
    """

    groups: List[List[str]] = rest_field()
    """A partition of the original faces based on face similarity. Groups are ranked by number of
     faces. Required."""
    messy_group: List[str] = rest_field(name="messyGroup")
    """Face ids array of faces that cannot find any similar faces from original faces. Required."""

    @overload
    def __init__(
        self,
        *,
        groups: List[List[str]],
        messy_group: List[str],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceIdentificationCandidate(_model_base.Model):
    """Candidate for identify call.


    :ivar person_id: personId of candidate person. Required.
    :vartype person_id: str
    :ivar confidence: Confidence value of the candidate. The higher confidence, the more similar.
     Range between [0,1]. Required.
    :vartype confidence: float
    """

    person_id: str = rest_field(name="personId")
    """personId of candidate person. Required."""
    confidence: float = rest_field()
    """Confidence value of the candidate. The higher confidence, the more similar. Range between
     [0,1]. Required."""

    @overload
    def __init__(
        self,
        *,
        person_id: str,
        confidence: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceIdentificationResult(_model_base.Model):
    """Identify result.


    :ivar face_id: faceId of the query face. Required.
    :vartype face_id: str
    :ivar candidates: Identified person candidates for that face (ranked by confidence). Array size
     should be no larger than input maxNumOfCandidatesReturned. If no person is identified, will
     return an empty array. Required.
    :vartype candidates: list[~azure.ai.vision.face.models.FaceIdentificationCandidate]
    """

    face_id: str = rest_field(name="faceId")
    """faceId of the query face. Required."""
    candidates: List["_models.FaceIdentificationCandidate"] = rest_field()
    """Identified person candidates for that face (ranked by confidence). Array size should be no
     larger than input maxNumOfCandidatesReturned. If no person is identified, will return an empty
     array. Required."""

    @overload
    def __init__(
        self,
        *,
        face_id: str,
        candidates: List["_models.FaceIdentificationCandidate"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceLandmarks(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """A collection of 27-point face landmarks pointing to the important positions of face components.


    :ivar pupil_left: The coordinates of the left eye pupil. Required.
    :vartype pupil_left: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar pupil_right: The coordinates of the right eye pupil. Required.
    :vartype pupil_right: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_tip: The coordinates of the nose tip. Required.
    :vartype nose_tip: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar mouth_left: The coordinates of the mouth left. Required.
    :vartype mouth_left: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar mouth_right: The coordinates of the mouth right. Required.
    :vartype mouth_right: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eyebrow_left_outer: The coordinates of the left eyebrow outer. Required.
    :vartype eyebrow_left_outer: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eyebrow_left_inner: The coordinates of the left eyebrow inner. Required.
    :vartype eyebrow_left_inner: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_left_outer: The coordinates of the left eye outer. Required.
    :vartype eye_left_outer: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_left_top: The coordinates of the left eye top. Required.
    :vartype eye_left_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_left_bottom: The coordinates of the left eye bottom. Required.
    :vartype eye_left_bottom: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_left_inner: The coordinates of the left eye inner. Required.
    :vartype eye_left_inner: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eyebrow_right_inner: The coordinates of the right eyebrow inner. Required.
    :vartype eyebrow_right_inner: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eyebrow_right_outer: The coordinates of the right eyebrow outer. Required.
    :vartype eyebrow_right_outer: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_right_inner: The coordinates of the right eye inner. Required.
    :vartype eye_right_inner: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_right_top: The coordinates of the right eye top. Required.
    :vartype eye_right_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_right_bottom: The coordinates of the right eye bottom. Required.
    :vartype eye_right_bottom: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar eye_right_outer: The coordinates of the right eye outer. Required.
    :vartype eye_right_outer: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_root_left: The coordinates of the nose root left. Required.
    :vartype nose_root_left: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_root_right: The coordinates of the nose root right. Required.
    :vartype nose_root_right: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_left_alar_top: The coordinates of the nose left alar top. Required.
    :vartype nose_left_alar_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_right_alar_top: The coordinates of the nose right alar top. Required.
    :vartype nose_right_alar_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_left_alar_out_tip: The coordinates of the nose left alar out tip. Required.
    :vartype nose_left_alar_out_tip: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar nose_right_alar_out_tip: The coordinates of the nose right alar out tip. Required.
    :vartype nose_right_alar_out_tip: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar upper_lip_top: The coordinates of the upper lip top. Required.
    :vartype upper_lip_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar upper_lip_bottom: The coordinates of the upper lip bottom. Required.
    :vartype upper_lip_bottom: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar under_lip_top: The coordinates of the under lip top. Required.
    :vartype under_lip_top: ~azure.ai.vision.face.models.LandmarkCoordinate
    :ivar under_lip_bottom: The coordinates of the under lip bottom. Required.
    :vartype under_lip_bottom: ~azure.ai.vision.face.models.LandmarkCoordinate
    """

    pupil_left: "_models.LandmarkCoordinate" = rest_field(name="pupilLeft")
    """The coordinates of the left eye pupil. Required."""
    pupil_right: "_models.LandmarkCoordinate" = rest_field(name="pupilRight")
    """The coordinates of the right eye pupil. Required."""
    nose_tip: "_models.LandmarkCoordinate" = rest_field(name="noseTip")
    """The coordinates of the nose tip. Required."""
    mouth_left: "_models.LandmarkCoordinate" = rest_field(name="mouthLeft")
    """The coordinates of the mouth left. Required."""
    mouth_right: "_models.LandmarkCoordinate" = rest_field(name="mouthRight")
    """The coordinates of the mouth right. Required."""
    eyebrow_left_outer: "_models.LandmarkCoordinate" = rest_field(name="eyebrowLeftOuter")
    """The coordinates of the left eyebrow outer. Required."""
    eyebrow_left_inner: "_models.LandmarkCoordinate" = rest_field(name="eyebrowLeftInner")
    """The coordinates of the left eyebrow inner. Required."""
    eye_left_outer: "_models.LandmarkCoordinate" = rest_field(name="eyeLeftOuter")
    """The coordinates of the left eye outer. Required."""
    eye_left_top: "_models.LandmarkCoordinate" = rest_field(name="eyeLeftTop")
    """The coordinates of the left eye top. Required."""
    eye_left_bottom: "_models.LandmarkCoordinate" = rest_field(name="eyeLeftBottom")
    """The coordinates of the left eye bottom. Required."""
    eye_left_inner: "_models.LandmarkCoordinate" = rest_field(name="eyeLeftInner")
    """The coordinates of the left eye inner. Required."""
    eyebrow_right_inner: "_models.LandmarkCoordinate" = rest_field(name="eyebrowRightInner")
    """The coordinates of the right eyebrow inner. Required."""
    eyebrow_right_outer: "_models.LandmarkCoordinate" = rest_field(name="eyebrowRightOuter")
    """The coordinates of the right eyebrow outer. Required."""
    eye_right_inner: "_models.LandmarkCoordinate" = rest_field(name="eyeRightInner")
    """The coordinates of the right eye inner. Required."""
    eye_right_top: "_models.LandmarkCoordinate" = rest_field(name="eyeRightTop")
    """The coordinates of the right eye top. Required."""
    eye_right_bottom: "_models.LandmarkCoordinate" = rest_field(name="eyeRightBottom")
    """The coordinates of the right eye bottom. Required."""
    eye_right_outer: "_models.LandmarkCoordinate" = rest_field(name="eyeRightOuter")
    """The coordinates of the right eye outer. Required."""
    nose_root_left: "_models.LandmarkCoordinate" = rest_field(name="noseRootLeft")
    """The coordinates of the nose root left. Required."""
    nose_root_right: "_models.LandmarkCoordinate" = rest_field(name="noseRootRight")
    """The coordinates of the nose root right. Required."""
    nose_left_alar_top: "_models.LandmarkCoordinate" = rest_field(name="noseLeftAlarTop")
    """The coordinates of the nose left alar top. Required."""
    nose_right_alar_top: "_models.LandmarkCoordinate" = rest_field(name="noseRightAlarTop")
    """The coordinates of the nose right alar top. Required."""
    nose_left_alar_out_tip: "_models.LandmarkCoordinate" = rest_field(name="noseLeftAlarOutTip")
    """The coordinates of the nose left alar out tip. Required."""
    nose_right_alar_out_tip: "_models.LandmarkCoordinate" = rest_field(name="noseRightAlarOutTip")
    """The coordinates of the nose right alar out tip. Required."""
    upper_lip_top: "_models.LandmarkCoordinate" = rest_field(name="upperLipTop")
    """The coordinates of the upper lip top. Required."""
    upper_lip_bottom: "_models.LandmarkCoordinate" = rest_field(name="upperLipBottom")
    """The coordinates of the upper lip bottom. Required."""
    under_lip_top: "_models.LandmarkCoordinate" = rest_field(name="underLipTop")
    """The coordinates of the under lip top. Required."""
    under_lip_bottom: "_models.LandmarkCoordinate" = rest_field(name="underLipBottom")
    """The coordinates of the under lip bottom. Required."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        pupil_left: "_models.LandmarkCoordinate",
        pupil_right: "_models.LandmarkCoordinate",
        nose_tip: "_models.LandmarkCoordinate",
        mouth_left: "_models.LandmarkCoordinate",
        mouth_right: "_models.LandmarkCoordinate",
        eyebrow_left_outer: "_models.LandmarkCoordinate",
        eyebrow_left_inner: "_models.LandmarkCoordinate",
        eye_left_outer: "_models.LandmarkCoordinate",
        eye_left_top: "_models.LandmarkCoordinate",
        eye_left_bottom: "_models.LandmarkCoordinate",
        eye_left_inner: "_models.LandmarkCoordinate",
        eyebrow_right_inner: "_models.LandmarkCoordinate",
        eyebrow_right_outer: "_models.LandmarkCoordinate",
        eye_right_inner: "_models.LandmarkCoordinate",
        eye_right_top: "_models.LandmarkCoordinate",
        eye_right_bottom: "_models.LandmarkCoordinate",
        eye_right_outer: "_models.LandmarkCoordinate",
        nose_root_left: "_models.LandmarkCoordinate",
        nose_root_right: "_models.LandmarkCoordinate",
        nose_left_alar_top: "_models.LandmarkCoordinate",
        nose_right_alar_top: "_models.LandmarkCoordinate",
        nose_left_alar_out_tip: "_models.LandmarkCoordinate",
        nose_right_alar_out_tip: "_models.LandmarkCoordinate",
        upper_lip_top: "_models.LandmarkCoordinate",
        upper_lip_bottom: "_models.LandmarkCoordinate",
        under_lip_top: "_models.LandmarkCoordinate",
        under_lip_bottom: "_models.LandmarkCoordinate",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceRectangle(_model_base.Model):
    """A rectangle within which a face can be found.


    :ivar top: The distance from the top edge if the image to the top edge of the rectangle, in
     pixels. Required.
    :vartype top: int
    :ivar left: The distance from the left edge if the image to the left edge of the rectangle, in
     pixels. Required.
    :vartype left: int
    :ivar width: The width of the rectangle, in pixels. Required.
    :vartype width: int
    :ivar height: The height of the rectangle, in pixels. Required.
    :vartype height: int
    """

    top: int = rest_field()
    """The distance from the top edge if the image to the top edge of the rectangle, in pixels.
     Required."""
    left: int = rest_field()
    """The distance from the left edge if the image to the left edge of the rectangle, in pixels.
     Required."""
    width: int = rest_field()
    """The width of the rectangle, in pixels. Required."""
    height: int = rest_field()
    """The height of the rectangle, in pixels. Required."""

    @overload
    def __init__(
        self,
        *,
        top: int,
        left: int,
        width: int,
        height: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceTrainingResult(_model_base.Model):
    """Training result of a container.


    :ivar status: Training status of the container. Required. Known values are: "notStarted",
     "running", "succeeded", and "failed".
    :vartype status: str or ~azure.ai.vision.face.models.FaceOperationStatus
    :ivar created_date_time: A combined UTC date and time string that describes the created time of
     the person group, large person group or large face list. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_action_date_time: A combined UTC date and time string that describes the last modify
     time of the person group, large person group or large face list, could be null value when the
     group is not successfully trained. Required.
    :vartype last_action_date_time: ~datetime.datetime
    :ivar last_successful_training_date_time: A combined UTC date and time string that describes
     the last successful training time of the person group, large person group or large face list.
     Required.
    :vartype last_successful_training_date_time: ~datetime.datetime
    :ivar message: Show failure message when training failed (omitted when training succeed).
    :vartype message: str
    """

    status: Union[str, "_models.FaceOperationStatus"] = rest_field()
    """Training status of the container. Required. Known values are: \"notStarted\", \"running\",
     \"succeeded\", and \"failed\"."""
    created_date_time: datetime.datetime = rest_field(name="createdDateTime", format="rfc3339")
    """A combined UTC date and time string that describes the created time of the person group, large
     person group or large face list. Required."""
    last_action_date_time: datetime.datetime = rest_field(name="lastActionDateTime", format="rfc3339")
    """A combined UTC date and time string that describes the last modify time of the person group,
     large person group or large face list, could be null value when the group is not successfully
     trained. Required."""
    last_successful_training_date_time: datetime.datetime = rest_field(
        name="lastSuccessfulTrainingDateTime", format="rfc3339"
    )
    """A combined UTC date and time string that describes the last successful training time of the
     person group, large person group or large face list. Required."""
    message: Optional[str] = rest_field()
    """Show failure message when training failed (omitted when training succeed)."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.FaceOperationStatus"],
        created_date_time: datetime.datetime,
        last_action_date_time: datetime.datetime,
        last_successful_training_date_time: datetime.datetime,
        message: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FaceVerificationResult(_model_base.Model):
    """Verify result.


    :ivar is_identical: True if the two faces belong to the same person or the face belongs to the
     person, otherwise false. Required.
    :vartype is_identical: bool
    :ivar confidence: A number indicates the similarity confidence of whether two faces belong to
     the same person, or whether the face belongs to the person. By default, isIdentical is set to
     True if similarity confidence is greater than or equal to 0.5. This is useful for advanced
     users to override 'isIdentical' and fine-tune the result on their own data. Required.
    :vartype confidence: float
    """

    is_identical: bool = rest_field(name="isIdentical")
    """True if the two faces belong to the same person or the face belongs to the person, otherwise
     false. Required."""
    confidence: float = rest_field()
    """A number indicates the similarity confidence of whether two faces belong to the same person, or
     whether the face belongs to the person. By default, isIdentical is set to True if similarity
     confidence is greater than or equal to 0.5. This is useful for advanced users to override
     'isIdentical' and fine-tune the result on their own data. Required."""

    @overload
    def __init__(
        self,
        *,
        is_identical: bool,
        confidence: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class FacialHair(_model_base.Model):
    """Properties describing facial hair attributes.


    :ivar moustache: A number ranging from 0 to 1 indicating a level of confidence associated with
     a property. Required.
    :vartype moustache: float
    :ivar beard: A number ranging from 0 to 1 indicating a level of confidence associated with a
     property. Required.
    :vartype beard: float
    :ivar sideburns: A number ranging from 0 to 1 indicating a level of confidence associated with
     a property. Required.
    :vartype sideburns: float
    """

    moustache: float = rest_field()
    """A number ranging from 0 to 1 indicating a level of confidence associated with a property.
     Required."""
    beard: float = rest_field()
    """A number ranging from 0 to 1 indicating a level of confidence associated with a property.
     Required."""
    sideburns: float = rest_field()
    """A number ranging from 0 to 1 indicating a level of confidence associated with a property.
     Required."""

    @overload
    def __init__(
        self,
        *,
        moustache: float,
        beard: float,
        sideburns: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class HairColor(_model_base.Model):
    """An array of candidate colors and confidence level in the presence of each.


    :ivar color: Name of the hair color. Required. Known values are: "unknown", "white", "gray",
     "blond", "brown", "red", "black", and "other".
    :vartype color: str or ~azure.ai.vision.face.models.HairColorType
    :ivar confidence: Confidence level of the color. Range between [0,1]. Required.
    :vartype confidence: float
    """

    color: Union[str, "_models.HairColorType"] = rest_field()
    """Name of the hair color. Required. Known values are: \"unknown\", \"white\", \"gray\",
     \"blond\", \"brown\", \"red\", \"black\", and \"other\"."""
    confidence: float = rest_field()
    """Confidence level of the color. Range between [0,1]. Required."""

    @overload
    def __init__(
        self,
        *,
        color: Union[str, "_models.HairColorType"],
        confidence: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class HairProperties(_model_base.Model):
    """Properties describing hair attributes.


    :ivar bald: A number describing confidence level of whether the person is bald. Required.
    :vartype bald: float
    :ivar invisible: A boolean value describing whether the hair is visible in the image. Required.
    :vartype invisible: bool
    :ivar hair_color: An array of candidate colors and confidence level in the presence of each.
     Required.
    :vartype hair_color: list[~azure.ai.vision.face.models.HairColor]
    """

    bald: float = rest_field()
    """A number describing confidence level of whether the person is bald. Required."""
    invisible: bool = rest_field()
    """A boolean value describing whether the hair is visible in the image. Required."""
    hair_color: List["_models.HairColor"] = rest_field(name="hairColor")
    """An array of candidate colors and confidence level in the presence of each. Required."""

    @overload
    def __init__(
        self,
        *,
        bald: float,
        invisible: bool,
        hair_color: List["_models.HairColor"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class HeadPose(_model_base.Model):
    """3-D roll/yaw/pitch angles for face direction.


    :ivar pitch: Value of angles. Required.
    :vartype pitch: float
    :ivar roll: Value of angles. Required.
    :vartype roll: float
    :ivar yaw: Value of angles. Required.
    :vartype yaw: float
    """

    pitch: float = rest_field()
    """Value of angles. Required."""
    roll: float = rest_field()
    """Value of angles. Required."""
    yaw: float = rest_field()
    """Value of angles. Required."""

    @overload
    def __init__(
        self,
        *,
        pitch: float,
        roll: float,
        yaw: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LandmarkCoordinate(_model_base.Model):
    """Landmark coordinates within an image.


    :ivar x: The horizontal component, in pixels. Required.
    :vartype x: float
    :ivar y: The vertical component, in pixels. Required.
    :vartype y: float
    """

    x: float = rest_field()
    """The horizontal component, in pixels. Required."""
    y: float = rest_field()
    """The vertical component, in pixels. Required."""

    @overload
    def __init__(
        self,
        *,
        x: float,
        y: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LargeFaceList(_model_base.Model):
    """Large face list is a list of faces, up to 1,000,000 faces.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: User defined name, maximum length is 128. Required.
    :vartype name: str
    :ivar user_data: Optional user defined data. Length should not exceed 16K.
    :vartype user_data: str
    :ivar recognition_model: Name of recognition model. Recognition model is used when the face
     features are extracted and associated with detected faceIds. Known values are:
     "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
    :vartype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
    :ivar large_face_list_id: Valid character is letter in lower case or digit or '-' or '_',
     maximum length is 64. Required.
    :vartype large_face_list_id: str
    """

    name: str = rest_field()
    """User defined name, maximum length is 128. Required."""
    user_data: Optional[str] = rest_field(name="userData")
    """Optional user defined data. Length should not exceed 16K."""
    recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = rest_field(name="recognitionModel")
    """Name of recognition model. Recognition model is used when the face features are extracted and
     associated with detected faceIds. Known values are: \"recognition_01\", \"recognition_02\",
     \"recognition_03\", and \"recognition_04\"."""
    large_face_list_id: str = rest_field(name="largeFaceListId", visibility=["read"])
    """Valid character is letter in lower case or digit or '-' or '_', maximum length is 64. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LargeFaceListFace(_model_base.Model):
    """Face resource for large face list.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar persisted_face_id: Face ID of the face. Required.
    :vartype persisted_face_id: str
    :ivar user_data: User-provided data attached to the face. The length limit is 1K.
    :vartype user_data: str
    """

    persisted_face_id: str = rest_field(name="persistedFaceId", visibility=["read"])
    """Face ID of the face. Required."""
    user_data: Optional[str] = rest_field(name="userData")
    """User-provided data attached to the face. The length limit is 1K."""

    @overload
    def __init__(
        self,
        *,
        user_data: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LargePersonGroup(_model_base.Model):
    """The container of the uploaded person data, including face recognition feature, and up to
    1,000,000 people.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: User defined name, maximum length is 128. Required.
    :vartype name: str
    :ivar user_data: Optional user defined data. Length should not exceed 16K.
    :vartype user_data: str
    :ivar recognition_model: Name of recognition model. Recognition model is used when the face
     features are extracted and associated with detected faceIds. Known values are:
     "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
    :vartype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
    :ivar large_person_group_id: ID of the container. Required.
    :vartype large_person_group_id: str
    """

    name: str = rest_field()
    """User defined name, maximum length is 128. Required."""
    user_data: Optional[str] = rest_field(name="userData")
    """Optional user defined data. Length should not exceed 16K."""
    recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = rest_field(name="recognitionModel")
    """Name of recognition model. Recognition model is used when the face features are extracted and
     associated with detected faceIds. Known values are: \"recognition_01\", \"recognition_02\",
     \"recognition_03\", and \"recognition_04\"."""
    large_person_group_id: str = rest_field(name="largePersonGroupId", visibility=["read"])
    """ID of the container. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        user_data: Optional[str] = None,
        recognition_model: Optional[Union[str, "_models.FaceRecognitionModel"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LargePersonGroupPerson(_model_base.Model):
    """The person in a specified large person group. To add face to this person, please call "Add
    Large Person Group Person Face".

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar person_id: ID of the person. Required.
    :vartype person_id: str
    :ivar name: User defined name, maximum length is 128. Required.
    :vartype name: str
    :ivar user_data: Optional user defined data. Length should not exceed 16K.
    :vartype user_data: str
    :ivar persisted_face_ids: Face ids of registered faces in the person.
    :vartype persisted_face_ids: list[str]
    """

    person_id: str = rest_field(name="personId", visibility=["read"])
    """ID of the person. Required."""
    name: str = rest_field()
    """User defined name, maximum length is 128. Required."""
    user_data: Optional[str] = rest_field(name="userData")
    """Optional user defined data. Length should not exceed 16K."""
    persisted_face_ids: Optional[List[str]] = rest_field(name="persistedFaceIds")
    """Face ids of registered faces in the person."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        user_data: Optional[str] = None,
        persisted_face_ids: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LargePersonGroupPersonFace(_model_base.Model):
    """Face resource for large person group person.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar persisted_face_id: Face ID of the face. Required.
    :vartype persisted_face_id: str
    :ivar user_data: User-provided data attached to the face. The length limit is 1K.
    :vartype user_data: str
    """

    persisted_face_id: str = rest_field(name="persistedFaceId", visibility=["read"])
    """Face ID of the face. Required."""
    user_data: Optional[str] = rest_field(name="userData")
    """User-provided data attached to the face. The length limit is 1K."""

    @overload
    def __init__(
        self,
        *,
        user_data: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessOutputsTarget(_model_base.Model):
    """The liveness classification for target face.


    :ivar face_rectangle: The face region where the liveness classification was made on. Required.
    :vartype face_rectangle: ~azure.ai.vision.face.models.FaceRectangle
    :ivar file_name: The file name which contains the face rectangle where the liveness
     classification was made on. Required.
    :vartype file_name: str
    :ivar time_offset_within_file: The time offset within the file of the frame which contains the
     face rectangle where the liveness classification was made on. Required.
    :vartype time_offset_within_file: int
    :ivar image_type: The image type which contains the face rectangle where the liveness
     classification was made on. Required. Known values are: "Color", "Infrared", and "Depth".
    :vartype image_type: str or ~azure.ai.vision.face.models.FaceImageType
    """

    face_rectangle: "_models.FaceRectangle" = rest_field(name="faceRectangle")
    """The face region where the liveness classification was made on. Required."""
    file_name: str = rest_field(name="fileName")
    """The file name which contains the face rectangle where the liveness classification was made on.
     Required."""
    time_offset_within_file: int = rest_field(name="timeOffsetWithinFile")
    """The time offset within the file of the frame which contains the face rectangle where the
     liveness classification was made on. Required."""
    image_type: Union[str, "_models.FaceImageType"] = rest_field(name="imageType")
    """The image type which contains the face rectangle where the liveness classification was made on.
     Required. Known values are: \"Color\", \"Infrared\", and \"Depth\"."""

    @overload
    def __init__(
        self,
        *,
        face_rectangle: "_models.FaceRectangle",
        file_name: str,
        time_offset_within_file: int,
        image_type: Union[str, "_models.FaceImageType"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessResponseBody(_model_base.Model):
    """The response body of detect liveness API call.

    :ivar liveness_decision: The liveness classification for the target face. Known values are:
     "uncertain", "realface", and "spoofface".
    :vartype liveness_decision: str or ~azure.ai.vision.face.models.FaceLivenessDecision
    :ivar target: Specific targets used for liveness classification.
    :vartype target: ~azure.ai.vision.face.models.LivenessOutputsTarget
    :ivar model_version_used: The model version used for liveness classification. Known values are:
     "2022-10-15-preview.04" and "2023-12-20-preview.06".
    :vartype model_version_used: str or ~azure.ai.vision.face.models.LivenessModel
    :ivar verify_result: The face verification output. Only available when the request is liveness
     with verify.
    :vartype verify_result: ~azure.ai.vision.face.models.LivenessWithVerifyOutputs
    """

    liveness_decision: Optional[Union[str, "_models.FaceLivenessDecision"]] = rest_field(name="livenessDecision")
    """The liveness classification for the target face. Known values are: \"uncertain\", \"realface\",
     and \"spoofface\"."""
    target: Optional["_models.LivenessOutputsTarget"] = rest_field()
    """Specific targets used for liveness classification."""
    model_version_used: Optional[Union[str, "_models.LivenessModel"]] = rest_field(name="modelVersionUsed")
    """The model version used for liveness classification. Known values are: \"2022-10-15-preview.04\"
     and \"2023-12-20-preview.06\"."""
    verify_result: Optional["_models.LivenessWithVerifyOutputs"] = rest_field(name="verifyResult")
    """The face verification output. Only available when the request is liveness with verify."""

    @overload
    def __init__(
        self,
        *,
        liveness_decision: Optional[Union[str, "_models.FaceLivenessDecision"]] = None,
        target: Optional["_models.LivenessOutputsTarget"] = None,
        model_version_used: Optional[Union[str, "_models.LivenessModel"]] = None,
        verify_result: Optional["_models.LivenessWithVerifyOutputs"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessSession(_model_base.Model):
    """Session result of detect liveness.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: The unique ID to reference this session. Required.
    :vartype id: str
    :ivar created_date_time: DateTime when this session was created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar session_start_date_time: DateTime when this session was started by the client.
    :vartype session_start_date_time: ~datetime.datetime
    :ivar session_expired: Whether or not the session is expired. Required.
    :vartype session_expired: bool
    :ivar device_correlation_id: Unique Guid per each end-user device. This is to provide rate
     limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this
     'deviceCorrelationId' must be null.
    :vartype device_correlation_id: str
    :ivar auth_token_time_to_live_in_seconds: Seconds the session should last for. Range is 60 to
     86400 seconds. Default value is 600.
    :vartype auth_token_time_to_live_in_seconds: int
    :ivar status: The current status of the session. Required. Known values are: "NotStarted",
     "Started", and "ResultAvailable".
    :vartype status: str or ~azure.ai.vision.face.models.FaceSessionStatus
    :ivar result: The latest session audit result only populated if status == 'ResultAvailable'.
    :vartype result: ~azure.ai.vision.face.models.LivenessSessionAuditEntry
    """

    id: str = rest_field(visibility=["read"])
    """The unique ID to reference this session. Required."""
    created_date_time: datetime.datetime = rest_field(name="createdDateTime", format="rfc3339")
    """DateTime when this session was created. Required."""
    session_start_date_time: Optional[datetime.datetime] = rest_field(name="sessionStartDateTime", format="rfc3339")
    """DateTime when this session was started by the client."""
    session_expired: bool = rest_field(name="sessionExpired")
    """Whether or not the session is expired. Required."""
    device_correlation_id: Optional[str] = rest_field(name="deviceCorrelationId")
    """Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If
     'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be
     null."""
    auth_token_time_to_live_in_seconds: Optional[int] = rest_field(name="authTokenTimeToLiveInSeconds")
    """Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600."""
    status: Union[str, "_models.FaceSessionStatus"] = rest_field()
    """The current status of the session. Required. Known values are: \"NotStarted\", \"Started\", and
     \"ResultAvailable\"."""
    result: Optional["_models.LivenessSessionAuditEntry"] = rest_field()
    """The latest session audit result only populated if status == 'ResultAvailable'."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        session_expired: bool,
        status: Union[str, "_models.FaceSessionStatus"],
        session_start_date_time: Optional[datetime.datetime] = None,
        device_correlation_id: Optional[str] = None,
        auth_token_time_to_live_in_seconds: Optional[int] = None,
        result: Optional["_models.LivenessSessionAuditEntry"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessSessionAuditEntry(_model_base.Model):
    """Audit entry for a request in session.


    :ivar id: The unique id to refer to this audit request. Use this id with the 'start' query
     parameter to continue on to the next page of audit results. Required.
    :vartype id: int
    :ivar session_id: The unique sessionId of the created session. It will expire 48 hours after it
     was created or may be deleted sooner using the corresponding session DELETE operation.
     Required.
    :vartype session_id: str
    :ivar request_id: The unique requestId that is returned by the service to the client in the
     'apim-request-id' header. Required.
    :vartype request_id: str
    :ivar client_request_id: The unique clientRequestId that is sent by the client in the
     'client-request-id' header. Required.
    :vartype client_request_id: str
    :ivar received_date_time: The UTC DateTime that the request was received. Required.
    :vartype received_date_time: ~datetime.datetime
    :ivar request: The request of this entry. Required.
    :vartype request: ~azure.ai.vision.face.models.AuditRequestInfo
    :ivar response: The response of this entry. Required.
    :vartype response: ~azure.ai.vision.face.models.AuditLivenessResponseInfo
    :ivar digest: The server calculated digest for this request. If the client reported digest
     differs from the server calculated digest, then the message integrity between the client and
     service has been compromised and the result should not be trusted. For more information, see
     how to guides on how to leverage this value to secure your end-to-end solution. Required.
    :vartype digest: str
    :ivar session_image_id: The image ID of the session request.
    :vartype session_image_id: str
    :ivar verify_image_hash: The sha256 hash of the verify-image in the request.
    :vartype verify_image_hash: str
    """

    id: int = rest_field()
    """The unique id to refer to this audit request. Use this id with the 'start' query parameter to
     continue on to the next page of audit results. Required."""
    session_id: str = rest_field(name="sessionId")
    """The unique sessionId of the created session. It will expire 48 hours after it was created or
     may be deleted sooner using the corresponding session DELETE operation. Required."""
    request_id: str = rest_field(name="requestId")
    """The unique requestId that is returned by the service to the client in the 'apim-request-id'
     header. Required."""
    client_request_id: str = rest_field(name="clientRequestId")
    """The unique clientRequestId that is sent by the client in the 'client-request-id' header.
     Required."""
    received_date_time: datetime.datetime = rest_field(name="receivedDateTime", format="rfc3339")
    """The UTC DateTime that the request was received. Required."""
    request: "_models.AuditRequestInfo" = rest_field()
    """The request of this entry. Required."""
    response: "_models.AuditLivenessResponseInfo" = rest_field()
    """The response of this entry. Required."""
    digest: str = rest_field()
    """The server calculated digest for this request. If the client reported digest differs from the
     server calculated digest, then the message integrity between the client and service has been
     compromised and the result should not be trusted. For more information, see how to guides on
     how to leverage this value to secure your end-to-end solution. Required."""
    session_image_id: Optional[str] = rest_field(name="sessionImageId")
    """The image ID of the session request."""
    verify_image_hash: Optional[str] = rest_field(name="verifyImageHash")
    """The sha256 hash of the verify-image in the request."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        session_id: str,
        request_id: str,
        client_request_id: str,
        received_date_time: datetime.datetime,
        request: "_models.AuditRequestInfo",
        response: "_models.AuditLivenessResponseInfo",
        digest: str,
        session_image_id: Optional[str] = None,
        verify_image_hash: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessSessionItem(_model_base.Model):
    """Session data returned for enumeration.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: The unique ID to reference this session. Required.
    :vartype id: str
    :ivar created_date_time: DateTime when this session was created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar session_start_date_time: DateTime when this session was started by the client.
    :vartype session_start_date_time: ~datetime.datetime
    :ivar session_expired: Whether or not the session is expired. Required.
    :vartype session_expired: bool
    :ivar device_correlation_id: Unique Guid per each end-user device. This is to provide rate
     limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this
     'deviceCorrelationId' must be null.
    :vartype device_correlation_id: str
    :ivar auth_token_time_to_live_in_seconds: Seconds the session should last for. Range is 60 to
     86400 seconds. Default value is 600.
    :vartype auth_token_time_to_live_in_seconds: int
    """

    id: str = rest_field(visibility=["read"])
    """The unique ID to reference this session. Required."""
    created_date_time: datetime.datetime = rest_field(name="createdDateTime", format="rfc3339")
    """DateTime when this session was created. Required."""
    session_start_date_time: Optional[datetime.datetime] = rest_field(name="sessionStartDateTime", format="rfc3339")
    """DateTime when this session was started by the client."""
    session_expired: bool = rest_field(name="sessionExpired")
    """Whether or not the session is expired. Required."""
    device_correlation_id: Optional[str] = rest_field(name="deviceCorrelationId")
    """Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If
     'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be
     null."""
    auth_token_time_to_live_in_seconds: Optional[int] = rest_field(name="authTokenTimeToLiveInSeconds")
    """Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        session_expired: bool,
        session_start_date_time: Optional[datetime.datetime] = None,
        device_correlation_id: Optional[str] = None,
        auth_token_time_to_live_in_seconds: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessWithVerifyImage(_model_base.Model):
    """The detail of face for verification.


    :ivar face_rectangle: The face region where the comparison image's classification was made.
     Required.
    :vartype face_rectangle: ~azure.ai.vision.face.models.FaceRectangle
    :ivar quality_for_recognition: Quality of face image for recognition. Required. Known values
     are: "low", "medium", and "high".
    :vartype quality_for_recognition: str or ~azure.ai.vision.face.models.QualityForRecognition
    """

    face_rectangle: "_models.FaceRectangle" = rest_field(name="faceRectangle")
    """The face region where the comparison image's classification was made. Required."""
    quality_for_recognition: Union[str, "_models.QualityForRecognition"] = rest_field(name="qualityForRecognition")
    """Quality of face image for recognition. Required. Known values are: \"low\", \"medium\", and
     \"high\"."""

    @overload
    def __init__(
        self,
        *,
        face_rectangle: "_models.FaceRectangle",
        quality_for_recognition: Union[str, "_models.QualityForRecognition"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessWithVerifyOutputs(_model_base.Model):
    """The face verification output.


    :ivar verify_image: The detail of face for verification. Required.
    :vartype verify_image: ~azure.ai.vision.face.models.LivenessWithVerifyImage
    :ivar match_confidence: The target face liveness face and comparison image face verification
     confidence. Required.
    :vartype match_confidence: float
    :ivar is_identical: Whether the target liveness face and comparison image face match. Required.
    :vartype is_identical: bool
    """

    verify_image: "_models.LivenessWithVerifyImage" = rest_field(name="verifyImage")
    """The detail of face for verification. Required."""
    match_confidence: float = rest_field(name="matchConfidence")
    """The target face liveness face and comparison image face verification confidence. Required."""
    is_identical: bool = rest_field(name="isIdentical")
    """Whether the target liveness face and comparison image face match. Required."""

    @overload
    def __init__(
        self,
        *,
        verify_image: "_models.LivenessWithVerifyImage",
        match_confidence: float,
        is_identical: bool,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LivenessWithVerifySession(_model_base.Model):
    """Session result of detect liveness with verify.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: The unique ID to reference this session. Required.
    :vartype id: str
    :ivar created_date_time: DateTime when this session was created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar session_start_date_time: DateTime when this session was started by the client.
    :vartype session_start_date_time: ~datetime.datetime
    :ivar session_expired: Whether or not the session is expired. Required.
    :vartype session_expired: bool
    :ivar device_correlation_id: Unique Guid per each end-user device. This is to provide rate
     limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this
     'deviceCorrelationId' must be null.
    :vartype device_correlation_id: str
    :ivar auth_token_time_to_live_in_seconds: Seconds the session should last for. Range is 60 to
     86400 seconds. Default value is 600.
    :vartype auth_token_time_to_live_in_seconds: int
    :ivar status: The current status of the session. Required. Known values are: "NotStarted",
     "Started", and "ResultAvailable".
    :vartype status: str or ~azure.ai.vision.face.models.FaceSessionStatus
    :ivar result: The latest session audit result only populated if status == 'ResultAvailable'.
    :vartype result: ~azure.ai.vision.face.models.LivenessSessionAuditEntry
    """

    id: str = rest_field(visibility=["read"])
    """The unique ID to reference this session. Required."""
    created_date_time: datetime.datetime = rest_field(name="createdDateTime", format="rfc3339")
    """DateTime when this session was created. Required."""
    session_start_date_time: Optional[datetime.datetime] = rest_field(name="sessionStartDateTime", format="rfc3339")
    """DateTime when this session was started by the client."""
    session_expired: bool = rest_field(name="sessionExpired")
    """Whether or not the session is expired. Required."""
    device_correlation_id: Optional[str] = rest_field(name="deviceCorrelationId")
    """Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If
     'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be
     null."""
    auth_token_time_to_live_in_seconds: Optional[int] = rest_field(name="authTokenTimeToLiveInSeconds")
    """Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600."""
    status: Union[str, "_models.FaceSessionStatus"] = rest_field()
    """The current status of the session. Required. Known values are: \"NotStarted\", \"Started\", and
     \"ResultAvailable\"."""
    result: Optional["_models.LivenessSessionAuditEntry"] = rest_field()
    """The latest session audit result only populated if status == 'ResultAvailable'."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        session_expired: bool,
        status: Union[str, "_models.FaceSessionStatus"],
        session_start_date_time: Optional[datetime.datetime] = None,
        device_correlation_id: Optional[str] = None,
        auth_token_time_to_live_in_seconds: Optional[int] = None,
        result: Optional["_models.LivenessSessionAuditEntry"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MaskProperties(_model_base.Model):
    """Properties describing the presence of a mask on a given face.


    :ivar nose_and_mouth_covered: A boolean value indicating whether nose and mouth are covered.
     Required.
    :vartype nose_and_mouth_covered: bool
    :ivar type: Type of the mask. Required. Known values are: "faceMask", "noMask",
     "otherMaskOrOcclusion", and "uncertain".
    :vartype type: str or ~azure.ai.vision.face.models.MaskType
    """

    nose_and_mouth_covered: bool = rest_field(name="noseAndMouthCovered")
    """A boolean value indicating whether nose and mouth are covered. Required."""
    type: Union[str, "_models.MaskType"] = rest_field()
    """Type of the mask. Required. Known values are: \"faceMask\", \"noMask\",
     \"otherMaskOrOcclusion\", and \"uncertain\"."""

    @overload
    def __init__(
        self,
        *,
        nose_and_mouth_covered: bool,
        type: Union[str, "_models.MaskType"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NoiseProperties(_model_base.Model):
    """Properties describing noise level of the image.


    :ivar noise_level: An enum value indicating level of noise. Required. Known values are: "low",
     "medium", and "high".
    :vartype noise_level: str or ~azure.ai.vision.face.models.NoiseLevel
    :ivar value: A number indicating level of noise level ranging from 0 to 1. [0, 0.25) is under
     exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise
     level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise level. Required.
    :vartype value: float
    """

    noise_level: Union[str, "_models.NoiseLevel"] = rest_field(name="noiseLevel")
    """An enum value indicating level of noise. Required. Known values are: \"low\", \"medium\", and
     \"high\"."""
    value: float = rest_field()
    """A number indicating level of noise level ranging from 0 to 1. [0, 0.25) is under exposure.
     [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise level. [0.3,
     0.7) is medium noise level. [0.7, 1] is high noise level. Required."""

    @overload
    def __init__(
        self,
        *,
        noise_level: Union[str, "_models.NoiseLevel"],
        value: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OcclusionProperties(_model_base.Model):
    """Properties describing occlusions on a given face.


    :ivar forehead_occluded: A boolean value indicating whether forehead is occluded. Required.
    :vartype forehead_occluded: bool
    :ivar eye_occluded: A boolean value indicating whether eyes are occluded. Required.
    :vartype eye_occluded: bool
    :ivar mouth_occluded: A boolean value indicating whether the mouth is occluded. Required.
    :vartype mouth_occluded: bool
    """

    forehead_occluded: bool = rest_field(name="foreheadOccluded")
    """A boolean value indicating whether forehead is occluded. Required."""
    eye_occluded: bool = rest_field(name="eyeOccluded")
    """A boolean value indicating whether eyes are occluded. Required."""
    mouth_occluded: bool = rest_field(name="mouthOccluded")
    """A boolean value indicating whether the mouth is occluded. Required."""

    @overload
    def __init__(
        self,
        *,
        forehead_occluded: bool,
        eye_occluded: bool,
        mouth_occluded: bool,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
