# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class WorkspaceConnectionPropertiesV2(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccessKeyAuthTypeWorkspaceConnectionProperties, ApiKeyAuthWorkspaceConnectionProperties, CustomKeysWorkspaceConnectionProperties, ManagedIdentityAuthTypeWorkspaceConnectionProperties, NoneAuthTypeWorkspaceConnectionProperties, PATAuthTypeWorkspaceConnectionProperties, SASAuthTypeWorkspaceConnectionProperties, ServicePrincipalAuthTypeWorkspaceConnectionProperties, UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'AccessKey': 'AccessKeyAuthTypeWorkspaceConnectionProperties', 'ApiKey': 'ApiKeyAuthWorkspaceConnectionProperties', 'CustomKeys': 'CustomKeysWorkspaceConnectionProperties', 'ManagedIdentity': 'ManagedIdentityAuthTypeWorkspaceConnectionProperties', 'None': 'NoneAuthTypeWorkspaceConnectionProperties', 'PAT': 'PATAuthTypeWorkspaceConnectionProperties', 'SAS': 'SASAuthTypeWorkspaceConnectionProperties', 'ServicePrincipal': 'ServicePrincipalAuthTypeWorkspaceConnectionProperties', 'UsernamePassword': 'UsernamePasswordAuthTypeWorkspaceConnectionProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        """
        super(WorkspaceConnectionPropertiesV2, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]
        self.category = kwargs.get('category', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.metadata = None
        self.target = kwargs.get('target', None)


class AccessKeyAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """AccessKeyAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionAccessKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionAccessKey
        """
        super(AccessKeyAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'AccessKey'  # type: str
        self.credentials = kwargs.get('credentials', None)


class DatastoreCredentials(msrest.serialization.Model):
    """Base definition for datastore credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreCredentials, CertificateDatastoreCredentials, NoneDatastoreCredentials, SasDatastoreCredentials, ServicePrincipalDatastoreCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    _subtype_map = {
        'credentials_type': {'AccountKey': 'AccountKeyDatastoreCredentials', 'Certificate': 'CertificateDatastoreCredentials', 'None': 'NoneDatastoreCredentials', 'Sas': 'SasDatastoreCredentials', 'ServicePrincipal': 'ServicePrincipalDatastoreCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = None  # type: Optional[str]


class AccountKeyDatastoreCredentials(DatastoreCredentials):
    """Account key datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage account secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'AccountKeyDatastoreSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage account secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
        """
        super(AccountKeyDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'AccountKey'  # type: str
        self.secrets = kwargs['secrets']


class DatastoreSecrets(msrest.serialization.Model):
    """Base definition for datastore secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreSecrets, CertificateDatastoreSecrets, SasDatastoreSecrets, ServicePrincipalDatastoreSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
    }

    _subtype_map = {
        'secrets_type': {'AccountKey': 'AccountKeyDatastoreSecrets', 'Certificate': 'CertificateDatastoreSecrets', 'Sas': 'SasDatastoreSecrets', 'ServicePrincipal': 'ServicePrincipalDatastoreSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = None  # type: Optional[str]


class AccountKeyDatastoreSecrets(DatastoreSecrets):
    """Datastore account key secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar key: Storage account key.
    :vartype key: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key: Storage account key.
        :paramtype key: str
        """
        super(AccountKeyDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'AccountKey'  # type: str
        self.key = kwargs.get('key', None)


class AmlOperation(msrest.serialization.Model):
    """Azure Machine Learning team account REST API operation.

    :ivar display: Gets or sets display name of operation.
    :vartype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: bool
    :ivar name: Gets or sets operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar origin: The intended executor of the operation: user/system.
    :vartype origin: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword display: Gets or sets display name of operation.
        :paramtype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation applies to data-plane.
        :paramtype is_data_action: bool
        :keyword name: Gets or sets operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword origin: The intended executor of the operation: user/system.
        :paramtype origin: str
        """
        super(AmlOperation, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.name = kwargs.get('name', None)
        self.origin = kwargs.get('origin', None)


class AmlOperationListResult(msrest.serialization.Model):
    """AmlOperationListResult.

    :ivar value: Gets or sets list of AML team account operations supported by the
     AML team account resource provider.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlOperation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlOperation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Gets or sets list of AML team account operations supported by the
         AML team account resource provider.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.AmlOperation]
        """
        super(AmlOperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class IdentityConfiguration(msrest.serialization.Model):
    """Base definition for identity configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlToken, ManagedIdentity, UserIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    _subtype_map = {
        'identity_type': {'AMLToken': 'AmlToken', 'Managed': 'ManagedIdentity', 'UserIdentity': 'UserIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IdentityConfiguration, self).__init__(**kwargs)
        self.identity_type = None  # type: Optional[str]


class AmlToken(IdentityConfiguration):
    """AML Token identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlToken, self).__init__(**kwargs)
        self.identity_type = 'AMLToken'  # type: str


class AmlUserFeature(msrest.serialization.Model):
    """Features enabled for a workspace.

    :ivar id: Specifies the feature ID.
    :vartype id: str
    :ivar display_name: Specifies the feature name.
    :vartype display_name: str
    :ivar description: Describes the feature for user experience.
    :vartype description: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Specifies the feature ID.
        :paramtype id: str
        :keyword display_name: Specifies the feature name.
        :paramtype display_name: str
        :keyword description: Describes the feature for user experience.
        :paramtype description: str
        """
        super(AmlUserFeature, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)


class ApiKeyAuthWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """This connection type covers the generic ApiKey auth connection categories, for examples:
AzureOpenAI:
    Category:= AzureOpenAI
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {ApiKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= {ApiBase}

CognitiveService:
    Category:= CognitiveService
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {SubscriptionKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= ServiceRegion={serviceRegion}

CognitiveSearch:
    Category:= CognitiveSearch
    AuthType:= ApiKey (as type discriminator)
    Credentials:= {Key} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
    Target:= {Endpoint}

Use Metadata property bag for ApiType, ApiVersion, Kind and other metadata fields.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionApiKey
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionApiKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionApiKey
        """
        super(ApiKeyAuthWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'ApiKey'  # type: str
        self.credentials = kwargs.get('credentials', None)


class ResourceBase(msrest.serialization.Model):
    """ResourceBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(ResourceBase, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)
        self.tags = kwargs.get('tags', None)


class AssetBase(ResourceBase):
    """AssetBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetBase, self).__init__(**kwargs)
        self.is_anonymous = kwargs.get('is_anonymous', False)
        self.is_archived = kwargs.get('is_archived', False)


class AssetContainer(ResourceBase):
    """AssetContainer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetContainer, self).__init__(**kwargs)
        self.is_archived = kwargs.get('is_archived', False)
        self.latest_version = None
        self.next_version = None


class AssetJobInput(msrest.serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(AssetJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']


class AssetJobOutput(msrest.serialization.Model):
    """Asset output type.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super(AssetJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)


class AssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataPathAssetReference, IdAssetReference, OutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'DataPathAssetReference', 'Id': 'IdAssetReference', 'OutputPath': 'OutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class DatastoreDetails(ResourceBase):
    """Base definition for datastore contents configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobDatastore, AzureDataLakeGen1Datastore, AzureDataLakeGen2Datastore, AzureFileDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    _subtype_map = {
        'datastore_type': {'AzureBlob': 'AzureBlobDatastore', 'AzureDataLakeGen1': 'AzureDataLakeGen1Datastore', 'AzureDataLakeGen2': 'AzureDataLakeGen2Datastore', 'AzureFile': 'AzureFileDatastore'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        """
        super(DatastoreDetails, self).__init__(**kwargs)
        self.credentials = kwargs['credentials']
        self.datastore_type = 'DatastoreDetails'  # type: str
        self.is_default = None


class AzureBlobDatastore(DatastoreDetails):
    """Azure Blob datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Storage account name.
    :vartype account_name: str
    :ivar container_name: Storage account container name.
    :vartype container_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        :keyword container_name: Storage account container name.
        :paramtype container_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureBlobDatastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureBlob'  # type: str
        self.account_name = kwargs.get('account_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.endpoint = kwargs.get('endpoint', None)
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class AzureDataLakeGen1Datastore(DatastoreDetails):
    """Azure Data Lake Gen1 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    :ivar store_name: Required. [Required] Azure Data Lake store name.
    :vartype store_name: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'store_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        :keyword store_name: Required. [Required] Azure Data Lake store name.
        :paramtype store_name: str
        """
        super(AzureDataLakeGen1Datastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureDataLakeGen1'  # type: str
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)
        self.store_name = kwargs['store_name']


class AzureDataLakeGen2Datastore(DatastoreDetails):
    """Azure Data Lake Gen2 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
    :vartype filesystem: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'filesystem': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
        :paramtype filesystem: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureDataLakeGen2Datastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureDataLakeGen2'  # type: str
        self.account_name = kwargs['account_name']
        self.endpoint = kwargs.get('endpoint', None)
        self.filesystem = kwargs['filesystem']
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class AzureFileDatastore(DatastoreDetails):
    """Azure File datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar file_share_name: Required. [Required] TODO - File share name.
    :vartype file_share_name: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'file_share_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'file_share_name': {'key': 'fileShareName', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword file_share_name: Required. [Required] TODO - File share name.
        :paramtype file_share_name: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureFileDatastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureFile'  # type: str
        self.account_name = kwargs['account_name']
        self.endpoint = kwargs.get('endpoint', None)
        self.file_share_name = kwargs['file_share_name']
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class EarlyTerminationPolicy(msrest.serialization.Model):
    """Early termination policies enable canceling poor-performing runs before they complete.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BanditPolicy, MedianStoppingPolicy, TruncationSelectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    _subtype_map = {
        'policy_type': {'Bandit': 'BanditPolicy', 'MedianStopping': 'MedianStoppingPolicy', 'TruncationSelection': 'TruncationSelectionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(EarlyTerminationPolicy, self).__init__(**kwargs)
        self.delay_evaluation = kwargs.get('delay_evaluation', 0)
        self.evaluation_interval = kwargs.get('evaluation_interval', 0)
        self.policy_type = None  # type: Optional[str]


class BanditPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar slack_amount: Absolute distance allowed from the best performing run.
    :vartype slack_amount: float
    :ivar slack_factor: Ratio of the allowed distance from the best performing run.
    :vartype slack_factor: float
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'slack_amount': {'key': 'slackAmount', 'type': 'float'},
        'slack_factor': {'key': 'slackFactor', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword slack_amount: Absolute distance allowed from the best performing run.
        :paramtype slack_amount: float
        :keyword slack_factor: Ratio of the allowed distance from the best performing run.
        :paramtype slack_factor: float
        """
        super(BanditPolicy, self).__init__(**kwargs)
        self.policy_type = 'Bandit'  # type: str
        self.slack_amount = kwargs.get('slack_amount', 0)
        self.slack_factor = kwargs.get('slack_factor', 0)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class BatchDeploymentData(TrackedResource):
    """BatchDeploymentData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchDeploymentDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchDeploymentData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class EndpointDeploymentPropertiesBase(msrest.serialization.Model):
    """Base definition for endpoint deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointDeploymentPropertiesBase, self).__init__(**kwargs)
        self.code_configuration = kwargs.get('code_configuration', None)
        self.description = kwargs.get('description', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.properties = kwargs.get('properties', None)


class BatchDeploymentDetails(EndpointDeploymentPropertiesBase):
    """Batch inference settings per deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar compute: Compute target for batch inference operation.
    :vartype compute: str
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar resources: Indicates compute configuration for the job.
     If not provided, will default to the defaults defined in ResourceConfiguration.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    :ivar retry_settings: Retry Settings for the batch inference operation.
     If not provided, will default to the defaults defined in BatchRetrySettings.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'compute': {'key': 'compute', 'type': 'str'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'AssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
        'retry_settings': {'key': 'retrySettings', 'type': 'BatchRetrySettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: Compute target for batch inference operation.
        :paramtype compute: str
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword resources: Indicates compute configuration for the job.
         If not provided, will default to the defaults defined in ResourceConfiguration.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        :keyword retry_settings: Retry Settings for the batch inference operation.
         If not provided, will default to the defaults defined in BatchRetrySettings.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        """
        super(BatchDeploymentDetails, self).__init__(**kwargs)
        self.compute = kwargs.get('compute', None)
        self.error_threshold = kwargs.get('error_threshold', -1)
        self.logging_level = kwargs.get('logging_level', None)
        self.max_concurrency_per_instance = kwargs.get('max_concurrency_per_instance', 1)
        self.mini_batch_size = kwargs.get('mini_batch_size', 10)
        self.model = kwargs.get('model', None)
        self.output_action = kwargs.get('output_action', None)
        self.output_file_name = kwargs.get('output_file_name', "predictions.csv")
        self.provisioning_state = None
        self.resources = kwargs.get('resources', None)
        self.retry_settings = kwargs.get('retry_settings', None)


class BatchDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchDeployment entities.

    :ivar next_link: The link to the next page of BatchDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchDeploymentData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchDeploymentData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchDeployment objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchDeploymentData]
        """
        super(BatchDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class BatchEndpointData(TrackedResource):
    """BatchEndpointData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchEndpointDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchEndpointData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class BatchEndpointDefaults(msrest.serialization.Model):
    """Batch endpoint default values.

    :ivar deployment_name: Name of the deployment that will be default for the endpoint.
     This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
    :vartype deployment_name: str
    """

    _attribute_map = {
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword deployment_name: Name of the deployment that will be default for the endpoint.
         This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        :paramtype deployment_name: str
        """
        super(BatchEndpointDefaults, self).__init__(**kwargs)
        self.deployment_name = kwargs.get('deployment_name', None)


class EndpointPropertiesBase(msrest.serialization.Model):
    """Inference Endpoint base definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointPropertiesBase, self).__init__(**kwargs)
        self.auth_mode = kwargs['auth_mode']
        self.description = kwargs.get('description', None)
        self.keys = kwargs.get('keys', None)
        self.properties = kwargs.get('properties', None)
        self.scoring_uri = None
        self.swagger_uri = None


class BatchEndpointDetails(EndpointPropertiesBase):
    """Batch endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(BatchEndpointDetails, self).__init__(**kwargs)
        self.defaults = kwargs.get('defaults', None)
        self.provisioning_state = None


class BatchEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchEndpoint entities.

    :ivar next_link: The link to the next page of BatchEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpointData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchEndpointData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpointData]
        """
        super(BatchEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class BatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(BatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = kwargs.get('max_retries', 3)
        self.timeout = kwargs.get('timeout', "PT30S")


class SamplingAlgorithm(msrest.serialization.Model):
    """The Sampling Algorithm used to generate hyperparameter values, along with properties to
configure the algorithm.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BayesianSamplingAlgorithm, GridSamplingAlgorithm, RandomSamplingAlgorithm.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    _subtype_map = {
        'sampling_algorithm_type': {'Bayesian': 'BayesianSamplingAlgorithm', 'Grid': 'GridSamplingAlgorithm', 'Random': 'RandomSamplingAlgorithm'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = None  # type: Optional[str]


class BayesianSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values based on previous values.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BayesianSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Bayesian'  # type: str


class BuildContext(msrest.serialization.Model):
    """Configuration settings for Docker build context.

    All required parameters must be populated in order to send to Azure.

    :ivar context_uri: Required. [Required] URI of the Docker build context used to build the
     image. Supports blob URIs on environment creation and may return blob or Git URIs.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
    :vartype context_uri: str
    :ivar dockerfile_path: Path to the Dockerfile in the build context.
    
    
     .. raw:: html
    
        <seealso href="https://docs.docker.com/engine/reference/builder/" />.
    :vartype dockerfile_path: str
    """

    _validation = {
        'context_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'context_uri': {'key': 'contextUri', 'type': 'str'},
        'dockerfile_path': {'key': 'dockerfilePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword context_uri: Required. [Required] URI of the Docker build context used to build the
         image. Supports blob URIs on environment creation and may return blob or Git URIs.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
        :paramtype context_uri: str
        :keyword dockerfile_path: Path to the Dockerfile in the build context.
        
        
         .. raw:: html
        
            <seealso href="https://docs.docker.com/engine/reference/builder/" />.
        :paramtype dockerfile_path: str
        """
        super(BuildContext, self).__init__(**kwargs)
        self.context_uri = kwargs['context_uri']
        self.dockerfile_path = kwargs.get('dockerfile_path', "Dockerfile")


class CertificateDatastoreCredentials(DatastoreCredentials):
    """Certificate datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    :ivar thumbprint: Required. [Required] Thumbprint of the certificate used for authentication.
    :vartype thumbprint: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
        'thumbprint': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'CertificateDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        :keyword thumbprint: Required. [Required] Thumbprint of the certificate used for
         authentication.
        :paramtype thumbprint: str
        """
        super(CertificateDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Certificate'  # type: str
        self.authority_url = kwargs.get('authority_url', None)
        self.client_id = kwargs['client_id']
        self.resource_url = kwargs.get('resource_url', None)
        self.secrets = kwargs['secrets']
        self.tenant_id = kwargs['tenant_id']
        self.thumbprint = kwargs['thumbprint']


class CertificateDatastoreSecrets(DatastoreSecrets):
    """Datastore certificate secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar certificate: Service principal certificate.
    :vartype certificate: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword certificate: Service principal certificate.
        :paramtype certificate: str
        """
        super(CertificateDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Certificate'  # type: str
        self.certificate = kwargs.get('certificate', None)


class CodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(CodeConfiguration, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.scoring_script = kwargs['scoring_script']


class CodeContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerDetails
        """
        super(CodeContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class CodeContainerDetails(AssetContainer):
    """Container for code asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(CodeContainerDetails, self).__init__(**kwargs)


class CodeContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeContainer entities.

    :ivar next_link: The link to the next page of CodeContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeContainerData]
        """
        super(CodeContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class CodeVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionDetails
        """
        super(CodeVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class CodeVersionDetails(AssetBase):
    """Code asset version details.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar code_uri: Uri where code is located.
    :vartype code_uri: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'code_uri': {'key': 'codeUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword code_uri: Uri where code is located.
        :paramtype code_uri: str
        """
        super(CodeVersionDetails, self).__init__(**kwargs)
        self.code_uri = kwargs.get('code_uri', None)


class CodeVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeVersion entities.

    :ivar next_link: The link to the next page of CodeVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeVersionData]
        """
        super(CodeVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class JobBaseDetails(ResourceBase):
    """Base definition for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CommandJob, PipelineJob, SweepJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'Command': 'CommandJob', 'Pipeline': 'PipelineJob', 'Sweep': 'SweepJob'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        """
        super(JobBaseDetails, self).__init__(**kwargs)
        self.compute_id = kwargs.get('compute_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.experiment_name = kwargs.get('experiment_name', "Default")
        self.identity = kwargs.get('identity', None)
        self.is_archived = kwargs.get('is_archived', False)
        self.job_type = 'JobBaseDetails'  # type: str
        self.services = kwargs.get('services', None)
        self.status = None


class CommandJob(JobBaseDetails):
    """Command job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Command Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar parameters: Input parameters.
    :vartype parameters: any
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'CommandJobLimits'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Command Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        """
        super(CommandJob, self).__init__(**kwargs)
        self.job_type = 'Command'  # type: str
        self.code_id = kwargs.get('code_id', None)
        self.command = kwargs['command']
        self.distribution = kwargs.get('distribution', None)
        self.environment_id = kwargs['environment_id']
        self.environment_variables = kwargs.get('environment_variables', None)
        self.inputs = kwargs.get('inputs', None)
        self.limits = kwargs.get('limits', None)
        self.outputs = kwargs.get('outputs', None)
        self.parameters = None
        self.resources = kwargs.get('resources', None)


class JobLimits(msrest.serialization.Model):
    """JobLimits.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CommandJobLimits, SweepJobLimits.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    _subtype_map = {
        'job_limits_type': {'Command': 'CommandJobLimits', 'Sweep': 'SweepJobLimits'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(JobLimits, self).__init__(**kwargs)
        self.job_limits_type = None  # type: Optional[str]
        self.timeout = kwargs.get('timeout', None)


class CommandJobLimits(JobLimits):
    """Command Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(CommandJobLimits, self).__init__(**kwargs)
        self.job_limits_type = 'Command'  # type: str


class ComponentContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerDetails
        """
        super(ComponentContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ComponentContainerDetails(AssetContainer):
    """Component container definition.


.. raw:: html

   <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ComponentContainerDetails, self).__init__(**kwargs)


class ComponentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentContainer entities.

    :ivar next_link: The link to the next page of ComponentContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentContainer objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainerData]
        """
        super(ComponentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ComponentVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionDetails
        """
        super(ComponentVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ComponentVersionDetails(AssetBase):
    """Definition of a component version: defines resources that span component types.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar component_spec: Defines Component definition details.
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
     />.
    :vartype component_spec: any
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'component_spec': {'key': 'componentSpec', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword component_spec: Defines Component definition details.
        
        
         .. raw:: html
        
            <see
         href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
         />.
        :paramtype component_spec: any
        """
        super(ComponentVersionDetails, self).__init__(**kwargs)
        self.component_spec = kwargs.get('component_spec', None)


class ComponentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentVersion entities.

    :ivar next_link: The link to the next page of ComponentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersionData]
        """
        super(ComponentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ComputeRuntimeDto(msrest.serialization.Model):
    """ComputeRuntimeDto.

    :ivar spark_runtime_version:
    :vartype spark_runtime_version: str
    """

    _attribute_map = {
        'spark_runtime_version': {'key': 'sparkRuntimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword spark_runtime_version:
        :paramtype spark_runtime_version: str
        """
        super(ComputeRuntimeDto, self).__init__(**kwargs)
        self.spark_runtime_version = kwargs.get('spark_runtime_version', None)


class ContainerResourceRequirements(msrest.serialization.Model):
    """Resource requirements for each container instance within an online deployment.

    :ivar container_resource_limits: Container resource limit info:.
    :vartype container_resource_limits:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    :ivar container_resource_requests: Container resource request info:.
    :vartype container_resource_requests:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    """

    _attribute_map = {
        'container_resource_limits': {'key': 'containerResourceLimits', 'type': 'ContainerResourceSettings'},
        'container_resource_requests': {'key': 'containerResourceRequests', 'type': 'ContainerResourceSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_resource_limits: Container resource limit info:.
        :paramtype container_resource_limits:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        :keyword container_resource_requests: Container resource request info:.
        :paramtype container_resource_requests:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.container_resource_limits = kwargs.get('container_resource_limits', None)
        self.container_resource_requests = kwargs.get('container_resource_requests', None)


class ContainerResourceSettings(msrest.serialization.Model):
    """ContainerResourceSettings.

    :ivar cpu: Number of vCPUs request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: str
    :ivar gpu: Number of Nvidia GPU cards request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype gpu: str
    :ivar memory: Memory size request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory: str
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'memory': {'key': 'memory', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword cpu: Number of vCPUs request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: str
        :keyword gpu: Number of Nvidia GPU cards request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype gpu: str
        :keyword memory: Memory size request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory: str
        """
        super(ContainerResourceSettings, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', None)
        self.gpu = kwargs.get('gpu', None)
        self.memory = kwargs.get('memory', None)


class CosmosDbSettings(msrest.serialization.Model):
    """CosmosDbSettings.

    :ivar collections_throughput:
    :vartype collections_throughput: int
    """

    _attribute_map = {
        'collections_throughput': {'key': 'collectionsThroughput', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword collections_throughput:
        :paramtype collections_throughput: int
        """
        super(CosmosDbSettings, self).__init__(**kwargs)
        self.collections_throughput = kwargs.get('collections_throughput', None)


class CustomKeys(msrest.serialization.Model):
    """CustomKeys.

    :ivar keys: Dictionary of :code:`<string>`.
    :vartype keys: dict[str, str]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword keys: Dictionary of :code:`<string>`.
        :paramtype keys: dict[str, str]
        """
        super(CustomKeys, self).__init__(**kwargs)
        self.keys = kwargs.get('keys', None)


class CustomKeysWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """Category:= CustomKeys
AuthType:= CustomKeys (as type discriminator)
Credentials:= {CustomKeys} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.CustomKeys
Target:= {any value}
Use Metadata property bag for ApiVersion and other metadata fields.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.CustomKeys
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CustomKeys'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.CustomKeys
        """
        super(CustomKeysWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'CustomKeys'  # type: str
        self.credentials = kwargs.get('credentials', None)


class JobInput(msrest.serialization.Model):
    """Command job definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput, TritonModelJobInput, UriFileJobInput, UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_input_type': {'custom_model': 'CustomModelJobInput', 'literal': 'LiteralJobInput', 'mlflow_model': 'MLFlowModelJobInput', 'mltable': 'MLTableJobInput', 'triton_model': 'TritonModelJobInput', 'uri_file': 'UriFileJobInput', 'uri_folder': 'UriFolderJobInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(JobInput, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.job_input_type = None  # type: Optional[str]


class CustomModelJobInput(JobInput, AssetJobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(CustomModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'custom_model'  # type: str
        self.description = kwargs.get('description', None)


class JobOutput(msrest.serialization.Model):
    """Job output definition container information on where to find job output/logs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput, UriFileJobOutput, UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_output_type': {'custom_model': 'CustomModelJobOutput', 'mlflow_model': 'MLFlowModelJobOutput', 'mltable': 'MLTableJobOutput', 'triton_model': 'TritonModelJobOutput', 'uri_file': 'UriFileJobOutput', 'uri_folder': 'UriFolderJobOutput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(JobOutput, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.job_output_type = None  # type: Optional[str]


class CustomModelJobOutput(JobOutput, AssetJobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(CustomModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'custom_model'  # type: str
        self.description = kwargs.get('description', None)


class DataContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataContainerDetails
        """
        super(DataContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DataContainerDetails(AssetContainer):
    """Container for data asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar data_type: Required. [Required] Specifies the type of data. Possible values include:
     "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'data_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_type: Required. [Required] Specifies the type of data. Possible values include:
         "uri_file", "uri_folder", "mltable".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
        """
        super(DataContainerDetails, self).__init__(**kwargs)
        self.data_type = kwargs['data_type']


class DataContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataContainer entities.

    :ivar next_link: The link to the next page of DataContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainerData]
        """
        super(DataContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class DataPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(DataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = kwargs.get('datastore_id', None)
        self.path = kwargs.get('path', None)


class DatastoreData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatastoreDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DatastoreDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatastoreDetails
        """
        super(DatastoreData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DatastoreResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Datastore entities.

    :ivar next_link: The link to the next page of Datastore objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Datastore.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DatastoreData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DatastoreData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Datastore objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Datastore.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DatastoreData]
        """
        super(DatastoreResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class DataVersionBaseData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataVersionBaseDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseDetails
        """
        super(DataVersionBaseData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DataVersionBaseDetails(AssetBase):
    """Data version base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MLTableData, UriFileDataVersion, UriFolderDataVersion.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    _subtype_map = {
        'data_type': {'mltable': 'MLTableData', 'uri_file': 'UriFileDataVersion', 'uri_folder': 'UriFolderDataVersion'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(DataVersionBaseDetails, self).__init__(**kwargs)
        self.data_type = 'DataVersionBaseDetails'  # type: str
        self.data_uri = kwargs['data_uri']


class DataVersionBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataVersionBase entities.

    :ivar next_link: The link to the next page of DataVersionBase objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataVersionBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBaseData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataVersionBaseData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataVersionBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataVersionBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBaseData]
        """
        super(DataVersionBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineScaleSettings(msrest.serialization.Model):
    """Online deployment scaling configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DefaultScaleSettings, TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    _subtype_map = {
        'scale_type': {'Default': 'DefaultScaleSettings', 'TargetUtilization': 'TargetUtilizationScaleSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OnlineScaleSettings, self).__init__(**kwargs)
        self.scale_type = None  # type: Optional[str]


class DefaultScaleSettings(OnlineScaleSettings):
    """DefaultScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'Default'  # type: str


class DeploymentLogs(msrest.serialization.Model):
    """DeploymentLogs.

    :ivar content: The retrieved online deployment logs.
    :vartype content: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: The retrieved online deployment logs.
        :paramtype content: str
        """
        super(DeploymentLogs, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class DeploymentLogsRequest(msrest.serialization.Model):
    """DeploymentLogsRequest.

    :ivar container_type: The type of container to retrieve logs from. Possible values include:
     "StorageInitializer", "InferenceServer".
    :vartype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
    :ivar tail: The maximum number of lines to tail.
    :vartype tail: int
    """

    _attribute_map = {
        'container_type': {'key': 'containerType', 'type': 'str'},
        'tail': {'key': 'tail', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_type: The type of container to retrieve logs from. Possible values include:
         "StorageInitializer", "InferenceServer".
        :paramtype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
        :keyword tail: The maximum number of lines to tail.
        :paramtype tail: int
        """
        super(DeploymentLogsRequest, self).__init__(**kwargs)
        self.container_type = kwargs.get('container_type', None)
        self.tail = kwargs.get('tail', None)


class DiagnoseRequestProperties(msrest.serialization.Model):
    """DiagnoseRequestProperties.

    :ivar application_insights: Setting for diagnosing dependent application insights.
    :vartype application_insights: dict[str, any]
    :ivar container_registry: Setting for diagnosing dependent container registry.
    :vartype container_registry: dict[str, any]
    :ivar dns_resolution: Setting for diagnosing dns resolution.
    :vartype dns_resolution: dict[str, any]
    :ivar key_vault: Setting for diagnosing dependent key vault.
    :vartype key_vault: dict[str, any]
    :ivar nsg: Setting for diagnosing network security group.
    :vartype nsg: dict[str, any]
    :ivar others: Setting for diagnosing unclassified category of problems.
    :vartype others: dict[str, any]
    :ivar resource_lock: Setting for diagnosing resource lock.
    :vartype resource_lock: dict[str, any]
    :ivar storage_account: Setting for diagnosing dependent storage account.
    :vartype storage_account: dict[str, any]
    :ivar udr: Setting for diagnosing user defined routing.
    :vartype udr: dict[str, any]
    """

    _attribute_map = {
        'application_insights': {'key': 'applicationInsights', 'type': '{object}'},
        'container_registry': {'key': 'containerRegistry', 'type': '{object}'},
        'dns_resolution': {'key': 'dnsResolution', 'type': '{object}'},
        'key_vault': {'key': 'keyVault', 'type': '{object}'},
        'nsg': {'key': 'nsg', 'type': '{object}'},
        'others': {'key': 'others', 'type': '{object}'},
        'resource_lock': {'key': 'resourceLock', 'type': '{object}'},
        'storage_account': {'key': 'storageAccount', 'type': '{object}'},
        'udr': {'key': 'udr', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword application_insights: Setting for diagnosing dependent application insights.
        :paramtype application_insights: dict[str, any]
        :keyword container_registry: Setting for diagnosing dependent container registry.
        :paramtype container_registry: dict[str, any]
        :keyword dns_resolution: Setting for diagnosing dns resolution.
        :paramtype dns_resolution: dict[str, any]
        :keyword key_vault: Setting for diagnosing dependent key vault.
        :paramtype key_vault: dict[str, any]
        :keyword nsg: Setting for diagnosing network security group.
        :paramtype nsg: dict[str, any]
        :keyword others: Setting for diagnosing unclassified category of problems.
        :paramtype others: dict[str, any]
        :keyword resource_lock: Setting for diagnosing resource lock.
        :paramtype resource_lock: dict[str, any]
        :keyword storage_account: Setting for diagnosing dependent storage account.
        :paramtype storage_account: dict[str, any]
        :keyword udr: Setting for diagnosing user defined routing.
        :paramtype udr: dict[str, any]
        """
        super(DiagnoseRequestProperties, self).__init__(**kwargs)
        self.application_insights = kwargs.get('application_insights', None)
        self.container_registry = kwargs.get('container_registry', None)
        self.dns_resolution = kwargs.get('dns_resolution', None)
        self.key_vault = kwargs.get('key_vault', None)
        self.nsg = kwargs.get('nsg', None)
        self.others = kwargs.get('others', None)
        self.resource_lock = kwargs.get('resource_lock', None)
        self.storage_account = kwargs.get('storage_account', None)
        self.udr = kwargs.get('udr', None)


class DiagnoseResponseResult(msrest.serialization.Model):
    """DiagnoseResponseResult.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseResponseResultValue'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
        """
        super(DiagnoseResponseResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DiagnoseResponseResultValue(msrest.serialization.Model):
    """DiagnoseResponseResultValue.

    :ivar user_defined_route_results:
    :vartype user_defined_route_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar network_security_rule_results:
    :vartype network_security_rule_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar resource_lock_results:
    :vartype resource_lock_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar dns_resolution_results:
    :vartype dns_resolution_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar storage_account_results:
    :vartype storage_account_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar key_vault_results:
    :vartype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar container_registry_results:
    :vartype container_registry_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar application_insights_results:
    :vartype application_insights_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar other_results:
    :vartype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    """

    _attribute_map = {
        'user_defined_route_results': {'key': 'userDefinedRouteResults', 'type': '[DiagnoseResult]'},
        'network_security_rule_results': {'key': 'networkSecurityRuleResults', 'type': '[DiagnoseResult]'},
        'resource_lock_results': {'key': 'resourceLockResults', 'type': '[DiagnoseResult]'},
        'dns_resolution_results': {'key': 'dnsResolutionResults', 'type': '[DiagnoseResult]'},
        'storage_account_results': {'key': 'storageAccountResults', 'type': '[DiagnoseResult]'},
        'key_vault_results': {'key': 'keyVaultResults', 'type': '[DiagnoseResult]'},
        'container_registry_results': {'key': 'containerRegistryResults', 'type': '[DiagnoseResult]'},
        'application_insights_results': {'key': 'applicationInsightsResults', 'type': '[DiagnoseResult]'},
        'other_results': {'key': 'otherResults', 'type': '[DiagnoseResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_defined_route_results:
        :paramtype user_defined_route_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword network_security_rule_results:
        :paramtype network_security_rule_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword resource_lock_results:
        :paramtype resource_lock_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword dns_resolution_results:
        :paramtype dns_resolution_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword storage_account_results:
        :paramtype storage_account_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword key_vault_results:
        :paramtype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword container_registry_results:
        :paramtype container_registry_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword application_insights_results:
        :paramtype application_insights_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword other_results:
        :paramtype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        """
        super(DiagnoseResponseResultValue, self).__init__(**kwargs)
        self.user_defined_route_results = kwargs.get('user_defined_route_results', None)
        self.network_security_rule_results = kwargs.get('network_security_rule_results', None)
        self.resource_lock_results = kwargs.get('resource_lock_results', None)
        self.dns_resolution_results = kwargs.get('dns_resolution_results', None)
        self.storage_account_results = kwargs.get('storage_account_results', None)
        self.key_vault_results = kwargs.get('key_vault_results', None)
        self.container_registry_results = kwargs.get('container_registry_results', None)
        self.application_insights_results = kwargs.get('application_insights_results', None)
        self.other_results = kwargs.get('other_results', None)


class DiagnoseResult(msrest.serialization.Model):
    """DiagnoseResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code for workspace setup error.
    :vartype code: str
    :ivar level: Level of workspace setup error. Possible values include: "Warning", "Error",
     "Information".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.DiagnoseResultLevel
    :ivar message: Message of workspace setup error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DiagnoseResult, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.message = None


class DiagnoseWorkspaceParameters(msrest.serialization.Model):
    """Parameters to diagnose a workspace.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseRequestProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
        """
        super(DiagnoseWorkspaceParameters, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DistributionConfiguration(msrest.serialization.Model):
    """Base definition for job distribution configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Mpi, PyTorch, TensorFlow.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
    }

    _subtype_map = {
        'distribution_type': {'Mpi': 'Mpi', 'PyTorch': 'PyTorch', 'TensorFlow': 'TensorFlow'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DistributionConfiguration, self).__init__(**kwargs)
        self.distribution_type = None  # type: Optional[str]


class EncryptionKeyVaultUpdateProperties(msrest.serialization.Model):
    """EncryptionKeyVaultUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_identifier: Required.
    :vartype key_identifier: str
    """

    _validation = {
        'key_identifier': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key_identifier: Required.
        :paramtype key_identifier: str
        """
        super(EncryptionKeyVaultUpdateProperties, self).__init__(**kwargs)
        self.key_identifier = kwargs['key_identifier']


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :ivar cosmos_db_resource_id: The byok cosmosdb account that customer brings to store customer's
     data
     with encryption.
    :vartype cosmos_db_resource_id: str
    :ivar identity: Identity to be used with the keyVault.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
    :ivar key_vault_properties: Required. KeyVault details to do the encryption.
    :vartype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
    :ivar search_account_resource_id: The byok search account that customer brings to store
     customer's data
     with encryption.
    :vartype search_account_resource_id: str
    :ivar status: Required. Possible values include: "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :ivar storage_account_resource_id: The byok storage account that customer brings to store
     customer's data
     with encryption.
    :vartype storage_account_resource_id: str
    """

    _validation = {
        'key_vault_properties': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'cosmos_db_resource_id': {'key': 'cosmosDbResourceId', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityForCmk'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
        'search_account_resource_id': {'key': 'searchAccountResourceId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'storage_account_resource_id': {'key': 'storageAccountResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword cosmos_db_resource_id: The byok cosmosdb account that customer brings to store
         customer's data
         with encryption.
        :paramtype cosmos_db_resource_id: str
        :keyword identity: Identity to be used with the keyVault.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
        :keyword key_vault_properties: Required. KeyVault details to do the encryption.
        :paramtype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
        :keyword search_account_resource_id: The byok search account that customer brings to store
         customer's data
         with encryption.
        :paramtype search_account_resource_id: str
        :keyword status: Required. Possible values include: "Enabled", "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
        :keyword storage_account_resource_id: The byok storage account that customer brings to store
         customer's data
         with encryption.
        :paramtype storage_account_resource_id: str
        """
        super(EncryptionProperty, self).__init__(**kwargs)
        self.cosmos_db_resource_id = kwargs.get('cosmos_db_resource_id', None)
        self.identity = kwargs.get('identity', None)
        self.key_vault_properties = kwargs['key_vault_properties']
        self.search_account_resource_id = kwargs.get('search_account_resource_id', None)
        self.status = kwargs['status']
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)


class EncryptionUpdateProperties(msrest.serialization.Model):
    """EncryptionUpdateProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_properties: Required.
    :vartype key_vault_properties:
     ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
    """

    _validation = {
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'EncryptionKeyVaultUpdateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key_vault_properties: Required.
        :paramtype key_vault_properties:
         ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultUpdateProperties
        """
        super(EncryptionUpdateProperties, self).__init__(**kwargs)
        self.key_vault_properties = kwargs['key_vault_properties']


class EndpointAuthKeys(msrest.serialization.Model):
    """Keys for endpoint authentication.

    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        """
        super(EndpointAuthKeys, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)


class EndpointAuthToken(msrest.serialization.Model):
    """Service Token.

    :ivar access_token: Access token for endpoint authentication.
    :vartype access_token: str
    :ivar expiry_time_utc: Access token expiry time (UTC).
    :vartype expiry_time_utc: long
    :ivar refresh_after_time_utc: Refresh access token after time (UTC).
    :vartype refresh_after_time_utc: long
    :ivar token_type: Access token type.
    :vartype token_type: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiry_time_utc': {'key': 'expiryTimeUtc', 'type': 'long'},
        'refresh_after_time_utc': {'key': 'refreshAfterTimeUtc', 'type': 'long'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword access_token: Access token for endpoint authentication.
        :paramtype access_token: str
        :keyword expiry_time_utc: Access token expiry time (UTC).
        :paramtype expiry_time_utc: long
        :keyword refresh_after_time_utc: Refresh access token after time (UTC).
        :paramtype refresh_after_time_utc: long
        :keyword token_type: Access token type.
        :paramtype token_type: str
        """
        super(EndpointAuthToken, self).__init__(**kwargs)
        self.access_token = kwargs.get('access_token', None)
        self.expiry_time_utc = kwargs.get('expiry_time_utc', 0)
        self.refresh_after_time_utc = kwargs.get('refresh_after_time_utc', 0)
        self.token_type = kwargs.get('token_type', None)


class EnvironmentContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerDetails
        """
        super(EnvironmentContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class EnvironmentContainerDetails(AssetContainer):
    """Container for environment specification versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(EnvironmentContainerDetails, self).__init__(**kwargs)


class EnvironmentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentContainer entities.

    :ivar next_link: The link to the next page of EnvironmentContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainerData]
        """
        super(EnvironmentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class EnvironmentVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionDetails
        """
        super(EnvironmentVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class EnvironmentVersionDetails(AssetBase):
    """Environment version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar build: Configuration settings for Docker build context.
    :vartype build: ~azure.mgmt.machinelearningservices.models.BuildContext
    :ivar conda_file: Standard configuration file used by Conda that lets you install any kind of
     package, including Python, R, and C/C++ packages.
    
    
     .. raw:: html
    
        <see
     href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
     />.
    :vartype conda_file: str
    :ivar environment_type: Environment type is either user managed or curated by the Azure ML
     service
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments"
     />. Possible values include: "Curated", "UserCreated".
    :vartype environment_type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentType
    :ivar image: Name of the image that will be used for the environment.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
     />.
    :vartype image: str
    :ivar inference_config: Defines configuration specific to inference.
    :vartype inference_config:
     ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
    :ivar os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
    """

    _validation = {
        'environment_type': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'build': {'key': 'build', 'type': 'BuildContext'},
        'conda_file': {'key': 'condaFile', 'type': 'str'},
        'environment_type': {'key': 'environmentType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'inference_config': {'key': 'inferenceConfig', 'type': 'InferenceContainerProperties'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword build: Configuration settings for Docker build context.
        :paramtype build: ~azure.mgmt.machinelearningservices.models.BuildContext
        :keyword conda_file: Standard configuration file used by Conda that lets you install any kind
         of package, including Python, R, and C/C++ packages.
        
        
         .. raw:: html
        
            <see
         href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
         />.
        :paramtype conda_file: str
        :keyword image: Name of the image that will be used for the environment.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
         />.
        :paramtype image: str
        :keyword inference_config: Defines configuration specific to inference.
        :paramtype inference_config:
         ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
        :keyword os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
        """
        super(EnvironmentVersionDetails, self).__init__(**kwargs)
        self.build = kwargs.get('build', None)
        self.conda_file = kwargs.get('conda_file', None)
        self.environment_type = None
        self.image = kwargs.get('image', None)
        self.inference_config = kwargs.get('inference_config', None)
        self.os_type = kwargs.get('os_type', None)


class EnvironmentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentVersion entities.

    :ivar next_link: The link to the next page of EnvironmentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersionData]
        """
        super(EnvironmentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExternalFQDNResponse(msrest.serialization.Model):
    """ExternalFQDNResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointsPropertyBag]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FQDNEndpointsPropertyBag]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointsPropertyBag]
        """
        super(ExternalFQDNResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class FeatureStoreSettings(msrest.serialization.Model):
    """FeatureStoreSettings.

    :ivar compute_runtime:
    :vartype compute_runtime: ~azure.mgmt.machinelearningservices.models.ComputeRuntimeDto
    :ivar offline_store_connection_name:
    :vartype offline_store_connection_name: str
    :ivar online_store_connection_name:
    :vartype online_store_connection_name: str
    """

    _attribute_map = {
        'compute_runtime': {'key': 'computeRuntime', 'type': 'ComputeRuntimeDto'},
        'offline_store_connection_name': {'key': 'offlineStoreConnectionName', 'type': 'str'},
        'online_store_connection_name': {'key': 'onlineStoreConnectionName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword compute_runtime:
        :paramtype compute_runtime: ~azure.mgmt.machinelearningservices.models.ComputeRuntimeDto
        :keyword offline_store_connection_name:
        :paramtype offline_store_connection_name: str
        :keyword online_store_connection_name:
        :paramtype online_store_connection_name: str
        """
        super(FeatureStoreSettings, self).__init__(**kwargs)
        self.compute_runtime = kwargs.get('compute_runtime', None)
        self.offline_store_connection_name = kwargs.get('offline_store_connection_name', None)
        self.online_store_connection_name = kwargs.get('online_store_connection_name', None)


class FlavorData(msrest.serialization.Model):
    """FlavorData.

    :ivar data: Model flavor-specific data.
    :vartype data: dict[str, str]
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Model flavor-specific data.
        :paramtype data: dict[str, str]
        """
        super(FlavorData, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class FQDNEndpoint(msrest.serialization.Model):
    """FQDNEndpoint.

    :ivar domain_name:
    :vartype domain_name: str
    :ivar endpoint_details:
    :vartype endpoint_details: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[FQDNEndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword domain_name:
        :paramtype domain_name: str
        :keyword endpoint_details:
        :paramtype endpoint_details:
         list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
        """
        super(FQDNEndpoint, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.endpoint_details = kwargs.get('endpoint_details', None)


class FQDNEndpointDetail(msrest.serialization.Model):
    """FQDNEndpointDetail.

    :ivar port:
    :vartype port: int
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword port:
        :paramtype port: int
        """
        super(FQDNEndpointDetail, self).__init__(**kwargs)
        self.port = kwargs.get('port', None)


class FQDNEndpoints(msrest.serialization.Model):
    """FQDNEndpoints.

    :ivar category:
    :vartype category: str
    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[FQDNEndpoint]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category:
        :paramtype category: str
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
        """
        super(FQDNEndpoints, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.endpoints = kwargs.get('endpoints', None)


class FQDNEndpointsPropertyBag(msrest.serialization.Model):
    """FQDNEndpointsPropertyBag.

    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpoints
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FQDNEndpoints'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpoints
        """
        super(FQDNEndpointsPropertyBag, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class OutboundRule(msrest.serialization.Model):
    """OutboundRule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FqdnOutboundRule, PrivateEndpointOutboundRule, ServiceTagOutboundRule.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Possible values include: "Required", "Recommended", "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Possible values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Constant filled by server. Possible values include: "FQDN",
     "PrivateEndpoint", "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'FQDN': 'FqdnOutboundRule', 'PrivateEndpoint': 'PrivateEndpointOutboundRule', 'ServiceTag': 'ServiceTagOutboundRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Possible values include: "Required", "Recommended", "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        """
        super(OutboundRule, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.status = kwargs.get('status', None)
        self.type = None  # type: Optional[str]


class FqdnOutboundRule(OutboundRule):
    """FqdnOutboundRule.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Possible values include: "Required", "Recommended", "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Possible values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Constant filled by server. Possible values include: "FQDN",
     "PrivateEndpoint", "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination:
    :vartype destination: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Possible values include: "Required", "Recommended", "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination:
        :paramtype destination: str
        """
        super(FqdnOutboundRule, self).__init__(**kwargs)
        self.type = 'FQDN'  # type: str
        self.destination = kwargs.get('destination', None)


class GridSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that exhaustively generates every value combination in the space.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GridSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Grid'  # type: str


class IdAssetReference(AssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: Required. [Required] ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
        'asset_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id: Required. [Required] ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(IdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = kwargs['asset_id']


class IdentityForCmk(msrest.serialization.Model):
    """IdentityForCmk.

    :ivar user_assigned_identity: UserAssignedIdentity to be used to fetch the encryption key from
     keyVault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_assigned_identity: UserAssignedIdentity to be used to fetch the encryption key
         from keyVault.
        :paramtype user_assigned_identity: str
        """
        super(IdentityForCmk, self).__init__(**kwargs)
        self.user_assigned_identity = kwargs.get('user_assigned_identity', None)


class InferenceContainerProperties(msrest.serialization.Model):
    """InferenceContainerProperties.

    :ivar liveness_route: The route to check the liveness of the inference server container.
    :vartype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar readiness_route: The route to check the readiness of the inference server container.
    :vartype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar scoring_route: The port to send the scoring requests to, within the inference server
     container.
    :vartype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
    """

    _attribute_map = {
        'liveness_route': {'key': 'livenessRoute', 'type': 'Route'},
        'readiness_route': {'key': 'readinessRoute', 'type': 'Route'},
        'scoring_route': {'key': 'scoringRoute', 'type': 'Route'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword liveness_route: The route to check the liveness of the inference server container.
        :paramtype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword readiness_route: The route to check the readiness of the inference server container.
        :paramtype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword scoring_route: The port to send the scoring requests to, within the inference server
         container.
        :paramtype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
        """
        super(InferenceContainerProperties, self).__init__(**kwargs)
        self.liveness_route = kwargs.get('liveness_route', None)
        self.readiness_route = kwargs.get('readiness_route', None)
        self.scoring_route = kwargs.get('scoring_route', None)


class JobBaseData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.JobBaseDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'JobBaseDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.JobBaseDetails
        """
        super(JobBaseData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class JobBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of JobBase entities.

    :ivar next_link: The link to the next page of JobBase objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type JobBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.JobBaseData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[JobBaseData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of JobBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type JobBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.JobBaseData]
        """
        super(JobBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class JobService(msrest.serialization.Model):
    """Job endpoint definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: Url for endpoint.
    :vartype endpoint: str
    :ivar error_message: Any error in the service.
    :vartype error_message: str
    :ivar job_service_type: Endpoint type.
    :vartype job_service_type: str
    :ivar port: Port for endpoint.
    :vartype port: int
    :ivar properties: Additional properties to set on the endpoint.
    :vartype properties: dict[str, str]
    :ivar status: Status of endpoint.
    :vartype status: str
    """

    _validation = {
        'error_message': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'job_service_type': {'key': 'jobServiceType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword endpoint: Url for endpoint.
        :paramtype endpoint: str
        :keyword job_service_type: Endpoint type.
        :paramtype job_service_type: str
        :keyword port: Port for endpoint.
        :paramtype port: int
        :keyword properties: Additional properties to set on the endpoint.
        :paramtype properties: dict[str, str]
        """
        super(JobService, self).__init__(**kwargs)
        self.endpoint = kwargs.get('endpoint', None)
        self.error_message = None
        self.job_service_type = kwargs.get('job_service_type', None)
        self.port = kwargs.get('port', None)
        self.properties = kwargs.get('properties', None)
        self.status = None


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_client_id: Currently, we support only SystemAssigned MSI.
     We need this when we support UserAssignedIdentities.
    :vartype identity_client_id: str
    :ivar key_identifier: Required. KeyVault key identifier to encrypt the data.
    :vartype key_identifier: str
    :ivar key_vault_arm_id: Required. KeyVault Arm Id that contains the data encryption key.
    :vartype key_vault_arm_id: str
    """

    _validation = {
        'key_identifier': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'key_vault_arm_id': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'key_vault_arm_id': {'key': 'keyVaultArmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity_client_id: Currently, we support only SystemAssigned MSI.
         We need this when we support UserAssignedIdentities.
        :paramtype identity_client_id: str
        :keyword key_identifier: Required. KeyVault key identifier to encrypt the data.
        :paramtype key_identifier: str
        :keyword key_vault_arm_id: Required. KeyVault Arm Id that contains the data encryption key.
        :paramtype key_vault_arm_id: str
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.identity_client_id = kwargs.get('identity_client_id', None)
        self.key_identifier = kwargs['key_identifier']
        self.key_vault_arm_id = kwargs['key_vault_arm_id']


class OnlineDeploymentDetails(EndpointDeploymentPropertiesBase):
    """OnlineDeploymentDetails.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: KubernetesOnlineDeployment, ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    _subtype_map = {
        'endpoint_compute_type': {'Kubernetes': 'KubernetesOnlineDeployment', 'Managed': 'ManagedOnlineDeployment'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(OnlineDeploymentDetails, self).__init__(**kwargs)
        self.app_insights_enabled = kwargs.get('app_insights_enabled', False)
        self.endpoint_compute_type = 'OnlineDeploymentDetails'  # type: str
        self.instance_type = kwargs.get('instance_type', None)
        self.liveness_probe = kwargs.get('liveness_probe', None)
        self.model = kwargs.get('model', None)
        self.model_mount_path = kwargs.get('model_mount_path', None)
        self.provisioning_state = None
        self.readiness_probe = kwargs.get('readiness_probe', None)
        self.request_settings = kwargs.get('request_settings', None)
        self.scale_settings = kwargs.get('scale_settings', None)


class KubernetesOnlineDeployment(OnlineDeploymentDetails):
    """Properties specific to a KubernetesOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    :ivar container_resource_requirements: The resource requirements for the container (cpu and
     memory).
    :vartype container_resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
        'container_resource_requirements': {'key': 'containerResourceRequirements', 'type': 'ContainerResourceRequirements'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        :keyword container_resource_requirements: The resource requirements for the container (cpu and
         memory).
        :paramtype container_resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        """
        super(KubernetesOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Kubernetes'  # type: str
        self.container_resource_requirements = kwargs.get('container_resource_requirements', None)


class ListAmlUserFeatureResult(msrest.serialization.Model):
    """The List Aml user feature operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML user facing features.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlUserFeature]
    :ivar next_link: The URI to fetch the next page of AML user features information. Call
     ListNext() with this to fetch the next page of AML user features information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlUserFeature]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAmlUserFeatureResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListNotebookKeysResult(msrest.serialization.Model):
    """ListNotebookKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_access_key: The primary access key of the Notebook.
    :vartype primary_access_key: str
    :ivar secondary_access_key: The secondary access key of the Notebook.
    :vartype secondary_access_key: str
    """

    _validation = {
        'primary_access_key': {'readonly': True},
        'secondary_access_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_access_key': {'key': 'primaryAccessKey', 'type': 'str'},
        'secondary_access_key': {'key': 'secondaryAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListNotebookKeysResult, self).__init__(**kwargs)
        self.primary_access_key = None
        self.secondary_access_key = None


class ListStorageAccountKeysResult(msrest.serialization.Model):
    """ListStorageAccountKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key: The access key of the storage.
    :vartype user_storage_key: str
    """

    _validation = {
        'user_storage_key': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListStorageAccountKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None


class ListWorkspaceKeysResult(msrest.serialization.Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar app_insights_instrumentation_key: The access key of the workspace app insights.
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    :ivar notebook_access_keys:
    :vartype notebook_access_keys:
     ~azure.mgmt.machinelearningservices.models.ListNotebookKeysResult
    :ivar user_storage_arm_id: The arm Id key of the workspace storage.
    :vartype user_storage_arm_id: str
    :ivar user_storage_key: The access key of the workspace storage.
    :vartype user_storage_key: str
    """

    _validation = {
        'app_insights_instrumentation_key': {'readonly': True},
        'user_storage_arm_id': {'readonly': True},
        'user_storage_key': {'readonly': True},
    }

    _attribute_map = {
        'app_insights_instrumentation_key': {'key': 'appInsightsInstrumentationKey', 'type': 'str'},
        'container_registry_credentials': {'key': 'containerRegistryCredentials', 'type': 'RegistryListCredentialsResult'},
        'notebook_access_keys': {'key': 'notebookAccessKeys', 'type': 'ListNotebookKeysResult'},
        'user_storage_arm_id': {'key': 'userStorageArmId', 'type': 'str'},
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_registry_credentials:
        :paramtype container_registry_credentials:
         ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
        :keyword notebook_access_keys:
        :paramtype notebook_access_keys:
         ~azure.mgmt.machinelearningservices.models.ListNotebookKeysResult
        """
        super(ListWorkspaceKeysResult, self).__init__(**kwargs)
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = kwargs.get('container_registry_credentials', None)
        self.notebook_access_keys = kwargs.get('notebook_access_keys', None)
        self.user_storage_arm_id = None
        self.user_storage_key = None


class LiteralJobInput(JobInput):
    """Literal input type.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar value: Required. [Required] Literal value for the input.
    :vartype value: str
    """

    _validation = {
        'job_input_type': {'required': True},
        'value': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword value: Required. [Required] Literal value for the input.
        :paramtype value: str
        """
        super(LiteralJobInput, self).__init__(**kwargs)
        self.job_input_type = 'literal'  # type: str
        self.value = kwargs['value']


class ManagedIdentity(IdentityConfiguration):
    """Managed identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    :ivar client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not
     set this field.
    :vartype client_id: str
    :ivar object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not
     set this field.
    :vartype object_id: str
    :ivar resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned,
     do not set this field.
    :vartype resource_id: str
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_id: Specifies a user-assigned identity by client ID. For system-assigned, do
         not set this field.
        :paramtype client_id: str
        :keyword object_id: Specifies a user-assigned identity by object ID. For system-assigned, do
         not set this field.
        :paramtype object_id: str
        :keyword resource_id: Specifies a user-assigned identity by ARM resource ID. For
         system-assigned, do not set this field.
        :paramtype resource_id: str
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.identity_type = 'Managed'  # type: str
        self.client_id = kwargs.get('client_id', None)
        self.object_id = kwargs.get('object_id', None)
        self.resource_id = kwargs.get('resource_id', None)


class ManagedIdentityAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ManagedIdentityAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionManagedIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
        """
        super(ManagedIdentityAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'ManagedIdentity'  # type: str
        self.credentials = kwargs.get('credentials', None)


class ManagedNetworkProvisionOptions(msrest.serialization.Model):
    """ManagedNetworkProvisionOptions.

    :ivar include_spark:
    :vartype include_spark: bool
    """

    _attribute_map = {
        'include_spark': {'key': 'includeSpark', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword include_spark:
        :paramtype include_spark: bool
        """
        super(ManagedNetworkProvisionOptions, self).__init__(**kwargs)
        self.include_spark = kwargs.get('include_spark', None)


class ManagedNetworkProvisionStatus(msrest.serialization.Model):
    """ManagedNetworkProvisionStatus.

    :ivar spark_ready:
    :vartype spark_ready: bool
    :ivar status: Possible values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ManagedNetworkStatus
    """

    _attribute_map = {
        'spark_ready': {'key': 'sparkReady', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword spark_ready:
        :paramtype spark_ready: bool
        :keyword status: Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ManagedNetworkStatus
        """
        super(ManagedNetworkProvisionStatus, self).__init__(**kwargs)
        self.spark_ready = kwargs.get('spark_ready', None)
        self.status = kwargs.get('status', None)


class ManagedOnlineDeployment(OnlineDeploymentDetails):
    """Properties specific to a ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(ManagedOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Managed'  # type: str


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Required. Type of managed service identity (where both SystemAssigned and
     UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity (where both SystemAssigned and
         UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
         "UserAssigned", "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class MedianStoppingPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on running averages of the primary metric of all runs.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(MedianStoppingPolicy, self).__init__(**kwargs)
        self.policy_type = 'MedianStopping'  # type: str


class MLFlowModelJobInput(JobInput, AssetJobInput):
    """MLFlowModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLFlowModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'mlflow_model'  # type: str
        self.description = kwargs.get('description', None)


class MLFlowModelJobOutput(JobOutput, AssetJobOutput):
    """MLFlowModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLFlowModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'mlflow_model'  # type: str
        self.description = kwargs.get('description', None)


class MLTableData(DataVersionBaseDetails):
    """MLTable data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    :ivar referenced_uris: Uris referenced in the MLTable definition (required for lineage).
    :vartype referenced_uris: list[str]
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'referenced_uris': {'key': 'referencedUris', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        :keyword referenced_uris: Uris referenced in the MLTable definition (required for lineage).
        :paramtype referenced_uris: list[str]
        """
        super(MLTableData, self).__init__(**kwargs)
        self.data_type = 'mltable'  # type: str
        self.referenced_uris = kwargs.get('referenced_uris', None)


class MLTableJobInput(JobInput, AssetJobInput):
    """MLTableJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLTableJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'mltable'  # type: str
        self.description = kwargs.get('description', None)


class MLTableJobOutput(JobOutput, AssetJobOutput):
    """MLTableJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLTableJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'mltable'  # type: str
        self.description = kwargs.get('description', None)


class ModelContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerDetails
        """
        super(ModelContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ModelContainerDetails(AssetContainer):
    """ModelContainerDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ModelContainerDetails, self).__init__(**kwargs)


class ModelContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelContainer entities.

    :ivar next_link: The link to the next page of ModelContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelContainerData]
        """
        super(ModelContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ModelVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionDetails
        """
        super(ModelVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ModelVersionDetails(AssetBase):
    """Model asset version details.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar flavors: Mapping of model flavors to their properties.
    :vartype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
    :ivar job_name: Name of the training job which produced this model.
    :vartype job_name: str
    :ivar model_type: The storage format for this entity. Used for NCD.
    :vartype model_type: str
    :ivar model_uri: The URI path to the model contents.
    :vartype model_uri: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'flavors': {'key': 'flavors', 'type': '{FlavorData}'},
        'job_name': {'key': 'jobName', 'type': 'str'},
        'model_type': {'key': 'modelType', 'type': 'str'},
        'model_uri': {'key': 'modelUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword flavors: Mapping of model flavors to their properties.
        :paramtype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
        :keyword job_name: Name of the training job which produced this model.
        :paramtype job_name: str
        :keyword model_type: The storage format for this entity. Used for NCD.
        :paramtype model_type: str
        :keyword model_uri: The URI path to the model contents.
        :paramtype model_uri: str
        """
        super(ModelVersionDetails, self).__init__(**kwargs)
        self.flavors = kwargs.get('flavors', None)
        self.job_name = kwargs.get('job_name', None)
        self.model_type = kwargs.get('model_type', None)
        self.model_uri = kwargs.get('model_uri', None)


class ModelVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelVersion entities.

    :ivar next_link: The link to the next page of ModelVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelVersionData]
        """
        super(ModelVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class Mpi(DistributionConfiguration):
    """MPI distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per MPI node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per MPI node.
        :paramtype process_count_per_instance: int
        """
        super(Mpi, self).__init__(**kwargs)
        self.distribution_type = 'Mpi'  # type: str
        self.process_count_per_instance = kwargs.get('process_count_per_instance', None)


class NoneAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """NoneAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        """
        super(NoneAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'None'  # type: str


class NoneDatastoreCredentials(DatastoreCredentials):
    """Empty/none datastore credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NoneDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'None'  # type: str


class NotebookAccessTokenResult(msrest.serialization.Model):
    """NotebookAccessTokenResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_token:
    :vartype access_token: str
    :ivar expires_in:
    :vartype expires_in: int
    :ivar host_name:
    :vartype host_name: str
    :ivar notebook_resource_id:
    :vartype notebook_resource_id: str
    :ivar public_dns:
    :vartype public_dns: str
    :ivar refresh_token:
    :vartype refresh_token: str
    :ivar scope:
    :vartype scope: str
    :ivar token_type:
    :vartype token_type: str
    """

    _validation = {
        'access_token': {'readonly': True},
        'expires_in': {'readonly': True},
        'host_name': {'readonly': True},
        'notebook_resource_id': {'readonly': True},
        'public_dns': {'readonly': True},
        'refresh_token': {'readonly': True},
        'scope': {'readonly': True},
        'token_type': {'readonly': True},
    }

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'notebook_resource_id': {'key': 'notebookResourceId', 'type': 'str'},
        'public_dns': {'key': 'publicDns', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NotebookAccessTokenResult, self).__init__(**kwargs)
        self.access_token = None
        self.expires_in = None
        self.host_name = None
        self.notebook_resource_id = None
        self.public_dns = None
        self.refresh_token = None
        self.scope = None
        self.token_type = None


class NotebookPreparationError(msrest.serialization.Model):
    """NotebookPreparationError.

    :ivar error_message:
    :vartype error_message: str
    :ivar status_code:
    :vartype status_code: int
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error_message:
        :paramtype error_message: str
        :keyword status_code:
        :paramtype status_code: int
        """
        super(NotebookPreparationError, self).__init__(**kwargs)
        self.error_message = kwargs.get('error_message', None)
        self.status_code = kwargs.get('status_code', None)


class NotebookResourceInfo(msrest.serialization.Model):
    """NotebookResourceInfo.

    :ivar fqdn:
    :vartype fqdn: str
    :ivar is_private_link_enabled:
    :vartype is_private_link_enabled: bool
    :ivar notebook_preparation_error: The error that occurs when preparing notebook.
    :vartype notebook_preparation_error:
     ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
    :ivar resource_id: the data plane resourceId that used to initialize notebook component.
    :vartype resource_id: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'is_private_link_enabled': {'key': 'isPrivateLinkEnabled', 'type': 'bool'},
        'notebook_preparation_error': {'key': 'notebookPreparationError', 'type': 'NotebookPreparationError'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword fqdn:
        :paramtype fqdn: str
        :keyword is_private_link_enabled:
        :paramtype is_private_link_enabled: bool
        :keyword notebook_preparation_error: The error that occurs when preparing notebook.
        :paramtype notebook_preparation_error:
         ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
        :keyword resource_id: the data plane resourceId that used to initialize notebook component.
        :paramtype resource_id: str
        """
        super(NotebookResourceInfo, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.is_private_link_enabled = kwargs.get('is_private_link_enabled', None)
        self.notebook_preparation_error = kwargs.get('notebook_preparation_error', None)
        self.resource_id = kwargs.get('resource_id', None)


class Objective(msrest.serialization.Model):
    """Optimization objective.

    All required parameters must be populated in order to send to Azure.

    :ivar goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
     Possible values include: "Minimize", "Maximize".
    :vartype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
    :ivar primary_metric: Required. [Required] Name of the metric to optimize.
    :vartype primary_metric: str
    """

    _validation = {
        'goal': {'required': True},
        'primary_metric': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'goal': {'key': 'goal', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
         Possible values include: "Minimize", "Maximize".
        :paramtype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
        :keyword primary_metric: Required. [Required] Name of the metric to optimize.
        :paramtype primary_metric: str
        """
        super(Objective, self).__init__(**kwargs)
        self.goal = kwargs['goal']
        self.primary_metric = kwargs['primary_metric']


class OnlineDeploymentData(TrackedResource):
    """OnlineDeploymentData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineDeploymentDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineDeploymentData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class OnlineDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineDeployment entities.

    :ivar next_link: The link to the next page of OnlineDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeploymentData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineDeploymentData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineDeployment objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeploymentData]
        """
        super(OnlineDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineEndpointData(TrackedResource):
    """OnlineEndpointData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineEndpointDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineEndpointData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class OnlineEndpointDetails(EndpointPropertiesBase):
    """Online endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar compute: ARM resource ID of the compute if it exists.
     optional.
    :vartype compute: str
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    :ivar traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values
     need to sum to 100.
    :vartype traffic: dict[str, int]
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'compute': {'key': 'compute', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'traffic': {'key': 'traffic', 'type': '{int}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: ARM resource ID of the compute if it exists.
         optional.
        :paramtype compute: str
        :keyword traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic
         values need to sum to 100.
        :paramtype traffic: dict[str, int]
        """
        super(OnlineEndpointDetails, self).__init__(**kwargs)
        self.compute = kwargs.get('compute', None)
        self.provisioning_state = None
        self.traffic = kwargs.get('traffic', None)


class OnlineEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineEndpoint entities.

    :ivar next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpointData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineEndpointData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpointData]
        """
        super(OnlineEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineRequestSettings(msrest.serialization.Model):
    """Online deployment scoring requests configuration.

    :ivar max_concurrent_requests_per_instance: The number of maximum concurrent requests per node
     allowed per deployment. Defaults to 1.
    :vartype max_concurrent_requests_per_instance: int
    :ivar max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601
     format.
     Defaults to 500ms.
    :vartype max_queue_wait: ~datetime.timedelta
    :ivar request_timeout: The scoring timeout in ISO 8601 format.
     Defaults to 5000ms.
    :vartype request_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_requests_per_instance': {'key': 'maxConcurrentRequestsPerInstance', 'type': 'int'},
        'max_queue_wait': {'key': 'maxQueueWait', 'type': 'duration'},
        'request_timeout': {'key': 'requestTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_concurrent_requests_per_instance: The number of maximum concurrent requests per
         node allowed per deployment. Defaults to 1.
        :paramtype max_concurrent_requests_per_instance: int
        :keyword max_queue_wait: The maximum amount of time a request will stay in the queue in ISO
         8601 format.
         Defaults to 500ms.
        :paramtype max_queue_wait: ~datetime.timedelta
        :keyword request_timeout: The scoring timeout in ISO 8601 format.
         Defaults to 5000ms.
        :paramtype request_timeout: ~datetime.timedelta
        """
        super(OnlineRequestSettings, self).__init__(**kwargs)
        self.max_concurrent_requests_per_instance = kwargs.get('max_concurrent_requests_per_instance', 1)
        self.max_queue_wait = kwargs.get('max_queue_wait', "PT0.5S")
        self.request_timeout = kwargs.get('request_timeout', "PT5S")


class OperationDisplay(msrest.serialization.Model):
    """Display name of operation.

    :ivar description: Gets or sets the description for the operation.
    :vartype description: str
    :ivar operation: Gets or sets the operation that users can perform.
    :vartype operation: str
    :ivar provider: Gets or sets the resource provider name:
     Microsoft.MachineLearningExperimentation.
    :vartype provider: str
    :ivar resource: Gets or sets the resource on which the operation is performed.
    :vartype resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Gets or sets the description for the operation.
        :paramtype description: str
        :keyword operation: Gets or sets the operation that users can perform.
        :paramtype operation: str
        :keyword provider: Gets or sets the resource provider name:
         Microsoft.MachineLearningExperimentation.
        :paramtype provider: str
        :keyword resource: Gets or sets the resource on which the operation is performed.
        :paramtype resource: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.operation = kwargs.get('operation', None)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)


class OutboundRuleBasicResource(Resource):
    """OutboundRuleBasicResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OutboundRule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'OutboundRule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OutboundRule
        """
        super(OutboundRuleBasicResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class OutboundRuleListResult(msrest.serialization.Model):
    """OutboundRuleListResult.

    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: The list of machine learning workspaces. Since this list may be incomplete, the
     nextLink field should be used to request the next list of machine learning workspaces.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OutboundRuleBasicResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OutboundRuleBasicResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        :keyword value: The list of machine learning workspaces. Since this list may be incomplete, the
         nextLink field should be used to request the next list of machine learning workspaces.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OutboundRuleBasicResource]
        """
        super(OutboundRuleListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OutputPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super(OutputPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'OutputPath'  # type: str
        self.job_id = kwargs.get('job_id', None)
        self.path = kwargs.get('path', None)


class PartialAssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartialDataPathAssetReference, PartialIdAssetReference, PartialOutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'PartialDataPathAssetReference', 'Id': 'PartialIdAssetReference', 'OutputPath': 'PartialOutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialAssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class PartialBatchDeployment(msrest.serialization.Model):
    """Mutable batch inference settings per deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration:
     ~azure.mgmt.machinelearningservices.models.PartialCodeConfiguration
    :ivar compute: Compute binding definition.
    :vartype compute: str
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates number of processes per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.PartialAssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar retry_settings: Retry Settings for the batch inference operation.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.PartialBatchRetrySettings
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'PartialCodeConfiguration'},
        'compute': {'key': 'compute', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'PartialAssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'retry_settings': {'key': 'retrySettings', 'type': 'PartialBatchRetrySettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration:
         ~azure.mgmt.machinelearningservices.models.PartialCodeConfiguration
        :keyword compute: Compute binding definition.
        :paramtype compute: str
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates number of processes per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.PartialAssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword retry_settings: Retry Settings for the batch inference operation.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.PartialBatchRetrySettings
        """
        super(PartialBatchDeployment, self).__init__(**kwargs)
        self.code_configuration = kwargs.get('code_configuration', None)
        self.compute = kwargs.get('compute', None)
        self.description = kwargs.get('description', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.error_threshold = kwargs.get('error_threshold', None)
        self.logging_level = kwargs.get('logging_level', None)
        self.max_concurrency_per_instance = kwargs.get('max_concurrency_per_instance', None)
        self.mini_batch_size = kwargs.get('mini_batch_size', None)
        self.model = kwargs.get('model', None)
        self.output_action = kwargs.get('output_action', None)
        self.output_file_name = kwargs.get('output_file_name', None)
        self.properties = kwargs.get('properties', None)
        self.retry_settings = kwargs.get('retry_settings', None)


class PartialBatchDeploymentPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialBatchDeployment'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialBatchDeploymentPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialBatchEndpoint(msrest.serialization.Model):
    """Mutable Batch endpoint configuration.

    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    """

    _attribute_map = {
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(PartialBatchEndpoint, self).__init__(**kwargs)
        self.defaults = kwargs.get('defaults', None)


class PartialBatchEndpointPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchEndpoint
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialBatchEndpoint'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchEndpoint
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialBatchEndpointPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialBatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(PartialBatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = kwargs.get('max_retries', None)
        self.timeout = kwargs.get('timeout', None)


class PartialCodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'min_length': 1},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(PartialCodeConfiguration, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.scoring_script = kwargs.get('scoring_script', None)


class PartialDataPathAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(PartialDataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = kwargs.get('datastore_id', None)
        self.path = kwargs.get('path', None)


class PartialIdAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id: ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(PartialIdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = kwargs.get('asset_id', None)


class PartialOnlineDeployment(msrest.serialization.Model):
    """Mutable online deployment configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartialKubernetesOnlineDeployment, PartialManagedOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_compute_type': {'Kubernetes': 'PartialKubernetesOnlineDeployment', 'Managed': 'PartialManagedOnlineDeployment'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = None  # type: Optional[str]


class PartialKubernetesOnlineDeployment(PartialOnlineDeployment):
    """Properties specific to a KubernetesOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialKubernetesOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Kubernetes'  # type: str


class PartialManagedOnlineDeployment(PartialOnlineDeployment):
    """Properties specific to a ManagedOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialManagedOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Managed'  # type: str


class PartialManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar type: Managed service identity (system assigned and/or user assigned identities).
     Possible values include: "None", "SystemAssigned", "UserAssigned",
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, any]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Managed service identity (system assigned and/or user assigned identities).
         Possible values include: "None", "SystemAssigned", "UserAssigned",
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, any]
        """
        super(PartialManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class PartialOnlineDeploymentPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineDeployment
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialOnlineDeployment'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineDeployment
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialOnlineDeploymentPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialOnlineEndpointPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: any
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: any
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialOnlineEndpointPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialOutputPathAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super(PartialOutputPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'OutputPath'  # type: str
        self.job_id = kwargs.get('job_id', None)
        self.path = kwargs.get('path', None)


class PartialSku(msrest.serialization.Model):
    """Common SKU definition.

    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(PartialSku, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.family = kwargs.get('family', None)
        self.name = kwargs.get('name', None)
        self.size = kwargs.get('size', None)
        self.tier = kwargs.get('tier', None)


class Password(msrest.serialization.Model):
    """Password.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Password, self).__init__(**kwargs)
        self.name = None
        self.value = None


class PATAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """PATAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionPersonalAccessToken'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
        """
        super(PATAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'PAT'  # type: str
        self.credentials = kwargs.get('credentials', None)


class PipelineJob(JobBaseDetails):
    """Pipeline Job definition: defines generic to MFE attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar inputs: Inputs for the pipeline job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar jobs: Jobs construct the Pipeline Job.
    :vartype jobs: dict[str, any]
    :ivar outputs: Outputs for the pipeline job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
    :vartype settings: any
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'jobs': {'key': 'jobs', 'type': '{object}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'settings': {'key': 'settings', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword inputs: Inputs for the pipeline job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword jobs: Jobs construct the Pipeline Job.
        :paramtype jobs: dict[str, any]
        :keyword outputs: Outputs for the pipeline job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :paramtype settings: any
        """
        super(PipelineJob, self).__init__(**kwargs)
        self.job_type = 'Pipeline'  # type: str
        self.inputs = kwargs.get('inputs', None)
        self.jobs = kwargs.get('jobs', None)
        self.outputs = kwargs.get('outputs', None)
        self.settings = kwargs.get('settings', None)


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Same as workspace location.
    :vartype location: str
    :ivar sku: Optional. This field is required to be implemented by the RP because AML is
     supporting more than one tier.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar private_endpoint:
    :vartype private_endpoint:
     ~azure.mgmt.machinelearningservices.models.WorkspacePrivateEndpointResource
    :ivar private_link_service_connection_state: The connection state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Connection status of the service consumer with the service provider
     Possible state transitions
     Pending -> Approved (Service provider approves the connection request)
     Pending -> Rejected (Service provider rejects the connection request)
     Pending -> Disconnected (Service provider deletes the connection)
     Approved -> Rejected (Service provider rejects the approved connection)
     Approved -> Disconnected (Service provider deletes the connection)
     Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
     Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'WorkspacePrivateEndpointResource'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Same as workspace location.
        :paramtype location: str
        :keyword sku: Optional. This field is required to be implemented by the RP because AML is
         supporting more than one tier.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword private_endpoint:
        :paramtype private_endpoint:
         ~azure.mgmt.machinelearningservices.models.WorkspacePrivateEndpointResource
        :keyword private_link_service_connection_state: The connection state.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
        :keyword provisioning_state: Connection status of the service consumer with the service
         provider
         Possible state transitions
         Pending -> Approved (Service provider approves the connection request)
         Pending -> Rejected (Service provider rejects the connection request)
         Pending -> Disconnected (Service provider deletes the connection)
         Approved -> Rejected (Service provider rejects the approved connection)
         Approved -> Disconnected (Service provider deletes the connection)
         Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
         Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
         "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
        :paramtype provisioning_state: str or
         ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """PrivateEndpointConnectionListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
        """
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateEndpointDestination(msrest.serialization.Model):
    """PrivateEndpointDestination.

    :ivar service_resource_id:
    :vartype service_resource_id: str
    :ivar spark_enabled:
    :vartype spark_enabled: bool
    :ivar spark_status: Possible values include: "Inactive", "Active".
    :vartype spark_status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar subresource_target:
    :vartype subresource_target: str
    """

    _attribute_map = {
        'service_resource_id': {'key': 'serviceResourceId', 'type': 'str'},
        'spark_enabled': {'key': 'sparkEnabled', 'type': 'bool'},
        'spark_status': {'key': 'sparkStatus', 'type': 'str'},
        'subresource_target': {'key': 'subresourceTarget', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_resource_id:
        :paramtype service_resource_id: str
        :keyword spark_enabled:
        :paramtype spark_enabled: bool
        :keyword spark_status: Possible values include: "Inactive", "Active".
        :paramtype spark_status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword subresource_target:
        :paramtype subresource_target: str
        """
        super(PrivateEndpointDestination, self).__init__(**kwargs)
        self.service_resource_id = kwargs.get('service_resource_id', None)
        self.spark_enabled = kwargs.get('spark_enabled', None)
        self.spark_status = kwargs.get('spark_status', None)
        self.subresource_target = kwargs.get('subresource_target', None)


class PrivateEndpointOutboundRule(OutboundRule):
    """PrivateEndpointOutboundRule.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Possible values include: "Required", "Recommended", "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Possible values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Constant filled by server. Possible values include: "FQDN",
     "PrivateEndpoint", "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination:
    :vartype destination: ~azure.mgmt.machinelearningservices.models.PrivateEndpointDestination
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'PrivateEndpointDestination'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Possible values include: "Required", "Recommended", "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination:
        :paramtype destination: ~azure.mgmt.machinelearningservices.models.PrivateEndpointDestination
        """
        super(PrivateEndpointOutboundRule, self).__init__(**kwargs)
        self.type = 'PrivateEndpoint'  # type: str
        self.destination = kwargs.get('destination', None)


class PrivateLinkResource(Resource):
    """PrivateLinkResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Same as workspace location.
    :vartype location: str
    :ivar sku: Optional. This field is required to be implemented by the RP because AML is
     supporting more than one tier.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Same as workspace location.
        :paramtype location: str
        :keyword sku: Optional. This field is required to be implemented by the RP because AML is
         supporting more than one tier.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword required_members: The private link resource required member names.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """PrivateLinkResourceListResult.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
        """
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """PrivateLinkServiceConnectionState.

    :ivar actions_required: Some RP chose "None". Other RPs use this for region expansion.
    :vartype actions_required: str
    :ivar description: User-defined message that, per NRP doc, may be used for approval-related
     message.
    :vartype description: str
    :ivar status: Connection status of the service consumer with the service provider
     Possible state transitions
     Pending -> Approved (Service provider approves the connection request)
     Pending -> Rejected (Service provider rejects the connection request)
     Pending -> Disconnected (Service provider deletes the connection)
     Approved -> Rejected (Service provider rejects the approved connection)
     Approved -> Disconnected (Service provider deletes the connection)
     Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
     Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
    """

    _attribute_map = {
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword actions_required: Some RP chose "None". Other RPs use this for region expansion.
        :paramtype actions_required: str
        :keyword description: User-defined message that, per NRP doc, may be used for approval-related
         message.
        :paramtype description: str
        :keyword status: Connection status of the service consumer with the service provider
         Possible state transitions
         Pending -> Approved (Service provider approves the connection request)
         Pending -> Rejected (Service provider rejects the connection request)
         Pending -> Disconnected (Service provider deletes the connection)
         Approved -> Rejected (Service provider rejects the approved connection)
         Approved -> Disconnected (Service provider deletes the connection)
         Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
         Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
         "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.actions_required = kwargs.get('actions_required', None)
        self.description = kwargs.get('description', None)
        self.status = kwargs.get('status', None)


class ProbeSettings(msrest.serialization.Model):
    """Deployment container liveness/readiness probe configuration.

    :ivar failure_threshold: The number of failures to allow before returning an unhealthy status.
    :vartype failure_threshold: int
    :ivar initial_delay: The delay before the first probe in ISO 8601 format.
    :vartype initial_delay: ~datetime.timedelta
    :ivar period: The length of time between probes in ISO 8601 format.
    :vartype period: ~datetime.timedelta
    :ivar success_threshold: The number of successful probes before returning a healthy status.
    :vartype success_threshold: int
    :ivar timeout: The probe timeout in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'initial_delay': {'key': 'initialDelay', 'type': 'duration'},
        'period': {'key': 'period', 'type': 'duration'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword failure_threshold: The number of failures to allow before returning an unhealthy
         status.
        :paramtype failure_threshold: int
        :keyword initial_delay: The delay before the first probe in ISO 8601 format.
        :paramtype initial_delay: ~datetime.timedelta
        :keyword period: The length of time between probes in ISO 8601 format.
        :paramtype period: ~datetime.timedelta
        :keyword success_threshold: The number of successful probes before returning a healthy status.
        :paramtype success_threshold: int
        :keyword timeout: The probe timeout in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ProbeSettings, self).__init__(**kwargs)
        self.failure_threshold = kwargs.get('failure_threshold', 30)
        self.initial_delay = kwargs.get('initial_delay', None)
        self.period = kwargs.get('period', "PT10S")
        self.success_threshold = kwargs.get('success_threshold', 1)
        self.timeout = kwargs.get('timeout', "PT2S")


class PyTorch(DistributionConfiguration):
    """PyTorch distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per node.
        :paramtype process_count_per_instance: int
        """
        super(PyTorch, self).__init__(**kwargs)
        self.distribution_type = 'PyTorch'  # type: str
        self.process_count_per_instance = kwargs.get('process_count_per_instance', None)


class RandomSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values randomly.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    :ivar rule: The specific type of random algorithm. Possible values include: "Random", "Sobol".
    :vartype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
    :ivar seed: An optional integer to use as the seed for random number generation.
    :vartype seed: int
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
        'rule': {'key': 'rule', 'type': 'str'},
        'seed': {'key': 'seed', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword rule: The specific type of random algorithm. Possible values include: "Random",
         "Sobol".
        :paramtype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
        :keyword seed: An optional integer to use as the seed for random number generation.
        :paramtype seed: int
        """
        super(RandomSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Random'  # type: str
        self.rule = kwargs.get('rule', None)
        self.seed = kwargs.get('seed', None)


class RegenerateEndpointKeysRequest(msrest.serialization.Model):
    """RegenerateEndpointKeysRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Required. [Required] Specification for which type of key to generate. Primary
     or Secondary. Possible values include: "Primary", "Secondary".
    :vartype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
    :ivar key_value: The value the key is set to.
    :vartype key_value: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'key_value': {'key': 'keyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key_type: Required. [Required] Specification for which type of key to generate.
         Primary or Secondary. Possible values include: "Primary", "Secondary".
        :paramtype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
        :keyword key_value: The value the key is set to.
        :paramtype key_value: str
        """
        super(RegenerateEndpointKeysRequest, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']
        self.key_value = kwargs.get('key_value', None)


class RegistryListCredentialsResult(msrest.serialization.Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location of the workspace ACR.
    :vartype location: str
    :ivar passwords:
    :vartype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    :ivar username: The username of the workspace ACR.
    :vartype username: str
    """

    _validation = {
        'location': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[Password]'},
        'username': {'key': 'username', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword passwords:
        :paramtype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
        """
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.location = None
        self.passwords = kwargs.get('passwords', None)
        self.username = None


class ResourceConfiguration(msrest.serialization.Model):
    """ResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(ResourceConfiguration, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', 1)
        self.instance_type = kwargs.get('instance_type', None)
        self.properties = kwargs.get('properties', None)


class Route(msrest.serialization.Model):
    """Route.

    All required parameters must be populated in order to send to Azure.

    :ivar path: Required. [Required] The path for the route.
    :vartype path: str
    :ivar port: Required. [Required] The port for the route.
    :vartype port: int
    """

    _validation = {
        'path': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'port': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword path: Required. [Required] The path for the route.
        :paramtype path: str
        :keyword port: Required. [Required] The port for the route.
        :paramtype port: int
        """
        super(Route, self).__init__(**kwargs)
        self.path = kwargs['path']
        self.port = kwargs['port']


class SASAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """SASAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionSharedAccessSignature'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionSharedAccessSignature
        """
        super(SASAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'SAS'  # type: str
        self.credentials = kwargs.get('credentials', None)


class SasDatastoreCredentials(DatastoreCredentials):
    """SAS datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage container secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'SasDatastoreSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage container secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
        """
        super(SasDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Sas'  # type: str
        self.secrets = kwargs['secrets']


class SasDatastoreSecrets(DatastoreSecrets):
    """Datastore SAS secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar sas_token: Storage container SAS token.
    :vartype sas_token: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sas_token: Storage container SAS token.
        :paramtype sas_token: str
        """
        super(SasDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Sas'  # type: str
        self.sas_token = kwargs.get('sas_token', None)


class ServiceManagedResourcesSettings(msrest.serialization.Model):
    """ServiceManagedResourcesSettings.

    :ivar cosmos_db:
    :vartype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
    """

    _attribute_map = {
        'cosmos_db': {'key': 'cosmosDb', 'type': 'CosmosDbSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword cosmos_db:
        :paramtype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
        """
        super(ServiceManagedResourcesSettings, self).__init__(**kwargs)
        self.cosmos_db = kwargs.get('cosmos_db', None)


class ServicePrincipalAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ServicePrincipalAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionServicePrincipal
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionServicePrincipal'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionServicePrincipal
        """
        super(ServicePrincipalAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'ServicePrincipal'  # type: str
        self.credentials = kwargs.get('credentials', None)


class ServicePrincipalDatastoreCredentials(DatastoreCredentials):
    """Service Principal datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'ServicePrincipalDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        """
        super(ServicePrincipalDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'ServicePrincipal'  # type: str
        self.authority_url = kwargs.get('authority_url', None)
        self.client_id = kwargs['client_id']
        self.resource_url = kwargs.get('resource_url', None)
        self.secrets = kwargs['secrets']
        self.tenant_id = kwargs['tenant_id']


class ServicePrincipalDatastoreSecrets(DatastoreSecrets):
    """Datastore Service Principal secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar client_secret: Service principal secret.
    :vartype client_secret: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_secret: Service principal secret.
        :paramtype client_secret: str
        """
        super(ServicePrincipalDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'ServicePrincipal'  # type: str
        self.client_secret = kwargs.get('client_secret', None)


class ServiceTagDestination(msrest.serialization.Model):
    """ServiceTagDestination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar action: Possible values include: "Allow", "Deny".
    :vartype action: str or ~azure.mgmt.machinelearningservices.models.RuleAction
    :ivar address_prefixes: Optional, if provided, the ServiceTag property will be ignored.
    :vartype address_prefixes: list[str]
    :ivar port_ranges:
    :vartype port_ranges: str
    :ivar protocol:
    :vartype protocol: str
    :ivar service_tag:
    :vartype service_tag: str
    """

    _validation = {
        'address_prefixes': {'readonly': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
        'port_ranges': {'key': 'portRanges', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_tag': {'key': 'serviceTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword action: Possible values include: "Allow", "Deny".
        :paramtype action: str or ~azure.mgmt.machinelearningservices.models.RuleAction
        :keyword port_ranges:
        :paramtype port_ranges: str
        :keyword protocol:
        :paramtype protocol: str
        :keyword service_tag:
        :paramtype service_tag: str
        """
        super(ServiceTagDestination, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.address_prefixes = None
        self.port_ranges = kwargs.get('port_ranges', None)
        self.protocol = kwargs.get('protocol', None)
        self.service_tag = kwargs.get('service_tag', None)


class ServiceTagOutboundRule(OutboundRule):
    """ServiceTagOutboundRule.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Possible values include: "Required", "Recommended", "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Possible values include: "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Required. Constant filled by server. Possible values include: "FQDN",
     "PrivateEndpoint", "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination:
    :vartype destination: ~azure.mgmt.machinelearningservices.models.ServiceTagDestination
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'ServiceTagDestination'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Possible values include: "Required", "Recommended", "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Possible values include: "Inactive", "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination:
        :paramtype destination: ~azure.mgmt.machinelearningservices.models.ServiceTagDestination
        """
        super(ServiceTagOutboundRule, self).__init__(**kwargs)
        self.type = 'ServiceTag'  # type: str
        self.destination = kwargs.get('destination', None)


class SharedPrivateLinkResource(msrest.serialization.Model):
    """SharedPrivateLinkResource.

    :ivar name: Unique name of the private link.
    :vartype name: str
    :ivar group_id: group id of the private link.
    :vartype group_id: str
    :ivar private_link_resource_id: the resource id that private link links to.
    :vartype private_link_resource_id: str
    :ivar request_message: Request message.
    :vartype request_message: str
    :ivar status: Connection status of the service consumer with the service provider
     Possible state transitions
     Pending -> Approved (Service provider approves the connection request)
     Pending -> Rejected (Service provider rejects the connection request)
     Pending -> Disconnected (Service provider deletes the connection)
     Approved -> Rejected (Service provider rejects the approved connection)
     Approved -> Disconnected (Service provider deletes the connection)
     Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
     Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
     "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Unique name of the private link.
        :paramtype name: str
        :keyword group_id: group id of the private link.
        :paramtype group_id: str
        :keyword private_link_resource_id: the resource id that private link links to.
        :paramtype private_link_resource_id: str
        :keyword request_message: Request message.
        :paramtype request_message: str
        :keyword status: Connection status of the service consumer with the service provider
         Possible state transitions
         Pending -> Approved (Service provider approves the connection request)
         Pending -> Rejected (Service provider rejects the connection request)
         Pending -> Disconnected (Service provider deletes the connection)
         Approved -> Rejected (Service provider rejects the approved connection)
         Approved -> Disconnected (Service provider deletes the connection)
         Rejected -> Pending (Service consumer re-initiates the connection request that was rejected)
         Rejected -> Disconnected (Service provider deletes the connection). Possible values include:
         "Approved", "Pending", "Rejected", "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
        """
        super(SharedPrivateLinkResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.group_id = kwargs.get('group_id', None)
        self.private_link_resource_id = kwargs.get('private_link_resource_id', None)
        self.request_message = kwargs.get('request_message', None)
        self.status = kwargs.get('status', None)


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)


class SkuCapacity(msrest.serialization.Model):
    """SKU capacity information.

    :ivar default: Gets or sets the default capacity.
    :vartype default: int
    :ivar maximum: Gets or sets the maximum.
    :vartype maximum: int
    :ivar minimum: Gets or sets the minimum.
    :vartype minimum: int
    :ivar scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword default: Gets or sets the default capacity.
        :paramtype default: int
        :keyword maximum: Gets or sets the maximum.
        :paramtype maximum: int
        :keyword minimum: Gets or sets the minimum.
        :paramtype minimum: int
        :keyword scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
         "Manual", "None".
        :paramtype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
        """
        super(SkuCapacity, self).__init__(**kwargs)
        self.default = kwargs.get('default', 0)
        self.maximum = kwargs.get('maximum', 0)
        self.minimum = kwargs.get('minimum', 0)
        self.scale_type = kwargs.get('scale_type', None)


class SkuResource(msrest.serialization.Model):
    """Fulfills ARM Contract requirement to list all available SKUS for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity: Gets or sets the Sku Capacity.
    :vartype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
    :ivar resource_type: The resource type name.
    :vartype resource_type: str
    :ivar sku: Gets or sets the Sku.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
    """

    _validation = {
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuSetting'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword capacity: Gets or sets the Sku Capacity.
        :paramtype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
        :keyword sku: Gets or sets the Sku.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
        """
        super(SkuResource, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.resource_type = None
        self.sku = kwargs.get('sku', None)


class SkuResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of SkuResource entities.

    :ivar next_link: The link to the next page of SkuResource objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type SkuResource.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SkuResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of SkuResource objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type SkuResource.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
        """
        super(SkuResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class SkuSetting(msrest.serialization.Model):
    """SkuSetting fulfills the need for stripped down SKU info in ARM contract.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. [Required] The name of the SKU. Ex - P3. It is typically a letter+number
     code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _validation = {
        'name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. [Required] The name of the SKU. Ex - P3. It is typically a
         letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(SkuSetting, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)


class SweepJob(JobBaseDetails):
    """Sweep job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar early_termination: Early termination policies enable canceling poor-performing runs
     before they complete.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Sweep Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
    :ivar objective: Required. [Required] Optimization objective.
    :vartype objective: ~azure.mgmt.machinelearningservices.models.Objective
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
    :vartype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
    :ivar search_space: Required. [Required] A dictionary containing each parameter and its
     distribution. The dictionary key is the name of the parameter.
    :vartype search_space: any
    :ivar trial: Required. [Required] Trial component definition.
    :vartype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'objective': {'required': True},
        'sampling_algorithm': {'required': True},
        'search_space': {'required': True},
        'trial': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'SweepJobLimits'},
        'objective': {'key': 'objective', 'type': 'Objective'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'SamplingAlgorithm'},
        'search_space': {'key': 'searchSpace', 'type': 'object'},
        'trial': {'key': 'trial', 'type': 'TrialComponent'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword early_termination: Early termination policies enable canceling poor-performing runs
         before they complete.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Sweep Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
        :keyword objective: Required. [Required] Optimization objective.
        :paramtype objective: ~azure.mgmt.machinelearningservices.models.Objective
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
        :paramtype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
        :keyword search_space: Required. [Required] A dictionary containing each parameter and its
         distribution. The dictionary key is the name of the parameter.
        :paramtype search_space: any
        :keyword trial: Required. [Required] Trial component definition.
        :paramtype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
        """
        super(SweepJob, self).__init__(**kwargs)
        self.job_type = 'Sweep'  # type: str
        self.early_termination = kwargs.get('early_termination', None)
        self.inputs = kwargs.get('inputs', None)
        self.limits = kwargs.get('limits', None)
        self.objective = kwargs['objective']
        self.outputs = kwargs.get('outputs', None)
        self.sampling_algorithm = kwargs['sampling_algorithm']
        self.search_space = kwargs['search_space']
        self.trial = kwargs['trial']


class SweepJobLimits(JobLimits):
    """Sweep Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar max_concurrent_trials: Sweep Job max concurrent trials.
    :vartype max_concurrent_trials: int
    :ivar max_total_trials: Sweep Job max total trials.
    :vartype max_total_trials: int
    :ivar trial_timeout: Sweep Job Trial timeout value.
    :vartype trial_timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_total_trials': {'key': 'maxTotalTrials', 'type': 'int'},
        'trial_timeout': {'key': 'trialTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        :keyword max_concurrent_trials: Sweep Job max concurrent trials.
        :paramtype max_concurrent_trials: int
        :keyword max_total_trials: Sweep Job max total trials.
        :paramtype max_total_trials: int
        :keyword trial_timeout: Sweep Job Trial timeout value.
        :paramtype trial_timeout: ~datetime.timedelta
        """
        super(SweepJobLimits, self).__init__(**kwargs)
        self.job_limits_type = 'Sweep'  # type: str
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', None)
        self.max_total_trials = kwargs.get('max_total_trials', None)
        self.trial_timeout = kwargs.get('trial_timeout', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TargetUtilizationScaleSettings(OnlineScaleSettings):
    """TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    :ivar max_instances: The maximum number of instances that the deployment can scale to. The
     quota will be reserved for max_instances.
    :vartype max_instances: int
    :ivar min_instances: The minimum number of instances to always be present.
    :vartype min_instances: int
    :ivar polling_interval: The polling interval in ISO 8691 format. Only supports duration with
     precision as low as Seconds.
    :vartype polling_interval: ~datetime.timedelta
    :ivar target_utilization_percentage: Target CPU usage for the autoscaler.
    :vartype target_utilization_percentage: int
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
        'max_instances': {'key': 'maxInstances', 'type': 'int'},
        'min_instances': {'key': 'minInstances', 'type': 'int'},
        'polling_interval': {'key': 'pollingInterval', 'type': 'duration'},
        'target_utilization_percentage': {'key': 'targetUtilizationPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_instances: The maximum number of instances that the deployment can scale to. The
         quota will be reserved for max_instances.
        :paramtype max_instances: int
        :keyword min_instances: The minimum number of instances to always be present.
        :paramtype min_instances: int
        :keyword polling_interval: The polling interval in ISO 8691 format. Only supports duration with
         precision as low as Seconds.
        :paramtype polling_interval: ~datetime.timedelta
        :keyword target_utilization_percentage: Target CPU usage for the autoscaler.
        :paramtype target_utilization_percentage: int
        """
        super(TargetUtilizationScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'TargetUtilization'  # type: str
        self.max_instances = kwargs.get('max_instances', 1)
        self.min_instances = kwargs.get('min_instances', 1)
        self.polling_interval = kwargs.get('polling_interval', "PT1S")
        self.target_utilization_percentage = kwargs.get('target_utilization_percentage', 70)


class TensorFlow(DistributionConfiguration):
    """TensorFlow distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar parameter_server_count: Number of parameter server tasks.
    :vartype parameter_server_count: int
    :ivar worker_count: Number of workers. If not specified, will default to the instance count.
    :vartype worker_count: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'parameter_server_count': {'key': 'parameterServerCount', 'type': 'int'},
        'worker_count': {'key': 'workerCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameter_server_count: Number of parameter server tasks.
        :paramtype parameter_server_count: int
        :keyword worker_count: Number of workers. If not specified, will default to the instance count.
        :paramtype worker_count: int
        """
        super(TensorFlow, self).__init__(**kwargs)
        self.distribution_type = 'TensorFlow'  # type: str
        self.parameter_server_count = kwargs.get('parameter_server_count', 0)
        self.worker_count = kwargs.get('worker_count', None)


class TrialComponent(msrest.serialization.Model):
    """Trial component definition.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    """

    _validation = {
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        """
        super(TrialComponent, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.command = kwargs['command']
        self.distribution = kwargs.get('distribution', None)
        self.environment_id = kwargs['environment_id']
        self.environment_variables = kwargs.get('environment_variables', None)
        self.resources = kwargs.get('resources', None)


class TritonModelJobInput(JobInput, AssetJobInput):
    """TritonModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(TritonModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'triton_model'  # type: str
        self.description = kwargs.get('description', None)


class TritonModelJobOutput(JobOutput, AssetJobOutput):
    """TritonModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(TritonModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'triton_model'  # type: str
        self.description = kwargs.get('description', None)


class TruncationSelectionPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar truncation_percentage: The percentage of runs to cancel at each evaluation interval.
    :vartype truncation_percentage: int
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'truncation_percentage': {'key': 'truncationPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        :paramtype truncation_percentage: int
        """
        super(TruncationSelectionPolicy, self).__init__(**kwargs)
        self.policy_type = 'TruncationSelection'  # type: str
        self.truncation_percentage = kwargs.get('truncation_percentage', 0)


class UriFileDataVersion(DataVersionBaseDetails):
    """uri-file data version entity.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(UriFileDataVersion, self).__init__(**kwargs)
        self.data_type = 'uri_file'  # type: str


class UriFileJobInput(JobInput, AssetJobInput):
    """UriFileJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFileJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'uri_file'  # type: str
        self.description = kwargs.get('description', None)


class UriFileJobOutput(JobOutput, AssetJobOutput):
    """UriFileJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFileJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'uri_file'  # type: str
        self.description = kwargs.get('description', None)


class UriFolderDataVersion(DataVersionBaseDetails):
    """uri-folder data version entity.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "uri_file", "uri_folder", "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220501.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(UriFolderDataVersion, self).__init__(**kwargs)
        self.data_type = 'uri_folder'  # type: str


class UriFolderJobInput(JobInput, AssetJobInput):
    """UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "literal", "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFolderJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'uri_folder'  # type: str
        self.description = kwargs.get('description', None)


class UriFolderJobOutput(JobOutput, AssetJobOutput):
    """UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "uri_file", "uri_folder", "mltable", "custom_model",
     "mlflow_model", "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFolderJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'uri_folder'  # type: str
        self.description = kwargs.get('description', None)


class UserAssignedIdentity(msrest.serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserIdentity(IdentityConfiguration):
    """User identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserIdentity, self).__init__(**kwargs)
        self.identity_type = 'UserIdentity'  # type: str


class UsernamePasswordAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal", "AccessKey", "ApiKey", "CustomKeys".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
     "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
     "CognitiveSearch", "CognitiveService", "CustomKeys".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar expiry_time:
    :vartype expiry_time: ~datetime.datetime
    :ivar metadata: Dictionary of :code:`<AnyObject>`.
    :vartype metadata: dict[str, any]
    :ivar target:
    :vartype target: str
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionUsernamePassword
    """

    _validation = {
        'auth_type': {'required': True},
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'target': {'key': 'target', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'WorkspaceConnectionUsernamePassword'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "S3", "Snowflake", "AzureSqlDb", "AzureSynapseAnalytics",
         "AzureMySqlDb", "AzurePostgresDb", "ADLSGen2", "Redis", "ApiKey", "AzureOpenAI",
         "CognitiveSearch", "CognitiveService", "CustomKeys".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword expiry_time:
        :paramtype expiry_time: ~datetime.datetime
        :keyword target:
        :paramtype target: str
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionUsernamePassword
        """
        super(UsernamePasswordAuthTypeWorkspaceConnectionProperties, self).__init__(**kwargs)
        self.auth_type = 'UsernamePassword'  # type: str
        self.credentials = kwargs.get('credentials', None)


class Workspace(Resource):
    """Workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind:
    :vartype kind: str
    :ivar location:
    :vartype location: str
    :ivar sku: Optional. This field is required to be implemented by the RP because AML is
     supporting more than one tier.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar allow_public_access_when_behind_vnet: The flag to indicate whether to allow public access
     when behind VNet.
    :vartype allow_public_access_when_behind_vnet: bool
    :ivar application_insights: ARM id of the application insights associated with this workspace.
    :vartype application_insights: str
    :ivar associated_workspaces:
    :vartype associated_workspaces: list[str]
    :ivar container_registries:
    :vartype container_registries: list[str]
    :ivar container_registry: ARM id of the container registry associated with this workspace.
    :vartype container_registry: str
    :ivar description: The description of this workspace.
    :vartype description: str
    :ivar discovery_url: Url for the discovery service to identify regional endpoints for machine
     learning experimentation services.
    :vartype discovery_url: str
    :ivar enable_data_isolation:
    :vartype enable_data_isolation: bool
    :ivar encryption:
    :vartype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionProperty
    :ivar existing_workspaces:
    :vartype existing_workspaces: list[str]
    :ivar feature_store_settings: Settings for feature store type workspace.
    :vartype feature_store_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureStoreSettings
    :ivar friendly_name: The friendly name for this workspace. This name in mutable.
    :vartype friendly_name: str
    :ivar hbi_workspace: The flag to signal HBI data in the workspace and reduce diagnostic data
     collected by the service.
    :vartype hbi_workspace: bool
    :ivar hub_resource_id:
    :vartype hub_resource_id: str
    :ivar image_build_compute: The compute name for image build.
    :vartype image_build_compute: str
    :ivar key_vault: ARM id of the key vault associated with this workspace. This cannot be changed
     once the workspace has been created.
    :vartype key_vault: str
    :ivar key_vaults:
    :vartype key_vaults: list[str]
    :ivar managed_network: Anything.
    :vartype managed_network: any
    :ivar ml_flow_tracking_uri: The URI associated with this workspace that machine learning flow
     must point at to set up tracking.
    :vartype ml_flow_tracking_uri: str
    :ivar notebook_info: The notebook info of Azure ML workspace.
    :vartype notebook_info: ~azure.mgmt.machinelearningservices.models.NotebookResourceInfo
    :ivar primary_user_assigned_identity: The user assigned identity resource id that represents
     the workspace identity.
    :vartype primary_user_assigned_identity: str
    :ivar private_endpoint_connections: The list of private endpoint connections in the workspace.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    :ivar private_link_count: Count of private connections in the workspace.
    :vartype private_link_count: int
    :ivar provisioning_state: The current deployment state of workspace resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Unknown", "Updating", "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar public_network_access: Whether requests from Public Network are allowed. Possible values
     include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar service_managed_resources_settings: The service managed resource settings.
    :vartype service_managed_resources_settings:
     ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
    :ivar service_provisioned_resource_group: The name of the managed resource group created by
     workspace RP in customer subscription if the workspace is CMK workspace.
    :vartype service_provisioned_resource_group: str
    :ivar shared_private_link_resources: The list of shared private link resources in this
     workspace.
    :vartype shared_private_link_resources:
     list[~azure.mgmt.machinelearningservices.models.SharedPrivateLinkResource]
    :ivar soft_delete_retention_in_days: Retention time in days after workspace get soft deleted.
    :vartype soft_delete_retention_in_days: int
    :ivar storage_account: ARM id of the storage account associated with this workspace. This
     cannot be changed once the workspace has been created.
    :vartype storage_account: str
    :ivar storage_accounts:
    :vartype storage_accounts: list[str]
    :ivar storage_hns_enabled: If the storage associated with the workspace has hierarchical
     namespace(HNS) enabled.
    :vartype storage_hns_enabled: bool
    :ivar system_datastores_auth_mode: The auth mode used for accessing the system datastores of
     the workspace.
    :vartype system_datastores_auth_mode: str
    :ivar tenant_id: The tenant id associated with this workspace.
    :vartype tenant_id: str
    :ivar v1_legacy_mode: Enabling v1_legacy_mode may prevent you from using features provided by
     the v2 API.
    :vartype v1_legacy_mode: bool
    :ivar workspace_hub_config:
    :vartype workspace_hub_config: ~azure.mgmt.machinelearningservices.models.WorkspaceHubConfig
    :ivar workspace_id: The immutable id associated with this workspace.
    :vartype workspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'ml_flow_tracking_uri': {'readonly': True},
        'notebook_info': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'private_link_count': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'service_provisioned_resource_group': {'readonly': True},
        'storage_hns_enabled': {'readonly': True},
        'tenant_id': {'readonly': True},
        'workspace_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'allow_public_access_when_behind_vnet': {'key': 'properties.allowPublicAccessWhenBehindVnet', 'type': 'bool'},
        'application_insights': {'key': 'properties.applicationInsights', 'type': 'str'},
        'associated_workspaces': {'key': 'properties.associatedWorkspaces', 'type': '[str]'},
        'container_registries': {'key': 'properties.containerRegistries', 'type': '[str]'},
        'container_registry': {'key': 'properties.containerRegistry', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'discovery_url': {'key': 'properties.discoveryUrl', 'type': 'str'},
        'enable_data_isolation': {'key': 'properties.enableDataIsolation', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperty'},
        'existing_workspaces': {'key': 'properties.existingWorkspaces', 'type': '[str]'},
        'feature_store_settings': {'key': 'properties.featureStoreSettings', 'type': 'FeatureStoreSettings'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'hbi_workspace': {'key': 'properties.hbiWorkspace', 'type': 'bool'},
        'hub_resource_id': {'key': 'properties.hubResourceId', 'type': 'str'},
        'image_build_compute': {'key': 'properties.imageBuildCompute', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'str'},
        'key_vaults': {'key': 'properties.keyVaults', 'type': '[str]'},
        'managed_network': {'key': 'properties.managedNetwork', 'type': 'object'},
        'ml_flow_tracking_uri': {'key': 'properties.mlFlowTrackingUri', 'type': 'str'},
        'notebook_info': {'key': 'properties.notebookInfo', 'type': 'NotebookResourceInfo'},
        'primary_user_assigned_identity': {'key': 'properties.primaryUserAssignedIdentity', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'private_link_count': {'key': 'properties.privateLinkCount', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'service_managed_resources_settings': {'key': 'properties.serviceManagedResourcesSettings', 'type': 'ServiceManagedResourcesSettings'},
        'service_provisioned_resource_group': {'key': 'properties.serviceProvisionedResourceGroup', 'type': 'str'},
        'shared_private_link_resources': {'key': 'properties.sharedPrivateLinkResources', 'type': '[SharedPrivateLinkResource]'},
        'soft_delete_retention_in_days': {'key': 'properties.softDeleteRetentionInDays', 'type': 'int'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'str'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[str]'},
        'storage_hns_enabled': {'key': 'properties.storageHnsEnabled', 'type': 'bool'},
        'system_datastores_auth_mode': {'key': 'properties.systemDatastoresAuthMode', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'v1_legacy_mode': {'key': 'properties.v1LegacyMode', 'type': 'bool'},
        'workspace_hub_config': {'key': 'properties.workspaceHubConfig', 'type': 'WorkspaceHubConfig'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind:
        :paramtype kind: str
        :keyword location:
        :paramtype location: str
        :keyword sku: Optional. This field is required to be implemented by the RP because AML is
         supporting more than one tier.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword allow_public_access_when_behind_vnet: The flag to indicate whether to allow public
         access when behind VNet.
        :paramtype allow_public_access_when_behind_vnet: bool
        :keyword application_insights: ARM id of the application insights associated with this
         workspace.
        :paramtype application_insights: str
        :keyword associated_workspaces:
        :paramtype associated_workspaces: list[str]
        :keyword container_registries:
        :paramtype container_registries: list[str]
        :keyword container_registry: ARM id of the container registry associated with this workspace.
        :paramtype container_registry: str
        :keyword description: The description of this workspace.
        :paramtype description: str
        :keyword discovery_url: Url for the discovery service to identify regional endpoints for
         machine learning experimentation services.
        :paramtype discovery_url: str
        :keyword enable_data_isolation:
        :paramtype enable_data_isolation: bool
        :keyword encryption:
        :paramtype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionProperty
        :keyword existing_workspaces:
        :paramtype existing_workspaces: list[str]
        :keyword feature_store_settings: Settings for feature store type workspace.
        :paramtype feature_store_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureStoreSettings
        :keyword friendly_name: The friendly name for this workspace. This name in mutable.
        :paramtype friendly_name: str
        :keyword hbi_workspace: The flag to signal HBI data in the workspace and reduce diagnostic data
         collected by the service.
        :paramtype hbi_workspace: bool
        :keyword hub_resource_id:
        :paramtype hub_resource_id: str
        :keyword image_build_compute: The compute name for image build.
        :paramtype image_build_compute: str
        :keyword key_vault: ARM id of the key vault associated with this workspace. This cannot be
         changed once the workspace has been created.
        :paramtype key_vault: str
        :keyword key_vaults:
        :paramtype key_vaults: list[str]
        :keyword managed_network: Anything.
        :paramtype managed_network: any
        :keyword primary_user_assigned_identity: The user assigned identity resource id that represents
         the workspace identity.
        :paramtype primary_user_assigned_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Possible
         values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword service_managed_resources_settings: The service managed resource settings.
        :paramtype service_managed_resources_settings:
         ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
        :keyword shared_private_link_resources: The list of shared private link resources in this
         workspace.
        :paramtype shared_private_link_resources:
         list[~azure.mgmt.machinelearningservices.models.SharedPrivateLinkResource]
        :keyword soft_delete_retention_in_days: Retention time in days after workspace get soft
         deleted.
        :paramtype soft_delete_retention_in_days: int
        :keyword storage_account: ARM id of the storage account associated with this workspace. This
         cannot be changed once the workspace has been created.
        :paramtype storage_account: str
        :keyword storage_accounts:
        :paramtype storage_accounts: list[str]
        :keyword system_datastores_auth_mode: The auth mode used for accessing the system datastores of
         the workspace.
        :paramtype system_datastores_auth_mode: str
        :keyword v1_legacy_mode: Enabling v1_legacy_mode may prevent you from using features provided
         by the v2 API.
        :paramtype v1_legacy_mode: bool
        :keyword workspace_hub_config:
        :paramtype workspace_hub_config: ~azure.mgmt.machinelearningservices.models.WorkspaceHubConfig
        """
        super(Workspace, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.allow_public_access_when_behind_vnet = kwargs.get('allow_public_access_when_behind_vnet', None)
        self.application_insights = kwargs.get('application_insights', None)
        self.associated_workspaces = kwargs.get('associated_workspaces', None)
        self.container_registries = kwargs.get('container_registries', None)
        self.container_registry = kwargs.get('container_registry', None)
        self.description = kwargs.get('description', None)
        self.discovery_url = kwargs.get('discovery_url', None)
        self.enable_data_isolation = kwargs.get('enable_data_isolation', None)
        self.encryption = kwargs.get('encryption', None)
        self.existing_workspaces = kwargs.get('existing_workspaces', None)
        self.feature_store_settings = kwargs.get('feature_store_settings', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.hbi_workspace = kwargs.get('hbi_workspace', None)
        self.hub_resource_id = kwargs.get('hub_resource_id', None)
        self.image_build_compute = kwargs.get('image_build_compute', None)
        self.key_vault = kwargs.get('key_vault', None)
        self.key_vaults = kwargs.get('key_vaults', None)
        self.managed_network = kwargs.get('managed_network', None)
        self.ml_flow_tracking_uri = None
        self.notebook_info = None
        self.primary_user_assigned_identity = kwargs.get('primary_user_assigned_identity', None)
        self.private_endpoint_connections = None
        self.private_link_count = None
        self.provisioning_state = None
        self.public_network_access = kwargs.get('public_network_access', None)
        self.service_managed_resources_settings = kwargs.get('service_managed_resources_settings', None)
        self.service_provisioned_resource_group = None
        self.shared_private_link_resources = kwargs.get('shared_private_link_resources', None)
        self.soft_delete_retention_in_days = kwargs.get('soft_delete_retention_in_days', None)
        self.storage_account = kwargs.get('storage_account', None)
        self.storage_accounts = kwargs.get('storage_accounts', None)
        self.storage_hns_enabled = None
        self.system_datastores_auth_mode = kwargs.get('system_datastores_auth_mode', None)
        self.tenant_id = None
        self.v1_legacy_mode = kwargs.get('v1_legacy_mode', None)
        self.workspace_hub_config = kwargs.get('workspace_hub_config', None)
        self.workspace_id = None


class WorkspaceConnectionAccessKey(msrest.serialization.Model):
    """WorkspaceConnectionAccessKey.

    :ivar access_key_id:
    :vartype access_key_id: str
    :ivar secret_access_key:
    :vartype secret_access_key: str
    """

    _attribute_map = {
        'access_key_id': {'key': 'accessKeyId', 'type': 'str'},
        'secret_access_key': {'key': 'secretAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword access_key_id:
        :paramtype access_key_id: str
        :keyword secret_access_key:
        :paramtype secret_access_key: str
        """
        super(WorkspaceConnectionAccessKey, self).__init__(**kwargs)
        self.access_key_id = kwargs.get('access_key_id', None)
        self.secret_access_key = kwargs.get('secret_access_key', None)


class WorkspaceConnectionApiKey(msrest.serialization.Model):
    """WorkspaceConnectionApiKey.

    :ivar key:
    :vartype key: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key:
        :paramtype key: str
        """
        super(WorkspaceConnectionApiKey, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)


class WorkspaceConnectionManagedIdentity(msrest.serialization.Model):
    """WorkspaceConnectionManagedIdentity.

    :ivar client_id:
    :vartype client_id: str
    :ivar resource_id:
    :vartype resource_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_id:
        :paramtype client_id: str
        :keyword resource_id:
        :paramtype resource_id: str
        """
        super(WorkspaceConnectionManagedIdentity, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.resource_id = kwargs.get('resource_id', None)


class WorkspaceConnectionPersonalAccessToken(msrest.serialization.Model):
    """WorkspaceConnectionPersonalAccessToken.

    :ivar pat:
    :vartype pat: str
    """

    _attribute_map = {
        'pat': {'key': 'pat', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword pat:
        :paramtype pat: str
        """
        super(WorkspaceConnectionPersonalAccessToken, self).__init__(**kwargs)
        self.pat = kwargs.get('pat', None)


class WorkspaceConnectionPropertiesV2BasicResource(Resource):
    """WorkspaceConnectionPropertiesV2BasicResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'WorkspaceConnectionPropertiesV2'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
        """
        super(WorkspaceConnectionPropertiesV2BasicResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value:
     list[~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2BasicResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[WorkspaceConnectionPropertiesV2BasicResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2BasicResource]
        """
        super(WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class WorkspaceConnectionServicePrincipal(msrest.serialization.Model):
    """WorkspaceConnectionServicePrincipal.

    :ivar client_id:
    :vartype client_id: str
    :ivar client_secret:
    :vartype client_secret: str
    :ivar tenant_id:
    :vartype tenant_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_id:
        :paramtype client_id: str
        :keyword client_secret:
        :paramtype client_secret: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        """
        super(WorkspaceConnectionServicePrincipal, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class WorkspaceConnectionSharedAccessSignature(msrest.serialization.Model):
    """WorkspaceConnectionSharedAccessSignature.

    :ivar sas:
    :vartype sas: str
    """

    _attribute_map = {
        'sas': {'key': 'sas', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sas:
        :paramtype sas: str
        """
        super(WorkspaceConnectionSharedAccessSignature, self).__init__(**kwargs)
        self.sas = kwargs.get('sas', None)


class WorkspaceConnectionUpdateParameter(msrest.serialization.Model):
    """WorkspaceConnectionUpdateParameter.

    :ivar properties: The properties that the machine learning workspace connection will be updated
     with.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'WorkspaceConnectionPropertiesV2'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: The properties that the machine learning workspace connection will be
         updated with.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
        """
        super(WorkspaceConnectionUpdateParameter, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class WorkspaceConnectionUsernamePassword(msrest.serialization.Model):
    """WorkspaceConnectionUsernamePassword.

    :ivar password:
    :vartype password: str
    :ivar username:
    :vartype username: str
    """

    _attribute_map = {
        'password': {'key': 'password', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword password:
        :paramtype password: str
        :keyword username:
        :paramtype username: str
        """
        super(WorkspaceConnectionUsernamePassword, self).__init__(**kwargs)
        self.password = kwargs.get('password', None)
        self.username = kwargs.get('username', None)


class WorkspaceHubConfig(msrest.serialization.Model):
    """WorkspaceHubConfig.

    :ivar additional_workspace_storage_accounts:
    :vartype additional_workspace_storage_accounts: list[str]
    :ivar default_workspace_resource_group:
    :vartype default_workspace_resource_group: str
    """

    _attribute_map = {
        'additional_workspace_storage_accounts': {'key': 'additionalWorkspaceStorageAccounts', 'type': '[str]'},
        'default_workspace_resource_group': {'key': 'defaultWorkspaceResourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_workspace_storage_accounts:
        :paramtype additional_workspace_storage_accounts: list[str]
        :keyword default_workspace_resource_group:
        :paramtype default_workspace_resource_group: str
        """
        super(WorkspaceHubConfig, self).__init__(**kwargs)
        self.additional_workspace_storage_accounts = kwargs.get('additional_workspace_storage_accounts', None)
        self.default_workspace_resource_group = kwargs.get('default_workspace_resource_group', None)


class WorkspaceListResult(msrest.serialization.Model):
    """The result of a request to list machine learning workspaces.

    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: The list of machine learning workspaces. Since this list may be incomplete, the
     nextLink field should be used to request the next list of machine learning workspaces.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Workspace]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Workspace]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        :keyword value: The list of machine learning workspaces. Since this list may be incomplete, the
         nextLink field should be used to request the next list of machine learning workspaces.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Workspace]
        """
        super(WorkspaceListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class WorkspacePrivateEndpointResource(msrest.serialization.Model):
    """WorkspacePrivateEndpointResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: e.g.
     /subscriptions/{networkSubscriptionId}/resourceGroups/{rgName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}.
    :vartype id: str
    :ivar subnet_arm_id: The subnetId that the private endpoint is connected to.
    :vartype subnet_arm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'subnet_arm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet_arm_id': {'key': 'subnetArmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(WorkspacePrivateEndpointResource, self).__init__(**kwargs)
        self.id = None
        self.subnet_arm_id = None


class WorkspaceUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a machine learning workspace.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar sku: Optional. This field is required to be implemented by the RP because AML is
     supporting more than one tier.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar tags: A set of tags. The resource tags for the machine learning workspace.
    :vartype tags: dict[str, str]
    :ivar application_insights: ARM id of the application insights associated with this workspace.
    :vartype application_insights: str
    :ivar container_registry: ARM id of the container registry associated with this workspace.
    :vartype container_registry: str
    :ivar description: The description of this workspace.
    :vartype description: str
    :ivar enable_data_isolation:
    :vartype enable_data_isolation: bool
    :ivar encryption:
    :vartype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionUpdateProperties
    :ivar feature_store_settings: Settings for feature store type workspace.
    :vartype feature_store_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureStoreSettings
    :ivar friendly_name: The friendly name for this workspace. This name in mutable.
    :vartype friendly_name: str
    :ivar image_build_compute: The compute name for image build.
    :vartype image_build_compute: str
    :ivar managed_network: Anything.
    :vartype managed_network: any
    :ivar primary_user_assigned_identity: The user assigned identity resource id that represents
     the workspace identity.
    :vartype primary_user_assigned_identity: str
    :ivar public_network_access: Whether requests from Public Network are allowed. Possible values
     include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar service_managed_resources_settings: The service managed resource settings.
    :vartype service_managed_resources_settings:
     ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
    :ivar soft_delete_retention_in_days: Retention time in days after workspace get soft deleted.
    :vartype soft_delete_retention_in_days: int
    :ivar v1_legacy_mode: Enabling v1_legacy_mode may prevent you from using features provided by
     the v2 API.
    :vartype v1_legacy_mode: bool
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'application_insights': {'key': 'properties.applicationInsights', 'type': 'str'},
        'container_registry': {'key': 'properties.containerRegistry', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'enable_data_isolation': {'key': 'properties.enableDataIsolation', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionUpdateProperties'},
        'feature_store_settings': {'key': 'properties.featureStoreSettings', 'type': 'FeatureStoreSettings'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'image_build_compute': {'key': 'properties.imageBuildCompute', 'type': 'str'},
        'managed_network': {'key': 'properties.managedNetwork', 'type': 'object'},
        'primary_user_assigned_identity': {'key': 'properties.primaryUserAssignedIdentity', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'service_managed_resources_settings': {'key': 'properties.serviceManagedResourcesSettings', 'type': 'ServiceManagedResourcesSettings'},
        'soft_delete_retention_in_days': {'key': 'properties.softDeleteRetentionInDays', 'type': 'int'},
        'v1_legacy_mode': {'key': 'properties.v1LegacyMode', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword sku: Optional. This field is required to be implemented by the RP because AML is
         supporting more than one tier.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword tags: A set of tags. The resource tags for the machine learning workspace.
        :paramtype tags: dict[str, str]
        :keyword application_insights: ARM id of the application insights associated with this
         workspace.
        :paramtype application_insights: str
        :keyword container_registry: ARM id of the container registry associated with this workspace.
        :paramtype container_registry: str
        :keyword description: The description of this workspace.
        :paramtype description: str
        :keyword enable_data_isolation:
        :paramtype enable_data_isolation: bool
        :keyword encryption:
        :paramtype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionUpdateProperties
        :keyword feature_store_settings: Settings for feature store type workspace.
        :paramtype feature_store_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureStoreSettings
        :keyword friendly_name: The friendly name for this workspace. This name in mutable.
        :paramtype friendly_name: str
        :keyword image_build_compute: The compute name for image build.
        :paramtype image_build_compute: str
        :keyword managed_network: Anything.
        :paramtype managed_network: any
        :keyword primary_user_assigned_identity: The user assigned identity resource id that represents
         the workspace identity.
        :paramtype primary_user_assigned_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Possible
         values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword service_managed_resources_settings: The service managed resource settings.
        :paramtype service_managed_resources_settings:
         ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
        :keyword soft_delete_retention_in_days: Retention time in days after workspace get soft
         deleted.
        :paramtype soft_delete_retention_in_days: int
        :keyword v1_legacy_mode: Enabling v1_legacy_mode may prevent you from using features provided
         by the v2 API.
        :paramtype v1_legacy_mode: bool
        """
        super(WorkspaceUpdateParameters, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.application_insights = kwargs.get('application_insights', None)
        self.container_registry = kwargs.get('container_registry', None)
        self.description = kwargs.get('description', None)
        self.enable_data_isolation = kwargs.get('enable_data_isolation', None)
        self.encryption = kwargs.get('encryption', None)
        self.feature_store_settings = kwargs.get('feature_store_settings', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.image_build_compute = kwargs.get('image_build_compute', None)
        self.managed_network = kwargs.get('managed_network', None)
        self.primary_user_assigned_identity = kwargs.get('primary_user_assigned_identity', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.service_managed_resources_settings = kwargs.get('service_managed_resources_settings', None)
        self.soft_delete_retention_in_days = kwargs.get('soft_delete_retention_in_days', None)
        self.v1_legacy_mode = kwargs.get('v1_legacy_mode', None)
