# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, Union
from typing_extensions import Self

from azure.core import PipelineClient
from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse

from . import models as _models
from ._configuration import AzureFileStorageConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import DirectoryOperations, FileOperations, ServiceOperations, ShareOperations


class AzureFileStorage:  # pylint: disable=client-accepts-api-version-keyword
    """AzureFileStorage.

    :ivar service: ServiceOperations operations
    :vartype service: azure.storage.fileshare.operations.ServiceOperations
    :ivar share: ShareOperations operations
    :vartype share: azure.storage.fileshare.operations.ShareOperations
    :ivar directory: DirectoryOperations operations
    :vartype directory: azure.storage.fileshare.operations.DirectoryOperations
    :ivar file: FileOperations operations
    :vartype file: azure.storage.fileshare.operations.FileOperations
    :param url: The URL of the service account, share, directory or file that is the target of the
     desired operation. Required.
    :type url: str
    :param base_url: Service URL. Required. Default value is "".
    :type base_url: str
    :param file_request_intent: Valid value is backup. "backup" Default value is None.
    :type file_request_intent: str or ~azure.storage.fileshare.models.ShareTokenIntent
    :param allow_trailing_dot: If true, the trailing dot will not be trimmed from the target URI.
     Default value is None.
    :type allow_trailing_dot: bool
    :param allow_source_trailing_dot: If true, the trailing dot will not be trimmed from the source
     URI. Default value is None.
    :type allow_source_trailing_dot: bool
    :keyword version: Specifies the version of the operation to use for this request. Default value
     is "2026-02-06". Note that overriding this default value may result in unsupported behavior.
    :paramtype version: str
    :keyword file_range_write_from_url: Only update is supported: - Update: Writes the bytes
     downloaded from the source url into the specified range. Default value is "update". Note that
     overriding this default value may result in unsupported behavior.
    :paramtype file_range_write_from_url: str
    """

    def __init__(  # pylint: disable=missing-client-constructor-parameter-credential
        self,
        url: str,
        base_url: str = "",
        file_request_intent: Optional[Union[str, _models.ShareTokenIntent]] = None,
        allow_trailing_dot: Optional[bool] = None,
        allow_source_trailing_dot: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        self._config = AzureFileStorageConfiguration(
            url=url,
            file_request_intent=file_request_intent,
            allow_trailing_dot=allow_trailing_dot,
            allow_source_trailing_dot=allow_source_trailing_dot,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: PipelineClient = PipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.service = ServiceOperations(self._client, self._config, self._serialize, self._deserialize)
        self.share = ShareOperations(self._client, self._config, self._serialize, self._deserialize)
        self.directory = DirectoryOperations(self._client, self._config, self._serialize, self._deserialize)
        self.file = FileOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
