#!/usr/bin/env python

#  Copyright (c) 2005 Gavin E. Crooks <gec@threeplusone.com>
#
#  This software is distributed under the MIT Open Source License.
#  <http://www.opensource.org/licenses/mit-license.html>
#
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#  THE SOFTWARE.
#

"""
Null sequence IO. Acts like /dev/null. Read returns empty sequences or sequence lists,
writes do nothing.
"""


from typing import Iterator, Optional, TextIO

from ..seq import Alphabet, Seq, SeqList

names = ()
extensions = ()


def read(fin: TextIO, alphabet: Optional[Alphabet] = None) -> SeqList:
    assert fin is not None  # Do something with arguments to quiet pychecker
    # if alphabet is not None:
    #     pass
    return SeqList([])


def iterseq(fin: TextIO, alphabet: Optional[Alphabet] = None) -> Iterator[Seq]:
    assert fin is not None
    # if alphabet is not None:
    #     pass
    yield Seq("")
    return


def write(fout: TextIO, seqs: SeqList) -> None:
    for s in seqs:
        writeseq(fout, s)


def writeseq(fout: TextIO, seq: SeqList) -> None:
    assert fout is not None
    assert seq is not None
    return
