% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LengESCData.R
\name{LengESCData}
\alias{LengESCData}
\title{Obtain the Leng ESC data}
\usage{
LengESCData(ensembl = FALSE, location = TRUE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether gene symbols should be converted to Ensembl annotation.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of normalized expected read counts.
}
\description{
Obtain the human embryonic stem cell single-cell RNA-seq data from Leng et al. (2015).
}
\details{
Column metadata contains the cell line, experiment number and experimentally determined cell cycle phase for each cell.

If \code{ensembl=TRUE}, the gene symbols in the published annotation are converted to Ensembl.
If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/leng-esc}.
}
\examples{
sce <- LengESCData()

}
\references{
Leng F et al. (2015).
Oscope identifies oscillatory genes in unsynchronized single-cell RNA-seq experiments. 
\emph{Nat. Methods} 12(10), 947-950.
}
\author{
Aaron Lun
}
