% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{translateDNA}
\alias{translateDNA}
\title{Translate nucleotide sequences to amino acids}
\usage{
translateDNA(seq, trim = FALSE)
}
\arguments{
\item{seq}{vector of strings defining DNA sequence(s) to be converted to translated.}

\item{trim}{boolean flag to remove 3 nts from both ends of seq
(converts IMGT junction to CDR3 region).}
}
\value{
A vector of translated sequence strings.
}
\description{
\code{translateDNA} translates nucleotide sequences to amino acid sequences.
}
\examples{
# Translate a single sequence
translateDNA("ACTGACTCGA")

# Translate a vector of sequences
translateDNA(ExampleDb$JUNCTION[1:3])

# Remove the first and last codon from the translation
translateDNA(ExampleDb$JUNCTION[1:3], trim=TRUE)

}
\seealso{
\code{\link[seqinr]{translate}}.
}
