\name{write.pir}
\alias{write.pir}
\title{ Write PIR Formated Sequences }
\description{
  Write aligned or un-aligned sequences to a PIR format file.
}
\usage{
write.pir(alignment=NULL, ids=NULL, seqs=alignment$ali, 
   pdb.file = NULL, chain.first = NULL, resno.first = NULL,
   chain.last = NULL, resno.last = NULL, file, append = FALSE)
}
\arguments{
  \item{alignment}{  an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}}. }
  \item{ids}{ a vector of sequence names to serve as sequence identifers }
  \item{seqs}{ an sequence or alignment character matrix or vector with a row per sequence }
  \item{pdb.file}{ a vector of pdb filenames; For sequence, provide "". }
  \item{chain.first}{ a vector of chain id for the first residue. }
  \item{resno.first}{ a vector of residue number for the first residue. }
  \item{chain.last}{ a vector of chain id for the last residue. }
  \item{resno.last}{ a vector of residue number for the last residue. }
  \item{file}{ name of output file.  }
  \item{append}{ logical, if TRUE output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}. }
}
\value{
  Called for its effect.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
 }
\author{ Xin-Qiu Yao }
\note{
  PIR is required format for input alignment file to use Modeller. 
  For a description of PIR format see:
  \url{https://salilab.org/modeller/manual/node488.html}.
}
\seealso{ \code{\link{read.fasta}}, \code{\link{read.fasta.pdb}}, 
   \code{\link{write.fasta}} }
\examples{
\donttest{
# Needs MUSCLE installed - testing excluded

if(check.utility("muscle")) {

## Generate an input file for structural modeling of 
## transducin G-alpha subunit using the template 3SN6_A

## Read transducin alpha subunit sequence
seq <- get.seq("P04695", db = "uniprot", outfile = tempfile())

## Read structure template
path = tempdir()
pdb.file <- get.pdb("3sn6_A", path = path, split = TRUE)
pdb <- read.pdb(pdb.file)

## Build an alignment between template and target
aln <- seqaln(seqbind(pdbseq(pdb), seq), id = c("3sn6_A", seq$id), outfile = tempfile())

## Write PIR format alignment file
outfile = file.path(tempdir(), "eg.pir")
write.pir(aln, pdb.file = c(pdb.file, ""), file = outfile)

invisible( cat("\nSee the output file:", outfile, sep = "\n") )

}
}
}
\keyword{ IO }
