\name{perturbNetwork}
\Rdversion{1.1}
\alias{perturbNetwork}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Perturb a Boolean network randomly
}
\description{
Modifies a synchronous, asynchronous, or probabilistic Boolean network by randomly perturbing  either the functions for single genes or the state transitions. Random perturbations can be employed to assess the stability of the network.
}
\usage{
perturbNetwork(network, 
               perturb = c("functions","transitions"), 
               method = c("bitflip","shuffle"), 
               simplify = (perturb[1]!="functions"), 
               readableFunctions = FALSE, 
               excludeFixed = TRUE, 
               maxNumBits = 1, 
               numStates = max(1,2^length(network$genes)/100))
}
\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork} or \code{ProbabilisticBooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}}, generated by \if{latex}{\cr}\code{\link{generateRandomNKNetwork}}, or reconstructed by \code{\link{reconstructNetwork}}.
}
  \item{perturb}{
	If set to "functions", a transition function of a single gene is chosen at random and perturbed directly. This is the default mode. If set to "transitions", the transition table is generated, one or several state transitions are perturbed randomly, and the gene transition functions are rebuilt from the modified transition table. \code{perturb="transitions"} is only allowed for non-probabilistic networks of class \code{BooleanNetworks}.
}
  \item{method}{
	The perturbation method to be applied to the functions or transitions. "bitflip" randomly inverts one or several bits (depending on the value of \code{maxNumBits}). "shuffle" generates a random permutation of the positions in the function or state and rearranges the bits according to this permutation.
}
  \item{simplify}{
	If this is true, \code{\link{simplifyNetwork}} is called to simplify the gene transition functions after the perturbation. This removes irrelevant input genes. Defaults to TRUE if \code{perturb} is "transitions", and to FALSE otherwise.
}
  \item{readableFunctions}{
	If this is true, readable DNF representations of the truth tables of the functions are generated. These DNF are displayed when the network is printed. The DNF representations are not minimized and can thus be very long. If set to FALSE, the truth table result column is displayed.	
}

\item{excludeFixed}{
	Determines whether fixed variables can also be perturbed (if set to FALSE) or if they are excluded from the perturbation (if set to TRUE). Default is TRUE.
}

  \item{maxNumBits}{
	The maximum number of bits to be perturbed in one function or state. Defaults to 1.
}
  \item{numStates}{
	The number of state transitions to be perturbed if \code{perturb} is "transitions". Defaults to 1% of all states.
}
}

\value{
Depending on the input, an object of class \code{BooleanNetwork} or \code{ProbabilisticBooleanNetwork} containing the perturbed copy of the original network is returned. The classes \code{BooleanNetwork} and \code{ProbabilisticBooleanNetwork} are described in more detail in \code{\link{loadNetwork}}.
}
\seealso{
\code{\link{loadNetwork}}, \code{\link{generateRandomNKNetwork}}, \code{\link{reconstructNetwork}}, \code{\link{simplifyNetwork}}}

\examples{
# load example data
data(cellcycle)

# perturb the network
perturbedNet1 <- perturbNetwork(cellcycle, perturb="functions", method="shuffle")
perturbedNet2 <- perturbNetwork(cellcycle, perturb="transitions", method="bitflip")

# get attractors
print(getAttractors(perturbedNet1))
print(getAttractors(perturbedNet2))
}
\references{
Y. Xiao and E. R. Dougherty (2007), The impact of function perturbations in Boolean networks. Bioinformatics 23(10):1265--1273.

I. Shmulevich, E. R. Dougherty, W. Zhang (2002), Control of stationary behavior in probabilistic Boolean networks by means of structural intervention. Journal of Biological Systems 10(4):431--445.
}
\keyword{Boolean network
  probabilistic Boolean network
  PBN
	state
	perturb
	perturbation
	noise
	robustness}
