% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asyncvaried.R
\name{AsyncVaried}
\alias{AsyncVaried}
\title{Async client for different request types}
\value{
An object of class \code{AsyncVaried} with variables and methods.
\link{HttpResponse} objects are returned in the order they are passed in.
We print the first 10.
}
\description{
An async client to do many requests, each with different URLs, curl options,
etc.
}
\section{Failure behavior}{

HTTP requests mostly fail in ways that you are probably familiar with,
including when there's a 400 response (the URL not found), and when the
server made a mistake (a 500 series HTTP status code).

But requests can fail sometimes where there is no HTTP status code, and
no agreed upon way to handle it other than to just fail immediately.

When a request fails when using synchronous requests (see \link{HttpClient})
you get an error message that stops your code progression
immediately saying for example:
\itemize{
\item "Could not resolve host: https://foo.com"
\item "Failed to connect to foo.com"
\item "Resolving timed out after 10 milliseconds"
}

However, for async requests we don't want to fail immediately because
that would stop the subsequent requests from occurring. Thus, when
we find that a request fails for one of the reasons above we
give back a \link{HttpResponse} object just like any other response, and:
\itemize{
\item capture the error message and put it in the \code{content} slot of the
response object (thus calls to \code{content} and \code{parse()} work correctly)
\item give back a \code{0} HTTP status code. we handle this specially when testing
whether the request was successful or not with e.g., the \code{success()}
method
}
}

\section{R6 classes}{

This is an R6 class from the package \pkg{R6}. Find out more
about R6 at \url{https://r6.r-lib.org/}. After creating an instance of an R6
class (e.g., \code{x <- HttpClient$new(url = "https://httpbin.org")}) you can
access values and methods on the object \code{x}.
}

\examples{
\dontrun{
# pass in requests via ...
req1 <- HttpRequest$new(
  url = "https://httpbin.org/get",
  opts = list(verbose = TRUE),
  headers = list(foo = "bar")
)$get()
req2 <- HttpRequest$new(url = "https://httpbin.org/post")$post()

# Create an AsyncVaried object
out <- AsyncVaried$new(req1, req2)

# before you make requests, the methods return empty objects
out$status()
out$status_code()
out$content()
out$times()
out$parse()
out$responses()

# make requests
out$request()

# access various parts
## http status objects
out$status()
## status codes
out$status_code()
## content (raw data)
out$content()
## times
out$times()
## parsed content
out$parse()
## response objects
out$responses()

# use $verb() method to select http verb
method <- "post"
req1 <- HttpRequest$new(
  url = "https://httpbin.org/post",
  opts = list(verbose = TRUE),
  headers = list(foo = "bar")
)$verb(method)
req2 <- HttpRequest$new(url = "https://httpbin.org/post")$verb(method)
out <- AsyncVaried$new(req1, req2)
out
out$request()
out$responses()

# pass in requests in a list via .list param
reqlist <- list(
  HttpRequest$new(url = "https://httpbin.org/get")$get(),
  HttpRequest$new(url = "https://httpbin.org/post")$post(),
  HttpRequest$new(url = "https://httpbin.org/put")$put(),
  HttpRequest$new(url = "https://httpbin.org/delete")$delete(),
  HttpRequest$new(url = "https://httpbin.org/get?g=5")$get(),
  HttpRequest$new(
    url = "https://httpbin.org/post")$post(body = list(y = 9)),
  HttpRequest$new(
    url = "https://httpbin.org/get")$get(query = list(hello = "world"))
)

out <- AsyncVaried$new(.list = reqlist)
out$request()
out$status()
out$status_code()
out$content()
out$times()
out$parse()

# using auth with async
url <- "https://httpbin.org/basic-auth/user/passwd"
auth <- auth(user = "user", pwd = "passwd")
reqlist <- list(
  HttpRequest$new(url = url, auth = auth)$get(),
  HttpRequest$new(url = url, auth = auth)$get(query = list(a=5)),
  HttpRequest$new(url = url, auth = auth)$get(query = list(b=3))
)
out <- AsyncVaried$new(.list = reqlist)
out$request()
out$status()
out$parse()

# failure behavior
## e.g. when a URL doesn't exist, a timeout, etc.
reqlist <- list(
  HttpRequest$new(url = "http://stuffthings.gvb")$get(),
  HttpRequest$new(url = "https://httpbin.org")$head(),
  HttpRequest$new(url = "https://httpbin.org", 
   opts = list(timeout_ms = 10))$head()
)
(tmp <- AsyncVaried$new(.list = reqlist))
tmp$request()
tmp$responses()
tmp$parse("UTF-8")

# access intemediate redirect headers
dois <- c("10.7202/1045307ar", "10.1242/jeb.088898", "10.1121/1.3383963")
reqlist <- list(
  HttpRequest$new(url = paste0("https://doi.org/", dois[1]))$get(),
  HttpRequest$new(url = paste0("https://doi.org/", dois[2]))$get(),
  HttpRequest$new(url = paste0("https://doi.org/", dois[3]))$get()
)
tmp <- AsyncVaried$new(.list = reqlist)
tmp$request()
tmp
lapply(tmp$responses(), "[[", "response_headers_all")
}
}
\seealso{
Other async: 
\code{\link{AsyncQueue}},
\code{\link{Async}},
\code{\link{HttpRequest}}
}
\concept{async}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{AsyncVaried$print()}}
\item \href{#method-new}{\code{AsyncVaried$new()}}
\item \href{#method-request}{\code{AsyncVaried$request()}}
\item \href{#method-responses}{\code{AsyncVaried$responses()}}
\item \href{#method-requests}{\code{AsyncVaried$requests()}}
\item \href{#method-parse}{\code{AsyncVaried$parse()}}
\item \href{#method-status_code}{\code{AsyncVaried$status_code()}}
\item \href{#method-status}{\code{AsyncVaried$status()}}
\item \href{#method-content}{\code{AsyncVaried$content()}}
\item \href{#method-times}{\code{AsyncVaried$times()}}
\item \href{#method-clone}{\code{AsyncVaried$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for AsyncVaried objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new AsyncVaried object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$new(..., .list = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{..., .list}}{Any number of objects of class \code{\link[=HttpRequest]{HttpRequest()}},
must supply inputs to one of these parameters, but not both}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AsyncVaried} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-request"></a>}}
\if{latex}{\out{\hypertarget{method-request}{}}}
\subsection{Method \code{request()}}{
Execute asynchronous requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$request()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing, responses stored inside object, though will print
messages if you choose verbose output
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-responses"></a>}}
\if{latex}{\out{\hypertarget{method-responses}{}}}
\subsection{Method \code{responses()}}{
List responses
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$responses()}\if{html}{\out{</div>}}
}

\subsection{Details}{
An S3 print method is used to summarise results. \link{unclass}
the output to see the list, or index to results, e.g., \verb{[1]}, \verb{[1:3]}
}

\subsection{Returns}{
a list of \code{HttpResponse} objects, empty list before
requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-requests"></a>}}
\if{latex}{\out{\hypertarget{method-requests}{}}}
\subsection{Method \code{requests()}}{
List requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$requests()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of \code{HttpRequest} objects, empty list before
requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parse"></a>}}
\if{latex}{\out{\hypertarget{method-parse}{}}}
\subsection{Method \code{parse()}}{
parse content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$parse(encoding = "UTF-8")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encoding}}{(character) the encoding to use in parsing.
default:"UTF-8"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character vector, empty character vector before
requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status_code"></a>}}
\if{latex}{\out{\hypertarget{method-status_code}{}}}
\subsection{Method \code{status_code()}}{
Get HTTP status codes for each response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$status_code()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numeric vector, empty numeric vector before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status"></a>}}
\if{latex}{\out{\hypertarget{method-status}{}}}
\subsection{Method \code{status()}}{
List HTTP status objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of \code{http_code} objects, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-content"></a>}}
\if{latex}{\out{\hypertarget{method-content}{}}}
\subsection{Method \code{content()}}{
Get raw content for each response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$content()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
raw list, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-times"></a>}}
\if{latex}{\out{\hypertarget{method-times}{}}}
\subsection{Method \code{times()}}{
curl request times
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$times()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list of named numeric vectors, empty list before requests made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncVaried$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
