% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_starprep.R
\name{commarobust}
\alias{commarobust}
\title{Build lm_robust object from lm fit}
\usage{
commarobust(model, se_type = NULL, clusters = NULL, ci = TRUE, alpha = 0.05)
}
\arguments{
\item{model}{an lm model object}

\item{se_type}{The sort of standard error sought. If \code{clusters} is
not specified the options are "HC0", "HC1" (or "stata", the equivalent),
"HC2" (default), "HC3", or "classical". If \code{clusters} is specified the
options are "CR0", "CR2" (default), or "stata". Can also specify "none",
which may speed up estimation of the coefficients.}

\item{clusters}{A vector corresponding to the clusters in the data.}

\item{ci}{logical. Whether to compute and return p-values and confidence
intervals, TRUE by default.}

\item{alpha}{The significance level, 0.05 by default.}
}
\value{
an \code{\link{lm_robust}} object.
}
\description{
Build lm_robust object from lm fit
}
\examples{
lmo <- lm(mpg ~ hp, data = mtcars)

# Default HC2
commarobust(lmo)

commarobust(lmo, se_type = "HC3")

commarobust(lmo, se_type = "stata", clusters = mtcars$carb)

}
