% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with.R
\name{ph_with.flextable}
\alias{ph_with.flextable}
\title{Add a flextable into a PowerPoint slide}
\usage{
\method{ph_with}{flextable}(x, value, location, ...)
}
\arguments{
\item{x}{a pptx device}

\item{value}{flextable object}

\item{location}{a location for a placeholder. See \code{\link[officer:ph_location_type]{officer::ph_location_type()}}
for example.}

\item{...}{unused arguments.}
}
\description{
Add a flextable in a PowerPoint document object produced
by \code{\link[officer:read_pptx]{officer::read_pptx()}}.

This function will create a native PowerPoint table from the flextable
and the result can be eventually edited.
}
\note{
The width and height of the table can not be set with \code{location}. Use
functions \code{\link[=width]{width()}}, \code{\link[=height]{height()}}, \code{\link[=autofit]{autofit()}}
and \code{\link[=dim_pretty]{dim_pretty()}} instead. The overall size is resulting from
cells, paragraphs and text properties (i.e. padding, font size, border widths).
}
\section{caption}{

Captions are not printed in PowerPoint slides.

While captions are useful for document formats like Word, RTF, HTML, or PDF,
they aren't directly supported in PowerPoint slides. Unlike documents with
a defined layout, PowerPoint slides lack a structured document flow. They
don't function like HTML documents or paginated formats (RTF, Word, PDF).
This makes it technically challenging to determine the ideal placement for
a caption within a slide. Additionally, including a caption within the table
itself isn't feasible.
}

\examples{
library(officer)

ft <- flextable(head(iris))

doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, ft, location = ph_location_left())

fileout <- tempfile(fileext = ".pptx")
print(doc, target = fileout)
}
