% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{valign}
\alias{valign}
\title{Set vertical alignment}
\usage{
valign(x, i = NULL, j = NULL, valign = "center", part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{valign}{vertical alignment of paragraph within cell,
one of "center" or "top" or "bottom".}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change vertical alignment of selected rows and columns of a flextable.
}
\examples{
ft_1 <- flextable(iris[c(1:3, 51:53, 101:103), ])
ft_1 <- theme_box(ft_1)
ft_1 <- merge_v(ft_1, j = 5)
ft_1

ft_2 <- valign(ft_1, j = 5, valign = "top", part = "all")
ft_2
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{tab_settings}()}
}
\concept{sugar functions for table style}
