% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit_assignment_linter.R
\name{implicit_assignment_linter}
\alias{implicit_assignment_linter}
\title{Avoid implicit assignment in function calls}
\usage{
implicit_assignment_linter(
  except = c("bquote", "expression", "expr", "quo", "quos", "quote"),
  allow_lazy = FALSE,
  allow_scoped = FALSE
)
}
\arguments{
\item{except}{A character vector of functions to be excluded from linting.}

\item{allow_lazy}{logical, default \code{FALSE}. If \code{TRUE}, assignments that only
trigger conditionally (e.g. in the RHS of \code{&&} or \code{||} expressions) are skipped.}

\item{allow_scoped}{Logical, default \code{FALSE}. If \code{TRUE}, "scoped assignments",
where the object is assigned in the statement beginning a branch and used only
within that branch, are skipped.}
}
\description{
Assigning inside function calls makes the code difficult to read, and should
be avoided, except for functions that capture side-effects (e.g. \code{\link[=capture.output]{capture.output()}}).
}
\examples{
# will produce lints
lint(
  text = "if (x <- 1L) TRUE",
  linters = implicit_assignment_linter()
)

lint(
  text = "mean(x <- 1:4)",
  linters = implicit_assignment_linter()
)

# okay
lines <- "x <- 1L\nif (x) TRUE"
writeLines(lines)
lint(
  text = lines,
  linters = implicit_assignment_linter()
)

lines <- "x <- 1:4\nmean(x)"
writeLines(lines)
lint(
  text = lines,
  linters = implicit_assignment_linter()
)

lint(
  text = "A && (B <- foo(A))",
  linters = implicit_assignment_linter(allow_lazy = TRUE)
)

lines <- c(
  "if (any(idx <- x < 0)) {",
  "  stop('negative elements: ', toString(which(idx)))",
  "}"
)
writeLines(lines)
lint(
  text = lines,
  linters = implicit_assignment_linter(allow_scoped = TRUE)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#assignment}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
