% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnecessary_nesting_linter.R
\name{unnecessary_nesting_linter}
\alias{unnecessary_nesting_linter}
\title{Block instances of unnecessary nesting}
\usage{
unnecessary_nesting_linter(
  allow_assignment = TRUE,
  allow_functions = c("switch", "try", "tryCatch", "withCallingHandlers", "quote",
    "expression", "bquote", "substitute", "with_parameters_test_that", "reactive",
    "observe", "observeEvent", "renderCachedPlot", "renderDataTable", "renderImage",
    "renderPlot", "renderPrint", "renderTable", "renderText", "renderUI"),
  branch_exit_calls = character()
)
}
\arguments{
\item{allow_assignment}{Logical, default \code{TRUE}, in which case
braced expressions consisting only of a single assignment are skipped.
if \code{FALSE}, all braced expressions with only one child expression are linted.
The \code{TRUE} case facilitates interaction with \code{\link[=implicit_assignment_linter]{implicit_assignment_linter()}}
for certain cases where an implicit assignment is necessary, so a braced
assignment is used to further distinguish the assignment. See examples.}

\item{allow_functions}{Character vector of functions which always allow
one-child braced expressions. \code{testthat::test_that()} is always allowed because
testthat requires a braced expression in its \code{code} argument. The other defaults
similarly compute on expressions in a way which is worth highlighting by
em-bracing them, even if there is only one expression, while \code{\link[=switch]{switch()}} is allowed
for its use as a control flow analogous to \code{if}/\verb{else}.]}

\item{branch_exit_calls}{Character vector of functions which are considered
as "exiting" a branch for the purpose of recommending removing nesting in a branch
\emph{lacking} an exit call when the other branch terminates with one. Calls which
always interrupt or quit the current call or R session,
e.g. \code{\link[=stop]{stop()}} and \code{\link[=q]{q()}}, are always included.}
}
\description{
Excessive nesting harms readability. Use helper functions or early returns
to reduce nesting wherever possible.
}
\examples{
# will produce lints
code <- "if (A) {\n  stop('A is bad!')\n} else {\n  do_good()\n}"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "tryCatch(\n  {\n    foo()\n  },\n  error = identity\n)"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "expect_warning(\n  {\n    x <- foo()\n  },\n  'warned'\n)"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter(allow_assignment = FALSE)
)

code <- "if (x) { \n  if (y) { \n   return(1L) \n  } \n}"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

lint(
  text = "my_quote({x})",
  linters = unnecessary_nesting_linter()
)

code <- paste(
  "if (A) {",
  "  stop('A is bad because a.')",
  "} else {",
  "  warning('!A requires caution.')",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

# okay
code <- "if (A) {\n  stop('A is bad because a.')\n} else {\n  stop('!A is bad too.')\n}"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "capture.output({\n  foo()\n})"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "expect_warning(\n  {\n    x <- foo()\n  },\n  'warned'\n)"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "if (x && y) { \n  return(1L) \n}"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

code <- "if (x) { \n  y <- x + 1L\n  if (y) { \n   return(1L) \n  } \n}"
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter()
)

lint(
  text = "my_quote({x})",
  linters = unnecessary_nesting_linter(allow_functions = "my_quote")
)

code <- paste(
  "if (A) {",
  "  stop('A is bad because a.')",
  "} else {",
  "  warning('!A requires caution.')",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = unnecessary_nesting_linter(branch_exit_calls = c("stop", "warning"))
)

}
\seealso{
\itemize{
\item \code{\link[=cyclocomp_linter]{cyclocomp_linter()}} for another linter that penalizes overly complex code.
\item \link{linters} for a complete list of linters available in lintr.
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
