% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{encrypt_envelope}
\alias{encrypt_envelope}
\alias{envelope}
\alias{decrypt_envelope}
\title{Envelope encryption}
\usage{
encrypt_envelope(data, pubkey = my_pubkey())

decrypt_envelope(data, iv, session, key = my_key(), password)
}
\arguments{
\item{data}{raw data vector or file path for message to be signed.
If \code{hash == NULL} then \code{data} must be a hash string or raw vector.}

\item{pubkey}{public key or file path. See \code{\link{read_pubkey}}.}

\item{iv}{16 byte raw vector returned by \code{encrypt_envelope}.}

\item{session}{raw vector with encrypted session key as returned by \code{encrypt_envelope}.}

\item{key}{private key or file path. See \code{\link{read_key}}.}

\item{password}{string or a function to read protected keys. See \code{\link{read_key}}.}
}
\description{
An \href{https://wiki.openssl.org/index.php/EVP_Asymmetric_Encryption_and_Decryption_of_an_Envelope}{envelope}
contains ciphertext along with an encrypted session key and optionally and initialization
vector. The \code{\link{encrypt_envelope}} generates a random IV and session-key which is
used to encrypt the \code{data} with \code{\link[openssl:aes_cbc]{AES}} stream cipher. The
session key itself is encrypted using the given RSA key (see \code{\link{rsa_encrypt}}) and
stored or sent along with the encrypted data. Each of these outputs is required to decrypt
the data with the corresponding private key.
}
\examples{
# Requires RSA key
key <- rsa_keygen()
pubkey <- key$pubkey
msg <- serialize(iris, NULL)

# Encrypt
out <- encrypt_envelope(msg, pubkey)
str(out)

# Decrypt
orig <- decrypt_envelope(out$data, out$iv, out$session, key)
stopifnot(identical(msg, orig))
}
\references{
\url{https://wiki.openssl.org/index.php/EVP_Asymmetric_Encryption_and_Decryption_of_an_Envelope}
}
