% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease2variant.R
\name{disease2variant}
\alias{disease2variant}
\title{Retrieves variants associated to a disease, or list of diseases and generates an \code{DataGeNET.DGN}}
\usage{
disease2variant(
  disease = "C0751955",
  vocabulary = "UMLS",
  database = "CURATED",
  score = c(0, 1),
  api_key = NULL,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{disease}{A disease or a list of disease identifiers (CUIs, MeSH, OMIMs...)}

\item{vocabulary}{The vocabulary of the disease identifier(s)
Select one of the available: \code{OMIM} (OMIM), \code{MSH} (MeSH), \code{DO} (Disease Ontology),
\code{NCI} (NCI thesaurus), \code{ORDO} (Orphanet),
\code{ICD9CM} (ICD9-CM) or \code{EFO} (EFO). Default \code{'UMLS'}.}

\item{database}{Name of the database that will be queried. It can take the values:
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CURATED'} to use expert curated, human databases;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{score}{A vector with two elements: 1) initial value of score 2) final value of score}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to hide the warnings.}
}
\value{
An object of class \code{DataGeNET.DGN}
}
\description{
Given the name of one or multiple diseases and retrieves the associated variant(s)
 and creates an object of type \code{DataGeNET.RDF}.
}
\examples{
dis2var <- disease2variant( disease = "C0751955",vocabulary = "UMLS", database = "ALL", score=c(0,1) )
}
