% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.output.R
\docType{class}
\name{RK.Output}
\alias{RK.Output}
\alias{rk.output}
\alias{rk.import.legacy.output}
\title{Class and functions for organizing RKWard output.}
\usage{
rk.output(filename = NULL, create = FALSE, all = FALSE)

rk.import.legacy.output(
  filename = file.path(rk.home(), "rk_out.html"),
  import = TRUE,
  delete = FALSE
)
}
\arguments{
\item{filename}{The location where an existing output directory is loaded from or saved/exported to. Note that this is usually not the same location where functions such as
\link{rk.print} will write to (these operate on a temporary "working copy", but rather the target directory, where changes should eventually be saved
back, to.}

\item{create}{If \code{TRUE}, create a new output directory. The parameter \code{filename}, if specified, is the target save file/directory, in this case. Should this already exist,
an error will be raised. If \code{create=FALSE}, load or re-use an existing output directory. If the parameter \code{filename} is left \code{NULL}, \code{rk.output} will
return the currently active output in this case (creating and/or activating an output file, in case all outputs have been closed or deactivated).}

\item{all}{If \code{TRUE}, return a list of all currently loaded output directories.}

\item{overwrite}{If \code{TRUE}, RKWard will overwrite any existing output when saving, or discard any existing modifications when closing or reverting an output. If \code{FALSE}, trying
to overwrite/discard existing files/modifications will result in an error. If \code{NULL} (the default), the frontend will ask what to do in this case.}

\item{discard}{See \code{overwrite} for the meaning.}

\item{raise}{Raise the output window, if it is already visble.}
}
\description{
Since version 0.7.3, RKWard supports more than one output document. While dealing with only a single output page, there will be no need for the user to call any of
             the following functions, directly, as exactly one output is always opened for writing in RKWard (unless rk.set.output.html.file() has been called, explicitly).
             However, these functions allow to manage several distinct output pages, programmatically.

             The primary entry point is the function \code{rk.output}, which allows to retrieve the current output directly, or to load or create a new one. This will return
             an instance of the \code{RK.Output} reference class, which has methods for subsequent manipulation. Two instances of this class may be pointing to the same
             logical output file/directory (e.g. when loading the same output file, twice), in which case any operation will affect both instances the same.

             Internally, outputs are managed by the RKWard frontend. The frontend will ask to save any unsaved modified output pages on exit, even if those are not currently shown.

             Output references can be assigned to a symbol, which may be useful when writing to several output files in turn. However, such references should be considered
             short-lived. Importantly, they will not currently remain valid across sessions. Where this may be a concern, code should obtain a new reference using
             rk.output(filename="something") at relevant entry points to subsequent code.

             At the time of this writing, output is stored in directories containing an HTML index file, and, usually, several image files, and possibly more.
             However other types of output may be supported in the future, and therefore assumptions about the details of the output storage should be avoided.

             \code{rk.output} can be used to create or load output files, as well as to obtain a reference to an already loaded output file. After that, use the class methods
             to operate on the reference obtained.

             \code{rk.import.legacy.output} can be used to import an legacy (pre 0.7.3) output file to .rko-format. This function is going to be removed after some time.
}
\section{Fields}{

\describe{
\item{\code{id}}{An internal identifier. NULL for a closed output. This should be treated as read-only, but you can use this to test whether two output handles are the same.}
}}

\section{Methods}{

\describe{
\item{\code{activate()}}{Set this output as the one that rk.print and other RKWard Output functions will write to.}

\item{\code{clear(discard = NULL)}}{Clear all content from this output. As with any function in this class, this affects the working copy, only, until you call save. Therefore, by default, the user will be prompted for confirmation
if and only if there are unsaved changes pending.}

\item{\code{close(discard = NULL)}}{Forget about this output file, also closing any open views. Note: Trying to call any further methods on this object will fail.}

\item{\code{export(Class)}}{Returns the result of coercing the object to
Class.  No effect on the object itself.}

\item{\code{filename()}}{Return the target filename for this output, i.e. the location where it will be saved, to. This will be an empty string for newly created outputs that have not been saved, yet.
Do not write anything to the target filename, directly! This is purely for information.}

\item{\code{isEmpty()}}{Returns TRUE, if the output is currently empty.}

\item{\code{isModified()}}{Returns TRUE, if this output has any changes that may need saving.}

\item{\code{revert(discard = NULL)}}{Revert this output to the last saved state. If no previous state is available (never saved, before), clears the output.}

\item{\code{save(filename, overwrite = NULL)}}{Save this output, either to the last known save location (if no filename is specified) or to a new location ("save as").}

\item{\code{view(raise = TRUE)}}{Open this output for viewing in the frontend.}
}}

\examples{

## Not run
x <- rk.output(create=TRUE)
x$activate()
rk.print("Hello World!")
x$view()
x$save() # Will prompt for filename
x$close()

}
