# coding: binary
# Generated by generate-specs

#################### null_nilkey_nilvalue ####################

shared_examples_for 'null_nilkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = ''
    store[0] = nil
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = ''
    store[nil] = nil
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = nil
    store[0] = ''
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = nil
    store[nil] = ''
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 0
    store[0] = false
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 0
    store[nil] = false
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = false
    store[0] = 0
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = false
    store[nil] = 0
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, false, options).should == false
  end
end

#################### store_nilkey_nilvalue ####################

shared_examples_for 'store_nilkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = ''
    store[nil].should == ''
    store.load(nil).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = ''
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(nil, value).should equal(value)
    store[nil].should == ''
    store.load(nil).should == ''
  end

  it 'stores values after clear' do
    store[nil] = ''
    store[0] = nil
    store.clear.should equal(store)
    store[nil] = ''
    store[nil].should == ''
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = ''
    store.delete(nil).should == ''
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = ''
    store[nil].should == ''
    store[nil] = nil
    store[nil].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == ''
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = ''
    store[nil].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[0] = ''
    store[0].should == ''
    store.load(0).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[0] = ''
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(0, value).should equal(value)
    store[0].should == ''
    store.load(0).should == ''
  end

  it 'stores values after clear' do
    store[0] = ''
    store[nil] = nil
    store.clear.should equal(store)
    store[0] = ''
    store[0].should == ''
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = ''
    store.delete(0).should == ''
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = ''
    store[0].should == ''
    store[0] = nil
    store[0].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[0] = value).should equal(value)
    store[0].should == ''
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = ''
    store[0].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = nil
    store[nil].should == nil
    store.load(nil).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = nil
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(nil, value).should equal(value)
    store[nil].should == nil
    store.load(nil).should == nil
  end

  it 'stores values after clear' do
    store[nil] = nil
    store[0] = ''
    store.clear.should equal(store)
    store[nil] = nil
    store[nil].should == nil
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = nil
    store.delete(nil).should == nil
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = nil
    store[nil].should == nil
    store[nil] = ''
    store[nil].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == nil
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = nil
    store[nil].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[0] = nil
    store[0].should == nil
    store.load(0).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[0] = nil
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(0, value).should equal(value)
    store[0].should == nil
    store.load(0).should == nil
  end

  it 'stores values after clear' do
    store[0] = nil
    store[nil] = ''
    store.clear.should equal(store)
    store[0] = nil
    store[0].should == nil
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = nil
    store.delete(0).should == nil
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = nil
    store[0].should == nil
    store[0] = ''
    store[0].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[0] = value).should equal(value)
    store[0].should == nil
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = nil
    store[0].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = 0
    store[nil].should == 0
    store.load(nil).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = 0
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(nil, value).should equal(value)
    store[nil].should == 0
    store.load(nil).should == 0
  end

  it 'stores values after clear' do
    store[nil] = 0
    store[0] = false
    store.clear.should equal(store)
    store[nil] = 0
    store[nil].should == 0
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 0
    store.delete(nil).should == 0
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 0
    store[nil].should == 0
    store[nil] = false
    store[nil].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == 0
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = 0
    store[nil].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[0] = 0
    store[0].should == 0
    store.load(0).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[0] = 0
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(0, value).should equal(value)
    store[0].should == 0
    store.load(0).should == 0
  end

  it 'stores values after clear' do
    store[0] = 0
    store[nil] = false
    store.clear.should equal(store)
    store[0] = 0
    store[0].should == 0
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 0
    store.delete(0).should == 0
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 0
    store[0].should == 0
    store[0] = false
    store[0].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[0] = value).should equal(value)
    store[0].should == 0
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = 0
    store[0].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = false
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = false
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(nil, value).should equal(value)
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'stores values after clear' do
    store[nil] = false
    store[0] = 0
    store.clear.should equal(store)
    store[nil] = false
    store[nil].should == false
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = false
    store.delete(nil).should == false
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = false
    store[nil].should == false
    store[nil] = 0
    store[nil].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == false
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = false
    store[nil].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[0] = false
    store[0].should == false
    store.load(0).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[0] = false
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(0, value).should equal(value)
    store[0].should == false
    store.load(0).should == false
  end

  it 'stores values after clear' do
    store[0] = false
    store[nil] = 0
    store.clear.should equal(store)
    store[0] = false
    store[0].should == false
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = false
    store.delete(0).should == false
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = false
    store[0].should == false
    store[0] = 0
    store[0].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[0] = value).should equal(value)
    store[0].should == false
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = false
    store[0].should == false
  end
end

#################### persist_nilkey_nilvalue ####################

shared_examples_for 'persist_nilkey_nilvalue' do
  it 'persists values' do
    store[nil] = ''
    store.close
    @store = nil
    store[nil].should == ''
  end

  it 'persists values' do
    store[0] = ''
    store.close
    @store = nil
    store[0].should == ''
  end

  it 'persists values' do
    store[nil] = nil
    store.close
    @store = nil
    store[nil].should == nil
  end

  it 'persists values' do
    store[0] = nil
    store.close
    @store = nil
    store[0].should == nil
  end

  it 'persists values' do
    store[nil] = 0
    store.close
    @store = nil
    store[nil].should == 0
  end

  it 'persists values' do
    store[0] = 0
    store.close
    @store = nil
    store[0].should == 0
  end

  it 'persists values' do
    store[nil] = false
    store.close
    @store = nil
    store[nil].should == false
  end

  it 'persists values' do
    store[0] = false
    store.close
    @store = nil
    store[0].should == false
  end
end

#################### null_nilkey_integervalue ####################

shared_examples_for 'null_nilkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 41
    store[0] = -12
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 41
    store[nil] = -12
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = -12
    store[0] = 41
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = -12
    store[nil] = 41
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, -12, options).should == -12
  end
end

#################### store_nilkey_integervalue ####################

shared_examples_for 'store_nilkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = 41
    store[nil].should == 41
    store.load(nil).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = 41
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(nil, value).should equal(value)
    store[nil].should == 41
    store.load(nil).should == 41
  end

  it 'stores values after clear' do
    store[nil] = 41
    store[0] = -12
    store.clear.should equal(store)
    store[nil] = 41
    store[nil].should == 41
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 41
    store.delete(nil).should == 41
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 41
    store[nil].should == 41
    store[nil] = -12
    store[nil].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == 41
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = 41
    store[nil].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = 41
    store.fetch(nil, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = 41
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = 41
    store[0].should == 41
    store.load(0).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[0] = 41
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(0, value).should equal(value)
    store[0].should == 41
    store.load(0).should == 41
  end

  it 'stores values after clear' do
    store[0] = 41
    store[nil] = -12
    store.clear.should equal(store)
    store[0] = 41
    store[0].should == 41
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 41
    store.delete(0).should == 41
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 41
    store[0].should == 41
    store[0] = -12
    store[0].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[0] = value).should equal(value)
    store[0].should == 41
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = 41
    store[0].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = 41
    store.fetch(0, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = 41
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = -12
    store[nil].should == -12
    store.load(nil).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = -12
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(nil, value).should equal(value)
    store[nil].should == -12
    store.load(nil).should == -12
  end

  it 'stores values after clear' do
    store[nil] = -12
    store[0] = 41
    store.clear.should equal(store)
    store[nil] = -12
    store[nil].should == -12
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = -12
    store.delete(nil).should == -12
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = -12
    store[nil].should == -12
    store[nil] = 41
    store[nil].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == -12
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = -12
    store[nil].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = -12
    store.fetch(nil, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = -12
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = -12
    store[0].should == -12
    store.load(0).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[0] = -12
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(0, value).should equal(value)
    store[0].should == -12
    store.load(0).should == -12
  end

  it 'stores values after clear' do
    store[0] = -12
    store[nil] = 41
    store.clear.should equal(store)
    store[0] = -12
    store[0].should == -12
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = -12
    store.delete(0).should == -12
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = -12
    store[0].should == -12
    store[0] = 41
    store[0].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[0] = value).should equal(value)
    store[0].should == -12
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = -12
    store[0].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = -12
    store.fetch(0, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = -12
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_nilkey_integervalue ####################

shared_examples_for 'persist_nilkey_integervalue' do
  it 'persists values' do
    store[nil] = 41
    store.close
    @store = nil
    store[nil].should == 41
  end

  it 'persists values' do
    store[0] = 41
    store.close
    @store = nil
    store[0].should == 41
  end

  it 'persists values' do
    store[nil] = -12
    store.close
    @store = nil
    store[nil].should == -12
  end

  it 'persists values' do
    store[0] = -12
    store.close
    @store = nil
    store[0].should == -12
  end
end

#################### null_nilkey_numbervalue ####################

shared_examples_for 'null_nilkey_numbervalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 123.456
    store[0] = -98.7
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 123.456
    store[nil] = -98.7
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = -98.7
    store[0] = 123.456
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = -98.7
    store[nil] = 123.456
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 340282366920938463463374607431768211456
    store[0] = 33
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 340282366920938463463374607431768211456
    store[nil] = 33
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = 33
    store[0] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = 33
    store[nil] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, 33, options).should == 33
  end
end

#################### store_nilkey_numbervalue ####################

shared_examples_for 'store_nilkey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = 123.456
    store[nil].should == 123.456
    store.load(nil).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = 123.456
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(nil, value).should equal(value)
    store[nil].should == 123.456
    store.load(nil).should == 123.456
  end

  it 'stores values after clear' do
    store[nil] = 123.456
    store[0] = -98.7
    store.clear.should equal(store)
    store[nil] = 123.456
    store[nil].should == 123.456
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 123.456
    store.delete(nil).should == 123.456
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 123.456
    store[nil].should == 123.456
    store[nil] = -98.7
    store[nil].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == 123.456
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = 123.456
    store[nil].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = 123.456
    store.fetch(nil, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = 123.456
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = 123.456
    store[0].should == 123.456
    store.load(0).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[0] = 123.456
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(0, value).should equal(value)
    store[0].should == 123.456
    store.load(0).should == 123.456
  end

  it 'stores values after clear' do
    store[0] = 123.456
    store[nil] = -98.7
    store.clear.should equal(store)
    store[0] = 123.456
    store[0].should == 123.456
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 123.456
    store.delete(0).should == 123.456
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 123.456
    store[0].should == 123.456
    store[0] = -98.7
    store[0].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[0] = value).should equal(value)
    store[0].should == 123.456
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = 123.456
    store[0].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = 123.456
    store.fetch(0, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = 123.456
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = -98.7
    store[nil].should == -98.7
    store.load(nil).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = -98.7
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(nil, value).should equal(value)
    store[nil].should == -98.7
    store.load(nil).should == -98.7
  end

  it 'stores values after clear' do
    store[nil] = -98.7
    store[0] = 123.456
    store.clear.should equal(store)
    store[nil] = -98.7
    store[nil].should == -98.7
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = -98.7
    store.delete(nil).should == -98.7
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = -98.7
    store[nil].should == -98.7
    store[nil] = 123.456
    store[nil].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == -98.7
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = -98.7
    store[nil].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = -98.7
    store.fetch(nil, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = -98.7
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = -98.7
    store[0].should == -98.7
    store.load(0).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[0] = -98.7
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(0, value).should equal(value)
    store[0].should == -98.7
    store.load(0).should == -98.7
  end

  it 'stores values after clear' do
    store[0] = -98.7
    store[nil] = 123.456
    store.clear.should equal(store)
    store[0] = -98.7
    store[0].should == -98.7
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = -98.7
    store.delete(0).should == -98.7
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = -98.7
    store[0].should == -98.7
    store[0] = 123.456
    store[0].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[0] = value).should equal(value)
    store[0].should == -98.7
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = -98.7
    store[0].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = -98.7
    store.fetch(0, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = -98.7
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = 340282366920938463463374607431768211456
    store[nil].should == 340282366920938463463374607431768211456
    store.load(nil).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = 340282366920938463463374607431768211456
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(nil, value).should equal(value)
    store[nil].should == 340282366920938463463374607431768211456
    store.load(nil).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[nil] = 340282366920938463463374607431768211456
    store[0] = 33
    store.clear.should equal(store)
    store[nil] = 340282366920938463463374607431768211456
    store[nil].should == 340282366920938463463374607431768211456
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 340282366920938463463374607431768211456
    store.delete(nil).should == 340282366920938463463374607431768211456
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 340282366920938463463374607431768211456
    store[nil].should == 340282366920938463463374607431768211456
    store[nil] = 33
    store[nil].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = 340282366920938463463374607431768211456
    store[nil].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = 340282366920938463463374607431768211456
    store.fetch(nil, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = 340282366920938463463374607431768211456
    store[0].should == 340282366920938463463374607431768211456
    store.load(0).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[0] = 340282366920938463463374607431768211456
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(0, value).should equal(value)
    store[0].should == 340282366920938463463374607431768211456
    store.load(0).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[0] = 340282366920938463463374607431768211456
    store[nil] = 33
    store.clear.should equal(store)
    store[0] = 340282366920938463463374607431768211456
    store[0].should == 340282366920938463463374607431768211456
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 340282366920938463463374607431768211456
    store.delete(0).should == 340282366920938463463374607431768211456
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 340282366920938463463374607431768211456
    store[0].should == 340282366920938463463374607431768211456
    store[0] = 33
    store[0].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[0] = value).should equal(value)
    store[0].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = 340282366920938463463374607431768211456
    store[0].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = 340282366920938463463374607431768211456
    store.fetch(0, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = 33
    store[nil].should == 33
    store.load(nil).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = 33
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(nil, value).should equal(value)
    store[nil].should == 33
    store.load(nil).should == 33
  end

  it 'stores values after clear' do
    store[nil] = 33
    store[0] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[nil] = 33
    store[nil].should == 33
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = 33
    store.delete(nil).should == 33
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = 33
    store[nil].should == 33
    store[nil] = 340282366920938463463374607431768211456
    store[nil].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == 33
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = 33
    store[nil].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = 33
    store.fetch(nil, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = 33
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = 33
    store[0].should == 33
    store.load(0).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[0] = 33
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(0, value).should equal(value)
    store[0].should == 33
    store.load(0).should == 33
  end

  it 'stores values after clear' do
    store[0] = 33
    store[nil] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[0] = 33
    store[0].should == 33
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = 33
    store.delete(0).should == 33
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = 33
    store[0].should == 33
    store[0] = 340282366920938463463374607431768211456
    store[0].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[0] = value).should equal(value)
    store[0].should == 33
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = 33
    store[0].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = 33
    store.fetch(0, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = 33
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_nilkey_numbervalue ####################

shared_examples_for 'persist_nilkey_numbervalue' do
  it 'persists values' do
    store[nil] = 123.456
    store.close
    @store = nil
    store[nil].should == 123.456
  end

  it 'persists values' do
    store[0] = 123.456
    store.close
    @store = nil
    store[0].should == 123.456
  end

  it 'persists values' do
    store[nil] = -98.7
    store.close
    @store = nil
    store[nil].should == -98.7
  end

  it 'persists values' do
    store[0] = -98.7
    store.close
    @store = nil
    store[0].should == -98.7
  end

  it 'persists values' do
    store[nil] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[nil].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[0] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[0].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[nil] = 33
    store.close
    @store = nil
    store[nil].should == 33
  end

  it 'persists values' do
    store[0] = 33
    store.close
    @store = nil
    store[0].should == 33
  end
end

#################### null_nilkey_booleanvalue ####################

shared_examples_for 'null_nilkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = true
    store[0] = false
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = true
    store[nil] = false
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = false
    store[0] = true
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = false
    store[nil] = true
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, false, options).should == false
  end
end

#################### store_nilkey_booleanvalue ####################

shared_examples_for 'store_nilkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = true
    store[nil].should == true
    store.load(nil).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = true
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(nil, value).should equal(value)
    store[nil].should == true
    store.load(nil).should == true
  end

  it 'stores values after clear' do
    store[nil] = true
    store[0] = false
    store.clear.should equal(store)
    store[nil] = true
    store[nil].should == true
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = true
    store.delete(nil).should == true
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = true
    store[nil].should == true
    store[nil] = false
    store[nil].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == true
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = true
    store[nil].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = true
    store.fetch(nil, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = true
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = true
    store[0].should == true
    store.load(0).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[0] = true
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(0, value).should equal(value)
    store[0].should == true
    store.load(0).should == true
  end

  it 'stores values after clear' do
    store[0] = true
    store[nil] = false
    store.clear.should equal(store)
    store[0] = true
    store[0].should == true
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = true
    store.delete(0).should == true
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = true
    store[0].should == true
    store[0] = false
    store[0].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[0] = value).should equal(value)
    store[0].should == true
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = true
    store[0].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = true
    store.fetch(0, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = true
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = false
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = false
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(nil, value).should equal(value)
    store[nil].should == false
    store.load(nil).should == false
  end

  it 'stores values after clear' do
    store[nil] = false
    store[0] = true
    store.clear.should equal(store)
    store[nil] = false
    store[nil].should == false
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = false
    store.delete(nil).should == false
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = false
    store[nil].should == false
    store[nil] = true
    store[nil].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == false
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = false
    store[nil].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = false
    store.fetch(nil, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = false
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = false
    store[0].should == false
    store.load(0).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[0] = false
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(0, value).should equal(value)
    store[0].should == false
    store.load(0).should == false
  end

  it 'stores values after clear' do
    store[0] = false
    store[nil] = true
    store.clear.should equal(store)
    store[0] = false
    store[0].should == false
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = false
    store.delete(0).should == false
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = false
    store[0].should == false
    store[0] = true
    store[0].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[0] = value).should equal(value)
    store[0].should == false
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = false
    store[0].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = false
    store.fetch(0, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = false
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_nilkey_booleanvalue ####################

shared_examples_for 'persist_nilkey_booleanvalue' do
  it 'persists values' do
    store[nil] = true
    store.close
    @store = nil
    store[nil].should == true
  end

  it 'persists values' do
    store[0] = true
    store.close
    @store = nil
    store[0].should == true
  end

  it 'persists values' do
    store[nil] = false
    store.close
    @store = nil
    store[nil].should == false
  end

  it 'persists values' do
    store[0] = false
    store.close
    @store = nil
    store[0].should == false
  end
end

#################### null_nilkey_stringvalue ####################

shared_examples_for 'null_nilkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "strval1"
    store[0] = "strval2"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "strval1"
    store[nil] = "strval2"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "strval2"
    store[0] = "strval1"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "strval2"
    store[nil] = "strval1"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "strval2", options).should == "strval2"
  end
end

#################### store_nilkey_stringvalue ####################

shared_examples_for 'store_nilkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store.load(nil).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = "strval1"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(nil, value).should equal(value)
    store[nil].should == "strval1"
    store.load(nil).should == "strval1"
  end

  it 'stores values after clear' do
    store[nil] = "strval1"
    store[0] = "strval2"
    store.clear.should equal(store)
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "strval1"
    store.delete(nil).should == "strval1"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "strval1"
    store[nil].should == "strval1"
    store[nil] = "strval2"
    store[nil].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[nil] = value).should equal(value)
    store[nil].should == "strval1"
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = "strval1"
    store[nil].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "strval1"
    store.fetch(nil, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "strval1"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = "strval1"
    store[0].should == "strval1"
    store.load(0).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[0] = "strval1"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(0, value).should equal(value)
    store[0].should == "strval1"
    store.load(0).should == "strval1"
  end

  it 'stores values after clear' do
    store[0] = "strval1"
    store[nil] = "strval2"
    store.clear.should equal(store)
    store[0] = "strval1"
    store[0].should == "strval1"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "strval1"
    store.delete(0).should == "strval1"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "strval1"
    store[0].should == "strval1"
    store[0] = "strval2"
    store[0].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[0] = value).should equal(value)
    store[0].should == "strval1"
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = "strval1"
    store[0].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "strval1"
    store.fetch(0, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "strval1"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store.load(nil).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = "strval2"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(nil, value).should equal(value)
    store[nil].should == "strval2"
    store.load(nil).should == "strval2"
  end

  it 'stores values after clear' do
    store[nil] = "strval2"
    store[0] = "strval1"
    store.clear.should equal(store)
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "strval2"
    store.delete(nil).should == "strval2"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "strval2"
    store[nil].should == "strval2"
    store[nil] = "strval1"
    store[nil].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[nil] = value).should equal(value)
    store[nil].should == "strval2"
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = "strval2"
    store[nil].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "strval2"
    store.fetch(nil, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "strval2"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = "strval2"
    store[0].should == "strval2"
    store.load(0).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[0] = "strval2"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(0, value).should equal(value)
    store[0].should == "strval2"
    store.load(0).should == "strval2"
  end

  it 'stores values after clear' do
    store[0] = "strval2"
    store[nil] = "strval1"
    store.clear.should equal(store)
    store[0] = "strval2"
    store[0].should == "strval2"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "strval2"
    store.delete(0).should == "strval2"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "strval2"
    store[0].should == "strval2"
    store[0] = "strval1"
    store[0].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[0] = value).should equal(value)
    store[0].should == "strval2"
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = "strval2"
    store[0].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "strval2"
    store.fetch(0, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "strval2"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_stringvalue ####################

shared_examples_for 'returndifferent_nilkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[0] = value
    store[0].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_stringvalue ####################

shared_examples_for 'returnsame_nilkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[0] = value
    store[0].should be_equal(value)
  end
end

#################### persist_nilkey_stringvalue ####################

shared_examples_for 'persist_nilkey_stringvalue' do
  it 'persists values' do
    store[nil] = "strval1"
    store.close
    @store = nil
    store[nil].should == "strval1"
  end

  it 'persists values' do
    store[0] = "strval1"
    store.close
    @store = nil
    store[0].should == "strval1"
  end

  it 'persists values' do
    store[nil] = "strval2"
    store.close
    @store = nil
    store[nil].should == "strval2"
  end

  it 'persists values' do
    store[0] = "strval2"
    store.close
    @store = nil
    store[0].should == "strval2"
  end
end

#################### null_nilkey_binaryvalue ####################

shared_examples_for 'null_nilkey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "über"
    store[0] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "über"
    store[nil] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = "\xAA\xBB\xCC"
    store[0] = "über"
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = "\xAA\xBB\xCC"
    store[nil] = "über"
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end
end

#################### store_nilkey_binaryvalue ####################

shared_examples_for 'store_nilkey_binaryvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = "über"
    store[nil].should == "über"
    store.load(nil).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = "über"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(nil, value).should equal(value)
    store[nil].should == "über"
    store.load(nil).should == "über"
  end

  it 'stores values after clear' do
    store[nil] = "über"
    store[0] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[nil] = "über"
    store[nil].should == "über"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "über"
    store.delete(nil).should == "über"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "über"
    store[nil].should == "über"
    store[nil] = "\xAA\xBB\xCC"
    store[nil].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[nil] = value).should equal(value)
    store[nil].should == "über"
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = "über"
    store[nil].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "über"
    store.fetch(nil, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "über"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = "über"
    store[0].should == "über"
    store.load(0).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[0] = "über"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(0, value).should equal(value)
    store[0].should == "über"
    store.load(0).should == "über"
  end

  it 'stores values after clear' do
    store[0] = "über"
    store[nil] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[0] = "über"
    store[0].should == "über"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "über"
    store.delete(0).should == "über"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "über"
    store[0].should == "über"
    store[0] = "\xAA\xBB\xCC"
    store[0].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[0] = value).should equal(value)
    store[0].should == "über"
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = "über"
    store[0].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "über"
    store.fetch(0, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "über"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = "\xAA\xBB\xCC"
    store[nil].should == "\xAA\xBB\xCC"
    store.load(nil).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = "\xAA\xBB\xCC"
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(nil, value).should equal(value)
    store[nil].should == "\xAA\xBB\xCC"
    store.load(nil).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[nil] = "\xAA\xBB\xCC"
    store[0] = "über"
    store.clear.should equal(store)
    store[nil] = "\xAA\xBB\xCC"
    store[nil].should == "\xAA\xBB\xCC"
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = "\xAA\xBB\xCC"
    store.delete(nil).should == "\xAA\xBB\xCC"
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = "\xAA\xBB\xCC"
    store[nil].should == "\xAA\xBB\xCC"
    store[nil] = "über"
    store[nil].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[nil] = value).should equal(value)
    store[nil].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = "\xAA\xBB\xCC"
    store[nil].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = "\xAA\xBB\xCC"
    store.fetch(nil, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = "\xAA\xBB\xCC"
    store[0].should == "\xAA\xBB\xCC"
    store.load(0).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[0] = "\xAA\xBB\xCC"
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(0, value).should equal(value)
    store[0].should == "\xAA\xBB\xCC"
    store.load(0).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[0] = "\xAA\xBB\xCC"
    store[nil] = "über"
    store.clear.should equal(store)
    store[0] = "\xAA\xBB\xCC"
    store[0].should == "\xAA\xBB\xCC"
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = "\xAA\xBB\xCC"
    store.delete(0).should == "\xAA\xBB\xCC"
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = "\xAA\xBB\xCC"
    store[0].should == "\xAA\xBB\xCC"
    store[0] = "über"
    store[0].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[0] = value).should equal(value)
    store[0].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = "\xAA\xBB\xCC"
    store[0].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = "\xAA\xBB\xCC"
    store.fetch(0, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_binaryvalue ####################

shared_examples_for 'returndifferent_nilkey_binaryvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[0] = value
    store[0].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_binaryvalue ####################

shared_examples_for 'returnsame_nilkey_binaryvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[0] = value
    store[0].should be_equal(value)
  end
end

#################### persist_nilkey_binaryvalue ####################

shared_examples_for 'persist_nilkey_binaryvalue' do
  it 'persists values' do
    store[nil] = "über"
    store.close
    @store = nil
    store[nil].should == "über"
  end

  it 'persists values' do
    store[0] = "über"
    store.close
    @store = nil
    store[0].should == "über"
  end

  it 'persists values' do
    store[nil] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[nil].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[0] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[0].should == "\xAA\xBB\xCC"
  end
end

#################### null_nilkey_hashvalue ####################

shared_examples_for 'null_nilkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_nilkey_hashvalue ####################

shared_examples_for 'store_nilkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store.load(nil).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(nil, value).should equal(value)
    store[nil].should == {"hashval1"=>["array1", 1]}
    store.load(nil).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.delete(nil).should == {"hashval1"=>["array1", 1]}
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.fetch(nil, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store.load(0).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(0, value).should equal(value)
    store[0].should == {"hashval1"=>["array1", 1]}
    store.load(0).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.delete(0).should == {"hashval1"=>["array1", 1]}
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[0] = value).should equal(value)
    store[0].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.fetch(0, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(nil, value).should equal(value)
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(nil).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store[nil].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[nil] = value).should equal(value)
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(nil, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(0, value).should equal(value)
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(0).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = {"hashval1"=>["array1", 1]}
    store[0].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[0] = value).should equal(value)
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(0, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_hashvalue ####################

shared_examples_for 'returndifferent_nilkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = value
    store[0].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_hashvalue ####################

shared_examples_for 'returnsame_nilkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0] = value
    store[0].should be_equal(value)
  end
end

#################### persist_nilkey_hashvalue ####################

shared_examples_for 'persist_nilkey_hashvalue' do
  it 'persists values' do
    store[nil] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[nil].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[0] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[0].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[nil] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[nil].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[0] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[0].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_nilkey_objectvalue ####################

shared_examples_for 'null_nilkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[nil].should be_nil
    store.load(nil).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[nil] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(nil).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(nil).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[nil] = Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(nil).should be_false
    store.key?(0).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(nil, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = nil
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(nil, options).should be_false
    store.load(nil, options).should be_nil
    store.fetch(nil, 42, options).should == 42
    store.fetch(nil, options) { 42 }.should == 42
    store.delete(nil, options).should be_nil
    store.clear(options).should equal(store)
    store.store(nil, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[0].should be_nil
    store.load(0).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[0] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0] = Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(0).should be_false
    store.key?(nil).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0, options).should be_false
    store.load(0, options).should be_nil
    store.fetch(0, 42, options).should == 42
    store.fetch(0, options) { 42 }.should == 42
    store.delete(0, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_nilkey_objectvalue ####################

shared_examples_for 'store_nilkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store.load(nil).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = Value.new(:objval1)
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(nil, value).should equal(value)
    store[nil].should == Value.new(:objval1)
    store.load(nil).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[nil] = Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store.clear.should equal(store)
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = Value.new(:objval1)
    store.delete(nil).should == Value.new(:objval1)
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[nil] = value).should equal(value)
    store[nil].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = Value.new(:objval1)
    store.fetch(nil, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store.load(0).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[0] = Value.new(:objval1)
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(0, value).should equal(value)
    store[0].should == Value.new(:objval1)
    store.load(0).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[0] = Value.new(:objval1)
    store[nil] = Value.new(:objval2)
    store.clear.should equal(store)
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = Value.new(:objval1)
    store.delete(0).should == Value.new(:objval1)
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[0] = value).should equal(value)
    store[0].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = Value.new(:objval1)
    store.fetch(0, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store.load(nil).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[nil] = Value.new(:objval2)
    store.key?(nil).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(nil, value).should equal(value)
    store[nil].should == Value.new(:objval2)
    store.load(nil).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[nil] = Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store.clear.should equal(store)
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store[0].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[nil] = Value.new(:objval2)
    store.delete(nil).should == Value.new(:objval2)
    store.key?(nil).should be_false
  end

  it 'overwrites existing values' do
    store[nil] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store[nil].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[nil] = value).should equal(value)
    store[nil].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = nil.freeze
    store[key] = Value.new(:objval2)
    store[nil].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[nil] = Value.new(:objval2)
    store.fetch(nil, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[nil] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(nil) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store.load(0).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[0] = Value.new(:objval2)
    store.key?(0).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(0, value).should equal(value)
    store[0].should == Value.new(:objval2)
    store.load(0).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[0] = Value.new(:objval2)
    store[nil] = Value.new(:objval1)
    store.clear.should equal(store)
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store[nil].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0] = Value.new(:objval2)
    store.delete(0).should == Value.new(:objval2)
    store.key?(0).should be_false
  end

  it 'overwrites existing values' do
    store[0] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
    store[0] = Value.new(:objval1)
    store[0].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[0] = value).should equal(value)
    store[0].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = 0.freeze
    store[key] = Value.new(:objval2)
    store[0].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0] = Value.new(:objval2)
    store.fetch(0, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(0) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_nilkey_objectvalue ####################

shared_examples_for 'returndifferent_nilkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[0] = value
    store[0].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[nil] = value
    store[nil].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[0] = value
    store[0].should_not be_equal(value)
  end
end

#################### returnsame_nilkey_objectvalue ####################

shared_examples_for 'returnsame_nilkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[0] = value
    store[0].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[nil] = value
    store[nil].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[0] = value
    store[0].should be_equal(value)
  end
end

#################### persist_nilkey_objectvalue ####################

shared_examples_for 'persist_nilkey_objectvalue' do
  it 'persists values' do
    store[nil] = Value.new(:objval1)
    store.close
    @store = nil
    store[nil].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[0] = Value.new(:objval1)
    store.close
    @store = nil
    store[0].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[nil] = Value.new(:objval2)
    store.close
    @store = nil
    store[nil].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[0] = Value.new(:objval2)
    store.close
    @store = nil
    store[0].should == Value.new(:objval2)
  end
end

#################### null_integerkey_nilvalue ####################

shared_examples_for 'null_integerkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = ''
    store[42] = nil
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = ''
    store[-10] = nil
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = nil
    store[42] = ''
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = nil
    store[-10] = ''
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 0
    store[42] = false
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 0
    store[-10] = false
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = false
    store[42] = 0
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = false
    store[-10] = 0
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, false, options).should == false
  end
end

#################### store_integerkey_nilvalue ####################

shared_examples_for 'store_integerkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = ''
    store[-10].should == ''
    store.load(-10).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = ''
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(-10, value).should equal(value)
    store[-10].should == ''
    store.load(-10).should == ''
  end

  it 'stores values after clear' do
    store[-10] = ''
    store[42] = nil
    store.clear.should equal(store)
    store[-10] = ''
    store[-10].should == ''
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = ''
    store.delete(-10).should == ''
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = ''
    store[-10].should == ''
    store[-10] = nil
    store[-10].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == ''
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = ''
    store[-10].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[42] = ''
    store[42].should == ''
    store.load(42).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[42] = ''
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(42, value).should equal(value)
    store[42].should == ''
    store.load(42).should == ''
  end

  it 'stores values after clear' do
    store[42] = ''
    store[-10] = nil
    store.clear.should equal(store)
    store[42] = ''
    store[42].should == ''
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = ''
    store.delete(42).should == ''
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = ''
    store[42].should == ''
    store[42] = nil
    store[42].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[42] = value).should equal(value)
    store[42].should == ''
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = ''
    store[42].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = nil
    store[-10].should == nil
    store.load(-10).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = nil
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(-10, value).should equal(value)
    store[-10].should == nil
    store.load(-10).should == nil
  end

  it 'stores values after clear' do
    store[-10] = nil
    store[42] = ''
    store.clear.should equal(store)
    store[-10] = nil
    store[-10].should == nil
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = nil
    store.delete(-10).should == nil
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = nil
    store[-10].should == nil
    store[-10] = ''
    store[-10].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == nil
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = nil
    store[-10].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[42] = nil
    store[42].should == nil
    store.load(42).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[42] = nil
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(42, value).should equal(value)
    store[42].should == nil
    store.load(42).should == nil
  end

  it 'stores values after clear' do
    store[42] = nil
    store[-10] = ''
    store.clear.should equal(store)
    store[42] = nil
    store[42].should == nil
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = nil
    store.delete(42).should == nil
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = nil
    store[42].should == nil
    store[42] = ''
    store[42].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[42] = value).should equal(value)
    store[42].should == nil
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = nil
    store[42].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = 0
    store[-10].should == 0
    store.load(-10).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = 0
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(-10, value).should equal(value)
    store[-10].should == 0
    store.load(-10).should == 0
  end

  it 'stores values after clear' do
    store[-10] = 0
    store[42] = false
    store.clear.should equal(store)
    store[-10] = 0
    store[-10].should == 0
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 0
    store.delete(-10).should == 0
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 0
    store[-10].should == 0
    store[-10] = false
    store[-10].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == 0
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = 0
    store[-10].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 0
    store[42].should == 0
    store.load(42).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[42] = 0
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(42, value).should equal(value)
    store[42].should == 0
    store.load(42).should == 0
  end

  it 'stores values after clear' do
    store[42] = 0
    store[-10] = false
    store.clear.should equal(store)
    store[42] = 0
    store[42].should == 0
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 0
    store.delete(42).should == 0
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 0
    store[42].should == 0
    store[42] = false
    store[42].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[42] = value).should equal(value)
    store[42].should == 0
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = 0
    store[42].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = false
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = false
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(-10, value).should equal(value)
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'stores values after clear' do
    store[-10] = false
    store[42] = 0
    store.clear.should equal(store)
    store[-10] = false
    store[-10].should == false
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = false
    store.delete(-10).should == false
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = false
    store[-10].should == false
    store[-10] = 0
    store[-10].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == false
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = false
    store[-10].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[42] = false
    store[42].should == false
    store.load(42).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[42] = false
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(42, value).should equal(value)
    store[42].should == false
    store.load(42).should == false
  end

  it 'stores values after clear' do
    store[42] = false
    store[-10] = 0
    store.clear.should equal(store)
    store[42] = false
    store[42].should == false
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = false
    store.delete(42).should == false
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = false
    store[42].should == false
    store[42] = 0
    store[42].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[42] = value).should equal(value)
    store[42].should == false
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = false
    store[42].should == false
  end
end

#################### persist_integerkey_nilvalue ####################

shared_examples_for 'persist_integerkey_nilvalue' do
  it 'persists values' do
    store[-10] = ''
    store.close
    @store = nil
    store[-10].should == ''
  end

  it 'persists values' do
    store[42] = ''
    store.close
    @store = nil
    store[42].should == ''
  end

  it 'persists values' do
    store[-10] = nil
    store.close
    @store = nil
    store[-10].should == nil
  end

  it 'persists values' do
    store[42] = nil
    store.close
    @store = nil
    store[42].should == nil
  end

  it 'persists values' do
    store[-10] = 0
    store.close
    @store = nil
    store[-10].should == 0
  end

  it 'persists values' do
    store[42] = 0
    store.close
    @store = nil
    store[42].should == 0
  end

  it 'persists values' do
    store[-10] = false
    store.close
    @store = nil
    store[-10].should == false
  end

  it 'persists values' do
    store[42] = false
    store.close
    @store = nil
    store[42].should == false
  end
end

#################### null_integerkey_integervalue ####################

shared_examples_for 'null_integerkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 41
    store[42] = -12
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 41
    store[-10] = -12
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = -12
    store[42] = 41
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = -12
    store[-10] = 41
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, -12, options).should == -12
  end
end

#################### store_integerkey_integervalue ####################

shared_examples_for 'store_integerkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = 41
    store[-10].should == 41
    store.load(-10).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = 41
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(-10, value).should equal(value)
    store[-10].should == 41
    store.load(-10).should == 41
  end

  it 'stores values after clear' do
    store[-10] = 41
    store[42] = -12
    store.clear.should equal(store)
    store[-10] = 41
    store[-10].should == 41
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 41
    store.delete(-10).should == 41
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 41
    store[-10].should == 41
    store[-10] = -12
    store[-10].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == 41
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = 41
    store[-10].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = 41
    store.fetch(-10, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = 41
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 41
    store[42].should == 41
    store.load(42).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[42] = 41
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(42, value).should equal(value)
    store[42].should == 41
    store.load(42).should == 41
  end

  it 'stores values after clear' do
    store[42] = 41
    store[-10] = -12
    store.clear.should equal(store)
    store[42] = 41
    store[42].should == 41
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 41
    store.delete(42).should == 41
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 41
    store[42].should == 41
    store[42] = -12
    store[42].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[42] = value).should equal(value)
    store[42].should == 41
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = 41
    store[42].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = 41
    store.fetch(42, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = 41
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = -12
    store[-10].should == -12
    store.load(-10).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = -12
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(-10, value).should equal(value)
    store[-10].should == -12
    store.load(-10).should == -12
  end

  it 'stores values after clear' do
    store[-10] = -12
    store[42] = 41
    store.clear.should equal(store)
    store[-10] = -12
    store[-10].should == -12
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = -12
    store.delete(-10).should == -12
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = -12
    store[-10].should == -12
    store[-10] = 41
    store[-10].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == -12
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = -12
    store[-10].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = -12
    store.fetch(-10, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = -12
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = -12
    store[42].should == -12
    store.load(42).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[42] = -12
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(42, value).should equal(value)
    store[42].should == -12
    store.load(42).should == -12
  end

  it 'stores values after clear' do
    store[42] = -12
    store[-10] = 41
    store.clear.should equal(store)
    store[42] = -12
    store[42].should == -12
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = -12
    store.delete(42).should == -12
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = -12
    store[42].should == -12
    store[42] = 41
    store[42].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[42] = value).should equal(value)
    store[42].should == -12
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = -12
    store[42].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = -12
    store.fetch(42, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = -12
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_integerkey_integervalue ####################

shared_examples_for 'persist_integerkey_integervalue' do
  it 'persists values' do
    store[-10] = 41
    store.close
    @store = nil
    store[-10].should == 41
  end

  it 'persists values' do
    store[42] = 41
    store.close
    @store = nil
    store[42].should == 41
  end

  it 'persists values' do
    store[-10] = -12
    store.close
    @store = nil
    store[-10].should == -12
  end

  it 'persists values' do
    store[42] = -12
    store.close
    @store = nil
    store[42].should == -12
  end
end

#################### null_integerkey_numbervalue ####################

shared_examples_for 'null_integerkey_numbervalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 123.456
    store[42] = -98.7
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 123.456
    store[-10] = -98.7
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = -98.7
    store[42] = 123.456
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = -98.7
    store[-10] = 123.456
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 340282366920938463463374607431768211456
    store[42] = 33
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 340282366920938463463374607431768211456
    store[-10] = 33
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = 33
    store[42] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = 33
    store[-10] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, 33, options).should == 33
  end
end

#################### store_integerkey_numbervalue ####################

shared_examples_for 'store_integerkey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = 123.456
    store[-10].should == 123.456
    store.load(-10).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = 123.456
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(-10, value).should equal(value)
    store[-10].should == 123.456
    store.load(-10).should == 123.456
  end

  it 'stores values after clear' do
    store[-10] = 123.456
    store[42] = -98.7
    store.clear.should equal(store)
    store[-10] = 123.456
    store[-10].should == 123.456
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 123.456
    store.delete(-10).should == 123.456
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 123.456
    store[-10].should == 123.456
    store[-10] = -98.7
    store[-10].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == 123.456
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = 123.456
    store[-10].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = 123.456
    store.fetch(-10, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = 123.456
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 123.456
    store[42].should == 123.456
    store.load(42).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[42] = 123.456
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(42, value).should equal(value)
    store[42].should == 123.456
    store.load(42).should == 123.456
  end

  it 'stores values after clear' do
    store[42] = 123.456
    store[-10] = -98.7
    store.clear.should equal(store)
    store[42] = 123.456
    store[42].should == 123.456
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 123.456
    store.delete(42).should == 123.456
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 123.456
    store[42].should == 123.456
    store[42] = -98.7
    store[42].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[42] = value).should equal(value)
    store[42].should == 123.456
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = 123.456
    store[42].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = 123.456
    store.fetch(42, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = 123.456
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = -98.7
    store[-10].should == -98.7
    store.load(-10).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = -98.7
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(-10, value).should equal(value)
    store[-10].should == -98.7
    store.load(-10).should == -98.7
  end

  it 'stores values after clear' do
    store[-10] = -98.7
    store[42] = 123.456
    store.clear.should equal(store)
    store[-10] = -98.7
    store[-10].should == -98.7
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = -98.7
    store.delete(-10).should == -98.7
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = -98.7
    store[-10].should == -98.7
    store[-10] = 123.456
    store[-10].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == -98.7
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = -98.7
    store[-10].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = -98.7
    store.fetch(-10, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = -98.7
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = -98.7
    store[42].should == -98.7
    store.load(42).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[42] = -98.7
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(42, value).should equal(value)
    store[42].should == -98.7
    store.load(42).should == -98.7
  end

  it 'stores values after clear' do
    store[42] = -98.7
    store[-10] = 123.456
    store.clear.should equal(store)
    store[42] = -98.7
    store[42].should == -98.7
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = -98.7
    store.delete(42).should == -98.7
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = -98.7
    store[42].should == -98.7
    store[42] = 123.456
    store[42].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[42] = value).should equal(value)
    store[42].should == -98.7
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = -98.7
    store[42].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = -98.7
    store.fetch(42, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = -98.7
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = 340282366920938463463374607431768211456
    store[-10].should == 340282366920938463463374607431768211456
    store.load(-10).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = 340282366920938463463374607431768211456
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(-10, value).should equal(value)
    store[-10].should == 340282366920938463463374607431768211456
    store.load(-10).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[-10] = 340282366920938463463374607431768211456
    store[42] = 33
    store.clear.should equal(store)
    store[-10] = 340282366920938463463374607431768211456
    store[-10].should == 340282366920938463463374607431768211456
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 340282366920938463463374607431768211456
    store.delete(-10).should == 340282366920938463463374607431768211456
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 340282366920938463463374607431768211456
    store[-10].should == 340282366920938463463374607431768211456
    store[-10] = 33
    store[-10].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = 340282366920938463463374607431768211456
    store[-10].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = 340282366920938463463374607431768211456
    store.fetch(-10, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 340282366920938463463374607431768211456
    store[42].should == 340282366920938463463374607431768211456
    store.load(42).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[42] = 340282366920938463463374607431768211456
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(42, value).should equal(value)
    store[42].should == 340282366920938463463374607431768211456
    store.load(42).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[42] = 340282366920938463463374607431768211456
    store[-10] = 33
    store.clear.should equal(store)
    store[42] = 340282366920938463463374607431768211456
    store[42].should == 340282366920938463463374607431768211456
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 340282366920938463463374607431768211456
    store.delete(42).should == 340282366920938463463374607431768211456
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 340282366920938463463374607431768211456
    store[42].should == 340282366920938463463374607431768211456
    store[42] = 33
    store[42].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[42] = value).should equal(value)
    store[42].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = 340282366920938463463374607431768211456
    store[42].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = 340282366920938463463374607431768211456
    store.fetch(42, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = 33
    store[-10].should == 33
    store.load(-10).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = 33
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(-10, value).should equal(value)
    store[-10].should == 33
    store.load(-10).should == 33
  end

  it 'stores values after clear' do
    store[-10] = 33
    store[42] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[-10] = 33
    store[-10].should == 33
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = 33
    store.delete(-10).should == 33
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = 33
    store[-10].should == 33
    store[-10] = 340282366920938463463374607431768211456
    store[-10].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == 33
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = 33
    store[-10].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = 33
    store.fetch(-10, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = 33
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = 33
    store[42].should == 33
    store.load(42).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[42] = 33
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(42, value).should equal(value)
    store[42].should == 33
    store.load(42).should == 33
  end

  it 'stores values after clear' do
    store[42] = 33
    store[-10] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[42] = 33
    store[42].should == 33
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = 33
    store.delete(42).should == 33
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = 33
    store[42].should == 33
    store[42] = 340282366920938463463374607431768211456
    store[42].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[42] = value).should equal(value)
    store[42].should == 33
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = 33
    store[42].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = 33
    store.fetch(42, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = 33
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_integerkey_numbervalue ####################

shared_examples_for 'persist_integerkey_numbervalue' do
  it 'persists values' do
    store[-10] = 123.456
    store.close
    @store = nil
    store[-10].should == 123.456
  end

  it 'persists values' do
    store[42] = 123.456
    store.close
    @store = nil
    store[42].should == 123.456
  end

  it 'persists values' do
    store[-10] = -98.7
    store.close
    @store = nil
    store[-10].should == -98.7
  end

  it 'persists values' do
    store[42] = -98.7
    store.close
    @store = nil
    store[42].should == -98.7
  end

  it 'persists values' do
    store[-10] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[-10].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[42] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[42].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[-10] = 33
    store.close
    @store = nil
    store[-10].should == 33
  end

  it 'persists values' do
    store[42] = 33
    store.close
    @store = nil
    store[42].should == 33
  end
end

#################### null_integerkey_booleanvalue ####################

shared_examples_for 'null_integerkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = true
    store[42] = false
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = true
    store[-10] = false
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = false
    store[42] = true
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = false
    store[-10] = true
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, false, options).should == false
  end
end

#################### store_integerkey_booleanvalue ####################

shared_examples_for 'store_integerkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = true
    store[-10].should == true
    store.load(-10).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = true
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(-10, value).should equal(value)
    store[-10].should == true
    store.load(-10).should == true
  end

  it 'stores values after clear' do
    store[-10] = true
    store[42] = false
    store.clear.should equal(store)
    store[-10] = true
    store[-10].should == true
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = true
    store.delete(-10).should == true
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = true
    store[-10].should == true
    store[-10] = false
    store[-10].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == true
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = true
    store[-10].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = true
    store.fetch(-10, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = true
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = true
    store[42].should == true
    store.load(42).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[42] = true
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(42, value).should equal(value)
    store[42].should == true
    store.load(42).should == true
  end

  it 'stores values after clear' do
    store[42] = true
    store[-10] = false
    store.clear.should equal(store)
    store[42] = true
    store[42].should == true
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = true
    store.delete(42).should == true
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = true
    store[42].should == true
    store[42] = false
    store[42].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[42] = value).should equal(value)
    store[42].should == true
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = true
    store[42].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = true
    store.fetch(42, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = true
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = false
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = false
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(-10, value).should equal(value)
    store[-10].should == false
    store.load(-10).should == false
  end

  it 'stores values after clear' do
    store[-10] = false
    store[42] = true
    store.clear.should equal(store)
    store[-10] = false
    store[-10].should == false
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = false
    store.delete(-10).should == false
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = false
    store[-10].should == false
    store[-10] = true
    store[-10].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == false
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = false
    store[-10].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = false
    store.fetch(-10, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = false
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = false
    store[42].should == false
    store.load(42).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[42] = false
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(42, value).should equal(value)
    store[42].should == false
    store.load(42).should == false
  end

  it 'stores values after clear' do
    store[42] = false
    store[-10] = true
    store.clear.should equal(store)
    store[42] = false
    store[42].should == false
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = false
    store.delete(42).should == false
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = false
    store[42].should == false
    store[42] = true
    store[42].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[42] = value).should equal(value)
    store[42].should == false
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = false
    store[42].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = false
    store.fetch(42, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = false
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_integerkey_booleanvalue ####################

shared_examples_for 'persist_integerkey_booleanvalue' do
  it 'persists values' do
    store[-10] = true
    store.close
    @store = nil
    store[-10].should == true
  end

  it 'persists values' do
    store[42] = true
    store.close
    @store = nil
    store[42].should == true
  end

  it 'persists values' do
    store[-10] = false
    store.close
    @store = nil
    store[-10].should == false
  end

  it 'persists values' do
    store[42] = false
    store.close
    @store = nil
    store[42].should == false
  end
end

#################### null_integerkey_stringvalue ####################

shared_examples_for 'null_integerkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "strval1"
    store[42] = "strval2"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "strval1"
    store[-10] = "strval2"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "strval2"
    store[42] = "strval1"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "strval2"
    store[-10] = "strval1"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "strval2", options).should == "strval2"
  end
end

#################### store_integerkey_stringvalue ####################

shared_examples_for 'store_integerkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store.load(-10).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = "strval1"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(-10, value).should equal(value)
    store[-10].should == "strval1"
    store.load(-10).should == "strval1"
  end

  it 'stores values after clear' do
    store[-10] = "strval1"
    store[42] = "strval2"
    store.clear.should equal(store)
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "strval1"
    store.delete(-10).should == "strval1"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "strval1"
    store[-10].should == "strval1"
    store[-10] = "strval2"
    store[-10].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[-10] = value).should equal(value)
    store[-10].should == "strval1"
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = "strval1"
    store[-10].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "strval1"
    store.fetch(-10, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "strval1"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "strval1"
    store[42].should == "strval1"
    store.load(42).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[42] = "strval1"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(42, value).should equal(value)
    store[42].should == "strval1"
    store.load(42).should == "strval1"
  end

  it 'stores values after clear' do
    store[42] = "strval1"
    store[-10] = "strval2"
    store.clear.should equal(store)
    store[42] = "strval1"
    store[42].should == "strval1"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "strval1"
    store.delete(42).should == "strval1"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "strval1"
    store[42].should == "strval1"
    store[42] = "strval2"
    store[42].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[42] = value).should equal(value)
    store[42].should == "strval1"
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = "strval1"
    store[42].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "strval1"
    store.fetch(42, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "strval1"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store.load(-10).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = "strval2"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(-10, value).should equal(value)
    store[-10].should == "strval2"
    store.load(-10).should == "strval2"
  end

  it 'stores values after clear' do
    store[-10] = "strval2"
    store[42] = "strval1"
    store.clear.should equal(store)
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "strval2"
    store.delete(-10).should == "strval2"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "strval2"
    store[-10].should == "strval2"
    store[-10] = "strval1"
    store[-10].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[-10] = value).should equal(value)
    store[-10].should == "strval2"
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = "strval2"
    store[-10].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "strval2"
    store.fetch(-10, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "strval2"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "strval2"
    store[42].should == "strval2"
    store.load(42).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[42] = "strval2"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(42, value).should equal(value)
    store[42].should == "strval2"
    store.load(42).should == "strval2"
  end

  it 'stores values after clear' do
    store[42] = "strval2"
    store[-10] = "strval1"
    store.clear.should equal(store)
    store[42] = "strval2"
    store[42].should == "strval2"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "strval2"
    store.delete(42).should == "strval2"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "strval2"
    store[42].should == "strval2"
    store[42] = "strval1"
    store[42].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[42] = value).should equal(value)
    store[42].should == "strval2"
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = "strval2"
    store[42].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "strval2"
    store.fetch(42, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "strval2"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_stringvalue ####################

shared_examples_for 'returndifferent_integerkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_stringvalue ####################

shared_examples_for 'returnsame_integerkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_stringvalue ####################

shared_examples_for 'persist_integerkey_stringvalue' do
  it 'persists values' do
    store[-10] = "strval1"
    store.close
    @store = nil
    store[-10].should == "strval1"
  end

  it 'persists values' do
    store[42] = "strval1"
    store.close
    @store = nil
    store[42].should == "strval1"
  end

  it 'persists values' do
    store[-10] = "strval2"
    store.close
    @store = nil
    store[-10].should == "strval2"
  end

  it 'persists values' do
    store[42] = "strval2"
    store.close
    @store = nil
    store[42].should == "strval2"
  end
end

#################### null_integerkey_binaryvalue ####################

shared_examples_for 'null_integerkey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "über"
    store[42] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "über"
    store[-10] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = "\xAA\xBB\xCC"
    store[42] = "über"
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = "\xAA\xBB\xCC"
    store[-10] = "über"
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end
end

#################### store_integerkey_binaryvalue ####################

shared_examples_for 'store_integerkey_binaryvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = "über"
    store[-10].should == "über"
    store.load(-10).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = "über"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(-10, value).should equal(value)
    store[-10].should == "über"
    store.load(-10).should == "über"
  end

  it 'stores values after clear' do
    store[-10] = "über"
    store[42] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[-10] = "über"
    store[-10].should == "über"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "über"
    store.delete(-10).should == "über"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "über"
    store[-10].should == "über"
    store[-10] = "\xAA\xBB\xCC"
    store[-10].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[-10] = value).should equal(value)
    store[-10].should == "über"
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = "über"
    store[-10].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "über"
    store.fetch(-10, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "über"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "über"
    store[42].should == "über"
    store.load(42).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[42] = "über"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(42, value).should equal(value)
    store[42].should == "über"
    store.load(42).should == "über"
  end

  it 'stores values after clear' do
    store[42] = "über"
    store[-10] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[42] = "über"
    store[42].should == "über"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "über"
    store.delete(42).should == "über"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "über"
    store[42].should == "über"
    store[42] = "\xAA\xBB\xCC"
    store[42].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[42] = value).should equal(value)
    store[42].should == "über"
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = "über"
    store[42].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "über"
    store.fetch(42, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "über"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = "\xAA\xBB\xCC"
    store[-10].should == "\xAA\xBB\xCC"
    store.load(-10).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = "\xAA\xBB\xCC"
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(-10, value).should equal(value)
    store[-10].should == "\xAA\xBB\xCC"
    store.load(-10).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[-10] = "\xAA\xBB\xCC"
    store[42] = "über"
    store.clear.should equal(store)
    store[-10] = "\xAA\xBB\xCC"
    store[-10].should == "\xAA\xBB\xCC"
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = "\xAA\xBB\xCC"
    store.delete(-10).should == "\xAA\xBB\xCC"
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = "\xAA\xBB\xCC"
    store[-10].should == "\xAA\xBB\xCC"
    store[-10] = "über"
    store[-10].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[-10] = value).should equal(value)
    store[-10].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = "\xAA\xBB\xCC"
    store[-10].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = "\xAA\xBB\xCC"
    store.fetch(-10, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = "\xAA\xBB\xCC"
    store[42].should == "\xAA\xBB\xCC"
    store.load(42).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[42] = "\xAA\xBB\xCC"
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(42, value).should equal(value)
    store[42].should == "\xAA\xBB\xCC"
    store.load(42).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[42] = "\xAA\xBB\xCC"
    store[-10] = "über"
    store.clear.should equal(store)
    store[42] = "\xAA\xBB\xCC"
    store[42].should == "\xAA\xBB\xCC"
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = "\xAA\xBB\xCC"
    store.delete(42).should == "\xAA\xBB\xCC"
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = "\xAA\xBB\xCC"
    store[42].should == "\xAA\xBB\xCC"
    store[42] = "über"
    store[42].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[42] = value).should equal(value)
    store[42].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = "\xAA\xBB\xCC"
    store[42].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = "\xAA\xBB\xCC"
    store.fetch(42, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_binaryvalue ####################

shared_examples_for 'returndifferent_integerkey_binaryvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_binaryvalue ####################

shared_examples_for 'returnsame_integerkey_binaryvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_binaryvalue ####################

shared_examples_for 'persist_integerkey_binaryvalue' do
  it 'persists values' do
    store[-10] = "über"
    store.close
    @store = nil
    store[-10].should == "über"
  end

  it 'persists values' do
    store[42] = "über"
    store.close
    @store = nil
    store[42].should == "über"
  end

  it 'persists values' do
    store[-10] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[-10].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[42] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[42].should == "\xAA\xBB\xCC"
  end
end

#################### null_integerkey_hashvalue ####################

shared_examples_for 'null_integerkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_integerkey_hashvalue ####################

shared_examples_for 'store_integerkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store.load(-10).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(-10, value).should equal(value)
    store[-10].should == {"hashval1"=>["array1", 1]}
    store.load(-10).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.delete(-10).should == {"hashval1"=>["array1", 1]}
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.fetch(-10, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store.load(42).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(42, value).should equal(value)
    store[42].should == {"hashval1"=>["array1", 1]}
    store.load(42).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.delete(42).should == {"hashval1"=>["array1", 1]}
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[42] = value).should equal(value)
    store[42].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.fetch(42, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(-10, value).should equal(value)
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(-10).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store[-10].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[-10] = value).should equal(value)
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(-10, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(42, value).should equal(value)
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(42).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = {"hashval1"=>["array1", 1]}
    store[42].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[42] = value).should equal(value)
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(42, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_hashvalue ####################

shared_examples_for 'returndifferent_integerkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_hashvalue ####################

shared_examples_for 'returnsame_integerkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_hashvalue ####################

shared_examples_for 'persist_integerkey_hashvalue' do
  it 'persists values' do
    store[-10] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[-10].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[42] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[42].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[-10] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[-10].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[42] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[42].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_integerkey_objectvalue ####################

shared_examples_for 'null_integerkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[-10].should be_nil
    store.load(-10).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[-10] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-10).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-10).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-10] = Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(-10).should be_false
    store.key?(42).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-10, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -10
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-10, options).should be_false
    store.load(-10, options).should be_nil
    store.fetch(-10, 42, options).should == 42
    store.fetch(-10, options) { 42 }.should == 42
    store.delete(-10, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-10, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[42].should be_nil
    store.load(42).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[42] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(42).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(42).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[42] = Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(42).should be_false
    store.key?(-10).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(42, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 42
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(42, options).should be_false
    store.load(42, options).should be_nil
    store.fetch(42, 42, options).should == 42
    store.fetch(42, options) { 42 }.should == 42
    store.delete(42, options).should be_nil
    store.clear(options).should equal(store)
    store.store(42, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_integerkey_objectvalue ####################

shared_examples_for 'store_integerkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store.load(-10).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = Value.new(:objval1)
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(-10, value).should equal(value)
    store[-10].should == Value.new(:objval1)
    store.load(-10).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[-10] = Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store.clear.should equal(store)
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = Value.new(:objval1)
    store.delete(-10).should == Value.new(:objval1)
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[-10] = value).should equal(value)
    store[-10].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = Value.new(:objval1)
    store.fetch(-10, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store.load(42).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[42] = Value.new(:objval1)
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(42, value).should equal(value)
    store[42].should == Value.new(:objval1)
    store.load(42).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[42] = Value.new(:objval1)
    store[-10] = Value.new(:objval2)
    store.clear.should equal(store)
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = Value.new(:objval1)
    store.delete(42).should == Value.new(:objval1)
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[42] = value).should equal(value)
    store[42].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = Value.new(:objval1)
    store.fetch(42, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store.load(-10).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[-10] = Value.new(:objval2)
    store.key?(-10).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(-10, value).should equal(value)
    store[-10].should == Value.new(:objval2)
    store.load(-10).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[-10] = Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store.clear.should equal(store)
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store[42].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-10] = Value.new(:objval2)
    store.delete(-10).should == Value.new(:objval2)
    store.key?(-10).should be_false
  end

  it 'overwrites existing values' do
    store[-10] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store[-10].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[-10] = value).should equal(value)
    store[-10].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = -10.freeze
    store[key] = Value.new(:objval2)
    store[-10].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-10] = Value.new(:objval2)
    store.fetch(-10, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-10] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(-10) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store.load(42).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[42] = Value.new(:objval2)
    store.key?(42).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(42, value).should equal(value)
    store[42].should == Value.new(:objval2)
    store.load(42).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[42] = Value.new(:objval2)
    store[-10] = Value.new(:objval1)
    store.clear.should equal(store)
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store[-10].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[42] = Value.new(:objval2)
    store.delete(42).should == Value.new(:objval2)
    store.key?(42).should be_false
  end

  it 'overwrites existing values' do
    store[42] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
    store[42] = Value.new(:objval1)
    store[42].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[42] = value).should equal(value)
    store[42].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = 42.freeze
    store[key] = Value.new(:objval2)
    store[42].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[42] = Value.new(:objval2)
    store.fetch(42, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[42] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(42) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_integerkey_objectvalue ####################

shared_examples_for 'returndifferent_integerkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[42] = value
    store[42].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[-10] = value
    store[-10].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[42] = value
    store[42].should_not be_equal(value)
  end
end

#################### returnsame_integerkey_objectvalue ####################

shared_examples_for 'returnsame_integerkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[42] = value
    store[42].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[-10] = value
    store[-10].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[42] = value
    store[42].should be_equal(value)
  end
end

#################### persist_integerkey_objectvalue ####################

shared_examples_for 'persist_integerkey_objectvalue' do
  it 'persists values' do
    store[-10] = Value.new(:objval1)
    store.close
    @store = nil
    store[-10].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[42] = Value.new(:objval1)
    store.close
    @store = nil
    store[42].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[-10] = Value.new(:objval2)
    store.close
    @store = nil
    store[-10].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[42] = Value.new(:objval2)
    store.close
    @store = nil
    store[42].should == Value.new(:objval2)
  end
end

#################### null_numberkey_nilvalue ####################

shared_examples_for 'null_numberkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = ''
    store[-0.3] = nil
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = ''
    store[0.5] = nil
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = nil
    store[-0.3] = ''
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = nil
    store[0.5] = ''
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = 0
    store[-0.3] = false
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = 0
    store[0.5] = false
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = false
    store[-0.3] = 0
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = false
    store[0.5] = 0
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = ''
    store[99] = nil
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = ''
    store[170141183460469231731687303715884105728] = nil
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = nil
    store[99] = ''
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = nil
    store[170141183460469231731687303715884105728] = ''
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = 0
    store[99] = false
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = 0
    store[170141183460469231731687303715884105728] = false
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = false
    store[99] = 0
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = false
    store[170141183460469231731687303715884105728] = 0
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, false, options).should == false
  end
end

#################### store_numberkey_nilvalue ####################

shared_examples_for 'store_numberkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = ''
    store[0.5].should == ''
    store.load(0.5).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = ''
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(0.5, value).should equal(value)
    store[0.5].should == ''
    store.load(0.5).should == ''
  end

  it 'stores values after clear' do
    store[0.5] = ''
    store[-0.3] = nil
    store.clear.should equal(store)
    store[0.5] = ''
    store[0.5].should == ''
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = ''
    store.delete(0.5).should == ''
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = ''
    store[0.5].should == ''
    store[0.5] = nil
    store[0.5].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == ''
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = ''
    store[0.5].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = ''
    store[-0.3].should == ''
    store.load(-0.3).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = ''
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == ''
    store.load(-0.3).should == ''
  end

  it 'stores values after clear' do
    store[-0.3] = ''
    store[0.5] = nil
    store.clear.should equal(store)
    store[-0.3] = ''
    store[-0.3].should == ''
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = ''
    store.delete(-0.3).should == ''
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = ''
    store[-0.3].should == ''
    store[-0.3] = nil
    store[-0.3].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == ''
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = ''
    store[-0.3].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = nil
    store[0.5].should == nil
    store.load(0.5).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = nil
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(0.5, value).should equal(value)
    store[0.5].should == nil
    store.load(0.5).should == nil
  end

  it 'stores values after clear' do
    store[0.5] = nil
    store[-0.3] = ''
    store.clear.should equal(store)
    store[0.5] = nil
    store[0.5].should == nil
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = nil
    store.delete(0.5).should == nil
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = nil
    store[0.5].should == nil
    store[0.5] = ''
    store[0.5].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == nil
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = nil
    store[0.5].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = nil
    store[-0.3].should == nil
    store.load(-0.3).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = nil
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == nil
    store.load(-0.3).should == nil
  end

  it 'stores values after clear' do
    store[-0.3] = nil
    store[0.5] = ''
    store.clear.should equal(store)
    store[-0.3] = nil
    store[-0.3].should == nil
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = nil
    store.delete(-0.3).should == nil
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = nil
    store[-0.3].should == nil
    store[-0.3] = ''
    store[-0.3].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == nil
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = nil
    store[-0.3].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = 0
    store[0.5].should == 0
    store.load(0.5).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = 0
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(0.5, value).should equal(value)
    store[0.5].should == 0
    store.load(0.5).should == 0
  end

  it 'stores values after clear' do
    store[0.5] = 0
    store[-0.3] = false
    store.clear.should equal(store)
    store[0.5] = 0
    store[0.5].should == 0
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = 0
    store.delete(0.5).should == 0
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = 0
    store[0.5].should == 0
    store[0.5] = false
    store[0.5].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == 0
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = 0
    store[0.5].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = 0
    store[-0.3].should == 0
    store.load(-0.3).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = 0
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == 0
    store.load(-0.3).should == 0
  end

  it 'stores values after clear' do
    store[-0.3] = 0
    store[0.5] = false
    store.clear.should equal(store)
    store[-0.3] = 0
    store[-0.3].should == 0
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = 0
    store.delete(-0.3).should == 0
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = 0
    store[-0.3].should == 0
    store[-0.3] = false
    store[-0.3].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == 0
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = 0
    store[-0.3].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = false
    store[0.5].should == false
    store.load(0.5).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = false
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(0.5, value).should equal(value)
    store[0.5].should == false
    store.load(0.5).should == false
  end

  it 'stores values after clear' do
    store[0.5] = false
    store[-0.3] = 0
    store.clear.should equal(store)
    store[0.5] = false
    store[0.5].should == false
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = false
    store.delete(0.5).should == false
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = false
    store[0.5].should == false
    store[0.5] = 0
    store[0.5].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == false
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = false
    store[0.5].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = false
    store[-0.3].should == false
    store.load(-0.3).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = false
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == false
    store.load(-0.3).should == false
  end

  it 'stores values after clear' do
    store[-0.3] = false
    store[0.5] = 0
    store.clear.should equal(store)
    store[-0.3] = false
    store[-0.3].should == false
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = false
    store.delete(-0.3).should == false
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = false
    store[-0.3].should == false
    store[-0.3] = 0
    store[-0.3].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == false
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = false
    store[-0.3].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = ''
    store[170141183460469231731687303715884105728].should == ''
    store.load(170141183460469231731687303715884105728).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = ''
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == ''
    store.load(170141183460469231731687303715884105728).should == ''
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = ''
    store[99] = nil
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = ''
    store[170141183460469231731687303715884105728].should == ''
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = ''
    store.delete(170141183460469231731687303715884105728).should == ''
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = ''
    store[170141183460469231731687303715884105728].should == ''
    store[170141183460469231731687303715884105728] = nil
    store[170141183460469231731687303715884105728].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == ''
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = ''
    store[170141183460469231731687303715884105728].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[99] = ''
    store[99].should == ''
    store.load(99).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[99] = ''
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(99, value).should equal(value)
    store[99].should == ''
    store.load(99).should == ''
  end

  it 'stores values after clear' do
    store[99] = ''
    store[170141183460469231731687303715884105728] = nil
    store.clear.should equal(store)
    store[99] = ''
    store[99].should == ''
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = ''
    store.delete(99).should == ''
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = ''
    store[99].should == ''
    store[99] = nil
    store[99].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[99] = value).should equal(value)
    store[99].should == ''
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = ''
    store[99].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = nil
    store[170141183460469231731687303715884105728].should == nil
    store.load(170141183460469231731687303715884105728).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = nil
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == nil
    store.load(170141183460469231731687303715884105728).should == nil
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = nil
    store[99] = ''
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = nil
    store[170141183460469231731687303715884105728].should == nil
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = nil
    store.delete(170141183460469231731687303715884105728).should == nil
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = nil
    store[170141183460469231731687303715884105728].should == nil
    store[170141183460469231731687303715884105728] = ''
    store[170141183460469231731687303715884105728].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == nil
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = nil
    store[170141183460469231731687303715884105728].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[99] = nil
    store[99].should == nil
    store.load(99).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[99] = nil
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(99, value).should equal(value)
    store[99].should == nil
    store.load(99).should == nil
  end

  it 'stores values after clear' do
    store[99] = nil
    store[170141183460469231731687303715884105728] = ''
    store.clear.should equal(store)
    store[99] = nil
    store[99].should == nil
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = nil
    store.delete(99).should == nil
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = nil
    store[99].should == nil
    store[99] = ''
    store[99].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[99] = value).should equal(value)
    store[99].should == nil
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = nil
    store[99].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = 0
    store[170141183460469231731687303715884105728].should == 0
    store.load(170141183460469231731687303715884105728).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = 0
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == 0
    store.load(170141183460469231731687303715884105728).should == 0
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = 0
    store[99] = false
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = 0
    store[170141183460469231731687303715884105728].should == 0
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = 0
    store.delete(170141183460469231731687303715884105728).should == 0
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = 0
    store[170141183460469231731687303715884105728].should == 0
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == 0
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = 0
    store[170141183460469231731687303715884105728].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[99] = 0
    store[99].should == 0
    store.load(99).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[99] = 0
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(99, value).should equal(value)
    store[99].should == 0
    store.load(99).should == 0
  end

  it 'stores values after clear' do
    store[99] = 0
    store[170141183460469231731687303715884105728] = false
    store.clear.should equal(store)
    store[99] = 0
    store[99].should == 0
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = 0
    store.delete(99).should == 0
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = 0
    store[99].should == 0
    store[99] = false
    store[99].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[99] = value).should equal(value)
    store[99].should == 0
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = 0
    store[99].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store.load(170141183460469231731687303715884105728).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = false
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == false
    store.load(170141183460469231731687303715884105728).should == false
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = false
    store[99] = 0
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = false
    store.delete(170141183460469231731687303715884105728).should == false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store[170141183460469231731687303715884105728] = 0
    store[170141183460469231731687303715884105728].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == false
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = false
    store[170141183460469231731687303715884105728].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[99] = false
    store[99].should == false
    store.load(99).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[99] = false
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(99, value).should equal(value)
    store[99].should == false
    store.load(99).should == false
  end

  it 'stores values after clear' do
    store[99] = false
    store[170141183460469231731687303715884105728] = 0
    store.clear.should equal(store)
    store[99] = false
    store[99].should == false
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = false
    store.delete(99).should == false
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = false
    store[99].should == false
    store[99] = 0
    store[99].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[99] = value).should equal(value)
    store[99].should == false
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = false
    store[99].should == false
  end
end

#################### persist_numberkey_nilvalue ####################

shared_examples_for 'persist_numberkey_nilvalue' do
  it 'persists values' do
    store[0.5] = ''
    store.close
    @store = nil
    store[0.5].should == ''
  end

  it 'persists values' do
    store[-0.3] = ''
    store.close
    @store = nil
    store[-0.3].should == ''
  end

  it 'persists values' do
    store[0.5] = nil
    store.close
    @store = nil
    store[0.5].should == nil
  end

  it 'persists values' do
    store[-0.3] = nil
    store.close
    @store = nil
    store[-0.3].should == nil
  end

  it 'persists values' do
    store[0.5] = 0
    store.close
    @store = nil
    store[0.5].should == 0
  end

  it 'persists values' do
    store[-0.3] = 0
    store.close
    @store = nil
    store[-0.3].should == 0
  end

  it 'persists values' do
    store[0.5] = false
    store.close
    @store = nil
    store[0.5].should == false
  end

  it 'persists values' do
    store[-0.3] = false
    store.close
    @store = nil
    store[-0.3].should == false
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = ''
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == ''
  end

  it 'persists values' do
    store[99] = ''
    store.close
    @store = nil
    store[99].should == ''
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = nil
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == nil
  end

  it 'persists values' do
    store[99] = nil
    store.close
    @store = nil
    store[99].should == nil
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = 0
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == 0
  end

  it 'persists values' do
    store[99] = 0
    store.close
    @store = nil
    store[99].should == 0
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = false
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == false
  end

  it 'persists values' do
    store[99] = false
    store.close
    @store = nil
    store[99].should == false
  end
end

#################### null_numberkey_integervalue ####################

shared_examples_for 'null_numberkey_integervalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = 41
    store[-0.3] = -12
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = 41
    store[0.5] = -12
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = -12
    store[-0.3] = 41
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = -12
    store[0.5] = 41
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = 41
    store[99] = -12
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = 41
    store[170141183460469231731687303715884105728] = -12
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = -12
    store[99] = 41
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = -12
    store[170141183460469231731687303715884105728] = 41
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, -12, options).should == -12
  end
end

#################### store_numberkey_integervalue ####################

shared_examples_for 'store_numberkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = 41
    store[0.5].should == 41
    store.load(0.5).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = 41
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(0.5, value).should equal(value)
    store[0.5].should == 41
    store.load(0.5).should == 41
  end

  it 'stores values after clear' do
    store[0.5] = 41
    store[-0.3] = -12
    store.clear.should equal(store)
    store[0.5] = 41
    store[0.5].should == 41
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = 41
    store.delete(0.5).should == 41
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = 41
    store[0.5].should == 41
    store[0.5] = -12
    store[0.5].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == 41
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = 41
    store[0.5].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = 41
    store.fetch(0.5, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = 41
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = 41
    store[-0.3].should == 41
    store.load(-0.3).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = 41
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == 41
    store.load(-0.3).should == 41
  end

  it 'stores values after clear' do
    store[-0.3] = 41
    store[0.5] = -12
    store.clear.should equal(store)
    store[-0.3] = 41
    store[-0.3].should == 41
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = 41
    store.delete(-0.3).should == 41
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = 41
    store[-0.3].should == 41
    store[-0.3] = -12
    store[-0.3].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == 41
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = 41
    store[-0.3].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = 41
    store.fetch(-0.3, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = 41
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = -12
    store[0.5].should == -12
    store.load(0.5).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = -12
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(0.5, value).should equal(value)
    store[0.5].should == -12
    store.load(0.5).should == -12
  end

  it 'stores values after clear' do
    store[0.5] = -12
    store[-0.3] = 41
    store.clear.should equal(store)
    store[0.5] = -12
    store[0.5].should == -12
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = -12
    store.delete(0.5).should == -12
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = -12
    store[0.5].should == -12
    store[0.5] = 41
    store[0.5].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == -12
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = -12
    store[0.5].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = -12
    store.fetch(0.5, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = -12
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = -12
    store[-0.3].should == -12
    store.load(-0.3).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = -12
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == -12
    store.load(-0.3).should == -12
  end

  it 'stores values after clear' do
    store[-0.3] = -12
    store[0.5] = 41
    store.clear.should equal(store)
    store[-0.3] = -12
    store[-0.3].should == -12
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = -12
    store.delete(-0.3).should == -12
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = -12
    store[-0.3].should == -12
    store[-0.3] = 41
    store[-0.3].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == -12
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = -12
    store[-0.3].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = -12
    store.fetch(-0.3, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = -12
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = 41
    store[170141183460469231731687303715884105728].should == 41
    store.load(170141183460469231731687303715884105728).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = 41
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == 41
    store.load(170141183460469231731687303715884105728).should == 41
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = 41
    store[99] = -12
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = 41
    store[170141183460469231731687303715884105728].should == 41
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = 41
    store.delete(170141183460469231731687303715884105728).should == 41
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = 41
    store[170141183460469231731687303715884105728].should == 41
    store[170141183460469231731687303715884105728] = -12
    store[170141183460469231731687303715884105728].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == 41
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = 41
    store[170141183460469231731687303715884105728].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = 41
    store.fetch(170141183460469231731687303715884105728, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = 41
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = 41
    store[99].should == 41
    store.load(99).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[99] = 41
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(99, value).should equal(value)
    store[99].should == 41
    store.load(99).should == 41
  end

  it 'stores values after clear' do
    store[99] = 41
    store[170141183460469231731687303715884105728] = -12
    store.clear.should equal(store)
    store[99] = 41
    store[99].should == 41
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = 41
    store.delete(99).should == 41
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = 41
    store[99].should == 41
    store[99] = -12
    store[99].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[99] = value).should equal(value)
    store[99].should == 41
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = 41
    store[99].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = 41
    store.fetch(99, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = 41
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = -12
    store[170141183460469231731687303715884105728].should == -12
    store.load(170141183460469231731687303715884105728).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = -12
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == -12
    store.load(170141183460469231731687303715884105728).should == -12
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = -12
    store[99] = 41
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = -12
    store[170141183460469231731687303715884105728].should == -12
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = -12
    store.delete(170141183460469231731687303715884105728).should == -12
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = -12
    store[170141183460469231731687303715884105728].should == -12
    store[170141183460469231731687303715884105728] = 41
    store[170141183460469231731687303715884105728].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == -12
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = -12
    store[170141183460469231731687303715884105728].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = -12
    store.fetch(170141183460469231731687303715884105728, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = -12
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = -12
    store[99].should == -12
    store.load(99).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[99] = -12
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(99, value).should equal(value)
    store[99].should == -12
    store.load(99).should == -12
  end

  it 'stores values after clear' do
    store[99] = -12
    store[170141183460469231731687303715884105728] = 41
    store.clear.should equal(store)
    store[99] = -12
    store[99].should == -12
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = -12
    store.delete(99).should == -12
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = -12
    store[99].should == -12
    store[99] = 41
    store[99].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[99] = value).should equal(value)
    store[99].should == -12
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = -12
    store[99].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = -12
    store.fetch(99, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = -12
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_numberkey_integervalue ####################

shared_examples_for 'persist_numberkey_integervalue' do
  it 'persists values' do
    store[0.5] = 41
    store.close
    @store = nil
    store[0.5].should == 41
  end

  it 'persists values' do
    store[-0.3] = 41
    store.close
    @store = nil
    store[-0.3].should == 41
  end

  it 'persists values' do
    store[0.5] = -12
    store.close
    @store = nil
    store[0.5].should == -12
  end

  it 'persists values' do
    store[-0.3] = -12
    store.close
    @store = nil
    store[-0.3].should == -12
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = 41
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == 41
  end

  it 'persists values' do
    store[99] = 41
    store.close
    @store = nil
    store[99].should == 41
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = -12
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == -12
  end

  it 'persists values' do
    store[99] = -12
    store.close
    @store = nil
    store[99].should == -12
  end
end

#################### null_numberkey_numbervalue ####################

shared_examples_for 'null_numberkey_numbervalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = 123.456
    store[-0.3] = -98.7
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = 123.456
    store[0.5] = -98.7
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = -98.7
    store[-0.3] = 123.456
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = -98.7
    store[0.5] = 123.456
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = 340282366920938463463374607431768211456
    store[-0.3] = 33
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = 340282366920938463463374607431768211456
    store[0.5] = 33
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = 33
    store[-0.3] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = 33
    store[0.5] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = 123.456
    store[99] = -98.7
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = 123.456
    store[170141183460469231731687303715884105728] = -98.7
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = -98.7
    store[99] = 123.456
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = -98.7
    store[170141183460469231731687303715884105728] = 123.456
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[99] = 33
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728] = 33
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = 33
    store[99] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = 33
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, 33, options).should == 33
  end
end

#################### store_numberkey_numbervalue ####################

shared_examples_for 'store_numberkey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = 123.456
    store[0.5].should == 123.456
    store.load(0.5).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = 123.456
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(0.5, value).should equal(value)
    store[0.5].should == 123.456
    store.load(0.5).should == 123.456
  end

  it 'stores values after clear' do
    store[0.5] = 123.456
    store[-0.3] = -98.7
    store.clear.should equal(store)
    store[0.5] = 123.456
    store[0.5].should == 123.456
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = 123.456
    store.delete(0.5).should == 123.456
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = 123.456
    store[0.5].should == 123.456
    store[0.5] = -98.7
    store[0.5].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == 123.456
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = 123.456
    store[0.5].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = 123.456
    store.fetch(0.5, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = 123.456
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = 123.456
    store[-0.3].should == 123.456
    store.load(-0.3).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = 123.456
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == 123.456
    store.load(-0.3).should == 123.456
  end

  it 'stores values after clear' do
    store[-0.3] = 123.456
    store[0.5] = -98.7
    store.clear.should equal(store)
    store[-0.3] = 123.456
    store[-0.3].should == 123.456
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = 123.456
    store.delete(-0.3).should == 123.456
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = 123.456
    store[-0.3].should == 123.456
    store[-0.3] = -98.7
    store[-0.3].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == 123.456
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = 123.456
    store[-0.3].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = 123.456
    store.fetch(-0.3, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = 123.456
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = -98.7
    store[0.5].should == -98.7
    store.load(0.5).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = -98.7
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(0.5, value).should equal(value)
    store[0.5].should == -98.7
    store.load(0.5).should == -98.7
  end

  it 'stores values after clear' do
    store[0.5] = -98.7
    store[-0.3] = 123.456
    store.clear.should equal(store)
    store[0.5] = -98.7
    store[0.5].should == -98.7
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = -98.7
    store.delete(0.5).should == -98.7
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = -98.7
    store[0.5].should == -98.7
    store[0.5] = 123.456
    store[0.5].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == -98.7
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = -98.7
    store[0.5].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = -98.7
    store.fetch(0.5, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = -98.7
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = -98.7
    store[-0.3].should == -98.7
    store.load(-0.3).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = -98.7
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == -98.7
    store.load(-0.3).should == -98.7
  end

  it 'stores values after clear' do
    store[-0.3] = -98.7
    store[0.5] = 123.456
    store.clear.should equal(store)
    store[-0.3] = -98.7
    store[-0.3].should == -98.7
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = -98.7
    store.delete(-0.3).should == -98.7
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = -98.7
    store[-0.3].should == -98.7
    store[-0.3] = 123.456
    store[-0.3].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == -98.7
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = -98.7
    store[-0.3].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = -98.7
    store.fetch(-0.3, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = -98.7
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = 340282366920938463463374607431768211456
    store[0.5].should == 340282366920938463463374607431768211456
    store.load(0.5).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = 340282366920938463463374607431768211456
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(0.5, value).should equal(value)
    store[0.5].should == 340282366920938463463374607431768211456
    store.load(0.5).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[0.5] = 340282366920938463463374607431768211456
    store[-0.3] = 33
    store.clear.should equal(store)
    store[0.5] = 340282366920938463463374607431768211456
    store[0.5].should == 340282366920938463463374607431768211456
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = 340282366920938463463374607431768211456
    store.delete(0.5).should == 340282366920938463463374607431768211456
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = 340282366920938463463374607431768211456
    store[0.5].should == 340282366920938463463374607431768211456
    store[0.5] = 33
    store[0.5].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = 340282366920938463463374607431768211456
    store[0.5].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = 340282366920938463463374607431768211456
    store.fetch(0.5, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = 340282366920938463463374607431768211456
    store[-0.3].should == 340282366920938463463374607431768211456
    store.load(-0.3).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = 340282366920938463463374607431768211456
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == 340282366920938463463374607431768211456
    store.load(-0.3).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[-0.3] = 340282366920938463463374607431768211456
    store[0.5] = 33
    store.clear.should equal(store)
    store[-0.3] = 340282366920938463463374607431768211456
    store[-0.3].should == 340282366920938463463374607431768211456
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = 340282366920938463463374607431768211456
    store.delete(-0.3).should == 340282366920938463463374607431768211456
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = 340282366920938463463374607431768211456
    store[-0.3].should == 340282366920938463463374607431768211456
    store[-0.3] = 33
    store[-0.3].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = 340282366920938463463374607431768211456
    store[-0.3].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = 340282366920938463463374607431768211456
    store.fetch(-0.3, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = 33
    store[0.5].should == 33
    store.load(0.5).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = 33
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(0.5, value).should equal(value)
    store[0.5].should == 33
    store.load(0.5).should == 33
  end

  it 'stores values after clear' do
    store[0.5] = 33
    store[-0.3] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[0.5] = 33
    store[0.5].should == 33
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = 33
    store.delete(0.5).should == 33
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = 33
    store[0.5].should == 33
    store[0.5] = 340282366920938463463374607431768211456
    store[0.5].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == 33
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = 33
    store[0.5].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = 33
    store.fetch(0.5, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = 33
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = 33
    store[-0.3].should == 33
    store.load(-0.3).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = 33
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == 33
    store.load(-0.3).should == 33
  end

  it 'stores values after clear' do
    store[-0.3] = 33
    store[0.5] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[-0.3] = 33
    store[-0.3].should == 33
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = 33
    store.delete(-0.3).should == 33
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = 33
    store[-0.3].should == 33
    store[-0.3] = 340282366920938463463374607431768211456
    store[-0.3].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == 33
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = 33
    store[-0.3].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = 33
    store.fetch(-0.3, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = 33
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = 123.456
    store[170141183460469231731687303715884105728].should == 123.456
    store.load(170141183460469231731687303715884105728).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = 123.456
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == 123.456
    store.load(170141183460469231731687303715884105728).should == 123.456
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = 123.456
    store[99] = -98.7
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = 123.456
    store[170141183460469231731687303715884105728].should == 123.456
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = 123.456
    store.delete(170141183460469231731687303715884105728).should == 123.456
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = 123.456
    store[170141183460469231731687303715884105728].should == 123.456
    store[170141183460469231731687303715884105728] = -98.7
    store[170141183460469231731687303715884105728].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == 123.456
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = 123.456
    store[170141183460469231731687303715884105728].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = 123.456
    store.fetch(170141183460469231731687303715884105728, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = 123.456
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = 123.456
    store[99].should == 123.456
    store.load(99).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[99] = 123.456
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(99, value).should equal(value)
    store[99].should == 123.456
    store.load(99).should == 123.456
  end

  it 'stores values after clear' do
    store[99] = 123.456
    store[170141183460469231731687303715884105728] = -98.7
    store.clear.should equal(store)
    store[99] = 123.456
    store[99].should == 123.456
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = 123.456
    store.delete(99).should == 123.456
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = 123.456
    store[99].should == 123.456
    store[99] = -98.7
    store[99].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[99] = value).should equal(value)
    store[99].should == 123.456
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = 123.456
    store[99].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = 123.456
    store.fetch(99, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = 123.456
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = -98.7
    store[170141183460469231731687303715884105728].should == -98.7
    store.load(170141183460469231731687303715884105728).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = -98.7
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == -98.7
    store.load(170141183460469231731687303715884105728).should == -98.7
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = -98.7
    store[99] = 123.456
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = -98.7
    store[170141183460469231731687303715884105728].should == -98.7
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = -98.7
    store.delete(170141183460469231731687303715884105728).should == -98.7
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = -98.7
    store[170141183460469231731687303715884105728].should == -98.7
    store[170141183460469231731687303715884105728] = 123.456
    store[170141183460469231731687303715884105728].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == -98.7
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = -98.7
    store[170141183460469231731687303715884105728].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = -98.7
    store.fetch(170141183460469231731687303715884105728, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = -98.7
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = -98.7
    store[99].should == -98.7
    store.load(99).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[99] = -98.7
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(99, value).should equal(value)
    store[99].should == -98.7
    store.load(99).should == -98.7
  end

  it 'stores values after clear' do
    store[99] = -98.7
    store[170141183460469231731687303715884105728] = 123.456
    store.clear.should equal(store)
    store[99] = -98.7
    store[99].should == -98.7
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = -98.7
    store.delete(99).should == -98.7
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = -98.7
    store[99].should == -98.7
    store[99] = 123.456
    store[99].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[99] = value).should equal(value)
    store[99].should == -98.7
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = -98.7
    store[99].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = -98.7
    store.fetch(99, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = -98.7
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
    store.load(170141183460469231731687303715884105728).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
    store.load(170141183460469231731687303715884105728).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[99] = 33
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.delete(170141183460469231731687303715884105728).should == 340282366920938463463374607431768211456
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728] = 33
    store[170141183460469231731687303715884105728].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.fetch(170141183460469231731687303715884105728, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = 340282366920938463463374607431768211456
    store[99].should == 340282366920938463463374607431768211456
    store.load(99).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[99] = 340282366920938463463374607431768211456
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(99, value).should equal(value)
    store[99].should == 340282366920938463463374607431768211456
    store.load(99).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[99] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728] = 33
    store.clear.should equal(store)
    store[99] = 340282366920938463463374607431768211456
    store[99].should == 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = 340282366920938463463374607431768211456
    store.delete(99).should == 340282366920938463463374607431768211456
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = 340282366920938463463374607431768211456
    store[99].should == 340282366920938463463374607431768211456
    store[99] = 33
    store[99].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[99] = value).should equal(value)
    store[99].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = 340282366920938463463374607431768211456
    store[99].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = 340282366920938463463374607431768211456
    store.fetch(99, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = 33
    store[170141183460469231731687303715884105728].should == 33
    store.load(170141183460469231731687303715884105728).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = 33
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == 33
    store.load(170141183460469231731687303715884105728).should == 33
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = 33
    store[99] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = 33
    store[170141183460469231731687303715884105728].should == 33
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = 33
    store.delete(170141183460469231731687303715884105728).should == 33
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = 33
    store[170141183460469231731687303715884105728].should == 33
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == 33
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = 33
    store[170141183460469231731687303715884105728].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = 33
    store.fetch(170141183460469231731687303715884105728, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = 33
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = 33
    store[99].should == 33
    store.load(99).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[99] = 33
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(99, value).should equal(value)
    store[99].should == 33
    store.load(99).should == 33
  end

  it 'stores values after clear' do
    store[99] = 33
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[99] = 33
    store[99].should == 33
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = 33
    store.delete(99).should == 33
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = 33
    store[99].should == 33
    store[99] = 340282366920938463463374607431768211456
    store[99].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[99] = value).should equal(value)
    store[99].should == 33
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = 33
    store[99].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = 33
    store.fetch(99, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = 33
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_numberkey_numbervalue ####################

shared_examples_for 'persist_numberkey_numbervalue' do
  it 'persists values' do
    store[0.5] = 123.456
    store.close
    @store = nil
    store[0.5].should == 123.456
  end

  it 'persists values' do
    store[-0.3] = 123.456
    store.close
    @store = nil
    store[-0.3].should == 123.456
  end

  it 'persists values' do
    store[0.5] = -98.7
    store.close
    @store = nil
    store[0.5].should == -98.7
  end

  it 'persists values' do
    store[-0.3] = -98.7
    store.close
    @store = nil
    store[-0.3].should == -98.7
  end

  it 'persists values' do
    store[0.5] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[0.5].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[-0.3] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[-0.3].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[0.5] = 33
    store.close
    @store = nil
    store[0.5].should == 33
  end

  it 'persists values' do
    store[-0.3] = 33
    store.close
    @store = nil
    store[-0.3].should == 33
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = 123.456
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == 123.456
  end

  it 'persists values' do
    store[99] = 123.456
    store.close
    @store = nil
    store[99].should == 123.456
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = -98.7
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == -98.7
  end

  it 'persists values' do
    store[99] = -98.7
    store.close
    @store = nil
    store[99].should == -98.7
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[99] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[99].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = 33
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == 33
  end

  it 'persists values' do
    store[99] = 33
    store.close
    @store = nil
    store[99].should == 33
  end
end

#################### null_numberkey_booleanvalue ####################

shared_examples_for 'null_numberkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = true
    store[-0.3] = false
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = true
    store[0.5] = false
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = false
    store[-0.3] = true
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = false
    store[0.5] = true
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = true
    store[99] = false
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = true
    store[170141183460469231731687303715884105728] = false
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = false
    store[99] = true
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = false
    store[170141183460469231731687303715884105728] = true
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, false, options).should == false
  end
end

#################### store_numberkey_booleanvalue ####################

shared_examples_for 'store_numberkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = true
    store[0.5].should == true
    store.load(0.5).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = true
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(0.5, value).should equal(value)
    store[0.5].should == true
    store.load(0.5).should == true
  end

  it 'stores values after clear' do
    store[0.5] = true
    store[-0.3] = false
    store.clear.should equal(store)
    store[0.5] = true
    store[0.5].should == true
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = true
    store.delete(0.5).should == true
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = true
    store[0.5].should == true
    store[0.5] = false
    store[0.5].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == true
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = true
    store[0.5].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = true
    store.fetch(0.5, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = true
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = true
    store[-0.3].should == true
    store.load(-0.3).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = true
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == true
    store.load(-0.3).should == true
  end

  it 'stores values after clear' do
    store[-0.3] = true
    store[0.5] = false
    store.clear.should equal(store)
    store[-0.3] = true
    store[-0.3].should == true
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = true
    store.delete(-0.3).should == true
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = true
    store[-0.3].should == true
    store[-0.3] = false
    store[-0.3].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == true
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = true
    store[-0.3].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = true
    store.fetch(-0.3, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = true
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = false
    store[0.5].should == false
    store.load(0.5).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = false
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(0.5, value).should equal(value)
    store[0.5].should == false
    store.load(0.5).should == false
  end

  it 'stores values after clear' do
    store[0.5] = false
    store[-0.3] = true
    store.clear.should equal(store)
    store[0.5] = false
    store[0.5].should == false
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = false
    store.delete(0.5).should == false
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = false
    store[0.5].should == false
    store[0.5] = true
    store[0.5].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == false
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = false
    store[0.5].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = false
    store.fetch(0.5, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = false
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = false
    store[-0.3].should == false
    store.load(-0.3).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = false
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == false
    store.load(-0.3).should == false
  end

  it 'stores values after clear' do
    store[-0.3] = false
    store[0.5] = true
    store.clear.should equal(store)
    store[-0.3] = false
    store[-0.3].should == false
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = false
    store.delete(-0.3).should == false
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = false
    store[-0.3].should == false
    store[-0.3] = true
    store[-0.3].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == false
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = false
    store[-0.3].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = false
    store.fetch(-0.3, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = false
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = true
    store[170141183460469231731687303715884105728].should == true
    store.load(170141183460469231731687303715884105728).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = true
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == true
    store.load(170141183460469231731687303715884105728).should == true
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = true
    store[99] = false
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = true
    store[170141183460469231731687303715884105728].should == true
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = true
    store.delete(170141183460469231731687303715884105728).should == true
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = true
    store[170141183460469231731687303715884105728].should == true
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == true
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = true
    store[170141183460469231731687303715884105728].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = true
    store.fetch(170141183460469231731687303715884105728, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = true
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = true
    store[99].should == true
    store.load(99).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[99] = true
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(99, value).should equal(value)
    store[99].should == true
    store.load(99).should == true
  end

  it 'stores values after clear' do
    store[99] = true
    store[170141183460469231731687303715884105728] = false
    store.clear.should equal(store)
    store[99] = true
    store[99].should == true
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = true
    store.delete(99).should == true
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = true
    store[99].should == true
    store[99] = false
    store[99].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[99] = value).should equal(value)
    store[99].should == true
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = true
    store[99].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = true
    store.fetch(99, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = true
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store.load(170141183460469231731687303715884105728).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = false
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == false
    store.load(170141183460469231731687303715884105728).should == false
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = false
    store[99] = true
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = false
    store.delete(170141183460469231731687303715884105728).should == false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = false
    store[170141183460469231731687303715884105728].should == false
    store[170141183460469231731687303715884105728] = true
    store[170141183460469231731687303715884105728].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == false
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = false
    store[170141183460469231731687303715884105728].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = false
    store.fetch(170141183460469231731687303715884105728, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = false
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = false
    store[99].should == false
    store.load(99).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[99] = false
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(99, value).should equal(value)
    store[99].should == false
    store.load(99).should == false
  end

  it 'stores values after clear' do
    store[99] = false
    store[170141183460469231731687303715884105728] = true
    store.clear.should equal(store)
    store[99] = false
    store[99].should == false
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = false
    store.delete(99).should == false
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = false
    store[99].should == false
    store[99] = true
    store[99].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[99] = value).should equal(value)
    store[99].should == false
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = false
    store[99].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = false
    store.fetch(99, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = false
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_numberkey_booleanvalue ####################

shared_examples_for 'persist_numberkey_booleanvalue' do
  it 'persists values' do
    store[0.5] = true
    store.close
    @store = nil
    store[0.5].should == true
  end

  it 'persists values' do
    store[-0.3] = true
    store.close
    @store = nil
    store[-0.3].should == true
  end

  it 'persists values' do
    store[0.5] = false
    store.close
    @store = nil
    store[0.5].should == false
  end

  it 'persists values' do
    store[-0.3] = false
    store.close
    @store = nil
    store[-0.3].should == false
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = true
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == true
  end

  it 'persists values' do
    store[99] = true
    store.close
    @store = nil
    store[99].should == true
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = false
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == false
  end

  it 'persists values' do
    store[99] = false
    store.close
    @store = nil
    store[99].should == false
  end
end

#################### null_numberkey_stringvalue ####################

shared_examples_for 'null_numberkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = "strval1"
    store[-0.3] = "strval2"
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = "strval1"
    store[0.5] = "strval2"
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = "strval2"
    store[-0.3] = "strval1"
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = "strval2"
    store[0.5] = "strval1"
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = "strval1"
    store[99] = "strval2"
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = "strval1"
    store[170141183460469231731687303715884105728] = "strval2"
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = "strval2"
    store[99] = "strval1"
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = "strval2"
    store[170141183460469231731687303715884105728] = "strval1"
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, "strval2", options).should == "strval2"
  end
end

#################### store_numberkey_stringvalue ####################

shared_examples_for 'store_numberkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = "strval1"
    store[0.5].should == "strval1"
    store.load(0.5).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = "strval1"
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(0.5, value).should equal(value)
    store[0.5].should == "strval1"
    store.load(0.5).should == "strval1"
  end

  it 'stores values after clear' do
    store[0.5] = "strval1"
    store[-0.3] = "strval2"
    store.clear.should equal(store)
    store[0.5] = "strval1"
    store[0.5].should == "strval1"
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = "strval1"
    store.delete(0.5).should == "strval1"
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = "strval1"
    store[0.5].should == "strval1"
    store[0.5] = "strval2"
    store[0.5].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == "strval1"
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = "strval1"
    store[0.5].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = "strval1"
    store.fetch(0.5, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = "strval1"
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = "strval1"
    store[-0.3].should == "strval1"
    store.load(-0.3).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = "strval1"
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == "strval1"
    store.load(-0.3).should == "strval1"
  end

  it 'stores values after clear' do
    store[-0.3] = "strval1"
    store[0.5] = "strval2"
    store.clear.should equal(store)
    store[-0.3] = "strval1"
    store[-0.3].should == "strval1"
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = "strval1"
    store.delete(-0.3).should == "strval1"
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = "strval1"
    store[-0.3].should == "strval1"
    store[-0.3] = "strval2"
    store[-0.3].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == "strval1"
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = "strval1"
    store[-0.3].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = "strval1"
    store.fetch(-0.3, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = "strval1"
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = "strval2"
    store[0.5].should == "strval2"
    store.load(0.5).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = "strval2"
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(0.5, value).should equal(value)
    store[0.5].should == "strval2"
    store.load(0.5).should == "strval2"
  end

  it 'stores values after clear' do
    store[0.5] = "strval2"
    store[-0.3] = "strval1"
    store.clear.should equal(store)
    store[0.5] = "strval2"
    store[0.5].should == "strval2"
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = "strval2"
    store.delete(0.5).should == "strval2"
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = "strval2"
    store[0.5].should == "strval2"
    store[0.5] = "strval1"
    store[0.5].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == "strval2"
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = "strval2"
    store[0.5].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = "strval2"
    store.fetch(0.5, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = "strval2"
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = "strval2"
    store[-0.3].should == "strval2"
    store.load(-0.3).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = "strval2"
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == "strval2"
    store.load(-0.3).should == "strval2"
  end

  it 'stores values after clear' do
    store[-0.3] = "strval2"
    store[0.5] = "strval1"
    store.clear.should equal(store)
    store[-0.3] = "strval2"
    store[-0.3].should == "strval2"
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = "strval2"
    store.delete(-0.3).should == "strval2"
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = "strval2"
    store[-0.3].should == "strval2"
    store[-0.3] = "strval1"
    store[-0.3].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == "strval2"
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = "strval2"
    store[-0.3].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = "strval2"
    store.fetch(-0.3, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = "strval2"
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = "strval1"
    store[170141183460469231731687303715884105728].should == "strval1"
    store.load(170141183460469231731687303715884105728).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = "strval1"
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == "strval1"
    store.load(170141183460469231731687303715884105728).should == "strval1"
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = "strval1"
    store[99] = "strval2"
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = "strval1"
    store[170141183460469231731687303715884105728].should == "strval1"
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = "strval1"
    store.delete(170141183460469231731687303715884105728).should == "strval1"
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = "strval1"
    store[170141183460469231731687303715884105728].should == "strval1"
    store[170141183460469231731687303715884105728] = "strval2"
    store[170141183460469231731687303715884105728].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == "strval1"
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = "strval1"
    store[170141183460469231731687303715884105728].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = "strval1"
    store.fetch(170141183460469231731687303715884105728, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = "strval1"
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = "strval1"
    store[99].should == "strval1"
    store.load(99).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[99] = "strval1"
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(99, value).should equal(value)
    store[99].should == "strval1"
    store.load(99).should == "strval1"
  end

  it 'stores values after clear' do
    store[99] = "strval1"
    store[170141183460469231731687303715884105728] = "strval2"
    store.clear.should equal(store)
    store[99] = "strval1"
    store[99].should == "strval1"
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = "strval1"
    store.delete(99).should == "strval1"
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = "strval1"
    store[99].should == "strval1"
    store[99] = "strval2"
    store[99].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[99] = value).should equal(value)
    store[99].should == "strval1"
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = "strval1"
    store[99].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = "strval1"
    store.fetch(99, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = "strval1"
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = "strval2"
    store[170141183460469231731687303715884105728].should == "strval2"
    store.load(170141183460469231731687303715884105728).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = "strval2"
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == "strval2"
    store.load(170141183460469231731687303715884105728).should == "strval2"
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = "strval2"
    store[99] = "strval1"
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = "strval2"
    store[170141183460469231731687303715884105728].should == "strval2"
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = "strval2"
    store.delete(170141183460469231731687303715884105728).should == "strval2"
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = "strval2"
    store[170141183460469231731687303715884105728].should == "strval2"
    store[170141183460469231731687303715884105728] = "strval1"
    store[170141183460469231731687303715884105728].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == "strval2"
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = "strval2"
    store[170141183460469231731687303715884105728].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = "strval2"
    store.fetch(170141183460469231731687303715884105728, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = "strval2"
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = "strval2"
    store[99].should == "strval2"
    store.load(99).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[99] = "strval2"
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(99, value).should equal(value)
    store[99].should == "strval2"
    store.load(99).should == "strval2"
  end

  it 'stores values after clear' do
    store[99] = "strval2"
    store[170141183460469231731687303715884105728] = "strval1"
    store.clear.should equal(store)
    store[99] = "strval2"
    store[99].should == "strval2"
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = "strval2"
    store.delete(99).should == "strval2"
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = "strval2"
    store[99].should == "strval2"
    store[99] = "strval1"
    store[99].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[99] = value).should equal(value)
    store[99].should == "strval2"
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = "strval2"
    store[99].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = "strval2"
    store.fetch(99, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = "strval2"
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_numberkey_stringvalue ####################

shared_examples_for 'returndifferent_numberkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[99] = value
    store[99].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[99] = value
    store[99].should_not be_equal(value)
  end
end

#################### returnsame_numberkey_stringvalue ####################

shared_examples_for 'returnsame_numberkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[99] = value
    store[99].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[99] = value
    store[99].should be_equal(value)
  end
end

#################### persist_numberkey_stringvalue ####################

shared_examples_for 'persist_numberkey_stringvalue' do
  it 'persists values' do
    store[0.5] = "strval1"
    store.close
    @store = nil
    store[0.5].should == "strval1"
  end

  it 'persists values' do
    store[-0.3] = "strval1"
    store.close
    @store = nil
    store[-0.3].should == "strval1"
  end

  it 'persists values' do
    store[0.5] = "strval2"
    store.close
    @store = nil
    store[0.5].should == "strval2"
  end

  it 'persists values' do
    store[-0.3] = "strval2"
    store.close
    @store = nil
    store[-0.3].should == "strval2"
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = "strval1"
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == "strval1"
  end

  it 'persists values' do
    store[99] = "strval1"
    store.close
    @store = nil
    store[99].should == "strval1"
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = "strval2"
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == "strval2"
  end

  it 'persists values' do
    store[99] = "strval2"
    store.close
    @store = nil
    store[99].should == "strval2"
  end
end

#################### null_numberkey_binaryvalue ####################

shared_examples_for 'null_numberkey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = "über"
    store[-0.3] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = "über"
    store[0.5] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = "\xAA\xBB\xCC"
    store[-0.3] = "über"
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = "\xAA\xBB\xCC"
    store[0.5] = "über"
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = "über"
    store[99] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = "über"
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[99] = "über"
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728] = "über"
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end
end

#################### store_numberkey_binaryvalue ####################

shared_examples_for 'store_numberkey_binaryvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = "über"
    store[0.5].should == "über"
    store.load(0.5).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = "über"
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(0.5, value).should equal(value)
    store[0.5].should == "über"
    store.load(0.5).should == "über"
  end

  it 'stores values after clear' do
    store[0.5] = "über"
    store[-0.3] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[0.5] = "über"
    store[0.5].should == "über"
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = "über"
    store.delete(0.5).should == "über"
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = "über"
    store[0.5].should == "über"
    store[0.5] = "\xAA\xBB\xCC"
    store[0.5].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == "über"
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = "über"
    store[0.5].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = "über"
    store.fetch(0.5, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = "über"
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = "über"
    store[-0.3].should == "über"
    store.load(-0.3).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = "über"
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == "über"
    store.load(-0.3).should == "über"
  end

  it 'stores values after clear' do
    store[-0.3] = "über"
    store[0.5] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[-0.3] = "über"
    store[-0.3].should == "über"
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = "über"
    store.delete(-0.3).should == "über"
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = "über"
    store[-0.3].should == "über"
    store[-0.3] = "\xAA\xBB\xCC"
    store[-0.3].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == "über"
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = "über"
    store[-0.3].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = "über"
    store.fetch(-0.3, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = "über"
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = "\xAA\xBB\xCC"
    store[0.5].should == "\xAA\xBB\xCC"
    store.load(0.5).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = "\xAA\xBB\xCC"
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(0.5, value).should equal(value)
    store[0.5].should == "\xAA\xBB\xCC"
    store.load(0.5).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[0.5] = "\xAA\xBB\xCC"
    store[-0.3] = "über"
    store.clear.should equal(store)
    store[0.5] = "\xAA\xBB\xCC"
    store[0.5].should == "\xAA\xBB\xCC"
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = "\xAA\xBB\xCC"
    store.delete(0.5).should == "\xAA\xBB\xCC"
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = "\xAA\xBB\xCC"
    store[0.5].should == "\xAA\xBB\xCC"
    store[0.5] = "über"
    store[0.5].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = "\xAA\xBB\xCC"
    store[0.5].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = "\xAA\xBB\xCC"
    store.fetch(0.5, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = "\xAA\xBB\xCC"
    store[-0.3].should == "\xAA\xBB\xCC"
    store.load(-0.3).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = "\xAA\xBB\xCC"
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == "\xAA\xBB\xCC"
    store.load(-0.3).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[-0.3] = "\xAA\xBB\xCC"
    store[0.5] = "über"
    store.clear.should equal(store)
    store[-0.3] = "\xAA\xBB\xCC"
    store[-0.3].should == "\xAA\xBB\xCC"
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = "\xAA\xBB\xCC"
    store.delete(-0.3).should == "\xAA\xBB\xCC"
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = "\xAA\xBB\xCC"
    store[-0.3].should == "\xAA\xBB\xCC"
    store[-0.3] = "über"
    store[-0.3].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = "\xAA\xBB\xCC"
    store[-0.3].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = "\xAA\xBB\xCC"
    store.fetch(-0.3, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = "über"
    store[170141183460469231731687303715884105728].should == "über"
    store.load(170141183460469231731687303715884105728).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = "über"
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == "über"
    store.load(170141183460469231731687303715884105728).should == "über"
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = "über"
    store[99] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = "über"
    store[170141183460469231731687303715884105728].should == "über"
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = "über"
    store.delete(170141183460469231731687303715884105728).should == "über"
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = "über"
    store[170141183460469231731687303715884105728].should == "über"
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == "über"
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = "über"
    store[170141183460469231731687303715884105728].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = "über"
    store.fetch(170141183460469231731687303715884105728, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = "über"
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = "über"
    store[99].should == "über"
    store.load(99).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[99] = "über"
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(99, value).should equal(value)
    store[99].should == "über"
    store.load(99).should == "über"
  end

  it 'stores values after clear' do
    store[99] = "über"
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[99] = "über"
    store[99].should == "über"
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = "über"
    store.delete(99).should == "über"
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = "über"
    store[99].should == "über"
    store[99] = "\xAA\xBB\xCC"
    store[99].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[99] = value).should equal(value)
    store[99].should == "über"
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = "über"
    store[99].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = "über"
    store.fetch(99, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = "über"
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
    store.load(170141183460469231731687303715884105728).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
    store.load(170141183460469231731687303715884105728).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[99] = "über"
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.delete(170141183460469231731687303715884105728).should == "\xAA\xBB\xCC"
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728] = "über"
    store[170141183460469231731687303715884105728].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.fetch(170141183460469231731687303715884105728, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = "\xAA\xBB\xCC"
    store[99].should == "\xAA\xBB\xCC"
    store.load(99).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[99] = "\xAA\xBB\xCC"
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(99, value).should equal(value)
    store[99].should == "\xAA\xBB\xCC"
    store.load(99).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[99] = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728] = "über"
    store.clear.should equal(store)
    store[99] = "\xAA\xBB\xCC"
    store[99].should == "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = "\xAA\xBB\xCC"
    store.delete(99).should == "\xAA\xBB\xCC"
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = "\xAA\xBB\xCC"
    store[99].should == "\xAA\xBB\xCC"
    store[99] = "über"
    store[99].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[99] = value).should equal(value)
    store[99].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = "\xAA\xBB\xCC"
    store[99].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = "\xAA\xBB\xCC"
    store.fetch(99, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_numberkey_binaryvalue ####################

shared_examples_for 'returndifferent_numberkey_binaryvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[99] = value
    store[99].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[99] = value
    store[99].should_not be_equal(value)
  end
end

#################### returnsame_numberkey_binaryvalue ####################

shared_examples_for 'returnsame_numberkey_binaryvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[99] = value
    store[99].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[99] = value
    store[99].should be_equal(value)
  end
end

#################### persist_numberkey_binaryvalue ####################

shared_examples_for 'persist_numberkey_binaryvalue' do
  it 'persists values' do
    store[0.5] = "über"
    store.close
    @store = nil
    store[0.5].should == "über"
  end

  it 'persists values' do
    store[-0.3] = "über"
    store.close
    @store = nil
    store[-0.3].should == "über"
  end

  it 'persists values' do
    store[0.5] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[0.5].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[-0.3] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[-0.3].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = "über"
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == "über"
  end

  it 'persists values' do
    store[99] = "über"
    store.close
    @store = nil
    store[99].should == "über"
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[99] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[99].should == "\xAA\xBB\xCC"
  end
end

#################### null_numberkey_hashvalue ####################

shared_examples_for 'null_numberkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_numberkey_hashvalue ####################

shared_examples_for 'store_numberkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[0.5].should == {"hashval1"=>["array1", 1]}
    store.load(0.5).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(0.5, value).should equal(value)
    store[0.5].should == {"hashval1"=>["array1", 1]}
    store.load(0.5).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[0.5].should == {"hashval1"=>["array1", 1]}
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.delete(0.5).should == {"hashval1"=>["array1", 1]}
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[0.5].should == {"hashval1"=>["array1", 1]}
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[0.5].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.fetch(0.5, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[-0.3].should == {"hashval1"=>["array1", 1]}
    store.load(-0.3).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == {"hashval1"=>["array1", 1]}
    store.load(-0.3).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[-0.3].should == {"hashval1"=>["array1", 1]}
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.delete(-0.3).should == {"hashval1"=>["array1", 1]}
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[-0.3].should == {"hashval1"=>["array1", 1]}
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[-0.3].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.fetch(-0.3, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0.5).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(0.5, value).should equal(value)
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(0.5).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(0.5).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5] = {"hashval1"=>["array1", 1]}
    store[0.5].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(0.5, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-0.3).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(-0.3).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(-0.3).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store[-0.3].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(-0.3, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
    store.load(170141183460469231731687303715884105728).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
    store.load(170141183460469231731687303715884105728).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.delete(170141183460469231731687303715884105728).should == {"hashval1"=>["array1", 1]}
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.fetch(170141183460469231731687303715884105728, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = {"hashval1"=>["array1", 1]}
    store[99].should == {"hashval1"=>["array1", 1]}
    store.load(99).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[99] = {"hashval1"=>["array1", 1]}
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(99, value).should equal(value)
    store[99].should == {"hashval1"=>["array1", 1]}
    store.load(99).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[99] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[99] = {"hashval1"=>["array1", 1]}
    store[99].should == {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = {"hashval1"=>["array1", 1]}
    store.delete(99).should == {"hashval1"=>["array1", 1]}
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = {"hashval1"=>["array1", 1]}
    store[99].should == {"hashval1"=>["array1", 1]}
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[99] = value).should equal(value)
    store[99].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[99].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = {"hashval1"=>["array1", 1]}
    store.fetch(99, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(170141183460469231731687303715884105728).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(170141183460469231731687303715884105728).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(170141183460469231731687303715884105728).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(170141183460469231731687303715884105728, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(99).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(99, value).should equal(value)
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(99).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(99).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99] = {"hashval1"=>["array1", 1]}
    store[99].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[99] = value).should equal(value)
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(99, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_numberkey_hashvalue ####################

shared_examples_for 'returndifferent_numberkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[99] = value
    store[99].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99] = value
    store[99].should_not be_equal(value)
  end
end

#################### returnsame_numberkey_hashvalue ####################

shared_examples_for 'returnsame_numberkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[99] = value
    store[99].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[99] = value
    store[99].should be_equal(value)
  end
end

#################### persist_numberkey_hashvalue ####################

shared_examples_for 'persist_numberkey_hashvalue' do
  it 'persists values' do
    store[0.5] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[0.5].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[-0.3] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[-0.3].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[0.5] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[0.5].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[-0.3] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[-0.3].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[99] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[99].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[99] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[99].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_numberkey_objectvalue ####################

shared_examples_for 'null_numberkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = Value.new(:objval1)
    store[-0.3] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = Value.new(:objval1)
    store[0.5] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[0.5].should be_nil
    store.load(0.5).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[0.5] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(0.5).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(0.5).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[0.5] = Value.new(:objval2)
    store[-0.3] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(0.5).should be_false
    store.key?(-0.3).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(0.5, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 0.5
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(0.5, options).should be_false
    store.load(0.5, options).should be_nil
    store.fetch(0.5, 42, options).should == 42
    store.fetch(0.5, options) { 42 }.should == 42
    store.delete(0.5, options).should be_nil
    store.clear(options).should equal(store)
    store.store(0.5, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[-0.3].should be_nil
    store.load(-0.3).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[-0.3] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(-0.3).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(-0.3).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[-0.3] = Value.new(:objval2)
    store[0.5] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(-0.3).should be_false
    store.key?(0.5).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(-0.3, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = -0.3
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(-0.3, options).should be_false
    store.load(-0.3, options).should be_nil
    store.fetch(-0.3, 42, options).should == 42
    store.fetch(-0.3, options) { 42 }.should == 42
    store.delete(-0.3, options).should be_nil
    store.clear(options).should equal(store)
    store.store(-0.3, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[99] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = Value.new(:objval1)
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[170141183460469231731687303715884105728].should be_nil
    store.load(170141183460469231731687303715884105728).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[170141183460469231731687303715884105728] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(170141183460469231731687303715884105728).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[99] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(170141183460469231731687303715884105728).should be_false
    store.key?(99).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(170141183460469231731687303715884105728, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 170141183460469231731687303715884105728
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(170141183460469231731687303715884105728, options).should be_false
    store.load(170141183460469231731687303715884105728, options).should be_nil
    store.fetch(170141183460469231731687303715884105728, 42, options).should == 42
    store.fetch(170141183460469231731687303715884105728, options) { 42 }.should == 42
    store.delete(170141183460469231731687303715884105728, options).should be_nil
    store.clear(options).should equal(store)
    store.store(170141183460469231731687303715884105728, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[99].should be_nil
    store.load(99).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[99] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(99).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(99).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[99] = Value.new(:objval2)
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(99).should be_false
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(99, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = 99
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(99, options).should be_false
    store.load(99, options).should be_nil
    store.fetch(99, 42, options).should == 42
    store.fetch(99, options) { 42 }.should == 42
    store.delete(99, options).should be_nil
    store.clear(options).should equal(store)
    store.store(99, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_numberkey_objectvalue ####################

shared_examples_for 'store_numberkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[0.5] = Value.new(:objval1)
    store[0.5].should == Value.new(:objval1)
    store.load(0.5).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = Value.new(:objval1)
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(0.5, value).should equal(value)
    store[0.5].should == Value.new(:objval1)
    store.load(0.5).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[0.5] = Value.new(:objval1)
    store[-0.3] = Value.new(:objval2)
    store.clear.should equal(store)
    store[0.5] = Value.new(:objval1)
    store[0.5].should == Value.new(:objval1)
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = Value.new(:objval1)
    store.delete(0.5).should == Value.new(:objval1)
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = Value.new(:objval1)
    store[0.5].should == Value.new(:objval1)
    store[0.5] = Value.new(:objval2)
    store[0.5].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = Value.new(:objval1)
    store[0.5].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = Value.new(:objval1)
    store.fetch(0.5, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = Value.new(:objval1)
    store[-0.3].should == Value.new(:objval1)
    store.load(-0.3).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = Value.new(:objval1)
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == Value.new(:objval1)
    store.load(-0.3).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[-0.3] = Value.new(:objval1)
    store[0.5] = Value.new(:objval2)
    store.clear.should equal(store)
    store[-0.3] = Value.new(:objval1)
    store[-0.3].should == Value.new(:objval1)
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = Value.new(:objval1)
    store.delete(-0.3).should == Value.new(:objval1)
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = Value.new(:objval1)
    store[-0.3].should == Value.new(:objval1)
    store[-0.3] = Value.new(:objval2)
    store[-0.3].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = Value.new(:objval1)
    store[-0.3].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = Value.new(:objval1)
    store.fetch(-0.3, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[0.5] = Value.new(:objval2)
    store[0.5].should == Value.new(:objval2)
    store.load(0.5).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[0.5] = Value.new(:objval2)
    store.key?(0.5).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(0.5, value).should equal(value)
    store[0.5].should == Value.new(:objval2)
    store.load(0.5).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[0.5] = Value.new(:objval2)
    store[-0.3] = Value.new(:objval1)
    store.clear.should equal(store)
    store[0.5] = Value.new(:objval2)
    store[0.5].should == Value.new(:objval2)
    store[-0.3].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[0.5] = Value.new(:objval2)
    store.delete(0.5).should == Value.new(:objval2)
    store.key?(0.5).should be_false
  end

  it 'overwrites existing values' do
    store[0.5] = Value.new(:objval2)
    store[0.5].should == Value.new(:objval2)
    store[0.5] = Value.new(:objval1)
    store[0.5].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[0.5] = value).should equal(value)
    store[0.5].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = 0.5.freeze
    store[key] = Value.new(:objval2)
    store[0.5].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[0.5] = Value.new(:objval2)
    store.fetch(0.5, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[0.5] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(0.5) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[-0.3] = Value.new(:objval2)
    store[-0.3].should == Value.new(:objval2)
    store.load(-0.3).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[-0.3] = Value.new(:objval2)
    store.key?(-0.3).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(-0.3, value).should equal(value)
    store[-0.3].should == Value.new(:objval2)
    store.load(-0.3).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[-0.3] = Value.new(:objval2)
    store[0.5] = Value.new(:objval1)
    store.clear.should equal(store)
    store[-0.3] = Value.new(:objval2)
    store[-0.3].should == Value.new(:objval2)
    store[0.5].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[-0.3] = Value.new(:objval2)
    store.delete(-0.3).should == Value.new(:objval2)
    store.key?(-0.3).should be_false
  end

  it 'overwrites existing values' do
    store[-0.3] = Value.new(:objval2)
    store[-0.3].should == Value.new(:objval2)
    store[-0.3] = Value.new(:objval1)
    store[-0.3].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[-0.3] = value).should equal(value)
    store[-0.3].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = -0.3.freeze
    store[key] = Value.new(:objval2)
    store[-0.3].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[-0.3] = Value.new(:objval2)
    store.fetch(-0.3, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[-0.3] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(-0.3) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
    store.load(170141183460469231731687303715884105728).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
    store.load(170141183460469231731687303715884105728).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[99] = Value.new(:objval2)
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.delete(170141183460469231731687303715884105728).should == Value.new(:objval1)
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = Value.new(:objval1)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.fetch(170141183460469231731687303715884105728, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = Value.new(:objval1)
    store[99].should == Value.new(:objval1)
    store.load(99).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[99] = Value.new(:objval1)
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(99, value).should equal(value)
    store[99].should == Value.new(:objval1)
    store.load(99).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[99] = Value.new(:objval1)
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.clear.should equal(store)
    store[99] = Value.new(:objval1)
    store[99].should == Value.new(:objval1)
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = Value.new(:objval1)
    store.delete(99).should == Value.new(:objval1)
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = Value.new(:objval1)
    store[99].should == Value.new(:objval1)
    store[99] = Value.new(:objval2)
    store[99].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[99] = value).should equal(value)
    store[99].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = Value.new(:objval1)
    store[99].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = Value.new(:objval1)
    store.fetch(99, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
    store.load(170141183460469231731687303715884105728).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.key?(170141183460469231731687303715884105728).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(170141183460469231731687303715884105728, value).should equal(value)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
    store.load(170141183460469231731687303715884105728).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[99] = Value.new(:objval1)
    store.clear.should equal(store)
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
    store[99].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.delete(170141183460469231731687303715884105728).should == Value.new(:objval2)
    store.key?(170141183460469231731687303715884105728).should be_false
  end

  it 'overwrites existing values' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[170141183460469231731687303715884105728] = value).should equal(value)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = 170141183460469231731687303715884105728.freeze
    store[key] = Value.new(:objval2)
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.fetch(170141183460469231731687303715884105728, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(170141183460469231731687303715884105728) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[99] = Value.new(:objval2)
    store[99].should == Value.new(:objval2)
    store.load(99).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[99] = Value.new(:objval2)
    store.key?(99).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(99, value).should equal(value)
    store[99].should == Value.new(:objval2)
    store.load(99).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[99] = Value.new(:objval2)
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.clear.should equal(store)
    store[99] = Value.new(:objval2)
    store[99].should == Value.new(:objval2)
    store[170141183460469231731687303715884105728].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[99] = Value.new(:objval2)
    store.delete(99).should == Value.new(:objval2)
    store.key?(99).should be_false
  end

  it 'overwrites existing values' do
    store[99] = Value.new(:objval2)
    store[99].should == Value.new(:objval2)
    store[99] = Value.new(:objval1)
    store[99].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[99] = value).should equal(value)
    store[99].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = 99.freeze
    store[key] = Value.new(:objval2)
    store[99].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[99] = Value.new(:objval2)
    store.fetch(99, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[99] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(99) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_numberkey_objectvalue ####################

shared_examples_for 'returndifferent_numberkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[0.5] = value
    store[0.5].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[-0.3] = value
    store[-0.3].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[99] = value
    store[99].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[99] = value
    store[99].should_not be_equal(value)
  end
end

#################### returnsame_numberkey_objectvalue ####################

shared_examples_for 'returnsame_numberkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[0.5] = value
    store[0.5].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[-0.3] = value
    store[-0.3].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[99] = value
    store[99].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[170141183460469231731687303715884105728] = value
    store[170141183460469231731687303715884105728].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[99] = value
    store[99].should be_equal(value)
  end
end

#################### persist_numberkey_objectvalue ####################

shared_examples_for 'persist_numberkey_objectvalue' do
  it 'persists values' do
    store[0.5] = Value.new(:objval1)
    store.close
    @store = nil
    store[0.5].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[-0.3] = Value.new(:objval1)
    store.close
    @store = nil
    store[-0.3].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[0.5] = Value.new(:objval2)
    store.close
    @store = nil
    store[0.5].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[-0.3] = Value.new(:objval2)
    store.close
    @store = nil
    store[-0.3].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = Value.new(:objval1)
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[99] = Value.new(:objval1)
    store.close
    @store = nil
    store[99].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[170141183460469231731687303715884105728] = Value.new(:objval2)
    store.close
    @store = nil
    store[170141183460469231731687303715884105728].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[99] = Value.new(:objval2)
    store.close
    @store = nil
    store[99].should == Value.new(:objval2)
  end
end

#################### null_booleankey_nilvalue ####################

shared_examples_for 'null_booleankey_nilvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = ''
    store[false] = nil
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = ''
    store[true] = nil
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = nil
    store[false] = ''
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = nil
    store[true] = ''
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 0
    store[false] = false
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 0
    store[true] = false
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = false
    store[false] = 0
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = false
    store[true] = 0
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, false, options).should == false
  end
end

#################### store_booleankey_nilvalue ####################

shared_examples_for 'store_booleankey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = ''
    store[true].should == ''
    store.load(true).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[true] = ''
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(true, value).should equal(value)
    store[true].should == ''
    store.load(true).should == ''
  end

  it 'stores values after clear' do
    store[true] = ''
    store[false] = nil
    store.clear.should equal(store)
    store[true] = ''
    store[true].should == ''
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = ''
    store.delete(true).should == ''
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = ''
    store[true].should == ''
    store[true] = nil
    store[true].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[true] = value).should equal(value)
    store[true].should == ''
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = ''
    store[true].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[false] = ''
    store[false].should == ''
    store.load(false).should == ''
  end

  it 'returns true from #key? if a key is available' do
    store[false] = ''
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store(false, value).should equal(value)
    store[false].should == ''
    store.load(false).should == ''
  end

  it 'stores values after clear' do
    store[false] = ''
    store[true] = nil
    store.clear.should equal(store)
    store[false] = ''
    store[false].should == ''
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = ''
    store.delete(false).should == ''
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = ''
    store[false].should == ''
    store[false] = nil
    store[false].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store[false] = value).should equal(value)
    store[false].should == ''
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = ''
    store[false].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store[true] = nil
    store[true].should == nil
    store.load(true).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[true] = nil
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(true, value).should equal(value)
    store[true].should == nil
    store.load(true).should == nil
  end

  it 'stores values after clear' do
    store[true] = nil
    store[false] = ''
    store.clear.should equal(store)
    store[true] = nil
    store[true].should == nil
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = nil
    store.delete(true).should == nil
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = nil
    store[true].should == nil
    store[true] = ''
    store[true].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[true] = value).should equal(value)
    store[true].should == nil
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = nil
    store[true].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[false] = nil
    store[false].should == nil
    store.load(false).should == nil
  end

  it 'returns true from #key? if a key is available' do
    store[false] = nil
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store(false, value).should equal(value)
    store[false].should == nil
    store.load(false).should == nil
  end

  it 'stores values after clear' do
    store[false] = nil
    store[true] = ''
    store.clear.should equal(store)
    store[false] = nil
    store[false].should == nil
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = nil
    store.delete(false).should == nil
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = nil
    store[false].should == nil
    store[false] = ''
    store[false].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store[false] = value).should equal(value)
    store[false].should == nil
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = nil
    store[false].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store[true] = 0
    store[true].should == 0
    store.load(true).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[true] = 0
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(true, value).should equal(value)
    store[true].should == 0
    store.load(true).should == 0
  end

  it 'stores values after clear' do
    store[true] = 0
    store[false] = false
    store.clear.should equal(store)
    store[true] = 0
    store[true].should == 0
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 0
    store.delete(true).should == 0
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 0
    store[true].should == 0
    store[true] = false
    store[true].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[true] = value).should equal(value)
    store[true].should == 0
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = 0
    store[true].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 0
    store[false].should == 0
    store.load(false).should == 0
  end

  it 'returns true from #key? if a key is available' do
    store[false] = 0
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store(false, value).should equal(value)
    store[false].should == 0
    store.load(false).should == 0
  end

  it 'stores values after clear' do
    store[false] = 0
    store[true] = false
    store.clear.should equal(store)
    store[false] = 0
    store[false].should == 0
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 0
    store.delete(false).should == 0
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 0
    store[false].should == 0
    store[false] = false
    store[false].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store[false] = value).should equal(value)
    store[false].should == 0
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = 0
    store[false].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store[true] = false
    store[true].should == false
    store.load(true).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[true] = false
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(true, value).should equal(value)
    store[true].should == false
    store.load(true).should == false
  end

  it 'stores values after clear' do
    store[true] = false
    store[false] = 0
    store.clear.should equal(store)
    store[true] = false
    store[true].should == false
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = false
    store.delete(true).should == false
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = false
    store[true].should == false
    store[true] = 0
    store[true].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[true] = value).should equal(value)
    store[true].should == false
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = false
    store[true].should == false
  end

  it 'writes values to keys that like a Hash' do
    store[false] = false
    store[false].should == false
    store.load(false).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[false] = false
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(false, value).should equal(value)
    store[false].should == false
    store.load(false).should == false
  end

  it 'stores values after clear' do
    store[false] = false
    store[true] = 0
    store.clear.should equal(store)
    store[false] = false
    store[false].should == false
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = false
    store.delete(false).should == false
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = false
    store[false].should == false
    store[false] = 0
    store[false].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[false] = value).should equal(value)
    store[false].should == false
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = false
    store[false].should == false
  end
end

#################### persist_booleankey_nilvalue ####################

shared_examples_for 'persist_booleankey_nilvalue' do
  it 'persists values' do
    store[true] = ''
    store.close
    @store = nil
    store[true].should == ''
  end

  it 'persists values' do
    store[false] = ''
    store.close
    @store = nil
    store[false].should == ''
  end

  it 'persists values' do
    store[true] = nil
    store.close
    @store = nil
    store[true].should == nil
  end

  it 'persists values' do
    store[false] = nil
    store.close
    @store = nil
    store[false].should == nil
  end

  it 'persists values' do
    store[true] = 0
    store.close
    @store = nil
    store[true].should == 0
  end

  it 'persists values' do
    store[false] = 0
    store.close
    @store = nil
    store[false].should == 0
  end

  it 'persists values' do
    store[true] = false
    store.close
    @store = nil
    store[true].should == false
  end

  it 'persists values' do
    store[false] = false
    store.close
    @store = nil
    store[false].should == false
  end
end

#################### null_booleankey_integervalue ####################

shared_examples_for 'null_booleankey_integervalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 41
    store[false] = -12
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 41
    store[true] = -12
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = -12
    store[false] = 41
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = -12
    store[true] = 41
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, -12, options).should == -12
  end
end

#################### store_booleankey_integervalue ####################

shared_examples_for 'store_booleankey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = 41
    store[true].should == 41
    store.load(true).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[true] = 41
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(true, value).should equal(value)
    store[true].should == 41
    store.load(true).should == 41
  end

  it 'stores values after clear' do
    store[true] = 41
    store[false] = -12
    store.clear.should equal(store)
    store[true] = 41
    store[true].should == 41
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 41
    store.delete(true).should == 41
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 41
    store[true].should == 41
    store[true] = -12
    store[true].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[true] = value).should equal(value)
    store[true].should == 41
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = 41
    store[true].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = 41
    store.fetch(true, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = 41
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 41
    store[false].should == 41
    store.load(false).should == 41
  end

  it 'returns true from #key? if a key is available' do
    store[false] = 41
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store(false, value).should equal(value)
    store[false].should == 41
    store.load(false).should == 41
  end

  it 'stores values after clear' do
    store[false] = 41
    store[true] = -12
    store.clear.should equal(store)
    store[false] = 41
    store[false].should == 41
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 41
    store.delete(false).should == 41
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 41
    store[false].should == 41
    store[false] = -12
    store[false].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store[false] = value).should equal(value)
    store[false].should == 41
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = 41
    store[false].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = 41
    store.fetch(false, -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = 41
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = -12
    store[true].should == -12
    store.load(true).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[true] = -12
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(true, value).should equal(value)
    store[true].should == -12
    store.load(true).should == -12
  end

  it 'stores values after clear' do
    store[true] = -12
    store[false] = 41
    store.clear.should equal(store)
    store[true] = -12
    store[true].should == -12
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = -12
    store.delete(true).should == -12
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = -12
    store[true].should == -12
    store[true] = 41
    store[true].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[true] = value).should equal(value)
    store[true].should == -12
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = -12
    store[true].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = -12
    store.fetch(true, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = -12
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = -12
    store[false].should == -12
    store.load(false).should == -12
  end

  it 'returns true from #key? if a key is available' do
    store[false] = -12
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store(false, value).should equal(value)
    store[false].should == -12
    store.load(false).should == -12
  end

  it 'stores values after clear' do
    store[false] = -12
    store[true] = 41
    store.clear.should equal(store)
    store[false] = -12
    store[false].should == -12
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = -12
    store.delete(false).should == -12
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = -12
    store[false].should == -12
    store[false] = 41
    store[false].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store[false] = value).should equal(value)
    store[false].should == -12
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = -12
    store[false].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = -12
    store.fetch(false, 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = -12
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_booleankey_integervalue ####################

shared_examples_for 'persist_booleankey_integervalue' do
  it 'persists values' do
    store[true] = 41
    store.close
    @store = nil
    store[true].should == 41
  end

  it 'persists values' do
    store[false] = 41
    store.close
    @store = nil
    store[false].should == 41
  end

  it 'persists values' do
    store[true] = -12
    store.close
    @store = nil
    store[true].should == -12
  end

  it 'persists values' do
    store[false] = -12
    store.close
    @store = nil
    store[false].should == -12
  end
end

#################### null_booleankey_numbervalue ####################

shared_examples_for 'null_booleankey_numbervalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 123.456
    store[false] = -98.7
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 123.456
    store[true] = -98.7
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = -98.7
    store[false] = 123.456
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = -98.7
    store[true] = 123.456
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 340282366920938463463374607431768211456
    store[false] = 33
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 340282366920938463463374607431768211456
    store[true] = 33
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = 33
    store[false] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = 33
    store[true] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, 33, options).should == 33
  end
end

#################### store_booleankey_numbervalue ####################

shared_examples_for 'store_booleankey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = 123.456
    store[true].should == 123.456
    store.load(true).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[true] = 123.456
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(true, value).should equal(value)
    store[true].should == 123.456
    store.load(true).should == 123.456
  end

  it 'stores values after clear' do
    store[true] = 123.456
    store[false] = -98.7
    store.clear.should equal(store)
    store[true] = 123.456
    store[true].should == 123.456
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 123.456
    store.delete(true).should == 123.456
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 123.456
    store[true].should == 123.456
    store[true] = -98.7
    store[true].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[true] = value).should equal(value)
    store[true].should == 123.456
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = 123.456
    store[true].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = 123.456
    store.fetch(true, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = 123.456
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 123.456
    store[false].should == 123.456
    store.load(false).should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store[false] = 123.456
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store(false, value).should equal(value)
    store[false].should == 123.456
    store.load(false).should == 123.456
  end

  it 'stores values after clear' do
    store[false] = 123.456
    store[true] = -98.7
    store.clear.should equal(store)
    store[false] = 123.456
    store[false].should == 123.456
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 123.456
    store.delete(false).should == 123.456
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 123.456
    store[false].should == 123.456
    store[false] = -98.7
    store[false].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store[false] = value).should equal(value)
    store[false].should == 123.456
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = 123.456
    store[false].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = 123.456
    store.fetch(false, -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = 123.456
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = -98.7
    store[true].should == -98.7
    store.load(true).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[true] = -98.7
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(true, value).should equal(value)
    store[true].should == -98.7
    store.load(true).should == -98.7
  end

  it 'stores values after clear' do
    store[true] = -98.7
    store[false] = 123.456
    store.clear.should equal(store)
    store[true] = -98.7
    store[true].should == -98.7
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = -98.7
    store.delete(true).should == -98.7
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = -98.7
    store[true].should == -98.7
    store[true] = 123.456
    store[true].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[true] = value).should equal(value)
    store[true].should == -98.7
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = -98.7
    store[true].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = -98.7
    store.fetch(true, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = -98.7
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = -98.7
    store[false].should == -98.7
    store.load(false).should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store[false] = -98.7
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store(false, value).should equal(value)
    store[false].should == -98.7
    store.load(false).should == -98.7
  end

  it 'stores values after clear' do
    store[false] = -98.7
    store[true] = 123.456
    store.clear.should equal(store)
    store[false] = -98.7
    store[false].should == -98.7
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = -98.7
    store.delete(false).should == -98.7
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = -98.7
    store[false].should == -98.7
    store[false] = 123.456
    store[false].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store[false] = value).should equal(value)
    store[false].should == -98.7
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = -98.7
    store[false].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = -98.7
    store.fetch(false, 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = -98.7
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = 340282366920938463463374607431768211456
    store[true].should == 340282366920938463463374607431768211456
    store.load(true).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[true] = 340282366920938463463374607431768211456
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(true, value).should equal(value)
    store[true].should == 340282366920938463463374607431768211456
    store.load(true).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[true] = 340282366920938463463374607431768211456
    store[false] = 33
    store.clear.should equal(store)
    store[true] = 340282366920938463463374607431768211456
    store[true].should == 340282366920938463463374607431768211456
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 340282366920938463463374607431768211456
    store.delete(true).should == 340282366920938463463374607431768211456
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 340282366920938463463374607431768211456
    store[true].should == 340282366920938463463374607431768211456
    store[true] = 33
    store[true].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[true] = value).should equal(value)
    store[true].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = 340282366920938463463374607431768211456
    store[true].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = 340282366920938463463374607431768211456
    store.fetch(true, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 340282366920938463463374607431768211456
    store[false].should == 340282366920938463463374607431768211456
    store.load(false).should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store[false] = 340282366920938463463374607431768211456
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store(false, value).should equal(value)
    store[false].should == 340282366920938463463374607431768211456
    store.load(false).should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store[false] = 340282366920938463463374607431768211456
    store[true] = 33
    store.clear.should equal(store)
    store[false] = 340282366920938463463374607431768211456
    store[false].should == 340282366920938463463374607431768211456
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 340282366920938463463374607431768211456
    store.delete(false).should == 340282366920938463463374607431768211456
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 340282366920938463463374607431768211456
    store[false].should == 340282366920938463463374607431768211456
    store[false] = 33
    store[false].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store[false] = value).should equal(value)
    store[false].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = 340282366920938463463374607431768211456
    store[false].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = 340282366920938463463374607431768211456
    store.fetch(false, 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = 33
    store[true].should == 33
    store.load(true).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[true] = 33
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(true, value).should equal(value)
    store[true].should == 33
    store.load(true).should == 33
  end

  it 'stores values after clear' do
    store[true] = 33
    store[false] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[true] = 33
    store[true].should == 33
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = 33
    store.delete(true).should == 33
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = 33
    store[true].should == 33
    store[true] = 340282366920938463463374607431768211456
    store[true].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[true] = value).should equal(value)
    store[true].should == 33
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = 33
    store[true].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = 33
    store.fetch(true, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = 33
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = 33
    store[false].should == 33
    store.load(false).should == 33
  end

  it 'returns true from #key? if a key is available' do
    store[false] = 33
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store(false, value).should equal(value)
    store[false].should == 33
    store.load(false).should == 33
  end

  it 'stores values after clear' do
    store[false] = 33
    store[true] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store[false] = 33
    store[false].should == 33
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = 33
    store.delete(false).should == 33
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = 33
    store[false].should == 33
    store[false] = 340282366920938463463374607431768211456
    store[false].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store[false] = value).should equal(value)
    store[false].should == 33
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = 33
    store[false].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = 33
    store.fetch(false, 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = 33
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_booleankey_numbervalue ####################

shared_examples_for 'persist_booleankey_numbervalue' do
  it 'persists values' do
    store[true] = 123.456
    store.close
    @store = nil
    store[true].should == 123.456
  end

  it 'persists values' do
    store[false] = 123.456
    store.close
    @store = nil
    store[false].should == 123.456
  end

  it 'persists values' do
    store[true] = -98.7
    store.close
    @store = nil
    store[true].should == -98.7
  end

  it 'persists values' do
    store[false] = -98.7
    store.close
    @store = nil
    store[false].should == -98.7
  end

  it 'persists values' do
    store[true] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[true].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[false] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store[false].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store[true] = 33
    store.close
    @store = nil
    store[true].should == 33
  end

  it 'persists values' do
    store[false] = 33
    store.close
    @store = nil
    store[false].should == 33
  end
end

#################### null_booleankey_booleanvalue ####################

shared_examples_for 'null_booleankey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = true
    store[false] = false
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = true
    store[true] = false
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = false
    store[false] = true
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = false
    store[true] = true
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, false, options).should == false
  end
end

#################### store_booleankey_booleanvalue ####################

shared_examples_for 'store_booleankey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = true
    store[true].should == true
    store.load(true).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[true] = true
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(true, value).should equal(value)
    store[true].should == true
    store.load(true).should == true
  end

  it 'stores values after clear' do
    store[true] = true
    store[false] = false
    store.clear.should equal(store)
    store[true] = true
    store[true].should == true
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = true
    store.delete(true).should == true
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = true
    store[true].should == true
    store[true] = false
    store[true].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[true] = value).should equal(value)
    store[true].should == true
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = true
    store[true].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = true
    store.fetch(true, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = true
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = true
    store[false].should == true
    store.load(false).should == true
  end

  it 'returns true from #key? if a key is available' do
    store[false] = true
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store(false, value).should equal(value)
    store[false].should == true
    store.load(false).should == true
  end

  it 'stores values after clear' do
    store[false] = true
    store[true] = false
    store.clear.should equal(store)
    store[false] = true
    store[false].should == true
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = true
    store.delete(false).should == true
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = true
    store[false].should == true
    store[false] = false
    store[false].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store[false] = value).should equal(value)
    store[false].should == true
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = true
    store[false].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = true
    store.fetch(false, false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = true
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = false
    store[true].should == false
    store.load(true).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[true] = false
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(true, value).should equal(value)
    store[true].should == false
    store.load(true).should == false
  end

  it 'stores values after clear' do
    store[true] = false
    store[false] = true
    store.clear.should equal(store)
    store[true] = false
    store[true].should == false
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = false
    store.delete(true).should == false
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = false
    store[true].should == false
    store[true] = true
    store[true].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[true] = value).should equal(value)
    store[true].should == false
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = false
    store[true].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = false
    store.fetch(true, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = false
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = false
    store[false].should == false
    store.load(false).should == false
  end

  it 'returns true from #key? if a key is available' do
    store[false] = false
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store(false, value).should equal(value)
    store[false].should == false
    store.load(false).should == false
  end

  it 'stores values after clear' do
    store[false] = false
    store[true] = true
    store.clear.should equal(store)
    store[false] = false
    store[false].should == false
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = false
    store.delete(false).should == false
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = false
    store[false].should == false
    store[false] = true
    store[false].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store[false] = value).should equal(value)
    store[false].should == false
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = false
    store[false].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = false
    store.fetch(false, true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = false
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_booleankey_booleanvalue ####################

shared_examples_for 'persist_booleankey_booleanvalue' do
  it 'persists values' do
    store[true] = true
    store.close
    @store = nil
    store[true].should == true
  end

  it 'persists values' do
    store[false] = true
    store.close
    @store = nil
    store[false].should == true
  end

  it 'persists values' do
    store[true] = false
    store.close
    @store = nil
    store[true].should == false
  end

  it 'persists values' do
    store[false] = false
    store.close
    @store = nil
    store[false].should == false
  end
end

#################### null_booleankey_stringvalue ####################

shared_examples_for 'null_booleankey_stringvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "strval1"
    store[false] = "strval2"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "strval1"
    store[true] = "strval2"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "strval2"
    store[false] = "strval1"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "strval2"
    store[true] = "strval1"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "strval2", options).should == "strval2"
  end
end

#################### store_booleankey_stringvalue ####################

shared_examples_for 'store_booleankey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = "strval1"
    store[true].should == "strval1"
    store.load(true).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[true] = "strval1"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(true, value).should equal(value)
    store[true].should == "strval1"
    store.load(true).should == "strval1"
  end

  it 'stores values after clear' do
    store[true] = "strval1"
    store[false] = "strval2"
    store.clear.should equal(store)
    store[true] = "strval1"
    store[true].should == "strval1"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "strval1"
    store.delete(true).should == "strval1"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "strval1"
    store[true].should == "strval1"
    store[true] = "strval2"
    store[true].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[true] = value).should equal(value)
    store[true].should == "strval1"
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = "strval1"
    store[true].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "strval1"
    store.fetch(true, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "strval1"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "strval1"
    store[false].should == "strval1"
    store.load(false).should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store[false] = "strval1"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store(false, value).should equal(value)
    store[false].should == "strval1"
    store.load(false).should == "strval1"
  end

  it 'stores values after clear' do
    store[false] = "strval1"
    store[true] = "strval2"
    store.clear.should equal(store)
    store[false] = "strval1"
    store[false].should == "strval1"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "strval1"
    store.delete(false).should == "strval1"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "strval1"
    store[false].should == "strval1"
    store[false] = "strval2"
    store[false].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store[false] = value).should equal(value)
    store[false].should == "strval1"
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = "strval1"
    store[false].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "strval1"
    store.fetch(false, "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "strval1"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = "strval2"
    store[true].should == "strval2"
    store.load(true).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[true] = "strval2"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(true, value).should equal(value)
    store[true].should == "strval2"
    store.load(true).should == "strval2"
  end

  it 'stores values after clear' do
    store[true] = "strval2"
    store[false] = "strval1"
    store.clear.should equal(store)
    store[true] = "strval2"
    store[true].should == "strval2"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "strval2"
    store.delete(true).should == "strval2"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "strval2"
    store[true].should == "strval2"
    store[true] = "strval1"
    store[true].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[true] = value).should equal(value)
    store[true].should == "strval2"
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = "strval2"
    store[true].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "strval2"
    store.fetch(true, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "strval2"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "strval2"
    store[false].should == "strval2"
    store.load(false).should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store[false] = "strval2"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store(false, value).should equal(value)
    store[false].should == "strval2"
    store.load(false).should == "strval2"
  end

  it 'stores values after clear' do
    store[false] = "strval2"
    store[true] = "strval1"
    store.clear.should equal(store)
    store[false] = "strval2"
    store[false].should == "strval2"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "strval2"
    store.delete(false).should == "strval2"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "strval2"
    store[false].should == "strval2"
    store[false] = "strval1"
    store[false].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store[false] = value).should equal(value)
    store[false].should == "strval2"
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = "strval2"
    store[false].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "strval2"
    store.fetch(false, "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "strval2"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_stringvalue ####################

shared_examples_for 'returndifferent_booleankey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_stringvalue ####################

shared_examples_for 'returnsame_booleankey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_stringvalue ####################

shared_examples_for 'persist_booleankey_stringvalue' do
  it 'persists values' do
    store[true] = "strval1"
    store.close
    @store = nil
    store[true].should == "strval1"
  end

  it 'persists values' do
    store[false] = "strval1"
    store.close
    @store = nil
    store[false].should == "strval1"
  end

  it 'persists values' do
    store[true] = "strval2"
    store.close
    @store = nil
    store[true].should == "strval2"
  end

  it 'persists values' do
    store[false] = "strval2"
    store.close
    @store = nil
    store[false].should == "strval2"
  end
end

#################### null_booleankey_binaryvalue ####################

shared_examples_for 'null_booleankey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "über"
    store[false] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "über"
    store[true] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = "\xAA\xBB\xCC"
    store[false] = "über"
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = "\xAA\xBB\xCC"
    store[true] = "über"
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end
end

#################### store_booleankey_binaryvalue ####################

shared_examples_for 'store_booleankey_binaryvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = "über"
    store[true].should == "über"
    store.load(true).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[true] = "über"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(true, value).should equal(value)
    store[true].should == "über"
    store.load(true).should == "über"
  end

  it 'stores values after clear' do
    store[true] = "über"
    store[false] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[true] = "über"
    store[true].should == "über"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "über"
    store.delete(true).should == "über"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "über"
    store[true].should == "über"
    store[true] = "\xAA\xBB\xCC"
    store[true].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[true] = value).should equal(value)
    store[true].should == "über"
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = "über"
    store[true].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "über"
    store.fetch(true, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "über"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "über"
    store[false].should == "über"
    store.load(false).should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store[false] = "über"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store(false, value).should equal(value)
    store[false].should == "über"
    store.load(false).should == "über"
  end

  it 'stores values after clear' do
    store[false] = "über"
    store[true] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store[false] = "über"
    store[false].should == "über"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "über"
    store.delete(false).should == "über"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "über"
    store[false].should == "über"
    store[false] = "\xAA\xBB\xCC"
    store[false].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store[false] = value).should equal(value)
    store[false].should == "über"
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = "über"
    store[false].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "über"
    store.fetch(false, "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "über"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = "\xAA\xBB\xCC"
    store[true].should == "\xAA\xBB\xCC"
    store.load(true).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[true] = "\xAA\xBB\xCC"
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(true, value).should equal(value)
    store[true].should == "\xAA\xBB\xCC"
    store.load(true).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[true] = "\xAA\xBB\xCC"
    store[false] = "über"
    store.clear.should equal(store)
    store[true] = "\xAA\xBB\xCC"
    store[true].should == "\xAA\xBB\xCC"
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = "\xAA\xBB\xCC"
    store.delete(true).should == "\xAA\xBB\xCC"
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = "\xAA\xBB\xCC"
    store[true].should == "\xAA\xBB\xCC"
    store[true] = "über"
    store[true].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[true] = value).should equal(value)
    store[true].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = "\xAA\xBB\xCC"
    store[true].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = "\xAA\xBB\xCC"
    store.fetch(true, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = "\xAA\xBB\xCC"
    store[false].should == "\xAA\xBB\xCC"
    store.load(false).should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store[false] = "\xAA\xBB\xCC"
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store(false, value).should equal(value)
    store[false].should == "\xAA\xBB\xCC"
    store.load(false).should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store[false] = "\xAA\xBB\xCC"
    store[true] = "über"
    store.clear.should equal(store)
    store[false] = "\xAA\xBB\xCC"
    store[false].should == "\xAA\xBB\xCC"
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = "\xAA\xBB\xCC"
    store.delete(false).should == "\xAA\xBB\xCC"
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = "\xAA\xBB\xCC"
    store[false].should == "\xAA\xBB\xCC"
    store[false] = "über"
    store[false].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store[false] = value).should equal(value)
    store[false].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = "\xAA\xBB\xCC"
    store[false].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = "\xAA\xBB\xCC"
    store.fetch(false, "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_binaryvalue ####################

shared_examples_for 'returndifferent_booleankey_binaryvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_binaryvalue ####################

shared_examples_for 'returnsame_booleankey_binaryvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_binaryvalue ####################

shared_examples_for 'persist_booleankey_binaryvalue' do
  it 'persists values' do
    store[true] = "über"
    store.close
    @store = nil
    store[true].should == "über"
  end

  it 'persists values' do
    store[false] = "über"
    store.close
    @store = nil
    store[false].should == "über"
  end

  it 'persists values' do
    store[true] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[true].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store[false] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store[false].should == "\xAA\xBB\xCC"
  end
end

#################### null_booleankey_hashvalue ####################

shared_examples_for 'null_booleankey_hashvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_booleankey_hashvalue ####################

shared_examples_for 'store_booleankey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store.load(true).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(true, value).should equal(value)
    store[true].should == {"hashval1"=>["array1", 1]}
    store.load(true).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.delete(true).should == {"hashval1"=>["array1", 1]}
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[true] = value).should equal(value)
    store[true].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.fetch(true, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store.load(false).should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store(false, value).should equal(value)
    store[false].should == {"hashval1"=>["array1", 1]}
    store.load(false).should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.delete(false).should == {"hashval1"=>["array1", 1]}
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store[false] = value).should equal(value)
    store[false].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.fetch(false, {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(true, value).should equal(value)
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(true).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store[true].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[true] = value).should equal(value)
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(true, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store(false, value).should equal(value)
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete(false).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = {"hashval1"=>["array1", 1]}
    store[false].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store[false] = value).should equal(value)
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(false, {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_hashvalue ####################

shared_examples_for 'returndifferent_booleankey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_hashvalue ####################

shared_examples_for 'returnsame_booleankey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_hashvalue ####################

shared_examples_for 'persist_booleankey_hashvalue' do
  it 'persists values' do
    store[true] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[true].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[false] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store[false].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store[true] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[true].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store[false] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store[false].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_booleankey_objectvalue ####################

shared_examples_for 'null_booleankey_objectvalue' do
  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store[true].should be_nil
    store.load(true).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[true] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(true).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(true).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[true] = Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(true).should be_false
    store.key?(false).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(true, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = true
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(true, options).should be_false
    store.load(true, options).should be_nil
    store.fetch(true, 42, options).should == 42
    store.fetch(true, options) { 42 }.should == 42
    store.delete(true, options).should be_nil
    store.clear(options).should equal(store)
    store.store(true, Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store[false].should be_nil
    store.load(false).should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store[false] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?(false).should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete(false).should be_nil
  end

  it 'removes all keys from the store with clear' do
    store[false] = Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?(false).should be_false
    store.key?(true).should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch(false, Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = false
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?(false, options).should be_false
    store.load(false, options).should be_nil
    store.fetch(false, 42, options).should == 42
    store.fetch(false, options) { 42 }.should == 42
    store.delete(false, options).should be_nil
    store.clear(options).should equal(store)
    store.store(false, Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_booleankey_objectvalue ####################

shared_examples_for 'store_booleankey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store.load(true).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[true] = Value.new(:objval1)
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(true, value).should equal(value)
    store[true].should == Value.new(:objval1)
    store.load(true).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[true] = Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store.clear.should equal(store)
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = Value.new(:objval1)
    store.delete(true).should == Value.new(:objval1)
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[true] = value).should equal(value)
    store[true].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = Value.new(:objval1)
    store.fetch(true, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store.load(false).should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store[false] = Value.new(:objval1)
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store(false, value).should equal(value)
    store[false].should == Value.new(:objval1)
    store.load(false).should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store[false] = Value.new(:objval1)
    store[true] = Value.new(:objval2)
    store.clear.should equal(store)
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = Value.new(:objval1)
    store.delete(false).should == Value.new(:objval1)
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store[false] = value).should equal(value)
    store[false].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = Value.new(:objval1)
    store.fetch(false, Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store.load(true).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[true] = Value.new(:objval2)
    store.key?(true).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(true, value).should equal(value)
    store[true].should == Value.new(:objval2)
    store.load(true).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[true] = Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store.clear.should equal(store)
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store[false].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[true] = Value.new(:objval2)
    store.delete(true).should == Value.new(:objval2)
    store.key?(true).should be_false
  end

  it 'overwrites existing values' do
    store[true] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store[true].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[true] = value).should equal(value)
    store[true].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = true.freeze
    store[key] = Value.new(:objval2)
    store[true].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[true] = Value.new(:objval2)
    store.fetch(true, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[true] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(true) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store.load(false).should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store[false] = Value.new(:objval2)
    store.key?(false).should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store(false, value).should equal(value)
    store[false].should == Value.new(:objval2)
    store.load(false).should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store[false] = Value.new(:objval2)
    store[true] = Value.new(:objval1)
    store.clear.should equal(store)
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store[true].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store[false] = Value.new(:objval2)
    store.delete(false).should == Value.new(:objval2)
    store.key?(false).should be_false
  end

  it 'overwrites existing values' do
    store[false] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
    store[false] = Value.new(:objval1)
    store[false].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store[false] = value).should equal(value)
    store[false].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = false.freeze
    store[key] = Value.new(:objval2)
    store[false].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store[false] = Value.new(:objval2)
    store.fetch(false, Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store[false] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch(false) { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_booleankey_objectvalue ####################

shared_examples_for 'returndifferent_booleankey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store[false] = value
    store[false].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[true] = value
    store[true].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store[false] = value
    store[false].should_not be_equal(value)
  end
end

#################### returnsame_booleankey_objectvalue ####################

shared_examples_for 'returnsame_booleankey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store[false] = value
    store[false].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[true] = value
    store[true].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store[false] = value
    store[false].should be_equal(value)
  end
end

#################### persist_booleankey_objectvalue ####################

shared_examples_for 'persist_booleankey_objectvalue' do
  it 'persists values' do
    store[true] = Value.new(:objval1)
    store.close
    @store = nil
    store[true].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[false] = Value.new(:objval1)
    store.close
    @store = nil
    store[false].should == Value.new(:objval1)
  end

  it 'persists values' do
    store[true] = Value.new(:objval2)
    store.close
    @store = nil
    store[true].should == Value.new(:objval2)
  end

  it 'persists values' do
    store[false] = Value.new(:objval2)
    store.close
    @store = nil
    store[false].should == Value.new(:objval2)
  end
end

#################### null_stringkey_nilvalue ####################

shared_examples_for 'null_stringkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = ''
    store["strkey2"] = nil
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = ''
    store["strkey1"] = nil
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = nil
    store["strkey2"] = ''
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = nil
    store["strkey1"] = ''
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 0
    store["strkey2"] = false
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 0
    store["strkey1"] = false
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = false
    store["strkey2"] = 0
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = false
    store["strkey1"] = 0
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", false, options).should == false
  end
end

#################### store_stringkey_nilvalue ####################

shared_examples_for 'store_stringkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = ''
    store["strkey1"].should == ''
    store.load("strkey1").should == ''
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = ''
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == ''
    store.load("strkey1").should == ''
  end

  it 'stores values after clear' do
    store["strkey1"] = ''
    store["strkey2"] = nil
    store.clear.should equal(store)
    store["strkey1"] = ''
    store["strkey1"].should == ''
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = ''
    store.delete("strkey1").should == ''
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = ''
    store["strkey1"].should == ''
    store["strkey1"] = nil
    store["strkey1"].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == ''
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = ''
    store["strkey1"].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = ''
    store["strkey2"].should == ''
    store.load("strkey2").should == ''
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = ''
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == ''
    store.load("strkey2").should == ''
  end

  it 'stores values after clear' do
    store["strkey2"] = ''
    store["strkey1"] = nil
    store.clear.should equal(store)
    store["strkey2"] = ''
    store["strkey2"].should == ''
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = ''
    store.delete("strkey2").should == ''
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = ''
    store["strkey2"].should == ''
    store["strkey2"] = nil
    store["strkey2"].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == ''
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = ''
    store["strkey2"].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store.load("strkey1").should == nil
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = nil
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == nil
    store.load("strkey1").should == nil
  end

  it 'stores values after clear' do
    store["strkey1"] = nil
    store["strkey2"] = ''
    store.clear.should equal(store)
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = nil
    store.delete("strkey1").should == nil
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = nil
    store["strkey1"].should == nil
    store["strkey1"] = ''
    store["strkey1"].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == nil
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = nil
    store["strkey1"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store.load("strkey2").should == nil
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = nil
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == nil
    store.load("strkey2").should == nil
  end

  it 'stores values after clear' do
    store["strkey2"] = nil
    store["strkey1"] = ''
    store.clear.should equal(store)
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = nil
    store.delete("strkey2").should == nil
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = nil
    store["strkey2"].should == nil
    store["strkey2"] = ''
    store["strkey2"].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == nil
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = nil
    store["strkey2"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store.load("strkey1").should == 0
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = 0
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 0
    store.load("strkey1").should == 0
  end

  it 'stores values after clear' do
    store["strkey1"] = 0
    store["strkey2"] = false
    store.clear.should equal(store)
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 0
    store.delete("strkey1").should == 0
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 0
    store["strkey1"].should == 0
    store["strkey1"] = false
    store["strkey1"].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == 0
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = 0
    store["strkey1"].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store.load("strkey2").should == 0
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = 0
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 0
    store.load("strkey2").should == 0
  end

  it 'stores values after clear' do
    store["strkey2"] = 0
    store["strkey1"] = false
    store.clear.should equal(store)
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 0
    store.delete("strkey2").should == 0
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 0
    store["strkey2"].should == 0
    store["strkey2"] = false
    store["strkey2"].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == 0
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = 0
    store["strkey2"].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = false
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'stores values after clear' do
    store["strkey1"] = false
    store["strkey2"] = 0
    store.clear.should equal(store)
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = false
    store.delete("strkey1").should == false
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey1"] = 0
    store["strkey1"].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == false
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = false
    store["strkey1"].should == false
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = false
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'stores values after clear' do
    store["strkey2"] = false
    store["strkey1"] = 0
    store.clear.should equal(store)
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = false
    store.delete("strkey2").should == false
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey2"] = 0
    store["strkey2"].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == false
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = false
    store["strkey2"].should == false
  end
end

#################### persist_stringkey_nilvalue ####################

shared_examples_for 'persist_stringkey_nilvalue' do
  it 'persists values' do
    store["strkey1"] = ''
    store.close
    @store = nil
    store["strkey1"].should == ''
  end

  it 'persists values' do
    store["strkey2"] = ''
    store.close
    @store = nil
    store["strkey2"].should == ''
  end

  it 'persists values' do
    store["strkey1"] = nil
    store.close
    @store = nil
    store["strkey1"].should == nil
  end

  it 'persists values' do
    store["strkey2"] = nil
    store.close
    @store = nil
    store["strkey2"].should == nil
  end

  it 'persists values' do
    store["strkey1"] = 0
    store.close
    @store = nil
    store["strkey1"].should == 0
  end

  it 'persists values' do
    store["strkey2"] = 0
    store.close
    @store = nil
    store["strkey2"].should == 0
  end

  it 'persists values' do
    store["strkey1"] = false
    store.close
    @store = nil
    store["strkey1"].should == false
  end

  it 'persists values' do
    store["strkey2"] = false
    store.close
    @store = nil
    store["strkey2"].should == false
  end
end

#################### null_stringkey_integervalue ####################

shared_examples_for 'null_stringkey_integervalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 41
    store["strkey2"] = -12
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 41
    store["strkey1"] = -12
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = -12
    store["strkey2"] = 41
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = -12
    store["strkey1"] = 41
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", -12, options).should == -12
  end
end

#################### store_stringkey_integervalue ####################

shared_examples_for 'store_stringkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store.load("strkey1").should == 41
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = 41
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 41
    store.load("strkey1").should == 41
  end

  it 'stores values after clear' do
    store["strkey1"] = 41
    store["strkey2"] = -12
    store.clear.should equal(store)
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 41
    store.delete("strkey1").should == 41
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 41
    store["strkey1"].should == 41
    store["strkey1"] = -12
    store["strkey1"].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == 41
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = 41
    store["strkey1"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = 41
    store.fetch("strkey1", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = 41
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store.load("strkey2").should == 41
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = 41
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 41
    store.load("strkey2").should == 41
  end

  it 'stores values after clear' do
    store["strkey2"] = 41
    store["strkey1"] = -12
    store.clear.should equal(store)
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 41
    store.delete("strkey2").should == 41
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 41
    store["strkey2"].should == 41
    store["strkey2"] = -12
    store["strkey2"].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == 41
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = 41
    store["strkey2"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = 41
    store.fetch("strkey2", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = 41
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store.load("strkey1").should == -12
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = -12
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == -12
    store.load("strkey1").should == -12
  end

  it 'stores values after clear' do
    store["strkey1"] = -12
    store["strkey2"] = 41
    store.clear.should equal(store)
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = -12
    store.delete("strkey1").should == -12
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = -12
    store["strkey1"].should == -12
    store["strkey1"] = 41
    store["strkey1"].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == -12
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = -12
    store["strkey1"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = -12
    store.fetch("strkey1", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = -12
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store.load("strkey2").should == -12
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = -12
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == -12
    store.load("strkey2").should == -12
  end

  it 'stores values after clear' do
    store["strkey2"] = -12
    store["strkey1"] = 41
    store.clear.should equal(store)
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = -12
    store.delete("strkey2").should == -12
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = -12
    store["strkey2"].should == -12
    store["strkey2"] = 41
    store["strkey2"].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == -12
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = -12
    store["strkey2"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = -12
    store.fetch("strkey2", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = -12
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_stringkey_integervalue ####################

shared_examples_for 'persist_stringkey_integervalue' do
  it 'persists values' do
    store["strkey1"] = 41
    store.close
    @store = nil
    store["strkey1"].should == 41
  end

  it 'persists values' do
    store["strkey2"] = 41
    store.close
    @store = nil
    store["strkey2"].should == 41
  end

  it 'persists values' do
    store["strkey1"] = -12
    store.close
    @store = nil
    store["strkey1"].should == -12
  end

  it 'persists values' do
    store["strkey2"] = -12
    store.close
    @store = nil
    store["strkey2"].should == -12
  end
end

#################### null_stringkey_numbervalue ####################

shared_examples_for 'null_stringkey_numbervalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 123.456
    store["strkey2"] = -98.7
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 123.456
    store["strkey1"] = -98.7
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = -98.7
    store["strkey2"] = 123.456
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = -98.7
    store["strkey1"] = 123.456
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey2"] = 33
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey1"] = 33
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = 33
    store["strkey2"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = 33
    store["strkey1"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", 33, options).should == 33
  end
end

#################### store_stringkey_numbervalue ####################

shared_examples_for 'store_stringkey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 123.456
    store["strkey1"].should == 123.456
    store.load("strkey1").should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = 123.456
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 123.456
    store.load("strkey1").should == 123.456
  end

  it 'stores values after clear' do
    store["strkey1"] = 123.456
    store["strkey2"] = -98.7
    store.clear.should equal(store)
    store["strkey1"] = 123.456
    store["strkey1"].should == 123.456
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 123.456
    store.delete("strkey1").should == 123.456
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 123.456
    store["strkey1"].should == 123.456
    store["strkey1"] = -98.7
    store["strkey1"].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == 123.456
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = 123.456
    store["strkey1"].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = 123.456
    store.fetch("strkey1", -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = 123.456
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 123.456
    store["strkey2"].should == 123.456
    store.load("strkey2").should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = 123.456
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 123.456
    store.load("strkey2").should == 123.456
  end

  it 'stores values after clear' do
    store["strkey2"] = 123.456
    store["strkey1"] = -98.7
    store.clear.should equal(store)
    store["strkey2"] = 123.456
    store["strkey2"].should == 123.456
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 123.456
    store.delete("strkey2").should == 123.456
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 123.456
    store["strkey2"].should == 123.456
    store["strkey2"] = -98.7
    store["strkey2"].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == 123.456
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = 123.456
    store["strkey2"].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = 123.456
    store.fetch("strkey2", -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = 123.456
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = -98.7
    store["strkey1"].should == -98.7
    store.load("strkey1").should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = -98.7
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == -98.7
    store.load("strkey1").should == -98.7
  end

  it 'stores values after clear' do
    store["strkey1"] = -98.7
    store["strkey2"] = 123.456
    store.clear.should equal(store)
    store["strkey1"] = -98.7
    store["strkey1"].should == -98.7
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = -98.7
    store.delete("strkey1").should == -98.7
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = -98.7
    store["strkey1"].should == -98.7
    store["strkey1"] = 123.456
    store["strkey1"].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == -98.7
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = -98.7
    store["strkey1"].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = -98.7
    store.fetch("strkey1", 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = -98.7
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = -98.7
    store["strkey2"].should == -98.7
    store.load("strkey2").should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = -98.7
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == -98.7
    store.load("strkey2").should == -98.7
  end

  it 'stores values after clear' do
    store["strkey2"] = -98.7
    store["strkey1"] = 123.456
    store.clear.should equal(store)
    store["strkey2"] = -98.7
    store["strkey2"].should == -98.7
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = -98.7
    store.delete("strkey2").should == -98.7
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = -98.7
    store["strkey2"].should == -98.7
    store["strkey2"] = 123.456
    store["strkey2"].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == -98.7
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = -98.7
    store["strkey2"].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = -98.7
    store.fetch("strkey2", 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = -98.7
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey1"].should == 340282366920938463463374607431768211456
    store.load("strkey1").should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 340282366920938463463374607431768211456
    store.load("strkey1").should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey2"] = 33
    store.clear.should equal(store)
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey1"].should == 340282366920938463463374607431768211456
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store.delete("strkey1").should == 340282366920938463463374607431768211456
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey1"].should == 340282366920938463463374607431768211456
    store["strkey1"] = 33
    store["strkey1"].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = 340282366920938463463374607431768211456
    store["strkey1"].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store.fetch("strkey1", 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey2"].should == 340282366920938463463374607431768211456
    store.load("strkey2").should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 340282366920938463463374607431768211456
    store.load("strkey2").should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey1"] = 33
    store.clear.should equal(store)
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey2"].should == 340282366920938463463374607431768211456
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store.delete("strkey2").should == 340282366920938463463374607431768211456
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey2"].should == 340282366920938463463374607431768211456
    store["strkey2"] = 33
    store["strkey2"].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = 340282366920938463463374607431768211456
    store["strkey2"].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store.fetch("strkey2", 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = 33
    store["strkey1"].should == 33
    store.load("strkey1").should == 33
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = 33
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == 33
    store.load("strkey1").should == 33
  end

  it 'stores values after clear' do
    store["strkey1"] = 33
    store["strkey2"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store["strkey1"] = 33
    store["strkey1"].should == 33
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = 33
    store.delete("strkey1").should == 33
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = 33
    store["strkey1"].should == 33
    store["strkey1"] = 340282366920938463463374607431768211456
    store["strkey1"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == 33
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = 33
    store["strkey1"].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = 33
    store.fetch("strkey1", 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = 33
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = 33
    store["strkey2"].should == 33
    store.load("strkey2").should == 33
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = 33
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == 33
    store.load("strkey2").should == 33
  end

  it 'stores values after clear' do
    store["strkey2"] = 33
    store["strkey1"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store["strkey2"] = 33
    store["strkey2"].should == 33
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = 33
    store.delete("strkey2").should == 33
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = 33
    store["strkey2"].should == 33
    store["strkey2"] = 340282366920938463463374607431768211456
    store["strkey2"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == 33
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = 33
    store["strkey2"].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = 33
    store.fetch("strkey2", 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = 33
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_stringkey_numbervalue ####################

shared_examples_for 'persist_stringkey_numbervalue' do
  it 'persists values' do
    store["strkey1"] = 123.456
    store.close
    @store = nil
    store["strkey1"].should == 123.456
  end

  it 'persists values' do
    store["strkey2"] = 123.456
    store.close
    @store = nil
    store["strkey2"].should == 123.456
  end

  it 'persists values' do
    store["strkey1"] = -98.7
    store.close
    @store = nil
    store["strkey1"].should == -98.7
  end

  it 'persists values' do
    store["strkey2"] = -98.7
    store.close
    @store = nil
    store["strkey2"].should == -98.7
  end

  it 'persists values' do
    store["strkey1"] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store["strkey1"].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store["strkey2"] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store["strkey2"].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store["strkey1"] = 33
    store.close
    @store = nil
    store["strkey1"].should == 33
  end

  it 'persists values' do
    store["strkey2"] = 33
    store.close
    @store = nil
    store["strkey2"].should == 33
  end
end

#################### null_stringkey_booleanvalue ####################

shared_examples_for 'null_stringkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = true
    store["strkey2"] = false
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = true
    store["strkey1"] = false
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = false
    store["strkey2"] = true
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = false
    store["strkey1"] = true
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", false, options).should == false
  end
end

#################### store_stringkey_booleanvalue ####################

shared_examples_for 'store_stringkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = true
    store["strkey1"].should == true
    store.load("strkey1").should == true
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = true
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == true
    store.load("strkey1").should == true
  end

  it 'stores values after clear' do
    store["strkey1"] = true
    store["strkey2"] = false
    store.clear.should equal(store)
    store["strkey1"] = true
    store["strkey1"].should == true
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = true
    store.delete("strkey1").should == true
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = true
    store["strkey1"].should == true
    store["strkey1"] = false
    store["strkey1"].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == true
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = true
    store["strkey1"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = true
    store.fetch("strkey1", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = true
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = true
    store["strkey2"].should == true
    store.load("strkey2").should == true
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = true
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == true
    store.load("strkey2").should == true
  end

  it 'stores values after clear' do
    store["strkey2"] = true
    store["strkey1"] = false
    store.clear.should equal(store)
    store["strkey2"] = true
    store["strkey2"].should == true
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = true
    store.delete("strkey2").should == true
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = true
    store["strkey2"].should == true
    store["strkey2"] = false
    store["strkey2"].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == true
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = true
    store["strkey2"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = true
    store.fetch("strkey2", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = true
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = false
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == false
    store.load("strkey1").should == false
  end

  it 'stores values after clear' do
    store["strkey1"] = false
    store["strkey2"] = true
    store.clear.should equal(store)
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = false
    store.delete("strkey1").should == false
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = false
    store["strkey1"].should == false
    store["strkey1"] = true
    store["strkey1"].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == false
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = false
    store["strkey1"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = false
    store.fetch("strkey1", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = false
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = false
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == false
    store.load("strkey2").should == false
  end

  it 'stores values after clear' do
    store["strkey2"] = false
    store["strkey1"] = true
    store.clear.should equal(store)
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = false
    store.delete("strkey2").should == false
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = false
    store["strkey2"].should == false
    store["strkey2"] = true
    store["strkey2"].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == false
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = false
    store["strkey2"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = false
    store.fetch("strkey2", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = false
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_stringkey_booleanvalue ####################

shared_examples_for 'persist_stringkey_booleanvalue' do
  it 'persists values' do
    store["strkey1"] = true
    store.close
    @store = nil
    store["strkey1"].should == true
  end

  it 'persists values' do
    store["strkey2"] = true
    store.close
    @store = nil
    store["strkey2"].should == true
  end

  it 'persists values' do
    store["strkey1"] = false
    store.close
    @store = nil
    store["strkey1"].should == false
  end

  it 'persists values' do
    store["strkey2"] = false
    store.close
    @store = nil
    store["strkey2"].should == false
  end
end

#################### null_stringkey_stringvalue ####################

shared_examples_for 'null_stringkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "strval1"
    store["strkey2"] = "strval2"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "strval1"
    store["strkey1"] = "strval2"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "strval2"
    store["strkey2"] = "strval1"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "strval2"
    store["strkey1"] = "strval1"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "strval2", options).should == "strval2"
  end
end

#################### store_stringkey_stringvalue ####################

shared_examples_for 'store_stringkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store.load("strkey1").should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = "strval1"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "strval1"
    store.load("strkey1").should == "strval1"
  end

  it 'stores values after clear' do
    store["strkey1"] = "strval1"
    store["strkey2"] = "strval2"
    store.clear.should equal(store)
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "strval1"
    store.delete("strkey1").should == "strval1"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == "strval1"
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = "strval1"
    store["strkey1"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "strval1"
    store.fetch("strkey1", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store.load("strkey2").should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = "strval1"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "strval1"
    store.load("strkey2").should == "strval1"
  end

  it 'stores values after clear' do
    store["strkey2"] = "strval1"
    store["strkey1"] = "strval2"
    store.clear.should equal(store)
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "strval1"
    store.delete("strkey2").should == "strval1"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == "strval1"
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = "strval1"
    store["strkey2"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "strval1"
    store.fetch("strkey2", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store.load("strkey1").should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = "strval2"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "strval2"
    store.load("strkey1").should == "strval2"
  end

  it 'stores values after clear' do
    store["strkey1"] = "strval2"
    store["strkey2"] = "strval1"
    store.clear.should equal(store)
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "strval2"
    store.delete("strkey1").should == "strval2"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "strval2"
    store["strkey1"].should == "strval2"
    store["strkey1"] = "strval1"
    store["strkey1"].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == "strval2"
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = "strval2"
    store["strkey1"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "strval2"
    store.fetch("strkey1", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store.load("strkey2").should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = "strval2"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "strval2"
    store.load("strkey2").should == "strval2"
  end

  it 'stores values after clear' do
    store["strkey2"] = "strval2"
    store["strkey1"] = "strval1"
    store.clear.should equal(store)
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "strval2"
    store.delete("strkey2").should == "strval2"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "strval2"
    store["strkey2"].should == "strval2"
    store["strkey2"] = "strval1"
    store["strkey2"].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == "strval2"
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = "strval2"
    store["strkey2"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "strval2"
    store.fetch("strkey2", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_stringvalue ####################

shared_examples_for 'returndifferent_stringkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_stringvalue ####################

shared_examples_for 'returnsame_stringkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_stringvalue ####################

shared_examples_for 'persist_stringkey_stringvalue' do
  it 'persists values' do
    store["strkey1"] = "strval1"
    store.close
    @store = nil
    store["strkey1"].should == "strval1"
  end

  it 'persists values' do
    store["strkey2"] = "strval1"
    store.close
    @store = nil
    store["strkey2"].should == "strval1"
  end

  it 'persists values' do
    store["strkey1"] = "strval2"
    store.close
    @store = nil
    store["strkey1"].should == "strval2"
  end

  it 'persists values' do
    store["strkey2"] = "strval2"
    store.close
    @store = nil
    store["strkey2"].should == "strval2"
  end
end

#################### null_stringkey_binaryvalue ####################

shared_examples_for 'null_stringkey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "über"
    store["strkey2"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "über"
    store["strkey1"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey2"] = "über"
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "\xAA\xBB\xCC"
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey1"] = "über"
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", "\xAA\xBB\xCC").should == "\xAA\xBB\xCC"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = "\xAA\xBB\xCC"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", "\xAA\xBB\xCC", options).should == "\xAA\xBB\xCC"
  end
end

#################### store_stringkey_binaryvalue ####################

shared_examples_for 'store_stringkey_binaryvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "über"
    store["strkey1"].should == "über"
    store.load("strkey1").should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = "über"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "über"
    store.load("strkey1").should == "über"
  end

  it 'stores values after clear' do
    store["strkey1"] = "über"
    store["strkey2"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store["strkey1"] = "über"
    store["strkey1"].should == "über"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "über"
    store.delete("strkey1").should == "über"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "über"
    store["strkey1"].should == "über"
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey1"].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == "über"
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = "über"
    store["strkey1"].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "über"
    store.fetch("strkey1", "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "über"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "über"
    store["strkey2"].should == "über"
    store.load("strkey2").should == "über"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = "über"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "über"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "über"
    store.load("strkey2").should == "über"
  end

  it 'stores values after clear' do
    store["strkey2"] = "über"
    store["strkey1"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store["strkey2"] = "über"
    store["strkey2"].should == "über"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "über"
    store.delete("strkey2").should == "über"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "über"
    store["strkey2"].should == "über"
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey2"].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen values' do
    value = "über".freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == "über"
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = "über"
    store["strkey2"].should == "über"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "über"
    store.fetch("strkey2", "\xAA\xBB\xCC").should == "über"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "über"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey1"].should == "\xAA\xBB\xCC"
    store.load("strkey1").should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == "\xAA\xBB\xCC"
    store.load("strkey1").should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey2"] = "über"
    store.clear.should equal(store)
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey1"].should == "\xAA\xBB\xCC"
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store.delete("strkey1").should == "\xAA\xBB\xCC"
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store["strkey1"].should == "\xAA\xBB\xCC"
    store["strkey1"] = "über"
    store["strkey1"].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = "\xAA\xBB\xCC"
    store["strkey1"].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store.fetch("strkey1", "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey2"].should == "\xAA\xBB\xCC"
    store.load("strkey2").should == "\xAA\xBB\xCC"
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = "\xAA\xBB\xCC"
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == "\xAA\xBB\xCC"
    store.load("strkey2").should == "\xAA\xBB\xCC"
  end

  it 'stores values after clear' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey1"] = "über"
    store.clear.should equal(store)
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey2"].should == "\xAA\xBB\xCC"
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store.delete("strkey2").should == "\xAA\xBB\xCC"
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store["strkey2"].should == "\xAA\xBB\xCC"
    store["strkey2"] = "über"
    store["strkey2"].should == "über"
  end

  it 'stores frozen values' do
    value = "\xAA\xBB\xCC".freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == "\xAA\xBB\xCC"
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = "\xAA\xBB\xCC"
    store["strkey2"].should == "\xAA\xBB\xCC"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store.fetch("strkey2", "über").should == "\xAA\xBB\xCC"
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = "\xAA\xBB\xCC"
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_binaryvalue ####################

shared_examples_for 'returndifferent_stringkey_binaryvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "über"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "über"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "\xAA\xBB\xCC"
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_binaryvalue ####################

shared_examples_for 'returnsame_stringkey_binaryvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "über"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "über"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "\xAA\xBB\xCC"
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_binaryvalue ####################

shared_examples_for 'persist_stringkey_binaryvalue' do
  it 'persists values' do
    store["strkey1"] = "über"
    store.close
    @store = nil
    store["strkey1"].should == "über"
  end

  it 'persists values' do
    store["strkey2"] = "über"
    store.close
    @store = nil
    store["strkey2"].should == "über"
  end

  it 'persists values' do
    store["strkey1"] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store["strkey1"].should == "\xAA\xBB\xCC"
  end

  it 'persists values' do
    store["strkey2"] = "\xAA\xBB\xCC"
    store.close
    @store = nil
    store["strkey2"].should == "\xAA\xBB\xCC"
  end
end

#################### null_stringkey_hashvalue ####################

shared_examples_for 'null_stringkey_hashvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval1"=>["array1", 1]}
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", {"hashval1"=>["array1", 1]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = {"hashval1"=>["array1", 1]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", {"hashval1"=>["array1", 1]}, options).should == {"hashval1"=>["array1", 1]}
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}, options).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### store_stringkey_hashvalue ####################

shared_examples_for 'store_stringkey_hashvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey1").should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey1").should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.delete("strkey1").should == {"hashval1"=>["array1", 1]}
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.fetch("strkey1", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey2").should == {"hashval1"=>["array1", 1]}
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval1"=>["array1", 1]}
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store.load("strkey2").should == {"hashval1"=>["array1", 1]}
  end

  it 'stores values after clear' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.clear.should equal(store)
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.delete("strkey2").should == {"hashval1"=>["array1", 1]}
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen values' do
    value = {"hashval1"=>["array1", 1]}.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.fetch("strkey2", {"hashval3"=>["array2", {"hashval4"=>42}]}).should == {"hashval1"=>["array1", 1]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete("strkey1").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch("strkey1", {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.load("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores values after clear' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.clear.should equal(store)
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.delete("strkey2").should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end

  it 'stores frozen values' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}.freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.fetch("strkey2", {"hashval1"=>["array1", 1]}).should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_hashvalue ####################

shared_examples_for 'returndifferent_stringkey_hashvalue' do
  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_hashvalue ####################

shared_examples_for 'returnsame_stringkey_hashvalue' do
  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval1"=>["array1", 1]}
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_hashvalue ####################

shared_examples_for 'persist_stringkey_hashvalue' do
  it 'persists values' do
    store["strkey1"] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store["strkey1"].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store["strkey2"] = {"hashval1"=>["array1", 1]}
    store.close
    @store = nil
    store["strkey2"].should == {"hashval1"=>["array1", 1]}
  end

  it 'persists values' do
    store["strkey1"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store["strkey1"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end

  it 'persists values' do
    store["strkey2"] = {"hashval3"=>["array2", {"hashval4"=>42}]}
    store.close
    @store = nil
    store["strkey2"].should == {"hashval3"=>["array2", {"hashval4"=>42}]}
  end
end

#################### null_stringkey_objectvalue ####################

shared_examples_for 'null_stringkey_objectvalue' do
  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval1)
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", Value.new(:objval1)).should == Value.new(:objval1)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = Value.new(:objval1)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", Value.new(:objval1), options).should == Value.new(:objval1)
  end

  it 'reads from keys like a Hash' do
    store["strkey1"].should be_nil
    store.load("strkey1").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store["strkey1"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey1").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey1").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?("strkey1").should be_false
    store.key?("strkey2").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey1", Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey1"
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey1", options).should be_false
    store.load("strkey1", options).should be_nil
    store.fetch("strkey1", 42, options).should == 42
    store.fetch("strkey1", options) { 42 }.should == 42
    store.delete("strkey1", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey1", Value.new(:objval2), options).should == Value.new(:objval2)
  end

  it 'reads from keys like a Hash' do
    store["strkey2"].should be_nil
    store.load("strkey2").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = Value.new(:objval2)
    (store["strkey2"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("strkey2").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("strkey2").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store.clear.should equal(store)
    store.key?("strkey2").should be_false
    store.key?("strkey1").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("strkey2", Value.new(:objval2)).should == Value.new(:objval2)
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "strkey2"
    value = Value.new(:objval2)
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("strkey2", options).should be_false
    store.load("strkey2", options).should be_nil
    store.fetch("strkey2", 42, options).should == 42
    store.fetch("strkey2", options) { 42 }.should == 42
    store.delete("strkey2", options).should be_nil
    store.clear(options).should equal(store)
    store.store("strkey2", Value.new(:objval2), options).should == Value.new(:objval2)
  end
end

#################### store_stringkey_objectvalue ####################

shared_examples_for 'store_stringkey_objectvalue' do
  it 'writes values to keys that like a Hash' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store.load("strkey1").should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = Value.new(:objval1)
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == Value.new(:objval1)
    store.load("strkey1").should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store.clear.should equal(store)
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = Value.new(:objval1)
    store.delete("strkey1").should == Value.new(:objval1)
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = Value.new(:objval1)
    store.fetch("strkey1", Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store.load("strkey2").should == Value.new(:objval1)
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = Value.new(:objval1)
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval1)
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == Value.new(:objval1)
    store.load("strkey2").should == Value.new(:objval1)
  end

  it 'stores values after clear' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey1"] = Value.new(:objval2)
    store.clear.should equal(store)
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = Value.new(:objval1)
    store.delete("strkey2").should == Value.new(:objval1)
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
  end

  it 'stores frozen values' do
    value = Value.new(:objval1).freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == Value.new(:objval1)
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = Value.new(:objval1)
    store.fetch("strkey2", Value.new(:objval2)).should == Value.new(:objval1)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = Value.new(:objval1)
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store.load("strkey1").should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store["strkey1"] = Value.new(:objval2)
    store.key?("strkey1").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store("strkey1", value).should equal(value)
    store["strkey1"].should == Value.new(:objval2)
    store.load("strkey1").should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store.clear.should equal(store)
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store["strkey2"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey1"] = Value.new(:objval2)
    store.delete("strkey1").should == Value.new(:objval2)
    store.key?("strkey1").should be_false
  end

  it 'overwrites existing values' do
    store["strkey1"] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store["strkey1"].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store["strkey1"] = value).should equal(value)
    store["strkey1"].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = "strkey1".freeze
    store[key] = Value.new(:objval2)
    store["strkey1"].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey1"] = Value.new(:objval2)
    store.fetch("strkey1", Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey1"] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch("strkey1") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store.load("strkey2").should == Value.new(:objval2)
  end

  it 'returns true from #key? if a key is available' do
    store["strkey2"] = Value.new(:objval2)
    store.key?("strkey2").should be_true
  end

  it 'stores values with #store' do
    value = Value.new(:objval2)
    store.store("strkey2", value).should equal(value)
    store["strkey2"].should == Value.new(:objval2)
    store.load("strkey2").should == Value.new(:objval2)
  end

  it 'stores values after clear' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey1"] = Value.new(:objval1)
    store.clear.should equal(store)
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store["strkey1"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["strkey2"] = Value.new(:objval2)
    store.delete("strkey2").should == Value.new(:objval2)
    store.key?("strkey2").should be_false
  end

  it 'overwrites existing values' do
    store["strkey2"] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
    store["strkey2"] = Value.new(:objval1)
    store["strkey2"].should == Value.new(:objval1)
  end

  it 'stores frozen values' do
    value = Value.new(:objval2).freeze
    (store["strkey2"] = value).should equal(value)
    store["strkey2"].should == Value.new(:objval2)
  end

  it 'stores frozen keys' do
    key = "strkey2".freeze
    store[key] = Value.new(:objval2)
    store["strkey2"].should == Value.new(:objval2)
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["strkey2"] = Value.new(:objval2)
    store.fetch("strkey2", Value.new(:objval1)).should == Value.new(:objval2)
  end

  it 'does not run the block in fetch if the key is available' do
    store["strkey2"] = Value.new(:objval2)
    unaltered = 'unaltered'
    store.fetch("strkey2") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_stringkey_objectvalue ####################

shared_examples_for 'returndifferent_stringkey_objectvalue' do
  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval1)
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store["strkey1"] = value
    store["strkey1"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = Value.new(:objval2)
    store["strkey2"] = value
    store["strkey2"].should_not be_equal(value)
  end
end

#################### returnsame_stringkey_objectvalue ####################

shared_examples_for 'returnsame_stringkey_objectvalue' do
  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval1)
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store["strkey1"] = value
    store["strkey1"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = Value.new(:objval2)
    store["strkey2"] = value
    store["strkey2"].should be_equal(value)
  end
end

#################### persist_stringkey_objectvalue ####################

shared_examples_for 'persist_stringkey_objectvalue' do
  it 'persists values' do
    store["strkey1"] = Value.new(:objval1)
    store.close
    @store = nil
    store["strkey1"].should == Value.new(:objval1)
  end

  it 'persists values' do
    store["strkey2"] = Value.new(:objval1)
    store.close
    @store = nil
    store["strkey2"].should == Value.new(:objval1)
  end

  it 'persists values' do
    store["strkey1"] = Value.new(:objval2)
    store.close
    @store = nil
    store["strkey1"].should == Value.new(:objval2)
  end

  it 'persists values' do
    store["strkey2"] = Value.new(:objval2)
    store.close
    @store = nil
    store["strkey2"].should == Value.new(:objval2)
  end
end

#################### null_pathkey_nilvalue ####################

shared_examples_for 'null_pathkey_nilvalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = ''
    store["foo/bar"] = nil
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = ''
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = ''
    store["bar/foo/baz"] = nil
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", '').should == ''
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = ''
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", '', options).should == ''
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = nil
    store["foo/bar"] = ''
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = nil
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = nil
    store["bar/foo/baz"] = ''
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", nil).should == nil
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = nil
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", nil, options).should == nil
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = 0
    store["foo/bar"] = false
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 0
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = 0
    store["bar/foo/baz"] = false
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", 0).should == 0
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = 0
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", 0, options).should == 0
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = false
    store["foo/bar"] = 0
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = false
    store["bar/foo/baz"] = 0
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", false, options).should == false
  end
end

#################### store_pathkey_nilvalue ####################

shared_examples_for 'store_pathkey_nilvalue' do
  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = ''
    store["bar/foo/baz"].should == ''
    store.load("bar/foo/baz").should == ''
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = ''
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == ''
    store.load("bar/foo/baz").should == ''
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = ''
    store["foo/bar"] = nil
    store.clear.should equal(store)
    store["bar/foo/baz"] = ''
    store["bar/foo/baz"].should == ''
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = ''
    store.delete("bar/foo/baz").should == ''
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = ''
    store["bar/foo/baz"].should == ''
    store["bar/foo/baz"] = nil
    store["bar/foo/baz"].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == ''
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = ''
    store["bar/foo/baz"].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = ''
    store["foo/bar"].should == ''
    store.load("foo/bar").should == ''
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = ''
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = ''
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == ''
    store.load("foo/bar").should == ''
  end

  it 'stores values after clear' do
    store["foo/bar"] = ''
    store["bar/foo/baz"] = nil
    store.clear.should equal(store)
    store["foo/bar"] = ''
    store["foo/bar"].should == ''
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = ''
    store.delete("foo/bar").should == ''
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = ''
    store["foo/bar"].should == ''
    store["foo/bar"] = nil
    store["foo/bar"].should == nil
  end

  it 'stores frozen values' do
    value = ''.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == ''
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = ''
    store["foo/bar"].should == ''
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = nil
    store["bar/foo/baz"].should == nil
    store.load("bar/foo/baz").should == nil
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = nil
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == nil
    store.load("bar/foo/baz").should == nil
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = nil
    store["foo/bar"] = ''
    store.clear.should equal(store)
    store["bar/foo/baz"] = nil
    store["bar/foo/baz"].should == nil
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = nil
    store.delete("bar/foo/baz").should == nil
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = nil
    store["bar/foo/baz"].should == nil
    store["bar/foo/baz"] = ''
    store["bar/foo/baz"].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == nil
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = nil
    store["bar/foo/baz"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = nil
    store["foo/bar"].should == nil
    store.load("foo/bar").should == nil
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = nil
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = nil
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == nil
    store.load("foo/bar").should == nil
  end

  it 'stores values after clear' do
    store["foo/bar"] = nil
    store["bar/foo/baz"] = ''
    store.clear.should equal(store)
    store["foo/bar"] = nil
    store["foo/bar"].should == nil
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = nil
    store.delete("foo/bar").should == nil
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = nil
    store["foo/bar"].should == nil
    store["foo/bar"] = ''
    store["foo/bar"].should == ''
  end

  it 'stores frozen values' do
    value = nil.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == nil
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = nil
    store["foo/bar"].should == nil
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = 0
    store["bar/foo/baz"].should == 0
    store.load("bar/foo/baz").should == 0
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = 0
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == 0
    store.load("bar/foo/baz").should == 0
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = 0
    store["foo/bar"] = false
    store.clear.should equal(store)
    store["bar/foo/baz"] = 0
    store["bar/foo/baz"].should == 0
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = 0
    store.delete("bar/foo/baz").should == 0
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = 0
    store["bar/foo/baz"].should == 0
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == 0
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = 0
    store["bar/foo/baz"].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = 0
    store["foo/bar"].should == 0
    store.load("foo/bar").should == 0
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = 0
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = 0
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == 0
    store.load("foo/bar").should == 0
  end

  it 'stores values after clear' do
    store["foo/bar"] = 0
    store["bar/foo/baz"] = false
    store.clear.should equal(store)
    store["foo/bar"] = 0
    store["foo/bar"].should == 0
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = 0
    store.delete("foo/bar").should == 0
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = 0
    store["foo/bar"].should == 0
    store["foo/bar"] = false
    store["foo/bar"].should == false
  end

  it 'stores frozen values' do
    value = 0.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == 0
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = 0
    store["foo/bar"].should == 0
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store.load("bar/foo/baz").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = false
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == false
    store.load("bar/foo/baz").should == false
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = false
    store["foo/bar"] = 0
    store.clear.should equal(store)
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = false
    store.delete("bar/foo/baz").should == false
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store["bar/foo/baz"] = 0
    store["bar/foo/baz"].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == false
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = false
    store["bar/foo/baz"].should == false
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store.load("foo/bar").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = false
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == false
    store.load("foo/bar").should == false
  end

  it 'stores values after clear' do
    store["foo/bar"] = false
    store["bar/foo/baz"] = 0
    store.clear.should equal(store)
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = false
    store.delete("foo/bar").should == false
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store["foo/bar"] = 0
    store["foo/bar"].should == 0
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == false
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = false
    store["foo/bar"].should == false
  end
end

#################### persist_pathkey_nilvalue ####################

shared_examples_for 'persist_pathkey_nilvalue' do
  it 'persists values' do
    store["bar/foo/baz"] = ''
    store.close
    @store = nil
    store["bar/foo/baz"].should == ''
  end

  it 'persists values' do
    store["foo/bar"] = ''
    store.close
    @store = nil
    store["foo/bar"].should == ''
  end

  it 'persists values' do
    store["bar/foo/baz"] = nil
    store.close
    @store = nil
    store["bar/foo/baz"].should == nil
  end

  it 'persists values' do
    store["foo/bar"] = nil
    store.close
    @store = nil
    store["foo/bar"].should == nil
  end

  it 'persists values' do
    store["bar/foo/baz"] = 0
    store.close
    @store = nil
    store["bar/foo/baz"].should == 0
  end

  it 'persists values' do
    store["foo/bar"] = 0
    store.close
    @store = nil
    store["foo/bar"].should == 0
  end

  it 'persists values' do
    store["bar/foo/baz"] = false
    store.close
    @store = nil
    store["bar/foo/baz"].should == false
  end

  it 'persists values' do
    store["foo/bar"] = false
    store.close
    @store = nil
    store["foo/bar"].should == false
  end
end

#################### null_pathkey_integervalue ####################

shared_examples_for 'null_pathkey_integervalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = 41
    store["foo/bar"] = -12
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 41
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = 41
    store["bar/foo/baz"] = -12
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", 41).should == 41
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = 41
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", 41, options).should == 41
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = -12
    store["foo/bar"] = 41
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", -12, options).should == -12
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -12
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = -12
    store["bar/foo/baz"] = 41
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", -12).should == -12
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = -12
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", -12, options).should == -12
  end
end

#################### store_pathkey_integervalue ####################

shared_examples_for 'store_pathkey_integervalue' do
  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = 41
    store["bar/foo/baz"].should == 41
    store.load("bar/foo/baz").should == 41
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = 41
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == 41
    store.load("bar/foo/baz").should == 41
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = 41
    store["foo/bar"] = -12
    store.clear.should equal(store)
    store["bar/foo/baz"] = 41
    store["bar/foo/baz"].should == 41
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = 41
    store.delete("bar/foo/baz").should == 41
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = 41
    store["bar/foo/baz"].should == 41
    store["bar/foo/baz"] = -12
    store["bar/foo/baz"].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == 41
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = 41
    store["bar/foo/baz"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = 41
    store.fetch("bar/foo/baz", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = 41
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = 41
    store["foo/bar"].should == 41
    store.load("foo/bar").should == 41
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = 41
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = 41
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == 41
    store.load("foo/bar").should == 41
  end

  it 'stores values after clear' do
    store["foo/bar"] = 41
    store["bar/foo/baz"] = -12
    store.clear.should equal(store)
    store["foo/bar"] = 41
    store["foo/bar"].should == 41
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = 41
    store.delete("foo/bar").should == 41
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = 41
    store["foo/bar"].should == 41
    store["foo/bar"] = -12
    store["foo/bar"].should == -12
  end

  it 'stores frozen values' do
    value = 41.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == 41
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = 41
    store["foo/bar"].should == 41
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = 41
    store.fetch("foo/bar", -12).should == 41
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = 41
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = -12
    store["bar/foo/baz"].should == -12
    store.load("bar/foo/baz").should == -12
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = -12
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == -12
    store.load("bar/foo/baz").should == -12
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = -12
    store["foo/bar"] = 41
    store.clear.should equal(store)
    store["bar/foo/baz"] = -12
    store["bar/foo/baz"].should == -12
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = -12
    store.delete("bar/foo/baz").should == -12
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = -12
    store["bar/foo/baz"].should == -12
    store["bar/foo/baz"] = 41
    store["bar/foo/baz"].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == -12
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = -12
    store["bar/foo/baz"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = -12
    store.fetch("bar/foo/baz", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = -12
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = -12
    store["foo/bar"].should == -12
    store.load("foo/bar").should == -12
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = -12
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = -12
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == -12
    store.load("foo/bar").should == -12
  end

  it 'stores values after clear' do
    store["foo/bar"] = -12
    store["bar/foo/baz"] = 41
    store.clear.should equal(store)
    store["foo/bar"] = -12
    store["foo/bar"].should == -12
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = -12
    store.delete("foo/bar").should == -12
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = -12
    store["foo/bar"].should == -12
    store["foo/bar"] = 41
    store["foo/bar"].should == 41
  end

  it 'stores frozen values' do
    value = -12.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == -12
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = -12
    store["foo/bar"].should == -12
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = -12
    store.fetch("foo/bar", 41).should == -12
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = -12
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_pathkey_integervalue ####################

shared_examples_for 'persist_pathkey_integervalue' do
  it 'persists values' do
    store["bar/foo/baz"] = 41
    store.close
    @store = nil
    store["bar/foo/baz"].should == 41
  end

  it 'persists values' do
    store["foo/bar"] = 41
    store.close
    @store = nil
    store["foo/bar"].should == 41
  end

  it 'persists values' do
    store["bar/foo/baz"] = -12
    store.close
    @store = nil
    store["bar/foo/baz"].should == -12
  end

  it 'persists values' do
    store["foo/bar"] = -12
    store.close
    @store = nil
    store["foo/bar"].should == -12
  end
end

#################### null_pathkey_numbervalue ####################

shared_examples_for 'null_pathkey_numbervalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = 123.456
    store["foo/bar"] = -98.7
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 123.456
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = 123.456
    store["bar/foo/baz"] = -98.7
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", 123.456).should == 123.456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = 123.456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", 123.456, options).should == 123.456
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = -98.7
    store["foo/bar"] = 123.456
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = -98.7
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = -98.7
    store["bar/foo/baz"] = 123.456
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", -98.7).should == -98.7
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = -98.7
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", -98.7, options).should == -98.7
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["foo/bar"] = 33
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 340282366920938463463374607431768211456
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"] = 33
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", 340282366920938463463374607431768211456).should == 340282366920938463463374607431768211456
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = 340282366920938463463374607431768211456
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", 340282366920938463463374607431768211456, options).should == 340282366920938463463374607431768211456
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = 33
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", 33, options).should == 33
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = 33
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = 33
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", 33).should == 33
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = 33
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", 33, options).should == 33
  end
end

#################### store_pathkey_numbervalue ####################

shared_examples_for 'store_pathkey_numbervalue' do
  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = 123.456
    store["bar/foo/baz"].should == 123.456
    store.load("bar/foo/baz").should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = 123.456
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == 123.456
    store.load("bar/foo/baz").should == 123.456
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = 123.456
    store["foo/bar"] = -98.7
    store.clear.should equal(store)
    store["bar/foo/baz"] = 123.456
    store["bar/foo/baz"].should == 123.456
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = 123.456
    store.delete("bar/foo/baz").should == 123.456
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = 123.456
    store["bar/foo/baz"].should == 123.456
    store["bar/foo/baz"] = -98.7
    store["bar/foo/baz"].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == 123.456
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = 123.456
    store["bar/foo/baz"].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = 123.456
    store.fetch("bar/foo/baz", -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = 123.456
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = 123.456
    store["foo/bar"].should == 123.456
    store.load("foo/bar").should == 123.456
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = 123.456
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = 123.456
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == 123.456
    store.load("foo/bar").should == 123.456
  end

  it 'stores values after clear' do
    store["foo/bar"] = 123.456
    store["bar/foo/baz"] = -98.7
    store.clear.should equal(store)
    store["foo/bar"] = 123.456
    store["foo/bar"].should == 123.456
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = 123.456
    store.delete("foo/bar").should == 123.456
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = 123.456
    store["foo/bar"].should == 123.456
    store["foo/bar"] = -98.7
    store["foo/bar"].should == -98.7
  end

  it 'stores frozen values' do
    value = 123.456.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == 123.456
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = 123.456
    store["foo/bar"].should == 123.456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = 123.456
    store.fetch("foo/bar", -98.7).should == 123.456
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = 123.456
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = -98.7
    store["bar/foo/baz"].should == -98.7
    store.load("bar/foo/baz").should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = -98.7
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == -98.7
    store.load("bar/foo/baz").should == -98.7
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = -98.7
    store["foo/bar"] = 123.456
    store.clear.should equal(store)
    store["bar/foo/baz"] = -98.7
    store["bar/foo/baz"].should == -98.7
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = -98.7
    store.delete("bar/foo/baz").should == -98.7
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = -98.7
    store["bar/foo/baz"].should == -98.7
    store["bar/foo/baz"] = 123.456
    store["bar/foo/baz"].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == -98.7
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = -98.7
    store["bar/foo/baz"].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = -98.7
    store.fetch("bar/foo/baz", 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = -98.7
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = -98.7
    store["foo/bar"].should == -98.7
    store.load("foo/bar").should == -98.7
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = -98.7
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = -98.7
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == -98.7
    store.load("foo/bar").should == -98.7
  end

  it 'stores values after clear' do
    store["foo/bar"] = -98.7
    store["bar/foo/baz"] = 123.456
    store.clear.should equal(store)
    store["foo/bar"] = -98.7
    store["foo/bar"].should == -98.7
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = -98.7
    store.delete("foo/bar").should == -98.7
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = -98.7
    store["foo/bar"].should == -98.7
    store["foo/bar"] = 123.456
    store["foo/bar"].should == 123.456
  end

  it 'stores frozen values' do
    value = -98.7.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == -98.7
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = -98.7
    store["foo/bar"].should == -98.7
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = -98.7
    store.fetch("foo/bar", 123.456).should == -98.7
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = -98.7
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
    store.load("bar/foo/baz").should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
    store.load("bar/foo/baz").should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["foo/bar"] = 33
    store.clear.should equal(store)
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.delete("bar/foo/baz").should == 340282366920938463463374607431768211456
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
    store["bar/foo/baz"] = 33
    store["bar/foo/baz"].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = 340282366920938463463374607431768211456
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.fetch("bar/foo/baz", 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["foo/bar"].should == 340282366920938463463374607431768211456
    store.load("foo/bar").should == 340282366920938463463374607431768211456
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = 340282366920938463463374607431768211456
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == 340282366920938463463374607431768211456
    store.load("foo/bar").should == 340282366920938463463374607431768211456
  end

  it 'stores values after clear' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"] = 33
    store.clear.should equal(store)
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["foo/bar"].should == 340282366920938463463374607431768211456
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.delete("foo/bar").should == 340282366920938463463374607431768211456
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["foo/bar"].should == 340282366920938463463374607431768211456
    store["foo/bar"] = 33
    store["foo/bar"].should == 33
  end

  it 'stores frozen values' do
    value = 340282366920938463463374607431768211456.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = 340282366920938463463374607431768211456
    store["foo/bar"].should == 340282366920938463463374607431768211456
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.fetch("foo/bar", 33).should == 340282366920938463463374607431768211456
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = 33
    store["bar/foo/baz"].should == 33
    store.load("bar/foo/baz").should == 33
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = 33
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == 33
    store.load("bar/foo/baz").should == 33
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = 33
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store["bar/foo/baz"] = 33
    store["bar/foo/baz"].should == 33
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = 33
    store.delete("bar/foo/baz").should == 33
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = 33
    store["bar/foo/baz"].should == 33
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == 33
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = 33
    store["bar/foo/baz"].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = 33
    store.fetch("bar/foo/baz", 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = 33
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = 33
    store["foo/bar"].should == 33
    store.load("foo/bar").should == 33
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = 33
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = 33
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == 33
    store.load("foo/bar").should == 33
  end

  it 'stores values after clear' do
    store["foo/bar"] = 33
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.clear.should equal(store)
    store["foo/bar"] = 33
    store["foo/bar"].should == 33
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = 33
    store.delete("foo/bar").should == 33
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = 33
    store["foo/bar"].should == 33
    store["foo/bar"] = 340282366920938463463374607431768211456
    store["foo/bar"].should == 340282366920938463463374607431768211456
  end

  it 'stores frozen values' do
    value = 33.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == 33
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = 33
    store["foo/bar"].should == 33
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = 33
    store.fetch("foo/bar", 340282366920938463463374607431768211456).should == 33
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = 33
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_pathkey_numbervalue ####################

shared_examples_for 'persist_pathkey_numbervalue' do
  it 'persists values' do
    store["bar/foo/baz"] = 123.456
    store.close
    @store = nil
    store["bar/foo/baz"].should == 123.456
  end

  it 'persists values' do
    store["foo/bar"] = 123.456
    store.close
    @store = nil
    store["foo/bar"].should == 123.456
  end

  it 'persists values' do
    store["bar/foo/baz"] = -98.7
    store.close
    @store = nil
    store["bar/foo/baz"].should == -98.7
  end

  it 'persists values' do
    store["foo/bar"] = -98.7
    store.close
    @store = nil
    store["foo/bar"].should == -98.7
  end

  it 'persists values' do
    store["bar/foo/baz"] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store["bar/foo/baz"].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store["foo/bar"] = 340282366920938463463374607431768211456
    store.close
    @store = nil
    store["foo/bar"].should == 340282366920938463463374607431768211456
  end

  it 'persists values' do
    store["bar/foo/baz"] = 33
    store.close
    @store = nil
    store["bar/foo/baz"].should == 33
  end

  it 'persists values' do
    store["foo/bar"] = 33
    store.close
    @store = nil
    store["foo/bar"].should == 33
  end
end

#################### null_pathkey_booleanvalue ####################

shared_examples_for 'null_pathkey_booleanvalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = true
    store["foo/bar"] = false
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = true
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = true
    store["bar/foo/baz"] = false
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", true).should == true
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = true
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", true, options).should == true
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = false
    store["foo/bar"] = true
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", false, options).should == false
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = false
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = false
    store["bar/foo/baz"] = true
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", false).should == false
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = false
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", false, options).should == false
  end
end

#################### store_pathkey_booleanvalue ####################

shared_examples_for 'store_pathkey_booleanvalue' do
  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = true
    store["bar/foo/baz"].should == true
    store.load("bar/foo/baz").should == true
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = true
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == true
    store.load("bar/foo/baz").should == true
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = true
    store["foo/bar"] = false
    store.clear.should equal(store)
    store["bar/foo/baz"] = true
    store["bar/foo/baz"].should == true
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = true
    store.delete("bar/foo/baz").should == true
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = true
    store["bar/foo/baz"].should == true
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == true
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = true
    store["bar/foo/baz"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = true
    store.fetch("bar/foo/baz", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = true
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = true
    store["foo/bar"].should == true
    store.load("foo/bar").should == true
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = true
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = true
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == true
    store.load("foo/bar").should == true
  end

  it 'stores values after clear' do
    store["foo/bar"] = true
    store["bar/foo/baz"] = false
    store.clear.should equal(store)
    store["foo/bar"] = true
    store["foo/bar"].should == true
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = true
    store.delete("foo/bar").should == true
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = true
    store["foo/bar"].should == true
    store["foo/bar"] = false
    store["foo/bar"].should == false
  end

  it 'stores frozen values' do
    value = true.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == true
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = true
    store["foo/bar"].should == true
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = true
    store.fetch("foo/bar", false).should == true
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = true
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store.load("bar/foo/baz").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = false
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == false
    store.load("bar/foo/baz").should == false
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = false
    store["foo/bar"] = true
    store.clear.should equal(store)
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = false
    store.delete("bar/foo/baz").should == false
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = false
    store["bar/foo/baz"].should == false
    store["bar/foo/baz"] = true
    store["bar/foo/baz"].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == false
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = false
    store["bar/foo/baz"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = false
    store.fetch("bar/foo/baz", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = false
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store.load("foo/bar").should == false
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = false
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = false
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == false
    store.load("foo/bar").should == false
  end

  it 'stores values after clear' do
    store["foo/bar"] = false
    store["bar/foo/baz"] = true
    store.clear.should equal(store)
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = false
    store.delete("foo/bar").should == false
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = false
    store["foo/bar"].should == false
    store["foo/bar"] = true
    store["foo/bar"].should == true
  end

  it 'stores frozen values' do
    value = false.freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == false
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = false
    store["foo/bar"].should == false
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = false
    store.fetch("foo/bar", true).should == false
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = false
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### persist_pathkey_booleanvalue ####################

shared_examples_for 'persist_pathkey_booleanvalue' do
  it 'persists values' do
    store["bar/foo/baz"] = true
    store.close
    @store = nil
    store["bar/foo/baz"].should == true
  end

  it 'persists values' do
    store["foo/bar"] = true
    store.close
    @store = nil
    store["foo/bar"].should == true
  end

  it 'persists values' do
    store["bar/foo/baz"] = false
    store.close
    @store = nil
    store["bar/foo/baz"].should == false
  end

  it 'persists values' do
    store["foo/bar"] = false
    store.close
    @store = nil
    store["foo/bar"].should == false
  end
end

#################### null_pathkey_stringvalue ####################

shared_examples_for 'null_pathkey_stringvalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = "strval1"
    store["foo/bar"] = "strval2"
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval1"
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = "strval1"
    store["bar/foo/baz"] = "strval2"
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", "strval1").should == "strval1"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = "strval1"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", "strval1", options).should == "strval1"
  end

  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = "strval2"
    store["foo/bar"] = "strval1"
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", "strval2", options).should == "strval2"
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "strval2"
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = "strval2"
    store["bar/foo/baz"] = "strval1"
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("foo/bar", "strval2").should == "strval2"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "foo/bar"
    value = "strval2"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("foo/bar", options).should be_false
    store.load("foo/bar", options).should be_nil
    store.fetch("foo/bar", 42, options).should == 42
    store.fetch("foo/bar", options) { 42 }.should == 42
    store.delete("foo/bar", options).should be_nil
    store.clear(options).should equal(store)
    store.store("foo/bar", "strval2", options).should == "strval2"
  end
end

#################### store_pathkey_stringvalue ####################

shared_examples_for 'store_pathkey_stringvalue' do
  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = "strval1"
    store["bar/foo/baz"].should == "strval1"
    store.load("bar/foo/baz").should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = "strval1"
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == "strval1"
    store.load("bar/foo/baz").should == "strval1"
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = "strval1"
    store["foo/bar"] = "strval2"
    store.clear.should equal(store)
    store["bar/foo/baz"] = "strval1"
    store["bar/foo/baz"].should == "strval1"
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = "strval1"
    store.delete("bar/foo/baz").should == "strval1"
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = "strval1"
    store["bar/foo/baz"].should == "strval1"
    store["bar/foo/baz"] = "strval2"
    store["bar/foo/baz"].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == "strval1"
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = "strval1"
    store["bar/foo/baz"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = "strval1"
    store.fetch("bar/foo/baz", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = "strval1"
    store["foo/bar"].should == "strval1"
    store.load("foo/bar").should == "strval1"
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = "strval1"
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = "strval1"
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == "strval1"
    store.load("foo/bar").should == "strval1"
  end

  it 'stores values after clear' do
    store["foo/bar"] = "strval1"
    store["bar/foo/baz"] = "strval2"
    store.clear.should equal(store)
    store["foo/bar"] = "strval1"
    store["foo/bar"].should == "strval1"
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = "strval1"
    store.delete("foo/bar").should == "strval1"
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = "strval1"
    store["foo/bar"].should == "strval1"
    store["foo/bar"] = "strval2"
    store["foo/bar"].should == "strval2"
  end

  it 'stores frozen values' do
    value = "strval1".freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == "strval1"
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = "strval1"
    store["foo/bar"].should == "strval1"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = "strval1"
    store.fetch("foo/bar", "strval2").should == "strval1"
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = "strval1"
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["bar/foo/baz"] = "strval2"
    store["bar/foo/baz"].should == "strval2"
    store.load("bar/foo/baz").should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store["bar/foo/baz"] = "strval2"
    store.key?("bar/foo/baz").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("bar/foo/baz", value).should equal(value)
    store["bar/foo/baz"].should == "strval2"
    store.load("bar/foo/baz").should == "strval2"
  end

  it 'stores values after clear' do
    store["bar/foo/baz"] = "strval2"
    store["foo/bar"] = "strval1"
    store.clear.should equal(store)
    store["bar/foo/baz"] = "strval2"
    store["bar/foo/baz"].should == "strval2"
    store["foo/bar"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["bar/foo/baz"] = "strval2"
    store.delete("bar/foo/baz").should == "strval2"
    store.key?("bar/foo/baz").should be_false
  end

  it 'overwrites existing values' do
    store["bar/foo/baz"] = "strval2"
    store["bar/foo/baz"].should == "strval2"
    store["bar/foo/baz"] = "strval1"
    store["bar/foo/baz"].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store["bar/foo/baz"] = value).should equal(value)
    store["bar/foo/baz"].should == "strval2"
  end

  it 'stores frozen keys' do
    key = "bar/foo/baz".freeze
    store[key] = "strval2"
    store["bar/foo/baz"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["bar/foo/baz"] = "strval2"
    store.fetch("bar/foo/baz", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["bar/foo/baz"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("bar/foo/baz") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end

  it 'writes values to keys that like a Hash' do
    store["foo/bar"] = "strval2"
    store["foo/bar"].should == "strval2"
    store.load("foo/bar").should == "strval2"
  end

  it 'returns true from #key? if a key is available' do
    store["foo/bar"] = "strval2"
    store.key?("foo/bar").should be_true
  end

  it 'stores values with #store' do
    value = "strval2"
    store.store("foo/bar", value).should equal(value)
    store["foo/bar"].should == "strval2"
    store.load("foo/bar").should == "strval2"
  end

  it 'stores values after clear' do
    store["foo/bar"] = "strval2"
    store["bar/foo/baz"] = "strval1"
    store.clear.should equal(store)
    store["foo/bar"] = "strval2"
    store["foo/bar"].should == "strval2"
    store["bar/foo/baz"].should be_nil
  end

  it 'removes and returns a value from the backing store via delete if it exists' do
    store["foo/bar"] = "strval2"
    store.delete("foo/bar").should == "strval2"
    store.key?("foo/bar").should be_false
  end

  it 'overwrites existing values' do
    store["foo/bar"] = "strval2"
    store["foo/bar"].should == "strval2"
    store["foo/bar"] = "strval1"
    store["foo/bar"].should == "strval1"
  end

  it 'stores frozen values' do
    value = "strval2".freeze
    (store["foo/bar"] = value).should equal(value)
    store["foo/bar"].should == "strval2"
  end

  it 'stores frozen keys' do
    key = "foo/bar".freeze
    store[key] = "strval2"
    store["foo/bar"].should == "strval2"
  end
  it 'fetches a key with a default value with fetch, if the key is available' do
    store["foo/bar"] = "strval2"
    store.fetch("foo/bar", "strval1").should == "strval2"
  end

  it 'does not run the block in fetch if the key is available' do
    store["foo/bar"] = "strval2"
    unaltered = 'unaltered'
    store.fetch("foo/bar") { unaltered = 'altered' }
    unaltered.should == 'unaltered'
  end
end

#################### returndifferent_pathkey_stringvalue ####################

shared_examples_for 'returndifferent_pathkey_stringvalue' do
  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["bar/foo/baz"] = value
    store["bar/foo/baz"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval1"
    store["foo/bar"] = value
    store["foo/bar"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["bar/foo/baz"] = value
    store["bar/foo/baz"].should_not be_equal(value)
  end

  it 'guarantees that a different value is retrieved' do
    value = "strval2"
    store["foo/bar"] = value
    store["foo/bar"].should_not be_equal(value)
  end
end

#################### returnsame_pathkey_stringvalue ####################

shared_examples_for 'returnsame_pathkey_stringvalue' do
  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["bar/foo/baz"] = value
    store["bar/foo/baz"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval1"
    store["foo/bar"] = value
    store["foo/bar"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["bar/foo/baz"] = value
    store["bar/foo/baz"].should be_equal(value)
  end

  it 'guarantees that the same value is retrieved' do
    value = "strval2"
    store["foo/bar"] = value
    store["foo/bar"].should be_equal(value)
  end
end

#################### persist_pathkey_stringvalue ####################

shared_examples_for 'persist_pathkey_stringvalue' do
  it 'persists values' do
    store["bar/foo/baz"] = "strval1"
    store.close
    @store = nil
    store["bar/foo/baz"].should == "strval1"
  end

  it 'persists values' do
    store["foo/bar"] = "strval1"
    store.close
    @store = nil
    store["foo/bar"].should == "strval1"
  end

  it 'persists values' do
    store["bar/foo/baz"] = "strval2"
    store.close
    @store = nil
    store["bar/foo/baz"].should == "strval2"
  end

  it 'persists values' do
    store["foo/bar"] = "strval2"
    store.close
    @store = nil
    store["foo/bar"].should == "strval2"
  end
end

#################### null_pathkey_binaryvalue ####################

shared_examples_for 'null_pathkey_binaryvalue' do
  it 'reads from keys like a Hash' do
    store["bar/foo/baz"].should be_nil
    store.load("bar/foo/baz").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store["bar/foo/baz"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("bar/foo/baz").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("bar/foo/baz").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["bar/foo/baz"] = "über"
    store["foo/bar"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?("bar/foo/baz").should be_false
    store.key?("foo/bar").should be_false
  end

  it 'fetches a key with a default value with fetch, if the key is not available' do
    store.fetch("bar/foo/baz", "über").should == "über"
  end

  it 'fetches a key with a block with fetch, if the key is not available' do
    key = "bar/foo/baz"
    value = "über"
    store.fetch(key) do |k|
      k.should equal(key)
      value
    end.should equal(value)
  end

  it 'accepts frozen options' do
    options = {:option1 => 1, :options2 => 2}
    options.freeze
    store.key?("bar/foo/baz", options).should be_false
    store.load("bar/foo/baz", options).should be_nil
    store.fetch("bar/foo/baz", 42, options).should == 42
    store.fetch("bar/foo/baz", options) { 42 }.should == 42
    store.delete("bar/foo/baz", options).should be_nil
    store.clear(options).should equal(store)
    store.store("bar/foo/baz", "über", options).should == "über"
  end

  it 'reads from keys like a Hash' do
    store["foo/bar"].should be_nil
    store.load("foo/bar").should be_nil
  end

  it 'guarantees that the same value is returned when setting a key' do
    value = "über"
    (store["foo/bar"] = value).should equal(value)
  end

  it 'returns false from #key? if a key is not available' do
    store.key?("foo/bar").should be_false
  end

  it 'returns nil from delete if a value for a key does not exist' do
    store.delete("foo/bar").should be_nil
  end

  it 'removes all keys from the store with clear' do
    store["foo/bar"] = "über"
    store["bar/foo/baz"] = "\xAA\xBB\xCC"
    store.clear.should equal(store)
    store.key?("foo/bar").should be_false
    store.key?("bar/foo/baz").shoul