#! /bin/sh
#------------------------------------------------------------------------------
#$Author: andrius $
#$Date: 2017-12-06 14:35:22 +0200 (Wed, 06 Dec 2017) $
#$Revision: 119 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/smiles-scripts/tags/v0.4.0/tests/cases/cdkrecharge_016.sh $
#------------------------------------------------------------------------------
#*
#   Run a test to see how the 'cdkrecharge' script works in its installation
#   directory
#**

TMP_DIR="${TMPDIR}"

BASENAME=$(basename $0 .sh)

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

## set -x

mkdir ${TMP_DIR}/bin
mkdir ${TMP_DIR}/share
mkdir ${TMP_DIR}/share/java

cp bin/cdkrecharge ${TMP_DIR}/bin
cp jars/*.jar      ${TMP_DIR}/share/java

cd ${TMP_DIR}
export CLASSPATH=

./bin/cdkrecharge --smiles 'c1ccccc1'
