#pragma once

namespace sql {

	namespace features {

		/**
		 * Description of the features provided by a database.
		 *
		 * This is a set of bitflags that the database may provide.
		 */
		enum DBFeatures {
			// No features.
			none = 0x00,

			// Don't need an explicit autoincrement for numeric primary keys (e.g. for SQLite).
			implicitAutoIncrement = 0x01,

			// Limited support for table modifications.
			limitedUpdate = 0x02,

			// Support for RETURNING in INSERT queries.
			insertReturning = 0x04,

			// Support for RETURNING in UPDATE queries.
			updateReturning = 0x08,

			// Support for RETURNING in DELETE queries.
			deleteReturning = 0x10,
		};

		BITMASK_OPERATORS(DBFeatures);

	}
}
